// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ActivateTypeInput`](crate::input::ActivateTypeInput)
pub mod activate_type_input {
    /// A builder for [`ActivateTypeInput`](crate::input::ActivateTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
        pub(crate) public_type_arn: std::option::Option<std::string::String>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) type_name_alias: std::option::Option<std::string::String>,
        pub(crate) auto_update: std::option::Option<bool>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) version_bump: std::option::Option<crate::model::VersionBump>,
        pub(crate) major_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the public extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn public_type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the public extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_public_type_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_type_arn = input;
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>An alias to assign to the public extension, in this account and region. If you specify
        /// an alias for the extension, CloudFormation treats the alias as the extension type name
        /// within this account and region. You must use the alias to refer to the extension in your
        /// templates, API calls, and CloudFormation console.</p>
        /// <p>An extension alias must be unique within a given account and region. You can activate
        /// the same public resource multiple times in the same account and region, using different
        /// type name aliases.</p>
        pub fn type_name_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name_alias = Some(input.into());
            self
        }
        /// <p>An alias to assign to the public extension, in this account and region. If you specify
        /// an alias for the extension, CloudFormation treats the alias as the extension type name
        /// within this account and region. You must use the alias to refer to the extension in your
        /// templates, API calls, and CloudFormation console.</p>
        /// <p>An extension alias must be unique within a given account and region. You can activate
        /// the same public resource multiple times in the same account and region, using different
        /// type name aliases.</p>
        pub fn set_type_name_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_name_alias = input;
            self
        }
        /// <p>Whether to automatically update the extension in this account and region when a new
        /// <i>minor</i> version is published by the extension publisher. Major
        /// versions released by the publisher must be manually updated.</p>
        /// <p>The default is <code>true</code>.</p>
        pub fn auto_update(mut self, input: bool) -> Self {
            self.auto_update = Some(input);
            self
        }
        /// <p>Whether to automatically update the extension in this account and region when a new
        /// <i>minor</i> version is published by the extension publisher. Major
        /// versions released by the publisher must be manually updated.</p>
        /// <p>The default is <code>true</code>.</p>
        pub fn set_auto_update(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_update = input;
            self
        }
        /// <p>Contains logging configuration information for an extension.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>Contains logging configuration information for an extension.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The name of the IAM execution role to use to activate the extension.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The name of the IAM execution role to use to activate the extension.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>Manually updates a previously-activated type to a new major or minor version, if
        /// available. You can also use this parameter to update the value of
        /// <code>AutoUpdate</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MAJOR</code>: CloudFormation updates the extension to the newest major
        /// version, if one is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MINOR</code>: CloudFormation updates the extension to the newest minor
        /// version, if one is available.</p>
        /// </li>
        /// </ul>
        pub fn version_bump(mut self, input: crate::model::VersionBump) -> Self {
            self.version_bump = Some(input);
            self
        }
        /// <p>Manually updates a previously-activated type to a new major or minor version, if
        /// available. You can also use this parameter to update the value of
        /// <code>AutoUpdate</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MAJOR</code>: CloudFormation updates the extension to the newest major
        /// version, if one is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MINOR</code>: CloudFormation updates the extension to the newest minor
        /// version, if one is available.</p>
        /// </li>
        /// </ul>
        pub fn set_version_bump(
            mut self,
            input: std::option::Option<crate::model::VersionBump>,
        ) -> Self {
            self.version_bump = input;
            self
        }
        /// <p>The major version of this extension you want to activate, if multiple major versions are
        /// available. The default is the latest major version. CloudFormation uses the latest
        /// available <i>minor</i> version of the major version selected.</p>
        /// <p>You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not
        /// both.</p>
        pub fn major_version(mut self, input: i64) -> Self {
            self.major_version = Some(input);
            self
        }
        /// <p>The major version of this extension you want to activate, if multiple major versions are
        /// available. The default is the latest major version. CloudFormation uses the latest
        /// available <i>minor</i> version of the major version selected.</p>
        /// <p>You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not
        /// both.</p>
        pub fn set_major_version(mut self, input: std::option::Option<i64>) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateTypeInput`](crate::input::ActivateTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateTypeInput {
                r#type: self.r#type,
                public_type_arn: self.public_type_arn,
                publisher_id: self.publisher_id,
                type_name: self.type_name,
                type_name_alias: self.type_name_alias,
                auto_update: self.auto_update,
                logging_config: self.logging_config,
                execution_role_arn: self.execution_role_arn,
                version_bump: self.version_bump,
                major_version: self.major_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateTypeInputOperationOutputAlias = crate::operation::ActivateType;
#[doc(hidden)]
pub type ActivateTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ActivateTypeInput {
    /// Consumes the builder and constructs an Operation<[`ActivateType`](crate::operation::ActivateType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_activate_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateTypeInput`](crate::input::ActivateTypeInput)
    pub fn builder() -> crate::input::activate_type_input::Builder {
        crate::input::activate_type_input::Builder::default()
    }
}

/// See [`BatchDescribeTypeConfigurationsInput`](crate::input::BatchDescribeTypeConfigurationsInput)
pub mod batch_describe_type_configurations_input {
    /// A builder for [`BatchDescribeTypeConfigurationsInput`](crate::input::BatchDescribeTypeConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_configuration_identifiers:
            std::option::Option<std::vec::Vec<crate::model::TypeConfigurationIdentifier>>,
    }
    impl Builder {
        /// Appends an item to `type_configuration_identifiers`.
        ///
        /// To override the contents of this collection use [`set_type_configuration_identifiers`](Self::set_type_configuration_identifiers).
        ///
        /// <p>The list of identifiers for the desired extension configurations.</p>
        pub fn type_configuration_identifiers(
            mut self,
            input: impl Into<crate::model::TypeConfigurationIdentifier>,
        ) -> Self {
            let mut v = self.type_configuration_identifiers.unwrap_or_default();
            v.push(input.into());
            self.type_configuration_identifiers = Some(v);
            self
        }
        /// <p>The list of identifiers for the desired extension configurations.</p>
        pub fn set_type_configuration_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypeConfigurationIdentifier>>,
        ) -> Self {
            self.type_configuration_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeTypeConfigurationsInput`](crate::input::BatchDescribeTypeConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDescribeTypeConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDescribeTypeConfigurationsInput {
                type_configuration_identifiers: self.type_configuration_identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDescribeTypeConfigurationsInputOperationOutputAlias =
    crate::operation::BatchDescribeTypeConfigurations;
#[doc(hidden)]
pub type BatchDescribeTypeConfigurationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDescribeTypeConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDescribeTypeConfigurations`](crate::operation::BatchDescribeTypeConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDescribeTypeConfigurations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDescribeTypeConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDescribeTypeConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDescribeTypeConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_describe_type_configurations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDescribeTypeConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDescribeTypeConfigurations",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDescribeTypeConfigurationsInput`](crate::input::BatchDescribeTypeConfigurationsInput)
    pub fn builder() -> crate::input::batch_describe_type_configurations_input::Builder {
        crate::input::batch_describe_type_configurations_input::Builder::default()
    }
}

/// See [`CancelUpdateStackInput`](crate::input::CancelUpdateStackInput)
pub mod cancel_update_stack_input {
    /// A builder for [`CancelUpdateStackInput`](crate::input::CancelUpdateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to cancel an update on a stack with the same name. You might retry
        /// <code>CancelUpdateStack</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to cancel an update on a stack with the same name. You might retry
        /// <code>CancelUpdateStack</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelUpdateStackInput`](crate::input::CancelUpdateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelUpdateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelUpdateStackInput {
                stack_name: self.stack_name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelUpdateStackInputOperationOutputAlias = crate::operation::CancelUpdateStack;
#[doc(hidden)]
pub type CancelUpdateStackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelUpdateStackInput {
    /// Consumes the builder and constructs an Operation<[`CancelUpdateStack`](crate::operation::CancelUpdateStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelUpdateStack,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelUpdateStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelUpdateStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelUpdateStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_update_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelUpdateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelUpdateStack",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelUpdateStackInput`](crate::input::CancelUpdateStackInput)
    pub fn builder() -> crate::input::cancel_update_stack_input::Builder {
        crate::input::cancel_update_stack_input::Builder::default()
    }
}

/// See [`ContinueUpdateRollbackInput`](crate::input::ContinueUpdateRollbackInput)
pub mod continue_update_rollback_input {
    /// A builder for [`ContinueUpdateRollbackInput`](crate::input::ContinueUpdateRollbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) resources_to_skip: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique ID of the stack that you want to continue rolling
        /// back.</p>
        /// <note>
        /// <p>Don't specify the name of a nested stack (a stack that was created by using the
        /// <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the
        /// parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code>
        /// resource).</p>
        /// </note>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique ID of the stack that you want to continue rolling
        /// back.</p>
        /// <note>
        /// <p>Don't specify the name of a nested stack (a stack that was created by using the
        /// <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the
        /// parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code>
        /// resource).</p>
        /// </note>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to roll back the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to roll back the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `resources_to_skip`.
        ///
        /// To override the contents of this collection use [`set_resources_to_skip`](Self::set_resources_to_skip).
        ///
        /// <p>A list of the logical IDs of the resources that CloudFormation skips during the
        /// continue update rollback operation. You can specify only resources that are in the
        /// <code>UPDATE_FAILED</code> state because a rollback failed. You can't specify resources
        /// that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an
        /// update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
        /// <important>
        /// <p>Specify this property to skip rolling back resources that CloudFormation
        /// can't successfully roll back. We recommend that you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. CloudFormation sets
        /// the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to
        /// roll back the stack. After the rollback is complete, the state of the skipped resources
        /// will be inconsistent with the state of the resources in the stack template. Before
        /// performing another stack update, you must update the stack or resources to be consistent
        /// with each other. If you don't, subsequent stack updates might fail, and the stack will
        /// become unrecoverable.</p>
        /// </important>
        /// <p>Specify the minimum number of resources required to successfully roll back your stack.
        /// For example, a failed resource update might cause dependent resources to fail. In this
        /// case, it might not be necessary to skip the dependent resources.</p>
        /// <p>To skip resources that are part of nested stacks, use the following format:
        /// <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of
        /// a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the
        /// <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one
        /// of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or
        /// <code>DELETE_FAILED</code>.</p>
        /// <note>
        /// <p>Don't confuse a child stack's name with its corresponding logical ID defined in the
        /// parent stack. For an example of a continue update rollback operation with nested stacks,
        /// see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>.</p>
        /// </note>
        pub fn resources_to_skip(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources_to_skip.unwrap_or_default();
            v.push(input.into());
            self.resources_to_skip = Some(v);
            self
        }
        /// <p>A list of the logical IDs of the resources that CloudFormation skips during the
        /// continue update rollback operation. You can specify only resources that are in the
        /// <code>UPDATE_FAILED</code> state because a rollback failed. You can't specify resources
        /// that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an
        /// update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
        /// <important>
        /// <p>Specify this property to skip rolling back resources that CloudFormation
        /// can't successfully roll back. We recommend that you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. CloudFormation sets
        /// the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to
        /// roll back the stack. After the rollback is complete, the state of the skipped resources
        /// will be inconsistent with the state of the resources in the stack template. Before
        /// performing another stack update, you must update the stack or resources to be consistent
        /// with each other. If you don't, subsequent stack updates might fail, and the stack will
        /// become unrecoverable.</p>
        /// </important>
        /// <p>Specify the minimum number of resources required to successfully roll back your stack.
        /// For example, a failed resource update might cause dependent resources to fail. In this
        /// case, it might not be necessary to skip the dependent resources.</p>
        /// <p>To skip resources that are part of nested stacks, use the following format:
        /// <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of
        /// a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the
        /// <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one
        /// of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or
        /// <code>DELETE_FAILED</code>.</p>
        /// <note>
        /// <p>Don't confuse a child stack's name with its corresponding logical ID defined in the
        /// parent stack. For an example of a continue update rollback operation with nested stacks,
        /// see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>.</p>
        /// </note>
        pub fn set_resources_to_skip(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources_to_skip = input;
            self
        }
        /// <p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify
        /// this token if you plan to retry requests so that CloudFormationknows that you're not
        /// attempting to continue the rollback to a stack with the same name. You might retry
        /// <code>ContinueUpdateRollback</code> requests to ensure that CloudFormation
        /// successfully received them.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify
        /// this token if you plan to retry requests so that CloudFormationknows that you're not
        /// attempting to continue the rollback to a stack with the same name. You might retry
        /// <code>ContinueUpdateRollback</code> requests to ensure that CloudFormation
        /// successfully received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinueUpdateRollbackInput`](crate::input::ContinueUpdateRollbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ContinueUpdateRollbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ContinueUpdateRollbackInput {
                stack_name: self.stack_name,
                role_arn: self.role_arn,
                resources_to_skip: self.resources_to_skip,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ContinueUpdateRollbackInputOperationOutputAlias = crate::operation::ContinueUpdateRollback;
#[doc(hidden)]
pub type ContinueUpdateRollbackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ContinueUpdateRollbackInput {
    /// Consumes the builder and constructs an Operation<[`ContinueUpdateRollback`](crate::operation::ContinueUpdateRollback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ContinueUpdateRollback,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ContinueUpdateRollbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ContinueUpdateRollbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ContinueUpdateRollbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_continue_update_rollback(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ContinueUpdateRollback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ContinueUpdateRollback",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ContinueUpdateRollbackInput`](crate::input::ContinueUpdateRollbackInput)
    pub fn builder() -> crate::input::continue_update_rollback_input::Builder {
        crate::input::continue_update_rollback_input::Builder::default()
    }
}

/// See [`CreateChangeSetInput`](crate::input::CreateChangeSetInput)
pub mod create_change_set_input {
    /// A builder for [`CreateChangeSetInput`](crate::input::CreateChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) use_previous_template: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
        pub(crate) notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) change_set_type: std::option::Option<crate::model::ChangeSetType>,
        pub(crate) resources_to_import:
            std::option::Option<std::vec::Vec<crate::model::ResourceToImport>>,
        pub(crate) include_nested_stacks: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name or the unique ID of the stack for which you are creating a change set.
        /// CloudFormation generates the change set by comparing this stack's information with the
        /// information that you submit, such as a modified template or different parameter input
        /// values.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique ID of the stack for which you are creating a change set.
        /// CloudFormation generates the change set by comparing this stack's information with the
        /// information that you submit, such as a modified template or different parameter input
        /// values.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A structure that contains the body of the revised template, with a minimum length of
        /// 1 byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
        /// comparing this template with the template of the stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>A structure that contains the body of the revised template, with a minimum length of
        /// 1 byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
        /// comparing this template with the template of the stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The location of the file that contains the revised template. The URL must point to a
        /// template (max size: 460,800 bytes) that is located in an S3 bucket or a Systems Manager
        /// document. CloudFormation generates the change set by comparing this template with the
        /// stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>The location of the file that contains the revised template. The URL must point to a
        /// template (max size: 460,800 bytes) that is located in an S3 bucket or a Systems Manager
        /// document. CloudFormation generates the change set by comparing this template with the
        /// stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// <p>Whether to reuse the template that is associated with the stack to create the change
        /// set.</p>
        pub fn use_previous_template(mut self, input: bool) -> Self {
            self.use_previous_template = Some(input);
            self
        }
        /// <p>Whether to reuse the template that is associated with the stack to create the change
        /// set.</p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.use_previous_template = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// change set. For more information, see the <a>Parameter</a> data type.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// change set. For more information, see the <a>Parameter</a> data type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either
        /// capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you
        /// <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <note>
        /// <p>This capacity does not apply to creating change sets, and specifying it when
        /// creating change sets has no effect.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create or update the stack
        /// directly from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.</p>
        /// </note>
        /// <p>For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either
        /// capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you
        /// <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <note>
        /// <p>This capacity does not apply to creating change sets, and specifying it when
        /// creating change sets has no effect.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create or update the stack
        /// directly from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.</p>
        /// </note>
        /// <p>For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with if you execute
        /// this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource type that you're updating,
        /// the stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for condition keys in
        /// IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with
        /// Identity and Access Management</a> in the CloudFormation User
        /// Guide.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The template resource types that you have permissions to work with if you execute
        /// this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource type that you're updating,
        /// the stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for condition keys in
        /// IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with
        /// Identity and Access Management</a> in the CloudFormation User
        /// Guide.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes when executing the change set. CloudFormation uses the
        /// role's credentials to make calls on your behalf. CloudFormation uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes when executing the change set. CloudFormation uses the
        /// role's credentials to make calls on your behalf. CloudFormation uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(
            mut self,
            input: crate::model::RollbackConfiguration,
        ) -> Self {
            self.rollback_configuration = Some(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.rollback_configuration = input;
            self
        }
        /// Appends an item to `notification_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS)
        /// topics that CloudFormation associates with the stack. To remove all associated
        /// notification topics, specify an empty list.</p>
        pub fn notification_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.notification_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS)
        /// topics that CloudFormation associates with the stack. To remove all associated
        /// notification topics, specify an empty list.</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_ar_ns = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to resources in the stack. You can specify a maximum of 50 tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to resources in the stack. You can specify a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the change set. The name must be unique among all change sets that are
        /// associated with the specified stack.</p>
        /// <p>A change set name can contain only alphanumeric, case sensitive characters and
        /// hyphens. It must start with an alphabetic character and cannot exceed 128
        /// characters.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name of the change set. The name must be unique among all change sets that are
        /// associated with the specified stack.</p>
        /// <p>A change set name can contain only alphanumeric, case sensitive characters and
        /// hyphens. It must start with an alphabetic character and cannot exceed 128
        /// characters.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another change set with the same name. You might retry
        /// <code>CreateChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another change set with the same name. You might retry
        /// <code>CreateChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A description to help you identify this change set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description to help you identify this change set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of change set operation. To create a change set for a new stack, specify
        /// <code>CREATE</code>. To create a change set for an existing stack, specify
        /// <code>UPDATE</code>. To create a change set for an import operation, specify
        /// <code>IMPORT</code>.</p>
        /// <p>If you create a change set for a new stack, CloudFormation creates a stack with a
        /// unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
        /// <code>REVIEW_IN_PROGRESS</code>
        /// </a> state until you execute the change
        /// set.</p>
        /// <p>By default, CloudFormation specifies <code>UPDATE</code>. You can't use the
        /// <code>UPDATE</code> type to create a change set for a new stack or the
        /// <code>CREATE</code> type to create a change set for an existing stack.</p>
        pub fn change_set_type(mut self, input: crate::model::ChangeSetType) -> Self {
            self.change_set_type = Some(input);
            self
        }
        /// <p>The type of change set operation. To create a change set for a new stack, specify
        /// <code>CREATE</code>. To create a change set for an existing stack, specify
        /// <code>UPDATE</code>. To create a change set for an import operation, specify
        /// <code>IMPORT</code>.</p>
        /// <p>If you create a change set for a new stack, CloudFormation creates a stack with a
        /// unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
        /// <code>REVIEW_IN_PROGRESS</code>
        /// </a> state until you execute the change
        /// set.</p>
        /// <p>By default, CloudFormation specifies <code>UPDATE</code>. You can't use the
        /// <code>UPDATE</code> type to create a change set for a new stack or the
        /// <code>CREATE</code> type to create a change set for an existing stack.</p>
        pub fn set_change_set_type(
            mut self,
            input: std::option::Option<crate::model::ChangeSetType>,
        ) -> Self {
            self.change_set_type = input;
            self
        }
        /// Appends an item to `resources_to_import`.
        ///
        /// To override the contents of this collection use [`set_resources_to_import`](Self::set_resources_to_import).
        ///
        /// <p>The resources to import into your stack.</p>
        pub fn resources_to_import(
            mut self,
            input: impl Into<crate::model::ResourceToImport>,
        ) -> Self {
            let mut v = self.resources_to_import.unwrap_or_default();
            v.push(input.into());
            self.resources_to_import = Some(v);
            self
        }
        /// <p>The resources to import into your stack.</p>
        pub fn set_resources_to_import(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceToImport>>,
        ) -> Self {
            self.resources_to_import = input;
            self
        }
        /// <p>Creates a change set for the all nested stacks specified in the template. The default
        /// behavior of this action is set to <code>False</code>. To include nested sets in a change
        /// set, specify <code>True</code>.</p>
        pub fn include_nested_stacks(mut self, input: bool) -> Self {
            self.include_nested_stacks = Some(input);
            self
        }
        /// <p>Creates a change set for the all nested stacks specified in the template. The default
        /// behavior of this action is set to <code>False</code>. To include nested sets in a change
        /// set, specify <code>True</code>.</p>
        pub fn set_include_nested_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.include_nested_stacks = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChangeSetInput`](crate::input::CreateChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChangeSetInput {
                stack_name: self.stack_name,
                template_body: self.template_body,
                template_url: self.template_url,
                use_previous_template: self.use_previous_template,
                parameters: self.parameters,
                capabilities: self.capabilities,
                resource_types: self.resource_types,
                role_arn: self.role_arn,
                rollback_configuration: self.rollback_configuration,
                notification_ar_ns: self.notification_ar_ns,
                tags: self.tags,
                change_set_name: self.change_set_name,
                client_token: self.client_token,
                description: self.description,
                change_set_type: self.change_set_type,
                resources_to_import: self.resources_to_import,
                include_nested_stacks: self.include_nested_stacks,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChangeSetInputOperationOutputAlias = crate::operation::CreateChangeSet;
#[doc(hidden)]
pub type CreateChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateChangeSet`](crate::operation::CreateChangeSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChangeSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChangeSetInput`](crate::input::CreateChangeSetInput)
    pub fn builder() -> crate::input::create_change_set_input::Builder {
        crate::input::create_change_set_input::Builder::default()
    }
}

/// See [`CreateStackInput`](crate::input::CreateStackInput)
pub mod create_stack_input {
    /// A builder for [`CreateStackInput`](crate::input::CreateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) disable_rollback: std::option::Option<bool>,
        pub(crate) rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
        pub(crate) notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) on_failure: std::option::Option<crate::model::OnFailure>,
        pub(crate) stack_policy_body: std::option::Option<std::string::String>,
        pub(crate) stack_policy_url: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) enable_termination_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name that is associated with the stack. The name must be unique in the Region in
        /// which you are creating the stack.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens.
        /// It must start with an alphabetical character and cannot be longer than 128
        /// characters.</p>
        /// </note>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name that is associated with the stack. The name must be unique in the Region in
        /// which you are creating the stack.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens.
        /// It must start with an alphabetical character and cannot be longer than 128
        /// characters.</p>
        /// </note>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>Set to <code>true</code> to disable rollback of the stack if stack creation failed.
        /// You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not
        /// both.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn disable_rollback(mut self, input: bool) -> Self {
            self.disable_rollback = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to disable rollback of the stack if stack creation failed.
        /// You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not
        /// both.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_rollback = input;
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(
            mut self,
            input: crate::model::RollbackConfiguration,
        ) -> Self {
            self.rollback_configuration = Some(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.rollback_configuration = input;
            self
        }
        /// <p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if
        /// <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will
        /// be rolled back.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if
        /// <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will
        /// be rolled back.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// Appends an item to `notification_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You
        /// can find your SNS topic ARNs using the SNS console or your Command Line Interface
        /// (CLI).</p>
        pub fn notification_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.notification_ar_ns = Some(v);
            self
        }
        /// <p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You
        /// can find your SNS topic ARNs using the SNS console or your Command Line Interface
        /// (CLI).</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_ar_ns = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only create stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only create stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with for this create
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template
        /// resource types: <code>AWS::*</code> (for all Amazon Web Services resources),
        /// <code>Custom::*</code> (for all custom resources),
        /// <code>Custom::<i>logical_ID</i>
        /// </code> (for a specific custom resource),
        /// <code>AWS::<i>service_name</i>::*</code> (for all resources of a
        /// particular Amazon Web Services service), and
        /// <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i>
        /// </code> (for a specific Amazon Web Services resource).</p>
        /// <p>If the list of resource types doesn't include a resource that you're creating, the
        /// stack creation fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The template resource types that you have permissions to work with for this create
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template
        /// resource types: <code>AWS::*</code> (for all Amazon Web Services resources),
        /// <code>Custom::*</code> (for all custom resources),
        /// <code>Custom::<i>logical_ID</i>
        /// </code> (for a specific custom resource),
        /// <code>AWS::<i>service_name</i>::*</code> (for all resources of a
        /// particular Amazon Web Services service), and
        /// <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i>
        /// </code> (for a specific Amazon Web Services resource).</p>
        /// <p>If the list of resource types doesn't include a resource that you're creating, the
        /// stack creation fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to create the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to create the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Determines what action will be taken if stack creation fails. This must be one of:
        /// DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or
        /// <code>DisableRollback</code>, but not both.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn on_failure(mut self, input: crate::model::OnFailure) -> Self {
            self.on_failure = Some(input);
            self
        }
        /// <p>Determines what action will be taken if stack creation fails. This must be one of:
        /// DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or
        /// <code>DisableRollback</code>, but not both.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn set_on_failure(
            mut self,
            input: std::option::Option<crate::model::OnFailure>,
        ) -> Self {
            self.on_failure = input;
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the <i>CloudFormation User Guide</i>.
        /// You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code>
        /// parameter, but not both.</p>
        pub fn stack_policy_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_body = Some(input.into());
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the <i>CloudFormation User Guide</i>.
        /// You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code>
        /// parameter, but not both.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_body = input;
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn stack_policy_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_url = Some(input.into());
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_url = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to the resources created in the stack. A maximum number of 50 tags can be
        /// specified.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to the resources created in the stack. A maximum number of 50 tags can be
        /// specified.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique identifier for this <code>CreateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// create a stack with the same name. You might retry <code>CreateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>CreateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// create a stack with the same name. You might retry <code>CreateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Whether to enable termination protection on the specified stack. If a user attempts to
        /// delete a stack with termination protection enabled, the operation fails and the stack
        /// remains unchanged. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being
        /// Deleted</a> in the <i>CloudFormation User Guide</i>. Termination protection is
        /// disabled on stacks by default.</p>
        /// <p>For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>,
        /// termination protection is set on the root stack and cannot be changed directly on the
        /// nested stack.</p>
        pub fn enable_termination_protection(mut self, input: bool) -> Self {
            self.enable_termination_protection = Some(input);
            self
        }
        /// <p>Whether to enable termination protection on the specified stack. If a user attempts to
        /// delete a stack with termination protection enabled, the operation fails and the stack
        /// remains unchanged. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being
        /// Deleted</a> in the <i>CloudFormation User Guide</i>. Termination protection is
        /// disabled on stacks by default.</p>
        /// <p>For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>,
        /// termination protection is set on the root stack and cannot be changed directly on the
        /// nested stack.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_termination_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackInput`](crate::input::CreateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStackInput {
                stack_name: self.stack_name,
                template_body: self.template_body,
                template_url: self.template_url,
                parameters: self.parameters,
                disable_rollback: self.disable_rollback,
                rollback_configuration: self.rollback_configuration,
                timeout_in_minutes: self.timeout_in_minutes,
                notification_ar_ns: self.notification_ar_ns,
                capabilities: self.capabilities,
                resource_types: self.resource_types,
                role_arn: self.role_arn,
                on_failure: self.on_failure,
                stack_policy_body: self.stack_policy_body,
                stack_policy_url: self.stack_policy_url,
                tags: self.tags,
                client_request_token: self.client_request_token,
                enable_termination_protection: self.enable_termination_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStackInputOperationOutputAlias = crate::operation::CreateStack;
#[doc(hidden)]
pub type CreateStackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStackInput {
    /// Consumes the builder and constructs an Operation<[`CreateStack`](crate::operation::CreateStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStack,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStack",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
}

/// See [`CreateStackInstancesInput`](crate::input::CreateStackInstancesInput)
pub mod create_stack_instances_input {
    /// A builder for [`CreateStackInstancesInput`](crate::input::CreateStackInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parameter_overrides: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to create stack instances
        /// from.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to create stack instances
        /// from.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts that you want to create stack instances in the
        /// specified Region(s) for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts that you want to create stack instances in the
        /// specified Region(s) for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which to create
        /// stack instances in the specified Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, input: crate::model::DeploymentTargets) -> Self {
            self.deployment_targets = Some(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which to create
        /// stack instances in the specified Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The names of one or more Regions where you want to create stack instances using the
        /// specified Amazon Web Services accounts.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>The names of one or more Regions where you want to create stack instances using the
        /// specified Amazon Web Services accounts.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Appends an item to `parameter_overrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p>A list of stack set parameters whose values you want to override in the selected
        /// stack instances.</p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template.</p>
        pub fn parameter_overrides(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameter_overrides.unwrap_or_default();
            v.push(input.into());
            self.parameter_overrides = Some(v);
            self
        }
        /// <p>A list of stack set parameters whose values you want to override in the selected
        /// stack instances.</p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameter_overrides = input;
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackInstancesInput`](crate::input::CreateStackInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStackInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStackInstancesInput {
                stack_set_name: self.stack_set_name,
                accounts: self.accounts,
                deployment_targets: self.deployment_targets,
                regions: self.regions,
                parameter_overrides: self.parameter_overrides,
                operation_preferences: self.operation_preferences,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStackInstancesInputOperationOutputAlias = crate::operation::CreateStackInstances;
#[doc(hidden)]
pub type CreateStackInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStackInstancesInput {
    /// Consumes the builder and constructs an Operation<[`CreateStackInstances`](crate::operation::CreateStackInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStackInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStackInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStackInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStackInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_stack_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStackInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStackInstances",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStackInstancesInput`](crate::input::CreateStackInstancesInput)
    pub fn builder() -> crate::input::create_stack_instances_input::Builder {
        crate::input::create_stack_instances_input::Builder::default()
    }
}

/// See [`CreateStackSetInput`](crate::input::CreateStackSetInput)
pub mod create_stack_set_input {
    /// A builder for [`CreateStackSetInput`](crate::input::CreateStackSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) administration_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_name: std::option::Option<std::string::String>,
        pub(crate) permission_model: std::option::Option<crate::model::PermissionModels>,
        pub(crate) auto_deployment: std::option::Option<crate::model::AutoDeployment>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to associate with the stack set. The name must be unique in the Region where
        /// you create your stack set.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case-sensitive) and
        /// hyphens. It must start with an alphabetic character and can't be longer than 128
        /// characters.</p>
        /// </note>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name to associate with the stack set. The name must be unique in the Region where
        /// you create your stack set.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case-sensitive) and
        /// hyphens. It must start with an alphabetic character and can't be longer than 128
        /// characters.</p>
        /// </note>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>A description of the stack set. You can use the description to identify the stack
        /// set's purpose or other important information.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stack set. You can use the description to identify the stack
        /// set's purpose or other important information.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// <p>The stack ID you are importing into a new stack set. Specify the Amazon Resource Number
        /// (ARN) of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID you are importing into a new stack set. Specify the Amazon Resource Number
        /// (ARN) of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The input parameters for the stack set template.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>The input parameters for the stack set template.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack set template contains
        /// certain capabilities in order for CloudFormation to create the stack set and related stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying
        /// one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must create the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To create the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack set template contains
        /// certain capabilities in order for CloudFormation to create the stack set and related stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying
        /// one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must create the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To create the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. A maximum number of 50 tags can be specified.</p>
        /// <p>If you specify tags as part of a <code>CreateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you don't, the entire <code>CreateStackSet</code> action fails with an <code>access
        /// denied</code> error, and the stack set is not created.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. A maximum number of 50 tags can be specified.</p>
        /// <p>If you specify tags as part of a <code>CreateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you don't, the entire <code>CreateStackSet</code> action fails with an <code>access
        /// denied</code> error, and the stack set is not created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
        /// Granting Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        pub fn administration_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.administration_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
        /// Granting Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administration_role_arn = input;
            self
        }
        /// <p>The name of the IAM execution role to use to create the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets.
        ///
        /// </p>
        pub fn execution_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM execution role to use to create the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets.
        ///
        /// </p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_name = input;
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. By default,
        /// <code>SELF-MANAGED</code> is specified.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn permission_model(mut self, input: crate::model::PermissionModels) -> Self {
            self.permission_model = Some(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. By default,
        /// <code>SELF-MANAGED</code> is specified.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.permission_model = input;
            self
        }
        /// <p>Describes whether StackSets automatically deploys to Organizations accounts that
        /// are added to the target organization or organizational unit (OU). Specify only if
        /// <code>PermissionModel</code> is <code>SERVICE_MANAGED</code>.</p>
        pub fn auto_deployment(mut self, input: crate::model::AutoDeployment) -> Self {
            self.auto_deployment = Some(input);
            self
        }
        /// <p>Describes whether StackSets automatically deploys to Organizations accounts that
        /// are added to the target organization or organizational unit (OU). Specify only if
        /// <code>PermissionModel</code> is <code>SERVICE_MANAGED</code>.</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.auto_deployment = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to the
        /// management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to a
        /// delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated admin in the
        /// management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>Stack sets with service-managed permissions are created in the management account,
        /// including stack sets that are created by delegated administrators.</p>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to the
        /// management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to a
        /// delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated admin in the
        /// management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>Stack sets with service-managed permissions are created in the management account,
        /// including stack sets that are created by delegated administrators.</p>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// <p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another stack set with the same name. You might retry <code>CreateStackSet</code>
        /// requests to ensure that CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another stack set with the same name. You might retry <code>CreateStackSet</code>
        /// requests to ensure that CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackSetInput`](crate::input::CreateStackSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStackSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStackSetInput {
                stack_set_name: self.stack_set_name,
                description: self.description,
                template_body: self.template_body,
                template_url: self.template_url,
                stack_id: self.stack_id,
                parameters: self.parameters,
                capabilities: self.capabilities,
                tags: self.tags,
                administration_role_arn: self.administration_role_arn,
                execution_role_name: self.execution_role_name,
                permission_model: self.permission_model,
                auto_deployment: self.auto_deployment,
                call_as: self.call_as,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStackSetInputOperationOutputAlias = crate::operation::CreateStackSet;
#[doc(hidden)]
pub type CreateStackSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStackSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateStackSet`](crate::operation::CreateStackSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStackSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStackSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStackSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStackSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_stack_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStackSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStackSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStackSetInput`](crate::input::CreateStackSetInput)
    pub fn builder() -> crate::input::create_stack_set_input::Builder {
        crate::input::create_stack_set_input::Builder::default()
    }
}

/// See [`DeactivateTypeInput`](crate::input::DeactivateTypeInput)
pub mod deactivate_type_input {
    /// A builder for [`DeactivateTypeInput`](crate::input::DeactivateTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type name of the extension, in this account and region. If you specified a type name
        /// alias when enabling the extension, use the type name alias.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type name of the extension, in this account and region. If you specified a type name
        /// alias when enabling the extension, use the type name alias.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateTypeInput`](crate::input::DeactivateTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateTypeInput {
                type_name: self.type_name,
                r#type: self.r#type,
                arn: self.arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateTypeInputOperationOutputAlias = crate::operation::DeactivateType;
#[doc(hidden)]
pub type DeactivateTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeactivateTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateType`](crate::operation::DeactivateType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deactivate_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateTypeInput`](crate::input::DeactivateTypeInput)
    pub fn builder() -> crate::input::deactivate_type_input::Builder {
        crate::input::deactivate_type_input::Builder::default()
    }
}

/// See [`DeleteChangeSetInput`](crate::input::DeleteChangeSetInput)
pub mod delete_change_set_input {
    /// A builder for [`DeleteChangeSetInput`](crate::input::DeleteChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// delete.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// delete.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>If you specified the name of a change set to delete, specify the stack name or ID
        /// (ARN) that is associated with it.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>If you specified the name of a change set to delete, specify the stack name or ID
        /// (ARN) that is associated with it.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChangeSetInput`](crate::input::DeleteChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChangeSetInput {
                change_set_name: self.change_set_name,
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChangeSetInputOperationOutputAlias = crate::operation::DeleteChangeSet;
#[doc(hidden)]
pub type DeleteChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChangeSet`](crate::operation::DeleteChangeSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChangeSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChangeSetInput`](crate::input::DeleteChangeSetInput)
    pub fn builder() -> crate::input::delete_change_set_input::Builder {
        crate::input::delete_change_set_input::Builder::default()
    }
}

/// See [`DeleteStackInput`](crate::input::DeleteStackInput)
pub mod delete_stack_input {
    /// A builder for [`DeleteStackInput`](crate::input::DeleteStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) retain_resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Appends an item to `retain_resources`.
        ///
        /// To override the contents of this collection use [`set_retain_resources`](Self::set_retain_resources).
        ///
        /// <p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs
        /// that are associated with the resources you want to retain. During deletion,
        /// CloudFormation deletes the stack but does not delete the retained resources.</p>
        /// <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty
        /// S3 bucket, but you want to delete the stack.</p>
        pub fn retain_resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.retain_resources.unwrap_or_default();
            v.push(input.into());
            self.retain_resources = Some(v);
            self
        }
        /// <p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs
        /// that are associated with the resources you want to retain. During deletion,
        /// CloudFormation deletes the stack but does not delete the retained resources.</p>
        /// <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty
        /// S3 bucket, but you want to delete the stack.</p>
        pub fn set_retain_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.retain_resources = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to delete the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to delete the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// delete a stack with the same name. You might retry <code>DeleteStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// delete a stack with the same name. You might retry <code>DeleteStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStackInput`](crate::input::DeleteStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStackInput {
                stack_name: self.stack_name,
                retain_resources: self.retain_resources,
                role_arn: self.role_arn,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStackInputOperationOutputAlias = crate::operation::DeleteStack;
#[doc(hidden)]
pub type DeleteStackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStackInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStack`](crate::operation::DeleteStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStack,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStack",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
}

/// See [`DeleteStackInstancesInput`](crate::input::DeleteStackInstancesInput)
pub mod delete_stack_instances_input {
    /// A builder for [`DeleteStackInstancesInput`](crate::input::DeleteStackInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) retain_stacks: std::option::Option<bool>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to delete stack instances
        /// for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to delete stack instances
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of the Amazon Web Services accounts that you want to delete stack instances for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>[Self-managed permissions] The names of the Amazon Web Services accounts that you want to delete stack instances for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts from which to delete
        /// stack instances.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, input: crate::model::DeploymentTargets) -> Self {
            self.deployment_targets = Some(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts from which to delete
        /// stack instances.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions where you want to delete stack set instances.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>The Regions where you want to delete stack set instances.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>Removes the stack instances from the specified stack set, but doesn't delete the
        /// stacks. You can't reassociate a retained stack or add an existing, saved stack to a new
        /// stack set.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn retain_stacks(mut self, input: bool) -> Self {
            self.retain_stacks = Some(input);
            self
        }
        /// <p>Removes the stack instances from the specified stack set, but doesn't delete the
        /// stacks. You can't reassociate a retained stack or add an existing, saved stack to a new
        /// stack set.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_retain_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.retain_stacks = input;
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You can retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You can retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStackInstancesInput`](crate::input::DeleteStackInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStackInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStackInstancesInput {
                stack_set_name: self.stack_set_name,
                accounts: self.accounts,
                deployment_targets: self.deployment_targets,
                regions: self.regions,
                operation_preferences: self.operation_preferences,
                retain_stacks: self.retain_stacks.unwrap_or_default(),
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStackInstancesInputOperationOutputAlias = crate::operation::DeleteStackInstances;
#[doc(hidden)]
pub type DeleteStackInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStackInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStackInstances`](crate::operation::DeleteStackInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStackInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStackInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStackInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStackInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_stack_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStackInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStackInstances",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStackInstancesInput`](crate::input::DeleteStackInstancesInput)
    pub fn builder() -> crate::input::delete_stack_instances_input::Builder {
        crate::input::delete_stack_instances_input::Builder::default()
    }
}

/// See [`DeleteStackSetInput`](crate::input::DeleteStackSetInput)
pub mod delete_stack_set_input {
    /// A builder for [`DeleteStackSetInput`](crate::input::DeleteStackSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you're deleting. You can obtain this
        /// value by running <a>ListStackSets</a>.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you're deleting. You can obtain this
        /// value by running <a>ListStackSets</a>.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStackSetInput`](crate::input::DeleteStackSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStackSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStackSetInput {
                stack_set_name: self.stack_set_name,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStackSetInputOperationOutputAlias = crate::operation::DeleteStackSet;
#[doc(hidden)]
pub type DeleteStackSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStackSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStackSet`](crate::operation::DeleteStackSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStackSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStackSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStackSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStackSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_stack_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStackSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStackSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStackSetInput`](crate::input::DeleteStackSetInput)
    pub fn builder() -> crate::input::delete_stack_set_input::Builder {
        crate::input::delete_stack_set_input::Builder::default()
    }
}

/// See [`DeregisterTypeInput`](crate::input::DeregisterTypeInput)
pub mod deregister_type_input {
    /// A builder for [`DeregisterTypeInput`](crate::input::DeregisterTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTypeInput`](crate::input::DeregisterTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTypeInput {
                arn: self.arn,
                r#type: self.r#type,
                type_name: self.type_name,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTypeInputOperationOutputAlias = crate::operation::DeregisterType;
#[doc(hidden)]
pub type DeregisterTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterType`](crate::operation::DeregisterType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTypeInput`](crate::input::DeregisterTypeInput)
    pub fn builder() -> crate::input::deregister_type_input::Builder {
        crate::input::deregister_type_input::Builder::default()
    }
}

/// See [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
pub mod describe_account_limits_input {
    /// A builder for [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that identifies the next page of limits that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of limits that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountLimitsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationOutputAlias = crate::operation::DescribeAccountLimits;
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountLimits`](crate::operation::DescribeAccountLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_limits(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountLimits",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
}

/// See [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
pub mod describe_change_set_input {
    /// A builder for [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// describe.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// describe.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) of the
        /// change set you want to describe.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) of the
        /// change set you want to describe.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A string (provided by the <a>DescribeChangeSet</a> response output) that
        /// identifies the next page of information that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string (provided by the <a>DescribeChangeSet</a> response output) that
        /// identifies the next page of information that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChangeSetInput {
                change_set_name: self.change_set_name,
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChangeSetInputOperationOutputAlias = crate::operation::DescribeChangeSet;
#[doc(hidden)]
pub type DescribeChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChangeSet`](crate::operation::DescribeChangeSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChangeSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    pub fn builder() -> crate::input::describe_change_set_input::Builder {
        crate::input::describe_change_set_input::Builder::default()
    }
}

/// See [`DescribePublisherInput`](crate::input::DescribePublisherInput)
pub mod describe_publisher_input {
    /// A builder for [`DescribePublisherInput`](crate::input::DescribePublisherInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) publisher_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the extension publisher.</p>
        /// <p>If you do not supply a <code>PublisherId</code>, and you have registered as an extension
        /// publisher, <code>DescribePublisher</code> returns information about your own publisher
        /// account.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>If you do not supply a <code>PublisherId</code>, and you have registered as an extension
        /// publisher, <code>DescribePublisher</code> returns information about your own publisher
        /// account.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePublisherInput`](crate::input::DescribePublisherInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePublisherInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePublisherInput {
                publisher_id: self.publisher_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePublisherInputOperationOutputAlias = crate::operation::DescribePublisher;
#[doc(hidden)]
pub type DescribePublisherInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePublisherInput {
    /// Consumes the builder and constructs an Operation<[`DescribePublisher`](crate::operation::DescribePublisher)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePublisher,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePublisherInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePublisherInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePublisherInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_publisher(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePublisher::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePublisher",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePublisherInput`](crate::input::DescribePublisherInput)
    pub fn builder() -> crate::input::describe_publisher_input::Builder {
        crate::input::describe_publisher_input::Builder::default()
    }
}

/// See [`DescribeStackDriftDetectionStatusInput`](crate::input::DescribeStackDriftDetectionStatusInput)
pub mod describe_stack_drift_detection_status_input {
    /// A builder for [`DescribeStackDriftDetectionStatusInput`](crate::input::DescribeStackDriftDetectionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_drift_detection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the drift detection results of this operation.</p>
        /// <p>CloudFormation generates new results, with a new drift detection ID, each time this operation is
        /// run. However, the number of drift results CloudFormation retains for any given stack, and for how
        /// long, may vary.</p>
        pub fn stack_drift_detection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_drift_detection_id = Some(input.into());
            self
        }
        /// <p>The ID of the drift detection results of this operation.</p>
        /// <p>CloudFormation generates new results, with a new drift detection ID, each time this operation is
        /// run. However, the number of drift results CloudFormation retains for any given stack, and for how
        /// long, may vary.</p>
        pub fn set_stack_drift_detection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_drift_detection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackDriftDetectionStatusInput`](crate::input::DescribeStackDriftDetectionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackDriftDetectionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackDriftDetectionStatusInput {
                stack_drift_detection_id: self.stack_drift_detection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackDriftDetectionStatusInputOperationOutputAlias =
    crate::operation::DescribeStackDriftDetectionStatus;
#[doc(hidden)]
pub type DescribeStackDriftDetectionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackDriftDetectionStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackDriftDetectionStatus`](crate::operation::DescribeStackDriftDetectionStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackDriftDetectionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackDriftDetectionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackDriftDetectionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackDriftDetectionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_drift_detection_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackDriftDetectionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackDriftDetectionStatus",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackDriftDetectionStatusInput`](crate::input::DescribeStackDriftDetectionStatusInput)
    pub fn builder() -> crate::input::describe_stack_drift_detection_status_input::Builder {
        crate::input::describe_stack_drift_detection_status_input::Builder::default()
    }
}

/// See [`DescribeStackEventsInput`](crate::input::DescribeStackEventsInput)
pub mod describe_stack_events_input {
    /// A builder for [`DescribeStackEventsInput`](crate::input::DescribeStackEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A string that identifies the next page of events that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of events that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackEventsInput`](crate::input::DescribeStackEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackEventsInput {
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackEventsInputOperationOutputAlias = crate::operation::DescribeStackEvents;
#[doc(hidden)]
pub type DescribeStackEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackEvents`](crate::operation::DescribeStackEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackEvents",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackEventsInput`](crate::input::DescribeStackEventsInput)
    pub fn builder() -> crate::input::describe_stack_events_input::Builder {
        crate::input::describe_stack_events_input::Builder::default()
    }
}

/// See [`DescribeStackInstanceInput`](crate::input::DescribeStackInstanceInput)
pub mod describe_stack_instance_input {
    /// A builder for [`DescribeStackInstanceInput`](crate::input::DescribeStackInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_instance_account: std::option::Option<std::string::String>,
        pub(crate) stack_instance_region: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID of the stack set that you want to get stack instance
        /// information for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID of the stack set that you want to get stack instance
        /// information for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The ID of an Amazon Web Services account that's associated with this stack instance.</p>
        pub fn stack_instance_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_instance_account = Some(input.into());
            self
        }
        /// <p>The ID of an Amazon Web Services account that's associated with this stack instance.</p>
        pub fn set_stack_instance_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_instance_account = input;
            self
        }
        /// <p>The name of a Region that's associated with this stack instance.</p>
        pub fn stack_instance_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_instance_region = Some(input.into());
            self
        }
        /// <p>The name of a Region that's associated with this stack instance.</p>
        pub fn set_stack_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_instance_region = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackInstanceInput`](crate::input::DescribeStackInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackInstanceInput {
                stack_set_name: self.stack_set_name,
                stack_instance_account: self.stack_instance_account,
                stack_instance_region: self.stack_instance_region,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackInstanceInputOperationOutputAlias = crate::operation::DescribeStackInstance;
#[doc(hidden)]
pub type DescribeStackInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackInstance`](crate::operation::DescribeStackInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackInstance",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackInstanceInput`](crate::input::DescribeStackInstanceInput)
    pub fn builder() -> crate::input::describe_stack_instance_input::Builder {
        crate::input::describe_stack_instance_input::Builder::default()
    }
}

/// See [`DescribeStackResourceInput`](crate::input::DescribeStackResourceInput)
pub mod describe_stack_resource_input {
    /// A builder for [`DescribeStackResourceInput`](crate::input::DescribeStackResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackResourceInput`](crate::input::DescribeStackResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackResourceInput {
                stack_name: self.stack_name,
                logical_resource_id: self.logical_resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackResourceInputOperationOutputAlias = crate::operation::DescribeStackResource;
#[doc(hidden)]
pub type DescribeStackResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackResourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackResource`](crate::operation::DescribeStackResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackResource",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackResourceInput`](crate::input::DescribeStackResourceInput)
    pub fn builder() -> crate::input::describe_stack_resource_input::Builder {
        crate::input::describe_stack_resource_input::Builder::default()
    }
}

/// See [`DescribeStackResourceDriftsInput`](crate::input::DescribeStackResourceDriftsInput)
pub mod describe_stack_resource_drifts_input {
    /// A builder for [`DescribeStackResourceDriftsInput`](crate::input::DescribeStackResourceDriftsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_resource_drift_status_filters:
            std::option::Option<std::vec::Vec<crate::model::StackResourceDriftStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the stack for which you want drift information.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack for which you want drift information.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Appends an item to `stack_resource_drift_status_filters`.
        ///
        /// To override the contents of this collection use [`set_stack_resource_drift_status_filters`](Self::set_stack_resource_drift_status_filters).
        ///
        /// <p>The resource drift status values to use as filters for the resource drift results
        /// returned.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DELETED</code>: The resource differs from its expected template
        /// configuration in that the resource has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED</code>: One or more resource properties differ from their
        /// expected template values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_SYNC</code>: The resources's actual configuration matches its expected
        /// template configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p>
        /// </li>
        /// </ul>
        pub fn stack_resource_drift_status_filters(
            mut self,
            input: impl Into<crate::model::StackResourceDriftStatus>,
        ) -> Self {
            let mut v = self.stack_resource_drift_status_filters.unwrap_or_default();
            v.push(input.into());
            self.stack_resource_drift_status_filters = Some(v);
            self
        }
        /// <p>The resource drift status values to use as filters for the resource drift results
        /// returned.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DELETED</code>: The resource differs from its expected template
        /// configuration in that the resource has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED</code>: One or more resource properties differ from their
        /// expected template values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_SYNC</code>: The resources's actual configuration matches its expected
        /// template configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p>
        /// </li>
        /// </ul>
        pub fn set_stack_resource_drift_status_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackResourceDriftStatus>>,
        ) -> Self {
            self.stack_resource_drift_status_filters = input;
            self
        }
        /// <p>A string that identifies the next page of stack resource drift results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of stack resource drift results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackResourceDriftsInput`](crate::input::DescribeStackResourceDriftsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackResourceDriftsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackResourceDriftsInput {
                stack_name: self.stack_name,
                stack_resource_drift_status_filters: self.stack_resource_drift_status_filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackResourceDriftsInputOperationOutputAlias =
    crate::operation::DescribeStackResourceDrifts;
#[doc(hidden)]
pub type DescribeStackResourceDriftsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackResourceDriftsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackResourceDrifts`](crate::operation::DescribeStackResourceDrifts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackResourceDrifts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackResourceDriftsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackResourceDriftsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackResourceDriftsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_resource_drifts(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackResourceDrifts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackResourceDrifts",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackResourceDriftsInput`](crate::input::DescribeStackResourceDriftsInput)
    pub fn builder() -> crate::input::describe_stack_resource_drifts_input::Builder {
        crate::input::describe_stack_resource_drifts_input::Builder::default()
    }
}

/// See [`DescribeStackResourcesInput`](crate::input::DescribeStackResourcesInput)
pub mod describe_stack_resources_input {
    /// A builder for [`DescribeStackResourcesInput`](crate::input::DescribeStackResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        /// <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify
        /// <code>PhysicalResourceId</code>.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        /// <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify
        /// <code>PhysicalResourceId</code>.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a
        /// resource supported by CloudFormation.</p>
        /// <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance,
        /// <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass
        /// the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack
        /// the instance belongs to and what other resources are part of the stack.</p>
        /// <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you
        /// must specify <code>StackName</code>.</p>
        /// <p>Default: There is no default value.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a
        /// resource supported by CloudFormation.</p>
        /// <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance,
        /// <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass
        /// the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack
        /// the instance belongs to and what other resources are part of the stack.</p>
        /// <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you
        /// must specify <code>StackName</code>.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackResourcesInput`](crate::input::DescribeStackResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackResourcesInput {
                stack_name: self.stack_name,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackResourcesInputOperationOutputAlias = crate::operation::DescribeStackResources;
#[doc(hidden)]
pub type DescribeStackResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackResourcesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackResources`](crate::operation::DescribeStackResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_resources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackResources",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackResourcesInput`](crate::input::DescribeStackResourcesInput)
    pub fn builder() -> crate::input::describe_stack_resources_input::Builder {
        crate::input::describe_stack_resources_input::Builder::default()
    }
}

/// See [`DescribeStacksInput`](crate::input::DescribeStacksInput)
pub mod describe_stacks_input {
    /// A builder for [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStacksInput`](crate::input::DescribeStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStacksInput {
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStacksInputOperationOutputAlias = crate::operation::DescribeStacks;
#[doc(hidden)]
pub type DescribeStacksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStacks`](crate::operation::DescribeStacks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStacks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStacksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStacksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStacksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stacks(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStacks",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
}

/// See [`DescribeStackSetInput`](crate::input::DescribeStackSetInput)
pub mod describe_stack_set_input {
    /// A builder for [`DescribeStackSetInput`](crate::input::DescribeStackSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set whose description you want.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set whose description you want.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackSetInput`](crate::input::DescribeStackSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackSetInput {
                stack_set_name: self.stack_set_name,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackSetInputOperationOutputAlias = crate::operation::DescribeStackSet;
#[doc(hidden)]
pub type DescribeStackSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackSet`](crate::operation::DescribeStackSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackSetInput`](crate::input::DescribeStackSetInput)
    pub fn builder() -> crate::input::describe_stack_set_input::Builder {
        crate::input::describe_stack_set_input::Builder::default()
    }
}

/// See [`DescribeStackSetOperationInput`](crate::input::DescribeStackSetOperationInput)
pub mod describe_stack_set_operation_input {
    /// A builder for [`DescribeStackSetOperationInput`](crate::input::DescribeStackSetOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID of the stack set for the stack operation.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID of the stack set for the stack operation.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The unique ID of the stack set operation. </p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the stack set operation. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackSetOperationInput`](crate::input::DescribeStackSetOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackSetOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackSetOperationInput {
                stack_set_name: self.stack_set_name,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackSetOperationInputOperationOutputAlias =
    crate::operation::DescribeStackSetOperation;
#[doc(hidden)]
pub type DescribeStackSetOperationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStackSetOperationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackSetOperation`](crate::operation::DescribeStackSetOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackSetOperation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackSetOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackSetOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackSetOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_set_operation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackSetOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackSetOperation",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackSetOperationInput`](crate::input::DescribeStackSetOperationInput)
    pub fn builder() -> crate::input::describe_stack_set_operation_input::Builder {
        crate::input::describe_stack_set_operation_input::Builder::default()
    }
}

/// See [`DescribeTypeInput`](crate::input::DescribeTypeInput)
pub mod describe_type_input {
    /// A builder for [`DescribeTypeInput`](crate::input::DescribeTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
        pub(crate) public_version_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The kind of extension. </p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension. </p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        /// <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information
        /// about that specific extension version. Otherwise, it returns information about the default
        /// extension version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        /// <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information
        /// about that specific extension version. Otherwise, it returns information about the default
        /// extension version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions provided by Amazon are not assigned a publisher ID.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions provided by Amazon are not assigned a publisher ID.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// <p>The version number of a public third-party extension.</p>
        pub fn public_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_version_number = Some(input.into());
            self
        }
        /// <p>The version number of a public third-party extension.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTypeInput`](crate::input::DescribeTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTypeInput {
                r#type: self.r#type,
                type_name: self.type_name,
                arn: self.arn,
                version_id: self.version_id,
                publisher_id: self.publisher_id,
                public_version_number: self.public_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTypeInputOperationOutputAlias = crate::operation::DescribeType;
#[doc(hidden)]
pub type DescribeTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTypeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeType`](crate::operation::DescribeType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTypeInput`](crate::input::DescribeTypeInput)
    pub fn builder() -> crate::input::describe_type_input::Builder {
        crate::input::describe_type_input::Builder::default()
    }
}

/// See [`DescribeTypeRegistrationInput`](crate::input::DescribeTypeRegistrationInput)
pub mod describe_type_registration_input {
    /// A builder for [`DescribeTypeRegistrationInput`](crate::input::DescribeTypeRegistrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registration_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for this registration request.</p>
        /// <p>This registration token is generated by CloudFormation when you initiate a
        /// registration request using <code>
        /// <a>RegisterType</a>
        /// </code>.</p>
        pub fn registration_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.registration_token = Some(input.into());
            self
        }
        /// <p>The identifier for this registration request.</p>
        /// <p>This registration token is generated by CloudFormation when you initiate a
        /// registration request using <code>
        /// <a>RegisterType</a>
        /// </code>.</p>
        pub fn set_registration_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registration_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTypeRegistrationInput`](crate::input::DescribeTypeRegistrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTypeRegistrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTypeRegistrationInput {
                registration_token: self.registration_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTypeRegistrationInputOperationOutputAlias =
    crate::operation::DescribeTypeRegistration;
#[doc(hidden)]
pub type DescribeTypeRegistrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTypeRegistrationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTypeRegistration`](crate::operation::DescribeTypeRegistration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTypeRegistration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTypeRegistrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTypeRegistrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTypeRegistrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_type_registration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTypeRegistration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTypeRegistration",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTypeRegistrationInput`](crate::input::DescribeTypeRegistrationInput)
    pub fn builder() -> crate::input::describe_type_registration_input::Builder {
        crate::input::describe_type_registration_input::Builder::default()
    }
}

/// See [`DetectStackDriftInput`](crate::input::DetectStackDriftInput)
pub mod detect_stack_drift_input {
    /// A builder for [`DetectStackDriftInput`](crate::input::DetectStackDriftInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the stack for which you want to detect drift.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack for which you want to detect drift.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Appends an item to `logical_resource_ids`.
        ///
        /// To override the contents of this collection use [`set_logical_resource_ids`](Self::set_logical_resource_ids).
        ///
        /// <p>The logical names of any resources you want to use as filters.</p>
        pub fn logical_resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logical_resource_ids.unwrap_or_default();
            v.push(input.into());
            self.logical_resource_ids = Some(v);
            self
        }
        /// <p>The logical names of any resources you want to use as filters.</p>
        pub fn set_logical_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logical_resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectStackDriftInput`](crate::input::DetectStackDriftInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectStackDriftInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectStackDriftInput {
                stack_name: self.stack_name,
                logical_resource_ids: self.logical_resource_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectStackDriftInputOperationOutputAlias = crate::operation::DetectStackDrift;
#[doc(hidden)]
pub type DetectStackDriftInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectStackDriftInput {
    /// Consumes the builder and constructs an Operation<[`DetectStackDrift`](crate::operation::DetectStackDrift)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectStackDrift,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectStackDriftInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectStackDriftInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectStackDriftInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_stack_drift(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectStackDrift::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectStackDrift",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectStackDriftInput`](crate::input::DetectStackDriftInput)
    pub fn builder() -> crate::input::detect_stack_drift_input::Builder {
        crate::input::detect_stack_drift_input::Builder::default()
    }
}

/// See [`DetectStackResourceDriftInput`](crate::input::DetectStackResourceDriftInput)
pub mod detect_stack_resource_drift_input {
    /// A builder for [`DetectStackResourceDriftInput`](crate::input::DetectStackResourceDriftInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack to which the resource belongs.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack to which the resource belongs.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The logical name of the resource for which to return drift information.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource for which to return drift information.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectStackResourceDriftInput`](crate::input::DetectStackResourceDriftInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectStackResourceDriftInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectStackResourceDriftInput {
                stack_name: self.stack_name,
                logical_resource_id: self.logical_resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectStackResourceDriftInputOperationOutputAlias =
    crate::operation::DetectStackResourceDrift;
#[doc(hidden)]
pub type DetectStackResourceDriftInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectStackResourceDriftInput {
    /// Consumes the builder and constructs an Operation<[`DetectStackResourceDrift`](crate::operation::DetectStackResourceDrift)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectStackResourceDrift,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectStackResourceDriftInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectStackResourceDriftInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectStackResourceDriftInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_stack_resource_drift(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectStackResourceDrift::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectStackResourceDrift",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectStackResourceDriftInput`](crate::input::DetectStackResourceDriftInput)
    pub fn builder() -> crate::input::detect_stack_resource_drift_input::Builder {
        crate::input::detect_stack_resource_drift_input::Builder::default()
    }
}

/// See [`DetectStackSetDriftInput`](crate::input::DetectStackSetDriftInput)
pub mod detect_stack_set_drift_input {
    /// A builder for [`DetectStackSetDriftInput`](crate::input::DetectStackSetDriftInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name of the stack set on which to perform the drift detection operation.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the stack set on which to perform the drift detection operation.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>
        /// <i>The ID of the stack set operation.</i>
        /// </p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>
        /// <i>The ID of the stack set operation.</i>
        /// </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectStackSetDriftInput`](crate::input::DetectStackSetDriftInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectStackSetDriftInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectStackSetDriftInput {
                stack_set_name: self.stack_set_name,
                operation_preferences: self.operation_preferences,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectStackSetDriftInputOperationOutputAlias = crate::operation::DetectStackSetDrift;
#[doc(hidden)]
pub type DetectStackSetDriftInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectStackSetDriftInput {
    /// Consumes the builder and constructs an Operation<[`DetectStackSetDrift`](crate::operation::DetectStackSetDrift)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectStackSetDrift,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectStackSetDriftInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectStackSetDriftInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectStackSetDriftInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_stack_set_drift(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectStackSetDrift::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectStackSetDrift",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectStackSetDriftInput`](crate::input::DetectStackSetDriftInput)
    pub fn builder() -> crate::input::detect_stack_set_drift_input::Builder {
        crate::input::detect_stack_set_drift_input::Builder::default()
    }
}

/// See [`EstimateTemplateCostInput`](crate::input::EstimateTemplateCostInput)
pub mod estimate_template_cost_input {
    /// A builder for [`EstimateTemplateCostInput`](crate::input::EstimateTemplateCostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EstimateTemplateCostInput`](crate::input::EstimateTemplateCostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EstimateTemplateCostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EstimateTemplateCostInput {
                template_body: self.template_body,
                template_url: self.template_url,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type EstimateTemplateCostInputOperationOutputAlias = crate::operation::EstimateTemplateCost;
#[doc(hidden)]
pub type EstimateTemplateCostInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EstimateTemplateCostInput {
    /// Consumes the builder and constructs an Operation<[`EstimateTemplateCost`](crate::operation::EstimateTemplateCost)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EstimateTemplateCost,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EstimateTemplateCostInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EstimateTemplateCostInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EstimateTemplateCostInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_estimate_template_cost(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EstimateTemplateCost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EstimateTemplateCost",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EstimateTemplateCostInput`](crate::input::EstimateTemplateCostInput)
    pub fn builder() -> crate::input::estimate_template_cost_input::Builder {
        crate::input::estimate_template_cost_input::Builder::default()
    }
}

/// See [`ExecuteChangeSetInput`](crate::input::ExecuteChangeSetInput)
pub mod execute_change_set_input {
    /// A builder for [`ExecuteChangeSetInput`](crate::input::ExecuteChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) disable_rollback: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name or ARN of the change set that you want use to update the specified
        /// stack.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the change set that you want use to update the specified
        /// stack.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) that is
        /// associated with the change set you want to execute.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) that is
        /// associated with the change set you want to execute.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to execute a change set to update a stack with the same name. You might retry
        /// <code>ExecuteChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to execute a change set to update a stack with the same name. You might retry
        /// <code>ExecuteChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Preserves the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>True</code>
        /// </p>
        pub fn disable_rollback(mut self, input: bool) -> Self {
            self.disable_rollback = Some(input);
            self
        }
        /// <p>Preserves the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>True</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_rollback = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteChangeSetInput`](crate::input::ExecuteChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteChangeSetInput {
                change_set_name: self.change_set_name,
                stack_name: self.stack_name,
                client_request_token: self.client_request_token,
                disable_rollback: self.disable_rollback,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteChangeSetInputOperationOutputAlias = crate::operation::ExecuteChangeSet;
#[doc(hidden)]
pub type ExecuteChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteChangeSet`](crate::operation::ExecuteChangeSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteChangeSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteChangeSetInput`](crate::input::ExecuteChangeSetInput)
    pub fn builder() -> crate::input::execute_change_set_input::Builder {
        crate::input::execute_change_set_input::Builder::default()
    }
}

/// See [`GetStackPolicyInput`](crate::input::GetStackPolicyInput)
pub mod get_stack_policy_input {
    /// A builder for [`GetStackPolicyInput`](crate::input::GetStackPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or unique stack ID that is associated with the stack whose policy you want
        /// to get.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or unique stack ID that is associated with the stack whose policy you want
        /// to get.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStackPolicyInput`](crate::input::GetStackPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStackPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStackPolicyInput {
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStackPolicyInputOperationOutputAlias = crate::operation::GetStackPolicy;
#[doc(hidden)]
pub type GetStackPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetStackPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetStackPolicy`](crate::operation::GetStackPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStackPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStackPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStackPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStackPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_stack_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStackPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStackPolicy",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStackPolicyInput`](crate::input::GetStackPolicyInput)
    pub fn builder() -> crate::input::get_stack_policy_input::Builder {
        crate::input::get_stack_policy_input::Builder::default()
    }
}

/// See [`GetTemplateInput`](crate::input::GetTemplateInput)
pub mod get_template_input {
    /// A builder for [`GetTemplateInput`](crate::input::GetTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) template_stage: std::option::Option<crate::model::TemplateStage>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of a change set for which CloudFormation
        /// returns the associated template. If you specify a name, you must also specify the
        /// <code>StackName</code>.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of a change set for which CloudFormation
        /// returns the associated template. If you specify a name, you must also specify the
        /// <code>StackName</code>.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>For templates that include transforms, the stage of the template that CloudFormation returns. To get the user-submitted template, specify
        /// <code>Original</code>. To get the template after CloudFormation has processed
        /// all transforms, specify <code>Processed</code>.</p>
        /// <p>If the template doesn't include transforms, <code>Original</code> and
        /// <code>Processed</code> return the same template. By default, CloudFormation
        /// specifies <code>Processed</code>.</p>
        pub fn template_stage(mut self, input: crate::model::TemplateStage) -> Self {
            self.template_stage = Some(input);
            self
        }
        /// <p>For templates that include transforms, the stage of the template that CloudFormation returns. To get the user-submitted template, specify
        /// <code>Original</code>. To get the template after CloudFormation has processed
        /// all transforms, specify <code>Processed</code>.</p>
        /// <p>If the template doesn't include transforms, <code>Original</code> and
        /// <code>Processed</code> return the same template. By default, CloudFormation
        /// specifies <code>Processed</code>.</p>
        pub fn set_template_stage(
            mut self,
            input: std::option::Option<crate::model::TemplateStage>,
        ) -> Self {
            self.template_stage = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemplateInput`](crate::input::GetTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTemplateInput {
                stack_name: self.stack_name,
                change_set_name: self.change_set_name,
                template_stage: self.template_stage,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTemplateInputOperationOutputAlias = crate::operation::GetTemplate;
#[doc(hidden)]
pub type GetTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetTemplate`](crate::operation::GetTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTemplate",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTemplateInput`](crate::input::GetTemplateInput)
    pub fn builder() -> crate::input::get_template_input::Builder {
        crate::input::get_template_input::Builder::default()
    }
}

/// See [`GetTemplateSummaryInput`](crate::input::GetTemplateSummaryInput)
pub mod get_template_summary_input {
    /// A builder for [`GetTemplateSummaryInput`](crate::input::GetTemplateSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// <p>The name or the stack ID that is associated with the stack, which are not always
        /// interchangeable. For running stacks, you can specify either the stack's name or its unique
        /// stack ID. For deleted stack, you must specify the unique stack ID.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the stack ID that is associated with the stack, which are not always
        /// interchangeable. For running stacks, you can specify either the stack's name or its unique
        /// stack ID. For deleted stack, you must specify the unique stack ID.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name or unique ID of the stack set from which the stack was created.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set from which the stack was created.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemplateSummaryInput`](crate::input::GetTemplateSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTemplateSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTemplateSummaryInput {
                template_body: self.template_body,
                template_url: self.template_url,
                stack_name: self.stack_name,
                stack_set_name: self.stack_set_name,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTemplateSummaryInputOperationOutputAlias = crate::operation::GetTemplateSummary;
#[doc(hidden)]
pub type GetTemplateSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTemplateSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetTemplateSummary`](crate::operation::GetTemplateSummary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTemplateSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTemplateSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTemplateSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTemplateSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_template_summary(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTemplateSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTemplateSummary",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTemplateSummaryInput`](crate::input::GetTemplateSummaryInput)
    pub fn builder() -> crate::input::get_template_summary_input::Builder {
        crate::input::get_template_summary_input::Builder::default()
    }
}

/// See [`ImportStacksToStackSetInput`](crate::input::ImportStacksToStackSetInput)
pub mod import_stacks_to_stack_set_input {
    /// A builder for [`ImportStacksToStackSetInput`](crate::input::ImportStacksToStackSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name of the stack set. The name must be unique in the Region where you create your
        /// stack set.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the stack set. The name must be unique in the Region where you create your
        /// stack set.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `stack_ids`.
        ///
        /// To override the contents of this collection use [`set_stack_ids`](Self::set_stack_ids).
        ///
        /// <p>The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per
        /// stack set at a time.</p>
        pub fn stack_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_ids.unwrap_or_default();
            v.push(input.into());
            self.stack_ids = Some(v);
            self
        }
        /// <p>The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per
        /// stack set at a time.</p>
        pub fn set_stack_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_ids = input;
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>A unique, user defined, identifier for the stack set operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A unique, user defined, identifier for the stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportStacksToStackSetInput`](crate::input::ImportStacksToStackSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportStacksToStackSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportStacksToStackSetInput {
                stack_set_name: self.stack_set_name,
                stack_ids: self.stack_ids,
                operation_preferences: self.operation_preferences,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportStacksToStackSetInputOperationOutputAlias = crate::operation::ImportStacksToStackSet;
#[doc(hidden)]
pub type ImportStacksToStackSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportStacksToStackSetInput {
    /// Consumes the builder and constructs an Operation<[`ImportStacksToStackSet`](crate::operation::ImportStacksToStackSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportStacksToStackSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportStacksToStackSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportStacksToStackSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportStacksToStackSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_stacks_to_stack_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportStacksToStackSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportStacksToStackSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportStacksToStackSetInput`](crate::input::ImportStacksToStackSetInput)
    pub fn builder() -> crate::input::import_stacks_to_stack_set_input::Builder {
        crate::input::import_stacks_to_stack_set_input::Builder::default()
    }
}

/// See [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
pub mod list_change_sets_input {
    /// A builder for [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
        /// change sets.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
        /// change sets.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
        /// identifies the next page of change sets that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
        /// identifies the next page of change sets that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChangeSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChangeSetsInput {
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChangeSetsInputOperationOutputAlias = crate::operation::ListChangeSets;
#[doc(hidden)]
pub type ListChangeSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListChangeSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListChangeSets`](crate::operation::ListChangeSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChangeSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChangeSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChangeSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChangeSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_change_sets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChangeSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChangeSets",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    pub fn builder() -> crate::input::list_change_sets_input::Builder {
        crate::input::list_change_sets_input::Builder::default()
    }
}

/// See [`ListExportsInput`](crate::input::ListExportsInput)
pub mod list_exports_input {
    /// A builder for [`ListExportsInput`](crate::input::ListExportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string (provided by the <a>ListExports</a> response output) that
        /// identifies the next page of exported output values that you asked to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string (provided by the <a>ListExports</a> response output) that
        /// identifies the next page of exported output values that you asked to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExportsInput`](crate::input::ListExportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExportsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExportsInputOperationOutputAlias = crate::operation::ListExports;
#[doc(hidden)]
pub type ListExportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListExportsInput {
    /// Consumes the builder and constructs an Operation<[`ListExports`](crate::operation::ListExports)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_exports(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExports",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
}

/// See [`ListImportsInput`](crate::input::ListImportsInput)
pub mod list_imports_input {
    /// A builder for [`ListImportsInput`](crate::input::ListImportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the exported output value. CloudFormation returns the stack names
        /// that are importing this value.</p>
        pub fn export_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_name = Some(input.into());
            self
        }
        /// <p>The name of the exported output value. CloudFormation returns the stack names
        /// that are importing this value.</p>
        pub fn set_export_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_name = input;
            self
        }
        /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
        /// the next page of stacks that are importing the specified exported output value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
        /// the next page of stacks that are importing the specified exported output value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImportsInput`](crate::input::ListImportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImportsInput {
                export_name: self.export_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImportsInputOperationOutputAlias = crate::operation::ListImports;
#[doc(hidden)]
pub type ListImportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListImportsInput {
    /// Consumes the builder and constructs an Operation<[`ListImports`](crate::operation::ListImports)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListImportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListImportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListImportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_imports(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImports",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListImportsInput`](crate::input::ListImportsInput)
    pub fn builder() -> crate::input::list_imports_input::Builder {
        crate::input::list_imports_input::Builder::default()
    }
}

/// See [`ListStackInstancesInput`](crate::input::ListStackInstancesInput)
pub mod list_stack_instances_input {
    /// A builder for [`ListStackInstancesInput`](crate::input::ListStackInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::StackInstanceFilter>>,
        pub(crate) stack_instance_account: std::option::Option<std::string::String>,
        pub(crate) stack_instance_region: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to list stack instances
        /// for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to list stack instances
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response's
        /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
        /// results, call <code>ListStackInstances</code> again and assign that token to the request
        /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response's
        /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
        /// results, call <code>ListStackInstances</code> again and assign that token to the request
        /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The status that stack instances are filtered by.</p>
        pub fn filters(mut self, input: impl Into<crate::model::StackInstanceFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The status that stack instances are filtered by.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackInstanceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
        pub fn stack_instance_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_instance_account = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
        pub fn set_stack_instance_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_instance_account = input;
            self
        }
        /// <p>The name of the Region where you want to list stack instances. </p>
        pub fn stack_instance_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_instance_region = Some(input.into());
            self
        }
        /// <p>The name of the Region where you want to list stack instances. </p>
        pub fn set_stack_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_instance_region = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackInstancesInput`](crate::input::ListStackInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackInstancesInput {
                stack_set_name: self.stack_set_name,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                stack_instance_account: self.stack_instance_account,
                stack_instance_region: self.stack_instance_region,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackInstancesInputOperationOutputAlias = crate::operation::ListStackInstances;
#[doc(hidden)]
pub type ListStackInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStackInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListStackInstances`](crate::operation::ListStackInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_instances(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackInstances",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackInstancesInput`](crate::input::ListStackInstancesInput)
    pub fn builder() -> crate::input::list_stack_instances_input::Builder {
        crate::input::list_stack_instances_input::Builder::default()
    }
}

/// See [`ListStackResourcesInput`](crate::input::ListStackResourcesInput)
pub mod list_stack_resources_input {
    /// A builder for [`ListStackResourcesInput`](crate::input::ListStackResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>A string that identifies the next page of stack resources that you want to
        /// retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of stack resources that you want to
        /// retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackResourcesInput`](crate::input::ListStackResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackResourcesInput {
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackResourcesInputOperationOutputAlias = crate::operation::ListStackResources;
#[doc(hidden)]
pub type ListStackResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStackResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListStackResources`](crate::operation::ListStackResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_resources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackResources",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackResourcesInput`](crate::input::ListStackResourcesInput)
    pub fn builder() -> crate::input::list_stack_resources_input::Builder {
        crate::input::list_stack_resources_input::Builder::default()
    }
}

/// See [`ListStacksInput`](crate::input::ListStacksInput)
pub mod list_stacks_input {
    /// A builder for [`ListStacksInput`](crate::input::ListStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) stack_status_filter:
            std::option::Option<std::vec::Vec<crate::model::StackStatus>>,
    }
    impl Builder {
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `stack_status_filter`.
        ///
        /// To override the contents of this collection use [`set_stack_status_filter`](Self::set_stack_status_filter).
        ///
        /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
        /// stacks with the specified status codes. For a complete list of stack status codes, see the
        /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
        pub fn stack_status_filter(mut self, input: impl Into<crate::model::StackStatus>) -> Self {
            let mut v = self.stack_status_filter.unwrap_or_default();
            v.push(input.into());
            self.stack_status_filter = Some(v);
            self
        }
        /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
        /// stacks with the specified status codes. For a complete list of stack status codes, see the
        /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
        pub fn set_stack_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackStatus>>,
        ) -> Self {
            self.stack_status_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStacksInput`](crate::input::ListStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStacksInput {
                next_token: self.next_token,
                stack_status_filter: self.stack_status_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStacksInputOperationOutputAlias = crate::operation::ListStacks;
#[doc(hidden)]
pub type ListStacksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStacksInput {
    /// Consumes the builder and constructs an Operation<[`ListStacks`](crate::operation::ListStacks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStacks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStacksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStacksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStacksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_stacks(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStacks",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStacksInput`](crate::input::ListStacksInput)
    pub fn builder() -> crate::input::list_stacks_input::Builder {
        crate::input::list_stacks_input::Builder::default()
    }
}

/// See [`ListStackSetOperationResultsInput`](crate::input::ListStackSetOperationResultsInput)
pub mod list_stack_set_operation_results_input {
    /// A builder for [`ListStackSetOperationResultsInput`](crate::input::ListStackSetOperationResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to get operation results
        /// for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to get operation results
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The ID of the stack set operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response
        /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
        /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
        /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
        /// the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response
        /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
        /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
        /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
        /// the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackSetOperationResultsInput`](crate::input::ListStackSetOperationResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackSetOperationResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackSetOperationResultsInput {
                stack_set_name: self.stack_set_name,
                operation_id: self.operation_id,
                next_token: self.next_token,
                max_results: self.max_results,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackSetOperationResultsInputOperationOutputAlias =
    crate::operation::ListStackSetOperationResults;
#[doc(hidden)]
pub type ListStackSetOperationResultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStackSetOperationResultsInput {
    /// Consumes the builder and constructs an Operation<[`ListStackSetOperationResults`](crate::operation::ListStackSetOperationResults)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackSetOperationResults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackSetOperationResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackSetOperationResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackSetOperationResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_set_operation_results(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackSetOperationResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackSetOperationResults",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackSetOperationResultsInput`](crate::input::ListStackSetOperationResultsInput)
    pub fn builder() -> crate::input::list_stack_set_operation_results_input::Builder {
        crate::input::list_stack_set_operation_results_input::Builder::default()
    }
}

/// See [`ListStackSetOperationsInput`](crate::input::ListStackSetOperationsInput)
pub mod list_stack_set_operations_input {
    /// A builder for [`ListStackSetOperationsInput`](crate::input::ListStackSetOperationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to get operation summaries
        /// for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to get operation summaries
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
        /// to the request object's <code>NextToken</code> parameter. If there are no remaining
        /// results, the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
        /// to the request object's <code>NextToken</code> parameter. If there are no remaining
        /// results, the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackSetOperationsInput`](crate::input::ListStackSetOperationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackSetOperationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackSetOperationsInput {
                stack_set_name: self.stack_set_name,
                next_token: self.next_token,
                max_results: self.max_results,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackSetOperationsInputOperationOutputAlias = crate::operation::ListStackSetOperations;
#[doc(hidden)]
pub type ListStackSetOperationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStackSetOperationsInput {
    /// Consumes the builder and constructs an Operation<[`ListStackSetOperations`](crate::operation::ListStackSetOperations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackSetOperations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackSetOperationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackSetOperationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackSetOperationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_set_operations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackSetOperations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackSetOperations",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackSetOperationsInput`](crate::input::ListStackSetOperationsInput)
    pub fn builder() -> crate::input::list_stack_set_operations_input::Builder {
        crate::input::list_stack_set_operations_input::Builder::default()
    }
}

/// See [`ListStackSetsInput`](crate::input::ListStackSetsInput)
pub mod list_stack_sets_input {
    /// A builder for [`ListStackSetsInput`](crate::input::ListStackSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::StackSetStatus>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSets</code> again and assign that token to the
        /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
        /// previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSets</code> again and assign that token to the
        /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
        /// previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The status of the stack sets that you want to get summary information
        /// about.</p>
        pub fn status(mut self, input: crate::model::StackSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stack sets that you want to get summary information
        /// about.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the management account or as a delegated administrator in a member
        /// account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the management account or as a delegated administrator in a member
        /// account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackSetsInput`](crate::input::ListStackSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackSetsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                status: self.status,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackSetsInputOperationOutputAlias = crate::operation::ListStackSets;
#[doc(hidden)]
pub type ListStackSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStackSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListStackSets`](crate::operation::ListStackSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_sets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackSets",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackSetsInput`](crate::input::ListStackSetsInput)
    pub fn builder() -> crate::input::list_stack_sets_input::Builder {
        crate::input::list_stack_sets_input::Builder::default()
    }
}

/// See [`ListTypeRegistrationsInput`](crate::input::ListTypeRegistrationsInput)
pub mod list_type_registrations_input {
    /// A builder for [`ListTypeRegistrationsInput`](crate::input::ListTypeRegistrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) type_arn: std::option::Option<std::string::String>,
        pub(crate) registration_status_filter:
            std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_arn = input;
            self
        }
        /// <p>The current status of the extension registration request.</p>
        /// <p>The default is <code>IN_PROGRESS</code>.</p>
        pub fn registration_status_filter(
            mut self,
            input: crate::model::RegistrationStatus,
        ) -> Self {
            self.registration_status_filter = Some(input);
            self
        }
        /// <p>The current status of the extension registration request.</p>
        /// <p>The default is <code>IN_PROGRESS</code>.</p>
        pub fn set_registration_status_filter(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.registration_status_filter = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypeRegistrationsInput`](crate::input::ListTypeRegistrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTypeRegistrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTypeRegistrationsInput {
                r#type: self.r#type,
                type_name: self.type_name,
                type_arn: self.type_arn,
                registration_status_filter: self.registration_status_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypeRegistrationsInputOperationOutputAlias = crate::operation::ListTypeRegistrations;
#[doc(hidden)]
pub type ListTypeRegistrationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTypeRegistrationsInput {
    /// Consumes the builder and constructs an Operation<[`ListTypeRegistrations`](crate::operation::ListTypeRegistrations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypeRegistrations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTypeRegistrationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTypeRegistrationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTypeRegistrationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_type_registrations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTypeRegistrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTypeRegistrations",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTypeRegistrationsInput`](crate::input::ListTypeRegistrationsInput)
    pub fn builder() -> crate::input::list_type_registrations_input::Builder {
        crate::input::list_type_registrations_input::Builder::default()
    }
}

/// See [`ListTypesInput`](crate::input::ListTypesInput)
pub mod list_types_input {
    /// A builder for [`ListTypesInput`](crate::input::ListTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) visibility: std::option::Option<crate::model::Visibility>,
        pub(crate) provisioning_type: std::option::Option<crate::model::ProvisioningType>,
        pub(crate) deprecated_status: std::option::Option<crate::model::DeprecatedStatus>,
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) filters: std::option::Option<crate::model::TypeFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The scope at which the extensions are visible and usable in CloudFormation
        /// operations.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
        /// and region. This includes:</p>
        /// <ul>
        /// <li>
        /// <p>Private extensions you have registered in this account and region.</p>
        /// </li>
        /// <li>
        /// <p>Public extensions that you have activated in this account and region.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
        /// activated within any Amazon account. This includes extensions from Amazon, as well as
        /// third-party publishers.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>PRIVATE</code>.</p>
        pub fn visibility(mut self, input: crate::model::Visibility) -> Self {
            self.visibility = Some(input);
            self
        }
        /// <p>The scope at which the extensions are visible and usable in CloudFormation
        /// operations.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
        /// and region. This includes:</p>
        /// <ul>
        /// <li>
        /// <p>Private extensions you have registered in this account and region.</p>
        /// </li>
        /// <li>
        /// <p>Public extensions that you have activated in this account and region.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
        /// activated within any Amazon account. This includes extensions from Amazon, as well as
        /// third-party publishers.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>PRIVATE</code>.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::Visibility>,
        ) -> Self {
            self.visibility = input;
            self
        }
        /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
        /// provisioning type during registration, based on the types of handlers in the schema handler
        /// package submitted.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
        /// process updates to the type during stack update operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
        /// the type cannot be updated and must instead be replaced during stack update
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
        /// and delete handlers, and therefore cannot actually be provisioned.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
        pub fn provisioning_type(mut self, input: crate::model::ProvisioningType) -> Self {
            self.provisioning_type = Some(input);
            self
        }
        /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
        /// provisioning type during registration, based on the types of handlers in the schema handler
        /// package submitted.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
        /// process updates to the type during stack update operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
        /// the type cannot be updated and must instead be replaced during stack update
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
        /// and delete handlers, and therefore cannot actually be provisioned.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
        pub fn set_provisioning_type(
            mut self,
            input: std::option::Option<crate::model::ProvisioningType>,
        ) -> Self {
            self.provisioning_type = input;
            self
        }
        /// <p>The deprecation status of the extension that you want to get summary information
        /// about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension is registered for use in CloudFormation
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
        /// used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        pub fn deprecated_status(mut self, input: crate::model::DeprecatedStatus) -> Self {
            self.deprecated_status = Some(input);
            self
        }
        /// <p>The deprecation status of the extension that you want to get summary information
        /// about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension is registered for use in CloudFormation
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
        /// used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        pub fn set_deprecated_status(
            mut self,
            input: std::option::Option<crate::model::DeprecatedStatus>,
        ) -> Self {
            self.deprecated_status = input;
            self
        }
        /// <p>The type of extension.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Filter criteria to use in determining which extensions to return.</p>
        /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
        /// value when returning the list of types.</p>
        pub fn filters(mut self, input: crate::model::TypeFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filter criteria to use in determining which extensions to return.</p>
        /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
        /// value when returning the list of types.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::TypeFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypesInput`](crate::input::ListTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTypesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTypesInput {
                visibility: self.visibility,
                provisioning_type: self.provisioning_type,
                deprecated_status: self.deprecated_status,
                r#type: self.r#type,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypesInputOperationOutputAlias = crate::operation::ListTypes;
#[doc(hidden)]
pub type ListTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListTypes`](crate::operation::ListTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTypes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTypes",
                    "cloudformation",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTypesInput`](crate::input::ListTypesInput)
    pub fn builder() -> crate::input::list_types_input::Builder {
        crate::input::list_types_input::Builder::default()
    }
}

/// See [`ListTypeVersionsInput`](crate::input::ListTypeVersionsInput)
pub mod list_type_versions_input {
    /// A builder for [`ListTypeVersionsInput`](crate::input::ListTypeVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) deprecated_status: std::option::Option<crate::model::DeprecatedStatus>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The kind of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension for which you want version summary information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension for which you want version summary information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The deprecation status of the extension versions that you want to get summary
        /// information about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
        /// scope.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
        /// longer be used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>LIVE</code>.</p>
        pub fn deprecated_status(mut self, input: crate::model::DeprecatedStatus) -> Self {
            self.deprecated_status = Some(input);
            self
        }
        /// <p>The deprecation status of the extension versions that you want to get summary
        /// information about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
        /// scope.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
        /// longer be used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>LIVE</code>.</p>
        pub fn set_deprecated_status(
            mut self,
            input: std::option::Option<crate::model::DeprecatedStatus>,
        ) -> Self {
            self.deprecated_status = input;
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypeVersionsInput`](crate::input::ListTypeVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTypeVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTypeVersionsInput {
                r#type: self.r#type,
                type_name: self.type_name,
                arn: self.arn,
                max_results: self.max_results,
                next_token: self.next_token,
                deprecated_status: self.deprecated_status,
                publisher_id: self.publisher_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypeVersionsInputOperationOutputAlias = crate::operation::ListTypeVersions;
#[doc(hidden)]
pub type ListTypeVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTypeVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTypeVersions`](crate::operation::ListTypeVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypeVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTypeVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTypeVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTypeVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_type_versions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTypeVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTypeVersions",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTypeVersionsInput`](crate::input::ListTypeVersionsInput)
    pub fn builder() -> crate::input::list_type_versions_input::Builder {
        crate::input::list_type_versions_input::Builder::default()
    }
}

/// See [`PublishTypeInput`](crate::input::PublishTypeInput)
pub mod publish_type_input {
    /// A builder for [`PublishTypeInput`](crate::input::PublishTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) public_version_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The version number to assign to this version of the extension.</p>
        /// <p>Use the following format, and adhere to semantic versioning when assigning a version
        /// number to your extension: </p>
        /// <p>
        /// <code>MAJOR.MINOR.PATCH</code>
        /// </p>
        /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
        /// 2.0.0</a>.</p>
        /// <p>If you do not specify a version number, CloudFormation increments the version number by
        /// one minor version release.</p>
        /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
        /// regardless of the value you specify.</p>
        pub fn public_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_version_number = Some(input.into());
            self
        }
        /// <p>The version number to assign to this version of the extension.</p>
        /// <p>Use the following format, and adhere to semantic versioning when assigning a version
        /// number to your extension: </p>
        /// <p>
        /// <code>MAJOR.MINOR.PATCH</code>
        /// </p>
        /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
        /// 2.0.0</a>.</p>
        /// <p>If you do not specify a version number, CloudFormation increments the version number by
        /// one minor version release.</p>
        /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
        /// regardless of the value you specify.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishTypeInput`](crate::input::PublishTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishTypeInput {
                r#type: self.r#type,
                arn: self.arn,
                type_name: self.type_name,
                public_version_number: self.public_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishTypeInputOperationOutputAlias = crate::operation::PublishType;
#[doc(hidden)]
pub type PublishTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PublishTypeInput {
    /// Consumes the builder and constructs an Operation<[`PublishType`](crate::operation::PublishType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PublishTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PublishTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PublishTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_publish_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PublishTypeInput`](crate::input::PublishTypeInput)
    pub fn builder() -> crate::input::publish_type_input::Builder {
        crate::input::publish_type_input::Builder::default()
    }
}

/// See [`RecordHandlerProgressInput`](crate::input::RecordHandlerProgressInput)
pub mod record_handler_progress_input {
    /// A builder for [`RecordHandlerProgressInput`](crate::input::RecordHandlerProgressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bearer_token: std::option::Option<std::string::String>,
        pub(crate) operation_status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) current_operation_status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::HandlerErrorCode>,
        pub(crate) resource_model: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn bearer_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.bearer_token = Some(input.into());
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_bearer_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bearer_token = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn operation_status(mut self, input: crate::model::OperationStatus) -> Self {
            self.operation_status = Some(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_operation_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.operation_status = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn current_operation_status(mut self, input: crate::model::OperationStatus) -> Self {
            self.current_operation_status = Some(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_current_operation_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.current_operation_status = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn error_code(mut self, input: crate::model::HandlerErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::HandlerErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn resource_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_model = Some(input.into());
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_resource_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_model = input;
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordHandlerProgressInput`](crate::input::RecordHandlerProgressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RecordHandlerProgressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RecordHandlerProgressInput {
                bearer_token: self.bearer_token,
                operation_status: self.operation_status,
                current_operation_status: self.current_operation_status,
                status_message: self.status_message,
                error_code: self.error_code,
                resource_model: self.resource_model,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type RecordHandlerProgressInputOperationOutputAlias = crate::operation::RecordHandlerProgress;
#[doc(hidden)]
pub type RecordHandlerProgressInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RecordHandlerProgressInput {
    /// Consumes the builder and constructs an Operation<[`RecordHandlerProgress`](crate::operation::RecordHandlerProgress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RecordHandlerProgress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RecordHandlerProgressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RecordHandlerProgressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RecordHandlerProgressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_record_handler_progress(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RecordHandlerProgress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RecordHandlerProgress",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RecordHandlerProgressInput`](crate::input::RecordHandlerProgressInput)
    pub fn builder() -> crate::input::record_handler_progress_input::Builder {
        crate::input::record_handler_progress_input::Builder::default()
    }
}

/// See [`RegisterPublisherInput`](crate::input::RegisterPublisherInput)
pub mod register_publisher_input {
    /// A builder for [`RegisterPublisherInput`](crate::input::RegisterPublisherInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_terms_and_conditions: std::option::Option<bool>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
        /// You must accept the terms and conditions in order to register to publish public extensions
        /// to the CloudFormation registry.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn accept_terms_and_conditions(mut self, input: bool) -> Self {
            self.accept_terms_and_conditions = Some(input);
            self
        }
        /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
        /// You must accept the terms and conditions in order to register to publish public extensions
        /// to the CloudFormation registry.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn set_accept_terms_and_conditions(mut self, input: std::option::Option<bool>) -> Self {
            self.accept_terms_and_conditions = input;
            self
        }
        /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
        /// Resource Name (ARN) for your connection to that account.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
        /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
        /// Resource Name (ARN) for your connection to that account.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
        /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterPublisherInput`](crate::input::RegisterPublisherInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterPublisherInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterPublisherInput {
                accept_terms_and_conditions: self.accept_terms_and_conditions,
                connection_arn: self.connection_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterPublisherInputOperationOutputAlias = crate::operation::RegisterPublisher;
#[doc(hidden)]
pub type RegisterPublisherInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterPublisherInput {
    /// Consumes the builder and constructs an Operation<[`RegisterPublisher`](crate::operation::RegisterPublisher)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterPublisher,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterPublisherInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterPublisherInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterPublisherInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_publisher(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterPublisher::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterPublisher",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterPublisherInput`](crate::input::RegisterPublisherInput)
    pub fn builder() -> crate::input::register_publisher_input::Builder {
        crate::input::register_publisher_input::Builder::default()
    }
}

/// See [`RegisterTypeInput`](crate::input::RegisterTypeInput)
pub mod register_type_input {
    /// A builder for [`RegisterTypeInput`](crate::input::RegisterTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) schema_handler_package: std::option::Option<std::string::String>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The kind of extension.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension being registered.</p>
        /// <p>We recommend that extension names adhere to the following patterns: </p>
        /// <ul>
        /// <li>
        /// <p>For resource types,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
        /// </li>
        /// <li>
        /// <p>For modules,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following organization namespaces are reserved and cannot be used in your
        /// extension names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Alexa</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AMZN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Custom</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Dev</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension being registered.</p>
        /// <p>We recommend that extension names adhere to the following patterns: </p>
        /// <ul>
        /// <li>
        /// <p>For resource types,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
        /// </li>
        /// <li>
        /// <p>For modules,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following organization namespaces are reserved and cannot be used in your
        /// extension names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Alexa</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AMZN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Custom</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Dev</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>A url to the S3 bucket containing the extension project package that contains the
        /// neccessary files for the extension you want to register.</p>
        /// <p>For information on generating a schema handler package for the extension you want to
        /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
        /// in the <i>CloudFormation CLI User Guide</i>.</p>
        /// <note>
        /// <p>The user registering the extension must be able to access the package in the S3
        /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
        /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
        /// for Amazon S3</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// </note>
        pub fn schema_handler_package(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_handler_package = Some(input.into());
            self
        }
        /// <p>A url to the S3 bucket containing the extension project package that contains the
        /// neccessary files for the extension you want to register.</p>
        /// <p>For information on generating a schema handler package for the extension you want to
        /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
        /// in the <i>CloudFormation CLI User Guide</i>.</p>
        /// <note>
        /// <p>The user registering the extension must be able to access the package in the S3
        /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
        /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
        /// for Amazon S3</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_schema_handler_package(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_handler_package = input;
            self
        }
        /// <p>Specifies logging configuration information for an extension.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>Specifies logging configuration information for an extension.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
        /// when invoking the extension.</p>
        /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
        /// relationship with the CloudFormation service principle
        /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
        /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
        /// an <i>
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
        /// execution role</a>
        /// </i> that includes the necessary permissions to call
        /// those Amazon Web Services APIs, and provision that execution role in your account. When
        /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
        /// execution role to create a temporary session token, which it then passes to the resource
        /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
        /// when invoking the extension.</p>
        /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
        /// relationship with the CloudFormation service principle
        /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
        /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
        /// an <i>
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
        /// execution role</a>
        /// </i> that includes the necessary permissions to call
        /// those Amazon Web Services APIs, and provision that execution role in your account. When
        /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
        /// execution role to create a temporary session token, which it then passes to the resource
        /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>A unique identifier that acts as an idempotency key for this registration request.
        /// Specifying a client request token prevents CloudFormation from generating more
        /// than one version of an extension from the same registeration request, even if the request
        /// is submitted multiple times. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that acts as an idempotency key for this registration request.
        /// Specifying a client request token prevents CloudFormation from generating more
        /// than one version of an extension from the same registeration request, even if the request
        /// is submitted multiple times. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTypeInput`](crate::input::RegisterTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterTypeInput {
                r#type: self.r#type,
                type_name: self.type_name,
                schema_handler_package: self.schema_handler_package,
                logging_config: self.logging_config,
                execution_role_arn: self.execution_role_arn,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterTypeInputOperationOutputAlias = crate::operation::RegisterType;
#[doc(hidden)]
pub type RegisterTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterTypeInput {
    /// Consumes the builder and constructs an Operation<[`RegisterType`](crate::operation::RegisterType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_register_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterType",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterTypeInput`](crate::input::RegisterTypeInput)
    pub fn builder() -> crate::input::register_type_input::Builder {
        crate::input::register_type_input::Builder::default()
    }
}

/// See [`RollbackStackInput`](crate::input::RollbackStackInput)
pub mod rollback_stack_input {
    /// A builder for [`RollbackStackInput`](crate::input::RollbackStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name that is associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackStackInput`](crate::input::RollbackStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RollbackStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RollbackStackInput {
                stack_name: self.stack_name,
                role_arn: self.role_arn,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type RollbackStackInputOperationOutputAlias = crate::operation::RollbackStack;
#[doc(hidden)]
pub type RollbackStackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RollbackStackInput {
    /// Consumes the builder and constructs an Operation<[`RollbackStack`](crate::operation::RollbackStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RollbackStack,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RollbackStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RollbackStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RollbackStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_rollback_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RollbackStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RollbackStack",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RollbackStackInput`](crate::input::RollbackStackInput)
    pub fn builder() -> crate::input::rollback_stack_input::Builder {
        crate::input::rollback_stack_input::Builder::default()
    }
}

/// See [`SetStackPolicyInput`](crate::input::SetStackPolicyInput)
pub mod set_stack_policy_input {
    /// A builder for [`SetStackPolicyInput`](crate::input::SetStackPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_policy_body: std::option::Option<std::string::String>,
        pub(crate) stack_policy_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or unique stack ID that you want to associate a policy with.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or unique stack ID that you want to associate a policy with.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
        /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        pub fn stack_policy_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_body = Some(input.into());
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
        /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_body = input;
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn stack_policy_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_url = Some(input.into());
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_url = input;
            self
        }
        /// Consumes the builder and constructs a [`SetStackPolicyInput`](crate::input::SetStackPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetStackPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetStackPolicyInput {
                stack_name: self.stack_name,
                stack_policy_body: self.stack_policy_body,
                stack_policy_url: self.stack_policy_url,
            })
        }
    }
}
#[doc(hidden)]
pub type SetStackPolicyInputOperationOutputAlias = crate::operation::SetStackPolicy;
#[doc(hidden)]
pub type SetStackPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetStackPolicyInput {
    /// Consumes the builder and constructs an Operation<[`SetStackPolicy`](crate::operation::SetStackPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetStackPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetStackPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetStackPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetStackPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_stack_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetStackPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetStackPolicy",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetStackPolicyInput`](crate::input::SetStackPolicyInput)
    pub fn builder() -> crate::input::set_stack_policy_input::Builder {
        crate::input::set_stack_policy_input::Builder::default()
    }
}

/// See [`SetTypeConfigurationInput`](crate::input::SetTypeConfigurationInput)
pub mod set_type_configuration_input {
    /// A builder for [`SetTypeConfigurationInput`](crate::input::SetTypeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_arn: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) configuration_alias: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
        /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
        /// configuration for an extension, but not for a specific extension version.</p>
        pub fn type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
        /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
        /// configuration for an extension, but not for a specific extension version.</p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_arn = input;
            self
        }
        /// <p>The configuration data for the extension, in this account and region. </p>
        /// <p>The configuration data must be formatted as JSON, and validate against the schema
        /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
        /// <i>CloudFormation CLI User Guide</i>.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The configuration data for the extension, in this account and region. </p>
        /// <p>The configuration data must be formatted as JSON, and validate against the schema
        /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
        /// <i>CloudFormation CLI User Guide</i>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>An alias by which to refer to this extension configuration data.</p>
        /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
        /// for a resource type extension.</p>
        pub fn configuration_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_alias = Some(input.into());
            self
        }
        /// <p>An alias by which to refer to this extension configuration data.</p>
        /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
        /// for a resource type extension.</p>
        pub fn set_configuration_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_alias = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The type of extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTypeConfigurationInput`](crate::input::SetTypeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTypeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTypeConfigurationInput {
                type_arn: self.type_arn,
                configuration: self.configuration,
                configuration_alias: self.configuration_alias,
                type_name: self.type_name,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTypeConfigurationInputOperationOutputAlias = crate::operation::SetTypeConfiguration;
#[doc(hidden)]
pub type SetTypeConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetTypeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`SetTypeConfiguration`](crate::operation::SetTypeConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTypeConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTypeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTypeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTypeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_type_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTypeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTypeConfiguration",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTypeConfigurationInput`](crate::input::SetTypeConfigurationInput)
    pub fn builder() -> crate::input::set_type_configuration_input::Builder {
        crate::input::set_type_configuration_input::Builder::default()
    }
}

/// See [`SetTypeDefaultVersionInput`](crate::input::SetTypeDefaultVersionInput)
pub mod set_type_default_version_input {
    /// A builder for [`SetTypeDefaultVersionInput`](crate::input::SetTypeDefaultVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTypeDefaultVersionInput`](crate::input::SetTypeDefaultVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTypeDefaultVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTypeDefaultVersionInput {
                arn: self.arn,
                r#type: self.r#type,
                type_name: self.type_name,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTypeDefaultVersionInputOperationOutputAlias = crate::operation::SetTypeDefaultVersion;
#[doc(hidden)]
pub type SetTypeDefaultVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetTypeDefaultVersionInput {
    /// Consumes the builder and constructs an Operation<[`SetTypeDefaultVersion`](crate::operation::SetTypeDefaultVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTypeDefaultVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTypeDefaultVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTypeDefaultVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTypeDefaultVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_type_default_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTypeDefaultVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTypeDefaultVersion",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTypeDefaultVersionInput`](crate::input::SetTypeDefaultVersionInput)
    pub fn builder() -> crate::input::set_type_default_version_input::Builder {
        crate::input::set_type_default_version_input::Builder::default()
    }
}

/// See [`SignalResourceInput`](crate::input::SignalResourceInput)
pub mod signal_resource_input {
    /// A builder for [`SignalResourceInput`](crate::input::SignalResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) unique_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceSignalStatus>,
    }
    impl Builder {
        /// <p>The stack name or unique stack ID that includes the resource that you want to
        /// signal.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The stack name or unique stack ID that includes the resource that you want to
        /// signal.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
        /// the resource that given in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
        /// the resource that given in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
        /// groups, specify the instance ID that you are signaling as the unique ID. If you send
        /// multiple signals to a single resource (such as signaling a wait condition), each signal
        /// requires a different unique ID.</p>
        pub fn unique_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_id = Some(input.into());
            self
        }
        /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
        /// groups, specify the instance ID that you are signaling as the unique ID. If you send
        /// multiple signals to a single resource (such as signaling a wait condition), each signal
        /// requires a different unique ID.</p>
        pub fn set_unique_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unique_id = input;
            self
        }
        /// <p>The status of the signal, which is either success or failure. A failure signal causes
        /// CloudFormation to immediately fail the stack creation or update.</p>
        pub fn status(mut self, input: crate::model::ResourceSignalStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the signal, which is either success or failure. A failure signal causes
        /// CloudFormation to immediately fail the stack creation or update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceSignalStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SignalResourceInput`](crate::input::SignalResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SignalResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SignalResourceInput {
                stack_name: self.stack_name,
                logical_resource_id: self.logical_resource_id,
                unique_id: self.unique_id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type SignalResourceInputOperationOutputAlias = crate::operation::SignalResource;
#[doc(hidden)]
pub type SignalResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SignalResourceInput {
    /// Consumes the builder and constructs an Operation<[`SignalResource`](crate::operation::SignalResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SignalResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SignalResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SignalResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SignalResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_signal_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SignalResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SignalResource",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SignalResourceInput`](crate::input::SignalResourceInput)
    pub fn builder() -> crate::input::signal_resource_input::Builder {
        crate::input::signal_resource_input::Builder::default()
    }
}

/// See [`StopStackSetOperationInput`](crate::input::StopStackSetOperationInput)
pub mod stop_stack_set_operation_input {
    /// A builder for [`StopStackSetOperationInput`](crate::input::StopStackSetOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to stop the operation
        /// for.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to stop the operation
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The ID of the stack operation. </p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack operation. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`StopStackSetOperationInput`](crate::input::StopStackSetOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopStackSetOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopStackSetOperationInput {
                stack_set_name: self.stack_set_name,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type StopStackSetOperationInputOperationOutputAlias = crate::operation::StopStackSetOperation;
#[doc(hidden)]
pub type StopStackSetOperationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopStackSetOperationInput {
    /// Consumes the builder and constructs an Operation<[`StopStackSetOperation`](crate::operation::StopStackSetOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopStackSetOperation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopStackSetOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopStackSetOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopStackSetOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_stack_set_operation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopStackSetOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopStackSetOperation",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopStackSetOperationInput`](crate::input::StopStackSetOperationInput)
    pub fn builder() -> crate::input::stop_stack_set_operation_input::Builder {
        crate::input::stop_stack_set_operation_input::Builder::default()
    }
}

/// See [`TestTypeInput`](crate::input::TestTypeInput)
pub mod test_type_input {
    /// A builder for [`TestTypeInput`](crate::input::TestTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) log_delivery_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The version of the extension to test.</p>
        /// <p>You can specify the version id with either <code>Arn</code>, or with
        /// <code>TypeName</code> and <code>Type</code>.</p>
        /// <p>If you do not specify a version, CloudFormation uses the default version of the
        /// extension in this account and region for testing.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version of the extension to test.</p>
        /// <p>You can specify the version id with either <code>Arn</code>, or with
        /// <code>TypeName</code> and <code>Type</code>.</p>
        /// <p>If you do not specify a version, CloudFormation uses the default version of the
        /// extension in this account and region for testing.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
        /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
        /// extension has been assigned a test type status of <code>PASSED</code> or
        /// <code>FAILED</code>.</p>
        /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
        /// bucket. Specifically, the user needs the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>GetObject</p>
        /// </li>
        /// <li>
        /// <p>PutObject</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
        /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
        /// Access Management User Guide</i>.</p>
        pub fn log_delivery_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_delivery_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
        /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
        /// extension has been assigned a test type status of <code>PASSED</code> or
        /// <code>FAILED</code>.</p>
        /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
        /// bucket. Specifically, the user needs the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>GetObject</p>
        /// </li>
        /// <li>
        /// <p>PutObject</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
        /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
        /// Access Management User Guide</i>.</p>
        pub fn set_log_delivery_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_delivery_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`TestTypeInput`](crate::input::TestTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::TestTypeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::TestTypeInput {
                arn: self.arn,
                r#type: self.r#type,
                type_name: self.type_name,
                version_id: self.version_id,
                log_delivery_bucket: self.log_delivery_bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type TestTypeInputOperationOutputAlias = crate::operation::TestType;
#[doc(hidden)]
pub type TestTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestTypeInput {
    /// Consumes the builder and constructs an Operation<[`TestType`](crate::operation::TestType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_test_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::TestType::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "TestType",
                    "cloudformation",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestTypeInput`](crate::input::TestTypeInput)
    pub fn builder() -> crate::input::test_type_input::Builder {
        crate::input::test_type_input::Builder::default()
    }
}

/// See [`UpdateStackInput`](crate::input::UpdateStackInput)
pub mod update_stack_input {
    /// A builder for [`UpdateStackInput`](crate::input::UpdateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) use_previous_template: std::option::Option<bool>,
        pub(crate) stack_policy_during_update_body: std::option::Option<std::string::String>,
        pub(crate) stack_policy_during_update_url: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
        pub(crate) stack_policy_body: std::option::Option<std::string::String>,
        pub(crate) stack_policy_url: std::option::Option<std::string::String>,
        pub(crate) notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) disable_rollback: std::option::Option<bool>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or unique stack ID of the stack to update.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or unique stack ID of the stack to update.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// <p>Reuse the existing template that is associated with the stack that you are
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn use_previous_template(mut self, input: bool) -> Self {
            self.use_previous_template = Some(input);
            self
        }
        /// <p>Reuse the existing template that is associated with the stack that you are
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.use_previous_template = input;
            self
        }
        /// <p>Structure containing the temporary overriding stack policy body. You can specify
        /// either the <code>StackPolicyDuringUpdateBody</code> or the
        /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn stack_policy_during_update_body(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.stack_policy_during_update_body = Some(input.into());
            self
        }
        /// <p>Structure containing the temporary overriding stack policy body. You can specify
        /// either the <code>StackPolicyDuringUpdateBody</code> or the
        /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn set_stack_policy_during_update_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_during_update_body = input;
            self
        }
        /// <p>Location of a file containing the temporary overriding stack policy. The URL must
        /// point to a policy (max size: 16KB) located in an S3 bucket in
        /// the same Region as the stack. You can specify either the
        /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
        /// parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn stack_policy_during_update_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.stack_policy_during_update_url = Some(input.into());
            self
        }
        /// <p>Location of a file containing the temporary overriding stack policy. The URL must
        /// point to a policy (max size: 16KB) located in an S3 bucket in
        /// the same Region as the stack. You can specify either the
        /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
        /// parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn set_stack_policy_during_update_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_during_update_url = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually updating the stack. If your stack template contains one or
        /// more macros, and you choose to update a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to update a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must update the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only update stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually updating the stack. If your stack template contains one or
        /// more macros, and you choose to update a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to update a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must update the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only update stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with for this update
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource that you're updating, the
        /// stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The template resource types that you have permissions to work with for this update
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource that you're updating, the
        /// stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(
            mut self,
            input: crate::model::RollbackConfiguration,
        ) -> Self {
            self.rollback_configuration = Some(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.rollback_configuration = input;
            self
        }
        /// <p>Structure containing a new stack policy body. You can specify either the
        /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn stack_policy_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_body = Some(input.into());
            self
        }
        /// <p>Structure containing a new stack policy body. You can specify either the
        /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_body = input;
            self
        }
        /// <p>Location of a file containing the updated stack policy. The URL must point to a
        /// policy (max size: 16KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn stack_policy_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_policy_url = Some(input.into());
            self
        }
        /// <p>Location of a file containing the updated stack policy. The URL must point to a
        /// policy (max size: 16KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_policy_url = input;
            self
        }
        /// Appends an item to `notification_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
        /// CloudFormation associates with the stack. Specify an empty list to remove all notification
        /// topics.</p>
        pub fn notification_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.notification_ar_ns = Some(v);
            self
        }
        /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
        /// CloudFormation associates with the stack. Specify an empty list to remove all notification
        /// topics.</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_ar_ns = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to supported resources in the stack. You can specify a maximum number of 50
        /// tags.</p>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
        /// tags. If you specify an empty value, CloudFormation removes all associated
        /// tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to supported resources in the stack. You can specify a maximum number of 50
        /// tags.</p>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
        /// tags. If you specify an empty value, CloudFormation removes all associated
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>False</code>
        /// </p>
        pub fn disable_rollback(mut self, input: bool) -> Self {
            self.disable_rollback = Some(input);
            self
        }
        /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>False</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_rollback = input;
            self
        }
        /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackInput`](crate::input::UpdateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStackInput {
                stack_name: self.stack_name,
                template_body: self.template_body,
                template_url: self.template_url,
                use_previous_template: self.use_previous_template,
                stack_policy_during_update_body: self.stack_policy_during_update_body,
                stack_policy_during_update_url: self.stack_policy_during_update_url,
                parameters: self.parameters,
                capabilities: self.capabilities,
                resource_types: self.resource_types,
                role_arn: self.role_arn,
                rollback_configuration: self.rollback_configuration,
                stack_policy_body: self.stack_policy_body,
                stack_policy_url: self.stack_policy_url,
                notification_ar_ns: self.notification_ar_ns,
                tags: self.tags,
                disable_rollback: self.disable_rollback,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStackInputOperationOutputAlias = crate::operation::UpdateStack;
#[doc(hidden)]
pub type UpdateStackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStackInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStack`](crate::operation::UpdateStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStack,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStack",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
}

/// See [`UpdateStackInstancesInput`](crate::input::UpdateStackInstancesInput)
pub mod update_stack_instances_input {
    /// A builder for [`UpdateStackInstancesInput`](crate::input::UpdateStackInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parameter_overrides: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
        /// for stack instances. The overridden parameter values will be applied to all stack instances
        /// in the specified accounts and Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
        /// for stack instances. The overridden parameter values will be applied to all stack instances
        /// in the specified accounts and Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which you want to
        /// update parameter values for stack instances. If your update targets OUs, the overridden
        /// parameter values only apply to the accounts that are currently in the target OUs and their
        /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
        /// overridden values.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, input: crate::model::DeploymentTargets) -> Self {
            self.deployment_targets = Some(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which you want to
        /// update parameter values for stack instances. If your update targets OUs, the overridden
        /// parameter values only apply to the accounts that are currently in the target OUs and their
        /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
        /// overridden values.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The names of one or more Regions in which you want to update parameter values for
        /// stack instances. The overridden parameter values will be applied to all stack instances in
        /// the specified accounts and Regions.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>The names of one or more Regions in which you want to update parameter values for
        /// stack instances. The overridden parameter values will be applied to all stack instances in
        /// the specified accounts and Regions.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Appends an item to `parameter_overrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p> A list of input parameters whose values you want to update for the specified stack
        /// instances. </p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance update
        /// operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
        /// update the stack set template. If you add a parameter to a template, before you can
        /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
        /// parameter value specified in the stack set. Once a stack instance has been updated with the
        /// new parameter, you can then override the parameter value using
        /// <code>UpdateStackInstances</code>.</p>
        pub fn parameter_overrides(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameter_overrides.unwrap_or_default();
            v.push(input.into());
            self.parameter_overrides = Some(v);
            self
        }
        /// <p> A list of input parameters whose values you want to update for the specified stack
        /// instances. </p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance update
        /// operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
        /// update the stack set template. If you add a parameter to a template, before you can
        /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
        /// parameter value specified in the stack set. Once a stack instance has been updated with the
        /// new parameter, you can then override the parameter value using
        /// <code>UpdateStackInstances</code>.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameter_overrides = input;
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>The unique identifier for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one automatically.
        /// </p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one automatically.
        /// </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackInstancesInput`](crate::input::UpdateStackInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStackInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStackInstancesInput {
                stack_set_name: self.stack_set_name,
                accounts: self.accounts,
                deployment_targets: self.deployment_targets,
                regions: self.regions,
                parameter_overrides: self.parameter_overrides,
                operation_preferences: self.operation_preferences,
                operation_id: self.operation_id,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStackInstancesInputOperationOutputAlias = crate::operation::UpdateStackInstances;
#[doc(hidden)]
pub type UpdateStackInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStackInstancesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStackInstances`](crate::operation::UpdateStackInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStackInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStackInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStackInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStackInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_stack_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStackInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStackInstances",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStackInstancesInput`](crate::input::UpdateStackInstancesInput)
    pub fn builder() -> crate::input::update_stack_instances_input::Builder {
        crate::input::update_stack_instances_input::Builder::default()
    }
}

/// See [`UpdateStackSetInput`](crate::input::UpdateStackSetInput)
pub mod update_stack_set_input {
    /// A builder for [`UpdateStackSetInput`](crate::input::UpdateStackSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
        pub(crate) use_previous_template: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) administration_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_name: std::option::Option<std::string::String>,
        pub(crate) deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
        pub(crate) permission_model: std::option::Option<crate::model::PermissionModels>,
        pub(crate) auto_deployment: std::option::Option<crate::model::AutoDeployment>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) call_as: std::option::Option<crate::model::CallAs>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that you want to update.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that you want to update.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>A brief description of updates that you are making.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description of updates that you are making.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// <p>Use the existing template that's associated with the stack set that you're
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn use_previous_template(mut self, input: bool) -> Self {
            self.use_previous_template = Some(input);
            self
        }
        /// <p>Use the existing template that's associated with the stack set that you're
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.use_previous_template = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of input parameters for the stack set template. </p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of input parameters for the stack set template. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack set and its associated stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
        /// specifying one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability. </p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must update the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To update the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack set and its associated stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
        /// specifying one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability. </p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must update the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To update the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. You can specify a maximum number of 50 tags.</p>
        /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
        /// currently associated with this stack set. This means:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
        /// stack's tags. </p>
        /// </li>
        /// <li>
        /// <p>If you specify <i>any</i> tags using this parameter, you must
        /// specify <i>all</i> the tags that you want associated with this stack
        /// set, even tags you've specifed before (for example, when creating the stack set or
        /// during a previous update of the stack set.). Any tags that you don't include in the
        /// updated list of tags are removed from the stack set, and therefore from the stacks
        /// and resources as well. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an empty value, CloudFormation removes all currently
        /// associated tags.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you omit tags that are currently associated with the stack set from the list of tags you
        /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
        /// and checks to see if you have permission to untag resources. If you don't have the
        /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
        /// <code>access denied</code> error, and the stack set is not updated.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. You can specify a maximum number of 50 tags.</p>
        /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
        /// currently associated with this stack set. This means:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
        /// stack's tags. </p>
        /// </li>
        /// <li>
        /// <p>If you specify <i>any</i> tags using this parameter, you must
        /// specify <i>all</i> the tags that you want associated with this stack
        /// set, even tags you've specifed before (for example, when creating the stack set or
        /// during a previous update of the stack set.). Any tags that you don't include in the
        /// updated list of tags are removed from the stack set, and therefore from the stacks
        /// and resources as well. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an empty value, CloudFormation removes all currently
        /// associated tags.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you omit tags that are currently associated with the stack set from the list of tags you
        /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
        /// and checks to see if you have permission to untag resources. If you don't have the
        /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
        /// <code>access denied</code> error, and the stack set is not updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
        /// Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        /// <p>If you specified a customized administrator role when you created the stack set, you
        /// must specify a customized administrator role, even if it is the same customized
        /// administrator role used with this stack set previously.</p>
        pub fn administration_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.administration_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
        /// Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        /// <p>If you specified a customized administrator role when you created the stack set, you
        /// must specify a customized administrator role, even if it is the same customized
        /// administrator role used with this stack set previously.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administration_role_arn = input;
            self
        }
        /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets. </p>
        /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
        /// If you do not specify a customized execution role, CloudFormation performs the update using the role
        /// previously associated with the stack set, so long as you have permissions to perform
        /// operations on the stack set.</p>
        pub fn execution_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets. </p>
        /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
        /// If you do not specify a customized execution role, CloudFormation performs the update using the role
        /// previously associated with the stack set, so long as you have permissions to perform
        /// operations on the stack set.</p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_name = input;
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts in which to update
        /// associated stack instances.</p>
        /// <p>To update all the stack instances associated with this stack set, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        /// <p>If the stack set update includes changes to the template (that is, if
        /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
        /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
        /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts
        /// and Regions, while leaving all other stack instances with their existing stack instance
        /// status.</p>
        pub fn deployment_targets(mut self, input: crate::model::DeploymentTargets) -> Self {
            self.deployment_targets = Some(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts in which to update
        /// associated stack instances.</p>
        /// <p>To update all the stack instances associated with this stack set, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        /// <p>If the stack set update includes changes to the template (that is, if
        /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
        /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
        /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts
        /// and Regions, while leaving all other stack instances with their existing stack instance
        /// status.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
        /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
        /// set.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn permission_model(mut self, input: crate::model::PermissionModels) -> Self {
            self.permission_model = Some(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
        /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
        /// set.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.permission_model = input;
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
        /// Organizations accounts that are added to a target organization or organizational
        /// unit (OU).</p>
        /// <p>If you specify <code>AutoDeployment</code>, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        pub fn auto_deployment(mut self, input: crate::model::AutoDeployment) -> Self {
            self.auto_deployment = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
        /// Organizations accounts that are added to a target organization or organizational
        /// unit (OU).</p>
        /// <p>If you specify <code>AutoDeployment</code>, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.auto_deployment = input;
            self
        }
        /// <p>The unique ID for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, CloudFormation generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack
        /// instances whose status is <code>OUTDATED</code>. </p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, CloudFormation generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack
        /// instances whose status is <code>OUTDATED</code>. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
        /// If you specify accounts, you must also specify the Regions in which to update stack set
        /// instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
        /// If you specify accounts, you must also specify the Regions in which to update stack set
        /// instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
        /// must also specify accounts in which to update stack set instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
        /// must also specify accounts in which to update stack set instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, input: crate::model::CallAs) -> Self {
            self.call_as = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.call_as = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackSetInput`](crate::input::UpdateStackSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStackSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStackSetInput {
                stack_set_name: self.stack_set_name,
                description: self.description,
                template_body: self.template_body,
                template_url: self.template_url,
                use_previous_template: self.use_previous_template,
                parameters: self.parameters,
                capabilities: self.capabilities,
                tags: self.tags,
                operation_preferences: self.operation_preferences,
                administration_role_arn: self.administration_role_arn,
                execution_role_name: self.execution_role_name,
                deployment_targets: self.deployment_targets,
                permission_model: self.permission_model,
                auto_deployment: self.auto_deployment,
                operation_id: self.operation_id,
                accounts: self.accounts,
                regions: self.regions,
                call_as: self.call_as,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStackSetInputOperationOutputAlias = crate::operation::UpdateStackSet;
#[doc(hidden)]
pub type UpdateStackSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStackSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStackSet`](crate::operation::UpdateStackSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStackSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStackSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStackSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStackSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        if self.operation_id.is_none() {
            self.operation_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_stack_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStackSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStackSet",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStackSetInput`](crate::input::UpdateStackSetInput)
    pub fn builder() -> crate::input::update_stack_set_input::Builder {
        crate::input::update_stack_set_input::Builder::default()
    }
}

/// See [`UpdateTerminationProtectionInput`](crate::input::UpdateTerminationProtectionInput)
pub mod update_termination_protection_input {
    /// A builder for [`UpdateTerminationProtectionInput`](crate::input::UpdateTerminationProtectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_termination_protection: std::option::Option<bool>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether to enable termination protection on the specified stack.</p>
        pub fn enable_termination_protection(mut self, input: bool) -> Self {
            self.enable_termination_protection = Some(input);
            self
        }
        /// <p>Whether to enable termination protection on the specified stack.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_termination_protection = input;
            self
        }
        /// <p>The name or unique ID of the stack for which you want to set termination
        /// protection.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack for which you want to set termination
        /// protection.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTerminationProtectionInput`](crate::input::UpdateTerminationProtectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTerminationProtectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTerminationProtectionInput {
                enable_termination_protection: self.enable_termination_protection,
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTerminationProtectionInputOperationOutputAlias =
    crate::operation::UpdateTerminationProtection;
#[doc(hidden)]
pub type UpdateTerminationProtectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTerminationProtectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTerminationProtection`](crate::operation::UpdateTerminationProtection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTerminationProtection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTerminationProtectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTerminationProtectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTerminationProtectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_termination_protection(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTerminationProtection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTerminationProtection",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTerminationProtectionInput`](crate::input::UpdateTerminationProtectionInput)
    pub fn builder() -> crate::input::update_termination_protection_input::Builder {
        crate::input::update_termination_protection_input::Builder::default()
    }
}

/// See [`ValidateTemplateInput`](crate::input::ValidateTemplateInput)
pub mod validate_template_input {
    /// A builder for [`ValidateTemplateInput`](crate::input::ValidateTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateTemplateInput`](crate::input::ValidateTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidateTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidateTemplateInput {
                template_body: self.template_body,
                template_url: self.template_url,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidateTemplateInputOperationOutputAlias = crate::operation::ValidateTemplate;
#[doc(hidden)]
pub type ValidateTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ValidateTemplateInput {
    /// Consumes the builder and constructs an Operation<[`ValidateTemplate`](crate::operation::ValidateTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidateTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ValidateTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ValidateTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ValidateTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_validate_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidateTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidateTemplate",
            "cloudformation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ValidateTemplateInput`](crate::input::ValidateTemplateInput)
    pub fn builder() -> crate::input::validate_template_input::Builder {
        crate::input::validate_template_input::Builder::default()
    }
}

/// <p>The input for <a>ValidateTemplate</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateTemplateInput {
    /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
    /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
    /// both are passed, only <code>TemplateBody</code> is used.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>Location of file containing the template body. The URL must point to a template (max
    /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
    /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
    /// both are passed, only <code>TemplateBody</code> is used.</p>
    pub template_url: std::option::Option<std::string::String>,
}
impl ValidateTemplateInput {
    /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
    /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
    /// both are passed, only <code>TemplateBody</code> is used.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>Location of file containing the template body. The URL must point to a template (max
    /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
    /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
    /// both are passed, only <code>TemplateBody</code> is used.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
}
impl std::fmt::Debug for ValidateTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateTemplateInput");
        formatter.field("template_body", &self.template_body);
        formatter.field("template_url", &self.template_url);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTerminationProtectionInput {
    /// <p>Whether to enable termination protection on the specified stack.</p>
    pub enable_termination_protection: std::option::Option<bool>,
    /// <p>The name or unique ID of the stack for which you want to set termination
    /// protection.</p>
    pub stack_name: std::option::Option<std::string::String>,
}
impl UpdateTerminationProtectionInput {
    /// <p>Whether to enable termination protection on the specified stack.</p>
    pub fn enable_termination_protection(&self) -> std::option::Option<bool> {
        self.enable_termination_protection
    }
    /// <p>The name or unique ID of the stack for which you want to set termination
    /// protection.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateTerminationProtectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTerminationProtectionInput");
        formatter.field(
            "enable_termination_protection",
            &self.enable_termination_protection,
        );
        formatter.field("stack_name", &self.stack_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackSetInput {
    /// <p>The name or unique ID of the stack set that you want to update.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>A brief description of updates that you are making.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
    /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The location of the file that contains the template body. The URL must point to a
    /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
    /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true. </p>
    pub template_url: std::option::Option<std::string::String>,
    /// <p>Use the existing template that's associated with the stack set that you're
    /// updating.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true. </p>
    pub use_previous_template: std::option::Option<bool>,
    /// <p>A list of input parameters for the stack set template. </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
    /// capabilities in order for CloudFormation to update the stack set and its associated stack
    /// instances.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
    /// </p>
    /// <p>Some stack templates might include resources that can affect permissions in
    /// your Amazon Web Services account; for example, by creating new Identity and Access Management
    /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
    /// specifying one of these capabilities.</p>
    /// <p>The following IAM resources require you to specify either the
    /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
    /// capability.</p>
    /// <ul>
    /// <li>
    /// <p>If you have IAM resources, you can specify either capability. </p>
    /// </li>
    /// <li>
    /// <p>If you have IAM resources with custom names, you <i>must</i>
    /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
    /// </li>
    /// <li>
    /// <p>If you don't specify either of these capabilities, CloudFormation returns an
    /// <code>InsufficientCapabilities</code> error.</p>
    /// </li>
    /// </ul>
    /// <p>If your stack template contains these resources, we recommend that you review
    /// all permissions associated with them and edit their permissions if
    /// necessary.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
    /// AWS::IAM::AccessKey</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
    /// AWS::IAM::Group</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
    /// AWS::IAM::Policy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
    /// AWS::IAM::Role</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
    /// AWS::IAM::User</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
    /// Resources in CloudFormation Templates</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_AUTO_EXPAND</code>
    /// </p>
    /// <p>Some templates reference macros. If your stack set template references one or more
    /// macros, you must update the stack set directly from the processed template, without
    /// first reviewing the resulting changes in a change set. To update the stack set
    /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
    /// Perform Custom Processing on Templates</a>.</p>
    /// <important>
    /// <p>Stack sets with service-managed permissions do not currently support the use of
    /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
    /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
    /// for a stack set with service-managed permissions, if you reference a macro in your
    /// template the stack set operation will fail.</p>
    /// </important>
    /// </li>
    /// </ul>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
    /// CloudFormation also propagates these tags to supported resources that are created in
    /// the stacks. You can specify a maximum number of 50 tags.</p>
    /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
    /// currently associated with this stack set. This means:</p>
    /// <ul>
    /// <li>
    /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
    /// stack's tags. </p>
    /// </li>
    /// <li>
    /// <p>If you specify <i>any</i> tags using this parameter, you must
    /// specify <i>all</i> the tags that you want associated with this stack
    /// set, even tags you've specifed before (for example, when creating the stack set or
    /// during a previous update of the stack set.). Any tags that you don't include in the
    /// updated list of tags are removed from the stack set, and therefore from the stacks
    /// and resources as well. </p>
    /// </li>
    /// <li>
    /// <p>If you specify an empty value, CloudFormation removes all currently
    /// associated tags.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
    /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
    /// you omit tags that are currently associated with the stack set from the list of tags you
    /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
    /// and checks to see if you have permission to untag resources. If you don't have the
    /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
    /// <code>access denied</code> error, and the stack set is not updated.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
    pub operation_preferences: std::option::Option<crate::model::StackSetOperationPreferences>,
    /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
    /// <p>Specify an IAM role only if you are using customized administrator roles to control
    /// which users or groups can manage specific stack sets within the same administrator account.
    /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
    /// Permissions for Stack Set Operations</a> in the
    /// <i>CloudFormation User Guide</i>.</p>
    /// <p>If you specified a customized administrator role when you created the stack set, you
    /// must specify a customized administrator role, even if it is the same customized
    /// administrator role used with this stack set previously.</p>
    pub administration_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
    /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
    /// for the stack set operation.</p>
    /// <p>Specify an IAM role only if you are using customized execution roles to control which
    /// stack resources users and groups can include in their stack sets. </p>
    /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
    /// If you do not specify a customized execution role, CloudFormation performs the update using the role
    /// previously associated with the stack set, so long as you have permissions to perform
    /// operations on the stack set.</p>
    pub execution_role_name: std::option::Option<std::string::String>,
    /// <p>[Service-managed permissions] The Organizations accounts in which to update
    /// associated stack instances.</p>
    /// <p>To update all the stack instances associated with this stack set, do not specify
    /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
    /// <p>If the stack set update includes changes to the template (that is, if
    /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
    /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
    /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts
    /// and Regions, while leaving all other stack instances with their existing stack instance
    /// status.</p>
    pub deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
    /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
    /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
    /// set.</p>
    /// <ul>
    /// <li>
    /// <p>With <code>self-managed</code> permissions, you must create the administrator and
    /// execution roles required to deploy to target accounts. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
    /// Self-Managed Stack Set Permissions</a>.</p>
    /// </li>
    /// <li>
    /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
    /// IAM roles required to deploy to accounts managed by Organizations. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
    /// </li>
    /// </ul>
    pub permission_model: std::option::Option<crate::model::PermissionModels>,
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
    /// Organizations accounts that are added to a target organization or organizational
    /// unit (OU).</p>
    /// <p>If you specify <code>AutoDeployment</code>, do not specify
    /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
    pub auto_deployment: std::option::Option<crate::model::AutoDeployment>,
    /// <p>The unique ID for this stack set operation. </p>
    /// <p>The operation ID also functions as an idempotency token, to ensure that
    /// CloudFormation performs the stack set operation only once, even if you retry the request
    /// multiple times. You might retry stack set operation requests to ensure that
    /// CloudFormation successfully received them.</p>
    /// <p>If you don't specify an operation ID, CloudFormation generates one
    /// automatically.</p>
    /// <p>Repeating this stack set operation with a new operation ID retries all stack
    /// instances whose status is <code>OUTDATED</code>. </p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
    /// If you specify accounts, you must also specify the Regions in which to update stack set
    /// instances.</p>
    /// <p>To update <i>all</i> the stack instances associated with this stack set,
    /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
    /// <p>If the stack set update includes changes to the template (that is, if the
    /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
    /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
    /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
    /// leaving all other stack instances with their existing stack instance status. </p>
    pub accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
    /// must also specify accounts in which to update stack set instances.</p>
    /// <p>To update <i>all</i> the stack instances associated with this stack set,
    /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
    /// <p>If the stack set update includes changes to the template (that is, if the
    /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
    /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
    /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
    /// leaving all other stack instances with their existing stack instance status. </p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl UpdateStackSetInput {
    /// <p>The name or unique ID of the stack set that you want to update.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>A brief description of updates that you are making.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
    /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The location of the file that contains the template body. The URL must point to a
    /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
    /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true. </p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
    /// <p>Use the existing template that's associated with the stack set that you're
    /// updating.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
    /// <code>UsePreviousTemplate</code> to true. </p>
    pub fn use_previous_template(&self) -> std::option::Option<bool> {
        self.use_previous_template
    }
    /// <p>A list of input parameters for the stack set template. </p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
    /// capabilities in order for CloudFormation to update the stack set and its associated stack
    /// instances.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
    /// </p>
    /// <p>Some stack templates might include resources that can affect permissions in
    /// your Amazon Web Services account; for example, by creating new Identity and Access Management
    /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
    /// specifying one of these capabilities.</p>
    /// <p>The following IAM resources require you to specify either the
    /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
    /// capability.</p>
    /// <ul>
    /// <li>
    /// <p>If you have IAM resources, you can specify either capability. </p>
    /// </li>
    /// <li>
    /// <p>If you have IAM resources with custom names, you <i>must</i>
    /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
    /// </li>
    /// <li>
    /// <p>If you don't specify either of these capabilities, CloudFormation returns an
    /// <code>InsufficientCapabilities</code> error.</p>
    /// </li>
    /// </ul>
    /// <p>If your stack template contains these resources, we recommend that you review
    /// all permissions associated with them and edit their permissions if
    /// necessary.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
    /// AWS::IAM::AccessKey</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
    /// AWS::IAM::Group</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
    /// AWS::IAM::Policy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
    /// AWS::IAM::Role</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
    /// AWS::IAM::User</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
    /// Resources in CloudFormation Templates</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_AUTO_EXPAND</code>
    /// </p>
    /// <p>Some templates reference macros. If your stack set template references one or more
    /// macros, you must update the stack set directly from the processed template, without
    /// first reviewing the resulting changes in a change set. To update the stack set
    /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
    /// Perform Custom Processing on Templates</a>.</p>
    /// <important>
    /// <p>Stack sets with service-managed permissions do not currently support the use of
    /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
    /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
    /// for a stack set with service-managed permissions, if you reference a macro in your
    /// template the stack set operation will fail.</p>
    /// </important>
    /// </li>
    /// </ul>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.capabilities.as_deref()
    }
    /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
    /// CloudFormation also propagates these tags to supported resources that are created in
    /// the stacks. You can specify a maximum number of 50 tags.</p>
    /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
    /// currently associated with this stack set. This means:</p>
    /// <ul>
    /// <li>
    /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
    /// stack's tags. </p>
    /// </li>
    /// <li>
    /// <p>If you specify <i>any</i> tags using this parameter, you must
    /// specify <i>all</i> the tags that you want associated with this stack
    /// set, even tags you've specifed before (for example, when creating the stack set or
    /// during a previous update of the stack set.). Any tags that you don't include in the
    /// updated list of tags are removed from the stack set, and therefore from the stacks
    /// and resources as well. </p>
    /// </li>
    /// <li>
    /// <p>If you specify an empty value, CloudFormation removes all currently
    /// associated tags.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
    /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
    /// you omit tags that are currently associated with the stack set from the list of tags you
    /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
    /// and checks to see if you have permission to untag resources. If you don't have the
    /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
    /// <code>access denied</code> error, and the stack set is not updated.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
    pub fn operation_preferences(
        &self,
    ) -> std::option::Option<&crate::model::StackSetOperationPreferences> {
        self.operation_preferences.as_ref()
    }
    /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
    /// <p>Specify an IAM role only if you are using customized administrator roles to control
    /// which users or groups can manage specific stack sets within the same administrator account.
    /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
    /// Permissions for Stack Set Operations</a> in the
    /// <i>CloudFormation User Guide</i>.</p>
    /// <p>If you specified a customized administrator role when you created the stack set, you
    /// must specify a customized administrator role, even if it is the same customized
    /// administrator role used with this stack set previously.</p>
    pub fn administration_role_arn(&self) -> std::option::Option<&str> {
        self.administration_role_arn.as_deref()
    }
    /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
    /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
    /// for the stack set operation.</p>
    /// <p>Specify an IAM role only if you are using customized execution roles to control which
    /// stack resources users and groups can include in their stack sets. </p>
    /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
    /// If you do not specify a customized execution role, CloudFormation performs the update using the role
    /// previously associated with the stack set, so long as you have permissions to perform
    /// operations on the stack set.</p>
    pub fn execution_role_name(&self) -> std::option::Option<&str> {
        self.execution_role_name.as_deref()
    }
    /// <p>[Service-managed permissions] The Organizations accounts in which to update
    /// associated stack instances.</p>
    /// <p>To update all the stack instances associated with this stack set, do not specify
    /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
    /// <p>If the stack set update includes changes to the template (that is, if
    /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
    /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
    /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts
    /// and Regions, while leaving all other stack instances with their existing stack instance
    /// status.</p>
    pub fn deployment_targets(&self) -> std::option::Option<&crate::model::DeploymentTargets> {
        self.deployment_targets.as_ref()
    }
    /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
    /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
    /// set.</p>
    /// <ul>
    /// <li>
    /// <p>With <code>self-managed</code> permissions, you must create the administrator and
    /// execution roles required to deploy to target accounts. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
    /// Self-Managed Stack Set Permissions</a>.</p>
    /// </li>
    /// <li>
    /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
    /// IAM roles required to deploy to accounts managed by Organizations. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
    /// </li>
    /// </ul>
    pub fn permission_model(&self) -> std::option::Option<&crate::model::PermissionModels> {
        self.permission_model.as_ref()
    }
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
    /// Organizations accounts that are added to a target organization or organizational
    /// unit (OU).</p>
    /// <p>If you specify <code>AutoDeployment</code>, do not specify
    /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
    pub fn auto_deployment(&self) -> std::option::Option<&crate::model::AutoDeployment> {
        self.auto_deployment.as_ref()
    }
    /// <p>The unique ID for this stack set operation. </p>
    /// <p>The operation ID also functions as an idempotency token, to ensure that
    /// CloudFormation performs the stack set operation only once, even if you retry the request
    /// multiple times. You might retry stack set operation requests to ensure that
    /// CloudFormation successfully received them.</p>
    /// <p>If you don't specify an operation ID, CloudFormation generates one
    /// automatically.</p>
    /// <p>Repeating this stack set operation with a new operation ID retries all stack
    /// instances whose status is <code>OUTDATED</code>. </p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
    /// If you specify accounts, you must also specify the Regions in which to update stack set
    /// instances.</p>
    /// <p>To update <i>all</i> the stack instances associated with this stack set,
    /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
    /// <p>If the stack set update includes changes to the template (that is, if the
    /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
    /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
    /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
    /// leaving all other stack instances with their existing stack instance status. </p>
    pub fn accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.accounts.as_deref()
    }
    /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
    /// must also specify accounts in which to update stack set instances.</p>
    /// <p>To update <i>all</i> the stack instances associated with this stack set,
    /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
    /// <p>If the stack set update includes changes to the template (that is, if the
    /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
    /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
    /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
    /// and Regions. If the stack set update does not include changes to the template or
    /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
    /// leaving all other stack instances with their existing stack instance status. </p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for UpdateStackSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackSetInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("description", &self.description);
        formatter.field("template_body", &self.template_body);
        formatter.field("template_url", &self.template_url);
        formatter.field("use_previous_template", &self.use_previous_template);
        formatter.field("parameters", &self.parameters);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("tags", &self.tags);
        formatter.field("operation_preferences", &self.operation_preferences);
        formatter.field("administration_role_arn", &self.administration_role_arn);
        formatter.field("execution_role_name", &self.execution_role_name);
        formatter.field("deployment_targets", &self.deployment_targets);
        formatter.field("permission_model", &self.permission_model);
        formatter.field("auto_deployment", &self.auto_deployment);
        formatter.field("operation_id", &self.operation_id);
        formatter.field("accounts", &self.accounts);
        formatter.field("regions", &self.regions);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackInstancesInput {
    /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
    /// for stack instances. The overridden parameter values will be applied to all stack instances
    /// in the specified accounts and Regions.</p>
    /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
    pub accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>[Service-managed permissions] The Organizations accounts for which you want to
    /// update parameter values for stack instances. If your update targets OUs, the overridden
    /// parameter values only apply to the accounts that are currently in the target OUs and their
    /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
    /// overridden values.</p>
    /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
    /// both.</p>
    pub deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
    /// <p>The names of one or more Regions in which you want to update parameter values for
    /// stack instances. The overridden parameter values will be applied to all stack instances in
    /// the specified accounts and Regions.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A list of input parameters whose values you want to update for the specified stack
    /// instances. </p>
    /// <p>Any overridden parameter values will be applied to all stack instances in the
    /// specified accounts and Regions. When specifying parameters and their values, be aware of
    /// how CloudFormation sets parameter values during stack instance update
    /// operations:</p>
    /// <ul>
    /// <li>
    /// <p>To override the current value for a parameter, include the parameter and
    /// specify its value.</p>
    /// </li>
    /// <li>
    /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
    /// <code>true</code>. (You cannot specify both a value and set
    /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
    /// </li>
    /// <li>
    /// <p>To set an overridden parameter back to the value specified in the stack set,
    /// specify a parameter list but do not include the parameter in the list.</p>
    /// </li>
    /// <li>
    /// <p>To leave all parameters set to their present values, do not specify this
    /// property at all.</p>
    /// </li>
    /// </ul>
    /// <p>During stack set updates, any parameter values overridden for a stack instance are
    /// not updated, but retain their overridden value.</p>
    /// <p>You can only override the parameter <i>values</i> that are specified in
    /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
    /// update the stack set template. If you add a parameter to a template, before you can
    /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
    /// parameter value specified in the stack set. Once a stack instance has been updated with the
    /// new parameter, you can then override the parameter value using
    /// <code>UpdateStackInstances</code>.</p>
    pub parameter_overrides: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
    pub operation_preferences: std::option::Option<crate::model::StackSetOperationPreferences>,
    /// <p>The unique identifier for this stack set operation. </p>
    /// <p>The operation ID also functions as an idempotency token, to ensure that
    /// CloudFormation performs the stack set operation only once, even if you retry the request
    /// multiple times. You might retry stack set operation requests to ensure that
    /// CloudFormation successfully received them.</p>
    /// <p>If you don't specify an operation ID, the SDK generates one automatically.
    /// </p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl UpdateStackInstancesInput {
    /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
    /// for stack instances. The overridden parameter values will be applied to all stack instances
    /// in the specified accounts and Regions.</p>
    /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
    pub fn accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.accounts.as_deref()
    }
    /// <p>[Service-managed permissions] The Organizations accounts for which you want to
    /// update parameter values for stack instances. If your update targets OUs, the overridden
    /// parameter values only apply to the accounts that are currently in the target OUs and their
    /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
    /// overridden values.</p>
    /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
    /// both.</p>
    pub fn deployment_targets(&self) -> std::option::Option<&crate::model::DeploymentTargets> {
        self.deployment_targets.as_ref()
    }
    /// <p>The names of one or more Regions in which you want to update parameter values for
    /// stack instances. The overridden parameter values will be applied to all stack instances in
    /// the specified accounts and Regions.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
    /// <p> A list of input parameters whose values you want to update for the specified stack
    /// instances. </p>
    /// <p>Any overridden parameter values will be applied to all stack instances in the
    /// specified accounts and Regions. When specifying parameters and their values, be aware of
    /// how CloudFormation sets parameter values during stack instance update
    /// operations:</p>
    /// <ul>
    /// <li>
    /// <p>To override the current value for a parameter, include the parameter and
    /// specify its value.</p>
    /// </li>
    /// <li>
    /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
    /// <code>true</code>. (You cannot specify both a value and set
    /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
    /// </li>
    /// <li>
    /// <p>To set an overridden parameter back to the value specified in the stack set,
    /// specify a parameter list but do not include the parameter in the list.</p>
    /// </li>
    /// <li>
    /// <p>To leave all parameters set to their present values, do not specify this
    /// property at all.</p>
    /// </li>
    /// </ul>
    /// <p>During stack set updates, any parameter values overridden for a stack instance are
    /// not updated, but retain their overridden value.</p>
    /// <p>You can only override the parameter <i>values</i> that are specified in
    /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
    /// update the stack set template. If you add a parameter to a template, before you can
    /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
    /// parameter value specified in the stack set. Once a stack instance has been updated with the
    /// new parameter, you can then override the parameter value using
    /// <code>UpdateStackInstances</code>.</p>
    pub fn parameter_overrides(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameter_overrides.as_deref()
    }
    /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
    pub fn operation_preferences(
        &self,
    ) -> std::option::Option<&crate::model::StackSetOperationPreferences> {
        self.operation_preferences.as_ref()
    }
    /// <p>The unique identifier for this stack set operation. </p>
    /// <p>The operation ID also functions as an idempotency token, to ensure that
    /// CloudFormation performs the stack set operation only once, even if you retry the request
    /// multiple times. You might retry stack set operation requests to ensure that
    /// CloudFormation successfully received them.</p>
    /// <p>If you don't specify an operation ID, the SDK generates one automatically.
    /// </p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for UpdateStackInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackInstancesInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("accounts", &self.accounts);
        formatter.field("deployment_targets", &self.deployment_targets);
        formatter.field("regions", &self.regions);
        formatter.field("parameter_overrides", &self.parameter_overrides);
        formatter.field("operation_preferences", &self.operation_preferences);
        formatter.field("operation_id", &self.operation_id);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

/// <p>The input for an <a>UpdateStack</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackInput {
    /// <p>The name or unique stack ID of the stack to update.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
    /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.)</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>Location of file containing the template body. The URL must point to a template that
    /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub template_url: std::option::Option<std::string::String>,
    /// <p>Reuse the existing template that is associated with the stack that you are
    /// updating.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub use_previous_template: std::option::Option<bool>,
    /// <p>Structure containing the temporary overriding stack policy body. You can specify
    /// either the <code>StackPolicyDuringUpdateBody</code> or the
    /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
    /// <p>If you want to update protected resources, specify a temporary overriding stack
    /// policy during this update. If you do not specify a stack policy, the current policy that is
    /// associated with the stack will be used.</p>
    pub stack_policy_during_update_body: std::option::Option<std::string::String>,
    /// <p>Location of a file containing the temporary overriding stack policy. The URL must
    /// point to a policy (max size: 16KB) located in an S3 bucket in
    /// the same Region as the stack. You can specify either the
    /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
    /// parameter, but not both.</p>
    /// <p>If you want to update protected resources, specify a temporary overriding stack
    /// policy during this update. If you do not specify a stack policy, the current policy that is
    /// associated with the stack will be used.</p>
    pub stack_policy_during_update_url: std::option::Option<std::string::String>,
    /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
    /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
    /// type.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
    /// capabilities in order for CloudFormation to update the stack.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
    /// </p>
    /// <p>Some stack templates might include resources that can affect permissions in
    /// your Amazon Web Services account; for example, by creating new Identity and Access Management
    /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
    /// of these capabilities.</p>
    /// <p>The following IAM resources require you to specify either the
    /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
    /// capability.</p>
    /// <ul>
    /// <li>
    /// <p>If you have IAM resources, you can specify either capability.</p>
    /// </li>
    /// <li>
    /// <p>If you have IAM resources with custom names, you <i>must</i>
    /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you don't specify either of these capabilities, CloudFormation returns an
    /// <code>InsufficientCapabilities</code> error.</p>
    /// </li>
    /// </ul>
    /// <p>If your stack template contains these resources, we recommend that you review
    /// all permissions associated with them and edit their permissions if
    /// necessary.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
    /// AWS::IAM::AccessKey</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
    /// AWS::IAM::Group</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
    /// AWS::IAM::Policy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
    /// AWS::IAM::Role</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
    /// AWS::IAM::User</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
    /// Resources in CloudFormation Templates</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_AUTO_EXPAND</code>
    /// </p>
    /// <p>Some template contain macros. Macros perform custom processing on templates; this
    /// can include simple actions like find-and-replace operations, all the way to extensive
    /// transformations of entire templates. Because of this, users typically create a change
    /// set from the processed template, so that they can review the changes resulting from
    /// the macros before actually updating the stack. If your stack template contains one or
    /// more macros, and you choose to update a stack directly from the processed template,
    /// without first reviewing the resulting changes in a change set, you must acknowledge
    /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
    /// <p>If you want to update a stack from a stack template that contains macros
    /// <i>and</i> nested stacks, you must update the stack directly from
    /// the template using this capability.</p>
    /// <important>
    /// <p>You should only update stacks directly from a stack template that contains
    /// macros if you know what processing the macro performs.</p>
    /// <p>Each macro relies on an underlying Lambda service function for processing stack
    /// templates. Be aware that the Lambda function owner can update the function
    /// operation without CloudFormation being notified.</p>
    /// </important>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
    /// CloudFormation Macros to Perform Custom Processing on
    /// Templates</a>.</p>
    /// </li>
    /// </ul>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>The template resource types that you have permissions to work with for this update
    /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
    /// <code>Custom::MyCustomInstance</code>.</p>
    /// <p>If the list of resource types doesn't include a resource that you're updating, the
    /// stack update fails. By default, CloudFormation grants permissions to all resource
    /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
    pub resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
    /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
    /// credentials to make calls on your behalf. CloudFormation always uses this role for all
    /// future operations on the stack. As long as users have permission to operate on the stack,
    /// CloudFormation uses this role even if the users don't have permission to pass it.
    /// Ensure that the role grants least privilege.</p>
    /// <p>If you don't specify a value, CloudFormation uses the role that was previously
    /// associated with the stack. If no role is available, CloudFormation uses a temporary
    /// session that is generated from your user credentials.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
    /// updating operations, and for the specified monitoring period afterwards.</p>
    pub rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
    /// <p>Structure containing a new stack policy body. You can specify either the
    /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
    /// both.</p>
    /// <p>You might update the stack policy, for example, in order to protect a new resource
    /// that you created during a stack update. If you do not specify a stack policy, the current
    /// policy that is associated with the stack is unchanged.</p>
    pub stack_policy_body: std::option::Option<std::string::String>,
    /// <p>Location of a file containing the updated stack policy. The URL must point to a
    /// policy (max size: 16KB) located in an S3 bucket in the same
    /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
    /// <code>StackPolicyURL</code> parameter, but not both.</p>
    /// <p>You might update the stack policy, for example, in order to protect a new resource
    /// that you created during a stack update. If you do not specify a stack policy, the current
    /// policy that is associated with the stack is unchanged.</p>
    pub stack_policy_url: std::option::Option<std::string::String>,
    /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
    /// CloudFormation associates with the stack. Specify an empty list to remove all notification
    /// topics.</p>
    pub notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
    /// these tags to supported resources in the stack. You can specify a maximum number of 50
    /// tags.</p>
    /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
    /// tags. If you specify an empty value, CloudFormation removes all associated
    /// tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
    /// <p>Default: <code>False</code>
    /// </p>
    pub disable_rollback: std::option::Option<bool>,
    /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
    /// you plan to retry requests so that CloudFormation knows that you're not attempting to
    /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
    /// ensure that CloudFormation successfully received them.</p>
    /// <p>All events triggered by a given stack operation are assigned the same client request
    /// token, which you can use to track operations. For example, if you execute a
    /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
    /// <code>StackEvents</code> generated by that operation will have
    /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
    /// <p>In the console, stack operations display the client request token on the Events tab.
    /// Stack operations that are initiated from the console use the token format
    /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
    /// stack operation . For example, if you create a stack using the console, each stack event
    /// would be assigned the same token in the following format:
    /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl UpdateStackInput {
    /// <p>The name or unique stack ID of the stack to update.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
    /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.)</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>Location of file containing the template body. The URL must point to a template that
    /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
    /// in the CloudFormation User Guide.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
    /// <p>Reuse the existing template that is associated with the stack that you are
    /// updating.</p>
    /// <p>Conditional: You must specify only one of the following parameters:
    /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
    /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
    pub fn use_previous_template(&self) -> std::option::Option<bool> {
        self.use_previous_template
    }
    /// <p>Structure containing the temporary overriding stack policy body. You can specify
    /// either the <code>StackPolicyDuringUpdateBody</code> or the
    /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
    /// <p>If you want to update protected resources, specify a temporary overriding stack
    /// policy during this update. If you do not specify a stack policy, the current policy that is
    /// associated with the stack will be used.</p>
    pub fn stack_policy_during_update_body(&self) -> std::option::Option<&str> {
        self.stack_policy_during_update_body.as_deref()
    }
    /// <p>Location of a file containing the temporary overriding stack policy. The URL must
    /// point to a policy (max size: 16KB) located in an S3 bucket in
    /// the same Region as the stack. You can specify either the
    /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
    /// parameter, but not both.</p>
    /// <p>If you want to update protected resources, specify a temporary overriding stack
    /// policy during this update. If you do not specify a stack policy, the current policy that is
    /// associated with the stack will be used.</p>
    pub fn stack_policy_during_update_url(&self) -> std::option::Option<&str> {
        self.stack_policy_during_update_url.as_deref()
    }
    /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
    /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
    /// type.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
    /// capabilities in order for CloudFormation to update the stack.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
    /// </p>
    /// <p>Some stack templates might include resources that can affect permissions in
    /// your Amazon Web Services account; for example, by creating new Identity and Access Management
    /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
    /// of these capabilities.</p>
    /// <p>The following IAM resources require you to specify either the
    /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
    /// capability.</p>
    /// <ul>
    /// <li>
    /// <p>If you have IAM resources, you can specify either capability.</p>
    /// </li>
    /// <li>
    /// <p>If you have IAM resources with custom names, you <i>must</i>
    /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you don't specify either of these capabilities, CloudFormation returns an
    /// <code>InsufficientCapabilities</code> error.</p>
    /// </li>
    /// </ul>
    /// <p>If your stack template contains these resources, we recommend that you review
    /// all permissions associated with them and edit their permissions if
    /// necessary.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
    /// AWS::IAM::AccessKey</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
    /// AWS::IAM::Group</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
    /// AWS::IAM::Policy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
    /// AWS::IAM::Role</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
    /// AWS::IAM::User</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
    /// Resources in CloudFormation Templates</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPABILITY_AUTO_EXPAND</code>
    /// </p>
    /// <p>Some template contain macros. Macros perform custom processing on templates; this
    /// can include simple actions like find-and-replace operations, all the way to extensive
    /// transformations of entire templates. Because of this, users typically create a change
    /// set from the processed template, so that they can review the changes resulting from
    /// the macros before actually updating the stack. If your stack template contains one or
    /// more macros, and you choose to update a stack directly from the processed template,
    /// without first reviewing the resulting changes in a change set, you must acknowledge
    /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
    /// <p>If you want to update a stack from a stack template that contains macros
    /// <i>and</i> nested stacks, you must update the stack directly from
    /// the template using this capability.</p>
    /// <important>
    /// <p>You should only update stacks directly from a stack template that contains
    /// macros if you know what processing the macro performs.</p>
    /// <p>Each macro relies on an underlying Lambda service function for processing stack
    /// templates. Be aware that the Lambda function owner can update the function
    /// operation without CloudFormation being notified.</p>
    /// </important>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
    /// CloudFormation Macros to Perform Custom Processing on
    /// Templates</a>.</p>
    /// </li>
    /// </ul>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.capabilities.as_deref()
    }
    /// <p>The template resource types that you have permissions to work with for this update
    /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
    /// <code>Custom::MyCustomInstance</code>.</p>
    /// <p>If the list of resource types doesn't include a resource that you're updating, the
    /// stack update fails. By default, CloudFormation grants permissions to all resource
    /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
    pub fn resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
    /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
    /// credentials to make calls on your behalf. CloudFormation always uses this role for all
    /// future operations on the stack. As long as users have permission to operate on the stack,
    /// CloudFormation uses this role even if the users don't have permission to pass it.
    /// Ensure that the role grants least privilege.</p>
    /// <p>If you don't specify a value, CloudFormation uses the role that was previously
    /// associated with the stack. If no role is available, CloudFormation uses a temporary
    /// session that is generated from your user credentials.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
    /// updating operations, and for the specified monitoring period afterwards.</p>
    pub fn rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RollbackConfiguration> {
        self.rollback_configuration.as_ref()
    }
    /// <p>Structure containing a new stack policy body. You can specify either the
    /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
    /// both.</p>
    /// <p>You might update the stack policy, for example, in order to protect a new resource
    /// that you created during a stack update. If you do not specify a stack policy, the current
    /// policy that is associated with the stack is unchanged.</p>
    pub fn stack_policy_body(&self) -> std::option::Option<&str> {
        self.stack_policy_body.as_deref()
    }
    /// <p>Location of a file containing the updated stack policy. The URL must point to a
    /// policy (max size: 16KB) located in an S3 bucket in the same
    /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
    /// <code>StackPolicyURL</code> parameter, but not both.</p>
    /// <p>You might update the stack policy, for example, in order to protect a new resource
    /// that you created during a stack update. If you do not specify a stack policy, the current
    /// policy that is associated with the stack is unchanged.</p>
    pub fn stack_policy_url(&self) -> std::option::Option<&str> {
        self.stack_policy_url.as_deref()
    }
    /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
    /// CloudFormation associates with the stack. Specify an empty list to remove all notification
    /// topics.</p>
    pub fn notification_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.notification_ar_ns.as_deref()
    }
    /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
    /// these tags to supported resources in the stack. You can specify a maximum number of 50
    /// tags.</p>
    /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
    /// tags. If you specify an empty value, CloudFormation removes all associated
    /// tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
    /// <p>Default: <code>False</code>
    /// </p>
    pub fn disable_rollback(&self) -> std::option::Option<bool> {
        self.disable_rollback
    }
    /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
    /// you plan to retry requests so that CloudFormation knows that you're not attempting to
    /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
    /// ensure that CloudFormation successfully received them.</p>
    /// <p>All events triggered by a given stack operation are assigned the same client request
    /// token, which you can use to track operations. For example, if you execute a
    /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
    /// <code>StackEvents</code> generated by that operation will have
    /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
    /// <p>In the console, stack operations display the client request token on the Events tab.
    /// Stack operations that are initiated from the console use the token format
    /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
    /// stack operation . For example, if you create a stack using the console, each stack event
    /// would be assigned the same token in the following format:
    /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("template_body", &self.template_body);
        formatter.field("template_url", &self.template_url);
        formatter.field("use_previous_template", &self.use_previous_template);
        formatter.field(
            "stack_policy_during_update_body",
            &self.stack_policy_during_update_body,
        );
        formatter.field(
            "stack_policy_during_update_url",
            &self.stack_policy_during_update_url,
        );
        formatter.field("parameters", &self.parameters);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("resource_types", &self.resource_types);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("rollback_configuration", &self.rollback_configuration);
        formatter.field("stack_policy_body", &self.stack_policy_body);
        formatter.field("stack_policy_url", &self.stack_policy_url);
        formatter.field("notification_ar_ns", &self.notification_ar_ns);
        formatter.field("tags", &self.tags);
        formatter.field("disable_rollback", &self.disable_rollback);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestTypeInput {
    /// <p>The Amazon Resource Number (ARN) of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of the extension to test.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub r#type: std::option::Option<crate::model::ThirdPartyType>,
    /// <p>The name of the extension to test.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The version of the extension to test.</p>
    /// <p>You can specify the version id with either <code>Arn</code>, or with
    /// <code>TypeName</code> and <code>Type</code>.</p>
    /// <p>If you do not specify a version, CloudFormation uses the default version of the
    /// extension in this account and region for testing.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
    /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
    /// extension has been assigned a test type status of <code>PASSED</code> or
    /// <code>FAILED</code>.</p>
    /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
    /// bucket. Specifically, the user needs the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>GetObject</p>
    /// </li>
    /// <li>
    /// <p>PutObject</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
    /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
    /// Access Management User Guide</i>.</p>
    pub log_delivery_bucket: std::option::Option<std::string::String>,
}
impl TestTypeInput {
    /// <p>The Amazon Resource Number (ARN) of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of the extension to test.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThirdPartyType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension to test.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The version of the extension to test.</p>
    /// <p>You can specify the version id with either <code>Arn</code>, or with
    /// <code>TypeName</code> and <code>Type</code>.</p>
    /// <p>If you do not specify a version, CloudFormation uses the default version of the
    /// extension in this account and region for testing.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
    /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
    /// extension has been assigned a test type status of <code>PASSED</code> or
    /// <code>FAILED</code>.</p>
    /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
    /// bucket. Specifically, the user needs the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>GetObject</p>
    /// </li>
    /// <li>
    /// <p>PutObject</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
    /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
    /// Access Management User Guide</i>.</p>
    pub fn log_delivery_bucket(&self) -> std::option::Option<&str> {
        self.log_delivery_bucket.as_deref()
    }
}
impl std::fmt::Debug for TestTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestTypeInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("version_id", &self.version_id);
        formatter.field("log_delivery_bucket", &self.log_delivery_bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopStackSetOperationInput {
    /// <p>The name or unique ID of the stack set that you want to stop the operation
    /// for.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>The ID of the stack operation. </p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl StopStackSetOperationInput {
    /// <p>The name or unique ID of the stack set that you want to stop the operation
    /// for.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>The ID of the stack operation. </p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for StopStackSetOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopStackSetOperationInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("operation_id", &self.operation_id);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

/// <p>The input for the <a>SignalResource</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignalResourceInput {
    /// <p>The stack name or unique stack ID that includes the resource that you want to
    /// signal.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
    /// the resource that given in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
    /// groups, specify the instance ID that you are signaling as the unique ID. If you send
    /// multiple signals to a single resource (such as signaling a wait condition), each signal
    /// requires a different unique ID.</p>
    pub unique_id: std::option::Option<std::string::String>,
    /// <p>The status of the signal, which is either success or failure. A failure signal causes
    /// CloudFormation to immediately fail the stack creation or update.</p>
    pub status: std::option::Option<crate::model::ResourceSignalStatus>,
}
impl SignalResourceInput {
    /// <p>The stack name or unique stack ID that includes the resource that you want to
    /// signal.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
    /// the resource that given in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
    /// groups, specify the instance ID that you are signaling as the unique ID. If you send
    /// multiple signals to a single resource (such as signaling a wait condition), each signal
    /// requires a different unique ID.</p>
    pub fn unique_id(&self) -> std::option::Option<&str> {
        self.unique_id.as_deref()
    }
    /// <p>The status of the signal, which is either success or failure. A failure signal causes
    /// CloudFormation to immediately fail the stack creation or update.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceSignalStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SignalResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignalResourceInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("unique_id", &self.unique_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTypeDefaultVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
    /// information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The kind of extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
    /// the Amazon Resource Name (ARN) assigned to the extension version when it is
    /// registered.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl SetTypeDefaultVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
    /// information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The kind of extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
    /// the Amazon Resource Name (ARN) assigned to the extension version when it is
    /// registered.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for SetTypeDefaultVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTypeDefaultVersionInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTypeConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
    /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
    /// configuration for an extension, but not for a specific extension version.</p>
    pub type_arn: std::option::Option<std::string::String>,
    /// <p>The configuration data for the extension, in this account and region. </p>
    /// <p>The configuration data must be formatted as JSON, and validate against the schema
    /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
    /// <i>CloudFormation CLI User Guide</i>.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>An alias by which to refer to this extension configuration data.</p>
    /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
    /// for a resource type extension.</p>
    pub configuration_alias: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
    /// <code>TypeName</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The type of extension.</p>
    /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
    /// <code>TypeName</code>.</p>
    pub r#type: std::option::Option<crate::model::ThirdPartyType>,
}
impl SetTypeConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
    /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
    /// configuration for an extension, but not for a specific extension version.</p>
    pub fn type_arn(&self) -> std::option::Option<&str> {
        self.type_arn.as_deref()
    }
    /// <p>The configuration data for the extension, in this account and region. </p>
    /// <p>The configuration data must be formatted as JSON, and validate against the schema
    /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
    /// <i>CloudFormation CLI User Guide</i>.</p>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>An alias by which to refer to this extension configuration data.</p>
    /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
    /// for a resource type extension.</p>
    pub fn configuration_alias(&self) -> std::option::Option<&str> {
        self.configuration_alias.as_deref()
    }
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
    /// <code>TypeName</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The type of extension.</p>
    /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
    /// <code>TypeName</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThirdPartyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for SetTypeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTypeConfigurationInput");
        formatter.field("type_arn", &self.type_arn);
        formatter.field("configuration", &self.configuration);
        formatter.field("configuration_alias", &self.configuration_alias);
        formatter.field("type_name", &self.type_name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>The input for the <a>SetStackPolicy</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetStackPolicyInput {
    /// <p>The name or unique stack ID that you want to associate a policy with.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
    /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
    /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
    /// both.</p>
    pub stack_policy_body: std::option::Option<std::string::String>,
    /// <p>Location of a file containing the stack policy. The URL must point to a policy
    /// (maximum size: 16 KB) located in an S3 bucket in the same
    /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
    /// <code>StackPolicyURL</code> parameter, but not both.</p>
    pub stack_policy_url: std::option::Option<std::string::String>,
}
impl SetStackPolicyInput {
    /// <p>The name or unique stack ID that you want to associate a policy with.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
    /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
    /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
    /// both.</p>
    pub fn stack_policy_body(&self) -> std::option::Option<&str> {
        self.stack_policy_body.as_deref()
    }
    /// <p>Location of a file containing the stack policy. The URL must point to a policy
    /// (maximum size: 16 KB) located in an S3 bucket in the same
    /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
    /// <code>StackPolicyURL</code> parameter, but not both.</p>
    pub fn stack_policy_url(&self) -> std::option::Option<&str> {
        self.stack_policy_url.as_deref()
    }
}
impl std::fmt::Debug for SetStackPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetStackPolicyInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("stack_policy_body", &self.stack_policy_body);
        formatter.field("stack_policy_url", &self.stack_policy_url);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackStackInput {
    /// <p>The name that is associated with the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl RollbackStackInput {
    /// <p>The name that is associated with the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for RollbackStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackStackInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTypeInput {
    /// <p>The kind of extension.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension being registered.</p>
    /// <p>We recommend that extension names adhere to the following patterns: </p>
    /// <ul>
    /// <li>
    /// <p>For resource types,
    /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
    /// </li>
    /// <li>
    /// <p>For modules,
    /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following organization namespaces are reserved and cannot be used in your
    /// extension names:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Alexa</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AMZN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Amazon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AWS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Custom</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Dev</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </note>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>A url to the S3 bucket containing the extension project package that contains the
    /// neccessary files for the extension you want to register.</p>
    /// <p>For information on generating a schema handler package for the extension you want to
    /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
    /// in the <i>CloudFormation CLI User Guide</i>.</p>
    /// <note>
    /// <p>The user registering the extension must be able to access the package in the S3
    /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
    /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
    /// for Amazon S3</a> in the <i>Identity and Access Management User
    /// Guide</i>.</p>
    /// </note>
    pub schema_handler_package: std::option::Option<std::string::String>,
    /// <p>Specifies logging configuration information for an extension.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
    /// when invoking the extension.</p>
    /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
    /// relationship with the CloudFormation service principle
    /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
    /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
    /// Guide</i>.</p>
    /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
    /// an <i>
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
    /// execution role</a>
    /// </i> that includes the necessary permissions to call
    /// those Amazon Web Services APIs, and provision that execution role in your account. When
    /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
    /// execution role to create a temporary session token, which it then passes to the resource
    /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier that acts as an idempotency key for this registration request.
    /// Specifying a client request token prevents CloudFormation from generating more
    /// than one version of an extension from the same registeration request, even if the request
    /// is submitted multiple times. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl RegisterTypeInput {
    /// <p>The kind of extension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension being registered.</p>
    /// <p>We recommend that extension names adhere to the following patterns: </p>
    /// <ul>
    /// <li>
    /// <p>For resource types,
    /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
    /// </li>
    /// <li>
    /// <p>For modules,
    /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following organization namespaces are reserved and cannot be used in your
    /// extension names:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Alexa</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AMZN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Amazon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AWS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Custom</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Dev</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </note>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>A url to the S3 bucket containing the extension project package that contains the
    /// neccessary files for the extension you want to register.</p>
    /// <p>For information on generating a schema handler package for the extension you want to
    /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
    /// in the <i>CloudFormation CLI User Guide</i>.</p>
    /// <note>
    /// <p>The user registering the extension must be able to access the package in the S3
    /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
    /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
    /// for Amazon S3</a> in the <i>Identity and Access Management User
    /// Guide</i>.</p>
    /// </note>
    pub fn schema_handler_package(&self) -> std::option::Option<&str> {
        self.schema_handler_package.as_deref()
    }
    /// <p>Specifies logging configuration information for an extension.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
    /// when invoking the extension.</p>
    /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
    /// relationship with the CloudFormation service principle
    /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
    /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
    /// Guide</i>.</p>
    /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
    /// an <i>
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
    /// execution role</a>
    /// </i> that includes the necessary permissions to call
    /// those Amazon Web Services APIs, and provision that execution role in your account. When
    /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
    /// execution role to create a temporary session token, which it then passes to the resource
    /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>A unique identifier that acts as an idempotency key for this registration request.
    /// Specifying a client request token prevents CloudFormation from generating more
    /// than one version of an extension from the same registeration request, even if the request
    /// is submitted multiple times. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for RegisterTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTypeInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("schema_handler_package", &self.schema_handler_package);
        formatter.field("logging_config", &self.logging_config);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterPublisherInput {
    /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
    /// You must accept the terms and conditions in order to register to publish public extensions
    /// to the CloudFormation registry.</p>
    /// <p>The default is <code>false</code>.</p>
    pub accept_terms_and_conditions: std::option::Option<bool>,
    /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
    /// Resource Name (ARN) for your connection to that account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
    /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
    pub connection_arn: std::option::Option<std::string::String>,
}
impl RegisterPublisherInput {
    /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
    /// You must accept the terms and conditions in order to register to publish public extensions
    /// to the CloudFormation registry.</p>
    /// <p>The default is <code>false</code>.</p>
    pub fn accept_terms_and_conditions(&self) -> std::option::Option<bool> {
        self.accept_terms_and_conditions
    }
    /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
    /// Resource Name (ARN) for your connection to that account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
    /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
}
impl std::fmt::Debug for RegisterPublisherInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterPublisherInput");
        formatter.field(
            "accept_terms_and_conditions",
            &self.accept_terms_and_conditions,
        );
        formatter.field("connection_arn", &self.connection_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordHandlerProgressInput {
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub bearer_token: std::option::Option<std::string::String>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub operation_status: std::option::Option<crate::model::OperationStatus>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub current_operation_status: std::option::Option<crate::model::OperationStatus>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub error_code: std::option::Option<crate::model::HandlerErrorCode>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub resource_model: std::option::Option<std::string::String>,
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl RecordHandlerProgressInput {
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn bearer_token(&self) -> std::option::Option<&str> {
        self.bearer_token.as_deref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn operation_status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.operation_status.as_ref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn current_operation_status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.current_operation_status.as_ref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::HandlerErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn resource_model(&self) -> std::option::Option<&str> {
        self.resource_model.as_deref()
    }
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for RecordHandlerProgressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordHandlerProgressInput");
        formatter.field("bearer_token", &self.bearer_token);
        formatter.field("operation_status", &self.operation_status);
        formatter.field("current_operation_status", &self.current_operation_status);
        formatter.field("status_message", &self.status_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("resource_model", &self.resource_model);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishTypeInput {
    /// <p>The type of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub r#type: std::option::Option<crate::model::ThirdPartyType>,
    /// <p>The Amazon Resource Number (ARN) of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The version number to assign to this version of the extension.</p>
    /// <p>Use the following format, and adhere to semantic versioning when assigning a version
    /// number to your extension: </p>
    /// <p>
    /// <code>MAJOR.MINOR.PATCH</code>
    /// </p>
    /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
    /// 2.0.0</a>.</p>
    /// <p>If you do not specify a version number, CloudFormation increments the version number by
    /// one minor version release.</p>
    /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
    /// regardless of the value you specify.</p>
    pub public_version_number: std::option::Option<std::string::String>,
}
impl PublishTypeInput {
    /// <p>The type of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThirdPartyType> {
        self.r#type.as_ref()
    }
    /// <p>The Amazon Resource Number (ARN) of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
    /// <code>Type</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The version number to assign to this version of the extension.</p>
    /// <p>Use the following format, and adhere to semantic versioning when assigning a version
    /// number to your extension: </p>
    /// <p>
    /// <code>MAJOR.MINOR.PATCH</code>
    /// </p>
    /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
    /// 2.0.0</a>.</p>
    /// <p>If you do not specify a version number, CloudFormation increments the version number by
    /// one minor version release.</p>
    /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
    /// regardless of the value you specify.</p>
    pub fn public_version_number(&self) -> std::option::Option<&str> {
        self.public_version_number.as_deref()
    }
}
impl std::fmt::Debug for PublishTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishTypeInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("arn", &self.arn);
        formatter.field("type_name", &self.type_name);
        formatter.field("public_version_number", &self.public_version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypeVersionsInput {
    /// <p>The kind of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension for which you want version summary information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
    /// information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The deprecation status of the extension versions that you want to get summary
    /// information about.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
    /// scope.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
    /// longer be used in CloudFormation operations. </p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>LIVE</code>.</p>
    pub deprecated_status: std::option::Option<crate::model::DeprecatedStatus>,
    /// <p>The publisher ID of the extension publisher.</p>
    /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
    pub publisher_id: std::option::Option<std::string::String>,
}
impl ListTypeVersionsInput {
    /// <p>The kind of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension for which you want version summary information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
    /// information.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The deprecation status of the extension versions that you want to get summary
    /// information about.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
    /// scope.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
    /// longer be used in CloudFormation operations. </p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>LIVE</code>.</p>
    pub fn deprecated_status(&self) -> std::option::Option<&crate::model::DeprecatedStatus> {
        self.deprecated_status.as_ref()
    }
    /// <p>The publisher ID of the extension publisher.</p>
    /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
    pub fn publisher_id(&self) -> std::option::Option<&str> {
        self.publisher_id.as_deref()
    }
}
impl std::fmt::Debug for ListTypeVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypeVersionsInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("arn", &self.arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("deprecated_status", &self.deprecated_status);
        formatter.field("publisher_id", &self.publisher_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypesInput {
    /// <p>The scope at which the extensions are visible and usable in CloudFormation
    /// operations.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
    /// and region. This includes:</p>
    /// <ul>
    /// <li>
    /// <p>Private extensions you have registered in this account and region.</p>
    /// </li>
    /// <li>
    /// <p>Public extensions that you have activated in this account and region.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
    /// activated within any Amazon account. This includes extensions from Amazon, as well as
    /// third-party publishers.</p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>PRIVATE</code>.</p>
    pub visibility: std::option::Option<crate::model::Visibility>,
    /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
    /// provisioning type during registration, based on the types of handlers in the schema handler
    /// package submitted.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
    /// process updates to the type during stack update operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
    /// the type cannot be updated and must instead be replaced during stack update
    /// operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
    /// and delete handlers, and therefore cannot actually be provisioned.</p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
    pub provisioning_type: std::option::Option<crate::model::ProvisioningType>,
    /// <p>The deprecation status of the extension that you want to get summary information
    /// about.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LIVE</code>: The extension is registered for use in CloudFormation
    /// operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
    /// used in CloudFormation operations. </p>
    /// </li>
    /// </ul>
    pub deprecated_status: std::option::Option<crate::model::DeprecatedStatus>,
    /// <p>The type of extension.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>Filter criteria to use in determining which extensions to return.</p>
    /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
    /// value when returning the list of types.</p>
    pub filters: std::option::Option<crate::model::TypeFilters>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTypesInput {
    /// <p>The scope at which the extensions are visible and usable in CloudFormation
    /// operations.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
    /// and region. This includes:</p>
    /// <ul>
    /// <li>
    /// <p>Private extensions you have registered in this account and region.</p>
    /// </li>
    /// <li>
    /// <p>Public extensions that you have activated in this account and region.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
    /// activated within any Amazon account. This includes extensions from Amazon, as well as
    /// third-party publishers.</p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>PRIVATE</code>.</p>
    pub fn visibility(&self) -> std::option::Option<&crate::model::Visibility> {
        self.visibility.as_ref()
    }
    /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
    /// provisioning type during registration, based on the types of handlers in the schema handler
    /// package submitted.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
    /// process updates to the type during stack update operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
    /// the type cannot be updated and must instead be replaced during stack update
    /// operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
    /// and delete handlers, and therefore cannot actually be provisioned.</p>
    /// </li>
    /// </ul>
    /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
    pub fn provisioning_type(&self) -> std::option::Option<&crate::model::ProvisioningType> {
        self.provisioning_type.as_ref()
    }
    /// <p>The deprecation status of the extension that you want to get summary information
    /// about.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LIVE</code>: The extension is registered for use in CloudFormation
    /// operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
    /// used in CloudFormation operations. </p>
    /// </li>
    /// </ul>
    pub fn deprecated_status(&self) -> std::option::Option<&crate::model::DeprecatedStatus> {
        self.deprecated_status.as_ref()
    }
    /// <p>The type of extension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>Filter criteria to use in determining which extensions to return.</p>
    /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
    /// value when returning the list of types.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::TypeFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypesInput");
        formatter.field("visibility", &self.visibility);
        formatter.field("provisioning_type", &self.provisioning_type);
        formatter.field("deprecated_status", &self.deprecated_status);
        formatter.field("r#type", &self.r#type);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypeRegistrationsInput {
    /// <p>The kind of extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub type_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the extension registration request.</p>
    /// <p>The default is <code>IN_PROGRESS</code>.</p>
    pub registration_status_filter: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTypeRegistrationsInput {
    /// <p>The kind of extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the extension.</p>
    /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
    /// <code>Arn</code>.</p>
    pub fn type_arn(&self) -> std::option::Option<&str> {
        self.type_arn.as_deref()
    }
    /// <p>The current status of the extension registration request.</p>
    /// <p>The default is <code>IN_PROGRESS</code>.</p>
    pub fn registration_status_filter(
        &self,
    ) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.registration_status_filter.as_ref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call this action again and assign that token to the request object's
    /// <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTypeRegistrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypeRegistrationsInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("type_arn", &self.type_arn);
        formatter.field(
            "registration_status_filter",
            &self.registration_status_filter,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackSetsInput {
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListStackSets</code> again and assign that token to the
    /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
    /// previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The status of the stack sets that you want to get summary information
    /// about.</p>
    pub status: std::option::Option<crate::model::StackSetStatus>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the management account or as a delegated administrator in a member
    /// account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl ListStackSetsInput {
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListStackSets</code> again and assign that token to the
    /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
    /// previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The status of the stack sets that you want to get summary information
    /// about.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetStatus> {
        self.status.as_ref()
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the management account or as a delegated administrator in a member
    /// account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for ListStackSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackSetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("status", &self.status);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackSetOperationsInput {
    /// <p>The name or unique ID of the stack set that you want to get operation summaries
    /// for.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
    /// to the request object's <code>NextToken</code> parameter. If there are no remaining
    /// results, the previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl ListStackSetOperationsInput {
    /// <p>The name or unique ID of the stack set that you want to get operation summaries
    /// for.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>If the previous paginated request didn't return all of the remaining results, the
    /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
    /// to the request object's <code>NextToken</code> parameter. If there are no remaining
    /// results, the previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for ListStackSetOperationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackSetOperationsInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackSetOperationResultsInput {
    /// <p>The name or unique ID of the stack set that you want to get operation results
    /// for.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>The ID of the stack set operation.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>If the previous request didn't return all of the remaining results, the response
    /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
    /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
    /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
    /// the previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl ListStackSetOperationResultsInput {
    /// <p>The name or unique ID of the stack set that you want to get operation results
    /// for.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>The ID of the stack set operation.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>If the previous request didn't return all of the remaining results, the response
    /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
    /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
    /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
    /// the previous response object's <code>NextToken</code> parameter is set to
    /// <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for ListStackSetOperationResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackSetOperationResultsInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("operation_id", &self.operation_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

/// <p>The input for <a>ListStacks</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStacksInput {
    /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
    /// stacks with the specified status codes. For a complete list of stack status codes, see the
    /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
    pub stack_status_filter: std::option::Option<std::vec::Vec<crate::model::StackStatus>>,
}
impl ListStacksInput {
    /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
    /// stacks with the specified status codes. For a complete list of stack status codes, see the
    /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
    pub fn stack_status_filter(&self) -> std::option::Option<&[crate::model::StackStatus]> {
        self.stack_status_filter.as_deref()
    }
}
impl std::fmt::Debug for ListStacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStacksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("stack_status_filter", &self.stack_status_filter);
        formatter.finish()
    }
}

/// <p>The input for the <a>ListStackResource</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackResourcesInput {
    /// <p>The name or the unique stack ID that is associated with the stack, which are not
    /// always interchangeable:</p>
    /// <ul>
    /// <li>
    /// <p>Running stacks: You can specify either the stack's name or its unique stack
    /// ID.</p>
    /// </li>
    /// <li>
    /// <p>Deleted stacks: You must specify the unique stack ID.</p>
    /// </li>
    /// </ul>
    /// <p>Default: There is no default value.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>A string that identifies the next page of stack resources that you want to
    /// retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStackResourcesInput {
    /// <p>The name or the unique stack ID that is associated with the stack, which are not
    /// always interchangeable:</p>
    /// <ul>
    /// <li>
    /// <p>Running stacks: You can specify either the stack's name or its unique stack
    /// ID.</p>
    /// </li>
    /// <li>
    /// <p>Deleted stacks: You must specify the unique stack ID.</p>
    /// </li>
    /// </ul>
    /// <p>Default: There is no default value.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>A string that identifies the next page of stack resources that you want to
    /// retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStackResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackResourcesInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackInstancesInput {
    /// <p>The name or unique ID of the stack set that you want to list stack instances
    /// for.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>If the previous request didn't return all of the remaining results, the response's
    /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
    /// results, call <code>ListStackInstances</code> again and assign that token to the request
    /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The status that stack instances are filtered by.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::StackInstanceFilter>>,
    /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
    pub stack_instance_account: std::option::Option<std::string::String>,
    /// <p>The name of the Region where you want to list stack instances. </p>
    pub stack_instance_region: std::option::Option<std::string::String>,
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub call_as: std::option::Option<crate::model::CallAs>,
}
impl ListStackInstancesInput {
    /// <p>The name or unique ID of the stack set that you want to list stack instances
    /// for.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>If the previous request didn't return all of the remaining results, the response's
    /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
    /// results, call <code>ListStackInstances</code> again and assign that token to the request
    /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
    /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call. If the number of
    /// available results exceeds this maximum, the response includes a <code>NextToken</code>
    /// value that you can assign to the <code>NextToken</code> request parameter to get the next
    /// set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The status that stack instances are filtered by.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::StackInstanceFilter]> {
        self.filters.as_deref()
    }
    /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
    pub fn stack_instance_account(&self) -> std::option::Option<&str> {
        self.stack_instance_account.as_deref()
    }
    /// <p>The name of the Region where you want to list stack instances. </p>
    pub fn stack_instance_region(&self) -> std::option::Option<&str> {
        self.stack_instance_region.as_deref()
    }
    /// <p>[Service-managed permissions] Specifies whether you are acting as an account
    /// administrator in the organization's management account or as a delegated administrator in a
    /// member account.</p>
    /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
    /// self-managed permissions.</p>
    /// <ul>
    /// <li>
    /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
    /// </li>
    /// <li>
    /// <p>If you are signed in to a delegated administrator account, specify
    /// <code>DELEGATED_ADMIN</code>.</p>
    /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
    /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn call_as(&self) -> std::option::Option<&crate::model::CallAs> {
        self.call_as.as_ref()
    }
}
impl std::fmt::Debug for ListStackInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackInstancesInput");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("stack_instance_account", &self.stack_instance_account);
        formatter.field("stack_instance_region", &self.stack_instance_region);
        formatter.field("call_as", &self.call_as);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImportsInput {
    /// <p>The name of the exported output value. CloudFormation returns the stack names
    /// that are importing this value.</p>
    pub export_name: std::option::Option<std::string::String>,
    /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
    /// the next page of stacks that are importing the specified exported output value.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImportsInput {
    /// <p>The name of the exported output value. CloudFormation returns the stack names
    /// that are importing this value.</p>
    pub fn export_name(&self) -> std::option::Option<&str> {
        self.export_name.as_deref()
    }
    /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
    /// the next page of stacks that are importing the specified exported output value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImportsInput");
        formatter.field("export_name", &self.export_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExportsInput {
    /// <p>A string (provided by the <a>ListExports</a> response output) that
    /// identifies the next page of exported output values that you asked to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExportsInput {
    /// <p>A string (provided by the <a>ListExports</a> response output) that
    /// identifies the next page of exported output values that you asked to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExportsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The input for the <a>ListChangeSets</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChangeSetsInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
    /// change sets.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
    /// identifies the next page of change sets that you want to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChangeSetsInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
    /// change sets.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
    /// identifies the next page of change sets that you want to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChangeSets