// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivateTypeOutput, crate::error::ActivateTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ActivateTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ActivateTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::ActivateTypeError {
            meta: generic,
            kind: crate::error::ActivateTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ActivateTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::ActivateTypeError {
            meta: generic,
            kind: crate::error::ActivateTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ActivateTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ActivateTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivateTypeOutput, crate::error::ActivateTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::activate_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_activate_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ActivateTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_describe_type_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDescribeTypeConfigurationsOutput,
    crate::error::BatchDescribeTypeConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDescribeTypeConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDescribeTypeConfigurationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::BatchDescribeTypeConfigurationsError { meta: generic, kind: crate::error::BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchDescribeTypeConfigurationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TypeConfigurationNotFoundException" => crate::error::BatchDescribeTypeConfigurationsError { meta: generic, kind: crate::error::BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::type_configuration_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_configuration_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchDescribeTypeConfigurationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchDescribeTypeConfigurationsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_describe_type_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDescribeTypeConfigurationsOutput,
    crate::error::BatchDescribeTypeConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::batch_describe_type_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_batch_describe_type_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::BatchDescribeTypeConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_update_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelUpdateStackOutput, crate::error::CancelUpdateStackError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelUpdateStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelUpdateStackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TokenAlreadyExistsException" => crate::error::CancelUpdateStackError {
            meta: generic,
            kind: crate::error::CancelUpdateStackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelUpdateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelUpdateStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_update_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelUpdateStackOutput, crate::error::CancelUpdateStackError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_update_stack_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_continue_update_rollback_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ContinueUpdateRollbackOutput,
    crate::error::ContinueUpdateRollbackError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ContinueUpdateRollbackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ContinueUpdateRollbackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TokenAlreadyExistsException" => crate::error::ContinueUpdateRollbackError {
            meta: generic,
            kind: crate::error::ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ContinueUpdateRollbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ContinueUpdateRollbackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_continue_update_rollback_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ContinueUpdateRollbackOutput,
    crate::error::ContinueUpdateRollbackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::continue_update_rollback_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_change_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChangeSetOutput, crate::error::CreateChangeSetError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChangeSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateChangeSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateChangeSetError {
            meta: generic,
            kind: crate::error::CreateChangeSetErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientCapabilitiesException" => crate::error::CreateChangeSetError {
            meta: generic,
            kind: crate::error::CreateChangeSetErrorKind::InsufficientCapabilitiesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_capabilities_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_capabilities_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateChangeSetError {
            meta: generic,
            kind: crate::error::CreateChangeSetErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChangeSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_change_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChangeSetOutput, crate::error::CreateChangeSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_change_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_change_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChangeSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStackOutput, crate::error::CreateStackError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateStackError {
            meta: generic,
            kind: crate::error::CreateStackErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientCapabilitiesException" => crate::error::CreateStackError {
            meta: generic,
            kind: crate::error::CreateStackErrorKind::InsufficientCapabilitiesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_capabilities_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_capabilities_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateStackError {
            meta: generic,
            kind: crate::error::CreateStackErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TokenAlreadyExistsException" => crate::error::CreateStackError {
            meta: generic,
            kind: crate::error::CreateStackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStackOutput, crate::error::CreateStackError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_stack_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_stack(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStackInstancesOutput,
    crate::error::CreateStackInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStackInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStackInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationIdAlreadyExistsException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::OperationIdAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_id_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_id_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleRequestException" => crate::error::CreateStackInstancesError {
            meta: generic,
            kind: crate::error::CreateStackInstancesErrorKind::StaleRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stale_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stale_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStackInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStackInstancesOutput,
    crate::error::CreateStackInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_stack_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_stack_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStackInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStackSetOutput, crate::error::CreateStackSetError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStackSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStackSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CreatedButModifiedException" => crate::error::CreateStackSetError {
            meta: generic,
            kind: crate::error::CreateStackSetErrorKind::CreatedButModifiedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::created_but_modified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_created_but_modified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateStackSetError {
            meta: generic,
            kind: crate::error::CreateStackSetErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NameAlreadyExistsException" => crate::error::CreateStackSetError {
            meta: generic,
            kind: crate::error::CreateStackSetErrorKind::NameAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::name_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_name_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStackSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_stack_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateStackSetOutput, crate::error::CreateStackSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_stack_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_stack_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStackSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeactivateTypeOutput, crate::error::DeactivateTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeactivateTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeactivateTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::DeactivateTypeError {
            meta: generic,
            kind: crate::error::DeactivateTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::DeactivateTypeError {
            meta: generic,
            kind: crate::error::DeactivateTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeactivateTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeactivateTypeOutput, crate::error::DeactivateTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deactivate_type_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_change_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChangeSetOutput, crate::error::DeleteChangeSetError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChangeSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChangeSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidChangeSetStatus" => crate::error::DeleteChangeSetError {
            meta: generic,
            kind: crate::error::DeleteChangeSetErrorKind::InvalidChangeSetStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_change_set_status_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_change_set_status_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChangeSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_change_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChangeSetOutput, crate::error::DeleteChangeSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_change_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStackOutput, crate::error::DeleteStackError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteStackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TokenAlreadyExistsException" => crate::error::DeleteStackError {
            meta: generic,
            kind: crate::error::DeleteStackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStackOutput, crate::error::DeleteStackError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_stack_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStackInstancesOutput,
    crate::error::DeleteStackInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStackInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteStackInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::DeleteStackInstancesError {
            meta: generic,
            kind: crate::error::DeleteStackInstancesErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationIdAlreadyExistsException" => crate::error::DeleteStackInstancesError {
            meta: generic,
            kind: crate::error::DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_id_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_id_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::DeleteStackInstancesError {
            meta: generic,
            kind: crate::error::DeleteStackInstancesErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::DeleteStackInstancesError {
            meta: generic,
            kind: crate::error::DeleteStackInstancesErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleRequestException" => crate::error::DeleteStackInstancesError {
            meta: generic,
            kind: crate::error::DeleteStackInstancesErrorKind::StaleRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stale_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stale_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteStackInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStackInstancesOutput,
    crate::error::DeleteStackInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_stack_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_stack_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteStackInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStackSetOutput, crate::error::DeleteStackSetError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStackSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteStackSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationInProgressException" => crate::error::DeleteStackSetError {
            meta: generic,
            kind: crate::error::DeleteStackSetErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotEmptyException" => crate::error::DeleteStackSetError {
            meta: generic,
            kind: crate::error::DeleteStackSetErrorKind::StackSetNotEmptyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_empty_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_empty_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteStackSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_stack_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteStackSetOutput, crate::error::DeleteStackSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_stack_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterTypeOutput, crate::error::DeregisterTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::DeregisterTypeError {
            meta: generic,
            kind: crate::error::DeregisterTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::DeregisterTypeError {
            meta: generic,
            kind: crate::error::DeregisterTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeregisterTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterTypeOutput, crate::error::DeregisterTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_type_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
    Err(crate::error::DescribeAccountLimitsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_limits_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_change_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeChangeSetOutput, crate::error::DescribeChangeSetError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChangeSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeChangeSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ChangeSetNotFound" => crate::error::DescribeChangeSetError {
            meta: generic,
            kind: crate::error::DescribeChangeSetErrorKind::ChangeSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::change_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_change_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChangeSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_change_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeChangeSetOutput, crate::error::DescribeChangeSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_change_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_change_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChangeSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_change_set_hooks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChangeSetHooksOutput,
    crate::error::DescribeChangeSetHooksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChangeSetHooksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeChangeSetHooksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ChangeSetNotFound" => crate::error::DescribeChangeSetHooksError {
            meta: generic,
            kind: crate::error::DescribeChangeSetHooksErrorKind::ChangeSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::change_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_change_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeChangeSetHooksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChangeSetHooksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_change_set_hooks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChangeSetHooksOutput,
    crate::error::DescribeChangeSetHooksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_change_set_hooks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_change_set_hooks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChangeSetHooksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_publisher_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePublisherOutput, crate::error::DescribePublisherError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePublisherError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePublisherError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::DescribePublisherError {
            meta: generic,
            kind: crate::error::DescribePublisherErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePublisherError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePublisherError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_publisher_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePublisherOutput, crate::error::DescribePublisherError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_publisher_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_publisher(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePublisherError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_drift_detection_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackDriftDetectionStatusOutput,
    crate::error::DescribeStackDriftDetectionStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackDriftDetectionStatusError::unhandled)?;
    Err(crate::error::DescribeStackDriftDetectionStatusError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_drift_detection_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackDriftDetectionStatusOutput,
    crate::error::DescribeStackDriftDetectionStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_stack_drift_detection_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_drift_detection_status(response.body().as_ref(), output).map_err(crate::error::DescribeStackDriftDetectionStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackEventsOutput,
    crate::error::DescribeStackEventsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackEventsError::unhandled)?;
    Err(crate::error::DescribeStackEventsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackEventsOutput,
    crate::error::DescribeStackEventsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_events_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackInstanceOutput,
    crate::error::DescribeStackInstanceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeStackInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "StackInstanceNotFoundException" => crate::error::DescribeStackInstanceError {
            meta: generic,
            kind: crate::error::DescribeStackInstanceErrorKind::StackInstanceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_instance_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_instance_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeStackInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::DescribeStackInstanceError {
            meta: generic,
            kind: crate::error::DescribeStackInstanceErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeStackInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStackInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackInstanceOutput,
    crate::error::DescribeStackInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourceOutput,
    crate::error::DescribeStackResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackResourceError::unhandled)?;
    Err(crate::error::DescribeStackResourceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourceOutput,
    crate::error::DescribeStackResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resource_drifts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourceDriftsOutput,
    crate::error::DescribeStackResourceDriftsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackResourceDriftsError::unhandled)?;
    Err(crate::error::DescribeStackResourceDriftsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resource_drifts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourceDriftsOutput,
    crate::error::DescribeStackResourceDriftsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_resource_drifts_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_resource_drifts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackResourceDriftsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourcesOutput,
    crate::error::DescribeStackResourcesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackResourcesError::unhandled)?;
    Err(crate::error::DescribeStackResourcesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_resources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackResourcesOutput,
    crate::error::DescribeStackResourcesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_resources_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_resources(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackResourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stacks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStacksOutput, crate::error::DescribeStacksError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStacksError::unhandled)?;
    Err(crate::error::DescribeStacksError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stacks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStacksOutput, crate::error::DescribeStacksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stacks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stacks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStacksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStackSetOutput, crate::error::DescribeStackSetError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeStackSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "StackSetNotFoundException" => crate::error::DescribeStackSetError {
            meta: generic,
            kind: crate::error::DescribeStackSetErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStackSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStackSetOutput, crate::error::DescribeStackSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_set_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackSetOperationOutput,
    crate::error::DescribeStackSetOperationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStackSetOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeStackSetOperationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotFoundException" => crate::error::DescribeStackSetOperationError {
            meta: generic,
            kind: crate::error::DescribeStackSetOperationErrorKind::OperationNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeStackSetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::DescribeStackSetOperationError {
            meta: generic,
            kind: crate::error::DescribeStackSetOperationErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeStackSetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStackSetOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stack_set_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStackSetOperationOutput,
    crate::error::DescribeStackSetOperationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stack_set_operation_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_stack_set_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStackSetOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTypeOutput, crate::error::DescribeTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::DescribeTypeError {
            meta: generic,
            kind: crate::error::DescribeTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::DescribeTypeError {
            meta: generic,
            kind: crate::error::DescribeTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTypeOutput, crate::error::DescribeTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_type_registration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTypeRegistrationOutput,
    crate::error::DescribeTypeRegistrationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTypeRegistrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTypeRegistrationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::DescribeTypeRegistrationError {
            meta: generic,
            kind: crate::error::DescribeTypeRegistrationErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTypeRegistrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTypeRegistrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_type_registration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTypeRegistrationOutput,
    crate::error::DescribeTypeRegistrationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_type_registration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_type_registration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTypeRegistrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_drift_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectStackDriftOutput, crate::error::DetectStackDriftError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectStackDriftError::unhandled)?;
    Err(crate::error::DetectStackDriftError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_drift_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectStackDriftOutput, crate::error::DetectStackDriftError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_stack_drift_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_detect_stack_drift(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectStackDriftError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_resource_drift_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectStackResourceDriftOutput,
    crate::error::DetectStackResourceDriftError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectStackResourceDriftError::unhandled)?;
    Err(crate::error::DetectStackResourceDriftError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_resource_drift_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectStackResourceDriftOutput,
    crate::error::DetectStackResourceDriftError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_stack_resource_drift_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_detect_stack_resource_drift(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectStackResourceDriftError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_set_drift_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectStackSetDriftOutput,
    crate::error::DetectStackSetDriftError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectStackSetDriftError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectStackSetDriftError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::DetectStackSetDriftError {
            meta: generic,
            kind: crate::error::DetectStackSetDriftErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetectStackSetDriftError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::DetectStackSetDriftError {
            meta: generic,
            kind: crate::error::DetectStackSetDriftErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetectStackSetDriftError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::DetectStackSetDriftError {
            meta: generic,
            kind: crate::error::DetectStackSetDriftErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetectStackSetDriftError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectStackSetDriftError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_stack_set_drift_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectStackSetDriftOutput,
    crate::error::DetectStackSetDriftError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_stack_set_drift_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_detect_stack_set_drift(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectStackSetDriftError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_estimate_template_cost_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EstimateTemplateCostOutput,
    crate::error::EstimateTemplateCostError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EstimateTemplateCostError::unhandled)?;
    Err(crate::error::EstimateTemplateCostError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_estimate_template_cost_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EstimateTemplateCostOutput,
    crate::error::EstimateTemplateCostError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::estimate_template_cost_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_estimate_template_cost(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EstimateTemplateCostError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_change_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteChangeSetOutput, crate::error::ExecuteChangeSetError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteChangeSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecuteChangeSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ChangeSetNotFound" => crate::error::ExecuteChangeSetError {
            meta: generic,
            kind: crate::error::ExecuteChangeSetErrorKind::ChangeSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::change_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_change_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecuteChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientCapabilitiesException" => crate::error::ExecuteChangeSetError {
            meta: generic,
            kind: crate::error::ExecuteChangeSetErrorKind::InsufficientCapabilitiesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_capabilities_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_capabilities_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecuteChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidChangeSetStatus" => crate::error::ExecuteChangeSetError {
            meta: generic,
            kind: crate::error::ExecuteChangeSetErrorKind::InvalidChangeSetStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_change_set_status_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_change_set_status_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecuteChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TokenAlreadyExistsException" => crate::error::ExecuteChangeSetError {
            meta: generic,
            kind: crate::error::ExecuteChangeSetErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecuteChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecuteChangeSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_change_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteChangeSetOutput, crate::error::ExecuteChangeSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_change_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stack_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStackPolicyOutput, crate::error::GetStackPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStackPolicyError::unhandled)?;
    Err(crate::error::GetStackPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_stack_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStackPolicyOutput, crate::error::GetStackPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_stack_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_stack_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetStackPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ChangeSetNotFound" => crate::error::GetTemplateError {
            meta: generic,
            kind: crate::error::GetTemplateErrorKind::ChangeSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::change_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_change_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_summary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTemplateSummaryOutput,
    crate::error::GetTemplateSummaryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTemplateSummaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTemplateSummaryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "StackSetNotFoundException" => crate::error::GetTemplateSummaryError {
            meta: generic,
            kind: crate::error::GetTemplateSummaryErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTemplateSummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTemplateSummaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_summary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTemplateSummaryOutput,
    crate::error::GetTemplateSummaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_template_summary_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_template_summary(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTemplateSummaryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_stacks_to_stack_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportStacksToStackSetOutput,
    crate::error::ImportStacksToStackSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ImportStacksToStackSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationIdAlreadyExistsException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_id_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_operation_id_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationInProgressException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackNotFoundException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::StackNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stack_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleRequestException" => crate::error::ImportStacksToStackSetError {
            meta: generic,
            kind: crate::error::ImportStacksToStackSetErrorKind::StaleRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stale_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stale_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportStacksToStackSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_stacks_to_stack_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportStacksToStackSetOutput,
    crate::error::ImportStacksToStackSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_stacks_to_stack_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_import_stacks_to_stack_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportStacksToStackSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_change_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChangeSetsOutput, crate::error::ListChangeSetsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChangeSetsError::unhandled)?;
    Err(crate::error::ListChangeSetsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_change_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChangeSetsOutput, crate::error::ListChangeSetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_change_sets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_change_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChangeSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_exports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListExportsError::unhandled)?;
    Err(crate::error::ListExportsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_exports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_exports_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_exports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListExportsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_imports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImportsOutput, crate::error::ListImportsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListImportsError::unhandled)?;
    Err(crate::error::ListImportsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_imports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImportsOutput, crate::error::ListImportsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_imports_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_imports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListImportsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackInstancesOutput,
    crate::error::ListStackInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListStackInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "StackSetNotFoundException" => crate::error::ListStackInstancesError {
            meta: generic,
            kind: crate::error::ListStackInstancesErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStackInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackInstancesOutput,
    crate::error::ListStackInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stack_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_stack_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStackInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_resources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackResourcesOutput,
    crate::error::ListStackResourcesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackResourcesError::unhandled)?;
    Err(crate::error::ListStackResourcesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_resources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackResourcesOutput,
    crate::error::ListStackResourcesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stack_resources_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_stack_resources(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStackResourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stacks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStacksOutput, crate::error::ListStacksError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStacksError::unhandled)?;
    Err(crate::error::ListStacksError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stacks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStacksOutput, crate::error::ListStacksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stacks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_stacks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStacksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_set_operation_results_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackSetOperationResultsOutput,
    crate::error::ListStackSetOperationResultsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackSetOperationResultsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListStackSetOperationResultsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotFoundException" => crate::error::ListStackSetOperationResultsError {
            meta: generic,
            kind: crate::error::ListStackSetOperationResultsErrorKind::OperationNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_operation_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListStackSetOperationResultsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "StackSetNotFoundException" => crate::error::ListStackSetOperationResultsError {
            meta: generic,
            kind: crate::error::ListStackSetOperationResultsErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListStackSetOperationResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStackSetOperationResultsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_set_operation_results_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackSetOperationResultsOutput,
    crate::error::ListStackSetOperationResultsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stack_set_operation_results_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_stack_set_operation_results(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListStackSetOperationResultsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_set_operations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackSetOperationsOutput,
    crate::error::ListStackSetOperationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackSetOperationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListStackSetOperationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "StackSetNotFoundException" => crate::error::ListStackSetOperationsError {
            meta: generic,
            kind: crate::error::ListStackSetOperationsErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListStackSetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStackSetOperationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_set_operations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackSetOperationsOutput,
    crate::error::ListStackSetOperationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stack_set_operations_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_stack_set_operations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStackSetOperationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStackSetsOutput, crate::error::ListStackSetsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackSetsError::unhandled)?;
    Err(crate::error::ListStackSetsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStackSetsOutput, crate::error::ListStackSetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_stack_sets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_stack_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStackSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_type_registrations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTypeRegistrationsOutput,
    crate::error::ListTypeRegistrationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTypeRegistrationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTypeRegistrationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::ListTypeRegistrationsError {
            meta: generic,
            kind: crate::error::ListTypeRegistrationsErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTypeRegistrationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTypeRegistrationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_type_registrations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTypeRegistrationsOutput,
    crate::error::ListTypeRegistrationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_type_registrations_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_type_registrations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTypeRegistrationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTypesOutput, crate::error::ListTypesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTypesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::ListTypesError {
            meta: generic,
            kind: crate::error::ListTypesErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTypesOutput, crate::error::ListTypesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_types_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_type_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTypeVersionsOutput, crate::error::ListTypeVersionsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTypeVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTypeVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::ListTypeVersionsError {
            meta: generic,
            kind: crate::error::ListTypeVersionsErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTypeVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTypeVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_type_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTypeVersionsOutput, crate::error::ListTypeVersionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_type_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_type_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTypeVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishTypeOutput, crate::error::PublishTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::PublishTypeError {
            meta: generic,
            kind: crate::error::PublishTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::PublishTypeError {
            meta: generic,
            kind: crate::error::PublishTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PublishTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishTypeOutput, crate::error::PublishTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_publish_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PublishTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_record_handler_progress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RecordHandlerProgressOutput,
    crate::error::RecordHandlerProgressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RecordHandlerProgressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RecordHandlerProgressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidStateTransition" => crate::error::RecordHandlerProgressError {
            meta: generic,
            kind: crate::error::RecordHandlerProgressErrorKind::InvalidStateTransitionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_state_transition_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_state_transition_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RecordHandlerProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConditionalCheckFailed" => crate::error::RecordHandlerProgressError {
            meta: generic,
            kind: crate::error::RecordHandlerProgressErrorKind::OperationStatusCheckFailedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_status_check_failed_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_operation_status_check_failed_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RecordHandlerProgressError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::RecordHandlerProgressError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_record_handler_progress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RecordHandlerProgressOutput,
    crate::error::RecordHandlerProgressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::record_handler_progress_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_publisher_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterPublisherOutput, crate::error::RegisterPublisherError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterPublisherError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterPublisherError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::RegisterPublisherError {
            meta: generic,
            kind: crate::error::RegisterPublisherErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterPublisherError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterPublisherError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_publisher_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterPublisherOutput, crate::error::RegisterPublisherError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_publisher_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_register_publisher(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterPublisherError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterTypeOutput, crate::error::RegisterTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::RegisterTypeError {
            meta: generic,
            kind: crate::error::RegisterTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterTypeOutput, crate::error::RegisterTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_register_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rollback_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RollbackStackOutput, crate::error::RollbackStackError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RollbackStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RollbackStackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TokenAlreadyExistsException" => crate::error::RollbackStackError {
            meta: generic,
            kind: crate::error::RollbackStackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RollbackStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RollbackStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rollback_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RollbackStackOutput, crate::error::RollbackStackError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::rollback_stack_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_rollback_stack(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RollbackStackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_stack_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetStackPolicyOutput, crate::error::SetStackPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetStackPolicyError::unhandled)?;
    Err(crate::error::SetStackPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_stack_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetStackPolicyOutput, crate::error::SetStackPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_stack_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_type_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTypeConfigurationOutput,
    crate::error::SetTypeConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetTypeConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetTypeConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::SetTypeConfigurationError {
            meta: generic,
            kind: crate::error::SetTypeConfigurationErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTypeConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::SetTypeConfigurationError {
            meta: generic,
            kind: crate::error::SetTypeConfigurationErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTypeConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetTypeConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_type_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTypeConfigurationOutput,
    crate::error::SetTypeConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_type_configuration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_set_type_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetTypeConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_type_default_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTypeDefaultVersionOutput,
    crate::error::SetTypeDefaultVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetTypeDefaultVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetTypeDefaultVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::SetTypeDefaultVersionError {
            meta: generic,
            kind: crate::error::SetTypeDefaultVersionErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTypeDefaultVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::SetTypeDefaultVersionError {
            meta: generic,
            kind: crate::error::SetTypeDefaultVersionErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTypeDefaultVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetTypeDefaultVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_type_default_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTypeDefaultVersionOutput,
    crate::error::SetTypeDefaultVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_type_default_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_signal_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignalResourceOutput, crate::error::SignalResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SignalResourceError::unhandled)?;
    Err(crate::error::SignalResourceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_signal_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignalResourceOutput, crate::error::SignalResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::signal_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_stack_set_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopStackSetOperationOutput,
    crate::error::StopStackSetOperationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopStackSetOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopStackSetOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::StopStackSetOperationError {
            meta: generic,
            kind: crate::error::StopStackSetOperationErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StopStackSetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotFoundException" => crate::error::StopStackSetOperationError {
            meta: generic,
            kind: crate::error::StopStackSetOperationErrorKind::OperationNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StopStackSetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::StopStackSetOperationError {
            meta: generic,
            kind: crate::error::StopStackSetOperationErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StopStackSetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopStackSetOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_stack_set_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopStackSetOperationOutput,
    crate::error::StopStackSetOperationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_stack_set_operation_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestTypeOutput, crate::error::TestTypeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CFNRegistryException" => crate::error::TestTypeError {
            meta: generic,
            kind: crate::error::TestTypeErrorKind::CfnRegistryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cfn_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cfn_registry_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TypeNotFoundException" => crate::error::TestTypeError {
            meta: generic,
            kind: crate::error::TestTypeErrorKind::TypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TestTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestTypeOutput, crate::error::TestTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::test_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_test_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TestTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStackOutput, crate::error::UpdateStackError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateStackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientCapabilitiesException" => crate::error::UpdateStackError {
            meta: generic,
            kind: crate::error::UpdateStackErrorKind::InsufficientCapabilitiesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_capabilities_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_capabilities_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TokenAlreadyExistsException" => crate::error::UpdateStackError {
            meta: generic,
            kind: crate::error::UpdateStackErrorKind::TokenAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::token_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_token_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStackOutput, crate::error::UpdateStackError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_stack_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_stack(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStackInstancesOutput,
    crate::error::UpdateStackInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStackInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateStackInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationIdAlreadyExistsException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_id_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_id_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackInstanceNotFoundException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::StackInstanceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_instance_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_instance_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleRequestException" => crate::error::UpdateStackInstancesError {
            meta: generic,
            kind: crate::error::UpdateStackInstancesErrorKind::StaleRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stale_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stale_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStackInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStackInstancesOutput,
    crate::error::UpdateStackInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_stack_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_stack_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStackInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStackSetOutput, crate::error::UpdateStackSetError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStackSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateStackSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOperationException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::InvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationIdAlreadyExistsException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::OperationIdAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_id_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_id_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackInstanceNotFoundException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::StackInstanceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_instance_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_instance_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StackSetNotFoundException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::StackSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stack_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stack_set_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleRequestException" => crate::error::UpdateStackSetError {
            meta: generic,
            kind: crate::error::UpdateStackSetErrorKind::StaleRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stale_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_stale_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStackSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStackSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_stack_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateStackSetOutput, crate::error::UpdateStackSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_stack_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_stack_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStackSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_termination_protection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTerminationProtectionOutput,
    crate::error::UpdateTerminationProtectionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTerminationProtectionError::unhandled)?;
    Err(crate::error::UpdateTerminationProtectionError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_termination_protection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTerminationProtectionOutput,
    crate::error::UpdateTerminationProtectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_termination_protection_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_termination_protection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTerminationProtectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ValidateTemplateOutput, crate::error::ValidateTemplateError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ValidateTemplateError::unhandled)?;
    Err(crate::error::ValidateTemplateError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ValidateTemplateOutput, crate::error::ValidateTemplateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::validate_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_validate_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ValidateTemplateError::unhandled)?;
        output.build()
    })
}
