// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CloudFormation`.
///
/// This client allows ergonomic access to a `CloudFormation`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ActivateType` operation.
    ///
    /// See [`ActivateType`](crate::client::fluent_builders::ActivateType) for more information about the
    /// operation and its arguments.
    pub fn activate_type(&self) -> fluent_builders::ActivateType<C, M, R> {
        fluent_builders::ActivateType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDescribeTypeConfigurations` operation.
    ///
    /// See [`BatchDescribeTypeConfigurations`](crate::client::fluent_builders::BatchDescribeTypeConfigurations) for more information about the
    /// operation and its arguments.
    pub fn batch_describe_type_configurations(
        &self,
    ) -> fluent_builders::BatchDescribeTypeConfigurations<C, M, R> {
        fluent_builders::BatchDescribeTypeConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelUpdateStack` operation.
    ///
    /// See [`CancelUpdateStack`](crate::client::fluent_builders::CancelUpdateStack) for more information about the
    /// operation and its arguments.
    pub fn cancel_update_stack(&self) -> fluent_builders::CancelUpdateStack<C, M, R> {
        fluent_builders::CancelUpdateStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ContinueUpdateRollback` operation.
    ///
    /// See [`ContinueUpdateRollback`](crate::client::fluent_builders::ContinueUpdateRollback) for more information about the
    /// operation and its arguments.
    pub fn continue_update_rollback(&self) -> fluent_builders::ContinueUpdateRollback<C, M, R> {
        fluent_builders::ContinueUpdateRollback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChangeSet` operation.
    ///
    /// See [`CreateChangeSet`](crate::client::fluent_builders::CreateChangeSet) for more information about the
    /// operation and its arguments.
    pub fn create_change_set(&self) -> fluent_builders::CreateChangeSet<C, M, R> {
        fluent_builders::CreateChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStack` operation.
    ///
    /// See [`CreateStack`](crate::client::fluent_builders::CreateStack) for more information about the
    /// operation and its arguments.
    pub fn create_stack(&self) -> fluent_builders::CreateStack<C, M, R> {
        fluent_builders::CreateStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStackInstances` operation.
    ///
    /// See [`CreateStackInstances`](crate::client::fluent_builders::CreateStackInstances) for more information about the
    /// operation and its arguments.
    pub fn create_stack_instances(&self) -> fluent_builders::CreateStackInstances<C, M, R> {
        fluent_builders::CreateStackInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStackSet` operation.
    ///
    /// See [`CreateStackSet`](crate::client::fluent_builders::CreateStackSet) for more information about the
    /// operation and its arguments.
    pub fn create_stack_set(&self) -> fluent_builders::CreateStackSet<C, M, R> {
        fluent_builders::CreateStackSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeactivateType` operation.
    ///
    /// See [`DeactivateType`](crate::client::fluent_builders::DeactivateType) for more information about the
    /// operation and its arguments.
    pub fn deactivate_type(&self) -> fluent_builders::DeactivateType<C, M, R> {
        fluent_builders::DeactivateType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChangeSet` operation.
    ///
    /// See [`DeleteChangeSet`](crate::client::fluent_builders::DeleteChangeSet) for more information about the
    /// operation and its arguments.
    pub fn delete_change_set(&self) -> fluent_builders::DeleteChangeSet<C, M, R> {
        fluent_builders::DeleteChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStack` operation.
    ///
    /// See [`DeleteStack`](crate::client::fluent_builders::DeleteStack) for more information about the
    /// operation and its arguments.
    pub fn delete_stack(&self) -> fluent_builders::DeleteStack<C, M, R> {
        fluent_builders::DeleteStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStackInstances` operation.
    ///
    /// See [`DeleteStackInstances`](crate::client::fluent_builders::DeleteStackInstances) for more information about the
    /// operation and its arguments.
    pub fn delete_stack_instances(&self) -> fluent_builders::DeleteStackInstances<C, M, R> {
        fluent_builders::DeleteStackInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStackSet` operation.
    ///
    /// See [`DeleteStackSet`](crate::client::fluent_builders::DeleteStackSet) for more information about the
    /// operation and its arguments.
    pub fn delete_stack_set(&self) -> fluent_builders::DeleteStackSet<C, M, R> {
        fluent_builders::DeleteStackSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterType` operation.
    ///
    /// See [`DeregisterType`](crate::client::fluent_builders::DeregisterType) for more information about the
    /// operation and its arguments.
    pub fn deregister_type(&self) -> fluent_builders::DeregisterType<C, M, R> {
        fluent_builders::DeregisterType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountLimits` operation.
    ///
    /// See [`DescribeAccountLimits`](crate::client::fluent_builders::DescribeAccountLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_account_limits(&self) -> fluent_builders::DescribeAccountLimits<C, M, R> {
        fluent_builders::DescribeAccountLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChangeSet` operation.
    ///
    /// See [`DescribeChangeSet`](crate::client::fluent_builders::DescribeChangeSet) for more information about the
    /// operation and its arguments.
    pub fn describe_change_set(&self) -> fluent_builders::DescribeChangeSet<C, M, R> {
        fluent_builders::DescribeChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePublisher` operation.
    ///
    /// See [`DescribePublisher`](crate::client::fluent_builders::DescribePublisher) for more information about the
    /// operation and its arguments.
    pub fn describe_publisher(&self) -> fluent_builders::DescribePublisher<C, M, R> {
        fluent_builders::DescribePublisher::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackDriftDetectionStatus` operation.
    ///
    /// See [`DescribeStackDriftDetectionStatus`](crate::client::fluent_builders::DescribeStackDriftDetectionStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_drift_detection_status(
        &self,
    ) -> fluent_builders::DescribeStackDriftDetectionStatus<C, M, R> {
        fluent_builders::DescribeStackDriftDetectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackEvents` operation.
    ///
    /// See [`DescribeStackEvents`](crate::client::fluent_builders::DescribeStackEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_events(&self) -> fluent_builders::DescribeStackEvents<C, M, R> {
        fluent_builders::DescribeStackEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackInstance` operation.
    ///
    /// See [`DescribeStackInstance`](crate::client::fluent_builders::DescribeStackInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_instance(&self) -> fluent_builders::DescribeStackInstance<C, M, R> {
        fluent_builders::DescribeStackInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackResource` operation.
    ///
    /// See [`DescribeStackResource`](crate::client::fluent_builders::DescribeStackResource) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_resource(&self) -> fluent_builders::DescribeStackResource<C, M, R> {
        fluent_builders::DescribeStackResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackResourceDrifts` operation.
    ///
    /// See [`DescribeStackResourceDrifts`](crate::client::fluent_builders::DescribeStackResourceDrifts) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_resource_drifts(
        &self,
    ) -> fluent_builders::DescribeStackResourceDrifts<C, M, R> {
        fluent_builders::DescribeStackResourceDrifts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackResources` operation.
    ///
    /// See [`DescribeStackResources`](crate::client::fluent_builders::DescribeStackResources) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_resources(&self) -> fluent_builders::DescribeStackResources<C, M, R> {
        fluent_builders::DescribeStackResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStacks` operation.
    ///
    /// See [`DescribeStacks`](crate::client::fluent_builders::DescribeStacks) for more information about the
    /// operation and its arguments.
    pub fn describe_stacks(&self) -> fluent_builders::DescribeStacks<C, M, R> {
        fluent_builders::DescribeStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackSet` operation.
    ///
    /// See [`DescribeStackSet`](crate::client::fluent_builders::DescribeStackSet) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_set(&self) -> fluent_builders::DescribeStackSet<C, M, R> {
        fluent_builders::DescribeStackSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStackSetOperation` operation.
    ///
    /// See [`DescribeStackSetOperation`](crate::client::fluent_builders::DescribeStackSetOperation) for more information about the
    /// operation and its arguments.
    pub fn describe_stack_set_operation(
        &self,
    ) -> fluent_builders::DescribeStackSetOperation<C, M, R> {
        fluent_builders::DescribeStackSetOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeType` operation.
    ///
    /// See [`DescribeType`](crate::client::fluent_builders::DescribeType) for more information about the
    /// operation and its arguments.
    pub fn describe_type(&self) -> fluent_builders::DescribeType<C, M, R> {
        fluent_builders::DescribeType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTypeRegistration` operation.
    ///
    /// See [`DescribeTypeRegistration`](crate::client::fluent_builders::DescribeTypeRegistration) for more information about the
    /// operation and its arguments.
    pub fn describe_type_registration(&self) -> fluent_builders::DescribeTypeRegistration<C, M, R> {
        fluent_builders::DescribeTypeRegistration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectStackDrift` operation.
    ///
    /// See [`DetectStackDrift`](crate::client::fluent_builders::DetectStackDrift) for more information about the
    /// operation and its arguments.
    pub fn detect_stack_drift(&self) -> fluent_builders::DetectStackDrift<C, M, R> {
        fluent_builders::DetectStackDrift::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectStackResourceDrift` operation.
    ///
    /// See [`DetectStackResourceDrift`](crate::client::fluent_builders::DetectStackResourceDrift) for more information about the
    /// operation and its arguments.
    pub fn detect_stack_resource_drift(
        &self,
    ) -> fluent_builders::DetectStackResourceDrift<C, M, R> {
        fluent_builders::DetectStackResourceDrift::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectStackSetDrift` operation.
    ///
    /// See [`DetectStackSetDrift`](crate::client::fluent_builders::DetectStackSetDrift) for more information about the
    /// operation and its arguments.
    pub fn detect_stack_set_drift(&self) -> fluent_builders::DetectStackSetDrift<C, M, R> {
        fluent_builders::DetectStackSetDrift::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EstimateTemplateCost` operation.
    ///
    /// See [`EstimateTemplateCost`](crate::client::fluent_builders::EstimateTemplateCost) for more information about the
    /// operation and its arguments.
    pub fn estimate_template_cost(&self) -> fluent_builders::EstimateTemplateCost<C, M, R> {
        fluent_builders::EstimateTemplateCost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteChangeSet` operation.
    ///
    /// See [`ExecuteChangeSet`](crate::client::fluent_builders::ExecuteChangeSet) for more information about the
    /// operation and its arguments.
    pub fn execute_change_set(&self) -> fluent_builders::ExecuteChangeSet<C, M, R> {
        fluent_builders::ExecuteChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStackPolicy` operation.
    ///
    /// See [`GetStackPolicy`](crate::client::fluent_builders::GetStackPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_stack_policy(&self) -> fluent_builders::GetStackPolicy<C, M, R> {
        fluent_builders::GetStackPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTemplate` operation.
    ///
    /// See [`GetTemplate`](crate::client::fluent_builders::GetTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_template(&self) -> fluent_builders::GetTemplate<C, M, R> {
        fluent_builders::GetTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTemplateSummary` operation.
    ///
    /// See [`GetTemplateSummary`](crate::client::fluent_builders::GetTemplateSummary) for more information about the
    /// operation and its arguments.
    pub fn get_template_summary(&self) -> fluent_builders::GetTemplateSummary<C, M, R> {
        fluent_builders::GetTemplateSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportStacksToStackSet` operation.
    ///
    /// See [`ImportStacksToStackSet`](crate::client::fluent_builders::ImportStacksToStackSet) for more information about the
    /// operation and its arguments.
    pub fn import_stacks_to_stack_set(&self) -> fluent_builders::ImportStacksToStackSet<C, M, R> {
        fluent_builders::ImportStacksToStackSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChangeSets` operation.
    ///
    /// See [`ListChangeSets`](crate::client::fluent_builders::ListChangeSets) for more information about the
    /// operation and its arguments.
    pub fn list_change_sets(&self) -> fluent_builders::ListChangeSets<C, M, R> {
        fluent_builders::ListChangeSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExports` operation.
    ///
    /// See [`ListExports`](crate::client::fluent_builders::ListExports) for more information about the
    /// operation and its arguments.
    pub fn list_exports(&self) -> fluent_builders::ListExports<C, M, R> {
        fluent_builders::ListExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImports` operation.
    ///
    /// See [`ListImports`](crate::client::fluent_builders::ListImports) for more information about the
    /// operation and its arguments.
    pub fn list_imports(&self) -> fluent_builders::ListImports<C, M, R> {
        fluent_builders::ListImports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackInstances` operation.
    ///
    /// See [`ListStackInstances`](crate::client::fluent_builders::ListStackInstances) for more information about the
    /// operation and its arguments.
    pub fn list_stack_instances(&self) -> fluent_builders::ListStackInstances<C, M, R> {
        fluent_builders::ListStackInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackResources` operation.
    ///
    /// See [`ListStackResources`](crate::client::fluent_builders::ListStackResources) for more information about the
    /// operation and its arguments.
    pub fn list_stack_resources(&self) -> fluent_builders::ListStackResources<C, M, R> {
        fluent_builders::ListStackResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStacks` operation.
    ///
    /// See [`ListStacks`](crate::client::fluent_builders::ListStacks) for more information about the
    /// operation and its arguments.
    pub fn list_stacks(&self) -> fluent_builders::ListStacks<C, M, R> {
        fluent_builders::ListStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackSetOperationResults` operation.
    ///
    /// See [`ListStackSetOperationResults`](crate::client::fluent_builders::ListStackSetOperationResults) for more information about the
    /// operation and its arguments.
    pub fn list_stack_set_operation_results(
        &self,
    ) -> fluent_builders::ListStackSetOperationResults<C, M, R> {
        fluent_builders::ListStackSetOperationResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackSetOperations` operation.
    ///
    /// See [`ListStackSetOperations`](crate::client::fluent_builders::ListStackSetOperations) for more information about the
    /// operation and its arguments.
    pub fn list_stack_set_operations(&self) -> fluent_builders::ListStackSetOperations<C, M, R> {
        fluent_builders::ListStackSetOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackSets` operation.
    ///
    /// See [`ListStackSets`](crate::client::fluent_builders::ListStackSets) for more information about the
    /// operation and its arguments.
    pub fn list_stack_sets(&self) -> fluent_builders::ListStackSets<C, M, R> {
        fluent_builders::ListStackSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypeRegistrations` operation.
    ///
    /// See [`ListTypeRegistrations`](crate::client::fluent_builders::ListTypeRegistrations) for more information about the
    /// operation and its arguments.
    pub fn list_type_registrations(&self) -> fluent_builders::ListTypeRegistrations<C, M, R> {
        fluent_builders::ListTypeRegistrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypes` operation.
    ///
    /// See [`ListTypes`](crate::client::fluent_builders::ListTypes) for more information about the
    /// operation and its arguments.
    pub fn list_types(&self) -> fluent_builders::ListTypes<C, M, R> {
        fluent_builders::ListTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypeVersions` operation.
    ///
    /// See [`ListTypeVersions`](crate::client::fluent_builders::ListTypeVersions) for more information about the
    /// operation and its arguments.
    pub fn list_type_versions(&self) -> fluent_builders::ListTypeVersions<C, M, R> {
        fluent_builders::ListTypeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishType` operation.
    ///
    /// See [`PublishType`](crate::client::fluent_builders::PublishType) for more information about the
    /// operation and its arguments.
    pub fn publish_type(&self) -> fluent_builders::PublishType<C, M, R> {
        fluent_builders::PublishType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RecordHandlerProgress` operation.
    ///
    /// See [`RecordHandlerProgress`](crate::client::fluent_builders::RecordHandlerProgress) for more information about the
    /// operation and its arguments.
    pub fn record_handler_progress(&self) -> fluent_builders::RecordHandlerProgress<C, M, R> {
        fluent_builders::RecordHandlerProgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterPublisher` operation.
    ///
    /// See [`RegisterPublisher`](crate::client::fluent_builders::RegisterPublisher) for more information about the
    /// operation and its arguments.
    pub fn register_publisher(&self) -> fluent_builders::RegisterPublisher<C, M, R> {
        fluent_builders::RegisterPublisher::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterType` operation.
    ///
    /// See [`RegisterType`](crate::client::fluent_builders::RegisterType) for more information about the
    /// operation and its arguments.
    pub fn register_type(&self) -> fluent_builders::RegisterType<C, M, R> {
        fluent_builders::RegisterType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RollbackStack` operation.
    ///
    /// See [`RollbackStack`](crate::client::fluent_builders::RollbackStack) for more information about the
    /// operation and its arguments.
    pub fn rollback_stack(&self) -> fluent_builders::RollbackStack<C, M, R> {
        fluent_builders::RollbackStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetStackPolicy` operation.
    ///
    /// See [`SetStackPolicy`](crate::client::fluent_builders::SetStackPolicy) for more information about the
    /// operation and its arguments.
    pub fn set_stack_policy(&self) -> fluent_builders::SetStackPolicy<C, M, R> {
        fluent_builders::SetStackPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetTypeConfiguration` operation.
    ///
    /// See [`SetTypeConfiguration`](crate::client::fluent_builders::SetTypeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn set_type_configuration(&self) -> fluent_builders::SetTypeConfiguration<C, M, R> {
        fluent_builders::SetTypeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetTypeDefaultVersion` operation.
    ///
    /// See [`SetTypeDefaultVersion`](crate::client::fluent_builders::SetTypeDefaultVersion) for more information about the
    /// operation and its arguments.
    pub fn set_type_default_version(&self) -> fluent_builders::SetTypeDefaultVersion<C, M, R> {
        fluent_builders::SetTypeDefaultVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SignalResource` operation.
    ///
    /// See [`SignalResource`](crate::client::fluent_builders::SignalResource) for more information about the
    /// operation and its arguments.
    pub fn signal_resource(&self) -> fluent_builders::SignalResource<C, M, R> {
        fluent_builders::SignalResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopStackSetOperation` operation.
    ///
    /// See [`StopStackSetOperation`](crate::client::fluent_builders::StopStackSetOperation) for more information about the
    /// operation and its arguments.
    pub fn stop_stack_set_operation(&self) -> fluent_builders::StopStackSetOperation<C, M, R> {
        fluent_builders::StopStackSetOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestType` operation.
    ///
    /// See [`TestType`](crate::client::fluent_builders::TestType) for more information about the
    /// operation and its arguments.
    pub fn test_type(&self) -> fluent_builders::TestType<C, M, R> {
        fluent_builders::TestType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStack` operation.
    ///
    /// See [`UpdateStack`](crate::client::fluent_builders::UpdateStack) for more information about the
    /// operation and its arguments.
    pub fn update_stack(&self) -> fluent_builders::UpdateStack<C, M, R> {
        fluent_builders::UpdateStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStackInstances` operation.
    ///
    /// See [`UpdateStackInstances`](crate::client::fluent_builders::UpdateStackInstances) for more information about the
    /// operation and its arguments.
    pub fn update_stack_instances(&self) -> fluent_builders::UpdateStackInstances<C, M, R> {
        fluent_builders::UpdateStackInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStackSet` operation.
    ///
    /// See [`UpdateStackSet`](crate::client::fluent_builders::UpdateStackSet) for more information about the
    /// operation and its arguments.
    pub fn update_stack_set(&self) -> fluent_builders::UpdateStackSet<C, M, R> {
        fluent_builders::UpdateStackSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTerminationProtection` operation.
    ///
    /// See [`UpdateTerminationProtection`](crate::client::fluent_builders::UpdateTerminationProtection) for more information about the
    /// operation and its arguments.
    pub fn update_termination_protection(
        &self,
    ) -> fluent_builders::UpdateTerminationProtection<C, M, R> {
        fluent_builders::UpdateTerminationProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidateTemplate` operation.
    ///
    /// See [`ValidateTemplate`](crate::client::fluent_builders::ValidateTemplate) for more information about the
    /// operation and its arguments.
    pub fn validate_template(&self) -> fluent_builders::ValidateTemplate<C, M, R> {
        fluent_builders::ValidateTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateType`.
    ///
    /// <p>Activates a public third-party extension, making it available for use in stack
    /// templates. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using
    /// public extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    /// <p>Once you have activated a public third-party extension in your account and region, use
    /// <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify configuration properties for the extension. For
    /// more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level</a> in the <i>CloudFormation
    /// User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ActivateType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_type_input::Builder,
    }
    impl<C, M, R> ActivateType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateTypeInputOperationOutputAlias,
                crate::output::ActivateTypeOutput,
                crate::error::ActivateTypeError,
                crate::input::ActivateTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ThirdPartyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the public extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn public_type_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_type_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the public extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_public_type_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_type_arn(input);
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn publisher_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.publisher_id(inp);
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_publisher_id(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>,
        /// <code>Type</code>, and <code>PublisherId</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>An alias to assign to the public extension, in this account and region. If you specify
        /// an alias for the extension, CloudFormation treats the alias as the extension type name
        /// within this account and region. You must use the alias to refer to the extension in your
        /// templates, API calls, and CloudFormation console.</p>
        /// <p>An extension alias must be unique within a given account and region. You can activate
        /// the same public resource multiple times in the same account and region, using different
        /// type name aliases.</p>
        pub fn type_name_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name_alias(inp);
            self
        }
        /// <p>An alias to assign to the public extension, in this account and region. If you specify
        /// an alias for the extension, CloudFormation treats the alias as the extension type name
        /// within this account and region. You must use the alias to refer to the extension in your
        /// templates, API calls, and CloudFormation console.</p>
        /// <p>An extension alias must be unique within a given account and region. You can activate
        /// the same public resource multiple times in the same account and region, using different
        /// type name aliases.</p>
        pub fn set_type_name_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_type_name_alias(input);
            self
        }
        /// <p>Whether to automatically update the extension in this account and region when a new
        /// <i>minor</i> version is published by the extension publisher. Major
        /// versions released by the publisher must be manually updated.</p>
        /// <p>The default is <code>true</code>.</p>
        pub fn auto_update(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_update(inp);
            self
        }
        /// <p>Whether to automatically update the extension in this account and region when a new
        /// <i>minor</i> version is published by the extension publisher. Major
        /// versions released by the publisher must be manually updated.</p>
        /// <p>The default is <code>true</code>.</p>
        pub fn set_auto_update(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_update(input);
            self
        }
        /// <p>Contains logging configuration information for an extension.</p>
        pub fn logging_config(mut self, inp: crate::model::LoggingConfig) -> Self {
            self.inner = self.inner.logging_config(inp);
            self
        }
        /// <p>Contains logging configuration information for an extension.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.inner = self.inner.set_logging_config(input);
            self
        }
        /// <p>The name of the IAM execution role to use to activate the extension.</p>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>The name of the IAM execution role to use to activate the extension.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>Manually updates a previously-activated type to a new major or minor version, if
        /// available. You can also use this parameter to update the value of
        /// <code>AutoUpdate</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MAJOR</code>: CloudFormation updates the extension to the newest major
        /// version, if one is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MINOR</code>: CloudFormation updates the extension to the newest minor
        /// version, if one is available.</p>
        /// </li>
        /// </ul>
        pub fn version_bump(mut self, inp: crate::model::VersionBump) -> Self {
            self.inner = self.inner.version_bump(inp);
            self
        }
        /// <p>Manually updates a previously-activated type to a new major or minor version, if
        /// available. You can also use this parameter to update the value of
        /// <code>AutoUpdate</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MAJOR</code>: CloudFormation updates the extension to the newest major
        /// version, if one is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MINOR</code>: CloudFormation updates the extension to the newest minor
        /// version, if one is available.</p>
        /// </li>
        /// </ul>
        pub fn set_version_bump(
            mut self,
            input: std::option::Option<crate::model::VersionBump>,
        ) -> Self {
            self.inner = self.inner.set_version_bump(input);
            self
        }
        /// <p>The major version of this extension you want to activate, if multiple major versions are
        /// available. The default is the latest major version. CloudFormation uses the latest
        /// available <i>minor</i> version of the major version selected.</p>
        /// <p>You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not
        /// both.</p>
        pub fn major_version(mut self, inp: i64) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>The major version of this extension you want to activate, if multiple major versions are
        /// available. The default is the latest major version. CloudFormation uses the latest
        /// available <i>minor</i> version of the major version selected.</p>
        /// <p>You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not
        /// both.</p>
        pub fn set_major_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDescribeTypeConfigurations`.
    ///
    /// <p>Returns configuration data for the specified CloudFormation extensions, from the
    /// CloudFormation registry for the account and region.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level</a> in the
    /// <i>CloudFormation User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDescribeTypeConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_describe_type_configurations_input::Builder,
    }
    impl<C, M, R> BatchDescribeTypeConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDescribeTypeConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDescribeTypeConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDescribeTypeConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDescribeTypeConfigurationsInputOperationOutputAlias,
                crate::output::BatchDescribeTypeConfigurationsOutput,
                crate::error::BatchDescribeTypeConfigurationsError,
                crate::input::BatchDescribeTypeConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TypeConfigurationIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_type_configuration_identifiers`](Self::set_type_configuration_identifiers).
        ///
        /// <p>The list of identifiers for the desired extension configurations.</p>
        pub fn type_configuration_identifiers(
            mut self,
            inp: impl Into<crate::model::TypeConfigurationIdentifier>,
        ) -> Self {
            self.inner = self.inner.type_configuration_identifiers(inp);
            self
        }
        /// <p>The list of identifiers for the desired extension configurations.</p>
        pub fn set_type_configuration_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypeConfigurationIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_type_configuration_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelUpdateStack`.
    ///
    /// <p>Cancels an update on the specified stack. If the call completes successfully, the
    /// stack rolls back the update and reverts to the previous stack configuration.</p>
    /// <note>
    /// <p>You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CancelUpdateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_update_stack_input::Builder,
    }
    impl<C, M, R> CancelUpdateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelUpdateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelUpdateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelUpdateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelUpdateStackInputOperationOutputAlias,
                crate::output::CancelUpdateStackOutput,
                crate::error::CancelUpdateStackError,
                crate::input::CancelUpdateStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to cancel an update on a stack with the same name. You might retry
        /// <code>CancelUpdateStack</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to cancel an update on a stack with the same name. You might retry
        /// <code>CancelUpdateStack</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ContinueUpdateRollback`.
    ///
    /// <p>For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state,
    /// continues rolling it back to the <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on
    /// the cause of the failure, you can manually <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> fix the error</a> and continue the rollback. By continuing the rollback, you can
    /// return your stack to a working state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and
    /// then try to update the stack again.</p>
    /// <p>A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when
    /// CloudFormation cannot roll back all changes after a failed stack update. For example, you
    /// might have a stack that is rolling back to an old database instance that was deleted
    /// outside of CloudFormation. Because CloudFormation doesn't know the database was
    /// deleted, it assumes that the database instance still exists and attempts to roll back to
    /// it, causing the update rollback to fail.</p>
    #[derive(std::fmt::Debug)]
    pub struct ContinueUpdateRollback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::continue_update_rollback_input::Builder,
    }
    impl<C, M, R> ContinueUpdateRollback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ContinueUpdateRollback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ContinueUpdateRollbackOutput,
            aws_smithy_http::result::SdkError<crate::error::ContinueUpdateRollbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ContinueUpdateRollbackInputOperationOutputAlias,
                crate::output::ContinueUpdateRollbackOutput,
                crate::error::ContinueUpdateRollbackError,
                crate::input::ContinueUpdateRollbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique ID of the stack that you want to continue rolling
        /// back.</p>
        /// <note>
        /// <p>Don't specify the name of a nested stack (a stack that was created by using the
        /// <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the
        /// parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code>
        /// resource).</p>
        /// </note>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique ID of the stack that you want to continue rolling
        /// back.</p>
        /// <note>
        /// <p>Don't specify the name of a nested stack (a stack that was created by using the
        /// <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the
        /// parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code>
        /// resource).</p>
        /// </note>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to roll back the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to roll back the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `ResourcesToSkip`.
        ///
        /// To override the contents of this collection use [`set_resources_to_skip`](Self::set_resources_to_skip).
        ///
        /// <p>A list of the logical IDs of the resources that CloudFormation skips during the
        /// continue update rollback operation. You can specify only resources that are in the
        /// <code>UPDATE_FAILED</code> state because a rollback failed. You can't specify resources
        /// that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an
        /// update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
        /// <important>
        /// <p>Specify this property to skip rolling back resources that CloudFormation
        /// can't successfully roll back. We recommend that you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. CloudFormation sets
        /// the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to
        /// roll back the stack. After the rollback is complete, the state of the skipped resources
        /// will be inconsistent with the state of the resources in the stack template. Before
        /// performing another stack update, you must update the stack or resources to be consistent
        /// with each other. If you don't, subsequent stack updates might fail, and the stack will
        /// become unrecoverable.</p>
        /// </important>
        /// <p>Specify the minimum number of resources required to successfully roll back your stack.
        /// For example, a failed resource update might cause dependent resources to fail. In this
        /// case, it might not be necessary to skip the dependent resources.</p>
        /// <p>To skip resources that are part of nested stacks, use the following format:
        /// <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of
        /// a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the
        /// <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one
        /// of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or
        /// <code>DELETE_FAILED</code>.</p>
        /// <note>
        /// <p>Don't confuse a child stack's name with its corresponding logical ID defined in the
        /// parent stack. For an example of a continue update rollback operation with nested stacks,
        /// see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>.</p>
        /// </note>
        pub fn resources_to_skip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resources_to_skip(inp);
            self
        }
        /// <p>A list of the logical IDs of the resources that CloudFormation skips during the
        /// continue update rollback operation. You can specify only resources that are in the
        /// <code>UPDATE_FAILED</code> state because a rollback failed. You can't specify resources
        /// that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an
        /// update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
        /// <important>
        /// <p>Specify this property to skip rolling back resources that CloudFormation
        /// can't successfully roll back. We recommend that you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. CloudFormation sets
        /// the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to
        /// roll back the stack. After the rollback is complete, the state of the skipped resources
        /// will be inconsistent with the state of the resources in the stack template. Before
        /// performing another stack update, you must update the stack or resources to be consistent
        /// with each other. If you don't, subsequent stack updates might fail, and the stack will
        /// become unrecoverable.</p>
        /// </important>
        /// <p>Specify the minimum number of resources required to successfully roll back your stack.
        /// For example, a failed resource update might cause dependent resources to fail. In this
        /// case, it might not be necessary to skip the dependent resources.</p>
        /// <p>To skip resources that are part of nested stacks, use the following format:
        /// <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of
        /// a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the
        /// <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one
        /// of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or
        /// <code>DELETE_FAILED</code>.</p>
        /// <note>
        /// <p>Don't confuse a child stack's name with its corresponding logical ID defined in the
        /// parent stack. For an example of a continue update rollback operation with nested stacks,
        /// see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>.</p>
        /// </note>
        pub fn set_resources_to_skip(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resources_to_skip(input);
            self
        }
        /// <p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify
        /// this token if you plan to retry requests so that CloudFormationknows that you're not
        /// attempting to continue the rollback to a stack with the same name. You might retry
        /// <code>ContinueUpdateRollback</code> requests to ensure that CloudFormation
        /// successfully received them.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify
        /// this token if you plan to retry requests so that CloudFormationknows that you're not
        /// attempting to continue the rollback to a stack with the same name. You might retry
        /// <code>ContinueUpdateRollback</code> requests to ensure that CloudFormation
        /// successfully received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChangeSet`.
    ///
    /// <p>Creates a list of changes that will be applied to a stack so that you can review the
    /// changes before executing them. You can create a change set for a stack that doesn't exist
    /// or an existing stack. If you create a change set for a stack that doesn't exist, the change
    /// set shows all of the resources that CloudFormation will create. If you create a change
    /// set for an existing stack, CloudFormation compares the stack's information with the
    /// information that you submit in the change set and lists the differences. Use change sets to
    /// understand which resources CloudFormation will create or change, and how it will change
    /// resources in an existing stack, before you create or update a stack.</p>
    /// <p>To create a change set for a stack that doesn't exist, for the
    /// <code>ChangeSetType</code> parameter, specify <code>CREATE</code>. To create a change
    /// set for an existing stack, specify <code>UPDATE</code> for the <code>ChangeSetType</code>
    /// parameter. To create a change set for an import operation, specify <code>IMPORT</code> for
    /// the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call
    /// successfully completes, CloudFormation starts creating the change set. To check the
    /// status of the change set or to review it, use the <a>DescribeChangeSet</a>
    /// action.</p>
    /// <p>When you are satisfied with the changes the change set will make, execute the change
    /// set by using the <a>ExecuteChangeSet</a> action. CloudFormation doesn't make
    /// changes until you execute the change set.</p>
    /// <p>To create a change set for the entire stack hierachy, set
    /// <code>IncludeNestedStacks</code> to <code>True</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_change_set_input::Builder,
    }
    impl<C, M, R> CreateChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChangeSetInputOperationOutputAlias,
                crate::output::CreateChangeSetOutput,
                crate::error::CreateChangeSetError,
                crate::input::CreateChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique ID of the stack for which you are creating a change set.
        /// CloudFormation generates the change set by comparing this stack's information with the
        /// information that you submit, such as a modified template or different parameter input
        /// values.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique ID of the stack for which you are creating a change set.
        /// CloudFormation generates the change set by comparing this stack's information with the
        /// information that you submit, such as a modified template or different parameter input
        /// values.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A structure that contains the body of the revised template, with a minimum length of
        /// 1 byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
        /// comparing this template with the template of the stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>A structure that contains the body of the revised template, with a minimum length of
        /// 1 byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
        /// comparing this template with the template of the stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The location of the file that contains the revised template. The URL must point to a
        /// template (max size: 460,800 bytes) that is located in an S3 bucket or a Systems Manager
        /// document. CloudFormation generates the change set by comparing this template with the
        /// stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>The location of the file that contains the revised template. The URL must point to a
        /// template (max size: 460,800 bytes) that is located in an S3 bucket or a Systems Manager
        /// document. CloudFormation generates the change set by comparing this template with the
        /// stack that you specified.</p>
        /// <p>Conditional: You must specify only <code>TemplateBody</code> or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// <p>Whether to reuse the template that is associated with the stack to create the change
        /// set.</p>
        pub fn use_previous_template(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_previous_template(inp);
            self
        }
        /// <p>Whether to reuse the template that is associated with the stack to create the change
        /// set.</p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_previous_template(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// change set. For more information, see the <a>Parameter</a> data type.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// change set. For more information, see the <a>Parameter</a> data type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either
        /// capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you
        /// <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <note>
        /// <p>This capacity does not apply to creating change sets, and specifying it when
        /// creating change sets has no effect.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create or update the stack
        /// directly from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.</p>
        /// </note>
        /// <p>For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either
        /// capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you
        /// <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <note>
        /// <p>This capacity does not apply to creating change sets, and specifying it when
        /// creating change sets has no effect.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create or update the stack
        /// directly from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.</p>
        /// </note>
        /// <p>For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with if you execute
        /// this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource type that you're updating,
        /// the stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for condition keys in
        /// IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with
        /// Identity and Access Management</a> in the CloudFormation User
        /// Guide.</p>
        pub fn resource_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(inp);
            self
        }
        /// <p>The template resource types that you have permissions to work with if you execute
        /// this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource type that you're updating,
        /// the stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for condition keys in
        /// IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with
        /// Identity and Access Management</a> in the CloudFormation User
        /// Guide.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes when executing the change set. CloudFormation uses the
        /// role's credentials to make calls on your behalf. CloudFormation uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes when executing the change set. CloudFormation uses the
        /// role's credentials to make calls on your behalf. CloudFormation uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(mut self, inp: crate::model::RollbackConfiguration) -> Self {
            self.inner = self.inner.rollback_configuration(inp);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rollback_configuration(input);
            self
        }
        /// Appends an item to `NotificationARNs`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS)
        /// topics that CloudFormation associates with the stack. To remove all associated
        /// notification topics, specify an empty list.</p>
        pub fn notification_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_ar_ns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS)
        /// topics that CloudFormation associates with the stack. To remove all associated
        /// notification topics, specify an empty list.</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_ar_ns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to resources in the stack. You can specify a maximum of 50 tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to resources in the stack. You can specify a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the change set. The name must be unique among all change sets that are
        /// associated with the specified stack.</p>
        /// <p>A change set name can contain only alphanumeric, case sensitive characters and
        /// hyphens. It must start with an alphabetic character and cannot exceed 128
        /// characters.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>The name of the change set. The name must be unique among all change sets that are
        /// associated with the specified stack.</p>
        /// <p>A change set name can contain only alphanumeric, case sensitive characters and
        /// hyphens. It must start with an alphabetic character and cannot exceed 128
        /// characters.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another change set with the same name. You might retry
        /// <code>CreateChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another change set with the same name. You might retry
        /// <code>CreateChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A description to help you identify this change set.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description to help you identify this change set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of change set operation. To create a change set for a new stack, specify
        /// <code>CREATE</code>. To create a change set for an existing stack, specify
        /// <code>UPDATE</code>. To create a change set for an import operation, specify
        /// <code>IMPORT</code>.</p>
        /// <p>If you create a change set for a new stack, CloudFormation creates a stack with a
        /// unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
        /// <code>REVIEW_IN_PROGRESS</code>
        /// </a> state until you execute the change
        /// set.</p>
        /// <p>By default, CloudFormation specifies <code>UPDATE</code>. You can't use the
        /// <code>UPDATE</code> type to create a change set for a new stack or the
        /// <code>CREATE</code> type to create a change set for an existing stack.</p>
        pub fn change_set_type(mut self, inp: crate::model::ChangeSetType) -> Self {
            self.inner = self.inner.change_set_type(inp);
            self
        }
        /// <p>The type of change set operation. To create a change set for a new stack, specify
        /// <code>CREATE</code>. To create a change set for an existing stack, specify
        /// <code>UPDATE</code>. To create a change set for an import operation, specify
        /// <code>IMPORT</code>.</p>
        /// <p>If you create a change set for a new stack, CloudFormation creates a stack with a
        /// unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
        /// <code>REVIEW_IN_PROGRESS</code>
        /// </a> state until you execute the change
        /// set.</p>
        /// <p>By default, CloudFormation specifies <code>UPDATE</code>. You can't use the
        /// <code>UPDATE</code> type to create a change set for a new stack or the
        /// <code>CREATE</code> type to create a change set for an existing stack.</p>
        pub fn set_change_set_type(
            mut self,
            input: std::option::Option<crate::model::ChangeSetType>,
        ) -> Self {
            self.inner = self.inner.set_change_set_type(input);
            self
        }
        /// Appends an item to `ResourcesToImport`.
        ///
        /// To override the contents of this collection use [`set_resources_to_import`](Self::set_resources_to_import).
        ///
        /// <p>The resources to import into your stack.</p>
        pub fn resources_to_import(
            mut self,
            inp: impl Into<crate::model::ResourceToImport>,
        ) -> Self {
            self.inner = self.inner.resources_to_import(inp);
            self
        }
        /// <p>The resources to import into your stack.</p>
        pub fn set_resources_to_import(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceToImport>>,
        ) -> Self {
            self.inner = self.inner.set_resources_to_import(input);
            self
        }
        /// <p>Creates a change set for the all nested stacks specified in the template. The default
        /// behavior of this action is set to <code>False</code>. To include nested sets in a change
        /// set, specify <code>True</code>.</p>
        pub fn include_nested_stacks(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_nested_stacks(inp);
            self
        }
        /// <p>Creates a change set for the all nested stacks specified in the template. The default
        /// behavior of this action is set to <code>False</code>. To include nested sets in a change
        /// set, specify <code>True</code>.</p>
        pub fn set_include_nested_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_nested_stacks(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStack`.
    ///
    /// <p>Creates a stack as specified in the template. After the call completes successfully,
    /// the stack creation starts. You can check the status of the stack via the <a>DescribeStacks</a> API.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stack_input::Builder,
    }
    impl<C, M, R> CreateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStackInputOperationOutputAlias,
                crate::output::CreateStackOutput,
                crate::error::CreateStackError,
                crate::input::CreateStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that is associated with the stack. The name must be unique in the Region in
        /// which you are creating the stack.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens.
        /// It must start with an alphabetical character and cannot be longer than 128
        /// characters.</p>
        /// </note>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name that is associated with the stack. The name must be unique in the Region in
        /// which you are creating the stack.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens.
        /// It must start with an alphabetical character and cannot be longer than 128
        /// characters.</p>
        /// </note>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the <code>TemplateBody</code> or the
        /// <code>TemplateURL</code> parameter, but not both.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>Set to <code>true</code> to disable rollback of the stack if stack creation failed.
        /// You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not
        /// both.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn disable_rollback(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_rollback(inp);
            self
        }
        /// <p>Set to <code>true</code> to disable rollback of the stack if stack creation failed.
        /// You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not
        /// both.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_rollback(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(mut self, inp: crate::model::RollbackConfiguration) -> Self {
            self.inner = self.inner.rollback_configuration(inp);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rollback_configuration(input);
            self
        }
        /// <p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if
        /// <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will
        /// be rolled back.</p>
        pub fn timeout_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes(inp);
            self
        }
        /// <p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if
        /// <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will
        /// be rolled back.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes(input);
            self
        }
        /// Appends an item to `NotificationARNs`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You
        /// can find your SNS topic ARNs using the SNS console or your Command Line Interface
        /// (CLI).</p>
        pub fn notification_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_ar_ns(inp);
            self
        }
        /// <p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You
        /// can find your SNS topic ARNs using the SNS console or your Command Line Interface
        /// (CLI).</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_ar_ns(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only create stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to create the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually creating the stack. If your stack template contains one or
        /// more macros, and you choose to create a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to create a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must create the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only create stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with for this create
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template
        /// resource types: <code>AWS::*</code> (for all Amazon Web Services resources),
        /// <code>Custom::*</code> (for all custom resources),
        /// <code>Custom::<i>logical_ID</i>
        /// </code> (for a specific custom resource),
        /// <code>AWS::<i>service_name</i>::*</code> (for all resources of a
        /// particular Amazon Web Services service), and
        /// <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i>
        /// </code> (for a specific Amazon Web Services resource).</p>
        /// <p>If the list of resource types doesn't include a resource that you're creating, the
        /// stack creation fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn resource_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(inp);
            self
        }
        /// <p>The template resource types that you have permissions to work with for this create
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template
        /// resource types: <code>AWS::*</code> (for all Amazon Web Services resources),
        /// <code>Custom::*</code> (for all custom resources),
        /// <code>Custom::<i>logical_ID</i>
        /// </code> (for a specific custom resource),
        /// <code>AWS::<i>service_name</i>::*</code> (for all resources of a
        /// particular Amazon Web Services service), and
        /// <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i>
        /// </code> (for a specific Amazon Web Services resource).</p>
        /// <p>If the list of resource types doesn't include a resource that you're creating, the
        /// stack creation fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to create the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to create the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Determines what action will be taken if stack creation fails. This must be one of:
        /// DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or
        /// <code>DisableRollback</code>, but not both.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn on_failure(mut self, inp: crate::model::OnFailure) -> Self {
            self.inner = self.inner.on_failure(inp);
            self
        }
        /// <p>Determines what action will be taken if stack creation fails. This must be one of:
        /// DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or
        /// <code>DisableRollback</code>, but not both.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn set_on_failure(
            mut self,
            input: std::option::Option<crate::model::OnFailure>,
        ) -> Self {
            self.inner = self.inner.set_on_failure(input);
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the <i>CloudFormation User Guide</i>.
        /// You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code>
        /// parameter, but not both.</p>
        pub fn stack_policy_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_body(inp);
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the <i>CloudFormation User Guide</i>.
        /// You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code>
        /// parameter, but not both.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_body(input);
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn stack_policy_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_url(inp);
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_url(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to the resources created in the stack. A maximum number of 50 tags can be
        /// specified.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to the resources created in the stack. A maximum number of 50 tags can be
        /// specified.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique identifier for this <code>CreateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// create a stack with the same name. You might retry <code>CreateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>CreateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// create a stack with the same name. You might retry <code>CreateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Whether to enable termination protection on the specified stack. If a user attempts to
        /// delete a stack with termination protection enabled, the operation fails and the stack
        /// remains unchanged. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being
        /// Deleted</a> in the <i>CloudFormation User Guide</i>. Termination protection is
        /// disabled on stacks by default.</p>
        /// <p>For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>,
        /// termination protection is set on the root stack and cannot be changed directly on the
        /// nested stack.</p>
        pub fn enable_termination_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_termination_protection(inp);
            self
        }
        /// <p>Whether to enable termination protection on the specified stack. If a user attempts to
        /// delete a stack with termination protection enabled, the operation fails and the stack
        /// remains unchanged. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being
        /// Deleted</a> in the <i>CloudFormation User Guide</i>. Termination protection is
        /// disabled on stacks by default.</p>
        /// <p>For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>,
        /// termination protection is set on the root stack and cannot be changed directly on the
        /// nested stack.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_termination_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStackInstances`.
    ///
    /// <p>Creates stack instances for the specified accounts, within the specified Regions. A
    /// stack instance refers to a stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStackInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stack_instances_input::Builder,
    }
    impl<C, M, R> CreateStackInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStackInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStackInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStackInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStackInstancesInputOperationOutputAlias,
                crate::output::CreateStackInstancesOutput,
                crate::error::CreateStackInstancesError,
                crate::input::CreateStackInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to create stack instances
        /// from.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to create stack instances
        /// from.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `Accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts that you want to create stack instances in the
        /// specified Region(s) for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accounts(inp);
            self
        }
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts that you want to create stack instances in the
        /// specified Region(s) for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accounts(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which to create
        /// stack instances in the specified Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, inp: crate::model::DeploymentTargets) -> Self {
            self.inner = self.inner.deployment_targets(inp);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which to create
        /// stack instances in the specified Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.inner = self.inner.set_deployment_targets(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The names of one or more Regions where you want to create stack instances using the
        /// specified Amazon Web Services accounts.</p>
        pub fn regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(inp);
            self
        }
        /// <p>The names of one or more Regions where you want to create stack instances using the
        /// specified Amazon Web Services accounts.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// Appends an item to `ParameterOverrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p>A list of stack set parameters whose values you want to override in the selected
        /// stack instances.</p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template.</p>
        pub fn parameter_overrides(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameter_overrides(inp);
            self
        }
        /// <p>A list of stack set parameters whose values you want to override in the selected
        /// stack instances.</p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_overrides(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStackSet`.
    ///
    /// <p>Creates a stack set.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStackSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stack_set_input::Builder,
    }
    impl<C, M, R> CreateStackSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStackSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStackSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStackSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStackSetInputOperationOutputAlias,
                crate::output::CreateStackSetOutput,
                crate::error::CreateStackSetError,
                crate::input::CreateStackSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to associate with the stack set. The name must be unique in the Region where
        /// you create your stack set.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case-sensitive) and
        /// hyphens. It must start with an alphabetic character and can't be longer than 128
        /// characters.</p>
        /// </note>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name to associate with the stack set. The name must be unique in the Region where
        /// you create your stack set.</p>
        /// <note>
        /// <p>A stack name can contain only alphanumeric characters (case-sensitive) and
        /// hyphens. It must start with an alphabetic character and can't be longer than 128
        /// characters.</p>
        /// </note>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>A description of the stack set. You can use the description to identify the stack
        /// set's purpose or other important information.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the stack set. You can use the description to identify the stack
        /// set's purpose or other important information.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter,
        /// but not both.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// <p>The stack ID you are importing into a new stack set. Specify the Amazon Resource Number
        /// (ARN) of the stack.</p>
        pub fn stack_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_id(inp);
            self
        }
        /// <p>The stack ID you are importing into a new stack set. Specify the Amazon Resource Number
        /// (ARN) of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_id(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The input parameters for the stack set template.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The input parameters for the stack set template.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack set template contains
        /// certain capabilities in order for CloudFormation to create the stack set and related stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying
        /// one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must create the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To create the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack set template contains
        /// certain capabilities in order for CloudFormation to create the stack set and related stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying
        /// one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must create the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To create the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. A maximum number of 50 tags can be specified.</p>
        /// <p>If you specify tags as part of a <code>CreateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you don't, the entire <code>CreateStackSet</code> action fails with an <code>access
        /// denied</code> error, and the stack set is not created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. A maximum number of 50 tags can be specified.</p>
        /// <p>If you specify tags as part of a <code>CreateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you don't, the entire <code>CreateStackSet</code> action fails with an <code>access
        /// denied</code> error, and the stack set is not created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
        /// Granting Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        pub fn administration_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administration_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
        /// Granting Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administration_role_arn(input);
            self
        }
        /// <p>The name of the IAM execution role to use to create the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets.
        ///
        /// </p>
        pub fn execution_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_name(inp);
            self
        }
        /// <p>The name of the IAM execution role to use to create the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets.
        ///
        /// </p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_name(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. By default,
        /// <code>SELF-MANAGED</code> is specified.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn permission_model(mut self, inp: crate::model::PermissionModels) -> Self {
            self.inner = self.inner.permission_model(inp);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. By default,
        /// <code>SELF-MANAGED</code> is specified.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.inner = self.inner.set_permission_model(input);
            self
        }
        /// <p>Describes whether StackSets automatically deploys to Organizations accounts that
        /// are added to the target organization or organizational unit (OU). Specify only if
        /// <code>PermissionModel</code> is <code>SERVICE_MANAGED</code>.</p>
        pub fn auto_deployment(mut self, inp: crate::model::AutoDeployment) -> Self {
            self.inner = self.inner.auto_deployment(inp);
            self
        }
        /// <p>Describes whether StackSets automatically deploys to Organizations accounts that
        /// are added to the target organization or organizational unit (OU). Specify only if
        /// <code>PermissionModel</code> is <code>SERVICE_MANAGED</code>.</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.inner = self.inner.set_auto_deployment(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to the
        /// management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to a
        /// delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated admin in the
        /// management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>Stack sets with service-managed permissions are created in the management account,
        /// including stack sets that are created by delegated administrators.</p>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to the
        /// management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>To create a stack set with service-managed permissions while signed in to a
        /// delegated administrator account, specify <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated admin in the
        /// management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>Stack sets with service-managed permissions are created in the management account,
        /// including stack sets that are created by delegated administrators.</p>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
        /// <p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another stack set with the same name. You might retry <code>CreateStackSet</code>
        /// requests to ensure that CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token
        /// if you plan to retry requests so that CloudFormation knows that you're not attempting
        /// to create another stack set with the same name. You might retry <code>CreateStackSet</code>
        /// requests to ensure that CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateType`.
    ///
    /// <p>Deactivates a public extension that was previously activated in this account and
    /// region.</p>
    /// <p>Once deactivated, an extension cannot be used in any CloudFormation operation. This
    /// includes stack update operations where the stack template includes the extension, even if
    /// no updates are being made to the extension. In addition, deactivated extensions are not
    /// automatically updated if a new version of the extension is released.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeactivateType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_type_input::Builder,
    }
    impl<C, M, R> DeactivateType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateTypeInputOperationOutputAlias,
                crate::output::DeactivateTypeOutput,
                crate::error::DeactivateTypeError,
                crate::input::DeactivateTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type name of the extension, in this account and region. If you specified a type name
        /// alias when enabling the extension, use the type name alias.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type name of the extension, in this account and region. If you specified a type name
        /// alias when enabling the extension, use the type name alias.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ThirdPartyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The extension type.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>Conditional: You must specify either <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChangeSet`.
    ///
    /// <p>Deletes the specified change set. Deleting change sets ensures that no one executes
    /// the wrong change set.</p>
    /// <p>If the call successfully completes, CloudFormation successfully deleted the
    /// change set.</p>
    /// <p>If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of
    /// the nested change set, then <code>DeleteChangeSet</code> will delete all change sets that
    /// belong to the stacks hierarchy and will also delete all change sets for nested stacks with
    /// the status of <code>REVIEW_IN_PROGRESS</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_change_set_input::Builder,
    }
    impl<C, M, R> DeleteChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChangeSetInputOperationOutputAlias,
                crate::output::DeleteChangeSetOutput,
                crate::error::DeleteChangeSetError,
                crate::input::DeleteChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// delete.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// delete.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>If you specified the name of a change set to delete, specify the stack name or ID
        /// (ARN) that is associated with it.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>If you specified the name of a change set to delete, specify the stack name or ID
        /// (ARN) that is associated with it.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStack`.
    ///
    /// <p>Deletes a specified stack. Once the call completes successfully, stack deletion
    /// starts. Deleted stacks do not show up in the <a>DescribeStacks</a> API if the
    /// deletion has been completed successfully.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stack_input::Builder,
    }
    impl<C, M, R> DeleteStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStackOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStackInputOperationOutputAlias,
                crate::output::DeleteStackOutput,
                crate::error::DeleteStackError,
                crate::input::DeleteStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// Appends an item to `RetainResources`.
        ///
        /// To override the contents of this collection use [`set_retain_resources`](Self::set_retain_resources).
        ///
        /// <p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs
        /// that are associated with the resources you want to retain. During deletion,
        /// CloudFormation deletes the stack but does not delete the retained resources.</p>
        /// <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty
        /// S3 bucket, but you want to delete the stack.</p>
        pub fn retain_resources(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.retain_resources(inp);
            self
        }
        /// <p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs
        /// that are associated with the resources you want to retain. During deletion,
        /// CloudFormation deletes the stack but does not delete the retained resources.</p>
        /// <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty
        /// S3 bucket, but you want to delete the stack.</p>
        pub fn set_retain_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_retain_resources(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to delete the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to delete the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// delete a stack with the same name. You might retry <code>DeleteStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// delete a stack with the same name. You might retry <code>DeleteStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStackInstances`.
    ///
    /// <p>Deletes stack instances for the specified accounts, in the specified Regions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStackInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stack_instances_input::Builder,
    }
    impl<C, M, R> DeleteStackInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStackInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStackInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStackInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStackInstancesInputOperationOutputAlias,
                crate::output::DeleteStackInstancesOutput,
                crate::error::DeleteStackInstancesError,
                crate::input::DeleteStackInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to delete stack instances
        /// for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to delete stack instances
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `Accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of the Amazon Web Services accounts that you want to delete stack instances for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accounts(inp);
            self
        }
        /// <p>[Self-managed permissions] The names of the Amazon Web Services accounts that you want to delete stack instances for.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accounts(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts from which to delete
        /// stack instances.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, inp: crate::model::DeploymentTargets) -> Self {
            self.inner = self.inner.deployment_targets(inp);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts from which to delete
        /// stack instances.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.inner = self.inner.set_deployment_targets(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions where you want to delete stack set instances.</p>
        pub fn regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(inp);
            self
        }
        /// <p>The Regions where you want to delete stack set instances.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>Removes the stack instances from the specified stack set, but doesn't delete the
        /// stacks. You can't reassociate a retained stack or add an existing, saved stack to a new
        /// stack set.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn retain_stacks(mut self, inp: bool) -> Self {
            self.inner = self.inner.retain_stacks(inp);
            self
        }
        /// <p>Removes the stack instances from the specified stack set, but doesn't delete the
        /// stacks. You can't reassociate a retained stack or add an existing, saved stack to a new
        /// stack set.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_retain_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retain_stacks(input);
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You can retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The unique identifier for this stack set operation.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one
        /// automatically.</p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You can retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack instances
        /// whose status is <code>OUTDATED</code>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStackSet`.
    ///
    /// <p>Deletes a stack set. Before you can delete a stack set, all of its member stack
    /// instances must be deleted. For more information about how to do this, see <a>DeleteStackInstances</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStackSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stack_set_input::Builder,
    }
    impl<C, M, R> DeleteStackSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStackSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStackSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStackSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStackSetInputOperationOutputAlias,
                crate::output::DeleteStackSetOutput,
                crate::error::DeleteStackSetError,
                crate::input::DeleteStackSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you're deleting. You can obtain this
        /// value by running <a>ListStackSets</a>.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you're deleting. You can obtain this
        /// value by running <a>ListStackSets</a>.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterType`.
    ///
    /// <p>Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it from active use. Deprecated extensions or
    /// extension versions cannot be used in CloudFormation operations.</p>
    /// <p>To deregister an entire extension, you must individually deregister all active versions
    /// of that extension. If an extension has only a single active version, deregistering that
    /// version results in the extension itself being deregistered and marked as deprecated in the
    /// registry. </p>
    /// <p>You cannot deregister the default version of an extension if there are other active
    /// version of that extension. If you do deregister the default version of an extension, the
    /// textensionype itself is deregistered as well and marked as deprecated. </p>
    /// <p>To view the deprecation status of an extension or extension version, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_type_input::Builder,
    }
    impl<C, M, R> DeregisterType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterTypeInputOperationOutputAlias,
                crate::output::DeregisterTypeOutput,
                crate::error::DeregisterTypeError,
                crate::input::DeregisterTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountLimits`.
    ///
    /// <p>Retrieves your account's CloudFormation limits, such as the maximum number of
    /// stacks that you can create in your account. For more information about account limits, see
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
    /// Limits</a> in the <i>CloudFormation User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_limits_input::Builder,
    }
    impl<C, M, R> DescribeAccountLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountLimitsInputOperationOutputAlias,
                crate::output::DescribeAccountLimitsOutput,
                crate::error::DescribeAccountLimitsError,
                crate::input::DescribeAccountLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that identifies the next page of limits that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of limits that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChangeSet`.
    ///
    /// <p>Returns the inputs for the change set and a list of changes that CloudFormation
    /// will make if you execute the change set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html">Updating Stacks Using Change Sets</a> in the CloudFormation User
    /// Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_change_set_input::Builder,
    }
    impl<C, M, R> DescribeChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChangeSetInputOperationOutputAlias,
                crate::output::DescribeChangeSetOutput,
                crate::error::DescribeChangeSetError,
                crate::input::DescribeChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// describe.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the change set that you want to
        /// describe.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) of the
        /// change set you want to describe.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) of the
        /// change set you want to describe.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A string (provided by the <a>DescribeChangeSet</a> response output) that
        /// identifies the next page of information that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string (provided by the <a>DescribeChangeSet</a> response output) that
        /// identifies the next page of information that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePublisher`.
    ///
    /// <p>Returns information about a CloudFormation extension publisher.</p>
    /// <p>If you do not supply a <code>PublisherId</code>, and you have registered as an extension
    /// publisher, <code>DescribePublisher</code> returns information about your own publisher
    /// account. </p>
    /// <p>For more information on registering as a publisher, see:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
    /// extensions to make them available for public use</a> in the
    /// <i>CloudFormation CLI User Guide</i>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribePublisher<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_publisher_input::Builder,
    }
    impl<C, M, R> DescribePublisher<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePublisher`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePublisherOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePublisherError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePublisherInputOperationOutputAlias,
                crate::output::DescribePublisherOutput,
                crate::error::DescribePublisherError,
                crate::input::DescribePublisherInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>If you do not supply a <code>PublisherId</code>, and you have registered as an extension
        /// publisher, <code>DescribePublisher</code> returns information about your own publisher
        /// account.</p>
        pub fn publisher_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.publisher_id(inp);
            self
        }
        /// <p>The ID of the extension publisher.</p>
        /// <p>If you do not supply a <code>PublisherId</code>, and you have registered as an extension
        /// publisher, <code>DescribePublisher</code> returns information about your own publisher
        /// account.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_publisher_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackDriftDetectionStatus`.
    ///
    /// <p>Returns information about a stack drift detection operation. A stack drift detection
    /// operation detects whether a stack's actual configuration differs, or has
    /// <i>drifted</i>, from it's expected configuration, as defined in the stack
    /// template and any values specified as template parameters. A stack is considered to have
    /// drifted if one or more of its resources have drifted. For more information on stack and
    /// resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
    /// Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    /// <p>Use <a>DetectStackDrift</a> to initiate a stack drift detection operation.
    /// <code>DetectStackDrift</code> returns a <code>StackDriftDetectionId</code> you can use
    /// to monitor the progress of the operation using
    /// <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has
    /// completed, use <a>DescribeStackResourceDrifts</a> to return drift information
    /// about the stack and its resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackDriftDetectionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_drift_detection_status_input::Builder,
    }
    impl<C, M, R> DescribeStackDriftDetectionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackDriftDetectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackDriftDetectionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackDriftDetectionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackDriftDetectionStatusInputOperationOutputAlias,
                crate::output::DescribeStackDriftDetectionStatusOutput,
                crate::error::DescribeStackDriftDetectionStatusError,
                crate::input::DescribeStackDriftDetectionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the drift detection results of this operation.</p>
        /// <p>CloudFormation generates new results, with a new drift detection ID, each time this operation is
        /// run. However, the number of drift results CloudFormation retains for any given stack, and for how
        /// long, may vary.</p>
        pub fn stack_drift_detection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_drift_detection_id(inp);
            self
        }
        /// <p>The ID of the drift detection results of this operation.</p>
        /// <p>CloudFormation generates new results, with a new drift detection ID, each time this operation is
        /// run. However, the number of drift results CloudFormation retains for any given stack, and for how
        /// long, may vary.</p>
        pub fn set_stack_drift_detection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_drift_detection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackEvents`.
    ///
    /// <p>Returns all stack related events for a specified stack in reverse chronological
    /// order. For more information about a stack's event history, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the CloudFormation User Guide.</p>
    /// <note>
    /// <p>You can list events for stacks that have failed to create or have been deleted by
    /// specifying the unique stack identifier (stack ID).</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_events_input::Builder,
    }
    impl<C, M, R> DescribeStackEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackEventsInputOperationOutputAlias,
                crate::output::DescribeStackEventsOutput,
                crate::error::DescribeStackEventsError,
                crate::input::DescribeStackEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A string that identifies the next page of events that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of events that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackInstance`.
    ///
    /// <p>Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.</p>
    /// <p>For a list of stack instances that are associated with a specific stack set, use
    /// <a>ListStackInstances</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_instance_input::Builder,
    }
    impl<C, M, R> DescribeStackInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackInstanceInputOperationOutputAlias,
                crate::output::DescribeStackInstanceOutput,
                crate::error::DescribeStackInstanceError,
                crate::input::DescribeStackInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID of the stack set that you want to get stack instance
        /// information for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or the unique stack ID of the stack set that you want to get stack instance
        /// information for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>The ID of an Amazon Web Services account that's associated with this stack instance.</p>
        pub fn stack_instance_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_instance_account(inp);
            self
        }
        /// <p>The ID of an Amazon Web Services account that's associated with this stack instance.</p>
        pub fn set_stack_instance_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_instance_account(input);
            self
        }
        /// <p>The name of a Region that's associated with this stack instance.</p>
        pub fn stack_instance_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_instance_region(inp);
            self
        }
        /// <p>The name of a Region that's associated with this stack instance.</p>
        pub fn set_stack_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_instance_region(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackResource`.
    ///
    /// <p>Returns a description of the specified resource in the specified stack.</p>
    /// <p>For deleted stacks, DescribeStackResource returns resource information for up to 90
    /// days after the stack has been deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_resource_input::Builder,
    }
    impl<C, M, R> DescribeStackResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackResourceInputOperationOutputAlias,
                crate::output::DescribeStackResourceOutput,
                crate::error::DescribeStackResourceError,
                crate::input::DescribeStackResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn logical_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_resource_id(inp);
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logical_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackResourceDrifts`.
    ///
    /// <p>Returns drift information for the resources that have been checked for drift in the
    /// specified stack. This includes actual and expected configuration values for resources where
    /// CloudFormation detects configuration drift.</p>
    /// <p>For a given stack, there will be one <code>StackResourceDrift</code> for each stack
    /// resource that has been checked for drift. Resources that haven't yet been checked for drift
    /// are not included. Resources that do not currently support drift detection are not checked,
    /// and so not included. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>
    /// <p>Use <a>DetectStackResourceDrift</a> to detect drift on individual
    /// resources, or <a>DetectStackDrift</a> to detect drift on all supported resources
    /// for a given stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackResourceDrifts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_resource_drifts_input::Builder,
    }
    impl<C, M, R> DescribeStackResourceDrifts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackResourceDrifts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackResourceDriftsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceDriftsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackResourceDriftsInputOperationOutputAlias,
                crate::output::DescribeStackResourceDriftsOutput,
                crate::error::DescribeStackResourceDriftsError,
                crate::input::DescribeStackResourceDriftsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack for which you want drift information.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack for which you want drift information.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// Appends an item to `StackResourceDriftStatusFilters`.
        ///
        /// To override the contents of this collection use [`set_stack_resource_drift_status_filters`](Self::set_stack_resource_drift_status_filters).
        ///
        /// <p>The resource drift status values to use as filters for the resource drift results
        /// returned.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DELETED</code>: The resource differs from its expected template
        /// configuration in that the resource has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED</code>: One or more resource properties differ from their
        /// expected template values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_SYNC</code>: The resources's actual configuration matches its expected
        /// template configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p>
        /// </li>
        /// </ul>
        pub fn stack_resource_drift_status_filters(
            mut self,
            inp: impl Into<crate::model::StackResourceDriftStatus>,
        ) -> Self {
            self.inner = self.inner.stack_resource_drift_status_filters(inp);
            self
        }
        /// <p>The resource drift status values to use as filters for the resource drift results
        /// returned.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DELETED</code>: The resource differs from its expected template
        /// configuration in that the resource has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED</code>: One or more resource properties differ from their
        /// expected template values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_SYNC</code>: The resources's actual configuration matches its expected
        /// template configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p>
        /// </li>
        /// </ul>
        pub fn set_stack_resource_drift_status_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackResourceDriftStatus>>,
        ) -> Self {
            self.inner = self.inner.set_stack_resource_drift_status_filters(input);
            self
        }
        /// <p>A string that identifies the next page of stack resource drift results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of stack resource drift results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackResources`.
    ///
    /// <p>Returns Amazon Web Services resource descriptions for running and deleted stacks. If
    /// <code>StackName</code> is specified, all the associated resources that are part of the
    /// stack are returned. If <code>PhysicalResourceId</code> is specified, the associated
    /// resources of the stack that the resource belongs to are returned.</p>
    /// <note>
    /// <p>Only the first 100 resources will be returned. If your stack has more resources
    /// than this, you should use <code>ListStackResources</code> instead.</p>
    /// </note>
    /// <p>For deleted stacks, <code>DescribeStackResources</code> returns resource information
    /// for up to 90 days after the stack has been deleted.</p>
    /// <p>You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>,
    /// but not both. In addition, you can specify <code>LogicalResourceId</code> to filter the
    /// returned result. For more information about resources, the <code>LogicalResourceId</code>
    /// and <code>PhysicalResourceId</code>, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User
    /// Guide</a>.</p>
    /// <note>
    /// <p>A <code>ValidationError</code> is returned if you specify both
    /// <code>StackName</code> and <code>PhysicalResourceId</code> in the same
    /// request.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_resources_input::Builder,
    }
    impl<C, M, R> DescribeStackResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackResourcesInputOperationOutputAlias,
                crate::output::DescribeStackResourcesOutput,
                crate::error::DescribeStackResourcesError,
                crate::input::DescribeStackResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        /// <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify
        /// <code>PhysicalResourceId</code>.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        /// <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify
        /// <code>PhysicalResourceId</code>.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn logical_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_resource_id(inp);
            self
        }
        /// <p>The logical name of the resource as specified in the template.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logical_resource_id(input);
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a
        /// resource supported by CloudFormation.</p>
        /// <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance,
        /// <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass
        /// the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack
        /// the instance belongs to and what other resources are part of the stack.</p>
        /// <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you
        /// must specify <code>StackName</code>.</p>
        /// <p>Default: There is no default value.</p>
        pub fn physical_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.physical_resource_id(inp);
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a
        /// resource supported by CloudFormation.</p>
        /// <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance,
        /// <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass
        /// the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack
        /// the instance belongs to and what other resources are part of the stack.</p>
        /// <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you
        /// must specify <code>StackName</code>.</p>
        /// <p>Default: There is no default value.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_physical_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStacks`.
    ///
    /// <p>Returns the description for the specified stack; if no stack name was specified, then
    /// it returns the description for all the stacks created.</p>
    /// <note>
    /// <p>If the stack does not exist, an <code>ValidationError</code> is
    /// returned.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stacks_input::Builder,
    }
    impl<C, M, R> DescribeStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStacksInputOperationOutputAlias,
                crate::output::DescribeStacksOutput,
                crate::error::DescribeStacksError,
                crate::input::DescribeStacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackSet`.
    ///
    /// <p>Returns the description of the specified stack set. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_set_input::Builder,
    }
    impl<C, M, R> DescribeStackSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackSetInputOperationOutputAlias,
                crate::output::DescribeStackSetOutput,
                crate::error::DescribeStackSetError,
                crate::input::DescribeStackSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set whose description you want.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set whose description you want.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStackSetOperation`.
    ///
    /// <p>Returns the description of the specified stack set operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStackSetOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stack_set_operation_input::Builder,
    }
    impl<C, M, R> DescribeStackSetOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStackSetOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStackSetOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStackSetOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStackSetOperationInputOperationOutputAlias,
                crate::output::DescribeStackSetOperationOutput,
                crate::error::DescribeStackSetOperationError,
                crate::input::DescribeStackSetOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID of the stack set for the stack operation.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or the unique stack ID of the stack set for the stack operation.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>The unique ID of the stack set operation. </p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The unique ID of the stack set operation. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeType`.
    ///
    /// <p>Returns detailed information about an extension that has been registered.</p>
    /// <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information
    /// about that specific extension version. Otherwise, it returns information about the default
    /// extension version.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_type_input::Builder,
    }
    impl<C, M, R> DescribeType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTypeInputOperationOutputAlias,
                crate::output::DescribeTypeOutput,
                crate::error::DescribeTypeError,
                crate::input::DescribeTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The kind of extension. </p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of extension. </p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        /// <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information
        /// about that specific extension version. Otherwise, it returns information about the default
        /// extension version.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        /// <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information
        /// about that specific extension version. Otherwise, it returns information about the default
        /// extension version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions provided by Amazon are not assigned a publisher ID.</p>
        pub fn publisher_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.publisher_id(inp);
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions provided by Amazon are not assigned a publisher ID.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_publisher_id(input);
            self
        }
        /// <p>The version number of a public third-party extension.</p>
        pub fn public_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_version_number(inp);
            self
        }
        /// <p>The version number of a public third-party extension.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTypeRegistration`.
    ///
    /// <p>Returns information about an extension's registration, including its current status and
    /// type and version identifiers.</p>
    /// <p>When you initiate a registration request using <code>
    /// <a>RegisterType</a>
    /// </code>, you can then use <code>
    /// <a>DescribeTypeRegistration</a>
    /// </code> to
    /// monitor the progress of that registration request.</p>
    /// <p>Once the registration request has completed, use <code>
    /// <a>DescribeType</a>
    /// </code> to return detailed information about an extension.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTypeRegistration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_type_registration_input::Builder,
    }
    impl<C, M, R> DescribeTypeRegistration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTypeRegistration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTypeRegistrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTypeRegistrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTypeRegistrationInputOperationOutputAlias,
                crate::output::DescribeTypeRegistrationOutput,
                crate::error::DescribeTypeRegistrationError,
                crate::input::DescribeTypeRegistrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for this registration request.</p>
        /// <p>This registration token is generated by CloudFormation when you initiate a
        /// registration request using <code>
        /// <a>RegisterType</a>
        /// </code>.</p>
        pub fn registration_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registration_token(inp);
            self
        }
        /// <p>The identifier for this registration request.</p>
        /// <p>This registration token is generated by CloudFormation when you initiate a
        /// registration request using <code>
        /// <a>RegisterType</a>
        /// </code>.</p>
        pub fn set_registration_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registration_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectStackDrift`.
    ///
    /// <p>Detects whether a stack's actual configuration differs, or has
    /// <i>drifted</i>, from it's expected configuration, as defined in the stack
    /// template and any values specified as template parameters. For each resource in the stack
    /// that supports drift detection, CloudFormation compares the actual configuration of the resource with
    /// its expected template configuration. Only resource properties explicitly defined in the
    /// stack template are checked for drift. A stack is considered to have drifted if one or more
    /// of its resources differ from their expected template configurations. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
    /// Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    /// <p>Use <code>DetectStackDrift</code> to detect drift on all supported resources for a
    /// given stack, or <a>DetectStackResourceDrift</a> to detect drift on individual
    /// resources.</p>
    /// <p>For a list of stack resources that currently support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>
    /// <p>
    /// <code>DetectStackDrift</code> can take up to several minutes, depending on the number
    /// of resources contained within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack
    /// drift operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return drift information about the stack and
    /// its resources.</p>
    /// <p>When detecting drift on a stack, CloudFormation does not detect drift on any nested stacks
    /// belonging to that stack. Perform <code>DetectStackDrift</code> directly on the nested stack
    /// itself.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectStackDrift<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_stack_drift_input::Builder,
    }
    impl<C, M, R> DetectStackDrift<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectStackDrift`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectStackDriftOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectStackDriftError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectStackDriftInputOperationOutputAlias,
                crate::output::DetectStackDriftOutput,
                crate::error::DetectStackDriftError,
                crate::input::DetectStackDriftInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack for which you want to detect drift.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack for which you want to detect drift.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// Appends an item to `LogicalResourceIds`.
        ///
        /// To override the contents of this collection use [`set_logical_resource_ids`](Self::set_logical_resource_ids).
        ///
        /// <p>The logical names of any resources you want to use as filters.</p>
        pub fn logical_resource_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_resource_ids(inp);
            self
        }
        /// <p>The logical names of any resources you want to use as filters.</p>
        pub fn set_logical_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logical_resource_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectStackResourceDrift`.
    ///
    /// <p>Returns information about whether a resource's actual configuration differs, or has
    /// <i>drifted</i>, from it's expected configuration, as defined in the stack
    /// template and any values specified as template parameters. This information includes actual
    /// and expected property values for resources in which CloudFormation detects drift. Only resource
    /// properties explicitly defined in the stack template are checked for drift. For more
    /// information about stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
    /// Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    /// <p>Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or
    /// <a>DetectStackDrift</a> to detect drift on all resources in a given stack
    /// that support drift detection.</p>
    /// <p>Resources that do not currently support drift detection cannot be checked. For a list
    /// of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectStackResourceDrift<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_stack_resource_drift_input::Builder,
    }
    impl<C, M, R> DetectStackResourceDrift<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectStackResourceDrift`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectStackResourceDriftOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectStackResourceDriftError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectStackResourceDriftInputOperationOutputAlias,
                crate::output::DetectStackResourceDriftOutput,
                crate::error::DetectStackResourceDriftError,
                crate::input::DetectStackResourceDriftInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack to which the resource belongs.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack to which the resource belongs.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The logical name of the resource for which to return drift information.</p>
        pub fn logical_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_resource_id(inp);
            self
        }
        /// <p>The logical name of the resource for which to return drift information.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logical_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectStackSetDrift`.
    ///
    /// <p>Detect drift on a stack set. When CloudFormation performs drift detection on a
    /// stack set, it performs drift detection on the stack associated with each stack instance in
    /// the stack set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation Performs Drift Detection on a Stack Set</a>.</p>
    /// <p>
    /// <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set
    /// drift detection operation. Use this operation id with <code>
    /// <a>DescribeStackSetOperation</a>
    /// </code> to monitor the progress of the drift
    /// detection operation. The drift detection operation may take some time, depending on the
    /// number of stack instances included in the stack set, as well as the number of resources
    /// included in each stack.</p>
    /// <p>Once the operation has completed, use the following actions to return drift
    /// information:</p>
    /// <ul>
    /// <li>
    /// <p>Use <code>
    /// <a>DescribeStackSet</a>
    /// </code> to return detailed information
    /// about the stack set, including detailed information about the last
    /// <i>completed</i> drift operation performed on the stack set.
    /// (Information about drift operations that are in progress is not included.)</p>
    /// </li>
    /// <li>
    /// <p>Use <code>
    /// <a>ListStackInstances</a>
    /// </code> to return a list of stack
    /// instances belonging to the stack set, including the drift status and last drift time
    /// checked of each instance.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>
    /// <a>DescribeStackInstance</a>
    /// </code> to return detailed
    /// information about a specific stack instance, including its drift status and last
    /// drift time checked.</p>
    /// </li>
    /// </ul>
    /// <p>For more information on performing a drift detection operation on a stack set, see
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
    /// Changes in Stack Sets</a>. </p>
    /// <p>You can only run a single drift detection operation on a given stack set at one time. </p>
    /// <p>To stop a drift detection stack set operation, use <code>
    /// <a>StopStackSetOperation</a>
    /// </code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectStackSetDrift<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_stack_set_drift_input::Builder,
    }
    impl<C, M, R> DetectStackSetDrift<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectStackSetDrift`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectStackSetDriftOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectStackSetDriftError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectStackSetDriftInputOperationOutputAlias,
                crate::output::DetectStackSetDriftOutput,
                crate::error::DetectStackSetDriftError,
                crate::input::DetectStackSetDriftInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack set on which to perform the drift detection operation.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name of the stack set on which to perform the drift detection operation.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>
        /// <i>The ID of the stack set operation.</i>
        /// </p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>
        /// <i>The ID of the stack set operation.</i>
        /// </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EstimateTemplateCost`.
    ///
    /// <p>Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple
    /// Monthly Calculator URL with a query string that describes the resources required to run the
    /// template.</p>
    #[derive(std::fmt::Debug)]
    pub struct EstimateTemplateCost<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::estimate_template_cost_input::Builder,
    }
    impl<C, M, R> EstimateTemplateCost<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EstimateTemplateCost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EstimateTemplateCostOutput,
            aws_smithy_http::result::SdkError<crate::error::EstimateTemplateCostError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EstimateTemplateCostInputOperationOutputAlias,
                crate::output::EstimateTemplateCostOutput,
                crate::error::EstimateTemplateCostError,
                crate::input::EstimateTemplateCostInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteChangeSet`.
    ///
    /// <p>Updates a stack using the input information that was provided when the specified
    /// change set was created. After the call successfully completes, CloudFormation starts
    /// updating the stack. Use the <a>DescribeStacks</a> action to view the status of
    /// the update.</p>
    /// <p>When you execute a change set, CloudFormation deletes all other change sets
    /// associated with the stack because they aren't valid for the updated stack.</p>
    /// <p>If a stack policy is associated with the stack, CloudFormation enforces the
    /// policy during the update. You can't specify a temporary stack policy that overrides the
    /// current policy.</p>
    /// <p>To create a change set for the entire stack hierachy, <code>IncludeNestedStacks</code>
    /// must have been set to <code>True</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_change_set_input::Builder,
    }
    impl<C, M, R> ExecuteChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteChangeSetInputOperationOutputAlias,
                crate::output::ExecuteChangeSetOutput,
                crate::error::ExecuteChangeSetError,
                crate::input::ExecuteChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the change set that you want use to update the specified
        /// stack.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>The name or ARN of the change set that you want use to update the specified
        /// stack.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) that is
        /// associated with the change set you want to execute.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>If you specified the name of a change set, specify the stack name or ID (ARN) that is
        /// associated with the change set you want to execute.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to execute a change set to update a stack with the same name. You might retry
        /// <code>ExecuteChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this
        /// token if you plan to retry requests so that CloudFormation knows that you're not
        /// attempting to execute a change set to update a stack with the same name. You might retry
        /// <code>ExecuteChangeSet</code> requests to ensure that CloudFormation successfully
        /// received them.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Preserves the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>True</code>
        /// </p>
        pub fn disable_rollback(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_rollback(inp);
            self
        }
        /// <p>Preserves the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>True</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_rollback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStackPolicy`.
    ///
    /// <p>Returns the stack policy for a specified stack. If a stack doesn't have a policy, a
    /// null value is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStackPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stack_policy_input::Builder,
    }
    impl<C, M, R> GetStackPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStackPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStackPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStackPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStackPolicyInputOperationOutputAlias,
                crate::output::GetStackPolicyOutput,
                crate::error::GetStackPolicyError,
                crate::input::GetStackPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique stack ID that is associated with the stack whose policy you want
        /// to get.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or unique stack ID that is associated with the stack whose policy you want
        /// to get.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemplate`.
    ///
    /// <p>Returns the template body for a specified stack. You can get the template for running
    /// or deleted stacks.</p>
    /// <p>For deleted stacks, GetTemplate returns the template for up to 90 days after the
    /// stack has been deleted.</p>
    /// <note>
    /// <p>If the template does not exist, a <code>ValidationError</code> is returned.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_template_input::Builder,
    }
    impl<C, M, R> GetTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemplateInputOperationOutputAlias,
                crate::output::GetTemplateOutput,
                crate::error::GetTemplateError,
                crate::input::GetTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of a change set for which CloudFormation
        /// returns the associated template. If you specify a name, you must also specify the
        /// <code>StackName</code>.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of a change set for which CloudFormation
        /// returns the associated template. If you specify a name, you must also specify the
        /// <code>StackName</code>.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>For templates that include transforms, the stage of the template that CloudFormation returns. To get the user-submitted template, specify
        /// <code>Original</code>. To get the template after CloudFormation has processed
        /// all transforms, specify <code>Processed</code>.</p>
        /// <p>If the template doesn't include transforms, <code>Original</code> and
        /// <code>Processed</code> return the same template. By default, CloudFormation
        /// specifies <code>Processed</code>.</p>
        pub fn template_stage(mut self, inp: crate::model::TemplateStage) -> Self {
            self.inner = self.inner.template_stage(inp);
            self
        }
        /// <p>For templates that include transforms, the stage of the template that CloudFormation returns. To get the user-submitted template, specify
        /// <code>Original</code>. To get the template after CloudFormation has processed
        /// all transforms, specify <code>Processed</code>.</p>
        /// <p>If the template doesn't include transforms, <code>Original</code> and
        /// <code>Processed</code> return the same template. By default, CloudFormation
        /// specifies <code>Processed</code>.</p>
        pub fn set_template_stage(
            mut self,
            input: std::option::Option<crate::model::TemplateStage>,
        ) -> Self {
            self.inner = self.inner.set_template_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemplateSummary`.
    ///
    /// <p>Returns information about a new or existing template. The
    /// <code>GetTemplateSummary</code> action is useful for viewing parameter information, such
    /// as default parameter values and parameter types, before you create or update a stack or
    /// stack set.</p>
    /// <p>You can use the <code>GetTemplateSummary</code> action when you submit a template, or
    /// you can get template information for a stack set, or a running or deleted stack.</p>
    /// <p>For deleted stacks, <code>GetTemplateSummary</code> returns the template information
    /// for up to 90 days after the stack has been deleted. If the template does not exist, a
    /// <code>ValidationError</code> is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTemplateSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_template_summary_input::Builder,
    }
    impl<C, M, R> GetTemplateSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemplateSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemplateSummaryInputOperationOutputAlias,
                crate::output::GetTemplateSummaryOutput,
                crate::error::GetTemplateSummaryError,
                crate::input::GetTemplateSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// <p>The name or the stack ID that is associated with the stack, which are not always
        /// interchangeable. For running stacks, you can specify either the stack's name or its unique
        /// stack ID. For deleted stack, you must specify the unique stack ID.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the stack ID that is associated with the stack, which are not always
        /// interchangeable. For running stacks, you can specify either the stack's name or its unique
        /// stack ID. For deleted stack, you must specify the unique stack ID.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name or unique ID of the stack set from which the stack was created.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set from which the stack was created.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or
        /// <code>TemplateURL</code>.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportStacksToStackSet`.
    ///
    /// <p>Import existing stacks into a new stack sets. Use the stack import operation to import
    /// up to 10 stacks into a new stack set in the same account as the source stack or in a
    /// different administrator account and Region, by specifying the stack ID of the stack you
    /// intend to import.</p>
    /// <note>
    /// <p>
    /// <code>ImportStacksToStackSet</code> is only supported by self-managed permissions.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ImportStacksToStackSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_stacks_to_stack_set_input::Builder,
    }
    impl<C, M, R> ImportStacksToStackSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportStacksToStackSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportStacksToStackSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportStacksToStackSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportStacksToStackSetInputOperationOutputAlias,
                crate::output::ImportStacksToStackSetOutput,
                crate::error::ImportStacksToStackSetError,
                crate::input::ImportStacksToStackSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack set. The name must be unique in the Region where you create your
        /// stack set.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name of the stack set. The name must be unique in the Region where you create your
        /// stack set.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `StackIds`.
        ///
        /// To override the contents of this collection use [`set_stack_ids`](Self::set_stack_ids).
        ///
        /// <p>The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per
        /// stack set at a time.</p>
        pub fn stack_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_ids(inp);
            self
        }
        /// <p>The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per
        /// stack set at a time.</p>
        pub fn set_stack_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_stack_ids(input);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>The user-specified preferences for how CloudFormation performs a stack set
        /// operation. </p>
        /// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>A unique, user defined, identifier for the stack set operation.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>A unique, user defined, identifier for the stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChangeSets`.
    ///
    /// <p>Returns the ID and status of each active change set for a stack. For example,
    /// CloudFormation lists change sets that are in the <code>CREATE_IN_PROGRESS</code> or
    /// <code>CREATE_PENDING</code> state.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChangeSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_change_sets_input::Builder,
    }
    impl<C, M, R> ListChangeSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChangeSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChangeSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChangeSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChangeSetsInputOperationOutputAlias,
                crate::output::ListChangeSetsOutput,
                crate::error::ListChangeSetsError,
                crate::input::ListChangeSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
        /// change sets.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list
        /// change sets.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
        /// identifies the next page of change sets that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string (provided by the <a>ListChangeSets</a> response output) that
        /// identifies the next page of change sets that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExports`.
    ///
    /// <p>Lists all exported output values in the account and Region in which you call this
    /// action. Use this action to see the exported output values that you can import into other
    /// stacks. To import values, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
    /// <code>Fn::ImportValue</code>
    /// </a> function.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
    /// CloudFormation Export Stack Output Values</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListExports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_exports_input::Builder,
    }
    impl<C, M, R> ListExports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExportsInputOperationOutputAlias,
                crate::output::ListExportsOutput,
                crate::error::ListExportsError,
                crate::input::ListExportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string (provided by the <a>ListExports</a> response output) that
        /// identifies the next page of exported output values that you asked to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string (provided by the <a>ListExports</a> response output) that
        /// identifies the next page of exported output values that you asked to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImports`.
    ///
    /// <p>Lists all stacks that are importing an exported output value. To modify or remove an
    /// exported output value, first use this action to see which stacks are using it. To see the
    /// exported output values in your account, see <a>ListExports</a>.</p>
    /// <p>For more information about importing an exported output value, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
    /// <code>Fn::ImportValue</code>
    /// </a> function.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_imports_input::Builder,
    }
    impl<C, M, R> ListImports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImportsInputOperationOutputAlias,
                crate::output::ListImportsOutput,
                crate::error::ListImportsError,
                crate::input::ListImportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the exported output value. CloudFormation returns the stack names
        /// that are importing this value.</p>
        pub fn export_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_name(inp);
            self
        }
        /// <p>The name of the exported output value. CloudFormation returns the stack names
        /// that are importing this value.</p>
        pub fn set_export_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_name(input);
            self
        }
        /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
        /// the next page of stacks that are importing the specified exported output value.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string (provided by the <a>ListImports</a> response output) that identifies
        /// the next page of stacks that are importing the specified exported output value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackInstances`.
    ///
    /// <p>Returns summary information about stack instances that are associated with the
    /// specified stack set. You can filter for stack instances that are associated with a specific
    /// Amazon Web Services account name or Region, or that have a specific status.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStackInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_instances_input::Builder,
    }
    impl<C, M, R> ListStackInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStackInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackInstancesInputOperationOutputAlias,
                crate::output::ListStackInstancesOutput,
                crate::error::ListStackInstancesError,
                crate::input::ListStackInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to list stack instances
        /// for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to list stack instances
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response's
        /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
        /// results, call <code>ListStackInstances</code> again and assign that token to the request
        /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response's
        /// <code>NextToken</code> parameter value is set to a token. To retrieve the next set of
        /// results, call <code>ListStackInstances</code> again and assign that token to the request
        /// object's <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The status that stack instances are filtered by.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::StackInstanceFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The status that stack instances are filtered by.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackInstanceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
        pub fn stack_instance_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_instance_account(inp);
            self
        }
        /// <p>The name of the Amazon Web Services account that you want to list stack instances for.</p>
        pub fn set_stack_instance_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_instance_account(input);
            self
        }
        /// <p>The name of the Region where you want to list stack instances. </p>
        pub fn stack_instance_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_instance_region(inp);
            self
        }
        /// <p>The name of the Region where you want to list stack instances. </p>
        pub fn set_stack_instance_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_instance_region(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackResources`.
    ///
    /// <p>Returns descriptions of all resources of the specified stack.</p>
    /// <p>For deleted stacks, ListStackResources returns resource information for up to 90 days
    /// after the stack has been deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStackResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_resources_input::Builder,
    }
    impl<C, M, R> ListStackResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStackResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackResourcesInputOperationOutputAlias,
                crate::output::ListStackResourcesOutput,
                crate::error::ListStackResourcesError,
                crate::input::ListStackResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or the unique stack ID that is associated with the stack, which are not
        /// always interchangeable:</p>
        /// <ul>
        /// <li>
        /// <p>Running stacks: You can specify either the stack's name or its unique stack
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>Deleted stacks: You must specify the unique stack ID.</p>
        /// </li>
        /// </ul>
        /// <p>Default: There is no default value.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>A string that identifies the next page of stack resources that you want to
        /// retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of stack resources that you want to
        /// retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStacks`.
    ///
    /// <p>Returns the summary information for stacks whose status matches the specified
    /// StackStatusFilter. Summary information for stacks that have been deleted is kept for 90
    /// days after the stack is deleted. If no StackStatusFilter is specified, summary information
    /// for all stacks is returned (including existing stacks and stacks that have been
    /// deleted).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stacks_input::Builder,
    }
    impl<C, M, R> ListStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStacksInputOperationOutputAlias,
                crate::output::ListStacksOutput,
                crate::error::ListStacksError,
                crate::input::ListStacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that identifies the next page of stacks that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `StackStatusFilter`.
        ///
        /// To override the contents of this collection use [`set_stack_status_filter`](Self::set_stack_status_filter).
        ///
        /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
        /// stacks with the specified status codes. For a complete list of stack status codes, see the
        /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
        pub fn stack_status_filter(mut self, inp: impl Into<crate::model::StackStatus>) -> Self {
            self.inner = self.inner.stack_status_filter(inp);
            self
        }
        /// <p>Stack status to use as a filter. Specify one or more stack status codes to list only
        /// stacks with the specified status codes. For a complete list of stack status codes, see the
        /// <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>
        pub fn set_stack_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackStatus>>,
        ) -> Self {
            self.inner = self.inner.set_stack_status_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackSetOperationResults`.
    ///
    /// <p>Returns summary information about the results of a stack set operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListStackSetOperationResults<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_set_operation_results_input::Builder,
    }
    impl<C, M, R> ListStackSetOperationResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackSetOperationResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackSetOperationResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackSetOperationResultsInputOperationOutputAlias,
                crate::output::ListStackSetOperationResultsOutput,
                crate::error::ListStackSetOperationResultsError,
                crate::input::ListStackSetOperationResultsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to get operation results
        /// for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to get operation results
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>The ID of the stack set operation.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The ID of the stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response
        /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
        /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
        /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
        /// the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous request didn't return all of the remaining results, the response
        /// object's <code>NextToken</code> parameter value is set to a token. To retrieve the next set
        /// of results, call <code>ListStackSetOperationResults</code> again and assign that token to
        /// the request object's <code>NextToken</code> parameter. If there are no remaining results,
        /// the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackSetOperations`.
    ///
    /// <p>Returns summary information about operations performed on a stack set. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListStackSetOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_set_operations_input::Builder,
    }
    impl<C, M, R> ListStackSetOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackSetOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackSetOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackSetOperationsInputOperationOutputAlias,
                crate::output::ListStackSetOperationsOutput,
                crate::error::ListStackSetOperationsError,
                crate::input::ListStackSetOperationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to get operation summaries
        /// for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to get operation summaries
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
        /// to the request object's <code>NextToken</code> parameter. If there are no remaining
        /// results, the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSetOperations</code> again and assign that token
        /// to the request object's <code>NextToken</code> parameter. If there are no remaining
        /// results, the previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackSets`.
    ///
    /// <p>Returns summary information about stack sets that are associated with the
    /// user.</p>
    /// <ul>
    /// <li>
    /// <p>[Self-managed permissions] If you set the <code>CallAs</code> parameter to
    /// <code>SELF</code> while signed in to your Amazon Web Services account,
    /// <code>ListStackSets</code> returns all self-managed stack sets in your Amazon Web Services account.</p>
    /// </li>
    /// <li>
    /// <p>[Service-managed permissions] If you set the <code>CallAs</code> parameter to
    /// <code>SELF</code> while signed in to the organization's management account,
    /// <code>ListStackSets</code> returns all stack sets in the management
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>[Service-managed permissions] If you set the <code>CallAs</code> parameter to
    /// <code>DELEGATED_ADMIN</code> while signed in to your member account,
    /// <code>ListStackSets</code> returns all stack sets with service-managed permissions
    /// in the management account.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListStackSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_sets_input::Builder,
    }
    impl<C, M, R> ListStackSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStackSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackSetsInputOperationOutputAlias,
                crate::output::ListStackSetsOutput,
                crate::error::ListStackSetsError,
                crate::input::ListStackSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSets</code> again and assign that token to the
        /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
        /// previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListStackSets</code> again and assign that token to the
        /// request object's <code>NextToken</code> parameter. If there are no remaining results, the
        /// previous response object's <code>NextToken</code> parameter is set to
        /// <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The status of the stack sets that you want to get summary information
        /// about.</p>
        pub fn status(mut self, inp: crate::model::StackSetStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the stack sets that you want to get summary information
        /// about.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the management account or as a delegated administrator in a member
        /// account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the management account or as a delegated administrator in a member
        /// account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypeRegistrations`.
    ///
    /// <p>Returns a list of registration tokens for the specified extension(s).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypeRegistrations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_type_registrations_input::Builder,
    }
    impl<C, M, R> ListTypeRegistrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypeRegistrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypeRegistrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypeRegistrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypeRegistrationsInputOperationOutputAlias,
                crate::output::ListTypeRegistrationsOutput,
                crate::error::ListTypeRegistrationsError,
                crate::input::ListTypeRegistrationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_arn(input);
            self
        }
        /// <p>The current status of the extension registration request.</p>
        /// <p>The default is <code>IN_PROGRESS</code>.</p>
        pub fn registration_status_filter(mut self, inp: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status_filter(inp);
            self
        }
        /// <p>The current status of the extension registration request.</p>
        /// <p>The default is <code>IN_PROGRESS</code>.</p>
        pub fn set_registration_status_filter(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status_filter(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypes`.
    ///
    /// <p>Returns summary information about extension that have been registered with CloudFormation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_types_input::Builder,
    }
    impl<C, M, R> ListTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypesInputOperationOutputAlias,
                crate::output::ListTypesOutput,
                crate::error::ListTypesError,
                crate::input::ListTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The scope at which the extensions are visible and usable in CloudFormation
        /// operations.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
        /// and region. This includes:</p>
        /// <ul>
        /// <li>
        /// <p>Private extensions you have registered in this account and region.</p>
        /// </li>
        /// <li>
        /// <p>Public extensions that you have activated in this account and region.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
        /// activated within any Amazon account. This includes extensions from Amazon, as well as
        /// third-party publishers.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>PRIVATE</code>.</p>
        pub fn visibility(mut self, inp: crate::model::Visibility) -> Self {
            self.inner = self.inner.visibility(inp);
            self
        }
        /// <p>The scope at which the extensions are visible and usable in CloudFormation
        /// operations.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PRIVATE</code>: Extensions that are visible and usable within this account
        /// and region. This includes:</p>
        /// <ul>
        /// <li>
        /// <p>Private extensions you have registered in this account and region.</p>
        /// </li>
        /// <li>
        /// <p>Public extensions that you have activated in this account and region.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC</code>: Extensions that are publicly visible and available to be
        /// activated within any Amazon account. This includes extensions from Amazon, as well as
        /// third-party publishers.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>PRIVATE</code>.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::Visibility>,
        ) -> Self {
            self.inner = self.inner.set_visibility(input);
            self
        }
        /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
        /// provisioning type during registration, based on the types of handlers in the schema handler
        /// package submitted.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
        /// process updates to the type during stack update operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
        /// the type cannot be updated and must instead be replaced during stack update
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
        /// and delete handlers, and therefore cannot actually be provisioned.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
        pub fn provisioning_type(mut self, inp: crate::model::ProvisioningType) -> Self {
            self.inner = self.inner.provisioning_type(inp);
            self
        }
        /// <p>For resource types, the provisioning behavior of the resource type. CloudFormation determines the
        /// provisioning type during registration, based on the types of handlers in the schema handler
        /// package submitted.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FULLY_MUTABLE</code>: The resource type includes an update handler to
        /// process updates to the type during stack update operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMMUTABLE</code>: The resource type does not include an update handler, so
        /// the type cannot be updated and must instead be replaced during stack update
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROVISIONABLE</code>: The resource type does not include create, read,
        /// and delete handlers, and therefore cannot actually be provisioned.</p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>FULLY_MUTABLE</code>.</p>
        pub fn set_provisioning_type(
            mut self,
            input: std::option::Option<crate::model::ProvisioningType>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_type(input);
            self
        }
        /// <p>The deprecation status of the extension that you want to get summary information
        /// about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension is registered for use in CloudFormation
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
        /// used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        pub fn deprecated_status(mut self, inp: crate::model::DeprecatedStatus) -> Self {
            self.inner = self.inner.deprecated_status(inp);
            self
        }
        /// <p>The deprecation status of the extension that you want to get summary information
        /// about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension is registered for use in CloudFormation
        /// operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension has been deregistered and can no longer be
        /// used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        pub fn set_deprecated_status(
            mut self,
            input: std::option::Option<crate::model::DeprecatedStatus>,
        ) -> Self {
            self.inner = self.inner.set_deprecated_status(input);
            self
        }
        /// <p>The type of extension.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Filter criteria to use in determining which extensions to return.</p>
        /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
        /// value when returning the list of types.</p>
        pub fn filters(mut self, inp: crate::model::TypeFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filter criteria to use in determining which extensions to return.</p>
        /// <p>If you specify a filter, CloudFormation ignores any specified <code>Visibility</code>
        /// value when returning the list of types.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::TypeFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypeVersions`.
    ///
    /// <p>Returns summary information about the versions of an extension.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_type_versions_input::Builder,
    }
    impl<C, M, R> ListTypeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypeVersionsInputOperationOutputAlias,
                crate::output::ListTypeVersionsOutput,
                crate::error::ListTypeVersionsError,
                crate::input::ListTypeVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The kind of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension for which you want version summary information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension for which you want version summary information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned with a single call. If the number of
        /// available results exceeds this maximum, the response includes a <code>NextToken</code>
        /// value that you can assign to the <code>NextToken</code> request parameter to get the next
        /// set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous paginated request didn't return all of the remaining results, the
        /// response object's <code>NextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call this action again and assign that token to the request object's
        /// <code>NextToken</code> parameter. If there are no remaining results, the previous
        /// response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The deprecation status of the extension versions that you want to get summary
        /// information about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
        /// scope.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
        /// longer be used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>LIVE</code>.</p>
        pub fn deprecated_status(mut self, inp: crate::model::DeprecatedStatus) -> Self {
            self.inner = self.inner.deprecated_status(inp);
            self
        }
        /// <p>The deprecation status of the extension versions that you want to get summary
        /// information about.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LIVE</code>: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility
        /// scope.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPRECATED</code>: The extension version has been deregistered and can no
        /// longer be used in CloudFormation operations. </p>
        /// </li>
        /// </ul>
        /// <p>The default is <code>LIVE</code>.</p>
        pub fn set_deprecated_status(
            mut self,
            input: std::option::Option<crate::model::DeprecatedStatus>,
        ) -> Self {
            self.inner = self.inner.set_deprecated_status(input);
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
        pub fn publisher_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.publisher_id(inp);
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_publisher_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishType`.
    ///
    /// <p>Publishes the specified extension to the CloudFormation registry as a public extension
    /// in this region. Public extensions are available for use by all CloudFormation users. For
    /// more information on publishing extensions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing extensions to make them available for public use</a> in the
    /// <i>CloudFormation CLI User Guide</i>.</p>
    /// <p>To publish an extension, you must be registered as a publisher with CloudFormation. For
    /// more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_type_input::Builder,
    }
    impl<C, M, R> PublishType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishTypeInputOperationOutputAlias,
                crate::output::PublishTypeOutput,
                crate::error::PublishTypeError,
                crate::input::PublishTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ThirdPartyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The version number to assign to this version of the extension.</p>
        /// <p>Use the following format, and adhere to semantic versioning when assigning a version
        /// number to your extension: </p>
        /// <p>
        /// <code>MAJOR.MINOR.PATCH</code>
        /// </p>
        /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
        /// 2.0.0</a>.</p>
        /// <p>If you do not specify a version number, CloudFormation increments the version number by
        /// one minor version release.</p>
        /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
        /// regardless of the value you specify.</p>
        pub fn public_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_version_number(inp);
            self
        }
        /// <p>The version number to assign to this version of the extension.</p>
        /// <p>Use the following format, and adhere to semantic versioning when assigning a version
        /// number to your extension: </p>
        /// <p>
        /// <code>MAJOR.MINOR.PATCH</code>
        /// </p>
        /// <p>For more information, see <a href="https://semver.org/">Semantic Versioning
        /// 2.0.0</a>.</p>
        /// <p>If you do not specify a version number, CloudFormation increments the version number by
        /// one minor version release.</p>
        /// <p>The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
        /// regardless of the value you specify.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecordHandlerProgress`.
    ///
    /// <p>Reports progress of a resource handler to CloudFormation.</p>
    /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. Do not use this API in your code.</p>
    #[derive(std::fmt::Debug)]
    pub struct RecordHandlerProgress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::record_handler_progress_input::Builder,
    }
    impl<C, M, R> RecordHandlerProgress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RecordHandlerProgress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecordHandlerProgressOutput,
            aws_smithy_http::result::SdkError<crate::error::RecordHandlerProgressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RecordHandlerProgressInputOperationOutputAlias,
                crate::output::RecordHandlerProgressOutput,
                crate::error::RecordHandlerProgressError,
                crate::input::RecordHandlerProgressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn bearer_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bearer_token(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_bearer_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bearer_token(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn operation_status(mut self, inp: crate::model::OperationStatus) -> Self {
            self.inner = self.inner.operation_status(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_operation_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.inner = self.inner.set_operation_status(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn current_operation_status(mut self, inp: crate::model::OperationStatus) -> Self {
            self.inner = self.inner.current_operation_status(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_current_operation_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.inner = self.inner.set_current_operation_status(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn status_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_message(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_message(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn error_code(mut self, inp: crate::model::HandlerErrorCode) -> Self {
            self.inner = self.inner.error_code(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::HandlerErrorCode>,
        ) -> Self {
            self.inner = self.inner.set_error_code(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn resource_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_model(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_resource_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_model(input);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterPublisher`.
    ///
    /// <p>Registers your account as a publisher of public extensions in the CloudFormation
    /// registry. Public extensions are available for use by all CloudFormation users. This
    /// publisher ID applies to your account in all Amazon Web Services Regions.</p>
    /// <p>For information on requirements for registering as a public extension publisher, see
    /// <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
    /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterPublisher<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_publisher_input::Builder,
    }
    impl<C, M, R> RegisterPublisher<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterPublisher`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterPublisherOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterPublisherError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterPublisherInputOperationOutputAlias,
                crate::output::RegisterPublisherOutput,
                crate::error::RegisterPublisherError,
                crate::input::RegisterPublisherInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
        /// You must accept the terms and conditions in order to register to publish public extensions
        /// to the CloudFormation registry.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn accept_terms_and_conditions(mut self, inp: bool) -> Self {
            self.inner = self.inner.accept_terms_and_conditions(inp);
            self
        }
        /// <p>Whether you accept the <a href="https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf">Terms and Conditions</a> for publishing extensions in the CloudFormation registry.
        /// You must accept the terms and conditions in order to register to publish public extensions
        /// to the CloudFormation registry.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn set_accept_terms_and_conditions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_accept_terms_and_conditions(input);
            self
        }
        /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
        /// Resource Name (ARN) for your connection to that account.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
        /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
        pub fn connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(inp);
            self
        }
        /// <p>If you are using a Bitbucket or GitHub account for identity verification, the Amazon
        /// Resource Name (ARN) for your connection to that account.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
        /// extensions</a> in the <i>CloudFormation CLI User Guide</i>.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterType`.
    ///
    /// <p>Registers an extension with the CloudFormation service. Registering an
    /// extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:</p>
    /// <ul>
    /// <li>
    /// <p>Validating the extension schema</p>
    /// </li>
    /// <li>
    /// <p>Determining which handlers, if any, have been specified for the extension</p>
    /// </li>
    /// <li>
    /// <p>Making the extension available for use in your account</p>
    /// </li>
    /// </ul>
    /// <p>For more information on how to develop extensions and ready them for registeration, see
    /// <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
    /// Providers</a> in the <i>CloudFormation CLI User
    /// Guide</i>.</p>
    /// <p>You can have a maximum of 50 resource extension versions registered at a time. This
    /// maximum is per account and per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to deregister specific extension versions if necessary.</p>
    /// <p>Once you have initiated a registration request using <code>
    /// <a>RegisterType</a>
    /// </code>, you can use <code>
    /// <a>DescribeTypeRegistration</a>
    /// </code> to
    /// monitor the progress of the registration request.</p>
    /// <p>Once you have registered a private extension in your account and region, use <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify configuration properties for the extension. For
    /// more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level</a> in the <i>CloudFormation
    /// User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_type_input::Builder,
    }
    impl<C, M, R> RegisterType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterTypeInputOperationOutputAlias,
                crate::output::RegisterTypeOutput,
                crate::error::RegisterTypeError,
                crate::input::RegisterTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The kind of extension.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension being registered.</p>
        /// <p>We recommend that extension names adhere to the following patterns: </p>
        /// <ul>
        /// <li>
        /// <p>For resource types,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
        /// </li>
        /// <li>
        /// <p>For modules,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following organization namespaces are reserved and cannot be used in your
        /// extension names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Alexa</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AMZN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Custom</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Dev</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension being registered.</p>
        /// <p>We recommend that extension names adhere to the following patterns: </p>
        /// <ul>
        /// <li>
        /// <p>For resource types,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p>
        /// </li>
        /// <li>
        /// <p>For modules,
        /// <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following organization namespaces are reserved and cannot be used in your
        /// extension names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Alexa</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AMZN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Custom</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Dev</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>A url to the S3 bucket containing the extension project package that contains the
        /// neccessary files for the extension you want to register.</p>
        /// <p>For information on generating a schema handler package for the extension you want to
        /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
        /// in the <i>CloudFormation CLI User Guide</i>.</p>
        /// <note>
        /// <p>The user registering the extension must be able to access the package in the S3
        /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
        /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
        /// for Amazon S3</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// </note>
        pub fn schema_handler_package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_handler_package(inp);
            self
        }
        /// <p>A url to the S3 bucket containing the extension project package that contains the
        /// neccessary files for the extension you want to register.</p>
        /// <p>For information on generating a schema handler package for the extension you want to
        /// register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
        /// in the <i>CloudFormation CLI User Guide</i>.</p>
        /// <note>
        /// <p>The user registering the extension must be able to access the package in the S3
        /// bucket. That is, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the
        /// schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
        /// for Amazon S3</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_schema_handler_package(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_handler_package(input);
            self
        }
        /// <p>Specifies logging configuration information for an extension.</p>
        pub fn logging_config(mut self, inp: crate::model::LoggingConfig) -> Self {
            self.inner = self.inner.logging_config(inp);
            self
        }
        /// <p>Specifies logging configuration information for an extension.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.inner = self.inner.set_logging_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
        /// when invoking the extension.</p>
        /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
        /// relationship with the CloudFormation service principle
        /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
        /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
        /// an <i>
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
        /// execution role</a>
        /// </i> that includes the necessary permissions to call
        /// those Amazon Web Services APIs, and provision that execution role in your account. When
        /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
        /// execution role to create a temporary session token, which it then passes to the resource
        /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
        /// when invoking the extension.</p>
        /// <p>For CloudFormation to assume the specified execution role, the role must contain a trust
        /// relationship with the CloudFormation service principle
        /// (<code>resources.cloudformation.amazonaws.com</code>). For more information on adding
        /// trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy</a> in the <i>Identity and Access Management User
        /// Guide</i>.</p>
        /// <p>If your extension calls Amazon Web Services APIs in any of its handlers, you must create
        /// an <i>
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM
        /// execution role</a>
        /// </i> that includes the necessary permissions to call
        /// those Amazon Web Services APIs, and provision that execution role in your account. When
        /// CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
        /// execution role to create a temporary session token, which it then passes to the resource
        /// type handler, thereby supplying your resource type with the appropriate credentials.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>A unique identifier that acts as an idempotency key for this registration request.
        /// Specifying a client request token prevents CloudFormation from generating more
        /// than one version of an extension from the same registeration request, even if the request
        /// is submitted multiple times. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier that acts as an idempotency key for this registration request.
        /// Specifying a client request token prevents CloudFormation from generating more
        /// than one version of an extension from the same registeration request, even if the request
        /// is submitted multiple times. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RollbackStack`.
    ///
    /// <p>When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the <a>DescribeStacks</a> API.</p>
    /// <p>Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or <code>UPDATE_FAILED</code> stack statuses.</p>
    /// <p>This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_COMPLETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_COMPLETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_ROLLBACK_COMPLETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IMPORT_COMPLETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IMPORT_ROLLBACK_COMPLETE</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RollbackStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rollback_stack_input::Builder,
    }
    impl<C, M, R> RollbackStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RollbackStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RollbackStackOutput,
            aws_smithy_http::result::SdkError<crate::error::RollbackStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RollbackStackInputOperationOutputAlias,
                crate::output::RollbackStackOutput,
                crate::error::RollbackStackError,
                crate::input::RollbackStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that is associated with the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name that is associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management role that CloudFormation assumes to rollback the stack.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>RollbackStack</code> request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetStackPolicy`.
    ///
    /// <p>Sets a stack policy for a specified stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetStackPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_stack_policy_input::Builder,
    }
    impl<C, M, R> SetStackPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetStackPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetStackPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SetStackPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetStackPolicyInputOperationOutputAlias,
                crate::output::SetStackPolicyOutput,
                crate::error::SetStackPolicyError,
                crate::input::SetStackPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique stack ID that you want to associate a policy with.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or unique stack ID that you want to associate a policy with.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
        /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        pub fn stack_policy_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_body(inp);
            self
        }
        /// <p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates
        /// to Stack Resources</a> in the CloudFormation User Guide. You can specify either
        /// the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_body(input);
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn stack_policy_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_url(inp);
            self
        }
        /// <p>Location of a file containing the stack policy. The URL must point to a policy
        /// (maximum size: 16 KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTypeConfiguration`.
    ///
    /// <p>Specifies the configuration data for a registered CloudFormation extension, in the given
    /// account and region.</p>
    /// <p>To view the current configuration data for an extension, refer to the
    /// <code>ConfigurationSchema</code> element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level</a> in the
    /// <i>CloudFormation User Guide</i>.</p>
    /// <important>
    /// <p>It is strongly recommended that you use dynamic references to restrict sensitive
    /// configuration definitions, such as third-party credentials. For more details on dynamic
    /// references, see <a href="https://docs.aws.amazon.com/">Using dynamic references to specify
    /// template values</a> in the <i>CloudFormation User
    /// Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct SetTypeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_type_configuration_input::Builder,
    }
    impl<C, M, R> SetTypeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetTypeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTypeConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTypeConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetTypeConfigurationInputOperationOutputAlias,
                crate::output::SetTypeConfigurationOutput,
                crate::error::SetTypeConfigurationError,
                crate::input::SetTypeConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
        /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
        /// configuration for an extension, but not for a specific extension version.</p>
        pub fn type_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will
        /// be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        /// <p>Do not include the extension versions suffix at the end of the ARN. You can set the
        /// configuration for an extension, but not for a specific extension version.</p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_arn(input);
            self
        }
        /// <p>The configuration data for the extension, in this account and region. </p>
        /// <p>The configuration data must be formatted as JSON, and validate against the schema
        /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
        /// <i>CloudFormation CLI User Guide</i>.</p>
        pub fn configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The configuration data for the extension, in this account and region. </p>
        /// <p>The configuration data must be formatted as JSON, and validate against the schema
        /// returned in the <code>ConfigurationSchema</code> response element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration">Defining account-level configuration data for an extension</a> in the
        /// <i>CloudFormation CLI User Guide</i>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>An alias by which to refer to this extension configuration data.</p>
        /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
        /// for a resource type extension.</p>
        pub fn configuration_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_alias(inp);
            self
        }
        /// <p>An alias by which to refer to this extension configuration data.</p>
        /// <p>Conditional: Specifying a configuration alias is required when setting a configuration
        /// for a resource type extension.</p>
        pub fn set_configuration_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_alias(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The type of extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ThirdPartyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of extension.</p>
        /// <p>Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
        /// <code>TypeName</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTypeDefaultVersion`.
    ///
    /// <p>Specify the default version of an extension. The default version of an extension will be
    /// used in CloudFormation operations.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetTypeDefaultVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_type_default_version_input::Builder,
    }
    impl<C, M, R> SetTypeDefaultVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetTypeDefaultVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTypeDefaultVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTypeDefaultVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetTypeDefaultVersionInputOperationOutputAlias,
                crate::output::SetTypeDefaultVersionOutput,
                crate::error::SetTypeDefaultVersionError,
                crate::input::SetTypeDefaultVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension for which you want version summary
        /// information.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::RegistryType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The kind of extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or
        /// <code>Arn</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of
        /// the Amazon Resource Name (ARN) assigned to the extension version when it is
        /// registered.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignalResource`.
    ///
    /// <p>Sends a signal to the specified resource with a success or failure status. You can
    /// use the SignalResource API in conjunction with a creation policy or update policy.
    /// CloudFormation doesn't proceed with a stack creation or update until resources receive the
    /// required number of signals or the timeout period is exceeded. The SignalResource API is
    /// useful in cases where you want to send signals from anywhere other than an Amazon EC2
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct SignalResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::signal_resource_input::Builder,
    }
    impl<C, M, R> SignalResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SignalResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignalResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::SignalResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SignalResourceInputOperationOutputAlias,
                crate::output::SignalResourceOutput,
                crate::error::SignalResourceError,
                crate::input::SignalResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stack name or unique stack ID that includes the resource that you want to
        /// signal.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The stack name or unique stack ID that includes the resource that you want to
        /// signal.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
        /// the resource that given in the template.</p>
        pub fn logical_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_resource_id(inp);
            self
        }
        /// <p>The logical ID of the resource that you want to signal. The logical ID is the name of
        /// the resource that given in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logical_resource_id(input);
            self
        }
        /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
        /// groups, specify the instance ID that you are signaling as the unique ID. If you send
        /// multiple signals to a single resource (such as signaling a wait condition), each signal
        /// requires a different unique ID.</p>
        pub fn unique_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_id(inp);
            self
        }
        /// <p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
        /// groups, specify the instance ID that you are signaling as the unique ID. If you send
        /// multiple signals to a single resource (such as signaling a wait condition), each signal
        /// requires a different unique ID.</p>
        pub fn set_unique_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_unique_id(input);
            self
        }
        /// <p>The status of the signal, which is either success or failure. A failure signal causes
        /// CloudFormation to immediately fail the stack creation or update.</p>
        pub fn status(mut self, inp: crate::model::ResourceSignalStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the signal, which is either success or failure. A failure signal causes
        /// CloudFormation to immediately fail the stack creation or update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceSignalStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStackSetOperation`.
    ///
    /// <p>Stops an in-progress operation on a stack set and its associated stack instances. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopStackSetOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_stack_set_operation_input::Builder,
    }
    impl<C, M, R> StopStackSetOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopStackSetOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStackSetOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStackSetOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopStackSetOperationInputOperationOutputAlias,
                crate::output::StopStackSetOperationOutput,
                crate::error::StopStackSetOperationError,
                crate::input::StopStackSetOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to stop the operation
        /// for.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to stop the operation
        /// for.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>The ID of the stack operation. </p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The ID of the stack operation. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestType`.
    ///
    /// <p>Tests a registered extension to make sure it meets all necessary requirements for being
    /// published in the CloudFormation registry.</p>
    /// <ul>
    /// <li>
    /// <p>For resource types, this includes passing all contracts tests defined for the
    /// type.</p>
    /// </li>
    /// <li>
    /// <p>For modules, this includes determining if the module's model meets all necessary
    /// requirements.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing">Testing your public extension prior to publishing</a> in the
    /// <i>CloudFormation CLI User Guide</i>.</p>
    /// <p>If you do not specify a version, CloudFormation uses the default version of the
    /// extension in your account and region for testing.</p>
    /// <p>To perform testing, CloudFormation assumes the execution role specified when the type
    /// was registered. For more information, see <a href="AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
    /// <p>Once you've initiated testing on an extension using <code>TestType</code>, you can use
    /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a> to monitor the current test status and test
    /// status description for the extension.</p>
    /// <p>An extension must have a test status of <code>PASSED</code> before it can be published.
    /// For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public use</a>
    /// in the <i>CloudFormation CLI User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_type_input::Builder,
    }
    impl<C, M, R> TestType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::TestTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestTypeInputOperationOutputAlias,
                crate::output::TestTypeOutput,
                crate::error::TestTypeError,
                crate::input::TestTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the extension.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The type of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ThirdPartyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the extension to test.</p>
        /// <p>Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and
        /// <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The version of the extension to test.</p>
        /// <p>You can specify the version id with either <code>Arn</code>, or with
        /// <code>TypeName</code> and <code>Type</code>.</p>
        /// <p>If you do not specify a version, CloudFormation uses the default version of the
        /// extension in this account and region for testing.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The version of the extension to test.</p>
        /// <p>You can specify the version id with either <code>Arn</code>, or with
        /// <code>TypeName</code> and <code>Type</code>.</p>
        /// <p>If you do not specify a version, CloudFormation uses the default version of the
        /// extension in this account and region for testing.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
        /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
        /// extension has been assigned a test type status of <code>PASSED</code> or
        /// <code>FAILED</code>.</p>
        /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
        /// bucket. Specifically, the user needs the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>GetObject</p>
        /// </li>
        /// <li>
        /// <p>PutObject</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
        /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
        /// Access Management User Guide</i>.</p>
        pub fn log_delivery_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_delivery_bucket(inp);
            self
        }
        /// <p>The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
        /// <p>CloudFormation delivers the logs by the time contract testing has completed and the
        /// extension has been assigned a test type status of <code>PASSED</code> or
        /// <code>FAILED</code>.</p>
        /// <p>The user calling <code>TestType</code> must be able to access items in the specified S3
        /// bucket. Specifically, the user needs the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>GetObject</p>
        /// </li>
        /// <li>
        /// <p>PutObject</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
        /// Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and
        /// Access Management User Guide</i>.</p>
        pub fn set_log_delivery_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_delivery_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStack`.
    ///
    /// <p>Updates a stack as specified in the template. After the call completes successfully,
    /// the stack update starts. You can check the status of the stack via the <a>DescribeStacks</a> action.</p>
    /// <p>To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.</p>
    /// <p>For more information about creating an update template, updating a stack, and
    /// monitoring the progress of the update, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
    /// Stack</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stack_input::Builder,
    }
    impl<C, M, R> UpdateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStackInputOperationOutputAlias,
                crate::output::UpdateStackOutput,
                crate::error::UpdateStackError,
                crate::input::UpdateStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique stack ID of the stack to update.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or unique stack ID of the stack to update.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.)</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template that
        /// is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// <p>Reuse the existing template that is associated with the stack that you are
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn use_previous_template(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_previous_template(inp);
            self
        }
        /// <p>Reuse the existing template that is associated with the stack that you are
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code>, <code>TemplateURL</code>, or set the
        /// <code>UsePreviousTemplate</code> to <code>true</code>.</p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_previous_template(input);
            self
        }
        /// <p>Structure containing the temporary overriding stack policy body. You can specify
        /// either the <code>StackPolicyDuringUpdateBody</code> or the
        /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn stack_policy_during_update_body(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stack_policy_during_update_body(inp);
            self
        }
        /// <p>Structure containing the temporary overriding stack policy body. You can specify
        /// either the <code>StackPolicyDuringUpdateBody</code> or the
        /// <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn set_stack_policy_during_update_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_during_update_body(input);
            self
        }
        /// <p>Location of a file containing the temporary overriding stack policy. The URL must
        /// point to a policy (max size: 16KB) located in an S3 bucket in
        /// the same Region as the stack. You can specify either the
        /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
        /// parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn stack_policy_during_update_url(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stack_policy_during_update_url(inp);
            self
        }
        /// <p>Location of a file containing the temporary overriding stack policy. The URL must
        /// point to a policy (max size: 16KB) located in an S3 bucket in
        /// the same Region as the stack. You can specify either the
        /// <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code>
        /// parameter, but not both.</p>
        /// <p>If you want to update protected resources, specify a temporary overriding stack
        /// policy during this update. If you do not specify a stack policy, the current policy that is
        /// associated with the stack will be used.</p>
        pub fn set_stack_policy_during_update_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_during_update_url(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of <code>Parameter</code> structures that specify input parameters for the
        /// stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
        /// type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually updating the stack. If your stack template contains one or
        /// more macros, and you choose to update a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to update a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must update the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only update stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one
        /// of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability.</p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some template contain macros. Macros perform custom processing on templates; this
        /// can include simple actions like find-and-replace operations, all the way to extensive
        /// transformations of entire templates. Because of this, users typically create a change
        /// set from the processed template, so that they can review the changes resulting from
        /// the macros before actually updating the stack. If your stack template contains one or
        /// more macros, and you choose to update a stack directly from the processed template,
        /// without first reviewing the resulting changes in a change set, you must acknowledge
        /// this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.</p>
        /// <p>If you want to update a stack from a stack template that contains macros
        /// <i>and</i> nested stacks, you must update the stack directly from
        /// the template using this capability.</p>
        /// <important>
        /// <p>You should only update stacks directly from a stack template that contains
        /// macros if you know what processing the macro performs.</p>
        /// <p>Each macro relies on an underlying Lambda service function for processing stack
        /// templates. Be aware that the Lambda function owner can update the function
        /// operation without CloudFormation being notified.</p>
        /// </important>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
        /// CloudFormation Macros to Perform Custom Processing on
        /// Templates</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The template resource types that you have permissions to work with for this update
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource that you're updating, the
        /// stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn resource_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(inp);
            self
        }
        /// <p>The template resource types that you have permissions to work with for this update
        /// stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
        /// <code>Custom::MyCustomInstance</code>.</p>
        /// <p>If the list of resource types doesn't include a resource that you're updating, the
        /// stack update fails. By default, CloudFormation grants permissions to all resource
        /// types. Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management</a>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
        /// that CloudFormation assumes to update the stack. CloudFormation uses the role's
        /// credentials to make calls on your behalf. CloudFormation always uses this role for all
        /// future operations on the stack. As long as users have permission to operate on the stack,
        /// CloudFormation uses this role even if the users don't have permission to pass it.
        /// Ensure that the role grants least privilege.</p>
        /// <p>If you don't specify a value, CloudFormation uses the role that was previously
        /// associated with the stack. If no role is available, CloudFormation uses a temporary
        /// session that is generated from your user credentials.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(mut self, inp: crate::model::RollbackConfiguration) -> Self {
            self.inner = self.inner.rollback_configuration(inp);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and
        /// updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rollback_configuration(input);
            self
        }
        /// <p>Structure containing a new stack policy body. You can specify either the
        /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn stack_policy_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_body(inp);
            self
        }
        /// <p>Structure containing a new stack policy body. You can specify either the
        /// <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not
        /// both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn set_stack_policy_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_body(input);
            self
        }
        /// <p>Location of a file containing the updated stack policy. The URL must point to a
        /// policy (max size: 16KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn stack_policy_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_policy_url(inp);
            self
        }
        /// <p>Location of a file containing the updated stack policy. The URL must point to a
        /// policy (max size: 16KB) located in an S3 bucket in the same
        /// Region as the stack. You can specify either the <code>StackPolicyBody</code> or the
        /// <code>StackPolicyURL</code> parameter, but not both.</p>
        /// <p>You might update the stack policy, for example, in order to protect a new resource
        /// that you created during a stack update. If you do not specify a stack policy, the current
        /// policy that is associated with the stack is unchanged.</p>
        pub fn set_stack_policy_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_policy_url(input);
            self
        }
        /// Appends an item to `NotificationARNs`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
        /// CloudFormation associates with the stack. Specify an empty list to remove all notification
        /// topics.</p>
        pub fn notification_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_ar_ns(inp);
            self
        }
        /// <p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
        /// CloudFormation associates with the stack. Specify an empty list to remove all notification
        /// topics.</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_ar_ns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to supported resources in the stack. You can specify a maximum number of 50
        /// tags.</p>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
        /// tags. If you specify an empty value, CloudFormation removes all associated
        /// tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Key-value pairs to associate with this stack. CloudFormation also propagates
        /// these tags to supported resources in the stack. You can specify a maximum number of 50
        /// tags.</p>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the stack's
        /// tags. If you specify an empty value, CloudFormation removes all associated
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>False</code>
        /// </p>
        pub fn disable_rollback(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_rollback(inp);
            self
        }
        /// <p>Preserve the state of previously provisioned resources when an operation fails.</p>
        /// <p>Default: <code>False</code>
        /// </p>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_rollback(input);
            self
        }
        /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if
        /// you plan to retry requests so that CloudFormation knows that you're not attempting to
        /// update a stack with the same name. You might retry <code>UpdateStack</code> requests to
        /// ensure that CloudFormation successfully received them.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request
        /// token, which you can use to track operations. For example, if you execute a
        /// <code>CreateStack</code> operation with the token <code>token1</code>, then all the
        /// <code>StackEvents</code> generated by that operation will have
        /// <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab.
        /// Stack operations that are initiated from the console use the token format
        /// <i>Console-StackOperation-ID</i>, which helps you easily identify the
        /// stack operation . For example, if you create a stack using the console, each stack event
        /// would be assigned the same token in the following format:
        /// <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStackInstances`.
    ///
    /// <p>Updates the parameter values for stack instances for the specified accounts, within
    /// the specified Regions. A stack instance refers to a stack in a specific account and Region. </p>
    /// <p>You can only update stack instances in Regions and accounts where they already exist;
    /// to create additional stack instances, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html">CreateStackInstances</a>. </p>
    /// <p>During stack set updates, any parameters overridden for a stack instance are not
    /// updated, but retain their overridden value.</p>
    /// <p>You can only update the parameter <i>values</i> that are specified in
    /// the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template. If you add a parameter to a
    /// template, before you can override the parameter value specified in the stack set you must
    /// first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
    /// parameter value specified in the stack set. Once a stack instance has been updated with the
    /// new parameter, you can then override the parameter value using
    /// <code>UpdateStackInstances</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStackInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stack_instances_input::Builder,
    }
    impl<C, M, R> UpdateStackInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStackInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStackInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStackInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStackInstancesInputOperationOutputAlias,
                crate::output::UpdateStackInstancesOutput,
                crate::error::UpdateStackInstancesError,
                crate::input::UpdateStackInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set associated with the stack instances.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `Accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
        /// for stack instances. The overridden parameter values will be applied to all stack instances
        /// in the specified accounts and Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn accounts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accounts(inp);
            self
        }
        /// <p>[Self-managed permissions] The names of one or more Amazon Web Services accounts for which you want to update parameter values
        /// for stack instances. The overridden parameter values will be applied to all stack instances
        /// in the specified accounts and Regions.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accounts(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which you want to
        /// update parameter values for stack instances. If your update targets OUs, the overridden
        /// parameter values only apply to the accounts that are currently in the target OUs and their
        /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
        /// overridden values.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn deployment_targets(mut self, inp: crate::model::DeploymentTargets) -> Self {
            self.inner = self.inner.deployment_targets(inp);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts for which you want to
        /// update parameter values for stack instances. If your update targets OUs, the overridden
        /// parameter values only apply to the accounts that are currently in the target OUs and their
        /// child OUs. Accounts added to the target OUs and their child OUs in the future won't use the
        /// overridden values.</p>
        /// <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not
        /// both.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.inner = self.inner.set_deployment_targets(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The names of one or more Regions in which you want to update parameter values for
        /// stack instances. The overridden parameter values will be applied to all stack instances in
        /// the specified accounts and Regions.</p>
        pub fn regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(inp);
            self
        }
        /// <p>The names of one or more Regions in which you want to update parameter values for
        /// stack instances. The overridden parameter values will be applied to all stack instances in
        /// the specified accounts and Regions.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// Appends an item to `ParameterOverrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p> A list of input parameters whose values you want to update for the specified stack
        /// instances. </p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance update
        /// operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
        /// update the stack set template. If you add a parameter to a template, before you can
        /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
        /// parameter value specified in the stack set. Once a stack instance has been updated with the
        /// new parameter, you can then override the parameter value using
        /// <code>UpdateStackInstances</code>.</p>
        pub fn parameter_overrides(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameter_overrides(inp);
            self
        }
        /// <p> A list of input parameters whose values you want to update for the specified stack
        /// instances. </p>
        /// <p>Any overridden parameter values will be applied to all stack instances in the
        /// specified accounts and Regions. When specifying parameters and their values, be aware of
        /// how CloudFormation sets parameter values during stack instance update
        /// operations:</p>
        /// <ul>
        /// <li>
        /// <p>To override the current value for a parameter, include the parameter and
        /// specify its value.</p>
        /// </li>
        /// <li>
        /// <p>To leave an overridden parameter set to its present value, include the parameter and specify <code>UsePreviousValue</code> as
        /// <code>true</code>. (You cannot specify both a value and set
        /// <code>UsePreviousValue</code> to <code>true</code>.)</p>
        /// </li>
        /// <li>
        /// <p>To set an overridden parameter back to the value specified in the stack set,
        /// specify a parameter list but do not include the parameter in the list.</p>
        /// </li>
        /// <li>
        /// <p>To leave all parameters set to their present values, do not specify this
        /// property at all.</p>
        /// </li>
        /// </ul>
        /// <p>During stack set updates, any parameter values overridden for a stack instance are
        /// not updated, but retain their overridden value.</p>
        /// <p>You can only override the parameter <i>values</i> that are specified in
        /// the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to
        /// update the stack set template. If you add a parameter to a template, before you can
        /// override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and
        /// parameter value specified in the stack set. Once a stack instance has been updated with the
        /// new parameter, you can then override the parameter value using
        /// <code>UpdateStackInstances</code>.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_overrides(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>The unique identifier for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one automatically.
        /// </p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The unique identifier for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, the SDK generates one automatically.
        /// </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStackSet`.
    ///
    /// <p>Updates the stack set, and associated stack instances in the specified accounts and
    /// Regions.</p>
    /// <p>Even if the stack set operation created by updating the stack set fails (completely
    /// or partially, below or above a specified failure tolerance), the stack set is updated with
    /// your changes. Subsequent <a>CreateStackInstances</a> calls on the specified
    /// stack set use the updated stack set.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStackSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stack_set_input::Builder,
    }
    impl<C, M, R> UpdateStackSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStackSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStackSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStackSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStackSetInputOperationOutputAlias,
                crate::output::UpdateStackSetOutput,
                crate::error::UpdateStackSetError,
                crate::input::UpdateStackSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or unique ID of the stack set that you want to update.</p>
        pub fn stack_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack set that you want to update.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// <p>A brief description of updates that you are making.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A brief description of updates that you are making.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>The structure that contains the template body, with a minimum length of 1 byte and a
        /// maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>The location of the file that contains the template body. The URL must point to a
        /// template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
        /// Manager document. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
        /// <p>Use the existing template that's associated with the stack set that you're
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn use_previous_template(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_previous_template(inp);
            self
        }
        /// <p>Use the existing template that's associated with the stack set that you're
        /// updating.</p>
        /// <p>Conditional: You must specify only one of the following parameters:
        /// <code>TemplateBody</code> or <code>TemplateURL</code>—or set
        /// <code>UsePreviousTemplate</code> to true. </p>
        pub fn set_use_previous_template(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_previous_template(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of input parameters for the stack set template. </p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of input parameters for the stack set template. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack set and its associated stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
        /// specifying one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability. </p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must update the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To update the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>In some cases, you must explicitly acknowledge that your stack template contains certain
        /// capabilities in order for CloudFormation to update the stack set and its associated stack
        /// instances.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
        /// </p>
        /// <p>Some stack templates might include resources that can affect permissions in
        /// your Amazon Web Services account; for example, by creating new Identity and Access Management
        /// (IAM) users. For those stacks sets, you must explicitly acknowledge this by
        /// specifying one of these capabilities.</p>
        /// <p>The following IAM resources require you to specify either the
        /// <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code>
        /// capability.</p>
        /// <ul>
        /// <li>
        /// <p>If you have IAM resources, you can specify either capability. </p>
        /// </li>
        /// <li>
        /// <p>If you have IAM resources with custom names, you <i>must</i>
        /// specify <code>CAPABILITY_NAMED_IAM</code>. </p>
        /// </li>
        /// <li>
        /// <p>If you don't specify either of these capabilities, CloudFormation returns an
        /// <code>InsufficientCapabilities</code> error.</p>
        /// </li>
        /// </ul>
        /// <p>If your stack template contains these resources, we recommend that you review
        /// all permissions associated with them and edit their permissions if
        /// necessary.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
        /// AWS::IAM::AccessKey</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
        /// AWS::IAM::Group</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
        /// AWS::IAM::Policy</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
        /// AWS::IAM::Role</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
        /// AWS::IAM::User</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM
        /// Resources in CloudFormation Templates</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPABILITY_AUTO_EXPAND</code>
        /// </p>
        /// <p>Some templates reference macros. If your stack set template references one or more
        /// macros, you must update the stack set directly from the processed template, without
        /// first reviewing the resulting changes in a change set. To update the stack set
        /// directly, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation Macros to
        /// Perform Custom Processing on Templates</a>.</p>
        /// <important>
        /// <p>Stack sets with service-managed permissions do not currently support the use of
        /// macros in templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a>
        /// transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
        /// for a stack set with service-managed permissions, if you reference a macro in your
        /// template the stack set operation will fail.</p>
        /// </important>
        /// </li>
        /// </ul>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. You can specify a maximum number of 50 tags.</p>
        /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
        /// currently associated with this stack set. This means:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
        /// stack's tags. </p>
        /// </li>
        /// <li>
        /// <p>If you specify <i>any</i> tags using this parameter, you must
        /// specify <i>all</i> the tags that you want associated with this stack
        /// set, even tags you've specifed before (for example, when creating the stack set or
        /// during a previous update of the stack set.). Any tags that you don't include in the
        /// updated list of tags are removed from the stack set, and therefore from the stacks
        /// and resources as well. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an empty value, CloudFormation removes all currently
        /// associated tags.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you omit tags that are currently associated with the stack set from the list of tags you
        /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
        /// and checks to see if you have permission to untag resources. If you don't have the
        /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
        /// <code>access denied</code> error, and the stack set is not updated.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pairs to associate with this stack set and the stacks created from it.
        /// CloudFormation also propagates these tags to supported resources that are created in
        /// the stacks. You can specify a maximum number of 50 tags.</p>
        /// <p>If you specify tags for this parameter, those tags replace any list of tags that are
        /// currently associated with this stack set. This means:</p>
        /// <ul>
        /// <li>
        /// <p>If you don't specify this parameter, CloudFormation doesn't modify the
        /// stack's tags. </p>
        /// </li>
        /// <li>
        /// <p>If you specify <i>any</i> tags using this parameter, you must
        /// specify <i>all</i> the tags that you want associated with this stack
        /// set, even tags you've specifed before (for example, when creating the stack set or
        /// during a previous update of the stack set.). Any tags that you don't include in the
        /// updated list of tags are removed from the stack set, and therefore from the stacks
        /// and resources as well. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an empty value, CloudFormation removes all currently
        /// associated tags.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify new tags as part of an <code>UpdateStackSet</code> action,
        /// CloudFormation checks to see if you have the required IAM permission to tag resources. If
        /// you omit tags that are currently associated with the stack set from the list of tags you
        /// specify, CloudFormation assumes that you want to remove those tags from the stack set,
        /// and checks to see if you have permission to untag resources. If you don't have the
        /// necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
        /// <code>access denied</code> error, and the stack set is not updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            inp: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.inner = self.inner.operation_preferences(inp);
            self
        }
        /// <p>Preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_operation_preferences(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
        /// Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        /// <p>If you specified a customized administrator role when you created the stack set, you
        /// must specify a customized administrator role, even if it is the same customized
        /// administrator role used with this stack set previously.</p>
        pub fn administration_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administration_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p>
        /// <p>Specify an IAM role only if you are using customized administrator roles to control
        /// which users or groups can manage specific stack sets within the same administrator account.
        /// For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
        /// Permissions for Stack Set Operations</a> in the
        /// <i>CloudFormation User Guide</i>.</p>
        /// <p>If you specified a customized administrator role when you created the stack set, you
        /// must specify a customized administrator role, even if it is the same customized
        /// administrator role used with this stack set previously.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administration_role_arn(input);
            self
        }
        /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets. </p>
        /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
        /// If you do not specify a customized execution role, CloudFormation performs the update using the role
        /// previously associated with the stack set, so long as you have permissions to perform
        /// operations on the stack set.</p>
        pub fn execution_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_name(inp);
            self
        }
        /// <p>The name of the IAM execution role to use to update the stack set. If you do not specify
        /// an execution role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role
        /// for the stack set operation.</p>
        /// <p>Specify an IAM role only if you are using customized execution roles to control which
        /// stack resources users and groups can include in their stack sets. </p>
        /// <p> If you specify a customized execution role, CloudFormation uses that role to update the stack.
        /// If you do not specify a customized execution role, CloudFormation performs the update using the role
        /// previously associated with the stack set, so long as you have permissions to perform
        /// operations on the stack set.</p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_name(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts in which to update
        /// associated stack instances.</p>
        /// <p>To update all the stack instances associated with this stack set, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        /// <p>If the stack set update includes changes to the template (that is, if
        /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
        /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
        /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts
        /// and Regions, while leaving all other stack instances with their existing stack instance
        /// status.</p>
        pub fn deployment_targets(mut self, inp: crate::model::DeploymentTargets) -> Self {
            self.inner = self.inner.deployment_targets(inp);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts in which to update
        /// associated stack instances.</p>
        /// <p>To update all the stack instances associated with this stack set, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        /// <p>If the stack set update includes changes to the template (that is, if
        /// <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the
        /// <code>Parameters</code>, CloudFormation marks all stack instances with a status
        /// of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts
        /// and Regions, while leaving all other stack instances with their existing stack instance
        /// status.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.inner = self.inner.set_deployment_targets(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
        /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
        /// set.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn permission_model(mut self, inp: crate::model::PermissionModels) -> Self {
            self.inner = self.inner.permission_model(inp);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created. You cannot
        /// modify <code>PermissionModel</code> if there are stack instances associated with your stack
        /// set.</p>
        /// <ul>
        /// <li>
        /// <p>With <code>self-managed</code> permissions, you must create the administrator and
        /// execution roles required to deploy to target accounts. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
        /// Self-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// <li>
        /// <p>With <code>service-managed</code> permissions, StackSets automatically creates the
        /// IAM roles required to deploy to accounts managed by Organizations. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.inner = self.inner.set_permission_model(input);
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
        /// Organizations accounts that are added to a target organization or organizational
        /// unit (OU).</p>
        /// <p>If you specify <code>AutoDeployment</code>, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        pub fn auto_deployment(mut self, inp: crate::model::AutoDeployment) -> Self {
            self.inner = self.inner.auto_deployment(inp);
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to
        /// Organizations accounts that are added to a target organization or organizational
        /// unit (OU).</p>
        /// <p>If you specify <code>AutoDeployment</code>, do not specify
        /// <code>DeploymentTargets</code> or <code>Regions</code>.</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.inner = self.inner.set_auto_deployment(input);
            self
        }
        /// <p>The unique ID for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, CloudFormation generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack
        /// instances whose status is <code>OUTDATED</code>. </p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The unique ID for this stack set operation. </p>
        /// <p>The operation ID also functions as an idempotency token, to ensure that
        /// CloudFormation performs the stack set operation only once, even if you retry the request
        /// multiple times. You might retry stack set operation requests to ensure that
        /// CloudFormation successfully received them.</p>
        /// <p>If you don't specify an operation ID, CloudFormation generates one
        /// automatically.</p>
        /// <p>Repeating this stack set operation with a new operation ID retries all stack
        /// instances whose status is <code>OUTDATED</code>. </p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
        /// Appends an item to `Accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
        /// If you specify accounts, you must also specify the Regions in which to update stack set
        /// instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn accounts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accounts(inp);
            self
        }
        /// <p>[Self-managed permissions] The accounts in which to update associated stack instances.
        /// If you specify accounts, you must also specify the Regions in which to update stack set
        /// instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accounts(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
        /// must also specify accounts in which to update stack set instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(inp);
            self
        }
        /// <p>The Regions in which to update associated stack instances. If you specify Regions, you
        /// must also specify accounts in which to update stack set instances.</p>
        /// <p>To update <i>all</i> the stack instances associated with this stack set,
        /// do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p>
        /// <p>If the stack set update includes changes to the template (that is, if the
        /// <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the
        /// <code>Parameters</code> property, CloudFormation marks all stack instances with a status of
        /// <code>OUTDATED</code> prior to updating the stack instances in the specified accounts
        /// and Regions. If the stack set update does not include changes to the template or
        /// parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
        /// leaving all other stack instances with their existing stack instance status. </p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn call_as(mut self, inp: crate::model::CallAs) -> Self {
            self.inner = self.inner.call_as(inp);
            self
        }
        /// <p>[Service-managed permissions] Specifies whether you are acting as an account
        /// administrator in the organization's management account or as a delegated administrator in a
        /// member account.</p>
        /// <p>By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with
        /// self-managed permissions.</p>
        /// <ul>
        /// <li>
        /// <p>If you are signed in to the management account, specify <code>SELF</code>.</p>
        /// </li>
        /// <li>
        /// <p>If you are signed in to a delegated administrator account, specify
        /// <code>DELEGATED_ADMIN</code>.</p>
        /// <p>Your Amazon Web Services account must be registered as a delegated administrator in
        /// the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_call_as(mut self, input: std::option::Option<crate::model::CallAs>) -> Self {
            self.inner = self.inner.set_call_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTerminationProtection`.
    ///
    /// <p>Updates termination protection for the specified stack. If a user attempts to delete
    /// a stack with termination protection enabled, the operation fails and the stack remains
    /// unchanged. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
    /// Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
    /// stacks</a>, termination protection is set on the root stack and cannot be changed
    /// directly on the nested stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTerminationProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_termination_protection_input::Builder,
    }
    impl<C, M, R> UpdateTerminationProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTerminationProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTerminationProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTerminationProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTerminationProtectionInputOperationOutputAlias,
                crate::output::UpdateTerminationProtectionOutput,
                crate::error::UpdateTerminationProtectionError,
                crate::input::UpdateTerminationProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether to enable termination protection on the specified stack.</p>
        pub fn enable_termination_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_termination_protection(inp);
            self
        }
        /// <p>Whether to enable termination protection on the specified stack.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_termination_protection(input);
            self
        }
        /// <p>The name or unique ID of the stack for which you want to set termination
        /// protection.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name or unique ID of the stack for which you want to set termination
        /// protection.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateTemplate`.
    ///
    /// <p>Validates a specified template. CloudFormation first checks if the template is
    /// valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both
    /// these checks fail, CloudFormation returns a template validation error.</p>
    #[derive(std::fmt::Debug)]
    pub struct ValidateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_template_input::Builder,
    }
    impl<C, M, R> ValidateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidateTemplateInputOperationOutputAlias,
                crate::output::ValidateTemplateOutput,
                crate::error::ValidateTemplateError,
                crate::input::ValidateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>Structure containing the template body with a minimum length of 1 byte and a maximum
        /// length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>Location of file containing the template body. The URL must point to a template (max
        /// size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document.
        /// For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
        /// in the CloudFormation User Guide.</p>
        /// <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If
        /// both are passed, only <code>TemplateBody</code> is used.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
