// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ActivateType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_type`](crate::client::Client::activate_type).
///
/// See [`crate::client::fluent_builders::ActivateType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateType {
    _private: (),
}
impl ActivateType {
    /// Creates a new builder-style object to manufacture [`ActivateTypeInput`](crate::input::ActivateTypeInput)
    pub fn builder() -> crate::input::activate_type_input::Builder {
        crate::input::activate_type_input::Builder::default()
    }
    /// Creates a new `ActivateType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateType {
    type Output =
        std::result::Result<crate::output::ActivateTypeOutput, crate::error::ActivateTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_type_error(response)
        } else {
            crate::operation_deser::parse_activate_type_response(response)
        }
    }
}

/// Operation shape for `BatchDescribeTypeConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_describe_type_configurations`](crate::client::Client::batch_describe_type_configurations).
///
/// See [`crate::client::fluent_builders::BatchDescribeTypeConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDescribeTypeConfigurations {
    _private: (),
}
impl BatchDescribeTypeConfigurations {
    /// Creates a new builder-style object to manufacture [`BatchDescribeTypeConfigurationsInput`](crate::input::BatchDescribeTypeConfigurationsInput)
    pub fn builder() -> crate::input::batch_describe_type_configurations_input::Builder {
        crate::input::batch_describe_type_configurations_input::Builder::default()
    }
    /// Creates a new `BatchDescribeTypeConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDescribeTypeConfigurations {
    type Output = std::result::Result<
        crate::output::BatchDescribeTypeConfigurationsOutput,
        crate::error::BatchDescribeTypeConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_describe_type_configurations_error(response)
        } else {
            crate::operation_deser::parse_batch_describe_type_configurations_response(response)
        }
    }
}

/// Operation shape for `CancelUpdateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_update_stack`](crate::client::Client::cancel_update_stack).
///
/// See [`crate::client::fluent_builders::CancelUpdateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelUpdateStack {
    _private: (),
}
impl CancelUpdateStack {
    /// Creates a new builder-style object to manufacture [`CancelUpdateStackInput`](crate::input::CancelUpdateStackInput)
    pub fn builder() -> crate::input::cancel_update_stack_input::Builder {
        crate::input::cancel_update_stack_input::Builder::default()
    }
    /// Creates a new `CancelUpdateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelUpdateStack {
    type Output = std::result::Result<
        crate::output::CancelUpdateStackOutput,
        crate::error::CancelUpdateStackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_update_stack_error(response)
        } else {
            crate::operation_deser::parse_cancel_update_stack_response(response)
        }
    }
}

/// Operation shape for `ContinueUpdateRollback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`continue_update_rollback`](crate::client::Client::continue_update_rollback).
///
/// See [`crate::client::fluent_builders::ContinueUpdateRollback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ContinueUpdateRollback {
    _private: (),
}
impl ContinueUpdateRollback {
    /// Creates a new builder-style object to manufacture [`ContinueUpdateRollbackInput`](crate::input::ContinueUpdateRollbackInput)
    pub fn builder() -> crate::input::continue_update_rollback_input::Builder {
        crate::input::continue_update_rollback_input::Builder::default()
    }
    /// Creates a new `ContinueUpdateRollback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ContinueUpdateRollback {
    type Output = std::result::Result<
        crate::output::ContinueUpdateRollbackOutput,
        crate::error::ContinueUpdateRollbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_continue_update_rollback_error(response)
        } else {
            crate::operation_deser::parse_continue_update_rollback_response(response)
        }
    }
}

/// Operation shape for `CreateChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_change_set`](crate::client::Client::create_change_set).
///
/// See [`crate::client::fluent_builders::CreateChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChangeSet {
    _private: (),
}
impl CreateChangeSet {
    /// Creates a new builder-style object to manufacture [`CreateChangeSetInput`](crate::input::CreateChangeSetInput)
    pub fn builder() -> crate::input::create_change_set_input::Builder {
        crate::input::create_change_set_input::Builder::default()
    }
    /// Creates a new `CreateChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChangeSet {
    type Output = std::result::Result<
        crate::output::CreateChangeSetOutput,
        crate::error::CreateChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_change_set_error(response)
        } else {
            crate::operation_deser::parse_create_change_set_response(response)
        }
    }
}

/// Operation shape for `CreateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stack`](crate::client::Client::create_stack).
///
/// See [`crate::client::fluent_builders::CreateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStack {
    _private: (),
}
impl CreateStack {
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
    /// Creates a new `CreateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStack {
    type Output =
        std::result::Result<crate::output::CreateStackOutput, crate::error::CreateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stack_error(response)
        } else {
            crate::operation_deser::parse_create_stack_response(response)
        }
    }
}

/// Operation shape for `CreateStackInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stack_instances`](crate::client::Client::create_stack_instances).
///
/// See [`crate::client::fluent_builders::CreateStackInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStackInstances {
    _private: (),
}
impl CreateStackInstances {
    /// Creates a new builder-style object to manufacture [`CreateStackInstancesInput`](crate::input::CreateStackInstancesInput)
    pub fn builder() -> crate::input::create_stack_instances_input::Builder {
        crate::input::create_stack_instances_input::Builder::default()
    }
    /// Creates a new `CreateStackInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStackInstances {
    type Output = std::result::Result<
        crate::output::CreateStackInstancesOutput,
        crate::error::CreateStackInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stack_instances_error(response)
        } else {
            crate::operation_deser::parse_create_stack_instances_response(response)
        }
    }
}

/// Operation shape for `CreateStackSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stack_set`](crate::client::Client::create_stack_set).
///
/// See [`crate::client::fluent_builders::CreateStackSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStackSet {
    _private: (),
}
impl CreateStackSet {
    /// Creates a new builder-style object to manufacture [`CreateStackSetInput`](crate::input::CreateStackSetInput)
    pub fn builder() -> crate::input::create_stack_set_input::Builder {
        crate::input::create_stack_set_input::Builder::default()
    }
    /// Creates a new `CreateStackSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStackSet {
    type Output =
        std::result::Result<crate::output::CreateStackSetOutput, crate::error::CreateStackSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stack_set_error(response)
        } else {
            crate::operation_deser::parse_create_stack_set_response(response)
        }
    }
}

/// Operation shape for `DeactivateType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deactivate_type`](crate::client::Client::deactivate_type).
///
/// See [`crate::client::fluent_builders::DeactivateType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeactivateType {
    _private: (),
}
impl DeactivateType {
    /// Creates a new builder-style object to manufacture [`DeactivateTypeInput`](crate::input::DeactivateTypeInput)
    pub fn builder() -> crate::input::deactivate_type_input::Builder {
        crate::input::deactivate_type_input::Builder::default()
    }
    /// Creates a new `DeactivateType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeactivateType {
    type Output =
        std::result::Result<crate::output::DeactivateTypeOutput, crate::error::DeactivateTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deactivate_type_error(response)
        } else {
            crate::operation_deser::parse_deactivate_type_response(response)
        }
    }
}

/// Operation shape for `DeleteChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_change_set`](crate::client::Client::delete_change_set).
///
/// See [`crate::client::fluent_builders::DeleteChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChangeSet {
    _private: (),
}
impl DeleteChangeSet {
    /// Creates a new builder-style object to manufacture [`DeleteChangeSetInput`](crate::input::DeleteChangeSetInput)
    pub fn builder() -> crate::input::delete_change_set_input::Builder {
        crate::input::delete_change_set_input::Builder::default()
    }
    /// Creates a new `DeleteChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChangeSet {
    type Output = std::result::Result<
        crate::output::DeleteChangeSetOutput,
        crate::error::DeleteChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_change_set_error(response)
        } else {
            crate::operation_deser::parse_delete_change_set_response(response)
        }
    }
}

/// Operation shape for `DeleteStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stack`](crate::client::Client::delete_stack).
///
/// See [`crate::client::fluent_builders::DeleteStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStack {
    _private: (),
}
impl DeleteStack {
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
    /// Creates a new `DeleteStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStack {
    type Output =
        std::result::Result<crate::output::DeleteStackOutput, crate::error::DeleteStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stack_error(response)
        } else {
            crate::operation_deser::parse_delete_stack_response(response)
        }
    }
}

/// Operation shape for `DeleteStackInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stack_instances`](crate::client::Client::delete_stack_instances).
///
/// See [`crate::client::fluent_builders::DeleteStackInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStackInstances {
    _private: (),
}
impl DeleteStackInstances {
    /// Creates a new builder-style object to manufacture [`DeleteStackInstancesInput`](crate::input::DeleteStackInstancesInput)
    pub fn builder() -> crate::input::delete_stack_instances_input::Builder {
        crate::input::delete_stack_instances_input::Builder::default()
    }
    /// Creates a new `DeleteStackInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStackInstances {
    type Output = std::result::Result<
        crate::output::DeleteStackInstancesOutput,
        crate::error::DeleteStackInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stack_instances_error(response)
        } else {
            crate::operation_deser::parse_delete_stack_instances_response(response)
        }
    }
}

/// Operation shape for `DeleteStackSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stack_set`](crate::client::Client::delete_stack_set).
///
/// See [`crate::client::fluent_builders::DeleteStackSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStackSet {
    _private: (),
}
impl DeleteStackSet {
    /// Creates a new builder-style object to manufacture [`DeleteStackSetInput`](crate::input::DeleteStackSetInput)
    pub fn builder() -> crate::input::delete_stack_set_input::Builder {
        crate::input::delete_stack_set_input::Builder::default()
    }
    /// Creates a new `DeleteStackSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStackSet {
    type Output =
        std::result::Result<crate::output::DeleteStackSetOutput, crate::error::DeleteStackSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stack_set_error(response)
        } else {
            crate::operation_deser::parse_delete_stack_set_response(response)
        }
    }
}

/// Operation shape for `DeregisterType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_type`](crate::client::Client::deregister_type).
///
/// See [`crate::client::fluent_builders::DeregisterType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterType {
    _private: (),
}
impl DeregisterType {
    /// Creates a new builder-style object to manufacture [`DeregisterTypeInput`](crate::input::DeregisterTypeInput)
    pub fn builder() -> crate::input::deregister_type_input::Builder {
        crate::input::deregister_type_input::Builder::default()
    }
    /// Creates a new `DeregisterType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterType {
    type Output =
        std::result::Result<crate::output::DeregisterTypeOutput, crate::error::DeregisterTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_type_error(response)
        } else {
            crate::operation_deser::parse_deregister_type_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_limits`](crate::client::Client::describe_account_limits).
///
/// See [`crate::client::fluent_builders::DescribeAccountLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountLimits {
    _private: (),
}
impl DescribeAccountLimits {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
    /// Creates a new `DescribeAccountLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountLimits {
    type Output = std::result::Result<
        crate::output::DescribeAccountLimitsOutput,
        crate::error::DescribeAccountLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_account_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_change_set`](crate::client::Client::describe_change_set).
///
/// See [`crate::client::fluent_builders::DescribeChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChangeSet {
    _private: (),
}
impl DescribeChangeSet {
    /// Creates a new builder-style object to manufacture [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    pub fn builder() -> crate::input::describe_change_set_input::Builder {
        crate::input::describe_change_set_input::Builder::default()
    }
    /// Creates a new `DescribeChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChangeSet {
    type Output = std::result::Result<
        crate::output::DescribeChangeSetOutput,
        crate::error::DescribeChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_change_set_error(response)
        } else {
            crate::operation_deser::parse_describe_change_set_response(response)
        }
    }
}

/// Operation shape for `DescribePublisher`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_publisher`](crate::client::Client::describe_publisher).
///
/// See [`crate::client::fluent_builders::DescribePublisher`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePublisher {
    _private: (),
}
impl DescribePublisher {
    /// Creates a new builder-style object to manufacture [`DescribePublisherInput`](crate::input::DescribePublisherInput)
    pub fn builder() -> crate::input::describe_publisher_input::Builder {
        crate::input::describe_publisher_input::Builder::default()
    }
    /// Creates a new `DescribePublisher` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePublisher {
    type Output = std::result::Result<
        crate::output::DescribePublisherOutput,
        crate::error::DescribePublisherError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_publisher_error(response)
        } else {
            crate::operation_deser::parse_describe_publisher_response(response)
        }
    }
}

/// Operation shape for `DescribeStackDriftDetectionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_drift_detection_status`](crate::client::Client::describe_stack_drift_detection_status).
///
/// See [`crate::client::fluent_builders::DescribeStackDriftDetectionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackDriftDetectionStatus {
    _private: (),
}
impl DescribeStackDriftDetectionStatus {
    /// Creates a new builder-style object to manufacture [`DescribeStackDriftDetectionStatusInput`](crate::input::DescribeStackDriftDetectionStatusInput)
    pub fn builder() -> crate::input::describe_stack_drift_detection_status_input::Builder {
        crate::input::describe_stack_drift_detection_status_input::Builder::default()
    }
    /// Creates a new `DescribeStackDriftDetectionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackDriftDetectionStatus {
    type Output = std::result::Result<
        crate::output::DescribeStackDriftDetectionStatusOutput,
        crate::error::DescribeStackDriftDetectionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_drift_detection_status_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_drift_detection_status_response(response)
        }
    }
}

/// Operation shape for `DescribeStackEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_events`](crate::client::Client::describe_stack_events).
///
/// See [`crate::client::fluent_builders::DescribeStackEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackEvents {
    _private: (),
}
impl DescribeStackEvents {
    /// Creates a new builder-style object to manufacture [`DescribeStackEventsInput`](crate::input::DescribeStackEventsInput)
    pub fn builder() -> crate::input::describe_stack_events_input::Builder {
        crate::input::describe_stack_events_input::Builder::default()
    }
    /// Creates a new `DescribeStackEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackEvents {
    type Output = std::result::Result<
        crate::output::DescribeStackEventsOutput,
        crate::error::DescribeStackEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_events_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_events_response(response)
        }
    }
}

/// Operation shape for `DescribeStackInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_instance`](crate::client::Client::describe_stack_instance).
///
/// See [`crate::client::fluent_builders::DescribeStackInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackInstance {
    _private: (),
}
impl DescribeStackInstance {
    /// Creates a new builder-style object to manufacture [`DescribeStackInstanceInput`](crate::input::DescribeStackInstanceInput)
    pub fn builder() -> crate::input::describe_stack_instance_input::Builder {
        crate::input::describe_stack_instance_input::Builder::default()
    }
    /// Creates a new `DescribeStackInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackInstance {
    type Output = std::result::Result<
        crate::output::DescribeStackInstanceOutput,
        crate::error::DescribeStackInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_instance_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_instance_response(response)
        }
    }
}

/// Operation shape for `DescribeStackResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_resource`](crate::client::Client::describe_stack_resource).
///
/// See [`crate::client::fluent_builders::DescribeStackResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackResource {
    _private: (),
}
impl DescribeStackResource {
    /// Creates a new builder-style object to manufacture [`DescribeStackResourceInput`](crate::input::DescribeStackResourceInput)
    pub fn builder() -> crate::input::describe_stack_resource_input::Builder {
        crate::input::describe_stack_resource_input::Builder::default()
    }
    /// Creates a new `DescribeStackResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackResource {
    type Output = std::result::Result<
        crate::output::DescribeStackResourceOutput,
        crate::error::DescribeStackResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_resource_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeStackResourceDrifts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_resource_drifts`](crate::client::Client::describe_stack_resource_drifts).
///
/// See [`crate::client::fluent_builders::DescribeStackResourceDrifts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackResourceDrifts {
    _private: (),
}
impl DescribeStackResourceDrifts {
    /// Creates a new builder-style object to manufacture [`DescribeStackResourceDriftsInput`](crate::input::DescribeStackResourceDriftsInput)
    pub fn builder() -> crate::input::describe_stack_resource_drifts_input::Builder {
        crate::input::describe_stack_resource_drifts_input::Builder::default()
    }
    /// Creates a new `DescribeStackResourceDrifts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackResourceDrifts {
    type Output = std::result::Result<
        crate::output::DescribeStackResourceDriftsOutput,
        crate::error::DescribeStackResourceDriftsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_resource_drifts_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_resource_drifts_response(response)
        }
    }
}

/// Operation shape for `DescribeStackResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_resources`](crate::client::Client::describe_stack_resources).
///
/// See [`crate::client::fluent_builders::DescribeStackResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackResources {
    _private: (),
}
impl DescribeStackResources {
    /// Creates a new builder-style object to manufacture [`DescribeStackResourcesInput`](crate::input::DescribeStackResourcesInput)
    pub fn builder() -> crate::input::describe_stack_resources_input::Builder {
        crate::input::describe_stack_resources_input::Builder::default()
    }
    /// Creates a new `DescribeStackResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackResources {
    type Output = std::result::Result<
        crate::output::DescribeStackResourcesOutput,
        crate::error::DescribeStackResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_resources_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_resources_response(response)
        }
    }
}

/// Operation shape for `DescribeStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stacks`](crate::client::Client::describe_stacks).
///
/// See [`crate::client::fluent_builders::DescribeStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStacks {
    _private: (),
}
impl DescribeStacks {
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
    /// Creates a new `DescribeStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStacks {
    type Output =
        std::result::Result<crate::output::DescribeStacksOutput, crate::error::DescribeStacksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stacks_error(response)
        } else {
            crate::operation_deser::parse_describe_stacks_response(response)
        }
    }
}

/// Operation shape for `DescribeStackSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_set`](crate::client::Client::describe_stack_set).
///
/// See [`crate::client::fluent_builders::DescribeStackSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackSet {
    _private: (),
}
impl DescribeStackSet {
    /// Creates a new builder-style object to manufacture [`DescribeStackSetInput`](crate::input::DescribeStackSetInput)
    pub fn builder() -> crate::input::describe_stack_set_input::Builder {
        crate::input::describe_stack_set_input::Builder::default()
    }
    /// Creates a new `DescribeStackSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackSet {
    type Output = std::result::Result<
        crate::output::DescribeStackSetOutput,
        crate::error::DescribeStackSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_set_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_set_response(response)
        }
    }
}

/// Operation shape for `DescribeStackSetOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_set_operation`](crate::client::Client::describe_stack_set_operation).
///
/// See [`crate::client::fluent_builders::DescribeStackSetOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackSetOperation {
    _private: (),
}
impl DescribeStackSetOperation {
    /// Creates a new builder-style object to manufacture [`DescribeStackSetOperationInput`](crate::input::DescribeStackSetOperationInput)
    pub fn builder() -> crate::input::describe_stack_set_operation_input::Builder {
        crate::input::describe_stack_set_operation_input::Builder::default()
    }
    /// Creates a new `DescribeStackSetOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackSetOperation {
    type Output = std::result::Result<
        crate::output::DescribeStackSetOperationOutput,
        crate::error::DescribeStackSetOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_set_operation_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_set_operation_response(response)
        }
    }
}

/// Operation shape for `DescribeType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_type`](crate::client::Client::describe_type).
///
/// See [`crate::client::fluent_builders::DescribeType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeType {
    _private: (),
}
impl DescribeType {
    /// Creates a new builder-style object to manufacture [`DescribeTypeInput`](crate::input::DescribeTypeInput)
    pub fn builder() -> crate::input::describe_type_input::Builder {
        crate::input::describe_type_input::Builder::default()
    }
    /// Creates a new `DescribeType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeType {
    type Output =
        std::result::Result<crate::output::DescribeTypeOutput, crate::error::DescribeTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_type_error(response)
        } else {
            crate::operation_deser::parse_describe_type_response(response)
        }
    }
}

/// Operation shape for `DescribeTypeRegistration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_type_registration`](crate::client::Client::describe_type_registration).
///
/// See [`crate::client::fluent_builders::DescribeTypeRegistration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTypeRegistration {
    _private: (),
}
impl DescribeTypeRegistration {
    /// Creates a new builder-style object to manufacture [`DescribeTypeRegistrationInput`](crate::input::DescribeTypeRegistrationInput)
    pub fn builder() -> crate::input::describe_type_registration_input::Builder {
        crate::input::describe_type_registration_input::Builder::default()
    }
    /// Creates a new `DescribeTypeRegistration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTypeRegistration {
    type Output = std::result::Result<
        crate::output::DescribeTypeRegistrationOutput,
        crate::error::DescribeTypeRegistrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_type_registration_error(response)
        } else {
            crate::operation_deser::parse_describe_type_registration_response(response)
        }
    }
}

/// Operation shape for `DetectStackDrift`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_stack_drift`](crate::client::Client::detect_stack_drift).
///
/// See [`crate::client::fluent_builders::DetectStackDrift`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectStackDrift {
    _private: (),
}
impl DetectStackDrift {
    /// Creates a new builder-style object to manufacture [`DetectStackDriftInput`](crate::input::DetectStackDriftInput)
    pub fn builder() -> crate::input::detect_stack_drift_input::Builder {
        crate::input::detect_stack_drift_input::Builder::default()
    }
    /// Creates a new `DetectStackDrift` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectStackDrift {
    type Output = std::result::Result<
        crate::output::DetectStackDriftOutput,
        crate::error::DetectStackDriftError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_stack_drift_error(response)
        } else {
            crate::operation_deser::parse_detect_stack_drift_response(response)
        }
    }
}

/// Operation shape for `DetectStackResourceDrift`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_stack_resource_drift`](crate::client::Client::detect_stack_resource_drift).
///
/// See [`crate::client::fluent_builders::DetectStackResourceDrift`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectStackResourceDrift {
    _private: (),
}
impl DetectStackResourceDrift {
    /// Creates a new builder-style object to manufacture [`DetectStackResourceDriftInput`](crate::input::DetectStackResourceDriftInput)
    pub fn builder() -> crate::input::detect_stack_resource_drift_input::Builder {
        crate::input::detect_stack_resource_drift_input::Builder::default()
    }
    /// Creates a new `DetectStackResourceDrift` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectStackResourceDrift {
    type Output = std::result::Result<
        crate::output::DetectStackResourceDriftOutput,
        crate::error::DetectStackResourceDriftError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_stack_resource_drift_error(response)
        } else {
            crate::operation_deser::parse_detect_stack_resource_drift_response(response)
        }
    }
}

/// Operation shape for `DetectStackSetDrift`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_stack_set_drift`](crate::client::Client::detect_stack_set_drift).
///
/// See [`crate::client::fluent_builders::DetectStackSetDrift`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectStackSetDrift {
    _private: (),
}
impl DetectStackSetDrift {
    /// Creates a new builder-style object to manufacture [`DetectStackSetDriftInput`](crate::input::DetectStackSetDriftInput)
    pub fn builder() -> crate::input::detect_stack_set_drift_input::Builder {
        crate::input::detect_stack_set_drift_input::Builder::default()
    }
    /// Creates a new `DetectStackSetDrift` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectStackSetDrift {
    type Output = std::result::Result<
        crate::output::DetectStackSetDriftOutput,
        crate::error::DetectStackSetDriftError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_stack_set_drift_error(response)
        } else {
            crate::operation_deser::parse_detect_stack_set_drift_response(response)
        }
    }
}

/// Operation shape for `EstimateTemplateCost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`estimate_template_cost`](crate::client::Client::estimate_template_cost).
///
/// See [`crate::client::fluent_builders::EstimateTemplateCost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EstimateTemplateCost {
    _private: (),
}
impl EstimateTemplateCost {
    /// Creates a new builder-style object to manufacture [`EstimateTemplateCostInput`](crate::input::EstimateTemplateCostInput)
    pub fn builder() -> crate::input::estimate_template_cost_input::Builder {
        crate::input::estimate_template_cost_input::Builder::default()
    }
    /// Creates a new `EstimateTemplateCost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EstimateTemplateCost {
    type Output = std::result::Result<
        crate::output::EstimateTemplateCostOutput,
        crate::error::EstimateTemplateCostError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_estimate_template_cost_error(response)
        } else {
            crate::operation_deser::parse_estimate_template_cost_response(response)
        }
    }
}

/// Operation shape for `ExecuteChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_change_set`](crate::client::Client::execute_change_set).
///
/// See [`crate::client::fluent_builders::ExecuteChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteChangeSet {
    _private: (),
}
impl ExecuteChangeSet {
    /// Creates a new builder-style object to manufacture [`ExecuteChangeSetInput`](crate::input::ExecuteChangeSetInput)
    pub fn builder() -> crate::input::execute_change_set_input::Builder {
        crate::input::execute_change_set_input::Builder::default()
    }
    /// Creates a new `ExecuteChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteChangeSet {
    type Output = std::result::Result<
        crate::output::ExecuteChangeSetOutput,
        crate::error::ExecuteChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_change_set_error(response)
        } else {
            crate::operation_deser::parse_execute_change_set_response(response)
        }
    }
}

/// Operation shape for `GetStackPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stack_policy`](crate::client::Client::get_stack_policy).
///
/// See [`crate::client::fluent_builders::GetStackPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStackPolicy {
    _private: (),
}
impl GetStackPolicy {
    /// Creates a new builder-style object to manufacture [`GetStackPolicyInput`](crate::input::GetStackPolicyInput)
    pub fn builder() -> crate::input::get_stack_policy_input::Builder {
        crate::input::get_stack_policy_input::Builder::default()
    }
    /// Creates a new `GetStackPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStackPolicy {
    type Output =
        std::result::Result<crate::output::GetStackPolicyOutput, crate::error::GetStackPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stack_policy_error(response)
        } else {
            crate::operation_deser::parse_get_stack_policy_response(response)
        }
    }
}

/// Operation shape for `GetTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_template`](crate::client::Client::get_template).
///
/// See [`crate::client::fluent_builders::GetTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemplate {
    _private: (),
}
impl GetTemplate {
    /// Creates a new builder-style object to manufacture [`GetTemplateInput`](crate::input::GetTemplateInput)
    pub fn builder() -> crate::input::get_template_input::Builder {
        crate::input::get_template_input::Builder::default()
    }
    /// Creates a new `GetTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemplate {
    type Output =
        std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_template_error(response)
        } else {
            crate::operation_deser::parse_get_template_response(response)
        }
    }
}

/// Operation shape for `GetTemplateSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_template_summary`](crate::client::Client::get_template_summary).
///
/// See [`crate::client::fluent_builders::GetTemplateSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemplateSummary {
    _private: (),
}
impl GetTemplateSummary {
    /// Creates a new builder-style object to manufacture [`GetTemplateSummaryInput`](crate::input::GetTemplateSummaryInput)
    pub fn builder() -> crate::input::get_template_summary_input::Builder {
        crate::input::get_template_summary_input::Builder::default()
    }
    /// Creates a new `GetTemplateSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemplateSummary {
    type Output = std::result::Result<
        crate::output::GetTemplateSummaryOutput,
        crate::error::GetTemplateSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_template_summary_error(response)
        } else {
            crate::operation_deser::parse_get_template_summary_response(response)
        }
    }
}

/// Operation shape for `ImportStacksToStackSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_stacks_to_stack_set`](crate::client::Client::import_stacks_to_stack_set).
///
/// See [`crate::client::fluent_builders::ImportStacksToStackSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportStacksToStackSet {
    _private: (),
}
impl ImportStacksToStackSet {
    /// Creates a new builder-style object to manufacture [`ImportStacksToStackSetInput`](crate::input::ImportStacksToStackSetInput)
    pub fn builder() -> crate::input::import_stacks_to_stack_set_input::Builder {
        crate::input::import_stacks_to_stack_set_input::Builder::default()
    }
    /// Creates a new `ImportStacksToStackSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportStacksToStackSet {
    type Output = std::result::Result<
        crate::output::ImportStacksToStackSetOutput,
        crate::error::ImportStacksToStackSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_stacks_to_stack_set_error(response)
        } else {
            crate::operation_deser::parse_import_stacks_to_stack_set_response(response)
        }
    }
}

/// Operation shape for `ListChangeSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_change_sets`](crate::client::Client::list_change_sets).
///
/// See [`crate::client::fluent_builders::ListChangeSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChangeSets {
    _private: (),
}
impl ListChangeSets {
    /// Creates a new builder-style object to manufacture [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    pub fn builder() -> crate::input::list_change_sets_input::Builder {
        crate::input::list_change_sets_input::Builder::default()
    }
    /// Creates a new `ListChangeSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChangeSets {
    type Output =
        std::result::Result<crate::output::ListChangeSetsOutput, crate::error::ListChangeSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_change_sets_error(response)
        } else {
            crate::operation_deser::parse_list_change_sets_response(response)
        }
    }
}

/// Operation shape for `ListExports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_exports`](crate::client::Client::list_exports).
///
/// See [`crate::client::fluent_builders::ListExports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExports {
    _private: (),
}
impl ListExports {
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
    /// Creates a new `ListExports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExports {
    type Output =
        std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_exports_error(response)
        } else {
            crate::operation_deser::parse_list_exports_response(response)
        }
    }
}

/// Operation shape for `ListImports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_imports`](crate::client::Client::list_imports).
///
/// See [`crate::client::fluent_builders::ListImports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImports {
    _private: (),
}
impl ListImports {
    /// Creates a new builder-style object to manufacture [`ListImportsInput`](crate::input::ListImportsInput)
    pub fn builder() -> crate::input::list_imports_input::Builder {
        crate::input::list_imports_input::Builder::default()
    }
    /// Creates a new `ListImports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImports {
    type Output =
        std::result::Result<crate::output::ListImportsOutput, crate::error::ListImportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_imports_error(response)
        } else {
            crate::operation_deser::parse_list_imports_response(response)
        }
    }
}

/// Operation shape for `ListStackInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_instances`](crate::client::Client::list_stack_instances).
///
/// See [`crate::client::fluent_builders::ListStackInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackInstances {
    _private: (),
}
impl ListStackInstances {
    /// Creates a new builder-style object to manufacture [`ListStackInstancesInput`](crate::input::ListStackInstancesInput)
    pub fn builder() -> crate::input::list_stack_instances_input::Builder {
        crate::input::list_stack_instances_input::Builder::default()
    }
    /// Creates a new `ListStackInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackInstances {
    type Output = std::result::Result<
        crate::output::ListStackInstancesOutput,
        crate::error::ListStackInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_instances_error(response)
        } else {
            crate::operation_deser::parse_list_stack_instances_response(response)
        }
    }
}

/// Operation shape for `ListStackResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_resources`](crate::client::Client::list_stack_resources).
///
/// See [`crate::client::fluent_builders::ListStackResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackResources {
    _private: (),
}
impl ListStackResources {
    /// Creates a new builder-style object to manufacture [`ListStackResourcesInput`](crate::input::ListStackResourcesInput)
    pub fn builder() -> crate::input::list_stack_resources_input::Builder {
        crate::input::list_stack_resources_input::Builder::default()
    }
    /// Creates a new `ListStackResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackResources {
    type Output = std::result::Result<
        crate::output::ListStackResourcesOutput,
        crate::error::ListStackResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_resources_error(response)
        } else {
            crate::operation_deser::parse_list_stack_resources_response(response)
        }
    }
}

/// Operation shape for `ListStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stacks`](crate::client::Client::list_stacks).
///
/// See [`crate::client::fluent_builders::ListStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStacks {
    _private: (),
}
impl ListStacks {
    /// Creates a new builder-style object to manufacture [`ListStacksInput`](crate::input::ListStacksInput)
    pub fn builder() -> crate::input::list_stacks_input::Builder {
        crate::input::list_stacks_input::Builder::default()
    }
    /// Creates a new `ListStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStacks {
    type Output =
        std::result::Result<crate::output::ListStacksOutput, crate::error::ListStacksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stacks_error(response)
        } else {
            crate::operation_deser::parse_list_stacks_response(response)
        }
    }
}

/// Operation shape for `ListStackSetOperationResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_set_operation_results`](crate::client::Client::list_stack_set_operation_results).
///
/// See [`crate::client::fluent_builders::ListStackSetOperationResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackSetOperationResults {
    _private: (),
}
impl ListStackSetOperationResults {
    /// Creates a new builder-style object to manufacture [`ListStackSetOperationResultsInput`](crate::input::ListStackSetOperationResultsInput)
    pub fn builder() -> crate::input::list_stack_set_operation_results_input::Builder {
        crate::input::list_stack_set_operation_results_input::Builder::default()
    }
    /// Creates a new `ListStackSetOperationResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackSetOperationResults {
    type Output = std::result::Result<
        crate::output::ListStackSetOperationResultsOutput,
        crate::error::ListStackSetOperationResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_set_operation_results_error(response)
        } else {
            crate::operation_deser::parse_list_stack_set_operation_results_response(response)
        }
    }
}

/// Operation shape for `ListStackSetOperations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_set_operations`](crate::client::Client::list_stack_set_operations).
///
/// See [`crate::client::fluent_builders::ListStackSetOperations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackSetOperations {
    _private: (),
}
impl ListStackSetOperations {
    /// Creates a new builder-style object to manufacture [`ListStackSetOperationsInput`](crate::input::ListStackSetOperationsInput)
    pub fn builder() -> crate::input::list_stack_set_operations_input::Builder {
        crate::input::list_stack_set_operations_input::Builder::default()
    }
    /// Creates a new `ListStackSetOperations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackSetOperations {
    type Output = std::result::Result<
        crate::output::ListStackSetOperationsOutput,
        crate::error::ListStackSetOperationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_set_operations_error(response)
        } else {
            crate::operation_deser::parse_list_stack_set_operations_response(response)
        }
    }
}

/// Operation shape for `ListStackSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_sets`](crate::client::Client::list_stack_sets).
///
/// See [`crate::client::fluent_builders::ListStackSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackSets {
    _private: (),
}
impl ListStackSets {
    /// Creates a new builder-style object to manufacture [`ListStackSetsInput`](crate::input::ListStackSetsInput)
    pub fn builder() -> crate::input::list_stack_sets_input::Builder {
        crate::input::list_stack_sets_input::Builder::default()
    }
    /// Creates a new `ListStackSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackSets {
    type Output =
        std::result::Result<crate::output::ListStackSetsOutput, crate::error::ListStackSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_sets_error(response)
        } else {
            crate::operation_deser::parse_list_stack_sets_response(response)
        }
    }
}

/// Operation shape for `ListTypeRegistrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_type_registrations`](crate::client::Client::list_type_registrations).
///
/// See [`crate::client::fluent_builders::ListTypeRegistrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypeRegistrations {
    _private: (),
}
impl ListTypeRegistrations {
    /// Creates a new builder-style object to manufacture [`ListTypeRegistrationsInput`](crate::input::ListTypeRegistrationsInput)
    pub fn builder() -> crate::input::list_type_registrations_input::Builder {
        crate::input::list_type_registrations_input::Builder::default()
    }
    /// Creates a new `ListTypeRegistrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypeRegistrations {
    type Output = std::result::Result<
        crate::output::ListTypeRegistrationsOutput,
        crate::error::ListTypeRegistrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_type_registrations_error(response)
        } else {
            crate::operation_deser::parse_list_type_registrations_response(response)
        }
    }
}

/// Operation shape for `ListTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_types`](crate::client::Client::list_types).
///
/// See [`crate::client::fluent_builders::ListTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypes {
    _private: (),
}
impl ListTypes {
    /// Creates a new builder-style object to manufacture [`ListTypesInput`](crate::input::ListTypesInput)
    pub fn builder() -> crate::input::list_types_input::Builder {
        crate::input::list_types_input::Builder::default()
    }
    /// Creates a new `ListTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypes {
    type Output = std::result::Result<crate::output::ListTypesOutput, crate::error::ListTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_types_error(response)
        } else {
            crate::operation_deser::parse_list_types_response(response)
        }
    }
}

/// Operation shape for `ListTypeVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_type_versions`](crate::client::Client::list_type_versions).
///
/// See [`crate::client::fluent_builders::ListTypeVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypeVersions {
    _private: (),
}
impl ListTypeVersions {
    /// Creates a new builder-style object to manufacture [`ListTypeVersionsInput`](crate::input::ListTypeVersionsInput)
    pub fn builder() -> crate::input::list_type_versions_input::Builder {
        crate::input::list_type_versions_input::Builder::default()
    }
    /// Creates a new `ListTypeVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypeVersions {
    type Output = std::result::Result<
        crate::output::ListTypeVersionsOutput,
        crate::error::ListTypeVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_type_versions_error(response)
        } else {
            crate::operation_deser::parse_list_type_versions_response(response)
        }
    }
}

/// Operation shape for `PublishType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_type`](crate::client::Client::publish_type).
///
/// See [`crate::client::fluent_builders::PublishType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishType {
    _private: (),
}
impl PublishType {
    /// Creates a new builder-style object to manufacture [`PublishTypeInput`](crate::input::PublishTypeInput)
    pub fn builder() -> crate::input::publish_type_input::Builder {
        crate::input::publish_type_input::Builder::default()
    }
    /// Creates a new `PublishType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishType {
    type Output =
        std::result::Result<crate::output::PublishTypeOutput, crate::error::PublishTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_type_error(response)
        } else {
            crate::operation_deser::parse_publish_type_response(response)
        }
    }
}

/// Operation shape for `RecordHandlerProgress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`record_handler_progress`](crate::client::Client::record_handler_progress).
///
/// See [`crate::client::fluent_builders::RecordHandlerProgress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RecordHandlerProgress {
    _private: (),
}
impl RecordHandlerProgress {
    /// Creates a new builder-style object to manufacture [`RecordHandlerProgressInput`](crate::input::RecordHandlerProgressInput)
    pub fn builder() -> crate::input::record_handler_progress_input::Builder {
        crate::input::record_handler_progress_input::Builder::default()
    }
    /// Creates a new `RecordHandlerProgress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RecordHandlerProgress {
    type Output = std::result::Result<
        crate::output::RecordHandlerProgressOutput,
        crate::error::RecordHandlerProgressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_record_handler_progress_error(response)
        } else {
            crate::operation_deser::parse_record_handler_progress_response(response)
        }
    }
}

/// Operation shape for `RegisterPublisher`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_publisher`](crate::client::Client::register_publisher).
///
/// See [`crate::client::fluent_builders::RegisterPublisher`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterPublisher {
    _private: (),
}
impl RegisterPublisher {
    /// Creates a new builder-style object to manufacture [`RegisterPublisherInput`](crate::input::RegisterPublisherInput)
    pub fn builder() -> crate::input::register_publisher_input::Builder {
        crate::input::register_publisher_input::Builder::default()
    }
    /// Creates a new `RegisterPublisher` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterPublisher {
    type Output = std::result::Result<
        crate::output::RegisterPublisherOutput,
        crate::error::RegisterPublisherError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_publisher_error(response)
        } else {
            crate::operation_deser::parse_register_publisher_response(response)
        }
    }
}

/// Operation shape for `RegisterType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_type`](crate::client::Client::register_type).
///
/// See [`crate::client::fluent_builders::RegisterType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterType {
    _private: (),
}
impl RegisterType {
    /// Creates a new builder-style object to manufacture [`RegisterTypeInput`](crate::input::RegisterTypeInput)
    pub fn builder() -> crate::input::register_type_input::Builder {
        crate::input::register_type_input::Builder::default()
    }
    /// Creates a new `RegisterType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterType {
    type Output =
        std::result::Result<crate::output::RegisterTypeOutput, crate::error::RegisterTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_type_error(response)
        } else {
            crate::operation_deser::parse_register_type_response(response)
        }
    }
}

/// Operation shape for `RollbackStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`rollback_stack`](crate::client::Client::rollback_stack).
///
/// See [`crate::client::fluent_builders::RollbackStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RollbackStack {
    _private: (),
}
impl RollbackStack {
    /// Creates a new builder-style object to manufacture [`RollbackStackInput`](crate::input::RollbackStackInput)
    pub fn builder() -> crate::input::rollback_stack_input::Builder {
        crate::input::rollback_stack_input::Builder::default()
    }
    /// Creates a new `RollbackStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RollbackStack {
    type Output =
        std::result::Result<crate::output::RollbackStackOutput, crate::error::RollbackStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_rollback_stack_error(response)
        } else {
            crate::operation_deser::parse_rollback_stack_response(response)
        }
    }
}

/// Operation shape for `SetStackPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_stack_policy`](crate::client::Client::set_stack_policy).
///
/// See [`crate::client::fluent_builders::SetStackPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetStackPolicy {
    _private: (),
}
impl SetStackPolicy {
    /// Creates a new builder-style object to manufacture [`SetStackPolicyInput`](crate::input::SetStackPolicyInput)
    pub fn builder() -> crate::input::set_stack_policy_input::Builder {
        crate::input::set_stack_policy_input::Builder::default()
    }
    /// Creates a new `SetStackPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetStackPolicy {
    type Output =
        std::result::Result<crate::output::SetStackPolicyOutput, crate::error::SetStackPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_stack_policy_error(response)
        } else {
            crate::operation_deser::parse_set_stack_policy_response(response)
        }
    }
}

/// Operation shape for `SetTypeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_type_configuration`](crate::client::Client::set_type_configuration).
///
/// See [`crate::client::fluent_builders::SetTypeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTypeConfiguration {
    _private: (),
}
impl SetTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`SetTypeConfigurationInput`](crate::input::SetTypeConfigurationInput)
    pub fn builder() -> crate::input::set_type_configuration_input::Builder {
        crate::input::set_type_configuration_input::Builder::default()
    }
    /// Creates a new `SetTypeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTypeConfiguration {
    type Output = std::result::Result<
        crate::output::SetTypeConfigurationOutput,
        crate::error::SetTypeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_type_configuration_error(response)
        } else {
            crate::operation_deser::parse_set_type_configuration_response(response)
        }
    }
}

/// Operation shape for `SetTypeDefaultVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_type_default_version`](crate::client::Client::set_type_default_version).
///
/// See [`crate::client::fluent_builders::SetTypeDefaultVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTypeDefaultVersion {
    _private: (),
}
impl SetTypeDefaultVersion {
    /// Creates a new builder-style object to manufacture [`SetTypeDefaultVersionInput`](crate::input::SetTypeDefaultVersionInput)
    pub fn builder() -> crate::input::set_type_default_version_input::Builder {
        crate::input::set_type_default_version_input::Builder::default()
    }
    /// Creates a new `SetTypeDefaultVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTypeDefaultVersion {
    type Output = std::result::Result<
        crate::output::SetTypeDefaultVersionOutput,
        crate::error::SetTypeDefaultVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_type_default_version_error(response)
        } else {
            crate::operation_deser::parse_set_type_default_version_response(response)
        }
    }
}

/// Operation shape for `SignalResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`signal_resource`](crate::client::Client::signal_resource).
///
/// See [`crate::client::fluent_builders::SignalResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SignalResource {
    _private: (),
}
impl SignalResource {
    /// Creates a new builder-style object to manufacture [`SignalResourceInput`](crate::input::SignalResourceInput)
    pub fn builder() -> crate::input::signal_resource_input::Builder {
        crate::input::signal_resource_input::Builder::default()
    }
    /// Creates a new `SignalResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SignalResource {
    type Output =
        std::result::Result<crate::output::SignalResourceOutput, crate::error::SignalResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_signal_resource_error(response)
        } else {
            crate::operation_deser::parse_signal_resource_response(response)
        }
    }
}

/// Operation shape for `StopStackSetOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_stack_set_operation`](crate::client::Client::stop_stack_set_operation).
///
/// See [`crate::client::fluent_builders::StopStackSetOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopStackSetOperation {
    _private: (),
}
impl StopStackSetOperation {
    /// Creates a new builder-style object to manufacture [`StopStackSetOperationInput`](crate::input::StopStackSetOperationInput)
    pub fn builder() -> crate::input::stop_stack_set_operation_input::Builder {
        crate::input::stop_stack_set_operation_input::Builder::default()
    }
    /// Creates a new `StopStackSetOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopStackSetOperation {
    type Output = std::result::Result<
        crate::output::StopStackSetOperationOutput,
        crate::error::StopStackSetOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_stack_set_operation_error(response)
        } else {
            crate::operation_deser::parse_stop_stack_set_operation_response(response)
        }
    }
}

/// Operation shape for `TestType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_type`](crate::client::Client::test_type).
///
/// See [`crate::client::fluent_builders::TestType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestType {
    _private: (),
}
impl TestType {
    /// Creates a new builder-style object to manufacture [`TestTypeInput`](crate::input::TestTypeInput)
    pub fn builder() -> crate::input::test_type_input::Builder {
        crate::input::test_type_input::Builder::default()
    }
    /// Creates a new `TestType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestType {
    type Output = std::result::Result<crate::output::TestTypeOutput, crate::error::TestTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_type_error(response)
        } else {
            crate::operation_deser::parse_test_type_response(response)
        }
    }
}

/// Operation shape for `UpdateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stack`](crate::client::Client::update_stack).
///
/// See [`crate::client::fluent_builders::UpdateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStack {
    _private: (),
}
impl UpdateStack {
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
    /// Creates a new `UpdateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStack {
    type Output =
        std::result::Result<crate::output::UpdateStackOutput, crate::error::UpdateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stack_error(response)
        } else {
            crate::operation_deser::parse_update_stack_response(response)
        }
    }
}

/// Operation shape for `UpdateStackInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stack_instances`](crate::client::Client::update_stack_instances).
///
/// See [`crate::client::fluent_builders::UpdateStackInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStackInstances {
    _private: (),
}
impl UpdateStackInstances {
    /// Creates a new builder-style object to manufacture [`UpdateStackInstancesInput`](crate::input::UpdateStackInstancesInput)
    pub fn builder() -> crate::input::update_stack_instances_input::Builder {
        crate::input::update_stack_instances_input::Builder::default()
    }
    /// Creates a new `UpdateStackInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStackInstances {
    type Output = std::result::Result<
        crate::output::UpdateStackInstancesOutput,
        crate::error::UpdateStackInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stack_instances_error(response)
        } else {
            crate::operation_deser::parse_update_stack_instances_response(response)
        }
    }
}

/// Operation shape for `UpdateStackSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stack_set`](crate::client::Client::update_stack_set).
///
/// See [`crate::client::fluent_builders::UpdateStackSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStackSet {
    _private: (),
}
impl UpdateStackSet {
    /// Creates a new builder-style object to manufacture [`UpdateStackSetInput`](crate::input::UpdateStackSetInput)
    pub fn builder() -> crate::input::update_stack_set_input::Builder {
        crate::input::update_stack_set_input::Builder::default()
    }
    /// Creates a new `UpdateStackSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStackSet {
    type Output =
        std::result::Result<crate::output::UpdateStackSetOutput, crate::error::UpdateStackSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stack_set_error(response)
        } else {
            crate::operation_deser::parse_update_stack_set_response(response)
        }
    }
}

/// Operation shape for `UpdateTerminationProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_termination_protection`](crate::client::Client::update_termination_protection).
///
/// See [`crate::client::fluent_builders::UpdateTerminationProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTerminationProtection {
    _private: (),
}
impl UpdateTerminationProtection {
    /// Creates a new builder-style object to manufacture [`UpdateTerminationProtectionInput`](crate::input::UpdateTerminationProtectionInput)
    pub fn builder() -> crate::input::update_termination_protection_input::Builder {
        crate::input::update_termination_protection_input::Builder::default()
    }
    /// Creates a new `UpdateTerminationProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTerminationProtection {
    type Output = std::result::Result<
        crate::output::UpdateTerminationProtectionOutput,
        crate::error::UpdateTerminationProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_termination_protection_error(response)
        } else {
            crate::operation_deser::parse_update_termination_protection_response(response)
        }
    }
}

/// Operation shape for `ValidateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_template`](crate::client::Client::validate_template).
///
/// See [`crate::client::fluent_builders::ValidateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateTemplate {
    _private: (),
}
impl ValidateTemplate {
    /// Creates a new builder-style object to manufacture [`ValidateTemplateInput`](crate::input::ValidateTemplateInput)
    pub fn builder() -> crate::input::validate_template_input::Builder {
        crate::input::validate_template_input::Builder::default()
    }
    /// Creates a new `ValidateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateTemplate {
    type Output = std::result::Result<
        crate::output::ValidateTemplateOutput,
        crate::error::ValidateTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_template_error(response)
        } else {
            crate::operation_deser::parse_validate_template_response(response)
        }
    }
}
