// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudDirectory
///
/// Client for invoking operations on Amazon CloudDirectory. Each operation on Amazon CloudDirectory is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_clouddirectory::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_clouddirectory::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_clouddirectory::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddFacetToObject`](crate::client::fluent_builders::AddFacetToObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::AddFacetToObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::AddFacetToObject::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`schema_facet(SchemaFacet)`](crate::client::fluent_builders::AddFacetToObject::schema_facet) / [`set_schema_facet(Option<SchemaFacet>)`](crate::client::fluent_builders::AddFacetToObject::set_schema_facet): <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
    ///   - [`object_attribute_list(Vec<AttributeKeyAndValue>)`](crate::client::fluent_builders::AddFacetToObject::object_attribute_list) / [`set_object_attribute_list(Option<Vec<AttributeKeyAndValue>>)`](crate::client::fluent_builders::AddFacetToObject::set_object_attribute_list): <p>Attributes on the facet that you are adding to the object.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::AddFacetToObject::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AddFacetToObject::set_object_reference): <p>A reference to the object you are adding the specified facet to.</p>
    /// - On success, responds with [`AddFacetToObjectOutput`](crate::output::AddFacetToObjectOutput)

    /// - On failure, responds with [`SdkError<AddFacetToObjectError>`](crate::error::AddFacetToObjectError)
    pub fn add_facet_to_object(&self) -> fluent_builders::AddFacetToObject {
        fluent_builders::AddFacetToObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplySchema`](crate::client::fluent_builders::ApplySchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`published_schema_arn(impl Into<String>)`](crate::client::fluent_builders::ApplySchema::published_schema_arn) / [`set_published_schema_arn(Option<String>)`](crate::client::fluent_builders::ApplySchema::set_published_schema_arn): <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ApplySchema::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ApplySchema::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
    /// - On success, responds with [`ApplySchemaOutput`](crate::output::ApplySchemaOutput) with field(s):
    ///   - [`applied_schema_arn(Option<String>)`](crate::output::ApplySchemaOutput::applied_schema_arn): <p>The applied schema ARN that is associated with the copied schema in the <code>Directory</code>. You can use this ARN to describe the schema information applied on this directory. For more information, see <code>arns</code>.</p>
    ///   - [`directory_arn(Option<String>)`](crate::output::ApplySchemaOutput::directory_arn): <p>The ARN that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<ApplySchemaError>`](crate::error::ApplySchemaError)
    pub fn apply_schema(&self) -> fluent_builders::ApplySchema {
        fluent_builders::ApplySchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachObject`](crate::client::fluent_builders::AttachObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::AttachObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::AttachObject::set_directory_arn): <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`parent_reference(ObjectReference)`](crate::client::fluent_builders::AttachObject::parent_reference) / [`set_parent_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachObject::set_parent_reference): <p>The parent object reference.</p>
    ///   - [`child_reference(ObjectReference)`](crate::client::fluent_builders::AttachObject::child_reference) / [`set_child_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachObject::set_child_reference): <p>The child object reference to be attached to the object.</p>
    ///   - [`link_name(impl Into<String>)`](crate::client::fluent_builders::AttachObject::link_name) / [`set_link_name(Option<String>)`](crate::client::fluent_builders::AttachObject::set_link_name): <p>The link name with which the child object is attached to the parent.</p>
    /// - On success, responds with [`AttachObjectOutput`](crate::output::AttachObjectOutput) with field(s):
    ///   - [`attached_object_identifier(Option<String>)`](crate::output::AttachObjectOutput::attached_object_identifier): <p>The attached <code>ObjectIdentifier</code>, which is the child <code>ObjectIdentifier</code>.</p>
    /// - On failure, responds with [`SdkError<AttachObjectError>`](crate::error::AttachObjectError)
    pub fn attach_object(&self) -> fluent_builders::AttachObject {
        fluent_builders::AttachObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::AttachPolicy::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::AttachPolicy::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`policy_reference(ObjectReference)`](crate::client::fluent_builders::AttachPolicy::policy_reference) / [`set_policy_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachPolicy::set_policy_reference): <p>The reference that is associated with the policy object.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::AttachPolicy::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachPolicy::set_object_reference): <p>The reference that identifies the object to which the policy will be attached.</p>
    /// - On success, responds with [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)

    /// - On failure, responds with [`SdkError<AttachPolicyError>`](crate::error::AttachPolicyError)
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachToIndex`](crate::client::fluent_builders::AttachToIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::AttachToIndex::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::AttachToIndex::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
    ///   - [`index_reference(ObjectReference)`](crate::client::fluent_builders::AttachToIndex::index_reference) / [`set_index_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachToIndex::set_index_reference): <p>A reference to the index that you are attaching the object to.</p>
    ///   - [`target_reference(ObjectReference)`](crate::client::fluent_builders::AttachToIndex::target_reference) / [`set_target_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachToIndex::set_target_reference): <p>A reference to the object that you are attaching to the index.</p>
    /// - On success, responds with [`AttachToIndexOutput`](crate::output::AttachToIndexOutput) with field(s):
    ///   - [`attached_object_identifier(Option<String>)`](crate::output::AttachToIndexOutput::attached_object_identifier): <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
    /// - On failure, responds with [`SdkError<AttachToIndexError>`](crate::error::AttachToIndexError)
    pub fn attach_to_index(&self) -> fluent_builders::AttachToIndex {
        fluent_builders::AttachToIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachTypedLink`](crate::client::fluent_builders::AttachTypedLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::AttachTypedLink::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::AttachTypedLink::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
    ///   - [`source_object_reference(ObjectReference)`](crate::client::fluent_builders::AttachTypedLink::source_object_reference) / [`set_source_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachTypedLink::set_source_object_reference): <p>Identifies the source object that the typed link will attach to.</p>
    ///   - [`target_object_reference(ObjectReference)`](crate::client::fluent_builders::AttachTypedLink::target_object_reference) / [`set_target_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::AttachTypedLink::set_target_object_reference): <p>Identifies the target object that the typed link will attach to.</p>
    ///   - [`typed_link_facet(TypedLinkSchemaAndFacetName)`](crate::client::fluent_builders::AttachTypedLink::typed_link_facet) / [`set_typed_link_facet(Option<TypedLinkSchemaAndFacetName>)`](crate::client::fluent_builders::AttachTypedLink::set_typed_link_facet): <p>Identifies the typed link facet that is associated with the typed link.</p>
    ///   - [`attributes(Vec<AttributeNameAndValue>)`](crate::client::fluent_builders::AttachTypedLink::attributes) / [`set_attributes(Option<Vec<AttributeNameAndValue>>)`](crate::client::fluent_builders::AttachTypedLink::set_attributes): <p>A set of attributes that are associated with the typed link.</p>
    /// - On success, responds with [`AttachTypedLinkOutput`](crate::output::AttachTypedLinkOutput) with field(s):
    ///   - [`typed_link_specifier(Option<TypedLinkSpecifier>)`](crate::output::AttachTypedLinkOutput::typed_link_specifier): <p>Returns a typed link specifier as output.</p>
    /// - On failure, responds with [`SdkError<AttachTypedLinkError>`](crate::error::AttachTypedLinkError)
    pub fn attach_typed_link(&self) -> fluent_builders::AttachTypedLink {
        fluent_builders::AttachTypedLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchRead`](crate::client::fluent_builders::BatchRead) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::BatchRead::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::BatchRead::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    ///   - [`operations(Vec<BatchReadOperation>)`](crate::client::fluent_builders::BatchRead::operations) / [`set_operations(Option<Vec<BatchReadOperation>>)`](crate::client::fluent_builders::BatchRead::set_operations): <p>A list of operations that are part of the batch.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::BatchRead::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::BatchRead::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    /// - On success, responds with [`BatchReadOutput`](crate::output::BatchReadOutput) with field(s):
    ///   - [`responses(Option<Vec<BatchReadOperationResponse>>)`](crate::output::BatchReadOutput::responses): <p>A list of all the responses for each batch read.</p>
    /// - On failure, responds with [`SdkError<BatchReadError>`](crate::error::BatchReadError)
    pub fn batch_read(&self) -> fluent_builders::BatchRead {
        fluent_builders::BatchRead::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchWrite`](crate::client::fluent_builders::BatchWrite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::BatchWrite::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::BatchWrite::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    ///   - [`operations(Vec<BatchWriteOperation>)`](crate::client::fluent_builders::BatchWrite::operations) / [`set_operations(Option<Vec<BatchWriteOperation>>)`](crate::client::fluent_builders::BatchWrite::set_operations): <p>A list of operations that are part of the batch.</p>
    /// - On success, responds with [`BatchWriteOutput`](crate::output::BatchWriteOutput) with field(s):
    ///   - [`responses(Option<Vec<BatchWriteOperationResponse>>)`](crate::output::BatchWriteOutput::responses): <p>A list of all the responses for each batch write.</p>
    /// - On failure, responds with [`SdkError<BatchWriteError>`](crate::error::BatchWriteError)
    pub fn batch_write(&self) -> fluent_builders::BatchWrite {
        fluent_builders::BatchWrite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectory`](crate::client::fluent_builders::CreateDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_name): <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_schema_arn): <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
    /// - On success, responds with [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput) with field(s):
    ///   - [`directory_arn(Option<String>)`](crate::output::CreateDirectoryOutput::directory_arn): <p>The ARN that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateDirectoryOutput::name): <p>The name of the <code>Directory</code>.</p>
    ///   - [`object_identifier(Option<String>)`](crate::output::CreateDirectoryOutput::object_identifier): <p>The root object node of the created directory.</p>
    ///   - [`applied_schema_arn(Option<String>)`](crate::output::CreateDirectoryOutput::applied_schema_arn): <p>The ARN of the published schema in the <code>Directory</code>. Once a published schema is copied into the directory, it has its own ARN, which is referred to applied schema ARN. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<CreateDirectoryError>`](crate::error::CreateDirectoryError)
    pub fn create_directory(&self) -> fluent_builders::CreateDirectory {
        fluent_builders::CreateDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFacet`](crate::client::fluent_builders::CreateFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::CreateFacet::set_schema_arn): <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFacet::set_name): <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
    ///   - [`attributes(Vec<FacetAttribute>)`](crate::client::fluent_builders::CreateFacet::attributes) / [`set_attributes(Option<Vec<FacetAttribute>>)`](crate::client::fluent_builders::CreateFacet::set_attributes): <p>The attributes that are associated with the <code>Facet</code>.</p>
    ///   - [`object_type(ObjectType)`](crate::client::fluent_builders::CreateFacet::object_type) / [`set_object_type(Option<ObjectType>)`](crate::client::fluent_builders::CreateFacet::set_object_type): <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>  <ul>   <li> <p>Node: Can have multiple children but one parent.</p> </li>  </ul>  <ul>   <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>  </ul>  <ul>   <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>  </ul>  <ul>   <li> <p>Index: Can be created with the Index API.</p> </li>  </ul>
    ///   - [`facet_style(FacetStyle)`](crate::client::fluent_builders::CreateFacet::facet_style) / [`set_facet_style(Option<FacetStyle>)`](crate::client::fluent_builders::CreateFacet::set_facet_style): <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
    /// - On success, responds with [`CreateFacetOutput`](crate::output::CreateFacetOutput)

    /// - On failure, responds with [`SdkError<CreateFacetError>`](crate::error::CreateFacetError)
    pub fn create_facet(&self) -> fluent_builders::CreateFacet {
        fluent_builders::CreateFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIndex`](crate::client::fluent_builders::CreateIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIndex::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::CreateIndex::set_directory_arn): <p>The ARN of the directory where the index should be created.</p>
    ///   - [`ordered_indexed_attribute_list(Vec<AttributeKey>)`](crate::client::fluent_builders::CreateIndex::ordered_indexed_attribute_list) / [`set_ordered_indexed_attribute_list(Option<Vec<AttributeKey>>)`](crate::client::fluent_builders::CreateIndex::set_ordered_indexed_attribute_list): <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
    ///   - [`is_unique(bool)`](crate::client::fluent_builders::CreateIndex::is_unique) / [`set_is_unique(bool)`](crate::client::fluent_builders::CreateIndex::set_is_unique): <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
    ///   - [`parent_reference(ObjectReference)`](crate::client::fluent_builders::CreateIndex::parent_reference) / [`set_parent_reference(Option<ObjectReference>)`](crate::client::fluent_builders::CreateIndex::set_parent_reference): <p>A reference to the parent object that contains the index object.</p>
    ///   - [`link_name(impl Into<String>)`](crate::client::fluent_builders::CreateIndex::link_name) / [`set_link_name(Option<String>)`](crate::client::fluent_builders::CreateIndex::set_link_name): <p>The name of the link between the parent object and the index object.</p>
    /// - On success, responds with [`CreateIndexOutput`](crate::output::CreateIndexOutput) with field(s):
    ///   - [`object_identifier(Option<String>)`](crate::output::CreateIndexOutput::object_identifier): <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
    /// - On failure, responds with [`SdkError<CreateIndexError>`](crate::error::CreateIndexError)
    pub fn create_index(&self) -> fluent_builders::CreateIndex {
        fluent_builders::CreateIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateObject`](crate::client::fluent_builders::CreateObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::CreateObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::CreateObject::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
    ///   - [`schema_facets(Vec<SchemaFacet>)`](crate::client::fluent_builders::CreateObject::schema_facets) / [`set_schema_facets(Option<Vec<SchemaFacet>>)`](crate::client::fluent_builders::CreateObject::set_schema_facets): <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
    ///   - [`object_attribute_list(Vec<AttributeKeyAndValue>)`](crate::client::fluent_builders::CreateObject::object_attribute_list) / [`set_object_attribute_list(Option<Vec<AttributeKeyAndValue>>)`](crate::client::fluent_builders::CreateObject::set_object_attribute_list): <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
    ///   - [`parent_reference(ObjectReference)`](crate::client::fluent_builders::CreateObject::parent_reference) / [`set_parent_reference(Option<ObjectReference>)`](crate::client::fluent_builders::CreateObject::set_parent_reference): <p>If specified, the parent reference to which this object will be attached.</p>
    ///   - [`link_name(impl Into<String>)`](crate::client::fluent_builders::CreateObject::link_name) / [`set_link_name(Option<String>)`](crate::client::fluent_builders::CreateObject::set_link_name): <p>The name of link that is used to attach this object to a parent.</p>
    /// - On success, responds with [`CreateObjectOutput`](crate::output::CreateObjectOutput) with field(s):
    ///   - [`object_identifier(Option<String>)`](crate::output::CreateObjectOutput::object_identifier): <p>The identifier that is associated with the object.</p>
    /// - On failure, responds with [`SdkError<CreateObjectError>`](crate::error::CreateObjectError)
    pub fn create_object(&self) -> fluent_builders::CreateObject {
        fluent_builders::CreateObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSchema`](crate::client::fluent_builders::CreateSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSchema::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSchema::set_name): <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
    /// - On success, responds with [`CreateSchemaOutput`](crate::output::CreateSchemaOutput) with field(s):
    ///   - [`schema_arn(Option<String>)`](crate::output::CreateSchemaOutput::schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<CreateSchemaError>`](crate::error::CreateSchemaError)
    pub fn create_schema(&self) -> fluent_builders::CreateSchema {
        fluent_builders::CreateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTypedLinkFacet`](crate::client::fluent_builders::CreateTypedLinkFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTypedLinkFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::CreateTypedLinkFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`facet(TypedLinkFacet)`](crate::client::fluent_builders::CreateTypedLinkFacet::facet) / [`set_facet(Option<TypedLinkFacet>)`](crate::client::fluent_builders::CreateTypedLinkFacet::set_facet): <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
    /// - On success, responds with [`CreateTypedLinkFacetOutput`](crate::output::CreateTypedLinkFacetOutput)

    /// - On failure, responds with [`SdkError<CreateTypedLinkFacetError>`](crate::error::CreateTypedLinkFacetError)
    pub fn create_typed_link_facet(&self) -> fluent_builders::CreateTypedLinkFacet {
        fluent_builders::CreateTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectory`](crate::client::fluent_builders::DeleteDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectory::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DeleteDirectory::set_directory_arn): <p>The ARN of the directory to delete.</p>
    /// - On success, responds with [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput) with field(s):
    ///   - [`directory_arn(Option<String>)`](crate::output::DeleteDirectoryOutput::directory_arn): <p>The ARN of the deleted directory.</p>
    /// - On failure, responds with [`SdkError<DeleteDirectoryError>`](crate::error::DeleteDirectoryError)
    pub fn delete_directory(&self) -> fluent_builders::DeleteDirectory {
        fluent_builders::DeleteDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFacet`](crate::client::fluent_builders::DeleteFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::DeleteFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteFacet::set_name): <p>The name of the facet to delete.</p>
    /// - On success, responds with [`DeleteFacetOutput`](crate::output::DeleteFacetOutput)

    /// - On failure, responds with [`SdkError<DeleteFacetError>`](crate::error::DeleteFacetError)
    pub fn delete_facet(&self) -> fluent_builders::DeleteFacet {
        fluent_builders::DeleteFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteObject`](crate::client::fluent_builders::DeleteObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::DeleteObject::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DeleteObject::set_object_reference): <p>A reference that identifies the object.</p>
    /// - On success, responds with [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)

    /// - On failure, responds with [`SdkError<DeleteObjectError>`](crate::error::DeleteObjectError)
    pub fn delete_object(&self) -> fluent_builders::DeleteObject {
        fluent_builders::DeleteObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSchema`](crate::client::fluent_builders::DeleteSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteSchema::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::DeleteSchema::set_schema_arn): <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    /// - On success, responds with [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput) with field(s):
    ///   - [`schema_arn(Option<String>)`](crate::output::DeleteSchemaOutput::schema_arn): <p>The input ARN that is returned as part of the response. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteSchemaError>`](crate::error::DeleteSchemaError)
    pub fn delete_schema(&self) -> fluent_builders::DeleteSchema {
        fluent_builders::DeleteSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTypedLinkFacet`](crate::client::fluent_builders::DeleteTypedLinkFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTypedLinkFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::DeleteTypedLinkFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteTypedLinkFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteTypedLinkFacet::set_name): <p>The unique name of the typed link facet.</p>
    /// - On success, responds with [`DeleteTypedLinkFacetOutput`](crate::output::DeleteTypedLinkFacetOutput)

    /// - On failure, responds with [`SdkError<DeleteTypedLinkFacetError>`](crate::error::DeleteTypedLinkFacetError)
    pub fn delete_typed_link_facet(&self) -> fluent_builders::DeleteTypedLinkFacet {
        fluent_builders::DeleteTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachFromIndex`](crate::client::fluent_builders::DetachFromIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DetachFromIndex::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DetachFromIndex::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
    ///   - [`index_reference(ObjectReference)`](crate::client::fluent_builders::DetachFromIndex::index_reference) / [`set_index_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DetachFromIndex::set_index_reference): <p>A reference to the index object.</p>
    ///   - [`target_reference(ObjectReference)`](crate::client::fluent_builders::DetachFromIndex::target_reference) / [`set_target_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DetachFromIndex::set_target_reference): <p>A reference to the object being detached from the index.</p>
    /// - On success, responds with [`DetachFromIndexOutput`](crate::output::DetachFromIndexOutput) with field(s):
    ///   - [`detached_object_identifier(Option<String>)`](crate::output::DetachFromIndexOutput::detached_object_identifier): <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
    /// - On failure, responds with [`SdkError<DetachFromIndexError>`](crate::error::DetachFromIndexError)
    pub fn detach_from_index(&self) -> fluent_builders::DetachFromIndex {
        fluent_builders::DetachFromIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachObject`](crate::client::fluent_builders::DetachObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DetachObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DetachObject::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`parent_reference(ObjectReference)`](crate::client::fluent_builders::DetachObject::parent_reference) / [`set_parent_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DetachObject::set_parent_reference): <p>The parent reference from which the object with the specified link name is detached.</p>
    ///   - [`link_name(impl Into<String>)`](crate::client::fluent_builders::DetachObject::link_name) / [`set_link_name(Option<String>)`](crate::client::fluent_builders::DetachObject::set_link_name): <p>The link name associated with the object that needs to be detached.</p>
    /// - On success, responds with [`DetachObjectOutput`](crate::output::DetachObjectOutput) with field(s):
    ///   - [`detached_object_identifier(Option<String>)`](crate::output::DetachObjectOutput::detached_object_identifier): <p>The <code>ObjectIdentifier</code> that was detached from the object.</p>
    /// - On failure, responds with [`SdkError<DetachObjectError>`](crate::error::DetachObjectError)
    pub fn detach_object(&self) -> fluent_builders::DetachObject {
        fluent_builders::DetachObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DetachPolicy::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DetachPolicy::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`policy_reference(ObjectReference)`](crate::client::fluent_builders::DetachPolicy::policy_reference) / [`set_policy_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DetachPolicy::set_policy_reference): <p>Reference that identifies the policy object.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::DetachPolicy::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::DetachPolicy::set_object_reference): <p>Reference that identifies the object whose policy object will be detached.</p>
    /// - On success, responds with [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)

    /// - On failure, responds with [`SdkError<DetachPolicyError>`](crate::error::DetachPolicyError)
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachTypedLink`](crate::client::fluent_builders::DetachTypedLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DetachTypedLink::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DetachTypedLink::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
    ///   - [`typed_link_specifier(TypedLinkSpecifier)`](crate::client::fluent_builders::DetachTypedLink::typed_link_specifier) / [`set_typed_link_specifier(Option<TypedLinkSpecifier>)`](crate::client::fluent_builders::DetachTypedLink::set_typed_link_specifier): <p>Used to accept a typed link specifier as input.</p>
    /// - On success, responds with [`DetachTypedLinkOutput`](crate::output::DetachTypedLinkOutput)

    /// - On failure, responds with [`SdkError<DetachTypedLinkError>`](crate::error::DetachTypedLinkError)
    pub fn detach_typed_link(&self) -> fluent_builders::DetachTypedLink {
        fluent_builders::DetachTypedLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableDirectory`](crate::client::fluent_builders::DisableDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::DisableDirectory::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::DisableDirectory::set_directory_arn): <p>The ARN of the directory to disable.</p>
    /// - On success, responds with [`DisableDirectoryOutput`](crate::output::DisableDirectoryOutput) with field(s):
    ///   - [`directory_arn(Option<String>)`](crate::output::DisableDirectoryOutput::directory_arn): <p>The ARN of the directory that has been disabled.</p>
    /// - On failure, responds with [`SdkError<DisableDirectoryError>`](crate::error::DisableDirectoryError)
    pub fn disable_directory(&self) -> fluent_builders::DisableDirectory {
        fluent_builders::DisableDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableDirectory`](crate::client::fluent_builders::EnableDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::EnableDirectory::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::EnableDirectory::set_directory_arn): <p>The ARN of the directory to enable.</p>
    /// - On success, responds with [`EnableDirectoryOutput`](crate::output::EnableDirectoryOutput) with field(s):
    ///   - [`directory_arn(Option<String>)`](crate::output::EnableDirectoryOutput::directory_arn): <p>The ARN of the enabled directory.</p>
    /// - On failure, responds with [`SdkError<EnableDirectoryError>`](crate::error::EnableDirectoryError)
    pub fn enable_directory(&self) -> fluent_builders::EnableDirectory {
        fluent_builders::EnableDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppliedSchemaVersion`](crate::client::fluent_builders::GetAppliedSchemaVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::GetAppliedSchemaVersion::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::GetAppliedSchemaVersion::set_schema_arn): <p>The ARN of the applied schema.</p>
    /// - On success, responds with [`GetAppliedSchemaVersionOutput`](crate::output::GetAppliedSchemaVersionOutput) with field(s):
    ///   - [`applied_schema_arn(Option<String>)`](crate::output::GetAppliedSchemaVersionOutput::applied_schema_arn): <p>Current applied schema ARN, including the minor version in use if one was provided.</p>
    /// - On failure, responds with [`SdkError<GetAppliedSchemaVersionError>`](crate::error::GetAppliedSchemaVersionError)
    pub fn get_applied_schema_version(&self) -> fluent_builders::GetAppliedSchemaVersion {
        fluent_builders::GetAppliedSchemaVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDirectory`](crate::client::fluent_builders::GetDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::GetDirectory::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::GetDirectory::set_directory_arn): <p>The ARN of the directory.</p>
    /// - On success, responds with [`GetDirectoryOutput`](crate::output::GetDirectoryOutput) with field(s):
    ///   - [`directory(Option<Directory>)`](crate::output::GetDirectoryOutput::directory): <p>Metadata about the directory.</p>
    /// - On failure, responds with [`SdkError<GetDirectoryError>`](crate::error::GetDirectoryError)
    pub fn get_directory(&self) -> fluent_builders::GetDirectory {
        fluent_builders::GetDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFacet`](crate::client::fluent_builders::GetFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::GetFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::GetFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetFacet::set_name): <p>The name of the facet to retrieve.</p>
    /// - On success, responds with [`GetFacetOutput`](crate::output::GetFacetOutput) with field(s):
    ///   - [`facet(Option<Facet>)`](crate::output::GetFacetOutput::facet): <p>The <code>Facet</code> structure that is associated with the facet.</p>
    /// - On failure, responds with [`SdkError<GetFacetError>`](crate::error::GetFacetError)
    pub fn get_facet(&self) -> fluent_builders::GetFacet {
        fluent_builders::GetFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLinkAttributes`](crate::client::fluent_builders::GetLinkAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::GetLinkAttributes::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::GetLinkAttributes::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    ///   - [`typed_link_specifier(TypedLinkSpecifier)`](crate::client::fluent_builders::GetLinkAttributes::typed_link_specifier) / [`set_typed_link_specifier(Option<TypedLinkSpecifier>)`](crate::client::fluent_builders::GetLinkAttributes::set_typed_link_specifier): <p>Allows a typed link specifier to be accepted as input.</p>
    ///   - [`attribute_names(Vec<String>)`](crate::client::fluent_builders::GetLinkAttributes::attribute_names) / [`set_attribute_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetLinkAttributes::set_attribute_names): <p>A list of attribute names whose values will be retrieved.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::GetLinkAttributes::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::GetLinkAttributes::set_consistency_level): <p>The consistency level at which to retrieve the attributes on a typed link.</p>
    /// - On success, responds with [`GetLinkAttributesOutput`](crate::output::GetLinkAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<AttributeKeyAndValue>>)`](crate::output::GetLinkAttributesOutput::attributes): <p>The attributes that are associated with the typed link.</p>
    /// - On failure, responds with [`SdkError<GetLinkAttributesError>`](crate::error::GetLinkAttributesError)
    pub fn get_link_attributes(&self) -> fluent_builders::GetLinkAttributes {
        fluent_builders::GetLinkAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectAttributes`](crate::client::fluent_builders::GetObjectAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::GetObjectAttributes::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::GetObjectAttributes::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::GetObjectAttributes::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::GetObjectAttributes::set_object_reference): <p>Reference that identifies the object whose attributes will be retrieved.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::GetObjectAttributes::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::GetObjectAttributes::set_consistency_level): <p>The consistency level at which to retrieve the attributes on an object.</p>
    ///   - [`schema_facet(SchemaFacet)`](crate::client::fluent_builders::GetObjectAttributes::schema_facet) / [`set_schema_facet(Option<SchemaFacet>)`](crate::client::fluent_builders::GetObjectAttributes::set_schema_facet): <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
    ///   - [`attribute_names(Vec<String>)`](crate::client::fluent_builders::GetObjectAttributes::attribute_names) / [`set_attribute_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetObjectAttributes::set_attribute_names): <p>List of attribute names whose values will be retrieved.</p>
    /// - On success, responds with [`GetObjectAttributesOutput`](crate::output::GetObjectAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<AttributeKeyAndValue>>)`](crate::output::GetObjectAttributesOutput::attributes): <p>The attributes that are associated with the object.</p>
    /// - On failure, responds with [`SdkError<GetObjectAttributesError>`](crate::error::GetObjectAttributesError)
    pub fn get_object_attributes(&self) -> fluent_builders::GetObjectAttributes {
        fluent_builders::GetObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectInformation`](crate::client::fluent_builders::GetObjectInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::GetObjectInformation::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::GetObjectInformation::set_directory_arn): <p>The ARN of the directory being retrieved.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::GetObjectInformation::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::GetObjectInformation::set_object_reference): <p>A reference to the object.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::GetObjectInformation::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::GetObjectInformation::set_consistency_level): <p>The consistency level at which to retrieve the object information.</p>
    /// - On success, responds with [`GetObjectInformationOutput`](crate::output::GetObjectInformationOutput) with field(s):
    ///   - [`schema_facets(Option<Vec<SchemaFacet>>)`](crate::output::GetObjectInformationOutput::schema_facets): <p>The facets attached to the specified object. Although the response does not include minor version information, the most recently applied minor version of each Facet is in effect. See <code>GetAppliedSchemaVersion</code> for details.</p>
    ///   - [`object_identifier(Option<String>)`](crate::output::GetObjectInformationOutput::object_identifier): <p>The <code>ObjectIdentifier</code> of the specified object.</p>
    /// - On failure, responds with [`SdkError<GetObjectInformationError>`](crate::error::GetObjectInformationError)
    pub fn get_object_information(&self) -> fluent_builders::GetObjectInformation {
        fluent_builders::GetObjectInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSchemaAsJson`](crate::client::fluent_builders::GetSchemaAsJson) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::GetSchemaAsJson::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::GetSchemaAsJson::set_schema_arn): <p>The ARN of the schema to retrieve.</p>
    /// - On success, responds with [`GetSchemaAsJsonOutput`](crate::output::GetSchemaAsJsonOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetSchemaAsJsonOutput::name): <p>The name of the retrieved schema.</p>
    ///   - [`document(Option<String>)`](crate::output::GetSchemaAsJsonOutput::document): <p>The JSON representation of the schema document.</p>
    /// - On failure, responds with [`SdkError<GetSchemaAsJsonError>`](crate::error::GetSchemaAsJsonError)
    pub fn get_schema_as_json(&self) -> fluent_builders::GetSchemaAsJson {
        fluent_builders::GetSchemaAsJson::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTypedLinkFacetInformation`](crate::client::fluent_builders::GetTypedLinkFacetInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::GetTypedLinkFacetInformation::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::GetTypedLinkFacetInformation::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetTypedLinkFacetInformation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetTypedLinkFacetInformation::set_name): <p>The unique name of the typed link facet.</p>
    /// - On success, responds with [`GetTypedLinkFacetInformationOutput`](crate::output::GetTypedLinkFacetInformationOutput) with field(s):
    ///   - [`identity_attribute_order(Option<Vec<String>>)`](crate::output::GetTypedLinkFacetInformationOutput::identity_attribute_order): <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    /// - On failure, responds with [`SdkError<GetTypedLinkFacetInformationError>`](crate::error::GetTypedLinkFacetInformationError)
    pub fn get_typed_link_facet_information(
        &self,
    ) -> fluent_builders::GetTypedLinkFacetInformation {
        fluent_builders::GetTypedLinkFacetInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppliedSchemaArns`](crate::client::fluent_builders::ListAppliedSchemaArns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppliedSchemaArns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::set_directory_arn): <p>The ARN of the directory you are listing.</p>
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::set_schema_arn): <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppliedSchemaArns::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppliedSchemaArns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppliedSchemaArns::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListAppliedSchemaArnsOutput`](crate::output::ListAppliedSchemaArnsOutput) with field(s):
    ///   - [`schema_arns(Option<Vec<String>>)`](crate::output::ListAppliedSchemaArnsOutput::schema_arns): <p>The ARNs of schemas that are applied to the directory.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppliedSchemaArnsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListAppliedSchemaArnsError>`](crate::error::ListAppliedSchemaArnsError)
    pub fn list_applied_schema_arns(&self) -> fluent_builders::ListAppliedSchemaArns {
        fluent_builders::ListAppliedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttachedIndices`](crate::client::fluent_builders::ListAttachedIndices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttachedIndices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListAttachedIndices::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListAttachedIndices::set_directory_arn): <p>The ARN of the directory.</p>
    ///   - [`target_reference(ObjectReference)`](crate::client::fluent_builders::ListAttachedIndices::target_reference) / [`set_target_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListAttachedIndices::set_target_reference): <p>A reference to the object that has indices attached.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttachedIndices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttachedIndices::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttachedIndices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttachedIndices::set_max_results): <p>The maximum number of results to retrieve.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListAttachedIndices::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListAttachedIndices::set_consistency_level): <p>The consistency level to use for this operation.</p>
    /// - On success, responds with [`ListAttachedIndicesOutput`](crate::output::ListAttachedIndicesOutput) with field(s):
    ///   - [`index_attachments(Option<Vec<IndexAttachment>>)`](crate::output::ListAttachedIndicesOutput::index_attachments): <p>The indices attached to the specified object.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttachedIndicesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListAttachedIndicesError>`](crate::error::ListAttachedIndicesError)
    pub fn list_attached_indices(&self) -> fluent_builders::ListAttachedIndices {
        fluent_builders::ListAttachedIndices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDevelopmentSchemaArns`](crate::client::fluent_builders::ListDevelopmentSchemaArns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDevelopmentSchemaArns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDevelopmentSchemaArns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDevelopmentSchemaArns::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDevelopmentSchemaArns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDevelopmentSchemaArns::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListDevelopmentSchemaArnsOutput`](crate::output::ListDevelopmentSchemaArnsOutput) with field(s):
    ///   - [`schema_arns(Option<Vec<String>>)`](crate::output::ListDevelopmentSchemaArnsOutput::schema_arns): <p>The ARNs of retrieved development schemas.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDevelopmentSchemaArnsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListDevelopmentSchemaArnsError>`](crate::error::ListDevelopmentSchemaArnsError)
    pub fn list_development_schema_arns(&self) -> fluent_builders::ListDevelopmentSchemaArns {
        fluent_builders::ListDevelopmentSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDirectories`](crate::client::fluent_builders::ListDirectories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDirectories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDirectories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDirectories::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDirectories::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDirectories::set_max_results): <p>The maximum number of results to retrieve.</p>
    ///   - [`state(DirectoryState)`](crate::client::fluent_builders::ListDirectories::state) / [`set_state(Option<DirectoryState>)`](crate::client::fluent_builders::ListDirectories::set_state): <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
    /// - On success, responds with [`ListDirectoriesOutput`](crate::output::ListDirectoriesOutput) with field(s):
    ///   - [`directories(Option<Vec<Directory>>)`](crate::output::ListDirectoriesOutput::directories): <p>Lists all directories that are associated with your account in pagination fashion.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDirectoriesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListDirectoriesError>`](crate::error::ListDirectoriesError)
    pub fn list_directories(&self) -> fluent_builders::ListDirectories {
        fluent_builders::ListDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFacetAttributes`](crate::client::fluent_builders::ListFacetAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFacetAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListFacetAttributes::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListFacetAttributes::set_schema_arn): <p>The ARN of the schema where the facet resides.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListFacetAttributes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListFacetAttributes::set_name): <p>The name of the facet whose attributes will be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFacetAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFacetAttributes::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFacetAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFacetAttributes::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListFacetAttributesOutput`](crate::output::ListFacetAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<FacetAttribute>>)`](crate::output::ListFacetAttributesOutput::attributes): <p>The attributes attached to the facet.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFacetAttributesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListFacetAttributesError>`](crate::error::ListFacetAttributesError)
    pub fn list_facet_attributes(&self) -> fluent_builders::ListFacetAttributes {
        fluent_builders::ListFacetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFacetNames`](crate::client::fluent_builders::ListFacetNames) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFacetNames::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListFacetNames::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListFacetNames::set_schema_arn): <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFacetNames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFacetNames::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFacetNames::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFacetNames::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListFacetNamesOutput`](crate::output::ListFacetNamesOutput) with field(s):
    ///   - [`facet_names(Option<Vec<String>>)`](crate::output::ListFacetNamesOutput::facet_names): <p>The names of facets that exist within the schema.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFacetNamesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListFacetNamesError>`](crate::error::ListFacetNamesError)
    pub fn list_facet_names(&self) -> fluent_builders::ListFacetNames {
        fluent_builders::ListFacetNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIncomingTypedLinks`](crate::client::fluent_builders::ListIncomingTypedLinks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListIncomingTypedLinks::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListIncomingTypedLinks::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_object_reference): <p>Reference that identifies the object whose attributes will be listed.</p>
    ///   - [`filter_attribute_ranges(Vec<TypedLinkAttributeRange>)`](crate::client::fluent_builders::ListIncomingTypedLinks::filter_attribute_ranges) / [`set_filter_attribute_ranges(Option<Vec<TypedLinkAttributeRange>>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_filter_attribute_ranges): <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    ///   - [`filter_typed_link(TypedLinkSchemaAndFacetName)`](crate::client::fluent_builders::ListIncomingTypedLinks::filter_typed_link) / [`set_filter_typed_link(Option<TypedLinkSchemaAndFacetName>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_filter_typed_link): <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIncomingTypedLinks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIncomingTypedLinks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_max_results): <p>The maximum number of results to retrieve.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListIncomingTypedLinks::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListIncomingTypedLinks::set_consistency_level): <p>The consistency level to execute the request at.</p>
    /// - On success, responds with [`ListIncomingTypedLinksOutput`](crate::output::ListIncomingTypedLinksOutput) with field(s):
    ///   - [`link_specifiers(Option<Vec<TypedLinkSpecifier>>)`](crate::output::ListIncomingTypedLinksOutput::link_specifiers): <p>Returns one or more typed link specifiers as output.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIncomingTypedLinksOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListIncomingTypedLinksError>`](crate::error::ListIncomingTypedLinksError)
    pub fn list_incoming_typed_links(&self) -> fluent_builders::ListIncomingTypedLinks {
        fluent_builders::ListIncomingTypedLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIndex`](crate::client::fluent_builders::ListIndex) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIndex::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListIndex::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListIndex::set_directory_arn): <p>The ARN of the directory that the index exists in.</p>
    ///   - [`ranges_on_indexed_values(Vec<ObjectAttributeRange>)`](crate::client::fluent_builders::ListIndex::ranges_on_indexed_values) / [`set_ranges_on_indexed_values(Option<Vec<ObjectAttributeRange>>)`](crate::client::fluent_builders::ListIndex::set_ranges_on_indexed_values): <p>Specifies the ranges of indexed values that you want to query.</p>
    ///   - [`index_reference(ObjectReference)`](crate::client::fluent_builders::ListIndex::index_reference) / [`set_index_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListIndex::set_index_reference): <p>The reference to the index to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIndex::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIndex::set_max_results): <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIndex::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIndex::set_next_token): <p>The pagination token.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListIndex::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListIndex::set_consistency_level): <p>The consistency level to execute the request at.</p>
    /// - On success, responds with [`ListIndexOutput`](crate::output::ListIndexOutput) with field(s):
    ///   - [`index_attachments(Option<Vec<IndexAttachment>>)`](crate::output::ListIndexOutput::index_attachments): <p>The objects and indexed values attached to the index.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIndexOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListIndexError>`](crate::error::ListIndexError)
    pub fn list_index(&self) -> fluent_builders::ListIndex {
        fluent_builders::ListIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedSchemaArns`](crate::client::fluent_builders::ListManagedSchemaArns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListManagedSchemaArns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListManagedSchemaArns::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListManagedSchemaArns::set_schema_arn): <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListManagedSchemaArns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListManagedSchemaArns::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListManagedSchemaArns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListManagedSchemaArns::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListManagedSchemaArnsOutput`](crate::output::ListManagedSchemaArnsOutput) with field(s):
    ///   - [`schema_arns(Option<Vec<String>>)`](crate::output::ListManagedSchemaArnsOutput::schema_arns): <p>The ARNs for all AWS managed schemas.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListManagedSchemaArnsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListManagedSchemaArnsError>`](crate::error::ListManagedSchemaArnsError)
    pub fn list_managed_schema_arns(&self) -> fluent_builders::ListManagedSchemaArns {
        fluent_builders::ListManagedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectAttributes`](crate::client::fluent_builders::ListObjectAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListObjectAttributes::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListObjectAttributes::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListObjectAttributes::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListObjectAttributes::set_object_reference): <p>The reference that identifies the object whose attributes will be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListObjectAttributes::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListObjectAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListObjectAttributes::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListObjectAttributes::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListObjectAttributes::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    ///   - [`facet_filter(SchemaFacet)`](crate::client::fluent_builders::ListObjectAttributes::facet_filter) / [`set_facet_filter(Option<SchemaFacet>)`](crate::client::fluent_builders::ListObjectAttributes::set_facet_filter): <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
    /// - On success, responds with [`ListObjectAttributesOutput`](crate::output::ListObjectAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<AttributeKeyAndValue>>)`](crate::output::ListObjectAttributesOutput::attributes): <p>Attributes map that is associated with the object. <code>AttributeArn</code> is the key, and attribute value is the value.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListObjectAttributesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListObjectAttributesError>`](crate::error::ListObjectAttributesError)
    pub fn list_object_attributes(&self) -> fluent_builders::ListObjectAttributes {
        fluent_builders::ListObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectChildren`](crate::client::fluent_builders::ListObjectChildren) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectChildren::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListObjectChildren::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListObjectChildren::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListObjectChildren::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListObjectChildren::set_object_reference): <p>The reference that identifies the object for which child objects are being listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectChildren::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListObjectChildren::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListObjectChildren::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListObjectChildren::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListObjectChildren::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListObjectChildren::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    /// - On success, responds with [`ListObjectChildrenOutput`](crate::output::ListObjectChildrenOutput) with field(s):
    ///   - [`children(Option<HashMap<String, String>>)`](crate::output::ListObjectChildrenOutput::children): <p>Children structure, which is a map with key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the value.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListObjectChildrenOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListObjectChildrenError>`](crate::error::ListObjectChildrenError)
    pub fn list_object_children(&self) -> fluent_builders::ListObjectChildren {
        fluent_builders::ListObjectChildren::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectParentPaths`](crate::client::fluent_builders::ListObjectParentPaths) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectParentPaths::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListObjectParentPaths::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListObjectParentPaths::set_directory_arn): <p>The ARN of the directory to which the parent path applies.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListObjectParentPaths::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListObjectParentPaths::set_object_reference): <p>The reference that identifies the object whose parent paths are listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectParentPaths::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListObjectParentPaths::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListObjectParentPaths::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListObjectParentPaths::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    /// - On success, responds with [`ListObjectParentPathsOutput`](crate::output::ListObjectParentPathsOutput) with field(s):
    ///   - [`path_to_object_identifiers_list(Option<Vec<PathToObjectIdentifiers>>)`](crate::output::ListObjectParentPathsOutput::path_to_object_identifiers_list): <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListObjectParentPathsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListObjectParentPathsError>`](crate::error::ListObjectParentPathsError)
    pub fn list_object_parent_paths(&self) -> fluent_builders::ListObjectParentPaths {
        fluent_builders::ListObjectParentPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectParents`](crate::client::fluent_builders::ListObjectParents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectParents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListObjectParents::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListObjectParents::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListObjectParents::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListObjectParents::set_object_reference): <p>The reference that identifies the object for which parent objects are being listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectParents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListObjectParents::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListObjectParents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListObjectParents::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListObjectParents::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListObjectParents::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    ///   - [`include_all_links_to_each_parent(bool)`](crate::client::fluent_builders::ListObjectParents::include_all_links_to_each_parent) / [`set_include_all_links_to_each_parent(bool)`](crate::client::fluent_builders::ListObjectParents::set_include_all_links_to_each_parent): <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
    /// - On success, responds with [`ListObjectParentsOutput`](crate::output::ListObjectParentsOutput) with field(s):
    ///   - [`parents(Option<HashMap<String, String>>)`](crate::output::ListObjectParentsOutput::parents): <p>The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and LinkName as the value.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListObjectParentsOutput::next_token): <p>The pagination token.</p>
    ///   - [`parent_links(Option<Vec<ObjectIdentifierAndLinkNameTuple>>)`](crate::output::ListObjectParentsOutput::parent_links): <p>Returns a list of parent reference and LinkName Tuples.</p>
    /// - On failure, responds with [`SdkError<ListObjectParentsError>`](crate::error::ListObjectParentsError)
    pub fn list_object_parents(&self) -> fluent_builders::ListObjectParents {
        fluent_builders::ListObjectParents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectPolicies`](crate::client::fluent_builders::ListObjectPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListObjectPolicies::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListObjectPolicies::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListObjectPolicies::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListObjectPolicies::set_object_reference): <p>Reference that identifies the object for which policies will be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListObjectPolicies::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListObjectPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListObjectPolicies::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListObjectPolicies::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListObjectPolicies::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    /// - On success, responds with [`ListObjectPoliciesOutput`](crate::output::ListObjectPoliciesOutput) with field(s):
    ///   - [`attached_policy_ids(Option<Vec<String>>)`](crate::output::ListObjectPoliciesOutput::attached_policy_ids): <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the object.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListObjectPoliciesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListObjectPoliciesError>`](crate::error::ListObjectPoliciesError)
    pub fn list_object_policies(&self) -> fluent_builders::ListObjectPolicies {
        fluent_builders::ListObjectPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOutgoingTypedLinks`](crate::client::fluent_builders::ListOutgoingTypedLinks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_directory_arn): <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::ListOutgoingTypedLinks::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_object_reference): <p>A reference that identifies the object whose attributes will be listed.</p>
    ///   - [`filter_attribute_ranges(Vec<TypedLinkAttributeRange>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::filter_attribute_ranges) / [`set_filter_attribute_ranges(Option<Vec<TypedLinkAttributeRange>>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_filter_attribute_ranges): <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    ///   - [`filter_typed_link(TypedLinkSchemaAndFacetName)`](crate::client::fluent_builders::ListOutgoingTypedLinks::filter_typed_link) / [`set_filter_typed_link(Option<TypedLinkSchemaAndFacetName>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_filter_typed_link): <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOutgoingTypedLinks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_max_results): <p>The maximum number of results to retrieve.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListOutgoingTypedLinks::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListOutgoingTypedLinks::set_consistency_level): <p>The consistency level to execute the request at.</p>
    /// - On success, responds with [`ListOutgoingTypedLinksOutput`](crate::output::ListOutgoingTypedLinksOutput) with field(s):
    ///   - [`typed_link_specifiers(Option<Vec<TypedLinkSpecifier>>)`](crate::output::ListOutgoingTypedLinksOutput::typed_link_specifiers): <p>Returns a typed link specifier as output.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOutgoingTypedLinksOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListOutgoingTypedLinksError>`](crate::error::ListOutgoingTypedLinksError)
    pub fn list_outgoing_typed_links(&self) -> fluent_builders::ListOutgoingTypedLinks {
        fluent_builders::ListOutgoingTypedLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicyAttachments`](crate::client::fluent_builders::ListPolicyAttachments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicyAttachments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::ListPolicyAttachments::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::ListPolicyAttachments::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    ///   - [`policy_reference(ObjectReference)`](crate::client::fluent_builders::ListPolicyAttachments::policy_reference) / [`set_policy_reference(Option<ObjectReference>)`](crate::client::fluent_builders::ListPolicyAttachments::set_policy_reference): <p>The reference that identifies the policy object.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPolicyAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPolicyAttachments::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPolicyAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPolicyAttachments::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    ///   - [`consistency_level(ConsistencyLevel)`](crate::client::fluent_builders::ListPolicyAttachments::consistency_level) / [`set_consistency_level(Option<ConsistencyLevel>)`](crate::client::fluent_builders::ListPolicyAttachments::set_consistency_level): <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    /// - On success, responds with [`ListPolicyAttachmentsOutput`](crate::output::ListPolicyAttachmentsOutput) with field(s):
    ///   - [`object_identifiers(Option<Vec<String>>)`](crate::output::ListPolicyAttachmentsOutput::object_identifiers): <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPolicyAttachmentsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListPolicyAttachmentsError>`](crate::error::ListPolicyAttachmentsError)
    pub fn list_policy_attachments(&self) -> fluent_builders::ListPolicyAttachments {
        fluent_builders::ListPolicyAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPublishedSchemaArns`](crate::client::fluent_builders::ListPublishedSchemaArns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPublishedSchemaArns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListPublishedSchemaArns::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListPublishedSchemaArns::set_schema_arn): <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPublishedSchemaArns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPublishedSchemaArns::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPublishedSchemaArns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPublishedSchemaArns::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListPublishedSchemaArnsOutput`](crate::output::ListPublishedSchemaArnsOutput) with field(s):
    ///   - [`schema_arns(Option<Vec<String>>)`](crate::output::ListPublishedSchemaArnsOutput::schema_arns): <p>The ARNs of published schemas.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPublishedSchemaArnsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListPublishedSchemaArnsError>`](crate::error::ListPublishedSchemaArnsError)
    pub fn list_published_schema_arns(&self) -> fluent_builders::ListPublishedSchemaArns {
        fluent_builders::ListPublishedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag key value pairs that are associated with the response.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTypedLinkFacetAttributes`](crate::client::fluent_builders::ListTypedLinkFacetAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::set_name): <p>The unique name of the typed link facet.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTypedLinkFacetAttributes::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListTypedLinkFacetAttributesOutput`](crate::output::ListTypedLinkFacetAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<TypedLinkAttributeDefinition>>)`](crate::output::ListTypedLinkFacetAttributesOutput::attributes): <p>An ordered set of attributes associate with the typed link.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTypedLinkFacetAttributesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListTypedLinkFacetAttributesError>`](crate::error::ListTypedLinkFacetAttributesError)
    pub fn list_typed_link_facet_attributes(
        &self,
    ) -> fluent_builders::ListTypedLinkFacetAttributes {
        fluent_builders::ListTypedLinkFacetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTypedLinkFacetNames`](crate::client::fluent_builders::ListTypedLinkFacetNames) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTypedLinkFacetNames::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::ListTypedLinkFacetNames::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::ListTypedLinkFacetNames::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTypedLinkFacetNames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTypedLinkFacetNames::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTypedLinkFacetNames::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTypedLinkFacetNames::set_max_results): <p>The maximum number of results to retrieve.</p>
    /// - On success, responds with [`ListTypedLinkFacetNamesOutput`](crate::output::ListTypedLinkFacetNamesOutput) with field(s):
    ///   - [`facet_names(Option<Vec<String>>)`](crate::output::ListTypedLinkFacetNamesOutput::facet_names): <p>The names of typed link facets that exist within the schema.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTypedLinkFacetNamesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListTypedLinkFacetNamesError>`](crate::error::ListTypedLinkFacetNamesError)
    pub fn list_typed_link_facet_names(&self) -> fluent_builders::ListTypedLinkFacetNames {
        fluent_builders::ListTypedLinkFacetNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`LookupPolicy`](crate::client::fluent_builders::LookupPolicy) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::LookupPolicy::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::LookupPolicy::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::LookupPolicy::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::LookupPolicy::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::LookupPolicy::set_object_reference): <p>Reference that identifies the object whose policies will be looked up.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::LookupPolicy::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::LookupPolicy::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::LookupPolicy::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::LookupPolicy::set_max_results): <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    /// - On success, responds with [`LookupPolicyOutput`](crate::output::LookupPolicyOutput) with field(s):
    ///   - [`policy_to_path_list(Option<Vec<PolicyToPath>>)`](crate::output::LookupPolicyOutput::policy_to_path_list): <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::LookupPolicyOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<LookupPolicyError>`](crate::error::LookupPolicyError)
    pub fn lookup_policy(&self) -> fluent_builders::LookupPolicy {
        fluent_builders::LookupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishSchema`](crate::client::fluent_builders::PublishSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`development_schema_arn(impl Into<String>)`](crate::client::fluent_builders::PublishSchema::development_schema_arn) / [`set_development_schema_arn(Option<String>)`](crate::client::fluent_builders::PublishSchema::set_development_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::PublishSchema::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::PublishSchema::set_version): <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
    ///   - [`minor_version(impl Into<String>)`](crate::client::fluent_builders::PublishSchema::minor_version) / [`set_minor_version(Option<String>)`](crate::client::fluent_builders::PublishSchema::set_minor_version): <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PublishSchema::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PublishSchema::set_name): <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
    /// - On success, responds with [`PublishSchemaOutput`](crate::output::PublishSchemaOutput) with field(s):
    ///   - [`published_schema_arn(Option<String>)`](crate::output::PublishSchemaOutput::published_schema_arn): <p>The ARN that is associated with the published schema. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<PublishSchemaError>`](crate::error::PublishSchemaError)
    pub fn publish_schema(&self) -> fluent_builders::PublishSchema {
        fluent_builders::PublishSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSchemaFromJson`](crate::client::fluent_builders::PutSchemaFromJson) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::PutSchemaFromJson::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::PutSchemaFromJson::set_schema_arn): <p>The ARN of the schema to update.</p>
    ///   - [`document(impl Into<String>)`](crate::client::fluent_builders::PutSchemaFromJson::document) / [`set_document(Option<String>)`](crate::client::fluent_builders::PutSchemaFromJson::set_document): <p>The replacement JSON schema.</p>
    /// - On success, responds with [`PutSchemaFromJsonOutput`](crate::output::PutSchemaFromJsonOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::PutSchemaFromJsonOutput::arn): <p>The ARN of the schema to update.</p>
    /// - On failure, responds with [`SdkError<PutSchemaFromJsonError>`](crate::error::PutSchemaFromJsonError)
    pub fn put_schema_from_json(&self) -> fluent_builders::PutSchemaFromJson {
        fluent_builders::PutSchemaFromJson::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFacetFromObject`](crate::client::fluent_builders::RemoveFacetFromObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFacetFromObject::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::RemoveFacetFromObject::set_directory_arn): <p>The ARN of the directory in which the object resides.</p>
    ///   - [`schema_facet(SchemaFacet)`](crate::client::fluent_builders::RemoveFacetFromObject::schema_facet) / [`set_schema_facet(Option<SchemaFacet>)`](crate::client::fluent_builders::RemoveFacetFromObject::set_schema_facet): <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::RemoveFacetFromObject::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::RemoveFacetFromObject::set_object_reference): <p>A reference to the object to remove the facet from.</p>
    /// - On success, responds with [`RemoveFacetFromObjectOutput`](crate::output::RemoveFacetFromObjectOutput)

    /// - On failure, responds with [`SdkError<RemoveFacetFromObjectError>`](crate::error::RemoveFacetFromObjectError)
    pub fn remove_facet_from_object(&self) -> fluent_builders::RemoveFacetFromObject {
        fluent_builders::RemoveFacetFromObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tag key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Keys of the tag that need to be removed from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFacet`](crate::client::fluent_builders::UpdateFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::UpdateFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFacet::set_name): <p>The name of the facet.</p>
    ///   - [`attribute_updates(Vec<FacetAttributeUpdate>)`](crate::client::fluent_builders::UpdateFacet::attribute_updates) / [`set_attribute_updates(Option<Vec<FacetAttributeUpdate>>)`](crate::client::fluent_builders::UpdateFacet::set_attribute_updates): <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
    ///   - [`object_type(ObjectType)`](crate::client::fluent_builders::UpdateFacet::object_type) / [`set_object_type(Option<ObjectType>)`](crate::client::fluent_builders::UpdateFacet::set_object_type): <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
    /// - On success, responds with [`UpdateFacetOutput`](crate::output::UpdateFacetOutput)

    /// - On failure, responds with [`SdkError<UpdateFacetError>`](crate::error::UpdateFacetError)
    pub fn update_facet(&self) -> fluent_builders::UpdateFacet {
        fluent_builders::UpdateFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLinkAttributes`](crate::client::fluent_builders::UpdateLinkAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLinkAttributes::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::UpdateLinkAttributes::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    ///   - [`typed_link_specifier(TypedLinkSpecifier)`](crate::client::fluent_builders::UpdateLinkAttributes::typed_link_specifier) / [`set_typed_link_specifier(Option<TypedLinkSpecifier>)`](crate::client::fluent_builders::UpdateLinkAttributes::set_typed_link_specifier): <p>Allows a typed link specifier to be accepted as input.</p>
    ///   - [`attribute_updates(Vec<LinkAttributeUpdate>)`](crate::client::fluent_builders::UpdateLinkAttributes::attribute_updates) / [`set_attribute_updates(Option<Vec<LinkAttributeUpdate>>)`](crate::client::fluent_builders::UpdateLinkAttributes::set_attribute_updates): <p>The attributes update structure.</p>
    /// - On success, responds with [`UpdateLinkAttributesOutput`](crate::output::UpdateLinkAttributesOutput)

    /// - On failure, responds with [`SdkError<UpdateLinkAttributesError>`](crate::error::UpdateLinkAttributesError)
    pub fn update_link_attributes(&self) -> fluent_builders::UpdateLinkAttributes {
        fluent_builders::UpdateLinkAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateObjectAttributes`](crate::client::fluent_builders::UpdateObjectAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateObjectAttributes::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::UpdateObjectAttributes::set_directory_arn): <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    ///   - [`object_reference(ObjectReference)`](crate::client::fluent_builders::UpdateObjectAttributes::object_reference) / [`set_object_reference(Option<ObjectReference>)`](crate::client::fluent_builders::UpdateObjectAttributes::set_object_reference): <p>The reference that identifies the object.</p>
    ///   - [`attribute_updates(Vec<ObjectAttributeUpdate>)`](crate::client::fluent_builders::UpdateObjectAttributes::attribute_updates) / [`set_attribute_updates(Option<Vec<ObjectAttributeUpdate>>)`](crate::client::fluent_builders::UpdateObjectAttributes::set_attribute_updates): <p>The attributes update structure.</p>
    /// - On success, responds with [`UpdateObjectAttributesOutput`](crate::output::UpdateObjectAttributesOutput) with field(s):
    ///   - [`object_identifier(Option<String>)`](crate::output::UpdateObjectAttributesOutput::object_identifier): <p>The <code>ObjectIdentifier</code> of the updated object.</p>
    /// - On failure, responds with [`SdkError<UpdateObjectAttributesError>`](crate::error::UpdateObjectAttributesError)
    pub fn update_object_attributes(&self) -> fluent_builders::UpdateObjectAttributes {
        fluent_builders::UpdateObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSchema`](crate::client::fluent_builders::UpdateSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSchema::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::UpdateSchema::set_schema_arn): <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSchema::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSchema::set_name): <p>The name of the schema.</p>
    /// - On success, responds with [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput) with field(s):
    ///   - [`schema_arn(Option<String>)`](crate::output::UpdateSchemaOutput::schema_arn): <p>The ARN that is associated with the updated schema. For more information, see <code>arns</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateSchemaError>`](crate::error::UpdateSchemaError)
    pub fn update_schema(&self) -> fluent_builders::UpdateSchema {
        fluent_builders::UpdateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTypedLinkFacet`](crate::client::fluent_builders::UpdateTypedLinkFacet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::schema_arn) / [`set_schema_arn(Option<String>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::set_schema_arn): <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::set_name): <p>The unique name of the typed link facet.</p>
    ///   - [`attribute_updates(Vec<TypedLinkFacetAttributeUpdate>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::attribute_updates) / [`set_attribute_updates(Option<Vec<TypedLinkFacetAttributeUpdate>>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::set_attribute_updates): <p>Attributes update structure.</p>
    ///   - [`identity_attribute_order(Vec<String>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::identity_attribute_order) / [`set_identity_attribute_order(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateTypedLinkFacet::set_identity_attribute_order): <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    /// - On success, responds with [`UpdateTypedLinkFacetOutput`](crate::output::UpdateTypedLinkFacetOutput)

    /// - On failure, responds with [`SdkError<UpdateTypedLinkFacetError>`](crate::error::UpdateTypedLinkFacetError)
    pub fn update_typed_link_facet(&self) -> fluent_builders::UpdateTypedLinkFacet {
        fluent_builders::UpdateTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpgradeAppliedSchema`](crate::client::fluent_builders::UpgradeAppliedSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`published_schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpgradeAppliedSchema::published_schema_arn) / [`set_published_schema_arn(Option<String>)`](crate::client::fluent_builders::UpgradeAppliedSchema::set_published_schema_arn): <p>The revision of the published schema to upgrade the directory to.</p>
    ///   - [`directory_arn(impl Into<String>)`](crate::client::fluent_builders::UpgradeAppliedSchema::directory_arn) / [`set_directory_arn(Option<String>)`](crate::client::fluent_builders::UpgradeAppliedSchema::set_directory_arn): <p>The ARN for the directory to which the upgraded schema will be applied.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpgradeAppliedSchema::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::UpgradeAppliedSchema::set_dry_run): <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
    /// - On success, responds with [`UpgradeAppliedSchemaOutput`](crate::output::UpgradeAppliedSchemaOutput) with field(s):
    ///   - [`upgraded_schema_arn(Option<String>)`](crate::output::UpgradeAppliedSchemaOutput::upgraded_schema_arn): <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    ///   - [`directory_arn(Option<String>)`](crate::output::UpgradeAppliedSchemaOutput::directory_arn): <p>The ARN of the directory that is returned as part of the response.</p>
    /// - On failure, responds with [`SdkError<UpgradeAppliedSchemaError>`](crate::error::UpgradeAppliedSchemaError)
    pub fn upgrade_applied_schema(&self) -> fluent_builders::UpgradeAppliedSchema {
        fluent_builders::UpgradeAppliedSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpgradePublishedSchema`](crate::client::fluent_builders::UpgradePublishedSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`development_schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::development_schema_arn) / [`set_development_schema_arn(Option<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::set_development_schema_arn): <p>The ARN of the development schema with the changes used for the upgrade.</p>
    ///   - [`published_schema_arn(impl Into<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::published_schema_arn) / [`set_published_schema_arn(Option<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::set_published_schema_arn): <p>The ARN of the published schema to be upgraded.</p>
    ///   - [`minor_version(impl Into<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::minor_version) / [`set_minor_version(Option<String>)`](crate::client::fluent_builders::UpgradePublishedSchema::set_minor_version): <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpgradePublishedSchema::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::UpgradePublishedSchema::set_dry_run): <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
    /// - On success, responds with [`UpgradePublishedSchemaOutput`](crate::output::UpgradePublishedSchemaOutput) with field(s):
    ///   - [`upgraded_schema_arn(Option<String>)`](crate::output::UpgradePublishedSchemaOutput::upgraded_schema_arn): <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    /// - On failure, responds with [`SdkError<UpgradePublishedSchemaError>`](crate::error::UpgradePublishedSchemaError)
    pub fn upgrade_published_schema(&self) -> fluent_builders::UpgradePublishedSchema {
        fluent_builders::UpgradePublishedSchema::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddFacetToObject`.
    ///
    /// <p>Adds a new <code>Facet</code> to an object. An object can have more than one facet applied on it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddFacetToObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_facet_to_object_input::Builder,
    }
    impl AddFacetToObject {
        /// Creates a new `AddFacetToObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFacetToObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFacetToObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(input);
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// Appends an item to `ObjectAttributeList`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            self.inner = self.inner.object_attribute_list(input);
            self
        }
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_object_attribute_list(input);
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplySchema`.
    ///
    /// <p>Copies the input published schema, at the specified version, into the <code>Directory</code> with the same name and version as that of the published schema.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplySchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_schema_input::Builder,
    }
    impl ApplySchema {
        /// Creates a new `ApplySchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplySchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplySchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(input.into());
            self
        }
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachObject`.
    ///
    /// <p>Attaches an existing object to another object. An object can be accessed in two ways:</p>
    /// <ol>
    /// <li> <p>Using the path</p> </li>
    /// <li> <p>Using <code>ObjectIdentifier</code> </p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_object_input::Builder,
    }
    impl AttachObject {
        /// Creates a new `AttachObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(input);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn child_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.child_reference(input);
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn set_child_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_child_reference(input);
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(input.into());
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl AttachPolicy {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(input);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachToIndex`.
    ///
    /// <p>Attaches the specified object to the specified index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachToIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_to_index_input::Builder,
    }
    impl AttachToIndex {
        /// Creates a new `AttachToIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachToIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachToIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(input);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(input);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachTypedLink`.
    ///
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachTypedLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_typed_link_input::Builder,
    }
    impl AttachTypedLink {
        /// Creates a new `AttachTypedLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachTypedLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachTypedLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn source_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.source_object_reference(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn set_source_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_source_object_reference(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn target_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_object_reference(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn set_target_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_object_reference(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn typed_link_facet(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.inner = self.inner.typed_link_facet(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn set_typed_link_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_facet(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, input: crate::model::AttributeNameAndValue) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchRead`.
    ///
    /// <p>Performs all the read operations in a batch. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchRead {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_read_input::Builder,
    }
    impl BatchRead {
        /// Creates a new `BatchRead`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchReadOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchReadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `Operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, input: crate::model::BatchReadOperation) -> Self {
            self.inner = self.inner.operations(input);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchReadOperation>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchWrite`.
    ///
    /// <p>Performs all the write operations in a batch. Either all the operations succeed or none.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchWrite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_write_input::Builder,
    }
    impl BatchWrite {
        /// Creates a new `BatchWrite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchWriteOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchWriteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `Operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, input: crate::model::BatchWriteOperation) -> Self {
            self.inner = self.inner.operations(input);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperation>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectory`.
    ///
    /// <p>Creates a <code>Directory</code> by copying the published schema into the directory. A directory cannot be created without a schema.</p>
    /// <p>You can also quickly create a directory using a managed schema, called the <code>QuickStartSchema</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html">Managed Schema</a> in the <i>Amazon Cloud Directory Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_directory_input::Builder,
    }
    impl CreateDirectory {
        /// Creates a new `CreateDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFacet`.
    ///
    /// <p>Creates a new <code>Facet</code> in a schema. Facet creation is allowed only in development or applied schemas.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_facet_input::Builder,
    }
    impl CreateFacet {
        /// Creates a new `CreateFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the <code>Facet</code>.</p>
        pub fn attributes(mut self, input: crate::model::FacetAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes that are associated with the <code>Facet</code>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
        /// <ul>
        /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Index: Can be created with the Index API.</p> </li>
        /// </ul>
        pub fn object_type(mut self, input: crate::model::ObjectType) -> Self {
            self.inner = self.inner.object_type(input);
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
        /// <ul>
        /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Index: Can be created with the Index API.</p> </li>
        /// </ul>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.inner = self.inner.set_object_type(input);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn facet_style(mut self, input: crate::model::FacetStyle) -> Self {
            self.inner = self.inner.facet_style(input);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn set_facet_style(
            mut self,
            input: std::option::Option<crate::model::FacetStyle>,
        ) -> Self {
            self.inner = self.inner.set_facet_style(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIndex`.
    ///
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html">Indexing and search</a> for more information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_index_input::Builder,
    }
    impl CreateIndex {
        /// Creates a new `CreateIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `OrderedIndexedAttributeList`.
        ///
        /// To override the contents of this collection use [`set_ordered_indexed_attribute_list`](Self::set_ordered_indexed_attribute_list).
        ///
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn ordered_indexed_attribute_list(mut self, input: crate::model::AttributeKey) -> Self {
            self.inner = self.inner.ordered_indexed_attribute_list(input);
            self
        }
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn set_ordered_indexed_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        ) -> Self {
            self.inner = self.inner.set_ordered_indexed_attribute_list(input);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn is_unique(mut self, input: bool) -> Self {
            self.inner = self.inner.is_unique(input);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn set_is_unique(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_unique(input);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(input);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(input.into());
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateObject`.
    ///
    /// <p>Creates an object in a <code>Directory</code>. Additionally attaches the object to a parent, if a parent reference and <code>LinkName</code> is specified. An object is simply a collection of <code>Facet</code> attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_object_input::Builder,
    }
    impl CreateObject {
        /// Creates a new `CreateObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `SchemaFacets`.
        ///
        /// To override the contents of this collection use [`set_schema_facets`](Self::set_schema_facets).
        ///
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facets(mut self, input: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facets(input);
            self
        }
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.inner = self.inner.set_schema_facets(input);
            self
        }
        /// Appends an item to `ObjectAttributeList`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            self.inner = self.inner.object_attribute_list(input);
            self
        }
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_object_attribute_list(input);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(input);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(input.into());
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchema`.
    ///
    /// <p>Creates a new schema in a development state. A schema can exist in three phases:</p>
    /// <ul>
    /// <li> <p> <i>Development:</i> This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.</p> </li>
    /// <li> <p> <i>Published:</i> Published schemas are immutable and have a version associated with them.</p> </li>
    /// <li> <p> <i>Applied:</i> Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_schema_input::Builder,
    }
    impl CreateSchema {
        /// Creates a new `CreateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTypedLinkFacet`.
    ///
    /// <p>Creates a <code>TypedLinkFacet</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTypedLinkFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_typed_link_facet_input::Builder,
    }
    impl CreateTypedLinkFacet {
        /// Creates a new `CreateTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTypedLinkFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
        pub fn facet(mut self, input: crate::model::TypedLinkFacet) -> Self {
            self.inner = self.inner.facet(input);
            self
        }
        /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
        pub fn set_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkFacet>,
        ) -> Self {
            self.inner = self.inner.set_facet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectory`.
    ///
    /// <p>Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_directory_input::Builder,
    }
    impl DeleteDirectory {
        /// Creates a new `DeleteDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to delete.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory to delete.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFacet`.
    ///
    /// <p>Deletes a given <code>Facet</code>. All attributes and <code>Rule</code>s that are associated with the facet will be deleted. Only development schema facets are allowed deletion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_facet_input::Builder,
    }
    impl DeleteFacet {
        /// Creates a new `DeleteFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObject`.
    ///
    /// <p>Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_object_input::Builder,
    }
    impl DeleteObject {
        /// Creates a new `DeleteObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchema`.
    ///
    /// <p>Deletes a given schema. Schemas in a development and published state can only be deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_schema_input::Builder,
    }
    impl DeleteSchema {
        /// Creates a new `DeleteSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTypedLinkFacet`.
    ///
    /// <p>Deletes a <code>TypedLinkFacet</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTypedLinkFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_typed_link_facet_input::Builder,
    }
    impl DeleteTypedLinkFacet {
        /// Creates a new `DeleteTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTypedLinkFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachFromIndex`.
    ///
    /// <p>Detaches the specified object from the specified index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachFromIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_from_index_input::Builder,
    }
    impl DetachFromIndex {
        /// Creates a new `DetachFromIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachFromIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachFromIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(input);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(input);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachObject`.
    ///
    /// <p>Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_object_input::Builder,
    }
    impl DetachObject {
        /// Creates a new `DetachObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The parent reference from which the object with the specified link name is detached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(input);
            self
        }
        /// <p>The parent reference from which the object with the specified link name is detached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(input.into());
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from an object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl DetachPolicy {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(input);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachTypedLink`.
    ///
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachTypedLink {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_typed_link_input::Builder,
    }
    impl DetachTypedLink {
        /// Creates a new `DetachTypedLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachTypedLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachTypedLinkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(input);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDirectory`.
    ///
    /// <p>Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_directory_input::Builder,
    }
    impl DisableDirectory {
        /// Creates a new `DisableDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to disable.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory to disable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDirectory`.
    ///
    /// <p>Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_directory_input::Builder,
    }
    impl EnableDirectory {
        /// Creates a new `EnableDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to enable.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory to enable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppliedSchemaVersion`.
    ///
    /// <p>Returns current applied schema version ARN, including the minor version in use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppliedSchemaVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_applied_schema_version_input::Builder,
    }
    impl GetAppliedSchemaVersion {
        /// Creates a new `GetAppliedSchemaVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppliedSchemaVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppliedSchemaVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the applied schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The ARN of the applied schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDirectory`.
    ///
    /// <p>Retrieves metadata about a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_directory_input::Builder,
    }
    impl GetDirectory {
        /// Creates a new `GetDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFacet`.
    ///
    /// <p>Gets details of the <code>Facet</code>, such as facet name, attributes, <code>Rule</code>s, or <code>ObjectType</code>. You can call this on all kinds of schema facets -- published, development, or applied.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_facet_input::Builder,
    }
    impl GetFacet {
        /// Creates a new `GetFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinkAttributes`.
    ///
    /// <p>Retrieves attributes that are associated with a typed link.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLinkAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_link_attributes_input::Builder,
    }
    impl GetLinkAttributes {
        /// Creates a new `GetLinkAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinkAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinkAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(input.into());
            self
        }
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectAttributes`.
    ///
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_attributes_input::Builder,
    }
    impl GetObjectAttributes {
        /// Creates a new `GetObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(input);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(input.into());
            self
        }
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectInformation`.
    ///
    /// <p>Retrieves metadata about an object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_information_input::Builder,
    }
    impl GetObjectInformation {
        /// Creates a new `GetObjectInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaAsJson`.
    ///
    /// <p>Retrieves a JSON representation of the schema. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON Schema Format</a> for more information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSchemaAsJson {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_schema_as_json_input::Builder,
    }
    impl GetSchemaAsJson {
        /// Creates a new `GetSchemaAsJson`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaAsJsonOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaAsJsonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTypedLinkFacetInformation`.
    ///
    /// <p>Returns the identity attribute order for a specific <code>TypedLinkFacet</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTypedLinkFacetInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_typed_link_facet_information_input::Builder,
    }
    impl GetTypedLinkFacetInformation {
        /// Creates a new `GetTypedLinkFacetInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTypedLinkFacetInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTypedLinkFacetInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppliedSchemaArns`.
    ///
    /// <p>Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppliedSchemaArns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_applied_schema_arns_input::Builder,
    }
    impl ListAppliedSchemaArns {
        /// Creates a new `ListAppliedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppliedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppliedSchemaArnsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppliedSchemaArnsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppliedSchemaArnsPaginator {
            crate::paginator::ListAppliedSchemaArnsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the directory you are listing.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory you are listing.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedIndices`.
    ///
    /// <p>Lists indices attached to the specified object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttachedIndices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_attached_indices_input::Builder,
    }
    impl ListAttachedIndices {
        /// Creates a new `ListAttachedIndices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedIndicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedIndicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttachedIndicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttachedIndicesPaginator {
            crate::paginator::ListAttachedIndicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(input);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevelopmentSchemaArns`.
    ///
    /// <p>Retrieves each Amazon Resource Name (ARN) of schemas in the development state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevelopmentSchemaArns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_development_schema_arns_input::Builder,
    }
    impl ListDevelopmentSchemaArns {
        /// Creates a new `ListDevelopmentSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevelopmentSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevelopmentSchemaArnsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevelopmentSchemaArnsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevelopmentSchemaArnsPaginator {
            crate::paginator::ListDevelopmentSchemaArnsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDirectories`.
    ///
    /// <p>Lists directories created within an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDirectories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_directories_input::Builder,
    }
    impl ListDirectories {
        /// Creates a new `ListDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDirectoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDirectoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDirectoriesPaginator {
            crate::paginator::ListDirectoriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
        pub fn state(mut self, input: crate::model::DirectoryState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DirectoryState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFacetAttributes`.
    ///
    /// <p>Retrieves attributes attached to the facet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFacetAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_facet_attributes_input::Builder,
    }
    impl ListFacetAttributes {
        /// Creates a new `ListFacetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacetAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacetAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFacetAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFacetAttributesPaginator {
            crate::paginator::ListFacetAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFacetNames`.
    ///
    /// <p>Retrieves the names of facets that exist in a schema.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFacetNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_facet_names_input::Builder,
    }
    impl ListFacetNames {
        /// Creates a new `ListFacetNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacetNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacetNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFacetNamesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFacetNamesPaginator {
            crate::paginator::ListFacetNamesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIncomingTypedLinks`.
    ///
    /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIncomingTypedLinks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_incoming_typed_links_input::Builder,
    }
    impl ListIncomingTypedLinks {
        /// Creates a new `ListIncomingTypedLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIncomingTypedLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIncomingTypedLinksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `FilterAttributeRanges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            self.inner = self.inner.filter_attribute_ranges(input);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_filter_attribute_ranges(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.inner = self.inner.filter_typed_link(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_filter_typed_link(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIndex`.
    ///
    /// <p>Lists objects attached to the specified index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_index_input::Builder,
    }
    impl ListIndex {
        /// Creates a new `ListIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIndexPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIndexPaginator {
            crate::paginator::ListIndexPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `RangesOnIndexedValues`.
        ///
        /// To override the contents of this collection use [`set_ranges_on_indexed_values`](Self::set_ranges_on_indexed_values).
        ///
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn ranges_on_indexed_values(
            mut self,
            input: crate::model::ObjectAttributeRange,
        ) -> Self {
            self.inner = self.inner.ranges_on_indexed_values(input);
            self
        }
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn set_ranges_on_indexed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_ranges_on_indexed_values(input);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(input);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedSchemaArns`.
    ///
    /// <p>Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedSchemaArns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_managed_schema_arns_input::Builder,
    }
    impl ListManagedSchemaArns {
        /// Creates a new `ListManagedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedSchemaArnsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListManagedSchemaArnsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListManagedSchemaArnsPaginator {
            crate::paginator::ListManagedSchemaArnsPaginator::new(self.handle, self.inner)
        }
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectAttributes`.
    ///
    /// <p>Lists all attributes that are associated with an object. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_attributes_input::Builder,
    }
    impl ListObjectAttributes {
        /// Creates a new `ListObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectAttributesPaginator {
            crate::paginator::ListObjectAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn facet_filter(mut self, input: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.facet_filter(input);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn set_facet_filter(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_facet_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectChildren`.
    ///
    /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectChildren {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_children_input::Builder,
    }
    impl ListObjectChildren {
        /// Creates a new `ListObjectChildren`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectChildrenOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectChildrenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectChildrenPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectChildrenPaginator {
            crate::paginator::ListObjectChildrenPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object for which child objects are being listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object for which child objects are being listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectParentPaths`.
    ///
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    /// <p>Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored from the target object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectParentPaths {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_parent_paths_input::Builder,
    }
    impl ListObjectParentPaths {
        /// Creates a new `ListObjectParentPaths`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectParentPathsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectParentPathsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectParentPathsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectParentPathsPaginator {
            crate::paginator::ListObjectParentPathsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectParents`.
    ///
    /// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectParents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_parents_input::Builder,
    }
    impl ListObjectParents {
        /// Creates a new `ListObjectParents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectParentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectParentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectParentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectParentsPaginator {
            crate::paginator::ListObjectParentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
        pub fn include_all_links_to_each_parent(mut self, input: bool) -> Self {
            self.inner = self.inner.include_all_links_to_each_parent(input);
            self
        }
        /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
        pub fn set_include_all_links_to_each_parent(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_all_links_to_each_parent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectPolicies`.
    ///
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_policies_input::Builder,
    }
    impl ListObjectPolicies {
        /// Creates a new `ListObjectPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectPoliciesPaginator {
            crate::paginator::ListObjectPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOutgoingTypedLinks`.
    ///
    /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOutgoingTypedLinks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_outgoing_typed_links_input::Builder,
    }
    impl ListOutgoingTypedLinks {
        /// Creates a new `ListOutgoingTypedLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOutgoingTypedLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOutgoingTypedLinksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `FilterAttributeRanges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            self.inner = self.inner.filter_attribute_ranges(input);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_filter_attribute_ranges(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.inner = self.inner.filter_typed_link(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_filter_typed_link(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyAttachments`.
    ///
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicyAttachments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_policy_attachments_input::Builder,
    }
    impl ListPolicyAttachments {
        /// Creates a new `ListPolicyAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyAttachmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyAttachmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPolicyAttachmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPolicyAttachmentsPaginator {
            crate::paginator::ListPolicyAttachmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(input);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublishedSchemaArns`.
    ///
    /// <p>Lists the major version families of each published schema. If a major version ARN is provided as <code>SchemaArn</code>, the minor version revisions in that family are listed instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPublishedSchemaArns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_published_schema_arns_input::Builder,
    }
    impl ListPublishedSchemaArns {
        /// Creates a new `ListPublishedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublishedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublishedSchemaArnsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPublishedSchemaArnsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPublishedSchemaArnsPaginator {
            crate::paginator::ListPublishedSchemaArnsPaginator::new(self.handle, self.inner)
        }
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypedLinkFacetAttributes`.
    ///
    /// <p>Returns a paginated list of all attribute definitions for a particular <code>TypedLinkFacet</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTypedLinkFacetAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_typed_link_facet_attributes_input::Builder,
    }
    impl ListTypedLinkFacetAttributes {
        /// Creates a new `ListTypedLinkFacetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypedLinkFacetAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypedLinkFacetAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTypedLinkFacetAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTypedLinkFacetAttributesPaginator {
            crate::paginator::ListTypedLinkFacetAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypedLinkFacetNames`.
    ///
    /// <p>Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTypedLinkFacetNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_typed_link_facet_names_input::Builder,
    }
    impl ListTypedLinkFacetNames {
        /// Creates a new `ListTypedLinkFacetNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypedLinkFacetNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypedLinkFacetNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTypedLinkFacetNamesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTypedLinkFacetNamesPaginator {
            crate::paginator::ListTypedLinkFacetNamesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LookupPolicy`.
    ///
    /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct LookupPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::lookup_policy_input::Builder,
    }
    impl LookupPolicy {
        /// Creates a new `LookupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LookupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::LookupPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::LookupPolicyPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::LookupPolicyPaginator {
            crate::paginator::LookupPolicyPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishSchema`.
    ///
    /// <p>Publishes a development schema with a major version and a recommended minor version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_schema_input::Builder,
    }
    impl PublishSchema {
        /// Creates a new `PublishSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
        pub fn development_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.development_schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_development_schema_arn(input);
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(input.into());
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSchemaFromJson`.
    ///
    /// <p>Allows a schema to be updated using JSON upload. Only available for development schemas. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON Schema Format</a> for more information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSchemaFromJson {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_schema_from_json_input::Builder,
    }
    impl PutSchemaFromJson {
        /// Creates a new `PutSchemaFromJson`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSchemaFromJsonOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSchemaFromJsonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFacetFromObject`.
    ///
    /// <p>Removes the specified facet from the specified object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveFacetFromObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_facet_from_object_input::Builder,
    }
    impl RemoveFacetFromObject {
        /// Creates a new `RemoveFacetFromObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFacetFromObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFacetFromObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(input);
            self
        }
        /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>An API operation for adding tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>An API operation for removing tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFacet`.
    ///
    /// <p>Does the following:</p>
    /// <ol>
    /// <li> <p>Adds new <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p> </li>
    /// <li> <p>Updates existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p> </li>
    /// <li> <p>Deletes existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_facet_input::Builder,
    }
    impl UpdateFacet {
        /// Creates a new `UpdateFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
        pub fn attribute_updates(mut self, input: crate::model::FacetAttributeUpdate) -> Self {
            self.inner = self.inner.attribute_updates(input);
            self
        }
        /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn object_type(mut self, input: crate::model::ObjectType) -> Self {
            self.inner = self.inner.object_type(input);
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.inner = self.inner.set_object_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLinkAttributes`.
    ///
    /// <p>Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its <code>IdentityAttributeOrder</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLinkAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_link_attributes_input::Builder,
    }
    impl UpdateLinkAttributes {
        /// Creates a new `UpdateLinkAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLinkAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLinkAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::LinkAttributeUpdate) -> Self {
            self.inner = self.inner.attribute_updates(input);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateObjectAttributes`.
    ///
    /// <p>Updates a given object's attributes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateObjectAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_object_attributes_input::Builder,
    }
    impl UpdateObjectAttributes {
        /// Creates a new `UpdateObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateObjectAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(input);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::ObjectAttributeUpdate) -> Self {
            self.inner = self.inner.attribute_updates(input);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSchema`.
    ///
    /// <p>Updates the schema name with a new name. Only development schema names can be updated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_schema_input::Builder,
    }
    impl UpdateSchema {
        /// Creates a new `UpdateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTypedLinkFacet`.
    ///
    /// <p>Updates a <code>TypedLinkFacet</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTypedLinkFacet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_typed_link_facet_input::Builder,
    }
    impl UpdateTypedLinkFacet {
        /// Creates a new `UpdateTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTypedLinkFacetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>Attributes update structure.</p>
        pub fn attribute_updates(
            mut self,
            input: crate::model::TypedLinkFacetAttributeUpdate,
        ) -> Self {
            self.inner = self.inner.attribute_updates(input);
            self
        }
        /// <p>Attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkFacetAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// Appends an item to `IdentityAttributeOrder`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_order`](Self::set_identity_attribute_order).
        ///
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn identity_attribute_order(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_attribute_order(input.into());
            self
        }
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_identity_attribute_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_attribute_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeAppliedSchema`.
    ///
    /// <p>Upgrades a single directory in-place using the <code>PublishedSchemaArn</code> with schema updates found in <code>MinorVersion</code>. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeAppliedSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upgrade_applied_schema_input::Builder,
    }
    impl UpgradeAppliedSchema {
        /// Creates a new `UpgradeAppliedSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeAppliedSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeAppliedSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(input.into());
            self
        }
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(input.into());
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradePublishedSchema`.
    ///
    /// <p>Upgrades a published schema under a new minor version revision using the current contents of <code>DevelopmentSchemaArn</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradePublishedSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upgrade_published_schema_input::Builder,
    }
    impl UpgradePublishedSchema {
        /// Creates a new `UpgradePublishedSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradePublishedSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradePublishedSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn development_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.development_schema_arn(input.into());
            self
        }
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_development_schema_arn(input);
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(input.into());
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(input.into());
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
