// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddFacetToObjectInput`](crate::input::AddFacetToObjectInput)
pub mod add_facet_to_object_input {
    /// A builder for [`AddFacetToObjectInput`](crate::input::AddFacetToObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) object_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// Appends an item to `object_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.object_attribute_list.unwrap_or_default();
            v.push(input);
            self.object_attribute_list = Some(v);
            self
        }
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.object_attribute_list = input;
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFacetToObjectInput`](crate::input::AddFacetToObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddFacetToObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddFacetToObjectInput {
                directory_arn: self.directory_arn,
                schema_facet: self.schema_facet,
                object_attribute_list: self.object_attribute_list,
                object_reference: self.object_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type AddFacetToObjectInputOperationOutputAlias = crate::operation::AddFacetToObject;
#[doc(hidden)]
pub type AddFacetToObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddFacetToObjectInput {
    /// Consumes the builder and constructs an Operation<[`AddFacetToObject`](crate::operation::AddFacetToObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddFacetToObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddFacetToObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/facets")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AddFacetToObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_1) = &_input.directory_arn {
                let formatted_2 = AsRef::<str>::as_ref(inner_1);
                if !formatted_2.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_2;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddFacetToObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddFacetToObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_facet_to_object(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddFacetToObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddFacetToObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddFacetToObjectInput`](crate::input::AddFacetToObjectInput)
    pub fn builder() -> crate::input::add_facet_to_object_input::Builder {
        crate::input::add_facet_to_object_input::Builder::default()
    }
}

/// See [`ApplySchemaInput`](crate::input::ApplySchemaInput)
pub mod apply_schema_input {
    /// A builder for [`ApplySchemaInput`](crate::input::ApplySchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) published_schema_arn: std::option::Option<std::string::String>,
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_schema_arn = Some(input.into());
            self
        }
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.published_schema_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplySchemaInput`](crate::input::ApplySchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplySchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplySchemaInput {
                published_schema_arn: self.published_schema_arn,
                directory_arn: self.directory_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplySchemaInputOperationOutputAlias = crate::operation::ApplySchema;
#[doc(hidden)]
pub type ApplySchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ApplySchemaInput {
    /// Consumes the builder and constructs an Operation<[`ApplySchema`](crate::operation::ApplySchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplySchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplySchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/apply")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ApplySchemaInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_3) = &_input.directory_arn {
                let formatted_4 = AsRef::<str>::as_ref(inner_3);
                if !formatted_4.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_4;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplySchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplySchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_apply_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplySchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplySchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplySchemaInput`](crate::input::ApplySchemaInput)
    pub fn builder() -> crate::input::apply_schema_input::Builder {
        crate::input::apply_schema_input::Builder::default()
    }
}

/// See [`AttachObjectInput`](crate::input::AttachObjectInput)
pub mod attach_object_input {
    /// A builder for [`AttachObjectInput`](crate::input::AttachObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) child_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The parent object reference.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn child_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.child_reference = Some(input);
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn set_child_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.child_reference = input;
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachObjectInput`](crate::input::AttachObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachObjectInput {
                directory_arn: self.directory_arn,
                parent_reference: self.parent_reference,
                child_reference: self.child_reference,
                link_name: self.link_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachObjectInputOperationOutputAlias = crate::operation::AttachObject;
#[doc(hidden)]
pub type AttachObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachObjectInput {
    /// Consumes the builder and constructs an Operation<[`AttachObject`](crate::operation::AttachObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/attach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AttachObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_5) = &_input.directory_arn {
                let formatted_6 = AsRef::<str>::as_ref(inner_5);
                if !formatted_6.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_6;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_attach_object(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachObjectInput`](crate::input::AttachObjectInput)
    pub fn builder() -> crate::input::attach_object_input::Builder {
        crate::input::attach_object_input::Builder::default()
    }
}

/// See [`AttachPolicyInput`](crate::input::AttachPolicyInput)
pub mod attach_policy_input {
    /// A builder for [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachPolicyInput`](crate::input::AttachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachPolicyInput {
                directory_arn: self.directory_arn,
                policy_reference: self.policy_reference,
                object_reference: self.object_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachPolicyInputOperationOutputAlias = crate::operation::AttachPolicy;
#[doc(hidden)]
pub type AttachPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachPolicy`](crate::operation::AttachPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/policy/attach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AttachPolicyInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_7) = &_input.directory_arn {
                let formatted_8 = AsRef::<str>::as_ref(inner_7);
                if !formatted_8.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_8;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_attach_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachPolicy",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
}

/// See [`AttachToIndexInput`](crate::input::AttachToIndexInput)
pub mod attach_to_index_input {
    /// A builder for [`AttachToIndexInput`](crate::input::AttachToIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachToIndexInput`](crate::input::AttachToIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachToIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachToIndexInput {
                directory_arn: self.directory_arn,
                index_reference: self.index_reference,
                target_reference: self.target_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachToIndexInputOperationOutputAlias = crate::operation::AttachToIndex;
#[doc(hidden)]
pub type AttachToIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachToIndexInput {
    /// Consumes the builder and constructs an Operation<[`AttachToIndex`](crate::operation::AttachToIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachToIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachToIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/index/attach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AttachToIndexInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_9) = &_input.directory_arn {
                let formatted_10 = AsRef::<str>::as_ref(inner_9);
                if !formatted_10.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_10;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachToIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachToIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_to_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachToIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachToIndex",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachToIndexInput`](crate::input::AttachToIndexInput)
    pub fn builder() -> crate::input::attach_to_index_input::Builder {
        crate::input::attach_to_index_input::Builder::default()
    }
}

/// See [`AttachTypedLinkInput`](crate::input::AttachTypedLinkInput)
pub mod attach_typed_link_input {
    /// A builder for [`AttachTypedLinkInput`](crate::input::AttachTypedLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) source_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn source_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.source_object_reference = Some(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn set_source_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.source_object_reference = input;
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn target_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_object_reference = Some(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn set_target_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_object_reference = input;
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn typed_link_facet(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.typed_link_facet = Some(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn set_typed_link_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.typed_link_facet = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, input: crate::model::AttributeNameAndValue) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachTypedLinkInput`](crate::input::AttachTypedLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachTypedLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachTypedLinkInput {
                directory_arn: self.directory_arn,
                source_object_reference: self.source_object_reference,
                target_object_reference: self.target_object_reference,
                typed_link_facet: self.typed_link_facet,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachTypedLinkInputOperationOutputAlias = crate::operation::AttachTypedLink;
#[doc(hidden)]
pub type AttachTypedLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachTypedLinkInput {
    /// Consumes the builder and constructs an Operation<[`AttachTypedLink`](crate::operation::AttachTypedLink)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachTypedLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachTypedLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/typedlink/attach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AttachTypedLinkInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_11) = &_input.directory_arn {
                let formatted_12 = AsRef::<str>::as_ref(inner_11);
                if !formatted_12.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_12;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachTypedLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachTypedLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_typed_link(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachTypedLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachTypedLink",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachTypedLinkInput`](crate::input::AttachTypedLinkInput)
    pub fn builder() -> crate::input::attach_typed_link_input::Builder {
        crate::input::attach_typed_link_input::Builder::default()
    }
}

/// See [`BatchReadInput`](crate::input::BatchReadInput)
pub mod batch_read_input {
    /// A builder for [`BatchReadInput`](crate::input::BatchReadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::BatchReadOperation>>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, input: crate::model::BatchReadOperation) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input);
            self.operations = Some(v);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchReadOperation>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadInput`](crate::input::BatchReadInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::BatchReadInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::BatchReadInput {
                directory_arn: self.directory_arn,
                operations: self.operations,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchReadInputOperationOutputAlias = crate::operation::BatchRead;
#[doc(hidden)]
pub type BatchReadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchReadInput {
    /// Consumes the builder and constructs an Operation<[`BatchRead`](crate::operation::BatchRead)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchRead,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchReadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/batchread")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::BatchReadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_13) = &_input.directory_arn {
                let formatted_14 = AsRef::<str>::as_ref(inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_15) = &_input.consistency_level {
                let formatted_16 = AsRef::<str>::as_ref(inner_15);
                if !formatted_16.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_16;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchReadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchReadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_read(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::BatchRead::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "BatchRead",
                    "clouddirectory",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchReadInput`](crate::input::BatchReadInput)
    pub fn builder() -> crate::input::batch_read_input::Builder {
        crate::input::batch_read_input::Builder::default()
    }
}

/// See [`BatchWriteInput`](crate::input::BatchWriteInput)
pub mod batch_write_input {
    /// A builder for [`BatchWriteInput`](crate::input::BatchWriteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) operations:
            std::option::Option<std::vec::Vec<crate::model::BatchWriteOperation>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, input: crate::model::BatchWriteOperation) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input);
            self.operations = Some(v);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperation>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteInput`](crate::input::BatchWriteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchWriteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchWriteInput {
                directory_arn: self.directory_arn,
                operations: self.operations,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchWriteInputOperationOutputAlias = crate::operation::BatchWrite;
#[doc(hidden)]
pub type BatchWriteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchWriteInput {
    /// Consumes the builder and constructs an Operation<[`BatchWrite`](crate::operation::BatchWrite)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchWrite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchWriteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/batchwrite")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::BatchWriteInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_17) = &_input.directory_arn {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchWriteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchWriteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_write(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchWrite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchWrite",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchWriteInput`](crate::input::BatchWriteInput)
    pub fn builder() -> crate::input::batch_write_input::Builder {
        crate::input::batch_write_input::Builder::default()
    }
}

/// See [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
pub mod create_directory_input {
    /// A builder for [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDirectoryInput {
                name: self.name,
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDirectoryInputOperationOutputAlias = crate::operation::CreateDirectory;
#[doc(hidden)]
pub type CreateDirectoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectory`](crate::operation::CreateDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory/create")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateDirectoryInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_19) = &_input.schema_arn {
                let formatted_20 = AsRef::<str>::as_ref(inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectory",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    pub fn builder() -> crate::input::create_directory_input::Builder {
        crate::input::create_directory_input::Builder::default()
    }
}

/// See [`CreateFacetInput`](crate::input::CreateFacetInput)
pub mod create_facet_input {
    /// A builder for [`CreateFacetInput`](crate::input::CreateFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        pub(crate) object_type: std::option::Option<crate::model::ObjectType>,
        pub(crate) facet_style: std::option::Option<crate::model::FacetStyle>,
    }
    impl Builder {
        /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the <code>Facet</code>.</p>
        pub fn attributes(mut self, input: crate::model::FacetAttribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes that are associated with the <code>Facet</code>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
        /// <ul>
        /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Index: Can be created with the Index API.</p> </li>
        /// </ul>
        pub fn object_type(mut self, input: crate::model::ObjectType) -> Self {
            self.object_type = Some(input);
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
        /// <ul>
        /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Index: Can be created with the Index API.</p> </li>
        /// </ul>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.object_type = input;
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn facet_style(mut self, input: crate::model::FacetStyle) -> Self {
            self.facet_style = Some(input);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn set_facet_style(
            mut self,
            input: std::option::Option<crate::model::FacetStyle>,
        ) -> Self {
            self.facet_style = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFacetInput`](crate::input::CreateFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
                attributes: self.attributes,
                object_type: self.object_type,
                facet_style: self.facet_style,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFacetInputOperationOutputAlias = crate::operation::CreateFacet;
#[doc(hidden)]
pub type CreateFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFacetInput {
    /// Consumes the builder and constructs an Operation<[`CreateFacet`](crate::operation::CreateFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet/create")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_21) = &_input.schema_arn {
                let formatted_22 = AsRef::<str>::as_ref(inner_21);
                if !formatted_22.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_22;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_facet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFacetInput`](crate::input::CreateFacetInput)
    pub fn builder() -> crate::input::create_facet_input::Builder {
        crate::input::create_facet_input::Builder::default()
    }
}

/// See [`CreateIndexInput`](crate::input::CreateIndexInput)
pub mod create_index_input {
    /// A builder for [`CreateIndexInput`](crate::input::CreateIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) ordered_indexed_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        pub(crate) is_unique: std::option::Option<bool>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Appends an item to `ordered_indexed_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_ordered_indexed_attribute_list`](Self::set_ordered_indexed_attribute_list).
        ///
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn ordered_indexed_attribute_list(mut self, input: crate::model::AttributeKey) -> Self {
            let mut v = self.ordered_indexed_attribute_list.unwrap_or_default();
            v.push(input);
            self.ordered_indexed_attribute_list = Some(v);
            self
        }
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn set_ordered_indexed_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        ) -> Self {
            self.ordered_indexed_attribute_list = input;
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn is_unique(mut self, input: bool) -> Self {
            self.is_unique = Some(input);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn set_is_unique(mut self, input: std::option::Option<bool>) -> Self {
            self.is_unique = input;
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIndexInput`](crate::input::CreateIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIndexInput {
                directory_arn: self.directory_arn,
                ordered_indexed_attribute_list: self.ordered_indexed_attribute_list,
                is_unique: self.is_unique.unwrap_or_default(),
                parent_reference: self.parent_reference,
                link_name: self.link_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIndexInputOperationOutputAlias = crate::operation::CreateIndex;
#[doc(hidden)]
pub type CreateIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIndexInput {
    /// Consumes the builder and constructs an Operation<[`CreateIndex`](crate::operation::CreateIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/index")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateIndexInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_23) = &_input.directory_arn {
                let formatted_24 = AsRef::<str>::as_ref(inner_23);
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIndex",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIndexInput`](crate::input::CreateIndexInput)
    pub fn builder() -> crate::input::create_index_input::Builder {
        crate::input::create_index_input::Builder::default()
    }
}

/// See [`CreateObjectInput`](crate::input::CreateObjectInput)
pub mod create_object_input {
    /// A builder for [`CreateObjectInput`](crate::input::CreateObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        pub(crate) object_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Appends an item to `schema_facets`.
        ///
        /// To override the contents of this collection use [`set_schema_facets`](Self::set_schema_facets).
        ///
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facets(mut self, input: crate::model::SchemaFacet) -> Self {
            let mut v = self.schema_facets.unwrap_or_default();
            v.push(input);
            self.schema_facets = Some(v);
            self
        }
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.schema_facets = input;
            self
        }
        /// Appends an item to `object_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.object_attribute_list.unwrap_or_default();
            v.push(input);
            self.object_attribute_list = Some(v);
            self
        }
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.object_attribute_list = input;
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateObjectInput`](crate::input::CreateObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateObjectInput {
                directory_arn: self.directory_arn,
                schema_facets: self.schema_facets,
                object_attribute_list: self.object_attribute_list,
                parent_reference: self.parent_reference,
                link_name: self.link_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateObjectInputOperationOutputAlias = crate::operation::CreateObject;
#[doc(hidden)]
pub type CreateObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateObjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateObject`](crate::operation::CreateObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_25) = &_input.directory_arn {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_object(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateObjectInput`](crate::input::CreateObjectInput)
    pub fn builder() -> crate::input::create_object_input::Builder {
        crate::input::create_object_input::Builder::default()
    }
}

/// See [`CreateSchemaInput`](crate::input::CreateSchemaInput)
pub mod create_schema_input {
    /// A builder for [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaInput`](crate::input::CreateSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSchemaInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type CreateSchemaInputOperationOutputAlias = crate::operation::CreateSchema;
#[doc(hidden)]
pub type CreateSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSchemaInput {
    /// Consumes the builder and constructs an Operation<[`CreateSchema`](crate::operation::CreateSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/create")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
}

/// See [`CreateTypedLinkFacetInput`](crate::input::CreateTypedLinkFacetInput)
pub mod create_typed_link_facet_input {
    /// A builder for [`CreateTypedLinkFacetInput`](crate::input::CreateTypedLinkFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) facet: std::option::Option<crate::model::TypedLinkFacet>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
        pub fn facet(mut self, input: crate::model::TypedLinkFacet) -> Self {
            self.facet = Some(input);
            self
        }
        /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
        pub fn set_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkFacet>,
        ) -> Self {
            self.facet = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTypedLinkFacetInput`](crate::input::CreateTypedLinkFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTypedLinkFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTypedLinkFacetInput {
                schema_arn: self.schema_arn,
                facet: self.facet,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTypedLinkFacetInputOperationOutputAlias = crate::operation::CreateTypedLinkFacet;
#[doc(hidden)]
pub type CreateTypedLinkFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTypedLinkFacetInput {
    /// Consumes the builder and constructs an Operation<[`CreateTypedLinkFacet`](crate::operation::CreateTypedLinkFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTypedLinkFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTypedLinkFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/facet/create"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateTypedLinkFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_27) = &_input.schema_arn {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTypedLinkFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTypedLinkFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_typed_link_facet(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTypedLinkFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTypedLinkFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTypedLinkFacetInput`](crate::input::CreateTypedLinkFacetInput)
    pub fn builder() -> crate::input::create_typed_link_facet_input::Builder {
        crate::input::create_typed_link_facet_input::Builder::default()
    }
}

/// See [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
pub mod delete_directory_input {
    /// A builder for [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory to delete.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory to delete.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDirectoryInput {
                directory_arn: self.directory_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectoryInputOperationOutputAlias = crate::operation::DeleteDirectory;
#[doc(hidden)]
pub type DeleteDirectoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectory`](crate::operation::DeleteDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteDirectoryInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_29) = &_input.directory_arn {
                let formatted_30 = AsRef::<str>::as_ref(inner_29);
                if !formatted_30.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_30;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectory",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    pub fn builder() -> crate::input::delete_directory_input::Builder {
        crate::input::delete_directory_input::Builder::default()
    }
}

/// See [`DeleteFacetInput`](crate::input::DeleteFacetInput)
pub mod delete_facet_input {
    /// A builder for [`DeleteFacetInput`](crate::input::DeleteFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFacetInput`](crate::input::DeleteFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFacetInputOperationOutputAlias = crate::operation::DeleteFacet;
#[doc(hidden)]
pub type DeleteFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFacetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFacet`](crate::operation::DeleteFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet/delete")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_31) = &_input.schema_arn {
                let formatted_32 = AsRef::<str>::as_ref(inner_31);
                if !formatted_32.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_32;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_facet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFacetInput`](crate::input::DeleteFacetInput)
    pub fn builder() -> crate::input::delete_facet_input::Builder {
        crate::input::delete_facet_input::Builder::default()
    }
}

/// See [`DeleteObjectInput`](crate::input::DeleteObjectInput)
pub mod delete_object_input {
    /// A builder for [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectInput`](crate::input::DeleteObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectInputOperationOutputAlias = crate::operation::DeleteObject;
#[doc(hidden)]
pub type DeleteObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObject`](crate::operation::DeleteObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/delete")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_33) = &_input.directory_arn {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_object(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
}

/// See [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
pub mod delete_schema_input {
    /// A builder for [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSchemaInput {
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSchemaInputOperationOutputAlias = crate::operation::DeleteSchema;
#[doc(hidden)]
pub type DeleteSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchema`](crate::operation::DeleteSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteSchemaInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_35) = &_input.schema_arn {
                let formatted_36 = AsRef::<str>::as_ref(inner_35);
                if !formatted_36.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_36;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
}

/// See [`DeleteTypedLinkFacetInput`](crate::input::DeleteTypedLinkFacetInput)
pub mod delete_typed_link_facet_input {
    /// A builder for [`DeleteTypedLinkFacetInput`](crate::input::DeleteTypedLinkFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTypedLinkFacetInput`](crate::input::DeleteTypedLinkFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTypedLinkFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTypedLinkFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTypedLinkFacetInputOperationOutputAlias = crate::operation::DeleteTypedLinkFacet;
#[doc(hidden)]
pub type DeleteTypedLinkFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTypedLinkFacetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTypedLinkFacet`](crate::operation::DeleteTypedLinkFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTypedLinkFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTypedLinkFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/facet/delete"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteTypedLinkFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_37) = &_input.schema_arn {
                let formatted_38 = AsRef::<str>::as_ref(inner_37);
                if !formatted_38.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_38;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTypedLinkFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTypedLinkFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_typed_link_facet(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTypedLinkFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTypedLinkFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTypedLinkFacetInput`](crate::input::DeleteTypedLinkFacetInput)
    pub fn builder() -> crate::input::delete_typed_link_facet_input::Builder {
        crate::input::delete_typed_link_facet_input::Builder::default()
    }
}

/// See [`DetachFromIndexInput`](crate::input::DetachFromIndexInput)
pub mod detach_from_index_input {
    /// A builder for [`DetachFromIndexInput`](crate::input::DetachFromIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachFromIndexInput`](crate::input::DetachFromIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachFromIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachFromIndexInput {
                directory_arn: self.directory_arn,
                index_reference: self.index_reference,
                target_reference: self.target_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachFromIndexInputOperationOutputAlias = crate::operation::DetachFromIndex;
#[doc(hidden)]
pub type DetachFromIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachFromIndexInput {
    /// Consumes the builder and constructs an Operation<[`DetachFromIndex`](crate::operation::DetachFromIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachFromIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachFromIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/index/detach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DetachFromIndexInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_39) = &_input.directory_arn {
                let formatted_40 = AsRef::<str>::as_ref(inner_39);
                if !formatted_40.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_40;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachFromIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachFromIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_from_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachFromIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachFromIndex",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachFromIndexInput`](crate::input::DetachFromIndexInput)
    pub fn builder() -> crate::input::detach_from_index_input::Builder {
        crate::input::detach_from_index_input::Builder::default()
    }
}

/// See [`DetachObjectInput`](crate::input::DetachObjectInput)
pub mod detach_object_input {
    /// A builder for [`DetachObjectInput`](crate::input::DetachObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The parent reference from which the object with the specified link name is detached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>The parent reference from which the object with the specified link name is detached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachObjectInput`](crate::input::DetachObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachObjectInput {
                directory_arn: self.directory_arn,
                parent_reference: self.parent_reference,
                link_name: self.link_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachObjectInputOperationOutputAlias = crate::operation::DetachObject;
#[doc(hidden)]
pub type DetachObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachObjectInput {
    /// Consumes the builder and constructs an Operation<[`DetachObject`](crate::operation::DetachObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/detach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DetachObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_41) = &_input.directory_arn {
                let formatted_42 = AsRef::<str>::as_ref(inner_41);
                if !formatted_42.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_42;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detach_object(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachObjectInput`](crate::input::DetachObjectInput)
    pub fn builder() -> crate::input::detach_object_input::Builder {
        crate::input::detach_object_input::Builder::default()
    }
}

/// See [`DetachPolicyInput`](crate::input::DetachPolicyInput)
pub mod detach_policy_input {
    /// A builder for [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachPolicyInput`](crate::input::DetachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachPolicyInput {
                directory_arn: self.directory_arn,
                policy_reference: self.policy_reference,
                object_reference: self.object_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachPolicyInputOperationOutputAlias = crate::operation::DetachPolicy;
#[doc(hidden)]
pub type DetachPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachPolicy`](crate::operation::DetachPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/policy/detach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DetachPolicyInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_43) = &_input.directory_arn {
                let formatted_44 = AsRef::<str>::as_ref(inner_43);
                if !formatted_44.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_44;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detach_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachPolicy",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
}

/// See [`DetachTypedLinkInput`](crate::input::DetachTypedLinkInput)
pub mod detach_typed_link_input {
    /// A builder for [`DetachTypedLinkInput`](crate::input::DetachTypedLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachTypedLinkInput`](crate::input::DetachTypedLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachTypedLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachTypedLinkInput {
                directory_arn: self.directory_arn,
                typed_link_specifier: self.typed_link_specifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachTypedLinkInputOperationOutputAlias = crate::operation::DetachTypedLink;
#[doc(hidden)]
pub type DetachTypedLinkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachTypedLinkInput {
    /// Consumes the builder and constructs an Operation<[`DetachTypedLink`](crate::operation::DetachTypedLink)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachTypedLink,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachTypedLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/typedlink/detach")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DetachTypedLinkInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_45) = &_input.directory_arn {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachTypedLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachTypedLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_typed_link(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachTypedLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachTypedLink",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachTypedLinkInput`](crate::input::DetachTypedLinkInput)
    pub fn builder() -> crate::input::detach_typed_link_input::Builder {
        crate::input::detach_typed_link_input::Builder::default()
    }
}

/// See [`DisableDirectoryInput`](crate::input::DisableDirectoryInput)
pub mod disable_directory_input {
    /// A builder for [`DisableDirectoryInput`](crate::input::DisableDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory to disable.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory to disable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDirectoryInput`](crate::input::DisableDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableDirectoryInput {
                directory_arn: self.directory_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableDirectoryInputOperationOutputAlias = crate::operation::DisableDirectory;
#[doc(hidden)]
pub type DisableDirectoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`DisableDirectory`](crate::operation::DisableDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableDirectory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory/disable")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DisableDirectoryInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_47) = &_input.directory_arn {
                let formatted_48 = AsRef::<str>::as_ref(inner_47);
                if !formatted_48.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_48;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableDirectory",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableDirectoryInput`](crate::input::DisableDirectoryInput)
    pub fn builder() -> crate::input::disable_directory_input::Builder {
        crate::input::disable_directory_input::Builder::default()
    }
}

/// See [`EnableDirectoryInput`](crate::input::EnableDirectoryInput)
pub mod enable_directory_input {
    /// A builder for [`EnableDirectoryInput`](crate::input::EnableDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory to enable.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory to enable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDirectoryInput`](crate::input::EnableDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableDirectoryInput {
                directory_arn: self.directory_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableDirectoryInputOperationOutputAlias = crate::operation::EnableDirectory;
#[doc(hidden)]
pub type EnableDirectoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`EnableDirectory`](crate::operation::EnableDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableDirectory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory/enable")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::EnableDirectoryInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_49) = &_input.directory_arn {
                let formatted_50 = AsRef::<str>::as_ref(inner_49);
                if !formatted_50.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_50;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableDirectory",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableDirectoryInput`](crate::input::EnableDirectoryInput)
    pub fn builder() -> crate::input::enable_directory_input::Builder {
        crate::input::enable_directory_input::Builder::default()
    }
}

/// See [`GetAppliedSchemaVersionInput`](crate::input::GetAppliedSchemaVersionInput)
pub mod get_applied_schema_version_input {
    /// A builder for [`GetAppliedSchemaVersionInput`](crate::input::GetAppliedSchemaVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the applied schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the applied schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppliedSchemaVersionInput`](crate::input::GetAppliedSchemaVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppliedSchemaVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppliedSchemaVersionInput {
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppliedSchemaVersionInputOperationOutputAlias =
    crate::operation::GetAppliedSchemaVersion;
#[doc(hidden)]
pub type GetAppliedSchemaVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppliedSchemaVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetAppliedSchemaVersion`](crate::operation::GetAppliedSchemaVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppliedSchemaVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppliedSchemaVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/schema/getappliedschema"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppliedSchemaVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppliedSchemaVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_applied_schema_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppliedSchemaVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppliedSchemaVersion",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppliedSchemaVersionInput`](crate::input::GetAppliedSchemaVersionInput)
    pub fn builder() -> crate::input::get_applied_schema_version_input::Builder {
        crate::input::get_applied_schema_version_input::Builder::default()
    }
}

/// See [`GetDirectoryInput`](crate::input::GetDirectoryInput)
pub mod get_directory_input {
    /// A builder for [`GetDirectoryInput`](crate::input::GetDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDirectoryInput`](crate::input::GetDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDirectoryInput {
                directory_arn: self.directory_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDirectoryInputOperationOutputAlias = crate::operation::GetDirectory;
#[doc(hidden)]
pub type GetDirectoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`GetDirectory`](crate::operation::GetDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDirectory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory/get")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetDirectoryInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_51) = &_input.directory_arn {
                let formatted_52 = AsRef::<str>::as_ref(inner_51);
                if !formatted_52.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_52;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDirectory",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDirectoryInput`](crate::input::GetDirectoryInput)
    pub fn builder() -> crate::input::get_directory_input::Builder {
        crate::input::get_directory_input::Builder::default()
    }
}

/// See [`GetFacetInput`](crate::input::GetFacetInput)
pub mod get_facet_input {
    /// A builder for [`GetFacetInput`](crate::input::GetFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFacetInput`](crate::input::GetFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFacetInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFacetInputOperationOutputAlias = crate::operation::GetFacet;
#[doc(hidden)]
pub type GetFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFacetInput {
    /// Consumes the builder and constructs an Operation<[`GetFacet`](crate::operation::GetFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_53) = &_input.schema_arn {
                let formatted_54 = AsRef::<str>::as_ref(inner_53);
                if !formatted_54.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_54;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_facet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFacet::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFacet",
                    "clouddirectory",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFacetInput`](crate::input::GetFacetInput)
    pub fn builder() -> crate::input::get_facet_input::Builder {
        crate::input::get_facet_input::Builder::default()
    }
}

/// See [`GetLinkAttributesInput`](crate::input::GetLinkAttributesInput)
pub mod get_link_attributes_input {
    /// A builder for [`GetLinkAttributesInput`](crate::input::GetLinkAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinkAttributesInput`](crate::input::GetLinkAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLinkAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLinkAttributesInput {
                directory_arn: self.directory_arn,
                typed_link_specifier: self.typed_link_specifier,
                attribute_names: self.attribute_names,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLinkAttributesInputOperationOutputAlias = crate::operation::GetLinkAttributes;
#[doc(hidden)]
pub type GetLinkAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLinkAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetLinkAttributes`](crate::operation::GetLinkAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLinkAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLinkAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/attributes/get"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetLinkAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_55) = &_input.directory_arn {
                let formatted_56 = AsRef::<str>::as_ref(inner_55);
                if !formatted_56.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_56;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLinkAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLinkAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_link_attributes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLinkAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLinkAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLinkAttributesInput`](crate::input::GetLinkAttributesInput)
    pub fn builder() -> crate::input::get_link_attributes_input::Builder {
        crate::input::get_link_attributes_input::Builder::default()
    }
}

/// See [`GetObjectAttributesInput`](crate::input::GetObjectAttributesInput)
pub mod get_object_attributes_input {
    /// A builder for [`GetObjectAttributesInput`](crate::input::GetObjectAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectAttributesInput`](crate::input::GetObjectAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectAttributesInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                consistency_level: self.consistency_level,
                schema_facet: self.schema_facet,
                attribute_names: self.attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectAttributesInputOperationOutputAlias = crate::operation::GetObjectAttributes;
#[doc(hidden)]
pub type GetObjectAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectAttributes`](crate::operation::GetObjectAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/object/attributes/get"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_57) = &_input.directory_arn {
                let formatted_58 = AsRef::<str>::as_ref(inner_57);
                if !formatted_58.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_58;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_59) = &_input.consistency_level {
                let formatted_60 = AsRef::<str>::as_ref(inner_59);
                if !formatted_60.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_60;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_object_attributes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectAttributesInput`](crate::input::GetObjectAttributesInput)
    pub fn builder() -> crate::input::get_object_attributes_input::Builder {
        crate::input::get_object_attributes_input::Builder::default()
    }
}

/// See [`GetObjectInformationInput`](crate::input::GetObjectInformationInput)
pub mod get_object_information_input {
    /// A builder for [`GetObjectInformationInput`](crate::input::GetObjectInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference to the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectInformationInput`](crate::input::GetObjectInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectInformationInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectInformationInputOperationOutputAlias = crate::operation::GetObjectInformation;
#[doc(hidden)]
pub type GetObjectInformationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectInformationInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectInformation`](crate::operation::GetObjectInformation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectInformation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/object/information"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectInformationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_61) = &_input.directory_arn {
                let formatted_62 = AsRef::<str>::as_ref(inner_61);
                if !formatted_62.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_62;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_63) = &_input.consistency_level {
                let formatted_64 = AsRef::<str>::as_ref(inner_63);
                if !formatted_64.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_64;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_object_information(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectInformation",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectInformationInput`](crate::input::GetObjectInformationInput)
    pub fn builder() -> crate::input::get_object_information_input::Builder {
        crate::input::get_object_information_input::Builder::default()
    }
}

/// See [`GetSchemaAsJsonInput`](crate::input::GetSchemaAsJsonInput)
pub mod get_schema_as_json_input {
    /// A builder for [`GetSchemaAsJsonInput`](crate::input::GetSchemaAsJsonInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaAsJsonInput`](crate::input::GetSchemaAsJsonInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSchemaAsJsonInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSchemaAsJsonInput {
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSchemaAsJsonInputOperationOutputAlias = crate::operation::GetSchemaAsJson;
#[doc(hidden)]
pub type GetSchemaAsJsonInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSchemaAsJsonInput {
    /// Consumes the builder and constructs an Operation<[`GetSchemaAsJson`](crate::operation::GetSchemaAsJson)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSchemaAsJson,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSchemaAsJsonInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/json")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetSchemaAsJsonInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_65) = &_input.schema_arn {
                let formatted_66 = AsRef::<str>::as_ref(inner_65);
                if !formatted_66.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_66;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSchemaAsJsonInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSchemaAsJsonInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSchemaAsJson::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSchemaAsJson",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSchemaAsJsonInput`](crate::input::GetSchemaAsJsonInput)
    pub fn builder() -> crate::input::get_schema_as_json_input::Builder {
        crate::input::get_schema_as_json_input::Builder::default()
    }
}

/// See [`GetTypedLinkFacetInformationInput`](crate::input::GetTypedLinkFacetInformationInput)
pub mod get_typed_link_facet_information_input {
    /// A builder for [`GetTypedLinkFacetInformationInput`](crate::input::GetTypedLinkFacetInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTypedLinkFacetInformationInput`](crate::input::GetTypedLinkFacetInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTypedLinkFacetInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTypedLinkFacetInformationInput {
                schema_arn: self.schema_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTypedLinkFacetInformationInputOperationOutputAlias =
    crate::operation::GetTypedLinkFacetInformation;
#[doc(hidden)]
pub type GetTypedLinkFacetInformationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetTypedLinkFacetInformationInput {
    /// Consumes the builder and constructs an Operation<[`GetTypedLinkFacetInformation`](crate::operation::GetTypedLinkFacetInformation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTypedLinkFacetInformation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTypedLinkFacetInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/facet/get"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetTypedLinkFacetInformationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_67) = &_input.schema_arn {
                let formatted_68 = AsRef::<str>::as_ref(inner_67);
                if !formatted_68.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_68;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTypedLinkFacetInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTypedLinkFacetInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_typed_link_facet_information(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTypedLinkFacetInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTypedLinkFacetInformation",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTypedLinkFacetInformationInput`](crate::input::GetTypedLinkFacetInformationInput)
    pub fn builder() -> crate::input::get_typed_link_facet_information_input::Builder {
        crate::input::get_typed_link_facet_information_input::Builder::default()
    }
}

/// See [`ListAppliedSchemaArnsInput`](crate::input::ListAppliedSchemaArnsInput)
pub mod list_applied_schema_arns_input {
    /// A builder for [`ListAppliedSchemaArnsInput`](crate::input::ListAppliedSchemaArnsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the directory you are listing.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory you are listing.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppliedSchemaArnsInput`](crate::input::ListAppliedSchemaArnsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppliedSchemaArnsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppliedSchemaArnsInput {
                directory_arn: self.directory_arn,
                schema_arn: self.schema_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppliedSchemaArnsInputOperationOutputAlias = crate::operation::ListAppliedSchemaArns;
#[doc(hidden)]
pub type ListAppliedSchemaArnsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppliedSchemaArnsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppliedSchemaArns`](crate::operation::ListAppliedSchemaArns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppliedSchemaArns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppliedSchemaArnsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/applied")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppliedSchemaArnsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppliedSchemaArnsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_applied_schema_arns(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppliedSchemaArns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppliedSchemaArns",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppliedSchemaArnsInput`](crate::input::ListAppliedSchemaArnsInput)
    pub fn builder() -> crate::input::list_applied_schema_arns_input::Builder {
        crate::input::list_applied_schema_arns_input::Builder::default()
    }
}

/// See [`ListAttachedIndicesInput`](crate::input::ListAttachedIndicesInput)
pub mod list_attached_indices_input {
    /// A builder for [`ListAttachedIndicesInput`](crate::input::ListAttachedIndicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedIndicesInput`](crate::input::ListAttachedIndicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttachedIndicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttachedIndicesInput {
                directory_arn: self.directory_arn,
                target_reference: self.target_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttachedIndicesInputOperationOutputAlias = crate::operation::ListAttachedIndices;
#[doc(hidden)]
pub type ListAttachedIndicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAttachedIndicesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttachedIndices`](crate::operation::ListAttachedIndices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttachedIndices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttachedIndicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/indices")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListAttachedIndicesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_69) = &_input.directory_arn {
                let formatted_70 = AsRef::<str>::as_ref(inner_69);
                if !formatted_70.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_70;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_71) = &_input.consistency_level {
                let formatted_72 = AsRef::<str>::as_ref(inner_71);
                if !formatted_72.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_72;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttachedIndicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttachedIndicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_attached_indices(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttachedIndices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttachedIndices",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttachedIndicesInput`](crate::input::ListAttachedIndicesInput)
    pub fn builder() -> crate::input::list_attached_indices_input::Builder {
        crate::input::list_attached_indices_input::Builder::default()
    }
}

/// See [`ListDevelopmentSchemaArnsInput`](crate::input::ListDevelopmentSchemaArnsInput)
pub mod list_development_schema_arns_input {
    /// A builder for [`ListDevelopmentSchemaArnsInput`](crate::input::ListDevelopmentSchemaArnsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevelopmentSchemaArnsInput`](crate::input::ListDevelopmentSchemaArnsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevelopmentSchemaArnsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevelopmentSchemaArnsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevelopmentSchemaArnsInputOperationOutputAlias =
    crate::operation::ListDevelopmentSchemaArns;
#[doc(hidden)]
pub type ListDevelopmentSchemaArnsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDevelopmentSchemaArnsInput {
    /// Consumes the builder and constructs an Operation<[`ListDevelopmentSchemaArns`](crate::operation::ListDevelopmentSchemaArns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevelopmentSchemaArns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevelopmentSchemaArnsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/schema/development"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevelopmentSchemaArnsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevelopmentSchemaArnsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_development_schema_arns(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevelopmentSchemaArns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevelopmentSchemaArns",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevelopmentSchemaArnsInput`](crate::input::ListDevelopmentSchemaArnsInput)
    pub fn builder() -> crate::input::list_development_schema_arns_input::Builder {
        crate::input::list_development_schema_arns_input::Builder::default()
    }
}

/// See [`ListDirectoriesInput`](crate::input::ListDirectoriesInput)
pub mod list_directories_input {
    /// A builder for [`ListDirectoriesInput`](crate::input::ListDirectoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DirectoryState>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
        pub fn state(mut self, input: crate::model::DirectoryState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DirectoryState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDirectoriesInput`](crate::input::ListDirectoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDirectoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDirectoriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                state: self.state,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDirectoriesInputOperationOutputAlias = crate::operation::ListDirectories;
#[doc(hidden)]
pub type ListDirectoriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDirectoriesInput {
    /// Consumes the builder and constructs an Operation<[`ListDirectories`](crate::operation::ListDirectories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDirectories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDirectoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/directory/list")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDirectoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDirectoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_directories(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDirectories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDirectories",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDirectoriesInput`](crate::input::ListDirectoriesInput)
    pub fn builder() -> crate::input::list_directories_input::Builder {
        crate::input::list_directories_input::Builder::default()
    }
}

/// See [`ListFacetAttributesInput`](crate::input::ListFacetAttributesInput)
pub mod list_facet_attributes_input {
    /// A builder for [`ListFacetAttributesInput`](crate::input::ListFacetAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFacetAttributesInput`](crate::input::ListFacetAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFacetAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFacetAttributesInput {
                schema_arn: self.schema_arn,
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFacetAttributesInputOperationOutputAlias = crate::operation::ListFacetAttributes;
#[doc(hidden)]
pub type ListFacetAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFacetAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ListFacetAttributes`](crate::operation::ListFacetAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFacetAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFacetAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet/attributes")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListFacetAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_73) = &_input.schema_arn {
                let formatted_74 = AsRef::<str>::as_ref(inner_73);
                if !formatted_74.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_74;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFacetAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFacetAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_facet_attributes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFacetAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFacetAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFacetAttributesInput`](crate::input::ListFacetAttributesInput)
    pub fn builder() -> crate::input::list_facet_attributes_input::Builder {
        crate::input::list_facet_attributes_input::Builder::default()
    }
}

/// See [`ListFacetNamesInput`](crate::input::ListFacetNamesInput)
pub mod list_facet_names_input {
    /// A builder for [`ListFacetNamesInput`](crate::input::ListFacetNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFacetNamesInput`](crate::input::ListFacetNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFacetNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFacetNamesInput {
                schema_arn: self.schema_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFacetNamesInputOperationOutputAlias = crate::operation::ListFacetNames;
#[doc(hidden)]
pub type ListFacetNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFacetNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListFacetNames`](crate::operation::ListFacetNames)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFacetNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFacetNamesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet/list")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListFacetNamesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_75) = &_input.schema_arn {
                let formatted_76 = AsRef::<str>::as_ref(inner_75);
                if !formatted_76.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_76;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFacetNamesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFacetNamesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_facet_names(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFacetNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFacetNames",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFacetNamesInput`](crate::input::ListFacetNamesInput)
    pub fn builder() -> crate::input::list_facet_names_input::Builder {
        crate::input::list_facet_names_input::Builder::default()
    }
}

/// See [`ListIncomingTypedLinksInput`](crate::input::ListIncomingTypedLinksInput)
pub mod list_incoming_typed_links_input {
    /// A builder for [`ListIncomingTypedLinksInput`](crate::input::ListIncomingTypedLinksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) filter_attribute_ranges:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        pub(crate) filter_typed_link:
            std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `filter_attribute_ranges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            let mut v = self.filter_attribute_ranges.unwrap_or_default();
            v.push(input);
            self.filter_attribute_ranges = Some(v);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.filter_attribute_ranges = input;
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.filter_typed_link = Some(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.filter_typed_link = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIncomingTypedLinksInput`](crate::input::ListIncomingTypedLinksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIncomingTypedLinksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIncomingTypedLinksInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                filter_attribute_ranges: self.filter_attribute_ranges,
                filter_typed_link: self.filter_typed_link,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIncomingTypedLinksInputOperationOutputAlias = crate::operation::ListIncomingTypedLinks;
#[doc(hidden)]
pub type ListIncomingTypedLinksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIncomingTypedLinksInput {
    /// Consumes the builder and constructs an Operation<[`ListIncomingTypedLinks`](crate::operation::ListIncomingTypedLinks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIncomingTypedLinks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIncomingTypedLinksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/incoming"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListIncomingTypedLinksInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_77) = &_input.directory_arn {
                let formatted_78 = AsRef::<str>::as_ref(inner_77);
                if !formatted_78.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_78;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIncomingTypedLinksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIncomingTypedLinksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_incoming_typed_links(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIncomingTypedLinks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIncomingTypedLinks",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIncomingTypedLinksInput`](crate::input::ListIncomingTypedLinksInput)
    pub fn builder() -> crate::input::list_incoming_typed_links_input::Builder {
        crate::input::list_incoming_typed_links_input::Builder::default()
    }
}

/// See [`ListIndexInput`](crate::input::ListIndexInput)
pub mod list_index_input {
    /// A builder for [`ListIndexInput`](crate::input::ListIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) ranges_on_indexed_values:
            std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Appends an item to `ranges_on_indexed_values`.
        ///
        /// To override the contents of this collection use [`set_ranges_on_indexed_values`](Self::set_ranges_on_indexed_values).
        ///
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn ranges_on_indexed_values(
            mut self,
            input: crate::model::ObjectAttributeRange,
        ) -> Self {
            let mut v = self.ranges_on_indexed_values.unwrap_or_default();
            v.push(input);
            self.ranges_on_indexed_values = Some(v);
            self
        }
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn set_ranges_on_indexed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        ) -> Self {
            self.ranges_on_indexed_values = input;
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIndexInput`](crate::input::ListIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListIndexInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListIndexInput {
                directory_arn: self.directory_arn,
                ranges_on_indexed_values: self.ranges_on_indexed_values,
                index_reference: self.index_reference,
                max_results: self.max_results,
                next_token: self.next_token,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIndexInputOperationOutputAlias = crate::operation::ListIndex;
#[doc(hidden)]
pub type ListIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIndexInput {
    /// Consumes the builder and constructs an Operation<[`ListIndex`](crate::operation::ListIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/index/targets")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListIndexInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_79) = &_input.directory_arn {
                let formatted_80 = AsRef::<str>::as_ref(inner_79);
                if !formatted_80.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_80;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_81) = &_input.consistency_level {
                let formatted_82 = AsRef::<str>::as_ref(inner_81);
                if !formatted_82.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_82;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListIndex::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListIndex",
                    "clouddirectory",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIndexInput`](crate::input::ListIndexInput)
    pub fn builder() -> crate::input::list_index_input::Builder {
        crate::input::list_index_input::Builder::default()
    }
}

/// See [`ListManagedSchemaArnsInput`](crate::input::ListManagedSchemaArnsInput)
pub mod list_managed_schema_arns_input {
    /// A builder for [`ListManagedSchemaArnsInput`](crate::input::ListManagedSchemaArnsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedSchemaArnsInput`](crate::input::ListManagedSchemaArnsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListManagedSchemaArnsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListManagedSchemaArnsInput {
                schema_arn: self.schema_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListManagedSchemaArnsInputOperationOutputAlias = crate::operation::ListManagedSchemaArns;
#[doc(hidden)]
pub type ListManagedSchemaArnsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListManagedSchemaArnsInput {
    /// Consumes the builder and constructs an Operation<[`ListManagedSchemaArns`](crate::operation::ListManagedSchemaArns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListManagedSchemaArns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListManagedSchemaArnsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/managed")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListManagedSchemaArnsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListManagedSchemaArnsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_managed_schema_arns(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListManagedSchemaArns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListManagedSchemaArns",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListManagedSchemaArnsInput`](crate::input::ListManagedSchemaArnsInput)
    pub fn builder() -> crate::input::list_managed_schema_arns_input::Builder {
        crate::input::list_managed_schema_arns_input::Builder::default()
    }
}

/// See [`ListObjectAttributesInput`](crate::input::ListObjectAttributesInput)
pub mod list_object_attributes_input {
    /// A builder for [`ListObjectAttributesInput`](crate::input::ListObjectAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
        pub(crate) facet_filter: std::option::Option<crate::model::SchemaFacet>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn facet_filter(mut self, input: crate::model::SchemaFacet) -> Self {
            self.facet_filter = Some(input);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn set_facet_filter(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.facet_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectAttributesInput`](crate::input::ListObjectAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectAttributesInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
                facet_filter: self.facet_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectAttributesInputOperationOutputAlias = crate::operation::ListObjectAttributes;
#[doc(hidden)]
pub type ListObjectAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectAttributes`](crate::operation::ListObjectAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/attributes")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_83) = &_input.directory_arn {
                let formatted_84 = AsRef::<str>::as_ref(inner_83);
                if !formatted_84.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_84;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_85) = &_input.consistency_level {
                let formatted_86 = AsRef::<str>::as_ref(inner_85);
                if !formatted_86.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_86;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_object_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectAttributesInput`](crate::input::ListObjectAttributesInput)
    pub fn builder() -> crate::input::list_object_attributes_input::Builder {
        crate::input::list_object_attributes_input::Builder::default()
    }
}

/// See [`ListObjectChildrenInput`](crate::input::ListObjectChildrenInput)
pub mod list_object_children_input {
    /// A builder for [`ListObjectChildrenInput`](crate::input::ListObjectChildrenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the object for which child objects are being listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object for which child objects are being listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectChildrenInput`](crate::input::ListObjectChildrenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectChildrenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectChildrenInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectChildrenInputOperationOutputAlias = crate::operation::ListObjectChildren;
#[doc(hidden)]
pub type ListObjectChildrenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectChildrenInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectChildren`](crate::operation::ListObjectChildren)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectChildren,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectChildrenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/children")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectChildrenInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_87) = &_input.directory_arn {
                let formatted_88 = AsRef::<str>::as_ref(inner_87);
                if !formatted_88.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_88;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_89) = &_input.consistency_level {
                let formatted_90 = AsRef::<str>::as_ref(inner_89);
                if !formatted_90.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_90;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectChildrenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectChildrenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_object_children(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectChildren::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectChildren",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectChildrenInput`](crate::input::ListObjectChildrenInput)
    pub fn builder() -> crate::input::list_object_children_input::Builder {
        crate::input::list_object_children_input::Builder::default()
    }
}

/// See [`ListObjectParentPathsInput`](crate::input::ListObjectParentPathsInput)
pub mod list_object_parent_paths_input {
    /// A builder for [`ListObjectParentPathsInput`](crate::input::ListObjectParentPathsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectParentPathsInput`](crate::input::ListObjectParentPathsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectParentPathsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectParentPathsInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectParentPathsInputOperationOutputAlias = crate::operation::ListObjectParentPaths;
#[doc(hidden)]
pub type ListObjectParentPathsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectParentPathsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectParentPaths`](crate::operation::ListObjectParentPaths)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectParentPaths,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectParentPathsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/object/parentpaths"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectParentPathsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_91) = &_input.directory_arn {
                let formatted_92 = AsRef::<str>::as_ref(inner_91);
                if !formatted_92.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_92;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectParentPathsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectParentPathsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_object_parent_paths(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectParentPaths::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectParentPaths",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectParentPathsInput`](crate::input::ListObjectParentPathsInput)
    pub fn builder() -> crate::input::list_object_parent_paths_input::Builder {
        crate::input::list_object_parent_paths_input::Builder::default()
    }
}

/// See [`ListObjectParentsInput`](crate::input::ListObjectParentsInput)
pub mod list_object_parents_input {
    /// A builder for [`ListObjectParentsInput`](crate::input::ListObjectParentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
        pub(crate) include_all_links_to_each_parent: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
        pub fn include_all_links_to_each_parent(mut self, input: bool) -> Self {
            self.include_all_links_to_each_parent = Some(input);
            self
        }
        /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
        pub fn set_include_all_links_to_each_parent(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_all_links_to_each_parent = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectParentsInput`](crate::input::ListObjectParentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectParentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectParentsInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
                include_all_links_to_each_parent: self
                    .include_all_links_to_each_parent
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectParentsInputOperationOutputAlias = crate::operation::ListObjectParents;
#[doc(hidden)]
pub type ListObjectParentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectParentsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectParents`](crate::operation::ListObjectParents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectParents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectParentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/parent")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectParentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_93) = &_input.directory_arn {
                let formatted_94 = AsRef::<str>::as_ref(inner_93);
                if !formatted_94.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_94;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_95) = &_input.consistency_level {
                let formatted_96 = AsRef::<str>::as_ref(inner_95);
                if !formatted_96.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_96;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectParentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectParentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_object_parents(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectParents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectParents",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectParentsInput`](crate::input::ListObjectParentsInput)
    pub fn builder() -> crate::input::list_object_parents_input::Builder {
        crate::input::list_object_parents_input::Builder::default()
    }
}

/// See [`ListObjectPoliciesInput`](crate::input::ListObjectPoliciesInput)
pub mod list_object_policies_input {
    /// A builder for [`ListObjectPoliciesInput`](crate::input::ListObjectPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectPoliciesInput`](crate::input::ListObjectPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectPoliciesInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectPoliciesInputOperationOutputAlias = crate::operation::ListObjectPolicies;
#[doc(hidden)]
pub type ListObjectPoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectPolicies`](crate::operation::ListObjectPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectPolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/policy")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectPoliciesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_97) = &_input.directory_arn {
                let formatted_98 = AsRef::<str>::as_ref(inner_97);
                if !formatted_98.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_98;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_99) = &_input.consistency_level {
                let formatted_100 = AsRef::<str>::as_ref(inner_99);
                if !formatted_100.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_100;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_object_policies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectPolicies",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectPoliciesInput`](crate::input::ListObjectPoliciesInput)
    pub fn builder() -> crate::input::list_object_policies_input::Builder {
        crate::input::list_object_policies_input::Builder::default()
    }
}

/// See [`ListOutgoingTypedLinksInput`](crate::input::ListOutgoingTypedLinksInput)
pub mod list_outgoing_typed_links_input {
    /// A builder for [`ListOutgoingTypedLinksInput`](crate::input::ListOutgoingTypedLinksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) filter_attribute_ranges:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        pub(crate) filter_typed_link:
            std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `filter_attribute_ranges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            let mut v = self.filter_attribute_ranges.unwrap_or_default();
            v.push(input);
            self.filter_attribute_ranges = Some(v);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.filter_attribute_ranges = input;
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.filter_typed_link = Some(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.filter_typed_link = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutgoingTypedLinksInput`](crate::input::ListOutgoingTypedLinksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOutgoingTypedLinksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOutgoingTypedLinksInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                filter_attribute_ranges: self.filter_attribute_ranges,
                filter_typed_link: self.filter_typed_link,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOutgoingTypedLinksInputOperationOutputAlias = crate::operation::ListOutgoingTypedLinks;
#[doc(hidden)]
pub type ListOutgoingTypedLinksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOutgoingTypedLinksInput {
    /// Consumes the builder and constructs an Operation<[`ListOutgoingTypedLinks`](crate::operation::ListOutgoingTypedLinks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOutgoingTypedLinks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOutgoingTypedLinksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/outgoing"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListOutgoingTypedLinksInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_101) = &_input.directory_arn {
                let formatted_102 = AsRef::<str>::as_ref(inner_101);
                if !formatted_102.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_102;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOutgoingTypedLinksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOutgoingTypedLinksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_outgoing_typed_links(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOutgoingTypedLinks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOutgoingTypedLinks",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOutgoingTypedLinksInput`](crate::input::ListOutgoingTypedLinksInput)
    pub fn builder() -> crate::input::list_outgoing_typed_links_input::Builder {
        crate::input::list_outgoing_typed_links_input::Builder::default()
    }
}

/// See [`ListPolicyAttachmentsInput`](crate::input::ListPolicyAttachmentsInput)
pub mod list_policy_attachments_input {
    /// A builder for [`ListPolicyAttachmentsInput`](crate::input::ListPolicyAttachmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, input: crate::model::ConsistencyLevel) -> Self {
            self.consistency_level = Some(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.consistency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyAttachmentsInput`](crate::input::ListPolicyAttachmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPolicyAttachmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPolicyAttachmentsInput {
                directory_arn: self.directory_arn,
                policy_reference: self.policy_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                consistency_level: self.consistency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPolicyAttachmentsInputOperationOutputAlias = crate::operation::ListPolicyAttachments;
#[doc(hidden)]
pub type ListPolicyAttachmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPolicyAttachmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicyAttachments`](crate::operation::ListPolicyAttachments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicyAttachments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPolicyAttachmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/policy/attachment")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListPolicyAttachmentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_103) = &_input.directory_arn {
                let formatted_104 = AsRef::<str>::as_ref(inner_103);
                if !formatted_104.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_104;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            if let Some(inner_105) = &_input.consistency_level {
                let formatted_106 = AsRef::<str>::as_ref(inner_105);
                if !formatted_106.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_106;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "consistency_level",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-consistency-level", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPolicyAttachmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPolicyAttachmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_policy_attachments(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicyAttachments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicyAttachments",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPolicyAttachmentsInput`](crate::input::ListPolicyAttachmentsInput)
    pub fn builder() -> crate::input::list_policy_attachments_input::Builder {
        crate::input::list_policy_attachments_input::Builder::default()
    }
}

/// See [`ListPublishedSchemaArnsInput`](crate::input::ListPublishedSchemaArnsInput)
pub mod list_published_schema_arns_input {
    /// A builder for [`ListPublishedSchemaArnsInput`](crate::input::ListPublishedSchemaArnsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublishedSchemaArnsInput`](crate::input::ListPublishedSchemaArnsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPublishedSchemaArnsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPublishedSchemaArnsInput {
                schema_arn: self.schema_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPublishedSchemaArnsInputOperationOutputAlias =
    crate::operation::ListPublishedSchemaArns;
#[doc(hidden)]
pub type ListPublishedSchemaArnsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPublishedSchemaArnsInput {
    /// Consumes the builder and constructs an Operation<[`ListPublishedSchemaArns`](crate::operation::ListPublishedSchemaArns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPublishedSchemaArns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPublishedSchemaArnsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/published")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPublishedSchemaArnsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPublishedSchemaArnsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_published_schema_arns(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPublishedSchemaArns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPublishedSchemaArns",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPublishedSchemaArnsInput`](crate::input::ListPublishedSchemaArnsInput)
    pub fn builder() -> crate::input::list_published_schema_arns_input::Builder {
        crate::input::list_published_schema_arns_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/tags")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTypedLinkFacetAttributesInput`](crate::input::ListTypedLinkFacetAttributesInput)
pub mod list_typed_link_facet_attributes_input {
    /// A builder for [`ListTypedLinkFacetAttributesInput`](crate::input::ListTypedLinkFacetAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypedLinkFacetAttributesInput`](crate::input::ListTypedLinkFacetAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTypedLinkFacetAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTypedLinkFacetAttributesInput {
                schema_arn: self.schema_arn,
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypedLinkFacetAttributesInputOperationOutputAlias =
    crate::operation::ListTypedLinkFacetAttributes;
#[doc(hidden)]
pub type ListTypedLinkFacetAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListTypedLinkFacetAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ListTypedLinkFacetAttributes`](crate::operation::ListTypedLinkFacetAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypedLinkFacetAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTypedLinkFacetAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/facet/attributes"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListTypedLinkFacetAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_107) = &_input.schema_arn {
                let formatted_108 = AsRef::<str>::as_ref(inner_107);
                if !formatted_108.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_108;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTypedLinkFacetAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTypedLinkFacetAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_typed_link_facet_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTypedLinkFacetAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTypedLinkFacetAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetAttributesInput`](crate::input::ListTypedLinkFacetAttributesInput)
    pub fn builder() -> crate::input::list_typed_link_facet_attributes_input::Builder {
        crate::input::list_typed_link_facet_attributes_input::Builder::default()
    }
}

/// See [`ListTypedLinkFacetNamesInput`](crate::input::ListTypedLinkFacetNamesInput)
pub mod list_typed_link_facet_names_input {
    /// A builder for [`ListTypedLinkFacetNamesInput`](crate::input::ListTypedLinkFacetNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypedLinkFacetNamesInput`](crate::input::ListTypedLinkFacetNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTypedLinkFacetNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTypedLinkFacetNamesInput {
                schema_arn: self.schema_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypedLinkFacetNamesInputOperationOutputAlias =
    crate::operation::ListTypedLinkFacetNames;
#[doc(hidden)]
pub type ListTypedLinkFacetNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTypedLinkFacetNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListTypedLinkFacetNames`](crate::operation::ListTypedLinkFacetNames)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypedLinkFacetNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTypedLinkFacetNamesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/facet/list"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListTypedLinkFacetNamesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_109) = &_input.schema_arn {
                let formatted_110 = AsRef::<str>::as_ref(inner_109);
                if !formatted_110.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_110;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTypedLinkFacetNamesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTypedLinkFacetNamesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_typed_link_facet_names(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTypedLinkFacetNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTypedLinkFacetNames",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetNamesInput`](crate::input::ListTypedLinkFacetNamesInput)
    pub fn builder() -> crate::input::list_typed_link_facet_names_input::Builder {
        crate::input::list_typed_link_facet_names_input::Builder::default()
    }
}

/// See [`LookupPolicyInput`](crate::input::LookupPolicyInput)
pub mod lookup_policy_input {
    /// A builder for [`LookupPolicyInput`](crate::input::LookupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupPolicyInput`](crate::input::LookupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LookupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LookupPolicyInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type LookupPolicyInputOperationOutputAlias = crate::operation::LookupPolicy;
#[doc(hidden)]
pub type LookupPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl LookupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`LookupPolicy`](crate::operation::LookupPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LookupPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LookupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/policy/lookup")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::LookupPolicyInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_111) = &_input.directory_arn {
                let formatted_112 = AsRef::<str>::as_ref(inner_111);
                if !formatted_112.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_112;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LookupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LookupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_lookup_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LookupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LookupPolicy",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LookupPolicyInput`](crate::input::LookupPolicyInput)
    pub fn builder() -> crate::input::lookup_policy_input::Builder {
        crate::input::lookup_policy_input::Builder::default()
    }
}

/// See [`PublishSchemaInput`](crate::input::PublishSchemaInput)
pub mod publish_schema_input {
    /// A builder for [`PublishSchemaInput`](crate::input::PublishSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) development_schema_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
        pub fn development_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.development_schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.development_schema_arn = input;
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishSchemaInput`](crate::input::PublishSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishSchemaInput {
                development_schema_arn: self.development_schema_arn,
                version: self.version,
                minor_version: self.minor_version,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishSchemaInputOperationOutputAlias = crate::operation::PublishSchema;
#[doc(hidden)]
pub type PublishSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PublishSchemaInput {
    /// Consumes the builder and constructs an Operation<[`PublishSchema`](crate::operation::PublishSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PublishSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/publish")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PublishSchemaInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_113) = &_input.development_schema_arn {
                let formatted_114 = AsRef::<str>::as_ref(inner_113);
                if !formatted_114.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_114;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "development_schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PublishSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PublishSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_publish_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PublishSchemaInput`](crate::input::PublishSchemaInput)
    pub fn builder() -> crate::input::publish_schema_input::Builder {
        crate::input::publish_schema_input::Builder::default()
    }
}

/// See [`PutSchemaFromJsonInput`](crate::input::PutSchemaFromJsonInput)
pub mod put_schema_from_json_input {
    /// A builder for [`PutSchemaFromJsonInput`](crate::input::PutSchemaFromJsonInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the schema to update.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSchemaFromJsonInput`](crate::input::PutSchemaFromJsonInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSchemaFromJsonInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSchemaFromJsonInput {
                schema_arn: self.schema_arn,
                document: self.document,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSchemaFromJsonInputOperationOutputAlias = crate::operation::PutSchemaFromJson;
#[doc(hidden)]
pub type PutSchemaFromJsonInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutSchemaFromJsonInput {
    /// Consumes the builder and constructs an Operation<[`PutSchemaFromJson`](crate::operation::PutSchemaFromJson)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSchemaFromJson,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSchemaFromJsonInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/json")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutSchemaFromJsonInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_115) = &_input.schema_arn {
                let formatted_116 = AsRef::<str>::as_ref(inner_115);
                if !formatted_116.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_116;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSchemaFromJsonInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSchemaFromJsonInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_schema_from_json(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSchemaFromJson::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSchemaFromJson",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSchemaFromJsonInput`](crate::input::PutSchemaFromJsonInput)
    pub fn builder() -> crate::input::put_schema_from_json_input::Builder {
        crate::input::put_schema_from_json_input::Builder::default()
    }
}

/// See [`RemoveFacetFromObjectInput`](crate::input::RemoveFacetFromObjectInput)
pub mod remove_facet_from_object_input {
    /// A builder for [`RemoveFacetFromObjectInput`](crate::input::RemoveFacetFromObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFacetFromObjectInput`](crate::input::RemoveFacetFromObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFacetFromObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFacetFromObjectInput {
                directory_arn: self.directory_arn,
                schema_facet: self.schema_facet,
                object_reference: self.object_reference,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFacetFromObjectInputOperationOutputAlias = crate::operation::RemoveFacetFromObject;
#[doc(hidden)]
pub type RemoveFacetFromObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveFacetFromObjectInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFacetFromObject`](crate::operation::RemoveFacetFromObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFacetFromObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFacetFromObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/object/facets/delete"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::RemoveFacetFromObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_117) = &_input.directory_arn {
                let formatted_118 = AsRef::<str>::as_ref(inner_117);
                if !formatted_118.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_118;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFacetFromObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFacetFromObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_facet_from_object(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFacetFromObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFacetFromObject",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFacetFromObjectInput`](crate::input::RemoveFacetFromObjectInput)
    pub fn builder() -> crate::input::remove_facet_from_object_input::Builder {
        crate::input::remove_facet_from_object_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/tags/add")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/tags/remove")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFacetInput`](crate::input::UpdateFacetInput)
pub mod update_facet_input {
    /// A builder for [`UpdateFacetInput`](crate::input::UpdateFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::FacetAttributeUpdate>>,
        pub(crate) object_type: std::option::Option<crate::model::ObjectType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
        pub fn attribute_updates(mut self, input: crate::model::FacetAttributeUpdate) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn object_type(mut self, input: crate::model::ObjectType) -> Self {
            self.object_type = Some(input);
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.object_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFacetInput`](crate::input::UpdateFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
                attribute_updates: self.attribute_updates,
                object_type: self.object_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFacetInputOperationOutputAlias = crate::operation::UpdateFacet;
#[doc(hidden)]
pub type UpdateFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFacetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFacet`](crate::operation::UpdateFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/facet")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_119) = &_input.schema_arn {
                let formatted_120 = AsRef::<str>::as_ref(inner_119);
                if !formatted_120.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_120;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_facet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFacetInput`](crate::input::UpdateFacetInput)
    pub fn builder() -> crate::input::update_facet_input::Builder {
        crate::input::update_facet_input::Builder::default()
    }
}

/// See [`UpdateLinkAttributesInput`](crate::input::UpdateLinkAttributesInput)
pub mod update_link_attributes_input {
    /// A builder for [`UpdateLinkAttributesInput`](crate::input::UpdateLinkAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::LinkAttributeUpdate) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLinkAttributesInput`](crate::input::UpdateLinkAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLinkAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLinkAttributesInput {
                directory_arn: self.directory_arn,
                typed_link_specifier: self.typed_link_specifier,
                attribute_updates: self.attribute_updates,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLinkAttributesInputOperationOutputAlias = crate::operation::UpdateLinkAttributes;
#[doc(hidden)]
pub type UpdateLinkAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLinkAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLinkAttributes`](crate::operation::UpdateLinkAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLinkAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLinkAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/typedlink/attributes/update"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateLinkAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_121) = &_input.directory_arn {
                let formatted_122 = AsRef::<str>::as_ref(inner_121);
                if !formatted_122.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_122;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLinkAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLinkAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_link_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLinkAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLinkAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLinkAttributesInput`](crate::input::UpdateLinkAttributesInput)
    pub fn builder() -> crate::input::update_link_attributes_input::Builder {
        crate::input::update_link_attributes_input::Builder::default()
    }
}

/// See [`UpdateObjectAttributesInput`](crate::input::UpdateObjectAttributesInput)
pub mod update_object_attributes_input {
    /// A builder for [`UpdateObjectAttributesInput`](crate::input::UpdateObjectAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::ObjectAttributeUpdate) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateObjectAttributesInput`](crate::input::UpdateObjectAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateObjectAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateObjectAttributesInput {
                directory_arn: self.directory_arn,
                object_reference: self.object_reference,
                attribute_updates: self.attribute_updates,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateObjectAttributesInputOperationOutputAlias = crate::operation::UpdateObjectAttributes;
#[doc(hidden)]
pub type UpdateObjectAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateObjectAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateObjectAttributes`](crate::operation::UpdateObjectAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateObjectAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateObjectAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/object/update")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateObjectAttributesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_123) = &_input.directory_arn {
                let formatted_124 = AsRef::<str>::as_ref(inner_123);
                if !formatted_124.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_124;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "directory_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateObjectAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateObjectAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_object_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateObjectAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateObjectAttributes",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateObjectAttributesInput`](crate::input::UpdateObjectAttributesInput)
    pub fn builder() -> crate::input::update_object_attributes_input::Builder {
        crate::input::update_object_attributes_input::Builder::default()
    }
}

/// See [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
pub mod update_schema_input {
    /// A builder for [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSchemaInput {
                schema_arn: self.schema_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSchemaInputOperationOutputAlias = crate::operation::UpdateSchema;
#[doc(hidden)]
pub type UpdateSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSchemaInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSchema`](crate::operation::UpdateSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/schema/update")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateSchemaInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_125) = &_input.schema_arn {
                let formatted_126 = AsRef::<str>::as_ref(inner_125);
                if !formatted_126.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_126;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    pub fn builder() -> crate::input::update_schema_input::Builder {
        crate::input::update_schema_input::Builder::default()
    }
}

/// See [`UpdateTypedLinkFacetInput`](crate::input::UpdateTypedLinkFacetInput)
pub mod update_typed_link_facet_input {
    /// A builder for [`UpdateTypedLinkFacetInput`](crate::input::UpdateTypedLinkFacetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkFacetAttributeUpdate>>,
        pub(crate) identity_attribute_order:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>Attributes update structure.</p>
        pub fn attribute_updates(
            mut self,
            input: crate::model::TypedLinkFacetAttributeUpdate,
        ) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>Attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkFacetAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Appends an item to `identity_attribute_order`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_order`](Self::set_identity_attribute_order).
        ///
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn identity_attribute_order(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_attribute_order.unwrap_or_default();
            v.push(input.into());
            self.identity_attribute_order = Some(v);
            self
        }
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_identity_attribute_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_attribute_order = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTypedLinkFacetInput`](crate::input::UpdateTypedLinkFacetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTypedLinkFacetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTypedLinkFacetInput {
                schema_arn: self.schema_arn,
                name: self.name,
                attribute_updates: self.attribute_updates,
                identity_attribute_order: self.identity_attribute_order,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTypedLinkFacetInputOperationOutputAlias = crate::operation::UpdateTypedLinkFacet;
#[doc(hidden)]
pub type UpdateTypedLinkFacetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTypedLinkFacetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTypedLinkFacet`](crate::operation::UpdateTypedLinkFacet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTypedLinkFacet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTypedLinkFacetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/amazonclouddirectory/2017-01-11/typedlink/facet")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateTypedLinkFacetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_127) = &_input.schema_arn {
                let formatted_128 = AsRef::<str>::as_ref(inner_127);
                if !formatted_128.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_128;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "schema_arn",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-data-partition", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTypedLinkFacetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTypedLinkFacetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_typed_link_facet(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTypedLinkFacet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTypedLinkFacet",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTypedLinkFacetInput`](crate::input::UpdateTypedLinkFacetInput)
    pub fn builder() -> crate::input::update_typed_link_facet_input::Builder {
        crate::input::update_typed_link_facet_input::Builder::default()
    }
}

/// See [`UpgradeAppliedSchemaInput`](crate::input::UpgradeAppliedSchemaInput)
pub mod upgrade_applied_schema_input {
    /// A builder for [`UpgradeAppliedSchemaInput`](crate::input::UpgradeAppliedSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) published_schema_arn: std::option::Option<std::string::String>,
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_schema_arn = Some(input.into());
            self
        }
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.published_schema_arn = input;
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeAppliedSchemaInput`](crate::input::UpgradeAppliedSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpgradeAppliedSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpgradeAppliedSchemaInput {
                published_schema_arn: self.published_schema_arn,
                directory_arn: self.directory_arn,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpgradeAppliedSchemaInputOperationOutputAlias = crate::operation::UpgradeAppliedSchema;
#[doc(hidden)]
pub type UpgradeAppliedSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpgradeAppliedSchemaInput {
    /// Consumes the builder and constructs an Operation<[`UpgradeAppliedSchema`](crate::operation::UpgradeAppliedSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpgradeAppliedSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpgradeAppliedSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/schema/upgradeapplied"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpgradeAppliedSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpgradeAppliedSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upgrade_applied_schema(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpgradeAppliedSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpgradeAppliedSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpgradeAppliedSchemaInput`](crate::input::UpgradeAppliedSchemaInput)
    pub fn builder() -> crate::input::upgrade_applied_schema_input::Builder {
        crate::input::upgrade_applied_schema_input::Builder::default()
    }
}

/// See [`UpgradePublishedSchemaInput`](crate::input::UpgradePublishedSchemaInput)
pub mod upgrade_published_schema_input {
    /// A builder for [`UpgradePublishedSchemaInput`](crate::input::UpgradePublishedSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) development_schema_arn: std::option::Option<std::string::String>,
        pub(crate) published_schema_arn: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn development_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.development_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.development_schema_arn = input;
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.published_schema_arn = input;
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradePublishedSchemaInput`](crate::input::UpgradePublishedSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpgradePublishedSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpgradePublishedSchemaInput {
                development_schema_arn: self.development_schema_arn,
                published_schema_arn: self.published_schema_arn,
                minor_version: self.minor_version,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpgradePublishedSchemaInputOperationOutputAlias = crate::operation::UpgradePublishedSchema;
#[doc(hidden)]
pub type UpgradePublishedSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpgradePublishedSchemaInput {
    /// Consumes the builder and constructs an Operation<[`UpgradePublishedSchema`](crate::operation::UpgradePublishedSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpgradePublishedSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpgradePublishedSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/amazonclouddirectory/2017-01-11/schema/upgradepublished"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpgradePublishedSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpgradePublishedSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upgrade_published_schema(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpgradePublishedSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpgradePublishedSchema",
            "clouddirectory",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpgradePublishedSchemaInput`](crate::input::UpgradePublishedSchemaInput)
    pub fn builder() -> crate::input::upgrade_published_schema_input::Builder {
        crate::input::upgrade_published_schema_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradePublishedSchemaInput {
    /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
    pub development_schema_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the published schema to be upgraded.</p>
    pub published_schema_arn: std::option::Option<std::string::String>,
    /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
    pub dry_run: bool,
}
impl UpgradePublishedSchemaInput {
    /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
    pub fn development_schema_arn(&self) -> std::option::Option<&str> {
        self.development_schema_arn.as_deref()
    }
    /// <p>The ARN of the published schema to be upgraded.</p>
    pub fn published_schema_arn(&self) -> std::option::Option<&str> {
        self.published_schema_arn.as_deref()
    }
    /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for UpgradePublishedSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradePublishedSchemaInput");
        formatter.field("development_schema_arn", &self.development_schema_arn);
        formatter.field("published_schema_arn", &self.published_schema_arn);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeAppliedSchemaInput {
    /// <p>The revision of the published schema to upgrade the directory to.</p>
    pub published_schema_arn: std::option::Option<std::string::String>,
    /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
    pub dry_run: bool,
}
impl UpgradeAppliedSchemaInput {
    /// <p>The revision of the published schema to upgrade the directory to.</p>
    pub fn published_schema_arn(&self) -> std::option::Option<&str> {
        self.published_schema_arn.as_deref()
    }
    /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for UpgradeAppliedSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeAppliedSchemaInput");
        formatter.field("published_schema_arn", &self.published_schema_arn);
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the typed link facet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Attributes update structure.</p>
    pub attribute_updates:
        std::option::Option<std::vec::Vec<crate::model::TypedLinkFacetAttributeUpdate>>,
    /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub identity_attribute_order: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The unique name of the typed link facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Attributes update structure.</p>
    pub fn attribute_updates(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkFacetAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
    /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn identity_attribute_order(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_attribute_order.as_deref()
    }
}
impl std::fmt::Debug for UpdateTypedLinkFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTypedLinkFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.field("identity_attribute_order", &self.identity_attribute_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSchemaInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The attributes update structure.</p>
    pub attribute_updates: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
}
impl UpdateObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The attributes update structure.</p>
    pub fn attribute_updates(&self) -> std::option::Option<&[crate::model::ObjectAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
}
impl std::fmt::Debug for UpdateObjectAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateObjectAttributesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLinkAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    /// <p>The attributes update structure.</p>
    pub attribute_updates: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
}
impl UpdateLinkAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
    /// <p>The attributes update structure.</p>
    pub fn attribute_updates(&self) -> std::option::Option<&[crate::model::LinkAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
}
impl std::fmt::Debug for UpdateLinkAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLinkAttributesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
    pub attribute_updates: std::option::Option<std::vec::Vec<crate::model::FacetAttributeUpdate>>,
    /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
    pub object_type: std::option::Option<crate::model::ObjectType>,
}
impl UpdateFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>List of attributes that need to be updated in a given schema <code>Facet</code>. Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update operation to perform. </p>
    pub fn attribute_updates(&self) -> std::option::Option<&[crate::model::FacetAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
    /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
    pub fn object_type(&self) -> std::option::Option<&crate::model::ObjectType> {
        self.object_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.field("object_type", &self.object_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys of the tag that need to be removed from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys of the tag that need to be removed from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag key-value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFacetFromObjectInput {
    /// <p>The ARN of the directory in which the object resides.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>A reference to the object to remove the facet from.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl RemoveFacetFromObjectInput {
    /// <p>The ARN of the directory in which the object resides.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The facet to remove. See <code>SchemaFacet</code> for details.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>A reference to the object to remove the facet from.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for RemoveFacetFromObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFacetFromObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSchemaFromJsonInput {
    /// <p>The ARN of the schema to update.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The replacement JSON schema.</p>
    pub document: std::option::Option<std::string::String>,
}
impl PutSchemaFromJsonInput {
    /// <p>The ARN of the schema to update.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The replacement JSON schema.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for PutSchemaFromJsonInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSchemaFromJsonInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("document", &self.document);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishSchemaInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
    pub development_schema_arn: std::option::Option<std::string::String>,
    /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
    pub name: std::option::Option<std::string::String>,
}
impl PublishSchemaInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see <code>arns</code>.</p>
    pub fn development_schema_arn(&self) -> std::option::Option<&str> {
        self.development_schema_arn.as_deref()
    }
    /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>The new name under which the schema will be published. If this is not provided, the development schema is considered.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PublishSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishSchemaInput");
        formatter.field("development_schema_arn", &self.development_schema_arn);
        formatter.field("version", &self.version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Reference that identifies the object whose policies will be looked up.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
}
impl LookupPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Reference that identifies the object whose policies will be looked up.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for LookupPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupPolicyInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypedLinkFacetNamesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTypedLinkFacetNamesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTypedLinkFacetNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypedLinkFacetNamesInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypedLinkFacetAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the typed link facet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTypedLinkFacetAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The unique name of the typed link facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTypedLinkFacetAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypedLinkFacetAttributesInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The pagination token. This is for future use. Currently pagination is not supported for tagging.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublishedSchemaArnsInput {
    /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPublishedSchemaArnsInput {
    /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPublishedSchemaArnsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublishedSchemaArnsInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyAttachmentsInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListPolicyAttachmentsInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListPolicyAttachmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyAttachmentsInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutgoingTypedLinksInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub filter_attribute_ranges:
        std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
    /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
    pub filter_typed_link: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The consistency level to execute the request at.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListOutgoingTypedLinksInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub fn filter_attribute_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkAttributeRange]> {
        self.filter_attribute_ranges.as_deref()
    }
    /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
    pub fn filter_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.filter_typed_link.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The consistency level to execute the request at.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListOutgoingTypedLinksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutgoingTypedLinksInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("filter_attribute_ranges", &self.filter_attribute_ranges);
        formatter.field("filter_typed_link", &self.filter_typed_link);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectPoliciesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Reference that identifies the object for which policies will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListObjectPoliciesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Reference that identifies the object for which policies will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListObjectPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectPoliciesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectParentsInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the object for which parent objects are being listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
    pub include_all_links_to_each_parent: bool,
}
impl ListObjectParentsInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the object for which parent objects are being listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
    /// <p>When set to True, returns all <code>ListObjectParentsResponse$ParentLinks</code>. There could be multiple links between a parent-child pair.</p>
    pub fn include_all_links_to_each_parent(&self) -> bool {
        self.include_all_links_to_each_parent
    }
}
impl std::fmt::Debug for ListObjectParentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectParentsInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.field(
            "include_all_links_to_each_parent",
            &self.include_all_links_to_each_parent,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectParentPathsInput {
    /// <p>The ARN of the directory to which the parent path applies.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the object whose parent paths are listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListObjectParentPathsInput {
    /// <p>The ARN of the directory to which the parent path applies.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the object whose parent paths are listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListObjectParentPathsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectParentPathsInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectChildrenInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the object for which child objects are being listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListObjectChildrenInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the object for which child objects are being listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListObjectChildrenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectChildrenInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
    pub facet_filter: std::option::Option<crate::model::SchemaFacet>,
}
impl ListObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
    /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
    pub fn facet_filter(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.facet_filter.as_ref()
    }
}
impl std::fmt::Debug for ListObjectAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectAttributesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.field("facet_filter", &self.facet_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedSchemaArnsInput {
    /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListManagedSchemaArnsInput {
    /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListManagedSchemaArnsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedSchemaArnsInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIndexInput {
    /// <p>The ARN of the directory that the index exists in.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the ranges of indexed values that you want to query.</p>
    pub ranges_on_indexed_values:
        std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
    /// <p>The reference to the index to list.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The consistency level to execute the request at.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListIndexInput {
    /// <p>The ARN of the directory that the index exists in.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Specifies the ranges of indexed values that you want to query.</p>
    pub fn ranges_on_indexed_values(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectAttributeRange]> {
        self.ranges_on_indexed_values.as_deref()
    }
    /// <p>The reference to the index to list.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The consistency level to execute the request at.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIndexInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("ranges_on_indexed_values", &self.ranges_on_indexed_values);
        formatter.field("index_reference", &self.index_reference);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIncomingTypedLinksInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub filter_attribute_ranges:
        std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
    /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
    pub filter_typed_link: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The consistency level to execute the request at.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListIncomingTypedLinksInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed links.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub fn filter_attribute_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkAttributeRange]> {
        self.filter_attribute_ranges.as_deref()
    }
    /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
    pub fn filter_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.filter_typed_link.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The consistency level to execute the request at.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListIncomingTypedLinksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIncomingTypedLinksInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("filter_attribute_ranges", &self.filter_attribute_ranges);
        formatter.field("filter_typed_link", &self.filter_typed_link);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFacetNamesInput {
    /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFacetNamesInput {
    /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFacetNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFacetNamesInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFacetAttributesInput {
    /// <p>The ARN of the schema where the facet resides.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet whose attributes will be retrieved.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFacetAttributesInput {
    /// <p>The ARN of the schema where the facet resides.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet whose attributes will be retrieved.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFacetAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFacetAttributesInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDirectoriesInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
    pub state: std::option::Option<crate::model::DirectoryState>,
}
impl ListDirectoriesInput {
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or Deleted.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DirectoryState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ListDirectoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDirectoriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevelopmentSchemaArnsInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDevelopmentSchemaArnsInput {
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDevelopmentSchemaArnsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevelopmentSchemaArnsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedIndicesInput {
    /// <p>The ARN of the directory.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference to the object that has indices attached.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The consistency level to use for this operation.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl ListAttachedIndicesInput {
    /// <p>The ARN of the directory.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference to the object that has indices attached.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The consistency level to use for this operation.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for ListAttachedIndicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedIndicesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("target_reference", &self.target_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppliedSchemaArnsInput {
    /// <p>The ARN of the directory you are listing.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppliedSchemaArnsInput {
    /// <p>The ARN of the directory you are listing.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppliedSchemaArnsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppliedSchemaArnsInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTypedLinkFacetInformationInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the typed link facet.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetTypedLinkFacetInformationInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The unique name of the typed link facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetTypedLinkFacetInformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTypedLinkFacetInformationInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaAsJsonInput {
    /// <p>The ARN of the schema to retrieve.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl GetSchemaAsJsonInput {
    /// <p>The ARN of the schema to retrieve.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for GetSchemaAsJsonInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaAsJsonInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectInformationInput {
    /// <p>The ARN of the directory being retrieved.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference to the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The consistency level at which to retrieve the object information.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl GetObjectInformationInput {
    /// <p>The ARN of the directory being retrieved.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference to the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The consistency level at which to retrieve the object information.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for GetObjectInformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectInformationInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The consistency level at which to retrieve the attributes on an object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
    /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>List of attribute names whose values will be retrieved.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetObjectAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The consistency level at which to retrieve the attributes on an object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
    /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>List of attribute names whose values will be retrieved.</p>
    pub fn attribute_names(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_names.as_deref()
    }
}
impl std::fmt::Debug for GetObjectAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectAttributesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinkAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    /// <p>A list of attribute names whose values will be retrieved.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl GetLinkAttributesInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <code>arns</code> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
    /// <p>A list of attribute names whose values will be retrieved.</p>
    pub fn attribute_names(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_names.as_deref()
    }
    /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for GetLinkAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinkAttributesInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet to retrieve.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet to retrieve.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDirectoryInput {
    /// <p>The ARN of the directory.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl GetDirectoryInput {
    /// <p>The ARN of the directory.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for GetDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDirectoryInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppliedSchemaVersionInput {
    /// <p>The ARN of the applied schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl GetAppliedSchemaVersionInput {
    /// <p>The ARN of the applied schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for GetAppliedSchemaVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppliedSchemaVersionInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDirectoryInput {
    /// <p>The ARN of the directory to enable.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl EnableDirectoryInput {
    /// <p>The ARN of the directory to enable.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for EnableDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDirectoryInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDirectoryInput {
    /// <p>The ARN of the directory to disable.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl DisableDirectoryInput {
    /// <p>The ARN of the directory to disable.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDirectoryInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachTypedLinkInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Used to accept a typed link specifier as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
}
impl DetachTypedLinkInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Used to accept a typed link specifier as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
}
impl std::fmt::Debug for DetachTypedLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachTypedLinkInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Reference that identifies the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Reference that identifies the object whose policy object will be detached.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl DetachPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Reference that identifies the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>Reference that identifies the object whose policy object will be detached.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for DetachPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPolicyInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The parent reference from which the object with the specified link name is detached.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The link name associated with the object that needs to be detached.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl DetachObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The parent reference from which the object with the specified link name is detached.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The link name associated with the object that needs to be detached.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for DetachObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachFromIndexInput {
    /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference to the index object.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>A reference to the object being detached from the index.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
}
impl DetachFromIndexInput {
    /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist in.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference to the index object.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>A reference to the object being detached from the index.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
}
impl std::fmt::Debug for DetachFromIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachFromIndexInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("index_reference", &self.index_reference);
        formatter.field("target_reference", &self.target_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the typed link facet.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The unique name of the typed link facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTypedLinkFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTypedLinkFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl DeleteSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference that identifies the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl DeleteObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference that identifies the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for DeleteObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Facet</code>. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryInput {
    /// <p>The ARN of the directory to delete.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl DeleteDirectoryInput {
    /// <p>The ARN of the directory to delete.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
    pub facet: std::option::Option<crate::model::TypedLinkFacet>,
}
impl CreateTypedLinkFacetInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p> <code>Facet</code> structure that is associated with the typed link facet.</p>
    pub fn facet(&self) -> std::option::Option<&crate::model::TypedLinkFacet> {
        self.facet.as_ref()
    }
}
impl std::fmt::Debug for CreateTypedLinkFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTypedLinkFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("facet", &self.facet);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaInput {
    /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateSchemaInput {
    /// <p>The name that is associated with the schema. This is unique to each account and in each region.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
    pub schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
    /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
    pub object_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>If specified, the parent reference to which this object will be attached.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of link that is used to attach this object to a parent.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl CreateObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> in which the object will be created. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <code>SchemaFacet</code> for details.</p>
    pub fn schema_facets(&self) -> std::option::Option<&[crate::model::SchemaFacet]> {
        self.schema_facets.as_deref()
    }
    /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map value.</p>
    pub fn object_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.object_attribute_list.as_deref()
    }
    /// <p>If specified, the parent reference to which this object will be attached.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The name of link that is used to attach this object to a parent.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for CreateObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("schema_facets", &self.schema_facets);
        formatter.field("object_attribute_list", &self.object_attribute_list);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIndexInput {
    /// <p>The ARN of the directory where the index should be created.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
    pub ordered_indexed_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
    /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
    pub is_unique: bool,
    /// <p>A reference to the parent object that contains the index object.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of the link between the parent object and the index object.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl CreateIndexInput {
    /// <p>The ARN of the directory where the index should be created.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
    pub fn ordered_indexed_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKey]> {
        self.ordered_indexed_attribute_list.as_deref()
    }
    /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
    pub fn is_unique(&self) -> bool {
        self.is_unique
    }
    /// <p>A reference to the parent object that contains the index object.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The name of the link between the parent object and the index object.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for CreateIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIndexInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field(
            "ordered_indexed_attribute_list",
            &self.ordered_indexed_attribute_list,
        );
        formatter.field("is_unique", &self.is_unique);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFacetInput {
    /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The attributes that are associated with the <code>Facet</code>.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
    /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
    /// <ul>
    /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Index: Can be created with the Index API.</p> </li>
    /// </ul>
    pub object_type: std::option::Option<crate::model::ObjectType>,
    /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
    pub facet_style: std::option::Option<crate::model::FacetStyle>,
}
impl CreateFacetInput {
    /// <p>The schema ARN in which the new <code>Facet</code> will be created. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the <code>Facet</code>, which is unique for a given schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The attributes that are associated with the <code>Facet</code>.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::FacetAttribute]> {
        self.attributes.as_deref()
    }
    /// <p>Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
    /// <ul>
    /// <li> <p>Node: Can have multiple children but one parent.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Leaf node: Cannot have children but can have multiple parents.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Policy: Allows you to store a policy document and policy type. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Index: Can be created with the Index API.</p> </li>
    /// </ul>
    pub fn object_type(&self) -> std::option::Option<&crate::model::ObjectType> {
        self.object_type.as_ref()
    }
    /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
    pub fn facet_style(&self) -> std::option::Option<&crate::model::FacetStyle> {
        self.facet_style.as_ref()
    }
}
impl std::fmt::Debug for CreateFacetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFacetInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("object_type", &self.object_type);
        formatter.field("facet_style", &self.facet_style);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryInput {
    /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl CreateDirectoryInput {
    /// <p>The name of the <code>Directory</code>. Should be unique per account, per region.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the data <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryInput");
        formatter.field("name", &self.name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A list of operations that are part of the batch.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperation>>,
}
impl BatchWriteInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A list of operations that are part of the batch.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::BatchWriteOperation]> {
        self.operations.as_deref()
    }
}
impl std::fmt::Debug for BatchWriteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("operations", &self.operations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A list of operations that are part of the batch.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::BatchReadOperation>>,
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub consistency_level: std::option::Option<crate::model::ConsistencyLevel>,
}
impl BatchReadInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code>. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A list of operations that are part of the batch.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::BatchReadOperation]> {
        self.operations.as_deref()
    }
    /// <p>Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object.</p>
    pub fn consistency_level(&self) -> std::option::Option<&crate::model::ConsistencyLevel> {
        self.consistency_level.as_ref()
    }
}
impl std::fmt::Debug for BatchReadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("operations", &self.operations);
        formatter.field("consistency_level", &self.consistency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachTypedLinkInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub source_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub target_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>A set of attributes that are associated with the typed link.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
}
impl AttachTypedLinkInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub fn source_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.source_object_reference.as_ref()
    }
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub fn target_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_object_reference.as_ref()
    }
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub fn typed_link_facet(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.typed_link_facet.as_ref()
    }
    /// <p>A set of attributes that are associated with the typed link.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeNameAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for AttachTypedLinkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachTypedLinkInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("source_object_reference", &self.source_object_reference);
        formatter.field("target_object_reference", &self.target_object_reference);
        formatter.field("typed_link_facet", &self.typed_link_facet);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachToIndexInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>A reference to the index that you are attaching the object to.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>A reference to the object that you are attaching to the index.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
}
impl AttachToIndexInput {
    /// <p>The Amazon Resource Name (ARN) of the directory where the object and index exist.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>A reference to the index that you are attaching the object to.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>A reference to the object that you are attaching to the index.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
}
impl std::fmt::Debug for AttachToIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachToIndexInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("index_reference", &self.index_reference);
        formatter.field("target_reference", &self.target_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The reference that is associated with the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The reference that identifies the object to which the policy will be attached.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl AttachPolicyInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The reference that is associated with the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>The reference that identifies the object to which the policy will be attached.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for AttachPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPolicyInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachObjectInput {
    /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The parent object reference.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The child object reference to be attached to the object.</p>
    pub child_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The link name with which the child object is attached to the parent.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl AttachObjectInput {
    /// <p>Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where both objects reside. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The parent object reference.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The child object reference to be attached to the object.</p>
    pub fn child_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.child_reference.as_ref()
    }
    /// <p>The link name with which the child object is attached to the parent.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for AttachObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("child_reference", &self.child_reference);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplySchemaInput {
    /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
    pub published_schema_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl ApplySchemaInput {
    /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see <code>arns</code>.</p>
    pub fn published_schema_arn(&self) -> std::option::Option<&str> {
        self.published_schema_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> into which the schema is copied. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for ApplySchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplySchemaInput");
        formatter.field("published_schema_arn", &self.published_schema_arn);
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFacetToObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>Attributes on the facet that you are adding to the object.</p>
    pub object_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>A reference to the object you are adding the specified facet to.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl AddFacetToObjectInput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the <code>Directory</code> where the object resides. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>Identifiers for the facet that you are adding to the object. See <code>SchemaFacet</code> for details.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>Attributes on the facet that you are adding to the object.</p>
    pub fn object_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.object_attribute_list.as_deref()
    }
    /// <p>A reference to the object you are adding the specified facet to.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for AddFacetToObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFacetToObjectInput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("object_attribute_list", &self.object_attribute_list);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
