// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A typed link facet attribute update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkFacetAttributeUpdate {
    /// <p>The attribute to update.</p>
    pub attribute: std::option::Option<crate::model::TypedLinkAttributeDefinition>,
    /// <p>The action to perform when updating the attribute.</p>
    pub action: std::option::Option<crate::model::UpdateActionType>,
}
impl TypedLinkFacetAttributeUpdate {
    /// <p>The attribute to update.</p>
    pub fn attribute(&self) -> std::option::Option<&crate::model::TypedLinkAttributeDefinition> {
        self.attribute.as_ref()
    }
    /// <p>The action to perform when updating the attribute.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::UpdateActionType> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for TypedLinkFacetAttributeUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkFacetAttributeUpdate");
        formatter.field("attribute", &self.attribute);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`TypedLinkFacetAttributeUpdate`](crate::model::TypedLinkFacetAttributeUpdate)
pub mod typed_link_facet_attribute_update {
    /// A builder for [`TypedLinkFacetAttributeUpdate`](crate::model::TypedLinkFacetAttributeUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::TypedLinkAttributeDefinition>,
        pub(crate) action: std::option::Option<crate::model::UpdateActionType>,
    }
    impl Builder {
        /// <p>The attribute to update.</p>
        pub fn attribute(mut self, input: crate::model::TypedLinkAttributeDefinition) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to update.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::TypedLinkAttributeDefinition>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The action to perform when updating the attribute.</p>
        pub fn action(mut self, input: crate::model::UpdateActionType) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to perform when updating the attribute.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateActionType>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkFacetAttributeUpdate`](crate::model::TypedLinkFacetAttributeUpdate)
        pub fn build(self) -> crate::model::TypedLinkFacetAttributeUpdate {
            crate::model::TypedLinkFacetAttributeUpdate {
                attribute: self.attribute,
                action: self.action,
            }
        }
    }
}
impl TypedLinkFacetAttributeUpdate {
    /// Creates a new builder-style object to manufacture [`TypedLinkFacetAttributeUpdate`](crate::model::TypedLinkFacetAttributeUpdate)
    pub fn builder() -> crate::model::typed_link_facet_attribute_update::Builder {
        crate::model::typed_link_facet_attribute_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateActionType {
    #[allow(missing_docs)] // documentation missing in model
    CreateOrUpdate,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateActionType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_OR_UPDATE" => UpdateActionType::CreateOrUpdate,
            "DELETE" => UpdateActionType::Delete,
            other => UpdateActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateActionType::from(s))
    }
}
impl UpdateActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateActionType::CreateOrUpdate => "CREATE_OR_UPDATE",
            UpdateActionType::Delete => "DELETE",
            UpdateActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE_OR_UPDATE", "DELETE"]
    }
}
impl AsRef<str> for UpdateActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A typed link attribute definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkAttributeDefinition {
    /// <p>The unique name of the typed link attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the attribute.</p>
    pub r#type: std::option::Option<crate::model::FacetAttributeType>,
    /// <p>The default value of the attribute (if configured).</p>
    pub default_value: std::option::Option<crate::model::TypedAttributeValue>,
    /// <p>Whether the attribute is mutable or not.</p>
    pub is_immutable: bool,
    /// <p>Validation rules that are attached to the attribute definition.</p>
    pub rules:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Rule>>,
    /// <p>The required behavior of the <code>TypedLinkAttributeDefinition</code>.</p>
    pub required_behavior: std::option::Option<crate::model::RequiredAttributeBehavior>,
}
impl TypedLinkAttributeDefinition {
    /// <p>The unique name of the typed link attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the attribute.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FacetAttributeType> {
        self.r#type.as_ref()
    }
    /// <p>The default value of the attribute (if configured).</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.default_value.as_ref()
    }
    /// <p>Whether the attribute is mutable or not.</p>
    pub fn is_immutable(&self) -> bool {
        self.is_immutable
    }
    /// <p>Validation rules that are attached to the attribute definition.</p>
    pub fn rules(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Rule>>
    {
        self.rules.as_ref()
    }
    /// <p>The required behavior of the <code>TypedLinkAttributeDefinition</code>.</p>
    pub fn required_behavior(
        &self,
    ) -> std::option::Option<&crate::model::RequiredAttributeBehavior> {
        self.required_behavior.as_ref()
    }
}
impl std::fmt::Debug for TypedLinkAttributeDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkAttributeDefinition");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("default_value", &self.default_value);
        formatter.field("is_immutable", &self.is_immutable);
        formatter.field("rules", &self.rules);
        formatter.field("required_behavior", &self.required_behavior);
        formatter.finish()
    }
}
/// See [`TypedLinkAttributeDefinition`](crate::model::TypedLinkAttributeDefinition)
pub mod typed_link_attribute_definition {
    /// A builder for [`TypedLinkAttributeDefinition`](crate::model::TypedLinkAttributeDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FacetAttributeType>,
        pub(crate) default_value: std::option::Option<crate::model::TypedAttributeValue>,
        pub(crate) is_immutable: std::option::Option<bool>,
        pub(crate) rules:
            std::option::Option<std::collections::HashMap<std::string::String, crate::model::Rule>>,
        pub(crate) required_behavior: std::option::Option<crate::model::RequiredAttributeBehavior>,
    }
    impl Builder {
        /// <p>The unique name of the typed link attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the attribute.</p>
        pub fn r#type(mut self, input: crate::model::FacetAttributeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the attribute.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FacetAttributeType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The default value of the attribute (if configured).</p>
        pub fn default_value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>The default value of the attribute (if configured).</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>Whether the attribute is mutable or not.</p>
        pub fn is_immutable(mut self, input: bool) -> Self {
            self.is_immutable = Some(input);
            self
        }
        /// <p>Whether the attribute is mutable or not.</p>
        pub fn set_is_immutable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_immutable = input;
            self
        }
        /// Adds a key-value pair to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Validation rules that are attached to the attribute definition.</p>
        pub fn rules(mut self, k: impl Into<std::string::String>, v: crate::model::Rule) -> Self {
            let mut hash_map = self.rules.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.rules = Some(hash_map);
            self
        }
        /// <p>Validation rules that are attached to the attribute definition.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Rule>,
            >,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The required behavior of the <code>TypedLinkAttributeDefinition</code>.</p>
        pub fn required_behavior(mut self, input: crate::model::RequiredAttributeBehavior) -> Self {
            self.required_behavior = Some(input);
            self
        }
        /// <p>The required behavior of the <code>TypedLinkAttributeDefinition</code>.</p>
        pub fn set_required_behavior(
            mut self,
            input: std::option::Option<crate::model::RequiredAttributeBehavior>,
        ) -> Self {
            self.required_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkAttributeDefinition`](crate::model::TypedLinkAttributeDefinition)
        pub fn build(self) -> crate::model::TypedLinkAttributeDefinition {
            crate::model::TypedLinkAttributeDefinition {
                name: self.name,
                r#type: self.r#type,
                default_value: self.default_value,
                is_immutable: self.is_immutable.unwrap_or_default(),
                rules: self.rules,
                required_behavior: self.required_behavior,
            }
        }
    }
}
impl TypedLinkAttributeDefinition {
    /// Creates a new builder-style object to manufacture [`TypedLinkAttributeDefinition`](crate::model::TypedLinkAttributeDefinition)
    pub fn builder() -> crate::model::typed_link_attribute_definition::Builder {
        crate::model::typed_link_attribute_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequiredAttributeBehavior {
    #[allow(missing_docs)] // documentation missing in model
    NotRequired,
    #[allow(missing_docs)] // documentation missing in model
    RequiredAlways,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequiredAttributeBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NOT_REQUIRED" => RequiredAttributeBehavior::NotRequired,
            "REQUIRED_ALWAYS" => RequiredAttributeBehavior::RequiredAlways,
            other => RequiredAttributeBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequiredAttributeBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequiredAttributeBehavior::from(s))
    }
}
impl RequiredAttributeBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequiredAttributeBehavior::NotRequired => "NOT_REQUIRED",
            RequiredAttributeBehavior::RequiredAlways => "REQUIRED_ALWAYS",
            RequiredAttributeBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_REQUIRED", "REQUIRED_ALWAYS"]
    }
}
impl AsRef<str> for RequiredAttributeBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an Amazon Resource Name (ARN) and parameters that are associated with the rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>The type of attribute validation rule.</p>
    pub r#type: std::option::Option<crate::model::RuleType>,
    /// <p>The minimum and maximum parameters that are associated with the rule.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Rule {
    /// <p>The type of attribute validation rule.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RuleType> {
        self.r#type.as_ref()
    }
    /// <p>The minimum and maximum parameters that are associated with the rule.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("r#type", &self.r#type);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RuleType>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of attribute validation rule.</p>
        pub fn r#type(mut self, input: crate::model::RuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of attribute validation rule.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleType>) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The minimum and maximum parameters that are associated with the rule.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The minimum and maximum parameters that are associated with the rule.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                r#type: self.r#type,
                parameters: self.parameters,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleType {
    #[allow(missing_docs)] // documentation missing in model
    BinaryLength,
    #[allow(missing_docs)] // documentation missing in model
    NumberComparison,
    #[allow(missing_docs)] // documentation missing in model
    StringFromSet,
    #[allow(missing_docs)] // documentation missing in model
    StringLength,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleType {
    fn from(s: &str) -> Self {
        match s {
            "BINARY_LENGTH" => RuleType::BinaryLength,
            "NUMBER_COMPARISON" => RuleType::NumberComparison,
            "STRING_FROM_SET" => RuleType::StringFromSet,
            "STRING_LENGTH" => RuleType::StringLength,
            other => RuleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleType::from(s))
    }
}
impl RuleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleType::BinaryLength => "BINARY_LENGTH",
            RuleType::NumberComparison => "NUMBER_COMPARISON",
            RuleType::StringFromSet => "STRING_FROM_SET",
            RuleType::StringLength => "STRING_LENGTH",
            RuleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BINARY_LENGTH",
            "NUMBER_COMPARISON",
            "STRING_FROM_SET",
            "STRING_LENGTH",
        ]
    }
}
impl AsRef<str> for RuleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the data for a typed attribute. You can set one, and only one, of the elements. Each attribute in an item is a name-value pair. Attributes have a single value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TypedAttributeValue {
    /// <p>A binary data value.</p>
    BinaryValue(aws_smithy_types::Blob),
    /// <p>A Boolean data value.</p>
    BooleanValue(bool),
    /// <p>A date and time value.</p>
    DatetimeValue(aws_smithy_types::DateTime),
    /// <p>A number data value.</p>
    NumberValue(std::string::String),
    /// <p>A string data value.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl TypedAttributeValue {
    /// Tries to convert the enum instance into [`BinaryValue`](crate::model::TypedAttributeValue::BinaryValue), extracting the inner [`Blob`](aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_binary_value(&self) -> std::result::Result<&aws_smithy_types::Blob, &Self> {
        if let TypedAttributeValue::BinaryValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BinaryValue`](crate::model::TypedAttributeValue::BinaryValue).
    pub fn is_binary_value(&self) -> bool {
        self.as_binary_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::TypedAttributeValue::BooleanValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&bool, &Self> {
        if let TypedAttributeValue::BooleanValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::TypedAttributeValue::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DatetimeValue`](crate::model::TypedAttributeValue::DatetimeValue), extracting the inner [`DateTime`](aws_smithy_types::DateTime).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_datetime_value(&self) -> std::result::Result<&aws_smithy_types::DateTime, &Self> {
        if let TypedAttributeValue::DatetimeValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`DatetimeValue`](crate::model::TypedAttributeValue::DatetimeValue).
    pub fn is_datetime_value(&self) -> bool {
        self.as_datetime_value().is_ok()
    }
    /// Tries to convert the enum instance into [`NumberValue`](crate::model::TypedAttributeValue::NumberValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_number_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let TypedAttributeValue::NumberValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`NumberValue`](crate::model::TypedAttributeValue::NumberValue).
    pub fn is_number_value(&self) -> bool {
        self.as_number_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::TypedAttributeValue::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let TypedAttributeValue::StringValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::TypedAttributeValue::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FacetAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    Variant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FacetAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "BINARY" => FacetAttributeType::Binary,
            "BOOLEAN" => FacetAttributeType::Boolean,
            "DATETIME" => FacetAttributeType::Datetime,
            "NUMBER" => FacetAttributeType::Number,
            "STRING" => FacetAttributeType::String,
            "VARIANT" => FacetAttributeType::Variant,
            other => FacetAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FacetAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FacetAttributeType::from(s))
    }
}
impl FacetAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FacetAttributeType::Binary => "BINARY",
            FacetAttributeType::Boolean => "BOOLEAN",
            FacetAttributeType::Datetime => "DATETIME",
            FacetAttributeType::Number => "NUMBER",
            FacetAttributeType::String => "STRING",
            FacetAttributeType::Variant => "VARIANT",
            FacetAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BINARY", "BOOLEAN", "DATETIME", "NUMBER", "STRING", "VARIANT",
        ]
    }
}
impl AsRef<str> for FacetAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Structure that contains attribute update information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectAttributeUpdate {
    /// <p>The key of the attribute being updated.</p>
    pub object_attribute_key: std::option::Option<crate::model::AttributeKey>,
    /// <p>The action to perform as part of the attribute update.</p>
    pub object_attribute_action: std::option::Option<crate::model::ObjectAttributeAction>,
}
impl ObjectAttributeUpdate {
    /// <p>The key of the attribute being updated.</p>
    pub fn object_attribute_key(&self) -> std::option::Option<&crate::model::AttributeKey> {
        self.object_attribute_key.as_ref()
    }
    /// <p>The action to perform as part of the attribute update.</p>
    pub fn object_attribute_action(
        &self,
    ) -> std::option::Option<&crate::model::ObjectAttributeAction> {
        self.object_attribute_action.as_ref()
    }
}
impl std::fmt::Debug for ObjectAttributeUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectAttributeUpdate");
        formatter.field("object_attribute_key", &self.object_attribute_key);
        formatter.field("object_attribute_action", &self.object_attribute_action);
        formatter.finish()
    }
}
/// See [`ObjectAttributeUpdate`](crate::model::ObjectAttributeUpdate)
pub mod object_attribute_update {
    /// A builder for [`ObjectAttributeUpdate`](crate::model::ObjectAttributeUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_attribute_key: std::option::Option<crate::model::AttributeKey>,
        pub(crate) object_attribute_action:
            std::option::Option<crate::model::ObjectAttributeAction>,
    }
    impl Builder {
        /// <p>The key of the attribute being updated.</p>
        pub fn object_attribute_key(mut self, input: crate::model::AttributeKey) -> Self {
            self.object_attribute_key = Some(input);
            self
        }
        /// <p>The key of the attribute being updated.</p>
        pub fn set_object_attribute_key(
            mut self,
            input: std::option::Option<crate::model::AttributeKey>,
        ) -> Self {
            self.object_attribute_key = input;
            self
        }
        /// <p>The action to perform as part of the attribute update.</p>
        pub fn object_attribute_action(
            mut self,
            input: crate::model::ObjectAttributeAction,
        ) -> Self {
            self.object_attribute_action = Some(input);
            self
        }
        /// <p>The action to perform as part of the attribute update.</p>
        pub fn set_object_attribute_action(
            mut self,
            input: std::option::Option<crate::model::ObjectAttributeAction>,
        ) -> Self {
            self.object_attribute_action = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectAttributeUpdate`](crate::model::ObjectAttributeUpdate)
        pub fn build(self) -> crate::model::ObjectAttributeUpdate {
            crate::model::ObjectAttributeUpdate {
                object_attribute_key: self.object_attribute_key,
                object_attribute_action: self.object_attribute_action,
            }
        }
    }
}
impl ObjectAttributeUpdate {
    /// Creates a new builder-style object to manufacture [`ObjectAttributeUpdate`](crate::model::ObjectAttributeUpdate)
    pub fn builder() -> crate::model::object_attribute_update::Builder {
        crate::model::object_attribute_update::Builder::default()
    }
}

/// <p>The action to take on the object attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectAttributeAction {
    /// <p>A type that can be either <code>Update</code> or <code>Delete</code>.</p>
    pub object_attribute_action_type: std::option::Option<crate::model::UpdateActionType>,
    /// <p>The value that you want to update to.</p>
    pub object_attribute_update_value: std::option::Option<crate::model::TypedAttributeValue>,
}
impl ObjectAttributeAction {
    /// <p>A type that can be either <code>Update</code> or <code>Delete</code>.</p>
    pub fn object_attribute_action_type(
        &self,
    ) -> std::option::Option<&crate::model::UpdateActionType> {
        self.object_attribute_action_type.as_ref()
    }
    /// <p>The value that you want to update to.</p>
    pub fn object_attribute_update_value(
        &self,
    ) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.object_attribute_update_value.as_ref()
    }
}
impl std::fmt::Debug for ObjectAttributeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectAttributeAction");
        formatter.field(
            "object_attribute_action_type",
            &self.object_attribute_action_type,
        );
        formatter.field(
            "object_attribute_update_value",
            &self.object_attribute_update_value,
        );
        formatter.finish()
    }
}
/// See [`ObjectAttributeAction`](crate::model::ObjectAttributeAction)
pub mod object_attribute_action {
    /// A builder for [`ObjectAttributeAction`](crate::model::ObjectAttributeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_attribute_action_type:
            std::option::Option<crate::model::UpdateActionType>,
        pub(crate) object_attribute_update_value:
            std::option::Option<crate::model::TypedAttributeValue>,
    }
    impl Builder {
        /// <p>A type that can be either <code>Update</code> or <code>Delete</code>.</p>
        pub fn object_attribute_action_type(
            mut self,
            input: crate::model::UpdateActionType,
        ) -> Self {
            self.object_attribute_action_type = Some(input);
            self
        }
        /// <p>A type that can be either <code>Update</code> or <code>Delete</code>.</p>
        pub fn set_object_attribute_action_type(
            mut self,
            input: std::option::Option<crate::model::UpdateActionType>,
        ) -> Self {
            self.object_attribute_action_type = input;
            self
        }
        /// <p>The value that you want to update to.</p>
        pub fn object_attribute_update_value(
            mut self,
            input: crate::model::TypedAttributeValue,
        ) -> Self {
            self.object_attribute_update_value = Some(input);
            self
        }
        /// <p>The value that you want to update to.</p>
        pub fn set_object_attribute_update_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.object_attribute_update_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectAttributeAction`](crate::model::ObjectAttributeAction)
        pub fn build(self) -> crate::model::ObjectAttributeAction {
            crate::model::ObjectAttributeAction {
                object_attribute_action_type: self.object_attribute_action_type,
                object_attribute_update_value: self.object_attribute_update_value,
            }
        }
    }
}
impl ObjectAttributeAction {
    /// Creates a new builder-style object to manufacture [`ObjectAttributeAction`](crate::model::ObjectAttributeAction)
    pub fn builder() -> crate::model::object_attribute_action::Builder {
        crate::model::object_attribute_action::Builder::default()
    }
}

/// <p>A unique identifier for an attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeKey {
    /// <p>The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet that the attribute exists within.</p>
    pub facet_name: std::option::Option<std::string::String>,
    /// <p>The name of the attribute.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AttributeKey {
    /// <p>The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet that the attribute exists within.</p>
    pub fn facet_name(&self) -> std::option::Option<&str> {
        self.facet_name.as_deref()
    }
    /// <p>The name of the attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AttributeKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeKey");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("facet_name", &self.facet_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AttributeKey`](crate::model::AttributeKey)
pub mod attribute_key {
    /// A builder for [`AttributeKey`](crate::model::AttributeKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) facet_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet that the attribute exists within.</p>
        pub fn facet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.facet_name = Some(input.into());
            self
        }
        /// <p>The name of the facet that the attribute exists within.</p>
        pub fn set_facet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.facet_name = input;
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeKey`](crate::model::AttributeKey)
        pub fn build(self) -> crate::model::AttributeKey {
            crate::model::AttributeKey {
                schema_arn: self.schema_arn,
                facet_name: self.facet_name,
                name: self.name,
            }
        }
    }
}
impl AttributeKey {
    /// Creates a new builder-style object to manufacture [`AttributeKey`](crate::model::AttributeKey)
    pub fn builder() -> crate::model::attribute_key::Builder {
        crate::model::attribute_key::Builder::default()
    }
}

/// <p>The reference that identifies an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectReference {
    /// <p>A path selector supports easy selection of an object by the parent/child links leading to it from the directory root. Use the link names from each parent/child link to construct the path. Path selectors start with a slash (/) and link names are separated by slashes. For more information about paths, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html">Access Objects</a>. You can identify an object in one of the following ways:</p>
    /// <ul>
    /// <li> <p> <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When creating objects, the system will provide you with the identifier of the created object. An object’s identifier is immutable and no two objects will ever share the same object identifier. To identify an object with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes. </p> </li>
    /// <li> <p> <i>/some/path</i> - Identifies the object based on path</p> </li>
    /// <li> <p> <i>#SomeBatchReference</i> - Identifies the object in a batch call</p> </li>
    /// </ul>
    pub selector: std::option::Option<std::string::String>,
}
impl ObjectReference {
    /// <p>A path selector supports easy selection of an object by the parent/child links leading to it from the directory root. Use the link names from each parent/child link to construct the path. Path selectors start with a slash (/) and link names are separated by slashes. For more information about paths, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html">Access Objects</a>. You can identify an object in one of the following ways:</p>
    /// <ul>
    /// <li> <p> <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When creating objects, the system will provide you with the identifier of the created object. An object’s identifier is immutable and no two objects will ever share the same object identifier. To identify an object with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes. </p> </li>
    /// <li> <p> <i>/some/path</i> - Identifies the object based on path</p> </li>
    /// <li> <p> <i>#SomeBatchReference</i> - Identifies the object in a batch call</p> </li>
    /// </ul>
    pub fn selector(&self) -> std::option::Option<&str> {
        self.selector.as_deref()
    }
}
impl std::fmt::Debug for ObjectReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectReference");
        formatter.field("selector", &self.selector);
        formatter.finish()
    }
}
/// See [`ObjectReference`](crate::model::ObjectReference)
pub mod object_reference {
    /// A builder for [`ObjectReference`](crate::model::ObjectReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selector: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A path selector supports easy selection of an object by the parent/child links leading to it from the directory root. Use the link names from each parent/child link to construct the path. Path selectors start with a slash (/) and link names are separated by slashes. For more information about paths, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html">Access Objects</a>. You can identify an object in one of the following ways:</p>
        /// <ul>
        /// <li> <p> <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When creating objects, the system will provide you with the identifier of the created object. An object’s identifier is immutable and no two objects will ever share the same object identifier. To identify an object with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes. </p> </li>
        /// <li> <p> <i>/some/path</i> - Identifies the object based on path</p> </li>
        /// <li> <p> <i>#SomeBatchReference</i> - Identifies the object in a batch call</p> </li>
        /// </ul>
        pub fn selector(mut self, input: impl Into<std::string::String>) -> Self {
            self.selector = Some(input.into());
            self
        }
        /// <p>A path selector supports easy selection of an object by the parent/child links leading to it from the directory root. Use the link names from each parent/child link to construct the path. Path selectors start with a slash (/) and link names are separated by slashes. For more information about paths, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html">Access Objects</a>. You can identify an object in one of the following ways:</p>
        /// <ul>
        /// <li> <p> <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When creating objects, the system will provide you with the identifier of the created object. An object’s identifier is immutable and no two objects will ever share the same object identifier. To identify an object with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes. </p> </li>
        /// <li> <p> <i>/some/path</i> - Identifies the object based on path</p> </li>
        /// <li> <p> <i>#SomeBatchReference</i> - Identifies the object in a batch call</p> </li>
        /// </ul>
        pub fn set_selector(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selector = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectReference`](crate::model::ObjectReference)
        pub fn build(self) -> crate::model::ObjectReference {
            crate::model::ObjectReference {
                selector: self.selector,
            }
        }
    }
}
impl ObjectReference {
    /// Creates a new builder-style object to manufacture [`ObjectReference`](crate::model::ObjectReference)
    pub fn builder() -> crate::model::object_reference::Builder {
        crate::model::object_reference::Builder::default()
    }
}

/// <p>Structure that contains attribute update information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinkAttributeUpdate {
    /// <p>The key of the attribute being updated.</p>
    pub attribute_key: std::option::Option<crate::model::AttributeKey>,
    /// <p>The action to perform as part of the attribute update.</p>
    pub attribute_action: std::option::Option<crate::model::LinkAttributeAction>,
}
impl LinkAttributeUpdate {
    /// <p>The key of the attribute being updated.</p>
    pub fn attribute_key(&self) -> std::option::Option<&crate::model::AttributeKey> {
        self.attribute_key.as_ref()
    }
    /// <p>The action to perform as part of the attribute update.</p>
    pub fn attribute_action(&self) -> std::option::Option<&crate::model::LinkAttributeAction> {
        self.attribute_action.as_ref()
    }
}
impl std::fmt::Debug for LinkAttributeUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinkAttributeUpdate");
        formatter.field("attribute_key", &self.attribute_key);
        formatter.field("attribute_action", &self.attribute_action);
        formatter.finish()
    }
}
/// See [`LinkAttributeUpdate`](crate::model::LinkAttributeUpdate)
pub mod link_attribute_update {
    /// A builder for [`LinkAttributeUpdate`](crate::model::LinkAttributeUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_key: std::option::Option<crate::model::AttributeKey>,
        pub(crate) attribute_action: std::option::Option<crate::model::LinkAttributeAction>,
    }
    impl Builder {
        /// <p>The key of the attribute being updated.</p>
        pub fn attribute_key(mut self, input: crate::model::AttributeKey) -> Self {
            self.attribute_key = Some(input);
            self
        }
        /// <p>The key of the attribute being updated.</p>
        pub fn set_attribute_key(
            mut self,
            input: std::option::Option<crate::model::AttributeKey>,
        ) -> Self {
            self.attribute_key = input;
            self
        }
        /// <p>The action to perform as part of the attribute update.</p>
        pub fn attribute_action(mut self, input: crate::model::LinkAttributeAction) -> Self {
            self.attribute_action = Some(input);
            self
        }
        /// <p>The action to perform as part of the attribute update.</p>
        pub fn set_attribute_action(
            mut self,
            input: std::option::Option<crate::model::LinkAttributeAction>,
        ) -> Self {
            self.attribute_action = input;
            self
        }
        /// Consumes the builder and constructs a [`LinkAttributeUpdate`](crate::model::LinkAttributeUpdate)
        pub fn build(self) -> crate::model::LinkAttributeUpdate {
            crate::model::LinkAttributeUpdate {
                attribute_key: self.attribute_key,
                attribute_action: self.attribute_action,
            }
        }
    }
}
impl LinkAttributeUpdate {
    /// Creates a new builder-style object to manufacture [`LinkAttributeUpdate`](crate::model::LinkAttributeUpdate)
    pub fn builder() -> crate::model::link_attribute_update::Builder {
        crate::model::link_attribute_update::Builder::default()
    }
}

/// <p>The action to take on a typed link attribute value. Updates are only supported for attributes which don’t contribute to link identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinkAttributeAction {
    /// <p>A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.</p>
    pub attribute_action_type: std::option::Option<crate::model::UpdateActionType>,
    /// <p>The value that you want to update to.</p>
    pub attribute_update_value: std::option::Option<crate::model::TypedAttributeValue>,
}
impl LinkAttributeAction {
    /// <p>A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.</p>
    pub fn attribute_action_type(&self) -> std::option::Option<&crate::model::UpdateActionType> {
        self.attribute_action_type.as_ref()
    }
    /// <p>The value that you want to update to.</p>
    pub fn attribute_update_value(
        &self,
    ) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.attribute_update_value.as_ref()
    }
}
impl std::fmt::Debug for LinkAttributeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinkAttributeAction");
        formatter.field("attribute_action_type", &self.attribute_action_type);
        formatter.field("attribute_update_value", &self.attribute_update_value);
        formatter.finish()
    }
}
/// See [`LinkAttributeAction`](crate::model::LinkAttributeAction)
pub mod link_attribute_action {
    /// A builder for [`LinkAttributeAction`](crate::model::LinkAttributeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_action_type: std::option::Option<crate::model::UpdateActionType>,
        pub(crate) attribute_update_value: std::option::Option<crate::model::TypedAttributeValue>,
    }
    impl Builder {
        /// <p>A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.</p>
        pub fn attribute_action_type(mut self, input: crate::model::UpdateActionType) -> Self {
            self.attribute_action_type = Some(input);
            self
        }
        /// <p>A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.</p>
        pub fn set_attribute_action_type(
            mut self,
            input: std::option::Option<crate::model::UpdateActionType>,
        ) -> Self {
            self.attribute_action_type = input;
            self
        }
        /// <p>The value that you want to update to.</p>
        pub fn attribute_update_value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.attribute_update_value = Some(input);
            self
        }
        /// <p>The value that you want to update to.</p>
        pub fn set_attribute_update_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.attribute_update_value = input;
            self
        }
        /// Consumes the builder and constructs a [`LinkAttributeAction`](crate::model::LinkAttributeAction)
        pub fn build(self) -> crate::model::LinkAttributeAction {
            crate::model::LinkAttributeAction {
                attribute_action_type: self.attribute_action_type,
                attribute_update_value: self.attribute_update_value,
            }
        }
    }
}
impl LinkAttributeAction {
    /// Creates a new builder-style object to manufacture [`LinkAttributeAction`](crate::model::LinkAttributeAction)
    pub fn builder() -> crate::model::link_attribute_action::Builder {
        crate::model::link_attribute_action::Builder::default()
    }
}

/// <p>Contains all the information that is used to uniquely identify a typed link. The parameters discussed in this topic are used to uniquely specify the typed link being operated on. The <code>AttachTypedLink</code> API returns a typed link specifier while the <code>DetachTypedLink</code> API accepts one as input. Similarly, the <code>ListIncomingTypedLinks</code> and <code>ListOutgoingTypedLinks</code> API operations provide typed link specifiers as output. You can also construct a typed link specifier from scratch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkSpecifier {
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub source_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub target_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the attribute value to update.</p>
    pub identity_attribute_values:
        std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
}
impl TypedLinkSpecifier {
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub fn typed_link_facet(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.typed_link_facet.as_ref()
    }
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub fn source_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.source_object_reference.as_ref()
    }
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub fn target_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_object_reference.as_ref()
    }
    /// <p>Identifies the attribute value to update.</p>
    pub fn identity_attribute_values(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeNameAndValue]> {
        self.identity_attribute_values.as_deref()
    }
}
impl std::fmt::Debug for TypedLinkSpecifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkSpecifier");
        formatter.field("typed_link_facet", &self.typed_link_facet);
        formatter.field("source_object_reference", &self.source_object_reference);
        formatter.field("target_object_reference", &self.target_object_reference);
        formatter.field("identity_attribute_values", &self.identity_attribute_values);
        formatter.finish()
    }
}
/// See [`TypedLinkSpecifier`](crate::model::TypedLinkSpecifier)
pub mod typed_link_specifier {
    /// A builder for [`TypedLinkSpecifier`](crate::model::TypedLinkSpecifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) source_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) identity_attribute_values:
            std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
    }
    impl Builder {
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn typed_link_facet(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.typed_link_facet = Some(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn set_typed_link_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.typed_link_facet = input;
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn source_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.source_object_reference = Some(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn set_source_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.source_object_reference = input;
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn target_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_object_reference = Some(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn set_target_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_object_reference = input;
            self
        }
        /// Appends an item to `identity_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_values`](Self::set_identity_attribute_values).
        ///
        /// <p>Identifies the attribute value to update.</p>
        pub fn identity_attribute_values(
            mut self,
            input: crate::model::AttributeNameAndValue,
        ) -> Self {
            let mut v = self.identity_attribute_values.unwrap_or_default();
            v.push(input);
            self.identity_attribute_values = Some(v);
            self
        }
        /// <p>Identifies the attribute value to update.</p>
        pub fn set_identity_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
        ) -> Self {
            self.identity_attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkSpecifier`](crate::model::TypedLinkSpecifier)
        pub fn build(self) -> crate::model::TypedLinkSpecifier {
            crate::model::TypedLinkSpecifier {
                typed_link_facet: self.typed_link_facet,
                source_object_reference: self.source_object_reference,
                target_object_reference: self.target_object_reference,
                identity_attribute_values: self.identity_attribute_values,
            }
        }
    }
}
impl TypedLinkSpecifier {
    /// Creates a new builder-style object to manufacture [`TypedLinkSpecifier`](crate::model::TypedLinkSpecifier)
    pub fn builder() -> crate::model::typed_link_specifier::Builder {
        crate::model::typed_link_specifier::Builder::default()
    }
}

/// <p>Identifies the attribute name and value for a typed link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeNameAndValue {
    /// <p>The attribute name of the typed link.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value for the typed link.</p>
    pub value: std::option::Option<crate::model::TypedAttributeValue>,
}
impl AttributeNameAndValue {
    /// <p>The attribute name of the typed link.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value for the typed link.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for AttributeNameAndValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeNameAndValue");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AttributeNameAndValue`](crate::model::AttributeNameAndValue)
pub mod attribute_name_and_value {
    /// A builder for [`AttributeNameAndValue`](crate::model::AttributeNameAndValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::TypedAttributeValue>,
    }
    impl Builder {
        /// <p>The attribute name of the typed link.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute name of the typed link.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The value for the typed link.</p>
        pub fn value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value for the typed link.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeNameAndValue`](crate::model::AttributeNameAndValue)
        pub fn build(self) -> crate::model::AttributeNameAndValue {
            crate::model::AttributeNameAndValue {
                attribute_name: self.attribute_name,
                value: self.value,
            }
        }
    }
}
impl AttributeNameAndValue {
    /// Creates a new builder-style object to manufacture [`AttributeNameAndValue`](crate::model::AttributeNameAndValue)
    pub fn builder() -> crate::model::attribute_name_and_value::Builder {
        crate::model::attribute_name_and_value::Builder::default()
    }
}

/// <p>Identifies the schema Amazon Resource Name (ARN) and facet name for the typed link.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkSchemaAndFacetName {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the typed link facet.</p>
    pub typed_link_name: std::option::Option<std::string::String>,
}
impl TypedLinkSchemaAndFacetName {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The unique name of the typed link facet.</p>
    pub fn typed_link_name(&self) -> std::option::Option<&str> {
        self.typed_link_name.as_deref()
    }
}
impl std::fmt::Debug for TypedLinkSchemaAndFacetName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkSchemaAndFacetName");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("typed_link_name", &self.typed_link_name);
        formatter.finish()
    }
}
/// See [`TypedLinkSchemaAndFacetName`](crate::model::TypedLinkSchemaAndFacetName)
pub mod typed_link_schema_and_facet_name {
    /// A builder for [`TypedLinkSchemaAndFacetName`](crate::model::TypedLinkSchemaAndFacetName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) typed_link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <code>arns</code>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn typed_link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.typed_link_name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_typed_link_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.typed_link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkSchemaAndFacetName`](crate::model::TypedLinkSchemaAndFacetName)
        pub fn build(self) -> crate::model::TypedLinkSchemaAndFacetName {
            crate::model::TypedLinkSchemaAndFacetName {
                schema_arn: self.schema_arn,
                typed_link_name: self.typed_link_name,
            }
        }
    }
}
impl TypedLinkSchemaAndFacetName {
    /// Creates a new builder-style object to manufacture [`TypedLinkSchemaAndFacetName`](crate::model::TypedLinkSchemaAndFacetName)
    pub fn builder() -> crate::model::typed_link_schema_and_facet_name::Builder {
        crate::model::typed_link_schema_and_facet_name::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectType {
    #[allow(missing_docs)] // documentation missing in model
    Index,
    #[allow(missing_docs)] // documentation missing in model
    LeafNode,
    #[allow(missing_docs)] // documentation missing in model
    Node,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectType {
    fn from(s: &str) -> Self {
        match s {
            "INDEX" => ObjectType::Index,
            "LEAF_NODE" => ObjectType::LeafNode,
            "NODE" => ObjectType::Node,
            "POLICY" => ObjectType::Policy,
            other => ObjectType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectType::from(s))
    }
}
impl ObjectType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectType::Index => "INDEX",
            ObjectType::LeafNode => "LEAF_NODE",
            ObjectType::Node => "NODE",
            ObjectType::Policy => "POLICY",
            ObjectType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INDEX", "LEAF_NODE", "NODE", "POLICY"]
    }
}
impl AsRef<str> for ObjectType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains information used to update an attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetAttributeUpdate {
    /// <p>The attribute to update.</p>
    pub attribute: std::option::Option<crate::model::FacetAttribute>,
    /// <p>The action to perform when updating the attribute.</p>
    pub action: std::option::Option<crate::model::UpdateActionType>,
}
impl FacetAttributeUpdate {
    /// <p>The attribute to update.</p>
    pub fn attribute(&self) -> std::option::Option<&crate::model::FacetAttribute> {
        self.attribute.as_ref()
    }
    /// <p>The action to perform when updating the attribute.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::UpdateActionType> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for FacetAttributeUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetAttributeUpdate");
        formatter.field("attribute", &self.attribute);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`FacetAttributeUpdate`](crate::model::FacetAttributeUpdate)
pub mod facet_attribute_update {
    /// A builder for [`FacetAttributeUpdate`](crate::model::FacetAttributeUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::FacetAttribute>,
        pub(crate) action: std::option::Option<crate::model::UpdateActionType>,
    }
    impl Builder {
        /// <p>The attribute to update.</p>
        pub fn attribute(mut self, input: crate::model::FacetAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to update.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::FacetAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The action to perform when updating the attribute.</p>
        pub fn action(mut self, input: crate::model::UpdateActionType) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to perform when updating the attribute.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateActionType>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetAttributeUpdate`](crate::model::FacetAttributeUpdate)
        pub fn build(self) -> crate::model::FacetAttributeUpdate {
            crate::model::FacetAttributeUpdate {
                attribute: self.attribute,
                action: self.action,
            }
        }
    }
}
impl FacetAttributeUpdate {
    /// Creates a new builder-style object to manufacture [`FacetAttributeUpdate`](crate::model::FacetAttributeUpdate)
    pub fn builder() -> crate::model::facet_attribute_update::Builder {
        crate::model::facet_attribute_update::Builder::default()
    }
}

/// <p>An attribute that is associated with the <code>Facet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetAttribute {
    /// <p>The name of the facet attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub attribute_definition: std::option::Option<crate::model::FacetAttributeDefinition>,
    /// <p>An attribute reference that is associated with the attribute. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub attribute_reference: std::option::Option<crate::model::FacetAttributeReference>,
    /// <p>The required behavior of the <code>FacetAttribute</code>.</p>
    pub required_behavior: std::option::Option<crate::model::RequiredAttributeBehavior>,
}
impl FacetAttribute {
    /// <p>The name of the facet attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub fn attribute_definition(
        &self,
    ) -> std::option::Option<&crate::model::FacetAttributeDefinition> {
        self.attribute_definition.as_ref()
    }
    /// <p>An attribute reference that is associated with the attribute. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub fn attribute_reference(
        &self,
    ) -> std::option::Option<&crate::model::FacetAttributeReference> {
        self.attribute_reference.as_ref()
    }
    /// <p>The required behavior of the <code>FacetAttribute</code>.</p>
    pub fn required_behavior(
        &self,
    ) -> std::option::Option<&crate::model::RequiredAttributeBehavior> {
        self.required_behavior.as_ref()
    }
}
impl std::fmt::Debug for FacetAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetAttribute");
        formatter.field("name", &self.name);
        formatter.field("attribute_definition", &self.attribute_definition);
        formatter.field("attribute_reference", &self.attribute_reference);
        formatter.field("required_behavior", &self.required_behavior);
        formatter.finish()
    }
}
/// See [`FacetAttribute`](crate::model::FacetAttribute)
pub mod facet_attribute {
    /// A builder for [`FacetAttribute`](crate::model::FacetAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute_definition:
            std::option::Option<crate::model::FacetAttributeDefinition>,
        pub(crate) attribute_reference: std::option::Option<crate::model::FacetAttributeReference>,
        pub(crate) required_behavior: std::option::Option<crate::model::RequiredAttributeBehavior>,
    }
    impl Builder {
        /// <p>The name of the facet attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the facet attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn attribute_definition(
            mut self,
            input: crate::model::FacetAttributeDefinition,
        ) -> Self {
            self.attribute_definition = Some(input);
            self
        }
        /// <p>A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn set_attribute_definition(
            mut self,
            input: std::option::Option<crate::model::FacetAttributeDefinition>,
        ) -> Self {
            self.attribute_definition = input;
            self
        }
        /// <p>An attribute reference that is associated with the attribute. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn attribute_reference(mut self, input: crate::model::FacetAttributeReference) -> Self {
            self.attribute_reference = Some(input);
            self
        }
        /// <p>An attribute reference that is associated with the attribute. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn set_attribute_reference(
            mut self,
            input: std::option::Option<crate::model::FacetAttributeReference>,
        ) -> Self {
            self.attribute_reference = input;
            self
        }
        /// <p>The required behavior of the <code>FacetAttribute</code>.</p>
        pub fn required_behavior(mut self, input: crate::model::RequiredAttributeBehavior) -> Self {
            self.required_behavior = Some(input);
            self
        }
        /// <p>The required behavior of the <code>FacetAttribute</code>.</p>
        pub fn set_required_behavior(
            mut self,
            input: std::option::Option<crate::model::RequiredAttributeBehavior>,
        ) -> Self {
            self.required_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetAttribute`](crate::model::FacetAttribute)
        pub fn build(self) -> crate::model::FacetAttribute {
            crate::model::FacetAttribute {
                name: self.name,
                attribute_definition: self.attribute_definition,
                attribute_reference: self.attribute_reference,
                required_behavior: self.required_behavior,
            }
        }
    }
}
impl FacetAttribute {
    /// Creates a new builder-style object to manufacture [`FacetAttribute`](crate::model::FacetAttribute)
    pub fn builder() -> crate::model::facet_attribute::Builder {
        crate::model::facet_attribute::Builder::default()
    }
}

/// <p>The facet attribute reference that specifies the attribute definition that contains the attribute facet name and attribute name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetAttributeReference {
    /// <p>The target facet name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub target_facet_name: std::option::Option<std::string::String>,
    /// <p>The target attribute name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub target_attribute_name: std::option::Option<std::string::String>,
}
impl FacetAttributeReference {
    /// <p>The target facet name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub fn target_facet_name(&self) -> std::option::Option<&str> {
        self.target_facet_name.as_deref()
    }
    /// <p>The target attribute name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
    pub fn target_attribute_name(&self) -> std::option::Option<&str> {
        self.target_attribute_name.as_deref()
    }
}
impl std::fmt::Debug for FacetAttributeReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetAttributeReference");
        formatter.field("target_facet_name", &self.target_facet_name);
        formatter.field("target_attribute_name", &self.target_attribute_name);
        formatter.finish()
    }
}
/// See [`FacetAttributeReference`](crate::model::FacetAttributeReference)
pub mod facet_attribute_reference {
    /// A builder for [`FacetAttributeReference`](crate::model::FacetAttributeReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_facet_name: std::option::Option<std::string::String>,
        pub(crate) target_attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The target facet name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn target_facet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_facet_name = Some(input.into());
            self
        }
        /// <p>The target facet name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn set_target_facet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_facet_name = input;
            self
        }
        /// <p>The target attribute name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn target_attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_attribute_name = Some(input.into());
            self
        }
        /// <p>The target attribute name that is associated with the facet reference. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
        pub fn set_target_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetAttributeReference`](crate::model::FacetAttributeReference)
        pub fn build(self) -> crate::model::FacetAttributeReference {
            crate::model::FacetAttributeReference {
                target_facet_name: self.target_facet_name,
                target_attribute_name: self.target_attribute_name,
            }
        }
    }
}
impl FacetAttributeReference {
    /// Creates a new builder-style object to manufacture [`FacetAttributeReference`](crate::model::FacetAttributeReference)
    pub fn builder() -> crate::model::facet_attribute_reference::Builder {
        crate::model::facet_attribute_reference::Builder::default()
    }
}

/// <p>A facet attribute definition. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html">Attribute References</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetAttributeDefinition {
    /// <p>The type of the attribute.</p>
    pub r#type: std::option::Option<crate::model::FacetAttributeType>,
    /// <p>The default value of the attribute (if configured).</p>
    pub default_value: std::option::Option<crate::model::TypedAttributeValue>,
    /// <p>Whether the attribute is mutable or not.</p>
    pub is_immutable: bool,
    /// <p>Validation rules attached to the attribute definition.</p>
    pub rules:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Rule>>,
}
impl FacetAttributeDefinition {
    /// <p>The type of the attribute.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FacetAttributeType> {
        self.r#type.as_ref()
    }
    /// <p>The default value of the attribute (if configured).</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.default_value.as_ref()
    }
    /// <p>Whether the attribute is mutable or not.</p>
    pub fn is_immutable(&self) -> bool {
        self.is_immutable
    }
    /// <p>Validation rules attached to the attribute definition.</p>
    pub fn rules(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Rule>>
    {
        self.rules.as_ref()
    }
}
impl std::fmt::Debug for FacetAttributeDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetAttributeDefinition");
        formatter.field("r#type", &self.r#type);
        formatter.field("default_value", &self.default_value);
        formatter.field("is_immutable", &self.is_immutable);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`FacetAttributeDefinition`](crate::model::FacetAttributeDefinition)
pub mod facet_attribute_definition {
    /// A builder for [`FacetAttributeDefinition`](crate::model::FacetAttributeDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FacetAttributeType>,
        pub(crate) default_value: std::option::Option<crate::model::TypedAttributeValue>,
        pub(crate) is_immutable: std::option::Option<bool>,
        pub(crate) rules:
            std::option::Option<std::collections::HashMap<std::string::String, crate::model::Rule>>,
    }
    impl Builder {
        /// <p>The type of the attribute.</p>
        pub fn r#type(mut self, input: crate::model::FacetAttributeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the attribute.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FacetAttributeType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The default value of the attribute (if configured).</p>
        pub fn default_value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>The default value of the attribute (if configured).</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>Whether the attribute is mutable or not.</p>
        pub fn is_immutable(mut self, input: bool) -> Self {
            self.is_immutable = Some(input);
            self
        }
        /// <p>Whether the attribute is mutable or not.</p>
        pub fn set_is_immutable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_immutable = input;
            self
        }
        /// Adds a key-value pair to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Validation rules attached to the attribute definition.</p>
        pub fn rules(mut self, k: impl Into<std::string::String>, v: crate::model::Rule) -> Self {
            let mut hash_map = self.rules.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.rules = Some(hash_map);
            self
        }
        /// <p>Validation rules attached to the attribute definition.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Rule>,
            >,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetAttributeDefinition`](crate::model::FacetAttributeDefinition)
        pub fn build(self) -> crate::model::FacetAttributeDefinition {
            crate::model::FacetAttributeDefinition {
                r#type: self.r#type,
                default_value: self.default_value,
                is_immutable: self.is_immutable.unwrap_or_default(),
                rules: self.rules,
            }
        }
    }
}
impl FacetAttributeDefinition {
    /// Creates a new builder-style object to manufacture [`FacetAttributeDefinition`](crate::model::FacetAttributeDefinition)
    pub fn builder() -> crate::model::facet_attribute_definition::Builder {
        crate::model::facet_attribute_definition::Builder::default()
    }
}

/// <p>The tag structure that contains a tag key and value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key that is associated with the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value that is associated with the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key that is associated with the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value that is associated with the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key that is associated with the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that is associated with the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value that is associated with the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that is associated with the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A facet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaFacet {
    /// <p>The ARN of the schema that contains the facet with no minor component. See <code>arns</code> and <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html">In-Place Schema Upgrade</a> for a description of when to provide minor versions. If this value is set, FacetName must also be set.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the facet. If this value is set, SchemaArn must also be set.</p>
    pub facet_name: std::option::Option<std::string::String>,
}
impl SchemaFacet {
    /// <p>The ARN of the schema that contains the facet with no minor component. See <code>arns</code> and <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html">In-Place Schema Upgrade</a> for a description of when to provide minor versions. If this value is set, FacetName must also be set.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the facet. If this value is set, SchemaArn must also be set.</p>
    pub fn facet_name(&self) -> std::option::Option<&str> {
        self.facet_name.as_deref()
    }
}
impl std::fmt::Debug for SchemaFacet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaFacet");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("facet_name", &self.facet_name);
        formatter.finish()
    }
}
/// See [`SchemaFacet`](crate::model::SchemaFacet)
pub mod schema_facet {
    /// A builder for [`SchemaFacet`](crate::model::SchemaFacet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) facet_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the schema that contains the facet with no minor component. See <code>arns</code> and <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html">In-Place Schema Upgrade</a> for a description of when to provide minor versions. If this value is set, FacetName must also be set.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema that contains the facet with no minor component. See <code>arns</code> and <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html">In-Place Schema Upgrade</a> for a description of when to provide minor versions. If this value is set, FacetName must also be set.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the facet. If this value is set, SchemaArn must also be set.</p>
        pub fn facet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.facet_name = Some(input.into());
            self
        }
        /// <p>The name of the facet. If this value is set, SchemaArn must also be set.</p>
        pub fn set_facet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.facet_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaFacet`](crate::model::SchemaFacet)
        pub fn build(self) -> crate::model::SchemaFacet {
            crate::model::SchemaFacet {
                schema_arn: self.schema_arn,
                facet_name: self.facet_name,
            }
        }
    }
}
impl SchemaFacet {
    /// Creates a new builder-style object to manufacture [`SchemaFacet`](crate::model::SchemaFacet)
    pub fn builder() -> crate::model::schema_facet::Builder {
        crate::model::schema_facet::Builder::default()
    }
}

/// <p>Used when a regular object exists in a <code>Directory</code> and you want to find all of the policies that are associated with that object and the parent to that object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyToPath {
    /// <p>The path that is referenced from the root.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>List of policy objects.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::PolicyAttachment>>,
}
impl PolicyToPath {
    /// <p>The path that is referenced from the root.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>List of policy objects.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::PolicyAttachment]> {
        self.policies.as_deref()
    }
}
impl std::fmt::Debug for PolicyToPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyToPath");
        formatter.field("path", &self.path);
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`PolicyToPath`](crate::model::PolicyToPath)
pub mod policy_to_path {
    /// A builder for [`PolicyToPath`](crate::model::PolicyToPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::PolicyAttachment>>,
    }
    impl Builder {
        /// <p>The path that is referenced from the root.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path that is referenced from the root.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>List of policy objects.</p>
        pub fn policies(mut self, input: crate::model::PolicyAttachment) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>List of policy objects.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyAttachment>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyToPath`](crate::model::PolicyToPath)
        pub fn build(self) -> crate::model::PolicyToPath {
            crate::model::PolicyToPath {
                path: self.path,
                policies: self.policies,
            }
        }
    }
}
impl PolicyToPath {
    /// Creates a new builder-style object to manufacture [`PolicyToPath`](crate::model::PolicyToPath)
    pub fn builder() -> crate::model::policy_to_path::Builder {
        crate::model::policy_to_path::Builder::default()
    }
}

/// <p>Contains the <code>PolicyType</code>, <code>PolicyId</code>, and the <code>ObjectIdentifier</code> to which it is attached. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyAttachment {
    /// <p>The ID of <code>PolicyAttachment</code>.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.</p>
    pub object_identifier: std::option::Option<std::string::String>,
    /// <p>The type of policy that can be associated with <code>PolicyAttachment</code>.</p>
    pub policy_type: std::option::Option<std::string::String>,
}
impl PolicyAttachment {
    /// <p>The ID of <code>PolicyAttachment</code>.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
    /// <p>The type of policy that can be associated with <code>PolicyAttachment</code>.</p>
    pub fn policy_type(&self) -> std::option::Option<&str> {
        self.policy_type.as_deref()
    }
}
impl std::fmt::Debug for PolicyAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyAttachment");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("object_identifier", &self.object_identifier);
        formatter.field("policy_type", &self.policy_type);
        formatter.finish()
    }
}
/// See [`PolicyAttachment`](crate::model::PolicyAttachment)
pub mod policy_attachment {
    /// A builder for [`PolicyAttachment`](crate::model::PolicyAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) object_identifier: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of <code>PolicyAttachment</code>.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of <code>PolicyAttachment</code>.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// <p>The type of policy that can be associated with <code>PolicyAttachment</code>.</p>
        pub fn policy_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type = Some(input.into());
            self
        }
        /// <p>The type of policy that can be associated with <code>PolicyAttachment</code>.</p>
        pub fn set_policy_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyAttachment`](crate::model::PolicyAttachment)
        pub fn build(self) -> crate::model::PolicyAttachment {
            crate::model::PolicyAttachment {
                policy_id: self.policy_id,
                object_identifier: self.object_identifier,
                policy_type: self.policy_type,
            }
        }
    }
}
impl PolicyAttachment {
    /// Creates a new builder-style object to manufacture [`PolicyAttachment`](crate::model::PolicyAttachment)
    pub fn builder() -> crate::model::policy_attachment::Builder {
        crate::model::policy_attachment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConsistencyLevel {
    #[allow(missing_docs)] // documentation missing in model
    Eventual,
    #[allow(missing_docs)] // documentation missing in model
    Serializable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConsistencyLevel {
    fn from(s: &str) -> Self {
        match s {
            "EVENTUAL" => ConsistencyLevel::Eventual,
            "SERIALIZABLE" => ConsistencyLevel::Serializable,
            other => ConsistencyLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConsistencyLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConsistencyLevel::from(s))
    }
}
impl ConsistencyLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConsistencyLevel::Eventual => "EVENTUAL",
            ConsistencyLevel::Serializable => "SERIALIZABLE",
            ConsistencyLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVENTUAL", "SERIALIZABLE"]
    }
}
impl AsRef<str> for ConsistencyLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies the range of attributes that are used by a specified filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkAttributeRange {
    /// <p>The unique name of the typed link attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The range of attribute values that are being selected.</p>
    pub range: std::option::Option<crate::model::TypedAttributeValueRange>,
}
impl TypedLinkAttributeRange {
    /// <p>The unique name of the typed link attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The range of attribute values that are being selected.</p>
    pub fn range(&self) -> std::option::Option<&crate::model::TypedAttributeValueRange> {
        self.range.as_ref()
    }
}
impl std::fmt::Debug for TypedLinkAttributeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkAttributeRange");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("range", &self.range);
        formatter.finish()
    }
}
/// See [`TypedLinkAttributeRange`](crate::model::TypedLinkAttributeRange)
pub mod typed_link_attribute_range {
    /// A builder for [`TypedLinkAttributeRange`](crate::model::TypedLinkAttributeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<crate::model::TypedAttributeValueRange>,
    }
    impl Builder {
        /// <p>The unique name of the typed link attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The range of attribute values that are being selected.</p>
        pub fn range(mut self, input: crate::model::TypedAttributeValueRange) -> Self {
            self.range = Some(input);
            self
        }
        /// <p>The range of attribute values that are being selected.</p>
        pub fn set_range(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValueRange>,
        ) -> Self {
            self.range = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkAttributeRange`](crate::model::TypedLinkAttributeRange)
        pub fn build(self) -> crate::model::TypedLinkAttributeRange {
            crate::model::TypedLinkAttributeRange {
                attribute_name: self.attribute_name,
                range: self.range,
            }
        }
    }
}
impl TypedLinkAttributeRange {
    /// Creates a new builder-style object to manufacture [`TypedLinkAttributeRange`](crate::model::TypedLinkAttributeRange)
    pub fn builder() -> crate::model::typed_link_attribute_range::Builder {
        crate::model::typed_link_attribute_range::Builder::default()
    }
}

/// <p>A range of attribute values. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_range_filters.html">Range Filters</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedAttributeValueRange {
    /// <p>The inclusive or exclusive range start.</p>
    pub start_mode: std::option::Option<crate::model::RangeMode>,
    /// <p>The value to start the range at.</p>
    pub start_value: std::option::Option<crate::model::TypedAttributeValue>,
    /// <p>The inclusive or exclusive range end.</p>
    pub end_mode: std::option::Option<crate::model::RangeMode>,
    /// <p>The attribute value to terminate the range at.</p>
    pub end_value: std::option::Option<crate::model::TypedAttributeValue>,
}
impl TypedAttributeValueRange {
    /// <p>The inclusive or exclusive range start.</p>
    pub fn start_mode(&self) -> std::option::Option<&crate::model::RangeMode> {
        self.start_mode.as_ref()
    }
    /// <p>The value to start the range at.</p>
    pub fn start_value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.start_value.as_ref()
    }
    /// <p>The inclusive or exclusive range end.</p>
    pub fn end_mode(&self) -> std::option::Option<&crate::model::RangeMode> {
        self.end_mode.as_ref()
    }
    /// <p>The attribute value to terminate the range at.</p>
    pub fn end_value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.end_value.as_ref()
    }
}
impl std::fmt::Debug for TypedAttributeValueRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedAttributeValueRange");
        formatter.field("start_mode", &self.start_mode);
        formatter.field("start_value", &self.start_value);
        formatter.field("end_mode", &self.end_mode);
        formatter.field("end_value", &self.end_value);
        formatter.finish()
    }
}
/// See [`TypedAttributeValueRange`](crate::model::TypedAttributeValueRange)
pub mod typed_attribute_value_range {
    /// A builder for [`TypedAttributeValueRange`](crate::model::TypedAttributeValueRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_mode: std::option::Option<crate::model::RangeMode>,
        pub(crate) start_value: std::option::Option<crate::model::TypedAttributeValue>,
        pub(crate) end_mode: std::option::Option<crate::model::RangeMode>,
        pub(crate) end_value: std::option::Option<crate::model::TypedAttributeValue>,
    }
    impl Builder {
        /// <p>The inclusive or exclusive range start.</p>
        pub fn start_mode(mut self, input: crate::model::RangeMode) -> Self {
            self.start_mode = Some(input);
            self
        }
        /// <p>The inclusive or exclusive range start.</p>
        pub fn set_start_mode(
            mut self,
            input: std::option::Option<crate::model::RangeMode>,
        ) -> Self {
            self.start_mode = input;
            self
        }
        /// <p>The value to start the range at.</p>
        pub fn start_value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.start_value = Some(input);
            self
        }
        /// <p>The value to start the range at.</p>
        pub fn set_start_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.start_value = input;
            self
        }
        /// <p>The inclusive or exclusive range end.</p>
        pub fn end_mode(mut self, input: crate::model::RangeMode) -> Self {
            self.end_mode = Some(input);
            self
        }
        /// <p>The inclusive or exclusive range end.</p>
        pub fn set_end_mode(mut self, input: std::option::Option<crate::model::RangeMode>) -> Self {
            self.end_mode = input;
            self
        }
        /// <p>The attribute value to terminate the range at.</p>
        pub fn end_value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.end_value = Some(input);
            self
        }
        /// <p>The attribute value to terminate the range at.</p>
        pub fn set_end_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.end_value = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedAttributeValueRange`](crate::model::TypedAttributeValueRange)
        pub fn build(self) -> crate::model::TypedAttributeValueRange {
            crate::model::TypedAttributeValueRange {
                start_mode: self.start_mode,
                start_value: self.start_value,
                end_mode: self.end_mode,
                end_value: self.end_value,
            }
        }
    }
}
impl TypedAttributeValueRange {
    /// Creates a new builder-style object to manufacture [`TypedAttributeValueRange`](crate::model::TypedAttributeValueRange)
    pub fn builder() -> crate::model::typed_attribute_value_range::Builder {
        crate::model::typed_attribute_value_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RangeMode {
    #[allow(missing_docs)] // documentation missing in model
    Exclusive,
    #[allow(missing_docs)] // documentation missing in model
    First,
    #[allow(missing_docs)] // documentation missing in model
    Inclusive,
    #[allow(missing_docs)] // documentation missing in model
    Last,
    #[allow(missing_docs)] // documentation missing in model
    LastBeforeMissingValues,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RangeMode {
    fn from(s: &str) -> Self {
        match s {
            "EXCLUSIVE" => RangeMode::Exclusive,
            "FIRST" => RangeMode::First,
            "INCLUSIVE" => RangeMode::Inclusive,
            "LAST" => RangeMode::Last,
            "LAST_BEFORE_MISSING_VALUES" => RangeMode::LastBeforeMissingValues,
            other => RangeMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RangeMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RangeMode::from(s))
    }
}
impl RangeMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RangeMode::Exclusive => "EXCLUSIVE",
            RangeMode::First => "FIRST",
            RangeMode::Inclusive => "INCLUSIVE",
            RangeMode::Last => "LAST",
            RangeMode::LastBeforeMissingValues => "LAST_BEFORE_MISSING_VALUES",
            RangeMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXCLUSIVE",
            "FIRST",
            "INCLUSIVE",
            "LAST",
            "LAST_BEFORE_MISSING_VALUES",
        ]
    }
}
impl AsRef<str> for RangeMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A pair of ObjectIdentifier and LinkName.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectIdentifierAndLinkNameTuple {
    /// <p>The ID that is associated with the object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the link between the parent and the child object.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl ObjectIdentifierAndLinkNameTuple {
    /// <p>The ID that is associated with the object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
    /// <p>The name of the link between the parent and the child object.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for ObjectIdentifierAndLinkNameTuple {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectIdentifierAndLinkNameTuple");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}
/// See [`ObjectIdentifierAndLinkNameTuple`](crate::model::ObjectIdentifierAndLinkNameTuple)
pub mod object_identifier_and_link_name_tuple {
    /// A builder for [`ObjectIdentifierAndLinkNameTuple`](crate::model::ObjectIdentifierAndLinkNameTuple)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that is associated with the object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The ID that is associated with the object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// <p>The name of the link between the parent and the child object.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link between the parent and the child object.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectIdentifierAndLinkNameTuple`](crate::model::ObjectIdentifierAndLinkNameTuple)
        pub fn build(self) -> crate::model::ObjectIdentifierAndLinkNameTuple {
            crate::model::ObjectIdentifierAndLinkNameTuple {
                object_identifier: self.object_identifier,
                link_name: self.link_name,
            }
        }
    }
}
impl ObjectIdentifierAndLinkNameTuple {
    /// Creates a new builder-style object to manufacture [`ObjectIdentifierAndLinkNameTuple`](crate::model::ObjectIdentifierAndLinkNameTuple)
    pub fn builder() -> crate::model::object_identifier_and_link_name_tuple::Builder {
        crate::model::object_identifier_and_link_name_tuple::Builder::default()
    }
}

/// <p>Returns the path to the <code>ObjectIdentifiers</code> that is associated with the directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PathToObjectIdentifiers {
    /// <p>The path that is used to identify the object starting from directory root.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.</p>
    pub object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PathToObjectIdentifiers {
    /// <p>The path that is used to identify the object starting from directory root.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.</p>
    pub fn object_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.object_identifiers.as_deref()
    }
}
impl std::fmt::Debug for PathToObjectIdentifiers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PathToObjectIdentifiers");
        formatter.field("path", &self.path);
        formatter.field("object_identifiers", &self.object_identifiers);
        formatter.finish()
    }
}
/// See [`PathToObjectIdentifiers`](crate::model::PathToObjectIdentifiers)
pub mod path_to_object_identifiers {
    /// A builder for [`PathToObjectIdentifiers`](crate::model::PathToObjectIdentifiers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The path that is used to identify the object starting from directory root.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path that is used to identify the object starting from directory root.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `object_identifiers`.
        ///
        /// To override the contents of this collection use [`set_object_identifiers`](Self::set_object_identifiers).
        ///
        /// <p>Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.</p>
        pub fn object_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.object_identifiers.unwrap_or_default();
            v.push(input.into());
            self.object_identifiers = Some(v);
            self
        }
        /// <p>Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.</p>
        pub fn set_object_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.object_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`PathToObjectIdentifiers`](crate::model::PathToObjectIdentifiers)
        pub fn build(self) -> crate::model::PathToObjectIdentifiers {
            crate::model::PathToObjectIdentifiers {
                path: self.path,
                object_identifiers: self.object_identifiers,
            }
        }
    }
}
impl PathToObjectIdentifiers {
    /// Creates a new builder-style object to manufacture [`PathToObjectIdentifiers`](crate::model::PathToObjectIdentifiers)
    pub fn builder() -> crate::model::path_to_object_identifiers::Builder {
        crate::model::path_to_object_identifiers::Builder::default()
    }
}

/// <p>The combination of an attribute key and an attribute value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeKeyAndValue {
    /// <p>The key of the attribute.</p>
    pub key: std::option::Option<crate::model::AttributeKey>,
    /// <p>The value of the attribute.</p>
    pub value: std::option::Option<crate::model::TypedAttributeValue>,
}
impl AttributeKeyAndValue {
    /// <p>The key of the attribute.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::AttributeKey> {
        self.key.as_ref()
    }
    /// <p>The value of the attribute.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::TypedAttributeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for AttributeKeyAndValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeKeyAndValue");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AttributeKeyAndValue`](crate::model::AttributeKeyAndValue)
pub mod attribute_key_and_value {
    /// A builder for [`AttributeKeyAndValue`](crate::model::AttributeKeyAndValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::AttributeKey>,
        pub(crate) value: std::option::Option<crate::model::TypedAttributeValue>,
    }
    impl Builder {
        /// <p>The key of the attribute.</p>
        pub fn key(mut self, input: crate::model::AttributeKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The key of the attribute.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::AttributeKey>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn value(mut self, input: crate::model::TypedAttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeKeyAndValue`](crate::model::AttributeKeyAndValue)
        pub fn build(self) -> crate::model::AttributeKeyAndValue {
            crate::model::AttributeKeyAndValue {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AttributeKeyAndValue {
    /// Creates a new builder-style object to manufacture [`AttributeKeyAndValue`](crate::model::AttributeKeyAndValue)
    pub fn builder() -> crate::model::attribute_key_and_value::Builder {
        crate::model::attribute_key_and_value::Builder::default()
    }
}

/// <p>Represents an index and an attached object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexAttachment {
    /// <p>The indexed attribute values.</p>
    pub indexed_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>In response to <code>ListIndex</code>, the <code>ObjectIdentifier</code> of the object attached to the index. In response to <code>ListAttachedIndices</code>, the <code>ObjectIdentifier</code> of the index attached to the object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side of the attachment specified in the query.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl IndexAttachment {
    /// <p>The indexed attribute values.</p>
    pub fn indexed_attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.indexed_attributes.as_deref()
    }
    /// <p>In response to <code>ListIndex</code>, the <code>ObjectIdentifier</code> of the object attached to the index. In response to <code>ListAttachedIndices</code>, the <code>ObjectIdentifier</code> of the index attached to the object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side of the attachment specified in the query.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for IndexAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexAttachment");
        formatter.field("indexed_attributes", &self.indexed_attributes);
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`IndexAttachment`](crate::model::IndexAttachment)
pub mod index_attachment {
    /// A builder for [`IndexAttachment`](crate::model::IndexAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) indexed_attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `indexed_attributes`.
        ///
        /// To override the contents of this collection use [`set_indexed_attributes`](Self::set_indexed_attributes).
        ///
        /// <p>The indexed attribute values.</p>
        pub fn indexed_attributes(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.indexed_attributes.unwrap_or_default();
            v.push(input);
            self.indexed_attributes = Some(v);
            self
        }
        /// <p>The indexed attribute values.</p>
        pub fn set_indexed_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.indexed_attributes = input;
            self
        }
        /// <p>In response to <code>ListIndex</code>, the <code>ObjectIdentifier</code> of the object attached to the index. In response to <code>ListAttachedIndices</code>, the <code>ObjectIdentifier</code> of the index attached to the object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side of the attachment specified in the query.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>In response to <code>ListIndex</code>, the <code>ObjectIdentifier</code> of the object attached to the index. In response to <code>ListAttachedIndices</code>, the <code>ObjectIdentifier</code> of the index attached to the object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side of the attachment specified in the query.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexAttachment`](crate::model::IndexAttachment)
        pub fn build(self) -> crate::model::IndexAttachment {
            crate::model::IndexAttachment {
                indexed_attributes: self.indexed_attributes,
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl IndexAttachment {
    /// Creates a new builder-style object to manufacture [`IndexAttachment`](crate::model::IndexAttachment)
    pub fn builder() -> crate::model::index_attachment::Builder {
        crate::model::index_attachment::Builder::default()
    }
}

/// <p>A range of attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectAttributeRange {
    /// <p>The key of the attribute that the attribute range covers.</p>
    pub attribute_key: std::option::Option<crate::model::AttributeKey>,
    /// <p>The range of attribute values being selected.</p>
    pub range: std::option::Option<crate::model::TypedAttributeValueRange>,
}
impl ObjectAttributeRange {
    /// <p>The key of the attribute that the attribute range covers.</p>
    pub fn attribute_key(&self) -> std::option::Option<&crate::model::AttributeKey> {
        self.attribute_key.as_ref()
    }
    /// <p>The range of attribute values being selected.</p>
    pub fn range(&self) -> std::option::Option<&crate::model::TypedAttributeValueRange> {
        self.range.as_ref()
    }
}
impl std::fmt::Debug for ObjectAttributeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectAttributeRange");
        formatter.field("attribute_key", &self.attribute_key);
        formatter.field("range", &self.range);
        formatter.finish()
    }
}
/// See [`ObjectAttributeRange`](crate::model::ObjectAttributeRange)
pub mod object_attribute_range {
    /// A builder for [`ObjectAttributeRange`](crate::model::ObjectAttributeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_key: std::option::Option<crate::model::AttributeKey>,
        pub(crate) range: std::option::Option<crate::model::TypedAttributeValueRange>,
    }
    impl Builder {
        /// <p>The key of the attribute that the attribute range covers.</p>
        pub fn attribute_key(mut self, input: crate::model::AttributeKey) -> Self {
            self.attribute_key = Some(input);
            self
        }
        /// <p>The key of the attribute that the attribute range covers.</p>
        pub fn set_attribute_key(
            mut self,
            input: std::option::Option<crate::model::AttributeKey>,
        ) -> Self {
            self.attribute_key = input;
            self
        }
        /// <p>The range of attribute values being selected.</p>
        pub fn range(mut self, input: crate::model::TypedAttributeValueRange) -> Self {
            self.range = Some(input);
            self
        }
        /// <p>The range of attribute values being selected.</p>
        pub fn set_range(
            mut self,
            input: std::option::Option<crate::model::TypedAttributeValueRange>,
        ) -> Self {
            self.range = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectAttributeRange`](crate::model::ObjectAttributeRange)
        pub fn build(self) -> crate::model::ObjectAttributeRange {
            crate::model::ObjectAttributeRange {
                attribute_key: self.attribute_key,
                range: self.range,
            }
        }
    }
}
impl ObjectAttributeRange {
    /// Creates a new builder-style object to manufacture [`ObjectAttributeRange`](crate::model::ObjectAttributeRange)
    pub fn builder() -> crate::model::object_attribute_range::Builder {
        crate::model::object_attribute_range::Builder::default()
    }
}

/// <p>Directory structure that includes the directory name and directory ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Directory {
    /// <p>The name of the directory.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <code>arns</code>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.</p>
    pub state: std::option::Option<crate::model::DirectoryState>,
    /// <p>The date and time when the directory was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Directory {
    /// <p>The name of the directory.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <code>arns</code>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DirectoryState> {
        self.state.as_ref()
    }
    /// <p>The date and time when the directory was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for Directory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Directory");
        formatter.field("name", &self.name);
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("state", &self.state);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`Directory`](crate::model::Directory)
pub mod directory {
    /// A builder for [`Directory`](crate::model::Directory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DirectoryState>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the directory.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the directory.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <code>arns</code>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <code>arns</code>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.</p>
        pub fn state(mut self, input: crate::model::DirectoryState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DirectoryState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time when the directory was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the directory was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Directory`](crate::model::Directory)
        pub fn build(self) -> crate::model::Directory {
            crate::model::Directory {
                name: self.name,
                directory_arn: self.directory_arn,
                state: self.state,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl Directory {
    /// Creates a new builder-style object to manufacture [`Directory`](crate::model::Directory)
    pub fn builder() -> crate::model::directory::Builder {
        crate::model::directory::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectoryState {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectoryState {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => DirectoryState::Deleted,
            "DISABLED" => DirectoryState::Disabled,
            "ENABLED" => DirectoryState::Enabled,
            other => DirectoryState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectoryState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectoryState::from(s))
    }
}
impl DirectoryState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectoryState::Deleted => "DELETED",
            DirectoryState::Disabled => "DISABLED",
            DirectoryState::Enabled => "ENABLED",
            DirectoryState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DirectoryState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains <code>Name</code>, <code>ARN</code>, <code>Attributes</code>, <code> <code>Rule</code>s</code>, and <code>ObjectTypes</code>. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_whatarefacets.html">Facets</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Facet {
    /// <p>The name of the <code>Facet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
    pub object_type: std::option::Option<crate::model::ObjectType>,
    /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
    pub facet_style: std::option::Option<crate::model::FacetStyle>,
}
impl Facet {
    /// <p>The name of the <code>Facet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
    pub fn object_type(&self) -> std::option::Option<&crate::model::ObjectType> {
        self.object_type.as_ref()
    }
    /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
    pub fn facet_style(&self) -> std::option::Option<&crate::model::FacetStyle> {
        self.facet_style.as_ref()
    }
}
impl std::fmt::Debug for Facet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Facet");
        formatter.field("name", &self.name);
        formatter.field("object_type", &self.object_type);
        formatter.field("facet_style", &self.facet_style);
        formatter.finish()
    }
}
/// See [`Facet`](crate::model::Facet)
pub mod facet {
    /// A builder for [`Facet`](crate::model::Facet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) object_type: std::option::Option<crate::model::ObjectType>,
        pub(crate) facet_style: std::option::Option<crate::model::FacetStyle>,
    }
    impl Builder {
        /// <p>The name of the <code>Facet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Facet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn object_type(mut self, input: crate::model::ObjectType) -> Self {
            self.object_type = Some(input);
            self
        }
        /// <p>The object type that is associated with the facet. See <code>CreateFacetRequest$ObjectType</code> for more details.</p>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.object_type = input;
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn facet_style(mut self, input: crate::model::FacetStyle) -> Self {
            self.facet_style = Some(input);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn set_facet_style(
            mut self,
            input: std::option::Option<crate::model::FacetStyle>,
        ) -> Self {
            self.facet_style = input;
            self
        }
        /// Consumes the builder and constructs a [`Facet`](crate::model::Facet)
        pub fn build(self) -> crate::model::Facet {
            crate::model::Facet {
                name: self.name,
                object_type: self.object_type,
                facet_style: self.facet_style,
            }
        }
    }
}
impl Facet {
    /// Creates a new builder-style object to manufacture [`Facet`](crate::model::Facet)
    pub fn builder() -> crate::model::facet::Builder {
        crate::model::facet::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FacetStyle {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FacetStyle {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMIC" => FacetStyle::Dynamic,
            "STATIC" => FacetStyle::Static,
            other => FacetStyle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FacetStyle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FacetStyle::from(s))
    }
}
impl FacetStyle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FacetStyle::Dynamic => "DYNAMIC",
            FacetStyle::Static => "STATIC",
            FacetStyle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMIC", "STATIC"]
    }
}
impl AsRef<str> for FacetStyle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the typed links structure and its attributes. To create a typed link facet, use the <code>CreateTypedLinkFacet</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypedLinkFacet {
    /// <p>The unique name of the typed link facet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
    /// <p>The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See <code>ListOutgoingTypedLinks</code> and <code>ListIncomingTypedLinks</code> for details.</p>
    pub identity_attribute_order: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TypedLinkFacet {
    /// <p>The unique name of the typed link facet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::TypedLinkAttributeDefinition]> {
        self.attributes.as_deref()
    }
    /// <p>The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See <code>ListOutgoingTypedLinks</code> and <code>ListIncomingTypedLinks</code> for details.</p>
    pub fn identity_attribute_order(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_attribute_order.as_deref()
    }
}
impl std::fmt::Debug for TypedLinkFacet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypedLinkFacet");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("identity_attribute_order", &self.identity_attribute_order);
        formatter.finish()
    }
}
/// See [`TypedLinkFacet`](crate::model::TypedLinkFacet)
pub mod typed_link_facet {
    /// A builder for [`TypedLinkFacet`](crate::model::TypedLinkFacet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
        pub(crate) identity_attribute_order:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.</p>
        pub fn attributes(mut self, input: crate::model::TypedLinkAttributeDefinition) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `identity_attribute_order`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_order`](Self::set_identity_attribute_order).
        ///
        /// <p>The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See <code>ListOutgoingTypedLinks</code> and <code>ListIncomingTypedLinks</code> for details.</p>
        pub fn identity_attribute_order(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_attribute_order.unwrap_or_default();
            v.push(input.into());
            self.identity_attribute_order = Some(v);
            self
        }
        /// <p>The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See <code>ListOutgoingTypedLinks</code> and <code>ListIncomingTypedLinks</code> for details.</p>
        pub fn set_identity_attribute_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_attribute_order = input;
            self
        }
        /// Consumes the builder and constructs a [`TypedLinkFacet`](crate::model::TypedLinkFacet)
        pub fn build(self) -> crate::model::TypedLinkFacet {
            crate::model::TypedLinkFacet {
                name: self.name,
                attributes: self.attributes,
                identity_attribute_order: self.identity_attribute_order,
            }
        }
    }
}
impl TypedLinkFacet {
    /// Creates a new builder-style object to manufacture [`TypedLinkFacet`](crate::model::TypedLinkFacet)
    pub fn builder() -> crate::model::typed_link_facet::Builder {
        crate::model::typed_link_facet::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchWriteExceptionType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException,
    #[allow(missing_docs)] // documentation missing in model
    DirectoryNotEnabledException,
    #[allow(missing_docs)] // documentation missing in model
    FacetValidationException,
    #[allow(missing_docs)] // documentation missing in model
    IndexedAttributeMissingException,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArnException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAttachmentException,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceededException,
    #[allow(missing_docs)] // documentation missing in model
    LinkNameAlreadyInUseException,
    #[allow(missing_docs)] // documentation missing in model
    NotIndexException,
    #[allow(missing_docs)] // documentation missing in model
    NotNodeException,
    #[allow(missing_docs)] // documentation missing in model
    NotPolicyException,
    #[allow(missing_docs)] // documentation missing in model
    ObjectAlreadyDetachedException,
    #[allow(missing_docs)] // documentation missing in model
    ObjectNotDetachedException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    StillContainsLinksException,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedIndexTypeException,
    #[allow(missing_docs)] // documentation missing in model
    ValidationException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchWriteExceptionType {
    fn from(s: &str) -> Self {
        match s {
            "AccessDeniedException" => BatchWriteExceptionType::AccessDeniedException,
            "DirectoryNotEnabledException" => BatchWriteExceptionType::DirectoryNotEnabledException,
            "FacetValidationException" => BatchWriteExceptionType::FacetValidationException,
            "IndexedAttributeMissingException" => {
                BatchWriteExceptionType::IndexedAttributeMissingException
            }
            "InternalServiceException" => BatchWriteExceptionType::InternalServiceException,
            "InvalidArnException" => BatchWriteExceptionType::InvalidArnException,
            "InvalidAttachmentException" => BatchWriteExceptionType::InvalidAttachmentException,
            "LimitExceededException" => BatchWriteExceptionType::LimitExceededException,
            "LinkNameAlreadyInUseException" => {
                BatchWriteExceptionType::LinkNameAlreadyInUseException
            }
            "NotIndexException" => BatchWriteExceptionType::NotIndexException,
            "NotNodeException" => BatchWriteExceptionType::NotNodeException,
            "NotPolicyException" => BatchWriteExceptionType::NotPolicyException,
            "ObjectAlreadyDetachedException" => {
                BatchWriteExceptionType::ObjectAlreadyDetachedException
            }
            "ObjectNotDetachedException" => BatchWriteExceptionType::ObjectNotDetachedException,
            "ResourceNotFoundException" => BatchWriteExceptionType::ResourceNotFoundException,
            "StillContainsLinksException" => BatchWriteExceptionType::StillContainsLinksException,
            "UnsupportedIndexTypeException" => {
                BatchWriteExceptionType::UnsupportedIndexTypeException
            }
            "ValidationException" => BatchWriteExceptionType::ValidationException,
            other => BatchWriteExceptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchWriteExceptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchWriteExceptionType::from(s))
    }
}
impl BatchWriteExceptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchWriteExceptionType::AccessDeniedException => "AccessDeniedException",
            BatchWriteExceptionType::DirectoryNotEnabledException => "DirectoryNotEnabledException",
            BatchWriteExceptionType::FacetValidationException => "FacetValidationException",
            BatchWriteExceptionType::IndexedAttributeMissingException => {
                "IndexedAttributeMissingException"
            }
            BatchWriteExceptionType::InternalServiceException => "InternalServiceException",
            BatchWriteExceptionType::InvalidArnException => "InvalidArnException",
            BatchWriteExceptionType::InvalidAttachmentException => "InvalidAttachmentException",
            BatchWriteExceptionType::LimitExceededException => "LimitExceededException",
            BatchWriteExceptionType::LinkNameAlreadyInUseException => {
                "LinkNameAlreadyInUseException"
            }
            BatchWriteExceptionType::NotIndexException => "NotIndexException",
            BatchWriteExceptionType::NotNodeException => "NotNodeException",
            BatchWriteExceptionType::NotPolicyException => "NotPolicyException",
            BatchWriteExceptionType::ObjectAlreadyDetachedException => {
                "ObjectAlreadyDetachedException"
            }
            BatchWriteExceptionType::ObjectNotDetachedException => "ObjectNotDetachedException",
            BatchWriteExceptionType::ResourceNotFoundException => "ResourceNotFoundException",
            BatchWriteExceptionType::StillContainsLinksException => "StillContainsLinksException",
            BatchWriteExceptionType::UnsupportedIndexTypeException => {
                "UnsupportedIndexTypeException"
            }
            BatchWriteExceptionType::ValidationException => "ValidationException",
            BatchWriteExceptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDeniedException",
            "DirectoryNotEnabledException",
            "FacetValidationException",
            "IndexedAttributeMissingException",
            "InternalServiceException",
            "InvalidArnException",
            "InvalidAttachmentException",
            "LimitExceededException",
            "LinkNameAlreadyInUseException",
            "NotIndexException",
            "NotNodeException",
            "NotPolicyException",
            "ObjectAlreadyDetachedException",
            "ObjectNotDetachedException",
            "ResourceNotFoundException",
            "StillContainsLinksException",
            "UnsupportedIndexTypeException",
            "ValidationException",
        ]
    }
}
impl AsRef<str> for BatchWriteExceptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of a <code>BatchWrite</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteOperationResponse {
    /// <p>Creates an object in a <code>Directory</code>.</p>
    pub create_object: std::option::Option<crate::model::BatchCreateObjectResponse>,
    /// <p>Attaches an object to a <code>Directory</code>.</p>
    pub attach_object: std::option::Option<crate::model::BatchAttachObjectResponse>,
    /// <p>Detaches an object from a <code>Directory</code>.</p>
    pub detach_object: std::option::Option<crate::model::BatchDetachObjectResponse>,
    /// <p>Updates a given object’s attributes.</p>
    pub update_object_attributes:
        std::option::Option<crate::model::BatchUpdateObjectAttributesResponse>,
    /// <p>Deletes an object in a <code>Directory</code>.</p>
    pub delete_object: std::option::Option<crate::model::BatchDeleteObjectResponse>,
    /// <p>The result of an add facet to object batch operation.</p>
    pub add_facet_to_object: std::option::Option<crate::model::BatchAddFacetToObjectResponse>,
    /// <p>The result of a batch remove facet from object operation.</p>
    pub remove_facet_from_object:
        std::option::Option<crate::model::BatchRemoveFacetFromObjectResponse>,
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
    pub attach_policy: std::option::Option<crate::model::BatchAttachPolicyResponse>,
    /// <p>Detaches a policy from a <code>Directory</code>.</p>
    pub detach_policy: std::option::Option<crate::model::BatchDetachPolicyResponse>,
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
    pub create_index: std::option::Option<crate::model::BatchCreateIndexResponse>,
    /// <p>Attaches the specified object to the specified index.</p>
    pub attach_to_index: std::option::Option<crate::model::BatchAttachToIndexResponse>,
    /// <p>Detaches the specified object from the specified index.</p>
    pub detach_from_index: std::option::Option<crate::model::BatchDetachFromIndexResponse>,
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub attach_typed_link: std::option::Option<crate::model::BatchAttachTypedLinkResponse>,
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub detach_typed_link: std::option::Option<crate::model::BatchDetachTypedLinkResponse>,
    /// <p>Represents the output of a <code>BatchWrite</code> response operation.</p>
    pub update_link_attributes:
        std::option::Option<crate::model::BatchUpdateLinkAttributesResponse>,
}
impl BatchWriteOperationResponse {
    /// <p>Creates an object in a <code>Directory</code>.</p>
    pub fn create_object(&self) -> std::option::Option<&crate::model::BatchCreateObjectResponse> {
        self.create_object.as_ref()
    }
    /// <p>Attaches an object to a <code>Directory</code>.</p>
    pub fn attach_object(&self) -> std::option::Option<&crate::model::BatchAttachObjectResponse> {
        self.attach_object.as_ref()
    }
    /// <p>Detaches an object from a <code>Directory</code>.</p>
    pub fn detach_object(&self) -> std::option::Option<&crate::model::BatchDetachObjectResponse> {
        self.detach_object.as_ref()
    }
    /// <p>Updates a given object’s attributes.</p>
    pub fn update_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchUpdateObjectAttributesResponse> {
        self.update_object_attributes.as_ref()
    }
    /// <p>Deletes an object in a <code>Directory</code>.</p>
    pub fn delete_object(&self) -> std::option::Option<&crate::model::BatchDeleteObjectResponse> {
        self.delete_object.as_ref()
    }
    /// <p>The result of an add facet to object batch operation.</p>
    pub fn add_facet_to_object(
        &self,
    ) -> std::option::Option<&crate::model::BatchAddFacetToObjectResponse> {
        self.add_facet_to_object.as_ref()
    }
    /// <p>The result of a batch remove facet from object operation.</p>
    pub fn remove_facet_from_object(
        &self,
    ) -> std::option::Option<&crate::model::BatchRemoveFacetFromObjectResponse> {
        self.remove_facet_from_object.as_ref()
    }
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
    pub fn attach_policy(&self) -> std::option::Option<&crate::model::BatchAttachPolicyResponse> {
        self.attach_policy.as_ref()
    }
    /// <p>Detaches a policy from a <code>Directory</code>.</p>
    pub fn detach_policy(&self) -> std::option::Option<&crate::model::BatchDetachPolicyResponse> {
        self.detach_policy.as_ref()
    }
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
    pub fn create_index(&self) -> std::option::Option<&crate::model::BatchCreateIndexResponse> {
        self.create_index.as_ref()
    }
    /// <p>Attaches the specified object to the specified index.</p>
    pub fn attach_to_index(
        &self,
    ) -> std::option::Option<&crate::model::BatchAttachToIndexResponse> {
        self.attach_to_index.as_ref()
    }
    /// <p>Detaches the specified object from the specified index.</p>
    pub fn detach_from_index(
        &self,
    ) -> std::option::Option<&crate::model::BatchDetachFromIndexResponse> {
        self.detach_from_index.as_ref()
    }
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn attach_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::BatchAttachTypedLinkResponse> {
        self.attach_typed_link.as_ref()
    }
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn detach_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::BatchDetachTypedLinkResponse> {
        self.detach_typed_link.as_ref()
    }
    /// <p>Represents the output of a <code>BatchWrite</code> response operation.</p>
    pub fn update_link_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchUpdateLinkAttributesResponse> {
        self.update_link_attributes.as_ref()
    }
}
impl std::fmt::Debug for BatchWriteOperationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteOperationResponse");
        formatter.field("create_object", &self.create_object);
        formatter.field("attach_object", &self.attach_object);
        formatter.field("detach_object", &self.detach_object);
        formatter.field("update_object_attributes", &self.update_object_attributes);
        formatter.field("delete_object", &self.delete_object);
        formatter.field("add_facet_to_object", &self.add_facet_to_object);
        formatter.field("remove_facet_from_object", &self.remove_facet_from_object);
        formatter.field("attach_policy", &self.attach_policy);
        formatter.field("detach_policy", &self.detach_policy);
        formatter.field("create_index", &self.create_index);
        formatter.field("attach_to_index", &self.attach_to_index);
        formatter.field("detach_from_index", &self.detach_from_index);
        formatter.field("attach_typed_link", &self.attach_typed_link);
        formatter.field("detach_typed_link", &self.detach_typed_link);
        formatter.field("update_link_attributes", &self.update_link_attributes);
        formatter.finish()
    }
}
/// See [`BatchWriteOperationResponse`](crate::model::BatchWriteOperationResponse)
pub mod batch_write_operation_response {
    /// A builder for [`BatchWriteOperationResponse`](crate::model::BatchWriteOperationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_object: std::option::Option<crate::model::BatchCreateObjectResponse>,
        pub(crate) attach_object: std::option::Option<crate::model::BatchAttachObjectResponse>,
        pub(crate) detach_object: std::option::Option<crate::model::BatchDetachObjectResponse>,
        pub(crate) update_object_attributes:
            std::option::Option<crate::model::BatchUpdateObjectAttributesResponse>,
        pub(crate) delete_object: std::option::Option<crate::model::BatchDeleteObjectResponse>,
        pub(crate) add_facet_to_object:
            std::option::Option<crate::model::BatchAddFacetToObjectResponse>,
        pub(crate) remove_facet_from_object:
            std::option::Option<crate::model::BatchRemoveFacetFromObjectResponse>,
        pub(crate) attach_policy: std::option::Option<crate::model::BatchAttachPolicyResponse>,
        pub(crate) detach_policy: std::option::Option<crate::model::BatchDetachPolicyResponse>,
        pub(crate) create_index: std::option::Option<crate::model::BatchCreateIndexResponse>,
        pub(crate) attach_to_index: std::option::Option<crate::model::BatchAttachToIndexResponse>,
        pub(crate) detach_from_index:
            std::option::Option<crate::model::BatchDetachFromIndexResponse>,
        pub(crate) attach_typed_link:
            std::option::Option<crate::model::BatchAttachTypedLinkResponse>,
        pub(crate) detach_typed_link:
            std::option::Option<crate::model::BatchDetachTypedLinkResponse>,
        pub(crate) update_link_attributes:
            std::option::Option<crate::model::BatchUpdateLinkAttributesResponse>,
    }
    impl Builder {
        /// <p>Creates an object in a <code>Directory</code>.</p>
        pub fn create_object(mut self, input: crate::model::BatchCreateObjectResponse) -> Self {
            self.create_object = Some(input);
            self
        }
        /// <p>Creates an object in a <code>Directory</code>.</p>
        pub fn set_create_object(
            mut self,
            input: std::option::Option<crate::model::BatchCreateObjectResponse>,
        ) -> Self {
            self.create_object = input;
            self
        }
        /// <p>Attaches an object to a <code>Directory</code>.</p>
        pub fn attach_object(mut self, input: crate::model::BatchAttachObjectResponse) -> Self {
            self.attach_object = Some(input);
            self
        }
        /// <p>Attaches an object to a <code>Directory</code>.</p>
        pub fn set_attach_object(
            mut self,
            input: std::option::Option<crate::model::BatchAttachObjectResponse>,
        ) -> Self {
            self.attach_object = input;
            self
        }
        /// <p>Detaches an object from a <code>Directory</code>.</p>
        pub fn detach_object(mut self, input: crate::model::BatchDetachObjectResponse) -> Self {
            self.detach_object = Some(input);
            self
        }
        /// <p>Detaches an object from a <code>Directory</code>.</p>
        pub fn set_detach_object(
            mut self,
            input: std::option::Option<crate::model::BatchDetachObjectResponse>,
        ) -> Self {
            self.detach_object = input;
            self
        }
        /// <p>Updates a given object’s attributes.</p>
        pub fn update_object_attributes(
            mut self,
            input: crate::model::BatchUpdateObjectAttributesResponse,
        ) -> Self {
            self.update_object_attributes = Some(input);
            self
        }
        /// <p>Updates a given object’s attributes.</p>
        pub fn set_update_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchUpdateObjectAttributesResponse>,
        ) -> Self {
            self.update_object_attributes = input;
            self
        }
        /// <p>Deletes an object in a <code>Directory</code>.</p>
        pub fn delete_object(mut self, input: crate::model::BatchDeleteObjectResponse) -> Self {
            self.delete_object = Some(input);
            self
        }
        /// <p>Deletes an object in a <code>Directory</code>.</p>
        pub fn set_delete_object(
            mut self,
            input: std::option::Option<crate::model::BatchDeleteObjectResponse>,
        ) -> Self {
            self.delete_object = input;
            self
        }
        /// <p>The result of an add facet to object batch operation.</p>
        pub fn add_facet_to_object(
            mut self,
            input: crate::model::BatchAddFacetToObjectResponse,
        ) -> Self {
            self.add_facet_to_object = Some(input);
            self
        }
        /// <p>The result of an add facet to object batch operation.</p>
        pub fn set_add_facet_to_object(
            mut self,
            input: std::option::Option<crate::model::BatchAddFacetToObjectResponse>,
        ) -> Self {
            self.add_facet_to_object = input;
            self
        }
        /// <p>The result of a batch remove facet from object operation.</p>
        pub fn remove_facet_from_object(
            mut self,
            input: crate::model::BatchRemoveFacetFromObjectResponse,
        ) -> Self {
            self.remove_facet_from_object = Some(input);
            self
        }
        /// <p>The result of a batch remove facet from object operation.</p>
        pub fn set_remove_facet_from_object(
            mut self,
            input: std::option::Option<crate::model::BatchRemoveFacetFromObjectResponse>,
        ) -> Self {
            self.remove_facet_from_object = input;
            self
        }
        /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
        pub fn attach_policy(mut self, input: crate::model::BatchAttachPolicyResponse) -> Self {
            self.attach_policy = Some(input);
            self
        }
        /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
        pub fn set_attach_policy(
            mut self,
            input: std::option::Option<crate::model::BatchAttachPolicyResponse>,
        ) -> Self {
            self.attach_policy = input;
            self
        }
        /// <p>Detaches a policy from a <code>Directory</code>.</p>
        pub fn detach_policy(mut self, input: crate::model::BatchDetachPolicyResponse) -> Self {
            self.detach_policy = Some(input);
            self
        }
        /// <p>Detaches a policy from a <code>Directory</code>.</p>
        pub fn set_detach_policy(
            mut self,
            input: std::option::Option<crate::model::BatchDetachPolicyResponse>,
        ) -> Self {
            self.detach_policy = input;
            self
        }
        /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
        pub fn create_index(mut self, input: crate::model::BatchCreateIndexResponse) -> Self {
            self.create_index = Some(input);
            self
        }
        /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
        pub fn set_create_index(
            mut self,
            input: std::option::Option<crate::model::BatchCreateIndexResponse>,
        ) -> Self {
            self.create_index = input;
            self
        }
        /// <p>Attaches the specified object to the specified index.</p>
        pub fn attach_to_index(mut self, input: crate::model::BatchAttachToIndexResponse) -> Self {
            self.attach_to_index = Some(input);
            self
        }
        /// <p>Attaches the specified object to the specified index.</p>
        pub fn set_attach_to_index(
            mut self,
            input: std::option::Option<crate::model::BatchAttachToIndexResponse>,
        ) -> Self {
            self.attach_to_index = input;
            self
        }
        /// <p>Detaches the specified object from the specified index.</p>
        pub fn detach_from_index(
            mut self,
            input: crate::model::BatchDetachFromIndexResponse,
        ) -> Self {
            self.detach_from_index = Some(input);
            self
        }
        /// <p>Detaches the specified object from the specified index.</p>
        pub fn set_detach_from_index(
            mut self,
            input: std::option::Option<crate::model::BatchDetachFromIndexResponse>,
        ) -> Self {
            self.detach_from_index = input;
            self
        }
        /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn attach_typed_link(
            mut self,
            input: crate::model::BatchAttachTypedLinkResponse,
        ) -> Self {
            self.attach_typed_link = Some(input);
            self
        }
        /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_attach_typed_link(
            mut self,
            input: std::option::Option<crate::model::BatchAttachTypedLinkResponse>,
        ) -> Self {
            self.attach_typed_link = input;
            self
        }
        /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn detach_typed_link(
            mut self,
            input: crate::model::BatchDetachTypedLinkResponse,
        ) -> Self {
            self.detach_typed_link = Some(input);
            self
        }
        /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_detach_typed_link(
            mut self,
            input: std::option::Option<crate::model::BatchDetachTypedLinkResponse>,
        ) -> Self {
            self.detach_typed_link = input;
            self
        }
        /// <p>Represents the output of a <code>BatchWrite</code> response operation.</p>
        pub fn update_link_attributes(
            mut self,
            input: crate::model::BatchUpdateLinkAttributesResponse,
        ) -> Self {
            self.update_link_attributes = Some(input);
            self
        }
        /// <p>Represents the output of a <code>BatchWrite</code> response operation.</p>
        pub fn set_update_link_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchUpdateLinkAttributesResponse>,
        ) -> Self {
            self.update_link_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteOperationResponse`](crate::model::BatchWriteOperationResponse)
        pub fn build(self) -> crate::model::BatchWriteOperationResponse {
            crate::model::BatchWriteOperationResponse {
                create_object: self.create_object,
                attach_object: self.attach_object,
                detach_object: self.detach_object,
                update_object_attributes: self.update_object_attributes,
                delete_object: self.delete_object,
                add_facet_to_object: self.add_facet_to_object,
                remove_facet_from_object: self.remove_facet_from_object,
                attach_policy: self.attach_policy,
                detach_policy: self.detach_policy,
                create_index: self.create_index,
                attach_to_index: self.attach_to_index,
                detach_from_index: self.detach_from_index,
                attach_typed_link: self.attach_typed_link,
                detach_typed_link: self.detach_typed_link,
                update_link_attributes: self.update_link_attributes,
            }
        }
    }
}
impl BatchWriteOperationResponse {
    /// Creates a new builder-style object to manufacture [`BatchWriteOperationResponse`](crate::model::BatchWriteOperationResponse)
    pub fn builder() -> crate::model::batch_write_operation_response::Builder {
        crate::model::batch_write_operation_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>UpdateLinkAttributes</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateLinkAttributesResponse {}
impl std::fmt::Debug for BatchUpdateLinkAttributesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateLinkAttributesResponse");
        formatter.finish()
    }
}
/// See [`BatchUpdateLinkAttributesResponse`](crate::model::BatchUpdateLinkAttributesResponse)
pub mod batch_update_link_attributes_response {
    /// A builder for [`BatchUpdateLinkAttributesResponse`](crate::model::BatchUpdateLinkAttributesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchUpdateLinkAttributesResponse`](crate::model::BatchUpdateLinkAttributesResponse)
        pub fn build(self) -> crate::model::BatchUpdateLinkAttributesResponse {
            crate::model::BatchUpdateLinkAttributesResponse {}
        }
    }
}
impl BatchUpdateLinkAttributesResponse {
    /// Creates a new builder-style object to manufacture [`BatchUpdateLinkAttributesResponse`](crate::model::BatchUpdateLinkAttributesResponse)
    pub fn builder() -> crate::model::batch_update_link_attributes_response::Builder {
        crate::model::batch_update_link_attributes_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>DetachTypedLink</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachTypedLinkResponse {}
impl std::fmt::Debug for BatchDetachTypedLinkResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachTypedLinkResponse");
        formatter.finish()
    }
}
/// See [`BatchDetachTypedLinkResponse`](crate::model::BatchDetachTypedLinkResponse)
pub mod batch_detach_typed_link_response {
    /// A builder for [`BatchDetachTypedLinkResponse`](crate::model::BatchDetachTypedLinkResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchDetachTypedLinkResponse`](crate::model::BatchDetachTypedLinkResponse)
        pub fn build(self) -> crate::model::BatchDetachTypedLinkResponse {
            crate::model::BatchDetachTypedLinkResponse {}
        }
    }
}
impl BatchDetachTypedLinkResponse {
    /// Creates a new builder-style object to manufacture [`BatchDetachTypedLinkResponse`](crate::model::BatchDetachTypedLinkResponse)
    pub fn builder() -> crate::model::batch_detach_typed_link_response::Builder {
        crate::model::batch_detach_typed_link_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>AttachTypedLink</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachTypedLinkResponse {
    /// <p>Returns a typed link specifier as output.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
}
impl BatchAttachTypedLinkResponse {
    /// <p>Returns a typed link specifier as output.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
}
impl std::fmt::Debug for BatchAttachTypedLinkResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachTypedLinkResponse");
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.finish()
    }
}
/// See [`BatchAttachTypedLinkResponse`](crate::model::BatchAttachTypedLinkResponse)
pub mod batch_attach_typed_link_response {
    /// A builder for [`BatchAttachTypedLinkResponse`](crate::model::BatchAttachTypedLinkResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    }
    impl Builder {
        /// <p>Returns a typed link specifier as output.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Returns a typed link specifier as output.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachTypedLinkResponse`](crate::model::BatchAttachTypedLinkResponse)
        pub fn build(self) -> crate::model::BatchAttachTypedLinkResponse {
            crate::model::BatchAttachTypedLinkResponse {
                typed_link_specifier: self.typed_link_specifier,
            }
        }
    }
}
impl BatchAttachTypedLinkResponse {
    /// Creates a new builder-style object to manufacture [`BatchAttachTypedLinkResponse`](crate::model::BatchAttachTypedLinkResponse)
    pub fn builder() -> crate::model::batch_attach_typed_link_response::Builder {
        crate::model::batch_attach_typed_link_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>DetachFromIndex</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachFromIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
    pub detached_object_identifier: std::option::Option<std::string::String>,
}
impl BatchDetachFromIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
    pub fn detached_object_identifier(&self) -> std::option::Option<&str> {
        self.detached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchDetachFromIndexResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachFromIndexResponse");
        formatter.field(
            "detached_object_identifier",
            &self.detached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`BatchDetachFromIndexResponse`](crate::model::BatchDetachFromIndexResponse)
pub mod batch_detach_from_index_response {
    /// A builder for [`BatchDetachFromIndexResponse`](crate::model::BatchDetachFromIndexResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
        pub fn detached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.detached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
        pub fn set_detached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachFromIndexResponse`](crate::model::BatchDetachFromIndexResponse)
        pub fn build(self) -> crate::model::BatchDetachFromIndexResponse {
            crate::model::BatchDetachFromIndexResponse {
                detached_object_identifier: self.detached_object_identifier,
            }
        }
    }
}
impl BatchDetachFromIndexResponse {
    /// Creates a new builder-style object to manufacture [`BatchDetachFromIndexResponse`](crate::model::BatchDetachFromIndexResponse)
    pub fn builder() -> crate::model::batch_detach_from_index_response::Builder {
        crate::model::batch_detach_from_index_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>AttachToIndex</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachToIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
    pub attached_object_identifier: std::option::Option<std::string::String>,
}
impl BatchAttachToIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
    pub fn attached_object_identifier(&self) -> std::option::Option<&str> {
        self.attached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchAttachToIndexResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachToIndexResponse");
        formatter.field(
            "attached_object_identifier",
            &self.attached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`BatchAttachToIndexResponse`](crate::model::BatchAttachToIndexResponse)
pub mod batch_attach_to_index_response {
    /// A builder for [`BatchAttachToIndexResponse`](crate::model::BatchAttachToIndexResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
        pub fn attached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
        pub fn set_attached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachToIndexResponse`](crate::model::BatchAttachToIndexResponse)
        pub fn build(self) -> crate::model::BatchAttachToIndexResponse {
            crate::model::BatchAttachToIndexResponse {
                attached_object_identifier: self.attached_object_identifier,
            }
        }
    }
}
impl BatchAttachToIndexResponse {
    /// Creates a new builder-style object to manufacture [`BatchAttachToIndexResponse`](crate::model::BatchAttachToIndexResponse)
    pub fn builder() -> crate::model::batch_attach_to_index_response::Builder {
        crate::model::batch_attach_to_index_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateIndex</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl BatchCreateIndexResponse {
    /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateIndexResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateIndexResponse");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`BatchCreateIndexResponse`](crate::model::BatchCreateIndexResponse)
pub mod batch_create_index_response {
    /// A builder for [`BatchCreateIndexResponse`](crate::model::BatchCreateIndexResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateIndexResponse`](crate::model::BatchCreateIndexResponse)
        pub fn build(self) -> crate::model::BatchCreateIndexResponse {
            crate::model::BatchCreateIndexResponse {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl BatchCreateIndexResponse {
    /// Creates a new builder-style object to manufacture [`BatchCreateIndexResponse`](crate::model::BatchCreateIndexResponse)
    pub fn builder() -> crate::model::batch_create_index_response::Builder {
        crate::model::batch_create_index_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>DetachPolicy</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachPolicyResponse {}
impl std::fmt::Debug for BatchDetachPolicyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachPolicyResponse");
        formatter.finish()
    }
}
/// See [`BatchDetachPolicyResponse`](crate::model::BatchDetachPolicyResponse)
pub mod batch_detach_policy_response {
    /// A builder for [`BatchDetachPolicyResponse`](crate::model::BatchDetachPolicyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchDetachPolicyResponse`](crate::model::BatchDetachPolicyResponse)
        pub fn build(self) -> crate::model::BatchDetachPolicyResponse {
            crate::model::BatchDetachPolicyResponse {}
        }
    }
}
impl BatchDetachPolicyResponse {
    /// Creates a new builder-style object to manufacture [`BatchDetachPolicyResponse`](crate::model::BatchDetachPolicyResponse)
    pub fn builder() -> crate::model::batch_detach_policy_response::Builder {
        crate::model::batch_detach_policy_response::Builder::default()
    }
}

/// <p>Represents the output of an <code>AttachPolicy</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachPolicyResponse {}
impl std::fmt::Debug for BatchAttachPolicyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachPolicyResponse");
        formatter.finish()
    }
}
/// See [`BatchAttachPolicyResponse`](crate::model::BatchAttachPolicyResponse)
pub mod batch_attach_policy_response {
    /// A builder for [`BatchAttachPolicyResponse`](crate::model::BatchAttachPolicyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchAttachPolicyResponse`](crate::model::BatchAttachPolicyResponse)
        pub fn build(self) -> crate::model::BatchAttachPolicyResponse {
            crate::model::BatchAttachPolicyResponse {}
        }
    }
}
impl BatchAttachPolicyResponse {
    /// Creates a new builder-style object to manufacture [`BatchAttachPolicyResponse`](crate::model::BatchAttachPolicyResponse)
    pub fn builder() -> crate::model::batch_attach_policy_response::Builder {
        crate::model::batch_attach_policy_response::Builder::default()
    }
}

/// <p>An empty result that represents success.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRemoveFacetFromObjectResponse {}
impl std::fmt::Debug for BatchRemoveFacetFromObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRemoveFacetFromObjectResponse");
        formatter.finish()
    }
}
/// See [`BatchRemoveFacetFromObjectResponse`](crate::model::BatchRemoveFacetFromObjectResponse)
pub mod batch_remove_facet_from_object_response {
    /// A builder for [`BatchRemoveFacetFromObjectResponse`](crate::model::BatchRemoveFacetFromObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchRemoveFacetFromObjectResponse`](crate::model::BatchRemoveFacetFromObjectResponse)
        pub fn build(self) -> crate::model::BatchRemoveFacetFromObjectResponse {
            crate::model::BatchRemoveFacetFromObjectResponse {}
        }
    }
}
impl BatchRemoveFacetFromObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchRemoveFacetFromObjectResponse`](crate::model::BatchRemoveFacetFromObjectResponse)
    pub fn builder() -> crate::model::batch_remove_facet_from_object_response::Builder {
        crate::model::batch_remove_facet_from_object_response::Builder::default()
    }
}

/// <p>The result of a batch add facet to object operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAddFacetToObjectResponse {}
impl std::fmt::Debug for BatchAddFacetToObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAddFacetToObjectResponse");
        formatter.finish()
    }
}
/// See [`BatchAddFacetToObjectResponse`](crate::model::BatchAddFacetToObjectResponse)
pub mod batch_add_facet_to_object_response {
    /// A builder for [`BatchAddFacetToObjectResponse`](crate::model::BatchAddFacetToObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchAddFacetToObjectResponse`](crate::model::BatchAddFacetToObjectResponse)
        pub fn build(self) -> crate::model::BatchAddFacetToObjectResponse {
            crate::model::BatchAddFacetToObjectResponse {}
        }
    }
}
impl BatchAddFacetToObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchAddFacetToObjectResponse`](crate::model::BatchAddFacetToObjectResponse)
    pub fn builder() -> crate::model::batch_add_facet_to_object_response::Builder {
        crate::model::batch_add_facet_to_object_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteObject</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteObjectResponse {}
impl std::fmt::Debug for BatchDeleteObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteObjectResponse");
        formatter.finish()
    }
}
/// See [`BatchDeleteObjectResponse`](crate::model::BatchDeleteObjectResponse)
pub mod batch_delete_object_response {
    /// A builder for [`BatchDeleteObjectResponse`](crate::model::BatchDeleteObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BatchDeleteObjectResponse`](crate::model::BatchDeleteObjectResponse)
        pub fn build(self) -> crate::model::BatchDeleteObjectResponse {
            crate::model::BatchDeleteObjectResponse {}
        }
    }
}
impl BatchDeleteObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchDeleteObjectResponse`](crate::model::BatchDeleteObjectResponse)
    pub fn builder() -> crate::model::batch_delete_object_response::Builder {
        crate::model::batch_delete_object_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchUpdate</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateObjectAttributesResponse {
    /// <p>ID that is associated with the object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl BatchUpdateObjectAttributesResponse {
    /// <p>ID that is associated with the object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateObjectAttributesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateObjectAttributesResponse");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`BatchUpdateObjectAttributesResponse`](crate::model::BatchUpdateObjectAttributesResponse)
pub mod batch_update_object_attributes_response {
    /// A builder for [`BatchUpdateObjectAttributesResponse`](crate::model::BatchUpdateObjectAttributesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID that is associated with the object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>ID that is associated with the object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateObjectAttributesResponse`](crate::model::BatchUpdateObjectAttributesResponse)
        pub fn build(self) -> crate::model::BatchUpdateObjectAttributesResponse {
            crate::model::BatchUpdateObjectAttributesResponse {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl BatchUpdateObjectAttributesResponse {
    /// Creates a new builder-style object to manufacture [`BatchUpdateObjectAttributesResponse`](crate::model::BatchUpdateObjectAttributesResponse)
    pub fn builder() -> crate::model::batch_update_object_attributes_response::Builder {
        crate::model::batch_update_object_attributes_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>DetachObject</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachObjectResponse {
    /// <p>The <code>ObjectIdentifier</code> of the detached object.</p>
    pub detached_object_identifier: std::option::Option<std::string::String>,
}
impl BatchDetachObjectResponse {
    /// <p>The <code>ObjectIdentifier</code> of the detached object.</p>
    pub fn detached_object_identifier(&self) -> std::option::Option<&str> {
        self.detached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchDetachObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachObjectResponse");
        formatter.field(
            "detached_object_identifier",
            &self.detached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`BatchDetachObjectResponse`](crate::model::BatchDetachObjectResponse)
pub mod batch_detach_object_response {
    /// A builder for [`BatchDetachObjectResponse`](crate::model::BatchDetachObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the detached object.</p>
        pub fn detached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.detached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the detached object.</p>
        pub fn set_detached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachObjectResponse`](crate::model::BatchDetachObjectResponse)
        pub fn build(self) -> crate::model::BatchDetachObjectResponse {
            crate::model::BatchDetachObjectResponse {
                detached_object_identifier: self.detached_object_identifier,
            }
        }
    }
}
impl BatchDetachObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchDetachObjectResponse`](crate::model::BatchDetachObjectResponse)
    pub fn builder() -> crate::model::batch_detach_object_response::Builder {
        crate::model::batch_detach_object_response::Builder::default()
    }
}

/// <p>Represents the output batch <code>AttachObject</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachObjectResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that has been attached.</p>
    pub attached_object_identifier: std::option::Option<std::string::String>,
}
impl BatchAttachObjectResponse {
    /// <p>The <code>ObjectIdentifier</code> of the object that has been attached.</p>
    pub fn attached_object_identifier(&self) -> std::option::Option<&str> {
        self.attached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchAttachObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachObjectResponse");
        formatter.field(
            "attached_object_identifier",
            &self.attached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`BatchAttachObjectResponse`](crate::model::BatchAttachObjectResponse)
pub mod batch_attach_object_response {
    /// A builder for [`BatchAttachObjectResponse`](crate::model::BatchAttachObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the object that has been attached.</p>
        pub fn attached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the object that has been attached.</p>
        pub fn set_attached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachObjectResponse`](crate::model::BatchAttachObjectResponse)
        pub fn build(self) -> crate::model::BatchAttachObjectResponse {
            crate::model::BatchAttachObjectResponse {
                attached_object_identifier: self.attached_object_identifier,
            }
        }
    }
}
impl BatchAttachObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchAttachObjectResponse`](crate::model::BatchAttachObjectResponse)
    pub fn builder() -> crate::model::batch_attach_object_response::Builder {
        crate::model::batch_attach_object_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateObject</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateObjectResponse {
    /// <p>The ID that is associated with the object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl BatchCreateObjectResponse {
    /// <p>The ID that is associated with the object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateObjectResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateObjectResponse");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`BatchCreateObjectResponse`](crate::model::BatchCreateObjectResponse)
pub mod batch_create_object_response {
    /// A builder for [`BatchCreateObjectResponse`](crate::model::BatchCreateObjectResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that is associated with the object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The ID that is associated with the object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateObjectResponse`](crate::model::BatchCreateObjectResponse)
        pub fn build(self) -> crate::model::BatchCreateObjectResponse {
            crate::model::BatchCreateObjectResponse {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl BatchCreateObjectResponse {
    /// Creates a new builder-style object to manufacture [`BatchCreateObjectResponse`](crate::model::BatchCreateObjectResponse)
    pub fn builder() -> crate::model::batch_create_object_response::Builder {
        crate::model::batch_create_object_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchWrite</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteOperation {
    /// <p>Creates an object.</p>
    pub create_object: std::option::Option<crate::model::BatchCreateObject>,
    /// <p>Attaches an object to a <code>Directory</code>.</p>
    pub attach_object: std::option::Option<crate::model::BatchAttachObject>,
    /// <p>Detaches an object from a <code>Directory</code>.</p>
    pub detach_object: std::option::Option<crate::model::BatchDetachObject>,
    /// <p>Updates a given object's attributes.</p>
    pub update_object_attributes: std::option::Option<crate::model::BatchUpdateObjectAttributes>,
    /// <p>Deletes an object in a <code>Directory</code>.</p>
    pub delete_object: std::option::Option<crate::model::BatchDeleteObject>,
    /// <p>A batch operation that adds a facet to an object.</p>
    pub add_facet_to_object: std::option::Option<crate::model::BatchAddFacetToObject>,
    /// <p>A batch operation that removes a facet from an object.</p>
    pub remove_facet_from_object: std::option::Option<crate::model::BatchRemoveFacetFromObject>,
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
    pub attach_policy: std::option::Option<crate::model::BatchAttachPolicy>,
    /// <p>Detaches a policy from a <code>Directory</code>.</p>
    pub detach_policy: std::option::Option<crate::model::BatchDetachPolicy>,
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
    pub create_index: std::option::Option<crate::model::BatchCreateIndex>,
    /// <p>Attaches the specified object to the specified index.</p>
    pub attach_to_index: std::option::Option<crate::model::BatchAttachToIndex>,
    /// <p>Detaches the specified object from the specified index.</p>
    pub detach_from_index: std::option::Option<crate::model::BatchDetachFromIndex>,
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub attach_typed_link: std::option::Option<crate::model::BatchAttachTypedLink>,
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub detach_typed_link: std::option::Option<crate::model::BatchDetachTypedLink>,
    /// <p>Updates a given object's attributes.</p>
    pub update_link_attributes: std::option::Option<crate::model::BatchUpdateLinkAttributes>,
}
impl BatchWriteOperation {
    /// <p>Creates an object.</p>
    pub fn create_object(&self) -> std::option::Option<&crate::model::BatchCreateObject> {
        self.create_object.as_ref()
    }
    /// <p>Attaches an object to a <code>Directory</code>.</p>
    pub fn attach_object(&self) -> std::option::Option<&crate::model::BatchAttachObject> {
        self.attach_object.as_ref()
    }
    /// <p>Detaches an object from a <code>Directory</code>.</p>
    pub fn detach_object(&self) -> std::option::Option<&crate::model::BatchDetachObject> {
        self.detach_object.as_ref()
    }
    /// <p>Updates a given object's attributes.</p>
    pub fn update_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchUpdateObjectAttributes> {
        self.update_object_attributes.as_ref()
    }
    /// <p>Deletes an object in a <code>Directory</code>.</p>
    pub fn delete_object(&self) -> std::option::Option<&crate::model::BatchDeleteObject> {
        self.delete_object.as_ref()
    }
    /// <p>A batch operation that adds a facet to an object.</p>
    pub fn add_facet_to_object(&self) -> std::option::Option<&crate::model::BatchAddFacetToObject> {
        self.add_facet_to_object.as_ref()
    }
    /// <p>A batch operation that removes a facet from an object.</p>
    pub fn remove_facet_from_object(
        &self,
    ) -> std::option::Option<&crate::model::BatchRemoveFacetFromObject> {
        self.remove_facet_from_object.as_ref()
    }
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
    pub fn attach_policy(&self) -> std::option::Option<&crate::model::BatchAttachPolicy> {
        self.attach_policy.as_ref()
    }
    /// <p>Detaches a policy from a <code>Directory</code>.</p>
    pub fn detach_policy(&self) -> std::option::Option<&crate::model::BatchDetachPolicy> {
        self.detach_policy.as_ref()
    }
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
    pub fn create_index(&self) -> std::option::Option<&crate::model::BatchCreateIndex> {
        self.create_index.as_ref()
    }
    /// <p>Attaches the specified object to the specified index.</p>
    pub fn attach_to_index(&self) -> std::option::Option<&crate::model::BatchAttachToIndex> {
        self.attach_to_index.as_ref()
    }
    /// <p>Detaches the specified object from the specified index.</p>
    pub fn detach_from_index(&self) -> std::option::Option<&crate::model::BatchDetachFromIndex> {
        self.detach_from_index.as_ref()
    }
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn attach_typed_link(&self) -> std::option::Option<&crate::model::BatchAttachTypedLink> {
        self.attach_typed_link.as_ref()
    }
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn detach_typed_link(&self) -> std::option::Option<&crate::model::BatchDetachTypedLink> {
        self.detach_typed_link.as_ref()
    }
    /// <p>Updates a given object's attributes.</p>
    pub fn update_link_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchUpdateLinkAttributes> {
        self.update_link_attributes.as_ref()
    }
}
impl std::fmt::Debug for BatchWriteOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteOperation");
        formatter.field("create_object", &self.create_object);
        formatter.field("attach_object", &self.attach_object);
        formatter.field("detach_object", &self.detach_object);
        formatter.field("update_object_attributes", &self.update_object_attributes);
        formatter.field("delete_object", &self.delete_object);
        formatter.field("add_facet_to_object", &self.add_facet_to_object);
        formatter.field("remove_facet_from_object", &self.remove_facet_from_object);
        formatter.field("attach_policy", &self.attach_policy);
        formatter.field("detach_policy", &self.detach_policy);
        formatter.field("create_index", &self.create_index);
        formatter.field("attach_to_index", &self.attach_to_index);
        formatter.field("detach_from_index", &self.detach_from_index);
        formatter.field("attach_typed_link", &self.attach_typed_link);
        formatter.field("detach_typed_link", &self.detach_typed_link);
        formatter.field("update_link_attributes", &self.update_link_attributes);
        formatter.finish()
    }
}
/// See [`BatchWriteOperation`](crate::model::BatchWriteOperation)
pub mod batch_write_operation {
    /// A builder for [`BatchWriteOperation`](crate::model::BatchWriteOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_object: std::option::Option<crate::model::BatchCreateObject>,
        pub(crate) attach_object: std::option::Option<crate::model::BatchAttachObject>,
        pub(crate) detach_object: std::option::Option<crate::model::BatchDetachObject>,
        pub(crate) update_object_attributes:
            std::option::Option<crate::model::BatchUpdateObjectAttributes>,
        pub(crate) delete_object: std::option::Option<crate::model::BatchDeleteObject>,
        pub(crate) add_facet_to_object: std::option::Option<crate::model::BatchAddFacetToObject>,
        pub(crate) remove_facet_from_object:
            std::option::Option<crate::model::BatchRemoveFacetFromObject>,
        pub(crate) attach_policy: std::option::Option<crate::model::BatchAttachPolicy>,
        pub(crate) detach_policy: std::option::Option<crate::model::BatchDetachPolicy>,
        pub(crate) create_index: std::option::Option<crate::model::BatchCreateIndex>,
        pub(crate) attach_to_index: std::option::Option<crate::model::BatchAttachToIndex>,
        pub(crate) detach_from_index: std::option::Option<crate::model::BatchDetachFromIndex>,
        pub(crate) attach_typed_link: std::option::Option<crate::model::BatchAttachTypedLink>,
        pub(crate) detach_typed_link: std::option::Option<crate::model::BatchDetachTypedLink>,
        pub(crate) update_link_attributes:
            std::option::Option<crate::model::BatchUpdateLinkAttributes>,
    }
    impl Builder {
        /// <p>Creates an object.</p>
        pub fn create_object(mut self, input: crate::model::BatchCreateObject) -> Self {
            self.create_object = Some(input);
            self
        }
        /// <p>Creates an object.</p>
        pub fn set_create_object(
            mut self,
            input: std::option::Option<crate::model::BatchCreateObject>,
        ) -> Self {
            self.create_object = input;
            self
        }
        /// <p>Attaches an object to a <code>Directory</code>.</p>
        pub fn attach_object(mut self, input: crate::model::BatchAttachObject) -> Self {
            self.attach_object = Some(input);
            self
        }
        /// <p>Attaches an object to a <code>Directory</code>.</p>
        pub fn set_attach_object(
            mut self,
            input: std::option::Option<crate::model::BatchAttachObject>,
        ) -> Self {
            self.attach_object = input;
            self
        }
        /// <p>Detaches an object from a <code>Directory</code>.</p>
        pub fn detach_object(mut self, input: crate::model::BatchDetachObject) -> Self {
            self.detach_object = Some(input);
            self
        }
        /// <p>Detaches an object from a <code>Directory</code>.</p>
        pub fn set_detach_object(
            mut self,
            input: std::option::Option<crate::model::BatchDetachObject>,
        ) -> Self {
            self.detach_object = input;
            self
        }
        /// <p>Updates a given object's attributes.</p>
        pub fn update_object_attributes(
            mut self,
            input: crate::model::BatchUpdateObjectAttributes,
        ) -> Self {
            self.update_object_attributes = Some(input);
            self
        }
        /// <p>Updates a given object's attributes.</p>
        pub fn set_update_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchUpdateObjectAttributes>,
        ) -> Self {
            self.update_object_attributes = input;
            self
        }
        /// <p>Deletes an object in a <code>Directory</code>.</p>
        pub fn delete_object(mut self, input: crate::model::BatchDeleteObject) -> Self {
            self.delete_object = Some(input);
            self
        }
        /// <p>Deletes an object in a <code>Directory</code>.</p>
        pub fn set_delete_object(
            mut self,
            input: std::option::Option<crate::model::BatchDeleteObject>,
        ) -> Self {
            self.delete_object = input;
            self
        }
        /// <p>A batch operation that adds a facet to an object.</p>
        pub fn add_facet_to_object(mut self, input: crate::model::BatchAddFacetToObject) -> Self {
            self.add_facet_to_object = Some(input);
            self
        }
        /// <p>A batch operation that adds a facet to an object.</p>
        pub fn set_add_facet_to_object(
            mut self,
            input: std::option::Option<crate::model::BatchAddFacetToObject>,
        ) -> Self {
            self.add_facet_to_object = input;
            self
        }
        /// <p>A batch operation that removes a facet from an object.</p>
        pub fn remove_facet_from_object(
            mut self,
            input: crate::model::BatchRemoveFacetFromObject,
        ) -> Self {
            self.remove_facet_from_object = Some(input);
            self
        }
        /// <p>A batch operation that removes a facet from an object.</p>
        pub fn set_remove_facet_from_object(
            mut self,
            input: std::option::Option<crate::model::BatchRemoveFacetFromObject>,
        ) -> Self {
            self.remove_facet_from_object = input;
            self
        }
        /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
        pub fn attach_policy(mut self, input: crate::model::BatchAttachPolicy) -> Self {
            self.attach_policy = Some(input);
            self
        }
        /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached policies.</p>
        pub fn set_attach_policy(
            mut self,
            input: std::option::Option<crate::model::BatchAttachPolicy>,
        ) -> Self {
            self.attach_policy = input;
            self
        }
        /// <p>Detaches a policy from a <code>Directory</code>.</p>
        pub fn detach_policy(mut self, input: crate::model::BatchDetachPolicy) -> Self {
            self.detach_policy = Some(input);
            self
        }
        /// <p>Detaches a policy from a <code>Directory</code>.</p>
        pub fn set_detach_policy(
            mut self,
            input: std::option::Option<crate::model::BatchDetachPolicy>,
        ) -> Self {
            self.detach_policy = input;
            self
        }
        /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
        pub fn create_index(mut self, input: crate::model::BatchCreateIndex) -> Self {
            self.create_index = Some(input);
            self
        }
        /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and search</a> for more information.</p>
        pub fn set_create_index(
            mut self,
            input: std::option::Option<crate::model::BatchCreateIndex>,
        ) -> Self {
            self.create_index = input;
            self
        }
        /// <p>Attaches the specified object to the specified index.</p>
        pub fn attach_to_index(mut self, input: crate::model::BatchAttachToIndex) -> Self {
            self.attach_to_index = Some(input);
            self
        }
        /// <p>Attaches the specified object to the specified index.</p>
        pub fn set_attach_to_index(
            mut self,
            input: std::option::Option<crate::model::BatchAttachToIndex>,
        ) -> Self {
            self.attach_to_index = input;
            self
        }
        /// <p>Detaches the specified object from the specified index.</p>
        pub fn detach_from_index(mut self, input: crate::model::BatchDetachFromIndex) -> Self {
            self.detach_from_index = Some(input);
            self
        }
        /// <p>Detaches the specified object from the specified index.</p>
        pub fn set_detach_from_index(
            mut self,
            input: std::option::Option<crate::model::BatchDetachFromIndex>,
        ) -> Self {
            self.detach_from_index = input;
            self
        }
        /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn attach_typed_link(mut self, input: crate::model::BatchAttachTypedLink) -> Self {
            self.attach_typed_link = Some(input);
            self
        }
        /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_attach_typed_link(
            mut self,
            input: std::option::Option<crate::model::BatchAttachTypedLink>,
        ) -> Self {
            self.attach_typed_link = input;
            self
        }
        /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn detach_typed_link(mut self, input: crate::model::BatchDetachTypedLink) -> Self {
            self.detach_typed_link = Some(input);
            self
        }
        /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_detach_typed_link(
            mut self,
            input: std::option::Option<crate::model::BatchDetachTypedLink>,
        ) -> Self {
            self.detach_typed_link = input;
            self
        }
        /// <p>Updates a given object's attributes.</p>
        pub fn update_link_attributes(
            mut self,
            input: crate::model::BatchUpdateLinkAttributes,
        ) -> Self {
            self.update_link_attributes = Some(input);
            self
        }
        /// <p>Updates a given object's attributes.</p>
        pub fn set_update_link_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchUpdateLinkAttributes>,
        ) -> Self {
            self.update_link_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteOperation`](crate::model::BatchWriteOperation)
        pub fn build(self) -> crate::model::BatchWriteOperation {
            crate::model::BatchWriteOperation {
                create_object: self.create_object,
                attach_object: self.attach_object,
                detach_object: self.detach_object,
                update_object_attributes: self.update_object_attributes,
                delete_object: self.delete_object,
                add_facet_to_object: self.add_facet_to_object,
                remove_facet_from_object: self.remove_facet_from_object,
                attach_policy: self.attach_policy,
                detach_policy: self.detach_policy,
                create_index: self.create_index,
                attach_to_index: self.attach_to_index,
                detach_from_index: self.detach_from_index,
                attach_typed_link: self.attach_typed_link,
                detach_typed_link: self.detach_typed_link,
                update_link_attributes: self.update_link_attributes,
            }
        }
    }
}
impl BatchWriteOperation {
    /// Creates a new builder-style object to manufacture [`BatchWriteOperation`](crate::model::BatchWriteOperation)
    pub fn builder() -> crate::model::batch_write_operation::Builder {
        crate::model::batch_write_operation::Builder::default()
    }
}

/// <p>Updates a given typed link’s attributes inside a <code>BatchRead</code> operation. Attributes to be updated must not contribute to the typed link’s identity, as defined by its <code>IdentityAttributeOrder</code>. For more information, see <code>UpdateLinkAttributes</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateLinkAttributes {
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    /// <p>The attributes update structure.</p>
    pub attribute_updates: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
}
impl BatchUpdateLinkAttributes {
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
    /// <p>The attributes update structure.</p>
    pub fn attribute_updates(&self) -> std::option::Option<&[crate::model::LinkAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateLinkAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateLinkAttributes");
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.finish()
    }
}
/// See [`BatchUpdateLinkAttributes`](crate::model::BatchUpdateLinkAttributes)
pub mod batch_update_link_attributes {
    /// A builder for [`BatchUpdateLinkAttributes`](crate::model::BatchUpdateLinkAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
    }
    impl Builder {
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::LinkAttributeUpdate) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateLinkAttributes`](crate::model::BatchUpdateLinkAttributes)
        pub fn build(self) -> crate::model::BatchUpdateLinkAttributes {
            crate::model::BatchUpdateLinkAttributes {
                typed_link_specifier: self.typed_link_specifier,
                attribute_updates: self.attribute_updates,
            }
        }
    }
}
impl BatchUpdateLinkAttributes {
    /// Creates a new builder-style object to manufacture [`BatchUpdateLinkAttributes`](crate::model::BatchUpdateLinkAttributes)
    pub fn builder() -> crate::model::batch_update_link_attributes::Builder {
        crate::model::batch_update_link_attributes::Builder::default()
    }
}

/// <p>Detaches a typed link from a specified source and target object inside a <code>BatchRead</code> operation. For more information, see <code>DetachTypedLink</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachTypedLink {
    /// <p>Used to accept a typed link specifier as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
}
impl BatchDetachTypedLink {
    /// <p>Used to accept a typed link specifier as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
}
impl std::fmt::Debug for BatchDetachTypedLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachTypedLink");
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.finish()
    }
}
/// See [`BatchDetachTypedLink`](crate::model::BatchDetachTypedLink)
pub mod batch_detach_typed_link {
    /// A builder for [`BatchDetachTypedLink`](crate::model::BatchDetachTypedLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    }
    impl Builder {
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachTypedLink`](crate::model::BatchDetachTypedLink)
        pub fn build(self) -> crate::model::BatchDetachTypedLink {
            crate::model::BatchDetachTypedLink {
                typed_link_specifier: self.typed_link_specifier,
            }
        }
    }
}
impl BatchDetachTypedLink {
    /// Creates a new builder-style object to manufacture [`BatchDetachTypedLink`](crate::model::BatchDetachTypedLink)
    pub fn builder() -> crate::model::batch_detach_typed_link::Builder {
        crate::model::batch_detach_typed_link::Builder::default()
    }
}

/// <p>Attaches a typed link to a specified source and target object inside a <code>BatchRead</code> operation. For more information, see <code>AttachTypedLink</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachTypedLink {
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub source_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub target_object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>A set of attributes that are associated with the typed link.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
}
impl BatchAttachTypedLink {
    /// <p>Identifies the source object that the typed link will attach to.</p>
    pub fn source_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.source_object_reference.as_ref()
    }
    /// <p>Identifies the target object that the typed link will attach to.</p>
    pub fn target_object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_object_reference.as_ref()
    }
    /// <p>Identifies the typed link facet that is associated with the typed link.</p>
    pub fn typed_link_facet(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.typed_link_facet.as_ref()
    }
    /// <p>A set of attributes that are associated with the typed link.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeNameAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for BatchAttachTypedLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachTypedLink");
        formatter.field("source_object_reference", &self.source_object_reference);
        formatter.field("target_object_reference", &self.target_object_reference);
        formatter.field("typed_link_facet", &self.typed_link_facet);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`BatchAttachTypedLink`](crate::model::BatchAttachTypedLink)
pub mod batch_attach_typed_link {
    /// A builder for [`BatchAttachTypedLink`](crate::model::BatchAttachTypedLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) typed_link_facet: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
    }
    impl Builder {
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn source_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.source_object_reference = Some(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn set_source_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.source_object_reference = input;
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn target_object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_object_reference = Some(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn set_target_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_object_reference = input;
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn typed_link_facet(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.typed_link_facet = Some(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn set_typed_link_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.typed_link_facet = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, input: crate::model::AttributeNameAndValue) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachTypedLink`](crate::model::BatchAttachTypedLink)
        pub fn build(self) -> crate::model::BatchAttachTypedLink {
            crate::model::BatchAttachTypedLink {
                source_object_reference: self.source_object_reference,
                target_object_reference: self.target_object_reference,
                typed_link_facet: self.typed_link_facet,
                attributes: self.attributes,
            }
        }
    }
}
impl BatchAttachTypedLink {
    /// Creates a new builder-style object to manufacture [`BatchAttachTypedLink`](crate::model::BatchAttachTypedLink)
    pub fn builder() -> crate::model::batch_attach_typed_link::Builder {
        crate::model::batch_attach_typed_link::Builder::default()
    }
}

/// <p>Detaches the specified object from the specified index inside a <code>BatchRead</code> operation. For more information, see <code>DetachFromIndex</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachFromIndex {
    /// <p>A reference to the index object.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>A reference to the object being detached from the index.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchDetachFromIndex {
    /// <p>A reference to the index object.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>A reference to the object being detached from the index.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchDetachFromIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachFromIndex");
        formatter.field("index_reference", &self.index_reference);
        formatter.field("target_reference", &self.target_reference);
        formatter.finish()
    }
}
/// See [`BatchDetachFromIndex`](crate::model::BatchDetachFromIndex)
pub mod batch_detach_from_index {
    /// A builder for [`BatchDetachFromIndex`](crate::model::BatchDetachFromIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>A reference to the index object.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachFromIndex`](crate::model::BatchDetachFromIndex)
        pub fn build(self) -> crate::model::BatchDetachFromIndex {
            crate::model::BatchDetachFromIndex {
                index_reference: self.index_reference,
                target_reference: self.target_reference,
            }
        }
    }
}
impl BatchDetachFromIndex {
    /// Creates a new builder-style object to manufacture [`BatchDetachFromIndex`](crate::model::BatchDetachFromIndex)
    pub fn builder() -> crate::model::batch_detach_from_index::Builder {
        crate::model::batch_detach_from_index::Builder::default()
    }
}

/// <p>Attaches the specified object to the specified index inside a <code>BatchRead</code> operation. For more information, see <code>AttachToIndex</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachToIndex {
    /// <p>A reference to the index that you are attaching the object to.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>A reference to the object that you are attaching to the index.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchAttachToIndex {
    /// <p>A reference to the index that you are attaching the object to.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>A reference to the object that you are attaching to the index.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchAttachToIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachToIndex");
        formatter.field("index_reference", &self.index_reference);
        formatter.field("target_reference", &self.target_reference);
        formatter.finish()
    }
}
/// See [`BatchAttachToIndex`](crate::model::BatchAttachToIndex)
pub mod batch_attach_to_index {
    /// A builder for [`BatchAttachToIndex`](crate::model::BatchAttachToIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachToIndex`](crate::model::BatchAttachToIndex)
        pub fn build(self) -> crate::model::BatchAttachToIndex {
            crate::model::BatchAttachToIndex {
                index_reference: self.index_reference,
                target_reference: self.target_reference,
            }
        }
    }
}
impl BatchAttachToIndex {
    /// Creates a new builder-style object to manufacture [`BatchAttachToIndex`](crate::model::BatchAttachToIndex)
    pub fn builder() -> crate::model::batch_attach_to_index::Builder {
        crate::model::batch_attach_to_index::Builder::default()
    }
}

/// <p>Creates an index object inside of a <code>BatchRead</code> operation. For more information, see <code>CreateIndex</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateIndex {
    /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
    pub ordered_indexed_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
    /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
    pub is_unique: bool,
    /// <p>A reference to the parent object that contains the index object.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of the link between the parent object and the index object.</p>
    pub link_name: std::option::Option<std::string::String>,
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub batch_reference_name: std::option::Option<std::string::String>,
}
impl BatchCreateIndex {
    /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
    pub fn ordered_indexed_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKey]> {
        self.ordered_indexed_attribute_list.as_deref()
    }
    /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
    pub fn is_unique(&self) -> bool {
        self.is_unique
    }
    /// <p>A reference to the parent object that contains the index object.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The name of the link between the parent object and the index object.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub fn batch_reference_name(&self) -> std::option::Option<&str> {
        self.batch_reference_name.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateIndex");
        formatter.field(
            "ordered_indexed_attribute_list",
            &self.ordered_indexed_attribute_list,
        );
        formatter.field("is_unique", &self.is_unique);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.field("batch_reference_name", &self.batch_reference_name);
        formatter.finish()
    }
}
/// See [`BatchCreateIndex`](crate::model::BatchCreateIndex)
pub mod batch_create_index {
    /// A builder for [`BatchCreateIndex`](crate::model::BatchCreateIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ordered_indexed_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        pub(crate) is_unique: std::option::Option<bool>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
        pub(crate) batch_reference_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ordered_indexed_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_ordered_indexed_attribute_list`](Self::set_ordered_indexed_attribute_list).
        ///
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn ordered_indexed_attribute_list(mut self, input: crate::model::AttributeKey) -> Self {
            let mut v = self.ordered_indexed_attribute_list.unwrap_or_default();
            v.push(input);
            self.ordered_indexed_attribute_list = Some(v);
            self
        }
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute is supported.</p>
        pub fn set_ordered_indexed_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        ) -> Self {
            self.ordered_indexed_attribute_list = input;
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn is_unique(mut self, input: bool) -> Self {
            self.is_unique = Some(input);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or not.</p>
        pub fn set_is_unique(mut self, input: std::option::Option<bool>) -> Self {
            self.is_unique = input;
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn batch_reference_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_reference_name = Some(input.into());
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn set_batch_reference_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_reference_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateIndex`](crate::model::BatchCreateIndex)
        pub fn build(self) -> crate::model::BatchCreateIndex {
            crate::model::BatchCreateIndex {
                ordered_indexed_attribute_list: self.ordered_indexed_attribute_list,
                is_unique: self.is_unique.unwrap_or_default(),
                parent_reference: self.parent_reference,
                link_name: self.link_name,
                batch_reference_name: self.batch_reference_name,
            }
        }
    }
}
impl BatchCreateIndex {
    /// Creates a new builder-style object to manufacture [`BatchCreateIndex`](crate::model::BatchCreateIndex)
    pub fn builder() -> crate::model::batch_create_index::Builder {
        crate::model::batch_create_index::Builder::default()
    }
}

/// <p>Detaches the specified policy from the specified directory inside a <code>BatchWrite</code> operation. For more information, see <code>DetachPolicy</code> and <code>BatchWriteRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachPolicy {
    /// <p>Reference that identifies the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Reference that identifies the object whose policy object will be detached.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchDetachPolicy {
    /// <p>Reference that identifies the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>Reference that identifies the object whose policy object will be detached.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchDetachPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachPolicy");
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchDetachPolicy`](crate::model::BatchDetachPolicy)
pub mod batch_detach_policy {
    /// A builder for [`BatchDetachPolicy`](crate::model::BatchDetachPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>Reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachPolicy`](crate::model::BatchDetachPolicy)
        pub fn build(self) -> crate::model::BatchDetachPolicy {
            crate::model::BatchDetachPolicy {
                policy_reference: self.policy_reference,
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchDetachPolicy {
    /// Creates a new builder-style object to manufacture [`BatchDetachPolicy`](crate::model::BatchDetachPolicy)
    pub fn builder() -> crate::model::batch_detach_policy::Builder {
        crate::model::batch_detach_policy::Builder::default()
    }
}

/// <p>Attaches a policy object to a regular object inside a <code>BatchRead</code> operation.&nbsp;For more information, see <code>AttachPolicy</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachPolicy {
    /// <p>The reference that is associated with the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The reference that identifies the object to which the policy will be attached.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchAttachPolicy {
    /// <p>The reference that is associated with the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>The reference that identifies the object to which the policy will be attached.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchAttachPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachPolicy");
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchAttachPolicy`](crate::model::BatchAttachPolicy)
pub mod batch_attach_policy {
    /// A builder for [`BatchAttachPolicy`](crate::model::BatchAttachPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The reference that is associated with the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be attached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachPolicy`](crate::model::BatchAttachPolicy)
        pub fn build(self) -> crate::model::BatchAttachPolicy {
            crate::model::BatchAttachPolicy {
                policy_reference: self.policy_reference,
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchAttachPolicy {
    /// Creates a new builder-style object to manufacture [`BatchAttachPolicy`](crate::model::BatchAttachPolicy)
    pub fn builder() -> crate::model::batch_attach_policy::Builder {
        crate::model::batch_attach_policy::Builder::default()
    }
}

/// <p>A batch operation to remove a facet from an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRemoveFacetFromObject {
    /// <p>The facet to remove from the object.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>A reference to the object whose facet will be removed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchRemoveFacetFromObject {
    /// <p>The facet to remove from the object.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>A reference to the object whose facet will be removed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchRemoveFacetFromObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRemoveFacetFromObject");
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchRemoveFacetFromObject`](crate::model::BatchRemoveFacetFromObject)
pub mod batch_remove_facet_from_object {
    /// A builder for [`BatchRemoveFacetFromObject`](crate::model::BatchRemoveFacetFromObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The facet to remove from the object.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>The facet to remove from the object.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// <p>A reference to the object whose facet will be removed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object whose facet will be removed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchRemoveFacetFromObject`](crate::model::BatchRemoveFacetFromObject)
        pub fn build(self) -> crate::model::BatchRemoveFacetFromObject {
            crate::model::BatchRemoveFacetFromObject {
                schema_facet: self.schema_facet,
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchRemoveFacetFromObject {
    /// Creates a new builder-style object to manufacture [`BatchRemoveFacetFromObject`](crate::model::BatchRemoveFacetFromObject)
    pub fn builder() -> crate::model::batch_remove_facet_from_object::Builder {
        crate::model::batch_remove_facet_from_object::Builder::default()
    }
}

/// <p>Represents the output of a batch add facet to object operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAddFacetToObject {
    /// <p>Represents the facet being added to the object.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>The attributes to set on the object.</p>
    pub object_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>A reference to the object being mutated.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchAddFacetToObject {
    /// <p>Represents the facet being added to the object.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>The attributes to set on the object.</p>
    pub fn object_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.object_attribute_list.as_deref()
    }
    /// <p>A reference to the object being mutated.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchAddFacetToObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAddFacetToObject");
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("object_attribute_list", &self.object_attribute_list);
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchAddFacetToObject`](crate::model::BatchAddFacetToObject)
pub mod batch_add_facet_to_object {
    /// A builder for [`BatchAddFacetToObject`](crate::model::BatchAddFacetToObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) object_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>Represents the facet being added to the object.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>Represents the facet being added to the object.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// Appends an item to `object_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>The attributes to set on the object.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.object_attribute_list.unwrap_or_default();
            v.push(input);
            self.object_attribute_list = Some(v);
            self
        }
        /// <p>The attributes to set on the object.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.object_attribute_list = input;
            self
        }
        /// <p>A reference to the object being mutated.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object being mutated.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAddFacetToObject`](crate::model::BatchAddFacetToObject)
        pub fn build(self) -> crate::model::BatchAddFacetToObject {
            crate::model::BatchAddFacetToObject {
                schema_facet: self.schema_facet,
                object_attribute_list: self.object_attribute_list,
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchAddFacetToObject {
    /// Creates a new builder-style object to manufacture [`BatchAddFacetToObject`](crate::model::BatchAddFacetToObject)
    pub fn builder() -> crate::model::batch_add_facet_to_object::Builder {
        crate::model::batch_add_facet_to_object::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteObject</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteObject {
    /// <p>The reference that identifies the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchDeleteObject {
    /// <p>The reference that identifies the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchDeleteObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteObject");
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchDeleteObject`](crate::model::BatchDeleteObject)
pub mod batch_delete_object {
    /// A builder for [`BatchDeleteObject`](crate::model::BatchDeleteObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>The reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteObject`](crate::model::BatchDeleteObject)
        pub fn build(self) -> crate::model::BatchDeleteObject {
            crate::model::BatchDeleteObject {
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchDeleteObject {
    /// Creates a new builder-style object to manufacture [`BatchDeleteObject`](crate::model::BatchDeleteObject)
    pub fn builder() -> crate::model::batch_delete_object::Builder {
        crate::model::batch_delete_object::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchUpdate</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateObjectAttributes {
    /// <p>Reference that identifies the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Attributes update structure.</p>
    pub attribute_updates: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
}
impl BatchUpdateObjectAttributes {
    /// <p>Reference that identifies the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Attributes update structure.</p>
    pub fn attribute_updates(&self) -> std::option::Option<&[crate::model::ObjectAttributeUpdate]> {
        self.attribute_updates.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateObjectAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateObjectAttributes");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.finish()
    }
}
/// See [`BatchUpdateObjectAttributes`](crate::model::BatchUpdateObjectAttributes)
pub mod batch_update_object_attributes {
    /// A builder for [`BatchUpdateObjectAttributes`](crate::model::BatchUpdateObjectAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) attribute_updates:
            std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
    }
    impl Builder {
        /// <p>Reference that identifies the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>Attributes update structure.</p>
        pub fn attribute_updates(mut self, input: crate::model::ObjectAttributeUpdate) -> Self {
            let mut v = self.attribute_updates.unwrap_or_default();
            v.push(input);
            self.attribute_updates = Some(v);
            self
        }
        /// <p>Attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateObjectAttributes`](crate::model::BatchUpdateObjectAttributes)
        pub fn build(self) -> crate::model::BatchUpdateObjectAttributes {
            crate::model::BatchUpdateObjectAttributes {
                object_reference: self.object_reference,
                attribute_updates: self.attribute_updates,
            }
        }
    }
}
impl BatchUpdateObjectAttributes {
    /// Creates a new builder-style object to manufacture [`BatchUpdateObjectAttributes`](crate::model::BatchUpdateObjectAttributes)
    pub fn builder() -> crate::model::batch_update_object_attributes::Builder {
        crate::model::batch_update_object_attributes::Builder::default()
    }
}

/// <p>Represents the output of a <code>DetachObject</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetachObject {
    /// <p>Parent reference from which the object with the specified link name is detached.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of the link.</p>
    pub link_name: std::option::Option<std::string::String>,
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub batch_reference_name: std::option::Option<std::string::String>,
}
impl BatchDetachObject {
    /// <p>Parent reference from which the object with the specified link name is detached.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The name of the link.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub fn batch_reference_name(&self) -> std::option::Option<&str> {
        self.batch_reference_name.as_deref()
    }
}
impl std::fmt::Debug for BatchDetachObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetachObject");
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.field("batch_reference_name", &self.batch_reference_name);
        formatter.finish()
    }
}
/// See [`BatchDetachObject`](crate::model::BatchDetachObject)
pub mod batch_detach_object {
    /// A builder for [`BatchDetachObject`](crate::model::BatchDetachObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
        pub(crate) batch_reference_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Parent reference from which the object with the specified link name is detached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>Parent reference from which the object with the specified link name is detached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The name of the link.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn batch_reference_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_reference_name = Some(input.into());
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn set_batch_reference_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_reference_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetachObject`](crate::model::BatchDetachObject)
        pub fn build(self) -> crate::model::BatchDetachObject {
            crate::model::BatchDetachObject {
                parent_reference: self.parent_reference,
                link_name: self.link_name,
                batch_reference_name: self.batch_reference_name,
            }
        }
    }
}
impl BatchDetachObject {
    /// Creates a new builder-style object to manufacture [`BatchDetachObject`](crate::model::BatchDetachObject)
    pub fn builder() -> crate::model::batch_detach_object::Builder {
        crate::model::batch_detach_object::Builder::default()
    }
}

/// <p>Represents the output of an <code>AttachObject</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAttachObject {
    /// <p>The parent object reference.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The child object reference that is to be attached to the object.</p>
    pub child_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of the link.</p>
    pub link_name: std::option::Option<std::string::String>,
}
impl BatchAttachObject {
    /// <p>The parent object reference.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The child object reference that is to be attached to the object.</p>
    pub fn child_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.child_reference.as_ref()
    }
    /// <p>The name of the link.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
}
impl std::fmt::Debug for BatchAttachObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAttachObject");
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("child_reference", &self.child_reference);
        formatter.field("link_name", &self.link_name);
        formatter.finish()
    }
}
/// See [`BatchAttachObject`](crate::model::BatchAttachObject)
pub mod batch_attach_object {
    /// A builder for [`BatchAttachObject`](crate::model::BatchAttachObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) child_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parent object reference.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The child object reference that is to be attached to the object.</p>
        pub fn child_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.child_reference = Some(input);
            self
        }
        /// <p>The child object reference that is to be attached to the object.</p>
        pub fn set_child_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.child_reference = input;
            self
        }
        /// <p>The name of the link.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAttachObject`](crate::model::BatchAttachObject)
        pub fn build(self) -> crate::model::BatchAttachObject {
            crate::model::BatchAttachObject {
                parent_reference: self.parent_reference,
                child_reference: self.child_reference,
                link_name: self.link_name,
            }
        }
    }
}
impl BatchAttachObject {
    /// Creates a new builder-style object to manufacture [`BatchAttachObject`](crate::model::BatchAttachObject)
    pub fn builder() -> crate::model::batch_attach_object::Builder {
        crate::model::batch_attach_object::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateObject</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateObject {
    /// <p>A list of <code>FacetArns</code> that will be associated with the object. For more information, see <code>arns</code>.</p>
    pub schema_facet: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
    /// <p>An attribute map, which contains an attribute ARN as the key and attribute value as the map value.</p>
    pub object_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>If specified, the parent reference to which this object will be attached.</p>
    pub parent_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The name of the link.</p>
    pub link_name: std::option::Option<std::string::String>,
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub batch_reference_name: std::option::Option<std::string::String>,
}
impl BatchCreateObject {
    /// <p>A list of <code>FacetArns</code> that will be associated with the object. For more information, see <code>arns</code>.</p>
    pub fn schema_facet(&self) -> std::option::Option<&[crate::model::SchemaFacet]> {
        self.schema_facet.as_deref()
    }
    /// <p>An attribute map, which contains an attribute ARN as the key and attribute value as the map value.</p>
    pub fn object_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.object_attribute_list.as_deref()
    }
    /// <p>If specified, the parent reference to which this object will be attached.</p>
    pub fn parent_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.parent_reference.as_ref()
    }
    /// <p>The name of the link.</p>
    pub fn link_name(&self) -> std::option::Option<&str> {
        self.link_name.as_deref()
    }
    /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
    pub fn batch_reference_name(&self) -> std::option::Option<&str> {
        self.batch_reference_name.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateObject");
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("object_attribute_list", &self.object_attribute_list);
        formatter.field("parent_reference", &self.parent_reference);
        formatter.field("link_name", &self.link_name);
        formatter.field("batch_reference_name", &self.batch_reference_name);
        formatter.finish()
    }
}
/// See [`BatchCreateObject`](crate::model::BatchCreateObject)
pub mod batch_create_object {
    /// A builder for [`BatchCreateObject`](crate::model::BatchCreateObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_facet: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        pub(crate) object_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) parent_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) link_name: std::option::Option<std::string::String>,
        pub(crate) batch_reference_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_facet`.
        ///
        /// To override the contents of this collection use [`set_schema_facet`](Self::set_schema_facet).
        ///
        /// <p>A list of <code>FacetArns</code> that will be associated with the object. For more information, see <code>arns</code>.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            let mut v = self.schema_facet.unwrap_or_default();
            v.push(input);
            self.schema_facet = Some(v);
            self
        }
        /// <p>A list of <code>FacetArns</code> that will be associated with the object. For more information, see <code>arns</code>.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// Appends an item to `object_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>An attribute map, which contains an attribute ARN as the key and attribute value as the map value.</p>
        pub fn object_attribute_list(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.object_attribute_list.unwrap_or_default();
            v.push(input);
            self.object_attribute_list = Some(v);
            self
        }
        /// <p>An attribute map, which contains an attribute ARN as the key and attribute value as the map value.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.object_attribute_list = input;
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn parent_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.parent_reference = Some(input);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.parent_reference = input;
            self
        }
        /// <p>The name of the link.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn batch_reference_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_reference_name = Some(input.into());
            self
        }
        /// <p>The batch reference name. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction Support</a> for more information.</p>
        pub fn set_batch_reference_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_reference_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateObject`](crate::model::BatchCreateObject)
        pub fn build(self) -> crate::model::BatchCreateObject {
            crate::model::BatchCreateObject {
                schema_facet: self.schema_facet,
                object_attribute_list: self.object_attribute_list,
                parent_reference: self.parent_reference,
                link_name: self.link_name,
                batch_reference_name: self.batch_reference_name,
            }
        }
    }
}
impl BatchCreateObject {
    /// Creates a new builder-style object to manufacture [`BatchCreateObject`](crate::model::BatchCreateObject)
    pub fn builder() -> crate::model::batch_create_object::Builder {
        crate::model::batch_create_object::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchRead</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadOperationResponse {
    /// <p>Identifies which operation in a batch has succeeded.</p>
    pub successful_response: std::option::Option<crate::model::BatchReadSuccessfulResponse>,
    /// <p>Identifies which operation in a batch has failed.</p>
    pub exception_response: std::option::Option<crate::model::BatchReadException>,
}
impl BatchReadOperationResponse {
    /// <p>Identifies which operation in a batch has succeeded.</p>
    pub fn successful_response(
        &self,
    ) -> std::option::Option<&crate::model::BatchReadSuccessfulResponse> {
        self.successful_response.as_ref()
    }
    /// <p>Identifies which operation in a batch has failed.</p>
    pub fn exception_response(&self) -> std::option::Option<&crate::model::BatchReadException> {
        self.exception_response.as_ref()
    }
}
impl std::fmt::Debug for BatchReadOperationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadOperationResponse");
        formatter.field("successful_response", &self.successful_response);
        formatter.field("exception_response", &self.exception_response);
        formatter.finish()
    }
}
/// See [`BatchReadOperationResponse`](crate::model::BatchReadOperationResponse)
pub mod batch_read_operation_response {
    /// A builder for [`BatchReadOperationResponse`](crate::model::BatchReadOperationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_response:
            std::option::Option<crate::model::BatchReadSuccessfulResponse>,
        pub(crate) exception_response: std::option::Option<crate::model::BatchReadException>,
    }
    impl Builder {
        /// <p>Identifies which operation in a batch has succeeded.</p>
        pub fn successful_response(
            mut self,
            input: crate::model::BatchReadSuccessfulResponse,
        ) -> Self {
            self.successful_response = Some(input);
            self
        }
        /// <p>Identifies which operation in a batch has succeeded.</p>
        pub fn set_successful_response(
            mut self,
            input: std::option::Option<crate::model::BatchReadSuccessfulResponse>,
        ) -> Self {
            self.successful_response = input;
            self
        }
        /// <p>Identifies which operation in a batch has failed.</p>
        pub fn exception_response(mut self, input: crate::model::BatchReadException) -> Self {
            self.exception_response = Some(input);
            self
        }
        /// <p>Identifies which operation in a batch has failed.</p>
        pub fn set_exception_response(
            mut self,
            input: std::option::Option<crate::model::BatchReadException>,
        ) -> Self {
            self.exception_response = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadOperationResponse`](crate::model::BatchReadOperationResponse)
        pub fn build(self) -> crate::model::BatchReadOperationResponse {
            crate::model::BatchReadOperationResponse {
                successful_response: self.successful_response,
                exception_response: self.exception_response,
            }
        }
    }
}
impl BatchReadOperationResponse {
    /// Creates a new builder-style object to manufacture [`BatchReadOperationResponse`](crate::model::BatchReadOperationResponse)
    pub fn builder() -> crate::model::batch_read_operation_response::Builder {
        crate::model::batch_read_operation_response::Builder::default()
    }
}

/// <p>The batch read exception structure, which contains the exception type and message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadException {
    /// <p>A type of exception, such as <code>InvalidArnException</code>.</p>
    pub r#type: std::option::Option<crate::model::BatchReadExceptionType>,
    /// <p>An exception message that is associated with the failure.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchReadException {
    /// <p>A type of exception, such as <code>InvalidArnException</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::BatchReadExceptionType> {
        self.r#type.as_ref()
    }
    /// <p>An exception message that is associated with the failure.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchReadException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchReadException`](crate::model::BatchReadException)
pub mod batch_read_exception {
    /// A builder for [`BatchReadException`](crate::model::BatchReadException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::BatchReadExceptionType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A type of exception, such as <code>InvalidArnException</code>.</p>
        pub fn r#type(mut self, input: crate::model::BatchReadExceptionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A type of exception, such as <code>InvalidArnException</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::BatchReadExceptionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An exception message that is associated with the failure.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An exception message that is associated with the failure.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadException`](crate::model::BatchReadException)
        pub fn build(self) -> crate::model::BatchReadException {
            crate::model::BatchReadException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl BatchReadException {
    /// Creates a new builder-style object to manufacture [`BatchReadException`](crate::model::BatchReadException)
    pub fn builder() -> crate::model::batch_read_exception::Builder {
        crate::model::batch_read_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchReadExceptionType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException,
    #[allow(missing_docs)] // documentation missing in model
    CannotListParentOfRootException,
    #[allow(missing_docs)] // documentation missing in model
    DirectoryNotEnabledException,
    #[allow(missing_docs)] // documentation missing in model
    FacetValidationException,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArnException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNextTokenException,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceededException,
    #[allow(missing_docs)] // documentation missing in model
    NotIndexException,
    #[allow(missing_docs)] // documentation missing in model
    NotNodeException,
    #[allow(missing_docs)] // documentation missing in model
    NotPolicyException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    ValidationException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchReadExceptionType {
    fn from(s: &str) -> Self {
        match s {
            "AccessDeniedException" => BatchReadExceptionType::AccessDeniedException,
            "CannotListParentOfRootException" => {
                BatchReadExceptionType::CannotListParentOfRootException
            }
            "DirectoryNotEnabledException" => BatchReadExceptionType::DirectoryNotEnabledException,
            "FacetValidationException" => BatchReadExceptionType::FacetValidationException,
            "InternalServiceException" => BatchReadExceptionType::InternalServiceException,
            "InvalidArnException" => BatchReadExceptionType::InvalidArnException,
            "InvalidNextTokenException" => BatchReadExceptionType::InvalidNextTokenException,
            "LimitExceededException" => BatchReadExceptionType::LimitExceededException,
            "NotIndexException" => BatchReadExceptionType::NotIndexException,
            "NotNodeException" => BatchReadExceptionType::NotNodeException,
            "NotPolicyException" => BatchReadExceptionType::NotPolicyException,
            "ResourceNotFoundException" => BatchReadExceptionType::ResourceNotFoundException,
            "ValidationException" => BatchReadExceptionType::ValidationException,
            other => BatchReadExceptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchReadExceptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchReadExceptionType::from(s))
    }
}
impl BatchReadExceptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchReadExceptionType::AccessDeniedException => "AccessDeniedException",
            BatchReadExceptionType::CannotListParentOfRootException => {
                "CannotListParentOfRootException"
            }
            BatchReadExceptionType::DirectoryNotEnabledException => "DirectoryNotEnabledException",
            BatchReadExceptionType::FacetValidationException => "FacetValidationException",
            BatchReadExceptionType::InternalServiceException => "InternalServiceException",
            BatchReadExceptionType::InvalidArnException => "InvalidArnException",
            BatchReadExceptionType::InvalidNextTokenException => "InvalidNextTokenException",
            BatchReadExceptionType::LimitExceededException => "LimitExceededException",
            BatchReadExceptionType::NotIndexException => "NotIndexException",
            BatchReadExceptionType::NotNodeException => "NotNodeException",
            BatchReadExceptionType::NotPolicyException => "NotPolicyException",
            BatchReadExceptionType::ResourceNotFoundException => "ResourceNotFoundException",
            BatchReadExceptionType::ValidationException => "ValidationException",
            BatchReadExceptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDeniedException",
            "CannotListParentOfRootException",
            "DirectoryNotEnabledException",
            "FacetValidationException",
            "InternalServiceException",
            "InvalidArnException",
            "InvalidNextTokenException",
            "LimitExceededException",
            "NotIndexException",
            "NotNodeException",
            "NotPolicyException",
            "ResourceNotFoundException",
            "ValidationException",
        ]
    }
}
impl AsRef<str> for BatchReadExceptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of a <code>BatchRead</code> success response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadSuccessfulResponse {
    /// <p>Lists all attributes that are associated with an object.</p>
    pub list_object_attributes:
        std::option::Option<crate::model::BatchListObjectAttributesResponse>,
    /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
    pub list_object_children: std::option::Option<crate::model::BatchListObjectChildrenResponse>,
    /// <p>Retrieves metadata about an object.</p>
    pub get_object_information:
        std::option::Option<crate::model::BatchGetObjectInformationResponse>,
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    pub get_object_attributes: std::option::Option<crate::model::BatchGetObjectAttributesResponse>,
    /// <p>Lists indices attached to an object.</p>
    pub list_attached_indices: std::option::Option<crate::model::BatchListAttachedIndicesResponse>,
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    pub list_object_parent_paths:
        std::option::Option<crate::model::BatchListObjectParentPathsResponse>,
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    pub list_object_policies: std::option::Option<crate::model::BatchListObjectPoliciesResponse>,
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    pub list_policy_attachments:
        std::option::Option<crate::model::BatchListPolicyAttachmentsResponse>,
    /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub lookup_policy: std::option::Option<crate::model::BatchLookupPolicyResponse>,
    /// <p>Lists objects attached to the specified index.</p>
    pub list_index: std::option::Option<crate::model::BatchListIndexResponse>,
    /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub list_outgoing_typed_links:
        std::option::Option<crate::model::BatchListOutgoingTypedLinksResponse>,
    /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub list_incoming_typed_links:
        std::option::Option<crate::model::BatchListIncomingTypedLinksResponse>,
    /// <p>The list of attributes to retrieve from the typed link.</p>
    pub get_link_attributes: std::option::Option<crate::model::BatchGetLinkAttributesResponse>,
    /// <p>The list of parent objects to retrieve.</p>
    pub list_object_parents: std::option::Option<crate::model::BatchListObjectParentsResponse>,
}
impl BatchReadSuccessfulResponse {
    /// <p>Lists all attributes that are associated with an object.</p>
    pub fn list_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectAttributesResponse> {
        self.list_object_attributes.as_ref()
    }
    /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
    pub fn list_object_children(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectChildrenResponse> {
        self.list_object_children.as_ref()
    }
    /// <p>Retrieves metadata about an object.</p>
    pub fn get_object_information(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetObjectInformationResponse> {
        self.get_object_information.as_ref()
    }
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    pub fn get_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetObjectAttributesResponse> {
        self.get_object_attributes.as_ref()
    }
    /// <p>Lists indices attached to an object.</p>
    pub fn list_attached_indices(
        &self,
    ) -> std::option::Option<&crate::model::BatchListAttachedIndicesResponse> {
        self.list_attached_indices.as_ref()
    }
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    pub fn list_object_parent_paths(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectParentPathsResponse> {
        self.list_object_parent_paths.as_ref()
    }
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    pub fn list_object_policies(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectPoliciesResponse> {
        self.list_object_policies.as_ref()
    }
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    pub fn list_policy_attachments(
        &self,
    ) -> std::option::Option<&crate::model::BatchListPolicyAttachmentsResponse> {
        self.list_policy_attachments.as_ref()
    }
    /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub fn lookup_policy(&self) -> std::option::Option<&crate::model::BatchLookupPolicyResponse> {
        self.lookup_policy.as_ref()
    }
    /// <p>Lists objects attached to the specified index.</p>
    pub fn list_index(&self) -> std::option::Option<&crate::model::BatchListIndexResponse> {
        self.list_index.as_ref()
    }
    /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn list_outgoing_typed_links(
        &self,
    ) -> std::option::Option<&crate::model::BatchListOutgoingTypedLinksResponse> {
        self.list_outgoing_typed_links.as_ref()
    }
    /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn list_incoming_typed_links(
        &self,
    ) -> std::option::Option<&crate::model::BatchListIncomingTypedLinksResponse> {
        self.list_incoming_typed_links.as_ref()
    }
    /// <p>The list of attributes to retrieve from the typed link.</p>
    pub fn get_link_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetLinkAttributesResponse> {
        self.get_link_attributes.as_ref()
    }
    /// <p>The list of parent objects to retrieve.</p>
    pub fn list_object_parents(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectParentsResponse> {
        self.list_object_parents.as_ref()
    }
}
impl std::fmt::Debug for BatchReadSuccessfulResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadSuccessfulResponse");
        formatter.field("list_object_attributes", &self.list_object_attributes);
        formatter.field("list_object_children", &self.list_object_children);
        formatter.field("get_object_information", &self.get_object_information);
        formatter.field("get_object_attributes", &self.get_object_attributes);
        formatter.field("list_attached_indices", &self.list_attached_indices);
        formatter.field("list_object_parent_paths", &self.list_object_parent_paths);
        formatter.field("list_object_policies", &self.list_object_policies);
        formatter.field("list_policy_attachments", &self.list_policy_attachments);
        formatter.field("lookup_policy", &self.lookup_policy);
        formatter.field("list_index", &self.list_index);
        formatter.field("list_outgoing_typed_links", &self.list_outgoing_typed_links);
        formatter.field("list_incoming_typed_links", &self.list_incoming_typed_links);
        formatter.field("get_link_attributes", &self.get_link_attributes);
        formatter.field("list_object_parents", &self.list_object_parents);
        formatter.finish()
    }
}
/// See [`BatchReadSuccessfulResponse`](crate::model::BatchReadSuccessfulResponse)
pub mod batch_read_successful_response {
    /// A builder for [`BatchReadSuccessfulResponse`](crate::model::BatchReadSuccessfulResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_object_attributes:
            std::option::Option<crate::model::BatchListObjectAttributesResponse>,
        pub(crate) list_object_children:
            std::option::Option<crate::model::BatchListObjectChildrenResponse>,
        pub(crate) get_object_information:
            std::option::Option<crate::model::BatchGetObjectInformationResponse>,
        pub(crate) get_object_attributes:
            std::option::Option<crate::model::BatchGetObjectAttributesResponse>,
        pub(crate) list_attached_indices:
            std::option::Option<crate::model::BatchListAttachedIndicesResponse>,
        pub(crate) list_object_parent_paths:
            std::option::Option<crate::model::BatchListObjectParentPathsResponse>,
        pub(crate) list_object_policies:
            std::option::Option<crate::model::BatchListObjectPoliciesResponse>,
        pub(crate) list_policy_attachments:
            std::option::Option<crate::model::BatchListPolicyAttachmentsResponse>,
        pub(crate) lookup_policy: std::option::Option<crate::model::BatchLookupPolicyResponse>,
        pub(crate) list_index: std::option::Option<crate::model::BatchListIndexResponse>,
        pub(crate) list_outgoing_typed_links:
            std::option::Option<crate::model::BatchListOutgoingTypedLinksResponse>,
        pub(crate) list_incoming_typed_links:
            std::option::Option<crate::model::BatchListIncomingTypedLinksResponse>,
        pub(crate) get_link_attributes:
            std::option::Option<crate::model::BatchGetLinkAttributesResponse>,
        pub(crate) list_object_parents:
            std::option::Option<crate::model::BatchListObjectParentsResponse>,
    }
    impl Builder {
        /// <p>Lists all attributes that are associated with an object.</p>
        pub fn list_object_attributes(
            mut self,
            input: crate::model::BatchListObjectAttributesResponse,
        ) -> Self {
            self.list_object_attributes = Some(input);
            self
        }
        /// <p>Lists all attributes that are associated with an object.</p>
        pub fn set_list_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectAttributesResponse>,
        ) -> Self {
            self.list_object_attributes = input;
            self
        }
        /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
        pub fn list_object_children(
            mut self,
            input: crate::model::BatchListObjectChildrenResponse,
        ) -> Self {
            self.list_object_children = Some(input);
            self
        }
        /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
        pub fn set_list_object_children(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectChildrenResponse>,
        ) -> Self {
            self.list_object_children = input;
            self
        }
        /// <p>Retrieves metadata about an object.</p>
        pub fn get_object_information(
            mut self,
            input: crate::model::BatchGetObjectInformationResponse,
        ) -> Self {
            self.get_object_information = Some(input);
            self
        }
        /// <p>Retrieves metadata about an object.</p>
        pub fn set_get_object_information(
            mut self,
            input: std::option::Option<crate::model::BatchGetObjectInformationResponse>,
        ) -> Self {
            self.get_object_information = input;
            self
        }
        /// <p>Retrieves attributes within a facet that are associated with an object.</p>
        pub fn get_object_attributes(
            mut self,
            input: crate::model::BatchGetObjectAttributesResponse,
        ) -> Self {
            self.get_object_attributes = Some(input);
            self
        }
        /// <p>Retrieves attributes within a facet that are associated with an object.</p>
        pub fn set_get_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchGetObjectAttributesResponse>,
        ) -> Self {
            self.get_object_attributes = input;
            self
        }
        /// <p>Lists indices attached to an object.</p>
        pub fn list_attached_indices(
            mut self,
            input: crate::model::BatchListAttachedIndicesResponse,
        ) -> Self {
            self.list_attached_indices = Some(input);
            self
        }
        /// <p>Lists indices attached to an object.</p>
        pub fn set_list_attached_indices(
            mut self,
            input: std::option::Option<crate::model::BatchListAttachedIndicesResponse>,
        ) -> Self {
            self.list_attached_indices = input;
            self
        }
        /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
        pub fn list_object_parent_paths(
            mut self,
            input: crate::model::BatchListObjectParentPathsResponse,
        ) -> Self {
            self.list_object_parent_paths = Some(input);
            self
        }
        /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
        pub fn set_list_object_parent_paths(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectParentPathsResponse>,
        ) -> Self {
            self.list_object_parent_paths = input;
            self
        }
        /// <p>Returns policies attached to an object in pagination fashion.</p>
        pub fn list_object_policies(
            mut self,
            input: crate::model::BatchListObjectPoliciesResponse,
        ) -> Self {
            self.list_object_policies = Some(input);
            self
        }
        /// <p>Returns policies attached to an object in pagination fashion.</p>
        pub fn set_list_object_policies(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectPoliciesResponse>,
        ) -> Self {
            self.list_object_policies = input;
            self
        }
        /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
        pub fn list_policy_attachments(
            mut self,
            input: crate::model::BatchListPolicyAttachmentsResponse,
        ) -> Self {
            self.list_policy_attachments = Some(input);
            self
        }
        /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
        pub fn set_list_policy_attachments(
            mut self,
            input: std::option::Option<crate::model::BatchListPolicyAttachmentsResponse>,
        ) -> Self {
            self.list_policy_attachments = input;
            self
        }
        /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn lookup_policy(mut self, input: crate::model::BatchLookupPolicyResponse) -> Self {
            self.lookup_policy = Some(input);
            self
        }
        /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn set_lookup_policy(
            mut self,
            input: std::option::Option<crate::model::BatchLookupPolicyResponse>,
        ) -> Self {
            self.lookup_policy = input;
            self
        }
        /// <p>Lists objects attached to the specified index.</p>
        pub fn list_index(mut self, input: crate::model::BatchListIndexResponse) -> Self {
            self.list_index = Some(input);
            self
        }
        /// <p>Lists objects attached to the specified index.</p>
        pub fn set_list_index(
            mut self,
            input: std::option::Option<crate::model::BatchListIndexResponse>,
        ) -> Self {
            self.list_index = input;
            self
        }
        /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn list_outgoing_typed_links(
            mut self,
            input: crate::model::BatchListOutgoingTypedLinksResponse,
        ) -> Self {
            self.list_outgoing_typed_links = Some(input);
            self
        }
        /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_list_outgoing_typed_links(
            mut self,
            input: std::option::Option<crate::model::BatchListOutgoingTypedLinksResponse>,
        ) -> Self {
            self.list_outgoing_typed_links = input;
            self
        }
        /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn list_incoming_typed_links(
            mut self,
            input: crate::model::BatchListIncomingTypedLinksResponse,
        ) -> Self {
            self.list_incoming_typed_links = Some(input);
            self
        }
        /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_list_incoming_typed_links(
            mut self,
            input: std::option::Option<crate::model::BatchListIncomingTypedLinksResponse>,
        ) -> Self {
            self.list_incoming_typed_links = input;
            self
        }
        /// <p>The list of attributes to retrieve from the typed link.</p>
        pub fn get_link_attributes(
            mut self,
            input: crate::model::BatchGetLinkAttributesResponse,
        ) -> Self {
            self.get_link_attributes = Some(input);
            self
        }
        /// <p>The list of attributes to retrieve from the typed link.</p>
        pub fn set_get_link_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchGetLinkAttributesResponse>,
        ) -> Self {
            self.get_link_attributes = input;
            self
        }
        /// <p>The list of parent objects to retrieve.</p>
        pub fn list_object_parents(
            mut self,
            input: crate::model::BatchListObjectParentsResponse,
        ) -> Self {
            self.list_object_parents = Some(input);
            self
        }
        /// <p>The list of parent objects to retrieve.</p>
        pub fn set_list_object_parents(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectParentsResponse>,
        ) -> Self {
            self.list_object_parents = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadSuccessfulResponse`](crate::model::BatchReadSuccessfulResponse)
        pub fn build(self) -> crate::model::BatchReadSuccessfulResponse {
            crate::model::BatchReadSuccessfulResponse {
                list_object_attributes: self.list_object_attributes,
                list_object_children: self.list_object_children,
                get_object_information: self.get_object_information,
                get_object_attributes: self.get_object_attributes,
                list_attached_indices: self.list_attached_indices,
                list_object_parent_paths: self.list_object_parent_paths,
                list_object_policies: self.list_object_policies,
                list_policy_attachments: self.list_policy_attachments,
                lookup_policy: self.lookup_policy,
                list_index: self.list_index,
                list_outgoing_typed_links: self.list_outgoing_typed_links,
                list_incoming_typed_links: self.list_incoming_typed_links,
                get_link_attributes: self.get_link_attributes,
                list_object_parents: self.list_object_parents,
            }
        }
    }
}
impl BatchReadSuccessfulResponse {
    /// Creates a new builder-style object to manufacture [`BatchReadSuccessfulResponse`](crate::model::BatchReadSuccessfulResponse)
    pub fn builder() -> crate::model::batch_read_successful_response::Builder {
        crate::model::batch_read_successful_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectParents</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectParentsResponse {
    /// <p>Returns a list of parent reference and LinkName Tuples.</p>
    pub parent_links:
        std::option::Option<std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListObjectParentsResponse {
    /// <p>Returns a list of parent reference and LinkName Tuples.</p>
    pub fn parent_links(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectIdentifierAndLinkNameTuple]> {
        self.parent_links.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListObjectParentsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectParentsResponse");
        formatter.field("parent_links", &self.parent_links);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListObjectParentsResponse`](crate::model::BatchListObjectParentsResponse)
pub mod batch_list_object_parents_response {
    /// A builder for [`BatchListObjectParentsResponse`](crate::model::BatchListObjectParentsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_links:
            std::option::Option<std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parent_links`.
        ///
        /// To override the contents of this collection use [`set_parent_links`](Self::set_parent_links).
        ///
        /// <p>Returns a list of parent reference and LinkName Tuples.</p>
        pub fn parent_links(
            mut self,
            input: crate::model::ObjectIdentifierAndLinkNameTuple,
        ) -> Self {
            let mut v = self.parent_links.unwrap_or_default();
            v.push(input);
            self.parent_links = Some(v);
            self
        }
        /// <p>Returns a list of parent reference and LinkName Tuples.</p>
        pub fn set_parent_links(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>,
            >,
        ) -> Self {
            self.parent_links = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectParentsResponse`](crate::model::BatchListObjectParentsResponse)
        pub fn build(self) -> crate::model::BatchListObjectParentsResponse {
            crate::model::BatchListObjectParentsResponse {
                parent_links: self.parent_links,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListObjectParentsResponse {
    /// Creates a new builder-style object to manufacture [`BatchListObjectParentsResponse`](crate::model::BatchListObjectParentsResponse)
    pub fn builder() -> crate::model::batch_list_object_parents_response::Builder {
        crate::model::batch_list_object_parents_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetLinkAttributes</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetLinkAttributesResponse {
    /// <p>The attributes that are associated with the typed link.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
}
impl BatchGetLinkAttributesResponse {
    /// <p>The attributes that are associated with the typed link.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for BatchGetLinkAttributesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetLinkAttributesResponse");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`BatchGetLinkAttributesResponse`](crate::model::BatchGetLinkAttributesResponse)
pub mod batch_get_link_attributes_response {
    /// A builder for [`BatchGetLinkAttributesResponse`](crate::model::BatchGetLinkAttributesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetLinkAttributesResponse`](crate::model::BatchGetLinkAttributesResponse)
        pub fn build(self) -> crate::model::BatchGetLinkAttributesResponse {
            crate::model::BatchGetLinkAttributesResponse {
                attributes: self.attributes,
            }
        }
    }
}
impl BatchGetLinkAttributesResponse {
    /// Creates a new builder-style object to manufacture [`BatchGetLinkAttributesResponse`](crate::model::BatchGetLinkAttributesResponse)
    pub fn builder() -> crate::model::batch_get_link_attributes_response::Builder {
        crate::model::batch_get_link_attributes_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListIncomingTypedLinks</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListIncomingTypedLinksResponse {
    /// <p>Returns one or more typed link specifiers as output.</p>
    pub link_specifiers: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListIncomingTypedLinksResponse {
    /// <p>Returns one or more typed link specifiers as output.</p>
    pub fn link_specifiers(&self) -> std::option::Option<&[crate::model::TypedLinkSpecifier]> {
        self.link_specifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListIncomingTypedLinksResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListIncomingTypedLinksResponse");
        formatter.field("link_specifiers", &self.link_specifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListIncomingTypedLinksResponse`](crate::model::BatchListIncomingTypedLinksResponse)
pub mod batch_list_incoming_typed_links_response {
    /// A builder for [`BatchListIncomingTypedLinksResponse`](crate::model::BatchListIncomingTypedLinksResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_specifiers:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `link_specifiers`.
        ///
        /// To override the contents of this collection use [`set_link_specifiers`](Self::set_link_specifiers).
        ///
        /// <p>Returns one or more typed link specifiers as output.</p>
        pub fn link_specifiers(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            let mut v = self.link_specifiers.unwrap_or_default();
            v.push(input);
            self.link_specifiers = Some(v);
            self
        }
        /// <p>Returns one or more typed link specifiers as output.</p>
        pub fn set_link_specifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        ) -> Self {
            self.link_specifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListIncomingTypedLinksResponse`](crate::model::BatchListIncomingTypedLinksResponse)
        pub fn build(self) -> crate::model::BatchListIncomingTypedLinksResponse {
            crate::model::BatchListIncomingTypedLinksResponse {
                link_specifiers: self.link_specifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListIncomingTypedLinksResponse {
    /// Creates a new builder-style object to manufacture [`BatchListIncomingTypedLinksResponse`](crate::model::BatchListIncomingTypedLinksResponse)
    pub fn builder() -> crate::model::batch_list_incoming_typed_links_response::Builder {
        crate::model::batch_list_incoming_typed_links_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListOutgoingTypedLinks</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListOutgoingTypedLinksResponse {
    /// <p>Returns a typed link specifier as output.</p>
    pub typed_link_specifiers: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListOutgoingTypedLinksResponse {
    /// <p>Returns a typed link specifier as output.</p>
    pub fn typed_link_specifiers(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkSpecifier]> {
        self.typed_link_specifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListOutgoingTypedLinksResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListOutgoingTypedLinksResponse");
        formatter.field("typed_link_specifiers", &self.typed_link_specifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListOutgoingTypedLinksResponse`](crate::model::BatchListOutgoingTypedLinksResponse)
pub mod batch_list_outgoing_typed_links_response {
    /// A builder for [`BatchListOutgoingTypedLinksResponse`](crate::model::BatchListOutgoingTypedLinksResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifiers:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `typed_link_specifiers`.
        ///
        /// To override the contents of this collection use [`set_typed_link_specifiers`](Self::set_typed_link_specifiers).
        ///
        /// <p>Returns a typed link specifier as output.</p>
        pub fn typed_link_specifiers(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            let mut v = self.typed_link_specifiers.unwrap_or_default();
            v.push(input);
            self.typed_link_specifiers = Some(v);
            self
        }
        /// <p>Returns a typed link specifier as output.</p>
        pub fn set_typed_link_specifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        ) -> Self {
            self.typed_link_specifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListOutgoingTypedLinksResponse`](crate::model::BatchListOutgoingTypedLinksResponse)
        pub fn build(self) -> crate::model::BatchListOutgoingTypedLinksResponse {
            crate::model::BatchListOutgoingTypedLinksResponse {
                typed_link_specifiers: self.typed_link_specifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListOutgoingTypedLinksResponse {
    /// Creates a new builder-style object to manufacture [`BatchListOutgoingTypedLinksResponse`](crate::model::BatchListOutgoingTypedLinksResponse)
    pub fn builder() -> crate::model::batch_list_outgoing_typed_links_response::Builder {
        crate::model::batch_list_outgoing_typed_links_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListIndex</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListIndexResponse {
    /// <p>The objects and indexed values attached to the index.</p>
    pub index_attachments: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListIndexResponse {
    /// <p>The objects and indexed values attached to the index.</p>
    pub fn index_attachments(&self) -> std::option::Option<&[crate::model::IndexAttachment]> {
        self.index_attachments.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListIndexResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListIndexResponse");
        formatter.field("index_attachments", &self.index_attachments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListIndexResponse`](crate::model::BatchListIndexResponse)
pub mod batch_list_index_response {
    /// A builder for [`BatchListIndexResponse`](crate::model::BatchListIndexResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_attachments:
            std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `index_attachments`.
        ///
        /// To override the contents of this collection use [`set_index_attachments`](Self::set_index_attachments).
        ///
        /// <p>The objects and indexed values attached to the index.</p>
        pub fn index_attachments(mut self, input: crate::model::IndexAttachment) -> Self {
            let mut v = self.index_attachments.unwrap_or_default();
            v.push(input);
            self.index_attachments = Some(v);
            self
        }
        /// <p>The objects and indexed values attached to the index.</p>
        pub fn set_index_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        ) -> Self {
            self.index_attachments = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListIndexResponse`](crate::model::BatchListIndexResponse)
        pub fn build(self) -> crate::model::BatchListIndexResponse {
            crate::model::BatchListIndexResponse {
                index_attachments: self.index_attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListIndexResponse {
    /// Creates a new builder-style object to manufacture [`BatchListIndexResponse`](crate::model::BatchListIndexResponse)
    pub fn builder() -> crate::model::batch_list_index_response::Builder {
        crate::model::batch_list_index_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>LookupPolicy</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchLookupPolicyResponse {
    /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub policy_to_path_list: std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchLookupPolicyResponse {
    /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub fn policy_to_path_list(&self) -> std::option::Option<&[crate::model::PolicyToPath]> {
        self.policy_to_path_list.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchLookupPolicyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchLookupPolicyResponse");
        formatter.field("policy_to_path_list", &self.policy_to_path_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchLookupPolicyResponse`](crate::model::BatchLookupPolicyResponse)
pub mod batch_lookup_policy_response {
    /// A builder for [`BatchLookupPolicyResponse`](crate::model::BatchLookupPolicyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_to_path_list:
            std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_to_path_list`.
        ///
        /// To override the contents of this collection use [`set_policy_to_path_list`](Self::set_policy_to_path_list).
        ///
        /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn policy_to_path_list(mut self, input: crate::model::PolicyToPath) -> Self {
            let mut v = self.policy_to_path_list.unwrap_or_default();
            v.push(input);
            self.policy_to_path_list = Some(v);
            self
        }
        /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn set_policy_to_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
        ) -> Self {
            self.policy_to_path_list = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchLookupPolicyResponse`](crate::model::BatchLookupPolicyResponse)
        pub fn build(self) -> crate::model::BatchLookupPolicyResponse {
            crate::model::BatchLookupPolicyResponse {
                policy_to_path_list: self.policy_to_path_list,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchLookupPolicyResponse {
    /// Creates a new builder-style object to manufacture [`BatchLookupPolicyResponse`](crate::model::BatchLookupPolicyResponse)
    pub fn builder() -> crate::model::batch_lookup_policy_response::Builder {
        crate::model::batch_lookup_policy_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListPolicyAttachments</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListPolicyAttachmentsResponse {
    /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
    pub object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListPolicyAttachmentsResponse {
    /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
    pub fn object_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.object_identifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListPolicyAttachmentsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListPolicyAttachmentsResponse");
        formatter.field("object_identifiers", &self.object_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListPolicyAttachmentsResponse`](crate::model::BatchListPolicyAttachmentsResponse)
pub mod batch_list_policy_attachments_response {
    /// A builder for [`BatchListPolicyAttachmentsResponse`](crate::model::BatchListPolicyAttachmentsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `object_identifiers`.
        ///
        /// To override the contents of this collection use [`set_object_identifiers`](Self::set_object_identifiers).
        ///
        /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
        pub fn object_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.object_identifiers.unwrap_or_default();
            v.push(input.into());
            self.object_identifiers = Some(v);
            self
        }
        /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
        pub fn set_object_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.object_identifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListPolicyAttachmentsResponse`](crate::model::BatchListPolicyAttachmentsResponse)
        pub fn build(self) -> crate::model::BatchListPolicyAttachmentsResponse {
            crate::model::BatchListPolicyAttachmentsResponse {
                object_identifiers: self.object_identifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListPolicyAttachmentsResponse {
    /// Creates a new builder-style object to manufacture [`BatchListPolicyAttachmentsResponse`](crate::model::BatchListPolicyAttachmentsResponse)
    pub fn builder() -> crate::model::batch_list_policy_attachments_response::Builder {
        crate::model::batch_list_policy_attachments_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectPolicies</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectPoliciesResponse {
    /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the object.</p>
    pub attached_policy_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListObjectPoliciesResponse {
    /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the object.</p>
    pub fn attached_policy_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.attached_policy_ids.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListObjectPoliciesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectPoliciesResponse");
        formatter.field("attached_policy_ids", &self.attached_policy_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListObjectPoliciesResponse`](crate::model::BatchListObjectPoliciesResponse)
pub mod batch_list_object_policies_response {
    /// A builder for [`BatchListObjectPoliciesResponse`](crate::model::BatchListObjectPoliciesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_policy_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attached_policy_ids`.
        ///
        /// To override the contents of this collection use [`set_attached_policy_ids`](Self::set_attached_policy_ids).
        ///
        /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the object.</p>
        pub fn attached_policy_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attached_policy_ids.unwrap_or_default();
            v.push(input.into());
            self.attached_policy_ids = Some(v);
            self
        }
        /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the object.</p>
        pub fn set_attached_policy_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attached_policy_ids = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectPoliciesResponse`](crate::model::BatchListObjectPoliciesResponse)
        pub fn build(self) -> crate::model::BatchListObjectPoliciesResponse {
            crate::model::BatchListObjectPoliciesResponse {
                attached_policy_ids: self.attached_policy_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListObjectPoliciesResponse {
    /// Creates a new builder-style object to manufacture [`BatchListObjectPoliciesResponse`](crate::model::BatchListObjectPoliciesResponse)
    pub fn builder() -> crate::model::batch_list_object_policies_response::Builder {
        crate::model::batch_list_object_policies_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectParentPaths</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectParentPathsResponse {
    /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.</p>
    pub path_to_object_identifiers_list:
        std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListObjectParentPathsResponse {
    /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.</p>
    pub fn path_to_object_identifiers_list(
        &self,
    ) -> std::option::Option<&[crate::model::PathToObjectIdentifiers]> {
        self.path_to_object_identifiers_list.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListObjectParentPathsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectParentPathsResponse");
        formatter.field(
            "path_to_object_identifiers_list",
            &self.path_to_object_identifiers_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListObjectParentPathsResponse`](crate::model::BatchListObjectParentPathsResponse)
pub mod batch_list_object_parent_paths_response {
    /// A builder for [`BatchListObjectParentPathsResponse`](crate::model::BatchListObjectParentPathsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_to_object_identifiers_list:
            std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `path_to_object_identifiers_list`.
        ///
        /// To override the contents of this collection use [`set_path_to_object_identifiers_list`](Self::set_path_to_object_identifiers_list).
        ///
        /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.</p>
        pub fn path_to_object_identifiers_list(
            mut self,
            input: crate::model::PathToObjectIdentifiers,
        ) -> Self {
            let mut v = self.path_to_object_identifiers_list.unwrap_or_default();
            v.push(input);
            self.path_to_object_identifiers_list = Some(v);
            self
        }
        /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.</p>
        pub fn set_path_to_object_identifiers_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
        ) -> Self {
            self.path_to_object_identifiers_list = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectParentPathsResponse`](crate::model::BatchListObjectParentPathsResponse)
        pub fn build(self) -> crate::model::BatchListObjectParentPathsResponse {
            crate::model::BatchListObjectParentPathsResponse {
                path_to_object_identifiers_list: self.path_to_object_identifiers_list,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListObjectParentPathsResponse {
    /// Creates a new builder-style object to manufacture [`BatchListObjectParentPathsResponse`](crate::model::BatchListObjectParentPathsResponse)
    pub fn builder() -> crate::model::batch_list_object_parent_paths_response::Builder {
        crate::model::batch_list_object_parent_paths_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListAttachedIndices</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListAttachedIndicesResponse {
    /// <p>The indices attached to the specified object.</p>
    pub index_attachments: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListAttachedIndicesResponse {
    /// <p>The indices attached to the specified object.</p>
    pub fn index_attachments(&self) -> std::option::Option<&[crate::model::IndexAttachment]> {
        self.index_attachments.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListAttachedIndicesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListAttachedIndicesResponse");
        formatter.field("index_attachments", &self.index_attachments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListAttachedIndicesResponse`](crate::model::BatchListAttachedIndicesResponse)
pub mod batch_list_attached_indices_response {
    /// A builder for [`BatchListAttachedIndicesResponse`](crate::model::BatchListAttachedIndicesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_attachments:
            std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `index_attachments`.
        ///
        /// To override the contents of this collection use [`set_index_attachments`](Self::set_index_attachments).
        ///
        /// <p>The indices attached to the specified object.</p>
        pub fn index_attachments(mut self, input: crate::model::IndexAttachment) -> Self {
            let mut v = self.index_attachments.unwrap_or_default();
            v.push(input);
            self.index_attachments = Some(v);
            self
        }
        /// <p>The indices attached to the specified object.</p>
        pub fn set_index_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        ) -> Self {
            self.index_attachments = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListAttachedIndicesResponse`](crate::model::BatchListAttachedIndicesResponse)
        pub fn build(self) -> crate::model::BatchListAttachedIndicesResponse {
            crate::model::BatchListAttachedIndicesResponse {
                index_attachments: self.index_attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListAttachedIndicesResponse {
    /// Creates a new builder-style object to manufacture [`BatchListAttachedIndicesResponse`](crate::model::BatchListAttachedIndicesResponse)
    pub fn builder() -> crate::model::batch_list_attached_indices_response::Builder {
        crate::model::batch_list_attached_indices_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetObjectAttributes</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetObjectAttributesResponse {
    /// <p>The attribute values that are associated with an object.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
}
impl BatchGetObjectAttributesResponse {
    /// <p>The attribute values that are associated with an object.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for BatchGetObjectAttributesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetObjectAttributesResponse");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`BatchGetObjectAttributesResponse`](crate::model::BatchGetObjectAttributesResponse)
pub mod batch_get_object_attributes_response {
    /// A builder for [`BatchGetObjectAttributesResponse`](crate::model::BatchGetObjectAttributesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attribute values that are associated with an object.</p>
        pub fn attributes(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attribute values that are associated with an object.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetObjectAttributesResponse`](crate::model::BatchGetObjectAttributesResponse)
        pub fn build(self) -> crate::model::BatchGetObjectAttributesResponse {
            crate::model::BatchGetObjectAttributesResponse {
                attributes: self.attributes,
            }
        }
    }
}
impl BatchGetObjectAttributesResponse {
    /// Creates a new builder-style object to manufacture [`BatchGetObjectAttributesResponse`](crate::model::BatchGetObjectAttributesResponse)
    pub fn builder() -> crate::model::batch_get_object_attributes_response::Builder {
        crate::model::batch_get_object_attributes_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetObjectInformation</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetObjectInformationResponse {
    /// <p>The facets attached to the specified object.</p>
    pub schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
    /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl BatchGetObjectInformationResponse {
    /// <p>The facets attached to the specified object.</p>
    pub fn schema_facets(&self) -> std::option::Option<&[crate::model::SchemaFacet]> {
        self.schema_facets.as_deref()
    }
    /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for BatchGetObjectInformationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetObjectInformationResponse");
        formatter.field("schema_facets", &self.schema_facets);
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`BatchGetObjectInformationResponse`](crate::model::BatchGetObjectInformationResponse)
pub mod batch_get_object_information_response {
    /// A builder for [`BatchGetObjectInformationResponse`](crate::model::BatchGetObjectInformationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_facets`.
        ///
        /// To override the contents of this collection use [`set_schema_facets`](Self::set_schema_facets).
        ///
        /// <p>The facets attached to the specified object.</p>
        pub fn schema_facets(mut self, input: crate::model::SchemaFacet) -> Self {
            let mut v = self.schema_facets.unwrap_or_default();
            v.push(input);
            self.schema_facets = Some(v);
            self
        }
        /// <p>The facets attached to the specified object.</p>
        pub fn set_schema_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.schema_facets = input;
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetObjectInformationResponse`](crate::model::BatchGetObjectInformationResponse)
        pub fn build(self) -> crate::model::BatchGetObjectInformationResponse {
            crate::model::BatchGetObjectInformationResponse {
                schema_facets: self.schema_facets,
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl BatchGetObjectInformationResponse {
    /// Creates a new builder-style object to manufacture [`BatchGetObjectInformationResponse`](crate::model::BatchGetObjectInformationResponse)
    pub fn builder() -> crate::model::batch_get_object_information_response::Builder {
        crate::model::batch_get_object_information_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectChildren</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectChildrenResponse {
    /// <p>The children structure, which is a map with the key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the value.</p>
    pub children:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListObjectChildrenResponse {
    /// <p>The children structure, which is a map with the key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the value.</p>
    pub fn children(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.children.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListObjectChildrenResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectChildrenResponse");
        formatter.field("children", &self.children);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListObjectChildrenResponse`](crate::model::BatchListObjectChildrenResponse)
pub mod batch_list_object_children_response {
    /// A builder for [`BatchListObjectChildrenResponse`](crate::model::BatchListObjectChildrenResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) children: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>The children structure, which is a map with the key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the value.</p>
        pub fn children(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.children.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.children = Some(hash_map);
            self
        }
        /// <p>The children structure, which is a map with the key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the value.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.children = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectChildrenResponse`](crate::model::BatchListObjectChildrenResponse)
        pub fn build(self) -> crate::model::BatchListObjectChildrenResponse {
            crate::model::BatchListObjectChildrenResponse {
                children: self.children,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListObjectChildrenResponse {
    /// Creates a new builder-style object to manufacture [`BatchListObjectChildrenResponse`](crate::model::BatchListObjectChildrenResponse)
    pub fn builder() -> crate::model::batch_list_object_children_response::Builder {
        crate::model::batch_list_object_children_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectAttributes</code> response operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectAttributesResponse {
    /// <p>The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value is the value.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListObjectAttributesResponse {
    /// <p>The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value is the value.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListObjectAttributesResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectAttributesResponse");
        formatter.field("attributes", &self.attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListObjectAttributesResponse`](crate::model::BatchListObjectAttributesResponse)
pub mod batch_list_object_attributes_response {
    /// A builder for [`BatchListObjectAttributesResponse`](crate::model::BatchListObjectAttributesResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value is the value.</p>
        pub fn attributes(mut self, input: crate::model::AttributeKeyAndValue) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value is the value.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectAttributesResponse`](crate::model::BatchListObjectAttributesResponse)
        pub fn build(self) -> crate::model::BatchListObjectAttributesResponse {
            crate::model::BatchListObjectAttributesResponse {
                attributes: self.attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListObjectAttributesResponse {
    /// Creates a new builder-style object to manufacture [`BatchListObjectAttributesResponse`](crate::model::BatchListObjectAttributesResponse)
    pub fn builder() -> crate::model::batch_list_object_attributes_response::Builder {
        crate::model::batch_list_object_attributes_response::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchRead</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadOperation {
    /// <p>Lists all attributes that are associated with an object.</p>
    pub list_object_attributes: std::option::Option<crate::model::BatchListObjectAttributes>,
    /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
    pub list_object_children: std::option::Option<crate::model::BatchListObjectChildren>,
    /// <p>Lists indices attached to an object.</p>
    pub list_attached_indices: std::option::Option<crate::model::BatchListAttachedIndices>,
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    pub list_object_parent_paths: std::option::Option<crate::model::BatchListObjectParentPaths>,
    /// <p>Retrieves metadata about an object.</p>
    pub get_object_information: std::option::Option<crate::model::BatchGetObjectInformation>,
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    pub get_object_attributes: std::option::Option<crate::model::BatchGetObjectAttributes>,
    /// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
    pub list_object_parents: std::option::Option<crate::model::BatchListObjectParents>,
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    pub list_object_policies: std::option::Option<crate::model::BatchListObjectPolicies>,
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    pub list_policy_attachments: std::option::Option<crate::model::BatchListPolicyAttachments>,
    /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub lookup_policy: std::option::Option<crate::model::BatchLookupPolicy>,
    /// <p>Lists objects attached to the specified index.</p>
    pub list_index: std::option::Option<crate::model::BatchListIndex>,
    /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub list_outgoing_typed_links: std::option::Option<crate::model::BatchListOutgoingTypedLinks>,
    /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub list_incoming_typed_links: std::option::Option<crate::model::BatchListIncomingTypedLinks>,
    /// <p>Retrieves attributes that are associated with a typed link.</p>
    pub get_link_attributes: std::option::Option<crate::model::BatchGetLinkAttributes>,
}
impl BatchReadOperation {
    /// <p>Lists all attributes that are associated with an object.</p>
    pub fn list_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectAttributes> {
        self.list_object_attributes.as_ref()
    }
    /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
    pub fn list_object_children(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectChildren> {
        self.list_object_children.as_ref()
    }
    /// <p>Lists indices attached to an object.</p>
    pub fn list_attached_indices(
        &self,
    ) -> std::option::Option<&crate::model::BatchListAttachedIndices> {
        self.list_attached_indices.as_ref()
    }
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    pub fn list_object_parent_paths(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectParentPaths> {
        self.list_object_parent_paths.as_ref()
    }
    /// <p>Retrieves metadata about an object.</p>
    pub fn get_object_information(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetObjectInformation> {
        self.get_object_information.as_ref()
    }
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    pub fn get_object_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetObjectAttributes> {
        self.get_object_attributes.as_ref()
    }
    /// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
    pub fn list_object_parents(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectParents> {
        self.list_object_parents.as_ref()
    }
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    pub fn list_object_policies(
        &self,
    ) -> std::option::Option<&crate::model::BatchListObjectPolicies> {
        self.list_object_policies.as_ref()
    }
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    pub fn list_policy_attachments(
        &self,
    ) -> std::option::Option<&crate::model::BatchListPolicyAttachments> {
        self.list_policy_attachments.as_ref()
    }
    /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub fn lookup_policy(&self) -> std::option::Option<&crate::model::BatchLookupPolicy> {
        self.lookup_policy.as_ref()
    }
    /// <p>Lists objects attached to the specified index.</p>
    pub fn list_index(&self) -> std::option::Option<&crate::model::BatchListIndex> {
        self.list_index.as_ref()
    }
    /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn list_outgoing_typed_links(
        &self,
    ) -> std::option::Option<&crate::model::BatchListOutgoingTypedLinks> {
        self.list_outgoing_typed_links.as_ref()
    }
    /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn list_incoming_typed_links(
        &self,
    ) -> std::option::Option<&crate::model::BatchListIncomingTypedLinks> {
        self.list_incoming_typed_links.as_ref()
    }
    /// <p>Retrieves attributes that are associated with a typed link.</p>
    pub fn get_link_attributes(
        &self,
    ) -> std::option::Option<&crate::model::BatchGetLinkAttributes> {
        self.get_link_attributes.as_ref()
    }
}
impl std::fmt::Debug for BatchReadOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadOperation");
        formatter.field("list_object_attributes", &self.list_object_attributes);
        formatter.field("list_object_children", &self.list_object_children);
        formatter.field("list_attached_indices", &self.list_attached_indices);
        formatter.field("list_object_parent_paths", &self.list_object_parent_paths);
        formatter.field("get_object_information", &self.get_object_information);
        formatter.field("get_object_attributes", &self.get_object_attributes);
        formatter.field("list_object_parents", &self.list_object_parents);
        formatter.field("list_object_policies", &self.list_object_policies);
        formatter.field("list_policy_attachments", &self.list_policy_attachments);
        formatter.field("lookup_policy", &self.lookup_policy);
        formatter.field("list_index", &self.list_index);
        formatter.field("list_outgoing_typed_links", &self.list_outgoing_typed_links);
        formatter.field("list_incoming_typed_links", &self.list_incoming_typed_links);
        formatter.field("get_link_attributes", &self.get_link_attributes);
        formatter.finish()
    }
}
/// See [`BatchReadOperation`](crate::model::BatchReadOperation)
pub mod batch_read_operation {
    /// A builder for [`BatchReadOperation`](crate::model::BatchReadOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_object_attributes:
            std::option::Option<crate::model::BatchListObjectAttributes>,
        pub(crate) list_object_children: std::option::Option<crate::model::BatchListObjectChildren>,
        pub(crate) list_attached_indices:
            std::option::Option<crate::model::BatchListAttachedIndices>,
        pub(crate) list_object_parent_paths:
            std::option::Option<crate::model::BatchListObjectParentPaths>,
        pub(crate) get_object_information:
            std::option::Option<crate::model::BatchGetObjectInformation>,
        pub(crate) get_object_attributes:
            std::option::Option<crate::model::BatchGetObjectAttributes>,
        pub(crate) list_object_parents: std::option::Option<crate::model::BatchListObjectParents>,
        pub(crate) list_object_policies: std::option::Option<crate::model::BatchListObjectPolicies>,
        pub(crate) list_policy_attachments:
            std::option::Option<crate::model::BatchListPolicyAttachments>,
        pub(crate) lookup_policy: std::option::Option<crate::model::BatchLookupPolicy>,
        pub(crate) list_index: std::option::Option<crate::model::BatchListIndex>,
        pub(crate) list_outgoing_typed_links:
            std::option::Option<crate::model::BatchListOutgoingTypedLinks>,
        pub(crate) list_incoming_typed_links:
            std::option::Option<crate::model::BatchListIncomingTypedLinks>,
        pub(crate) get_link_attributes: std::option::Option<crate::model::BatchGetLinkAttributes>,
    }
    impl Builder {
        /// <p>Lists all attributes that are associated with an object.</p>
        pub fn list_object_attributes(
            mut self,
            input: crate::model::BatchListObjectAttributes,
        ) -> Self {
            self.list_object_attributes = Some(input);
            self
        }
        /// <p>Lists all attributes that are associated with an object.</p>
        pub fn set_list_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectAttributes>,
        ) -> Self {
            self.list_object_attributes = input;
            self
        }
        /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
        pub fn list_object_children(
            mut self,
            input: crate::model::BatchListObjectChildren,
        ) -> Self {
            self.list_object_children = Some(input);
            self
        }
        /// <p>Returns a paginated list of child objects that are associated with a given object.</p>
        pub fn set_list_object_children(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectChildren>,
        ) -> Self {
            self.list_object_children = input;
            self
        }
        /// <p>Lists indices attached to an object.</p>
        pub fn list_attached_indices(
            mut self,
            input: crate::model::BatchListAttachedIndices,
        ) -> Self {
            self.list_attached_indices = Some(input);
            self
        }
        /// <p>Lists indices attached to an object.</p>
        pub fn set_list_attached_indices(
            mut self,
            input: std::option::Option<crate::model::BatchListAttachedIndices>,
        ) -> Self {
            self.list_attached_indices = input;
            self
        }
        /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
        pub fn list_object_parent_paths(
            mut self,
            input: crate::model::BatchListObjectParentPaths,
        ) -> Self {
            self.list_object_parent_paths = Some(input);
            self
        }
        /// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
        pub fn set_list_object_parent_paths(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectParentPaths>,
        ) -> Self {
            self.list_object_parent_paths = input;
            self
        }
        /// <p>Retrieves metadata about an object.</p>
        pub fn get_object_information(
            mut self,
            input: crate::model::BatchGetObjectInformation,
        ) -> Self {
            self.get_object_information = Some(input);
            self
        }
        /// <p>Retrieves metadata about an object.</p>
        pub fn set_get_object_information(
            mut self,
            input: std::option::Option<crate::model::BatchGetObjectInformation>,
        ) -> Self {
            self.get_object_information = input;
            self
        }
        /// <p>Retrieves attributes within a facet that are associated with an object.</p>
        pub fn get_object_attributes(
            mut self,
            input: crate::model::BatchGetObjectAttributes,
        ) -> Self {
            self.get_object_attributes = Some(input);
            self
        }
        /// <p>Retrieves attributes within a facet that are associated with an object.</p>
        pub fn set_get_object_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchGetObjectAttributes>,
        ) -> Self {
            self.get_object_attributes = input;
            self
        }
        /// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
        pub fn list_object_parents(mut self, input: crate::model::BatchListObjectParents) -> Self {
            self.list_object_parents = Some(input);
            self
        }
        /// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
        pub fn set_list_object_parents(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectParents>,
        ) -> Self {
            self.list_object_parents = input;
            self
        }
        /// <p>Returns policies attached to an object in pagination fashion.</p>
        pub fn list_object_policies(
            mut self,
            input: crate::model::BatchListObjectPolicies,
        ) -> Self {
            self.list_object_policies = Some(input);
            self
        }
        /// <p>Returns policies attached to an object in pagination fashion.</p>
        pub fn set_list_object_policies(
            mut self,
            input: std::option::Option<crate::model::BatchListObjectPolicies>,
        ) -> Self {
            self.list_object_policies = input;
            self
        }
        /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
        pub fn list_policy_attachments(
            mut self,
            input: crate::model::BatchListPolicyAttachments,
        ) -> Self {
            self.list_policy_attachments = Some(input);
            self
        }
        /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
        pub fn set_list_policy_attachments(
            mut self,
            input: std::option::Option<crate::model::BatchListPolicyAttachments>,
        ) -> Self {
            self.list_policy_attachments = input;
            self
        }
        /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn lookup_policy(mut self, input: crate::model::BatchLookupPolicy) -> Self {
            self.lookup_policy = Some(input);
            self
        }
        /// <p>Lists all policies from the root of the <code>Directory</code> to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn set_lookup_policy(
            mut self,
            input: std::option::Option<crate::model::BatchLookupPolicy>,
        ) -> Self {
            self.lookup_policy = input;
            self
        }
        /// <p>Lists objects attached to the specified index.</p>
        pub fn list_index(mut self, input: crate::model::BatchListIndex) -> Self {
            self.list_index = Some(input);
            self
        }
        /// <p>Lists objects attached to the specified index.</p>
        pub fn set_list_index(
            mut self,
            input: std::option::Option<crate::model::BatchListIndex>,
        ) -> Self {
            self.list_index = input;
            self
        }
        /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn list_outgoing_typed_links(
            mut self,
            input: crate::model::BatchListOutgoingTypedLinks,
        ) -> Self {
            self.list_outgoing_typed_links = Some(input);
            self
        }
        /// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_list_outgoing_typed_links(
            mut self,
            input: std::option::Option<crate::model::BatchListOutgoingTypedLinks>,
        ) -> Self {
            self.list_outgoing_typed_links = input;
            self
        }
        /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn list_incoming_typed_links(
            mut self,
            input: crate::model::BatchListIncomingTypedLinks,
        ) -> Self {
            self.list_incoming_typed_links = Some(input);
            self
        }
        /// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_list_incoming_typed_links(
            mut self,
            input: std::option::Option<crate::model::BatchListIncomingTypedLinks>,
        ) -> Self {
            self.list_incoming_typed_links = input;
            self
        }
        /// <p>Retrieves attributes that are associated with a typed link.</p>
        pub fn get_link_attributes(mut self, input: crate::model::BatchGetLinkAttributes) -> Self {
            self.get_link_attributes = Some(input);
            self
        }
        /// <p>Retrieves attributes that are associated with a typed link.</p>
        pub fn set_get_link_attributes(
            mut self,
            input: std::option::Option<crate::model::BatchGetLinkAttributes>,
        ) -> Self {
            self.get_link_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadOperation`](crate::model::BatchReadOperation)
        pub fn build(self) -> crate::model::BatchReadOperation {
            crate::model::BatchReadOperation {
                list_object_attributes: self.list_object_attributes,
                list_object_children: self.list_object_children,
                list_attached_indices: self.list_attached_indices,
                list_object_parent_paths: self.list_object_parent_paths,
                get_object_information: self.get_object_information,
                get_object_attributes: self.get_object_attributes,
                list_object_parents: self.list_object_parents,
                list_object_policies: self.list_object_policies,
                list_policy_attachments: self.list_policy_attachments,
                lookup_policy: self.lookup_policy,
                list_index: self.list_index,
                list_outgoing_typed_links: self.list_outgoing_typed_links,
                list_incoming_typed_links: self.list_incoming_typed_links,
                get_link_attributes: self.get_link_attributes,
            }
        }
    }
}
impl BatchReadOperation {
    /// Creates a new builder-style object to manufacture [`BatchReadOperation`](crate::model::BatchReadOperation)
    pub fn builder() -> crate::model::batch_read_operation::Builder {
        crate::model::batch_read_operation::Builder::default()
    }
}

/// <p>Retrieves attributes that are associated with a typed link inside a <code>BatchRead</code> operation. For more information, see <code>GetLinkAttributes</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetLinkAttributes {
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    /// <p>A list of attribute names whose values will be retrieved.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetLinkAttributes {
    /// <p>Allows a typed link specifier to be accepted as input.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
    /// <p>A list of attribute names whose values will be retrieved.</p>
    pub fn attribute_names(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetLinkAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetLinkAttributes");
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.finish()
    }
}
/// See [`BatchGetLinkAttributes`](crate::model::BatchGetLinkAttributes)
pub mod batch_get_link_attributes {
    /// A builder for [`BatchGetLinkAttributes`](crate::model::BatchGetLinkAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetLinkAttributes`](crate::model::BatchGetLinkAttributes)
        pub fn build(self) -> crate::model::BatchGetLinkAttributes {
            crate::model::BatchGetLinkAttributes {
                typed_link_specifier: self.typed_link_specifier,
                attribute_names: self.attribute_names,
            }
        }
    }
}
impl BatchGetLinkAttributes {
    /// Creates a new builder-style object to manufacture [`BatchGetLinkAttributes`](crate::model::BatchGetLinkAttributes)
    pub fn builder() -> crate::model::batch_get_link_attributes::Builder {
        crate::model::batch_get_link_attributes::Builder::default()
    }
}

/// <p>Returns a paginated list of all the incoming <code>TypedLinkSpecifier</code> information for an object inside a <code>BatchRead</code> operation. For more information, see <code>ListIncomingTypedLinks</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListIncomingTypedLinks {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub filter_attribute_ranges:
        std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
    /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
    pub filter_typed_link: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListIncomingTypedLinks {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub fn filter_attribute_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkAttributeRange]> {
        self.filter_attribute_ranges.as_deref()
    }
    /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
    pub fn filter_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.filter_typed_link.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListIncomingTypedLinks {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListIncomingTypedLinks");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("filter_attribute_ranges", &self.filter_attribute_ranges);
        formatter.field("filter_typed_link", &self.filter_typed_link);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListIncomingTypedLinks`](crate::model::BatchListIncomingTypedLinks)
pub mod batch_list_incoming_typed_links {
    /// A builder for [`BatchListIncomingTypedLinks`](crate::model::BatchListIncomingTypedLinks)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) filter_attribute_ranges:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        pub(crate) filter_typed_link:
            std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `filter_attribute_ranges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            let mut v = self.filter_attribute_ranges.unwrap_or_default();
            v.push(input);
            self.filter_attribute_ranges = Some(v);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.filter_attribute_ranges = input;
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.filter_typed_link = Some(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.filter_typed_link = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListIncomingTypedLinks`](crate::model::BatchListIncomingTypedLinks)
        pub fn build(self) -> crate::model::BatchListIncomingTypedLinks {
            crate::model::BatchListIncomingTypedLinks {
                object_reference: self.object_reference,
                filter_attribute_ranges: self.filter_attribute_ranges,
                filter_typed_link: self.filter_typed_link,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListIncomingTypedLinks {
    /// Creates a new builder-style object to manufacture [`BatchListIncomingTypedLinks`](crate::model::BatchListIncomingTypedLinks)
    pub fn builder() -> crate::model::batch_list_incoming_typed_links::Builder {
        crate::model::batch_list_incoming_typed_links::Builder::default()
    }
}

/// <p>Returns a paginated list of all the outgoing <code>TypedLinkSpecifier</code> information for an object inside a <code>BatchRead</code> operation. For more information, see <code>ListOutgoingTypedLinks</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListOutgoingTypedLinks {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub filter_attribute_ranges:
        std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
    /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
    pub filter_typed_link: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListOutgoingTypedLinks {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
    pub fn filter_attribute_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkAttributeRange]> {
        self.filter_attribute_ranges.as_deref()
    }
    /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
    pub fn filter_typed_link(
        &self,
    ) -> std::option::Option<&crate::model::TypedLinkSchemaAndFacetName> {
        self.filter_typed_link.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListOutgoingTypedLinks {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListOutgoingTypedLinks");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("filter_attribute_ranges", &self.filter_attribute_ranges);
        formatter.field("filter_typed_link", &self.filter_typed_link);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListOutgoingTypedLinks`](crate::model::BatchListOutgoingTypedLinks)
pub mod batch_list_outgoing_typed_links {
    /// A builder for [`BatchListOutgoingTypedLinks`](crate::model::BatchListOutgoingTypedLinks)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) filter_attribute_ranges:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        pub(crate) filter_typed_link:
            std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Appends an item to `filter_attribute_ranges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            input: crate::model::TypedLinkAttributeRange,
        ) -> Self {
            let mut v = self.filter_attribute_ranges.unwrap_or_default();
            v.push(input);
            self.filter_attribute_ranges = Some(v);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.filter_attribute_ranges = input;
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn filter_typed_link(
            mut self,
            input: crate::model::TypedLinkSchemaAndFacetName,
        ) -> Self {
            self.filter_typed_link = Some(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.filter_typed_link = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListOutgoingTypedLinks`](crate::model::BatchListOutgoingTypedLinks)
        pub fn build(self) -> crate::model::BatchListOutgoingTypedLinks {
            crate::model::BatchListOutgoingTypedLinks {
                object_reference: self.object_reference,
                filter_attribute_ranges: self.filter_attribute_ranges,
                filter_typed_link: self.filter_typed_link,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListOutgoingTypedLinks {
    /// Creates a new builder-style object to manufacture [`BatchListOutgoingTypedLinks`](crate::model::BatchListOutgoingTypedLinks)
    pub fn builder() -> crate::model::batch_list_outgoing_typed_links::Builder {
        crate::model::batch_list_outgoing_typed_links::Builder::default()
    }
}

/// <p>Lists objects attached to the specified index inside a <code>BatchRead</code> operation. For more information, see <code>ListIndex</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListIndex {
    /// <p>Specifies the ranges of indexed values that you want to query.</p>
    pub ranges_on_indexed_values:
        std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
    /// <p>The reference to the index to list.</p>
    pub index_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchListIndex {
    /// <p>Specifies the ranges of indexed values that you want to query.</p>
    pub fn ranges_on_indexed_values(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectAttributeRange]> {
        self.ranges_on_indexed_values.as_deref()
    }
    /// <p>The reference to the index to list.</p>
    pub fn index_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.index_reference.as_ref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchListIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListIndex");
        formatter.field("ranges_on_indexed_values", &self.ranges_on_indexed_values);
        formatter.field("index_reference", &self.index_reference);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchListIndex`](crate::model::BatchListIndex)
pub mod batch_list_index {
    /// A builder for [`BatchListIndex`](crate::model::BatchListIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ranges_on_indexed_values:
            std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        pub(crate) index_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ranges_on_indexed_values`.
        ///
        /// To override the contents of this collection use [`set_ranges_on_indexed_values`](Self::set_ranges_on_indexed_values).
        ///
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn ranges_on_indexed_values(
            mut self,
            input: crate::model::ObjectAttributeRange,
        ) -> Self {
            let mut v = self.ranges_on_indexed_values.unwrap_or_default();
            v.push(input);
            self.ranges_on_indexed_values = Some(v);
            self
        }
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn set_ranges_on_indexed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        ) -> Self {
            self.ranges_on_indexed_values = input;
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn index_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.index_reference = Some(input);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.index_reference = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListIndex`](crate::model::BatchListIndex)
        pub fn build(self) -> crate::model::BatchListIndex {
            crate::model::BatchListIndex {
                ranges_on_indexed_values: self.ranges_on_indexed_values,
                index_reference: self.index_reference,
                max_results: self.max_results,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchListIndex {
    /// Creates a new builder-style object to manufacture [`BatchListIndex`](crate::model::BatchListIndex)
    pub fn builder() -> crate::model::batch_list_index::Builder {
        crate::model::batch_list_index::Builder::default()
    }
}

/// <p>Lists all policies from the root of the Directory to the object specified inside a <code>BatchRead</code> operation. For more information, see <code>LookupPolicy</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchLookupPolicy {
    /// <p>Reference that identifies the object whose policies will be looked up.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchLookupPolicy {
    /// <p>Reference that identifies the object whose policies will be looked up.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchLookupPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchLookupPolicy");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchLookupPolicy`](crate::model::BatchLookupPolicy)
pub mod batch_lookup_policy {
    /// A builder for [`BatchLookupPolicy`](crate::model::BatchLookupPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchLookupPolicy`](crate::model::BatchLookupPolicy)
        pub fn build(self) -> crate::model::BatchLookupPolicy {
            crate::model::BatchLookupPolicy {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchLookupPolicy {
    /// Creates a new builder-style object to manufacture [`BatchLookupPolicy`](crate::model::BatchLookupPolicy)
    pub fn builder() -> crate::model::batch_lookup_policy::Builder {
        crate::model::batch_lookup_policy::Builder::default()
    }
}

/// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached inside a <code>BatchRead</code> operation. For more information, see <code>ListPolicyAttachments</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListPolicyAttachments {
    /// <p>The reference that identifies the policy object.</p>
    pub policy_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListPolicyAttachments {
    /// <p>The reference that identifies the policy object.</p>
    pub fn policy_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.policy_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListPolicyAttachments {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListPolicyAttachments");
        formatter.field("policy_reference", &self.policy_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListPolicyAttachments`](crate::model::BatchListPolicyAttachments)
pub mod batch_list_policy_attachments {
    /// A builder for [`BatchListPolicyAttachments`](crate::model::BatchListPolicyAttachments)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.policy_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.policy_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListPolicyAttachments`](crate::model::BatchListPolicyAttachments)
        pub fn build(self) -> crate::model::BatchListPolicyAttachments {
            crate::model::BatchListPolicyAttachments {
                policy_reference: self.policy_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListPolicyAttachments {
    /// Creates a new builder-style object to manufacture [`BatchListPolicyAttachments`](crate::model::BatchListPolicyAttachments)
    pub fn builder() -> crate::model::batch_list_policy_attachments::Builder {
        crate::model::batch_list_policy_attachments::Builder::default()
    }
}

/// <p>Returns policies attached to an object in pagination fashion inside a <code>BatchRead</code> operation. For more information, see <code>ListObjectPolicies</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectPolicies {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListObjectPolicies {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListObjectPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectPolicies");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListObjectPolicies`](crate::model::BatchListObjectPolicies)
pub mod batch_list_object_policies {
    /// A builder for [`BatchListObjectPolicies`](crate::model::BatchListObjectPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectPolicies`](crate::model::BatchListObjectPolicies)
        pub fn build(self) -> crate::model::BatchListObjectPolicies {
            crate::model::BatchListObjectPolicies {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListObjectPolicies {
    /// Creates a new builder-style object to manufacture [`BatchListObjectPolicies`](crate::model::BatchListObjectPolicies)
    pub fn builder() -> crate::model::batch_list_object_policies::Builder {
        crate::model::batch_list_object_policies::Builder::default()
    }
}

/// <p>Lists parent objects that are associated with a given object in pagination fashion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectParents {
    /// <p>The reference that identifies an object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListObjectParents {
    /// <p>The reference that identifies an object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListObjectParents {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectParents");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListObjectParents`](crate::model::BatchListObjectParents)
pub mod batch_list_object_parents {
    /// A builder for [`BatchListObjectParents`](crate::model::BatchListObjectParents)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies an object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies an object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectParents`](crate::model::BatchListObjectParents)
        pub fn build(self) -> crate::model::BatchListObjectParents {
            crate::model::BatchListObjectParents {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListObjectParents {
    /// Creates a new builder-style object to manufacture [`BatchListObjectParents`](crate::model::BatchListObjectParents)
    pub fn builder() -> crate::model::batch_list_object_parents::Builder {
        crate::model::batch_list_object_parents::Builder::default()
    }
}

/// <p>Retrieves attributes within a facet that are associated with an object inside an <code>BatchRead</code> operation. For more information, see <code>GetObjectAttributes</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetObjectAttributes {
    /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
    pub schema_facet: std::option::Option<crate::model::SchemaFacet>,
    /// <p>List of attribute names whose values will be retrieved.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetObjectAttributes {
    /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
    pub fn schema_facet(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.schema_facet.as_ref()
    }
    /// <p>List of attribute names whose values will be retrieved.</p>
    pub fn attribute_names(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetObjectAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetObjectAttributes");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("schema_facet", &self.schema_facet);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.finish()
    }
}
/// See [`BatchGetObjectAttributes`](crate::model::BatchGetObjectAttributes)
pub mod batch_get_object_attributes {
    /// A builder for [`BatchGetObjectAttributes`](crate::model::BatchGetObjectAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) schema_facet: std::option::Option<crate::model::SchemaFacet>,
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn schema_facet(mut self, input: crate::model::SchemaFacet) -> Self {
            self.schema_facet = Some(input);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <code>SchemaFacet</code> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.schema_facet = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetObjectAttributes`](crate::model::BatchGetObjectAttributes)
        pub fn build(self) -> crate::model::BatchGetObjectAttributes {
            crate::model::BatchGetObjectAttributes {
                object_reference: self.object_reference,
                schema_facet: self.schema_facet,
                attribute_names: self.attribute_names,
            }
        }
    }
}
impl BatchGetObjectAttributes {
    /// Creates a new builder-style object to manufacture [`BatchGetObjectAttributes`](crate::model::BatchGetObjectAttributes)
    pub fn builder() -> crate::model::batch_get_object_attributes::Builder {
        crate::model::batch_get_object_attributes::Builder::default()
    }
}

/// <p>Retrieves metadata about an object inside a <code>BatchRead</code> operation. For more information, see <code>GetObjectInformation</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetObjectInformation {
    /// <p>A reference to the object.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
}
impl BatchGetObjectInformation {
    /// <p>A reference to the object.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
}
impl std::fmt::Debug for BatchGetObjectInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetObjectInformation");
        formatter.field("object_reference", &self.object_reference);
        formatter.finish()
    }
}
/// See [`BatchGetObjectInformation`](crate::model::BatchGetObjectInformation)
pub mod batch_get_object_information {
    /// A builder for [`BatchGetObjectInformation`](crate::model::BatchGetObjectInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
    }
    impl Builder {
        /// <p>A reference to the object.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetObjectInformation`](crate::model::BatchGetObjectInformation)
        pub fn build(self) -> crate::model::BatchGetObjectInformation {
            crate::model::BatchGetObjectInformation {
                object_reference: self.object_reference,
            }
        }
    }
}
impl BatchGetObjectInformation {
    /// Creates a new builder-style object to manufacture [`BatchGetObjectInformation`](crate::model::BatchGetObjectInformation)
    pub fn builder() -> crate::model::batch_get_object_information::Builder {
        crate::model::batch_get_object_information::Builder::default()
    }
}

/// <p>Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects inside a <code>BatchRead</code> operation. For more information, see <code>ListObjectParentPaths</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectParentPaths {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListObjectParentPaths {
    /// <p>The reference that identifies the object whose attributes will be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListObjectParentPaths {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectParentPaths");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListObjectParentPaths`](crate::model::BatchListObjectParentPaths)
pub mod batch_list_object_parent_paths {
    /// A builder for [`BatchListObjectParentPaths`](crate::model::BatchListObjectParentPaths)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectParentPaths`](crate::model::BatchListObjectParentPaths)
        pub fn build(self) -> crate::model::BatchListObjectParentPaths {
            crate::model::BatchListObjectParentPaths {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListObjectParentPaths {
    /// Creates a new builder-style object to manufacture [`BatchListObjectParentPaths`](crate::model::BatchListObjectParentPaths)
    pub fn builder() -> crate::model::batch_list_object_parent_paths::Builder {
        crate::model::batch_list_object_parent_paths::Builder::default()
    }
}

/// <p>Lists indices attached to an object inside a <code>BatchRead</code> operation. For more information, see <code>ListAttachedIndices</code> and <code>BatchReadRequest$Operations</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListAttachedIndices {
    /// <p>A reference to the object that has indices attached.</p>
    pub target_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to retrieve.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListAttachedIndices {
    /// <p>A reference to the object that has indices attached.</p>
    pub fn target_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.target_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListAttachedIndices {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListAttachedIndices");
        formatter.field("target_reference", &self.target_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListAttachedIndices`](crate::model::BatchListAttachedIndices)
pub mod batch_list_attached_indices {
    /// A builder for [`BatchListAttachedIndices`](crate::model::BatchListAttachedIndices)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A reference to the object that has indices attached.</p>
        pub fn target_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.target_reference = Some(input);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.target_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListAttachedIndices`](crate::model::BatchListAttachedIndices)
        pub fn build(self) -> crate::model::BatchListAttachedIndices {
            crate::model::BatchListAttachedIndices {
                target_reference: self.target_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListAttachedIndices {
    /// Creates a new builder-style object to manufacture [`BatchListAttachedIndices`](crate::model::BatchListAttachedIndices)
    pub fn builder() -> crate::model::batch_list_attached_indices::Builder {
        crate::model::batch_list_attached_indices::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectChildren</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectChildren {
    /// <p>Reference of the object for which child objects are being listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
}
impl BatchListObjectChildren {
    /// <p>Reference of the object for which child objects are being listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for BatchListObjectChildren {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectChildren");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`BatchListObjectChildren`](crate::model::BatchListObjectChildren)
pub mod batch_list_object_children {
    /// A builder for [`BatchListObjectChildren`](crate::model::BatchListObjectChildren)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Reference of the object for which child objects are being listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference of the object for which child objects are being listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectChildren`](crate::model::BatchListObjectChildren)
        pub fn build(self) -> crate::model::BatchListObjectChildren {
            crate::model::BatchListObjectChildren {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl BatchListObjectChildren {
    /// Creates a new builder-style object to manufacture [`BatchListObjectChildren`](crate::model::BatchListObjectChildren)
    pub fn builder() -> crate::model::batch_list_object_children::Builder {
        crate::model::batch_list_object_children::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListObjectAttributes</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchListObjectAttributes {
    /// <p>Reference of the object whose attributes need to be listed.</p>
    pub object_reference: std::option::Option<crate::model::ObjectReference>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
    pub facet_filter: std::option::Option<crate::model::SchemaFacet>,
}
impl BatchListObjectAttributes {
    /// <p>Reference of the object whose attributes need to be listed.</p>
    pub fn object_reference(&self) -> std::option::Option<&crate::model::ObjectReference> {
        self.object_reference.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
    pub fn facet_filter(&self) -> std::option::Option<&crate::model::SchemaFacet> {
        self.facet_filter.as_ref()
    }
}
impl std::fmt::Debug for BatchListObjectAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchListObjectAttributes");
        formatter.field("object_reference", &self.object_reference);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("facet_filter", &self.facet_filter);
        formatter.finish()
    }
}
/// See [`BatchListObjectAttributes`](crate::model::BatchListObjectAttributes)
pub mod batch_list_object_attributes {
    /// A builder for [`BatchListObjectAttributes`](crate::model::BatchListObjectAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_reference: std::option::Option<crate::model::ObjectReference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) facet_filter: std::option::Option<crate::model::SchemaFacet>,
    }
    impl Builder {
        /// <p>Reference of the object whose attributes need to be listed.</p>
        pub fn object_reference(mut self, input: crate::model::ObjectReference) -> Self {
            self.object_reference = Some(input);
            self
        }
        /// <p>Reference of the object whose attributes need to be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.object_reference = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn facet_filter(mut self, input: crate::model::SchemaFacet) -> Self {
            self.facet_filter = Some(input);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain facet.</p>
        pub fn set_facet_filter(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.facet_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchListObjectAttributes`](crate::model::BatchListObjectAttributes)
        pub fn build(self) -> crate::model::BatchListObjectAttributes {
            crate::model::BatchListObjectAttributes {
                object_reference: self.object_reference,
                next_token: self.next_token,
                max_results: self.max_results,
                facet_filter: self.facet_filter,
            }
        }
    }
}
impl BatchListObjectAttributes {
    /// Creates a new builder-style object to manufacture [`BatchListObjectAttributes`](crate::model::BatchListObjectAttributes)
    pub fn builder() -> crate::model::batch_list_object_attributes::Builder {
        crate::model::batch_list_object_attributes::Builder::default()
    }
}
