// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradePublishedSchemaOutput {
    /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    pub upgraded_schema_arn: std::option::Option<std::string::String>,
}
impl UpgradePublishedSchemaOutput {
    /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    pub fn upgraded_schema_arn(&self) -> std::option::Option<&str> {
        self.upgraded_schema_arn.as_deref()
    }
}
impl std::fmt::Debug for UpgradePublishedSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradePublishedSchemaOutput");
        formatter.field("upgraded_schema_arn", &self.upgraded_schema_arn);
        formatter.finish()
    }
}
/// See [`UpgradePublishedSchemaOutput`](crate::output::UpgradePublishedSchemaOutput)
pub mod upgrade_published_schema_output {
    /// A builder for [`UpgradePublishedSchemaOutput`](crate::output::UpgradePublishedSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgraded_schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
        pub fn upgraded_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgraded_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
        pub fn set_upgraded_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upgraded_schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradePublishedSchemaOutput`](crate::output::UpgradePublishedSchemaOutput)
        pub fn build(self) -> crate::output::UpgradePublishedSchemaOutput {
            crate::output::UpgradePublishedSchemaOutput {
                upgraded_schema_arn: self.upgraded_schema_arn,
            }
        }
    }
}
impl UpgradePublishedSchemaOutput {
    /// Creates a new builder-style object to manufacture [`UpgradePublishedSchemaOutput`](crate::output::UpgradePublishedSchemaOutput)
    pub fn builder() -> crate::output::upgrade_published_schema_output::Builder {
        crate::output::upgrade_published_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeAppliedSchemaOutput {
    /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    pub upgraded_schema_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the directory that is returned as part of the response.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl UpgradeAppliedSchemaOutput {
    /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
    pub fn upgraded_schema_arn(&self) -> std::option::Option<&str> {
        self.upgraded_schema_arn.as_deref()
    }
    /// <p>The ARN of the directory that is returned as part of the response.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for UpgradeAppliedSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeAppliedSchemaOutput");
        formatter.field("upgraded_schema_arn", &self.upgraded_schema_arn);
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}
/// See [`UpgradeAppliedSchemaOutput`](crate::output::UpgradeAppliedSchemaOutput)
pub mod upgrade_applied_schema_output {
    /// A builder for [`UpgradeAppliedSchemaOutput`](crate::output::UpgradeAppliedSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgraded_schema_arn: std::option::Option<std::string::String>,
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
        pub fn upgraded_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgraded_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the upgraded schema that is returned as part of the response.</p>
        pub fn set_upgraded_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upgraded_schema_arn = input;
            self
        }
        /// <p>The ARN of the directory that is returned as part of the response.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory that is returned as part of the response.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeAppliedSchemaOutput`](crate::output::UpgradeAppliedSchemaOutput)
        pub fn build(self) -> crate::output::UpgradeAppliedSchemaOutput {
            crate::output::UpgradeAppliedSchemaOutput {
                upgraded_schema_arn: self.upgraded_schema_arn,
                directory_arn: self.directory_arn,
            }
        }
    }
}
impl UpgradeAppliedSchemaOutput {
    /// Creates a new builder-style object to manufacture [`UpgradeAppliedSchemaOutput`](crate::output::UpgradeAppliedSchemaOutput)
    pub fn builder() -> crate::output::upgrade_applied_schema_output::Builder {
        crate::output::upgrade_applied_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTypedLinkFacetOutput {}
impl std::fmt::Debug for UpdateTypedLinkFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTypedLinkFacetOutput");
        formatter.finish()
    }
}
/// See [`UpdateTypedLinkFacetOutput`](crate::output::UpdateTypedLinkFacetOutput)
pub mod update_typed_link_facet_output {
    /// A builder for [`UpdateTypedLinkFacetOutput`](crate::output::UpdateTypedLinkFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTypedLinkFacetOutput`](crate::output::UpdateTypedLinkFacetOutput)
        pub fn build(self) -> crate::output::UpdateTypedLinkFacetOutput {
            crate::output::UpdateTypedLinkFacetOutput {}
        }
    }
}
impl UpdateTypedLinkFacetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTypedLinkFacetOutput`](crate::output::UpdateTypedLinkFacetOutput)
    pub fn builder() -> crate::output::update_typed_link_facet_output::Builder {
        crate::output::update_typed_link_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSchemaOutput {
    /// <p>The ARN that is associated with the updated schema. For more information, see <a>arns</a>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl UpdateSchemaOutput {
    /// <p>The ARN that is associated with the updated schema. For more information, see <a>arns</a>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}
/// See [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
pub mod update_schema_output {
    /// A builder for [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that is associated with the updated schema. For more information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN that is associated with the updated schema. For more information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
        pub fn build(self) -> crate::output::UpdateSchemaOutput {
            crate::output::UpdateSchemaOutput {
                schema_arn: self.schema_arn,
            }
        }
    }
}
impl UpdateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    pub fn builder() -> crate::output::update_schema_output::Builder {
        crate::output::update_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateObjectAttributesOutput {
    /// <p>The <code>ObjectIdentifier</code> of the updated object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl UpdateObjectAttributesOutput {
    /// <p>The <code>ObjectIdentifier</code> of the updated object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for UpdateObjectAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateObjectAttributesOutput");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`UpdateObjectAttributesOutput`](crate::output::UpdateObjectAttributesOutput)
pub mod update_object_attributes_output {
    /// A builder for [`UpdateObjectAttributesOutput`](crate::output::UpdateObjectAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the updated object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the updated object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateObjectAttributesOutput`](crate::output::UpdateObjectAttributesOutput)
        pub fn build(self) -> crate::output::UpdateObjectAttributesOutput {
            crate::output::UpdateObjectAttributesOutput {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl UpdateObjectAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateObjectAttributesOutput`](crate::output::UpdateObjectAttributesOutput)
    pub fn builder() -> crate::output::update_object_attributes_output::Builder {
        crate::output::update_object_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLinkAttributesOutput {}
impl std::fmt::Debug for UpdateLinkAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLinkAttributesOutput");
        formatter.finish()
    }
}
/// See [`UpdateLinkAttributesOutput`](crate::output::UpdateLinkAttributesOutput)
pub mod update_link_attributes_output {
    /// A builder for [`UpdateLinkAttributesOutput`](crate::output::UpdateLinkAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLinkAttributesOutput`](crate::output::UpdateLinkAttributesOutput)
        pub fn build(self) -> crate::output::UpdateLinkAttributesOutput {
            crate::output::UpdateLinkAttributesOutput {}
        }
    }
}
impl UpdateLinkAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLinkAttributesOutput`](crate::output::UpdateLinkAttributesOutput)
    pub fn builder() -> crate::output::update_link_attributes_output::Builder {
        crate::output::update_link_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFacetOutput {}
impl std::fmt::Debug for UpdateFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFacetOutput");
        formatter.finish()
    }
}
/// See [`UpdateFacetOutput`](crate::output::UpdateFacetOutput)
pub mod update_facet_output {
    /// A builder for [`UpdateFacetOutput`](crate::output::UpdateFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateFacetOutput`](crate::output::UpdateFacetOutput)
        pub fn build(self) -> crate::output::UpdateFacetOutput {
            crate::output::UpdateFacetOutput {}
        }
    }
}
impl UpdateFacetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFacetOutput`](crate::output::UpdateFacetOutput)
    pub fn builder() -> crate::output::update_facet_output::Builder {
        crate::output::update_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFacetFromObjectOutput {}
impl std::fmt::Debug for RemoveFacetFromObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFacetFromObjectOutput");
        formatter.finish()
    }
}
/// See [`RemoveFacetFromObjectOutput`](crate::output::RemoveFacetFromObjectOutput)
pub mod remove_facet_from_object_output {
    /// A builder for [`RemoveFacetFromObjectOutput`](crate::output::RemoveFacetFromObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveFacetFromObjectOutput`](crate::output::RemoveFacetFromObjectOutput)
        pub fn build(self) -> crate::output::RemoveFacetFromObjectOutput {
            crate::output::RemoveFacetFromObjectOutput {}
        }
    }
}
impl RemoveFacetFromObjectOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFacetFromObjectOutput`](crate::output::RemoveFacetFromObjectOutput)
    pub fn builder() -> crate::output::remove_facet_from_object_output::Builder {
        crate::output::remove_facet_from_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSchemaFromJsonOutput {
    /// <p>The ARN of the schema to update.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl PutSchemaFromJsonOutput {
    /// <p>The ARN of the schema to update.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for PutSchemaFromJsonOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSchemaFromJsonOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`PutSchemaFromJsonOutput`](crate::output::PutSchemaFromJsonOutput)
pub mod put_schema_from_json_output {
    /// A builder for [`PutSchemaFromJsonOutput`](crate::output::PutSchemaFromJsonOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the schema to update.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSchemaFromJsonOutput`](crate::output::PutSchemaFromJsonOutput)
        pub fn build(self) -> crate::output::PutSchemaFromJsonOutput {
            crate::output::PutSchemaFromJsonOutput { arn: self.arn }
        }
    }
}
impl PutSchemaFromJsonOutput {
    /// Creates a new builder-style object to manufacture [`PutSchemaFromJsonOutput`](crate::output::PutSchemaFromJsonOutput)
    pub fn builder() -> crate::output::put_schema_from_json_output::Builder {
        crate::output::put_schema_from_json_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishSchemaOutput {
    /// <p>The ARN that is associated with the published schema. For more information, see <a>arns</a>.</p>
    pub published_schema_arn: std::option::Option<std::string::String>,
}
impl PublishSchemaOutput {
    /// <p>The ARN that is associated with the published schema. For more information, see <a>arns</a>.</p>
    pub fn published_schema_arn(&self) -> std::option::Option<&str> {
        self.published_schema_arn.as_deref()
    }
}
impl std::fmt::Debug for PublishSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishSchemaOutput");
        formatter.field("published_schema_arn", &self.published_schema_arn);
        formatter.finish()
    }
}
/// See [`PublishSchemaOutput`](crate::output::PublishSchemaOutput)
pub mod publish_schema_output {
    /// A builder for [`PublishSchemaOutput`](crate::output::PublishSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) published_schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that is associated with the published schema. For more information, see <a>arns</a>.</p>
        pub fn published_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN that is associated with the published schema. For more information, see <a>arns</a>.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.published_schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishSchemaOutput`](crate::output::PublishSchemaOutput)
        pub fn build(self) -> crate::output::PublishSchemaOutput {
            crate::output::PublishSchemaOutput {
                published_schema_arn: self.published_schema_arn,
            }
        }
    }
}
impl PublishSchemaOutput {
    /// Creates a new builder-style object to manufacture [`PublishSchemaOutput`](crate::output::PublishSchemaOutput)
    pub fn builder() -> crate::output::publish_schema_output::Builder {
        crate::output::publish_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupPolicyOutput {
    /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
    /// <code>PolicyType</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub policy_to_path_list: std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LookupPolicyOutput {
    /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
    /// <code>PolicyType</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    pub fn policy_to_path_list(&self) -> std::option::Option<&[crate::model::PolicyToPath]> {
        self.policy_to_path_list.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LookupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupPolicyOutput");
        formatter.field("policy_to_path_list", &self.policy_to_path_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`LookupPolicyOutput`](crate::output::LookupPolicyOutput)
pub mod lookup_policy_output {
    /// A builder for [`LookupPolicyOutput`](crate::output::LookupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_to_path_list:
            std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_to_path_list`.
        ///
        /// To override the contents of this collection use [`set_policy_to_path_list`](Self::set_policy_to_path_list).
        ///
        /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
        /// <code>PolicyType</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn policy_to_path_list(mut self, input: impl Into<crate::model::PolicyToPath>) -> Self {
            let mut v = self.policy_to_path_list.unwrap_or_default();
            v.push(input.into());
            self.policy_to_path_list = Some(v);
            self
        }
        /// <p>Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
        /// <code>PolicyType</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        pub fn set_policy_to_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyToPath>>,
        ) -> Self {
            self.policy_to_path_list = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupPolicyOutput`](crate::output::LookupPolicyOutput)
        pub fn build(self) -> crate::output::LookupPolicyOutput {
            crate::output::LookupPolicyOutput {
                policy_to_path_list: self.policy_to_path_list,
                next_token: self.next_token,
            }
        }
    }
}
impl LookupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`LookupPolicyOutput`](crate::output::LookupPolicyOutput)
    pub fn builder() -> crate::output::lookup_policy_output::Builder {
        crate::output::lookup_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypedLinkFacetNamesOutput {
    /// <p>The names of typed link facets that exist within the schema.</p>
    pub facet_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTypedLinkFacetNamesOutput {
    /// <p>The names of typed link facets that exist within the schema.</p>
    pub fn facet_names(&self) -> std::option::Option<&[std::string::String]> {
        self.facet_names.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTypedLinkFacetNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypedLinkFacetNamesOutput");
        formatter.field("facet_names", &self.facet_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTypedLinkFacetNamesOutput`](crate::output::ListTypedLinkFacetNamesOutput)
pub mod list_typed_link_facet_names_output {
    /// A builder for [`ListTypedLinkFacetNamesOutput`](crate::output::ListTypedLinkFacetNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) facet_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `facet_names`.
        ///
        /// To override the contents of this collection use [`set_facet_names`](Self::set_facet_names).
        ///
        /// <p>The names of typed link facets that exist within the schema.</p>
        pub fn facet_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.facet_names.unwrap_or_default();
            v.push(input.into());
            self.facet_names = Some(v);
            self
        }
        /// <p>The names of typed link facets that exist within the schema.</p>
        pub fn set_facet_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.facet_names = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypedLinkFacetNamesOutput`](crate::output::ListTypedLinkFacetNamesOutput)
        pub fn build(self) -> crate::output::ListTypedLinkFacetNamesOutput {
            crate::output::ListTypedLinkFacetNamesOutput {
                facet_names: self.facet_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTypedLinkFacetNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetNamesOutput`](crate::output::ListTypedLinkFacetNamesOutput)
    pub fn builder() -> crate::output::list_typed_link_facet_names_output::Builder {
        crate::output::list_typed_link_facet_names_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypedLinkFacetAttributesOutput {
    /// <p>An ordered set of attributes associate with the typed link.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTypedLinkFacetAttributesOutput {
    /// <p>An ordered set of attributes associate with the typed link.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::TypedLinkAttributeDefinition]> {
        self.attributes.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTypedLinkFacetAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypedLinkFacetAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTypedLinkFacetAttributesOutput`](crate::output::ListTypedLinkFacetAttributesOutput)
pub mod list_typed_link_facet_attributes_output {
    /// A builder for [`ListTypedLinkFacetAttributesOutput`](crate::output::ListTypedLinkFacetAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>An ordered set of attributes associate with the typed link.</p>
        pub fn attributes(
            mut self,
            input: impl Into<crate::model::TypedLinkAttributeDefinition>,
        ) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>An ordered set of attributes associate with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeDefinition>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypedLinkFacetAttributesOutput`](crate::output::ListTypedLinkFacetAttributesOutput)
        pub fn build(self) -> crate::output::ListTypedLinkFacetAttributesOutput {
            crate::output::ListTypedLinkFacetAttributesOutput {
                attributes: self.attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTypedLinkFacetAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetAttributesOutput`](crate::output::ListTypedLinkFacetAttributesOutput)
    pub fn builder() -> crate::output::list_typed_link_facet_attributes_output::Builder {
        crate::output::list_typed_link_facet_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tag key value pairs that are associated with the response.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tag key value pairs that are associated with the response.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key value pairs that are associated with the response.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag key value pairs that are associated with the response.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublishedSchemaArnsOutput {
    /// <p>The ARNs of published schemas.</p>
    pub schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPublishedSchemaArnsOutput {
    /// <p>The ARNs of published schemas.</p>
    pub fn schema_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.schema_arns.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPublishedSchemaArnsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublishedSchemaArnsOutput");
        formatter.field("schema_arns", &self.schema_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPublishedSchemaArnsOutput`](crate::output::ListPublishedSchemaArnsOutput)
pub mod list_published_schema_arns_output {
    /// A builder for [`ListPublishedSchemaArnsOutput`](crate::output::ListPublishedSchemaArnsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_arns`.
        ///
        /// To override the contents of this collection use [`set_schema_arns`](Self::set_schema_arns).
        ///
        /// <p>The ARNs of published schemas.</p>
        pub fn schema_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schema_arns.unwrap_or_default();
            v.push(input.into());
            self.schema_arns = Some(v);
            self
        }
        /// <p>The ARNs of published schemas.</p>
        pub fn set_schema_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schema_arns = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublishedSchemaArnsOutput`](crate::output::ListPublishedSchemaArnsOutput)
        pub fn build(self) -> crate::output::ListPublishedSchemaArnsOutput {
            crate::output::ListPublishedSchemaArnsOutput {
                schema_arns: self.schema_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPublishedSchemaArnsOutput {
    /// Creates a new builder-style object to manufacture [`ListPublishedSchemaArnsOutput`](crate::output::ListPublishedSchemaArnsOutput)
    pub fn builder() -> crate::output::list_published_schema_arns_output::Builder {
        crate::output::list_published_schema_arns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyAttachmentsOutput {
    /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
    pub object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPolicyAttachmentsOutput {
    /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
    pub fn object_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.object_identifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyAttachmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyAttachmentsOutput");
        formatter.field("object_identifiers", &self.object_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPolicyAttachmentsOutput`](crate::output::ListPolicyAttachmentsOutput)
pub mod list_policy_attachments_output {
    /// A builder for [`ListPolicyAttachmentsOutput`](crate::output::ListPolicyAttachmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `object_identifiers`.
        ///
        /// To override the contents of this collection use [`set_object_identifiers`](Self::set_object_identifiers).
        ///
        /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
        pub fn object_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.object_identifiers.unwrap_or_default();
            v.push(input.into());
            self.object_identifiers = Some(v);
            self
        }
        /// <p>A list of <code>ObjectIdentifiers</code> to which the policy is attached.</p>
        pub fn set_object_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.object_identifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyAttachmentsOutput`](crate::output::ListPolicyAttachmentsOutput)
        pub fn build(self) -> crate::output::ListPolicyAttachmentsOutput {
            crate::output::ListPolicyAttachmentsOutput {
                object_identifiers: self.object_identifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPolicyAttachmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyAttachmentsOutput`](crate::output::ListPolicyAttachmentsOutput)
    pub fn builder() -> crate::output::list_policy_attachments_output::Builder {
        crate::output::list_policy_attachments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutgoingTypedLinksOutput {
    /// <p>Returns a typed link specifier as output.</p>
    pub typed_link_specifiers: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOutgoingTypedLinksOutput {
    /// <p>Returns a typed link specifier as output.</p>
    pub fn typed_link_specifiers(
        &self,
    ) -> std::option::Option<&[crate::model::TypedLinkSpecifier]> {
        self.typed_link_specifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOutgoingTypedLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutgoingTypedLinksOutput");
        formatter.field("typed_link_specifiers", &self.typed_link_specifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOutgoingTypedLinksOutput`](crate::output::ListOutgoingTypedLinksOutput)
pub mod list_outgoing_typed_links_output {
    /// A builder for [`ListOutgoingTypedLinksOutput`](crate::output::ListOutgoingTypedLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifiers:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `typed_link_specifiers`.
        ///
        /// To override the contents of this collection use [`set_typed_link_specifiers`](Self::set_typed_link_specifiers).
        ///
        /// <p>Returns a typed link specifier as output.</p>
        pub fn typed_link_specifiers(
            mut self,
            input: impl Into<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            let mut v = self.typed_link_specifiers.unwrap_or_default();
            v.push(input.into());
            self.typed_link_specifiers = Some(v);
            self
        }
        /// <p>Returns a typed link specifier as output.</p>
        pub fn set_typed_link_specifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        ) -> Self {
            self.typed_link_specifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutgoingTypedLinksOutput`](crate::output::ListOutgoingTypedLinksOutput)
        pub fn build(self) -> crate::output::ListOutgoingTypedLinksOutput {
            crate::output::ListOutgoingTypedLinksOutput {
                typed_link_specifiers: self.typed_link_specifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOutgoingTypedLinksOutput {
    /// Creates a new builder-style object to manufacture [`ListOutgoingTypedLinksOutput`](crate::output::ListOutgoingTypedLinksOutput)
    pub fn builder() -> crate::output::list_outgoing_typed_links_output::Builder {
        crate::output::list_outgoing_typed_links_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectPoliciesOutput {
    /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the
    /// object.</p>
    pub attached_policy_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListObjectPoliciesOutput {
    /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the
    /// object.</p>
    pub fn attached_policy_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.attached_policy_ids.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListObjectPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectPoliciesOutput");
        formatter.field("attached_policy_ids", &self.attached_policy_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListObjectPoliciesOutput`](crate::output::ListObjectPoliciesOutput)
pub mod list_object_policies_output {
    /// A builder for [`ListObjectPoliciesOutput`](crate::output::ListObjectPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_policy_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attached_policy_ids`.
        ///
        /// To override the contents of this collection use [`set_attached_policy_ids`](Self::set_attached_policy_ids).
        ///
        /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the
        /// object.</p>
        pub fn attached_policy_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attached_policy_ids.unwrap_or_default();
            v.push(input.into());
            self.attached_policy_ids = Some(v);
            self
        }
        /// <p>A list of policy <code>ObjectIdentifiers</code>, that are attached to the
        /// object.</p>
        pub fn set_attached_policy_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attached_policy_ids = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectPoliciesOutput`](crate::output::ListObjectPoliciesOutput)
        pub fn build(self) -> crate::output::ListObjectPoliciesOutput {
            crate::output::ListObjectPoliciesOutput {
                attached_policy_ids: self.attached_policy_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListObjectPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectPoliciesOutput`](crate::output::ListObjectPoliciesOutput)
    pub fn builder() -> crate::output::list_object_policies_output::Builder {
        crate::output::list_object_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectParentsOutput {
    /// <p>The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and
    /// LinkName as the value.</p>
    pub parents:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Returns a list of parent reference and LinkName Tuples.</p>
    pub parent_links:
        std::option::Option<std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>>,
}
impl ListObjectParentsOutput {
    /// <p>The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and
    /// LinkName as the value.</p>
    pub fn parents(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parents.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Returns a list of parent reference and LinkName Tuples.</p>
    pub fn parent_links(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectIdentifierAndLinkNameTuple]> {
        self.parent_links.as_deref()
    }
}
impl std::fmt::Debug for ListObjectParentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectParentsOutput");
        formatter.field("parents", &self.parents);
        formatter.field("next_token", &self.next_token);
        formatter.field("parent_links", &self.parent_links);
        formatter.finish()
    }
}
/// See [`ListObjectParentsOutput`](crate::output::ListObjectParentsOutput)
pub mod list_object_parents_output {
    /// A builder for [`ListObjectParentsOutput`](crate::output::ListObjectParentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parents: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) parent_links:
            std::option::Option<std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>>,
    }
    impl Builder {
        /// Adds a key-value pair to `parents`.
        ///
        /// To override the contents of this collection use [`set_parents`](Self::set_parents).
        ///
        /// <p>The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and
        /// LinkName as the value.</p>
        pub fn parents(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parents.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parents = Some(hash_map);
            self
        }
        /// <p>The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and
        /// LinkName as the value.</p>
        pub fn set_parents(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parents = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `parent_links`.
        ///
        /// To override the contents of this collection use [`set_parent_links`](Self::set_parent_links).
        ///
        /// <p>Returns a list of parent reference and LinkName Tuples.</p>
        pub fn parent_links(
            mut self,
            input: impl Into<crate::model::ObjectIdentifierAndLinkNameTuple>,
        ) -> Self {
            let mut v = self.parent_links.unwrap_or_default();
            v.push(input.into());
            self.parent_links = Some(v);
            self
        }
        /// <p>Returns a list of parent reference and LinkName Tuples.</p>
        pub fn set_parent_links(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ObjectIdentifierAndLinkNameTuple>,
            >,
        ) -> Self {
            self.parent_links = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectParentsOutput`](crate::output::ListObjectParentsOutput)
        pub fn build(self) -> crate::output::ListObjectParentsOutput {
            crate::output::ListObjectParentsOutput {
                parents: self.parents,
                next_token: self.next_token,
                parent_links: self.parent_links,
            }
        }
    }
}
impl ListObjectParentsOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectParentsOutput`](crate::output::ListObjectParentsOutput)
    pub fn builder() -> crate::output::list_object_parents_output::Builder {
        crate::output::list_object_parents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectParentPathsOutput {
    /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the
    /// directory.</p>
    pub path_to_object_identifiers_list:
        std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListObjectParentPathsOutput {
    /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the
    /// directory.</p>
    pub fn path_to_object_identifiers_list(
        &self,
    ) -> std::option::Option<&[crate::model::PathToObjectIdentifiers]> {
        self.path_to_object_identifiers_list.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListObjectParentPathsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectParentPathsOutput");
        formatter.field(
            "path_to_object_identifiers_list",
            &self.path_to_object_identifiers_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListObjectParentPathsOutput`](crate::output::ListObjectParentPathsOutput)
pub mod list_object_parent_paths_output {
    /// A builder for [`ListObjectParentPathsOutput`](crate::output::ListObjectParentPathsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_to_object_identifiers_list:
            std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `path_to_object_identifiers_list`.
        ///
        /// To override the contents of this collection use [`set_path_to_object_identifiers_list`](Self::set_path_to_object_identifiers_list).
        ///
        /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the
        /// directory.</p>
        pub fn path_to_object_identifiers_list(
            mut self,
            input: impl Into<crate::model::PathToObjectIdentifiers>,
        ) -> Self {
            let mut v = self.path_to_object_identifiers_list.unwrap_or_default();
            v.push(input.into());
            self.path_to_object_identifiers_list = Some(v);
            self
        }
        /// <p>Returns the path to the <code>ObjectIdentifiers</code> that are associated with the
        /// directory.</p>
        pub fn set_path_to_object_identifiers_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathToObjectIdentifiers>>,
        ) -> Self {
            self.path_to_object_identifiers_list = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectParentPathsOutput`](crate::output::ListObjectParentPathsOutput)
        pub fn build(self) -> crate::output::ListObjectParentPathsOutput {
            crate::output::ListObjectParentPathsOutput {
                path_to_object_identifiers_list: self.path_to_object_identifiers_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListObjectParentPathsOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectParentPathsOutput`](crate::output::ListObjectParentPathsOutput)
    pub fn builder() -> crate::output::list_object_parent_paths_output::Builder {
        crate::output::list_object_parent_paths_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectChildrenOutput {
    /// <p>Children structure, which is a map with key as the <code>LinkName</code> and
    /// <code>ObjectIdentifier</code> as the value.</p>
    pub children:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListObjectChildrenOutput {
    /// <p>Children structure, which is a map with key as the <code>LinkName</code> and
    /// <code>ObjectIdentifier</code> as the value.</p>
    pub fn children(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.children.as_ref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListObjectChildrenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectChildrenOutput");
        formatter.field("children", &self.children);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListObjectChildrenOutput`](crate::output::ListObjectChildrenOutput)
pub mod list_object_children_output {
    /// A builder for [`ListObjectChildrenOutput`](crate::output::ListObjectChildrenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) children: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>Children structure, which is a map with key as the <code>LinkName</code> and
        /// <code>ObjectIdentifier</code> as the value.</p>
        pub fn children(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.children.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.children = Some(hash_map);
            self
        }
        /// <p>Children structure, which is a map with key as the <code>LinkName</code> and
        /// <code>ObjectIdentifier</code> as the value.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.children = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectChildrenOutput`](crate::output::ListObjectChildrenOutput)
        pub fn build(self) -> crate::output::ListObjectChildrenOutput {
            crate::output::ListObjectChildrenOutput {
                children: self.children,
                next_token: self.next_token,
            }
        }
    }
}
impl ListObjectChildrenOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectChildrenOutput`](crate::output::ListObjectChildrenOutput)
    pub fn builder() -> crate::output::list_object_children_output::Builder {
        crate::output::list_object_children_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectAttributesOutput {
    /// <p>Attributes map that is associated with the object. <code>AttributeArn</code> is the
    /// key, and attribute value is the value.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListObjectAttributesOutput {
    /// <p>Attributes map that is associated with the object. <code>AttributeArn</code> is the
    /// key, and attribute value is the value.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListObjectAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListObjectAttributesOutput`](crate::output::ListObjectAttributesOutput)
pub mod list_object_attributes_output {
    /// A builder for [`ListObjectAttributesOutput`](crate::output::ListObjectAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Attributes map that is associated with the object. <code>AttributeArn</code> is the
        /// key, and attribute value is the value.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::AttributeKeyAndValue>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Attributes map that is associated with the object. <code>AttributeArn</code> is the
        /// key, and attribute value is the value.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectAttributesOutput`](crate::output::ListObjectAttributesOutput)
        pub fn build(self) -> crate::output::ListObjectAttributesOutput {
            crate::output::ListObjectAttributesOutput {
                attributes: self.attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListObjectAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectAttributesOutput`](crate::output::ListObjectAttributesOutput)
    pub fn builder() -> crate::output::list_object_attributes_output::Builder {
        crate::output::list_object_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedSchemaArnsOutput {
    /// <p>The ARNs for all AWS managed schemas.</p>
    pub schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListManagedSchemaArnsOutput {
    /// <p>The ARNs for all AWS managed schemas.</p>
    pub fn schema_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.schema_arns.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListManagedSchemaArnsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedSchemaArnsOutput");
        formatter.field("schema_arns", &self.schema_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListManagedSchemaArnsOutput`](crate::output::ListManagedSchemaArnsOutput)
pub mod list_managed_schema_arns_output {
    /// A builder for [`ListManagedSchemaArnsOutput`](crate::output::ListManagedSchemaArnsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_arns`.
        ///
        /// To override the contents of this collection use [`set_schema_arns`](Self::set_schema_arns).
        ///
        /// <p>The ARNs for all AWS managed schemas.</p>
        pub fn schema_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schema_arns.unwrap_or_default();
            v.push(input.into());
            self.schema_arns = Some(v);
            self
        }
        /// <p>The ARNs for all AWS managed schemas.</p>
        pub fn set_schema_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schema_arns = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedSchemaArnsOutput`](crate::output::ListManagedSchemaArnsOutput)
        pub fn build(self) -> crate::output::ListManagedSchemaArnsOutput {
            crate::output::ListManagedSchemaArnsOutput {
                schema_arns: self.schema_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListManagedSchemaArnsOutput {
    /// Creates a new builder-style object to manufacture [`ListManagedSchemaArnsOutput`](crate::output::ListManagedSchemaArnsOutput)
    pub fn builder() -> crate::output::list_managed_schema_arns_output::Builder {
        crate::output::list_managed_schema_arns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIndexOutput {
    /// <p>The objects and indexed values attached to the index.</p>
    pub index_attachments: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIndexOutput {
    /// <p>The objects and indexed values attached to the index.</p>
    pub fn index_attachments(&self) -> std::option::Option<&[crate::model::IndexAttachment]> {
        self.index_attachments.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIndexOutput");
        formatter.field("index_attachments", &self.index_attachments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIndexOutput`](crate::output::ListIndexOutput)
pub mod list_index_output {
    /// A builder for [`ListIndexOutput`](crate::output::ListIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_attachments:
            std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `index_attachments`.
        ///
        /// To override the contents of this collection use [`set_index_attachments`](Self::set_index_attachments).
        ///
        /// <p>The objects and indexed values attached to the index.</p>
        pub fn index_attachments(
            mut self,
            input: impl Into<crate::model::IndexAttachment>,
        ) -> Self {
            let mut v = self.index_attachments.unwrap_or_default();
            v.push(input.into());
            self.index_attachments = Some(v);
            self
        }
        /// <p>The objects and indexed values attached to the index.</p>
        pub fn set_index_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        ) -> Self {
            self.index_attachments = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIndexOutput`](crate::output::ListIndexOutput)
        pub fn build(self) -> crate::output::ListIndexOutput {
            crate::output::ListIndexOutput {
                index_attachments: self.index_attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIndexOutput {
    /// Creates a new builder-style object to manufacture [`ListIndexOutput`](crate::output::ListIndexOutput)
    pub fn builder() -> crate::output::list_index_output::Builder {
        crate::output::list_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIncomingTypedLinksOutput {
    /// <p>Returns one or more typed link specifiers as output.</p>
    pub link_specifiers: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIncomingTypedLinksOutput {
    /// <p>Returns one or more typed link specifiers as output.</p>
    pub fn link_specifiers(&self) -> std::option::Option<&[crate::model::TypedLinkSpecifier]> {
        self.link_specifiers.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIncomingTypedLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIncomingTypedLinksOutput");
        formatter.field("link_specifiers", &self.link_specifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIncomingTypedLinksOutput`](crate::output::ListIncomingTypedLinksOutput)
pub mod list_incoming_typed_links_output {
    /// A builder for [`ListIncomingTypedLinksOutput`](crate::output::ListIncomingTypedLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_specifiers:
            std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `link_specifiers`.
        ///
        /// To override the contents of this collection use [`set_link_specifiers`](Self::set_link_specifiers).
        ///
        /// <p>Returns one or more typed link specifiers as output.</p>
        pub fn link_specifiers(
            mut self,
            input: impl Into<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            let mut v = self.link_specifiers.unwrap_or_default();
            v.push(input.into());
            self.link_specifiers = Some(v);
            self
        }
        /// <p>Returns one or more typed link specifiers as output.</p>
        pub fn set_link_specifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkSpecifier>>,
        ) -> Self {
            self.link_specifiers = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIncomingTypedLinksOutput`](crate::output::ListIncomingTypedLinksOutput)
        pub fn build(self) -> crate::output::ListIncomingTypedLinksOutput {
            crate::output::ListIncomingTypedLinksOutput {
                link_specifiers: self.link_specifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIncomingTypedLinksOutput {
    /// Creates a new builder-style object to manufacture [`ListIncomingTypedLinksOutput`](crate::output::ListIncomingTypedLinksOutput)
    pub fn builder() -> crate::output::list_incoming_typed_links_output::Builder {
        crate::output::list_incoming_typed_links_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFacetNamesOutput {
    /// <p>The names of facets that exist within the schema.</p>
    pub facet_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFacetNamesOutput {
    /// <p>The names of facets that exist within the schema.</p>
    pub fn facet_names(&self) -> std::option::Option<&[std::string::String]> {
        self.facet_names.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFacetNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFacetNamesOutput");
        formatter.field("facet_names", &self.facet_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFacetNamesOutput`](crate::output::ListFacetNamesOutput)
pub mod list_facet_names_output {
    /// A builder for [`ListFacetNamesOutput`](crate::output::ListFacetNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) facet_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `facet_names`.
        ///
        /// To override the contents of this collection use [`set_facet_names`](Self::set_facet_names).
        ///
        /// <p>The names of facets that exist within the schema.</p>
        pub fn facet_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.facet_names.unwrap_or_default();
            v.push(input.into());
            self.facet_names = Some(v);
            self
        }
        /// <p>The names of facets that exist within the schema.</p>
        pub fn set_facet_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.facet_names = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFacetNamesOutput`](crate::output::ListFacetNamesOutput)
        pub fn build(self) -> crate::output::ListFacetNamesOutput {
            crate::output::ListFacetNamesOutput {
                facet_names: self.facet_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFacetNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListFacetNamesOutput`](crate::output::ListFacetNamesOutput)
    pub fn builder() -> crate::output::list_facet_names_output::Builder {
        crate::output::list_facet_names_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFacetAttributesOutput {
    /// <p>The attributes attached to the facet.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFacetAttributesOutput {
    /// <p>The attributes attached to the facet.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::FacetAttribute]> {
        self.attributes.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFacetAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFacetAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFacetAttributesOutput`](crate::output::ListFacetAttributesOutput)
pub mod list_facet_attributes_output {
    /// A builder for [`ListFacetAttributesOutput`](crate::output::ListFacetAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes attached to the facet.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::FacetAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes attached to the facet.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFacetAttributesOutput`](crate::output::ListFacetAttributesOutput)
        pub fn build(self) -> crate::output::ListFacetAttributesOutput {
            crate::output::ListFacetAttributesOutput {
                attributes: self.attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFacetAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ListFacetAttributesOutput`](crate::output::ListFacetAttributesOutput)
    pub fn builder() -> crate::output::list_facet_attributes_output::Builder {
        crate::output::list_facet_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDirectoriesOutput {
    /// <p>Lists all directories that are associated with your account in pagination
    /// fashion.</p>
    pub directories: std::option::Option<std::vec::Vec<crate::model::Directory>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDirectoriesOutput {
    /// <p>Lists all directories that are associated with your account in pagination
    /// fashion.</p>
    pub fn directories(&self) -> std::option::Option<&[crate::model::Directory]> {
        self.directories.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDirectoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDirectoriesOutput");
        formatter.field("directories", &self.directories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDirectoriesOutput`](crate::output::ListDirectoriesOutput)
pub mod list_directories_output {
    /// A builder for [`ListDirectoriesOutput`](crate::output::ListDirectoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directories: std::option::Option<std::vec::Vec<crate::model::Directory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `directories`.
        ///
        /// To override the contents of this collection use [`set_directories`](Self::set_directories).
        ///
        /// <p>Lists all directories that are associated with your account in pagination
        /// fashion.</p>
        pub fn directories(mut self, input: impl Into<crate::model::Directory>) -> Self {
            let mut v = self.directories.unwrap_or_default();
            v.push(input.into());
            self.directories = Some(v);
            self
        }
        /// <p>Lists all directories that are associated with your account in pagination
        /// fashion.</p>
        pub fn set_directories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Directory>>,
        ) -> Self {
            self.directories = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDirectoriesOutput`](crate::output::ListDirectoriesOutput)
        pub fn build(self) -> crate::output::ListDirectoriesOutput {
            crate::output::ListDirectoriesOutput {
                directories: self.directories,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDirectoriesOutput {
    /// Creates a new builder-style object to manufacture [`ListDirectoriesOutput`](crate::output::ListDirectoriesOutput)
    pub fn builder() -> crate::output::list_directories_output::Builder {
        crate::output::list_directories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevelopmentSchemaArnsOutput {
    /// <p>The ARNs of retrieved development schemas.</p>
    pub schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevelopmentSchemaArnsOutput {
    /// <p>The ARNs of retrieved development schemas.</p>
    pub fn schema_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.schema_arns.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevelopmentSchemaArnsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevelopmentSchemaArnsOutput");
        formatter.field("schema_arns", &self.schema_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevelopmentSchemaArnsOutput`](crate::output::ListDevelopmentSchemaArnsOutput)
pub mod list_development_schema_arns_output {
    /// A builder for [`ListDevelopmentSchemaArnsOutput`](crate::output::ListDevelopmentSchemaArnsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_arns`.
        ///
        /// To override the contents of this collection use [`set_schema_arns`](Self::set_schema_arns).
        ///
        /// <p>The ARNs of retrieved development schemas.</p>
        pub fn schema_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schema_arns.unwrap_or_default();
            v.push(input.into());
            self.schema_arns = Some(v);
            self
        }
        /// <p>The ARNs of retrieved development schemas.</p>
        pub fn set_schema_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schema_arns = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevelopmentSchemaArnsOutput`](crate::output::ListDevelopmentSchemaArnsOutput)
        pub fn build(self) -> crate::output::ListDevelopmentSchemaArnsOutput {
            crate::output::ListDevelopmentSchemaArnsOutput {
                schema_arns: self.schema_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevelopmentSchemaArnsOutput {
    /// Creates a new builder-style object to manufacture [`ListDevelopmentSchemaArnsOutput`](crate::output::ListDevelopmentSchemaArnsOutput)
    pub fn builder() -> crate::output::list_development_schema_arns_output::Builder {
        crate::output::list_development_schema_arns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedIndicesOutput {
    /// <p>The indices attached to the specified object.</p>
    pub index_attachments: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAttachedIndicesOutput {
    /// <p>The indices attached to the specified object.</p>
    pub fn index_attachments(&self) -> std::option::Option<&[crate::model::IndexAttachment]> {
        self.index_attachments.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAttachedIndicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedIndicesOutput");
        formatter.field("index_attachments", &self.index_attachments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAttachedIndicesOutput`](crate::output::ListAttachedIndicesOutput)
pub mod list_attached_indices_output {
    /// A builder for [`ListAttachedIndicesOutput`](crate::output::ListAttachedIndicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_attachments:
            std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `index_attachments`.
        ///
        /// To override the contents of this collection use [`set_index_attachments`](Self::set_index_attachments).
        ///
        /// <p>The indices attached to the specified object.</p>
        pub fn index_attachments(
            mut self,
            input: impl Into<crate::model::IndexAttachment>,
        ) -> Self {
            let mut v = self.index_attachments.unwrap_or_default();
            v.push(input.into());
            self.index_attachments = Some(v);
            self
        }
        /// <p>The indices attached to the specified object.</p>
        pub fn set_index_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IndexAttachment>>,
        ) -> Self {
            self.index_attachments = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedIndicesOutput`](crate::output::ListAttachedIndicesOutput)
        pub fn build(self) -> crate::output::ListAttachedIndicesOutput {
            crate::output::ListAttachedIndicesOutput {
                index_attachments: self.index_attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAttachedIndicesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachedIndicesOutput`](crate::output::ListAttachedIndicesOutput)
    pub fn builder() -> crate::output::list_attached_indices_output::Builder {
        crate::output::list_attached_indices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppliedSchemaArnsOutput {
    /// <p>The ARNs of schemas that are applied to the directory.</p>
    pub schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppliedSchemaArnsOutput {
    /// <p>The ARNs of schemas that are applied to the directory.</p>
    pub fn schema_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.schema_arns.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppliedSchemaArnsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppliedSchemaArnsOutput");
        formatter.field("schema_arns", &self.schema_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppliedSchemaArnsOutput`](crate::output::ListAppliedSchemaArnsOutput)
pub mod list_applied_schema_arns_output {
    /// A builder for [`ListAppliedSchemaArnsOutput`](crate::output::ListAppliedSchemaArnsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_arns`.
        ///
        /// To override the contents of this collection use [`set_schema_arns`](Self::set_schema_arns).
        ///
        /// <p>The ARNs of schemas that are applied to the directory.</p>
        pub fn schema_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schema_arns.unwrap_or_default();
            v.push(input.into());
            self.schema_arns = Some(v);
            self
        }
        /// <p>The ARNs of schemas that are applied to the directory.</p>
        pub fn set_schema_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schema_arns = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppliedSchemaArnsOutput`](crate::output::ListAppliedSchemaArnsOutput)
        pub fn build(self) -> crate::output::ListAppliedSchemaArnsOutput {
            crate::output::ListAppliedSchemaArnsOutput {
                schema_arns: self.schema_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppliedSchemaArnsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppliedSchemaArnsOutput`](crate::output::ListAppliedSchemaArnsOutput)
    pub fn builder() -> crate::output::list_applied_schema_arns_output::Builder {
        crate::output::list_applied_schema_arns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTypedLinkFacetInformationOutput {
    /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
    /// links considers the order that the attributes are defined on the typed link facet. When
    /// providing ranges to typed link selection, any inexact ranges must be specified at the end. Any
    /// attributes that do not have a range specified are presumed to match the entire range. Filters
    /// are interpreted in the order of the attributes on the typed link facet, not the order in which
    /// they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub identity_attribute_order: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetTypedLinkFacetInformationOutput {
    /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
    /// links considers the order that the attributes are defined on the typed link facet. When
    /// providing ranges to typed link selection, any inexact ranges must be specified at the end. Any
    /// attributes that do not have a range specified are presumed to match the entire range. Filters
    /// are interpreted in the order of the attributes on the typed link facet, not the order in which
    /// they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    pub fn identity_attribute_order(&self) -> std::option::Option<&[std::string::String]> {
        self.identity_attribute_order.as_deref()
    }
}
impl std::fmt::Debug for GetTypedLinkFacetInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTypedLinkFacetInformationOutput");
        formatter.field("identity_attribute_order", &self.identity_attribute_order);
        formatter.finish()
    }
}
/// See [`GetTypedLinkFacetInformationOutput`](crate::output::GetTypedLinkFacetInformationOutput)
pub mod get_typed_link_facet_information_output {
    /// A builder for [`GetTypedLinkFacetInformationOutput`](crate::output::GetTypedLinkFacetInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_attribute_order:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identity_attribute_order`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_order`](Self::set_identity_attribute_order).
        ///
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
        /// links considers the order that the attributes are defined on the typed link facet. When
        /// providing ranges to typed link selection, any inexact ranges must be specified at the end. Any
        /// attributes that do not have a range specified are presumed to match the entire range. Filters
        /// are interpreted in the order of the attributes on the typed link facet, not the order in which
        /// they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn identity_attribute_order(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_attribute_order.unwrap_or_default();
            v.push(input.into());
            self.identity_attribute_order = Some(v);
            self
        }
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
        /// links considers the order that the attributes are defined on the typed link facet. When
        /// providing ranges to typed link selection, any inexact ranges must be specified at the end. Any
        /// attributes that do not have a range specified are presumed to match the entire range. Filters
        /// are interpreted in the order of the attributes on the typed link facet, not the order in which
        /// they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_identity_attribute_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_attribute_order = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTypedLinkFacetInformationOutput`](crate::output::GetTypedLinkFacetInformationOutput)
        pub fn build(self) -> crate::output::GetTypedLinkFacetInformationOutput {
            crate::output::GetTypedLinkFacetInformationOutput {
                identity_attribute_order: self.identity_attribute_order,
            }
        }
    }
}
impl GetTypedLinkFacetInformationOutput {
    /// Creates a new builder-style object to manufacture [`GetTypedLinkFacetInformationOutput`](crate::output::GetTypedLinkFacetInformationOutput)
    pub fn builder() -> crate::output::get_typed_link_facet_information_output::Builder {
        crate::output::get_typed_link_facet_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaAsJsonOutput {
    /// <p>The name of the retrieved schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The JSON representation of the schema document.</p>
    pub document: std::option::Option<std::string::String>,
}
impl GetSchemaAsJsonOutput {
    /// <p>The name of the retrieved schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The JSON representation of the schema document.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for GetSchemaAsJsonOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaAsJsonOutput");
        formatter.field("name", &self.name);
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`GetSchemaAsJsonOutput`](crate::output::GetSchemaAsJsonOutput)
pub mod get_schema_as_json_output {
    /// A builder for [`GetSchemaAsJsonOutput`](crate::output::GetSchemaAsJsonOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the retrieved schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the retrieved schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The JSON representation of the schema document.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The JSON representation of the schema document.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaAsJsonOutput`](crate::output::GetSchemaAsJsonOutput)
        pub fn build(self) -> crate::output::GetSchemaAsJsonOutput {
            crate::output::GetSchemaAsJsonOutput {
                name: self.name,
                document: self.document,
            }
        }
    }
}
impl GetSchemaAsJsonOutput {
    /// Creates a new builder-style object to manufacture [`GetSchemaAsJsonOutput`](crate::output::GetSchemaAsJsonOutput)
    pub fn builder() -> crate::output::get_schema_as_json_output::Builder {
        crate::output::get_schema_as_json_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectInformationOutput {
    /// <p>The facets attached to the specified object. Although the response does not include minor version information, the most recently applied minor version of each Facet is in effect. See <a>GetAppliedSchemaVersion</a> for details.</p>
    pub schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
    /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl GetObjectInformationOutput {
    /// <p>The facets attached to the specified object. Although the response does not include minor version information, the most recently applied minor version of each Facet is in effect. See <a>GetAppliedSchemaVersion</a> for details.</p>
    pub fn schema_facets(&self) -> std::option::Option<&[crate::model::SchemaFacet]> {
        self.schema_facets.as_deref()
    }
    /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for GetObjectInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectInformationOutput");
        formatter.field("schema_facets", &self.schema_facets);
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`GetObjectInformationOutput`](crate::output::GetObjectInformationOutput)
pub mod get_object_information_output {
    /// A builder for [`GetObjectInformationOutput`](crate::output::GetObjectInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_facets: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_facets`.
        ///
        /// To override the contents of this collection use [`set_schema_facets`](Self::set_schema_facets).
        ///
        /// <p>The facets attached to the specified object. Although the response does not include minor version information, the most recently applied minor version of each Facet is in effect. See <a>GetAppliedSchemaVersion</a> for details.</p>
        pub fn schema_facets(mut self, input: impl Into<crate::model::SchemaFacet>) -> Self {
            let mut v = self.schema_facets.unwrap_or_default();
            v.push(input.into());
            self.schema_facets = Some(v);
            self
        }
        /// <p>The facets attached to the specified object. Although the response does not include minor version information, the most recently applied minor version of each Facet is in effect. See <a>GetAppliedSchemaVersion</a> for details.</p>
        pub fn set_schema_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.schema_facets = input;
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the specified object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectInformationOutput`](crate::output::GetObjectInformationOutput)
        pub fn build(self) -> crate::output::GetObjectInformationOutput {
            crate::output::GetObjectInformationOutput {
                schema_facets: self.schema_facets,
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl GetObjectInformationOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectInformationOutput`](crate::output::GetObjectInformationOutput)
    pub fn builder() -> crate::output::get_object_information_output::Builder {
        crate::output::get_object_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectAttributesOutput {
    /// <p>The attributes that are associated with the object.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
}
impl GetObjectAttributesOutput {
    /// <p>The attributes that are associated with the object.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for GetObjectAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`GetObjectAttributesOutput`](crate::output::GetObjectAttributesOutput)
pub mod get_object_attributes_output {
    /// A builder for [`GetObjectAttributesOutput`](crate::output::GetObjectAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the object.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::AttributeKeyAndValue>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes that are associated with the object.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectAttributesOutput`](crate::output::GetObjectAttributesOutput)
        pub fn build(self) -> crate::output::GetObjectAttributesOutput {
            crate::output::GetObjectAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl GetObjectAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectAttributesOutput`](crate::output::GetObjectAttributesOutput)
    pub fn builder() -> crate::output::get_object_attributes_output::Builder {
        crate::output::get_object_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLinkAttributesOutput {
    /// <p>The attributes that are associated with the typed link.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
}
impl GetLinkAttributesOutput {
    /// <p>The attributes that are associated with the typed link.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeKeyAndValue]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for GetLinkAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLinkAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`GetLinkAttributesOutput`](crate::output::GetLinkAttributesOutput)
pub mod get_link_attributes_output {
    /// A builder for [`GetLinkAttributesOutput`](crate::output::GetLinkAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::AttributeKeyAndValue>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLinkAttributesOutput`](crate::output::GetLinkAttributesOutput)
        pub fn build(self) -> crate::output::GetLinkAttributesOutput {
            crate::output::GetLinkAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl GetLinkAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetLinkAttributesOutput`](crate::output::GetLinkAttributesOutput)
    pub fn builder() -> crate::output::get_link_attributes_output::Builder {
        crate::output::get_link_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFacetOutput {
    /// <p>The <a>Facet</a> structure that is associated with the facet.</p>
    pub facet: std::option::Option<crate::model::Facet>,
}
impl GetFacetOutput {
    /// <p>The <a>Facet</a> structure that is associated with the facet.</p>
    pub fn facet(&self) -> std::option::Option<&crate::model::Facet> {
        self.facet.as_ref()
    }
}
impl std::fmt::Debug for GetFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFacetOutput");
        formatter.field("facet", &self.facet);
        formatter.finish()
    }
}
/// See [`GetFacetOutput`](crate::output::GetFacetOutput)
pub mod get_facet_output {
    /// A builder for [`GetFacetOutput`](crate::output::GetFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) facet: std::option::Option<crate::model::Facet>,
    }
    impl Builder {
        /// <p>The <a>Facet</a> structure that is associated with the facet.</p>
        pub fn facet(mut self, input: crate::model::Facet) -> Self {
            self.facet = Some(input);
            self
        }
        /// <p>The <a>Facet</a> structure that is associated with the facet.</p>
        pub fn set_facet(mut self, input: std::option::Option<crate::model::Facet>) -> Self {
            self.facet = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFacetOutput`](crate::output::GetFacetOutput)
        pub fn build(self) -> crate::output::GetFacetOutput {
            crate::output::GetFacetOutput { facet: self.facet }
        }
    }
}
impl GetFacetOutput {
    /// Creates a new builder-style object to manufacture [`GetFacetOutput`](crate::output::GetFacetOutput)
    pub fn builder() -> crate::output::get_facet_output::Builder {
        crate::output::get_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDirectoryOutput {
    /// <p>Metadata about the directory.</p>
    pub directory: std::option::Option<crate::model::Directory>,
}
impl GetDirectoryOutput {
    /// <p>Metadata about the directory.</p>
    pub fn directory(&self) -> std::option::Option<&crate::model::Directory> {
        self.directory.as_ref()
    }
}
impl std::fmt::Debug for GetDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDirectoryOutput");
        formatter.field("directory", &self.directory);
        formatter.finish()
    }
}
/// See [`GetDirectoryOutput`](crate::output::GetDirectoryOutput)
pub mod get_directory_output {
    /// A builder for [`GetDirectoryOutput`](crate::output::GetDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory: std::option::Option<crate::model::Directory>,
    }
    impl Builder {
        /// <p>Metadata about the directory.</p>
        pub fn directory(mut self, input: crate::model::Directory) -> Self {
            self.directory = Some(input);
            self
        }
        /// <p>Metadata about the directory.</p>
        pub fn set_directory(
            mut self,
            input: std::option::Option<crate::model::Directory>,
        ) -> Self {
            self.directory = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDirectoryOutput`](crate::output::GetDirectoryOutput)
        pub fn build(self) -> crate::output::GetDirectoryOutput {
            crate::output::GetDirectoryOutput {
                directory: self.directory,
            }
        }
    }
}
impl GetDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`GetDirectoryOutput`](crate::output::GetDirectoryOutput)
    pub fn builder() -> crate::output::get_directory_output::Builder {
        crate::output::get_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppliedSchemaVersionOutput {
    /// <p>Current applied schema ARN, including the minor version in use if one was provided.</p>
    pub applied_schema_arn: std::option::Option<std::string::String>,
}
impl GetAppliedSchemaVersionOutput {
    /// <p>Current applied schema ARN, including the minor version in use if one was provided.</p>
    pub fn applied_schema_arn(&self) -> std::option::Option<&str> {
        self.applied_schema_arn.as_deref()
    }
}
impl std::fmt::Debug for GetAppliedSchemaVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppliedSchemaVersionOutput");
        formatter.field("applied_schema_arn", &self.applied_schema_arn);
        formatter.finish()
    }
}
/// See [`GetAppliedSchemaVersionOutput`](crate::output::GetAppliedSchemaVersionOutput)
pub mod get_applied_schema_version_output {
    /// A builder for [`GetAppliedSchemaVersionOutput`](crate::output::GetAppliedSchemaVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applied_schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Current applied schema ARN, including the minor version in use if one was provided.</p>
        pub fn applied_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.applied_schema_arn = Some(input.into());
            self
        }
        /// <p>Current applied schema ARN, including the minor version in use if one was provided.</p>
        pub fn set_applied_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.applied_schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppliedSchemaVersionOutput`](crate::output::GetAppliedSchemaVersionOutput)
        pub fn build(self) -> crate::output::GetAppliedSchemaVersionOutput {
            crate::output::GetAppliedSchemaVersionOutput {
                applied_schema_arn: self.applied_schema_arn,
            }
        }
    }
}
impl GetAppliedSchemaVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetAppliedSchemaVersionOutput`](crate::output::GetAppliedSchemaVersionOutput)
    pub fn builder() -> crate::output::get_applied_schema_version_output::Builder {
        crate::output::get_applied_schema_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDirectoryOutput {
    /// <p>The ARN of the enabled directory.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl EnableDirectoryOutput {
    /// <p>The ARN of the enabled directory.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for EnableDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDirectoryOutput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}
/// See [`EnableDirectoryOutput`](crate::output::EnableDirectoryOutput)
pub mod enable_directory_output {
    /// A builder for [`EnableDirectoryOutput`](crate::output::EnableDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the enabled directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the enabled directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDirectoryOutput`](crate::output::EnableDirectoryOutput)
        pub fn build(self) -> crate::output::EnableDirectoryOutput {
            crate::output::EnableDirectoryOutput {
                directory_arn: self.directory_arn,
            }
        }
    }
}
impl EnableDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`EnableDirectoryOutput`](crate::output::EnableDirectoryOutput)
    pub fn builder() -> crate::output::enable_directory_output::Builder {
        crate::output::enable_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDirectoryOutput {
    /// <p>The ARN of the directory that has been disabled.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl DisableDirectoryOutput {
    /// <p>The ARN of the directory that has been disabled.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDirectoryOutput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}
/// See [`DisableDirectoryOutput`](crate::output::DisableDirectoryOutput)
pub mod disable_directory_output {
    /// A builder for [`DisableDirectoryOutput`](crate::output::DisableDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the directory that has been disabled.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the directory that has been disabled.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDirectoryOutput`](crate::output::DisableDirectoryOutput)
        pub fn build(self) -> crate::output::DisableDirectoryOutput {
            crate::output::DisableDirectoryOutput {
                directory_arn: self.directory_arn,
            }
        }
    }
}
impl DisableDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`DisableDirectoryOutput`](crate::output::DisableDirectoryOutput)
    pub fn builder() -> crate::output::disable_directory_output::Builder {
        crate::output::disable_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachTypedLinkOutput {}
impl std::fmt::Debug for DetachTypedLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachTypedLinkOutput");
        formatter.finish()
    }
}
/// See [`DetachTypedLinkOutput`](crate::output::DetachTypedLinkOutput)
pub mod detach_typed_link_output {
    /// A builder for [`DetachTypedLinkOutput`](crate::output::DetachTypedLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachTypedLinkOutput`](crate::output::DetachTypedLinkOutput)
        pub fn build(self) -> crate::output::DetachTypedLinkOutput {
            crate::output::DetachTypedLinkOutput {}
        }
    }
}
impl DetachTypedLinkOutput {
    /// Creates a new builder-style object to manufacture [`DetachTypedLinkOutput`](crate::output::DetachTypedLinkOutput)
    pub fn builder() -> crate::output::detach_typed_link_output::Builder {
        crate::output::detach_typed_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPolicyOutput {}
impl std::fmt::Debug for DetachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
pub mod detach_policy_output {
    /// A builder for [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
        pub fn build(self) -> crate::output::DetachPolicyOutput {
            crate::output::DetachPolicyOutput {}
        }
    }
}
impl DetachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    pub fn builder() -> crate::output::detach_policy_output::Builder {
        crate::output::detach_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachObjectOutput {
    /// <p>The <code>ObjectIdentifier</code> that was detached from the object.</p>
    pub detached_object_identifier: std::option::Option<std::string::String>,
}
impl DetachObjectOutput {
    /// <p>The <code>ObjectIdentifier</code> that was detached from the object.</p>
    pub fn detached_object_identifier(&self) -> std::option::Option<&str> {
        self.detached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for DetachObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachObjectOutput");
        formatter.field(
            "detached_object_identifier",
            &self.detached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`DetachObjectOutput`](crate::output::DetachObjectOutput)
pub mod detach_object_output {
    /// A builder for [`DetachObjectOutput`](crate::output::DetachObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> that was detached from the object.</p>
        pub fn detached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.detached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> that was detached from the object.</p>
        pub fn set_detached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachObjectOutput`](crate::output::DetachObjectOutput)
        pub fn build(self) -> crate::output::DetachObjectOutput {
            crate::output::DetachObjectOutput {
                detached_object_identifier: self.detached_object_identifier,
            }
        }
    }
}
impl DetachObjectOutput {
    /// Creates a new builder-style object to manufacture [`DetachObjectOutput`](crate::output::DetachObjectOutput)
    pub fn builder() -> crate::output::detach_object_output::Builder {
        crate::output::detach_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachFromIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
    pub detached_object_identifier: std::option::Option<std::string::String>,
}
impl DetachFromIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
    pub fn detached_object_identifier(&self) -> std::option::Option<&str> {
        self.detached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for DetachFromIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachFromIndexOutput");
        formatter.field(
            "detached_object_identifier",
            &self.detached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`DetachFromIndexOutput`](crate::output::DetachFromIndexOutput)
pub mod detach_from_index_output {
    /// A builder for [`DetachFromIndexOutput`](crate::output::DetachFromIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
        pub fn detached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.detached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the object that was detached from the index.</p>
        pub fn set_detached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachFromIndexOutput`](crate::output::DetachFromIndexOutput)
        pub fn build(self) -> crate::output::DetachFromIndexOutput {
            crate::output::DetachFromIndexOutput {
                detached_object_identifier: self.detached_object_identifier,
            }
        }
    }
}
impl DetachFromIndexOutput {
    /// Creates a new builder-style object to manufacture [`DetachFromIndexOutput`](crate::output::DetachFromIndexOutput)
    pub fn builder() -> crate::output::detach_from_index_output::Builder {
        crate::output::detach_from_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTypedLinkFacetOutput {}
impl std::fmt::Debug for DeleteTypedLinkFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTypedLinkFacetOutput");
        formatter.finish()
    }
}
/// See [`DeleteTypedLinkFacetOutput`](crate::output::DeleteTypedLinkFacetOutput)
pub mod delete_typed_link_facet_output {
    /// A builder for [`DeleteTypedLinkFacetOutput`](crate::output::DeleteTypedLinkFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTypedLinkFacetOutput`](crate::output::DeleteTypedLinkFacetOutput)
        pub fn build(self) -> crate::output::DeleteTypedLinkFacetOutput {
            crate::output::DeleteTypedLinkFacetOutput {}
        }
    }
}
impl DeleteTypedLinkFacetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTypedLinkFacetOutput`](crate::output::DeleteTypedLinkFacetOutput)
    pub fn builder() -> crate::output::delete_typed_link_facet_output::Builder {
        crate::output::delete_typed_link_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaOutput {
    /// <p>The input ARN that is returned as part of the response. For more information, see
    /// <a>arns</a>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl DeleteSchemaOutput {
    /// <p>The input ARN that is returned as part of the response. For more information, see
    /// <a>arns</a>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}
/// See [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
pub mod delete_schema_output {
    /// A builder for [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input ARN that is returned as part of the response. For more information, see
        /// <a>arns</a>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The input ARN that is returned as part of the response. For more information, see
        /// <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
        pub fn build(self) -> crate::output::DeleteSchemaOutput {
            crate::output::DeleteSchemaOutput {
                schema_arn: self.schema_arn,
            }
        }
    }
}
impl DeleteSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    pub fn builder() -> crate::output::delete_schema_output::Builder {
        crate::output::delete_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectOutput {}
impl std::fmt::Debug for DeleteObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
pub mod delete_object_output {
    /// A builder for [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
        pub fn build(self) -> crate::output::DeleteObjectOutput {
            crate::output::DeleteObjectOutput {}
        }
    }
}
impl DeleteObjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
    pub fn builder() -> crate::output::delete_object_output::Builder {
        crate::output::delete_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFacetOutput {}
impl std::fmt::Debug for DeleteFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFacetOutput");
        formatter.finish()
    }
}
/// See [`DeleteFacetOutput`](crate::output::DeleteFacetOutput)
pub mod delete_facet_output {
    /// A builder for [`DeleteFacetOutput`](crate::output::DeleteFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFacetOutput`](crate::output::DeleteFacetOutput)
        pub fn build(self) -> crate::output::DeleteFacetOutput {
            crate::output::DeleteFacetOutput {}
        }
    }
}
impl DeleteFacetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFacetOutput`](crate::output::DeleteFacetOutput)
    pub fn builder() -> crate::output::delete_facet_output::Builder {
        crate::output::delete_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryOutput {
    /// <p>The ARN of the deleted directory.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl DeleteDirectoryOutput {
    /// <p>The ARN of the deleted directory.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryOutput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}
/// See [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
pub mod delete_directory_output {
    /// A builder for [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the deleted directory.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the deleted directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
        pub fn build(self) -> crate::output::DeleteDirectoryOutput {
            crate::output::DeleteDirectoryOutput {
                directory_arn: self.directory_arn,
            }
        }
    }
}
impl DeleteDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
    pub fn builder() -> crate::output::delete_directory_output::Builder {
        crate::output::delete_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTypedLinkFacetOutput {}
impl std::fmt::Debug for CreateTypedLinkFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTypedLinkFacetOutput");
        formatter.finish()
    }
}
/// See [`CreateTypedLinkFacetOutput`](crate::output::CreateTypedLinkFacetOutput)
pub mod create_typed_link_facet_output {
    /// A builder for [`CreateTypedLinkFacetOutput`](crate::output::CreateTypedLinkFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTypedLinkFacetOutput`](crate::output::CreateTypedLinkFacetOutput)
        pub fn build(self) -> crate::output::CreateTypedLinkFacetOutput {
            crate::output::CreateTypedLinkFacetOutput {}
        }
    }
}
impl CreateTypedLinkFacetOutput {
    /// Creates a new builder-style object to manufacture [`CreateTypedLinkFacetOutput`](crate::output::CreateTypedLinkFacetOutput)
    pub fn builder() -> crate::output::create_typed_link_facet_output::Builder {
        crate::output::create_typed_link_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
    /// information, see <a>arns</a>.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl CreateSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
    /// information, see <a>arns</a>.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}
/// See [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
pub mod create_schema_output {
    /// A builder for [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
        pub fn build(self) -> crate::output::CreateSchemaOutput {
            crate::output::CreateSchemaOutput {
                schema_arn: self.schema_arn,
            }
        }
    }
}
impl CreateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    pub fn builder() -> crate::output::create_schema_output::Builder {
        crate::output::create_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateObjectOutput {
    /// <p>The identifier that is associated with the object.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl CreateObjectOutput {
    /// <p>The identifier that is associated with the object.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for CreateObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateObjectOutput");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`CreateObjectOutput`](crate::output::CreateObjectOutput)
pub mod create_object_output {
    /// A builder for [`CreateObjectOutput`](crate::output::CreateObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that is associated with the object.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The identifier that is associated with the object.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateObjectOutput`](crate::output::CreateObjectOutput)
        pub fn build(self) -> crate::output::CreateObjectOutput {
            crate::output::CreateObjectOutput {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl CreateObjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateObjectOutput`](crate::output::CreateObjectOutput)
    pub fn builder() -> crate::output::create_object_output::Builder {
        crate::output::create_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
    pub object_identifier: std::option::Option<std::string::String>,
}
impl CreateIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
}
impl std::fmt::Debug for CreateIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIndexOutput");
        formatter.field("object_identifier", &self.object_identifier);
        formatter.finish()
    }
}
/// See [`CreateIndexOutput`](crate::output::CreateIndexOutput)
pub mod create_index_output {
    /// A builder for [`CreateIndexOutput`](crate::output::CreateIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the index created by this operation.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIndexOutput`](crate::output::CreateIndexOutput)
        pub fn build(self) -> crate::output::CreateIndexOutput {
            crate::output::CreateIndexOutput {
                object_identifier: self.object_identifier,
            }
        }
    }
}
impl CreateIndexOutput {
    /// Creates a new builder-style object to manufacture [`CreateIndexOutput`](crate::output::CreateIndexOutput)
    pub fn builder() -> crate::output::create_index_output::Builder {
        crate::output::create_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFacetOutput {}
impl std::fmt::Debug for CreateFacetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFacetOutput");
        formatter.finish()
    }
}
/// See [`CreateFacetOutput`](crate::output::CreateFacetOutput)
pub mod create_facet_output {
    /// A builder for [`CreateFacetOutput`](crate::output::CreateFacetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateFacetOutput`](crate::output::CreateFacetOutput)
        pub fn build(self) -> crate::output::CreateFacetOutput {
            crate::output::CreateFacetOutput {}
        }
    }
}
impl CreateFacetOutput {
    /// Creates a new builder-style object to manufacture [`CreateFacetOutput`](crate::output::CreateFacetOutput)
    pub fn builder() -> crate::output::create_facet_output::Builder {
        crate::output::create_facet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryOutput {
    /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
    /// see <a>arns</a>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <a>Directory</a>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The root object node of the created directory.</p>
    pub object_identifier: std::option::Option<std::string::String>,
    /// <p>The ARN of the published schema in the <a>Directory</a>. Once a published
    /// schema is copied into the directory, it has its own ARN, which is referred to applied schema
    /// ARN. For more information, see <a>arns</a>.</p>
    pub applied_schema_arn: std::option::Option<std::string::String>,
}
impl CreateDirectoryOutput {
    /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
    /// see <a>arns</a>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
    /// <p>The name of the <a>Directory</a>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The root object node of the created directory.</p>
    pub fn object_identifier(&self) -> std::option::Option<&str> {
        self.object_identifier.as_deref()
    }
    /// <p>The ARN of the published schema in the <a>Directory</a>. Once a published
    /// schema is copied into the directory, it has its own ARN, which is referred to applied schema
    /// ARN. For more information, see <a>arns</a>.</p>
    pub fn applied_schema_arn(&self) -> std::option::Option<&str> {
        self.applied_schema_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryOutput");
        formatter.field("directory_arn", &self.directory_arn);
        formatter.field("name", &self.name);
        formatter.field("object_identifier", &self.object_identifier);
        formatter.field("applied_schema_arn", &self.applied_schema_arn);
        formatter.finish()
    }
}
/// See [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
pub mod create_directory_output {
    /// A builder for [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) object_identifier: std::option::Option<std::string::String>,
        pub(crate) applied_schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
        /// see <a>arns</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
        /// see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// <p>The name of the <a>Directory</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <a>Directory</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The root object node of the created directory.</p>
        pub fn object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_identifier = Some(input.into());
            self
        }
        /// <p>The root object node of the created directory.</p>
        pub fn set_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_identifier = input;
            self
        }
        /// <p>The ARN of the published schema in the <a>Directory</a>. Once a published
        /// schema is copied into the directory, it has its own ARN, which is referred to applied schema
        /// ARN. For more information, see <a>arns</a>.</p>
        pub fn applied_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.applied_schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the published schema in the <a>Directory</a>. Once a published
        /// schema is copied into the directory, it has its own ARN, which is referred to applied schema
        /// ARN. For more information, see <a>arns</a>.</p>
        pub fn set_applied_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.applied_schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
        pub fn build(self) -> crate::output::CreateDirectoryOutput {
            crate::output::CreateDirectoryOutput {
                directory_arn: self.directory_arn,
                name: self.name,
                object_identifier: self.object_identifier,
                applied_schema_arn: self.applied_schema_arn,
            }
        }
    }
}
impl CreateDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
    pub fn builder() -> crate::output::create_directory_output::Builder {
        crate::output::create_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteOutput {
    /// <p>A list of all the responses for each batch write.</p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperationResponse>>,
}
impl BatchWriteOutput {
    /// <p>A list of all the responses for each batch write.</p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::BatchWriteOperationResponse]> {
        self.responses.as_deref()
    }
}
impl std::fmt::Debug for BatchWriteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteOutput");
        formatter.field("responses", &self.responses);
        formatter.finish()
    }
}
/// See [`BatchWriteOutput`](crate::output::BatchWriteOutput)
pub mod batch_write_output {
    /// A builder for [`BatchWriteOutput`](crate::output::BatchWriteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) responses:
            std::option::Option<std::vec::Vec<crate::model::BatchWriteOperationResponse>>,
    }
    impl Builder {
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>A list of all the responses for each batch write.</p>
        pub fn responses(
            mut self,
            input: impl Into<crate::model::BatchWriteOperationResponse>,
        ) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>A list of all the responses for each batch write.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperationResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteOutput`](crate::output::BatchWriteOutput)
        pub fn build(self) -> crate::output::BatchWriteOutput {
            crate::output::BatchWriteOutput {
                responses: self.responses,
            }
        }
    }
}
impl BatchWriteOutput {
    /// Creates a new builder-style object to manufacture [`BatchWriteOutput`](crate::output::BatchWriteOutput)
    pub fn builder() -> crate::output::batch_write_output::Builder {
        crate::output::batch_write_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchReadOutput {
    /// <p>A list of all the responses for each batch read.</p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::BatchReadOperationResponse>>,
}
impl BatchReadOutput {
    /// <p>A list of all the responses for each batch read.</p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::BatchReadOperationResponse]> {
        self.responses.as_deref()
    }
}
impl std::fmt::Debug for BatchReadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchReadOutput");
        formatter.field("responses", &self.responses);
        formatter.finish()
    }
}
/// See [`BatchReadOutput`](crate::output::BatchReadOutput)
pub mod batch_read_output {
    /// A builder for [`BatchReadOutput`](crate::output::BatchReadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) responses:
            std::option::Option<std::vec::Vec<crate::model::BatchReadOperationResponse>>,
    }
    impl Builder {
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>A list of all the responses for each batch read.</p>
        pub fn responses(
            mut self,
            input: impl Into<crate::model::BatchReadOperationResponse>,
        ) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>A list of all the responses for each batch read.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchReadOperationResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchReadOutput`](crate::output::BatchReadOutput)
        pub fn build(self) -> crate::output::BatchReadOutput {
            crate::output::BatchReadOutput {
                responses: self.responses,
            }
        }
    }
}
impl BatchReadOutput {
    /// Creates a new builder-style object to manufacture [`BatchReadOutput`](crate::output::BatchReadOutput)
    pub fn builder() -> crate::output::batch_read_output::Builder {
        crate::output::batch_read_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachTypedLinkOutput {
    /// <p>Returns a typed link specifier as output.</p>
    pub typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
}
impl AttachTypedLinkOutput {
    /// <p>Returns a typed link specifier as output.</p>
    pub fn typed_link_specifier(&self) -> std::option::Option<&crate::model::TypedLinkSpecifier> {
        self.typed_link_specifier.as_ref()
    }
}
impl std::fmt::Debug for AttachTypedLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachTypedLinkOutput");
        formatter.field("typed_link_specifier", &self.typed_link_specifier);
        formatter.finish()
    }
}
/// See [`AttachTypedLinkOutput`](crate::output::AttachTypedLinkOutput)
pub mod attach_typed_link_output {
    /// A builder for [`AttachTypedLinkOutput`](crate::output::AttachTypedLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) typed_link_specifier: std::option::Option<crate::model::TypedLinkSpecifier>,
    }
    impl Builder {
        /// <p>Returns a typed link specifier as output.</p>
        pub fn typed_link_specifier(mut self, input: crate::model::TypedLinkSpecifier) -> Self {
            self.typed_link_specifier = Some(input);
            self
        }
        /// <p>Returns a typed link specifier as output.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.typed_link_specifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachTypedLinkOutput`](crate::output::AttachTypedLinkOutput)
        pub fn build(self) -> crate::output::AttachTypedLinkOutput {
            crate::output::AttachTypedLinkOutput {
                typed_link_specifier: self.typed_link_specifier,
            }
        }
    }
}
impl AttachTypedLinkOutput {
    /// Creates a new builder-style object to manufacture [`AttachTypedLinkOutput`](crate::output::AttachTypedLinkOutput)
    pub fn builder() -> crate::output::attach_typed_link_output::Builder {
        crate::output::attach_typed_link_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachToIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
    pub attached_object_identifier: std::option::Option<std::string::String>,
}
impl AttachToIndexOutput {
    /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
    pub fn attached_object_identifier(&self) -> std::option::Option<&str> {
        self.attached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for AttachToIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachToIndexOutput");
        formatter.field(
            "attached_object_identifier",
            &self.attached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`AttachToIndexOutput`](crate::output::AttachToIndexOutput)
pub mod attach_to_index_output {
    /// A builder for [`AttachToIndexOutput`](crate::output::AttachToIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
        pub fn attached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_object_identifier = Some(input.into());
            self
        }
        /// <p>The <code>ObjectIdentifier</code> of the object that was attached to the index.</p>
        pub fn set_attached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachToIndexOutput`](crate::output::AttachToIndexOutput)
        pub fn build(self) -> crate::output::AttachToIndexOutput {
            crate::output::AttachToIndexOutput {
                attached_object_identifier: self.attached_object_identifier,
            }
        }
    }
}
impl AttachToIndexOutput {
    /// Creates a new builder-style object to manufacture [`AttachToIndexOutput`](crate::output::AttachToIndexOutput)
    pub fn builder() -> crate::output::attach_to_index_output::Builder {
        crate::output::attach_to_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPolicyOutput {}
impl std::fmt::Debug for AttachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
pub mod attach_policy_output {
    /// A builder for [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
        pub fn build(self) -> crate::output::AttachPolicyOutput {
            crate::output::AttachPolicyOutput {}
        }
    }
}
impl AttachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    pub fn builder() -> crate::output::attach_policy_output::Builder {
        crate::output::attach_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachObjectOutput {
    /// <p>The attached <code>ObjectIdentifier</code>, which is the child
    /// <code>ObjectIdentifier</code>.</p>
    pub attached_object_identifier: std::option::Option<std::string::String>,
}
impl AttachObjectOutput {
    /// <p>The attached <code>ObjectIdentifier</code>, which is the child
    /// <code>ObjectIdentifier</code>.</p>
    pub fn attached_object_identifier(&self) -> std::option::Option<&str> {
        self.attached_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for AttachObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachObjectOutput");
        formatter.field(
            "attached_object_identifier",
            &self.attached_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`AttachObjectOutput`](crate::output::AttachObjectOutput)
pub mod attach_object_output {
    /// A builder for [`AttachObjectOutput`](crate::output::AttachObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attached <code>ObjectIdentifier</code>, which is the child
        /// <code>ObjectIdentifier</code>.</p>
        pub fn attached_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_object_identifier = Some(input.into());
            self
        }
        /// <p>The attached <code>ObjectIdentifier</code>, which is the child
        /// <code>ObjectIdentifier</code>.</p>
        pub fn set_attached_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attached_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachObjectOutput`](crate::output::AttachObjectOutput)
        pub fn build(self) -> crate::output::AttachObjectOutput {
            crate::output::AttachObjectOutput {
                attached_object_identifier: self.attached_object_identifier,
            }
        }
    }
}
impl AttachObjectOutput {
    /// Creates a new builder-style object to manufacture [`AttachObjectOutput`](crate::output::AttachObjectOutput)
    pub fn builder() -> crate::output::attach_object_output::Builder {
        crate::output::attach_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplySchemaOutput {
    /// <p>The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this ARN to describe the schema information applied on
    /// this directory. For more information, see <a>arns</a>.</p>
    pub applied_schema_arn: std::option::Option<std::string::String>,
    /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
    /// see <a>arns</a>.</p>
    pub directory_arn: std::option::Option<std::string::String>,
}
impl ApplySchemaOutput {
    /// <p>The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this ARN to describe the schema information applied on
    /// this directory. For more information, see <a>arns</a>.</p>
    pub fn applied_schema_arn(&self) -> std::option::Option<&str> {
        self.applied_schema_arn.as_deref()
    }
    /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
    /// see <a>arns</a>.</p>
    pub fn directory_arn(&self) -> std::option::Option<&str> {
        self.directory_arn.as_deref()
    }
}
impl std::fmt::Debug for ApplySchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplySchemaOutput");
        formatter.field("applied_schema_arn", &self.applied_schema_arn);
        formatter.field("directory_arn", &self.directory_arn);
        formatter.finish()
    }
}
/// See [`ApplySchemaOutput`](crate::output::ApplySchemaOutput)
pub mod apply_schema_output {
    /// A builder for [`ApplySchemaOutput`](crate::output::ApplySchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applied_schema_arn: std::option::Option<std::string::String>,
        pub(crate) directory_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this ARN to describe the schema information applied on
        /// this directory. For more information, see <a>arns</a>.</p>
        pub fn applied_schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.applied_schema_arn = Some(input.into());
            self
        }
        /// <p>The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this ARN to describe the schema information applied on
        /// this directory. For more information, see <a>arns</a>.</p>
        pub fn set_applied_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.applied_schema_arn = input;
            self
        }
        /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
        /// see <a>arns</a>.</p>
        pub fn directory_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_arn = Some(input.into());
            self
        }
        /// <p>The ARN that is associated with the <a>Directory</a>. For more information,
        /// see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplySchemaOutput`](crate::output::ApplySchemaOutput)
        pub fn build(self) -> crate::output::ApplySchemaOutput {
            crate::output::ApplySchemaOutput {
                applied_schema_arn: self.applied_schema_arn,
                directory_arn: self.directory_arn,
            }
        }
    }
}
impl ApplySchemaOutput {
    /// Creates a new builder-style object to manufacture [`ApplySchemaOutput`](crate::output::ApplySchemaOutput)
    pub fn builder() -> crate::output::apply_schema_output::Builder {
        crate::output::apply_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFacetToObjectOutput {}
impl std::fmt::Debug for AddFacetToObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFacetToObjectOutput");
        formatter.finish()
    }
}
/// See [`AddFacetToObjectOutput`](crate::output::AddFacetToObjectOutput)
pub mod add_facet_to_object_output {
    /// A builder for [`AddFacetToObjectOutput`](crate::output::AddFacetToObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddFacetToObjectOutput`](crate::output::AddFacetToObjectOutput)
        pub fn build(self) -> crate::output::AddFacetToObjectOutput {
            crate::output::AddFacetToObjectOutput {}
        }
    }
}
impl AddFacetToObjectOutput {
    /// Creates a new builder-style object to manufacture [`AddFacetToObjectOutput`](crate::output::AddFacetToObjectOutput)
    pub fn builder() -> crate::output::add_facet_to_object_output::Builder {
        crate::output::add_facet_to_object_output::Builder::default()
    }
}
