// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddFacetToObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_facet_to_object`](crate::client::Client::add_facet_to_object).
///
/// See [`crate::client::fluent_builders::AddFacetToObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddFacetToObject {
    _private: (),
}
impl AddFacetToObject {
    /// Creates a new builder-style object to manufacture [`AddFacetToObjectInput`](crate::input::AddFacetToObjectInput)
    pub fn builder() -> crate::input::add_facet_to_object_input::Builder {
        crate::input::add_facet_to_object_input::Builder::default()
    }
    /// Creates a new `AddFacetToObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddFacetToObject {
    type Output = std::result::Result<
        crate::output::AddFacetToObjectOutput,
        crate::error::AddFacetToObjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_facet_to_object_error(response)
        } else {
            crate::operation_deser::parse_add_facet_to_object_response(response)
        }
    }
}

/// Operation shape for `ApplySchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_schema`](crate::client::Client::apply_schema).
///
/// See [`crate::client::fluent_builders::ApplySchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplySchema {
    _private: (),
}
impl ApplySchema {
    /// Creates a new builder-style object to manufacture [`ApplySchemaInput`](crate::input::ApplySchemaInput)
    pub fn builder() -> crate::input::apply_schema_input::Builder {
        crate::input::apply_schema_input::Builder::default()
    }
    /// Creates a new `ApplySchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplySchema {
    type Output =
        std::result::Result<crate::output::ApplySchemaOutput, crate::error::ApplySchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_schema_error(response)
        } else {
            crate::operation_deser::parse_apply_schema_response(response)
        }
    }
}

/// Operation shape for `AttachObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_object`](crate::client::Client::attach_object).
///
/// See [`crate::client::fluent_builders::AttachObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachObject {
    _private: (),
}
impl AttachObject {
    /// Creates a new builder-style object to manufacture [`AttachObjectInput`](crate::input::AttachObjectInput)
    pub fn builder() -> crate::input::attach_object_input::Builder {
        crate::input::attach_object_input::Builder::default()
    }
    /// Creates a new `AttachObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachObject {
    type Output =
        std::result::Result<crate::output::AttachObjectOutput, crate::error::AttachObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_object_error(response)
        } else {
            crate::operation_deser::parse_attach_object_response(response)
        }
    }
}

/// Operation shape for `AttachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_policy`](crate::client::Client::attach_policy).
///
/// See [`crate::client::fluent_builders::AttachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachPolicy {
    _private: (),
}
impl AttachPolicy {
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
    /// Creates a new `AttachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachPolicy {
    type Output =
        std::result::Result<crate::output::AttachPolicyOutput, crate::error::AttachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_policy_error(response)
        } else {
            crate::operation_deser::parse_attach_policy_response(response)
        }
    }
}

/// Operation shape for `AttachToIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_to_index`](crate::client::Client::attach_to_index).
///
/// See [`crate::client::fluent_builders::AttachToIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachToIndex {
    _private: (),
}
impl AttachToIndex {
    /// Creates a new builder-style object to manufacture [`AttachToIndexInput`](crate::input::AttachToIndexInput)
    pub fn builder() -> crate::input::attach_to_index_input::Builder {
        crate::input::attach_to_index_input::Builder::default()
    }
    /// Creates a new `AttachToIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachToIndex {
    type Output =
        std::result::Result<crate::output::AttachToIndexOutput, crate::error::AttachToIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_to_index_error(response)
        } else {
            crate::operation_deser::parse_attach_to_index_response(response)
        }
    }
}

/// Operation shape for `AttachTypedLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_typed_link`](crate::client::Client::attach_typed_link).
///
/// See [`crate::client::fluent_builders::AttachTypedLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachTypedLink {
    _private: (),
}
impl AttachTypedLink {
    /// Creates a new builder-style object to manufacture [`AttachTypedLinkInput`](crate::input::AttachTypedLinkInput)
    pub fn builder() -> crate::input::attach_typed_link_input::Builder {
        crate::input::attach_typed_link_input::Builder::default()
    }
    /// Creates a new `AttachTypedLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachTypedLink {
    type Output = std::result::Result<
        crate::output::AttachTypedLinkOutput,
        crate::error::AttachTypedLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_typed_link_error(response)
        } else {
            crate::operation_deser::parse_attach_typed_link_response(response)
        }
    }
}

/// Operation shape for `BatchRead`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_read`](crate::client::Client::batch_read).
///
/// See [`crate::client::fluent_builders::BatchRead`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchRead {
    _private: (),
}
impl BatchRead {
    /// Creates a new builder-style object to manufacture [`BatchReadInput`](crate::input::BatchReadInput)
    pub fn builder() -> crate::input::batch_read_input::Builder {
        crate::input::batch_read_input::Builder::default()
    }
    /// Creates a new `BatchRead` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchRead {
    type Output = std::result::Result<crate::output::BatchReadOutput, crate::error::BatchReadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_read_error(response)
        } else {
            crate::operation_deser::parse_batch_read_response(response)
        }
    }
}

/// Operation shape for `BatchWrite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_write`](crate::client::Client::batch_write).
///
/// See [`crate::client::fluent_builders::BatchWrite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchWrite {
    _private: (),
}
impl BatchWrite {
    /// Creates a new builder-style object to manufacture [`BatchWriteInput`](crate::input::BatchWriteInput)
    pub fn builder() -> crate::input::batch_write_input::Builder {
        crate::input::batch_write_input::Builder::default()
    }
    /// Creates a new `BatchWrite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchWrite {
    type Output =
        std::result::Result<crate::output::BatchWriteOutput, crate::error::BatchWriteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_write_error(response)
        } else {
            crate::operation_deser::parse_batch_write_response(response)
        }
    }
}

/// Operation shape for `CreateDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_directory`](crate::client::Client::create_directory).
///
/// See [`crate::client::fluent_builders::CreateDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDirectory {
    _private: (),
}
impl CreateDirectory {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    pub fn builder() -> crate::input::create_directory_input::Builder {
        crate::input::create_directory_input::Builder::default()
    }
    /// Creates a new `CreateDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDirectory {
    type Output = std::result::Result<
        crate::output::CreateDirectoryOutput,
        crate::error::CreateDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_directory_error(response)
        } else {
            crate::operation_deser::parse_create_directory_response(response)
        }
    }
}

/// Operation shape for `CreateFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_facet`](crate::client::Client::create_facet).
///
/// See [`crate::client::fluent_builders::CreateFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFacet {
    _private: (),
}
impl CreateFacet {
    /// Creates a new builder-style object to manufacture [`CreateFacetInput`](crate::input::CreateFacetInput)
    pub fn builder() -> crate::input::create_facet_input::Builder {
        crate::input::create_facet_input::Builder::default()
    }
    /// Creates a new `CreateFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFacet {
    type Output =
        std::result::Result<crate::output::CreateFacetOutput, crate::error::CreateFacetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_facet_error(response)
        } else {
            crate::operation_deser::parse_create_facet_response(response)
        }
    }
}

/// Operation shape for `CreateIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_index`](crate::client::Client::create_index).
///
/// See [`crate::client::fluent_builders::CreateIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIndex {
    _private: (),
}
impl CreateIndex {
    /// Creates a new builder-style object to manufacture [`CreateIndexInput`](crate::input::CreateIndexInput)
    pub fn builder() -> crate::input::create_index_input::Builder {
        crate::input::create_index_input::Builder::default()
    }
    /// Creates a new `CreateIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIndex {
    type Output =
        std::result::Result<crate::output::CreateIndexOutput, crate::error::CreateIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_index_error(response)
        } else {
            crate::operation_deser::parse_create_index_response(response)
        }
    }
}

/// Operation shape for `CreateObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_object`](crate::client::Client::create_object).
///
/// See [`crate::client::fluent_builders::CreateObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateObject {
    _private: (),
}
impl CreateObject {
    /// Creates a new builder-style object to manufacture [`CreateObjectInput`](crate::input::CreateObjectInput)
    pub fn builder() -> crate::input::create_object_input::Builder {
        crate::input::create_object_input::Builder::default()
    }
    /// Creates a new `CreateObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateObject {
    type Output =
        std::result::Result<crate::output::CreateObjectOutput, crate::error::CreateObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_object_error(response)
        } else {
            crate::operation_deser::parse_create_object_response(response)
        }
    }
}

/// Operation shape for `CreateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_schema`](crate::client::Client::create_schema).
///
/// See [`crate::client::fluent_builders::CreateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSchema {
    _private: (),
}
impl CreateSchema {
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
    /// Creates a new `CreateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSchema {
    type Output =
        std::result::Result<crate::output::CreateSchemaOutput, crate::error::CreateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_schema_error(response)
        } else {
            crate::operation_deser::parse_create_schema_response(response)
        }
    }
}

/// Operation shape for `CreateTypedLinkFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_typed_link_facet`](crate::client::Client::create_typed_link_facet).
///
/// See [`crate::client::fluent_builders::CreateTypedLinkFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTypedLinkFacet {
    _private: (),
}
impl CreateTypedLinkFacet {
    /// Creates a new builder-style object to manufacture [`CreateTypedLinkFacetInput`](crate::input::CreateTypedLinkFacetInput)
    pub fn builder() -> crate::input::create_typed_link_facet_input::Builder {
        crate::input::create_typed_link_facet_input::Builder::default()
    }
    /// Creates a new `CreateTypedLinkFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTypedLinkFacet {
    type Output = std::result::Result<
        crate::output::CreateTypedLinkFacetOutput,
        crate::error::CreateTypedLinkFacetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_typed_link_facet_error(response)
        } else {
            crate::operation_deser::parse_create_typed_link_facet_response(response)
        }
    }
}

/// Operation shape for `DeleteDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_directory`](crate::client::Client::delete_directory).
///
/// See [`crate::client::fluent_builders::DeleteDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDirectory {
    _private: (),
}
impl DeleteDirectory {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    pub fn builder() -> crate::input::delete_directory_input::Builder {
        crate::input::delete_directory_input::Builder::default()
    }
    /// Creates a new `DeleteDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDirectory {
    type Output = std::result::Result<
        crate::output::DeleteDirectoryOutput,
        crate::error::DeleteDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_directory_error(response)
        } else {
            crate::operation_deser::parse_delete_directory_response(response)
        }
    }
}

/// Operation shape for `DeleteFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_facet`](crate::client::Client::delete_facet).
///
/// See [`crate::client::fluent_builders::DeleteFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFacet {
    _private: (),
}
impl DeleteFacet {
    /// Creates a new builder-style object to manufacture [`DeleteFacetInput`](crate::input::DeleteFacetInput)
    pub fn builder() -> crate::input::delete_facet_input::Builder {
        crate::input::delete_facet_input::Builder::default()
    }
    /// Creates a new `DeleteFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFacet {
    type Output =
        std::result::Result<crate::output::DeleteFacetOutput, crate::error::DeleteFacetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_facet_error(response)
        } else {
            crate::operation_deser::parse_delete_facet_response(response)
        }
    }
}

/// Operation shape for `DeleteObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_object`](crate::client::Client::delete_object).
///
/// See [`crate::client::fluent_builders::DeleteObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteObject {
    _private: (),
}
impl DeleteObject {
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
    /// Creates a new `DeleteObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteObject {
    type Output =
        std::result::Result<crate::output::DeleteObjectOutput, crate::error::DeleteObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_object_error(response)
        } else {
            crate::operation_deser::parse_delete_object_response(response)
        }
    }
}

/// Operation shape for `DeleteSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema`](crate::client::Client::delete_schema).
///
/// See [`crate::client::fluent_builders::DeleteSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchema {
    _private: (),
}
impl DeleteSchema {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
    /// Creates a new `DeleteSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchema {
    type Output =
        std::result::Result<crate::output::DeleteSchemaOutput, crate::error::DeleteSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schema_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_response(response)
        }
    }
}

/// Operation shape for `DeleteTypedLinkFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_typed_link_facet`](crate::client::Client::delete_typed_link_facet).
///
/// See [`crate::client::fluent_builders::DeleteTypedLinkFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTypedLinkFacet {
    _private: (),
}
impl DeleteTypedLinkFacet {
    /// Creates a new builder-style object to manufacture [`DeleteTypedLinkFacetInput`](crate::input::DeleteTypedLinkFacetInput)
    pub fn builder() -> crate::input::delete_typed_link_facet_input::Builder {
        crate::input::delete_typed_link_facet_input::Builder::default()
    }
    /// Creates a new `DeleteTypedLinkFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTypedLinkFacet {
    type Output = std::result::Result<
        crate::output::DeleteTypedLinkFacetOutput,
        crate::error::DeleteTypedLinkFacetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_typed_link_facet_error(response)
        } else {
            crate::operation_deser::parse_delete_typed_link_facet_response(response)
        }
    }
}

/// Operation shape for `DetachFromIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_from_index`](crate::client::Client::detach_from_index).
///
/// See [`crate::client::fluent_builders::DetachFromIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachFromIndex {
    _private: (),
}
impl DetachFromIndex {
    /// Creates a new builder-style object to manufacture [`DetachFromIndexInput`](crate::input::DetachFromIndexInput)
    pub fn builder() -> crate::input::detach_from_index_input::Builder {
        crate::input::detach_from_index_input::Builder::default()
    }
    /// Creates a new `DetachFromIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachFromIndex {
    type Output = std::result::Result<
        crate::output::DetachFromIndexOutput,
        crate::error::DetachFromIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_from_index_error(response)
        } else {
            crate::operation_deser::parse_detach_from_index_response(response)
        }
    }
}

/// Operation shape for `DetachObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_object`](crate::client::Client::detach_object).
///
/// See [`crate::client::fluent_builders::DetachObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachObject {
    _private: (),
}
impl DetachObject {
    /// Creates a new builder-style object to manufacture [`DetachObjectInput`](crate::input::DetachObjectInput)
    pub fn builder() -> crate::input::detach_object_input::Builder {
        crate::input::detach_object_input::Builder::default()
    }
    /// Creates a new `DetachObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachObject {
    type Output =
        std::result::Result<crate::output::DetachObjectOutput, crate::error::DetachObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_object_error(response)
        } else {
            crate::operation_deser::parse_detach_object_response(response)
        }
    }
}

/// Operation shape for `DetachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_policy`](crate::client::Client::detach_policy).
///
/// See [`crate::client::fluent_builders::DetachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachPolicy {
    _private: (),
}
impl DetachPolicy {
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
    /// Creates a new `DetachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachPolicy {
    type Output =
        std::result::Result<crate::output::DetachPolicyOutput, crate::error::DetachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_policy_error(response)
        } else {
            crate::operation_deser::parse_detach_policy_response(response)
        }
    }
}

/// Operation shape for `DetachTypedLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_typed_link`](crate::client::Client::detach_typed_link).
///
/// See [`crate::client::fluent_builders::DetachTypedLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachTypedLink {
    _private: (),
}
impl DetachTypedLink {
    /// Creates a new builder-style object to manufacture [`DetachTypedLinkInput`](crate::input::DetachTypedLinkInput)
    pub fn builder() -> crate::input::detach_typed_link_input::Builder {
        crate::input::detach_typed_link_input::Builder::default()
    }
    /// Creates a new `DetachTypedLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachTypedLink {
    type Output = std::result::Result<
        crate::output::DetachTypedLinkOutput,
        crate::error::DetachTypedLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_typed_link_error(response)
        } else {
            crate::operation_deser::parse_detach_typed_link_response(response)
        }
    }
}

/// Operation shape for `DisableDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_directory`](crate::client::Client::disable_directory).
///
/// See [`crate::client::fluent_builders::DisableDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableDirectory {
    _private: (),
}
impl DisableDirectory {
    /// Creates a new builder-style object to manufacture [`DisableDirectoryInput`](crate::input::DisableDirectoryInput)
    pub fn builder() -> crate::input::disable_directory_input::Builder {
        crate::input::disable_directory_input::Builder::default()
    }
    /// Creates a new `DisableDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableDirectory {
    type Output = std::result::Result<
        crate::output::DisableDirectoryOutput,
        crate::error::DisableDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_directory_error(response)
        } else {
            crate::operation_deser::parse_disable_directory_response(response)
        }
    }
}

/// Operation shape for `EnableDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_directory`](crate::client::Client::enable_directory).
///
/// See [`crate::client::fluent_builders::EnableDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableDirectory {
    _private: (),
}
impl EnableDirectory {
    /// Creates a new builder-style object to manufacture [`EnableDirectoryInput`](crate::input::EnableDirectoryInput)
    pub fn builder() -> crate::input::enable_directory_input::Builder {
        crate::input::enable_directory_input::Builder::default()
    }
    /// Creates a new `EnableDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableDirectory {
    type Output = std::result::Result<
        crate::output::EnableDirectoryOutput,
        crate::error::EnableDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_directory_error(response)
        } else {
            crate::operation_deser::parse_enable_directory_response(response)
        }
    }
}

/// Operation shape for `GetAppliedSchemaVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_applied_schema_version`](crate::client::Client::get_applied_schema_version).
///
/// See [`crate::client::fluent_builders::GetAppliedSchemaVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppliedSchemaVersion {
    _private: (),
}
impl GetAppliedSchemaVersion {
    /// Creates a new builder-style object to manufacture [`GetAppliedSchemaVersionInput`](crate::input::GetAppliedSchemaVersionInput)
    pub fn builder() -> crate::input::get_applied_schema_version_input::Builder {
        crate::input::get_applied_schema_version_input::Builder::default()
    }
    /// Creates a new `GetAppliedSchemaVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppliedSchemaVersion {
    type Output = std::result::Result<
        crate::output::GetAppliedSchemaVersionOutput,
        crate::error::GetAppliedSchemaVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_applied_schema_version_error(response)
        } else {
            crate::operation_deser::parse_get_applied_schema_version_response(response)
        }
    }
}

/// Operation shape for `GetDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_directory`](crate::client::Client::get_directory).
///
/// See [`crate::client::fluent_builders::GetDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDirectory {
    _private: (),
}
impl GetDirectory {
    /// Creates a new builder-style object to manufacture [`GetDirectoryInput`](crate::input::GetDirectoryInput)
    pub fn builder() -> crate::input::get_directory_input::Builder {
        crate::input::get_directory_input::Builder::default()
    }
    /// Creates a new `GetDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDirectory {
    type Output =
        std::result::Result<crate::output::GetDirectoryOutput, crate::error::GetDirectoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_directory_error(response)
        } else {
            crate::operation_deser::parse_get_directory_response(response)
        }
    }
}

/// Operation shape for `GetFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_facet`](crate::client::Client::get_facet).
///
/// See [`crate::client::fluent_builders::GetFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFacet {
    _private: (),
}
impl GetFacet {
    /// Creates a new builder-style object to manufacture [`GetFacetInput`](crate::input::GetFacetInput)
    pub fn builder() -> crate::input::get_facet_input::Builder {
        crate::input::get_facet_input::Builder::default()
    }
    /// Creates a new `GetFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFacet {
    type Output = std::result::Result<crate::output::GetFacetOutput, crate::error::GetFacetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_facet_error(response)
        } else {
            crate::operation_deser::parse_get_facet_response(response)
        }
    }
}

/// Operation shape for `GetLinkAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_link_attributes`](crate::client::Client::get_link_attributes).
///
/// See [`crate::client::fluent_builders::GetLinkAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLinkAttributes {
    _private: (),
}
impl GetLinkAttributes {
    /// Creates a new builder-style object to manufacture [`GetLinkAttributesInput`](crate::input::GetLinkAttributesInput)
    pub fn builder() -> crate::input::get_link_attributes_input::Builder {
        crate::input::get_link_attributes_input::Builder::default()
    }
    /// Creates a new `GetLinkAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLinkAttributes {
    type Output = std::result::Result<
        crate::output::GetLinkAttributesOutput,
        crate::error::GetLinkAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_link_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_link_attributes_response(response)
        }
    }
}

/// Operation shape for `GetObjectAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_attributes`](crate::client::Client::get_object_attributes).
///
/// See [`crate::client::fluent_builders::GetObjectAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectAttributes {
    _private: (),
}
impl GetObjectAttributes {
    /// Creates a new builder-style object to manufacture [`GetObjectAttributesInput`](crate::input::GetObjectAttributesInput)
    pub fn builder() -> crate::input::get_object_attributes_input::Builder {
        crate::input::get_object_attributes_input::Builder::default()
    }
    /// Creates a new `GetObjectAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectAttributes {
    type Output = std::result::Result<
        crate::output::GetObjectAttributesOutput,
        crate::error::GetObjectAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_object_attributes_response(response)
        }
    }
}

/// Operation shape for `GetObjectInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_information`](crate::client::Client::get_object_information).
///
/// See [`crate::client::fluent_builders::GetObjectInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectInformation {
    _private: (),
}
impl GetObjectInformation {
    /// Creates a new builder-style object to manufacture [`GetObjectInformationInput`](crate::input::GetObjectInformationInput)
    pub fn builder() -> crate::input::get_object_information_input::Builder {
        crate::input::get_object_information_input::Builder::default()
    }
    /// Creates a new `GetObjectInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectInformation {
    type Output = std::result::Result<
        crate::output::GetObjectInformationOutput,
        crate::error::GetObjectInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_information_error(response)
        } else {
            crate::operation_deser::parse_get_object_information_response(response)
        }
    }
}

/// Operation shape for `GetSchemaAsJson`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema_as_json`](crate::client::Client::get_schema_as_json).
///
/// See [`crate::client::fluent_builders::GetSchemaAsJson`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchemaAsJson {
    _private: (),
}
impl GetSchemaAsJson {
    /// Creates a new builder-style object to manufacture [`GetSchemaAsJsonInput`](crate::input::GetSchemaAsJsonInput)
    pub fn builder() -> crate::input::get_schema_as_json_input::Builder {
        crate::input::get_schema_as_json_input::Builder::default()
    }
    /// Creates a new `GetSchemaAsJson` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchemaAsJson {
    type Output = std::result::Result<
        crate::output::GetSchemaAsJsonOutput,
        crate::error::GetSchemaAsJsonError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_as_json_error(response)
        } else {
            crate::operation_deser::parse_get_schema_as_json_response(response)
        }
    }
}

/// Operation shape for `GetTypedLinkFacetInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_typed_link_facet_information`](crate::client::Client::get_typed_link_facet_information).
///
/// See [`crate::client::fluent_builders::GetTypedLinkFacetInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTypedLinkFacetInformation {
    _private: (),
}
impl GetTypedLinkFacetInformation {
    /// Creates a new builder-style object to manufacture [`GetTypedLinkFacetInformationInput`](crate::input::GetTypedLinkFacetInformationInput)
    pub fn builder() -> crate::input::get_typed_link_facet_information_input::Builder {
        crate::input::get_typed_link_facet_information_input::Builder::default()
    }
    /// Creates a new `GetTypedLinkFacetInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTypedLinkFacetInformation {
    type Output = std::result::Result<
        crate::output::GetTypedLinkFacetInformationOutput,
        crate::error::GetTypedLinkFacetInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_typed_link_facet_information_error(response)
        } else {
            crate::operation_deser::parse_get_typed_link_facet_information_response(response)
        }
    }
}

/// Operation shape for `ListAppliedSchemaArns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_applied_schema_arns`](crate::client::Client::list_applied_schema_arns).
///
/// See [`crate::client::fluent_builders::ListAppliedSchemaArns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppliedSchemaArns {
    _private: (),
}
impl ListAppliedSchemaArns {
    /// Creates a new builder-style object to manufacture [`ListAppliedSchemaArnsInput`](crate::input::ListAppliedSchemaArnsInput)
    pub fn builder() -> crate::input::list_applied_schema_arns_input::Builder {
        crate::input::list_applied_schema_arns_input::Builder::default()
    }
    /// Creates a new `ListAppliedSchemaArns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppliedSchemaArns {
    type Output = std::result::Result<
        crate::output::ListAppliedSchemaArnsOutput,
        crate::error::ListAppliedSchemaArnsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_applied_schema_arns_error(response)
        } else {
            crate::operation_deser::parse_list_applied_schema_arns_response(response)
        }
    }
}

/// Operation shape for `ListAttachedIndices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attached_indices`](crate::client::Client::list_attached_indices).
///
/// See [`crate::client::fluent_builders::ListAttachedIndices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttachedIndices {
    _private: (),
}
impl ListAttachedIndices {
    /// Creates a new builder-style object to manufacture [`ListAttachedIndicesInput`](crate::input::ListAttachedIndicesInput)
    pub fn builder() -> crate::input::list_attached_indices_input::Builder {
        crate::input::list_attached_indices_input::Builder::default()
    }
    /// Creates a new `ListAttachedIndices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttachedIndices {
    type Output = std::result::Result<
        crate::output::ListAttachedIndicesOutput,
        crate::error::ListAttachedIndicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attached_indices_error(response)
        } else {
            crate::operation_deser::parse_list_attached_indices_response(response)
        }
    }
}

/// Operation shape for `ListDevelopmentSchemaArns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_development_schema_arns`](crate::client::Client::list_development_schema_arns).
///
/// See [`crate::client::fluent_builders::ListDevelopmentSchemaArns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevelopmentSchemaArns {
    _private: (),
}
impl ListDevelopmentSchemaArns {
    /// Creates a new builder-style object to manufacture [`ListDevelopmentSchemaArnsInput`](crate::input::ListDevelopmentSchemaArnsInput)
    pub fn builder() -> crate::input::list_development_schema_arns_input::Builder {
        crate::input::list_development_schema_arns_input::Builder::default()
    }
    /// Creates a new `ListDevelopmentSchemaArns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevelopmentSchemaArns {
    type Output = std::result::Result<
        crate::output::ListDevelopmentSchemaArnsOutput,
        crate::error::ListDevelopmentSchemaArnsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_development_schema_arns_error(response)
        } else {
            crate::operation_deser::parse_list_development_schema_arns_response(response)
        }
    }
}

/// Operation shape for `ListDirectories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_directories`](crate::client::Client::list_directories).
///
/// See [`crate::client::fluent_builders::ListDirectories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDirectories {
    _private: (),
}
impl ListDirectories {
    /// Creates a new builder-style object to manufacture [`ListDirectoriesInput`](crate::input::ListDirectoriesInput)
    pub fn builder() -> crate::input::list_directories_input::Builder {
        crate::input::list_directories_input::Builder::default()
    }
    /// Creates a new `ListDirectories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDirectories {
    type Output = std::result::Result<
        crate::output::ListDirectoriesOutput,
        crate::error::ListDirectoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_directories_error(response)
        } else {
            crate::operation_deser::parse_list_directories_response(response)
        }
    }
}

/// Operation shape for `ListFacetAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_facet_attributes`](crate::client::Client::list_facet_attributes).
///
/// See [`crate::client::fluent_builders::ListFacetAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFacetAttributes {
    _private: (),
}
impl ListFacetAttributes {
    /// Creates a new builder-style object to manufacture [`ListFacetAttributesInput`](crate::input::ListFacetAttributesInput)
    pub fn builder() -> crate::input::list_facet_attributes_input::Builder {
        crate::input::list_facet_attributes_input::Builder::default()
    }
    /// Creates a new `ListFacetAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFacetAttributes {
    type Output = std::result::Result<
        crate::output::ListFacetAttributesOutput,
        crate::error::ListFacetAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_facet_attributes_error(response)
        } else {
            crate::operation_deser::parse_list_facet_attributes_response(response)
        }
    }
}

/// Operation shape for `ListFacetNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_facet_names`](crate::client::Client::list_facet_names).
///
/// See [`crate::client::fluent_builders::ListFacetNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFacetNames {
    _private: (),
}
impl ListFacetNames {
    /// Creates a new builder-style object to manufacture [`ListFacetNamesInput`](crate::input::ListFacetNamesInput)
    pub fn builder() -> crate::input::list_facet_names_input::Builder {
        crate::input::list_facet_names_input::Builder::default()
    }
    /// Creates a new `ListFacetNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFacetNames {
    type Output =
        std::result::Result<crate::output::ListFacetNamesOutput, crate::error::ListFacetNamesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_facet_names_error(response)
        } else {
            crate::operation_deser::parse_list_facet_names_response(response)
        }
    }
}

/// Operation shape for `ListIncomingTypedLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_incoming_typed_links`](crate::client::Client::list_incoming_typed_links).
///
/// See [`crate::client::fluent_builders::ListIncomingTypedLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIncomingTypedLinks {
    _private: (),
}
impl ListIncomingTypedLinks {
    /// Creates a new builder-style object to manufacture [`ListIncomingTypedLinksInput`](crate::input::ListIncomingTypedLinksInput)
    pub fn builder() -> crate::input::list_incoming_typed_links_input::Builder {
        crate::input::list_incoming_typed_links_input::Builder::default()
    }
    /// Creates a new `ListIncomingTypedLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIncomingTypedLinks {
    type Output = std::result::Result<
        crate::output::ListIncomingTypedLinksOutput,
        crate::error::ListIncomingTypedLinksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_incoming_typed_links_error(response)
        } else {
            crate::operation_deser::parse_list_incoming_typed_links_response(response)
        }
    }
}

/// Operation shape for `ListIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_index`](crate::client::Client::list_index).
///
/// See [`crate::client::fluent_builders::ListIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIndex {
    _private: (),
}
impl ListIndex {
    /// Creates a new builder-style object to manufacture [`ListIndexInput`](crate::input::ListIndexInput)
    pub fn builder() -> crate::input::list_index_input::Builder {
        crate::input::list_index_input::Builder::default()
    }
    /// Creates a new `ListIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIndex {
    type Output = std::result::Result<crate::output::ListIndexOutput, crate::error::ListIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_index_error(response)
        } else {
            crate::operation_deser::parse_list_index_response(response)
        }
    }
}

/// Operation shape for `ListManagedSchemaArns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_managed_schema_arns`](crate::client::Client::list_managed_schema_arns).
///
/// See [`crate::client::fluent_builders::ListManagedSchemaArns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListManagedSchemaArns {
    _private: (),
}
impl ListManagedSchemaArns {
    /// Creates a new builder-style object to manufacture [`ListManagedSchemaArnsInput`](crate::input::ListManagedSchemaArnsInput)
    pub fn builder() -> crate::input::list_managed_schema_arns_input::Builder {
        crate::input::list_managed_schema_arns_input::Builder::default()
    }
    /// Creates a new `ListManagedSchemaArns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListManagedSchemaArns {
    type Output = std::result::Result<
        crate::output::ListManagedSchemaArnsOutput,
        crate::error::ListManagedSchemaArnsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_managed_schema_arns_error(response)
        } else {
            crate::operation_deser::parse_list_managed_schema_arns_response(response)
        }
    }
}

/// Operation shape for `ListObjectAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_attributes`](crate::client::Client::list_object_attributes).
///
/// See [`crate::client::fluent_builders::ListObjectAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectAttributes {
    _private: (),
}
impl ListObjectAttributes {
    /// Creates a new builder-style object to manufacture [`ListObjectAttributesInput`](crate::input::ListObjectAttributesInput)
    pub fn builder() -> crate::input::list_object_attributes_input::Builder {
        crate::input::list_object_attributes_input::Builder::default()
    }
    /// Creates a new `ListObjectAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectAttributes {
    type Output = std::result::Result<
        crate::output::ListObjectAttributesOutput,
        crate::error::ListObjectAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_attributes_error(response)
        } else {
            crate::operation_deser::parse_list_object_attributes_response(response)
        }
    }
}

/// Operation shape for `ListObjectChildren`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_children`](crate::client::Client::list_object_children).
///
/// See [`crate::client::fluent_builders::ListObjectChildren`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectChildren {
    _private: (),
}
impl ListObjectChildren {
    /// Creates a new builder-style object to manufacture [`ListObjectChildrenInput`](crate::input::ListObjectChildrenInput)
    pub fn builder() -> crate::input::list_object_children_input::Builder {
        crate::input::list_object_children_input::Builder::default()
    }
    /// Creates a new `ListObjectChildren` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectChildren {
    type Output = std::result::Result<
        crate::output::ListObjectChildrenOutput,
        crate::error::ListObjectChildrenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_children_error(response)
        } else {
            crate::operation_deser::parse_list_object_children_response(response)
        }
    }
}

/// Operation shape for `ListObjectParentPaths`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_parent_paths`](crate::client::Client::list_object_parent_paths).
///
/// See [`crate::client::fluent_builders::ListObjectParentPaths`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectParentPaths {
    _private: (),
}
impl ListObjectParentPaths {
    /// Creates a new builder-style object to manufacture [`ListObjectParentPathsInput`](crate::input::ListObjectParentPathsInput)
    pub fn builder() -> crate::input::list_object_parent_paths_input::Builder {
        crate::input::list_object_parent_paths_input::Builder::default()
    }
    /// Creates a new `ListObjectParentPaths` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectParentPaths {
    type Output = std::result::Result<
        crate::output::ListObjectParentPathsOutput,
        crate::error::ListObjectParentPathsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_parent_paths_error(response)
        } else {
            crate::operation_deser::parse_list_object_parent_paths_response(response)
        }
    }
}

/// Operation shape for `ListObjectParents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_parents`](crate::client::Client::list_object_parents).
///
/// See [`crate::client::fluent_builders::ListObjectParents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectParents {
    _private: (),
}
impl ListObjectParents {
    /// Creates a new builder-style object to manufacture [`ListObjectParentsInput`](crate::input::ListObjectParentsInput)
    pub fn builder() -> crate::input::list_object_parents_input::Builder {
        crate::input::list_object_parents_input::Builder::default()
    }
    /// Creates a new `ListObjectParents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectParents {
    type Output = std::result::Result<
        crate::output::ListObjectParentsOutput,
        crate::error::ListObjectParentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_parents_error(response)
        } else {
            crate::operation_deser::parse_list_object_parents_response(response)
        }
    }
}

/// Operation shape for `ListObjectPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_policies`](crate::client::Client::list_object_policies).
///
/// See [`crate::client::fluent_builders::ListObjectPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectPolicies {
    _private: (),
}
impl ListObjectPolicies {
    /// Creates a new builder-style object to manufacture [`ListObjectPoliciesInput`](crate::input::ListObjectPoliciesInput)
    pub fn builder() -> crate::input::list_object_policies_input::Builder {
        crate::input::list_object_policies_input::Builder::default()
    }
    /// Creates a new `ListObjectPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectPolicies {
    type Output = std::result::Result<
        crate::output::ListObjectPoliciesOutput,
        crate::error::ListObjectPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_policies_error(response)
        } else {
            crate::operation_deser::parse_list_object_policies_response(response)
        }
    }
}

/// Operation shape for `ListOutgoingTypedLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_outgoing_typed_links`](crate::client::Client::list_outgoing_typed_links).
///
/// See [`crate::client::fluent_builders::ListOutgoingTypedLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOutgoingTypedLinks {
    _private: (),
}
impl ListOutgoingTypedLinks {
    /// Creates a new builder-style object to manufacture [`ListOutgoingTypedLinksInput`](crate::input::ListOutgoingTypedLinksInput)
    pub fn builder() -> crate::input::list_outgoing_typed_links_input::Builder {
        crate::input::list_outgoing_typed_links_input::Builder::default()
    }
    /// Creates a new `ListOutgoingTypedLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOutgoingTypedLinks {
    type Output = std::result::Result<
        crate::output::ListOutgoingTypedLinksOutput,
        crate::error::ListOutgoingTypedLinksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_outgoing_typed_links_error(response)
        } else {
            crate::operation_deser::parse_list_outgoing_typed_links_response(response)
        }
    }
}

/// Operation shape for `ListPolicyAttachments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policy_attachments`](crate::client::Client::list_policy_attachments).
///
/// See [`crate::client::fluent_builders::ListPolicyAttachments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicyAttachments {
    _private: (),
}
impl ListPolicyAttachments {
    /// Creates a new builder-style object to manufacture [`ListPolicyAttachmentsInput`](crate::input::ListPolicyAttachmentsInput)
    pub fn builder() -> crate::input::list_policy_attachments_input::Builder {
        crate::input::list_policy_attachments_input::Builder::default()
    }
    /// Creates a new `ListPolicyAttachments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicyAttachments {
    type Output = std::result::Result<
        crate::output::ListPolicyAttachmentsOutput,
        crate::error::ListPolicyAttachmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policy_attachments_error(response)
        } else {
            crate::operation_deser::parse_list_policy_attachments_response(response)
        }
    }
}

/// Operation shape for `ListPublishedSchemaArns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_published_schema_arns`](crate::client::Client::list_published_schema_arns).
///
/// See [`crate::client::fluent_builders::ListPublishedSchemaArns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPublishedSchemaArns {
    _private: (),
}
impl ListPublishedSchemaArns {
    /// Creates a new builder-style object to manufacture [`ListPublishedSchemaArnsInput`](crate::input::ListPublishedSchemaArnsInput)
    pub fn builder() -> crate::input::list_published_schema_arns_input::Builder {
        crate::input::list_published_schema_arns_input::Builder::default()
    }
    /// Creates a new `ListPublishedSchemaArns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPublishedSchemaArns {
    type Output = std::result::Result<
        crate::output::ListPublishedSchemaArnsOutput,
        crate::error::ListPublishedSchemaArnsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_published_schema_arns_error(response)
        } else {
            crate::operation_deser::parse_list_published_schema_arns_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTypedLinkFacetAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_typed_link_facet_attributes`](crate::client::Client::list_typed_link_facet_attributes).
///
/// See [`crate::client::fluent_builders::ListTypedLinkFacetAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypedLinkFacetAttributes {
    _private: (),
}
impl ListTypedLinkFacetAttributes {
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetAttributesInput`](crate::input::ListTypedLinkFacetAttributesInput)
    pub fn builder() -> crate::input::list_typed_link_facet_attributes_input::Builder {
        crate::input::list_typed_link_facet_attributes_input::Builder::default()
    }
    /// Creates a new `ListTypedLinkFacetAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypedLinkFacetAttributes {
    type Output = std::result::Result<
        crate::output::ListTypedLinkFacetAttributesOutput,
        crate::error::ListTypedLinkFacetAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_typed_link_facet_attributes_error(response)
        } else {
            crate::operation_deser::parse_list_typed_link_facet_attributes_response(response)
        }
    }
}

/// Operation shape for `ListTypedLinkFacetNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_typed_link_facet_names`](crate::client::Client::list_typed_link_facet_names).
///
/// See [`crate::client::fluent_builders::ListTypedLinkFacetNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypedLinkFacetNames {
    _private: (),
}
impl ListTypedLinkFacetNames {
    /// Creates a new builder-style object to manufacture [`ListTypedLinkFacetNamesInput`](crate::input::ListTypedLinkFacetNamesInput)
    pub fn builder() -> crate::input::list_typed_link_facet_names_input::Builder {
        crate::input::list_typed_link_facet_names_input::Builder::default()
    }
    /// Creates a new `ListTypedLinkFacetNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypedLinkFacetNames {
    type Output = std::result::Result<
        crate::output::ListTypedLinkFacetNamesOutput,
        crate::error::ListTypedLinkFacetNamesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_typed_link_facet_names_error(response)
        } else {
            crate::operation_deser::parse_list_typed_link_facet_names_response(response)
        }
    }
}

/// Operation shape for `LookupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`lookup_policy`](crate::client::Client::lookup_policy).
///
/// See [`crate::client::fluent_builders::LookupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct LookupPolicy {
    _private: (),
}
impl LookupPolicy {
    /// Creates a new builder-style object to manufacture [`LookupPolicyInput`](crate::input::LookupPolicyInput)
    pub fn builder() -> crate::input::lookup_policy_input::Builder {
        crate::input::lookup_policy_input::Builder::default()
    }
    /// Creates a new `LookupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for LookupPolicy {
    type Output =
        std::result::Result<crate::output::LookupPolicyOutput, crate::error::LookupPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_lookup_policy_error(response)
        } else {
            crate::operation_deser::parse_lookup_policy_response(response)
        }
    }
}

/// Operation shape for `PublishSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_schema`](crate::client::Client::publish_schema).
///
/// See [`crate::client::fluent_builders::PublishSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishSchema {
    _private: (),
}
impl PublishSchema {
    /// Creates a new builder-style object to manufacture [`PublishSchemaInput`](crate::input::PublishSchemaInput)
    pub fn builder() -> crate::input::publish_schema_input::Builder {
        crate::input::publish_schema_input::Builder::default()
    }
    /// Creates a new `PublishSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishSchema {
    type Output =
        std::result::Result<crate::output::PublishSchemaOutput, crate::error::PublishSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_schema_error(response)
        } else {
            crate::operation_deser::parse_publish_schema_response(response)
        }
    }
}

/// Operation shape for `PutSchemaFromJson`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_schema_from_json`](crate::client::Client::put_schema_from_json).
///
/// See [`crate::client::fluent_builders::PutSchemaFromJson`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSchemaFromJson {
    _private: (),
}
impl PutSchemaFromJson {
    /// Creates a new builder-style object to manufacture [`PutSchemaFromJsonInput`](crate::input::PutSchemaFromJsonInput)
    pub fn builder() -> crate::input::put_schema_from_json_input::Builder {
        crate::input::put_schema_from_json_input::Builder::default()
    }
    /// Creates a new `PutSchemaFromJson` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSchemaFromJson {
    type Output = std::result::Result<
        crate::output::PutSchemaFromJsonOutput,
        crate::error::PutSchemaFromJsonError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_schema_from_json_error(response)
        } else {
            crate::operation_deser::parse_put_schema_from_json_response(response)
        }
    }
}

/// Operation shape for `RemoveFacetFromObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_facet_from_object`](crate::client::Client::remove_facet_from_object).
///
/// See [`crate::client::fluent_builders::RemoveFacetFromObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFacetFromObject {
    _private: (),
}
impl RemoveFacetFromObject {
    /// Creates a new builder-style object to manufacture [`RemoveFacetFromObjectInput`](crate::input::RemoveFacetFromObjectInput)
    pub fn builder() -> crate::input::remove_facet_from_object_input::Builder {
        crate::input::remove_facet_from_object_input::Builder::default()
    }
    /// Creates a new `RemoveFacetFromObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFacetFromObject {
    type Output = std::result::Result<
        crate::output::RemoveFacetFromObjectOutput,
        crate::error::RemoveFacetFromObjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_facet_from_object_error(response)
        } else {
            crate::operation_deser::parse_remove_facet_from_object_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_facet`](crate::client::Client::update_facet).
///
/// See [`crate::client::fluent_builders::UpdateFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFacet {
    _private: (),
}
impl UpdateFacet {
    /// Creates a new builder-style object to manufacture [`UpdateFacetInput`](crate::input::UpdateFacetInput)
    pub fn builder() -> crate::input::update_facet_input::Builder {
        crate::input::update_facet_input::Builder::default()
    }
    /// Creates a new `UpdateFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFacet {
    type Output =
        std::result::Result<crate::output::UpdateFacetOutput, crate::error::UpdateFacetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_facet_error(response)
        } else {
            crate::operation_deser::parse_update_facet_response(response)
        }
    }
}

/// Operation shape for `UpdateLinkAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_link_attributes`](crate::client::Client::update_link_attributes).
///
/// See [`crate::client::fluent_builders::UpdateLinkAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLinkAttributes {
    _private: (),
}
impl UpdateLinkAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateLinkAttributesInput`](crate::input::UpdateLinkAttributesInput)
    pub fn builder() -> crate::input::update_link_attributes_input::Builder {
        crate::input::update_link_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateLinkAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLinkAttributes {
    type Output = std::result::Result<
        crate::output::UpdateLinkAttributesOutput,
        crate::error::UpdateLinkAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_link_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_link_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateObjectAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_object_attributes`](crate::client::Client::update_object_attributes).
///
/// See [`crate::client::fluent_builders::UpdateObjectAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateObjectAttributes {
    _private: (),
}
impl UpdateObjectAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateObjectAttributesInput`](crate::input::UpdateObjectAttributesInput)
    pub fn builder() -> crate::input::update_object_attributes_input::Builder {
        crate::input::update_object_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateObjectAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateObjectAttributes {
    type Output = std::result::Result<
        crate::output::UpdateObjectAttributesOutput,
        crate::error::UpdateObjectAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_object_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_object_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_schema`](crate::client::Client::update_schema).
///
/// See [`crate::client::fluent_builders::UpdateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSchema {
    _private: (),
}
impl UpdateSchema {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    pub fn builder() -> crate::input::update_schema_input::Builder {
        crate::input::update_schema_input::Builder::default()
    }
    /// Creates a new `UpdateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSchema {
    type Output =
        std::result::Result<crate::output::UpdateSchemaOutput, crate::error::UpdateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_schema_error(response)
        } else {
            crate::operation_deser::parse_update_schema_response(response)
        }
    }
}

/// Operation shape for `UpdateTypedLinkFacet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_typed_link_facet`](crate::client::Client::update_typed_link_facet).
///
/// See [`crate::client::fluent_builders::UpdateTypedLinkFacet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTypedLinkFacet {
    _private: (),
}
impl UpdateTypedLinkFacet {
    /// Creates a new builder-style object to manufacture [`UpdateTypedLinkFacetInput`](crate::input::UpdateTypedLinkFacetInput)
    pub fn builder() -> crate::input::update_typed_link_facet_input::Builder {
        crate::input::update_typed_link_facet_input::Builder::default()
    }
    /// Creates a new `UpdateTypedLinkFacet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTypedLinkFacet {
    type Output = std::result::Result<
        crate::output::UpdateTypedLinkFacetOutput,
        crate::error::UpdateTypedLinkFacetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_typed_link_facet_error(response)
        } else {
            crate::operation_deser::parse_update_typed_link_facet_response(response)
        }
    }
}

/// Operation shape for `UpgradeAppliedSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upgrade_applied_schema`](crate::client::Client::upgrade_applied_schema).
///
/// See [`crate::client::fluent_builders::UpgradeAppliedSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpgradeAppliedSchema {
    _private: (),
}
impl UpgradeAppliedSchema {
    /// Creates a new builder-style object to manufacture [`UpgradeAppliedSchemaInput`](crate::input::UpgradeAppliedSchemaInput)
    pub fn builder() -> crate::input::upgrade_applied_schema_input::Builder {
        crate::input::upgrade_applied_schema_input::Builder::default()
    }
    /// Creates a new `UpgradeAppliedSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpgradeAppliedSchema {
    type Output = std::result::Result<
        crate::output::UpgradeAppliedSchemaOutput,
        crate::error::UpgradeAppliedSchemaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upgrade_applied_schema_error(response)
        } else {
            crate::operation_deser::parse_upgrade_applied_schema_response(response)
        }
    }
}

/// Operation shape for `UpgradePublishedSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upgrade_published_schema`](crate::client::Client::upgrade_published_schema).
///
/// See [`crate::client::fluent_builders::UpgradePublishedSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpgradePublishedSchema {
    _private: (),
}
impl UpgradePublishedSchema {
    /// Creates a new builder-style object to manufacture [`UpgradePublishedSchemaInput`](crate::input::UpgradePublishedSchemaInput)
    pub fn builder() -> crate::input::upgrade_published_schema_input::Builder {
        crate::input::upgrade_published_schema_input::Builder::default()
    }
    /// Creates a new `UpgradePublishedSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpgradePublishedSchema {
    type Output = std::result::Result<
        crate::output::UpgradePublishedSchemaOutput,
        crate::error::UpgradePublishedSchemaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upgrade_published_schema_error(response)
        } else {
            crate::operation_deser::parse_upgrade_published_schema_response(response)
        }
    }
}
