// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon CloudDirectory
///
/// Client for invoking operations on Amazon CloudDirectory. Each operation on Amazon CloudDirectory is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_clouddirectory::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_clouddirectory::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_clouddirectory::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddFacetToObject` operation.
    ///
    /// See [`AddFacetToObject`](crate::client::fluent_builders::AddFacetToObject) for more information about the
    /// operation and its arguments.
    pub fn add_facet_to_object(&self) -> fluent_builders::AddFacetToObject<C, M, R> {
        fluent_builders::AddFacetToObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplySchema` operation.
    ///
    /// See [`ApplySchema`](crate::client::fluent_builders::ApplySchema) for more information about the
    /// operation and its arguments.
    pub fn apply_schema(&self) -> fluent_builders::ApplySchema<C, M, R> {
        fluent_builders::ApplySchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachObject` operation.
    ///
    /// See [`AttachObject`](crate::client::fluent_builders::AttachObject) for more information about the
    /// operation and its arguments.
    pub fn attach_object(&self) -> fluent_builders::AttachObject<C, M, R> {
        fluent_builders::AttachObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachPolicy` operation.
    ///
    /// See [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy<C, M, R> {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachToIndex` operation.
    ///
    /// See [`AttachToIndex`](crate::client::fluent_builders::AttachToIndex) for more information about the
    /// operation and its arguments.
    pub fn attach_to_index(&self) -> fluent_builders::AttachToIndex<C, M, R> {
        fluent_builders::AttachToIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachTypedLink` operation.
    ///
    /// See [`AttachTypedLink`](crate::client::fluent_builders::AttachTypedLink) for more information about the
    /// operation and its arguments.
    pub fn attach_typed_link(&self) -> fluent_builders::AttachTypedLink<C, M, R> {
        fluent_builders::AttachTypedLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchRead` operation.
    ///
    /// See [`BatchRead`](crate::client::fluent_builders::BatchRead) for more information about the
    /// operation and its arguments.
    pub fn batch_read(&self) -> fluent_builders::BatchRead<C, M, R> {
        fluent_builders::BatchRead::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchWrite` operation.
    ///
    /// See [`BatchWrite`](crate::client::fluent_builders::BatchWrite) for more information about the
    /// operation and its arguments.
    pub fn batch_write(&self) -> fluent_builders::BatchWrite<C, M, R> {
        fluent_builders::BatchWrite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectory` operation.
    ///
    /// See [`CreateDirectory`](crate::client::fluent_builders::CreateDirectory) for more information about the
    /// operation and its arguments.
    pub fn create_directory(&self) -> fluent_builders::CreateDirectory<C, M, R> {
        fluent_builders::CreateDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFacet` operation.
    ///
    /// See [`CreateFacet`](crate::client::fluent_builders::CreateFacet) for more information about the
    /// operation and its arguments.
    pub fn create_facet(&self) -> fluent_builders::CreateFacet<C, M, R> {
        fluent_builders::CreateFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIndex` operation.
    ///
    /// See [`CreateIndex`](crate::client::fluent_builders::CreateIndex) for more information about the
    /// operation and its arguments.
    pub fn create_index(&self) -> fluent_builders::CreateIndex<C, M, R> {
        fluent_builders::CreateIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateObject` operation.
    ///
    /// See [`CreateObject`](crate::client::fluent_builders::CreateObject) for more information about the
    /// operation and its arguments.
    pub fn create_object(&self) -> fluent_builders::CreateObject<C, M, R> {
        fluent_builders::CreateObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSchema` operation.
    ///
    /// See [`CreateSchema`](crate::client::fluent_builders::CreateSchema) for more information about the
    /// operation and its arguments.
    pub fn create_schema(&self) -> fluent_builders::CreateSchema<C, M, R> {
        fluent_builders::CreateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTypedLinkFacet` operation.
    ///
    /// See [`CreateTypedLinkFacet`](crate::client::fluent_builders::CreateTypedLinkFacet) for more information about the
    /// operation and its arguments.
    pub fn create_typed_link_facet(&self) -> fluent_builders::CreateTypedLinkFacet<C, M, R> {
        fluent_builders::CreateTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectory` operation.
    ///
    /// See [`DeleteDirectory`](crate::client::fluent_builders::DeleteDirectory) for more information about the
    /// operation and its arguments.
    pub fn delete_directory(&self) -> fluent_builders::DeleteDirectory<C, M, R> {
        fluent_builders::DeleteDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFacet` operation.
    ///
    /// See [`DeleteFacet`](crate::client::fluent_builders::DeleteFacet) for more information about the
    /// operation and its arguments.
    pub fn delete_facet(&self) -> fluent_builders::DeleteFacet<C, M, R> {
        fluent_builders::DeleteFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteObject` operation.
    ///
    /// See [`DeleteObject`](crate::client::fluent_builders::DeleteObject) for more information about the
    /// operation and its arguments.
    pub fn delete_object(&self) -> fluent_builders::DeleteObject<C, M, R> {
        fluent_builders::DeleteObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchema` operation.
    ///
    /// See [`DeleteSchema`](crate::client::fluent_builders::DeleteSchema) for more information about the
    /// operation and its arguments.
    pub fn delete_schema(&self) -> fluent_builders::DeleteSchema<C, M, R> {
        fluent_builders::DeleteSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTypedLinkFacet` operation.
    ///
    /// See [`DeleteTypedLinkFacet`](crate::client::fluent_builders::DeleteTypedLinkFacet) for more information about the
    /// operation and its arguments.
    pub fn delete_typed_link_facet(&self) -> fluent_builders::DeleteTypedLinkFacet<C, M, R> {
        fluent_builders::DeleteTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachFromIndex` operation.
    ///
    /// See [`DetachFromIndex`](crate::client::fluent_builders::DetachFromIndex) for more information about the
    /// operation and its arguments.
    pub fn detach_from_index(&self) -> fluent_builders::DetachFromIndex<C, M, R> {
        fluent_builders::DetachFromIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachObject` operation.
    ///
    /// See [`DetachObject`](crate::client::fluent_builders::DetachObject) for more information about the
    /// operation and its arguments.
    pub fn detach_object(&self) -> fluent_builders::DetachObject<C, M, R> {
        fluent_builders::DetachObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachPolicy` operation.
    ///
    /// See [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy<C, M, R> {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachTypedLink` operation.
    ///
    /// See [`DetachTypedLink`](crate::client::fluent_builders::DetachTypedLink) for more information about the
    /// operation and its arguments.
    pub fn detach_typed_link(&self) -> fluent_builders::DetachTypedLink<C, M, R> {
        fluent_builders::DetachTypedLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableDirectory` operation.
    ///
    /// See [`DisableDirectory`](crate::client::fluent_builders::DisableDirectory) for more information about the
    /// operation and its arguments.
    pub fn disable_directory(&self) -> fluent_builders::DisableDirectory<C, M, R> {
        fluent_builders::DisableDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableDirectory` operation.
    ///
    /// See [`EnableDirectory`](crate::client::fluent_builders::EnableDirectory) for more information about the
    /// operation and its arguments.
    pub fn enable_directory(&self) -> fluent_builders::EnableDirectory<C, M, R> {
        fluent_builders::EnableDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppliedSchemaVersion` operation.
    ///
    /// See [`GetAppliedSchemaVersion`](crate::client::fluent_builders::GetAppliedSchemaVersion) for more information about the
    /// operation and its arguments.
    pub fn get_applied_schema_version(&self) -> fluent_builders::GetAppliedSchemaVersion<C, M, R> {
        fluent_builders::GetAppliedSchemaVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDirectory` operation.
    ///
    /// See [`GetDirectory`](crate::client::fluent_builders::GetDirectory) for more information about the
    /// operation and its arguments.
    pub fn get_directory(&self) -> fluent_builders::GetDirectory<C, M, R> {
        fluent_builders::GetDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFacet` operation.
    ///
    /// See [`GetFacet`](crate::client::fluent_builders::GetFacet) for more information about the
    /// operation and its arguments.
    pub fn get_facet(&self) -> fluent_builders::GetFacet<C, M, R> {
        fluent_builders::GetFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLinkAttributes` operation.
    ///
    /// See [`GetLinkAttributes`](crate::client::fluent_builders::GetLinkAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_link_attributes(&self) -> fluent_builders::GetLinkAttributes<C, M, R> {
        fluent_builders::GetLinkAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetObjectAttributes` operation.
    ///
    /// See [`GetObjectAttributes`](crate::client::fluent_builders::GetObjectAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_object_attributes(&self) -> fluent_builders::GetObjectAttributes<C, M, R> {
        fluent_builders::GetObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetObjectInformation` operation.
    ///
    /// See [`GetObjectInformation`](crate::client::fluent_builders::GetObjectInformation) for more information about the
    /// operation and its arguments.
    pub fn get_object_information(&self) -> fluent_builders::GetObjectInformation<C, M, R> {
        fluent_builders::GetObjectInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchemaAsJson` operation.
    ///
    /// See [`GetSchemaAsJson`](crate::client::fluent_builders::GetSchemaAsJson) for more information about the
    /// operation and its arguments.
    pub fn get_schema_as_json(&self) -> fluent_builders::GetSchemaAsJson<C, M, R> {
        fluent_builders::GetSchemaAsJson::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTypedLinkFacetInformation` operation.
    ///
    /// See [`GetTypedLinkFacetInformation`](crate::client::fluent_builders::GetTypedLinkFacetInformation) for more information about the
    /// operation and its arguments.
    pub fn get_typed_link_facet_information(
        &self,
    ) -> fluent_builders::GetTypedLinkFacetInformation<C, M, R> {
        fluent_builders::GetTypedLinkFacetInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppliedSchemaArns` operation.
    ///
    /// See [`ListAppliedSchemaArns`](crate::client::fluent_builders::ListAppliedSchemaArns) for more information about the
    /// operation and its arguments.
    pub fn list_applied_schema_arns(&self) -> fluent_builders::ListAppliedSchemaArns<C, M, R> {
        fluent_builders::ListAppliedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachedIndices` operation.
    ///
    /// See [`ListAttachedIndices`](crate::client::fluent_builders::ListAttachedIndices) for more information about the
    /// operation and its arguments.
    pub fn list_attached_indices(&self) -> fluent_builders::ListAttachedIndices<C, M, R> {
        fluent_builders::ListAttachedIndices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevelopmentSchemaArns` operation.
    ///
    /// See [`ListDevelopmentSchemaArns`](crate::client::fluent_builders::ListDevelopmentSchemaArns) for more information about the
    /// operation and its arguments.
    pub fn list_development_schema_arns(
        &self,
    ) -> fluent_builders::ListDevelopmentSchemaArns<C, M, R> {
        fluent_builders::ListDevelopmentSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDirectories` operation.
    ///
    /// See [`ListDirectories`](crate::client::fluent_builders::ListDirectories) for more information about the
    /// operation and its arguments.
    pub fn list_directories(&self) -> fluent_builders::ListDirectories<C, M, R> {
        fluent_builders::ListDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFacetAttributes` operation.
    ///
    /// See [`ListFacetAttributes`](crate::client::fluent_builders::ListFacetAttributes) for more information about the
    /// operation and its arguments.
    pub fn list_facet_attributes(&self) -> fluent_builders::ListFacetAttributes<C, M, R> {
        fluent_builders::ListFacetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFacetNames` operation.
    ///
    /// See [`ListFacetNames`](crate::client::fluent_builders::ListFacetNames) for more information about the
    /// operation and its arguments.
    pub fn list_facet_names(&self) -> fluent_builders::ListFacetNames<C, M, R> {
        fluent_builders::ListFacetNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIncomingTypedLinks` operation.
    ///
    /// See [`ListIncomingTypedLinks`](crate::client::fluent_builders::ListIncomingTypedLinks) for more information about the
    /// operation and its arguments.
    pub fn list_incoming_typed_links(&self) -> fluent_builders::ListIncomingTypedLinks<C, M, R> {
        fluent_builders::ListIncomingTypedLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIndex` operation.
    ///
    /// See [`ListIndex`](crate::client::fluent_builders::ListIndex) for more information about the
    /// operation and its arguments.
    pub fn list_index(&self) -> fluent_builders::ListIndex<C, M, R> {
        fluent_builders::ListIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListManagedSchemaArns` operation.
    ///
    /// See [`ListManagedSchemaArns`](crate::client::fluent_builders::ListManagedSchemaArns) for more information about the
    /// operation and its arguments.
    pub fn list_managed_schema_arns(&self) -> fluent_builders::ListManagedSchemaArns<C, M, R> {
        fluent_builders::ListManagedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListObjectAttributes` operation.
    ///
    /// See [`ListObjectAttributes`](crate::client::fluent_builders::ListObjectAttributes) for more information about the
    /// operation and its arguments.
    pub fn list_object_attributes(&self) -> fluent_builders::ListObjectAttributes<C, M, R> {
        fluent_builders::ListObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListObjectChildren` operation.
    ///
    /// See [`ListObjectChildren`](crate::client::fluent_builders::ListObjectChildren) for more information about the
    /// operation and its arguments.
    pub fn list_object_children(&self) -> fluent_builders::ListObjectChildren<C, M, R> {
        fluent_builders::ListObjectChildren::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListObjectParentPaths` operation.
    ///
    /// See [`ListObjectParentPaths`](crate::client::fluent_builders::ListObjectParentPaths) for more information about the
    /// operation and its arguments.
    pub fn list_object_parent_paths(&self) -> fluent_builders::ListObjectParentPaths<C, M, R> {
        fluent_builders::ListObjectParentPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListObjectParents` operation.
    ///
    /// See [`ListObjectParents`](crate::client::fluent_builders::ListObjectParents) for more information about the
    /// operation and its arguments.
    pub fn list_object_parents(&self) -> fluent_builders::ListObjectParents<C, M, R> {
        fluent_builders::ListObjectParents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListObjectPolicies` operation.
    ///
    /// See [`ListObjectPolicies`](crate::client::fluent_builders::ListObjectPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_object_policies(&self) -> fluent_builders::ListObjectPolicies<C, M, R> {
        fluent_builders::ListObjectPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOutgoingTypedLinks` operation.
    ///
    /// See [`ListOutgoingTypedLinks`](crate::client::fluent_builders::ListOutgoingTypedLinks) for more information about the
    /// operation and its arguments.
    pub fn list_outgoing_typed_links(&self) -> fluent_builders::ListOutgoingTypedLinks<C, M, R> {
        fluent_builders::ListOutgoingTypedLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyAttachments` operation.
    ///
    /// See [`ListPolicyAttachments`](crate::client::fluent_builders::ListPolicyAttachments) for more information about the
    /// operation and its arguments.
    pub fn list_policy_attachments(&self) -> fluent_builders::ListPolicyAttachments<C, M, R> {
        fluent_builders::ListPolicyAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPublishedSchemaArns` operation.
    ///
    /// See [`ListPublishedSchemaArns`](crate::client::fluent_builders::ListPublishedSchemaArns) for more information about the
    /// operation and its arguments.
    pub fn list_published_schema_arns(&self) -> fluent_builders::ListPublishedSchemaArns<C, M, R> {
        fluent_builders::ListPublishedSchemaArns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypedLinkFacetAttributes` operation.
    ///
    /// See [`ListTypedLinkFacetAttributes`](crate::client::fluent_builders::ListTypedLinkFacetAttributes) for more information about the
    /// operation and its arguments.
    pub fn list_typed_link_facet_attributes(
        &self,
    ) -> fluent_builders::ListTypedLinkFacetAttributes<C, M, R> {
        fluent_builders::ListTypedLinkFacetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypedLinkFacetNames` operation.
    ///
    /// See [`ListTypedLinkFacetNames`](crate::client::fluent_builders::ListTypedLinkFacetNames) for more information about the
    /// operation and its arguments.
    pub fn list_typed_link_facet_names(&self) -> fluent_builders::ListTypedLinkFacetNames<C, M, R> {
        fluent_builders::ListTypedLinkFacetNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LookupPolicy` operation.
    ///
    /// See [`LookupPolicy`](crate::client::fluent_builders::LookupPolicy) for more information about the
    /// operation and its arguments.
    pub fn lookup_policy(&self) -> fluent_builders::LookupPolicy<C, M, R> {
        fluent_builders::LookupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishSchema` operation.
    ///
    /// See [`PublishSchema`](crate::client::fluent_builders::PublishSchema) for more information about the
    /// operation and its arguments.
    pub fn publish_schema(&self) -> fluent_builders::PublishSchema<C, M, R> {
        fluent_builders::PublishSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSchemaFromJson` operation.
    ///
    /// See [`PutSchemaFromJson`](crate::client::fluent_builders::PutSchemaFromJson) for more information about the
    /// operation and its arguments.
    pub fn put_schema_from_json(&self) -> fluent_builders::PutSchemaFromJson<C, M, R> {
        fluent_builders::PutSchemaFromJson::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFacetFromObject` operation.
    ///
    /// See [`RemoveFacetFromObject`](crate::client::fluent_builders::RemoveFacetFromObject) for more information about the
    /// operation and its arguments.
    pub fn remove_facet_from_object(&self) -> fluent_builders::RemoveFacetFromObject<C, M, R> {
        fluent_builders::RemoveFacetFromObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFacet` operation.
    ///
    /// See [`UpdateFacet`](crate::client::fluent_builders::UpdateFacet) for more information about the
    /// operation and its arguments.
    pub fn update_facet(&self) -> fluent_builders::UpdateFacet<C, M, R> {
        fluent_builders::UpdateFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLinkAttributes` operation.
    ///
    /// See [`UpdateLinkAttributes`](crate::client::fluent_builders::UpdateLinkAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_link_attributes(&self) -> fluent_builders::UpdateLinkAttributes<C, M, R> {
        fluent_builders::UpdateLinkAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateObjectAttributes` operation.
    ///
    /// See [`UpdateObjectAttributes`](crate::client::fluent_builders::UpdateObjectAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_object_attributes(&self) -> fluent_builders::UpdateObjectAttributes<C, M, R> {
        fluent_builders::UpdateObjectAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSchema` operation.
    ///
    /// See [`UpdateSchema`](crate::client::fluent_builders::UpdateSchema) for more information about the
    /// operation and its arguments.
    pub fn update_schema(&self) -> fluent_builders::UpdateSchema<C, M, R> {
        fluent_builders::UpdateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTypedLinkFacet` operation.
    ///
    /// See [`UpdateTypedLinkFacet`](crate::client::fluent_builders::UpdateTypedLinkFacet) for more information about the
    /// operation and its arguments.
    pub fn update_typed_link_facet(&self) -> fluent_builders::UpdateTypedLinkFacet<C, M, R> {
        fluent_builders::UpdateTypedLinkFacet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradeAppliedSchema` operation.
    ///
    /// See [`UpgradeAppliedSchema`](crate::client::fluent_builders::UpgradeAppliedSchema) for more information about the
    /// operation and its arguments.
    pub fn upgrade_applied_schema(&self) -> fluent_builders::UpgradeAppliedSchema<C, M, R> {
        fluent_builders::UpgradeAppliedSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradePublishedSchema` operation.
    ///
    /// See [`UpgradePublishedSchema`](crate::client::fluent_builders::UpgradePublishedSchema) for more information about the
    /// operation and its arguments.
    pub fn upgrade_published_schema(&self) -> fluent_builders::UpgradePublishedSchema<C, M, R> {
        fluent_builders::UpgradePublishedSchema::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddFacetToObject`.
    ///
    /// <p>Adds a new <a>Facet</a> to an object. An object can have more than one facet applied on it.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddFacetToObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_facet_to_object_input::Builder,
    }
    impl<C, M, R> AddFacetToObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddFacetToObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFacetToObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFacetToObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddFacetToObjectInputOperationOutputAlias,
                crate::output::AddFacetToObjectOutput,
                crate::error::AddFacetToObjectError,
                crate::input::AddFacetToObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.</p>
        pub fn schema_facet(mut self, inp: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(inp);
            self
        }
        /// <p>Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// Appends an item to `ObjectAttributeList`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn object_attribute_list(
            mut self,
            inp: impl Into<crate::model::AttributeKeyAndValue>,
        ) -> Self {
            self.inner = self.inner.object_attribute_list(inp);
            self
        }
        /// <p>Attributes on the facet that you are adding to the object.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_object_attribute_list(input);
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>A reference to the object you are adding the specified facet to.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplySchema`.
    ///
    /// <p>Copies the input published schema, at the specified version, into the <a>Directory</a> with the same
    /// name and version as that of the published schema.</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplySchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_schema_input::Builder,
    }
    impl<C, M, R> ApplySchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplySchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplySchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplySchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplySchemaInputOperationOutputAlias,
                crate::output::ApplySchemaOutput,
                crate::error::ApplySchemaError,
                crate::input::ApplySchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more
        /// information, see <a>arns</a>.</p>
        pub fn published_schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(inp);
            self
        }
        /// <p>Published schema Amazon Resource Name (ARN) that needs to be copied. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// into which the schema is copied. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// into which the schema is copied. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachObject`.
    ///
    /// <p>Attaches an existing object to another object. An object can be accessed in two
    /// ways:</p>
    /// <ol>
    /// <li>
    /// <p>Using the path</p>
    /// </li>
    /// <li>
    /// <p>Using <code>ObjectIdentifier</code>
    /// </p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct AttachObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_object_input::Builder,
    }
    impl<C, M, R> AttachObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachObjectInputOperationOutputAlias,
                crate::output::AttachObjectOutput,
                crate::error::AttachObjectError,
                crate::input::AttachObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn parent_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(inp);
            self
        }
        /// <p>The parent object reference.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn child_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.child_reference(inp);
            self
        }
        /// <p>The child object reference to be attached to the object.</p>
        pub fn set_child_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_child_reference(input);
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn link_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(inp);
            self
        }
        /// <p>The link name with which the child object is attached to the parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches a policy object to a regular object. An object can have a limited number of attached
    /// policies.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl<C, M, R> AttachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPolicyInputOperationOutputAlias,
                crate::output::AttachPolicyOutput,
                crate::error::AttachPolicyError,
                crate::input::AttachPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn policy_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(inp);
            self
        }
        /// <p>The reference that is associated with the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be
        /// attached.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object to which the policy will be
        /// attached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachToIndex`.
    ///
    /// <p>Attaches the specified object to the specified index.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachToIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_to_index_input::Builder,
    }
    impl<C, M, R> AttachToIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachToIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachToIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachToIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachToIndexInputOperationOutputAlias,
                crate::output::AttachToIndexOutput,
                crate::error::AttachToIndexError,
                crate::input::AttachToIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index
        /// exist.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where the object and index
        /// exist.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn index_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(inp);
            self
        }
        /// <p>A reference to the index that you are attaching the object to.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn target_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(inp);
            self
        }
        /// <p>A reference to the object that you are attaching to the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachTypedLink`.
    ///
    /// <p>Attaches a typed link to a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachTypedLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_typed_link_input::Builder,
    }
    impl<C, M, R> AttachTypedLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachTypedLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachTypedLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachTypedLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachTypedLinkInputOperationOutputAlias,
                crate::output::AttachTypedLinkOutput,
                crate::error::AttachTypedLinkError,
                crate::input::AttachTypedLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed
        /// link.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to attach the typed
        /// link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn source_object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.source_object_reference(inp);
            self
        }
        /// <p>Identifies the source object that the typed link will attach to.</p>
        pub fn set_source_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_source_object_reference(input);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn target_object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_object_reference(inp);
            self
        }
        /// <p>Identifies the target object that the typed link will attach to.</p>
        pub fn set_target_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_object_reference(input);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn typed_link_facet(mut self, inp: crate::model::TypedLinkSchemaAndFacetName) -> Self {
            self.inner = self.inner.typed_link_facet(inp);
            self
        }
        /// <p>Identifies the typed link facet that is associated with the typed link.</p>
        pub fn set_typed_link_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_facet(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn attributes(mut self, inp: impl Into<crate::model::AttributeNameAndValue>) -> Self {
            self.inner = self.inner.attributes(inp);
            self
        }
        /// <p>A set of attributes that are associated with the typed link.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeNameAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchRead`.
    ///
    /// <p>Performs all the read operations in a batch. </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchRead<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_read_input::Builder,
    }
    impl<C, M, R> BatchRead<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchRead`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchReadOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchReadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchReadInputOperationOutputAlias,
                crate::output::BatchReadOutput,
                crate::error::BatchReadError,
                crate::input::BatchReadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `Operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, inp: impl Into<crate::model::BatchReadOperation>) -> Self {
            self.inner = self.inner.operations(inp);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchReadOperation>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchWrite`.
    ///
    /// <p>Performs all the write operations in a batch. Either all the operations succeed or
    /// none.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchWrite<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_write_input::Builder,
    }
    impl<C, M, R> BatchWrite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchWrite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchWriteOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchWriteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchWriteInputOperationOutputAlias,
                crate::output::BatchWriteOutput,
                crate::error::BatchWriteError,
                crate::input::BatchWriteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `Operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that are part of the batch.</p>
        pub fn operations(mut self, inp: impl Into<crate::model::BatchWriteOperation>) -> Self {
            self.inner = self.inner.operations(inp);
            self
        }
        /// <p>A list of operations that are part of the batch.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchWriteOperation>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectory`.
    ///
    /// <p>Creates a <a>Directory</a> by copying the published schema into the
    /// directory. A directory cannot be created without a schema.</p>
    /// <p>You can also quickly create a directory using a managed schema, called the
    /// <code>QuickStartSchema</code>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html">Managed Schema</a> in the <i>Amazon Cloud Directory Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_directory_input::Builder,
    }
    impl<C, M, R> CreateDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectoryInputOperationOutputAlias,
                crate::output::CreateDirectoryOutput,
                crate::error::CreateDirectoryError,
                crate::input::CreateDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <a>Directory</a>. Should be unique per account, per
        /// region.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <a>Directory</a>. Should be unique per account, per
        /// region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the
        /// data <a>Directory</a>. For more information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the published schema that will be copied into the
        /// data <a>Directory</a>. For more information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFacet`.
    ///
    /// <p>Creates a new <a>Facet</a> in a schema. Facet creation is allowed only
    /// in development or applied schemas.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_facet_input::Builder,
    }
    impl<C, M, R> CreateFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFacetInputOperationOutputAlias,
                crate::output::CreateFacetOutput,
                crate::error::CreateFacetError,
                crate::input::CreateFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The schema ARN in which the new <a>Facet</a> will be created. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The schema ARN in which the new <a>Facet</a> will be created. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the <a>Facet</a>, which is unique for a given schema.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <a>Facet</a>, which is unique for a given schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes that are associated with the <a>Facet</a>.</p>
        pub fn attributes(mut self, inp: impl Into<crate::model::FacetAttribute>) -> Self {
            self.inner = self.inner.attributes(inp);
            self
        }
        /// <p>The attributes that are associated with the <a>Facet</a>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node,
        /// policy or index.</p>
        /// <ul>
        /// <li>
        /// <p>Node: Can have multiple children but one parent.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Leaf node: Cannot have children but can have multiple parents.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Policy: Allows you to store a policy document and policy type. For more
        /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Index: Can be created with the Index API.</p>
        /// </li>
        /// </ul>
        pub fn object_type(mut self, inp: crate::model::ObjectType) -> Self {
            self.inner = self.inner.object_type(inp);
            self
        }
        /// <p>Specifies whether a given object created from this facet is of type node, leaf node,
        /// policy or index.</p>
        /// <ul>
        /// <li>
        /// <p>Node: Can have multiple children but one parent.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Leaf node: Cannot have children but can have multiple parents.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Policy: Allows you to store a policy document and policy type. For more
        /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Index: Can be created with the Index API.</p>
        /// </li>
        /// </ul>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.inner = self.inner.set_object_type(input);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn facet_style(mut self, inp: crate::model::FacetStyle) -> Self {
            self.inner = self.inner.facet_style(inp);
            self
        }
        /// <p>There are two different styles that you can define on any given facet, <code>Static</code> and <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations.</p>
        pub fn set_facet_style(
            mut self,
            input: std::option::Option<crate::model::FacetStyle>,
        ) -> Self {
            self.inner = self.inner.set_facet_style(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIndex`.
    ///
    /// <p>Creates an index object. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html">Indexing and search</a> for more information.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_index_input::Builder,
    }
    impl<C, M, R> CreateIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIndexInputOperationOutputAlias,
                crate::output::CreateIndexOutput,
                crate::error::CreateIndexError,
                crate::input::CreateIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory where the index should be created.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `OrderedIndexedAttributeList`.
        ///
        /// To override the contents of this collection use [`set_ordered_indexed_attribute_list`](Self::set_ordered_indexed_attribute_list).
        ///
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute
        /// is supported.</p>
        pub fn ordered_indexed_attribute_list(
            mut self,
            inp: impl Into<crate::model::AttributeKey>,
        ) -> Self {
            self.inner = self.inner.ordered_indexed_attribute_list(inp);
            self
        }
        /// <p>Specifies the attributes that should be indexed on. Currently only a single attribute
        /// is supported.</p>
        pub fn set_ordered_indexed_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKey>>,
        ) -> Self {
            self.inner = self.inner.set_ordered_indexed_attribute_list(input);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or
        /// not.</p>
        pub fn is_unique(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_unique(inp);
            self
        }
        /// <p>Indicates whether the attribute that is being indexed has unique values or
        /// not.</p>
        pub fn set_is_unique(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_unique(input);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn parent_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(inp);
            self
        }
        /// <p>A reference to the parent object that contains the index object.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn link_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(inp);
            self
        }
        /// <p>The name of the link between the parent object and the index object.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateObject`.
    ///
    /// <p>Creates an object in a <a>Directory</a>. Additionally attaches the object to
    /// a parent, if a parent reference and <code>LinkName</code> is specified. An object is simply a
    /// collection of <a>Facet</a> attributes. You can also use this API call to create a
    /// policy object, if the facet from which you create the object is a policy facet. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_object_input::Builder,
    }
    impl<C, M, R> CreateObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateObjectInputOperationOutputAlias,
                crate::output::CreateObjectOutput,
                crate::error::CreateObjectError,
                crate::input::CreateObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// in which the object will be created. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// in which the object will be created. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `SchemaFacets`.
        ///
        /// To override the contents of this collection use [`set_schema_facets`](Self::set_schema_facets).
        ///
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <a>SchemaFacet</a> for details.</p>
        pub fn schema_facets(mut self, inp: impl Into<crate::model::SchemaFacet>) -> Self {
            self.inner = self.inner.schema_facets(inp);
            self
        }
        /// <p>A list of schema facets to be associated with the object. Do not provide minor version components. See <a>SchemaFacet</a> for details.</p>
        pub fn set_schema_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaFacet>>,
        ) -> Self {
            self.inner = self.inner.set_schema_facets(input);
            self
        }
        /// Appends an item to `ObjectAttributeList`.
        ///
        /// To override the contents of this collection use [`set_object_attribute_list`](Self::set_object_attribute_list).
        ///
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map
        /// value.</p>
        pub fn object_attribute_list(
            mut self,
            inp: impl Into<crate::model::AttributeKeyAndValue>,
        ) -> Self {
            self.inner = self.inner.object_attribute_list(inp);
            self
        }
        /// <p>The attribute map whose attribute ARN contains the key and attribute value as the map
        /// value.</p>
        pub fn set_object_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeKeyAndValue>>,
        ) -> Self {
            self.inner = self.inner.set_object_attribute_list(input);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn parent_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(inp);
            self
        }
        /// <p>If specified, the parent reference to which this object will be attached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn link_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(inp);
            self
        }
        /// <p>The name of link that is used to attach this object to a parent.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchema`.
    ///
    /// <p>Creates a new schema in a development state. A schema can exist in three
    /// phases:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>Development:</i> This is a mutable phase of the schema. All new
    /// schemas are in the development phase. Once the schema is finalized, it can be
    /// published.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Published:</i> Published schemas are immutable and have a version
    /// associated with them.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Applied:</i> Applied schemas are mutable in a way that allows you
    /// to add new schema facets. You can also add new, nonrequired attributes to existing schema
    /// facets. You can apply only published schemas to directories. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_schema_input::Builder,
    }
    impl<C, M, R> CreateSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSchemaInputOperationOutputAlias,
                crate::output::CreateSchemaOutput,
                crate::error::CreateSchemaError,
                crate::input::CreateSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that is associated with the schema. This is unique to each account and in each
        /// region.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that is associated with the schema. This is unique to each account and in each
        /// region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTypedLinkFacet`.
    ///
    /// <p>Creates a <a>TypedLinkFacet</a>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTypedLinkFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_typed_link_facet_input::Builder,
    }
    impl<C, M, R> CreateTypedLinkFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTypedLinkFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTypedLinkFacetInputOperationOutputAlias,
                crate::output::CreateTypedLinkFacetOutput,
                crate::error::CreateTypedLinkFacetError,
                crate::input::CreateTypedLinkFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>
        /// <a>Facet</a> structure that is associated with the typed link
        /// facet.</p>
        pub fn facet(mut self, inp: crate::model::TypedLinkFacet) -> Self {
            self.inner = self.inner.facet(inp);
            self
        }
        /// <p>
        /// <a>Facet</a> structure that is associated with the typed link
        /// facet.</p>
        pub fn set_facet(
            mut self,
            input: std::option::Option<crate::model::TypedLinkFacet>,
        ) -> Self {
            self.inner = self.inner.set_facet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectory`.
    ///
    /// <p>Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme
    /// caution
    /// when deleting directories.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_directory_input::Builder,
    }
    impl<C, M, R> DeleteDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectoryInputOperationOutputAlias,
                crate::output::DeleteDirectoryOutput,
                crate::error::DeleteDirectoryError,
                crate::input::DeleteDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to delete.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory to delete.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFacet`.
    ///
    /// <p>Deletes a given <a>Facet</a>. All attributes and <a>Rule</a>s
    /// that are associated with the facet will be deleted. Only development schema facets are allowed
    /// deletion.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_facet_input::Builder,
    }
    impl<C, M, R> DeleteFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFacetInputOperationOutputAlias,
                crate::output::DeleteFacetOutput,
                crate::error::DeleteFacetError,
                crate::input::DeleteFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the facet to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObject`.
    ///
    /// <p>Deletes an object and its associated attributes. Only objects with no children and no
    /// parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_object_input::Builder,
    }
    impl<C, M, R> DeleteObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteObjectInputOperationOutputAlias,
                crate::output::DeleteObjectOutput,
                crate::error::DeleteObjectError,
                crate::input::DeleteObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>A reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchema`.
    ///
    /// <p>Deletes a given schema. Schemas in a development and published state can only be deleted. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schema_input::Builder,
    }
    impl<C, M, R> DeleteSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSchemaInputOperationOutputAlias,
                crate::output::DeleteSchemaOutput,
                crate::error::DeleteSchemaError,
                crate::input::DeleteSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see
        /// <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see
        /// <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTypedLinkFacet`.
    ///
    /// <p>Deletes a <a>TypedLinkFacet</a>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTypedLinkFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_typed_link_facet_input::Builder,
    }
    impl<C, M, R> DeleteTypedLinkFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTypedLinkFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTypedLinkFacetInputOperationOutputAlias,
                crate::output::DeleteTypedLinkFacetOutput,
                crate::error::DeleteTypedLinkFacetError,
                crate::input::DeleteTypedLinkFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachFromIndex`.
    ///
    /// <p>Detaches the specified object from the specified index.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachFromIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_from_index_input::Builder,
    }
    impl<C, M, R> DetachFromIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachFromIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachFromIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachFromIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachFromIndexInputOperationOutputAlias,
                crate::output::DetachFromIndexOutput,
                crate::error::DetachFromIndexError,
                crate::input::DetachFromIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist
        /// in.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory the index and object exist
        /// in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn index_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(inp);
            self
        }
        /// <p>A reference to the index object.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn target_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(inp);
            self
        }
        /// <p>A reference to the object being detached from the index.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachObject`.
    ///
    /// <p>Detaches a given object from the parent object. The object that is to be detached from the
    /// parent is specified by the link name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_object_input::Builder,
    }
    impl<C, M, R> DetachObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachObjectInputOperationOutputAlias,
                crate::output::DetachObjectOutput,
                crate::error::DetachObjectError,
                crate::input::DetachObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The parent reference from which the object with the specified link name is
        /// detached.</p>
        pub fn parent_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.parent_reference(inp);
            self
        }
        /// <p>The parent reference from which the object with the specified link name is
        /// detached.</p>
        pub fn set_parent_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_parent_reference(input);
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn link_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.link_name(inp);
            self
        }
        /// <p>The link name associated with the object that needs to be detached.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_link_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from an object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl<C, M, R> DetachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPolicyInputOperationOutputAlias,
                crate::output::DetachPolicyOutput,
                crate::error::DetachPolicyError,
                crate::input::DetachPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where both objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(inp);
            self
        }
        /// <p>Reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>Reference that identifies the object whose policy object will be detached.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachTypedLink`.
    ///
    /// <p>Detaches a typed link from a specified source and target object. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachTypedLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_typed_link_input::Builder,
    }
    impl<C, M, R> DetachTypedLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachTypedLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachTypedLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachTypedLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachTypedLinkInputOperationOutputAlias,
                crate::output::DetachTypedLinkOutput,
                crate::error::DetachTypedLinkError,
                crate::input::DetachTypedLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed
        /// link.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to detach the typed
        /// link.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn typed_link_specifier(mut self, inp: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(inp);
            self
        }
        /// <p>Used to accept a typed link specifier as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDirectory`.
    ///
    /// <p>Disables the specified directory. Disabled directories cannot be read or written to.
    /// Only enabled directories can be disabled. Disabled directories may be reenabled.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_directory_input::Builder,
    }
    impl<C, M, R> DisableDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableDirectoryInputOperationOutputAlias,
                crate::output::DisableDirectoryOutput,
                crate::error::DisableDirectoryError,
                crate::input::DisableDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to disable.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory to disable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDirectory`.
    ///
    /// <p>Enables the specified directory. Only disabled directories can be enabled. Once
    /// enabled, the directory can then be read and written to.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_directory_input::Builder,
    }
    impl<C, M, R> EnableDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableDirectoryInputOperationOutputAlias,
                crate::output::EnableDirectoryOutput,
                crate::error::EnableDirectoryError,
                crate::input::EnableDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to enable.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory to enable.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppliedSchemaVersion`.
    ///
    /// <p>Returns current applied schema version ARN, including the minor version in use.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppliedSchemaVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_applied_schema_version_input::Builder,
    }
    impl<C, M, R> GetAppliedSchemaVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppliedSchemaVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppliedSchemaVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppliedSchemaVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppliedSchemaVersionInputOperationOutputAlias,
                crate::output::GetAppliedSchemaVersionOutput,
                crate::error::GetAppliedSchemaVersionError,
                crate::input::GetAppliedSchemaVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the applied schema.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The ARN of the applied schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDirectory`.
    ///
    /// <p>Retrieves metadata about a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_directory_input::Builder,
    }
    impl<C, M, R> GetDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDirectoryInputOperationOutputAlias,
                crate::output::GetDirectoryOutput,
                crate::error::GetDirectoryError,
                crate::input::GetDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFacet`.
    ///
    /// <p>Gets details of the <a>Facet</a>, such as facet name, attributes, <a>Rule</a>s, or <code>ObjectType</code>. You can call this on all kinds of schema
    /// facets -- published, development, or applied.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_facet_input::Builder,
    }
    impl<C, M, R> GetFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFacetInputOperationOutputAlias,
                crate::output::GetFacetOutput,
                crate::error::GetFacetError,
                crate::input::GetFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the facet to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLinkAttributes`.
    ///
    /// <p>Retrieves attributes that are associated with a typed link.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLinkAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_link_attributes_input::Builder,
    }
    impl<C, M, R> GetLinkAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLinkAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLinkAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLinkAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLinkAttributesInputOperationOutputAlias,
                crate::output::GetLinkAttributesOutput,
                crate::error::GetLinkAttributesError,
                crate::input::GetLinkAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <a>arns</a> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see <a>arns</a> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, inp: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(inp);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>A list of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on a typed link.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectAttributes`.
    ///
    /// <p>Retrieves attributes within a facet that are associated with an object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetObjectAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_object_attributes_input::Builder,
    }
    impl<C, M, R> GetObjectAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetObjectAttributesInputOperationOutputAlias,
                crate::output::GetObjectAttributesOutput,
                crate::error::GetObjectAttributesError,
                crate::input::GetObjectAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be retrieved.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level at which to retrieve the attributes on an object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.</p>
        pub fn schema_facet(mut self, inp: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(inp);
            self
        }
        /// <p>Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn attribute_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>List of attribute names whose values will be retrieved.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectInformation`.
    ///
    /// <p>Retrieves metadata about an object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetObjectInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_object_information_input::Builder,
    }
    impl<C, M, R> GetObjectInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetObjectInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectInformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetObjectInformationInputOperationOutputAlias,
                crate::output::GetObjectInformationOutput,
                crate::error::GetObjectInformationError,
                crate::input::GetObjectInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory being retrieved.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>A reference to the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level at which to retrieve the object information.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaAsJson`.
    ///
    /// <p>Retrieves a JSON representation of the schema. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON Schema Format</a> for more information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchemaAsJson<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_as_json_input::Builder,
    }
    impl<C, M, R> GetSchemaAsJson<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchemaAsJson`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaAsJsonOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaAsJsonError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaAsJsonInputOperationOutputAlias,
                crate::output::GetSchemaAsJsonOutput,
                crate::error::GetSchemaAsJsonError,
                crate::input::GetSchemaAsJsonInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The ARN of the schema to retrieve.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTypedLinkFacetInformation`.
    ///
    /// <p>Returns the identity attribute order for a specific <a>TypedLinkFacet</a>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTypedLinkFacetInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_typed_link_facet_information_input::Builder,
    }
    impl<C, M, R> GetTypedLinkFacetInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTypedLinkFacetInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTypedLinkFacetInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTypedLinkFacetInformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTypedLinkFacetInformationInputOperationOutputAlias,
                crate::output::GetTypedLinkFacetInformationOutput,
                crate::error::GetTypedLinkFacetInformationError,
                crate::input::GetTypedLinkFacetInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppliedSchemaArns`.
    ///
    /// <p>Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor version.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppliedSchemaArns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applied_schema_arns_input::Builder,
    }
    impl<C, M, R> ListAppliedSchemaArns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppliedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppliedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppliedSchemaArnsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppliedSchemaArnsInputOperationOutputAlias,
                crate::output::ListAppliedSchemaArnsOutput,
                crate::error::ListAppliedSchemaArnsError,
                crate::input::ListAppliedSchemaArnsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory you are listing.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory you are listing.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The response for <code>ListAppliedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedIndices`.
    ///
    /// <p>Lists indices attached to the specified object.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttachedIndices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attached_indices_input::Builder,
    }
    impl<C, M, R> ListAttachedIndices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachedIndices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedIndicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedIndicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachedIndicesInputOperationOutputAlias,
                crate::output::ListAttachedIndicesOutput,
                crate::error::ListAttachedIndicesError,
                crate::input::ListAttachedIndicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn target_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.target_reference(inp);
            self
        }
        /// <p>A reference to the object that has indices attached.</p>
        pub fn set_target_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_target_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level to use for this operation.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevelopmentSchemaArns`.
    ///
    /// <p>Retrieves each Amazon Resource Name (ARN) of schemas in the development
    /// state.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDevelopmentSchemaArns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_development_schema_arns_input::Builder,
    }
    impl<C, M, R> ListDevelopmentSchemaArns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevelopmentSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevelopmentSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevelopmentSchemaArnsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevelopmentSchemaArnsInputOperationOutputAlias,
                crate::output::ListDevelopmentSchemaArnsOutput,
                crate::error::ListDevelopmentSchemaArnsError,
                crate::input::ListDevelopmentSchemaArnsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDirectories`.
    ///
    /// <p>Lists directories created within an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_directories_input::Builder,
    }
    impl<C, M, R> ListDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDirectoriesInputOperationOutputAlias,
                crate::output::ListDirectoriesOutput,
                crate::error::ListDirectoriesError,
                crate::input::ListDirectoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or
        /// Deleted.</p>
        pub fn state(mut self, inp: crate::model::DirectoryState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The state of the directories in the list. Can be either Enabled, Disabled, or
        /// Deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DirectoryState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFacetAttributes`.
    ///
    /// <p>Retrieves attributes attached to the facet.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFacetAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_facet_attributes_input::Builder,
    }
    impl<C, M, R> ListFacetAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFacetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacetAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacetAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFacetAttributesInputOperationOutputAlias,
                crate::output::ListFacetAttributesOutput,
                crate::error::ListFacetAttributesError,
                crate::input::ListFacetAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The ARN of the schema where the facet resides.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the facet whose attributes will be retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFacetNames`.
    ///
    /// <p>Retrieves the names of facets that exist in a schema.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFacetNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_facet_names_input::Builder,
    }
    impl<C, M, R> ListFacetNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFacetNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacetNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacetNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFacetNamesInputOperationOutputAlias,
                crate::output::ListFacetNamesOutput,
                crate::error::ListFacetNamesError,
                crate::input::ListFacetNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) to retrieve facet names from.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIncomingTypedLinks`.
    ///
    /// <p>Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a>
    /// information for an object. It also supports filtering by typed link facet and identity
    /// attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIncomingTypedLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_incoming_typed_links_input::Builder,
    }
    impl<C, M, R> ListIncomingTypedLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIncomingTypedLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIncomingTypedLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIncomingTypedLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIncomingTypedLinksInputOperationOutputAlias,
                crate::output::ListIncomingTypedLinksOutput,
                crate::error::ListIncomingTypedLinksError,
                crate::input::ListIncomingTypedLinksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed
        /// links.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed
        /// links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>Reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `FilterAttributeRanges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link
        /// selection, any inexact ranges must be specified at the end. Any attributes that do not have a
        /// range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            inp: impl Into<crate::model::TypedLinkAttributeRange>,
        ) -> Self {
            self.inner = self.inner.filter_attribute_ranges(inp);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link
        /// selection, any inexact ranges must be specified at the end. Any attributes that do not have a
        /// range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_filter_attribute_ranges(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the
        /// order in which they are supplied to any API calls.</p>
        pub fn filter_typed_link(mut self, inp: crate::model::TypedLinkSchemaAndFacetName) -> Self {
            self.inner = self.inner.filter_typed_link(inp);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes on the typed link facet, not the
        /// order in which they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_filter_typed_link(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIndex`.
    ///
    /// <p>Lists objects attached to the specified index.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_index_input::Builder,
    }
    impl<C, M, R> ListIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIndexInputOperationOutputAlias,
                crate::output::ListIndexOutput,
                crate::error::ListIndexError,
                crate::input::ListIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory that the index exists in.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// Appends an item to `RangesOnIndexedValues`.
        ///
        /// To override the contents of this collection use [`set_ranges_on_indexed_values`](Self::set_ranges_on_indexed_values).
        ///
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn ranges_on_indexed_values(
            mut self,
            inp: impl Into<crate::model::ObjectAttributeRange>,
        ) -> Self {
            self.inner = self.inner.ranges_on_indexed_values(inp);
            self
        }
        /// <p>Specifies the ranges of indexed values that you want to query.</p>
        pub fn set_ranges_on_indexed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_ranges_on_indexed_values(input);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn index_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.index_reference(inp);
            self
        }
        /// <p>The reference to the index to list.</p>
        pub fn set_index_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_index_reference(input);
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects in a single page to retrieve from the index during a request. For more information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory Limits</a>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedSchemaArns`.
    ///
    /// <p>Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListManagedSchemaArns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_schema_arns_input::Builder,
    }
    impl<C, M, R> ListManagedSchemaArns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedSchemaArnsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedSchemaArnsInputOperationOutputAlias,
                crate::output::ListManagedSchemaArnsOutput,
                crate::error::ListManagedSchemaArnsError,
                crate::input::ListManagedSchemaArnsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The response for ListManagedSchemaArns. When this parameter is used, all minor version ARNs for a major version are listed.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectAttributes`.
    ///
    /// <p>Lists all attributes that are associated with an object.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListObjectAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_object_attributes_input::Builder,
    }
    impl<C, M, R> ListObjectAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListObjectAttributesInputOperationOutputAlias,
                crate::output::ListObjectAttributesOutput,
                crate::error::ListObjectAttributesError,
                crate::input::ListObjectAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain
        /// facet.</p>
        pub fn facet_filter(mut self, inp: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.facet_filter(inp);
            self
        }
        /// <p>Used to filter the list of object attributes that are associated with a certain
        /// facet.</p>
        pub fn set_facet_filter(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_facet_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectChildren`.
    ///
    /// <p>Returns a paginated list of child objects that are associated with a given
    /// object.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListObjectChildren<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_object_children_input::Builder,
    }
    impl<C, M, R> ListObjectChildren<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListObjectChildren`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectChildrenOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectChildrenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListObjectChildrenInputOperationOutputAlias,
                crate::output::ListObjectChildrenOutput,
                crate::error::ListObjectChildrenError,
                crate::input::ListObjectChildrenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object for which child objects are being
        /// listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object for which child objects are being
        /// listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectParentPaths`.
    ///
    /// <p>Retrieves all available parent paths for any object type such as node, leaf node,
    /// policy node, and index node objects. For more information about objects, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html">Directory Structure</a>.</p>
    /// <p>Use this API to evaluate all parents for an object. The call returns all objects from
    /// the root of the directory up to the requested object. The API returns the number of paths
    /// based on user-defined <code>MaxResults</code>, in case there are multiple paths to the parent.
    /// The order of the paths and nodes returned is consistent among multiple API calls unless the
    /// objects are deleted or moved. Paths not leading to the directory root are ignored from the
    /// target object.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListObjectParentPaths<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_object_parent_paths_input::Builder,
    }
    impl<C, M, R> ListObjectParentPaths<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListObjectParentPaths`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectParentPathsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectParentPathsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListObjectParentPathsInputOperationOutputAlias,
                crate::output::ListObjectParentPathsOutput,
                crate::error::ListObjectParentPathsError,
                crate::input::ListObjectParentPathsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory to which the parent path applies.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object whose parent paths are listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectParents`.
    ///
    /// <p>Lists parent objects that are associated with a given object in pagination
    /// fashion.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListObjectParents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_object_parents_input::Builder,
    }
    impl<C, M, R> ListObjectParents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListObjectParents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectParentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectParentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListObjectParentsInputOperationOutputAlias,
                crate::output::ListObjectParentsOutput,
                crate::error::ListObjectParentsError,
                crate::input::ListObjectParentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being
        /// listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object for which parent objects are being
        /// listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
        /// <p>When set to True, returns all <a>ListObjectParentsResponse$ParentLinks</a>. There could be multiple links between a parent-child pair.</p>
        pub fn include_all_links_to_each_parent(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_all_links_to_each_parent(inp);
            self
        }
        /// <p>When set to True, returns all <a>ListObjectParentsResponse$ParentLinks</a>. There could be multiple links between a parent-child pair.</p>
        pub fn set_include_all_links_to_each_parent(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_all_links_to_each_parent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectPolicies`.
    ///
    /// <p>Returns policies attached to an object in pagination fashion.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListObjectPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_object_policies_input::Builder,
    }
    impl<C, M, R> ListObjectPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListObjectPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListObjectPoliciesInputOperationOutputAlias,
                crate::output::ListObjectPoliciesOutput,
                crate::error::ListObjectPoliciesError,
                crate::input::ListObjectPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>Reference that identifies the object for which policies will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOutgoingTypedLinks`.
    ///
    /// <p>Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a>
    /// information for an object. It also supports filtering by typed link facet and identity
    /// attributes. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOutgoingTypedLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_outgoing_typed_links_input::Builder,
    }
    impl<C, M, R> ListOutgoingTypedLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOutgoingTypedLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOutgoingTypedLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOutgoingTypedLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOutgoingTypedLinksInputOperationOutputAlias,
                crate::output::ListOutgoingTypedLinksOutput,
                crate::error::ListOutgoingTypedLinksError,
                crate::input::ListOutgoingTypedLinksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed
        /// links.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the directory where you want to list the typed
        /// links.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>A reference that identifies the object whose attributes will be listed.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `FilterAttributeRanges`.
        ///
        /// To override the contents of this collection use [`set_filter_attribute_ranges`](Self::set_filter_attribute_ranges).
        ///
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link
        /// selection, any inexact ranges must be specified at the end. Any attributes that do not have a
        /// range specified are presumed to match the entire range.</p>
        pub fn filter_attribute_ranges(
            mut self,
            inp: impl Into<crate::model::TypedLinkAttributeRange>,
        ) -> Self {
            self.inner = self.inner.filter_attribute_ranges(inp);
            self
        }
        /// <p>Provides range filters for multiple attributes. When providing ranges to typed link
        /// selection, any inexact ranges must be specified at the end. Any attributes that do not have a
        /// range specified are presumed to match the entire range.</p>
        pub fn set_filter_attribute_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkAttributeRange>>,
        ) -> Self {
            self.inner = self.inner.set_filter_attribute_ranges(input);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet,
        /// not the order they are supplied to any API calls.</p>
        pub fn filter_typed_link(mut self, inp: crate::model::TypedLinkSchemaAndFacetName) -> Self {
            self.inner = self.inner.filter_typed_link(inp);
            self
        }
        /// <p>Filters are interpreted in the order of the attributes defined on the typed link facet,
        /// not the order they are supplied to any API calls.</p>
        pub fn set_filter_typed_link(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSchemaAndFacetName>,
        ) -> Self {
            self.inner = self.inner.set_filter_typed_link(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>The consistency level to execute the request at.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyAttachments`.
    ///
    /// <p>Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicyAttachments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_attachments_input::Builder,
    }
    impl<C, M, R> ListPolicyAttachments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyAttachmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyAttachmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyAttachmentsInputOperationOutputAlias,
                crate::output::ListPolicyAttachmentsOutput,
                crate::error::ListPolicyAttachmentsError,
                crate::input::ListPolicyAttachmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where objects reside. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn policy_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.policy_reference(inp);
            self
        }
        /// <p>The reference that identifies the policy object.</p>
        pub fn set_policy_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_policy_reference(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn consistency_level(mut self, inp: crate::model::ConsistencyLevel) -> Self {
            self.inner = self.inner.consistency_level(inp);
            self
        }
        /// <p>Represents the manner and timing in which the successful write or update of an object
        /// is reflected in a subsequent read operation of that same object.</p>
        pub fn set_consistency_level(
            mut self,
            input: std::option::Option<crate::model::ConsistencyLevel>,
        ) -> Self {
            self.inner = self.inner.set_consistency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublishedSchemaArns`.
    ///
    /// <p>Lists the major version families of each published schema. If a major version ARN is provided as <code>SchemaArn</code>, the minor version revisions in that family are listed instead.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPublishedSchemaArns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_published_schema_arns_input::Builder,
    }
    impl<C, M, R> ListPublishedSchemaArns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPublishedSchemaArns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublishedSchemaArnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublishedSchemaArnsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPublishedSchemaArnsInputOperationOutputAlias,
                crate::output::ListPublishedSchemaArnsOutput,
                crate::error::ListPublishedSchemaArnsError,
                crate::input::ListPublishedSchemaArnsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The response for <code>ListPublishedSchemaArns</code> when this parameter is used will list all minor version ARNs for a major version.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns tags for a resource. Tagging is currently supported only for directories with a
    /// limit of 50 tags per directory. All 50 tags are returned for a given directory with this API
    /// call.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for
        /// tagging.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token. This is for future use. Currently pagination is not supported for
        /// tagging.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a
        /// single page. This is for future use and is not supported currently.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The <code>MaxResults</code> parameter sets the maximum number of results returned in a
        /// single page. This is for future use and is not supported currently.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypedLinkFacetAttributes`.
    ///
    /// <p>Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypedLinkFacetAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_typed_link_facet_attributes_input::Builder,
    }
    impl<C, M, R> ListTypedLinkFacetAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypedLinkFacetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypedLinkFacetAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypedLinkFacetAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypedLinkFacetAttributesInputOperationOutputAlias,
                crate::output::ListTypedLinkFacetAttributesOutput,
                crate::error::ListTypedLinkFacetAttributesError,
                crate::input::ListTypedLinkFacetAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypedLinkFacetNames`.
    ///
    /// <p>Returns a paginated list of <code>TypedLink</code> facet names for a particular schema.
    /// For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypedLinkFacetNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_typed_link_facet_names_input::Builder,
    }
    impl<C, M, R> ListTypedLinkFacetNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypedLinkFacetNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypedLinkFacetNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypedLinkFacetNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypedLinkFacetNamesInputOperationOutputAlias,
                crate::output::ListTypedLinkFacetNamesOutput,
                crate::error::ListTypedLinkFacetNamesError,
                crate::input::ListTypedLinkFacetNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LookupPolicy`.
    ///
    /// <p>Lists all policies from the root of the <a>Directory</a> to the object
    /// specified. If there are no policies present, an empty list is returned. If policies are
    /// present, and if some objects don't have the policies attached, it returns the <code>ObjectIdentifier</code>
    /// for such objects. If policies are present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and
    /// <code>policyType</code>. Paths that don't lead to the root from the target object are ignored. For more
    /// information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies">Policies</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct LookupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::lookup_policy_input::Builder,
    }
    impl<C, M, R> LookupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LookupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LookupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::LookupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LookupPolicyInputOperationOutputAlias,
                crate::output::LookupPolicyOutput,
                crate::error::LookupPolicyError,
                crate::input::LookupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>Reference that identifies the object whose policies will be looked up.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be retrieved in a single call. This is an approximate
        /// number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishSchema`.
    ///
    /// <p>Publishes a development schema with a major version and a recommended minor version.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_schema_input::Builder,
    }
    impl<C, M, R> PublishSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishSchemaInputOperationOutputAlias,
                crate::output::PublishSchemaOutput,
                crate::error::PublishSchemaError,
                crate::input::PublishSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For
        /// more information, see <a>arns</a>.</p>
        pub fn development_schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.development_schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the development schema. For
        /// more information, see <a>arns</a>.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_development_schema_arn(input);
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The major version under which the schema will be published. Schemas have both a major and minor version associated with them.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the
        /// development schema is considered.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name under which the schema will be published. If this is not provided, the
        /// development schema is considered.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSchemaFromJson`.
    ///
    /// <p>Allows a schema to be updated using JSON upload. Only available for development schemas. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON Schema Format</a> for more information.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSchemaFromJson<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_schema_from_json_input::Builder,
    }
    impl<C, M, R> PutSchemaFromJson<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSchemaFromJson`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSchemaFromJsonOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSchemaFromJsonError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSchemaFromJsonInputOperationOutputAlias,
                crate::output::PutSchemaFromJsonOutput,
                crate::error::PutSchemaFromJsonError,
                crate::input::PutSchemaFromJsonInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The ARN of the schema to update.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(inp);
            self
        }
        /// <p>The replacement JSON schema.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFacetFromObject`.
    ///
    /// <p>Removes the specified facet from the specified object.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveFacetFromObject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_facet_from_object_input::Builder,
    }
    impl<C, M, R> RemoveFacetFromObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFacetFromObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFacetFromObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFacetFromObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFacetFromObjectInputOperationOutputAlias,
                crate::output::RemoveFacetFromObjectOutput,
                crate::error::RemoveFacetFromObjectError,
                crate::input::RemoveFacetFromObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN of the directory in which the object resides.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The facet to remove. See <a>SchemaFacet</a> for details.</p>
        pub fn schema_facet(mut self, inp: crate::model::SchemaFacet) -> Self {
            self.inner = self.inner.schema_facet(inp);
            self
        }
        /// <p>The facet to remove. See <a>SchemaFacet</a> for details.</p>
        pub fn set_schema_facet(
            mut self,
            input: std::option::Option<crate::model::SchemaFacet>,
        ) -> Self {
            self.inner = self.inner.set_schema_facet(input);
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>A reference to the object to remove the facet from.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>An API operation for adding tags to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>An API operation for removing tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. Tagging is only supported for
        /// directories.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Keys of the tag that need to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFacet`.
    ///
    /// <p>Does the following:</p>
    /// <ol>
    /// <li>
    /// <p>Adds new <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p>
    /// </li>
    /// <li>
    /// <p>Updates existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p>
    /// </li>
    /// <li>
    /// <p>Deletes existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_facet_input::Builder,
    }
    impl<C, M, R> UpdateFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFacetInputOperationOutputAlias,
                crate::output::UpdateFacetOutput,
                crate::error::UpdateFacetError,
                crate::input::UpdateFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>.
        /// For more information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the facet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>List of attributes that need to be updated in a given schema <a>Facet</a>.
        /// Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update
        /// operation to perform. </p>
        pub fn attribute_updates(
            mut self,
            inp: impl Into<crate::model::FacetAttributeUpdate>,
        ) -> Self {
            self.inner = self.inner.attribute_updates(inp);
            self
        }
        /// <p>List of attributes that need to be updated in a given schema <a>Facet</a>.
        /// Each attribute is followed by <code>AttributeAction</code>, which specifies the type of update
        /// operation to perform. </p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FacetAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// <p>The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.</p>
        pub fn object_type(mut self, inp: crate::model::ObjectType) -> Self {
            self.inner = self.inner.object_type(inp);
            self
        }
        /// <p>The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.</p>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectType>,
        ) -> Self {
            self.inner = self.inner.set_object_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLinkAttributes`.
    ///
    /// <p>Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its <code>IdentityAttributeOrder</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLinkAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_link_attributes_input::Builder,
    }
    impl<C, M, R> UpdateLinkAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLinkAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLinkAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLinkAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLinkAttributesInputOperationOutputAlias,
                crate::output::UpdateLinkAttributesOutput,
                crate::error::UpdateLinkAttributesError,
                crate::input::UpdateLinkAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <a>arns</a> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see <a>arns</a> or <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn typed_link_specifier(mut self, inp: crate::model::TypedLinkSpecifier) -> Self {
            self.inner = self.inner.typed_link_specifier(inp);
            self
        }
        /// <p>Allows a typed link specifier to be accepted as input.</p>
        pub fn set_typed_link_specifier(
            mut self,
            input: std::option::Option<crate::model::TypedLinkSpecifier>,
        ) -> Self {
            self.inner = self.inner.set_typed_link_specifier(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(
            mut self,
            inp: impl Into<crate::model::LinkAttributeUpdate>,
        ) -> Self {
            self.inner = self.inner.attribute_updates(inp);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LinkAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateObjectAttributes`.
    ///
    /// <p>Updates a given object's attributes.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateObjectAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_object_attributes_input::Builder,
    }
    impl<C, M, R> UpdateObjectAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateObjectAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateObjectAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateObjectAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateObjectAttributesInputOperationOutputAlias,
                crate::output::UpdateObjectAttributesOutput,
                crate::error::UpdateObjectAttributesError,
                crate::input::UpdateObjectAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>
        /// where the object resides. For more information, see <a>arns</a>.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn object_reference(mut self, inp: crate::model::ObjectReference) -> Self {
            self.inner = self.inner.object_reference(inp);
            self
        }
        /// <p>The reference that identifies the object.</p>
        pub fn set_object_reference(
            mut self,
            input: std::option::Option<crate::model::ObjectReference>,
        ) -> Self {
            self.inner = self.inner.set_object_reference(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>The attributes update structure.</p>
        pub fn attribute_updates(
            mut self,
            inp: impl Into<crate::model::ObjectAttributeUpdate>,
        ) -> Self {
            self.inner = self.inner.attribute_updates(inp);
            self
        }
        /// <p>The attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSchema`.
    ///
    /// <p>Updates the schema name with a new name. Only development schema names can be
    /// updated.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_schema_input::Builder,
    }
    impl<C, M, R> UpdateSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSchemaInputOperationOutputAlias,
                crate::output::UpdateSchemaOutput,
                crate::error::UpdateSchemaError,
                crate::input::UpdateSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see
        /// <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the development schema. For more information, see
        /// <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The name of the schema.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTypedLinkFacet`.
    ///
    /// <p>Updates a <a>TypedLinkFacet</a>. For more information, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTypedLinkFacet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_typed_link_facet_input::Builder,
    }
    impl<C, M, R> UpdateTypedLinkFacet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTypedLinkFacet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTypedLinkFacetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTypedLinkFacetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTypedLinkFacetInputOperationOutputAlias,
                crate::output::UpdateTypedLinkFacetOutput,
                crate::error::UpdateTypedLinkFacetError,
                crate::input::UpdateTypedLinkFacetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is associated with the schema. For more
        /// information, see <a>arns</a>.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name of the typed link facet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>Attributes update structure.</p>
        pub fn attribute_updates(
            mut self,
            inp: impl Into<crate::model::TypedLinkFacetAttributeUpdate>,
        ) -> Self {
            self.inner = self.inner.attribute_updates(inp);
            self
        }
        /// <p>Attributes update structure.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TypedLinkFacetAttributeUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// Appends an item to `IdentityAttributeOrder`.
        ///
        /// To override the contents of this collection use [`set_identity_attribute_order`](Self::set_identity_attribute_order).
        ///
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
        /// links considers the order that the attributes are defined on the typed link facet.  When
        /// providing ranges to a typed link selection, any inexact ranges must be specified at the end.
        /// Any attributes that do not have a range specified are presumed to match the entire range.
        /// Filters are interpreted in the order of the attributes on the typed link facet, not the order
        /// in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn identity_attribute_order(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_attribute_order(inp);
            self
        }
        /// <p>The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed
        /// links considers the order that the attributes are defined on the typed link facet.  When
        /// providing ranges to a typed link selection, any inexact ranges must be specified at the end.
        /// Any attributes that do not have a range specified are presumed to match the entire range.
        /// Filters are interpreted in the order of the attributes on the typed link facet, not the order
        /// in which they are supplied to any API calls. For more information about identity attributes, see <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink">Typed Links</a>.</p>
        pub fn set_identity_attribute_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_attribute_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeAppliedSchema`.
    ///
    /// <p>Upgrades a single directory in-place using the <code>PublishedSchemaArn</code> with schema updates found in <code>MinorVersion</code>. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpgradeAppliedSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_applied_schema_input::Builder,
    }
    impl<C, M, R> UpgradeAppliedSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeAppliedSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeAppliedSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeAppliedSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeAppliedSchemaInputOperationOutputAlias,
                crate::output::UpgradeAppliedSchemaOutput,
                crate::error::UpgradeAppliedSchemaError,
                crate::input::UpgradeAppliedSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn published_schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(inp);
            self
        }
        /// <p>The revision of the published schema to upgrade the directory to.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn directory_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_arn(inp);
            self
        }
        /// <p>The ARN for the directory to which the upgraded schema will be applied.</p>
        pub fn set_directory_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_arn(input);
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter is optional.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradePublishedSchema`.
    ///
    /// <p>Upgrades a published schema under a new minor version revision using the current contents of <code>DevelopmentSchemaArn</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpgradePublishedSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_published_schema_input::Builder,
    }
    impl<C, M, R> UpgradePublishedSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradePublishedSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradePublishedSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradePublishedSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradePublishedSchemaInputOperationOutputAlias,
                crate::output::UpgradePublishedSchemaOutput,
                crate::error::UpgradePublishedSchemaError,
                crate::input::UpgradePublishedSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn development_schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.development_schema_arn(inp);
            self
        }
        /// <p>The ARN of the development schema with the changes used for the upgrade.</p>
        pub fn set_development_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_development_schema_arn(input);
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn published_schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.published_schema_arn(inp);
            self
        }
        /// <p>The ARN of the published schema to be upgraded.</p>
        pub fn set_published_schema_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_published_schema_arn(input);
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>Identifies the minor version of the published schema that will be created. This parameter is NOT optional.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
