// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddFacetToObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddFacetToObjectError {
    /// Kind of error that occurred.
    pub kind: AddFacetToObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddFacetToObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddFacetToObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddFacetToObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddFacetToObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AddFacetToObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddFacetToObjectError {
    fn code(&self) -> Option<&str> {
        AddFacetToObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddFacetToObjectError {
    /// Creates a new `AddFacetToObjectError`.
    pub fn new(kind: AddFacetToObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddFacetToObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddFacetToObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddFacetToObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddFacetToObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `AddFacetToObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFacetToObjectErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AddFacetToObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddFacetToObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::FacetValidationException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::ValidationException(_inner) => Some(_inner),
            AddFacetToObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplySchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplySchemaError {
    /// Kind of error that occurred.
    pub kind: ApplySchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplySchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplySchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that a schema could not be created due to a naming conflict. Please select a
    /// different name and then try again.</p>
    SchemaAlreadyExistsException(crate::error::SchemaAlreadyExistsException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplySchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplySchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::SchemaAlreadyExistsException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ApplySchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplySchemaError {
    fn code(&self) -> Option<&str> {
        ApplySchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplySchemaError {
    /// Creates a new `ApplySchemaError`.
    pub fn new(kind: ApplySchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplySchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplySchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplySchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplySchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ApplySchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ApplySchemaErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySchemaErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ApplySchemaErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::SchemaAlreadyExistsException`.
    pub fn is_schema_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySchemaErrorKind::SchemaAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `ApplySchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ApplySchemaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ApplySchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplySchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ApplySchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            ApplySchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            ApplySchemaErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            ApplySchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            ApplySchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ApplySchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ApplySchemaErrorKind::SchemaAlreadyExistsException(_inner) => Some(_inner),
            ApplySchemaErrorKind::ValidationException(_inner) => Some(_inner),
            ApplySchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachObjectError {
    /// Kind of error that occurred.
    pub kind: AttachObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
    /// name and then try again.</p>
    LinkNameAlreadyInUseException(crate::error::LinkNameAlreadyInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::LinkNameAlreadyInUseException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AttachObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachObjectError {
    fn code(&self) -> Option<&str> {
        AttachObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachObjectError {
    /// Creates a new `AttachObjectError`.
    pub fn new(kind: AttachObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AttachObjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, AttachObjectErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AttachObjectErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::LinkNameAlreadyInUseException`.
    pub fn is_link_name_already_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::LinkNameAlreadyInUseException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `AttachObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AttachObjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AttachObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            AttachObjectErrorKind::FacetValidationException(_inner) => Some(_inner),
            AttachObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            AttachObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            AttachObjectErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            AttachObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachObjectErrorKind::LinkNameAlreadyInUseException(_inner) => Some(_inner),
            AttachObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            AttachObjectErrorKind::ValidationException(_inner) => Some(_inner),
            AttachObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachPolicyErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation can only operate on policy objects.</p>
    NotPolicyException(crate::error::NotPolicyException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::NotPolicyException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachPolicyError {
    fn code(&self) -> Option<&str> {
        AttachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachPolicyError {
    /// Creates a new `AttachPolicyError`.
    pub fn new(kind: AttachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::NotPolicyException`.
    pub fn is_not_policy_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::NotPolicyException(_))
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `AttachPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AttachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachPolicyErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            AttachPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            AttachPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            AttachPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachPolicyErrorKind::NotPolicyException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachPolicyErrorKind::RetryableConflictException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            AttachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachToIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachToIndexError {
    /// Kind of error that occurred.
    pub kind: AttachToIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachToIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachToIndexErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>An object has been attempted to be attached to an object that does not have the appropriate attribute value.</p>
    IndexedAttributeMissingException(crate::error::IndexedAttributeMissingException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
    /// name and then try again.</p>
    LinkNameAlreadyInUseException(crate::error::LinkNameAlreadyInUseException),
    /// <p>Indicates that the requested operation can only operate on index objects.</p>
    NotIndexException(crate::error::NotIndexException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachToIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachToIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::IndexedAttributeMissingException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::LinkNameAlreadyInUseException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::NotIndexException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AttachToIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachToIndexError {
    fn code(&self) -> Option<&str> {
        AttachToIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachToIndexError {
    /// Creates a new `AttachToIndexError`.
    pub fn new(kind: AttachToIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachToIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachToIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachToIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachToIndexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AttachToIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::IndexedAttributeMissingException`.
    pub fn is_indexed_attribute_missing_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::IndexedAttributeMissingException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, AttachToIndexErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::LinkNameAlreadyInUseException`.
    pub fn is_link_name_already_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::LinkNameAlreadyInUseException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::NotIndexException`.
    pub fn is_not_index_exception(&self) -> bool {
        matches!(&self.kind, AttachToIndexErrorKind::NotIndexException(_))
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachToIndexErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `AttachToIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AttachToIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AttachToIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachToIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachToIndexErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            AttachToIndexErrorKind::IndexedAttributeMissingException(_inner) => Some(_inner),
            AttachToIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            AttachToIndexErrorKind::InvalidArnException(_inner) => Some(_inner),
            AttachToIndexErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            AttachToIndexErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachToIndexErrorKind::LinkNameAlreadyInUseException(_inner) => Some(_inner),
            AttachToIndexErrorKind::NotIndexException(_inner) => Some(_inner),
            AttachToIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachToIndexErrorKind::RetryableConflictException(_inner) => Some(_inner),
            AttachToIndexErrorKind::ValidationException(_inner) => Some(_inner),
            AttachToIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachTypedLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachTypedLinkError {
    /// Kind of error that occurred.
    pub kind: AttachTypedLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachTypedLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachTypedLinkErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachTypedLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachTypedLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AttachTypedLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachTypedLinkError {
    fn code(&self) -> Option<&str> {
        AttachTypedLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachTypedLinkError {
    /// Creates a new `AttachTypedLinkError`.
    pub fn new(kind: AttachTypedLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachTypedLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachTypedLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachTypedLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachTypedLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, AttachTypedLinkErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachTypedLinkErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `AttachTypedLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AttachTypedLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AttachTypedLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachTypedLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::FacetValidationException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::InternalServiceException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::InvalidArnException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::RetryableConflictException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::ValidationException(_inner) => Some(_inner),
            AttachTypedLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchRead` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchReadError {
    /// Kind of error that occurred.
    pub kind: BatchReadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchRead` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchReadErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchReadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchReadErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchReadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchReadError {
    fn code(&self) -> Option<&str> {
        BatchReadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchReadError {
    /// Creates a new `BatchReadError`.
    pub fn new(kind: BatchReadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchReadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchReadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchReadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchReadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchReadErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, BatchReadErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `BatchReadErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchReadErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `BatchReadErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, BatchReadErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `BatchReadErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, BatchReadErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `BatchReadErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, BatchReadErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `BatchReadErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchReadErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `BatchReadErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, BatchReadErrorKind::ValidationException(_))
    }
}
impl std::error::Error for BatchReadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchReadErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchReadErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            BatchReadErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchReadErrorKind::InvalidArnException(_inner) => Some(_inner),
            BatchReadErrorKind::LimitExceededException(_inner) => Some(_inner),
            BatchReadErrorKind::RetryableConflictException(_inner) => Some(_inner),
            BatchReadErrorKind::ValidationException(_inner) => Some(_inner),
            BatchReadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchWrite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchWriteError {
    /// Kind of error that occurred.
    pub kind: BatchWriteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchWrite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchWriteErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A <code>BatchWrite</code> exception has occurred.</p>
    BatchWriteException(crate::error::BatchWriteException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchWriteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchWriteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::BatchWriteException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchWriteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchWriteError {
    fn code(&self) -> Option<&str> {
        BatchWriteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchWriteError {
    /// Creates a new `BatchWriteError`.
    pub fn new(kind: BatchWriteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchWriteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchWriteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchWriteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchWriteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::BatchWriteException`.
    pub fn is_batch_write_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::BatchWriteException(_))
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `BatchWriteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, BatchWriteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for BatchWriteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchWriteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchWriteErrorKind::BatchWriteException(_inner) => Some(_inner),
            BatchWriteErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            BatchWriteErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchWriteErrorKind::InvalidArnException(_inner) => Some(_inner),
            BatchWriteErrorKind::LimitExceededException(_inner) => Some(_inner),
            BatchWriteErrorKind::RetryableConflictException(_inner) => Some(_inner),
            BatchWriteErrorKind::ValidationException(_inner) => Some(_inner),
            BatchWriteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectoryError {
    /// Kind of error that occurred.
    pub kind: CreateDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectoryErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates that a <a>Directory</a> could not be created due to a naming
    /// conflict. Choose a different name and try again.</p>
    DirectoryAlreadyExistsException(crate::error::DirectoryAlreadyExistsException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::DirectoryAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDirectoryError {
    fn code(&self) -> Option<&str> {
        CreateDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectoryError {
    /// Creates a new `CreateDirectoryError`.
    pub fn new(kind: CreateDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::DirectoryAlreadyExistsException`.
    pub fn is_directory_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::DirectoryAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateDirectoryErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDirectoryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::DirectoryAlreadyExistsException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFacetError {
    /// Kind of error that occurred.
    pub kind: CreateFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A facet with the same name already exists.</p>
    FacetAlreadyExistsException(crate::error::FacetAlreadyExistsException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
    InvalidRuleException(crate::error::InvalidRuleException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::FacetAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::InvalidRuleException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFacetError {
    fn code(&self) -> Option<&str> {
        CreateFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFacetError {
    /// Creates a new `CreateFacetError`.
    pub fn new(kind: CreateFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateFacetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::FacetAlreadyExistsException`.
    pub fn is_facet_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFacetErrorKind::FacetAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFacetErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateFacetErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::InvalidRuleException`.
    pub fn is_invalid_rule_exception(&self) -> bool {
        matches!(&self.kind, CreateFacetErrorKind::InvalidRuleException(_))
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateFacetErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFacetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFacetErrorKind::FacetAlreadyExistsException(_inner) => Some(_inner),
            CreateFacetErrorKind::FacetValidationException(_inner) => Some(_inner),
            CreateFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateFacetErrorKind::InvalidRuleException(_inner) => Some(_inner),
            CreateFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateFacetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIndexError {
    /// Kind of error that occurred.
    pub kind: CreateIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIndexErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
    /// name and then try again.</p>
    LinkNameAlreadyInUseException(crate::error::LinkNameAlreadyInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that the requested index type is not supported.</p>
    UnsupportedIndexTypeException(crate::error::UnsupportedIndexTypeException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::LinkNameAlreadyInUseException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::UnsupportedIndexTypeException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIndexError {
    fn code(&self) -> Option<&str> {
        CreateIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIndexError {
    /// Creates a new `CreateIndexError`.
    pub fn new(kind: CreateIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIndexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::LinkNameAlreadyInUseException`.
    pub fn is_link_name_already_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::LinkNameAlreadyInUseException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::UnsupportedIndexTypeException`.
    pub fn is_unsupported_index_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::UnsupportedIndexTypeException(_)
        )
    }
    /// Returns true if the error kind is `CreateIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIndexErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            CreateIndexErrorKind::FacetValidationException(_inner) => Some(_inner),
            CreateIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateIndexErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateIndexErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateIndexErrorKind::LinkNameAlreadyInUseException(_inner) => Some(_inner),
            CreateIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateIndexErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateIndexErrorKind::UnsupportedIndexTypeException(_inner) => Some(_inner),
            CreateIndexErrorKind::ValidationException(_inner) => Some(_inner),
            CreateIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateObjectError {
    /// Kind of error that occurred.
    pub kind: CreateObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
    /// name and then try again.</p>
    LinkNameAlreadyInUseException(crate::error::LinkNameAlreadyInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that the requested index type is not supported.</p>
    UnsupportedIndexTypeException(crate::error::UnsupportedIndexTypeException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::LinkNameAlreadyInUseException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::UnsupportedIndexTypeException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateObjectError {
    fn code(&self) -> Option<&str> {
        CreateObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateObjectError {
    /// Creates a new `CreateObjectError`.
    pub fn new(kind: CreateObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateObjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateObjectErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateObjectErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::LinkNameAlreadyInUseException`.
    pub fn is_link_name_already_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::LinkNameAlreadyInUseException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::UnsupportedIndexTypeException`.
    pub fn is_unsupported_index_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateObjectErrorKind::UnsupportedIndexTypeException(_)
        )
    }
    /// Returns true if the error kind is `CreateObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateObjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            CreateObjectErrorKind::FacetValidationException(_inner) => Some(_inner),
            CreateObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateObjectErrorKind::LinkNameAlreadyInUseException(_inner) => Some(_inner),
            CreateObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateObjectErrorKind::UnsupportedIndexTypeException(_inner) => Some(_inner),
            CreateObjectErrorKind::ValidationException(_inner) => Some(_inner),
            CreateObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSchemaError {
    /// Kind of error that occurred.
    pub kind: CreateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that a schema could not be created due to a naming conflict. Please select a
    /// different name and then try again.</p>
    SchemaAlreadyExistsException(crate::error::SchemaAlreadyExistsException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::SchemaAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSchemaError {
    fn code(&self) -> Option<&str> {
        CreateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSchemaError {
    /// Creates a new `CreateSchemaError`.
    pub fn new(kind: CreateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::SchemaAlreadyExistsException`.
    pub fn is_schema_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::SchemaAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateSchemaErrorKind::SchemaAlreadyExistsException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTypedLinkFacetError {
    /// Kind of error that occurred.
    pub kind: CreateTypedLinkFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTypedLinkFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A facet with the same name already exists.</p>
    FacetAlreadyExistsException(crate::error::FacetAlreadyExistsException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
    InvalidRuleException(crate::error::InvalidRuleException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTypedLinkFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTypedLinkFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::FacetAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::InvalidRuleException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateTypedLinkFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTypedLinkFacetError {
    fn code(&self) -> Option<&str> {
        CreateTypedLinkFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTypedLinkFacetError {
    /// Creates a new `CreateTypedLinkFacetError`.
    pub fn new(kind: CreateTypedLinkFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTypedLinkFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTypedLinkFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTypedLinkFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTypedLinkFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::FacetAlreadyExistsException`.
    pub fn is_facet_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::FacetAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::InvalidRuleException`.
    pub fn is_invalid_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::InvalidRuleException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypedLinkFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypedLinkFacetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateTypedLinkFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTypedLinkFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::FacetAlreadyExistsException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::FacetValidationException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::InvalidRuleException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateTypedLinkFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectoryError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectoryErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A directory that has been deleted and to which access has been attempted. Note: The
    /// requested resource will eventually cease to exist.</p>
    DirectoryDeletedException(crate::error::DirectoryDeletedException),
    /// <p>An operation can only operate on a disabled directory.</p>
    DirectoryNotDisabledException(crate::error::DirectoryNotDisabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::DirectoryDeletedException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::DirectoryNotDisabledException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDirectoryError {
    fn code(&self) -> Option<&str> {
        DeleteDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectoryError {
    /// Creates a new `DeleteDirectoryError`.
    pub fn new(kind: DeleteDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::DirectoryDeletedException`.
    pub fn is_directory_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::DirectoryDeletedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::DirectoryNotDisabledException`.
    pub fn is_directory_not_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::DirectoryNotDisabledException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DeleteDirectoryErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDirectoryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::DirectoryDeletedException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::DirectoryNotDisabledException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFacetError {
    /// Kind of error that occurred.
    pub kind: DeleteFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Occurs when deleting a facet that contains an attribute that is a target to an
    /// attribute reference in a different facet.</p>
    FacetInUseException(crate::error::FacetInUseException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::FacetInUseException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFacetError {
    fn code(&self) -> Option<&str> {
        DeleteFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFacetError {
    /// Creates a new `DeleteFacetError`.
    pub fn new(kind: DeleteFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::FacetInUseException`.
    pub fn is_facet_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::FacetInUseException(_))
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::FacetNotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFacetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFacetErrorKind::FacetInUseException(_inner) => Some(_inner),
            DeleteFacetErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            DeleteFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DeleteFacetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteObjectError {
    /// Kind of error that occurred.
    pub kind: DeleteObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation cannot be completed because the object has not
    /// been detached from the tree.</p>
    ObjectNotDetachedException(crate::error::ObjectNotDetachedException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::ObjectNotDetachedException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteObjectError {
    fn code(&self) -> Option<&str> {
        DeleteObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteObjectError {
    /// Creates a new `DeleteObjectError`.
    pub fn new(kind: DeleteObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteObjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DeleteObjectErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteObjectErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::ObjectNotDetachedException`.
    pub fn is_object_not_detached_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteObjectErrorKind::ObjectNotDetachedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteObjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            DeleteObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteObjectErrorKind::ObjectNotDetachedException(_inner) => Some(_inner),
            DeleteObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DeleteObjectErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>The object could not be deleted because links still exist. Remove the links and then
    /// try the operation again.</p>
    StillContainsLinksException(crate::error::StillContainsLinksException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::StillContainsLinksException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaError {
    /// Creates a new `DeleteSchemaError`.
    pub fn new(kind: DeleteSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::StillContainsLinksException`.
    pub fn is_still_contains_links_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::StillContainsLinksException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::StillContainsLinksException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTypedLinkFacetError {
    /// Kind of error that occurred.
    pub kind: DeleteTypedLinkFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTypedLinkFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTypedLinkFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTypedLinkFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteTypedLinkFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTypedLinkFacetError {
    fn code(&self) -> Option<&str> {
        DeleteTypedLinkFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTypedLinkFacetError {
    /// Creates a new `DeleteTypedLinkFacetError`.
    pub fn new(kind: DeleteTypedLinkFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTypedLinkFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTypedLinkFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTypedLinkFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTypedLinkFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::FacetNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypedLinkFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypedLinkFacetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteTypedLinkFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTypedLinkFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteTypedLinkFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachFromIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachFromIndexError {
    /// Kind of error that occurred.
    pub kind: DetachFromIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachFromIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachFromIndexErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation can only operate on index objects.</p>
    NotIndexException(crate::error::NotIndexException),
    /// <p>Indicates that the object is not attached to the index.</p>
    ObjectAlreadyDetachedException(crate::error::ObjectAlreadyDetachedException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachFromIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachFromIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::NotIndexException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::ObjectAlreadyDetachedException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DetachFromIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachFromIndexError {
    fn code(&self) -> Option<&str> {
        DetachFromIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachFromIndexError {
    /// Creates a new `DetachFromIndexError`.
    pub fn new(kind: DetachFromIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachFromIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachFromIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachFromIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachFromIndexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DetachFromIndexErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::NotIndexException`.
    pub fn is_not_index_exception(&self) -> bool {
        matches!(&self.kind, DetachFromIndexErrorKind::NotIndexException(_))
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::ObjectAlreadyDetachedException`.
    pub fn is_object_already_detached_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::ObjectAlreadyDetachedException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachFromIndexErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DetachFromIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DetachFromIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DetachFromIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachFromIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::InvalidArnException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::NotIndexException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::ObjectAlreadyDetachedException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::ValidationException(_inner) => Some(_inner),
            DetachFromIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachObjectError {
    /// Kind of error that occurred.
    pub kind: DetachObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when any invalid operations are performed on an object that is not a node, such
    /// as calling <code>ListObjectChildren</code> for a leaf node object.</p>
    NotNodeException(crate::error::NotNodeException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::NotNodeException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DetachObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachObjectError {
    fn code(&self) -> Option<&str> {
        DetachObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachObjectError {
    /// Creates a new `DetachObjectError`.
    pub fn new(kind: DetachObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DetachObjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DetachObjectErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DetachObjectErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::NotNodeException`.
    pub fn is_not_node_exception(&self) -> bool {
        matches!(&self.kind, DetachObjectErrorKind::NotNodeException(_))
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DetachObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DetachObjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DetachObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            DetachObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            DetachObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            DetachObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachObjectErrorKind::NotNodeException(_inner) => Some(_inner),
            DetachObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DetachObjectErrorKind::ValidationException(_inner) => Some(_inner),
            DetachObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachPolicyErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation can only operate on policy objects.</p>
    NotPolicyException(crate::error::NotPolicyException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::NotPolicyException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachPolicyError {
    fn code(&self) -> Option<&str> {
        DetachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachPolicyError {
    /// Creates a new `DetachPolicyError`.
    pub fn new(kind: DetachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::NotPolicyException`.
    pub fn is_not_policy_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::NotPolicyException(_))
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DetachPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DetachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachPolicyErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            DetachPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            DetachPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            DetachPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachPolicyErrorKind::NotPolicyException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachPolicyErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DetachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachTypedLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachTypedLinkError {
    /// Kind of error that occurred.
    pub kind: DetachTypedLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachTypedLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachTypedLinkErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachTypedLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachTypedLinkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DetachTypedLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachTypedLinkError {
    fn code(&self) -> Option<&str> {
        DetachTypedLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachTypedLinkError {
    /// Creates a new `DetachTypedLinkError`.
    pub fn new(kind: DetachTypedLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachTypedLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachTypedLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachTypedLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachTypedLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DetachTypedLinkErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachTypedLinkErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DetachTypedLinkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DetachTypedLinkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DetachTypedLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachTypedLinkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::FacetValidationException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::InternalServiceException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::InvalidArnException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::ValidationException(_inner) => Some(_inner),
            DetachTypedLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableDirectoryError {
    /// Kind of error that occurred.
    pub kind: DisableDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableDirectoryErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A directory that has been deleted and to which access has been attempted. Note: The
    /// requested resource will eventually cease to exist.</p>
    DirectoryDeletedException(crate::error::DirectoryDeletedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::DirectoryDeletedException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableDirectoryError {
    fn code(&self) -> Option<&str> {
        DisableDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableDirectoryError {
    /// Creates a new `DisableDirectoryError`.
    pub fn new(kind: DisableDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::DirectoryDeletedException`.
    pub fn is_directory_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::DirectoryDeletedException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `DisableDirectoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDirectoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisableDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::DirectoryDeletedException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::InvalidArnException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::RetryableConflictException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::ValidationException(_inner) => Some(_inner),
            DisableDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableDirectoryError {
    /// Kind of error that occurred.
    pub kind: EnableDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableDirectoryErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A directory that has been deleted and to which access has been attempted. Note: The
    /// requested resource will eventually cease to exist.</p>
    DirectoryDeletedException(crate::error::DirectoryDeletedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::DirectoryDeletedException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableDirectoryError {
    fn code(&self) -> Option<&str> {
        EnableDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableDirectoryError {
    /// Creates a new `EnableDirectoryError`.
    pub fn new(kind: EnableDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::DirectoryDeletedException`.
    pub fn is_directory_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::DirectoryDeletedException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, EnableDirectoryErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDirectoryErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `EnableDirectoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EnableDirectoryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EnableDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::DirectoryDeletedException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::InternalServiceException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::InvalidArnException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::RetryableConflictException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::ValidationException(_inner) => Some(_inner),
            EnableDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppliedSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppliedSchemaVersionError {
    /// Kind of error that occurred.
    pub kind: GetAppliedSchemaVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppliedSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppliedSchemaVersionErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppliedSchemaVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppliedSchemaVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAppliedSchemaVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppliedSchemaVersionError {
    fn code(&self) -> Option<&str> {
        GetAppliedSchemaVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppliedSchemaVersionError {
    /// Creates a new `GetAppliedSchemaVersionError`.
    pub fn new(kind: GetAppliedSchemaVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppliedSchemaVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppliedSchemaVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppliedSchemaVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppliedSchemaVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetAppliedSchemaVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppliedSchemaVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAppliedSchemaVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppliedSchemaVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetAppliedSchemaVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDirectoryError {
    /// Kind of error that occurred.
    pub kind: GetDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDirectoryErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDirectoryError {
    fn code(&self) -> Option<&str> {
        GetDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDirectoryError {
    /// Creates a new `GetDirectoryError`.
    pub fn new(kind: GetDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDirectoryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDirectoryErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetDirectoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDirectoryErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDirectoryErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetDirectoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDirectoryErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetDirectoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFacetError {
    /// Kind of error that occurred.
    pub kind: GetFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFacetError {
    fn code(&self) -> Option<&str> {
        GetFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFacetError {
    /// Creates a new `GetFacetError`.
    pub fn new(kind: GetFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::FacetNotFoundException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::RetryableConflictException(_))
    }
    /// Returns true if the error kind is `GetFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetFacetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFacetErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            GetFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetFacetErrorKind::ValidationException(_inner) => Some(_inner),
            GetFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLinkAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLinkAttributesError {
    /// Kind of error that occurred.
    pub kind: GetLinkAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLinkAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLinkAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLinkAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLinkAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLinkAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLinkAttributesError {
    fn code(&self) -> Option<&str> {
        GetLinkAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLinkAttributesError {
    /// Creates a new `GetLinkAttributesError`.
    pub fn new(kind: GetLinkAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLinkAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLinkAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLinkAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLinkAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetLinkAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLinkAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLinkAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLinkAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::FacetValidationException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            GetLinkAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetObjectAttributesError {
    /// Kind of error that occurred.
    pub kind: GetObjectAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetObjectAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetObjectAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetObjectAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetObjectAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetObjectAttributesError {
    fn code(&self) -> Option<&str> {
        GetObjectAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetObjectAttributesError {
    /// Creates a new `GetObjectAttributesError`.
    pub fn new(kind: GetObjectAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetObjectAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetObjectAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetObjectAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetObjectAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetObjectAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetObjectAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::FacetValidationException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            GetObjectAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetObjectInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetObjectInformationError {
    /// Kind of error that occurred.
    pub kind: GetObjectInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetObjectInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetObjectInformationErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetObjectInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetObjectInformationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetObjectInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetObjectInformationError {
    fn code(&self) -> Option<&str> {
        GetObjectInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetObjectInformationError {
    /// Creates a new `GetObjectInformationError`.
    pub fn new(kind: GetObjectInformationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetObjectInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetObjectInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetObjectInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetObjectInformationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetObjectInformationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetObjectInformationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetObjectInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetObjectInformationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::ValidationException(_inner) => Some(_inner),
            GetObjectInformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchemaAsJson` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaAsJsonError {
    /// Kind of error that occurred.
    pub kind: GetSchemaAsJsonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchemaAsJson` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaAsJsonErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaAsJsonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaAsJsonErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSchemaAsJsonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaAsJsonError {
    fn code(&self) -> Option<&str> {
        GetSchemaAsJsonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaAsJsonError {
    /// Creates a new `GetSchemaAsJsonError`.
    pub fn new(kind: GetSchemaAsJsonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaAsJsonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaAsJsonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaAsJsonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaAsJsonErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaAsJsonErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaAsJsonErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaAsJsonErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaAsJsonErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaAsJsonErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaAsJsonErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaAsJsonErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaAsJsonErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetSchemaAsJsonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaAsJsonErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::RetryableConflictException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::ValidationException(_inner) => Some(_inner),
            GetSchemaAsJsonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTypedLinkFacetInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTypedLinkFacetInformationError {
    /// Kind of error that occurred.
    pub kind: GetTypedLinkFacetInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTypedLinkFacetInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTypedLinkFacetInformationErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTypedLinkFacetInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTypedLinkFacetInformationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTypedLinkFacetInformationErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            GetTypedLinkFacetInformationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetTypedLinkFacetInformationErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetTypedLinkFacetInformationErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetTypedLinkFacetInformationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetTypedLinkFacetInformationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetTypedLinkFacetInformationErrorKind::RetryableConflictException(_inner) => {
                _inner.fmt(f)
            }
            GetTypedLinkFacetInformationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTypedLinkFacetInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTypedLinkFacetInformationError {
    fn code(&self) -> Option<&str> {
        GetTypedLinkFacetInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTypedLinkFacetInformationError {
    /// Creates a new `GetTypedLinkFacetInformationError`.
    pub fn new(kind: GetTypedLinkFacetInformationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTypedLinkFacetInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTypedLinkFacetInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTypedLinkFacetInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTypedLinkFacetInformationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::FacetNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetTypedLinkFacetInformationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypedLinkFacetInformationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTypedLinkFacetInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTypedLinkFacetInformationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetTypedLinkFacetInformationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetTypedLinkFacetInformationErrorKind::RetryableConflictException(_inner) => {
                Some(_inner)
            }
            GetTypedLinkFacetInformationErrorKind::ValidationException(_inner) => Some(_inner),
            GetTypedLinkFacetInformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAppliedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppliedSchemaArnsError {
    /// Kind of error that occurred.
    pub kind: ListAppliedSchemaArnsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAppliedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppliedSchemaArnsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppliedSchemaArnsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppliedSchemaArnsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAppliedSchemaArnsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppliedSchemaArnsError {
    fn code(&self) -> Option<&str> {
        ListAppliedSchemaArnsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppliedSchemaArnsError {
    /// Creates a new `ListAppliedSchemaArnsError`.
    pub fn new(kind: ListAppliedSchemaArnsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppliedSchemaArnsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppliedSchemaArnsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppliedSchemaArnsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppliedSchemaArnsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListAppliedSchemaArnsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppliedSchemaArnsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAppliedSchemaArnsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppliedSchemaArnsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAppliedSchemaArnsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachedIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachedIndicesError {
    /// Kind of error that occurred.
    pub kind: ListAttachedIndicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachedIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachedIndicesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachedIndicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachedIndicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAttachedIndicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachedIndicesError {
    fn code(&self) -> Option<&str> {
        ListAttachedIndicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachedIndicesError {
    /// Creates a new `ListAttachedIndicesError`.
    pub fn new(kind: ListAttachedIndicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachedIndicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachedIndicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachedIndicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachedIndicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListAttachedIndicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedIndicesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAttachedIndicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachedIndicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListAttachedIndicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevelopmentSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevelopmentSchemaArnsError {
    /// Kind of error that occurred.
    pub kind: ListDevelopmentSchemaArnsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevelopmentSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevelopmentSchemaArnsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevelopmentSchemaArnsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevelopmentSchemaArnsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDevelopmentSchemaArnsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevelopmentSchemaArnsError {
    fn code(&self) -> Option<&str> {
        ListDevelopmentSchemaArnsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevelopmentSchemaArnsError {
    /// Creates a new `ListDevelopmentSchemaArnsError`.
    pub fn new(kind: ListDevelopmentSchemaArnsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevelopmentSchemaArnsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevelopmentSchemaArnsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevelopmentSchemaArnsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevelopmentSchemaArnsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListDevelopmentSchemaArnsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevelopmentSchemaArnsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDevelopmentSchemaArnsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevelopmentSchemaArnsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDevelopmentSchemaArnsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDirectoriesError {
    /// Kind of error that occurred.
    pub kind: ListDirectoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDirectoriesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDirectoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDirectoriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDirectoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDirectoriesError {
    fn code(&self) -> Option<&str> {
        ListDirectoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDirectoriesError {
    /// Creates a new `ListDirectoriesError`.
    pub fn new(kind: ListDirectoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDirectoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDirectoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDirectoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDirectoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDirectoriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDirectoriesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListDirectoriesErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDirectoriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDirectoriesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDirectoriesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListDirectoriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDirectoriesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDirectoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDirectoriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDirectoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFacetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFacetAttributesError {
    /// Kind of error that occurred.
    pub kind: ListFacetAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFacetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFacetAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFacetAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFacetAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFacetAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFacetAttributesError {
    fn code(&self) -> Option<&str> {
        ListFacetAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFacetAttributesError {
    /// Creates a new `ListFacetAttributesError`.
    pub fn new(kind: ListFacetAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFacetAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFacetAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFacetAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFacetAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::FacetNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFacetAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFacetAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            ListFacetAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFacetNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFacetNamesError {
    /// Kind of error that occurred.
    pub kind: ListFacetNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFacetNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFacetNamesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFacetNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFacetNamesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFacetNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFacetNamesError {
    fn code(&self) -> Option<&str> {
        ListFacetNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFacetNamesError {
    /// Creates a new `ListFacetNamesError`.
    pub fn new(kind: ListFacetNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFacetNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFacetNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFacetNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFacetNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListFacetNamesErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFacetNamesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListFacetNamesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFacetNamesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFacetNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFacetNamesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::ValidationException(_inner) => Some(_inner),
            ListFacetNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIncomingTypedLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIncomingTypedLinksError {
    /// Kind of error that occurred.
    pub kind: ListIncomingTypedLinksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIncomingTypedLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIncomingTypedLinksErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIncomingTypedLinksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIncomingTypedLinksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIncomingTypedLinksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIncomingTypedLinksError {
    fn code(&self) -> Option<&str> {
        ListIncomingTypedLinksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIncomingTypedLinksError {
    /// Creates a new `ListIncomingTypedLinksError`.
    pub fn new(kind: ListIncomingTypedLinksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIncomingTypedLinksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIncomingTypedLinksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIncomingTypedLinksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIncomingTypedLinksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListIncomingTypedLinksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIncomingTypedLinksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListIncomingTypedLinksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIncomingTypedLinksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::FacetValidationException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::ValidationException(_inner) => Some(_inner),
            ListIncomingTypedLinksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIndexError {
    /// Kind of error that occurred.
    pub kind: ListIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIndexErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation can only operate on index objects.</p>
    NotIndexException(crate::error::NotIndexException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::NotIndexException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIndexError {
    fn code(&self) -> Option<&str> {
        ListIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIndexError {
    /// Creates a new `ListIndexError`.
    pub fn new(kind: ListIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIndexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIndexErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListIndexErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::FacetValidationException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::InvalidNextTokenException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::NotIndexException`.
    pub fn is_not_index_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::NotIndexException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `ListIndexErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIndexErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIndexErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListIndexErrorKind::FacetValidationException(_inner) => Some(_inner),
            ListIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListIndexErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListIndexErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListIndexErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListIndexErrorKind::NotIndexException(_inner) => Some(_inner),
            ListIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIndexErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListIndexErrorKind::ValidationException(_inner) => Some(_inner),
            ListIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListManagedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListManagedSchemaArnsError {
    /// Kind of error that occurred.
    pub kind: ListManagedSchemaArnsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListManagedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListManagedSchemaArnsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListManagedSchemaArnsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListManagedSchemaArnsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListManagedSchemaArnsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListManagedSchemaArnsError {
    fn code(&self) -> Option<&str> {
        ListManagedSchemaArnsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListManagedSchemaArnsError {
    /// Creates a new `ListManagedSchemaArnsError`.
    pub fn new(kind: ListManagedSchemaArnsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListManagedSchemaArnsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListManagedSchemaArnsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListManagedSchemaArnsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListManagedSchemaArnsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListManagedSchemaArnsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedSchemaArnsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListManagedSchemaArnsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListManagedSchemaArnsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::ValidationException(_inner) => Some(_inner),
            ListManagedSchemaArnsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListObjectAttributesError {
    /// Kind of error that occurred.
    pub kind: ListObjectAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListObjectAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListObjectAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListObjectAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListObjectAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListObjectAttributesError {
    fn code(&self) -> Option<&str> {
        ListObjectAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListObjectAttributesError {
    /// Creates a new `ListObjectAttributesError`.
    pub fn new(kind: ListObjectAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListObjectAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListObjectAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListObjectAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListObjectAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListObjectAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListObjectAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::FacetValidationException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            ListObjectAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListObjectChildren` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListObjectChildrenError {
    /// Kind of error that occurred.
    pub kind: ListObjectChildrenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListObjectChildren` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListObjectChildrenErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when any invalid operations are performed on an object that is not a node, such
    /// as calling <code>ListObjectChildren</code> for a leaf node object.</p>
    NotNodeException(crate::error::NotNodeException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListObjectChildrenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListObjectChildrenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::NotNodeException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListObjectChildrenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListObjectChildrenError {
    fn code(&self) -> Option<&str> {
        ListObjectChildrenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListObjectChildrenError {
    /// Creates a new `ListObjectChildrenError`.
    pub fn new(kind: ListObjectChildrenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListObjectChildrenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListObjectChildrenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListObjectChildrenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListObjectChildrenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::NotNodeException`.
    pub fn is_not_node_exception(&self) -> bool {
        matches!(&self.kind, ListObjectChildrenErrorKind::NotNodeException(_))
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectChildrenErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectChildrenErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListObjectChildrenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListObjectChildrenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::NotNodeException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::ValidationException(_inner) => Some(_inner),
            ListObjectChildrenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListObjectParentPaths` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListObjectParentPathsError {
    /// Kind of error that occurred.
    pub kind: ListObjectParentPathsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListObjectParentPaths` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListObjectParentPathsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListObjectParentPathsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListObjectParentPathsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListObjectParentPathsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListObjectParentPathsError {
    fn code(&self) -> Option<&str> {
        ListObjectParentPathsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListObjectParentPathsError {
    /// Creates a new `ListObjectParentPathsError`.
    pub fn new(kind: ListObjectParentPathsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListObjectParentPathsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListObjectParentPathsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListObjectParentPathsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListObjectParentPathsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentPathsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentPathsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListObjectParentPathsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListObjectParentPathsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::ValidationException(_inner) => Some(_inner),
            ListObjectParentPathsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListObjectParents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListObjectParentsError {
    /// Kind of error that occurred.
    pub kind: ListObjectParentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListObjectParents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListObjectParentsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Cannot list the parents of a <a>Directory</a> root.</p>
    CannotListParentOfRootException(crate::error::CannotListParentOfRootException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListObjectParentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListObjectParentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::CannotListParentOfRootException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListObjectParentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListObjectParentsError {
    fn code(&self) -> Option<&str> {
        ListObjectParentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListObjectParentsError {
    /// Creates a new `ListObjectParentsError`.
    pub fn new(kind: ListObjectParentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListObjectParentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListObjectParentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListObjectParentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListObjectParentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::CannotListParentOfRootException`.
    pub fn is_cannot_list_parent_of_root_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::CannotListParentOfRootException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectParentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectParentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListObjectParentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListObjectParentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::CannotListParentOfRootException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListObjectParentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListObjectPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListObjectPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListObjectPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListObjectPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListObjectPoliciesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListObjectPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListObjectPoliciesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListObjectPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListObjectPoliciesError {
    fn code(&self) -> Option<&str> {
        ListObjectPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListObjectPoliciesError {
    /// Creates a new `ListObjectPoliciesError`.
    pub fn new(kind: ListObjectPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListObjectPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListObjectPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListObjectPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListObjectPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListObjectPoliciesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListObjectPoliciesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListObjectPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListObjectPoliciesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::ValidationException(_inner) => Some(_inner),
            ListObjectPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOutgoingTypedLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOutgoingTypedLinksError {
    /// Kind of error that occurred.
    pub kind: ListOutgoingTypedLinksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOutgoingTypedLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOutgoingTypedLinksErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOutgoingTypedLinksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOutgoingTypedLinksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListOutgoingTypedLinksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOutgoingTypedLinksError {
    fn code(&self) -> Option<&str> {
        ListOutgoingTypedLinksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOutgoingTypedLinksError {
    /// Creates a new `ListOutgoingTypedLinksError`.
    pub fn new(kind: ListOutgoingTypedLinksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOutgoingTypedLinksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOutgoingTypedLinksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOutgoingTypedLinksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOutgoingTypedLinksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListOutgoingTypedLinksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingTypedLinksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListOutgoingTypedLinksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOutgoingTypedLinksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::FacetValidationException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::ValidationException(_inner) => Some(_inner),
            ListOutgoingTypedLinksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicyAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPolicyAttachmentsError {
    /// Kind of error that occurred.
    pub kind: ListPolicyAttachmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicyAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPolicyAttachmentsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the requested operation can only operate on policy objects.</p>
    NotPolicyException(crate::error::NotPolicyException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPolicyAttachmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPolicyAttachmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::NotPolicyException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPolicyAttachmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPolicyAttachmentsError {
    fn code(&self) -> Option<&str> {
        ListPolicyAttachmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPolicyAttachmentsError {
    /// Creates a new `ListPolicyAttachmentsError`.
    pub fn new(kind: ListPolicyAttachmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPolicyAttachmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPolicyAttachmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPolicyAttachmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPolicyAttachmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::NotPolicyException`.
    pub fn is_not_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::NotPolicyException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListPolicyAttachmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyAttachmentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPolicyAttachmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPolicyAttachmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::NotPolicyException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPolicyAttachmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPublishedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPublishedSchemaArnsError {
    /// Kind of error that occurred.
    pub kind: ListPublishedSchemaArnsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPublishedSchemaArns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPublishedSchemaArnsErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPublishedSchemaArnsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPublishedSchemaArnsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPublishedSchemaArnsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPublishedSchemaArnsError {
    fn code(&self) -> Option<&str> {
        ListPublishedSchemaArnsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPublishedSchemaArnsError {
    /// Creates a new `ListPublishedSchemaArnsError`.
    pub fn new(kind: ListPublishedSchemaArnsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPublishedSchemaArnsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPublishedSchemaArnsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPublishedSchemaArnsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPublishedSchemaArnsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListPublishedSchemaArnsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishedSchemaArnsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPublishedSchemaArnsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPublishedSchemaArnsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPublishedSchemaArnsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Can occur for multiple reasons such as when you tag a resource that doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed limit is 50 tags per resource.</p>
    InvalidTaggingRequestException(crate::error::InvalidTaggingRequestException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidTaggingRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidTaggingRequestException`.
    pub fn is_invalid_tagging_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidTaggingRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidTaggingRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypedLinkFacetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypedLinkFacetAttributesError {
    /// Kind of error that occurred.
    pub kind: ListTypedLinkFacetAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypedLinkFacetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypedLinkFacetAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypedLinkFacetAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypedLinkFacetAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetAttributesErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetAttributesErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            ListTypedLinkFacetAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetAttributesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListTypedLinkFacetAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetAttributesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListTypedLinkFacetAttributesErrorKind::RetryableConflictException(_inner) => {
                _inner.fmt(f)
            }
            ListTypedLinkFacetAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypedLinkFacetAttributesError {
    fn code(&self) -> Option<&str> {
        ListTypedLinkFacetAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypedLinkFacetAttributesError {
    /// Creates a new `ListTypedLinkFacetAttributesError`.
    pub fn new(kind: ListTypedLinkFacetAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypedLinkFacetAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypedLinkFacetAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypedLinkFacetAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypedLinkFacetAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::FacetNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTypedLinkFacetAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypedLinkFacetAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListTypedLinkFacetAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListTypedLinkFacetAttributesErrorKind::RetryableConflictException(_inner) => {
                Some(_inner)
            }
            ListTypedLinkFacetAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            ListTypedLinkFacetAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypedLinkFacetNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypedLinkFacetNamesError {
    /// Kind of error that occurred.
    pub kind: ListTypedLinkFacetNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypedLinkFacetNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypedLinkFacetNamesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypedLinkFacetNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypedLinkFacetNamesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTypedLinkFacetNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypedLinkFacetNamesError {
    fn code(&self) -> Option<&str> {
        ListTypedLinkFacetNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypedLinkFacetNamesError {
    /// Creates a new `ListTypedLinkFacetNamesError`.
    pub fn new(kind: ListTypedLinkFacetNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypedLinkFacetNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypedLinkFacetNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypedLinkFacetNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypedLinkFacetNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListTypedLinkFacetNamesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypedLinkFacetNamesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTypedLinkFacetNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypedLinkFacetNamesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::ValidationException(_inner) => Some(_inner),
            ListTypedLinkFacetNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `LookupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct LookupPolicyError {
    /// Kind of error that occurred.
    pub kind: LookupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `LookupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum LookupPolicyErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for LookupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            LookupPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            LookupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for LookupPolicyError {
    fn code(&self) -> Option<&str> {
        LookupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl LookupPolicyError {
    /// Creates a new `LookupPolicyError`.
    pub fn new(kind: LookupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `LookupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: LookupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `LookupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: LookupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, LookupPolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupPolicyErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, LookupPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupPolicyErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, LookupPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupPolicyErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `LookupPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, LookupPolicyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for LookupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            LookupPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            LookupPolicyErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            LookupPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            LookupPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            LookupPolicyErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            LookupPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            LookupPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            LookupPolicyErrorKind::RetryableConflictException(_inner) => Some(_inner),
            LookupPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            LookupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PublishSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishSchemaError {
    /// Kind of error that occurred.
    pub kind: PublishSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PublishSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that a schema is already published.</p>
    SchemaAlreadyPublishedException(crate::error::SchemaAlreadyPublishedException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::SchemaAlreadyPublishedException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PublishSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishSchemaError {
    fn code(&self) -> Option<&str> {
        PublishSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishSchemaError {
    /// Creates a new `PublishSchemaError`.
    pub fn new(kind: PublishSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PublishSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, PublishSchemaErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishSchemaErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::SchemaAlreadyPublishedException`.
    pub fn is_schema_already_published_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishSchemaErrorKind::SchemaAlreadyPublishedException(_)
        )
    }
    /// Returns true if the error kind is `PublishSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PublishSchemaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PublishSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PublishSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            PublishSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            PublishSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            PublishSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PublishSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            PublishSchemaErrorKind::SchemaAlreadyPublishedException(_inner) => Some(_inner),
            PublishSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            PublishSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSchemaFromJson` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSchemaFromJsonError {
    /// Kind of error that occurred.
    pub kind: PutSchemaFromJsonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSchemaFromJson` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSchemaFromJsonErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
    InvalidRuleException(crate::error::InvalidRuleException),
    /// <p>Indicates that the provided <code>SchemaDoc</code> value is not valid.</p>
    InvalidSchemaDocException(crate::error::InvalidSchemaDocException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSchemaFromJsonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSchemaFromJsonErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::InvalidRuleException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::InvalidSchemaDocException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutSchemaFromJsonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSchemaFromJsonError {
    fn code(&self) -> Option<&str> {
        PutSchemaFromJsonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSchemaFromJsonError {
    /// Creates a new `PutSchemaFromJsonError`.
    pub fn new(kind: PutSchemaFromJsonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSchemaFromJsonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSchemaFromJsonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSchemaFromJsonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSchemaFromJsonErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::InvalidRuleException`.
    pub fn is_invalid_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::InvalidRuleException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::InvalidSchemaDocException`.
    pub fn is_invalid_schema_doc_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::InvalidSchemaDocException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutSchemaFromJsonErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaFromJsonErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutSchemaFromJsonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSchemaFromJsonErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::InvalidArnException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::InvalidRuleException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::InvalidSchemaDocException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::RetryableConflictException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::ValidationException(_inner) => Some(_inner),
            PutSchemaFromJsonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFacetFromObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFacetFromObjectError {
    /// Kind of error that occurred.
    pub kind: RemoveFacetFromObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFacetFromObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFacetFromObjectErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFacetFromObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFacetFromObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveFacetFromObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFacetFromObjectError {
    fn code(&self) -> Option<&str> {
        RemoveFacetFromObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFacetFromObjectError {
    /// Creates a new `RemoveFacetFromObjectError`.
    pub fn new(kind: RemoveFacetFromObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFacetFromObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFacetFromObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFacetFromObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFacetFromObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `RemoveFacetFromObjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFacetFromObjectErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RemoveFacetFromObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFacetFromObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::FacetValidationException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::InvalidArnException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::RetryableConflictException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveFacetFromObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Can occur for multiple reasons such as when you tag a resource that doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed limit is 50 tags per resource.</p>
    InvalidTaggingRequestException(crate::error::InvalidTaggingRequestException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTaggingRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidTaggingRequestException`.
    pub fn is_invalid_tagging_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidTaggingRequestException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTaggingRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::RetryableConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Can occur for multiple reasons such as when you tag a resource that doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed limit is 50 tags per resource.</p>
    InvalidTaggingRequestException(crate::error::InvalidTaggingRequestException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTaggingRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidTaggingRequestException`.
    pub fn is_invalid_tagging_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidTaggingRequestException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTaggingRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFacetError {
    /// Kind of error that occurred.
    pub kind: UpdateFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>An attempt to modify a <a>Facet</a> resulted in an invalid schema
    /// exception.</p>
    InvalidFacetUpdateException(crate::error::InvalidFacetUpdateException),
    /// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
    InvalidRuleException(crate::error::InvalidRuleException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::InvalidFacetUpdateException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::InvalidRuleException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFacetError {
    fn code(&self) -> Option<&str> {
        UpdateFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFacetError {
    /// Creates a new `UpdateFacetError`.
    pub fn new(kind: UpdateFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::FacetNotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFacetErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::InvalidFacetUpdateException`.
    pub fn is_invalid_facet_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFacetErrorKind::InvalidFacetUpdateException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::InvalidRuleException`.
    pub fn is_invalid_rule_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::InvalidRuleException(_))
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateFacetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFacetErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            UpdateFacetErrorKind::FacetValidationException(_inner) => Some(_inner),
            UpdateFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateFacetErrorKind::InvalidFacetUpdateException(_inner) => Some(_inner),
            UpdateFacetErrorKind::InvalidRuleException(_inner) => Some(_inner),
            UpdateFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpdateFacetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLinkAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLinkAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateLinkAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLinkAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLinkAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLinkAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLinkAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLinkAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLinkAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateLinkAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLinkAttributesError {
    /// Creates a new `UpdateLinkAttributesError`.
    pub fn new(kind: UpdateLinkAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLinkAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLinkAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLinkAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLinkAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLinkAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLinkAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLinkAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLinkAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::FacetValidationException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLinkAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateObjectAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateObjectAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateObjectAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateObjectAttributesErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Operations are only permitted on enabled directories.</p>
    DirectoryNotEnabledException(crate::error::DirectoryNotEnabledException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
    /// name and then try again.</p>
    LinkNameAlreadyInUseException(crate::error::LinkNameAlreadyInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateObjectAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateObjectAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::LinkNameAlreadyInUseException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateObjectAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateObjectAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateObjectAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateObjectAttributesError {
    /// Creates a new `UpdateObjectAttributesError`.
    pub fn new(kind: UpdateObjectAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateObjectAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateObjectAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateObjectAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateObjectAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::DirectoryNotEnabledException`.
    pub fn is_directory_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::DirectoryNotEnabledException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::LinkNameAlreadyInUseException`.
    pub fn is_link_name_already_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::LinkNameAlreadyInUseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateObjectAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateObjectAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateObjectAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateObjectAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::DirectoryNotEnabledException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::FacetValidationException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::LinkNameAlreadyInUseException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateObjectAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSchemaError {
    /// Kind of error that occurred.
    pub kind: UpdateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSchemaError {
    fn code(&self) -> Option<&str> {
        UpdateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSchemaError {
    /// Creates a new `UpdateSchemaError`.
    pub fn new(kind: UpdateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTypedLinkFacetError {
    /// Kind of error that occurred.
    pub kind: UpdateTypedLinkFacetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTypedLinkFacet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTypedLinkFacetErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified <a>Facet</a> could not be found.</p>
    FacetNotFoundException(crate::error::FacetNotFoundException),
    /// <p>The <a>Facet</a> that you provided was not well formed or could not be
    /// validated with the schema.</p>
    FacetValidationException(crate::error::FacetValidationException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>An attempt to modify a <a>Facet</a> resulted in an invalid schema
    /// exception.</p>
    InvalidFacetUpdateException(crate::error::InvalidFacetUpdateException),
    /// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
    InvalidRuleException(crate::error::InvalidRuleException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTypedLinkFacetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTypedLinkFacetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::FacetNotFoundException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::FacetValidationException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::InvalidFacetUpdateException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::InvalidRuleException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateTypedLinkFacetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTypedLinkFacetError {
    fn code(&self) -> Option<&str> {
        UpdateTypedLinkFacetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTypedLinkFacetError {
    /// Creates a new `UpdateTypedLinkFacetError`.
    pub fn new(kind: UpdateTypedLinkFacetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTypedLinkFacetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTypedLinkFacetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTypedLinkFacetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTypedLinkFacetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::FacetNotFoundException`.
    pub fn is_facet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::FacetNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::FacetValidationException`.
    pub fn is_facet_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::FacetValidationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::InvalidFacetUpdateException`.
    pub fn is_invalid_facet_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::InvalidFacetUpdateException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::InvalidRuleException`.
    pub fn is_invalid_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::InvalidRuleException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypedLinkFacetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypedLinkFacetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateTypedLinkFacetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTypedLinkFacetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::FacetNotFoundException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::FacetValidationException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::InvalidFacetUpdateException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::InvalidRuleException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateTypedLinkFacetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpgradeAppliedSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpgradeAppliedSchemaError {
    /// Kind of error that occurred.
    pub kind: UpgradeAppliedSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpgradeAppliedSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpgradeAppliedSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a failure occurred while performing a check for backward compatibility between the specified schema and the schema that is currently applied to the directory.</p>
    IncompatibleSchemaException(crate::error::IncompatibleSchemaException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that a schema could not be created due to a naming conflict. Please select a
    /// different name and then try again.</p>
    SchemaAlreadyExistsException(crate::error::SchemaAlreadyExistsException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpgradeAppliedSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpgradeAppliedSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::IncompatibleSchemaException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::SchemaAlreadyExistsException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpgradeAppliedSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpgradeAppliedSchemaError {
    fn code(&self) -> Option<&str> {
        UpgradeAppliedSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpgradeAppliedSchemaError {
    /// Creates a new `UpgradeAppliedSchemaError`.
    pub fn new(kind: UpgradeAppliedSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpgradeAppliedSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpgradeAppliedSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpgradeAppliedSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpgradeAppliedSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::IncompatibleSchemaException`.
    pub fn is_incompatible_schema_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::IncompatibleSchemaException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::SchemaAlreadyExistsException`.
    pub fn is_schema_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::SchemaAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeAppliedSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeAppliedSchemaErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpgradeAppliedSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpgradeAppliedSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::IncompatibleSchemaException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::SchemaAlreadyExistsException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            UpgradeAppliedSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpgradePublishedSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpgradePublishedSchemaError {
    /// Kind of error that occurred.
    pub kind: UpgradePublishedSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpgradePublishedSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpgradePublishedSchemaErrorKind {
    /// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Indicates a failure occurred while performing a check for backward compatibility between the specified schema and the schema that is currently applied to the directory.</p>
    IncompatibleSchemaException(crate::error::IncompatibleSchemaException),
    /// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Indicates that the provided ARN value is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
    /// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
    InvalidAttachmentException(crate::error::InvalidAttachmentException),
    /// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
    RetryableConflictException(crate::error::RetryableConflictException),
    /// <p>Indicates that your request is malformed in some manner. See the exception
    /// message.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpgradePublishedSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpgradePublishedSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::IncompatibleSchemaException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::InvalidAttachmentException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::RetryableConflictException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpgradePublishedSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpgradePublishedSchemaError {
    fn code(&self) -> Option<&str> {
        UpgradePublishedSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpgradePublishedSchemaError {
    /// Creates a new `UpgradePublishedSchemaError`.
    pub fn new(kind: UpgradePublishedSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpgradePublishedSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpgradePublishedSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpgradePublishedSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpgradePublishedSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::IncompatibleSchemaException`.
    pub fn is_incompatible_schema_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::IncompatibleSchemaException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::InvalidAttachmentException`.
    pub fn is_invalid_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::InvalidAttachmentException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::RetryableConflictException`.
    pub fn is_retryable_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::RetryableConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpgradePublishedSchemaErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradePublishedSchemaErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpgradePublishedSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpgradePublishedSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::IncompatibleSchemaException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::InvalidAttachmentException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::RetryableConflictException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::ValidationException(_inner) => Some(_inner),
            UpgradePublishedSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that your request is malformed in some manner. See the exception
/// message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Occurs when a conflict with a previous successful write is detected. For example, if a write operation occurs on an object and then an attempt is made to read the object using “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryableConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RetryableConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryableConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RetryableConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RetryableConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RetryableConflictException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for RetryableConflictException {}
/// See [`RetryableConflictException`](crate::error::RetryableConflictException)
pub mod retryable_conflict_exception {
    /// A builder for [`RetryableConflictException`](crate::error::RetryableConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryableConflictException`](crate::error::RetryableConflictException)
        pub fn build(self) -> crate::error::RetryableConflictException {
            crate::error::RetryableConflictException {
                message: self.message,
            }
        }
    }
}
impl RetryableConflictException {
    /// Creates a new builder-style object to manufacture [`RetryableConflictException`](crate::error::RetryableConflictException)
    pub fn builder() -> crate::error::retryable_conflict_exception::Builder {
        crate::error::retryable_conflict_exception::Builder::default()
    }
}

/// <p>The specified resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that limits are exceeded. See <a href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Indicates that an attempt to make an attachment was invalid. For example, attaching two nodes
/// with a link type that is not applicable to the nodes or attempting to apply a schema to a directory a second time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAttachmentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAttachmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAttachmentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAttachmentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAttachmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAttachmentException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAttachmentException {}
/// See [`InvalidAttachmentException`](crate::error::InvalidAttachmentException)
pub mod invalid_attachment_exception {
    /// A builder for [`InvalidAttachmentException`](crate::error::InvalidAttachmentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAttachmentException`](crate::error::InvalidAttachmentException)
        pub fn build(self) -> crate::error::InvalidAttachmentException {
            crate::error::InvalidAttachmentException {
                message: self.message,
            }
        }
    }
}
impl InvalidAttachmentException {
    /// Creates a new builder-style object to manufacture [`InvalidAttachmentException`](crate::error::InvalidAttachmentException)
    pub fn builder() -> crate::error::invalid_attachment_exception::Builder {
        crate::error::invalid_attachment_exception::Builder::default()
    }
}

/// <p>Indicates that the provided ARN value is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnException {}
/// See [`InvalidArnException`](crate::error::InvalidArnException)
pub mod invalid_arn_exception {
    /// A builder for [`InvalidArnException`](crate::error::InvalidArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnException`](crate::error::InvalidArnException)
        pub fn build(self) -> crate::error::InvalidArnException {
            crate::error::InvalidArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidArnException {
    /// Creates a new builder-style object to manufacture [`InvalidArnException`](crate::error::InvalidArnException)
    pub fn builder() -> crate::error::invalid_arn_exception::Builder {
        crate::error::invalid_arn_exception::Builder::default()
    }
}

/// <p>Indicates a problem that must be resolved by Amazon Web Services. This might be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any operational issues with the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>Indicates a failure occurred while performing a check for backward compatibility between the specified schema and the schema that is currently applied to the directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleSchemaException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleSchemaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleSchemaException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleSchemaException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleSchemaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleSchemaException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleSchemaException {}
/// See [`IncompatibleSchemaException`](crate::error::IncompatibleSchemaException)
pub mod incompatible_schema_exception {
    /// A builder for [`IncompatibleSchemaException`](crate::error::IncompatibleSchemaException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleSchemaException`](crate::error::IncompatibleSchemaException)
        pub fn build(self) -> crate::error::IncompatibleSchemaException {
            crate::error::IncompatibleSchemaException {
                message: self.message,
            }
        }
    }
}
impl IncompatibleSchemaException {
    /// Creates a new builder-style object to manufacture [`IncompatibleSchemaException`](crate::error::IncompatibleSchemaException)
    pub fn builder() -> crate::error::incompatible_schema_exception::Builder {
        crate::error::incompatible_schema_exception::Builder::default()
    }
}

/// <p>Access denied or directory not found. Either you don't have permissions for this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Indicates that a schema could not be created due to a naming conflict. Please select a
/// different name and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SchemaAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SchemaAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SchemaAlreadyExistsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for SchemaAlreadyExistsException {}
/// See [`SchemaAlreadyExistsException`](crate::error::SchemaAlreadyExistsException)
pub mod schema_already_exists_exception {
    /// A builder for [`SchemaAlreadyExistsException`](crate::error::SchemaAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaAlreadyExistsException`](crate::error::SchemaAlreadyExistsException)
        pub fn build(self) -> crate::error::SchemaAlreadyExistsException {
            crate::error::SchemaAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl SchemaAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`SchemaAlreadyExistsException`](crate::error::SchemaAlreadyExistsException)
    pub fn builder() -> crate::error::schema_already_exists_exception::Builder {
        crate::error::schema_already_exists_exception::Builder::default()
    }
}

/// <p>Occurs when any of the rule parameter keys or values are invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRuleException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRuleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRuleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRuleException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRuleException {}
/// See [`InvalidRuleException`](crate::error::InvalidRuleException)
pub mod invalid_rule_exception {
    /// A builder for [`InvalidRuleException`](crate::error::InvalidRuleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRuleException`](crate::error::InvalidRuleException)
        pub fn build(self) -> crate::error::InvalidRuleException {
            crate::error::InvalidRuleException {
                message: self.message,
            }
        }
    }
}
impl InvalidRuleException {
    /// Creates a new builder-style object to manufacture [`InvalidRuleException`](crate::error::InvalidRuleException)
    pub fn builder() -> crate::error::invalid_rule_exception::Builder {
        crate::error::invalid_rule_exception::Builder::default()
    }
}

/// <p>An attempt to modify a <a>Facet</a> resulted in an invalid schema
/// exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFacetUpdateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFacetUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFacetUpdateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFacetUpdateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFacetUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFacetUpdateException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFacetUpdateException {}
/// See [`InvalidFacetUpdateException`](crate::error::InvalidFacetUpdateException)
pub mod invalid_facet_update_exception {
    /// A builder for [`InvalidFacetUpdateException`](crate::error::InvalidFacetUpdateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFacetUpdateException`](crate::error::InvalidFacetUpdateException)
        pub fn build(self) -> crate::error::InvalidFacetUpdateException {
            crate::error::InvalidFacetUpdateException {
                message: self.message,
            }
        }
    }
}
impl InvalidFacetUpdateException {
    /// Creates a new builder-style object to manufacture [`InvalidFacetUpdateException`](crate::error::InvalidFacetUpdateException)
    pub fn builder() -> crate::error::invalid_facet_update_exception::Builder {
        crate::error::invalid_facet_update_exception::Builder::default()
    }
}

/// <p>The <a>Facet</a> that you provided was not well formed or could not be
/// validated with the schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FacetValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FacetValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FacetValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FacetValidationException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for FacetValidationException {}
/// See [`FacetValidationException`](crate::error::FacetValidationException)
pub mod facet_validation_exception {
    /// A builder for [`FacetValidationException`](crate::error::FacetValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetValidationException`](crate::error::FacetValidationException)
        pub fn build(self) -> crate::error::FacetValidationException {
            crate::error::FacetValidationException {
                message: self.message,
            }
        }
    }
}
impl FacetValidationException {
    /// Creates a new builder-style object to manufacture [`FacetValidationException`](crate::error::FacetValidationException)
    pub fn builder() -> crate::error::facet_validation_exception::Builder {
        crate::error::facet_validation_exception::Builder::default()
    }
}

/// <p>The specified <a>Facet</a> could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FacetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FacetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FacetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FacetNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for FacetNotFoundException {}
/// See [`FacetNotFoundException`](crate::error::FacetNotFoundException)
pub mod facet_not_found_exception {
    /// A builder for [`FacetNotFoundException`](crate::error::FacetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetNotFoundException`](crate::error::FacetNotFoundException)
        pub fn build(self) -> crate::error::FacetNotFoundException {
            crate::error::FacetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl FacetNotFoundException {
    /// Creates a new builder-style object to manufacture [`FacetNotFoundException`](crate::error::FacetNotFoundException)
    pub fn builder() -> crate::error::facet_not_found_exception::Builder {
        crate::error::facet_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that a link could not be created due to a naming conflict. Choose a different
/// name and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinkNameAlreadyInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LinkNameAlreadyInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinkNameAlreadyInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LinkNameAlreadyInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LinkNameAlreadyInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LinkNameAlreadyInUseException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for LinkNameAlreadyInUseException {}
/// See [`LinkNameAlreadyInUseException`](crate::error::LinkNameAlreadyInUseException)
pub mod link_name_already_in_use_exception {
    /// A builder for [`LinkNameAlreadyInUseException`](crate::error::LinkNameAlreadyInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LinkNameAlreadyInUseException`](crate::error::LinkNameAlreadyInUseException)
        pub fn build(self) -> crate::error::LinkNameAlreadyInUseException {
            crate::error::LinkNameAlreadyInUseException {
                message: self.message,
            }
        }
    }
}
impl LinkNameAlreadyInUseException {
    /// Creates a new builder-style object to manufacture [`LinkNameAlreadyInUseException`](crate::error::LinkNameAlreadyInUseException)
    pub fn builder() -> crate::error::link_name_already_in_use_exception::Builder {
        crate::error::link_name_already_in_use_exception::Builder::default()
    }
}

/// <p>Operations are only permitted on enabled directories.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryNotEnabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryNotEnabledException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryNotEnabledException {}
/// See [`DirectoryNotEnabledException`](crate::error::DirectoryNotEnabledException)
pub mod directory_not_enabled_exception {
    /// A builder for [`DirectoryNotEnabledException`](crate::error::DirectoryNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryNotEnabledException`](crate::error::DirectoryNotEnabledException)
        pub fn build(self) -> crate::error::DirectoryNotEnabledException {
            crate::error::DirectoryNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl DirectoryNotEnabledException {
    /// Creates a new builder-style object to manufacture [`DirectoryNotEnabledException`](crate::error::DirectoryNotEnabledException)
    pub fn builder() -> crate::error::directory_not_enabled_exception::Builder {
        crate::error::directory_not_enabled_exception::Builder::default()
    }
}

/// <p>Can occur for multiple reasons such as when you tag a resource that doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed limit is 50 tags per resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTaggingRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTaggingRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTaggingRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTaggingRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTaggingRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTaggingRequestException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTaggingRequestException {}
/// See [`InvalidTaggingRequestException`](crate::error::InvalidTaggingRequestException)
pub mod invalid_tagging_request_exception {
    /// A builder for [`InvalidTaggingRequestException`](crate::error::InvalidTaggingRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTaggingRequestException`](crate::error::InvalidTaggingRequestException)
        pub fn build(self) -> crate::error::InvalidTaggingRequestException {
            crate::error::InvalidTaggingRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidTaggingRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidTaggingRequestException`](crate::error::InvalidTaggingRequestException)
    pub fn builder() -> crate::error::invalid_tagging_request_exception::Builder {
        crate::error::invalid_tagging_request_exception::Builder::default()
    }
}

/// <p>Indicates that the provided <code>SchemaDoc</code> value is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSchemaDocException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSchemaDocException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSchemaDocException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSchemaDocException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSchemaDocException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSchemaDocException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSchemaDocException {}
/// See [`InvalidSchemaDocException`](crate::error::InvalidSchemaDocException)
pub mod invalid_schema_doc_exception {
    /// A builder for [`InvalidSchemaDocException`](crate::error::InvalidSchemaDocException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSchemaDocException`](crate::error::InvalidSchemaDocException)
        pub fn build(self) -> crate::error::InvalidSchemaDocException {
            crate::error::InvalidSchemaDocException {
                message: self.message,
            }
        }
    }
}
impl InvalidSchemaDocException {
    /// Creates a new builder-style object to manufacture [`InvalidSchemaDocException`](crate::error::InvalidSchemaDocException)
    pub fn builder() -> crate::error::invalid_schema_doc_exception::Builder {
        crate::error::invalid_schema_doc_exception::Builder::default()
    }
}

/// <p>Indicates that a schema is already published.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaAlreadyPublishedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaAlreadyPublishedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaAlreadyPublishedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SchemaAlreadyPublishedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SchemaAlreadyPublishedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SchemaAlreadyPublishedException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for SchemaAlreadyPublishedException {}
/// See [`SchemaAlreadyPublishedException`](crate::error::SchemaAlreadyPublishedException)
pub mod schema_already_published_exception {
    /// A builder for [`SchemaAlreadyPublishedException`](crate::error::SchemaAlreadyPublishedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaAlreadyPublishedException`](crate::error::SchemaAlreadyPublishedException)
        pub fn build(self) -> crate::error::SchemaAlreadyPublishedException {
            crate::error::SchemaAlreadyPublishedException {
                message: self.message,
            }
        }
    }
}
impl SchemaAlreadyPublishedException {
    /// Creates a new builder-style object to manufacture [`SchemaAlreadyPublishedException`](crate::error::SchemaAlreadyPublishedException)
    pub fn builder() -> crate::error::schema_already_published_exception::Builder {
        crate::error::schema_already_published_exception::Builder::default()
    }
}

/// <p>Indicates that the <code>NextToken</code> value is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>Indicates that the requested operation can only operate on policy objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotPolicyException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotPolicyException {}
/// See [`NotPolicyException`](crate::error::NotPolicyException)
pub mod not_policy_exception {
    /// A builder for [`NotPolicyException`](crate::error::NotPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotPolicyException`](crate::error::NotPolicyException)
        pub fn build(self) -> crate::error::NotPolicyException {
            crate::error::NotPolicyException {
                message: self.message,
            }
        }
    }
}
impl NotPolicyException {
    /// Creates a new builder-style object to manufacture [`NotPolicyException`](crate::error::NotPolicyException)
    pub fn builder() -> crate::error::not_policy_exception::Builder {
        crate::error::not_policy_exception::Builder::default()
    }
}

/// <p>Cannot list the parents of a <a>Directory</a> root.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CannotListParentOfRootException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CannotListParentOfRootException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CannotListParentOfRootException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CannotListParentOfRootException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CannotListParentOfRootException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CannotListParentOfRootException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for CannotListParentOfRootException {}
/// See [`CannotListParentOfRootException`](crate::error::CannotListParentOfRootException)
pub mod cannot_list_parent_of_root_exception {
    /// A builder for [`CannotListParentOfRootException`](crate::error::CannotListParentOfRootException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CannotListParentOfRootException`](crate::error::CannotListParentOfRootException)
        pub fn build(self) -> crate::error::CannotListParentOfRootException {
            crate::error::CannotListParentOfRootException {
                message: self.message,
            }
        }
    }
}
impl CannotListParentOfRootException {
    /// Creates a new builder-style object to manufacture [`CannotListParentOfRootException`](crate::error::CannotListParentOfRootException)
    pub fn builder() -> crate::error::cannot_list_parent_of_root_exception::Builder {
        crate::error::cannot_list_parent_of_root_exception::Builder::default()
    }
}

/// <p>Occurs when any invalid operations are performed on an object that is not a node, such
/// as calling <code>ListObjectChildren</code> for a leaf node object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotNodeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotNodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotNodeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotNodeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotNodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotNodeException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotNodeException {}
/// See [`NotNodeException`](crate::error::NotNodeException)
pub mod not_node_exception {
    /// A builder for [`NotNodeException`](crate::error::NotNodeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotNodeException`](crate::error::NotNodeException)
        pub fn build(self) -> crate::error::NotNodeException {
            crate::error::NotNodeException {
                message: self.message,
            }
        }
    }
}
impl NotNodeException {
    /// Creates a new builder-style object to manufacture [`NotNodeException`](crate::error::NotNodeException)
    pub fn builder() -> crate::error::not_node_exception::Builder {
        crate::error::not_node_exception::Builder::default()
    }
}

/// <p>Indicates that the requested operation can only operate on index objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotIndexException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotIndexException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotIndexException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotIndexException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotIndexException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotIndexException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotIndexException {}
/// See [`NotIndexException`](crate::error::NotIndexException)
pub mod not_index_exception {
    /// A builder for [`NotIndexException`](crate::error::NotIndexException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotIndexException`](crate::error::NotIndexException)
        pub fn build(self) -> crate::error::NotIndexException {
            crate::error::NotIndexException {
                message: self.message,
            }
        }
    }
}
impl NotIndexException {
    /// Creates a new builder-style object to manufacture [`NotIndexException`](crate::error::NotIndexException)
    pub fn builder() -> crate::error::not_index_exception::Builder {
        crate::error::not_index_exception::Builder::default()
    }
}

/// <p>A directory that has been deleted and to which access has been attempted. Note: The
/// requested resource will eventually cease to exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryDeletedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryDeletedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryDeletedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryDeletedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryDeletedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryDeletedException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryDeletedException {}
/// See [`DirectoryDeletedException`](crate::error::DirectoryDeletedException)
pub mod directory_deleted_exception {
    /// A builder for [`DirectoryDeletedException`](crate::error::DirectoryDeletedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryDeletedException`](crate::error::DirectoryDeletedException)
        pub fn build(self) -> crate::error::DirectoryDeletedException {
            crate::error::DirectoryDeletedException {
                message: self.message,
            }
        }
    }
}
impl DirectoryDeletedException {
    /// Creates a new builder-style object to manufacture [`DirectoryDeletedException`](crate::error::DirectoryDeletedException)
    pub fn builder() -> crate::error::directory_deleted_exception::Builder {
        crate::error::directory_deleted_exception::Builder::default()
    }
}

/// <p>Indicates that the object is not attached to the index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectAlreadyDetachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ObjectAlreadyDetachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectAlreadyDetachedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ObjectAlreadyDetachedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ObjectAlreadyDetachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ObjectAlreadyDetachedException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for ObjectAlreadyDetachedException {}
/// See [`ObjectAlreadyDetachedException`](crate::error::ObjectAlreadyDetachedException)
pub mod object_already_detached_exception {
    /// A builder for [`ObjectAlreadyDetachedException`](crate::error::ObjectAlreadyDetachedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectAlreadyDetachedException`](crate::error::ObjectAlreadyDetachedException)
        pub fn build(self) -> crate::error::ObjectAlreadyDetachedException {
            crate::error::ObjectAlreadyDetachedException {
                message: self.message,
            }
        }
    }
}
impl ObjectAlreadyDetachedException {
    /// Creates a new builder-style object to manufacture [`ObjectAlreadyDetachedException`](crate::error::ObjectAlreadyDetachedException)
    pub fn builder() -> crate::error::object_already_detached_exception::Builder {
        crate::error::object_already_detached_exception::Builder::default()
    }
}

/// <p>The object could not be deleted because links still exist. Remove the links and then
/// try the operation again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StillContainsLinksException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StillContainsLinksException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StillContainsLinksException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StillContainsLinksException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StillContainsLinksException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StillContainsLinksException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for StillContainsLinksException {}
/// See [`StillContainsLinksException`](crate::error::StillContainsLinksException)
pub mod still_contains_links_exception {
    /// A builder for [`StillContainsLinksException`](crate::error::StillContainsLinksException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StillContainsLinksException`](crate::error::StillContainsLinksException)
        pub fn build(self) -> crate::error::StillContainsLinksException {
            crate::error::StillContainsLinksException {
                message: self.message,
            }
        }
    }
}
impl StillContainsLinksException {
    /// Creates a new builder-style object to manufacture [`StillContainsLinksException`](crate::error::StillContainsLinksException)
    pub fn builder() -> crate::error::still_contains_links_exception::Builder {
        crate::error::still_contains_links_exception::Builder::default()
    }
}

/// <p>Indicates that the requested operation cannot be completed because the object has not
/// been detached from the tree.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectNotDetachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ObjectNotDetachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectNotDetachedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ObjectNotDetachedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ObjectNotDetachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ObjectNotDetachedException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for ObjectNotDetachedException {}
/// See [`ObjectNotDetachedException`](crate::error::ObjectNotDetachedException)
pub mod object_not_detached_exception {
    /// A builder for [`ObjectNotDetachedException`](crate::error::ObjectNotDetachedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectNotDetachedException`](crate::error::ObjectNotDetachedException)
        pub fn build(self) -> crate::error::ObjectNotDetachedException {
            crate::error::ObjectNotDetachedException {
                message: self.message,
            }
        }
    }
}
impl ObjectNotDetachedException {
    /// Creates a new builder-style object to manufacture [`ObjectNotDetachedException`](crate::error::ObjectNotDetachedException)
    pub fn builder() -> crate::error::object_not_detached_exception::Builder {
        crate::error::object_not_detached_exception::Builder::default()
    }
}

/// <p>Occurs when deleting a facet that contains an attribute that is a target to an
/// attribute reference in a different facet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FacetInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FacetInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FacetInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FacetInUseException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for FacetInUseException {}
/// See [`FacetInUseException`](crate::error::FacetInUseException)
pub mod facet_in_use_exception {
    /// A builder for [`FacetInUseException`](crate::error::FacetInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetInUseException`](crate::error::FacetInUseException)
        pub fn build(self) -> crate::error::FacetInUseException {
            crate::error::FacetInUseException {
                message: self.message,
            }
        }
    }
}
impl FacetInUseException {
    /// Creates a new builder-style object to manufacture [`FacetInUseException`](crate::error::FacetInUseException)
    pub fn builder() -> crate::error::facet_in_use_exception::Builder {
        crate::error::facet_in_use_exception::Builder::default()
    }
}

/// <p>An operation can only operate on a disabled directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryNotDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryNotDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryNotDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryNotDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryNotDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryNotDisabledException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryNotDisabledException {}
/// See [`DirectoryNotDisabledException`](crate::error::DirectoryNotDisabledException)
pub mod directory_not_disabled_exception {
    /// A builder for [`DirectoryNotDisabledException`](crate::error::DirectoryNotDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryNotDisabledException`](crate::error::DirectoryNotDisabledException)
        pub fn build(self) -> crate::error::DirectoryNotDisabledException {
            crate::error::DirectoryNotDisabledException {
                message: self.message,
            }
        }
    }
}
impl DirectoryNotDisabledException {
    /// Creates a new builder-style object to manufacture [`DirectoryNotDisabledException`](crate::error::DirectoryNotDisabledException)
    pub fn builder() -> crate::error::directory_not_disabled_exception::Builder {
        crate::error::directory_not_disabled_exception::Builder::default()
    }
}

/// <p>A facet with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FacetAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FacetAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FacetAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FacetAlreadyExistsException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for FacetAlreadyExistsException {}
/// See [`FacetAlreadyExistsException`](crate::error::FacetAlreadyExistsException)
pub mod facet_already_exists_exception {
    /// A builder for [`FacetAlreadyExistsException`](crate::error::FacetAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetAlreadyExistsException`](crate::error::FacetAlreadyExistsException)
        pub fn build(self) -> crate::error::FacetAlreadyExistsException {
            crate::error::FacetAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl FacetAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`FacetAlreadyExistsException`](crate::error::FacetAlreadyExistsException)
    pub fn builder() -> crate::error::facet_already_exists_exception::Builder {
        crate::error::facet_already_exists_exception::Builder::default()
    }
}

/// <p>Indicates that the requested index type is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedIndexTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedIndexTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedIndexTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedIndexTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedIndexTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedIndexTypeException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedIndexTypeException {}
/// See [`UnsupportedIndexTypeException`](crate::error::UnsupportedIndexTypeException)
pub mod unsupported_index_type_exception {
    /// A builder for [`UnsupportedIndexTypeException`](crate::error::UnsupportedIndexTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedIndexTypeException`](crate::error::UnsupportedIndexTypeException)
        pub fn build(self) -> crate::error::UnsupportedIndexTypeException {
            crate::error::UnsupportedIndexTypeException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedIndexTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedIndexTypeException`](crate::error::UnsupportedIndexTypeException)
    pub fn builder() -> crate::error::unsupported_index_type_exception::Builder {
        crate::error::unsupported_index_type_exception::Builder::default()
    }
}

/// <p>Indicates that a <a>Directory</a> could not be created due to a naming
/// conflict. Choose a different name and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryAlreadyExistsException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryAlreadyExistsException {}
/// See [`DirectoryAlreadyExistsException`](crate::error::DirectoryAlreadyExistsException)
pub mod directory_already_exists_exception {
    /// A builder for [`DirectoryAlreadyExistsException`](crate::error::DirectoryAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryAlreadyExistsException`](crate::error::DirectoryAlreadyExistsException)
        pub fn build(self) -> crate::error::DirectoryAlreadyExistsException {
            crate::error::DirectoryAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl DirectoryAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`DirectoryAlreadyExistsException`](crate::error::DirectoryAlreadyExistsException)
    pub fn builder() -> crate::error::directory_already_exists_exception::Builder {
        crate::error::directory_already_exists_exception::Builder::default()
    }
}

/// <p>A <code>BatchWrite</code> exception has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteException {
    #[allow(missing_docs)] // documentation missing in model
    pub index: i32,
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<crate::model::BatchWriteExceptionType>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchWriteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteException");
        formatter.field("index", &self.index);
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchWriteException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchWriteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchWriteException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchWriteException {}
/// See [`BatchWriteException`](crate::error::BatchWriteException)
pub mod batch_write_exception {
    /// A builder for [`BatchWriteException`](crate::error::BatchWriteException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::BatchWriteExceptionType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: crate::model::BatchWriteExceptionType) -> Self {
            self.r#type = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::BatchWriteExceptionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteException`](crate::error::BatchWriteException)
        pub fn build(self) -> crate::error::BatchWriteException {
            crate::error::BatchWriteException {
                index: self.index.unwrap_or_default(),
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl BatchWriteException {
    /// Creates a new builder-style object to manufacture [`BatchWriteException`](crate::error::BatchWriteException)
    pub fn builder() -> crate::error::batch_write_exception::Builder {
        crate::error::batch_write_exception::Builder::default()
    }
}

/// <p>An object has been attempted to be attached to an object that does not have the appropriate attribute value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexedAttributeMissingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IndexedAttributeMissingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexedAttributeMissingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IndexedAttributeMissingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IndexedAttributeMissingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IndexedAttributeMissingException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for IndexedAttributeMissingException {}
/// See [`IndexedAttributeMissingException`](crate::error::IndexedAttributeMissingException)
pub mod indexed_attribute_missing_exception {
    /// A builder for [`IndexedAttributeMissingException`](crate::error::IndexedAttributeMissingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexedAttributeMissingException`](crate::error::IndexedAttributeMissingException)
        pub fn build(self) -> crate::error::IndexedAttributeMissingException {
            crate::error::IndexedAttributeMissingException {
                message: self.message,
            }
        }
    }
}
impl IndexedAttributeMissingException {
    /// Creates a new builder-style object to manufacture [`IndexedAttributeMissingException`](crate::error::IndexedAttributeMissingException)
    pub fn builder() -> crate::error::indexed_attribute_missing_exception::Builder {
        crate::error::indexed_attribute_missing_exception::Builder::default()
    }
}
