// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelResourceRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelResourceRequestError {
    /// Kind of error that occurred.
    pub kind: CancelResourceRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelResourceRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelResourceRequestErrorKind {
    /// <p>The resource is currently being modified by another operation.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A resource operation with the specified request token can't be found.</p>
    RequestTokenNotFoundException(crate::error::RequestTokenNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelResourceRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelResourceRequestErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CancelResourceRequestErrorKind::RequestTokenNotFoundException(_inner) => _inner.fmt(f),
            CancelResourceRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelResourceRequestError {
    fn code(&self) -> Option<&str> {
        CancelResourceRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelResourceRequestError {
    /// Creates a new `CancelResourceRequestError`.
    pub fn new(kind: CancelResourceRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelResourceRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelResourceRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelResourceRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelResourceRequestErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelResourceRequestErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelResourceRequestErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelResourceRequestErrorKind::RequestTokenNotFoundException`.
    pub fn is_request_token_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelResourceRequestErrorKind::RequestTokenNotFoundException(_)
        )
    }
}
impl std::error::Error for CancelResourceRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelResourceRequestErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CancelResourceRequestErrorKind::RequestTokenNotFoundException(_inner) => Some(_inner),
            CancelResourceRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceError {
    /// Kind of error that occurred.
    pub kind: CreateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The specified client token has already been used in another resource request.</p>
    /// <p>It's best practice for client tokens to be unique for each resource operation request. However, client token expire after 36 hours.</p>
    ClientTokenConflictException(crate::error::ClientTokenConflictException),
    /// <p>Another resource operation is currently being performed on this resource.</p>
    ConcurrentOperationException(crate::error::ConcurrentOperationException),
    /// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
    GeneralServiceException(crate::error::GeneralServiceException),
    /// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
    HandlerFailureException(crate::error::HandlerFailureException),
    /// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
    HandlerInternalFailureException(crate::error::HandlerInternalFailureException),
    /// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
    NetworkFailureException(crate::error::NetworkFailureException),
    /// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
    NotStabilizedException(crate::error::NotStabilizedException),
    /// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
    NotUpdatableException(crate::error::NotUpdatableException),
    /// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
    PrivateTypeException(crate::error::PrivateTypeException),
    /// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>A resource with the specified identifier can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
    ServiceInternalErrorException(crate::error::ServiceInternalErrorException),
    /// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// <p>The specified resource doesn't support this resource operation.</p>
    UnsupportedActionException(crate::error::UnsupportedActionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ClientTokenConflictException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ConcurrentOperationException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::GeneralServiceException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::HandlerFailureException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::HandlerInternalFailureException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::NetworkFailureException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::NotStabilizedException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::NotUpdatableException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::PrivateTypeException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ServiceInternalErrorException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::UnsupportedActionException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceError {
    fn code(&self) -> Option<&str> {
        CreateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceError {
    /// Creates a new `CreateResourceError`.
    pub fn new(kind: CreateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ClientTokenConflictException`.
    pub fn is_client_token_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ClientTokenConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ConcurrentOperationException`.
    pub fn is_concurrent_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ConcurrentOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::GeneralServiceException`.
    pub fn is_general_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::GeneralServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::HandlerFailureException`.
    pub fn is_handler_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::HandlerFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::HandlerInternalFailureException`.
    pub fn is_handler_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::HandlerInternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::NetworkFailureException`.
    pub fn is_network_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::NetworkFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::NotStabilizedException`.
    pub fn is_not_stabilized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::NotStabilizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::NotUpdatableException`.
    pub fn is_not_updatable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::NotUpdatableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::PrivateTypeException`.
    pub fn is_private_type_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceErrorKind::PrivateTypeException(_))
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ServiceInternalErrorException`.
    pub fn is_service_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ServiceInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::TypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::UnsupportedActionException`.
    pub fn is_unsupported_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::UnsupportedActionException(_)
        )
    }
}
impl std::error::Error for CreateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateResourceErrorKind::ClientTokenConflictException(_inner) => Some(_inner),
            CreateResourceErrorKind::ConcurrentOperationException(_inner) => Some(_inner),
            CreateResourceErrorKind::GeneralServiceException(_inner) => Some(_inner),
            CreateResourceErrorKind::HandlerFailureException(_inner) => Some(_inner),
            CreateResourceErrorKind::HandlerInternalFailureException(_inner) => Some(_inner),
            CreateResourceErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            CreateResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateResourceErrorKind::NetworkFailureException(_inner) => Some(_inner),
            CreateResourceErrorKind::NotStabilizedException(_inner) => Some(_inner),
            CreateResourceErrorKind::NotUpdatableException(_inner) => Some(_inner),
            CreateResourceErrorKind::PrivateTypeException(_inner) => Some(_inner),
            CreateResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            CreateResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateResourceErrorKind::ServiceInternalErrorException(_inner) => Some(_inner),
            CreateResourceErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreateResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateResourceErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            CreateResourceErrorKind::UnsupportedActionException(_inner) => Some(_inner),
            CreateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The specified client token has already been used in another resource request.</p>
    /// <p>It's best practice for client tokens to be unique for each resource operation request. However, client token expire after 36 hours.</p>
    ClientTokenConflictException(crate::error::ClientTokenConflictException),
    /// <p>Another resource operation is currently being performed on this resource.</p>
    ConcurrentOperationException(crate::error::ConcurrentOperationException),
    /// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
    GeneralServiceException(crate::error::GeneralServiceException),
    /// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
    HandlerFailureException(crate::error::HandlerFailureException),
    /// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
    HandlerInternalFailureException(crate::error::HandlerInternalFailureException),
    /// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
    NetworkFailureException(crate::error::NetworkFailureException),
    /// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
    NotStabilizedException(crate::error::NotStabilizedException),
    /// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
    NotUpdatableException(crate::error::NotUpdatableException),
    /// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
    PrivateTypeException(crate::error::PrivateTypeException),
    /// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>A resource with the specified identifier can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
    ServiceInternalErrorException(crate::error::ServiceInternalErrorException),
    /// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// <p>The specified resource doesn't support this resource operation.</p>
    UnsupportedActionException(crate::error::UnsupportedActionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ClientTokenConflictException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ConcurrentOperationException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::GeneralServiceException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::HandlerFailureException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::HandlerInternalFailureException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::NetworkFailureException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::NotStabilizedException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::NotUpdatableException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::PrivateTypeException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ServiceInternalErrorException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::UnsupportedActionException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceError {
    fn code(&self) -> Option<&str> {
        DeleteResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceError {
    /// Creates a new `DeleteResourceError`.
    pub fn new(kind: DeleteResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ClientTokenConflictException`.
    pub fn is_client_token_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ClientTokenConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ConcurrentOperationException`.
    pub fn is_concurrent_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ConcurrentOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::GeneralServiceException`.
    pub fn is_general_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::GeneralServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::HandlerFailureException`.
    pub fn is_handler_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::HandlerFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::HandlerInternalFailureException`.
    pub fn is_handler_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::HandlerInternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::NetworkFailureException`.
    pub fn is_network_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::NetworkFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::NotStabilizedException`.
    pub fn is_not_stabilized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::NotStabilizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::NotUpdatableException`.
    pub fn is_not_updatable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::NotUpdatableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::PrivateTypeException`.
    pub fn is_private_type_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::PrivateTypeException(_))
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ServiceInternalErrorException`.
    pub fn is_service_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ServiceInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::TypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::UnsupportedActionException`.
    pub fn is_unsupported_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::UnsupportedActionException(_)
        )
    }
}
impl std::error::Error for DeleteResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ClientTokenConflictException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ConcurrentOperationException(_inner) => Some(_inner),
            DeleteResourceErrorKind::GeneralServiceException(_inner) => Some(_inner),
            DeleteResourceErrorKind::HandlerFailureException(_inner) => Some(_inner),
            DeleteResourceErrorKind::HandlerInternalFailureException(_inner) => Some(_inner),
            DeleteResourceErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            DeleteResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteResourceErrorKind::NetworkFailureException(_inner) => Some(_inner),
            DeleteResourceErrorKind::NotStabilizedException(_inner) => Some(_inner),
            DeleteResourceErrorKind::NotUpdatableException(_inner) => Some(_inner),
            DeleteResourceErrorKind::PrivateTypeException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ServiceInternalErrorException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourceErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            DeleteResourceErrorKind::UnsupportedActionException(_inner) => Some(_inner),
            DeleteResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceError {
    /// Kind of error that occurred.
    pub kind: GetResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
    GeneralServiceException(crate::error::GeneralServiceException),
    /// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
    HandlerFailureException(crate::error::HandlerFailureException),
    /// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
    HandlerInternalFailureException(crate::error::HandlerInternalFailureException),
    /// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
    NetworkFailureException(crate::error::NetworkFailureException),
    /// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
    NotStabilizedException(crate::error::NotStabilizedException),
    /// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
    NotUpdatableException(crate::error::NotUpdatableException),
    /// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
    PrivateTypeException(crate::error::PrivateTypeException),
    /// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>A resource with the specified identifier can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
    ServiceInternalErrorException(crate::error::ServiceInternalErrorException),
    /// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// <p>The specified resource doesn't support this resource operation.</p>
    UnsupportedActionException(crate::error::UnsupportedActionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::GeneralServiceException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::HandlerFailureException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::HandlerInternalFailureException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::NetworkFailureException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::NotStabilizedException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::NotUpdatableException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::PrivateTypeException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::ServiceInternalErrorException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::UnsupportedActionException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceError {
    fn code(&self) -> Option<&str> {
        GetResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceError {
    /// Creates a new `GetResourceError`.
    pub fn new(kind: GetResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::GeneralServiceException`.
    pub fn is_general_service_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::GeneralServiceException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::HandlerFailureException`.
    pub fn is_handler_failure_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::HandlerFailureException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::HandlerInternalFailureException`.
    pub fn is_handler_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::HandlerInternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::NetworkFailureException`.
    pub fn is_network_failure_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::NetworkFailureException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::NotStabilizedException`.
    pub fn is_not_stabilized_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::NotStabilizedException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::NotUpdatableException`.
    pub fn is_not_updatable_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::NotUpdatableException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::PrivateTypeException`.
    pub fn is_private_type_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::PrivateTypeException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::ServiceInternalErrorException`.
    pub fn is_service_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::ServiceInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::TypeNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetResourceErrorKind::UnsupportedActionException`.
    pub fn is_unsupported_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::UnsupportedActionException(_)
        )
    }
}
impl std::error::Error for GetResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            GetResourceErrorKind::GeneralServiceException(_inner) => Some(_inner),
            GetResourceErrorKind::HandlerFailureException(_inner) => Some(_inner),
            GetResourceErrorKind::HandlerInternalFailureException(_inner) => Some(_inner),
            GetResourceErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            GetResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetResourceErrorKind::NetworkFailureException(_inner) => Some(_inner),
            GetResourceErrorKind::NotStabilizedException(_inner) => Some(_inner),
            GetResourceErrorKind::NotUpdatableException(_inner) => Some(_inner),
            GetResourceErrorKind::PrivateTypeException(_inner) => Some(_inner),
            GetResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            GetResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourceErrorKind::ServiceInternalErrorException(_inner) => Some(_inner),
            GetResourceErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            GetResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourceErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            GetResourceErrorKind::UnsupportedActionException(_inner) => Some(_inner),
            GetResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceRequestStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceRequestStatusError {
    /// Kind of error that occurred.
    pub kind: GetResourceRequestStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceRequestStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceRequestStatusErrorKind {
    /// <p>A resource operation with the specified request token can't be found.</p>
    RequestTokenNotFoundException(crate::error::RequestTokenNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceRequestStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceRequestStatusErrorKind::RequestTokenNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceRequestStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceRequestStatusError {
    fn code(&self) -> Option<&str> {
        GetResourceRequestStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceRequestStatusError {
    /// Creates a new `GetResourceRequestStatusError`.
    pub fn new(kind: GetResourceRequestStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceRequestStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceRequestStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceRequestStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceRequestStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceRequestStatusErrorKind::RequestTokenNotFoundException`.
    pub fn is_request_token_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceRequestStatusErrorKind::RequestTokenNotFoundException(_)
        )
    }
}
impl std::error::Error for GetResourceRequestStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceRequestStatusErrorKind::RequestTokenNotFoundException(_inner) => {
                Some(_inner)
            }
            GetResourceRequestStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceRequestsError {
    /// Kind of error that occurred.
    pub kind: ListResourceRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceRequestsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceRequestsError {
    fn code(&self) -> Option<&str> {
        ListResourceRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceRequestsError {
    /// Creates a new `ListResourceRequestsError`.
    pub fn new(kind: ListResourceRequestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceRequestsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListResourceRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesError {
    /// Kind of error that occurred.
    pub kind: ListResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
    GeneralServiceException(crate::error::GeneralServiceException),
    /// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
    HandlerFailureException(crate::error::HandlerFailureException),
    /// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
    HandlerInternalFailureException(crate::error::HandlerInternalFailureException),
    /// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
    NetworkFailureException(crate::error::NetworkFailureException),
    /// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
    NotStabilizedException(crate::error::NotStabilizedException),
    /// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
    NotUpdatableException(crate::error::NotUpdatableException),
    /// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
    PrivateTypeException(crate::error::PrivateTypeException),
    /// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>A resource with the specified identifier can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
    ServiceInternalErrorException(crate::error::ServiceInternalErrorException),
    /// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// <p>The specified resource doesn't support this resource operation.</p>
    UnsupportedActionException(crate::error::UnsupportedActionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::GeneralServiceException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::HandlerFailureException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::HandlerInternalFailureException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::NetworkFailureException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::NotStabilizedException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::NotUpdatableException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::PrivateTypeException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ServiceInternalErrorException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::UnsupportedActionException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesError {
    fn code(&self) -> Option<&str> {
        ListResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesError {
    /// Creates a new `ListResourcesError`.
    pub fn new(kind: ListResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::GeneralServiceException`.
    pub fn is_general_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::GeneralServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::HandlerFailureException`.
    pub fn is_handler_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::HandlerFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::HandlerInternalFailureException`.
    pub fn is_handler_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::HandlerInternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::NetworkFailureException`.
    pub fn is_network_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::NetworkFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::NotStabilizedException`.
    pub fn is_not_stabilized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::NotStabilizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::NotUpdatableException`.
    pub fn is_not_updatable_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::NotUpdatableException(_))
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::PrivateTypeException`.
    pub fn is_private_type_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::PrivateTypeException(_))
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ServiceInternalErrorException`.
    pub fn is_service_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ServiceInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::TypeNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::UnsupportedActionException`.
    pub fn is_unsupported_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::UnsupportedActionException(_)
        )
    }
}
impl std::error::Error for ListResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            ListResourcesErrorKind::GeneralServiceException(_inner) => Some(_inner),
            ListResourcesErrorKind::HandlerFailureException(_inner) => Some(_inner),
            ListResourcesErrorKind::HandlerInternalFailureException(_inner) => Some(_inner),
            ListResourcesErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            ListResourcesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListResourcesErrorKind::NetworkFailureException(_inner) => Some(_inner),
            ListResourcesErrorKind::NotStabilizedException(_inner) => Some(_inner),
            ListResourcesErrorKind::NotUpdatableException(_inner) => Some(_inner),
            ListResourcesErrorKind::PrivateTypeException(_inner) => Some(_inner),
            ListResourcesErrorKind::ResourceConflictException(_inner) => Some(_inner),
            ListResourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListResourcesErrorKind::ServiceInternalErrorException(_inner) => Some(_inner),
            ListResourcesErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            ListResourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListResourcesErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            ListResourcesErrorKind::UnsupportedActionException(_inner) => Some(_inner),
            ListResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The specified client token has already been used in another resource request.</p>
    /// <p>It's best practice for client tokens to be unique for each resource operation request. However, client token expire after 36 hours.</p>
    ClientTokenConflictException(crate::error::ClientTokenConflictException),
    /// <p>Another resource operation is currently being performed on this resource.</p>
    ConcurrentOperationException(crate::error::ConcurrentOperationException),
    /// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
    GeneralServiceException(crate::error::GeneralServiceException),
    /// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
    HandlerFailureException(crate::error::HandlerFailureException),
    /// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
    HandlerInternalFailureException(crate::error::HandlerInternalFailureException),
    /// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
    NetworkFailureException(crate::error::NetworkFailureException),
    /// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
    NotStabilizedException(crate::error::NotStabilizedException),
    /// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
    NotUpdatableException(crate::error::NotUpdatableException),
    /// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
    PrivateTypeException(crate::error::PrivateTypeException),
    /// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>A resource with the specified identifier can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
    ServiceInternalErrorException(crate::error::ServiceInternalErrorException),
    /// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// <p>The specified resource doesn't support this resource operation.</p>
    UnsupportedActionException(crate::error::UnsupportedActionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ClientTokenConflictException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ConcurrentOperationException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::GeneralServiceException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::HandlerFailureException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::HandlerInternalFailureException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::NetworkFailureException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::NotStabilizedException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::NotUpdatableException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::PrivateTypeException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ServiceInternalErrorException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::UnsupportedActionException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceError {
    fn code(&self) -> Option<&str> {
        UpdateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceError {
    /// Creates a new `UpdateResourceError`.
    pub fn new(kind: UpdateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ClientTokenConflictException`.
    pub fn is_client_token_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ClientTokenConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ConcurrentOperationException`.
    pub fn is_concurrent_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ConcurrentOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::GeneralServiceException`.
    pub fn is_general_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::GeneralServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::HandlerFailureException`.
    pub fn is_handler_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::HandlerFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::HandlerInternalFailureException`.
    pub fn is_handler_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::HandlerInternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::NetworkFailureException`.
    pub fn is_network_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::NetworkFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::NotStabilizedException`.
    pub fn is_not_stabilized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::NotStabilizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::NotUpdatableException`.
    pub fn is_not_updatable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::NotUpdatableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::PrivateTypeException`.
    pub fn is_private_type_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::PrivateTypeException(_))
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ServiceInternalErrorException`.
    pub fn is_service_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ServiceInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::TypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::UnsupportedActionException`.
    pub fn is_unsupported_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::UnsupportedActionException(_)
        )
    }
}
impl std::error::Error for UpdateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ClientTokenConflictException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ConcurrentOperationException(_inner) => Some(_inner),
            UpdateResourceErrorKind::GeneralServiceException(_inner) => Some(_inner),
            UpdateResourceErrorKind::HandlerFailureException(_inner) => Some(_inner),
            UpdateResourceErrorKind::HandlerInternalFailureException(_inner) => Some(_inner),
            UpdateResourceErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            UpdateResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateResourceErrorKind::NetworkFailureException(_inner) => Some(_inner),
            UpdateResourceErrorKind::NotStabilizedException(_inner) => Some(_inner),
            UpdateResourceErrorKind::NotUpdatableException(_inner) => Some(_inner),
            UpdateResourceErrorKind::PrivateTypeException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ServiceInternalErrorException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResourceErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::UnsupportedActionException(_inner) => Some(_inner),
            UpdateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource doesn't support this resource operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedActionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedActionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedActionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedActionException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedActionException {}
/// See [`UnsupportedActionException`](crate::error::UnsupportedActionException)
pub mod unsupported_action_exception {
    /// A builder for [`UnsupportedActionException`](crate::error::UnsupportedActionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedActionException`](crate::error::UnsupportedActionException)
        pub fn build(self) -> crate::error::UnsupportedActionException {
            crate::error::UnsupportedActionException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedActionException {
    /// Creates a new builder-style object to manufacture [`UnsupportedActionException`](crate::error::UnsupportedActionException)
    pub fn builder() -> crate::error::unsupported_action_exception::Builder {
        crate::error::unsupported_action_exception::Builder::default()
    }
}

/// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TypeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TypeNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TypeNotFoundException {}
/// See [`TypeNotFoundException`](crate::error::TypeNotFoundException)
pub mod type_not_found_exception {
    /// A builder for [`TypeNotFoundException`](crate::error::TypeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeNotFoundException`](crate::error::TypeNotFoundException)
        pub fn build(self) -> crate::error::TypeNotFoundException {
            crate::error::TypeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TypeNotFoundException {
    /// Creates a new builder-style object to manufacture [`TypeNotFoundException`](crate::error::TypeNotFoundException)
    pub fn builder() -> crate::error::type_not_found_exception::Builder {
        crate::error::type_not_found_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLimitExceededException {}
/// See [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
pub mod service_limit_exceeded_exception {
    /// A builder for [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
        pub fn build(self) -> crate::error::ServiceLimitExceededException {
            crate::error::ServiceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    pub fn builder() -> crate::error::service_limit_exceeded_exception::Builder {
        crate::error::service_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceInternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceInternalErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceInternalErrorException {}
/// See [`ServiceInternalErrorException`](crate::error::ServiceInternalErrorException)
pub mod service_internal_error_exception {
    /// A builder for [`ServiceInternalErrorException`](crate::error::ServiceInternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInternalErrorException`](crate::error::ServiceInternalErrorException)
        pub fn build(self) -> crate::error::ServiceInternalErrorException {
            crate::error::ServiceInternalErrorException {
                message: self.message,
            }
        }
    }
}
impl ServiceInternalErrorException {
    /// Creates a new builder-style object to manufacture [`ServiceInternalErrorException`](crate::error::ServiceInternalErrorException)
    pub fn builder() -> crate::error::service_internal_error_exception::Builder {
        crate::error::service_internal_error_exception::Builder::default()
    }
}

/// <p>A resource with the specified identifier can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can't be acted upon until that operation is finished.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceConflictException {}
/// See [`ResourceConflictException`](crate::error::ResourceConflictException)
pub mod resource_conflict_exception {
    /// A builder for [`ResourceConflictException`](crate::error::ResourceConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConflictException`](crate::error::ResourceConflictException)
        pub fn build(self) -> crate::error::ResourceConflictException {
            crate::error::ResourceConflictException {
                message: self.message,
            }
        }
    }
}
impl ResourceConflictException {
    /// Creates a new builder-style object to manufacture [`ResourceConflictException`](crate::error::ResourceConflictException)
    pub fn builder() -> crate::error::resource_conflict_exception::Builder {
        crate::error::resource_conflict_exception::Builder::default()
    }
}

/// <p>Cloud Control API hasn't received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PrivateTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PrivateTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PrivateTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PrivateTypeException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for PrivateTypeException {}
/// See [`PrivateTypeException`](crate::error::PrivateTypeException)
pub mod private_type_exception {
    /// A builder for [`PrivateTypeException`](crate::error::PrivateTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateTypeException`](crate::error::PrivateTypeException)
        pub fn build(self) -> crate::error::PrivateTypeException {
            crate::error::PrivateTypeException {
                message: self.message,
            }
        }
    }
}
impl PrivateTypeException {
    /// Creates a new builder-style object to manufacture [`PrivateTypeException`](crate::error::PrivateTypeException)
    pub fn builder() -> crate::error::private_type_exception::Builder {
        crate::error::private_type_exception::Builder::default()
    }
}

/// <p>One or more properties included in this resource operation are defined as create-only, and therefore can't be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotUpdatableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotUpdatableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotUpdatableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotUpdatableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotUpdatableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotUpdatableException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotUpdatableException {}
/// See [`NotUpdatableException`](crate::error::NotUpdatableException)
pub mod not_updatable_exception {
    /// A builder for [`NotUpdatableException`](crate::error::NotUpdatableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotUpdatableException`](crate::error::NotUpdatableException)
        pub fn build(self) -> crate::error::NotUpdatableException {
            crate::error::NotUpdatableException {
                message: self.message,
            }
        }
    }
}
impl NotUpdatableException {
    /// Creates a new builder-style object to manufacture [`NotUpdatableException`](crate::error::NotUpdatableException)
    pub fn builder() -> crate::error::not_updatable_exception::Builder {
        crate::error::not_updatable_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotStabilizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotStabilizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotStabilizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotStabilizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotStabilizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotStabilizedException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotStabilizedException {}
/// See [`NotStabilizedException`](crate::error::NotStabilizedException)
pub mod not_stabilized_exception {
    /// A builder for [`NotStabilizedException`](crate::error::NotStabilizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotStabilizedException`](crate::error::NotStabilizedException)
        pub fn build(self) -> crate::error::NotStabilizedException {
            crate::error::NotStabilizedException {
                message: self.message,
            }
        }
    }
}
impl NotStabilizedException {
    /// Creates a new builder-style object to manufacture [`NotStabilizedException`](crate::error::NotStabilizedException)
    pub fn builder() -> crate::error::not_stabilized_exception::Builder {
        crate::error::not_stabilized_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that the request couldn't be completed due to networking issues, such as a failure to receive a response from the server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NetworkFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NetworkFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NetworkFailureException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for NetworkFailureException {}
/// See [`NetworkFailureException`](crate::error::NetworkFailureException)
pub mod network_failure_exception {
    /// A builder for [`NetworkFailureException`](crate::error::NetworkFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFailureException`](crate::error::NetworkFailureException)
        pub fn build(self) -> crate::error::NetworkFailureException {
            crate::error::NetworkFailureException {
                message: self.message,
            }
        }
    }
}
impl NetworkFailureException {
    /// Creates a new builder-style object to manufacture [`NetworkFailureException`](crate::error::NetworkFailureException)
    pub fn builder() -> crate::error::network_failure_exception::Builder {
        crate::error::network_failure_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that the credentials provided by the user are invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCredentialsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCredentialsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCredentialsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCredentialsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCredentialsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCredentialsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCredentialsException {}
/// See [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
pub mod invalid_credentials_exception {
    /// A builder for [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
        pub fn build(self) -> crate::error::InvalidCredentialsException {
            crate::error::InvalidCredentialsException {
                message: self.message,
            }
        }
    }
}
impl InvalidCredentialsException {
    /// Creates a new builder-style object to manufacture [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
    pub fn builder() -> crate::error::invalid_credentials_exception::Builder {
        crate::error::invalid_credentials_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandlerInternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HandlerInternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandlerInternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HandlerInternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HandlerInternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HandlerInternalFailureException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for HandlerInternalFailureException {}
/// See [`HandlerInternalFailureException`](crate::error::HandlerInternalFailureException)
pub mod handler_internal_failure_exception {
    /// A builder for [`HandlerInternalFailureException`](crate::error::HandlerInternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HandlerInternalFailureException`](crate::error::HandlerInternalFailureException)
        pub fn build(self) -> crate::error::HandlerInternalFailureException {
            crate::error::HandlerInternalFailureException {
                message: self.message,
            }
        }
    }
}
impl HandlerInternalFailureException {
    /// Creates a new builder-style object to manufacture [`HandlerInternalFailureException`](crate::error::HandlerInternalFailureException)
    pub fn builder() -> crate::error::handler_internal_failure_exception::Builder {
        crate::error::handler_internal_failure_exception::Builder::default()
    }
}

/// <p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandlerFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HandlerFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandlerFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HandlerFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HandlerFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HandlerFailureException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for HandlerFailureException {}
/// See [`HandlerFailureException`](crate::error::HandlerFailureException)
pub mod handler_failure_exception {
    /// A builder for [`HandlerFailureException`](crate::error::HandlerFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HandlerFailureException`](crate::error::HandlerFailureException)
        pub fn build(self) -> crate::error::HandlerFailureException {
            crate::error::HandlerFailureException {
                message: self.message,
            }
        }
    }
}
impl HandlerFailureException {
    /// Creates a new builder-style object to manufacture [`HandlerFailureException`](crate::error::HandlerFailureException)
    pub fn builder() -> crate::error::handler_failure_exception::Builder {
        crate::error::handler_failure_exception::Builder::default()
    }
}

/// <p>The resource handler has returned that the downstream service generated an error that doesn't map to any other handler error code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneralServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GeneralServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneralServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GeneralServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GeneralServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GeneralServiceException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for GeneralServiceException {}
/// See [`GeneralServiceException`](crate::error::GeneralServiceException)
pub mod general_service_exception {
    /// A builder for [`GeneralServiceException`](crate::error::GeneralServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneralServiceException`](crate::error::GeneralServiceException)
        pub fn build(self) -> crate::error::GeneralServiceException {
            crate::error::GeneralServiceException {
                message: self.message,
            }
        }
    }
}
impl GeneralServiceException {
    /// Creates a new builder-style object to manufacture [`GeneralServiceException`](crate::error::GeneralServiceException)
    pub fn builder() -> crate::error::general_service_exception::Builder {
        crate::error::general_service_exception::Builder::default()
    }
}

/// <p>Another resource operation is currently being performed on this resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentOperationException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentOperationException {}
/// See [`ConcurrentOperationException`](crate::error::ConcurrentOperationException)
pub mod concurrent_operation_exception {
    /// A builder for [`ConcurrentOperationException`](crate::error::ConcurrentOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentOperationException`](crate::error::ConcurrentOperationException)
        pub fn build(self) -> crate::error::ConcurrentOperationException {
            crate::error::ConcurrentOperationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentOperationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentOperationException`](crate::error::ConcurrentOperationException)
    pub fn builder() -> crate::error::concurrent_operation_exception::Builder {
        crate::error::concurrent_operation_exception::Builder::default()
    }
}

/// <p>The specified client token has already been used in another resource request.</p>
/// <p>It's best practice for client tokens to be unique for each resource operation request. However, client token expire after 36 hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientTokenConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClientTokenConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientTokenConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClientTokenConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientTokenConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientTokenConflictException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientTokenConflictException {}
/// See [`ClientTokenConflictException`](crate::error::ClientTokenConflictException)
pub mod client_token_conflict_exception {
    /// A builder for [`ClientTokenConflictException`](crate::error::ClientTokenConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientTokenConflictException`](crate::error::ClientTokenConflictException)
        pub fn build(self) -> crate::error::ClientTokenConflictException {
            crate::error::ClientTokenConflictException {
                message: self.message,
            }
        }
    }
}
impl ClientTokenConflictException {
    /// Creates a new builder-style object to manufacture [`ClientTokenConflictException`](crate::error::ClientTokenConflictException)
    pub fn builder() -> crate::error::client_token_conflict_exception::Builder {
        crate::error::client_token_conflict_exception::Builder::default()
    }
}

/// <p>The resource with the name requested already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>A resource operation with the specified request token can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestTokenNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestTokenNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestTokenNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestTokenNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestTokenNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestTokenNotFoundException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestTokenNotFoundException {}
/// See [`RequestTokenNotFoundException`](crate::error::RequestTokenNotFoundException)
pub mod request_token_not_found_exception {
    /// A builder for [`RequestTokenNotFoundException`](crate::error::RequestTokenNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestTokenNotFoundException`](crate::error::RequestTokenNotFoundException)
        pub fn build(self) -> crate::error::RequestTokenNotFoundException {
            crate::error::RequestTokenNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RequestTokenNotFoundException {
    /// Creates a new builder-style object to manufacture [`RequestTokenNotFoundException`](crate::error::RequestTokenNotFoundException)
    pub fn builder() -> crate::error::request_token_not_found_exception::Builder {
        crate::error::request_token_not_found_exception::Builder::default()
    }
}

/// <p>The resource is currently being modified by another operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}
