// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the current status of a resource operation request. For more information, see
/// <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html">Managing resource operation requests</a> in the
/// <i>Amazon Web Services Cloud Control API User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProgressEvent {
    /// <p>The name of the resource type used in the operation.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The primary identifier for the resource.</p>
    /// <note>
    /// <p>In some cases, the resource identifier may be available before the resource operation
    /// has reached a status of <code>SUCCESS</code>.</p>
    /// </note>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The unique token representing this resource operation request.</p>
    /// <p>Use the <code>RequestToken</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation
    /// request.</p>
    pub request_token: std::option::Option<std::string::String>,
    /// <p>The resource operation type.</p>
    pub operation: std::option::Option<crate::model::Operation>,
    /// <p>The current status of the resource operation request.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code>: The resource operation has not yet started.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The resource operation is currently in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The resource operation has successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The resource operation has failed. Refer to the error code and
    /// status message for more information.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_IN_PROGRESS</code>: The resource operation is in the process of being
    /// canceled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_COMPLETE</code>: The resource operation has been canceled.</p>
    /// </li>
    /// </ul>
    pub operation_status: std::option::Option<crate::model::OperationStatus>,
    /// <p>When the resource operation request was initiated.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A JSON string containing the resource model, consisting of each resource property and its
    /// current value.</p>
    pub resource_model: std::option::Option<std::string::String>,
    /// <p>Any message explaining the current status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>For requests with a status of <code>FAILED</code>, the associated error code.</p>
    /// <p>For error code definitions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html">Handler error codes</a> in the <i>CloudFormation Command
    /// Line Interface User Guide for Extension Development</i>.</p>
    pub error_code: std::option::Option<crate::model::HandlerErrorCode>,
    /// <p>When to next request the status of this resource operation request.</p>
    pub retry_after: std::option::Option<aws_smithy_types::Instant>,
}
impl ProgressEvent {
    /// <p>The name of the resource type used in the operation.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The primary identifier for the resource.</p>
    /// <note>
    /// <p>In some cases, the resource identifier may be available before the resource operation
    /// has reached a status of <code>SUCCESS</code>.</p>
    /// </note>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The unique token representing this resource operation request.</p>
    /// <p>Use the <code>RequestToken</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation
    /// request.</p>
    pub fn request_token(&self) -> std::option::Option<&str> {
        self.request_token.as_deref()
    }
    /// <p>The resource operation type.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::Operation> {
        self.operation.as_ref()
    }
    /// <p>The current status of the resource operation request.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code>: The resource operation has not yet started.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The resource operation is currently in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The resource operation has successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The resource operation has failed. Refer to the error code and
    /// status message for more information.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_IN_PROGRESS</code>: The resource operation is in the process of being
    /// canceled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_COMPLETE</code>: The resource operation has been canceled.</p>
    /// </li>
    /// </ul>
    pub fn operation_status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.operation_status.as_ref()
    }
    /// <p>When the resource operation request was initiated.</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_time.as_ref()
    }
    /// <p>A JSON string containing the resource model, consisting of each resource property and its
    /// current value.</p>
    pub fn resource_model(&self) -> std::option::Option<&str> {
        self.resource_model.as_deref()
    }
    /// <p>Any message explaining the current status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>For requests with a status of <code>FAILED</code>, the associated error code.</p>
    /// <p>For error code definitions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html">Handler error codes</a> in the <i>CloudFormation Command
    /// Line Interface User Guide for Extension Development</i>.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::HandlerErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>When to next request the status of this resource operation request.</p>
    pub fn retry_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.retry_after.as_ref()
    }
}
impl std::fmt::Debug for ProgressEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProgressEvent");
        formatter.field("type_name", &self.type_name);
        formatter.field("identifier", &self.identifier);
        formatter.field("request_token", &self.request_token);
        formatter.field("operation", &self.operation);
        formatter.field("operation_status", &self.operation_status);
        formatter.field("event_time", &self.event_time);
        formatter.field("resource_model", &"*** Sensitive Data Redacted ***");
        formatter.field("status_message", &self.status_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("retry_after", &self.retry_after);
        formatter.finish()
    }
}
/// See [`ProgressEvent`](crate::model::ProgressEvent)
pub mod progress_event {
    /// A builder for [`ProgressEvent`](crate::model::ProgressEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) request_token: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::Operation>,
        pub(crate) operation_status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resource_model: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::HandlerErrorCode>,
        pub(crate) retry_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the resource type used in the operation.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the resource type used in the operation.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The primary identifier for the resource.</p>
        /// <note>
        /// <p>In some cases, the resource identifier may be available before the resource operation
        /// has reached a status of <code>SUCCESS</code>.</p>
        /// </note>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The primary identifier for the resource.</p>
        /// <note>
        /// <p>In some cases, the resource identifier may be available before the resource operation
        /// has reached a status of <code>SUCCESS</code>.</p>
        /// </note>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The unique token representing this resource operation request.</p>
        /// <p>Use the <code>RequestToken</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation
        /// request.</p>
        pub fn request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token = Some(input.into());
            self
        }
        /// <p>The unique token representing this resource operation request.</p>
        /// <p>Use the <code>RequestToken</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation
        /// request.</p>
        pub fn set_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token = input;
            self
        }
        /// <p>The resource operation type.</p>
        pub fn operation(mut self, input: crate::model::Operation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The resource operation type.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::Operation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the resource operation request.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code>: The resource operation has not yet started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The resource operation is currently in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The resource operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The resource operation has failed. Refer to the error code and
        /// status message for more information.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_IN_PROGRESS</code>: The resource operation is in the process of being
        /// canceled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_COMPLETE</code>: The resource operation has been canceled.</p>
        /// </li>
        /// </ul>
        pub fn operation_status(mut self, input: crate::model::OperationStatus) -> Self {
            self.operation_status = Some(input);
            self
        }
        /// <p>The current status of the resource operation request.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code>: The resource operation has not yet started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The resource operation is currently in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The resource operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The resource operation has failed. Refer to the error code and
        /// status message for more information.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_IN_PROGRESS</code>: The resource operation is in the process of being
        /// canceled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_COMPLETE</code>: The resource operation has been canceled.</p>
        /// </li>
        /// </ul>
        pub fn set_operation_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.operation_status = input;
            self
        }
        /// <p>When the resource operation request was initiated.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>When the resource operation request was initiated.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>A JSON string containing the resource model, consisting of each resource property and its
        /// current value.</p>
        pub fn resource_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_model = Some(input.into());
            self
        }
        /// <p>A JSON string containing the resource model, consisting of each resource property and its
        /// current value.</p>
        pub fn set_resource_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_model = input;
            self
        }
        /// <p>Any message explaining the current status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Any message explaining the current status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>For requests with a status of <code>FAILED</code>, the associated error code.</p>
        /// <p>For error code definitions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html">Handler error codes</a> in the <i>CloudFormation Command
        /// Line Interface User Guide for Extension Development</i>.</p>
        pub fn error_code(mut self, input: crate::model::HandlerErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>For requests with a status of <code>FAILED</code>, the associated error code.</p>
        /// <p>For error code definitions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html">Handler error codes</a> in the <i>CloudFormation Command
        /// Line Interface User Guide for Extension Development</i>.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::HandlerErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>When to next request the status of this resource operation request.</p>
        pub fn retry_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.retry_after = Some(input);
            self
        }
        /// <p>When to next request the status of this resource operation request.</p>
        pub fn set_retry_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.retry_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ProgressEvent`](crate::model::ProgressEvent)
        pub fn build(self) -> crate::model::ProgressEvent {
            crate::model::ProgressEvent {
                type_name: self.type_name,
                identifier: self.identifier,
                request_token: self.request_token,
                operation: self.operation,
                operation_status: self.operation_status,
                event_time: self.event_time,
                resource_model: self.resource_model,
                status_message: self.status_message,
                error_code: self.error_code,
                retry_after: self.retry_after,
            }
        }
    }
}
impl ProgressEvent {
    /// Creates a new builder-style object to manufacture [`ProgressEvent`](crate::model::ProgressEvent)
    pub fn builder() -> crate::model::progress_event::Builder {
        crate::model::progress_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandlerErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    GeneralServiceException,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCredentials,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequest,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFailure,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    NotStabilized,
    #[allow(missing_docs)] // documentation missing in model
    NotUpdatable,
    #[allow(missing_docs)] // documentation missing in model
    ResourceConflict,
    #[allow(missing_docs)] // documentation missing in model
    ServiceInternalError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ServiceTimeout,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandlerErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => HandlerErrorCode::AccessDenied,
            "AlreadyExists" => HandlerErrorCode::AlreadyExists,
            "GeneralServiceException" => HandlerErrorCode::GeneralServiceException,
            "InternalFailure" => HandlerErrorCode::InternalFailure,
            "InvalidCredentials" => HandlerErrorCode::InvalidCredentials,
            "InvalidRequest" => HandlerErrorCode::InvalidRequest,
            "NetworkFailure" => HandlerErrorCode::NetworkFailure,
            "NotFound" => HandlerErrorCode::NotFound,
            "NotStabilized" => HandlerErrorCode::NotStabilized,
            "NotUpdatable" => HandlerErrorCode::NotUpdatable,
            "ResourceConflict" => HandlerErrorCode::ResourceConflict,
            "ServiceInternalError" => HandlerErrorCode::ServiceInternalError,
            "ServiceLimitExceeded" => HandlerErrorCode::ServiceLimitExceeded,
            "ServiceTimeout" => HandlerErrorCode::ServiceTimeout,
            "Throttling" => HandlerErrorCode::Throttling,
            other => HandlerErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HandlerErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandlerErrorCode::from(s))
    }
}
impl HandlerErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandlerErrorCode::AccessDenied => "AccessDenied",
            HandlerErrorCode::AlreadyExists => "AlreadyExists",
            HandlerErrorCode::GeneralServiceException => "GeneralServiceException",
            HandlerErrorCode::InternalFailure => "InternalFailure",
            HandlerErrorCode::InvalidCredentials => "InvalidCredentials",
            HandlerErrorCode::InvalidRequest => "InvalidRequest",
            HandlerErrorCode::NetworkFailure => "NetworkFailure",
            HandlerErrorCode::NotFound => "NotFound",
            HandlerErrorCode::NotStabilized => "NotStabilized",
            HandlerErrorCode::NotUpdatable => "NotUpdatable",
            HandlerErrorCode::ResourceConflict => "ResourceConflict",
            HandlerErrorCode::ServiceInternalError => "ServiceInternalError",
            HandlerErrorCode::ServiceLimitExceeded => "ServiceLimitExceeded",
            HandlerErrorCode::ServiceTimeout => "ServiceTimeout",
            HandlerErrorCode::Throttling => "Throttling",
            HandlerErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "AlreadyExists",
            "GeneralServiceException",
            "InternalFailure",
            "InvalidCredentials",
            "InvalidRequest",
            "NetworkFailure",
            "NotFound",
            "NotStabilized",
            "NotUpdatable",
            "ResourceConflict",
            "ServiceInternalError",
            "ServiceLimitExceeded",
            "ServiceTimeout",
            "Throttling",
        ]
    }
}
impl AsRef<str> for HandlerErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    CancelComplete,
    #[allow(missing_docs)] // documentation missing in model
    CancelInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCEL_COMPLETE" => OperationStatus::CancelComplete,
            "CANCEL_IN_PROGRESS" => OperationStatus::CancelInProgress,
            "FAILED" => OperationStatus::Failed,
            "IN_PROGRESS" => OperationStatus::InProgress,
            "PENDING" => OperationStatus::Pending,
            "SUCCESS" => OperationStatus::Success,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::CancelComplete => "CANCEL_COMPLETE",
            OperationStatus::CancelInProgress => "CANCEL_IN_PROGRESS",
            OperationStatus::Failed => "FAILED",
            OperationStatus::InProgress => "IN_PROGRESS",
            OperationStatus::Pending => "PENDING",
            OperationStatus::Success => "SUCCESS",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCEL_COMPLETE",
            "CANCEL_IN_PROGRESS",
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "SUCCESS",
        ]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operation {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operation {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => Operation::Create,
            "DELETE" => Operation::Delete,
            "UPDATE" => Operation::Update,
            other => Operation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operation::from(s))
    }
}
impl Operation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operation::Create => "CREATE",
            Operation::Delete => "DELETE",
            Operation::Update => "UPDATE",
            Operation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "DELETE", "UPDATE"]
    }
}
impl AsRef<str> for Operation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about a provisioned resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDescription {
    /// <p>The primary identifier for the resource.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
    /// resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>A list of the resource properties and their current values.</p>
    pub properties: std::option::Option<std::string::String>,
}
impl ResourceDescription {
    /// <p>The primary identifier for the resource.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
    /// resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>A list of the resource properties and their current values.</p>
    pub fn properties(&self) -> std::option::Option<&str> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for ResourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDescription");
        formatter.field("identifier", &self.identifier);
        formatter.field("properties", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ResourceDescription`](crate::model::ResourceDescription)
pub mod resource_description {
    /// A builder for [`ResourceDescription`](crate::model::ResourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The primary identifier for the resource.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
        /// resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The primary identifier for the resource.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
        /// resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>A list of the resource properties and their current values.</p>
        pub fn properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties = Some(input.into());
            self
        }
        /// <p>A list of the resource properties and their current values.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDescription`](crate::model::ResourceDescription)
        pub fn build(self) -> crate::model::ResourceDescription {
            crate::model::ResourceDescription {
                identifier: self.identifier,
                properties: self.properties,
            }
        }
    }
}
impl ResourceDescription {
    /// Creates a new builder-style object to manufacture [`ResourceDescription`](crate::model::ResourceDescription)
    pub fn builder() -> crate::model::resource_description::Builder {
        crate::model::resource_description::Builder::default()
    }
}

/// <p>The filter criteria to use in determining the requests returned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceRequestStatusFilter {
    /// <p>The operation types to include in the filter.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::Operation>>,
    /// <p>The operation statuses to include in the filter.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code>: The operation has been requested, but not yet initiated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The operation is currently in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The operation has successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The operation has failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_IN_PROGRESS</code>: The operation is currently in the process of being
    /// canceled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_COMPLETE</code>: The operation has been canceled.</p>
    /// </li>
    /// </ul>
    pub operation_statuses: std::option::Option<std::vec::Vec<crate::model::OperationStatus>>,
}
impl ResourceRequestStatusFilter {
    /// <p>The operation types to include in the filter.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::Operation]> {
        self.operations.as_deref()
    }
    /// <p>The operation statuses to include in the filter.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code>: The operation has been requested, but not yet initiated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The operation is currently in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The operation has successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The operation has failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_IN_PROGRESS</code>: The operation is currently in the process of being
    /// canceled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_COMPLETE</code>: The operation has been canceled.</p>
    /// </li>
    /// </ul>
    pub fn operation_statuses(&self) -> std::option::Option<&[crate::model::OperationStatus]> {
        self.operation_statuses.as_deref()
    }
}
impl std::fmt::Debug for ResourceRequestStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceRequestStatusFilter");
        formatter.field("operations", &self.operations);
        formatter.field("operation_statuses", &self.operation_statuses);
        formatter.finish()
    }
}
/// See [`ResourceRequestStatusFilter`](crate::model::ResourceRequestStatusFilter)
pub mod resource_request_status_filter {
    /// A builder for [`ResourceRequestStatusFilter`](crate::model::ResourceRequestStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::Operation>>,
        pub(crate) operation_statuses:
            std::option::Option<std::vec::Vec<crate::model::OperationStatus>>,
    }
    impl Builder {
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The operation types to include in the filter.</p>
        pub fn operations(mut self, input: impl Into<crate::model::Operation>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>The operation types to include in the filter.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Operation>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// Appends an item to `operation_statuses`.
        ///
        /// To override the contents of this collection use [`set_operation_statuses`](Self::set_operation_statuses).
        ///
        /// <p>The operation statuses to include in the filter.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code>: The operation has been requested, but not yet initiated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The operation is currently in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The operation has failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_IN_PROGRESS</code>: The operation is currently in the process of being
        /// canceled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_COMPLETE</code>: The operation has been canceled.</p>
        /// </li>
        /// </ul>
        pub fn operation_statuses(
            mut self,
            input: impl Into<crate::model::OperationStatus>,
        ) -> Self {
            let mut v = self.operation_statuses.unwrap_or_default();
            v.push(input.into());
            self.operation_statuses = Some(v);
            self
        }
        /// <p>The operation statuses to include in the filter.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code>: The operation has been requested, but not yet initiated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The operation is currently in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The operation has failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_IN_PROGRESS</code>: The operation is currently in the process of being
        /// canceled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_COMPLETE</code>: The operation has been canceled.</p>
        /// </li>
        /// </ul>
        pub fn set_operation_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OperationStatus>>,
        ) -> Self {
            self.operation_statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceRequestStatusFilter`](crate::model::ResourceRequestStatusFilter)
        pub fn build(self) -> crate::model::ResourceRequestStatusFilter {
            crate::model::ResourceRequestStatusFilter {
                operations: self.operations,
                operation_statuses: self.operation_statuses,
            }
        }
    }
}
impl ResourceRequestStatusFilter {
    /// Creates a new builder-style object to manufacture [`ResourceRequestStatusFilter`](crate::model::ResourceRequestStatusFilter)
    pub fn builder() -> crate::model::resource_request_status_filter::Builder {
        crate::model::resource_request_status_filter::Builder::default()
    }
}
