// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateEnvironmentEC2` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentEC2Error {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentEC2ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironmentEC2` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentEC2ErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentEC2Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentEC2ErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEnvironmentEC2ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentEC2Error {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentEC2Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEnvironmentEC2Error {
    /// Creates a new `CreateEnvironmentEC2Error`.
    pub fn new(kind: CreateEnvironmentEC2ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentEC2Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentEC2ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentEC2Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentEC2ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentEC2ErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentEC2ErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentEC2Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentEC2ErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEnvironmentEC2ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentMembershipErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentMembershipErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEnvironmentMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentMembershipError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEnvironmentMembershipError {
    /// Creates a new `CreateEnvironmentMembershipError`.
    pub fn new(kind: CreateEnvironmentMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentMembershipErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentMembershipErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentMembershipErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEnvironmentMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEnvironmentError {
    /// Creates a new `DeleteEnvironmentError`.
    pub fn new(kind: DeleteEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteEnvironmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentMembershipErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentMembershipErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEnvironmentMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEnvironmentMembershipError {
    /// Creates a new `DeleteEnvironmentMembershipError`.
    pub fn new(kind: DeleteEnvironmentMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentMembershipErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentMembershipErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentMembershipErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEnvironmentMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironmentMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentMembershipsError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentMembershipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentMembershipsErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentMembershipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentMembershipsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeEnvironmentMembershipsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeEnvironmentMembershipsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeEnvironmentMembershipsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentMembershipsErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentMembershipsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeEnvironmentMembershipsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentMembershipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentMembershipsError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentMembershipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentMembershipsError {
    /// Creates a new `DescribeEnvironmentMembershipsError`.
    pub fn new(
        kind: DescribeEnvironmentMembershipsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentMembershipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentMembershipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentMembershipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentMembershipsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentMembershipsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentMembershipsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentMembershipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentMembershipsErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeEnvironmentMembershipsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeEnvironmentMembershipsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeEnvironmentMembershipsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeEnvironmentMembershipsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeEnvironmentMembershipsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeEnvironmentMembershipsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeEnvironmentMembershipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentsErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentsError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentsError {
    /// Creates a new `DescribeEnvironmentsError`.
    pub fn new(kind: DescribeEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentsErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironmentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentStatusErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentStatusErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentStatusErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEnvironmentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentStatusError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentStatusError {
    /// Creates a new `DescribeEnvironmentStatusError`.
    pub fn new(kind: DescribeEnvironmentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEnvironmentStatusErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentStatusErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentStatusErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeEnvironmentStatusErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEnvironmentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentsErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEnvironmentsError {
    /// Creates a new `ListEnvironmentsError`.
    pub fn new(kind: ListEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListEnvironmentsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListEnvironmentsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListEnvironmentsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ConflictException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A concurrent access issue occurred.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A concurrent access issue occurred.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEnvironmentError {
    /// Creates a new `UpdateEnvironmentError`.
    pub fn new(kind: UpdateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateEnvironmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentMembershipError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironmentMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentMembershipErrorKind {
    /// <p>The target request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An access permissions issue occurred.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal server error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>A service limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The target resource cannot be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many service requests were made over the given time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentMembershipErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEnvironmentMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentMembershipError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEnvironmentMembershipError {
    /// Creates a new `UpdateEnvironmentMembershipError`.
    pub fn new(kind: UpdateEnvironmentMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentMembershipErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentMembershipErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentMembershipErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEnvironmentMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Too many service requests were made over the given time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The target resource cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>A service limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>An internal server error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>An access permissions issue occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>A conflict occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The target request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>A concurrent access issue occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentAccessException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub class_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl ConcurrentAccessException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn class_name(&self) -> std::option::Option<&str> {
        self.class_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for ConcurrentAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentAccessException");
        formatter.field("message", &self.message);
        formatter.field("class_name", &self.class_name);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ConcurrentAccessException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentAccessException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentAccessException {}
/// See [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
pub mod concurrent_access_exception {
    /// A builder for [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
        pub fn build(self) -> crate::error::ConcurrentAccessException {
            crate::error::ConcurrentAccessException {
                message: self.message,
                class_name: self.class_name,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl ConcurrentAccessException {
    /// Creates a new builder-style object to manufacture [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
    pub fn builder() -> crate::error::concurrent_access_exception::Builder {
        crate::error::concurrent_access_exception::Builder::default()
    }
}
