// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Cloud9
///
/// Client for invoking operations on AWS Cloud9. Each operation on AWS Cloud9 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloud9::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloud9::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloud9::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateEnvironmentEC2`](crate::client::fluent_builders::CreateEnvironmentEC2) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_name): <p>The name of the environment to create.</p>  <p>This name is visible to other IAM users in the same Amazon Web Services account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_description): <p>The description of the environment to create.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_client_request_token): <p>A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in the <i>Amazon EC2 API Reference</i>.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_instance_type): <p>The type of instance to connect to the environment (for example, <code>t2.micro</code>).</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_subnet_id): <p>The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance.</p>
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_image_id): <p>The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.</p>  <p>The default AMI is used if the parameter isn't explicitly assigned a value in the request. Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2, which includes long term support through 2023.</p>  <p> <b>AMI aliases </b> </p>  <ul>   <li> <p> <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b> </p> </li>   <li> <p>Amazon Linux 2: <code>amazonlinux-2-x86_64</code> </p> </li>   <li> <p>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code> </p> </li>  </ul>  <p> <b>SSM paths</b> </p>  <ul>   <li> <p> <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b> </p> </li>   <li> <p>Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code> </p> </li>   <li> <p>Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code> </p> </li>  </ul>
    ///   - [`automatic_stop_time_minutes(i32)`](crate::client::fluent_builders::CreateEnvironmentEC2::automatic_stop_time_minutes) / [`set_automatic_stop_time_minutes(Option<i32>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_automatic_stop_time_minutes): <p>The number of minutes until the running instance is shut down after the environment has last been used.</p>
    ///   - [`owner_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::owner_arn) / [`set_owner_arn(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_owner_arn): <p>The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEnvironmentEC2::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_tags): <p>An array of key-value pairs that will be associated with the new Cloud9 development environment.</p>
    ///   - [`connection_type(ConnectionType)`](crate::client::fluent_builders::CreateEnvironmentEC2::connection_type) / [`set_connection_type(Option<ConnectionType>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_connection_type): <p>The connection type used for connecting to an Amazon EC2 environment. Valid values are <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through Amazon EC2 Systems Manager).</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager</a> in the <i>Cloud9 User Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateEnvironmentEC2::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateEnvironmentEC2::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateEnvironmentEc2Output`](crate::output::CreateEnvironmentEc2Output) with field(s):
    ///   - [`environment_id(Option<String>)`](crate::output::CreateEnvironmentEc2Output::environment_id): <p>The ID of the environment that was created.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentEC2Error>`](crate::error::CreateEnvironmentEC2Error)
    pub fn create_environment_ec2(&self) -> fluent_builders::CreateEnvironmentEC2<C, M, R> {
        fluent_builders::CreateEnvironmentEC2::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEnvironmentMembership`](crate::client::fluent_builders::CreateEnvironmentMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentMembership::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentMembership::set_environment_id): <p>The ID of the environment that contains the environment member you want to add.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironmentMembership::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::CreateEnvironmentMembership::set_user_arn): <p>The Amazon Resource Name (ARN) of the environment member you want to add.</p>
    ///   - [`permissions(MemberPermissions)`](crate::client::fluent_builders::CreateEnvironmentMembership::permissions) / [`set_permissions(Option<MemberPermissions>)`](crate::client::fluent_builders::CreateEnvironmentMembership::set_permissions): <p>The type of environment member permissions you want to associate with this environment member. Available values include:</p>  <ul>   <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>   <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>  </ul>
    /// - On success, responds with [`CreateEnvironmentMembershipOutput`](crate::output::CreateEnvironmentMembershipOutput) with field(s):
    ///   - [`membership(Option<EnvironmentMember>)`](crate::output::CreateEnvironmentMembershipOutput::membership): <p>Information about the environment member that was added.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentMembershipError>`](crate::error::CreateEnvironmentMembershipError)
    pub fn create_environment_membership(
        &self,
    ) -> fluent_builders::CreateEnvironmentMembership<C, M, R> {
        fluent_builders::CreateEnvironmentMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DeleteEnvironment::set_environment_id): <p>The ID of the environment to delete.</p>
    /// - On success, responds with [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)

    /// - On failure, responds with [`SdkError<DeleteEnvironmentError>`](crate::error::DeleteEnvironmentError)
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment<C, M, R> {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironmentMembership`](crate::client::fluent_builders::DeleteEnvironmentMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironmentMembership::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DeleteEnvironmentMembership::set_environment_id): <p>The ID of the environment to delete the environment member from.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironmentMembership::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::DeleteEnvironmentMembership::set_user_arn): <p>The Amazon Resource Name (ARN) of the environment member to delete from the environment.</p>
    /// - On success, responds with [`DeleteEnvironmentMembershipOutput`](crate::output::DeleteEnvironmentMembershipOutput)

    /// - On failure, responds with [`SdkError<DeleteEnvironmentMembershipError>`](crate::error::DeleteEnvironmentMembershipError)
    pub fn delete_environment_membership(
        &self,
    ) -> fluent_builders::DeleteEnvironmentMembership<C, M, R> {
        fluent_builders::DeleteEnvironmentMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentMemberships`](crate::client::fluent_builders::DescribeEnvironmentMemberships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEnvironmentMemberships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::set_user_arn): <p>The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::set_environment_id): <p>The ID of the environment to get environment member information about.</p>
    ///   - [`permissions(Vec<Permissions>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::permissions) / [`set_permissions(Option<Vec<Permissions>>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::set_permissions): <p>The type of environment member permissions to get information about. Available values include:</p>  <ul>   <li> <p> <code>owner</code>: Owns the environment.</p> </li>   <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>   <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>  </ul>  <p>If no value is specified, information about all environment members are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::set_next_token): <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEnvironmentMemberships::set_max_results): <p>The maximum number of environment members to get information about.</p>
    /// - On success, responds with [`DescribeEnvironmentMembershipsOutput`](crate::output::DescribeEnvironmentMembershipsOutput) with field(s):
    ///   - [`memberships(Option<Vec<EnvironmentMember>>)`](crate::output::DescribeEnvironmentMembershipsOutput::memberships): <p>Information about the environment members for the environment.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEnvironmentMembershipsOutput::next_token): <p>If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentMembershipsError>`](crate::error::DescribeEnvironmentMembershipsError)
    pub fn describe_environment_memberships(
        &self,
    ) -> fluent_builders::DescribeEnvironmentMemberships<C, M, R> {
        fluent_builders::DescribeEnvironmentMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironments`](crate::client::fluent_builders::DescribeEnvironments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeEnvironments::environment_ids) / [`set_environment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEnvironments::set_environment_ids): <p>The IDs of individual environments to get information about.</p>
    /// - On success, responds with [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput) with field(s):
    ///   - [`environments(Option<Vec<Environment>>)`](crate::output::DescribeEnvironmentsOutput::environments): <p>Information about the environments that are returned.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentsError>`](crate::error::DescribeEnvironmentsError)
    pub fn describe_environments(&self) -> fluent_builders::DescribeEnvironments<C, M, R> {
        fluent_builders::DescribeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentStatus`](crate::client::fluent_builders::DescribeEnvironmentStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentStatus::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentStatus::set_environment_id): <p>The ID of the environment to get status information about.</p>
    /// - On success, responds with [`DescribeEnvironmentStatusOutput`](crate::output::DescribeEnvironmentStatusOutput) with field(s):
    ///   - [`status(Option<EnvironmentStatus>)`](crate::output::DescribeEnvironmentStatusOutput::status): <p>The status of the environment. Available values include:</p>  <ul>   <li> <p> <code>connecting</code>: The environment is connecting.</p> </li>   <li> <p> <code>creating</code>: The environment is being created.</p> </li>   <li> <p> <code>deleting</code>: The environment is being deleted.</p> </li>   <li> <p> <code>error</code>: The environment is in an error state.</p> </li>   <li> <p> <code>ready</code>: The environment is ready.</p> </li>   <li> <p> <code>stopped</code>: The environment is stopped.</p> </li>   <li> <p> <code>stopping</code>: The environment is stopping.</p> </li>  </ul>
    ///   - [`message(Option<String>)`](crate::output::DescribeEnvironmentStatusOutput::message): <p>Any informational message about the status of the environment.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentStatusError>`](crate::error::DescribeEnvironmentStatusError)
    pub fn describe_environment_status(
        &self,
    ) -> fluent_builders::DescribeEnvironmentStatus<C, M, R> {
        fluent_builders::DescribeEnvironmentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnvironments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnvironments::set_next_token): <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnvironments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEnvironments::set_max_results): <p>The maximum number of environments to get identifiers for.</p>
    /// - On success, responds with [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListEnvironmentsOutput::next_token): <p>If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call.</p>
    ///   - [`environment_ids(Option<Vec<String>>)`](crate::output::ListEnvironmentsOutput::environment_ids): <p>The list of environment identifiers.</p>
    /// - On failure, responds with [`SdkError<ListEnvironmentsError>`](crate::error::ListEnvironmentsError)
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments<C, M, R> {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to get the tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags associated with the Cloud9 development environment.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to add tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of tags to add to the given Cloud9 development environment.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag names of the tags to remove from the given Cloud9 development environment.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_environment_id): <p>The ID of the environment to change settings.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_name): <p>A replacement name for the environment.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_description): <p>Any new or replacement description for the environment.</p>
    ///   - [`managed_credentials_action(ManagedCredentialsAction)`](crate::client::fluent_builders::UpdateEnvironment::managed_credentials_action) / [`set_managed_credentials_action(Option<ManagedCredentialsAction>)`](crate::client::fluent_builders::UpdateEnvironment::set_managed_credentials_action): <p>Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for an Cloud9 environment by using one of the following values:</p>  <ul>   <li> <p> <code>ENABLE</code> </p> </li>   <li> <p> <code>DISABLE</code> </p> </li>  </ul> <note>   <p>Only the environment owner can change the status of managed temporary credentials. An <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials is made by an account that's not the environment owner.</p>  </note>
    /// - On success, responds with [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)

    /// - On failure, responds with [`SdkError<UpdateEnvironmentError>`](crate::error::UpdateEnvironmentError)
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment<C, M, R> {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEnvironmentMembership`](crate::client::fluent_builders::UpdateEnvironmentMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironmentMembership::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::UpdateEnvironmentMembership::set_environment_id): <p>The ID of the environment for the environment member whose settings you want to change.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironmentMembership::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateEnvironmentMembership::set_user_arn): <p>The Amazon Resource Name (ARN) of the environment member whose settings you want to change.</p>
    ///   - [`permissions(MemberPermissions)`](crate::client::fluent_builders::UpdateEnvironmentMembership::permissions) / [`set_permissions(Option<MemberPermissions>)`](crate::client::fluent_builders::UpdateEnvironmentMembership::set_permissions): <p>The replacement type of environment member permissions you want to associate with this environment member. Available values include:</p>  <ul>   <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>   <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>  </ul>
    /// - On success, responds with [`UpdateEnvironmentMembershipOutput`](crate::output::UpdateEnvironmentMembershipOutput) with field(s):
    ///   - [`membership(Option<EnvironmentMember>)`](crate::output::UpdateEnvironmentMembershipOutput::membership): <p>Information about the environment member whose settings were changed.</p>
    /// - On failure, responds with [`SdkError<UpdateEnvironmentMembershipError>`](crate::error::UpdateEnvironmentMembershipError)
    pub fn update_environment_membership(
        &self,
    ) -> fluent_builders::UpdateEnvironmentMembership<C, M, R> {
        fluent_builders::UpdateEnvironmentMembership::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateEnvironmentEC2`.
    ///
    /// <p>Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironmentEC2<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_ec2_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentEC2<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentEC2`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentEc2Output,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentEC2Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentEc2InputOperationOutputAlias,
                crate::output::CreateEnvironmentEc2Output,
                crate::error::CreateEnvironmentEC2Error,
                crate::input::CreateEnvironmentEc2InputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to create.</p>
        /// <p>This name is visible to other IAM users in the same Amazon Web Services account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the environment to create.</p>
        /// <p>This name is visible to other IAM users in the same Amazon Web Services account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the environment to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the environment to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The type of instance to connect to the environment (for example, <code>t2.micro</code>).</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>The type of instance to connect to the environment (for example, <code>t2.micro</code>).</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.</p>
        /// <p>The default AMI is used if the parameter isn't explicitly assigned a value in the request. Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2, which includes long term support through 2023.</p>
        /// <p> <b>AMI aliases </b> </p>
        /// <ul>
        /// <li> <p> <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b> </p> </li>
        /// <li> <p>Amazon Linux 2: <code>amazonlinux-2-x86_64</code> </p> </li>
        /// <li> <p>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code> </p> </li>
        /// </ul>
        /// <p> <b>SSM paths</b> </p>
        /// <ul>
        /// <li> <p> <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b> </p> </li>
        /// <li> <p>Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code> </p> </li>
        /// <li> <p>Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code> </p> </li>
        /// </ul>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.</p>
        /// <p>The default AMI is used if the parameter isn't explicitly assigned a value in the request. Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2, which includes long term support through 2023.</p>
        /// <p> <b>AMI aliases </b> </p>
        /// <ul>
        /// <li> <p> <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b> </p> </li>
        /// <li> <p>Amazon Linux 2: <code>amazonlinux-2-x86_64</code> </p> </li>
        /// <li> <p>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code> </p> </li>
        /// </ul>
        /// <p> <b>SSM paths</b> </p>
        /// <ul>
        /// <li> <p> <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b> </p> </li>
        /// <li> <p>Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code> </p> </li>
        /// <li> <p>Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code> </p> </li>
        /// </ul>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The number of minutes until the running instance is shut down after the environment has last been used.</p>
        pub fn automatic_stop_time_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.automatic_stop_time_minutes(input);
            self
        }
        /// <p>The number of minutes until the running instance is shut down after the environment has last been used.</p>
        pub fn set_automatic_stop_time_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_automatic_stop_time_minutes(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator.</p>
        pub fn owner_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator.</p>
        pub fn set_owner_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that will be associated with the new Cloud9 development environment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs that will be associated with the new Cloud9 development environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The connection type used for connecting to an Amazon EC2 environment. Valid values are <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through Amazon EC2 Systems Manager).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager</a> in the <i>Cloud9 User Guide</i>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The connection type used for connecting to an Amazon EC2 environment. Valid values are <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through Amazon EC2 Systems Manager).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager</a> in the <i>Cloud9 User Guide</i>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironmentMembership`.
    ///
    /// <p>Adds an environment member to an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_membership_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentMembershipInputOperationOutputAlias,
                crate::output::CreateEnvironmentMembershipOutput,
                crate::error::CreateEnvironmentMembershipError,
                crate::input::CreateEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment that contains the environment member you want to add.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment that contains the environment member you want to add.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member you want to add.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member you want to add.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The type of environment member permissions you want to associate with this environment member. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        pub fn permissions(mut self, input: crate::model::MemberPermissions) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>The type of environment member permissions you want to associate with this environment member. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<crate::model::MemberPermissions>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl<C, M, R> DeleteEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentInputOperationOutputAlias,
                crate::output::DeleteEnvironmentOutput,
                crate::error::DeleteEnvironmentError,
                crate::input::DeleteEnvironmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to delete.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to delete.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentMembership`.
    ///
    /// <p>Deletes an environment member from an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_membership_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentMembershipInputOperationOutputAlias,
                crate::output::DeleteEnvironmentMembershipOutput,
                crate::error::DeleteEnvironmentMembershipError,
                crate::input::DeleteEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to delete the environment member from.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to delete the environment member from.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member to delete from the environment.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member to delete from the environment.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentMemberships`.
    ///
    /// <p>Gets information about environment members for an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_memberships_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentMembershipsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentMembershipsOutput,
                crate::error::DescribeEnvironmentMembershipsError,
                crate::input::DescribeEnvironmentMembershipsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEnvironmentMembershipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeEnvironmentMembershipsPaginator<C, M, R> {
            crate::paginator::DescribeEnvironmentMembershipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The ID of the environment to get environment member information about.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to get environment member information about.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The type of environment member permissions to get information about. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>owner</code>: Owns the environment.</p> </li>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        /// <p>If no value is specified, information about all environment members are returned.</p>
        pub fn permissions(mut self, input: crate::model::Permissions) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>The type of environment member permissions to get information about. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>owner</code>: Owns the environment.</p> </li>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        /// <p>If no value is specified, information about all environment members are returned.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permissions>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environment members to get information about.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of environment members to get information about.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironments`.
    ///
    /// <p>Gets information about Cloud9 development environments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environments_input::Builder,
    }
    impl<C, M, R> DescribeEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentsOutput,
                crate::error::DescribeEnvironmentsError,
                crate::input::DescribeEnvironmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `environmentIds`.
        ///
        /// To override the contents of this collection use [`set_environment_ids`](Self::set_environment_ids).
        ///
        /// <p>The IDs of individual environments to get information about.</p>
        pub fn environment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_ids(input.into());
            self
        }
        /// <p>The IDs of individual environments to get information about.</p>
        pub fn set_environment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentStatus`.
    ///
    /// <p>Gets status information for an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_status_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentStatusInputOperationOutputAlias,
                crate::output::DescribeEnvironmentStatusOutput,
                crate::error::DescribeEnvironmentStatusError,
                crate::input::DescribeEnvironmentStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to get status information about.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to get status information about.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>Gets a list of Cloud9 development environment identifiers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl<C, M, R> ListEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentsInputOperationOutputAlias,
                crate::output::ListEnvironmentsOutput,
                crate::error::ListEnvironmentsError,
                crate::input::ListEnvironmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnvironmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEnvironmentsPaginator<C, M, R> {
            crate::paginator::ListEnvironmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environments to get identifiers for.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of environments to get identifiers for.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of the tags associated with an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to get the tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to get the tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to an Cloud9 development environment.</p> <important>
    /// <p>Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to the given Cloud9 development environment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tags to add to the given Cloud9 development environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag names of the tags to remove from the given Cloud9 development environment.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag names of the tags to remove from the given Cloud9 development environment.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Changes the settings of an existing Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl<C, M, R> UpdateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentInputOperationOutputAlias,
                crate::output::UpdateEnvironmentOutput,
                crate::error::UpdateEnvironmentError,
                crate::input::UpdateEnvironmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to change settings.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to change settings.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>A replacement name for the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A replacement name for the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Any new or replacement description for the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Any new or replacement description for the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for an Cloud9 environment by using one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLE</code> </p> </li>
        /// <li> <p> <code>DISABLE</code> </p> </li>
        /// </ul> <note>
        /// <p>Only the environment owner can change the status of managed temporary credentials. An <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials is made by an account that's not the environment owner.</p>
        /// </note>
        pub fn managed_credentials_action(
            mut self,
            input: crate::model::ManagedCredentialsAction,
        ) -> Self {
            self.inner = self.inner.managed_credentials_action(input);
            self
        }
        /// <p>Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for an Cloud9 environment by using one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLE</code> </p> </li>
        /// <li> <p> <code>DISABLE</code> </p> </li>
        /// </ul> <note>
        /// <p>Only the environment owner can change the status of managed temporary credentials. An <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials is made by an account that's not the environment owner.</p>
        /// </note>
        pub fn set_managed_credentials_action(
            mut self,
            input: std::option::Option<crate::model::ManagedCredentialsAction>,
        ) -> Self {
            self.inner = self.inner.set_managed_credentials_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironmentMembership`.
    ///
    /// <p>Changes the settings of an existing environment member for an Cloud9 development environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_membership_input::Builder,
    }
    impl<C, M, R> UpdateEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentMembershipInputOperationOutputAlias,
                crate::output::UpdateEnvironmentMembershipOutput,
                crate::error::UpdateEnvironmentMembershipError,
                crate::input::UpdateEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment for the environment member whose settings you want to change.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment for the environment member whose settings you want to change.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member whose settings you want to change.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member whose settings you want to change.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The replacement type of environment member permissions you want to associate with this environment member. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        pub fn permissions(mut self, input: crate::model::MemberPermissions) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>The replacement type of environment member permissions you want to associate with this environment member. Available values include:</p>
        /// <ul>
        /// <li> <p> <code>read-only</code>: Has read-only access to the environment.</p> </li>
        /// <li> <p> <code>read-write</code>: Has read-write access to the environment.</p> </li>
        /// </ul>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<crate::model::MemberPermissions>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
