// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Cloud9
///
/// Client for invoking operations on AWS Cloud9. Each operation on AWS Cloud9 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloud9::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloud9::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloud9::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateEnvironmentEC2` operation.
    ///
    /// See [`CreateEnvironmentEC2`](crate::client::fluent_builders::CreateEnvironmentEC2) for more information about the
    /// operation and its arguments.
    pub fn create_environment_ec2(&self) -> fluent_builders::CreateEnvironmentEC2<C, M, R> {
        fluent_builders::CreateEnvironmentEC2::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironmentMembership` operation.
    ///
    /// See [`CreateEnvironmentMembership`](crate::client::fluent_builders::CreateEnvironmentMembership) for more information about the
    /// operation and its arguments.
    pub fn create_environment_membership(
        &self,
    ) -> fluent_builders::CreateEnvironmentMembership<C, M, R> {
        fluent_builders::CreateEnvironmentMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironment` operation.
    ///
    /// See [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) for more information about the
    /// operation and its arguments.
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment<C, M, R> {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironmentMembership` operation.
    ///
    /// See [`DeleteEnvironmentMembership`](crate::client::fluent_builders::DeleteEnvironmentMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_environment_membership(
        &self,
    ) -> fluent_builders::DeleteEnvironmentMembership<C, M, R> {
        fluent_builders::DeleteEnvironmentMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentMemberships` operation.
    ///
    /// See [`DescribeEnvironmentMemberships`](crate::client::fluent_builders::DescribeEnvironmentMemberships) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_memberships(
        &self,
    ) -> fluent_builders::DescribeEnvironmentMemberships<C, M, R> {
        fluent_builders::DescribeEnvironmentMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironments` operation.
    ///
    /// See [`DescribeEnvironments`](crate::client::fluent_builders::DescribeEnvironments) for more information about the
    /// operation and its arguments.
    pub fn describe_environments(&self) -> fluent_builders::DescribeEnvironments<C, M, R> {
        fluent_builders::DescribeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentStatus` operation.
    ///
    /// See [`DescribeEnvironmentStatus`](crate::client::fluent_builders::DescribeEnvironmentStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_status(
        &self,
    ) -> fluent_builders::DescribeEnvironmentStatus<C, M, R> {
        fluent_builders::DescribeEnvironmentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironments` operation.
    ///
    /// See [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) for more information about the
    /// operation and its arguments.
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments<C, M, R> {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironment` operation.
    ///
    /// See [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment<C, M, R> {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironmentMembership` operation.
    ///
    /// See [`UpdateEnvironmentMembership`](crate::client::fluent_builders::UpdateEnvironmentMembership) for more information about the
    /// operation and its arguments.
    pub fn update_environment_membership(
        &self,
    ) -> fluent_builders::UpdateEnvironmentMembership<C, M, R> {
        fluent_builders::UpdateEnvironmentMembership::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateEnvironmentEC2`.
    ///
    /// <p>Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and
    /// then connects from the instance to the environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironmentEC2<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_ec2_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentEC2<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentEC2`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentEc2Output,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentEC2Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentEc2InputOperationOutputAlias,
                crate::output::CreateEnvironmentEc2Output,
                crate::error::CreateEnvironmentEC2Error,
                crate::input::CreateEnvironmentEc2InputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to create.</p>
        /// <p>This name is visible to other IAM users in the same Amazon Web Services account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment to create.</p>
        /// <p>This name is visible to other IAM users in the same Amazon Web Services account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the environment to create.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the environment to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no
        /// more than one time.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in the
        /// <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no
        /// more than one time.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in the
        /// <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The type of instance to connect to the environment (for example,
        /// <code>t2.micro</code>).</p>
        pub fn instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(inp);
            self
        }
        /// <p>The type of instance to connect to the environment (for example,
        /// <code>t2.micro</code>).</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2
        /// instance.</p>
        pub fn subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(inp);
            self
        }
        /// <p>The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2
        /// instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
        /// To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM)
        /// path.</p>
        /// <p>The default AMI is used if the parameter isn't explicitly assigned a value in the request.
        /// Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you
        /// choose Amazon Linux 2, which includes long term support through 2023.</p>
        /// <p>
        /// <b>AMI aliases </b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Linux (default):
        /// <code>amazonlinux-1-x86_64</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>SSM paths</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Linux (default):
        /// <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Linux 2:
        /// <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Ubuntu 18.04:
        /// <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(inp);
            self
        }
        /// <p>The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
        /// To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM)
        /// path.</p>
        /// <p>The default AMI is used if the parameter isn't explicitly assigned a value in the request.
        /// Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you
        /// choose Amazon Linux 2, which includes long term support through 2023.</p>
        /// <p>
        /// <b>AMI aliases </b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Linux (default):
        /// <code>amazonlinux-1-x86_64</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>SSM paths</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Linux (default):
        /// <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Linux 2:
        /// <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Ubuntu 18.04:
        /// <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The number of minutes until the running instance is shut down after the environment has
        /// last been used.</p>
        pub fn automatic_stop_time_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.automatic_stop_time_minutes(inp);
            self
        }
        /// <p>The number of minutes until the running instance is shut down after the environment has
        /// last been used.</p>
        pub fn set_automatic_stop_time_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_automatic_stop_time_minutes(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any
        /// IAM principal. If this value is not specified, the ARN defaults to this environment's
        /// creator.</p>
        pub fn owner_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any
        /// IAM principal. If this value is not specified, the ARN defaults to this environment's
        /// creator.</p>
        pub fn set_owner_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that will be associated with the new Cloud9 development
        /// environment.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of key-value pairs that will be associated with the new Cloud9 development
        /// environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The connection type used for connecting to an Amazon EC2 environment. Valid values are
        /// <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through
        /// Amazon EC2 Systems Manager).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with
        /// Amazon EC2 Systems Manager</a> in the <i>Cloud9 User Guide</i>.</p>
        pub fn connection_type(mut self, inp: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(inp);
            self
        }
        /// <p>The connection type used for connecting to an Amazon EC2 environment. Valid values are
        /// <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through
        /// Amazon EC2 Systems Manager).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with
        /// Amazon EC2 Systems Manager</a> in the <i>Cloud9 User Guide</i>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironmentMembership`.
    ///
    /// <p>Adds an environment member to an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_membership_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentMembershipInputOperationOutputAlias,
                crate::output::CreateEnvironmentMembershipOutput,
                crate::error::CreateEnvironmentMembershipError,
                crate::input::CreateEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment that contains the environment member you want to add.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment that contains the environment member you want to add.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member you want to add.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member you want to add.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The type of environment member permissions you want to associate with this environment
        /// member. Available values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        pub fn permissions(mut self, inp: crate::model::MemberPermissions) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The type of environment member permissions you want to associate with this environment
        /// member. Available values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<crate::model::MemberPermissions>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the
    /// environment, also terminates the instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl<C, M, R> DeleteEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentInputOperationOutputAlias,
                crate::output::DeleteEnvironmentOutput,
                crate::error::DeleteEnvironmentError,
                crate::input::DeleteEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to delete.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to delete.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentMembership`.
    ///
    /// <p>Deletes an environment member from an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_membership_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentMembershipInputOperationOutputAlias,
                crate::output::DeleteEnvironmentMembershipOutput,
                crate::error::DeleteEnvironmentMembershipError,
                crate::input::DeleteEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to delete the environment member from.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to delete the environment member from.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member to delete from the
        /// environment.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member to delete from the
        /// environment.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentMemberships`.
    ///
    /// <p>Gets information about environment members for an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_memberships_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentMembershipsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentMembershipsOutput,
                crate::error::DescribeEnvironmentMembershipsError,
                crate::input::DescribeEnvironmentMembershipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an individual environment member to get information
        /// about. If no value is specified, information about all environment members are
        /// returned.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an individual environment member to get information
        /// about. If no value is specified, information about all environment members are
        /// returned.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The ID of the environment to get environment member information about.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to get environment member information about.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The type of environment member permissions to get information about. Available values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>owner</code>: Owns the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        /// <p>If no value is specified, information about all environment members are returned.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::Permissions>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The type of environment member permissions to get information about. Available values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>owner</code>: Owns the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        /// <p>If no value is specified, information about all environment members are returned.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permissions>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25
        /// items are returned, along with a unique string called a <i>next token</i>. To
        /// get the next batch of items in the list, call this operation again, adding the next token to
        /// the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25
        /// items are returned, along with a unique string called a <i>next token</i>. To
        /// get the next batch of items in the list, call this operation again, adding the next token to
        /// the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environment members to get information about.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of environment members to get information about.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironments`.
    ///
    /// <p>Gets information about Cloud9 development environments.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environments_input::Builder,
    }
    impl<C, M, R> DescribeEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentsOutput,
                crate::error::DescribeEnvironmentsError,
                crate::input::DescribeEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `environmentIds`.
        ///
        /// To override the contents of this collection use [`set_environment_ids`](Self::set_environment_ids).
        ///
        /// <p>The IDs of individual environments to get information about.</p>
        pub fn environment_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_ids(inp);
            self
        }
        /// <p>The IDs of individual environments to get information about.</p>
        pub fn set_environment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentStatus`.
    ///
    /// <p>Gets status information for an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_status_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentStatusInputOperationOutputAlias,
                crate::output::DescribeEnvironmentStatusOutput,
                crate::error::DescribeEnvironmentStatusError,
                crate::input::DescribeEnvironmentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to get status information about.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to get status information about.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>Gets a list of Cloud9 development environment identifiers.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl<C, M, R> ListEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentsInputOperationOutputAlias,
                crate::output::ListEnvironmentsOutput,
                crate::error::ListEnvironmentsError,
                crate::input::ListEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25
        /// items are returned, along with a unique string called a <i>next token</i>. To
        /// get the next batch of items in the list, call this operation again, adding the next token to
        /// the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>During a previous call, if there are more than 25 items in the list, only the first 25
        /// items are returned, along with a unique string called a <i>next token</i>. To
        /// get the next batch of items in the list, call this operation again, adding the next token to
        /// the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environments to get identifiers for.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of environments to get identifiers for.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of the tags associated with an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to get the tags
        /// for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to get the tags
        /// for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to an Cloud9 development environment.</p>
    /// <important>
    /// <p>Tags that you add to an Cloud9 environment by using this method will NOT be
    /// automatically propagated to underlying resources.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to add tags
        /// to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to add tags
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to the given Cloud9 development environment.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags to add to the given Cloud9 development environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to remove tags
        /// from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Cloud9 development environment to remove tags
        /// from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag names of the tags to remove from the given Cloud9 development
        /// environment.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag names of the tags to remove from the given Cloud9 development
        /// environment.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Changes the settings of an existing Cloud9 development environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl<C, M, R> UpdateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentInputOperationOutputAlias,
                crate::output::UpdateEnvironmentOutput,
                crate::error::UpdateEnvironmentError,
                crate::input::UpdateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to change settings.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to change settings.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>A replacement name for the environment.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A replacement name for the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Any new or replacement description for the environment.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Any new or replacement description for the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary
        /// credentials for an Cloud9 environment by using one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLE</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Only the environment owner can change the status of managed temporary credentials. An <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials is made by an account that's not the environment
        /// owner.</p>  
        /// </note>
        pub fn managed_credentials_action(
            mut self,
            inp: crate::model::ManagedCredentialsAction,
        ) -> Self {
            self.inner = self.inner.managed_credentials_action(inp);
            self
        }
        /// <p>Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary
        /// credentials for an Cloud9 environment by using one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLE</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Only the environment owner can change the status of managed temporary credentials. An <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials is made by an account that's not the environment
        /// owner.</p>  
        /// </note>
        pub fn set_managed_credentials_action(
            mut self,
            input: std::option::Option<crate::model::ManagedCredentialsAction>,
        ) -> Self {
            self.inner = self.inner.set_managed_credentials_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironmentMembership`.
    ///
    /// <p>Changes the settings of an existing environment member for an Cloud9 development
    /// environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironmentMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_membership_input::Builder,
    }
    impl<C, M, R> UpdateEnvironmentMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironmentMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentMembershipInputOperationOutputAlias,
                crate::output::UpdateEnvironmentMembershipOutput,
                crate::error::UpdateEnvironmentMembershipError,
                crate::input::UpdateEnvironmentMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment for the environment member whose settings you want to
        /// change.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment for the environment member whose settings you want to
        /// change.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member whose settings you want to
        /// change.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment member whose settings you want to
        /// change.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The replacement type of environment member permissions you want to associate with this
        /// environment member. Available values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        pub fn permissions(mut self, inp: crate::model::MemberPermissions) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The replacement type of environment member permissions you want to associate with this
        /// environment member. Available values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>read-only</code>: Has read-only access to the environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>read-write</code>: Has read-write access to the environment.</p>
        /// </li>
        /// </ul>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<crate::model::MemberPermissions>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
