// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Chime SDK Messaging
///
/// Client for invoking operations on Amazon Chime SDK Messaging. Each operation on Amazon Chime SDK Messaging is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_chimesdkmessaging::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_chimesdkmessaging::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_chimesdkmessaging::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateChannelFlow`](crate::client::fluent_builders::AssociateChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateChannelFlow::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::AssociateChannelFlow::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::AssociateChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::AssociateChannelFlow::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::AssociateChannelFlow::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    /// - On success, responds with [`AssociateChannelFlowOutput`](crate::output::AssociateChannelFlowOutput)

    /// - On failure, responds with [`SdkError<AssociateChannelFlowError>`](crate::error::AssociateChannelFlowError)
    pub fn associate_channel_flow(&self) -> fluent_builders::AssociateChannelFlow {
        fluent_builders::AssociateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchCreateChannelMembership`](crate::client::fluent_builders::BatchCreateChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_channel_arn): <p>The ARN of the channel to which you're adding users.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::BatchCreateChannelMembership::type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    ///   - [`member_arns(Vec<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::member_arns) / [`set_member_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_member_arns): <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput) with field(s):
    ///   - [`batch_channel_memberships(Option<BatchChannelMemberships>)`](crate::output::BatchCreateChannelMembershipOutput::batch_channel_memberships): <p>The list of channel memberships in the response.</p>
    ///   - [`errors(Option<Vec<BatchCreateChannelMembershipError>>)`](crate::output::BatchCreateChannelMembershipOutput::errors): <p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchCreateChannelMembershipError>`](crate::error::BatchCreateChannelMembershipError)
    pub fn batch_create_channel_membership(&self) -> fluent_builders::BatchCreateChannelMembership {
        fluent_builders::BatchCreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ChannelFlowCallback`](crate::client::fluent_builders::ChannelFlowCallback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`callback_id(impl Into<String>)`](crate::client::fluent_builders::ChannelFlowCallback::callback_id) / [`set_callback_id(Option<String>)`](crate::client::fluent_builders::ChannelFlowCallback::set_callback_id): <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ChannelFlowCallback::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ChannelFlowCallback::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`delete_resource(bool)`](crate::client::fluent_builders::ChannelFlowCallback::delete_resource) / [`set_delete_resource(bool)`](crate::client::fluent_builders::ChannelFlowCallback::set_delete_resource): <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
    ///   - [`channel_message(ChannelMessageCallback)`](crate::client::fluent_builders::ChannelFlowCallback::channel_message) / [`set_channel_message(Option<ChannelMessageCallback>)`](crate::client::fluent_builders::ChannelFlowCallback::set_channel_message): <p>Stores information about the processed message.</p>
    /// - On success, responds with [`ChannelFlowCallbackOutput`](crate::output::ChannelFlowCallbackOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ChannelFlowCallbackOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`callback_id(Option<String>)`](crate::output::ChannelFlowCallbackOutput::callback_id): <p>The call back ID passed in the request.</p>
    /// - On failure, responds with [`SdkError<ChannelFlowCallbackError>`](crate::error::ChannelFlowCallbackError)
    pub fn channel_flow_callback(&self) -> fluent_builders::ChannelFlowCallback {
        fluent_builders::ChannelFlowCallback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannel`](crate::client::fluent_builders::CreateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_app_instance_arn): <p>The ARN of the channel request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_name): <p>The name of the channel.</p>
    ///   - [`mode(ChannelMode)`](crate::client::fluent_builders::CreateChannel::mode) / [`set_mode(Option<ChannelMode>)`](crate::client::fluent_builders::CreateChannel::set_mode): <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
    ///   - [`privacy(ChannelPrivacy)`](crate::client::fluent_builders::CreateChannel::privacy) / [`set_privacy(Option<ChannelPrivacy>)`](crate::client::fluent_builders::CreateChannel::set_privacy): <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_metadata): <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_client_request_token): <p>The client token for the request. An <code>Idempotency</code> token.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateChannel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateChannel::set_tags): <p>The tags for the creation request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelOutput`](crate::output::CreateChannelOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<CreateChannelError>`](crate::error::CreateChannelError)
    pub fn create_channel(&self) -> fluent_builders::CreateChannel {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelBan`](crate::client::fluent_builders::CreateChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_channel_arn): <p>The ARN of the ban request.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelBanOutput::channel_arn): <p>The ARN of the response to the ban request.</p>
    ///   - [`member(Option<Identity>)`](crate::output::CreateChannelBanOutput::member): <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>
    /// - On failure, responds with [`SdkError<CreateChannelBanError>`](crate::error::CreateChannelBanError)
    pub fn create_channel_ban(&self) -> fluent_builders::CreateChannelBan {
        fluent_builders::CreateChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelFlow`](crate::client::fluent_builders::CreateChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelFlow::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelFlow::set_app_instance_arn): <p>The ARN of the channel flow request.</p>
    ///   - [`processors(Vec<Processor>)`](crate::client::fluent_builders::CreateChannelFlow::processors) / [`set_processors(Option<Vec<Processor>>)`](crate::client::fluent_builders::CreateChannelFlow::set_processors): <p>Information about the processor Lambda functions.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateChannelFlow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateChannelFlow::set_name): <p>The name of the channel flow.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateChannelFlow::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateChannelFlow::set_tags): <p>The tags for the creation request.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateChannelFlow::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateChannelFlow::set_client_request_token): <p>The client token for the request. An Idempotency token.</p>
    /// - On success, responds with [`CreateChannelFlowOutput`](crate::output::CreateChannelFlowOutput) with field(s):
    ///   - [`channel_flow_arn(Option<String>)`](crate::output::CreateChannelFlowOutput::channel_flow_arn): <p>The ARN of the channel flow.</p>
    /// - On failure, responds with [`SdkError<CreateChannelFlowError>`](crate::error::CreateChannelFlowError)
    pub fn create_channel_flow(&self) -> fluent_builders::CreateChannelFlow {
        fluent_builders::CreateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelMembership`](crate::client::fluent_builders::CreateChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_channel_arn): <p>The ARN of the channel to which you're adding users.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::CreateChannelMembership::type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::CreateChannelMembership::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelMembershipOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member(Option<Identity>)`](crate::output::CreateChannelMembershipOutput::member): <p>The ARN and metadata of the member being added.</p>
    /// - On failure, responds with [`SdkError<CreateChannelMembershipError>`](crate::error::CreateChannelMembershipError)
    pub fn create_channel_membership(&self) -> fluent_builders::CreateChannelMembership {
        fluent_builders::CreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelModerator`](crate::client::fluent_builders::CreateChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_channel_moderator_arn): <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelModeratorOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator(Option<Identity>)`](crate::output::CreateChannelModeratorOutput::channel_moderator): <p>The ARNs of the channel and the moderator.</p>
    /// - On failure, responds with [`SdkError<CreateChannelModeratorError>`](crate::error::CreateChannelModeratorError)
    pub fn create_channel_moderator(&self) -> fluent_builders::CreateChannelModerator {
        fluent_builders::CreateChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_channel_arn): <p>The ARN of the channel being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelError>`](crate::error::DeleteChannelError)
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelBan`](crate::client::fluent_builders::DeleteChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_channel_arn): <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_member_arn): <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelBanError>`](crate::error::DeleteChannelBanError)
    pub fn delete_channel_ban(&self) -> fluent_builders::DeleteChannelBan {
        fluent_builders::DeleteChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelFlow`](crate::client::fluent_builders::DeleteChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    /// - On success, responds with [`DeleteChannelFlowOutput`](crate::output::DeleteChannelFlowOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelFlowError>`](crate::error::DeleteChannelFlowError)
    pub fn delete_channel_flow(&self) -> fluent_builders::DeleteChannelFlow {
        fluent_builders::DeleteChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelMembership`](crate::client::fluent_builders::DeleteChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_channel_arn): <p>The ARN of the channel from which you want to remove the user.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelMembershipError>`](crate::error::DeleteChannelMembershipError)
    pub fn delete_channel_membership(&self) -> fluent_builders::DeleteChannelMembership {
        fluent_builders::DeleteChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelMessage`](crate::client::fluent_builders::DeleteChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_message_id): <p>The ID of the message being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelMessageError>`](crate::error::DeleteChannelMessageError)
    pub fn delete_channel_message(&self) -> fluent_builders::DeleteChannelMessage {
        fluent_builders::DeleteChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelModerator`](crate::client::fluent_builders::DeleteChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_channel_moderator_arn): <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelModeratorError>`](crate::error::DeleteChannelModeratorError)
    pub fn delete_channel_moderator(&self) -> fluent_builders::DeleteChannelModerator {
        fluent_builders::DeleteChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelOutput`](crate::output::DescribeChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::DescribeChannelOutput::channel): <p>The channel details.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelError>`](crate::error::DescribeChannelError)
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelBan`](crate::client::fluent_builders::DescribeChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_channel_arn): <p>The ARN of the channel from which the user is banned.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput) with field(s):
    ///   - [`channel_ban(Option<ChannelBan>)`](crate::output::DescribeChannelBanOutput::channel_ban): <p>The details of the ban.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelBanError>`](crate::error::DescribeChannelBanError)
    pub fn describe_channel_ban(&self) -> fluent_builders::DescribeChannelBan {
        fluent_builders::DescribeChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelFlow`](crate::client::fluent_builders::DescribeChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    /// - On success, responds with [`DescribeChannelFlowOutput`](crate::output::DescribeChannelFlowOutput) with field(s):
    ///   - [`channel_flow(Option<ChannelFlow>)`](crate::output::DescribeChannelFlowOutput::channel_flow): <p>The channel flow details.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelFlowError>`](crate::error::DescribeChannelFlowError)
    pub fn describe_channel_flow(&self) -> fluent_builders::DescribeChannelFlow {
        fluent_builders::DescribeChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelMembership`](crate::client::fluent_builders::DescribeChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput) with field(s):
    ///   - [`channel_membership(Option<ChannelMembership>)`](crate::output::DescribeChannelMembershipOutput::channel_membership): <p>The details of the membership.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelMembershipError>`](crate::error::DescribeChannelMembershipError)
    pub fn describe_channel_membership(&self) -> fluent_builders::DescribeChannelMembership {
        fluent_builders::DescribeChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelMembershipForAppInstanceUser`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_channel_arn): <p>The ARN of the channel to which the user belongs.</p>
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user in a channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput) with field(s):
    ///   - [`channel_membership(Option<ChannelMembershipForAppInstanceUserSummary>)`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput::channel_membership): <p>The channel to which a user belongs.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelMembershipForAppInstanceUserError>`](crate::error::DescribeChannelMembershipForAppInstanceUserError)
    pub fn describe_channel_membership_for_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelMembershipForAppInstanceUser {
        fluent_builders::DescribeChannelMembershipForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelModeratedByAppInstanceUser`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_channel_arn): <p>The ARN of the moderated channel.</p>
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput) with field(s):
    ///   - [`channel(Option<ChannelModeratedByAppInstanceUserSummary>)`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput::channel): <p>The moderated channel.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelModeratedByAppInstanceUserError>`](crate::error::DescribeChannelModeratedByAppInstanceUserError)
    pub fn describe_channel_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelModeratedByAppInstanceUser {
        fluent_builders::DescribeChannelModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelModerator`](crate::client::fluent_builders::DescribeChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_channel_moderator_arn): <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput) with field(s):
    ///   - [`channel_moderator(Option<ChannelModerator>)`](crate::output::DescribeChannelModeratorOutput::channel_moderator): <p>The details of the channel moderator.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelModeratorError>`](crate::error::DescribeChannelModeratorError)
    pub fn describe_channel_moderator(&self) -> fluent_builders::DescribeChannelModerator {
        fluent_builders::DescribeChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateChannelFlow`](crate::client::fluent_builders::DisassociateChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DisassociateChannelFlow::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    /// - On success, responds with [`DisassociateChannelFlowOutput`](crate::output::DisassociateChannelFlowOutput)

    /// - On failure, responds with [`SdkError<DisassociateChannelFlowError>`](crate::error::DisassociateChannelFlowError)
    pub fn disassociate_channel_flow(&self) -> fluent_builders::DisassociateChannelFlow {
        fluent_builders::DisassociateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannelMembershipPreferences`](crate::client::fluent_builders::GetChannelMembershipPreferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::GetChannelMembershipPreferences::set_chime_bearer): <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    /// - On success, responds with [`GetChannelMembershipPreferencesOutput`](crate::output::GetChannelMembershipPreferencesOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::GetChannelMembershipPreferencesOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member(Option<Identity>)`](crate::output::GetChannelMembershipPreferencesOutput::member): <p>The details of a user.</p>
    ///   - [`preferences(Option<ChannelMembershipPreferences>)`](crate::output::GetChannelMembershipPreferencesOutput::preferences): <p>The channel membership preferences for an <code>AppInstanceUser</code> .</p>
    /// - On failure, responds with [`SdkError<GetChannelMembershipPreferencesError>`](crate::error::GetChannelMembershipPreferencesError)
    pub fn get_channel_membership_preferences(
        &self,
    ) -> fluent_builders::GetChannelMembershipPreferences {
        fluent_builders::GetChannelMembershipPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannelMessage`](crate::client::fluent_builders::GetChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_message_id): <p>The ID of the message.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput) with field(s):
    ///   - [`channel_message(Option<ChannelMessage>)`](crate::output::GetChannelMessageOutput::channel_message): <p>The details of and content in the message.</p>
    /// - On failure, responds with [`SdkError<GetChannelMessageError>`](crate::error::GetChannelMessageError)
    pub fn get_channel_message(&self) -> fluent_builders::GetChannelMessage {
        fluent_builders::GetChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannelMessageStatus`](crate::client::fluent_builders::GetChannelMessageStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::set_channel_arn): <p>The ARN of the channel</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::set_message_id): <p>The ID of the message.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::GetChannelMessageStatus::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    /// - On success, responds with [`GetChannelMessageStatusOutput`](crate::output::GetChannelMessageStatusOutput) with field(s):
    ///   - [`status(Option<ChannelMessageStatusStructure>)`](crate::output::GetChannelMessageStatusOutput::status): <p>The message status and details.</p>
    /// - On failure, responds with [`SdkError<GetChannelMessageStatusError>`](crate::error::GetChannelMessageStatusError)
    pub fn get_channel_message_status(&self) -> fluent_builders::GetChannelMessageStatus {
        fluent_builders::GetChannelMessageStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMessagingSessionEndpoint`](crate::client::fluent_builders::GetMessagingSessionEndpoint) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetMessagingSessionEndpoint::send) it.

    /// - On success, responds with [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput) with field(s):
    ///   - [`endpoint(Option<MessagingSessionEndpoint>)`](crate::output::GetMessagingSessionEndpointOutput::endpoint): <p>The endpoint returned in the response.</p>
    /// - On failure, responds with [`SdkError<GetMessagingSessionEndpointError>`](crate::error::GetMessagingSessionEndpointError)
    pub fn get_messaging_session_endpoint(&self) -> fluent_builders::GetMessagingSessionEndpoint {
        fluent_builders::GetMessagingSessionEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelBans`](crate::client::fluent_builders::ListChannelBans) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelBans::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelBans::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelBans::set_max_results): <p>The maximum number of bans that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_next_token): <p>The token passed by previous API calls until all requested bans are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelBansOutput`](crate::output::ListChannelBansOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelBansOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelBansOutput::next_token): <p>The token passed by previous API calls until all requested bans are returned.</p>
    ///   - [`channel_bans(Option<Vec<ChannelBanSummary>>)`](crate::output::ListChannelBansOutput::channel_bans): <p>The information for each requested ban.</p>
    /// - On failure, responds with [`SdkError<ListChannelBansError>`](crate::error::ListChannelBansError)
    pub fn list_channel_bans(&self) -> fluent_builders::ListChannelBans {
        fluent_builders::ListChannelBans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelFlows`](crate::client::fluent_builders::ListChannelFlows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelFlows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelFlows::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListChannelFlows::set_app_instance_arn): <p>The ARN of the app instance.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelFlows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelFlows::set_max_results): <p>The maximum number of channel flows that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelFlows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelFlows::set_next_token): <p>The token passed by previous API calls until all requested channel flows are returned.</p>
    /// - On success, responds with [`ListChannelFlowsOutput`](crate::output::ListChannelFlowsOutput) with field(s):
    ///   - [`channel_flows(Option<Vec<ChannelFlowSummary>>)`](crate::output::ListChannelFlowsOutput::channel_flows): <p>The information about each channel flow.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelFlowsOutput::next_token): <p>The token passed by previous API calls until all requested channels are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelFlowsError>`](crate::error::ListChannelFlowsError)
    pub fn list_channel_flows(&self) -> fluent_builders::ListChannelFlows {
        fluent_builders::ListChannelFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMemberships`](crate::client::fluent_builders::ListChannelMemberships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMemberships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_channel_arn): <p>The maximum number of channel memberships that you want returned.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::ListChannelMemberships::type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::ListChannelMemberships::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMemberships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMemberships::set_max_results): <p>The maximum number of channel memberships that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_next_token): <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelMembershipsOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_memberships(Option<Vec<ChannelMembershipSummary>>)`](crate::output::ListChannelMembershipsOutput::channel_memberships): <p>The information for the requested channel memberships.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMembershipsOutput::next_token): <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelMembershipsError>`](crate::error::ListChannelMembershipsError)
    pub fn list_channel_memberships(&self) -> fluent_builders::ListChannelMemberships {
        fluent_builders::ListChannelMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMembershipsForAppInstanceUser`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>s</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_max_results): <p>The maximum number of users that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_next_token): <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput) with field(s):
    ///   - [`channel_memberships(Option<Vec<ChannelMembershipForAppInstanceUserSummary>>)`](crate::output::ListChannelMembershipsForAppInstanceUserOutput::channel_memberships): <p>The token passed by previous API calls until all requested users are returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMembershipsForAppInstanceUserOutput::next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelMembershipsForAppInstanceUserError>`](crate::error::ListChannelMembershipsForAppInstanceUserError)
    pub fn list_channel_memberships_for_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelMembershipsForAppInstanceUser {
        fluent_builders::ListChannelMembershipsForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMessages`](crate::client::fluent_builders::ListChannelMessages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMessages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::ListChannelMessages::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::ListChannelMessages::set_sort_order): <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
    ///   - [`not_before(DateTime)`](crate::client::fluent_builders::ListChannelMessages::not_before) / [`set_not_before(Option<DateTime>)`](crate::client::fluent_builders::ListChannelMessages::set_not_before): <p>The initial or starting time stamp for your requested messages.</p>
    ///   - [`not_after(DateTime)`](crate::client::fluent_builders::ListChannelMessages::not_after) / [`set_not_after(Option<DateTime>)`](crate::client::fluent_builders::ListChannelMessages::set_not_after): <p>The final or ending time stamp for your requested messages.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMessages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMessages::set_max_results): <p>The maximum number of messages that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_next_token): <p>The token passed by previous API calls until all requested messages are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelMessagesOutput::channel_arn): <p>The ARN of the channel containing the requested messages.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMessagesOutput::next_token): <p>The token passed by previous API calls until all requested messages are returned.</p>
    ///   - [`channel_messages(Option<Vec<ChannelMessageSummary>>)`](crate::output::ListChannelMessagesOutput::channel_messages): <p>The information about, and content of, each requested message.</p>
    /// - On failure, responds with [`SdkError<ListChannelMessagesError>`](crate::error::ListChannelMessagesError)
    pub fn list_channel_messages(&self) -> fluent_builders::ListChannelMessages {
        fluent_builders::ListChannelMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelModerators`](crate::client::fluent_builders::ListChannelModerators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelModerators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelModerators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelModerators::set_max_results): <p>The maximum number of moderators that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_next_token): <p>The token passed by previous API calls until all requested moderators are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelModeratorsOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelModeratorsOutput::next_token): <p>The token passed by previous API calls until all requested moderators are returned.</p>
    ///   - [`channel_moderators(Option<Vec<ChannelModeratorSummary>>)`](crate::output::ListChannelModeratorsOutput::channel_moderators): <p>The information about and names of each moderator.</p>
    /// - On failure, responds with [`SdkError<ListChannelModeratorsError>`](crate::error::ListChannelModeratorsError)
    pub fn list_channel_moderators(&self) -> fluent_builders::ListChannelModerators {
        fluent_builders::ListChannelModerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannels`](crate::client::fluent_builders::ListChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannels::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListChannels::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`privacy(ChannelPrivacy)`](crate::client::fluent_builders::ListChannels::privacy) / [`set_privacy(Option<ChannelPrivacy>)`](crate::client::fluent_builders::ListChannels::set_privacy): <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannels::set_max_results): <p>The maximum number of channels that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannels::set_next_token): <p>The token passed by previous API calls until all requested channels are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannels::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannels::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelsOutput`](crate::output::ListChannelsOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelSummary>>)`](crate::output::ListChannelsOutput::channels): <p>The information about each channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsOutput::next_token): <p>The token returned from previous API requests until the number of channels is reached.</p>
    /// - On failure, responds with [`SdkError<ListChannelsError>`](crate::error::ListChannelsError)
    pub fn list_channels(&self) -> fluent_builders::ListChannels {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelsAssociatedWithChannelFlow`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::set_max_results): <p>The maximum number of channels that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow::set_next_token): <p>The token passed by previous API calls until all requested channels are returned.</p>
    /// - On success, responds with [`ListChannelsAssociatedWithChannelFlowOutput`](crate::output::ListChannelsAssociatedWithChannelFlowOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelAssociatedWithFlowSummary>>)`](crate::output::ListChannelsAssociatedWithChannelFlowOutput::channels): <p>The information about each channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsAssociatedWithChannelFlowOutput::next_token): <p>The token passed by previous API calls until all requested channels are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelsAssociatedWithChannelFlowError>`](crate::error::ListChannelsAssociatedWithChannelFlowError)
    pub fn list_channels_associated_with_channel_flow(
        &self,
    ) -> fluent_builders::ListChannelsAssociatedWithChannelFlow {
        fluent_builders::ListChannelsAssociatedWithChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelsModeratedByAppInstanceUser`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user in the moderated channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_max_results): <p>The maximum number of channels in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_next_token): <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelModeratedByAppInstanceUserSummary>>)`](crate::output::ListChannelsModeratedByAppInstanceUserOutput::channels): <p>The moderated channels in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsModeratedByAppInstanceUserOutput::next_token): <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    /// - On failure, responds with [`SdkError<ListChannelsModeratedByAppInstanceUserError>`](crate::error::ListChannelsModeratedByAppInstanceUserError)
    pub fn list_channels_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelsModeratedByAppInstanceUser {
        fluent_builders::ListChannelsModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutChannelMembershipPreferences`](crate::client::fluent_builders::PutChannelMembershipPreferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::set_member_arn): <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::set_chime_bearer): <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    ///   - [`preferences(ChannelMembershipPreferences)`](crate::client::fluent_builders::PutChannelMembershipPreferences::preferences) / [`set_preferences(Option<ChannelMembershipPreferences>)`](crate::client::fluent_builders::PutChannelMembershipPreferences::set_preferences): <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
    /// - On success, responds with [`PutChannelMembershipPreferencesOutput`](crate::output::PutChannelMembershipPreferencesOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::PutChannelMembershipPreferencesOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member(Option<Identity>)`](crate::output::PutChannelMembershipPreferencesOutput::member): <p>The details of a user.</p>
    ///   - [`preferences(Option<ChannelMembershipPreferences>)`](crate::output::PutChannelMembershipPreferencesOutput::preferences): <p>The ARN and metadata of the member being added.</p>
    /// - On failure, responds with [`SdkError<PutChannelMembershipPreferencesError>`](crate::error::PutChannelMembershipPreferencesError)
    pub fn put_channel_membership_preferences(
        &self,
    ) -> fluent_builders::PutChannelMembershipPreferences {
        fluent_builders::PutChannelMembershipPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RedactChannelMessage`](crate::client::fluent_builders::RedactChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_channel_arn): <p>The ARN of the channel containing the messages that you want to redact.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_message_id): <p>The ID of the message being redacted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::RedactChannelMessageOutput::channel_arn): <p>The ARN of the channel containing the messages that you want to redact.</p>
    ///   - [`message_id(Option<String>)`](crate::output::RedactChannelMessageOutput::message_id): <p>The ID of the message being redacted.</p>
    /// - On failure, responds with [`SdkError<RedactChannelMessageError>`](crate::error::RedactChannelMessageError)
    pub fn redact_channel_message(&self) -> fluent_builders::RedactChannelMessage {
        fluent_builders::RedactChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendChannelMessage`](crate::client::fluent_builders::SendChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_content): <p>The content of the message.</p>
    ///   - [`r#type(ChannelMessageType)`](crate::client::fluent_builders::SendChannelMessage::type) / [`set_type(Option<ChannelMessageType>)`](crate::client::fluent_builders::SendChannelMessage::set_type): <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
    ///   - [`persistence(ChannelMessagePersistenceType)`](crate::client::fluent_builders::SendChannelMessage::persistence) / [`set_persistence(Option<ChannelMessagePersistenceType>)`](crate::client::fluent_builders::SendChannelMessage::set_persistence): <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_metadata): <p>The optional metadata for each message.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_client_request_token): <p>The <code>Idempotency</code> token for each client request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    ///   - [`push_notification(PushNotificationConfiguration)`](crate::client::fluent_builders::SendChannelMessage::push_notification) / [`set_push_notification(Option<PushNotificationConfiguration>)`](crate::client::fluent_builders::SendChannelMessage::set_push_notification): <p>The push notification configuration of the message.</p>
    ///   - [`message_attributes(HashMap<String, MessageAttributeValue>)`](crate::client::fluent_builders::SendChannelMessage::message_attributes) / [`set_message_attributes(Option<HashMap<String, MessageAttributeValue>>)`](crate::client::fluent_builders::SendChannelMessage::set_message_attributes): <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
    /// - On success, responds with [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::SendChannelMessageOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(Option<String>)`](crate::output::SendChannelMessageOutput::message_id): <p>The ID string assigned to each message.</p>
    ///   - [`status(Option<ChannelMessageStatusStructure>)`](crate::output::SendChannelMessageOutput::status): <p>The status of the channel message.</p>
    /// - On failure, responds with [`SdkError<SendChannelMessageError>`](crate::error::SendChannelMessageError)
    pub fn send_channel_message(&self) -> fluent_builders::SendChannelMessage {
        fluent_builders::SendChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_name): <p>The name of the channel.</p>
    ///   - [`mode(ChannelMode)`](crate::client::fluent_builders::UpdateChannel::mode) / [`set_mode(Option<ChannelMode>)`](crate::client::fluent_builders::UpdateChannel::set_mode): <p>The mode of the update request.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_metadata): <p>The metadata for the update request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelOutput`](crate::output::UpdateChannelOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelError>`](crate::error::UpdateChannelError)
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannelFlow`](crate::client::fluent_builders::UpdateChannelFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelFlow::channel_flow_arn) / [`set_channel_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannelFlow::set_channel_flow_arn): <p>The ARN of the channel flow.</p>
    ///   - [`processors(Vec<Processor>)`](crate::client::fluent_builders::UpdateChannelFlow::processors) / [`set_processors(Option<Vec<Processor>>)`](crate::client::fluent_builders::UpdateChannelFlow::set_processors): <p>Information about the processor Lambda functions </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelFlow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateChannelFlow::set_name): <p>The name of the channel flow.</p>
    /// - On success, responds with [`UpdateChannelFlowOutput`](crate::output::UpdateChannelFlowOutput) with field(s):
    ///   - [`channel_flow_arn(Option<String>)`](crate::output::UpdateChannelFlowOutput::channel_flow_arn): <p>The ARN of the channel flow.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelFlowError>`](crate::error::UpdateChannelFlowError)
    pub fn update_channel_flow(&self) -> fluent_builders::UpdateChannelFlow {
        fluent_builders::UpdateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannelMessage`](crate::client::fluent_builders::UpdateChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_message_id): <p>The ID string of the message being updated.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_content): <p>The content of the message being updated.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_metadata): <p>The metadata of the message being updated.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelMessageOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(Option<String>)`](crate::output::UpdateChannelMessageOutput::message_id): <p>The ID string of the message being updated.</p>
    ///   - [`status(Option<ChannelMessageStatusStructure>)`](crate::output::UpdateChannelMessageOutput::status): <p>The status of the message update.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelMessageError>`](crate::error::UpdateChannelMessageError)
    pub fn update_channel_message(&self) -> fluent_builders::UpdateChannelMessage {
        fluent_builders::UpdateChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannelReadMarker`](crate::client::fluent_builders::UpdateChannelReadMarker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelReadMarkerOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelReadMarkerError>`](crate::error::UpdateChannelReadMarkerError)
    pub fn update_channel_read_marker(&self) -> fluent_builders::UpdateChannelReadMarker {
        fluent_builders::UpdateChannelReadMarker::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateChannelFlow`.
    ///
    /// <p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the <code>DisassociateChannelFlow</code> API.</p> <note>
    /// <p>Only administrators or channel moderators can associate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_channel_flow_input::Builder,
    }
    impl AssociateChannelFlow {
        /// Creates a new `AssociateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateChannelMembership`.
    ///
    /// <p>Adds a specified number of users to a channel. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateChannelMembership {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_create_channel_membership_input::Builder,
    }
    impl BatchCreateChannelMembership {
        /// Creates a new `BatchCreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `MemberArns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arns(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_member_arns(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChannelFlowCallback`.
    ///
    /// <p>Calls back Chime SDK Messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p>
    /// <p>You can return one of the following processing responses:</p>
    /// <ul>
    /// <li> <p>Update message content or metadata</p> </li>
    /// <li> <p>Deny a message</p> </li>
    /// <li> <p>Make no changes to the message</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChannelFlowCallback {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::channel_flow_callback_input::Builder,
    }
    impl ChannelFlowCallback {
        /// Creates a new `ChannelFlowCallback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChannelFlowCallbackOutput,
            aws_smithy_http::result::SdkError<crate::error::ChannelFlowCallbackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn callback_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.callback_id(input.into());
            self
        }
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn set_callback_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_callback_id(input);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn delete_resource(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_resource(input);
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn set_delete_resource(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_resource(input);
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn channel_message(mut self, input: crate::model::ChannelMessageCallback) -> Self {
            self.inner = self.inner.channel_message(input);
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn set_channel_message(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageCallback>,
        ) -> Self {
            self.inner = self.inner.set_channel_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a channel to which you can add users and send messages.</p>
    /// <p> <b>Restriction</b>: You can't change a channel's privacy.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl CreateChannel {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelBan`.
    ///
    /// <p>Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p>
    /// <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelBan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_ban_input::Builder,
    }
    impl CreateChannelBan {
        /// Creates a new `CreateChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelFlow`.
    ///
    /// <p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions that perform actions on chat messages, such as stripping out profanity. You can associate channel flows with channels, and the processors in the channel flow then take action on all messages sent to that channel. This is a developer API.</p>
    /// <p>Channel flows process the following items:</p>
    /// <ol>
    /// <li> <p>New and updated messages</p> </li>
    /// <li> <p>Persistent and non-persistent messages</p> </li>
    /// <li> <p>The Standard message type</p> </li>
    /// </ol> <note>
    /// <p>Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK Messaging, refer to <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_flow_input::Builder,
    }
    impl CreateChannelFlow {
        /// Creates a new `CreateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// Appends an item to `Processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions.</p>
        pub fn processors(mut self, input: crate::model::Processor) -> Self {
            self.inner = self.inner.processors(input);
            self
        }
        /// <p>Information about the processor Lambda functions.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.inner = self.inner.set_processors(input);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelMembership`.
    ///
    /// <p>Adds a user to a channel. The <code>InvitedBy</code> field in <code>ChannelMembership</code> is derived from the request header. A channel member can:</p>
    /// <ul>
    /// <li> <p>List messages</p> </li>
    /// <li> <p>Send messages</p> </li>
    /// <li> <p>Receive messages</p> </li>
    /// <li> <p>Edit their own messages</p> </li>
    /// <li> <p>Leave the channel</p> </li>
    /// </ul>
    /// <p>Privacy settings impact this action as follows:</p>
    /// <ul>
    /// <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li>
    /// <li> <p>Private Channels: You must be a member to list or send messages.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelMembership {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_membership_input::Builder,
    }
    impl CreateChannelMembership {
        /// Creates a new `CreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelModerator`.
    ///
    /// <p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p>
    /// <ul>
    /// <li> <p>Add and remove other members of the channel.</p> </li>
    /// <li> <p>Add and remove other moderators of the channel.</p> </li>
    /// <li> <p>Add and remove user bans for the channel.</p> </li>
    /// <li> <p>Redact messages in the channel.</p> </li>
    /// <li> <p>List messages in the channel.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelModerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_moderator_input::Builder,
    }
    impl CreateChannelModerator {
        /// Creates a new `CreateChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl DeleteChannel {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelBan`.
    ///
    /// <p>Removes a user from a channel's ban list.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelBan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_ban_input::Builder,
    }
    impl DeleteChannelBan {
        /// Creates a new `DeleteChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelFlow`.
    ///
    /// <p>Deletes a channel flow, an irreversible process. This is a developer API.</p> <note>
    /// <p> This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the <code>ListChannelsAssociatedWithChannelFlow</code> API. Use the <code>DisassociateChannelFlow</code> API to disassociate a channel flow from all channels. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_flow_input::Builder,
    }
    impl DeleteChannelFlow {
        /// Creates a new `DeleteChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMembership`.
    ///
    /// <p>Removes a member from a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelMembership {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_membership_input::Builder,
    }
    impl DeleteChannelMembership {
        /// Creates a new `DeleteChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMessage`.
    ///
    /// <p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_message_input::Builder,
    }
    impl DeleteChannelMessage {
        /// Creates a new `DeleteChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelModerator`.
    ///
    /// <p>Deletes a channel moderator.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelModerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_moderator_input::Builder,
    }
    impl DeleteChannelModerator {
        /// Creates a new `DeleteChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl DescribeChannel {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelBan`.
    ///
    /// <p>Returns the full details of a channel ban.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelBan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_ban_input::Builder,
    }
    impl DescribeChannelBan {
        /// Creates a new `DescribeChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelFlow`.
    ///
    /// <p>Returns the full details of a channel flow in an Amazon Chime <code>AppInstance</code>. This is a developer API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_flow_input::Builder,
    }
    impl DescribeChannelFlow {
        /// Creates a new `DescribeChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembership`.
    ///
    /// <p>Returns the full details of a user's channel membership.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelMembership {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_membership_input::Builder,
    }
    impl DescribeChannelMembership {
        /// Creates a new `DescribeChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembershipForAppInstanceUser`.
    ///
    /// <p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelMembershipForAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_membership_for_app_instance_user_input::Builder,
    }
    impl DescribeChannelMembershipForAppInstanceUser {
        /// Creates a new `DescribeChannelMembershipForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModeratedByAppInstanceUser`.
    ///
    /// <p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelModeratedByAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_moderated_by_app_instance_user_input::Builder,
    }
    impl DescribeChannelModeratedByAppInstanceUser {
        /// Creates a new `DescribeChannelModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModerator`.
    ///
    /// <p>Returns the full details of a single ChannelModerator.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelModerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_moderator_input::Builder,
    }
    impl DescribeChannelModerator {
        /// Creates a new `DescribeChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateChannelFlow`.
    ///
    /// <p>Disassociates a channel flow from all its channels. Once disassociated, all messages to that channel stop going through the channel flow processor.</p> <note>
    /// <p>Only administrators or channel moderators can disassociate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_channel_flow_input::Builder,
    }
    impl DisassociateChannelFlow {
        /// Creates a new `DisassociateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMembershipPreferences`.
    ///
    /// <p>Gets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel. Only the <code>AppInstanceUser</code> who owns the membership can retrieve preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't retrieve preferences for other users. Banned users can't retrieve membership preferences for the channel from which they are banned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannelMembershipPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_channel_membership_preferences_input::Builder,
    }
    impl GetChannelMembershipPreferences {
        /// Creates a new `GetChannelMembershipPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMembershipPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMembershipPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessage`.
    ///
    /// <p>Gets the full details of a channel message.</p> <note>
    /// <p>The x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannelMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_channel_message_input::Builder,
    }
    impl GetChannelMessage {
        /// Creates a new `GetChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessageStatus`.
    ///
    /// <p>Gets message status for a specified <code>messageId</code>. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to retrieving message status if the event was not received because a client wasn't connected to a websocket. </p>
    /// <p>Messages can have any one of these statuses.</p>
    /// <dl>
    /// <dt>
    /// SENT
    /// </dt>
    /// <dd>
    /// <p>Message processed successfully</p>
    /// </dd>
    /// <dt>
    /// PENDING
    /// </dt>
    /// <dd>
    /// <p>Ongoing processing</p>
    /// </dd>
    /// <dt>
    /// FAILED
    /// </dt>
    /// <dd>
    /// <p>Processing failed</p>
    /// </dd>
    /// <dt>
    /// DENIED
    /// </dt>
    /// <dd>
    /// <p>Messasge denied by the processor</p>
    /// </dd>
    /// </dl> <note>
    /// <ul>
    /// <li> <p>This API does not return statuses for denied messages, because we don't store them once the processor denies them. </p> </li>
    /// <li> <p>Only the message sender can invoke this API.</p> </li>
    /// <li> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannelMessageStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_channel_message_status_input::Builder,
    }
    impl GetChannelMessageStatus {
        /// Creates a new `GetChannelMessageStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMessagingSessionEndpoint`.
    ///
    /// <p>The details of the endpoint for the messaging session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMessagingSessionEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_messaging_session_endpoint_input::Builder,
    }
    impl GetMessagingSessionEndpoint {
        /// Creates a new `GetMessagingSessionEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMessagingSessionEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListChannelBans`.
    ///
    /// <p>Lists all the users banned from a particular channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelBans {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_bans_input::Builder,
    }
    impl ListChannelBans {
        /// Creates a new `ListChannelBans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelBansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelBansError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelBansPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelBansPaginator {
            crate::paginator::ListChannelBansPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelFlows`.
    ///
    /// <p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelFlows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_flows_input::Builder,
    }
    impl ListChannelFlows {
        /// Creates a new `ListChannelFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelFlowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelFlowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelFlowsPaginator {
            crate::paginator::ListChannelFlowsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the app instance.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the app instance.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMemberships`.
    ///
    /// <p>Lists all channel memberships in a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    /// <p>If you want to list the channels to which a specific app instance user belongs, see the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html">ListChannelMembershipsForAppInstanceUser</a> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMemberships {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_memberships_input::Builder,
    }
    impl ListChannelMemberships {
        /// Creates a new `ListChannelMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMembershipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelMembershipsPaginator {
            crate::paginator::ListChannelMembershipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMembershipsForAppInstanceUser`.
    ///
    /// <p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMembershipsForAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_memberships_for_app_instance_user_input::Builder,
    }
    impl ListChannelMembershipsForAppInstanceUser {
        /// Creates a new `ListChannelMembershipsForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelMembershipsForAppInstanceUserError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator {
            crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMessages`.
    ///
    /// <p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note>
    /// <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p>
    /// <p>Also, the x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMessages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_messages_input::Builder,
    }
    impl ListChannelMessages {
        /// Creates a new `ListChannelMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMessagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelMessagesPaginator {
            crate::paginator::ListChannelMessagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.not_before(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_not_before(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.not_after(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_not_after(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelModerators`.
    ///
    /// <p>Lists all the moderators for a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelModerators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channel_moderators_input::Builder,
    }
    impl ListChannelModerators {
        /// Creates a new `ListChannelModerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelModeratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelModeratorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelModeratorsPaginator {
            crate::paginator::ListChannelModeratorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p>
    /// <p class="title"> <b>Functionality &amp; restrictions</b> </p>
    /// <ul>
    /// <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li>
    /// <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl ListChannels {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelsPaginator {
            crate::paginator::ListChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsAssociatedWithChannelFlow`.
    ///
    /// <p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelsAssociatedWithChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channels_associated_with_channel_flow_input::Builder,
    }
    impl ListChannelsAssociatedWithChannelFlow {
        /// Creates a new `ListChannelsAssociatedWithChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsAssociatedWithChannelFlowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsAssociatedWithChannelFlowError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsAssociatedWithChannelFlowPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListChannelsAssociatedWithChannelFlowPaginator {
            crate::paginator::ListChannelsAssociatedWithChannelFlowPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsModeratedByAppInstanceUser`.
    ///
    /// <p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelsModeratedByAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channels_moderated_by_app_instance_user_input::Builder,
    }
    impl ListChannelsModeratedByAppInstanceUser {
        /// Creates a new `ListChannelsModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsModeratedByAppInstanceUserError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator {
            crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK messaging resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutChannelMembershipPreferences`.
    ///
    /// <p>Sets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel. Only the <code>AppInstanceUser</code> who owns the membership can set preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't set preferences for other users. Banned users can't set membership preferences for the channel from which they are banned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutChannelMembershipPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_channel_membership_preferences_input::Builder,
    }
    impl PutChannelMembershipPreferences {
        /// Creates a new `PutChannelMembershipPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutChannelMembershipPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutChannelMembershipPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn preferences(mut self, input: crate::model::ChannelMembershipPreferences) -> Self {
            self.inner = self.inner.preferences(input);
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn set_preferences(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipPreferences>,
        ) -> Self {
            self.inner = self.inner.set_preferences(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactChannelMessage`.
    ///
    /// <p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RedactChannelMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::redact_channel_message_input::Builder,
    }
    impl RedactChannelMessage {
        /// Creates a new `RedactChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendChannelMessage`.
    ///
    /// <p>Sends a message to a particular channel that the member is a part of.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata. <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendChannelMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_channel_message_input::Builder,
    }
    impl SendChannelMessage {
        /// Creates a new `SendChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn persistence(mut self, input: crate::model::ChannelMessagePersistenceType) -> Self {
            self.inner = self.inner.persistence(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.inner = self.inner.set_persistence(input);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn push_notification(
            mut self,
            input: crate::model::PushNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.push_notification(input);
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn set_push_notification(
            mut self,
            input: std::option::Option<crate::model::PushNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_push_notification(input);
            self
        }
        /// Adds a key-value pair to `MessageAttributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MessageAttributeValue,
        ) -> Self {
            self.inner = self.inner.message_attributes(k.into(), v);
            self
        }
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_message_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK messaging resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Chime SDK messaging resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Update a channel's attributes.</p>
    /// <p> <b>Restriction</b>: You can't change a channel's privacy. </p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl UpdateChannel {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelFlow`.
    ///
    /// <p>Updates channel flow attributes. This is a developer API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannelFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_flow_input::Builder,
    }
    impl UpdateChannelFlow {
        /// Creates a new `UpdateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// Appends an item to `Processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions </p>
        pub fn processors(mut self, input: crate::model::Processor) -> Self {
            self.inner = self.inner.processors(input);
            self
        }
        /// <p>Information about the processor Lambda functions </p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.inner = self.inner.set_processors(input);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelMessage`.
    ///
    /// <p>Updates the content of a message.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannelMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_message_input::Builder,
    }
    impl UpdateChannelMessage {
        /// Creates a new `UpdateChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelReadMarker`.
    ///
    /// <p>The details of the time when a user last read messages in a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannelReadMarker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_read_marker_input::Builder,
    }
    impl UpdateChannelReadMarker {
        /// Creates a new `UpdateChannelReadMarker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelReadMarkerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelReadMarkerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
