// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::BadRequestException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::ForbiddenException(inner) => inner.fmt(f),
            Error::NotFoundException(inner) => inner.fmt(f),
            Error::ResourceLimitExceededException(inner) => inner.fmt(f),
            Error::ServiceFailureException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::ThrottledClientException(inner) => inner.fmt(f),
            Error::UnauthorizedClientException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateChannelFlowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::AssociateChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchCreateChannelMembershipErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::BatchCreateChannelMembershipErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ChannelFlowCallbackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ChannelFlowCallbackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ChannelFlowCallbackErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ChannelFlowCallbackErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateChannelError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChannelErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::CreateChannelErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateChannelErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateChannelErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateChannelErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::CreateChannelErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateChannelErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::CreateChannelErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::CreateChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChannelBanErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateChannelBanErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::CreateChannelBanErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::CreateChannelBanErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChannelFlowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::CreateChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChannelMembershipErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::CreateChannelMembershipErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateChannelMembershipErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateChannelMembershipErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateChannelMembershipErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::CreateChannelMembershipErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::CreateChannelMembershipErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::CreateChannelMembershipErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::CreateChannelMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChannelModeratorErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::CreateChannelModeratorErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateChannelModeratorErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateChannelModeratorErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateChannelModeratorErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::CreateChannelModeratorErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::CreateChannelModeratorErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::CreateChannelModeratorErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::CreateChannelModeratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteChannelErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DeleteChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelBanErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DeleteChannelBanErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelFlowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DeleteChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelMembershipErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelMembershipErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteChannelMembershipErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelMembershipErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelMembershipErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteChannelMembershipErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelMembershipErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::DeleteChannelMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelMessageErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DeleteChannelMessageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChannelModeratorErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DeleteChannelModeratorErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteChannelModeratorErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DeleteChannelModeratorErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteChannelModeratorErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DeleteChannelModeratorErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::DeleteChannelModeratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeChannelError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChannelErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DescribeChannelErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DescribeChannelErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DescribeChannelErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeChannelErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DescribeChannelErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DescribeChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChannelBanErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DescribeChannelBanErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChannelFlowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::DescribeChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChannelMembershipErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DescribeChannelMembershipErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DescribeChannelMembershipErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DescribeChannelMembershipErrorKind::ServiceFailureException(
                    inner,
                ) => Error::ServiceFailureException(inner),
                crate::error::DescribeChannelMembershipErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeChannelMembershipErrorKind::ThrottledClientException(
                    inner,
                ) => Error::ThrottledClientException(inner),
                crate::error::DescribeChannelMembershipErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::DescribeChannelMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeChannelMembershipForAppInstanceUserError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeChannelMembershipForAppInstanceUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeChannelModeratedByAppInstanceUserError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeChannelModeratedByAppInstanceUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChannelModeratorErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DescribeChannelModeratorErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DescribeChannelModeratorErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DescribeChannelModeratorErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DescribeChannelModeratorErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeChannelModeratorErrorKind::ThrottledClientException(
                    inner,
                ) => Error::ThrottledClientException(inner),
                crate::error::DescribeChannelModeratorErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::DescribeChannelModeratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateChannelFlowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DisassociateChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::DisassociateChannelFlowErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::DisassociateChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetChannelMembershipPreferencesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetChannelMembershipPreferencesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetChannelMembershipPreferencesErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::GetChannelMembershipPreferencesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetChannelMessageErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::GetChannelMessageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetChannelMessageErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetChannelMessageErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::GetChannelMessageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetChannelMessageErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::GetChannelMessageErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::GetChannelMessageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetChannelMessageStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetChannelMessageStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetChannelMessageStatusErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::GetChannelMessageStatusErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetChannelMessageStatusErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::GetChannelMessageStatusErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::GetChannelMessageStatusErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::GetChannelMessageStatusErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::GetChannelMessageStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMessagingSessionEndpointErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetMessagingSessionEndpointErrorKind::ServiceFailureException(
                    inner,
                ) => Error::ServiceFailureException(inner),
                crate::error::GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::GetMessagingSessionEndpointErrorKind::ThrottledClientException(
                    inner,
                ) => Error::ThrottledClientException(inner),
                crate::error::GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::GetMessagingSessionEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelBansError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListChannelBansError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelBansErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelBansErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelBansErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelBansErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListChannelBansErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelBansErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ListChannelBansErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelFlowsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListChannelFlowsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelFlowsErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ListChannelFlowsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelMembershipsErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelMembershipsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelMembershipsErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelMembershipsErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListChannelMembershipsErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelMembershipsErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::ListChannelMembershipsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListChannelMembershipsForAppInstanceUserError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListChannelMembershipsForAppInstanceUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelMessagesErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ListChannelMessagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelModeratorsErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelModeratorsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelModeratorsErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelModeratorsErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListChannelModeratorsErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelModeratorsErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::ListChannelModeratorsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChannelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListChannelsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChannelsErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListChannelsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListChannelsErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListChannelsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListChannelsErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListChannelsErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ListChannelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListChannelsAssociatedWithChannelFlowError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListChannelsAssociatedWithChannelFlowError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListChannelsModeratedByAppInstanceUserError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListChannelsModeratedByAppInstanceUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::PutChannelMembershipPreferencesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutChannelMembershipPreferencesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutChannelMembershipPreferencesErrorKind::BadRequestException(inner) => Error::BadRequestException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::ServiceFailureException(inner) => Error::ServiceFailureException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::ThrottledClientException(inner) => Error::ThrottledClientException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
                crate::error::PutChannelMembershipPreferencesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RedactChannelMessageErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::RedactChannelMessageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SendChannelMessageErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::SendChannelMessageErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::SendChannelMessageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::SendChannelMessageErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::SendChannelMessageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::SendChannelMessageErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::SendChannelMessageErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::SendChannelMessageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::TagResourceErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::TagResourceErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::TagResourceErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::UntagResourceErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UntagResourceErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::UntagResourceErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateChannelError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateChannelErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::UpdateChannelErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateChannelErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::UpdateChannelErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::UpdateChannelErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateChannelErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::UpdateChannelErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::UpdateChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateChannelFlowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateChannelFlowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateChannelFlowErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::UpdateChannelFlowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateChannelMessageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateChannelMessageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateChannelMessageErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::UnauthorizedClientException(inner) => {
                    Error::UnauthorizedClientException(inner)
                }
                crate::error::UpdateChannelMessageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateChannelReadMarkerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateChannelReadMarkerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateChannelReadMarkerErrorKind::BadRequestException(inner) => {
                    Error::BadRequestException(inner)
                }
                crate::error::UpdateChannelReadMarkerErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateChannelReadMarkerErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::UpdateChannelReadMarkerErrorKind::ServiceFailureException(inner) => {
                    Error::ServiceFailureException(inner)
                }
                crate::error::UpdateChannelReadMarkerErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateChannelReadMarkerErrorKind::ThrottledClientException(inner) => {
                    Error::ThrottledClientException(inner)
                }
                crate::error::UpdateChannelReadMarkerErrorKind::UnauthorizedClientException(
                    inner,
                ) => Error::UnauthorizedClientException(inner),
                crate::error::UpdateChannelReadMarkerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
