// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateChannelFlowInput`](crate::input::AssociateChannelFlowInput)
pub mod associate_channel_flow_input {
    /// A builder for [`AssociateChannelFlowInput`](crate::input::AssociateChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateChannelFlowInput`](crate::input::AssociateChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateChannelFlowInput {
                channel_arn: self.channel_arn,
                channel_flow_arn: self.channel_flow_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateChannelFlowInputOperationOutputAlias = crate::operation::AssociateChannelFlow;
#[doc(hidden)]
pub type AssociateChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`AssociateChannelFlow`](crate::operation::AssociateChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.channel_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/channel-flow",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AssociateChannelFlowInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_2) = &_input.chime_bearer {
                let formatted_3 = AsRef::<str>::as_ref(inner_2);
                if !formatted_3.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_3;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_channel_flow(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateChannelFlowInput`](crate::input::AssociateChannelFlowInput)
    pub fn builder() -> crate::input::associate_channel_flow_input::Builder {
        crate::input::associate_channel_flow_input::Builder::default()
    }
}

/// See [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
pub mod batch_create_channel_membership_input {
    /// A builder for [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) member_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `member_arns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.member_arns.unwrap_or_default();
            v.push(input.into());
            self.member_arns = Some(v);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.member_arns = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateChannelMembershipInput {
                channel_arn: self.channel_arn,
                r#type: self.r#type,
                member_arns: self.member_arns,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateChannelMembershipInputOperationOutputAlias =
    crate::operation::BatchCreateChannelMembership;
#[doc(hidden)]
pub type BatchCreateChannelMembershipInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateChannelMembership`](crate::operation::BatchCreateChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.channel_arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_4, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_5) = &_input.chime_bearer {
                let formatted_6 = AsRef::<str>::as_ref(inner_5);
                if !formatted_6.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_6;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-create");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_channel_membership(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateChannelMembership",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    pub fn builder() -> crate::input::batch_create_channel_membership_input::Builder {
        crate::input::batch_create_channel_membership_input::Builder::default()
    }
}

/// See [`ChannelFlowCallbackInput`](crate::input::ChannelFlowCallbackInput)
pub mod channel_flow_callback_input {
    /// A builder for [`ChannelFlowCallbackInput`](crate::input::ChannelFlowCallbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) callback_id: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) delete_resource: std::option::Option<bool>,
        pub(crate) channel_message: std::option::Option<crate::model::ChannelMessageCallback>,
    }
    impl Builder {
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn callback_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.callback_id = Some(input.into());
            self
        }
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn set_callback_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.callback_id = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn delete_resource(mut self, input: bool) -> Self {
            self.delete_resource = Some(input);
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn set_delete_resource(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_resource = input;
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn channel_message(mut self, input: crate::model::ChannelMessageCallback) -> Self {
            self.channel_message = Some(input);
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn set_channel_message(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageCallback>,
        ) -> Self {
            self.channel_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelFlowCallbackInput`](crate::input::ChannelFlowCallbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ChannelFlowCallbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ChannelFlowCallbackInput {
                callback_id: self.callback_id,
                channel_arn: self.channel_arn,
                delete_resource: self.delete_resource.unwrap_or_default(),
                channel_message: self.channel_message,
            })
        }
    }
}
#[doc(hidden)]
pub type ChannelFlowCallbackInputOperationOutputAlias = crate::operation::ChannelFlowCallback;
#[doc(hidden)]
pub type ChannelFlowCallbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ChannelFlowCallbackInput {
    /// Consumes the builder and constructs an Operation<[`ChannelFlowCallback`](crate::operation::ChannelFlowCallback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ChannelFlowCallback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ChannelFlowCallbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.channel_arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_7, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ChannelFlowCallbackInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "channel-flow-callback");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ChannelFlowCallbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ChannelFlowCallbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.callback_id.is_none() {
            self.callback_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_channel_flow_callback(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ChannelFlowCallback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ChannelFlowCallback",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ChannelFlowCallbackInput`](crate::input::ChannelFlowCallbackInput)
    pub fn builder() -> crate::input::channel_flow_callback_input::Builder {
        crate::input::channel_flow_callback_input::Builder::default()
    }
}

/// See [`CreateChannelInput`](crate::input::CreateChannelInput)
pub mod create_channel_input {
    /// A builder for [`CreateChannelInput`](crate::input::CreateChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelInput`](crate::input::CreateChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelInput {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                client_request_token: self.client_request_token,
                tags: self.tags,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelInputOperationOutputAlias = crate::operation::CreateChannel;
#[doc(hidden)]
pub type CreateChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannel`](crate::operation::CreateChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_8) = &_input.chime_bearer {
                let formatted_9 = AsRef::<str>::as_ref(inner_8);
                if !formatted_9.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_9;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_channel(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannel",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
}

/// See [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
pub mod create_channel_ban_input {
    /// A builder for [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelBanInputOperationOutputAlias = crate::operation::CreateChannelBan;
#[doc(hidden)]
pub type CreateChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelBan`](crate::operation::CreateChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.channel_arn;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_10, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_11) = &_input.chime_bearer {
                let formatted_12 = AsRef::<str>::as_ref(inner_11);
                if !formatted_12.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_12;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_ban(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelBan",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    pub fn builder() -> crate::input::create_channel_ban_input::Builder {
        crate::input::create_channel_ban_input::Builder::default()
    }
}

/// See [`CreateChannelFlowInput`](crate::input::CreateChannelFlowInput)
pub mod create_channel_flow_input {
    /// A builder for [`CreateChannelFlowInput`](crate::input::CreateChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Appends an item to `processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions.</p>
        pub fn processors(mut self, input: crate::model::Processor) -> Self {
            let mut v = self.processors.unwrap_or_default();
            v.push(input);
            self.processors = Some(v);
            self
        }
        /// <p>Information about the processor Lambda functions.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.processors = input;
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelFlowInput`](crate::input::CreateChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelFlowInput {
                app_instance_arn: self.app_instance_arn,
                processors: self.processors,
                name: self.name,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelFlowInputOperationOutputAlias = crate::operation::CreateChannelFlow;
#[doc(hidden)]
pub type CreateChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelFlow`](crate::operation::CreateChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channel-flows").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelFlowInput`](crate::input::CreateChannelFlowInput)
    pub fn builder() -> crate::input::create_channel_flow_input::Builder {
        crate::input::create_channel_flow_input::Builder::default()
    }
}

/// See [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
pub mod create_channel_membership_input {
    /// A builder for [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                r#type: self.r#type,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelMembershipInputOperationOutputAlias =
    crate::operation::CreateChannelMembership;
#[doc(hidden)]
pub type CreateChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelMembership`](crate::operation::CreateChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.channel_arn;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_13, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_14) = &_input.chime_bearer {
                let formatted_15 = AsRef::<str>::as_ref(inner_14);
                if !formatted_15.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_15;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_membership(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelMembership",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    pub fn builder() -> crate::input::create_channel_membership_input::Builder {
        crate::input::create_channel_membership_input::Builder::default()
    }
}

/// See [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
pub mod create_channel_moderator_input {
    /// A builder for [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelModeratorInputOperationOutputAlias = crate::operation::CreateChannelModerator;
#[doc(hidden)]
pub type CreateChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelModerator`](crate::operation::CreateChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.channel_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_17) = &_input.chime_bearer {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_moderator(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelModerator",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    pub fn builder() -> crate::input::create_channel_moderator_input::Builder {
        crate::input::create_channel_moderator_input::Builder::default()
    }
}

/// See [`DeleteChannelInput`](crate::input::DeleteChannelInput)
pub mod delete_channel_input {
    /// A builder for [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelInput`](crate::input::DeleteChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelInput {
                channel_arn: self.channel_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelInputOperationOutputAlias = crate::operation::DeleteChannel;
#[doc(hidden)]
pub type DeleteChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannel`](crate::operation::DeleteChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.channel_arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_19, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_20) = &_input.chime_bearer {
                let formatted_21 = AsRef::<str>::as_ref(inner_20);
                if !formatted_21.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_21;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannel",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
}

/// See [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
pub mod delete_channel_ban_input {
    /// A builder for [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelBanInputOperationOutputAlias = crate::operation::DeleteChannelBan;
#[doc(hidden)]
pub type DeleteChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelBan`](crate::operation::DeleteChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.channel_arn;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_22, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.member_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_24) = &_input.chime_bearer {
                let formatted_25 = AsRef::<str>::as_ref(inner_24);
                if !formatted_25.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_25;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelBan",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    pub fn builder() -> crate::input::delete_channel_ban_input::Builder {
        crate::input::delete_channel_ban_input::Builder::default()
    }
}

/// See [`DeleteChannelFlowInput`](crate::input::DeleteChannelFlowInput)
pub mod delete_channel_flow_input {
    /// A builder for [`DeleteChannelFlowInput`](crate::input::DeleteChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelFlowInput`](crate::input::DeleteChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelFlowInput {
                channel_flow_arn: self.channel_flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelFlowInputOperationOutputAlias = crate::operation::DeleteChannelFlow;
#[doc(hidden)]
pub type DeleteChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelFlow`](crate::operation::DeleteChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.channel_flow_arn;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_flow_arn = aws_smithy_http::label::fmt_string(input_26, false);
            if channel_flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channel-flows/{ChannelFlowArn}",
                ChannelFlowArn = channel_flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelFlowInput`](crate::input::DeleteChannelFlowInput)
    pub fn builder() -> crate::input::delete_channel_flow_input::Builder {
        crate::input::delete_channel_flow_input::Builder::default()
    }
}

/// See [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
pub mod delete_channel_membership_input {
    /// A builder for [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelMembershipInputOperationOutputAlias =
    crate::operation::DeleteChannelMembership;
#[doc(hidden)]
pub type DeleteChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelMembership`](crate::operation::DeleteChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.channel_arn;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_27, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.member_arn;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_28, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_29) = &_input.chime_bearer {
                let formatted_30 = AsRef::<str>::as_ref(inner_29);
                if !formatted_30.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_30;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelMembership",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    pub fn builder() -> crate::input::delete_channel_membership_input::Builder {
        crate::input::delete_channel_membership_input::Builder::default()
    }
}

/// See [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
pub mod delete_channel_message_input {
    /// A builder for [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelMessageInputOperationOutputAlias = crate::operation::DeleteChannelMessage;
#[doc(hidden)]
pub type DeleteChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelMessage`](crate::operation::DeleteChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.channel_arn;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_31, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.message_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_32, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_33) = &_input.chime_bearer {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelMessage",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    pub fn builder() -> crate::input::delete_channel_message_input::Builder {
        crate::input::delete_channel_message_input::Builder::default()
    }
}

/// See [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
pub mod delete_channel_moderator_input {
    /// A builder for [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelModeratorInputOperationOutputAlias = crate::operation::DeleteChannelModerator;
#[doc(hidden)]
pub type DeleteChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelModerator`](crate::operation::DeleteChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.channel_arn;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_35, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.channel_moderator_arn;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_moderator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_moderator_arn = aws_smithy_http::label::fmt_string(input_36, false);
            if channel_moderator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_moderator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}",
                ChannelArn = channel_arn,
                ChannelModeratorArn = channel_moderator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_37) = &_input.chime_bearer {
                let formatted_38 = AsRef::<str>::as_ref(inner_37);
                if !formatted_38.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_38;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelModerator",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    pub fn builder() -> crate::input::delete_channel_moderator_input::Builder {
        crate::input::delete_channel_moderator_input::Builder::default()
    }
}

/// See [`DescribeChannelInput`](crate::input::DescribeChannelInput)
pub mod describe_channel_input {
    /// A builder for [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelInput`](crate::input::DescribeChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelInput {
                channel_arn: self.channel_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelInputOperationOutputAlias = crate::operation::DescribeChannel;
#[doc(hidden)]
pub type DescribeChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannel`](crate::operation::DescribeChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.channel_arn;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_39, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_40) = &_input.chime_bearer {
                let formatted_41 = AsRef::<str>::as_ref(inner_40);
                if !formatted_41.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_41;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannel",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
}

/// See [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
pub mod describe_channel_ban_input {
    /// A builder for [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelBanInputOperationOutputAlias = crate::operation::DescribeChannelBan;
#[doc(hidden)]
pub type DescribeChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelBan`](crate::operation::DescribeChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.channel_arn;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_42, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_43 = &_input.member_arn;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_43, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_44) = &_input.chime_bearer {
                let formatted_45 = AsRef::<str>::as_ref(inner_44);
                if !formatted_45.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_45;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelBan",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    pub fn builder() -> crate::input::describe_channel_ban_input::Builder {
        crate::input::describe_channel_ban_input::Builder::default()
    }
}

/// See [`DescribeChannelFlowInput`](crate::input::DescribeChannelFlowInput)
pub mod describe_channel_flow_input {
    /// A builder for [`DescribeChannelFlowInput`](crate::input::DescribeChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelFlowInput`](crate::input::DescribeChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelFlowInput {
                channel_flow_arn: self.channel_flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelFlowInputOperationOutputAlias = crate::operation::DescribeChannelFlow;
#[doc(hidden)]
pub type DescribeChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelFlow`](crate::operation::DescribeChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.channel_flow_arn;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_flow_arn = aws_smithy_http::label::fmt_string(input_46, false);
            if channel_flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channel-flows/{ChannelFlowArn}",
                ChannelFlowArn = channel_flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelFlowInput`](crate::input::DescribeChannelFlowInput)
    pub fn builder() -> crate::input::describe_channel_flow_input::Builder {
        crate::input::describe_channel_flow_input::Builder::default()
    }
}

/// See [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
pub mod describe_channel_membership_input {
    /// A builder for [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelMembershipInputOperationOutputAlias =
    crate::operation::DescribeChannelMembership;
#[doc(hidden)]
pub type DescribeChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelMembership`](crate::operation::DescribeChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.channel_arn;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_47, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_48 = &_input.member_arn;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_48, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_49) = &_input.chime_bearer {
                let formatted_50 = AsRef::<str>::as_ref(inner_49);
                if !formatted_50.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_50;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelMembership",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    pub fn builder() -> crate::input::describe_channel_membership_input::Builder {
        crate::input::describe_channel_membership_input::Builder::default()
    }
}

/// See [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
pub mod describe_channel_membership_for_app_instance_user_input {
    /// A builder for [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeChannelMembershipForAppInstanceUserInput {
                    channel_arn: self.channel_arn,
                    app_instance_user_arn: self.app_instance_user_arn,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelMembershipForAppInstanceUserInputOperationOutputAlias =
    crate::operation::DescribeChannelMembershipForAppInstanceUser;
#[doc(hidden)]
pub type DescribeChannelMembershipForAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelMembershipForAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelMembershipForAppInstanceUser`](crate::operation::DescribeChannelMembershipForAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelMembershipForAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.channel_arn;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_51, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_52) = &_input.chime_bearer {
                let formatted_53 = AsRef::<str>::as_ref(inner_52);
                if !formatted_53.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_53;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-membership");
            if let Some(inner_54) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_54),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelMembershipForAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelMembershipForAppInstanceUser",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    pub fn builder(
    ) -> crate::input::describe_channel_membership_for_app_instance_user_input::Builder {
        crate::input::describe_channel_membership_for_app_instance_user_input::Builder::default()
    }
}

/// See [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
pub mod describe_channel_moderated_by_app_instance_user_input {
    /// A builder for [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeChannelModeratedByAppInstanceUserInput {
                    channel_arn: self.channel_arn,
                    app_instance_user_arn: self.app_instance_user_arn,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelModeratedByAppInstanceUserInputOperationOutputAlias =
    crate::operation::DescribeChannelModeratedByAppInstanceUser;
#[doc(hidden)]
pub type DescribeChannelModeratedByAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelModeratedByAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelModeratedByAppInstanceUser`](crate::operation::DescribeChannelModeratedByAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelModeratedByAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.channel_arn;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_55, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_56) = &_input.chime_bearer {
                let formatted_57 = AsRef::<str>::as_ref(inner_56);
                if !formatted_57.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_57;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-moderated-channel");
            if let Some(inner_58) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_58),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelModeratedByAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelModeratedByAppInstanceUser",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_channel_moderated_by_app_instance_user_input::Builder
    {
        crate::input::describe_channel_moderated_by_app_instance_user_input::Builder::default()
    }
}

/// See [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
pub mod describe_channel_moderator_input {
    /// A builder for [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelModeratorInputOperationOutputAlias =
    crate::operation::DescribeChannelModerator;
#[doc(hidden)]
pub type DescribeChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelModerator`](crate::operation::DescribeChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_59 = &_input.channel_arn;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_59, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_60 = &_input.channel_moderator_arn;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_moderator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_moderator_arn = aws_smithy_http::label::fmt_string(input_60, false);
            if channel_moderator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_moderator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}",
                ChannelArn = channel_arn,
                ChannelModeratorArn = channel_moderator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_61) = &_input.chime_bearer {
                let formatted_62 = AsRef::<str>::as_ref(inner_61);
                if !formatted_62.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_62;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelModerator",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    pub fn builder() -> crate::input::describe_channel_moderator_input::Builder {
        crate::input::describe_channel_moderator_input::Builder::default()
    }
}

/// See [`DisassociateChannelFlowInput`](crate::input::DisassociateChannelFlowInput)
pub mod disassociate_channel_flow_input {
    /// A builder for [`DisassociateChannelFlowInput`](crate::input::DisassociateChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateChannelFlowInput`](crate::input::DisassociateChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateChannelFlowInput {
                channel_arn: self.channel_arn,
                channel_flow_arn: self.channel_flow_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateChannelFlowInputOperationOutputAlias =
    crate::operation::DisassociateChannelFlow;
#[doc(hidden)]
pub type DisassociateChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateChannelFlow`](crate::operation::DisassociateChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_63 = &_input.channel_arn;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_63, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_64 = &_input.channel_flow_arn;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_flow_arn = aws_smithy_http::label::fmt_string(input_64, false);
            if channel_flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/channel-flow/{ChannelFlowArn}",
                ChannelArn = channel_arn,
                ChannelFlowArn = channel_flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DisassociateChannelFlowInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_65) = &_input.chime_bearer {
                let formatted_66 = AsRef::<str>::as_ref(inner_65);
                if !formatted_66.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_66;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateChannelFlowInput`](crate::input::DisassociateChannelFlowInput)
    pub fn builder() -> crate::input::disassociate_channel_flow_input::Builder {
        crate::input::disassociate_channel_flow_input::Builder::default()
    }
}

/// See [`GetChannelMembershipPreferencesInput`](crate::input::GetChannelMembershipPreferencesInput)
pub mod get_channel_membership_preferences_input {
    /// A builder for [`GetChannelMembershipPreferencesInput`](crate::input::GetChannelMembershipPreferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMembershipPreferencesInput`](crate::input::GetChannelMembershipPreferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChannelMembershipPreferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChannelMembershipPreferencesInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChannelMembershipPreferencesInputOperationOutputAlias =
    crate::operation::GetChannelMembershipPreferences;
#[doc(hidden)]
pub type GetChannelMembershipPreferencesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetChannelMembershipPreferencesInput {
    /// Consumes the builder and constructs an Operation<[`GetChannelMembershipPreferences`](crate::operation::GetChannelMembershipPreferences)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChannelMembershipPreferences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChannelMembershipPreferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.channel_arn;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_67, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_68 = &_input.member_arn;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_68, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}/preferences",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetChannelMembershipPreferencesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_69) = &_input.chime_bearer {
                let formatted_70 = AsRef::<str>::as_ref(inner_69);
                if !formatted_70.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_70;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChannelMembershipPreferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChannelMembershipPreferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChannelMembershipPreferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChannelMembershipPreferences",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChannelMembershipPreferencesInput`](crate::input::GetChannelMembershipPreferencesInput)
    pub fn builder() -> crate::input::get_channel_membership_preferences_input::Builder {
        crate::input::get_channel_membership_preferences_input::Builder::default()
    }
}

/// See [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
pub mod get_channel_message_input {
    /// A builder for [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChannelMessageInputOperationOutputAlias = crate::operation::GetChannelMessage;
#[doc(hidden)]
pub type GetChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`GetChannelMessage`](crate::operation::GetChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.channel_arn;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_71, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_72 = &_input.message_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_72, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_73) = &_input.chime_bearer {
                let formatted_74 = AsRef::<str>::as_ref(inner_73);
                if !formatted_74.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_74;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChannelMessage",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    pub fn builder() -> crate::input::get_channel_message_input::Builder {
        crate::input::get_channel_message_input::Builder::default()
    }
}

/// See [`GetChannelMessageStatusInput`](crate::input::GetChannelMessageStatusInput)
pub mod get_channel_message_status_input {
    /// A builder for [`GetChannelMessageStatusInput`](crate::input::GetChannelMessageStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMessageStatusInput`](crate::input::GetChannelMessageStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChannelMessageStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChannelMessageStatusInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChannelMessageStatusInputOperationOutputAlias =
    crate::operation::GetChannelMessageStatus;
#[doc(hidden)]
pub type GetChannelMessageStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetChannelMessageStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetChannelMessageStatus`](crate::operation::GetChannelMessageStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChannelMessageStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChannelMessageStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.channel_arn;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_75, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_76 = &_input.message_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_76, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetChannelMessageStatusInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_77) = &_input.chime_bearer {
                let formatted_78 = AsRef::<str>::as_ref(inner_77);
                if !formatted_78.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_78;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetChannelMessageStatusInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "message-status");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChannelMessageStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChannelMessageStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChannelMessageStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChannelMessageStatus",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChannelMessageStatusInput`](crate::input::GetChannelMessageStatusInput)
    pub fn builder() -> crate::input::get_channel_message_status_input::Builder {
        crate::input::get_channel_message_status_input::Builder::default()
    }
}

/// See [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
pub mod get_messaging_session_endpoint_input {
    /// A builder for [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMessagingSessionEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMessagingSessionEndpointInput {})
        }
    }
}
#[doc(hidden)]
pub type GetMessagingSessionEndpointInputOperationOutputAlias =
    crate::operation::GetMessagingSessionEndpoint;
#[doc(hidden)]
pub type GetMessagingSessionEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMessagingSessionEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetMessagingSessionEndpoint`](crate::operation::GetMessagingSessionEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMessagingSessionEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMessagingSessionEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/endpoints/messaging-session").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMessagingSessionEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMessagingSessionEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMessagingSessionEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMessagingSessionEndpoint",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    pub fn builder() -> crate::input::get_messaging_session_endpoint_input::Builder {
        crate::input::get_messaging_session_endpoint_input::Builder::default()
    }
}

/// See [`ListChannelBansInput`](crate::input::ListChannelBansInput)
pub mod list_channel_bans_input {
    /// A builder for [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelBansInput`](crate::input::ListChannelBansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelBansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelBansInput {
                channel_arn: self.channel_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelBansInputOperationOutputAlias = crate::operation::ListChannelBans;
#[doc(hidden)]
pub type ListChannelBansInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelBansInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelBans`](crate::operation::ListChannelBans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelBans,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelBansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.channel_arn;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_79, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelBansInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_80) = &_input.chime_bearer {
                let formatted_81 = AsRef::<str>::as_ref(inner_80);
                if !formatted_81.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_81;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelBansInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_82) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_82).encode(),
                );
            }
            if let Some(inner_83) = &_input.next_token {
                query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_83));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelBansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelBansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelBans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelBans",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    pub fn builder() -> crate::input::list_channel_bans_input::Builder {
        crate::input::list_channel_bans_input::Builder::default()
    }
}

/// See [`ListChannelFlowsInput`](crate::input::ListChannelFlowsInput)
pub mod list_channel_flows_input {
    /// A builder for [`ListChannelFlowsInput`](crate::input::ListChannelFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the app instance.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the app instance.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelFlowsInput`](crate::input::ListChannelFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelFlowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelFlowsInput {
                app_instance_arn: self.app_instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelFlowsInputOperationOutputAlias = crate::operation::ListChannelFlows;
#[doc(hidden)]
pub type ListChannelFlowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelFlowsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelFlows`](crate::operation::ListChannelFlows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelFlows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channel-flows").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListChannelFlowsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_84) = &_input.app_instance_arn {
                query.push_kv(
                    "app-instance-arn",
                    &aws_smithy_http::query::fmt_string(&inner_84),
                );
            }
            if let Some(inner_85) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_85).encode(),
                );
            }
            if let Some(inner_86) = &_input.next_token {
                query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_86));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelFlows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelFlows",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelFlowsInput`](crate::input::ListChannelFlowsInput)
    pub fn builder() -> crate::input::list_channel_flows_input::Builder {
        crate::input::list_channel_flows_input::Builder::default()
    }
}

/// See [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
pub mod list_channel_memberships_input {
    /// A builder for [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMembershipsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelMembershipsInput {
                channel_arn: self.channel_arn,
                r#type: self.r#type,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelMembershipsInputOperationOutputAlias = crate::operation::ListChannelMemberships;
#[doc(hidden)]
pub type ListChannelMembershipsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMembershipsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMemberships`](crate::operation::ListChannelMemberships)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMemberships,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMembershipsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_87 = &_input.channel_arn;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_87, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMembershipsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_88) = &_input.chime_bearer {
                let formatted_89 = AsRef::<str>::as_ref(inner_88);
                if !formatted_89.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_89;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMembershipsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_90) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_90));
            }
            if let Some(inner_91) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_91).encode(),
                );
            }
            if let Some(inner_92) = &_input.next_token {
                query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_92));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMembershipsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMembershipsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelMemberships::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelMemberships",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    pub fn builder() -> crate::input::list_channel_memberships_input::Builder {
        crate::input::list_channel_memberships_input::Builder::default()
    }
}

/// See [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
pub mod list_channel_memberships_for_app_instance_user_input {
    /// A builder for [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMembershipsForAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListChannelMembershipsForAppInstanceUserInput {
                    app_instance_user_arn: self.app_instance_user_arn,
                    max_results: self.max_results,
                    next_token: self.next_token,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListChannelMembershipsForAppInstanceUserInputOperationOutputAlias =
    crate::operation::ListChannelMembershipsForAppInstanceUser;
#[doc(hidden)]
pub type ListChannelMembershipsForAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMembershipsForAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMembershipsForAppInstanceUser`](crate::operation::ListChannelMembershipsForAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMembershipsForAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_93) = &_input.chime_bearer {
                let formatted_94 = AsRef::<str>::as_ref(inner_93);
                if !formatted_94.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_94;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-memberships");
            if let Some(inner_95) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_95),
                );
            }
            if let Some(inner_96) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_96).encode(),
                );
            }
            if let Some(inner_97) = &_input.next_token {
                query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_97));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelMembershipsForAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelMembershipsForAppInstanceUser",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channel_memberships_for_app_instance_user_input::Builder
    {
        crate::input::list_channel_memberships_for_app_instance_user_input::Builder::default()
    }
}

/// See [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
pub mod list_channel_messages_input {
    /// A builder for [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelMessagesInput {
                channel_arn: self.channel_arn,
                sort_order: self.sort_order,
                not_before: self.not_before,
                not_after: self.not_after,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelMessagesInputOperationOutputAlias = crate::operation::ListChannelMessages;
#[doc(hidden)]
pub type ListChannelMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMessagesInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMessages`](crate::operation::ListChannelMessages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMessagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_98 = &_input.channel_arn;
            let input_98 =
                input_98
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_98, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMessagesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_99) = &_input.chime_bearer {
                let formatted_100 = AsRef::<str>::as_ref(inner_99);
                if !formatted_100.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_100;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMessagesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_101) = &_input.sort_order {
                query.push_kv(
                    "sort-order",
                    &aws_smithy_http::query::fmt_string(&inner_101),
                );
            }
            if let Some(inner_102) = &_input.not_before {
                query.push_kv(
                    "not-before",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_102,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_103) = &_input.not_after {
                query.push_kv(
                    "not-after",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_103,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_104) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_104).encode(),
                );
            }
            if let Some(inner_105) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_105),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMessagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMessagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelMessages",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
    pub fn builder() -> crate::input::list_channel_messages_input::Builder {
        crate::input::list_channel_messages_input::Builder::default()
    }
}

/// See [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
pub mod list_channel_moderators_input {
    /// A builder for [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelModeratorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelModeratorsInput {
                channel_arn: self.channel_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelModeratorsInputOperationOutputAlias = crate::operation::ListChannelModerators;
#[doc(hidden)]
pub type ListChannelModeratorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelModeratorsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelModerators`](crate::operation::ListChannelModerators)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelModerators,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelModeratorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_106 = &_input.channel_arn;
            let input_106 =
                input_106
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_106, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelModeratorsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_107) = &_input.chime_bearer {
                let formatted_108 = AsRef::<str>::as_ref(inner_107);
                if !formatted_108.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_108;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelModeratorsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_109) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_109).encode(),
                );
            }
            if let Some(inner_110) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_110),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelModeratorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelModeratorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelModerators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelModerators",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
    pub fn builder() -> crate::input::list_channel_moderators_input::Builder {
        crate::input::list_channel_moderators_input::Builder::default()
    }
}

/// See [`ListChannelsInput`](crate::input::ListChannelsInput)
pub mod list_channels_input {
    /// A builder for [`ListChannelsInput`](crate::input::ListChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsInput`](crate::input::ListChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelsInput {
                app_instance_arn: self.app_instance_arn,
                privacy: self.privacy,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelsInputOperationOutputAlias = crate::operation::ListChannels;
#[doc(hidden)]
pub type ListChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannels`](crate::operation::ListChannels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_111) = &_input.chime_bearer {
                let formatted_112 = AsRef::<str>::as_ref(inner_111);
                if !formatted_112.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_112;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_113) = &_input.app_instance_arn {
                query.push_kv(
                    "app-instance-arn",
                    &aws_smithy_http::query::fmt_string(&inner_113),
                );
            }
            if let Some(inner_114) = &_input.privacy {
                query.push_kv("privacy", &aws_smithy_http::query::fmt_string(&inner_114));
            }
            if let Some(inner_115) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_115).encode(),
                );
            }
            if let Some(inner_116) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_116),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannels",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
}

/// See [`ListChannelsAssociatedWithChannelFlowInput`](crate::input::ListChannelsAssociatedWithChannelFlowInput)
pub mod list_channels_associated_with_channel_flow_input {
    /// A builder for [`ListChannelsAssociatedWithChannelFlowInput`](crate::input::ListChannelsAssociatedWithChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsAssociatedWithChannelFlowInput`](crate::input::ListChannelsAssociatedWithChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelsAssociatedWithChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelsAssociatedWithChannelFlowInput {
                channel_flow_arn: self.channel_flow_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelsAssociatedWithChannelFlowInputOperationOutputAlias =
    crate::operation::ListChannelsAssociatedWithChannelFlow;
#[doc(hidden)]
pub type ListChannelsAssociatedWithChannelFlowInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelsAssociatedWithChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelsAssociatedWithChannelFlow`](crate::operation::ListChannelsAssociatedWithChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelsAssociatedWithChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelsAssociatedWithChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListChannelsAssociatedWithChannelFlowInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "channel-flow-associations");
            if let Some(inner_117) = &_input.channel_flow_arn {
                query.push_kv(
                    "channel-flow-arn",
                    &aws_smithy_http::query::fmt_string(&inner_117),
                );
            }
            if let Some(inner_118) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_118).encode(),
                );
            }
            if let Some(inner_119) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_119),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelsAssociatedWithChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelsAssociatedWithChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelsAssociatedWithChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelsAssociatedWithChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelsAssociatedWithChannelFlowInput`](crate::input::ListChannelsAssociatedWithChannelFlowInput)
    pub fn builder() -> crate::input::list_channels_associated_with_channel_flow_input::Builder {
        crate::input::list_channels_associated_with_channel_flow_input::Builder::default()
    }
}

/// See [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
pub mod list_channels_moderated_by_app_instance_user_input {
    /// A builder for [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelsModeratedByAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelsModeratedByAppInstanceUserInput {
                app_instance_user_arn: self.app_instance_user_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelsModeratedByAppInstanceUserInputOperationOutputAlias =
    crate::operation::ListChannelsModeratedByAppInstanceUser;
#[doc(hidden)]
pub type ListChannelsModeratedByAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelsModeratedByAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelsModeratedByAppInstanceUser`](crate::operation::ListChannelsModeratedByAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelsModeratedByAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelsModeratedByAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelsModeratedByAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_120) = &_input.chime_bearer {
                let formatted_121 = AsRef::<str>::as_ref(inner_120);
                if !formatted_121.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_121;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelsModeratedByAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-moderated-channels");
            if let Some(inner_122) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_122),
                );
            }
            if let Some(inner_123) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_123).encode(),
                );
            }
            if let Some(inner_124) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_124),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelsModeratedByAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelsModeratedByAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelsModeratedByAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelsModeratedByAppInstanceUser",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channels_moderated_by_app_instance_user_input::Builder {
        crate::input::list_channels_moderated_by_app_instance_user_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTagsForResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_125) = &_input.resource_arn {
                query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_125));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutChannelMembershipPreferencesInput`](crate::input::PutChannelMembershipPreferencesInput)
pub mod put_channel_membership_preferences_input {
    /// A builder for [`PutChannelMembershipPreferencesInput`](crate::input::PutChannelMembershipPreferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
        pub(crate) preferences: std::option::Option<crate::model::ChannelMembershipPreferences>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn preferences(mut self, input: crate::model::ChannelMembershipPreferences) -> Self {
            self.preferences = Some(input);
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn set_preferences(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipPreferences>,
        ) -> Self {
            self.preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`PutChannelMembershipPreferencesInput`](crate::input::PutChannelMembershipPreferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutChannelMembershipPreferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutChannelMembershipPreferencesInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
                preferences: self.preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type PutChannelMembershipPreferencesInputOperationOutputAlias =
    crate::operation::PutChannelMembershipPreferences;
#[doc(hidden)]
pub type PutChannelMembershipPreferencesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutChannelMembershipPreferencesInput {
    /// Consumes the builder and constructs an Operation<[`PutChannelMembershipPreferences`](crate::operation::PutChannelMembershipPreferences)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutChannelMembershipPreferences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutChannelMembershipPreferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_126 = &_input.channel_arn;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_126, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_127 = &_input.member_arn;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_127, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}/preferences",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutChannelMembershipPreferencesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_128) = &_input.chime_bearer {
                let formatted_129 = AsRef::<str>::as_ref(inner_128);
                if !formatted_129.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_129;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutChannelMembershipPreferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutChannelMembershipPreferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_channel_membership_preferences(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutChannelMembershipPreferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutChannelMembershipPreferences",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutChannelMembershipPreferencesInput`](crate::input::PutChannelMembershipPreferencesInput)
    pub fn builder() -> crate::input::put_channel_membership_preferences_input::Builder {
        crate::input::put_channel_membership_preferences_input::Builder::default()
    }
}

/// See [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
pub mod redact_channel_message_input {
    /// A builder for [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RedactChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RedactChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type RedactChannelMessageInputOperationOutputAlias = crate::operation::RedactChannelMessage;
#[doc(hidden)]
pub type RedactChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RedactChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`RedactChannelMessage`](crate::operation::RedactChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RedactChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RedactChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_130 = &_input.channel_arn;
            let input_130 =
                input_130
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_130, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_131 = &_input.message_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_131, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::RedactChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_132) = &_input.chime_bearer {
                let formatted_133 = AsRef::<str>::as_ref(inner_132);
                if !formatted_133.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_133;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::RedactChannelMessageInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "redact");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RedactChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RedactChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RedactChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RedactChannelMessage",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
    pub fn builder() -> crate::input::redact_channel_message_input::Builder {
        crate::input::redact_channel_message_input::Builder::default()
    }
}

/// See [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
pub mod send_channel_message_input {
    /// A builder for [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMessageType>,
        pub(crate) persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
        pub(crate) push_notification:
            std::option::Option<crate::model::PushNotificationConfiguration>,
        pub(crate) message_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn persistence(mut self, input: crate::model::ChannelMessagePersistenceType) -> Self {
            self.persistence = Some(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.persistence = input;
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn push_notification(
            mut self,
            input: crate::model::PushNotificationConfiguration,
        ) -> Self {
            self.push_notification = Some(input);
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn set_push_notification(
            mut self,
            input: std::option::Option<crate::model::PushNotificationConfiguration>,
        ) -> Self {
            self.push_notification = input;
            self
        }
        /// Adds a key-value pair to `message_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MessageAttributeValue,
        ) -> Self {
            let mut hash_map = self.message_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.message_attributes = Some(hash_map);
            self
        }
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.message_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendChannelMessageInput {
                channel_arn: self.channel_arn,
                content: self.content,
                r#type: self.r#type,
                persistence: self.persistence,
                metadata: self.metadata,
                client_request_token: self.client_request_token,
                chime_bearer: self.chime_bearer,
                push_notification: self.push_notification,
                message_attributes: self.message_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type SendChannelMessageInputOperationOutputAlias = crate::operation::SendChannelMessage;
#[doc(hidden)]
pub type SendChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`SendChannelMessage`](crate::operation::SendChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_134 = &_input.channel_arn;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_134, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::SendChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_135) = &_input.chime_bearer {
                let formatted_136 = AsRef::<str>::as_ref(inner_135);
                if !formatted_136.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_136;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_channel_message(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendChannelMessage",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
    pub fn builder() -> crate::input::send_channel_message_input::Builder {
        crate::input::send_channel_message_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::TagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "tag-resource");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "untag-resource");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateChannelInput`](crate::input::UpdateChannelInput)
pub mod update_channel_input {
    /// A builder for [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelInput`](crate::input::UpdateChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelInput {
                channel_arn: self.channel_arn,
                name: self.name,
                mode: self.mode,
                metadata: self.metadata,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelInputOperationOutputAlias = crate::operation::UpdateChannel;
#[doc(hidden)]
pub type UpdateChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannel`](crate::operation::UpdateChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_137 = &_input.channel_arn;
            let input_137 =
                input_137
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_137, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_138) = &_input.chime_bearer {
                let formatted_139 = AsRef::<str>::as_ref(inner_138);
                if !formatted_139.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_139;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_channel(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannel",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
}

/// See [`UpdateChannelFlowInput`](crate::input::UpdateChannelFlowInput)
pub mod update_channel_flow_input {
    /// A builder for [`UpdateChannelFlowInput`](crate::input::UpdateChannelFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Appends an item to `processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions </p>
        pub fn processors(mut self, input: crate::model::Processor) -> Self {
            let mut v = self.processors.unwrap_or_default();
            v.push(input);
            self.processors = Some(v);
            self
        }
        /// <p>Information about the processor Lambda functions </p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.processors = input;
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelFlowInput`](crate::input::UpdateChannelFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelFlowInput {
                channel_flow_arn: self.channel_flow_arn,
                processors: self.processors,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelFlowInputOperationOutputAlias = crate::operation::UpdateChannelFlow;
#[doc(hidden)]
pub type UpdateChannelFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelFlowInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannelFlow`](crate::operation::UpdateChannelFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannelFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_140 = &_input.channel_flow_arn;
            let input_140 =
                input_140
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_flow_arn = aws_smithy_http::label::fmt_string(input_140, false);
            if channel_flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channel-flows/{ChannelFlowArn}",
                ChannelFlowArn = channel_flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_channel_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannelFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannelFlow",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelFlowInput`](crate::input::UpdateChannelFlowInput)
    pub fn builder() -> crate::input::update_channel_flow_input::Builder {
        crate::input::update_channel_flow_input::Builder::default()
    }
}

/// See [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
pub mod update_channel_message_input {
    /// A builder for [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelMessageInputOperationOutputAlias = crate::operation::UpdateChannelMessage;
#[doc(hidden)]
pub type UpdateChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannelMessage`](crate::operation::UpdateChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_141 = &_input.channel_arn;
            let input_141 =
                input_141
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_141, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_142 = &_input.message_id;
            let input_142 =
                input_142
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_142, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_143) = &_input.chime_bearer {
                let formatted_144 = AsRef::<str>::as_ref(inner_143);
                if !formatted_144.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_144;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_channel_message(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannelMessage",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
    pub fn builder() -> crate::input::update_channel_message_input::Builder {
        crate::input::update_channel_message_input::Builder::default()
    }
}

/// See [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
pub mod update_channel_read_marker_input {
    /// A builder for [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelReadMarkerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelReadMarkerInput {
                channel_arn: self.channel_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelReadMarkerInputOperationOutputAlias =
    crate::operation::UpdateChannelReadMarker;
#[doc(hidden)]
pub type UpdateChannelReadMarkerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelReadMarkerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannelReadMarker`](crate::operation::UpdateChannelReadMarker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannelReadMarker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelReadMarkerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_145 = &_input.channel_arn;
            let input_145 =
                input_145
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_145, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/readMarker",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateChannelReadMarkerInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_146) = &_input.chime_bearer {
                let formatted_147 = AsRef::<str>::as_ref(inner_146);
                if !formatted_147.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_147;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelReadMarkerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelReadMarkerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannelReadMarker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannelReadMarker",
            "chimesdkmessaging",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
    pub fn builder() -> crate::input::update_channel_read_marker_input::Builder {
        crate::input::update_channel_read_marker_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelReadMarkerInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl UpdateChannelReadMarkerInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelReadMarkerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelReadMarkerInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID string of the message being updated.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The content of the message being updated.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The metadata of the message being updated.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl UpdateChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID string of the message being updated.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The content of the message being updated.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The metadata of the message being updated.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelMessageInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>Information about the processor Lambda functions </p>
    pub processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
    /// <p>Information about the processor Lambda functions </p>
    pub fn processors(&self) -> std::option::Option<&[crate::model::Processor]> {
        self.processors.as_deref()
    }
    /// <p>The name of the channel flow.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelFlowInput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("processors", &self.processors);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The mode of the update request.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The metadata for the update request.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl UpdateChannelInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The name of the channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The mode of the update request.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ChannelMode> {
        self.mode.as_ref()
    }
    /// <p>The metadata for the update request.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("mode", &self.mode);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key-value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The content of the message.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
    pub r#type: std::option::Option<crate::model::ChannelMessageType>,
    /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
    pub persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
    /// <p>The optional metadata for each message.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The <code>Idempotency</code> token for each client request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
    /// <p>The push notification configuration of the message.</p>
    pub push_notification: std::option::Option<crate::model::PushNotificationConfiguration>,
    /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
    pub message_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    >,
}
impl SendChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The content of the message.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMessageType> {
        self.r#type.as_ref()
    }
    /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
    pub fn persistence(&self) -> std::option::Option<&crate::model::ChannelMessagePersistenceType> {
        self.persistence.as_ref()
    }
    /// <p>The optional metadata for each message.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The <code>Idempotency</code> token for each client request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
    /// <p>The push notification configuration of the message.</p>
    pub fn push_notification(
        &self,
    ) -> std::option::Option<&crate::model::PushNotificationConfiguration> {
        self.push_notification.as_ref()
    }
    /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
    pub fn message_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    > {
        self.message_attributes.as_ref()
    }
}
impl std::fmt::Debug for SendChannelMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendChannelMessageInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("persistence", &self.persistence);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("client_request_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.field("push_notification", &self.push_notification);
        formatter.field("message_attributes", &self.message_attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedactChannelMessageInput {
    /// <p>The ARN of the channel containing the messages that you want to redact.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the message being redacted.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl RedactChannelMessageInput {
    /// <p>The ARN of the channel containing the messages that you want to redact.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID of the message being redacted.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for RedactChannelMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedactChannelMessageInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutChannelMembershipPreferencesInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
    /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
    pub preferences: std::option::Option<crate::model::ChannelMembershipPreferences>,
}
impl PutChannelMembershipPreferencesInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
    /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
    pub fn preferences(&self) -> std::option::Option<&crate::model::ChannelMembershipPreferences> {
        self.preferences.as_ref()
    }
}
impl std::fmt::Debug for PutChannelMembershipPreferencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutChannelMembershipPreferencesInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.field("preferences", &self.preferences);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsModeratedByAppInstanceUserInput {
    /// <p>The ARN of the user in the moderated channel.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of channels in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelsModeratedByAppInstanceUserInput {
    /// <p>The ARN of the user in the moderated channel.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The maximum number of channels in the request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsModeratedByAppInstanceUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsModeratedByAppInstanceUserInput");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsAssociatedWithChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of channels that you want to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChannelsAssociatedWithChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
    /// <p>The maximum number of channels that you want to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsAssociatedWithChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsAssociatedWithChannelFlowInput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsInput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The maximum number of channels that you want to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelsInput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
    pub fn privacy(&self) -> std::option::Option<&crate::model::ChannelPrivacy> {
        self.privacy.as_ref()
    }
    /// <p>The maximum number of channels that you want to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsInput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("privacy", &self.privacy);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelModeratorsInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of moderators that you want returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelModeratorsInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The maximum number of moderators that you want returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelModeratorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelModeratorsInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMessagesInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The initial or starting time stamp for your requested messages.</p>
    pub not_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The final or ending time stamp for your requested messages.</p>
    pub not_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of messages that you want returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested messages are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelMessagesInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The initial or starting time stamp for your requested messages.</p>
    pub fn not_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_before.as_ref()
    }
    /// <p>The final or ending time stamp for your requested messages.</p>
    pub fn not_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_after.as_ref()
    }
    /// <p>The maximum number of messages that you want returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested messages are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelMessagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMessagesInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("not_before", &self.not_before);
        formatter.field("not_after", &self.not_after);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMembershipsForAppInstanceUserInput {
    /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of users that you want returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelMembershipsForAppInstanceUserInput {
    /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The maximum number of users that you want returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelMembershipsForAppInstanceUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMembershipsForAppInstanceUserInput");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMembershipsInput {
    /// <p>The maximum number of channel memberships that you want returned.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The maximum number of channel memberships that you want returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelMembershipsInput {
    /// <p>The maximum number of channel memberships that you want returned.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The maximum number of channel memberships that you want returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelMembershipsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMembershipsInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelFlowsInput {
    /// <p>The ARN of the app instance.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of channel flows that you want to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChannelFlowsInput {
    /// <p>The ARN of the app instance.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The maximum number of channel flows that you want to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChannelFlowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelFlowsInput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelBansInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of bans that you want returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token passed by previous API calls until all requested bans are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl ListChannelBansInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The maximum number of bans that you want returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token passed by previous API calls until all requested bans are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for ListChannelBansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelBansInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMessagingSessionEndpointInput {}
impl std::fmt::Debug for GetMessagingSessionEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMessagingSessionEndpointInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelMessageStatusInput {
    /// <p>The ARN of the channel</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl GetChannelMessageStatusInput {
    /// <p>The ARN of the channel</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID of the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for GetChannelMessageStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelMessageStatusInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl GetChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID of the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for GetChannelMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelMessageInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelMembershipPreferencesInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl GetChannelMembershipPreferencesInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for GetChannelMembershipPreferencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelMembershipPreferencesInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateChannelFlowInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DisassociateChannelFlowInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DisassociateChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateChannelFlowInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
    pub channel_moderator_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
    pub fn channel_moderator_arn(&self) -> std::option::Option<&str> {
        self.channel_moderator_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelModeratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelModeratorInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_moderator_arn", &self.channel_moderator_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelModeratedByAppInstanceUserInput {
    /// <p>The ARN of the moderated channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelModeratedByAppInstanceUserInput {
    /// <p>The ARN of the moderated channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelModeratedByAppInstanceUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelModeratedByAppInstanceUserInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelMembershipForAppInstanceUserInput {
    /// <p>The ARN of the channel to which the user belongs.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the user in a channel.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelMembershipForAppInstanceUserInput {
    /// <p>The ARN of the channel to which the user belongs.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ARN of the user in a channel.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelMembershipForAppInstanceUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelMembershipForAppInstanceUserInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelMembershipInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelMembershipInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelMembershipInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelMembershipInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
}
impl DescribeChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelFlowInput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelBanInput {
    /// <p>The ARN of the channel from which the user is banned.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelBanInput {
    /// <p>The ARN of the channel from which the user is banned.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelBanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelBanInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DescribeChannelInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
    pub channel_moderator_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DeleteChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
    pub fn channel_moderator_arn(&self) -> std::option::Option<&str> {
        self.channel_moderator_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelModeratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelModeratorInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_moderator_arn", &self.channel_moderator_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the message being deleted.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DeleteChannelMessageInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID of the message being deleted.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelMessageInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelMembershipInput {
    /// <p>The ARN of the channel from which you want to remove the user.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DeleteChannelMembershipInput {
    /// <p>The ARN of the channel from which you want to remove the user.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelMembershipInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelMembershipInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
}
impl DeleteChannelFlowInput {
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelFlowInput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelBanInput {
    /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DeleteChannelBanInput {
    /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelBanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelBanInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelInput {
    /// <p>The ARN of the channel being deleted.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl DeleteChannelInput {
    /// <p>The ARN of the channel being deleted.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
    pub channel_moderator_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl CreateChannelModeratorInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
    pub fn channel_moderator_arn(&self) -> std::option::Option<&str> {
        self.channel_moderator_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for CreateChannelModeratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelModeratorInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_moderator_arn", &self.channel_moderator_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelMembershipInput {
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl CreateChannelMembershipInput {
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for CreateChannelMembershipInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelMembershipInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelFlowInput {
    /// <p>The ARN of the channel flow request.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>Information about the processor Lambda functions.</p>
    pub processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The tags for the creation request.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The client token for the request. An Idempotency token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateChannelFlowInput {
    /// <p>The ARN of the channel flow request.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>Information about the processor Lambda functions.</p>
    pub fn processors(&self) -> std::option::Option<&[crate::model::Processor]> {
        self.processors.as_deref()
    }
    /// <p>The name of the channel flow.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The tags for the creation request.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The client token for the request. An Idempotency token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelFlowInput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("processors", &self.processors);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.field("client_request_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelBanInput {
    /// <p>The ARN of the ban request.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl CreateChannelBanInput {
    /// <p>The ARN of the ban request.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for CreateChannelBanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelBanInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member_arn", &self.member_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelInput {
    /// <p>The ARN of the channel request.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags for the creation request.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl CreateChannelInput {
    /// <p>The ARN of the channel request.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The name of the channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ChannelMode> {
        self.mode.as_ref()
    }
    /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
    pub fn privacy(&self) -> std::option::Option<&crate::model::ChannelPrivacy> {
        self.privacy.as_ref()
    }
    /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The tags for the creation request.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for CreateChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelInput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("client_request_token", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelFlowCallbackInput {
    /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
    pub callback_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
    pub delete_resource: bool,
    /// <p>Stores information about the processed message.</p>
    pub channel_message: std::option::Option<crate::model::ChannelMessageCallback>,
}
impl ChannelFlowCallbackInput {
    /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
    pub fn callback_id(&self) -> std::option::Option<&str> {
        self.callback_id.as_deref()
    }
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
    pub fn delete_resource(&self) -> bool {
        self.delete_resource
    }
    /// <p>Stores information about the processed message.</p>
    pub fn channel_message(&self) -> std::option::Option<&crate::model::ChannelMessageCallback> {
        self.channel_message.as_ref()
    }
}
impl std::fmt::Debug for ChannelFlowCallbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelFlowCallbackInput");
        formatter.field("callback_id", &self.callback_id);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("delete_resource", &self.delete_resource);
        formatter.field("channel_message", &self.channel_message);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateChannelMembershipInput {
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
    pub member_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl BatchCreateChannelMembershipInput {
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
    pub fn member_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.member_arns.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateChannelMembershipInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateChannelMembershipInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("member_arns", &self.member_arns);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateChannelFlowInput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub chime_bearer: std::option::Option<std::string::String>,
}
impl AssociateChannelFlowInput {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ARN of the channel flow.</p>
    pub fn channel_flow_arn(&self) -> std::option::Option<&str> {
        self.channel_flow_arn.as_deref()
    }
    /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
    pub fn chime_bearer(&self) -> std::option::Option<&str> {
        self.chime_bearer.as_deref()
    }
}
impl std::fmt::Debug for AssociateChannelFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateChannelFlowInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("chime_bearer", &self.chime_bearer);
        formatter.finish()
    }
}
