// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateChannelFlowOutput,
    crate::error::AssociateChannelFlowError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateChannelFlowError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociateChannelFlowError {
                meta: generic,
                kind: crate::error::AssociateChannelFlowErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::AssociateChannelFlowError {
            meta: generic,
            kind: crate::error::AssociateChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateChannelFlowOutput,
    crate::error::AssociateChannelFlowError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_channel_flow_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_create_channel_membership_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchCreateChannelMembershipOutput,
    crate::error::BatchCreateChannelMembershipError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchCreateChannelMembershipError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ThrottledClientException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::BatchCreateChannelMembershipError {
            meta: generic,
            kind: crate::error::BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthorized_client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::BatchCreateChannelMembershipError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_create_channel_membership_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchCreateChannelMembershipOutput,
    crate::error::BatchCreateChannelMembershipError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_create_channel_membership_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_batch_create_channel_membership(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::BatchCreateChannelMembershipError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_channel_flow_callback_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChannelFlowCallbackOutput,
    crate::error::ChannelFlowCallbackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ChannelFlowCallbackError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::ChannelFlowCallbackError {
                meta: generic,
                kind: crate::error::ChannelFlowCallbackErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ChannelFlowCallbackError {
            meta: generic,
            kind: crate::error::ChannelFlowCallbackErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ChannelFlowCallbackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_channel_flow_callback_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChannelFlowCallbackOutput,
    crate::error::ChannelFlowCallbackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::channel_flow_callback_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_channel_flow_callback(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ChannelFlowCallbackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChannelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateChannelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateChannelError {
                meta: generic,
                kind: crate::error::CreateChannelErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateChannelError {
            meta: generic,
            kind: crate::error::CreateChannelErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChannelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_channel_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_channel(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChannelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_ban_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelBanOutput, crate::error::CreateChannelBanError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChannelBanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateChannelBanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateChannelBanError {
                meta: generic,
                kind: crate::error::CreateChannelBanErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateChannelBanError {
            meta: generic,
            kind: crate::error::CreateChannelBanErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChannelBanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_ban_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelBanOutput, crate::error::CreateChannelBanError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_channel_ban_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_channel_ban(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChannelBanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelFlowOutput, crate::error::CreateChannelFlowError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateChannelFlowError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateChannelFlowError {
                meta: generic,
                kind: crate::error::CreateChannelFlowErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateChannelFlowError {
            meta: generic,
            kind: crate::error::CreateChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateChannelFlowOutput, crate::error::CreateChannelFlowError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_channel_flow_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_channel_flow(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChannelFlowError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_membership_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateChannelMembershipOutput,
    crate::error::CreateChannelMembershipError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChannelMembershipError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateChannelMembershipError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateChannelMembershipError {
                meta: generic,
                kind: crate::error::CreateChannelMembershipErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateChannelMembershipError {
            meta: generic,
            kind: crate::error::CreateChannelMembershipErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChannelMembershipError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_membership_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateChannelMembershipOutput,
    crate::error::CreateChannelMembershipError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_channel_membership_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_channel_membership(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChannelMembershipError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_moderator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateChannelModeratorOutput,
    crate::error::CreateChannelModeratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateChannelModeratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateChannelModeratorError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateChannelModeratorError {
                meta: generic,
                kind: crate::error::CreateChannelModeratorErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::CreateChannelModeratorError {
            meta: generic,
            kind: crate::error::CreateChannelModeratorErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateChannelModeratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_channel_moderator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateChannelModeratorOutput,
    crate::error::CreateChannelModeratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_channel_moderator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_channel_moderator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateChannelModeratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChannelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelError {
            meta: generic,
            kind: crate::error::DeleteChannelErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_ban_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelBanOutput, crate::error::DeleteChannelBanError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelBanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChannelBanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelBanError {
            meta: generic,
            kind: crate::error::DeleteChannelBanErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelBanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_ban_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelBanOutput, crate::error::DeleteChannelBanError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_ban_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelFlowOutput, crate::error::DeleteChannelFlowError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChannelFlowError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteChannelFlowError {
                meta: generic,
                kind: crate::error::DeleteChannelFlowErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelFlowError {
            meta: generic,
            kind: crate::error::DeleteChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteChannelFlowOutput, crate::error::DeleteChannelFlowError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_flow_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_membership_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelMembershipOutput,
    crate::error::DeleteChannelMembershipError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteChannelMembershipError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteChannelMembershipError {
                meta: generic,
                kind: crate::error::DeleteChannelMembershipErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelMembershipError {
            meta: generic,
            kind: crate::error::DeleteChannelMembershipErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelMembershipError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_membership_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelMembershipOutput,
    crate::error::DeleteChannelMembershipError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_membership_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelMessageOutput,
    crate::error::DeleteChannelMessageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteChannelMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelMessageError {
            meta: generic,
            kind: crate::error::DeleteChannelMessageErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelMessageOutput,
    crate::error::DeleteChannelMessageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_message_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_moderator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelModeratorOutput,
    crate::error::DeleteChannelModeratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteChannelModeratorError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DeleteChannelModeratorError {
            meta: generic,
            kind: crate::error::DeleteChannelModeratorErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteChannelModeratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_channel_moderator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteChannelModeratorOutput,
    crate::error::DeleteChannelModeratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_channel_moderator_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeChannelOutput, crate::error::DescribeChannelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeChannelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DescribeChannelError {
            meta: generic,
            kind: crate::error::DescribeChannelErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChannelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeChannelOutput, crate::error::DescribeChannelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_channel_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChannelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_ban_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelBanOutput,
    crate::error::DescribeChannelBanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelBanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeChannelBanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DescribeChannelBanError {
            meta: generic,
            kind: crate::error::DescribeChannelBanErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelBanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChannelBanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_ban_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelBanOutput,
    crate::error::DescribeChannelBanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_channel_ban_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_ban(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChannelBanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelFlowOutput,
    crate::error::DescribeChannelFlowError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeChannelFlowError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DescribeChannelFlowError {
            meta: generic,
            kind: crate::error::DescribeChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelFlowOutput,
    crate::error::DescribeChannelFlowError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_channel_flow_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_flow(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChannelFlowError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_membership_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelMembershipOutput,
    crate::error::DescribeChannelMembershipError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeChannelMembershipError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DescribeChannelMembershipError {
            meta: generic,
            kind: crate::error::DescribeChannelMembershipErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChannelMembershipError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_membership_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelMembershipOutput,
    crate::error::DescribeChannelMembershipError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_channel_membership_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_membership(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChannelMembershipError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_membership_for_app_instance_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
    crate::error::DescribeChannelMembershipForAppInstanceUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ForbiddenException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottledClientException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedClientException" => crate::error::DescribeChannelMembershipForAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeChannelMembershipForAppInstanceUserError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_membership_for_app_instance_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
    crate::error::DescribeChannelMembershipForAppInstanceUserError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::describe_channel_membership_for_app_instance_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_membership_for_app_instance_user(response.body().as_ref(), output).map_err(crate::error::DescribeChannelMembershipForAppInstanceUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_moderated_by_app_instance_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
    crate::error::DescribeChannelModeratedByAppInstanceUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ForbiddenException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottledClientException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedClientException" => crate::error::DescribeChannelModeratedByAppInstanceUserError { meta: generic, kind: crate::error::DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeChannelModeratedByAppInstanceUserError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_moderated_by_app_instance_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
    crate::error::DescribeChannelModeratedByAppInstanceUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_channel_moderated_by_app_instance_user_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_moderated_by_app_instance_user(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratedByAppInstanceUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_moderator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelModeratorOutput,
    crate::error::DescribeChannelModeratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeChannelModeratorError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DescribeChannelModeratorError {
            meta: generic,
            kind: crate::error::DescribeChannelModeratorErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeChannelModeratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_channel_moderator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeChannelModeratorOutput,
    crate::error::DescribeChannelModeratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_channel_moderator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_channel_moderator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeChannelModeratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateChannelFlowOutput,
    crate::error::DisassociateChannelFlowError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateChannelFlowError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DisassociateChannelFlowError {
                meta: generic,
                kind: crate::error::DisassociateChannelFlowErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::DisassociateChannelFlowError {
            meta: generic,
            kind: crate::error::DisassociateChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateChannelFlowOutput,
    crate::error::DisassociateChannelFlowError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_channel_flow_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_membership_preferences_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChannelMembershipPreferencesOutput,
    crate::error::GetChannelMembershipPreferencesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetChannelMembershipPreferencesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::GetChannelMembershipPreferencesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::GetChannelMembershipPreferencesErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::GetChannelMembershipPreferencesErrorKind::ServiceFailureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_failure_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceUnavailableException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind:
                crate::error::GetChannelMembershipPreferencesErrorKind::ServiceUnavailableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_unavailable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ThrottledClientException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::GetChannelMembershipPreferencesErrorKind::ThrottledClientException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::throttled_client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedClientException" => crate::error::GetChannelMembershipPreferencesError {
            meta: generic,
            kind:
                crate::error::GetChannelMembershipPreferencesErrorKind::UnauthorizedClientException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::unauthorized_client_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::GetChannelMembershipPreferencesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_membership_preferences_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChannelMembershipPreferencesOutput,
    crate::error::GetChannelMembershipPreferencesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_channel_membership_preferences_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_channel_membership_preferences(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetChannelMembershipPreferencesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetChannelMessageOutput, crate::error::GetChannelMessageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetChannelMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetChannelMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::GetChannelMessageError {
            meta: generic,
            kind: crate::error::GetChannelMessageErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetChannelMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetChannelMessageOutput, crate::error::GetChannelMessageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_channel_message_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_channel_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetChannelMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_message_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChannelMessageStatusOutput,
    crate::error::GetChannelMessageStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetChannelMessageStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::GetChannelMessageStatusError {
            meta: generic,
            kind: crate::error::GetChannelMessageStatusErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetChannelMessageStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_channel_message_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChannelMessageStatusOutput,
    crate::error::GetChannelMessageStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_channel_message_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_channel_message_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetChannelMessageStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_messaging_session_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMessagingSessionEndpointOutput,
    crate::error::GetMessagingSessionEndpointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetMessagingSessionEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ForbiddenException" => crate::error::GetMessagingSessionEndpointError {
            meta: generic,
            kind: crate::error::GetMessagingSessionEndpointErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetMessagingSessionEndpointError {
            meta: generic,
            kind: crate::error::GetMessagingSessionEndpointErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetMessagingSessionEndpointError {
            meta: generic,
            kind: crate::error::GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ThrottledClientException" => crate::error::GetMessagingSessionEndpointError {
            meta: generic,
            kind: crate::error::GetMessagingSessionEndpointErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::GetMessagingSessionEndpointError {
            meta: generic,
            kind: crate::error::GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthorized_client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetMessagingSessionEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_messaging_session_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMessagingSessionEndpointOutput,
    crate::error::GetMessagingSessionEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_messaging_session_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_messaging_session_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMessagingSessionEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_bans_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelBansOutput, crate::error::ListChannelBansError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelBansError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChannelBansError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelBansError {
            meta: generic,
            kind: crate::error::ListChannelBansErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelBansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelBansError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_bans_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelBansOutput, crate::error::ListChannelBansError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channel_bans_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_bans(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelBansError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_flows_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelFlowsOutput, crate::error::ListChannelFlowsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelFlowsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChannelFlowsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelFlowsError {
            meta: generic,
            kind: crate::error::ListChannelFlowsErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelFlowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelFlowsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_flows_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelFlowsOutput, crate::error::ListChannelFlowsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channel_flows_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_flows(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelFlowsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_memberships_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMembershipsOutput,
    crate::error::ListChannelMembershipsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelMembershipsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListChannelMembershipsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelMembershipsError {
            meta: generic,
            kind: crate::error::ListChannelMembershipsErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelMembershipsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_memberships_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMembershipsOutput,
    crate::error::ListChannelMembershipsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channel_memberships_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_memberships(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelMembershipsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_memberships_for_app_instance_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMembershipsForAppInstanceUserOutput,
    crate::error::ListChannelMembershipsForAppInstanceUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ForbiddenException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottledClientException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedClientException" => crate::error::ListChannelMembershipsForAppInstanceUserError { meta: generic, kind: crate::error::ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListChannelMembershipsForAppInstanceUserError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_memberships_for_app_instance_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMembershipsForAppInstanceUserOutput,
    crate::error::ListChannelMembershipsForAppInstanceUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_channel_memberships_for_app_instance_user_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_memberships_for_app_instance_user(response.body().as_ref(), output).map_err(crate::error::ListChannelMembershipsForAppInstanceUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_messages_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMessagesOutput,
    crate::error::ListChannelMessagesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelMessagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChannelMessagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelMessagesError {
            meta: generic,
            kind: crate::error::ListChannelMessagesErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelMessagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelMessagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_messages_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelMessagesOutput,
    crate::error::ListChannelMessagesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channel_messages_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_messages(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelMessagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_moderators_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelModeratorsOutput,
    crate::error::ListChannelModeratorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelModeratorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChannelModeratorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelModeratorsError {
            meta: generic,
            kind: crate::error::ListChannelModeratorsErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelModeratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelModeratorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channel_moderators_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelModeratorsOutput,
    crate::error::ListChannelModeratorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channel_moderators_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channel_moderators(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelModeratorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChannelsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListChannelsError {
            meta: generic,
            kind: crate::error::ListChannelsErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChannelsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_channels_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channels(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChannelsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_associated_with_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelsAssociatedWithChannelFlowOutput,
    crate::error::ListChannelsAssociatedWithChannelFlowError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ForbiddenException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottledClientException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedClientException" => crate::error::ListChannelsAssociatedWithChannelFlowError { meta: generic, kind: crate::error::ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListChannelsAssociatedWithChannelFlowError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_associated_with_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelsAssociatedWithChannelFlowOutput,
    crate::error::ListChannelsAssociatedWithChannelFlowError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_channels_associated_with_channel_flow_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channels_associated_with_channel_flow(response.body().as_ref(), output).map_err(crate::error::ListChannelsAssociatedWithChannelFlowError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_moderated_by_app_instance_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelsModeratedByAppInstanceUserOutput,
    crate::error::ListChannelsModeratedByAppInstanceUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ForbiddenException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceUnavailableException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottledClientException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedClientException" => crate::error::ListChannelsModeratedByAppInstanceUserError { meta: generic, kind: crate::error::ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListChannelsModeratedByAppInstanceUserError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_channels_moderated_by_app_instance_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListChannelsModeratedByAppInstanceUserOutput,
    crate::error::ListChannelsModeratedByAppInstanceUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_channels_moderated_by_app_instance_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_channels_moderated_by_app_instance_user(response.body().as_ref(), output).map_err(crate::error::ListChannelsModeratedByAppInstanceUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_channel_membership_preferences_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutChannelMembershipPreferencesOutput,
    crate::error::PutChannelMembershipPreferencesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutChannelMembershipPreferencesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::PutChannelMembershipPreferencesErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::PutChannelMembershipPreferencesError {
                meta: generic,
                kind: crate::error::PutChannelMembershipPreferencesErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::PutChannelMembershipPreferencesErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::PutChannelMembershipPreferencesErrorKind::ServiceFailureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_failure_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceUnavailableException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind:
                crate::error::PutChannelMembershipPreferencesErrorKind::ServiceUnavailableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_unavailable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ThrottledClientException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind: crate::error::PutChannelMembershipPreferencesErrorKind::ThrottledClientException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::throttled_client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedClientException" => crate::error::PutChannelMembershipPreferencesError {
            meta: generic,
            kind:
                crate::error::PutChannelMembershipPreferencesErrorKind::UnauthorizedClientException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::unauthorized_client_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::PutChannelMembershipPreferencesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_channel_membership_preferences_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutChannelMembershipPreferencesOutput,
    crate::error::PutChannelMembershipPreferencesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_channel_membership_preferences_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_channel_membership_preferences(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutChannelMembershipPreferencesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_redact_channel_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RedactChannelMessageOutput,
    crate::error::RedactChannelMessageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RedactChannelMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RedactChannelMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::RedactChannelMessageError {
            meta: generic,
            kind: crate::error::RedactChannelMessageErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RedactChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RedactChannelMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_redact_channel_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RedactChannelMessageOutput,
    crate::error::RedactChannelMessageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::redact_channel_message_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_redact_channel_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RedactChannelMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_channel_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendChannelMessageOutput,
    crate::error::SendChannelMessageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendChannelMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendChannelMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::SendChannelMessageError {
                meta: generic,
                kind: crate::error::SendChannelMessageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::SendChannelMessageError {
            meta: generic,
            kind: crate::error::SendChannelMessageErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendChannelMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_channel_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendChannelMessageOutput,
    crate::error::SendChannelMessageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_channel_message_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_channel_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendChannelMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ForbiddenException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateChannelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateChannelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateChannelError {
                meta: generic,
                kind: crate::error::UpdateChannelErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::UpdateChannelError {
            meta: generic,
            kind: crate::error::UpdateChannelErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateChannelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_channel_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_channel(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateChannelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_flow_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateChannelFlowOutput, crate::error::UpdateChannelFlowError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateChannelFlowError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateChannelFlowError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateChannelFlowError {
                meta: generic,
                kind: crate::error::UpdateChannelFlowErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::UpdateChannelFlowError {
            meta: generic,
            kind: crate::error::UpdateChannelFlowErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelFlowError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateChannelFlowError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_flow_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateChannelFlowOutput, crate::error::UpdateChannelFlowError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_channel_flow_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_channel_flow(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateChannelFlowError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChannelMessageOutput,
    crate::error::UpdateChannelMessageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateChannelMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateChannelMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateChannelMessageError {
                meta: generic,
                kind: crate::error::UpdateChannelMessageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::UpdateChannelMessageError {
            meta: generic,
            kind: crate::error::UpdateChannelMessageErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateChannelMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChannelMessageOutput,
    crate::error::UpdateChannelMessageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_channel_message_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_channel_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateChannelMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_read_marker_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChannelReadMarkerOutput,
    crate::error::UpdateChannelReadMarkerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateChannelReadMarkerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateChannelReadMarkerError {
                meta: generic,
                kind: crate::error::UpdateChannelReadMarkerErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ForbiddenException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::ForbiddenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::forbidden_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_forbidden_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottledClientException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::ThrottledClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttled_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttled_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedClientException" => crate::error::UpdateChannelReadMarkerError {
            meta: generic,
            kind: crate::error::UpdateChannelReadMarkerErrorKind::UnauthorizedClientException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateChannelReadMarkerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_channel_read_marker_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateChannelReadMarkerOutput,
    crate::error::UpdateChannelReadMarkerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_channel_read_marker_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_channel_read_marker(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateChannelReadMarkerError::unhandled)?;
        output.build()
    })
}
