// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_channel_flow`](crate::client::Client::associate_channel_flow).
///
/// See [`crate::client::fluent_builders::AssociateChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateChannelFlow {
    _private: (),
}
impl AssociateChannelFlow {
    /// Creates a new builder-style object to manufacture [`AssociateChannelFlowInput`](crate::input::AssociateChannelFlowInput)
    pub fn builder() -> crate::input::associate_channel_flow_input::Builder {
        crate::input::associate_channel_flow_input::Builder::default()
    }
    /// Creates a new `AssociateChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateChannelFlow {
    type Output = std::result::Result<
        crate::output::AssociateChannelFlowOutput,
        crate::error::AssociateChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_associate_channel_flow_response(response)
        }
    }
}

/// Operation shape for `BatchCreateChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_channel_membership`](crate::client::Client::batch_create_channel_membership).
///
/// See [`crate::client::fluent_builders::BatchCreateChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateChannelMembership {
    _private: (),
}
impl BatchCreateChannelMembership {
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    pub fn builder() -> crate::input::batch_create_channel_membership_input::Builder {
        crate::input::batch_create_channel_membership_input::Builder::default()
    }
    /// Creates a new `BatchCreateChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateChannelMembership {
    type Output = std::result::Result<
        crate::output::BatchCreateChannelMembershipOutput,
        crate::error::BatchCreateChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_batch_create_channel_membership_response(response)
        }
    }
}

/// Operation shape for `ChannelFlowCallback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`channel_flow_callback`](crate::client::Client::channel_flow_callback).
///
/// See [`crate::client::fluent_builders::ChannelFlowCallback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ChannelFlowCallback {
    _private: (),
}
impl ChannelFlowCallback {
    /// Creates a new builder-style object to manufacture [`ChannelFlowCallbackInput`](crate::input::ChannelFlowCallbackInput)
    pub fn builder() -> crate::input::channel_flow_callback_input::Builder {
        crate::input::channel_flow_callback_input::Builder::default()
    }
    /// Creates a new `ChannelFlowCallback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ChannelFlowCallback {
    type Output = std::result::Result<
        crate::output::ChannelFlowCallbackOutput,
        crate::error::ChannelFlowCallbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_channel_flow_callback_error(response)
        } else {
            crate::operation_deser::parse_channel_flow_callback_response(response)
        }
    }
}

/// Operation shape for `CreateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel`](crate::client::Client::create_channel).
///
/// See [`crate::client::fluent_builders::CreateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannel {
    _private: (),
}
impl CreateChannel {
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
    /// Creates a new `CreateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannel {
    type Output =
        std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_error(response)
        } else {
            crate::operation_deser::parse_create_channel_response(response)
        }
    }
}

/// Operation shape for `CreateChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_ban`](crate::client::Client::create_channel_ban).
///
/// See [`crate::client::fluent_builders::CreateChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelBan {
    _private: (),
}
impl CreateChannelBan {
    /// Creates a new builder-style object to manufacture [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    pub fn builder() -> crate::input::create_channel_ban_input::Builder {
        crate::input::create_channel_ban_input::Builder::default()
    }
    /// Creates a new `CreateChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelBan {
    type Output = std::result::Result<
        crate::output::CreateChannelBanOutput,
        crate::error::CreateChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_create_channel_ban_response(response)
        }
    }
}

/// Operation shape for `CreateChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_flow`](crate::client::Client::create_channel_flow).
///
/// See [`crate::client::fluent_builders::CreateChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelFlow {
    _private: (),
}
impl CreateChannelFlow {
    /// Creates a new builder-style object to manufacture [`CreateChannelFlowInput`](crate::input::CreateChannelFlowInput)
    pub fn builder() -> crate::input::create_channel_flow_input::Builder {
        crate::input::create_channel_flow_input::Builder::default()
    }
    /// Creates a new `CreateChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelFlow {
    type Output = std::result::Result<
        crate::output::CreateChannelFlowOutput,
        crate::error::CreateChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_create_channel_flow_response(response)
        }
    }
}

/// Operation shape for `CreateChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_membership`](crate::client::Client::create_channel_membership).
///
/// See [`crate::client::fluent_builders::CreateChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelMembership {
    _private: (),
}
impl CreateChannelMembership {
    /// Creates a new builder-style object to manufacture [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    pub fn builder() -> crate::input::create_channel_membership_input::Builder {
        crate::input::create_channel_membership_input::Builder::default()
    }
    /// Creates a new `CreateChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelMembership {
    type Output = std::result::Result<
        crate::output::CreateChannelMembershipOutput,
        crate::error::CreateChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_create_channel_membership_response(response)
        }
    }
}

/// Operation shape for `CreateChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_moderator`](crate::client::Client::create_channel_moderator).
///
/// See [`crate::client::fluent_builders::CreateChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelModerator {
    _private: (),
}
impl CreateChannelModerator {
    /// Creates a new builder-style object to manufacture [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    pub fn builder() -> crate::input::create_channel_moderator_input::Builder {
        crate::input::create_channel_moderator_input::Builder::default()
    }
    /// Creates a new `CreateChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelModerator {
    type Output = std::result::Result<
        crate::output::CreateChannelModeratorOutput,
        crate::error::CreateChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_create_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `DeleteChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel`](crate::client::Client::delete_channel).
///
/// See [`crate::client::fluent_builders::DeleteChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannel {
    _private: (),
}
impl DeleteChannel {
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
    /// Creates a new `DeleteChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannel {
    type Output =
        std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_ban`](crate::client::Client::delete_channel_ban).
///
/// See [`crate::client::fluent_builders::DeleteChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelBan {
    _private: (),
}
impl DeleteChannelBan {
    /// Creates a new builder-style object to manufacture [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    pub fn builder() -> crate::input::delete_channel_ban_input::Builder {
        crate::input::delete_channel_ban_input::Builder::default()
    }
    /// Creates a new `DeleteChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelBan {
    type Output = std::result::Result<
        crate::output::DeleteChannelBanOutput,
        crate::error::DeleteChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_ban_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_flow`](crate::client::Client::delete_channel_flow).
///
/// See [`crate::client::fluent_builders::DeleteChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelFlow {
    _private: (),
}
impl DeleteChannelFlow {
    /// Creates a new builder-style object to manufacture [`DeleteChannelFlowInput`](crate::input::DeleteChannelFlowInput)
    pub fn builder() -> crate::input::delete_channel_flow_input::Builder {
        crate::input::delete_channel_flow_input::Builder::default()
    }
    /// Creates a new `DeleteChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelFlow {
    type Output = std::result::Result<
        crate::output::DeleteChannelFlowOutput,
        crate::error::DeleteChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_flow_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_membership`](crate::client::Client::delete_channel_membership).
///
/// See [`crate::client::fluent_builders::DeleteChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelMembership {
    _private: (),
}
impl DeleteChannelMembership {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    pub fn builder() -> crate::input::delete_channel_membership_input::Builder {
        crate::input::delete_channel_membership_input::Builder::default()
    }
    /// Creates a new `DeleteChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelMembership {
    type Output = std::result::Result<
        crate::output::DeleteChannelMembershipOutput,
        crate::error::DeleteChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_membership_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_message`](crate::client::Client::delete_channel_message).
///
/// See [`crate::client::fluent_builders::DeleteChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelMessage {
    _private: (),
}
impl DeleteChannelMessage {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    pub fn builder() -> crate::input::delete_channel_message_input::Builder {
        crate::input::delete_channel_message_input::Builder::default()
    }
    /// Creates a new `DeleteChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelMessage {
    type Output = std::result::Result<
        crate::output::DeleteChannelMessageOutput,
        crate::error::DeleteChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_message_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_message_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_moderator`](crate::client::Client::delete_channel_moderator).
///
/// See [`crate::client::fluent_builders::DeleteChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelModerator {
    _private: (),
}
impl DeleteChannelModerator {
    /// Creates a new builder-style object to manufacture [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    pub fn builder() -> crate::input::delete_channel_moderator_input::Builder {
        crate::input::delete_channel_moderator_input::Builder::default()
    }
    /// Creates a new `DeleteChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelModerator {
    type Output = std::result::Result<
        crate::output::DeleteChannelModeratorOutput,
        crate::error::DeleteChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `DescribeChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel`](crate::client::Client::describe_channel).
///
/// See [`crate::client::fluent_builders::DescribeChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannel {
    _private: (),
}
impl DescribeChannel {
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
    /// Creates a new `DescribeChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannel {
    type Output = std::result::Result<
        crate::output::DescribeChannelOutput,
        crate::error::DescribeChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_ban`](crate::client::Client::describe_channel_ban).
///
/// See [`crate::client::fluent_builders::DescribeChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelBan {
    _private: (),
}
impl DescribeChannelBan {
    /// Creates a new builder-style object to manufacture [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    pub fn builder() -> crate::input::describe_channel_ban_input::Builder {
        crate::input::describe_channel_ban_input::Builder::default()
    }
    /// Creates a new `DescribeChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelBan {
    type Output = std::result::Result<
        crate::output::DescribeChannelBanOutput,
        crate::error::DescribeChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_ban_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_flow`](crate::client::Client::describe_channel_flow).
///
/// See [`crate::client::fluent_builders::DescribeChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelFlow {
    _private: (),
}
impl DescribeChannelFlow {
    /// Creates a new builder-style object to manufacture [`DescribeChannelFlowInput`](crate::input::DescribeChannelFlowInput)
    pub fn builder() -> crate::input::describe_channel_flow_input::Builder {
        crate::input::describe_channel_flow_input::Builder::default()
    }
    /// Creates a new `DescribeChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelFlow {
    type Output = std::result::Result<
        crate::output::DescribeChannelFlowOutput,
        crate::error::DescribeChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_flow_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_membership`](crate::client::Client::describe_channel_membership).
///
/// See [`crate::client::fluent_builders::DescribeChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelMembership {
    _private: (),
}
impl DescribeChannelMembership {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    pub fn builder() -> crate::input::describe_channel_membership_input::Builder {
        crate::input::describe_channel_membership_input::Builder::default()
    }
    /// Creates a new `DescribeChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelMembership {
    type Output = std::result::Result<
        crate::output::DescribeChannelMembershipOutput,
        crate::error::DescribeChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_membership_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelMembershipForAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_membership_for_app_instance_user`](crate::client::Client::describe_channel_membership_for_app_instance_user).
///
/// See [`crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelMembershipForAppInstanceUser {
    _private: (),
}
impl DescribeChannelMembershipForAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    pub fn builder(
    ) -> crate::input::describe_channel_membership_for_app_instance_user_input::Builder {
        crate::input::describe_channel_membership_for_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DescribeChannelMembershipForAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeChannelMembershipForAppInstanceUser
{
    type Output = std::result::Result<
        crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
        crate::error::DescribeChannelMembershipForAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_membership_for_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_channel_membership_for_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeChannelModeratedByAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_moderated_by_app_instance_user`](crate::client::Client::describe_channel_moderated_by_app_instance_user).
///
/// See [`crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelModeratedByAppInstanceUser {
    _private: (),
}
impl DescribeChannelModeratedByAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_channel_moderated_by_app_instance_user_input::Builder
    {
        crate::input::describe_channel_moderated_by_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DescribeChannelModeratedByAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelModeratedByAppInstanceUser {
    type Output = std::result::Result<
        crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
        crate::error::DescribeChannelModeratedByAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_moderated_by_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_channel_moderated_by_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_moderator`](crate::client::Client::describe_channel_moderator).
///
/// See [`crate::client::fluent_builders::DescribeChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelModerator {
    _private: (),
}
impl DescribeChannelModerator {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    pub fn builder() -> crate::input::describe_channel_moderator_input::Builder {
        crate::input::describe_channel_moderator_input::Builder::default()
    }
    /// Creates a new `DescribeChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelModerator {
    type Output = std::result::Result<
        crate::output::DescribeChannelModeratorOutput,
        crate::error::DescribeChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `DisassociateChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_channel_flow`](crate::client::Client::disassociate_channel_flow).
///
/// See [`crate::client::fluent_builders::DisassociateChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateChannelFlow {
    _private: (),
}
impl DisassociateChannelFlow {
    /// Creates a new builder-style object to manufacture [`DisassociateChannelFlowInput`](crate::input::DisassociateChannelFlowInput)
    pub fn builder() -> crate::input::disassociate_channel_flow_input::Builder {
        crate::input::disassociate_channel_flow_input::Builder::default()
    }
    /// Creates a new `DisassociateChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateChannelFlow {
    type Output = std::result::Result<
        crate::output::DisassociateChannelFlowOutput,
        crate::error::DisassociateChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_disassociate_channel_flow_response(response)
        }
    }
}

/// Operation shape for `GetChannelMembershipPreferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_channel_membership_preferences`](crate::client::Client::get_channel_membership_preferences).
///
/// See [`crate::client::fluent_builders::GetChannelMembershipPreferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChannelMembershipPreferences {
    _private: (),
}
impl GetChannelMembershipPreferences {
    /// Creates a new builder-style object to manufacture [`GetChannelMembershipPreferencesInput`](crate::input::GetChannelMembershipPreferencesInput)
    pub fn builder() -> crate::input::get_channel_membership_preferences_input::Builder {
        crate::input::get_channel_membership_preferences_input::Builder::default()
    }
    /// Creates a new `GetChannelMembershipPreferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChannelMembershipPreferences {
    type Output = std::result::Result<
        crate::output::GetChannelMembershipPreferencesOutput,
        crate::error::GetChannelMembershipPreferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_channel_membership_preferences_error(response)
        } else {
            crate::operation_deser::parse_get_channel_membership_preferences_response(response)
        }
    }
}

/// Operation shape for `GetChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_channel_message`](crate::client::Client::get_channel_message).
///
/// See [`crate::client::fluent_builders::GetChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChannelMessage {
    _private: (),
}
impl GetChannelMessage {
    /// Creates a new builder-style object to manufacture [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    pub fn builder() -> crate::input::get_channel_message_input::Builder {
        crate::input::get_channel_message_input::Builder::default()
    }
    /// Creates a new `GetChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChannelMessage {
    type Output = std::result::Result<
        crate::output::GetChannelMessageOutput,
        crate::error::GetChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_channel_message_error(response)
        } else {
            crate::operation_deser::parse_get_channel_message_response(response)
        }
    }
}

/// Operation shape for `GetChannelMessageStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_channel_message_status`](crate::client::Client::get_channel_message_status).
///
/// See [`crate::client::fluent_builders::GetChannelMessageStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChannelMessageStatus {
    _private: (),
}
impl GetChannelMessageStatus {
    /// Creates a new builder-style object to manufacture [`GetChannelMessageStatusInput`](crate::input::GetChannelMessageStatusInput)
    pub fn builder() -> crate::input::get_channel_message_status_input::Builder {
        crate::input::get_channel_message_status_input::Builder::default()
    }
    /// Creates a new `GetChannelMessageStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChannelMessageStatus {
    type Output = std::result::Result<
        crate::output::GetChannelMessageStatusOutput,
        crate::error::GetChannelMessageStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_channel_message_status_error(response)
        } else {
            crate::operation_deser::parse_get_channel_message_status_response(response)
        }
    }
}

/// Operation shape for `GetMessagingSessionEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_messaging_session_endpoint`](crate::client::Client::get_messaging_session_endpoint).
///
/// See [`crate::client::fluent_builders::GetMessagingSessionEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMessagingSessionEndpoint {
    _private: (),
}
impl GetMessagingSessionEndpoint {
    /// Creates a new builder-style object to manufacture [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    pub fn builder() -> crate::input::get_messaging_session_endpoint_input::Builder {
        crate::input::get_messaging_session_endpoint_input::Builder::default()
    }
    /// Creates a new `GetMessagingSessionEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMessagingSessionEndpoint {
    type Output = std::result::Result<
        crate::output::GetMessagingSessionEndpointOutput,
        crate::error::GetMessagingSessionEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_messaging_session_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_messaging_session_endpoint_response(response)
        }
    }
}

/// Operation shape for `ListChannelBans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_bans`](crate::client::Client::list_channel_bans).
///
/// See [`crate::client::fluent_builders::ListChannelBans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelBans {
    _private: (),
}
impl ListChannelBans {
    /// Creates a new builder-style object to manufacture [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    pub fn builder() -> crate::input::list_channel_bans_input::Builder {
        crate::input::list_channel_bans_input::Builder::default()
    }
    /// Creates a new `ListChannelBans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelBans {
    type Output = std::result::Result<
        crate::output::ListChannelBansOutput,
        crate::error::ListChannelBansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_bans_error(response)
        } else {
            crate::operation_deser::parse_list_channel_bans_response(response)
        }
    }
}

/// Operation shape for `ListChannelFlows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_flows`](crate::client::Client::list_channel_flows).
///
/// See [`crate::client::fluent_builders::ListChannelFlows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelFlows {
    _private: (),
}
impl ListChannelFlows {
    /// Creates a new builder-style object to manufacture [`ListChannelFlowsInput`](crate::input::ListChannelFlowsInput)
    pub fn builder() -> crate::input::list_channel_flows_input::Builder {
        crate::input::list_channel_flows_input::Builder::default()
    }
    /// Creates a new `ListChannelFlows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelFlows {
    type Output = std::result::Result<
        crate::output::ListChannelFlowsOutput,
        crate::error::ListChannelFlowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_flows_error(response)
        } else {
            crate::operation_deser::parse_list_channel_flows_response(response)
        }
    }
}

/// Operation shape for `ListChannelMemberships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_memberships`](crate::client::Client::list_channel_memberships).
///
/// See [`crate::client::fluent_builders::ListChannelMemberships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMemberships {
    _private: (),
}
impl ListChannelMemberships {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    pub fn builder() -> crate::input::list_channel_memberships_input::Builder {
        crate::input::list_channel_memberships_input::Builder::default()
    }
    /// Creates a new `ListChannelMemberships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMemberships {
    type Output = std::result::Result<
        crate::output::ListChannelMembershipsOutput,
        crate::error::ListChannelMembershipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_memberships_error(response)
        } else {
            crate::operation_deser::parse_list_channel_memberships_response(response)
        }
    }
}

/// Operation shape for `ListChannelMembershipsForAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_memberships_for_app_instance_user`](crate::client::Client::list_channel_memberships_for_app_instance_user).
///
/// See [`crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMembershipsForAppInstanceUser {
    _private: (),
}
impl ListChannelMembershipsForAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channel_memberships_for_app_instance_user_input::Builder
    {
        crate::input::list_channel_memberships_for_app_instance_user_input::Builder::default()
    }
    /// Creates a new `ListChannelMembershipsForAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMembershipsForAppInstanceUser {
    type Output = std::result::Result<
        crate::output::ListChannelMembershipsForAppInstanceUserOutput,
        crate::error::ListChannelMembershipsForAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_memberships_for_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_channel_memberships_for_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListChannelMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_messages`](crate::client::Client::list_channel_messages).
///
/// See [`crate::client::fluent_builders::ListChannelMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMessages {
    _private: (),
}
impl ListChannelMessages {
    /// Creates a new builder-style object to manufacture [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
    pub fn builder() -> crate::input::list_channel_messages_input::Builder {
        crate::input::list_channel_messages_input::Builder::default()
    }
    /// Creates a new `ListChannelMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMessages {
    type Output = std::result::Result<
        crate::output::ListChannelMessagesOutput,
        crate::error::ListChannelMessagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_messages_error(response)
        } else {
            crate::operation_deser::parse_list_channel_messages_response(response)
        }
    }
}

/// Operation shape for `ListChannelModerators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_moderators`](crate::client::Client::list_channel_moderators).
///
/// See [`crate::client::fluent_builders::ListChannelModerators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelModerators {
    _private: (),
}
impl ListChannelModerators {
    /// Creates a new builder-style object to manufacture [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
    pub fn builder() -> crate::input::list_channel_moderators_input::Builder {
        crate::input::list_channel_moderators_input::Builder::default()
    }
    /// Creates a new `ListChannelModerators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelModerators {
    type Output = std::result::Result<
        crate::output::ListChannelModeratorsOutput,
        crate::error::ListChannelModeratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_moderators_error(response)
        } else {
            crate::operation_deser::parse_list_channel_moderators_response(response)
        }
    }
}

/// Operation shape for `ListChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels`](crate::client::Client::list_channels).
///
/// See [`crate::client::fluent_builders::ListChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannels {
    _private: (),
}
impl ListChannels {
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
    /// Creates a new `ListChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannels {
    type Output =
        std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_error(response)
        } else {
            crate::operation_deser::parse_list_channels_response(response)
        }
    }
}

/// Operation shape for `ListChannelsAssociatedWithChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels_associated_with_channel_flow`](crate::client::Client::list_channels_associated_with_channel_flow).
///
/// See [`crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelsAssociatedWithChannelFlow {
    _private: (),
}
impl ListChannelsAssociatedWithChannelFlow {
    /// Creates a new builder-style object to manufacture [`ListChannelsAssociatedWithChannelFlowInput`](crate::input::ListChannelsAssociatedWithChannelFlowInput)
    pub fn builder() -> crate::input::list_channels_associated_with_channel_flow_input::Builder {
        crate::input::list_channels_associated_with_channel_flow_input::Builder::default()
    }
    /// Creates a new `ListChannelsAssociatedWithChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelsAssociatedWithChannelFlow {
    type Output = std::result::Result<
        crate::output::ListChannelsAssociatedWithChannelFlowOutput,
        crate::error::ListChannelsAssociatedWithChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_associated_with_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_list_channels_associated_with_channel_flow_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListChannelsModeratedByAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels_moderated_by_app_instance_user`](crate::client::Client::list_channels_moderated_by_app_instance_user).
///
/// See [`crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelsModeratedByAppInstanceUser {
    _private: (),
}
impl ListChannelsModeratedByAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channels_moderated_by_app_instance_user_input::Builder {
        crate::input::list_channels_moderated_by_app_instance_user_input::Builder::default()
    }
    /// Creates a new `ListChannelsModeratedByAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelsModeratedByAppInstanceUser {
    type Output = std::result::Result<
        crate::output::ListChannelsModeratedByAppInstanceUserOutput,
        crate::error::ListChannelsModeratedByAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_moderated_by_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_channels_moderated_by_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutChannelMembershipPreferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_channel_membership_preferences`](crate::client::Client::put_channel_membership_preferences).
///
/// See [`crate::client::fluent_builders::PutChannelMembershipPreferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutChannelMembershipPreferences {
    _private: (),
}
impl PutChannelMembershipPreferences {
    /// Creates a new builder-style object to manufacture [`PutChannelMembershipPreferencesInput`](crate::input::PutChannelMembershipPreferencesInput)
    pub fn builder() -> crate::input::put_channel_membership_preferences_input::Builder {
        crate::input::put_channel_membership_preferences_input::Builder::default()
    }
    /// Creates a new `PutChannelMembershipPreferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutChannelMembershipPreferences {
    type Output = std::result::Result<
        crate::output::PutChannelMembershipPreferencesOutput,
        crate::error::PutChannelMembershipPreferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_channel_membership_preferences_error(response)
        } else {
            crate::operation_deser::parse_put_channel_membership_preferences_response(response)
        }
    }
}

/// Operation shape for `RedactChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`redact_channel_message`](crate::client::Client::redact_channel_message).
///
/// See [`crate::client::fluent_builders::RedactChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RedactChannelMessage {
    _private: (),
}
impl RedactChannelMessage {
    /// Creates a new builder-style object to manufacture [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
    pub fn builder() -> crate::input::redact_channel_message_input::Builder {
        crate::input::redact_channel_message_input::Builder::default()
    }
    /// Creates a new `RedactChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RedactChannelMessage {
    type Output = std::result::Result<
        crate::output::RedactChannelMessageOutput,
        crate::error::RedactChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_redact_channel_message_error(response)
        } else {
            crate::operation_deser::parse_redact_channel_message_response(response)
        }
    }
}

/// Operation shape for `SendChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_channel_message`](crate::client::Client::send_channel_message).
///
/// See [`crate::client::fluent_builders::SendChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendChannelMessage {
    _private: (),
}
impl SendChannelMessage {
    /// Creates a new builder-style object to manufacture [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
    pub fn builder() -> crate::input::send_channel_message_input::Builder {
        crate::input::send_channel_message_input::Builder::default()
    }
    /// Creates a new `SendChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendChannelMessage {
    type Output = std::result::Result<
        crate::output::SendChannelMessageOutput,
        crate::error::SendChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_send_channel_message_error(response)
        } else {
            crate::operation_deser::parse_send_channel_message_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel`](crate::client::Client::update_channel).
///
/// See [`crate::client::fluent_builders::UpdateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannel {
    _private: (),
}
impl UpdateChannel {
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
    /// Creates a new `UpdateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannel {
    type Output =
        std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_error(response)
        } else {
            crate::operation_deser::parse_update_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_flow`](crate::client::Client::update_channel_flow).
///
/// See [`crate::client::fluent_builders::UpdateChannelFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelFlow {
    _private: (),
}
impl UpdateChannelFlow {
    /// Creates a new builder-style object to manufacture [`UpdateChannelFlowInput`](crate::input::UpdateChannelFlowInput)
    pub fn builder() -> crate::input::update_channel_flow_input::Builder {
        crate::input::update_channel_flow_input::Builder::default()
    }
    /// Creates a new `UpdateChannelFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelFlow {
    type Output = std::result::Result<
        crate::output::UpdateChannelFlowOutput,
        crate::error::UpdateChannelFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_flow_error(response)
        } else {
            crate::operation_deser::parse_update_channel_flow_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_message`](crate::client::Client::update_channel_message).
///
/// See [`crate::client::fluent_builders::UpdateChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelMessage {
    _private: (),
}
impl UpdateChannelMessage {
    /// Creates a new builder-style object to manufacture [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
    pub fn builder() -> crate::input::update_channel_message_input::Builder {
        crate::input::update_channel_message_input::Builder::default()
    }
    /// Creates a new `UpdateChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelMessage {
    type Output = std::result::Result<
        crate::output::UpdateChannelMessageOutput,
        crate::error::UpdateChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_message_error(response)
        } else {
            crate::operation_deser::parse_update_channel_message_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelReadMarker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_read_marker`](crate::client::Client::update_channel_read_marker).
///
/// See [`crate::client::fluent_builders::UpdateChannelReadMarker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelReadMarker {
    _private: (),
}
impl UpdateChannelReadMarker {
    /// Creates a new builder-style object to manufacture [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
    pub fn builder() -> crate::input::update_channel_read_marker_input::Builder {
        crate::input::update_channel_read_marker_input::Builder::default()
    }
    /// Creates a new `UpdateChannelReadMarker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelReadMarker {
    type Output = std::result::Result<
        crate::output::UpdateChannelReadMarkerOutput,
        crate::error::UpdateChannelReadMarkerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_read_marker_error(response)
        } else {
            crate::operation_deser::parse_update_channel_read_marker_response(response)
        }
    }
}
