// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `ChimeMessagingService`.
///
/// This client allows ergonomic access to a `ChimeMessagingService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateChannelFlow` operation.
    ///
    /// See [`AssociateChannelFlow`](crate::client::fluent_builders::AssociateChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn associate_channel_flow(&self) -> fluent_builders::AssociateChannelFlow<C, M, R> {
        fluent_builders::AssociateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchCreateChannelMembership` operation.
    ///
    /// See [`BatchCreateChannelMembership`](crate::client::fluent_builders::BatchCreateChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn batch_create_channel_membership(
        &self,
    ) -> fluent_builders::BatchCreateChannelMembership<C, M, R> {
        fluent_builders::BatchCreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChannelFlowCallback` operation.
    ///
    /// See [`ChannelFlowCallback`](crate::client::fluent_builders::ChannelFlowCallback) for more information about the
    /// operation and its arguments.
    pub fn channel_flow_callback(&self) -> fluent_builders::ChannelFlowCallback<C, M, R> {
        fluent_builders::ChannelFlowCallback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelBan` operation.
    ///
    /// See [`CreateChannelBan`](crate::client::fluent_builders::CreateChannelBan) for more information about the
    /// operation and its arguments.
    pub fn create_channel_ban(&self) -> fluent_builders::CreateChannelBan<C, M, R> {
        fluent_builders::CreateChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelFlow` operation.
    ///
    /// See [`CreateChannelFlow`](crate::client::fluent_builders::CreateChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn create_channel_flow(&self) -> fluent_builders::CreateChannelFlow<C, M, R> {
        fluent_builders::CreateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelMembership` operation.
    ///
    /// See [`CreateChannelMembership`](crate::client::fluent_builders::CreateChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn create_channel_membership(&self) -> fluent_builders::CreateChannelMembership<C, M, R> {
        fluent_builders::CreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelModerator` operation.
    ///
    /// See [`CreateChannelModerator`](crate::client::fluent_builders::CreateChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn create_channel_moderator(&self) -> fluent_builders::CreateChannelModerator<C, M, R> {
        fluent_builders::CreateChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelBan` operation.
    ///
    /// See [`DeleteChannelBan`](crate::client::fluent_builders::DeleteChannelBan) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_ban(&self) -> fluent_builders::DeleteChannelBan<C, M, R> {
        fluent_builders::DeleteChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelFlow` operation.
    ///
    /// See [`DeleteChannelFlow`](crate::client::fluent_builders::DeleteChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_flow(&self) -> fluent_builders::DeleteChannelFlow<C, M, R> {
        fluent_builders::DeleteChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelMembership` operation.
    ///
    /// See [`DeleteChannelMembership`](crate::client::fluent_builders::DeleteChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_membership(&self) -> fluent_builders::DeleteChannelMembership<C, M, R> {
        fluent_builders::DeleteChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelMessage` operation.
    ///
    /// See [`DeleteChannelMessage`](crate::client::fluent_builders::DeleteChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_message(&self) -> fluent_builders::DeleteChannelMessage<C, M, R> {
        fluent_builders::DeleteChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelModerator` operation.
    ///
    /// See [`DeleteChannelModerator`](crate::client::fluent_builders::DeleteChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_moderator(&self) -> fluent_builders::DeleteChannelModerator<C, M, R> {
        fluent_builders::DeleteChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannel` operation.
    ///
    /// See [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) for more information about the
    /// operation and its arguments.
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelBan` operation.
    ///
    /// See [`DescribeChannelBan`](crate::client::fluent_builders::DescribeChannelBan) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_ban(&self) -> fluent_builders::DescribeChannelBan<C, M, R> {
        fluent_builders::DescribeChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelFlow` operation.
    ///
    /// See [`DescribeChannelFlow`](crate::client::fluent_builders::DescribeChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_flow(&self) -> fluent_builders::DescribeChannelFlow<C, M, R> {
        fluent_builders::DescribeChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelMembership` operation.
    ///
    /// See [`DescribeChannelMembership`](crate::client::fluent_builders::DescribeChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_membership(
        &self,
    ) -> fluent_builders::DescribeChannelMembership<C, M, R> {
        fluent_builders::DescribeChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelMembershipForAppInstanceUser` operation.
    ///
    /// See [`DescribeChannelMembershipForAppInstanceUser`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_membership_for_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelMembershipForAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelMembershipForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelModeratedByAppInstanceUser` operation.
    ///
    /// See [`DescribeChannelModeratedByAppInstanceUser`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelModerator` operation.
    ///
    /// See [`DescribeChannelModerator`](crate::client::fluent_builders::DescribeChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_moderator(&self) -> fluent_builders::DescribeChannelModerator<C, M, R> {
        fluent_builders::DescribeChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateChannelFlow` operation.
    ///
    /// See [`DisassociateChannelFlow`](crate::client::fluent_builders::DisassociateChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn disassociate_channel_flow(&self) -> fluent_builders::DisassociateChannelFlow<C, M, R> {
        fluent_builders::DisassociateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannelMembershipPreferences` operation.
    ///
    /// See [`GetChannelMembershipPreferences`](crate::client::fluent_builders::GetChannelMembershipPreferences) for more information about the
    /// operation and its arguments.
    pub fn get_channel_membership_preferences(
        &self,
    ) -> fluent_builders::GetChannelMembershipPreferences<C, M, R> {
        fluent_builders::GetChannelMembershipPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannelMessage` operation.
    ///
    /// See [`GetChannelMessage`](crate::client::fluent_builders::GetChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn get_channel_message(&self) -> fluent_builders::GetChannelMessage<C, M, R> {
        fluent_builders::GetChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannelMessageStatus` operation.
    ///
    /// See [`GetChannelMessageStatus`](crate::client::fluent_builders::GetChannelMessageStatus) for more information about the
    /// operation and its arguments.
    pub fn get_channel_message_status(&self) -> fluent_builders::GetChannelMessageStatus<C, M, R> {
        fluent_builders::GetChannelMessageStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMessagingSessionEndpoint` operation.
    ///
    /// See [`GetMessagingSessionEndpoint`](crate::client::fluent_builders::GetMessagingSessionEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_messaging_session_endpoint(
        &self,
    ) -> fluent_builders::GetMessagingSessionEndpoint<C, M, R> {
        fluent_builders::GetMessagingSessionEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelBans` operation.
    ///
    /// See [`ListChannelBans`](crate::client::fluent_builders::ListChannelBans) for more information about the
    /// operation and its arguments.
    pub fn list_channel_bans(&self) -> fluent_builders::ListChannelBans<C, M, R> {
        fluent_builders::ListChannelBans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelFlows` operation.
    ///
    /// See [`ListChannelFlows`](crate::client::fluent_builders::ListChannelFlows) for more information about the
    /// operation and its arguments.
    pub fn list_channel_flows(&self) -> fluent_builders::ListChannelFlows<C, M, R> {
        fluent_builders::ListChannelFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMemberships` operation.
    ///
    /// See [`ListChannelMemberships`](crate::client::fluent_builders::ListChannelMemberships) for more information about the
    /// operation and its arguments.
    pub fn list_channel_memberships(&self) -> fluent_builders::ListChannelMemberships<C, M, R> {
        fluent_builders::ListChannelMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMembershipsForAppInstanceUser` operation.
    ///
    /// See [`ListChannelMembershipsForAppInstanceUser`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn list_channel_memberships_for_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelMembershipsForAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelMembershipsForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMessages` operation.
    ///
    /// See [`ListChannelMessages`](crate::client::fluent_builders::ListChannelMessages) for more information about the
    /// operation and its arguments.
    pub fn list_channel_messages(&self) -> fluent_builders::ListChannelMessages<C, M, R> {
        fluent_builders::ListChannelMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelModerators` operation.
    ///
    /// See [`ListChannelModerators`](crate::client::fluent_builders::ListChannelModerators) for more information about the
    /// operation and its arguments.
    pub fn list_channel_moderators(&self) -> fluent_builders::ListChannelModerators<C, M, R> {
        fluent_builders::ListChannelModerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelsAssociatedWithChannelFlow` operation.
    ///
    /// See [`ListChannelsAssociatedWithChannelFlow`](crate::client::fluent_builders::ListChannelsAssociatedWithChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn list_channels_associated_with_channel_flow(
        &self,
    ) -> fluent_builders::ListChannelsAssociatedWithChannelFlow<C, M, R> {
        fluent_builders::ListChannelsAssociatedWithChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelsModeratedByAppInstanceUser` operation.
    ///
    /// See [`ListChannelsModeratedByAppInstanceUser`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn list_channels_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelsModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelsModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutChannelMembershipPreferences` operation.
    ///
    /// See [`PutChannelMembershipPreferences`](crate::client::fluent_builders::PutChannelMembershipPreferences) for more information about the
    /// operation and its arguments.
    pub fn put_channel_membership_preferences(
        &self,
    ) -> fluent_builders::PutChannelMembershipPreferences<C, M, R> {
        fluent_builders::PutChannelMembershipPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RedactChannelMessage` operation.
    ///
    /// See [`RedactChannelMessage`](crate::client::fluent_builders::RedactChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn redact_channel_message(&self) -> fluent_builders::RedactChannelMessage<C, M, R> {
        fluent_builders::RedactChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendChannelMessage` operation.
    ///
    /// See [`SendChannelMessage`](crate::client::fluent_builders::SendChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn send_channel_message(&self) -> fluent_builders::SendChannelMessage<C, M, R> {
        fluent_builders::SendChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelFlow` operation.
    ///
    /// See [`UpdateChannelFlow`](crate::client::fluent_builders::UpdateChannelFlow) for more information about the
    /// operation and its arguments.
    pub fn update_channel_flow(&self) -> fluent_builders::UpdateChannelFlow<C, M, R> {
        fluent_builders::UpdateChannelFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelMessage` operation.
    ///
    /// See [`UpdateChannelMessage`](crate::client::fluent_builders::UpdateChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn update_channel_message(&self) -> fluent_builders::UpdateChannelMessage<C, M, R> {
        fluent_builders::UpdateChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelReadMarker` operation.
    ///
    /// See [`UpdateChannelReadMarker`](crate::client::fluent_builders::UpdateChannelReadMarker) for more information about the
    /// operation and its arguments.
    pub fn update_channel_read_marker(&self) -> fluent_builders::UpdateChannelReadMarker<C, M, R> {
        fluent_builders::UpdateChannelReadMarker::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateChannelFlow`.
    ///
    /// <p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the
    /// <code>DisassociateChannelFlow</code> API.</p>
    ///
    /// <note>
    /// <p>Only administrators or channel moderators can associate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code>
    /// of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_channel_flow_input::Builder,
    }
    impl<C, M, R> AssociateChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateChannelFlowInputOperationOutputAlias,
                crate::output::AssociateChannelFlowOutput,
                crate::error::AssociateChannelFlowError,
                crate::input::AssociateChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateChannelMembership`.
    ///
    /// <p>Adds a specified number of users to a channel. </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_channel_membership_input::Builder,
    }
    impl<C, M, R> BatchCreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateChannelMembershipInputOperationOutputAlias,
                crate::output::BatchCreateChannelMembershipOutput,
                crate::error::BatchCreateChannelMembershipError,
                crate::input::BatchCreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `MemberArns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arns(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_member_arns(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChannelFlowCallback`.
    ///
    /// <p>Calls back Chime SDK Messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p>
    /// <p>You can return one of the following processing responses:</p>                  
    /// <ul>
    /// <li>
    /// <p>Update message content or metadata</p>
    /// </li>
    /// <li>
    /// <p>Deny a message</p>
    /// </li>
    /// <li>
    /// <p>Make no changes to the message</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ChannelFlowCallback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::channel_flow_callback_input::Builder,
    }
    impl<C, M, R> ChannelFlowCallback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChannelFlowCallback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChannelFlowCallbackOutput,
            aws_smithy_http::result::SdkError<crate::error::ChannelFlowCallbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChannelFlowCallbackInputOperationOutputAlias,
                crate::output::ChannelFlowCallbackOutput,
                crate::error::ChannelFlowCallbackError,
                crate::input::ChannelFlowCallbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn callback_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.callback_id(inp);
            self
        }
        /// <p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>
        pub fn set_callback_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_callback_id(input);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn delete_resource(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_resource(inp);
            self
        }
        /// <p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>
        pub fn set_delete_resource(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_resource(input);
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn channel_message(mut self, inp: crate::model::ChannelMessageCallback) -> Self {
            self.inner = self.inner.channel_message(inp);
            self
        }
        /// <p>Stores information about the processed message.</p>
        pub fn set_channel_message(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageCallback>,
        ) -> Self {
            self.inner = self.inner.set_channel_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a channel to which you can add users and send messages.</p>
    ///
    /// <p>
    /// <b>Restriction</b>: You can't change a channel's
    /// privacy.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators,
        /// moderators, and channel members can add themselves and other members to unrestricted
        /// channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, inp: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators,
        /// moderators, and channel members can add themselves and other members to unrestricted
        /// channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private
        /// channels aren't discoverable by users outside the channel. Public channels are discoverable
        /// by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, inp: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(inp);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private
        /// channels aren't discoverable by users outside the channel. Public channels are discoverable
        /// by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelBan`.
    ///
    /// <p>Permanently bans a member from a channel. Moderators can't add banned members to a
    /// channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then
    /// <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or
    /// channels.</p>
    /// <p>If you ban a user who is already part of a channel, that user is automatically kicked
    /// from the channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_ban_input::Builder,
    }
    impl<C, M, R> CreateChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelBanInputOperationOutputAlias,
                crate::output::CreateChannelBanOutput,
                crate::error::CreateChannelBanError,
                crate::input::CreateChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelFlow`.
    ///
    /// <p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions
    /// that perform actions on chat messages, such as stripping out profanity. You can associate
    /// channel flows with channels, and the processors in the channel flow then take action on all
    /// messages sent to that channel. This is a developer API.</p>
    ///
    /// <p>Channel flows process the following items:</p>
    /// <ol>
    /// <li>
    /// <p>New and updated messages</p>
    /// </li>
    /// <li>
    /// <p>Persistent and non-persistent messages</p>
    /// </li>
    /// <li>
    /// <p>The Standard message type</p>
    /// </li>
    /// </ol>
    ///
    /// <note>
    /// <p>Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK Messaging, refer to
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_flow_input::Builder,
    }
    impl<C, M, R> CreateChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelFlowInputOperationOutputAlias,
                crate::output::CreateChannelFlowOutput,
                crate::error::CreateChannelFlowError,
                crate::input::CreateChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow request.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// Appends an item to `Processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions.</p>
        pub fn processors(mut self, inp: impl Into<crate::model::Processor>) -> Self {
            self.inner = self.inner.processors(inp);
            self
        }
        /// <p>Information about the processor Lambda functions.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.inner = self.inner.set_processors(input);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The client token for the request. An Idempotency token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelMembership`.
    ///
    /// <p>Adds a user to a channel. The <code>InvitedBy</code> field in <code>ChannelMembership</code> is derived from the
    /// request header. A channel member can:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>List messages</p>
    /// </li>
    /// <li>
    /// <p>Send messages</p>
    /// </li>
    /// <li>
    /// <p>Receive messages</p>
    /// </li>
    /// <li>
    /// <p>Edit their own messages</p>
    /// </li>
    /// <li>
    /// <p>Leave the channel</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Privacy settings impact this action as follows:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Public Channels: You do not need to be a member to list messages, but you must be
    /// a member to send messages.</p>
    /// </li>
    /// <li>
    /// <p>Private Channels: You must be a member to list or send messages.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_membership_input::Builder,
    }
    impl<C, M, R> CreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelMembershipInputOperationOutputAlias,
                crate::output::CreateChannelMembershipOutput,
                crate::error::CreateChannelMembershipError,
                crate::input::CreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelModerator`.
    ///
    /// <p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Add and remove other members of the channel.</p>
    /// </li>
    /// <li>
    /// <p>Add and remove other moderators of the channel.</p>
    /// </li>
    /// <li>
    /// <p>Add and remove user bans for the channel.</p>
    /// </li>
    /// <li>
    /// <p>Redact messages in the channel.</p>
    /// </li>
    /// <li>
    /// <p>List messages in the channel.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_moderator_input::Builder,
    }
    impl<C, M, R> CreateChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelModeratorInputOperationOutputAlias,
                crate::output::CreateChannelModeratorOutput,
                crate::error::CreateChannelModeratorError,
                crate::input::CreateChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Immediately makes a channel and its memberships inaccessible and marks them for
    /// deletion. This is an irreversible process.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelBan`.
    ///
    /// <p>Removes a user from a channel's ban list.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_ban_input::Builder,
    }
    impl<C, M, R> DeleteChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelBanInputOperationOutputAlias,
                crate::output::DeleteChannelBanOutput,
                crate::error::DeleteChannelBanError,
                crate::input::DeleteChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelFlow`.
    ///
    /// <p>Deletes a channel flow, an irreversible process. This is a developer API.</p>
    /// <note>
    /// <p> This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the
    /// <code>ListChannelsAssociatedWithChannelFlow</code> API. Use the <code>DisassociateChannelFlow</code> API to disassociate a channel flow from all channels. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_flow_input::Builder,
    }
    impl<C, M, R> DeleteChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelFlowInputOperationOutputAlias,
                crate::output::DeleteChannelFlowOutput,
                crate::error::DeleteChannelFlowError,
                crate::input::DeleteChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMembership`.
    ///
    /// <p>Removes a member from a channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_membership_input::Builder,
    }
    impl<C, M, R> DeleteChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMembershipInputOperationOutputAlias,
                crate::output::DeleteChannelMembershipOutput,
                crate::error::DeleteChannelMembershipError,
                crate::input::DeleteChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMessage`.
    ///
    /// <p>Deletes a channel message. Only admins can perform this action. Deletion makes messages
    /// inaccessible immediately. A background process deletes any revisions created by
    /// <code>UpdateChannelMessage</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_message_input::Builder,
    }
    impl<C, M, R> DeleteChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMessageInputOperationOutputAlias,
                crate::output::DeleteChannelMessageOutput,
                crate::error::DeleteChannelMessageError,
                crate::input::DeleteChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelModerator`.
    ///
    /// <p>Deletes a channel moderator.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_moderator_input::Builder,
    }
    impl<C, M, R> DeleteChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelModeratorInputOperationOutputAlias,
                crate::output::DeleteChannelModeratorOutput,
                crate::error::DeleteChannelModeratorError,
                crate::input::DeleteChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Returns the full details of a channel in an Amazon Chime
    /// <code>AppInstance</code>.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelBan`.
    ///
    /// <p>Returns the full details of a channel ban.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_ban_input::Builder,
    }
    impl<C, M, R> DescribeChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelBanInputOperationOutputAlias,
                crate::output::DescribeChannelBanOutput,
                crate::error::DescribeChannelBanError,
                crate::input::DescribeChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelFlow`.
    ///
    /// <p>Returns the full details of a channel flow in an Amazon Chime <code>AppInstance</code>. This is a developer API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_flow_input::Builder,
    }
    impl<C, M, R> DescribeChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelFlowInputOperationOutputAlias,
                crate::output::DescribeChannelFlowOutput,
                crate::error::DescribeChannelFlowError,
                crate::input::DescribeChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembership`.
    ///
    /// <p>Returns the full details of a user's channel membership.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipOutput,
                crate::error::DescribeChannelMembershipError,
                crate::input::DescribeChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembershipForAppInstanceUser`.
    ///
    /// <p> Returns the details of a channel based on the membership of the specified
    /// <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelMembershipForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembershipForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembershipForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModeratedByAppInstanceUser`.
    ///
    /// <p>Returns the full details of a channel moderated by the specified
    /// <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModerator`.
    ///
    /// <p>Returns the full details of a single ChannelModerator.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderator_input::Builder,
    }
    impl<C, M, R> DescribeChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratorInputOperationOutputAlias,
                crate::output::DescribeChannelModeratorOutput,
                crate::error::DescribeChannelModeratorError,
                crate::input::DescribeChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateChannelFlow`.
    ///
    /// <p>Disassociates a channel flow from all its channels. Once disassociated, all messages to
    /// that channel stop going through the channel flow processor.</p>
    /// <note>
    /// <p>Only administrators or channel moderators can disassociate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code>
    /// of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_channel_flow_input::Builder,
    }
    impl<C, M, R> DisassociateChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateChannelFlowInputOperationOutputAlias,
                crate::output::DisassociateChannelFlowOutput,
                crate::error::DisassociateChannelFlowError,
                crate::input::DisassociateChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMembershipPreferences`.
    ///
    /// <p>Gets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel.
    /// Only the <code>AppInstanceUser</code> who owns the membership can retrieve preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't retrieve preferences for other users.
    /// Banned users can't retrieve membership preferences for the channel from which they are banned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetChannelMembershipPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_membership_preferences_input::Builder,
    }
    impl<C, M, R> GetChannelMembershipPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannelMembershipPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMembershipPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMembershipPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelMembershipPreferencesInputOperationOutputAlias,
                crate::output::GetChannelMembershipPreferencesOutput,
                crate::error::GetChannelMembershipPreferencesError,
                crate::input::GetChannelMembershipPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessage`.
    ///
    /// <p>Gets the full details of a channel message.</p>
    ///
    /// <note>
    /// <p>The x-amz-chime-bearer request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_message_input::Builder,
    }
    impl<C, M, R> GetChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelMessageInputOperationOutputAlias,
                crate::output::GetChannelMessageOutput,
                crate::error::GetChannelMessageError,
                crate::input::GetChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessageStatus`.
    ///
    /// <p>Gets message status for a specified <code>messageId</code>. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to
    /// retrieving message status if the event was not received because a client wasn't connected to a websocket. </p>
    ///
    /// <p>Messages can have any one of these statuses.</p>
    ///
    /// <dl>
    /// <dt>SENT</dt>
    /// <dd>
    /// <p>Message processed successfully</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>Ongoing processing</p>
    /// </dd>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>Processing failed</p>
    /// </dd>
    /// <dt>DENIED</dt>
    /// <dd>
    /// <p>Messasge denied by the processor</p>
    /// </dd>
    /// </dl>
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>This API does not return statuses for denied messages, because we don't store them once the processor denies them. </p>
    /// </li>
    /// <li>
    /// <p>Only the message sender can invoke this API.</p>
    /// </li>
    /// <li>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetChannelMessageStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_message_status_input::Builder,
    }
    impl<C, M, R> GetChannelMessageStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannelMessageStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelMessageStatusInputOperationOutputAlias,
                crate::output::GetChannelMessageStatusOutput,
                crate::error::GetChannelMessageStatusError,
                crate::input::GetChannelMessageStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMessagingSessionEndpoint`.
    ///
    /// <p>The details of the endpoint for the messaging session.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMessagingSessionEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_messaging_session_endpoint_input::Builder,
    }
    impl<C, M, R> GetMessagingSessionEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMessagingSessionEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMessagingSessionEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMessagingSessionEndpointInputOperationOutputAlias,
                crate::output::GetMessagingSessionEndpointOutput,
                crate::error::GetMessagingSessionEndpointError,
                crate::input::GetMessagingSessionEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListChannelBans`.
    ///
    /// <p>Lists all the users banned from a particular channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelBans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_bans_input::Builder,
    }
    impl<C, M, R> ListChannelBans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelBans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelBansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelBansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelBansInputOperationOutputAlias,
                crate::output::ListChannelBansOutput,
                crate::error::ListChannelBansError,
                crate::input::ListChannelBansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelFlows`.
    ///
    /// <p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelFlows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_flows_input::Builder,
    }
    impl<C, M, R> ListChannelFlows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelFlowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelFlowsInputOperationOutputAlias,
                crate::output::ListChannelFlowsOutput,
                crate::error::ListChannelFlowsError,
                crate::input::ListChannelFlowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the app instance.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the app instance.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channel flows that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel flows are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMemberships`.
    ///
    /// <p>Lists all channel memberships in a channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    ///
    /// <p>If you want to list the channels to which a specific app instance user belongs, see the
    /// <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html">ListChannelMembershipsForAppInstanceUser</a> API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_input::Builder,
    }
    impl<C, M, R> ListChannelMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsInputOperationOutputAlias,
                crate::output::ListChannelMembershipsOutput,
                crate::error::ListChannelMembershipsError,
                crate::input::ListChannelMembershipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMembershipsForAppInstanceUser`.
    ///
    /// <p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an
    /// <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMembershipsForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelMembershipsForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMembershipsForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelMembershipsForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelMembershipsForAppInstanceUserOutput,
                crate::error::ListChannelMembershipsForAppInstanceUserError,
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is
        /// reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is
        /// reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMessages`.
    ///
    /// <p>List all the messages in a channel. Returns a paginated list of
    /// <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending
    /// order.</p>
    /// <note>
    /// <p>Redacted messages appear in the results as empty, since they are only redacted, not
    /// deleted. Deleted messages do not appear in the results. This action always returns the
    /// latest version of an edited message.</p>
    /// <p>Also, the x-amz-chime-bearer request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_messages_input::Builder,
    }
    impl<C, M, R> ListChannelMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMessagesInputOperationOutputAlias,
                crate::output::ListChannelMessagesOutput,
                crate::error::ListChannelMessagesError,
                crate::input::ListChannelMessagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time
        /// created.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time
        /// created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.not_before(inp);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_not_before(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.not_after(inp);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_not_after(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelModerators`.
    ///
    /// <p>Lists all the moderators for a channel.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelModerators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_moderators_input::Builder,
    }
    impl<C, M, R> ListChannelModerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelModerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelModeratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelModeratorsInputOperationOutputAlias,
                crate::output::ListChannelModeratorsOutput,
                crate::error::ListChannelModeratorsError,
                crate::input::ListChannelModeratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Lists all Channels created under a single Chime App as a paginated list. You can specify
    /// filters to narrow results.</p>
    ///
    /// <p class="title">
    /// <b>Functionality & restrictions</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to
    /// list the private channels in an account.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels.
        /// <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code>
        /// can retrieve private channels. </p>
        pub fn privacy(mut self, inp: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(inp);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels.
        /// <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code>
        /// can retrieve private channels. </p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsAssociatedWithChannelFlow`.
    ///
    /// <p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelsAssociatedWithChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_associated_with_channel_flow_input::Builder,
    }
    impl<C, M, R> ListChannelsAssociatedWithChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelsAssociatedWithChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsAssociatedWithChannelFlowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsAssociatedWithChannelFlowError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsAssociatedWithChannelFlowInputOperationOutputAlias,
                crate::output::ListChannelsAssociatedWithChannelFlowOutput,
                crate::error::ListChannelsAssociatedWithChannelFlowError,
                crate::input::ListChannelsAssociatedWithChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsModeratedByAppInstanceUser`.
    ///
    /// <p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelsModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelsModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelsModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelsModeratedByAppInstanceUserOutput,
                crate::error::ListChannelsModeratedByAppInstanceUserError,
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK messaging resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutChannelMembershipPreferences`.
    ///
    /// <p>Sets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel.
    /// Only the <code>AppInstanceUser</code> who owns the membership can set preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't set preferences for other users.
    /// Banned users can't set membership preferences for the channel from which they are banned.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutChannelMembershipPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_channel_membership_preferences_input::Builder,
    }
    impl<C, M, R> PutChannelMembershipPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutChannelMembershipPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutChannelMembershipPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutChannelMembershipPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutChannelMembershipPreferencesInputOperationOutputAlias,
                crate::output::PutChannelMembershipPreferencesOutput,
                crate::error::PutChannelMembershipPreferencesError,
                crate::input::PutChannelMembershipPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code>  of the user making the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserARN</code>  of the user making the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn preferences(mut self, inp: crate::model::ChannelMembershipPreferences) -> Self {
            self.inner = self.inner.preferences(inp);
            self
        }
        /// <p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>
        pub fn set_preferences(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipPreferences>,
        ) -> Self {
            self.inner = self.inner.set_preferences(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactChannelMessage`.
    ///
    /// <p>Redacts message content, but not metadata. The message exists in the back end, but the
    /// action returns null content, and the state shows as redacted.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RedactChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_channel_message_input::Builder,
    }
    impl<C, M, R> RedactChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactChannelMessageInputOperationOutputAlias,
                crate::output::RedactChannelMessageOutput,
                crate::error::RedactChannelMessageError,
                crate::input::RedactChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendChannelMessage`.
    ///
    /// <p>Sends a message to a particular channel that the member is a part of.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    ///
    /// <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata.
    /// <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SendChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_channel_message_input::Builder,
    }
    impl<C, M, R> SendChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendChannelMessageInputOperationOutputAlias,
                crate::output::SendChannelMessageOutput,
                crate::error::SendChannelMessageError,
                crate::input::SendChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMessageType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn persistence(mut self, inp: crate::model::ChannelMessagePersistenceType) -> Self {
            self.inner = self.inner.persistence(inp);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.inner = self.inner.set_persistence(input);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn push_notification(
            mut self,
            inp: crate::model::PushNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.push_notification(inp);
            self
        }
        /// <p>The push notification configuration of the message.</p>
        pub fn set_push_notification(
            mut self,
            input: std::option::Option<crate::model::PushNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_push_notification(input);
            self
        }
        /// Adds a key-value pair to `MessageAttributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MessageAttributeValue>,
        ) -> Self {
            self.inner = self.inner.message_attributes(k, v);
            self
        }
        /// <p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_message_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK messaging resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Chime SDK messaging resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Update a channel's attributes.</p>
    /// <p>
    /// <b>Restriction</b>: You can't change a channel's privacy. </p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn mode(mut self, inp: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelFlow`.
    ///
    /// <p>Updates channel flow attributes. This is a developer API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_flow_input::Builder,
    }
    impl<C, M, R> UpdateChannelFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelFlowInputOperationOutputAlias,
                crate::output::UpdateChannelFlowOutput,
                crate::error::UpdateChannelFlowError,
                crate::input::UpdateChannelFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_flow_arn(inp);
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_flow_arn(input);
            self
        }
        /// Appends an item to `Processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions </p>
        pub fn processors(mut self, inp: impl Into<crate::model::Processor>) -> Self {
            self.inner = self.inner.processors(inp);
            self
        }
        /// <p>Information about the processor Lambda functions </p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.inner = self.inner.set_processors(input);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelMessage`.
    ///
    /// <p>Updates the content of a message.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_message_input::Builder,
    }
    impl<C, M, R> UpdateChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelMessageInputOperationOutputAlias,
                crate::output::UpdateChannelMessageOutput,
                crate::error::UpdateChannelMessageError,
                crate::input::UpdateChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelReadMarker`.
    ///
    /// <p>The details of the time when a user last read messages in a channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelReadMarker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_read_marker_input::Builder,
    }
    impl<C, M, R> UpdateChannelReadMarker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelReadMarker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelReadMarkerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelReadMarkerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelReadMarkerInputOperationOutputAlias,
                crate::output::UpdateChannelReadMarkerOutput,
                crate::error::UpdateChannelReadMarkerError,
                crate::input::UpdateChannelReadMarkerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
