// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelReadMarkerOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateChannelReadMarkerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelReadMarkerOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}
/// See [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput)
pub mod update_channel_read_marker_output {
    /// A builder for [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput)
        pub fn build(self) -> crate::output::UpdateChannelReadMarkerOutput {
            crate::output::UpdateChannelReadMarkerOutput {
                channel_arn: self.channel_arn,
            }
        }
    }
}
impl UpdateChannelReadMarkerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput)
    pub fn builder() -> crate::output::update_channel_read_marker_output::Builder {
        crate::output::update_channel_read_marker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelMessageOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID string of the message being updated.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The status of the message update.</p>
    pub status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
}
impl std::fmt::Debug for UpdateChannelMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelMessageOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput)
pub mod update_channel_message_output {
    /// A builder for [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The status of the message update.</p>
        pub fn status(mut self, input: crate::model::ChannelMessageStatusStructure) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the message update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatusStructure>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput)
        pub fn build(self) -> crate::output::UpdateChannelMessageOutput {
            crate::output::UpdateChannelMessageOutput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                status: self.status,
            }
        }
    }
}
impl UpdateChannelMessageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput)
    pub fn builder() -> crate::output::update_channel_message_output::Builder {
        crate::output::update_channel_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelFlowOutput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelFlowOutput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.finish()
    }
}
/// See [`UpdateChannelFlowOutput`](crate::output::UpdateChannelFlowOutput)
pub mod update_channel_flow_output {
    /// A builder for [`UpdateChannelFlowOutput`](crate::output::UpdateChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelFlowOutput`](crate::output::UpdateChannelFlowOutput)
        pub fn build(self) -> crate::output::UpdateChannelFlowOutput {
            crate::output::UpdateChannelFlowOutput {
                channel_flow_arn: self.channel_flow_arn,
            }
        }
    }
}
impl UpdateChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelFlowOutput`](crate::output::UpdateChannelFlowOutput)
    pub fn builder() -> crate::output::update_channel_flow_output::Builder {
        crate::output::update_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}
/// See [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
pub mod update_channel_output {
    /// A builder for [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
        pub fn build(self) -> crate::output::UpdateChannelOutput {
            crate::output::UpdateChannelOutput {
                channel_arn: self.channel_arn,
            }
        }
    }
}
impl UpdateChannelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    pub fn builder() -> crate::output::update_channel_output::Builder {
        crate::output::update_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendChannelMessageOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID string assigned to each message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The status of the channel message.</p>
    pub status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
}
impl std::fmt::Debug for SendChannelMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendChannelMessageOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput)
pub mod send_channel_message_output {
    /// A builder for [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID string assigned to each message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID string assigned to each message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The status of the channel message.</p>
        pub fn status(mut self, input: crate::model::ChannelMessageStatusStructure) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the channel message.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatusStructure>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput)
        pub fn build(self) -> crate::output::SendChannelMessageOutput {
            crate::output::SendChannelMessageOutput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                status: self.status,
            }
        }
    }
}
impl SendChannelMessageOutput {
    /// Creates a new builder-style object to manufacture [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput)
    pub fn builder() -> crate::output::send_channel_message_output::Builder {
        crate::output::send_channel_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedactChannelMessageOutput {
    /// <p>The ARN of the channel containing the messages that you want to redact.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the message being redacted.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RedactChannelMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedactChannelMessageOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput)
pub mod redact_channel_message_output {
    /// A builder for [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput)
        pub fn build(self) -> crate::output::RedactChannelMessageOutput {
            crate::output::RedactChannelMessageOutput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
            }
        }
    }
}
impl RedactChannelMessageOutput {
    /// Creates a new builder-style object to manufacture [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput)
    pub fn builder() -> crate::output::redact_channel_message_output::Builder {
        crate::output::redact_channel_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsModeratedByAppInstanceUserOutput {
    /// <p>The moderated channels in the request.</p>
    pub channels:
        std::option::Option<std::vec::Vec<crate::model::ChannelModeratedByAppInstanceUserSummary>>,
    /// <p>The token returned from previous API requests until the number of channels moderated by
    /// the user is reached.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelsModeratedByAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsModeratedByAppInstanceUserOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput)
pub mod list_channels_moderated_by_app_instance_user_output {
    /// A builder for [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<
            std::vec::Vec<crate::model::ChannelModeratedByAppInstanceUserSummary>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>The moderated channels in the request.</p>
        pub fn channels(
            mut self,
            input: impl Into<crate::model::ChannelModeratedByAppInstanceUserSummary>,
        ) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>The moderated channels in the request.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ChannelModeratedByAppInstanceUserSummary>,
            >,
        ) -> Self {
            self.channels = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput)
        pub fn build(self) -> crate::output::ListChannelsModeratedByAppInstanceUserOutput {
            crate::output::ListChannelsModeratedByAppInstanceUserOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsModeratedByAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput)
    pub fn builder() -> crate::output::list_channels_moderated_by_app_instance_user_output::Builder
    {
        crate::output::list_channels_moderated_by_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsAssociatedWithChannelFlowOutput {
    /// <p>The information about each channel.</p>
    pub channels:
        std::option::Option<std::vec::Vec<crate::model::ChannelAssociatedWithFlowSummary>>,
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelsAssociatedWithChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsAssociatedWithChannelFlowOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelsAssociatedWithChannelFlowOutput`](crate::output::ListChannelsAssociatedWithChannelFlowOutput)
pub mod list_channels_associated_with_channel_flow_output {
    /// A builder for [`ListChannelsAssociatedWithChannelFlowOutput`](crate::output::ListChannelsAssociatedWithChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels:
            std::option::Option<std::vec::Vec<crate::model::ChannelAssociatedWithFlowSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>The information about each channel.</p>
        pub fn channels(
            mut self,
            input: impl Into<crate::model::ChannelAssociatedWithFlowSummary>,
        ) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>The information about each channel.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ChannelAssociatedWithFlowSummary>,
            >,
        ) -> Self {
            self.channels = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsAssociatedWithChannelFlowOutput`](crate::output::ListChannelsAssociatedWithChannelFlowOutput)
        pub fn build(self) -> crate::output::ListChannelsAssociatedWithChannelFlowOutput {
            crate::output::ListChannelsAssociatedWithChannelFlowOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsAssociatedWithChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsAssociatedWithChannelFlowOutput`](crate::output::ListChannelsAssociatedWithChannelFlowOutput)
    pub fn builder() -> crate::output::list_channels_associated_with_channel_flow_output::Builder {
        crate::output::list_channels_associated_with_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsOutput {
    /// <p>The information about each channel.</p>
    pub channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
    /// <p>The token returned from previous API requests until the number of channels is
    /// reached.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelsOutput`](crate::output::ListChannelsOutput)
pub mod list_channels_output {
    /// A builder for [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>The information about each channel.</p>
        pub fn channels(mut self, input: impl Into<crate::model::ChannelSummary>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>The information about each channel.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of channels is
        /// reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channels is
        /// reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsOutput`](crate::output::ListChannelsOutput)
        pub fn build(self) -> crate::output::ListChannelsOutput {
            crate::output::ListChannelsOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    pub fn builder() -> crate::output::list_channels_output::Builder {
        crate::output::list_channels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelModeratorsOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The token passed by previous API calls until all requested moderators are
    /// returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The information about and names of each moderator.</p>
    pub channel_moderators:
        std::option::Option<std::vec::Vec<crate::model::ChannelModeratorSummary>>,
}
impl std::fmt::Debug for ListChannelModeratorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelModeratorsOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_moderators", &self.channel_moderators);
        formatter.finish()
    }
}
/// See [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput)
pub mod list_channel_moderators_output {
    /// A builder for [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) channel_moderators:
            std::option::Option<std::vec::Vec<crate::model::ChannelModeratorSummary>>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `channel_moderators`.
        ///
        /// To override the contents of this collection use [`set_channel_moderators`](Self::set_channel_moderators).
        ///
        /// <p>The information about and names of each moderator.</p>
        pub fn channel_moderators(
            mut self,
            input: impl Into<crate::model::ChannelModeratorSummary>,
        ) -> Self {
            let mut v = self.channel_moderators.unwrap_or_default();
            v.push(input.into());
            self.channel_moderators = Some(v);
            self
        }
        /// <p>The information about and names of each moderator.</p>
        pub fn set_channel_moderators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelModeratorSummary>>,
        ) -> Self {
            self.channel_moderators = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput)
        pub fn build(self) -> crate::output::ListChannelModeratorsOutput {
            crate::output::ListChannelModeratorsOutput {
                channel_arn: self.channel_arn,
                next_token: self.next_token,
                channel_moderators: self.channel_moderators,
            }
        }
    }
}
impl ListChannelModeratorsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput)
    pub fn builder() -> crate::output::list_channel_moderators_output::Builder {
        crate::output::list_channel_moderators_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMessagesOutput {
    /// <p>The ARN of the channel containing the requested messages.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The token passed by previous API calls until all requested messages are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The information about, and content of, each requested message.</p>
    pub channel_messages: std::option::Option<std::vec::Vec<crate::model::ChannelMessageSummary>>,
}
impl std::fmt::Debug for ListChannelMessagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMessagesOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_messages", &self.channel_messages);
        formatter.finish()
    }
}
/// See [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput)
pub mod list_channel_messages_output {
    /// A builder for [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) channel_messages:
            std::option::Option<std::vec::Vec<crate::model::ChannelMessageSummary>>,
    }
    impl Builder {
        /// <p>The ARN of the channel containing the requested messages.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel containing the requested messages.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `channel_messages`.
        ///
        /// To override the contents of this collection use [`set_channel_messages`](Self::set_channel_messages).
        ///
        /// <p>The information about, and content of, each requested message.</p>
        pub fn channel_messages(
            mut self,
            input: impl Into<crate::model::ChannelMessageSummary>,
        ) -> Self {
            let mut v = self.channel_messages.unwrap_or_default();
            v.push(input.into());
            self.channel_messages = Some(v);
            self
        }
        /// <p>The information about, and content of, each requested message.</p>
        pub fn set_channel_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelMessageSummary>>,
        ) -> Self {
            self.channel_messages = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput)
        pub fn build(self) -> crate::output::ListChannelMessagesOutput {
            crate::output::ListChannelMessagesOutput {
                channel_arn: self.channel_arn,
                next_token: self.next_token,
                channel_messages: self.channel_messages,
            }
        }
    }
}
impl ListChannelMessagesOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput)
    pub fn builder() -> crate::output::list_channel_messages_output::Builder {
        crate::output::list_channel_messages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMembershipsForAppInstanceUserOutput {
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    pub channel_memberships: std::option::Option<
        std::vec::Vec<crate::model::ChannelMembershipForAppInstanceUserSummary>,
    >,
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelMembershipsForAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMembershipsForAppInstanceUserOutput");
        formatter.field("channel_memberships", &self.channel_memberships);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput)
pub mod list_channel_memberships_for_app_instance_user_output {
    /// A builder for [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_memberships: std::option::Option<
            std::vec::Vec<crate::model::ChannelMembershipForAppInstanceUserSummary>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channel_memberships`.
        ///
        /// To override the contents of this collection use [`set_channel_memberships`](Self::set_channel_memberships).
        ///
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn channel_memberships(
            mut self,
            input: impl Into<crate::model::ChannelMembershipForAppInstanceUserSummary>,
        ) -> Self {
            let mut v = self.channel_memberships.unwrap_or_default();
            v.push(input.into());
            self.channel_memberships = Some(v);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_channel_memberships(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ChannelMembershipForAppInstanceUserSummary>,
            >,
        ) -> Self {
            self.channel_memberships = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput)
        pub fn build(self) -> crate::output::ListChannelMembershipsForAppInstanceUserOutput {
            crate::output::ListChannelMembershipsForAppInstanceUserOutput {
                channel_memberships: self.channel_memberships,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelMembershipsForAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput)
    pub fn builder() -> crate::output::list_channel_memberships_for_app_instance_user_output::Builder
    {
        crate::output::list_channel_memberships_for_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelMembershipsOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The information for the requested channel memberships.</p>
    pub channel_memberships:
        std::option::Option<std::vec::Vec<crate::model::ChannelMembershipSummary>>,
    /// <p>The token passed by previous API calls until all requested channel memberships are
    /// returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelMembershipsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelMembershipsOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_memberships", &self.channel_memberships);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput)
pub mod list_channel_memberships_output {
    /// A builder for [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_memberships:
            std::option::Option<std::vec::Vec<crate::model::ChannelMembershipSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Appends an item to `channel_memberships`.
        ///
        /// To override the contents of this collection use [`set_channel_memberships`](Self::set_channel_memberships).
        ///
        /// <p>The information for the requested channel memberships.</p>
        pub fn channel_memberships(
            mut self,
            input: impl Into<crate::model::ChannelMembershipSummary>,
        ) -> Self {
            let mut v = self.channel_memberships.unwrap_or_default();
            v.push(input.into());
            self.channel_memberships = Some(v);
            self
        }
        /// <p>The information for the requested channel memberships.</p>
        pub fn set_channel_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelMembershipSummary>>,
        ) -> Self {
            self.channel_memberships = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput)
        pub fn build(self) -> crate::output::ListChannelMembershipsOutput {
            crate::output::ListChannelMembershipsOutput {
                channel_arn: self.channel_arn,
                channel_memberships: self.channel_memberships,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelMembershipsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput)
    pub fn builder() -> crate::output::list_channel_memberships_output::Builder {
        crate::output::list_channel_memberships_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelFlowsOutput {
    /// <p>The information about each channel flow.</p>
    pub channel_flows: std::option::Option<std::vec::Vec<crate::model::ChannelFlowSummary>>,
    /// <p>The token passed by previous API calls until all requested channels are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelFlowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelFlowsOutput");
        formatter.field("channel_flows", &self.channel_flows);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListChannelFlowsOutput`](crate::output::ListChannelFlowsOutput)
pub mod list_channel_flows_output {
    /// A builder for [`ListChannelFlowsOutput`](crate::output::ListChannelFlowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flows:
            std::option::Option<std::vec::Vec<crate::model::ChannelFlowSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channel_flows`.
        ///
        /// To override the contents of this collection use [`set_channel_flows`](Self::set_channel_flows).
        ///
        /// <p>The information about each channel flow.</p>
        pub fn channel_flows(mut self, input: impl Into<crate::model::ChannelFlowSummary>) -> Self {
            let mut v = self.channel_flows.unwrap_or_default();
            v.push(input.into());
            self.channel_flows = Some(v);
            self
        }
        /// <p>The information about each channel flow.</p>
        pub fn set_channel_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelFlowSummary>>,
        ) -> Self {
            self.channel_flows = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelFlowsOutput`](crate::output::ListChannelFlowsOutput)
        pub fn build(self) -> crate::output::ListChannelFlowsOutput {
            crate::output::ListChannelFlowsOutput {
                channel_flows: self.channel_flows,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelFlowsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelFlowsOutput`](crate::output::ListChannelFlowsOutput)
    pub fn builder() -> crate::output::list_channel_flows_output::Builder {
        crate::output::list_channel_flows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelBansOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The token passed by previous API calls until all requested bans are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The information for each requested ban.</p>
    pub channel_bans: std::option::Option<std::vec::Vec<crate::model::ChannelBanSummary>>,
}
impl std::fmt::Debug for ListChannelBansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelBansOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_bans", &self.channel_bans);
        formatter.finish()
    }
}
/// See [`ListChannelBansOutput`](crate::output::ListChannelBansOutput)
pub mod list_channel_bans_output {
    /// A builder for [`ListChannelBansOutput`](crate::output::ListChannelBansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) channel_bans:
            std::option::Option<std::vec::Vec<crate::model::ChannelBanSummary>>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `channel_bans`.
        ///
        /// To override the contents of this collection use [`set_channel_bans`](Self::set_channel_bans).
        ///
        /// <p>The information for each requested ban.</p>
        pub fn channel_bans(mut self, input: impl Into<crate::model::ChannelBanSummary>) -> Self {
            let mut v = self.channel_bans.unwrap_or_default();
            v.push(input.into());
            self.channel_bans = Some(v);
            self
        }
        /// <p>The information for each requested ban.</p>
        pub fn set_channel_bans(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelBanSummary>>,
        ) -> Self {
            self.channel_bans = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelBansOutput`](crate::output::ListChannelBansOutput)
        pub fn build(self) -> crate::output::ListChannelBansOutput {
            crate::output::ListChannelBansOutput {
                channel_arn: self.channel_arn,
                next_token: self.next_token,
                channel_bans: self.channel_bans,
            }
        }
    }
}
impl ListChannelBansOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelBansOutput`](crate::output::ListChannelBansOutput)
    pub fn builder() -> crate::output::list_channel_bans_output::Builder {
        crate::output::list_channel_bans_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMessagingSessionEndpointOutput {
    /// <p>The endpoint returned in the response.</p>
    pub endpoint: std::option::Option<crate::model::MessagingSessionEndpoint>,
}
impl std::fmt::Debug for GetMessagingSessionEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMessagingSessionEndpointOutput");
        formatter.field("endpoint", &self.endpoint);
        formatter.finish()
    }
}
/// See [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput)
pub mod get_messaging_session_endpoint_output {
    /// A builder for [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<crate::model::MessagingSessionEndpoint>,
    }
    impl Builder {
        /// <p>The endpoint returned in the response.</p>
        pub fn endpoint(mut self, input: crate::model::MessagingSessionEndpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>The endpoint returned in the response.</p>
        pub fn set_endpoint(
            mut self,
            input: std::option::Option<crate::model::MessagingSessionEndpoint>,
        ) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput)
        pub fn build(self) -> crate::output::GetMessagingSessionEndpointOutput {
            crate::output::GetMessagingSessionEndpointOutput {
                endpoint: self.endpoint,
            }
        }
    }
}
impl GetMessagingSessionEndpointOutput {
    /// Creates a new builder-style object to manufacture [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput)
    pub fn builder() -> crate::output::get_messaging_session_endpoint_output::Builder {
        crate::output::get_messaging_session_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelMessageStatusOutput {
    /// <p>The message status and details.</p>
    pub status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
}
impl std::fmt::Debug for GetChannelMessageStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelMessageStatusOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetChannelMessageStatusOutput`](crate::output::GetChannelMessageStatusOutput)
pub mod get_channel_message_status_output {
    /// A builder for [`GetChannelMessageStatusOutput`](crate::output::GetChannelMessageStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
    }
    impl Builder {
        /// <p>The message status and details.</p>
        pub fn status(mut self, input: crate::model::ChannelMessageStatusStructure) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The message status and details.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatusStructure>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMessageStatusOutput`](crate::output::GetChannelMessageStatusOutput)
        pub fn build(self) -> crate::output::GetChannelMessageStatusOutput {
            crate::output::GetChannelMessageStatusOutput {
                status: self.status,
            }
        }
    }
}
impl GetChannelMessageStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetChannelMessageStatusOutput`](crate::output::GetChannelMessageStatusOutput)
    pub fn builder() -> crate::output::get_channel_message_status_output::Builder {
        crate::output::get_channel_message_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelMessageOutput {
    /// <p>The details of and content in the message.</p>
    pub channel_message: std::option::Option<crate::model::ChannelMessage>,
}
impl std::fmt::Debug for GetChannelMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelMessageOutput");
        formatter.field("channel_message", &self.channel_message);
        formatter.finish()
    }
}
/// See [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput)
pub mod get_channel_message_output {
    /// A builder for [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_message: std::option::Option<crate::model::ChannelMessage>,
    }
    impl Builder {
        /// <p>The details of and content in the message.</p>
        pub fn channel_message(mut self, input: crate::model::ChannelMessage) -> Self {
            self.channel_message = Some(input);
            self
        }
        /// <p>The details of and content in the message.</p>
        pub fn set_channel_message(
            mut self,
            input: std::option::Option<crate::model::ChannelMessage>,
        ) -> Self {
            self.channel_message = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput)
        pub fn build(self) -> crate::output::GetChannelMessageOutput {
            crate::output::GetChannelMessageOutput {
                channel_message: self.channel_message,
            }
        }
    }
}
impl GetChannelMessageOutput {
    /// Creates a new builder-style object to manufacture [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput)
    pub fn builder() -> crate::output::get_channel_message_output::Builder {
        crate::output::get_channel_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateChannelFlowOutput {}
impl std::fmt::Debug for DisassociateChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateChannelFlowOutput");
        formatter.finish()
    }
}
/// See [`DisassociateChannelFlowOutput`](crate::output::DisassociateChannelFlowOutput)
pub mod disassociate_channel_flow_output {
    /// A builder for [`DisassociateChannelFlowOutput`](crate::output::DisassociateChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateChannelFlowOutput`](crate::output::DisassociateChannelFlowOutput)
        pub fn build(self) -> crate::output::DisassociateChannelFlowOutput {
            crate::output::DisassociateChannelFlowOutput {}
        }
    }
}
impl DisassociateChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateChannelFlowOutput`](crate::output::DisassociateChannelFlowOutput)
    pub fn builder() -> crate::output::disassociate_channel_flow_output::Builder {
        crate::output::disassociate_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelModeratorOutput {
    /// <p>The details of the channel moderator.</p>
    pub channel_moderator: std::option::Option<crate::model::ChannelModerator>,
}
impl std::fmt::Debug for DescribeChannelModeratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelModeratorOutput");
        formatter.field("channel_moderator", &self.channel_moderator);
        formatter.finish()
    }
}
/// See [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput)
pub mod describe_channel_moderator_output {
    /// A builder for [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_moderator: std::option::Option<crate::model::ChannelModerator>,
    }
    impl Builder {
        /// <p>The details of the channel moderator.</p>
        pub fn channel_moderator(mut self, input: crate::model::ChannelModerator) -> Self {
            self.channel_moderator = Some(input);
            self
        }
        /// <p>The details of the channel moderator.</p>
        pub fn set_channel_moderator(
            mut self,
            input: std::option::Option<crate::model::ChannelModerator>,
        ) -> Self {
            self.channel_moderator = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput)
        pub fn build(self) -> crate::output::DescribeChannelModeratorOutput {
            crate::output::DescribeChannelModeratorOutput {
                channel_moderator: self.channel_moderator,
            }
        }
    }
}
impl DescribeChannelModeratorOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput)
    pub fn builder() -> crate::output::describe_channel_moderator_output::Builder {
        crate::output::describe_channel_moderator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelModeratedByAppInstanceUserOutput {
    /// <p>The moderated channel.</p>
    pub channel: std::option::Option<crate::model::ChannelModeratedByAppInstanceUserSummary>,
}
impl std::fmt::Debug for DescribeChannelModeratedByAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelModeratedByAppInstanceUserOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput)
pub mod describe_channel_moderated_by_app_instance_user_output {
    /// A builder for [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel:
            std::option::Option<crate::model::ChannelModeratedByAppInstanceUserSummary>,
    }
    impl Builder {
        /// <p>The moderated channel.</p>
        pub fn channel(
            mut self,
            input: crate::model::ChannelModeratedByAppInstanceUserSummary,
        ) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The moderated channel.</p>
        pub fn set_channel(
            mut self,
            input: std::option::Option<crate::model::ChannelModeratedByAppInstanceUserSummary>,
        ) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput)
        pub fn build(self) -> crate::output::DescribeChannelModeratedByAppInstanceUserOutput {
            crate::output::DescribeChannelModeratedByAppInstanceUserOutput {
                channel: self.channel,
            }
        }
    }
}
impl DescribeChannelModeratedByAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput)
    pub fn builder(
    ) -> crate::output::describe_channel_moderated_by_app_instance_user_output::Builder {
        crate::output::describe_channel_moderated_by_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelMembershipForAppInstanceUserOutput {
    /// <p>The channel to which a user belongs.</p>
    pub channel_membership:
        std::option::Option<crate::model::ChannelMembershipForAppInstanceUserSummary>,
}
impl std::fmt::Debug for DescribeChannelMembershipForAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelMembershipForAppInstanceUserOutput");
        formatter.field("channel_membership", &self.channel_membership);
        formatter.finish()
    }
}
/// See [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput)
pub mod describe_channel_membership_for_app_instance_user_output {
    /// A builder for [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_membership:
            std::option::Option<crate::model::ChannelMembershipForAppInstanceUserSummary>,
    }
    impl Builder {
        /// <p>The channel to which a user belongs.</p>
        pub fn channel_membership(
            mut self,
            input: crate::model::ChannelMembershipForAppInstanceUserSummary,
        ) -> Self {
            self.channel_membership = Some(input);
            self
        }
        /// <p>The channel to which a user belongs.</p>
        pub fn set_channel_membership(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipForAppInstanceUserSummary>,
        ) -> Self {
            self.channel_membership = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput)
        pub fn build(self) -> crate::output::DescribeChannelMembershipForAppInstanceUserOutput {
            crate::output::DescribeChannelMembershipForAppInstanceUserOutput {
                channel_membership: self.channel_membership,
            }
        }
    }
}
impl DescribeChannelMembershipForAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput)
    pub fn builder(
    ) -> crate::output::describe_channel_membership_for_app_instance_user_output::Builder {
        crate::output::describe_channel_membership_for_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelMembershipOutput {
    /// <p>The details of the membership.</p>
    pub channel_membership: std::option::Option<crate::model::ChannelMembership>,
}
impl std::fmt::Debug for DescribeChannelMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelMembershipOutput");
        formatter.field("channel_membership", &self.channel_membership);
        formatter.finish()
    }
}
/// See [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput)
pub mod describe_channel_membership_output {
    /// A builder for [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_membership: std::option::Option<crate::model::ChannelMembership>,
    }
    impl Builder {
        /// <p>The details of the membership.</p>
        pub fn channel_membership(mut self, input: crate::model::ChannelMembership) -> Self {
            self.channel_membership = Some(input);
            self
        }
        /// <p>The details of the membership.</p>
        pub fn set_channel_membership(
            mut self,
            input: std::option::Option<crate::model::ChannelMembership>,
        ) -> Self {
            self.channel_membership = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput)
        pub fn build(self) -> crate::output::DescribeChannelMembershipOutput {
            crate::output::DescribeChannelMembershipOutput {
                channel_membership: self.channel_membership,
            }
        }
    }
}
impl DescribeChannelMembershipOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput)
    pub fn builder() -> crate::output::describe_channel_membership_output::Builder {
        crate::output::describe_channel_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelFlowOutput {
    /// <p>The channel flow details.</p>
    pub channel_flow: std::option::Option<crate::model::ChannelFlow>,
}
impl std::fmt::Debug for DescribeChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelFlowOutput");
        formatter.field("channel_flow", &self.channel_flow);
        formatter.finish()
    }
}
/// See [`DescribeChannelFlowOutput`](crate::output::DescribeChannelFlowOutput)
pub mod describe_channel_flow_output {
    /// A builder for [`DescribeChannelFlowOutput`](crate::output::DescribeChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow: std::option::Option<crate::model::ChannelFlow>,
    }
    impl Builder {
        /// <p>The channel flow details.</p>
        pub fn channel_flow(mut self, input: crate::model::ChannelFlow) -> Self {
            self.channel_flow = Some(input);
            self
        }
        /// <p>The channel flow details.</p>
        pub fn set_channel_flow(
            mut self,
            input: std::option::Option<crate::model::ChannelFlow>,
        ) -> Self {
            self.channel_flow = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelFlowOutput`](crate::output::DescribeChannelFlowOutput)
        pub fn build(self) -> crate::output::DescribeChannelFlowOutput {
            crate::output::DescribeChannelFlowOutput {
                channel_flow: self.channel_flow,
            }
        }
    }
}
impl DescribeChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelFlowOutput`](crate::output::DescribeChannelFlowOutput)
    pub fn builder() -> crate::output::describe_channel_flow_output::Builder {
        crate::output::describe_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelBanOutput {
    /// <p>The details of the ban.</p>
    pub channel_ban: std::option::Option<crate::model::ChannelBan>,
}
impl std::fmt::Debug for DescribeChannelBanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelBanOutput");
        formatter.field("channel_ban", &self.channel_ban);
        formatter.finish()
    }
}
/// See [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput)
pub mod describe_channel_ban_output {
    /// A builder for [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_ban: std::option::Option<crate::model::ChannelBan>,
    }
    impl Builder {
        /// <p>The details of the ban.</p>
        pub fn channel_ban(mut self, input: crate::model::ChannelBan) -> Self {
            self.channel_ban = Some(input);
            self
        }
        /// <p>The details of the ban.</p>
        pub fn set_channel_ban(
            mut self,
            input: std::option::Option<crate::model::ChannelBan>,
        ) -> Self {
            self.channel_ban = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput)
        pub fn build(self) -> crate::output::DescribeChannelBanOutput {
            crate::output::DescribeChannelBanOutput {
                channel_ban: self.channel_ban,
            }
        }
    }
}
impl DescribeChannelBanOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput)
    pub fn builder() -> crate::output::describe_channel_ban_output::Builder {
        crate::output::describe_channel_ban_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelOutput {
    /// <p>The channel details.</p>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl std::fmt::Debug for DescribeChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
pub mod describe_channel_output {
    /// A builder for [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p>The channel details.</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channel details.</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
        pub fn build(self) -> crate::output::DescribeChannelOutput {
            crate::output::DescribeChannelOutput {
                channel: self.channel,
            }
        }
    }
}
impl DescribeChannelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    pub fn builder() -> crate::output::describe_channel_output::Builder {
        crate::output::describe_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelModeratorOutput {}
impl std::fmt::Debug for DeleteChannelModeratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelModeratorOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)
pub mod delete_channel_moderator_output {
    /// A builder for [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)
        pub fn build(self) -> crate::output::DeleteChannelModeratorOutput {
            crate::output::DeleteChannelModeratorOutput {}
        }
    }
}
impl DeleteChannelModeratorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)
    pub fn builder() -> crate::output::delete_channel_moderator_output::Builder {
        crate::output::delete_channel_moderator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelMessageOutput {}
impl std::fmt::Debug for DeleteChannelMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelMessageOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)
pub mod delete_channel_message_output {
    /// A builder for [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)
        pub fn build(self) -> crate::output::DeleteChannelMessageOutput {
            crate::output::DeleteChannelMessageOutput {}
        }
    }
}
impl DeleteChannelMessageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)
    pub fn builder() -> crate::output::delete_channel_message_output::Builder {
        crate::output::delete_channel_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelMembershipOutput {}
impl std::fmt::Debug for DeleteChannelMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelMembershipOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)
pub mod delete_channel_membership_output {
    /// A builder for [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)
        pub fn build(self) -> crate::output::DeleteChannelMembershipOutput {
            crate::output::DeleteChannelMembershipOutput {}
        }
    }
}
impl DeleteChannelMembershipOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)
    pub fn builder() -> crate::output::delete_channel_membership_output::Builder {
        crate::output::delete_channel_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelFlowOutput {}
impl std::fmt::Debug for DeleteChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelFlowOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelFlowOutput`](crate::output::DeleteChannelFlowOutput)
pub mod delete_channel_flow_output {
    /// A builder for [`DeleteChannelFlowOutput`](crate::output::DeleteChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelFlowOutput`](crate::output::DeleteChannelFlowOutput)
        pub fn build(self) -> crate::output::DeleteChannelFlowOutput {
            crate::output::DeleteChannelFlowOutput {}
        }
    }
}
impl DeleteChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelFlowOutput`](crate::output::DeleteChannelFlowOutput)
    pub fn builder() -> crate::output::delete_channel_flow_output::Builder {
        crate::output::delete_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelBanOutput {}
impl std::fmt::Debug for DeleteChannelBanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelBanOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)
pub mod delete_channel_ban_output {
    /// A builder for [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)
        pub fn build(self) -> crate::output::DeleteChannelBanOutput {
            crate::output::DeleteChannelBanOutput {}
        }
    }
}
impl DeleteChannelBanOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)
    pub fn builder() -> crate::output::delete_channel_ban_output::Builder {
        crate::output::delete_channel_ban_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelOutput {}
impl std::fmt::Debug for DeleteChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
pub mod delete_channel_output {
    /// A builder for [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
        pub fn build(self) -> crate::output::DeleteChannelOutput {
            crate::output::DeleteChannelOutput {}
        }
    }
}
impl DeleteChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    pub fn builder() -> crate::output::delete_channel_output::Builder {
        crate::output::delete_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelModeratorOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARNs of the channel and the moderator.</p>
    pub channel_moderator: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for CreateChannelModeratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelModeratorOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_moderator", &self.channel_moderator);
        formatter.finish()
    }
}
/// See [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput)
pub mod create_channel_moderator_output {
    /// A builder for [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARNs of the channel and the moderator.</p>
        pub fn channel_moderator(mut self, input: crate::model::Identity) -> Self {
            self.channel_moderator = Some(input);
            self
        }
        /// <p>The ARNs of the channel and the moderator.</p>
        pub fn set_channel_moderator(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.channel_moderator = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput)
        pub fn build(self) -> crate::output::CreateChannelModeratorOutput {
            crate::output::CreateChannelModeratorOutput {
                channel_arn: self.channel_arn,
                channel_moderator: self.channel_moderator,
            }
        }
    }
}
impl CreateChannelModeratorOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput)
    pub fn builder() -> crate::output::create_channel_moderator_output::Builder {
        crate::output::create_channel_moderator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelMembershipOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN and metadata of the member being added.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for CreateChannelMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelMembershipOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput)
pub mod create_channel_membership_output {
    /// A builder for [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN and metadata of the member being added.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The ARN and metadata of the member being added.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput)
        pub fn build(self) -> crate::output::CreateChannelMembershipOutput {
            crate::output::CreateChannelMembershipOutput {
                channel_arn: self.channel_arn,
                member: self.member,
            }
        }
    }
}
impl CreateChannelMembershipOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput)
    pub fn builder() -> crate::output::create_channel_membership_output::Builder {
        crate::output::create_channel_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelFlowOutput {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelFlowOutput");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.finish()
    }
}
/// See [`CreateChannelFlowOutput`](crate::output::CreateChannelFlowOutput)
pub mod create_channel_flow_output {
    /// A builder for [`CreateChannelFlowOutput`](crate::output::CreateChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelFlowOutput`](crate::output::CreateChannelFlowOutput)
        pub fn build(self) -> crate::output::CreateChannelFlowOutput {
            crate::output::CreateChannelFlowOutput {
                channel_flow_arn: self.channel_flow_arn,
            }
        }
    }
}
impl CreateChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelFlowOutput`](crate::output::CreateChannelFlowOutput)
    pub fn builder() -> crate::output::create_channel_flow_output::Builder {
        crate::output::create_channel_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelBanOutput {
    /// <p>The ARN of the response to the ban request.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban
    /// response.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for CreateChannelBanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelBanOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput)
pub mod create_channel_ban_output {
    /// A builder for [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The ARN of the response to the ban request.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the response to the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban
        /// response.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban
        /// response.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput)
        pub fn build(self) -> crate::output::CreateChannelBanOutput {
            crate::output::CreateChannelBanOutput {
                channel_arn: self.channel_arn,
                member: self.member,
            }
        }
    }
}
impl CreateChannelBanOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput)
    pub fn builder() -> crate::output::create_channel_ban_output::Builder {
        crate::output::create_channel_ban_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}
/// See [`CreateChannelOutput`](crate::output::CreateChannelOutput)
pub mod create_channel_output {
    /// A builder for [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelOutput`](crate::output::CreateChannelOutput)
        pub fn build(self) -> crate::output::CreateChannelOutput {
            crate::output::CreateChannelOutput {
                channel_arn: self.channel_arn,
            }
        }
    }
}
impl CreateChannelOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    pub fn builder() -> crate::output::create_channel_output::Builder {
        crate::output::create_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelFlowCallbackOutput {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The call back ID passed in the request.</p>
    pub callback_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelFlowCallbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelFlowCallbackOutput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("callback_id", &self.callback_id);
        formatter.finish()
    }
}
/// See [`ChannelFlowCallbackOutput`](crate::output::ChannelFlowCallbackOutput)
pub mod channel_flow_callback_output {
    /// A builder for [`ChannelFlowCallbackOutput`](crate::output::ChannelFlowCallbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) callback_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The call back ID passed in the request.</p>
        pub fn callback_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.callback_id = Some(input.into());
            self
        }
        /// <p>The call back ID passed in the request.</p>
        pub fn set_callback_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.callback_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelFlowCallbackOutput`](crate::output::ChannelFlowCallbackOutput)
        pub fn build(self) -> crate::output::ChannelFlowCallbackOutput {
            crate::output::ChannelFlowCallbackOutput {
                channel_arn: self.channel_arn,
                callback_id: self.callback_id,
            }
        }
    }
}
impl ChannelFlowCallbackOutput {
    /// Creates a new builder-style object to manufacture [`ChannelFlowCallbackOutput`](crate::output::ChannelFlowCallbackOutput)
    pub fn builder() -> crate::output::channel_flow_callback_output::Builder {
        crate::output::channel_flow_callback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateChannelMembershipOutput {
    /// <p>The list of channel memberships in the response.</p>
    pub batch_channel_memberships: std::option::Option<crate::model::BatchChannelMemberships>,
    /// <p>If the action fails for one or more of the memberships in the request, a list of the
    /// memberships is returned, along with error codes and error messages.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchCreateChannelMembershipError>>,
}
impl std::fmt::Debug for BatchCreateChannelMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateChannelMembershipOutput");
        formatter.field("batch_channel_memberships", &self.batch_channel_memberships);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput)
pub mod batch_create_channel_membership_output {
    /// A builder for [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_channel_memberships:
            std::option::Option<crate::model::BatchChannelMemberships>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchCreateChannelMembershipError>>,
    }
    impl Builder {
        /// <p>The list of channel memberships in the response.</p>
        pub fn batch_channel_memberships(
            mut self,
            input: crate::model::BatchChannelMemberships,
        ) -> Self {
            self.batch_channel_memberships = Some(input);
            self
        }
        /// <p>The list of channel memberships in the response.</p>
        pub fn set_batch_channel_memberships(
            mut self,
            input: std::option::Option<crate::model::BatchChannelMemberships>,
        ) -> Self {
            self.batch_channel_memberships = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>If the action fails for one or more of the memberships in the request, a list of the
        /// memberships is returned, along with error codes and error messages.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchCreateChannelMembershipError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>If the action fails for one or more of the memberships in the request, a list of the
        /// memberships is returned, along with error codes and error messages.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchCreateChannelMembershipError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput)
        pub fn build(self) -> crate::output::BatchCreateChannelMembershipOutput {
            crate::output::BatchCreateChannelMembershipOutput {
                batch_channel_memberships: self.batch_channel_memberships,
                errors: self.errors,
            }
        }
    }
}
impl BatchCreateChannelMembershipOutput {
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput)
    pub fn builder() -> crate::output::batch_create_channel_membership_output::Builder {
        crate::output::batch_create_channel_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateChannelFlowOutput {}
impl std::fmt::Debug for AssociateChannelFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateChannelFlowOutput");
        formatter.finish()
    }
}
/// See [`AssociateChannelFlowOutput`](crate::output::AssociateChannelFlowOutput)
pub mod associate_channel_flow_output {
    /// A builder for [`AssociateChannelFlowOutput`](crate::output::AssociateChannelFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateChannelFlowOutput`](crate::output::AssociateChannelFlowOutput)
        pub fn build(self) -> crate::output::AssociateChannelFlowOutput {
            crate::output::AssociateChannelFlowOutput {}
        }
    }
}
impl AssociateChannelFlowOutput {
    /// Creates a new builder-style object to manufacture [`AssociateChannelFlowOutput`](crate::output::AssociateChannelFlowOutput)
    pub fn builder() -> crate::output::associate_channel_flow_output::Builder {
        crate::output::associate_channel_flow_output::Builder::default()
    }
}
