// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    BadRequest,
    #[allow(missing_docs)] // documentation missing in model
    Conflict,
    #[allow(missing_docs)] // documentation missing in model
    Forbidden,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberAssociationsExist,
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ServiceFailure,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    #[allow(missing_docs)] // documentation missing in model
    Unauthorized,
    #[allow(missing_docs)] // documentation missing in model
    Unprocessable,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnectorGroupAssociationsExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => ErrorCode::AccessDenied,
            "BadRequest" => ErrorCode::BadRequest,
            "Conflict" => ErrorCode::Conflict,
            "Forbidden" => ErrorCode::Forbidden,
            "NotFound" => ErrorCode::NotFound,
            "PhoneNumberAssociationsExist" => ErrorCode::PhoneNumberAssociationsExist,
            "PreconditionFailed" => ErrorCode::PreconditionFailed,
            "ResourceLimitExceeded" => ErrorCode::ResourceLimitExceeded,
            "ServiceFailure" => ErrorCode::ServiceFailure,
            "ServiceUnavailable" => ErrorCode::ServiceUnavailable,
            "Throttled" => ErrorCode::Throttled,
            "Throttling" => ErrorCode::Throttling,
            "Unauthorized" => ErrorCode::Unauthorized,
            "Unprocessable" => ErrorCode::Unprocessable,
            "VoiceConnectorGroupAssociationsExist" => {
                ErrorCode::VoiceConnectorGroupAssociationsExist
            }
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "AccessDenied",
            ErrorCode::BadRequest => "BadRequest",
            ErrorCode::Conflict => "Conflict",
            ErrorCode::Forbidden => "Forbidden",
            ErrorCode::NotFound => "NotFound",
            ErrorCode::PhoneNumberAssociationsExist => "PhoneNumberAssociationsExist",
            ErrorCode::PreconditionFailed => "PreconditionFailed",
            ErrorCode::ResourceLimitExceeded => "ResourceLimitExceeded",
            ErrorCode::ServiceFailure => "ServiceFailure",
            ErrorCode::ServiceUnavailable => "ServiceUnavailable",
            ErrorCode::Throttled => "Throttled",
            ErrorCode::Throttling => "Throttling",
            ErrorCode::Unauthorized => "Unauthorized",
            ErrorCode::Unprocessable => "Unprocessable",
            ErrorCode::VoiceConnectorGroupAssociationsExist => {
                "VoiceConnectorGroupAssociationsExist"
            }
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "BadRequest",
            "Conflict",
            "Forbidden",
            "NotFound",
            "PhoneNumberAssociationsExist",
            "PreconditionFailed",
            "ResourceLimitExceeded",
            "ServiceFailure",
            "ServiceUnavailable",
            "Throttled",
            "Throttling",
            "Unauthorized",
            "Unprocessable",
            "VoiceConnectorGroupAssociationsExist",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Stores information about a message status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessageStatusStructure {
    /// <p>The message status value.</p>
    pub value: std::option::Option<crate::model::ChannelMessageStatus>,
    /// <p>Contains more details about the messasge status.</p>
    pub detail: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelMessageStatusStructure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessageStatusStructure");
        formatter.field("value", &self.value);
        formatter.field("detail", &self.detail);
        formatter.finish()
    }
}
/// See [`ChannelMessageStatusStructure`](crate::model::ChannelMessageStatusStructure)
pub mod channel_message_status_structure {
    /// A builder for [`ChannelMessageStatusStructure`](crate::model::ChannelMessageStatusStructure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::ChannelMessageStatus>,
        pub(crate) detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message status value.</p>
        pub fn value(mut self, input: crate::model::ChannelMessageStatus) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The message status value.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatus>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>Contains more details about the messasge status.</p>
        pub fn detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail = Some(input.into());
            self
        }
        /// <p>Contains more details about the messasge status.</p>
        pub fn set_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessageStatusStructure`](crate::model::ChannelMessageStatusStructure)
        pub fn build(self) -> crate::model::ChannelMessageStatusStructure {
            crate::model::ChannelMessageStatusStructure {
                value: self.value,
                detail: self.detail,
            }
        }
    }
}
impl ChannelMessageStatusStructure {
    /// Creates a new builder-style object to manufacture [`ChannelMessageStatusStructure`](crate::model::ChannelMessageStatusStructure)
    pub fn builder() -> crate::model::channel_message_status_structure::Builder {
        crate::model::channel_message_status_structure::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMessageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Denied,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Sent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMessageStatus {
    fn from(s: &str) -> Self {
        match s {
            "DENIED" => ChannelMessageStatus::Denied,
            "FAILED" => ChannelMessageStatus::Failed,
            "PENDING" => ChannelMessageStatus::Pending,
            "SENT" => ChannelMessageStatus::Sent,
            other => ChannelMessageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMessageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMessageStatus::from(s))
    }
}
impl ChannelMessageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMessageStatus::Denied => "DENIED",
            ChannelMessageStatus::Failed => "FAILED",
            ChannelMessageStatus::Pending => "PENDING",
            ChannelMessageStatus::Sent => "SENT",
            ChannelMessageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DENIED", "FAILED", "PENDING", "SENT"]
    }
}
impl AsRef<str> for ChannelMessageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information about a processor in a channel flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Processor {
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The information about the type of processor and its identifier.</p>
    pub configuration: std::option::Option<crate::model::ProcessorConfiguration>,
    /// <p>The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence.
    /// At this point, we support only 1 processor within a flow.</p>
    pub execution_order: std::option::Option<i32>,
    /// <p>Determines whether to continue or stop processing if communication with processor fails. If the last processor in a channel flow sequence has a fallback action of CONTINUE, and communication
    /// with the processor fails, the message is considered processed and sent to the recipients in the channel.</p>
    pub fallback_action: std::option::Option<crate::model::FallbackAction>,
}
impl std::fmt::Debug for Processor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Processor");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("configuration", &self.configuration);
        formatter.field("execution_order", &self.execution_order);
        formatter.field("fallback_action", &self.fallback_action);
        formatter.finish()
    }
}
/// See [`Processor`](crate::model::Processor)
pub mod processor {
    /// A builder for [`Processor`](crate::model::Processor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ProcessorConfiguration>,
        pub(crate) execution_order: std::option::Option<i32>,
        pub(crate) fallback_action: std::option::Option<crate::model::FallbackAction>,
    }
    impl Builder {
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The information about the type of processor and its identifier.</p>
        pub fn configuration(mut self, input: crate::model::ProcessorConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The information about the type of processor and its identifier.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessorConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence.
        /// At this point, we support only 1 processor within a flow.</p>
        pub fn execution_order(mut self, input: i32) -> Self {
            self.execution_order = Some(input);
            self
        }
        /// <p>The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence.
        /// At this point, we support only 1 processor within a flow.</p>
        pub fn set_execution_order(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_order = input;
            self
        }
        /// <p>Determines whether to continue or stop processing if communication with processor fails. If the last processor in a channel flow sequence has a fallback action of CONTINUE, and communication
        /// with the processor fails, the message is considered processed and sent to the recipients in the channel.</p>
        pub fn fallback_action(mut self, input: crate::model::FallbackAction) -> Self {
            self.fallback_action = Some(input);
            self
        }
        /// <p>Determines whether to continue or stop processing if communication with processor fails. If the last processor in a channel flow sequence has a fallback action of CONTINUE, and communication
        /// with the processor fails, the message is considered processed and sent to the recipients in the channel.</p>
        pub fn set_fallback_action(
            mut self,
            input: std::option::Option<crate::model::FallbackAction>,
        ) -> Self {
            self.fallback_action = input;
            self
        }
        /// Consumes the builder and constructs a [`Processor`](crate::model::Processor)
        pub fn build(self) -> crate::model::Processor {
            crate::model::Processor {
                name: self.name,
                configuration: self.configuration,
                execution_order: self.execution_order,
                fallback_action: self.fallback_action,
            }
        }
    }
}
impl Processor {
    /// Creates a new builder-style object to manufacture [`Processor`](crate::model::Processor)
    pub fn builder() -> crate::model::processor::Builder {
        crate::model::processor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FallbackAction {
    #[allow(missing_docs)] // documentation missing in model
    Abort,
    #[allow(missing_docs)] // documentation missing in model
    Continue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FallbackAction {
    fn from(s: &str) -> Self {
        match s {
            "ABORT" => FallbackAction::Abort,
            "CONTINUE" => FallbackAction::Continue,
            other => FallbackAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FallbackAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FallbackAction::from(s))
    }
}
impl FallbackAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FallbackAction::Abort => "ABORT",
            FallbackAction::Continue => "CONTINUE",
            FallbackAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORT", "CONTINUE"]
    }
}
impl AsRef<str> for FallbackAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A processor's metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessorConfiguration {
    /// <p>Indicates that the processor is of type Lambda.</p>
    pub lambda: std::option::Option<crate::model::LambdaConfiguration>,
}
impl std::fmt::Debug for ProcessorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessorConfiguration");
        formatter.field("lambda", &self.lambda);
        formatter.finish()
    }
}
/// See [`ProcessorConfiguration`](crate::model::ProcessorConfiguration)
pub mod processor_configuration {
    /// A builder for [`ProcessorConfiguration`](crate::model::ProcessorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda: std::option::Option<crate::model::LambdaConfiguration>,
    }
    impl Builder {
        /// <p>Indicates that the processor is of type Lambda.</p>
        pub fn lambda(mut self, input: crate::model::LambdaConfiguration) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Indicates that the processor is of type Lambda.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaConfiguration>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessorConfiguration`](crate::model::ProcessorConfiguration)
        pub fn build(self) -> crate::model::ProcessorConfiguration {
            crate::model::ProcessorConfiguration {
                lambda: self.lambda,
            }
        }
    }
}
impl ProcessorConfiguration {
    /// Creates a new builder-style object to manufacture [`ProcessorConfiguration`](crate::model::ProcessorConfiguration)
    pub fn builder() -> crate::model::processor_configuration::Builder {
        crate::model::processor_configuration::Builder::default()
    }
}

/// <p>Stores metadata about a Lambda processor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaConfiguration {
    /// <p>The ARN of the Lambda message processing function.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Controls how the Lambda function is invoked.</p>
    pub invocation_type: std::option::Option<crate::model::InvocationType>,
}
impl std::fmt::Debug for LambdaConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaConfiguration");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("invocation_type", &self.invocation_type);
        formatter.finish()
    }
}
/// See [`LambdaConfiguration`](crate::model::LambdaConfiguration)
pub mod lambda_configuration {
    /// A builder for [`LambdaConfiguration`](crate::model::LambdaConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_type: std::option::Option<crate::model::InvocationType>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda message processing function.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda message processing function.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Controls how the Lambda function is invoked.</p>
        pub fn invocation_type(mut self, input: crate::model::InvocationType) -> Self {
            self.invocation_type = Some(input);
            self
        }
        /// <p>Controls how the Lambda function is invoked.</p>
        pub fn set_invocation_type(
            mut self,
            input: std::option::Option<crate::model::InvocationType>,
        ) -> Self {
            self.invocation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaConfiguration`](crate::model::LambdaConfiguration)
        pub fn build(self) -> crate::model::LambdaConfiguration {
            crate::model::LambdaConfiguration {
                resource_arn: self.resource_arn,
                invocation_type: self.invocation_type,
            }
        }
    }
}
impl LambdaConfiguration {
    /// Creates a new builder-style object to manufacture [`LambdaConfiguration`](crate::model::LambdaConfiguration)
    pub fn builder() -> crate::model::lambda_configuration::Builder {
        crate::model::lambda_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvocationType {
    #[allow(missing_docs)] // documentation missing in model
    Async,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvocationType {
    fn from(s: &str) -> Self {
        match s {
            "ASYNC" => InvocationType::Async,
            other => InvocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvocationType::from(s))
    }
}
impl InvocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvocationType::Async => "ASYNC",
            InvocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASYNC"]
    }
}
impl AsRef<str> for InvocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMode {
    #[allow(missing_docs)] // documentation missing in model
    Restricted,
    #[allow(missing_docs)] // documentation missing in model
    Unrestricted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMode {
    fn from(s: &str) -> Self {
        match s {
            "RESTRICTED" => ChannelMode::Restricted,
            "UNRESTRICTED" => ChannelMode::Unrestricted,
            other => ChannelMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMode::from(s))
    }
}
impl ChannelMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMode::Restricted => "RESTRICTED",
            ChannelMode::Unrestricted => "UNRESTRICTED",
            ChannelMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESTRICTED", "UNRESTRICTED"]
    }
}
impl AsRef<str> for ChannelMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A tag object containing a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key in a tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value in a tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key in a tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key in a tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value in a tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value in a tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMessagePersistenceType {
    #[allow(missing_docs)] // documentation missing in model
    NonPersistent,
    #[allow(missing_docs)] // documentation missing in model
    Persistent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMessagePersistenceType {
    fn from(s: &str) -> Self {
        match s {
            "NON_PERSISTENT" => ChannelMessagePersistenceType::NonPersistent,
            "PERSISTENT" => ChannelMessagePersistenceType::Persistent,
            other => ChannelMessagePersistenceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMessagePersistenceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMessagePersistenceType::from(s))
    }
}
impl ChannelMessagePersistenceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMessagePersistenceType::NonPersistent => "NON_PERSISTENT",
            ChannelMessagePersistenceType::Persistent => "PERSISTENT",
            ChannelMessagePersistenceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NON_PERSISTENT", "PERSISTENT"]
    }
}
impl AsRef<str> for ChannelMessagePersistenceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMessageType {
    #[allow(missing_docs)] // documentation missing in model
    Control,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMessageType {
    fn from(s: &str) -> Self {
        match s {
            "CONTROL" => ChannelMessageType::Control,
            "STANDARD" => ChannelMessageType::Standard,
            other => ChannelMessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMessageType::from(s))
    }
}
impl ChannelMessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMessageType::Control => "CONTROL",
            ChannelMessageType::Standard => "STANDARD",
            ChannelMessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTROL", "STANDARD"]
    }
}
impl AsRef<str> for ChannelMessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the details of a moderated channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModeratedByAppInstanceUserSummary {
    /// <p>Summary of the details of a <code>Channel</code>.</p>
    pub channel_summary: std::option::Option<crate::model::ChannelSummary>,
}
impl std::fmt::Debug for ChannelModeratedByAppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModeratedByAppInstanceUserSummary");
        formatter.field("channel_summary", &self.channel_summary);
        formatter.finish()
    }
}
/// See [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
pub mod channel_moderated_by_app_instance_user_summary {
    /// A builder for [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_summary: std::option::Option<crate::model::ChannelSummary>,
    }
    impl Builder {
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn channel_summary(mut self, input: crate::model::ChannelSummary) -> Self {
            self.channel_summary = Some(input);
            self
        }
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn set_channel_summary(
            mut self,
            input: std::option::Option<crate::model::ChannelSummary>,
        ) -> Self {
            self.channel_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
        pub fn build(self) -> crate::model::ChannelModeratedByAppInstanceUserSummary {
            crate::model::ChannelModeratedByAppInstanceUserSummary {
                channel_summary: self.channel_summary,
            }
        }
    }
}
impl ChannelModeratedByAppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
    pub fn builder() -> crate::model::channel_moderated_by_app_instance_user_summary::Builder {
        crate::model::channel_moderated_by_app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the details of a <code>Channel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelSummary {
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The mode of the channel.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The privacy setting of the channel.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The metadata of the channel.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The time at which the last message in a channel was sent.</p>
    pub last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ChannelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelSummary");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("last_message_timestamp", &self.last_message_timestamp);
        formatter.finish()
    }
}
/// See [`ChannelSummary`](crate::model::ChannelSummary)
pub mod channel_summary {
    /// A builder for [`ChannelSummary`](crate::model::ChannelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The privacy setting of the channel.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The privacy setting of the channel.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The metadata of the channel.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the channel.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The time at which the last message in a channel was sent.</p>
        pub fn last_message_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_message_timestamp = Some(input);
            self
        }
        /// <p>The time at which the last message in a channel was sent.</p>
        pub fn set_last_message_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_message_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelSummary`](crate::model::ChannelSummary)
        pub fn build(self) -> crate::model::ChannelSummary {
            crate::model::ChannelSummary {
                name: self.name,
                channel_arn: self.channel_arn,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                last_message_timestamp: self.last_message_timestamp,
            }
        }
    }
}
impl ChannelSummary {
    /// Creates a new builder-style object to manufacture [`ChannelSummary`](crate::model::ChannelSummary)
    pub fn builder() -> crate::model::channel_summary::Builder {
        crate::model::channel_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelPrivacy {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelPrivacy {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => ChannelPrivacy::Private,
            "PUBLIC" => ChannelPrivacy::Public,
            other => ChannelPrivacy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelPrivacy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelPrivacy::from(s))
    }
}
impl ChannelPrivacy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelPrivacy::Private => "PRIVATE",
            ChannelPrivacy::Public => "PUBLIC",
            ChannelPrivacy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for ChannelPrivacy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of details of a channel associated with channel flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelAssociatedWithFlowSummary {
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The mode of the channel.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The channel's privacy setting.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The channel's metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelAssociatedWithFlowSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelAssociatedWithFlowSummary");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ChannelAssociatedWithFlowSummary`](crate::model::ChannelAssociatedWithFlowSummary)
pub mod channel_associated_with_flow_summary {
    /// A builder for [`ChannelAssociatedWithFlowSummary`](crate::model::ChannelAssociatedWithFlowSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelAssociatedWithFlowSummary`](crate::model::ChannelAssociatedWithFlowSummary)
        pub fn build(self) -> crate::model::ChannelAssociatedWithFlowSummary {
            crate::model::ChannelAssociatedWithFlowSummary {
                name: self.name,
                channel_arn: self.channel_arn,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
            }
        }
    }
}
impl ChannelAssociatedWithFlowSummary {
    /// Creates a new builder-style object to manufacture [`ChannelAssociatedWithFlowSummary`](crate::model::ChannelAssociatedWithFlowSummary)
    pub fn builder() -> crate::model::channel_associated_with_flow_summary::Builder {
        crate::model::channel_associated_with_flow_summary::Builder::default()
    }
}

/// <p>Summary of the details of a <code>ChannelModerator</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModeratorSummary {
    /// <p>The data for a moderator.</p>
    pub moderator: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for ChannelModeratorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModeratorSummary");
        formatter.field("moderator", &self.moderator);
        formatter.finish()
    }
}
/// See [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
pub mod channel_moderator_summary {
    /// A builder for [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) moderator: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The data for a moderator.</p>
        pub fn moderator(mut self, input: crate::model::Identity) -> Self {
            self.moderator = Some(input);
            self
        }
        /// <p>The data for a moderator.</p>
        pub fn set_moderator(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.moderator = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
        pub fn build(self) -> crate::model::ChannelModeratorSummary {
            crate::model::ChannelModeratorSummary {
                moderator: self.moderator,
            }
        }
    }
}
impl ChannelModeratorSummary {
    /// Creates a new builder-style object to manufacture [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
    pub fn builder() -> crate::model::channel_moderator_summary::Builder {
        crate::model::channel_moderator_summary::Builder::default()
    }
}

/// <p>The details of a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Identity {
    /// <p>The ARN in an Identity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name in an Identity.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Identity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Identity");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Identity`](crate::model::Identity)
pub mod identity {
    /// A builder for [`Identity`](crate::model::Identity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN in an Identity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN in an Identity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Identity`](crate::model::Identity)
        pub fn build(self) -> crate::model::Identity {
            crate::model::Identity {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl Identity {
    /// Creates a new builder-style object to manufacture [`Identity`](crate::model::Identity)
    pub fn builder() -> crate::model::identity::Builder {
        crate::model::identity::Builder::default()
    }
}

/// <p>Summary of the messages in a <code>Channel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessageSummary {
    /// <p>The ID of the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The content of the message.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The metadata of the message.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The type of message.</p>
    pub r#type: std::option::Option<crate::model::ChannelMessageType>,
    /// <p>The time at which the message summary was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was last edited.</p>
    pub last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message sender.</p>
    pub sender: std::option::Option<crate::model::Identity>,
    /// <p>Indicates whether a message was redacted.</p>
    pub redacted: bool,
    /// <p>The message status. The status value is <code>SENT</code> for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the
    /// processing stage.</p>
    pub status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
}
impl std::fmt::Debug for ChannelMessageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessageSummary");
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("last_edited_timestamp", &self.last_edited_timestamp);
        formatter.field("sender", &self.sender);
        formatter.field("redacted", &self.redacted);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
pub mod channel_message_summary {
    /// A builder for [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMessageType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sender: std::option::Option<crate::model::Identity>,
        pub(crate) redacted: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
    }
    impl Builder {
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The metadata of the message.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The type of message.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of message.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which the message summary was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the message summary was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a message was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The time at which a message was last edited.</p>
        pub fn last_edited_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_edited_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last edited.</p>
        pub fn set_last_edited_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_edited_timestamp = input;
            self
        }
        /// <p>The message sender.</p>
        pub fn sender(mut self, input: crate::model::Identity) -> Self {
            self.sender = Some(input);
            self
        }
        /// <p>The message sender.</p>
        pub fn set_sender(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.sender = input;
            self
        }
        /// <p>Indicates whether a message was redacted.</p>
        pub fn redacted(mut self, input: bool) -> Self {
            self.redacted = Some(input);
            self
        }
        /// <p>Indicates whether a message was redacted.</p>
        pub fn set_redacted(mut self, input: std::option::Option<bool>) -> Self {
            self.redacted = input;
            self
        }
        /// <p>The message status. The status value is <code>SENT</code> for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the
        /// processing stage.</p>
        pub fn status(mut self, input: crate::model::ChannelMessageStatusStructure) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The message status. The status value is <code>SENT</code> for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the
        /// processing stage.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatusStructure>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
        pub fn build(self) -> crate::model::ChannelMessageSummary {
            crate::model::ChannelMessageSummary {
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
                r#type: self.r#type,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                last_edited_timestamp: self.last_edited_timestamp,
                sender: self.sender,
                redacted: self.redacted.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl ChannelMessageSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
    pub fn builder() -> crate::model::channel_message_summary::Builder {
        crate::model::channel_message_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembershipForAppInstanceUserSummary {
    /// <p>Returns the channel data for an <code>AppInstance</code>.</p>
    pub channel_summary: std::option::Option<crate::model::ChannelSummary>,
    /// <p>Returns the channel membership data for an <code>AppInstance</code>.</p>
    pub app_instance_user_membership_summary:
        std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
}
impl std::fmt::Debug for ChannelMembershipForAppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembershipForAppInstanceUserSummary");
        formatter.field("channel_summary", &self.channel_summary);
        formatter.field(
            "app_instance_user_membership_summary",
            &self.app_instance_user_membership_summary,
        );
        formatter.finish()
    }
}
/// See [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
pub mod channel_membership_for_app_instance_user_summary {
    /// A builder for [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_summary: std::option::Option<crate::model::ChannelSummary>,
        pub(crate) app_instance_user_membership_summary:
            std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
    }
    impl Builder {
        /// <p>Returns the channel data for an <code>AppInstance</code>.</p>
        pub fn channel_summary(mut self, input: crate::model::ChannelSummary) -> Self {
            self.channel_summary = Some(input);
            self
        }
        /// <p>Returns the channel data for an <code>AppInstance</code>.</p>
        pub fn set_channel_summary(
            mut self,
            input: std::option::Option<crate::model::ChannelSummary>,
        ) -> Self {
            self.channel_summary = input;
            self
        }
        /// <p>Returns the channel membership data for an <code>AppInstance</code>.</p>
        pub fn app_instance_user_membership_summary(
            mut self,
            input: crate::model::AppInstanceUserMembershipSummary,
        ) -> Self {
            self.app_instance_user_membership_summary = Some(input);
            self
        }
        /// <p>Returns the channel membership data for an <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_membership_summary(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
        ) -> Self {
            self.app_instance_user_membership_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
        pub fn build(self) -> crate::model::ChannelMembershipForAppInstanceUserSummary {
            crate::model::ChannelMembershipForAppInstanceUserSummary {
                channel_summary: self.channel_summary,
                app_instance_user_membership_summary: self.app_instance_user_membership_summary,
            }
        }
    }
}
impl ChannelMembershipForAppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
    pub fn builder() -> crate::model::channel_membership_for_app_instance_user_summary::Builder {
        crate::model::channel_membership_for_app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserMembershipSummary {
    /// <p>The type of <code>ChannelMembership</code>.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The time at which a message was last read.</p>
    pub read_marker_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AppInstanceUserMembershipSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserMembershipSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("read_marker_timestamp", &self.read_marker_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
pub mod app_instance_user_membership_summary {
    /// A builder for [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) read_marker_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of <code>ChannelMembership</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of <code>ChannelMembership</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which a message was last read.</p>
        pub fn read_marker_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.read_marker_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last read.</p>
        pub fn set_read_marker_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.read_marker_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
        pub fn build(self) -> crate::model::AppInstanceUserMembershipSummary {
            crate::model::AppInstanceUserMembershipSummary {
                r#type: self.r#type,
                read_marker_timestamp: self.read_marker_timestamp,
            }
        }
    }
}
impl AppInstanceUserMembershipSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
    pub fn builder() -> crate::model::app_instance_user_membership_summary::Builder {
        crate::model::app_instance_user_membership_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMembershipType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Hidden,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMembershipType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ChannelMembershipType::Default,
            "HIDDEN" => ChannelMembershipType::Hidden,
            other => ChannelMembershipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMembershipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMembershipType::from(s))
    }
}
impl ChannelMembershipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMembershipType::Default => "DEFAULT",
            ChannelMembershipType::Hidden => "HIDDEN",
            ChannelMembershipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "HIDDEN"]
    }
}
impl AsRef<str> for ChannelMembershipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the details of a <code>ChannelMembership</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembershipSummary {
    /// <p>A member's summary data.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for ChannelMembershipSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembershipSummary");
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
pub mod channel_membership_summary {
    /// A builder for [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>A member's summary data.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>A member's summary data.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
        pub fn build(self) -> crate::model::ChannelMembershipSummary {
            crate::model::ChannelMembershipSummary {
                member: self.member,
            }
        }
    }
}
impl ChannelMembershipSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
    pub fn builder() -> crate::model::channel_membership_summary::Builder {
        crate::model::channel_membership_summary::Builder::default()
    }
}

/// <p>Summary of details of a channel flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelFlowSummary {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Information about the processor Lambda functions.</p>
    pub processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
}
impl std::fmt::Debug for ChannelFlowSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelFlowSummary");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("processors", &self.processors);
        formatter.finish()
    }
}
/// See [`ChannelFlowSummary`](crate::model::ChannelFlowSummary)
pub mod channel_flow_summary {
    /// A builder for [`ChannelFlowSummary`](crate::model::ChannelFlowSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions.</p>
        pub fn processors(mut self, input: impl Into<crate::model::Processor>) -> Self {
            let mut v = self.processors.unwrap_or_default();
            v.push(input.into());
            self.processors = Some(v);
            self
        }
        /// <p>Information about the processor Lambda functions.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.processors = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelFlowSummary`](crate::model::ChannelFlowSummary)
        pub fn build(self) -> crate::model::ChannelFlowSummary {
            crate::model::ChannelFlowSummary {
                channel_flow_arn: self.channel_flow_arn,
                name: self.name,
                processors: self.processors,
            }
        }
    }
}
impl ChannelFlowSummary {
    /// Creates a new builder-style object to manufacture [`ChannelFlowSummary`](crate::model::ChannelFlowSummary)
    pub fn builder() -> crate::model::channel_flow_summary::Builder {
        crate::model::channel_flow_summary::Builder::default()
    }
}

/// <p>Summary of the details of a <code>ChannelBan</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelBanSummary {
    /// <p>The member being banned from a channel.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for ChannelBanSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelBanSummary");
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`ChannelBanSummary`](crate::model::ChannelBanSummary)
pub mod channel_ban_summary {
    /// A builder for [`ChannelBanSummary`](crate::model::ChannelBanSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The member being banned from a channel.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The member being banned from a channel.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelBanSummary`](crate::model::ChannelBanSummary)
        pub fn build(self) -> crate::model::ChannelBanSummary {
            crate::model::ChannelBanSummary {
                member: self.member,
            }
        }
    }
}
impl ChannelBanSummary {
    /// Creates a new builder-style object to manufacture [`ChannelBanSummary`](crate::model::ChannelBanSummary)
    pub fn builder() -> crate::model::channel_ban_summary::Builder {
        crate::model::channel_ban_summary::Builder::default()
    }
}

/// <p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessagingSessionEndpoint {
    /// <p>The endpoint to which you establish a websocket connection.</p>
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MessagingSessionEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessagingSessionEndpoint");
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
pub mod messaging_session_endpoint {
    /// A builder for [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint to which you establish a websocket connection.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The endpoint to which you establish a websocket connection.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
        pub fn build(self) -> crate::model::MessagingSessionEndpoint {
            crate::model::MessagingSessionEndpoint { url: self.url }
        }
    }
}
impl MessagingSessionEndpoint {
    /// Creates a new builder-style object to manufacture [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
    pub fn builder() -> crate::model::messaging_session_endpoint::Builder {
        crate::model::messaging_session_endpoint::Builder::default()
    }
}

/// <p>The details of a message in a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessage {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of a message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The message content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The message metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The message type.</p>
    pub r#type: std::option::Option<crate::model::ChannelMessageType>,
    /// <p>The time at which the message was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was edited.</p>
    pub last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message sender.</p>
    pub sender: std::option::Option<crate::model::Identity>,
    /// <p>Hides the content of a message.</p>
    pub redacted: bool,
    /// <p>The persistence setting for a channel message.</p>
    pub persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
    /// <p>The status of the channel message.</p>
    pub status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
}
impl std::fmt::Debug for ChannelMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessage");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_edited_timestamp", &self.last_edited_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("sender", &self.sender);
        formatter.field("redacted", &self.redacted);
        formatter.field("persistence", &self.persistence);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ChannelMessage`](crate::model::ChannelMessage)
pub mod channel_message {
    /// A builder for [`ChannelMessage`](crate::model::ChannelMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMessageType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sender: std::option::Option<crate::model::Identity>,
        pub(crate) redacted: std::option::Option<bool>,
        pub(crate) persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        pub(crate) status: std::option::Option<crate::model::ChannelMessageStatusStructure>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of a message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of a message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The message content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The message content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The message metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The message metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The message type.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The message type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which the message was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the message was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a message was edited.</p>
        pub fn last_edited_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_edited_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was edited.</p>
        pub fn set_last_edited_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_edited_timestamp = input;
            self
        }
        /// <p>The time at which a message was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The message sender.</p>
        pub fn sender(mut self, input: crate::model::Identity) -> Self {
            self.sender = Some(input);
            self
        }
        /// <p>The message sender.</p>
        pub fn set_sender(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.sender = input;
            self
        }
        /// <p>Hides the content of a message.</p>
        pub fn redacted(mut self, input: bool) -> Self {
            self.redacted = Some(input);
            self
        }
        /// <p>Hides the content of a message.</p>
        pub fn set_redacted(mut self, input: std::option::Option<bool>) -> Self {
            self.redacted = input;
            self
        }
        /// <p>The persistence setting for a channel message.</p>
        pub fn persistence(mut self, input: crate::model::ChannelMessagePersistenceType) -> Self {
            self.persistence = Some(input);
            self
        }
        /// <p>The persistence setting for a channel message.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.persistence = input;
            self
        }
        /// <p>The status of the channel message.</p>
        pub fn status(mut self, input: crate::model::ChannelMessageStatusStructure) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the channel message.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageStatusStructure>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessage`](crate::model::ChannelMessage)
        pub fn build(self) -> crate::model::ChannelMessage {
            crate::model::ChannelMessage {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
                r#type: self.r#type,
                created_timestamp: self.created_timestamp,
                last_edited_timestamp: self.last_edited_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                sender: self.sender,
                redacted: self.redacted.unwrap_or_default(),
                persistence: self.persistence,
                status: self.status,
            }
        }
    }
}
impl ChannelMessage {
    /// Creates a new builder-style object to manufacture [`ChannelMessage`](crate::model::ChannelMessage)
    pub fn builder() -> crate::model::channel_message::Builder {
        crate::model::channel_message::Builder::default()
    }
}

/// <p>The details of a channel moderator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModerator {
    /// <p>The moderator's data.</p>
    pub moderator: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the moderator's channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the moderator was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for ChannelModerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModerator");
        formatter.field("moderator", &self.moderator);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ChannelModerator`](crate::model::ChannelModerator)
pub mod channel_moderator {
    /// A builder for [`ChannelModerator`](crate::model::ChannelModerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) moderator: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The moderator's data.</p>
        pub fn moderator(mut self, input: crate::model::Identity) -> Self {
            self.moderator = Some(input);
            self
        }
        /// <p>The moderator's data.</p>
        pub fn set_moderator(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.moderator = input;
            self
        }
        /// <p>The ARN of the moderator's channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderator's channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the moderator was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the moderator was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModerator`](crate::model::ChannelModerator)
        pub fn build(self) -> crate::model::ChannelModerator {
            crate::model::ChannelModerator {
                moderator: self.moderator,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                created_by: self.created_by,
            }
        }
    }
}
impl ChannelModerator {
    /// Creates a new builder-style object to manufacture [`ChannelModerator`](crate::model::ChannelModerator)
    pub fn builder() -> crate::model::channel_moderator::Builder {
        crate::model::channel_moderator::Builder::default()
    }
}

/// <p>The details of a channel member.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembership {
    /// <p>The identifier of the member who invited another member.</p>
    pub invited_by: std::option::Option<crate::model::Identity>,
    /// <p>The membership type set for the channel member.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The data of the channel member.</p>
    pub member: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the member's channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the channel membership was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a channel membership was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ChannelMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembership");
        formatter.field("invited_by", &self.invited_by);
        formatter.field("r#type", &self.r#type);
        formatter.field("member", &self.member);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`ChannelMembership`](crate::model::ChannelMembership)
pub mod channel_membership {
    /// A builder for [`ChannelMembership`](crate::model::ChannelMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invited_by: std::option::Option<crate::model::Identity>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) member: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the member who invited another member.</p>
        pub fn invited_by(mut self, input: crate::model::Identity) -> Self {
            self.invited_by = Some(input);
            self
        }
        /// <p>The identifier of the member who invited another member.</p>
        pub fn set_invited_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.invited_by = input;
            self
        }
        /// <p>The membership type set for the channel member.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type set for the channel member.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data of the channel member.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The data of the channel member.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// <p>The ARN of the member's channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member's channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the channel membership was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the channel membership was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a channel membership was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a channel membership was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembership`](crate::model::ChannelMembership)
        pub fn build(self) -> crate::model::ChannelMembership {
            crate::model::ChannelMembership {
                invited_by: self.invited_by,
                r#type: self.r#type,
                member: self.member,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl ChannelMembership {
    /// Creates a new builder-style object to manufacture [`ChannelMembership`](crate::model::ChannelMembership)
    pub fn builder() -> crate::model::channel_membership::Builder {
        crate::model::channel_membership::Builder::default()
    }
}

/// <p>The details of a channel flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelFlow {
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
    /// <p>Information about the processor Lambda functions.</p>
    pub processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
    /// <p>The name of the channel flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time at which the channel flow was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a channel flow was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ChannelFlow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelFlow");
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.field("processors", &self.processors);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`ChannelFlow`](crate::model::ChannelFlow)
pub mod channel_flow {
    /// A builder for [`ChannelFlow`](crate::model::ChannelFlow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
        pub(crate) processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Appends an item to `processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>Information about the processor Lambda functions.</p>
        pub fn processors(mut self, input: impl Into<crate::model::Processor>) -> Self {
            let mut v = self.processors.unwrap_or_default();
            v.push(input.into());
            self.processors = Some(v);
            self
        }
        /// <p>Information about the processor Lambda functions.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.processors = input;
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time at which the channel flow was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the channel flow was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a channel flow was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a channel flow was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelFlow`](crate::model::ChannelFlow)
        pub fn build(self) -> crate::model::ChannelFlow {
            crate::model::ChannelFlow {
                channel_flow_arn: self.channel_flow_arn,
                processors: self.processors,
                name: self.name,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl ChannelFlow {
    /// Creates a new builder-style object to manufacture [`ChannelFlow`](crate::model::ChannelFlow)
    pub fn builder() -> crate::model::channel_flow::Builder {
        crate::model::channel_flow::Builder::default()
    }
}

/// <p>The details of a channel ban.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelBan {
    /// <p>The member being banned from the channel.</p>
    pub member: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the channel from which a member is being banned.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the ban was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
}
impl std::fmt::Debug for ChannelBan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelBan");
        formatter.field("member", &self.member);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ChannelBan`](crate::model::ChannelBan)
pub mod channel_ban {
    /// A builder for [`ChannelBan`](crate::model::ChannelBan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The member being banned from the channel.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The member being banned from the channel.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// <p>The ARN of the channel from which a member is being banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which a member is being banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the ban was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the ban was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelBan`](crate::model::ChannelBan)
        pub fn build(self) -> crate::model::ChannelBan {
            crate::model::ChannelBan {
                member: self.member,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                created_by: self.created_by,
            }
        }
    }
}
impl ChannelBan {
    /// Creates a new builder-style object to manufacture [`ChannelBan`](crate::model::ChannelBan)
    pub fn builder() -> crate::model::channel_ban::Builder {
        crate::model::channel_ban::Builder::default()
    }
}

/// <p>The details of a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// <p>The name of a channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of a channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The mode of the channel.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The channel's privacy setting.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The channel's metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
    /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a member sent the last message in the channel.</p>
    pub last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a channel was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the channel flow.</p>
    pub channel_flow_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("created_by", &self.created_by);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_message_timestamp", &self.last_message_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("channel_flow_arn", &self.channel_flow_arn);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) channel_flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of a channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a member sent the last message in the channel.</p>
        pub fn last_message_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_message_timestamp = Some(input);
            self
        }
        /// <p>The time at which a member sent the last message in the channel.</p>
        pub fn set_last_message_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_message_timestamp = input;
            self
        }
        /// <p>The time at which a channel was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a channel was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn channel_flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_flow_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel flow.</p>
        pub fn set_channel_flow_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                name: self.name,
                channel_arn: self.channel_arn,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                created_by: self.created_by,
                created_timestamp: self.created_timestamp,
                last_message_timestamp: self.last_message_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                channel_flow_arn: self.channel_flow_arn,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

/// <p>Stores information about a callback.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessageCallback {
    /// <p>The message ID.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The message content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The message metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelMessageCallback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessageCallback");
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ChannelMessageCallback`](crate::model::ChannelMessageCallback)
pub mod channel_message_callback {
    /// A builder for [`ChannelMessageCallback`](crate::model::ChannelMessageCallback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message ID.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The message ID.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The message content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The message content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The message metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The message metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessageCallback`](crate::model::ChannelMessageCallback)
        pub fn build(self) -> crate::model::ChannelMessageCallback {
            crate::model::ChannelMessageCallback {
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
            }
        }
    }
}
impl ChannelMessageCallback {
    /// Creates a new builder-style object to manufacture [`ChannelMessageCallback`](crate::model::ChannelMessageCallback)
    pub fn builder() -> crate::model::channel_message_callback::Builder {
        crate::model::channel_message_callback::Builder::default()
    }
}

/// <p>A list of failed member ARNs, error codes, and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateChannelMembershipError {
    /// <p>The ARN of the member that the service couldn't add.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchCreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateChannelMembershipError");
        formatter.field("member_arn", &self.member_arn);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
pub mod batch_create_channel_membership_error {
    /// A builder for [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the member that the service couldn't add.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member that the service couldn't add.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
        pub fn build(self) -> crate::model::BatchCreateChannelMembershipError {
            crate::model::BatchCreateChannelMembershipError {
                member_arn: self.member_arn,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchCreateChannelMembershipError {
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
    pub fn builder() -> crate::model::batch_create_channel_membership_error::Builder {
        crate::model::batch_create_channel_membership_error::Builder::default()
    }
}

/// <p>The membership information, including member ARNs, the channel ARN, and membership
/// types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchChannelMemberships {
    /// <p>The identifier of the member who invited another member.</p>
    pub invited_by: std::option::Option<crate::model::Identity>,
    /// <p>The membership types set for the channel users.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The users successfully added to the request.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::Identity>>,
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchChannelMemberships {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchChannelMemberships");
        formatter.field("invited_by", &self.invited_by);
        formatter.field("r#type", &self.r#type);
        formatter.field("members", &self.members);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}
/// See [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
pub mod batch_channel_memberships {
    /// A builder for [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invited_by: std::option::Option<crate::model::Identity>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) members: std::option::Option<std::vec::Vec<crate::model::Identity>>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the member who invited another member.</p>
        pub fn invited_by(mut self, input: crate::model::Identity) -> Self {
            self.invited_by = Some(input);
            self
        }
        /// <p>The identifier of the member who invited another member.</p>
        pub fn set_invited_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.invited_by = input;
            self
        }
        /// <p>The membership types set for the channel users.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership types set for the channel users.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The users successfully added to the request.</p>
        pub fn members(mut self, input: impl Into<crate::model::Identity>) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input.into());
            self.members = Some(v);
            self
        }
        /// <p>The users successfully added to the request.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Identity>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
        pub fn build(self) -> crate::model::BatchChannelMemberships {
            crate::model::BatchChannelMemberships {
                invited_by: self.invited_by,
                r#type: self.r#type,
                members: self.members,
                channel_arn: self.channel_arn,
            }
        }
    }
}
impl BatchChannelMemberships {
    /// Creates a new builder-style object to manufacture [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
    pub fn builder() -> crate::model::batch_channel_memberships::Builder {
        crate::model::batch_channel_memberships::Builder::default()
    }
}
