// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateChannelFlowError {
    /// Kind of error that occurred.
    pub kind: AssociateChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            AssociateChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateChannelFlowError {
    fn code(&self) -> Option<&str> {
        AssociateChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateChannelFlowError {
    /// Creates a new `AssociateChannelFlowError`.
    pub fn new(kind: AssociateChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `AssociateChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for AssociateChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            AssociateChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchCreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: BatchCreateChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateChannelMembershipError {
    fn code(&self) -> Option<&str> {
        BatchCreateChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateChannelMembershipError {
    /// Creates a new `BatchCreateChannelMembershipError`.
    pub fn new(kind: BatchCreateChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchCreateChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            BatchCreateChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChannelFlowCallback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChannelFlowCallbackError {
    /// Kind of error that occurred.
    pub kind: ChannelFlowCallbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChannelFlowCallback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChannelFlowCallbackErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChannelFlowCallbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChannelFlowCallbackErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ChannelFlowCallbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChannelFlowCallbackError {
    fn code(&self) -> Option<&str> {
        ChannelFlowCallbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChannelFlowCallbackError {
    /// Creates a new `ChannelFlowCallbackError`.
    pub fn new(kind: ChannelFlowCallbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChannelFlowCallbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChannelFlowCallbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChannelFlowCallbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChannelFlowCallbackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ChannelFlowCallbackErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChannelFlowCallbackErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ChannelFlowCallbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChannelFlowCallbackErrorKind::BadRequestException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::ConflictException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::ForbiddenException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ChannelFlowCallbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelError {
    /// Kind of error that occurred.
    pub kind: CreateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelError {
    fn code(&self) -> Option<&str> {
        CreateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelError {
    /// Creates a new `CreateChannelError`.
    pub fn new(kind: CreateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelBanError {
    /// Kind of error that occurred.
    pub kind: CreateChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelBanError {
    fn code(&self) -> Option<&str> {
        CreateChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelBanError {
    /// Creates a new `CreateChannelBanError`.
    pub fn new(kind: CreateChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelBanErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelBanErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelFlowError {
    /// Kind of error that occurred.
    pub kind: CreateChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelFlowError {
    fn code(&self) -> Option<&str> {
        CreateChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelFlowError {
    /// Creates a new `CreateChannelFlowError`.
    pub fn new(kind: CreateChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelFlowErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelMembershipError {
    fn code(&self) -> Option<&str> {
        CreateChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelMembershipError {
    /// Creates a new `CreateChannelMembershipError`.
    pub fn new(kind: CreateChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: CreateChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelModeratorError {
    fn code(&self) -> Option<&str> {
        CreateChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelModeratorError {
    /// Creates a new `CreateChannelModeratorError`.
    pub fn new(kind: CreateChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelError {
    fn code(&self) -> Option<&str> {
        DeleteChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelError {
    /// Creates a new `DeleteChannelError`.
    pub fn new(kind: DeleteChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelBanError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelBanError {
    fn code(&self) -> Option<&str> {
        DeleteChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelBanError {
    /// Creates a new `DeleteChannelBanError`.
    pub fn new(kind: DeleteChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelBanErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelFlowError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelFlowError {
    fn code(&self) -> Option<&str> {
        DeleteChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelFlowError {
    /// Creates a new `DeleteChannelFlowError`.
    pub fn new(kind: DeleteChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelFlowErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelMembershipError {
    /// Creates a new `DeleteChannelMembershipError`.
    pub fn new(kind: DeleteChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelMessageError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelMessageError {
    fn code(&self) -> Option<&str> {
        DeleteChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelMessageError {
    /// Creates a new `DeleteChannelMessageError`.
    pub fn new(kind: DeleteChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelModeratorError {
    fn code(&self) -> Option<&str> {
        DeleteChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelModeratorError {
    /// Creates a new `DeleteChannelModeratorError`.
    pub fn new(kind: DeleteChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelError {
    fn code(&self) -> Option<&str> {
        DescribeChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelError {
    /// Creates a new `DescribeChannelError`.
    pub fn new(kind: DescribeChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelBanError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelBanError {
    fn code(&self) -> Option<&str> {
        DescribeChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelBanError {
    /// Creates a new `DescribeChannelBanError`.
    pub fn new(kind: DescribeChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelFlowError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelFlowError {
    fn code(&self) -> Option<&str> {
        DescribeChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelFlowError {
    /// Creates a new `DescribeChannelFlowError`.
    pub fn new(kind: DescribeChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelMembershipError {
    fn code(&self) -> Option<&str> {
        DescribeChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelMembershipError {
    /// Creates a new `DescribeChannelMembershipError`.
    pub fn new(kind: DescribeChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelMembershipForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelMembershipForAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelMembershipForAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelMembershipForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelMembershipForAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelMembershipForAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeChannelMembershipForAppInstanceUserError
{
    fn code(&self) -> Option<&str> {
        DescribeChannelMembershipForAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelMembershipForAppInstanceUserError {
    /// Creates a new `DescribeChannelMembershipForAppInstanceUserError`.
    pub fn new(
        kind: DescribeChannelMembershipForAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelMembershipForAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelMembershipForAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelMembershipForAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeChannelModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelModeratedByAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelModeratedByAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelModeratedByAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelModeratedByAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelModeratedByAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        DescribeChannelModeratedByAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelModeratedByAppInstanceUserError {
    /// Creates a new `DescribeChannelModeratedByAppInstanceUserError`.
    pub fn new(
        kind: DescribeChannelModeratedByAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelModeratedByAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelModeratedByAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelModeratedByAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelModeratorError {
    fn code(&self) -> Option<&str> {
        DescribeChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelModeratorError {
    /// Creates a new `DescribeChannelModeratorError`.
    pub fn new(kind: DescribeChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateChannelFlowError {
    /// Kind of error that occurred.
    pub kind: DisassociateChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DisassociateChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateChannelFlowError {
    fn code(&self) -> Option<&str> {
        DisassociateChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateChannelFlowError {
    /// Creates a new `DisassociateChannelFlowError`.
    pub fn new(kind: DisassociateChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DisassociateChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DisassociateChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChannelMessageError {
    /// Kind of error that occurred.
    pub kind: GetChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChannelMessageError {
    fn code(&self) -> Option<&str> {
        GetChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChannelMessageError {
    /// Creates a new `GetChannelMessageError`.
    pub fn new(kind: GetChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetChannelMessageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::NotFoundException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChannelMessageStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChannelMessageStatusError {
    /// Kind of error that occurred.
    pub kind: GetChannelMessageStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChannelMessageStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChannelMessageStatusErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChannelMessageStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChannelMessageStatusErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetChannelMessageStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChannelMessageStatusError {
    fn code(&self) -> Option<&str> {
        GetChannelMessageStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChannelMessageStatusError {
    /// Creates a new `GetChannelMessageStatusError`.
    pub fn new(kind: GetChannelMessageStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChannelMessageStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChannelMessageStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChannelMessageStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChannelMessageStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelMessageStatusErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageStatusErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetChannelMessageStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChannelMessageStatusErrorKind::BadRequestException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetChannelMessageStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMessagingSessionEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMessagingSessionEndpointError {
    /// Kind of error that occurred.
    pub kind: GetMessagingSessionEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMessagingSessionEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMessagingSessionEndpointErrorKind {
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMessagingSessionEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetMessagingSessionEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMessagingSessionEndpointError {
    fn code(&self) -> Option<&str> {
        GetMessagingSessionEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMessagingSessionEndpointError {
    /// Creates a new `GetMessagingSessionEndpointError`.
    pub fn new(kind: GetMessagingSessionEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMessagingSessionEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMessagingSessionEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMessagingSessionEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMessagingSessionEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMessagingSessionEndpointErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetMessagingSessionEndpointErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetMessagingSessionEndpointErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetMessagingSessionEndpointErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `GetMessagingSessionEndpointErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetMessagingSessionEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetMessagingSessionEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelBans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelBansError {
    /// Kind of error that occurred.
    pub kind: ListChannelBansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelBans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelBansErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelBansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelBansErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelBansError {
    fn code(&self) -> Option<&str> {
        ListChannelBansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelBansError {
    /// Creates a new `ListChannelBansError`.
    pub fn new(kind: ListChannelBansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelBansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelBansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelBansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelBansErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListChannelBansErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelBansErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelBansErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelBansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelBansErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelBansErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelBansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelFlowsError {
    /// Kind of error that occurred.
    pub kind: ListChannelFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelFlowsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelFlowsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelFlowsError {
    fn code(&self) -> Option<&str> {
        ListChannelFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelFlowsError {
    /// Creates a new `ListChannelFlowsError`.
    pub fn new(kind: ListChannelFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelFlowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelFlowsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelFlowsErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelFlowsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelFlowsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelFlowsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelFlowsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelFlowsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelFlowsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMembershipsError {
    /// Kind of error that occurred.
    pub kind: ListChannelMembershipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMembershipsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMembershipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMembershipsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMembershipsError {
    fn code(&self) -> Option<&str> {
        ListChannelMembershipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMembershipsError {
    /// Creates a new `ListChannelMembershipsError`.
    pub fn new(kind: ListChannelMembershipsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMembershipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMembershipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMembershipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMembershipsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMembershipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMembershipsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelMembershipsForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMembershipsForAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: ListChannelMembershipsForAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMembershipsForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMembershipsForAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMembershipsForAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMembershipsForAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        ListChannelMembershipsForAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMembershipsForAppInstanceUserError {
    /// Creates a new `ListChannelMembershipsForAppInstanceUserError`.
    pub fn new(
        kind: ListChannelMembershipsForAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMembershipsForAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMembershipsForAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMembershipsForAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListChannelMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMessagesError {
    /// Kind of error that occurred.
    pub kind: ListChannelMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMessagesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMessagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMessagesError {
    fn code(&self) -> Option<&str> {
        ListChannelMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMessagesError {
    /// Creates a new `ListChannelMessagesError`.
    pub fn new(kind: ListChannelMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMessagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelMessagesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMessagesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelModerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelModeratorsError {
    /// Kind of error that occurred.
    pub kind: ListChannelModeratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelModerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelModeratorsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelModeratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelModeratorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelModeratorsError {
    fn code(&self) -> Option<&str> {
        ListChannelModeratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelModeratorsError {
    /// Creates a new `ListChannelModeratorsError`.
    pub fn new(kind: ListChannelModeratorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelModeratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelModeratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelModeratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelModeratorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelModeratorsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelModeratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelModeratorsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsError {
    /// Kind of error that occurred.
    pub kind: ListChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsError {
    fn code(&self) -> Option<&str> {
        ListChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsError {
    /// Creates a new `ListChannelsError`.
    pub fn new(kind: ListChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelsAssociatedWithChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsAssociatedWithChannelFlowError {
    /// Kind of error that occurred.
    pub kind: ListChannelsAssociatedWithChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelsAssociatedWithChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsAssociatedWithChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsAssociatedWithChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsAssociatedWithChannelFlowError {
    fn code(&self) -> Option<&str> {
        ListChannelsAssociatedWithChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsAssociatedWithChannelFlowError {
    /// Creates a new `ListChannelsAssociatedWithChannelFlowError`.
    pub fn new(
        kind: ListChannelsAssociatedWithChannelFlowErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsAssociatedWithChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsAssociatedWithChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsAssociatedWithChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsAssociatedWithChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelsAssociatedWithChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsAssociatedWithChannelFlowErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            ListChannelsAssociatedWithChannelFlowErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListChannelsModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsModeratedByAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: ListChannelsModeratedByAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelsModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsModeratedByAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsModeratedByAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsModeratedByAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        ListChannelsModeratedByAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsModeratedByAppInstanceUserError {
    /// Creates a new `ListChannelsModeratedByAppInstanceUserError`.
    pub fn new(
        kind: ListChannelsModeratedByAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsModeratedByAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsModeratedByAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelsModeratedByAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RedactChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RedactChannelMessageError {
    /// Kind of error that occurred.
    pub kind: RedactChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RedactChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RedactChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RedactChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RedactChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            RedactChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RedactChannelMessageError {
    fn code(&self) -> Option<&str> {
        RedactChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RedactChannelMessageError {
    /// Creates a new `RedactChannelMessageError`.
    pub fn new(kind: RedactChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RedactChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RedactChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RedactChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RedactChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `RedactChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RedactChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for RedactChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RedactChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            RedactChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendChannelMessageError {
    /// Kind of error that occurred.
    pub kind: SendChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            SendChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendChannelMessageError {
    fn code(&self) -> Option<&str> {
        SendChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendChannelMessageError {
    /// Creates a new `SendChannelMessageError`.
    pub fn new(kind: SendChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `SendChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for SendChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::ConflictException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            SendChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServiceFailureException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            TagResourceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            UntagResourceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelError {
    fn code(&self) -> Option<&str> {
        UpdateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelError {
    /// Creates a new `UpdateChannelError`.
    pub fn new(kind: UpdateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for UpdateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            UpdateChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            UpdateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelFlowError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannelFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelFlowErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            UpdateChannelFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelFlowError {
    fn code(&self) -> Option<&str> {
        UpdateChannelFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelFlowError {
    /// Creates a new `UpdateChannelFlowError`.
    pub fn new(kind: UpdateChannelFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelFlowErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelFlowErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelFlowErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for UpdateChannelFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::ThrottledClientException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            UpdateChannelFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelMessageError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            UpdateChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelMessageError {
    fn code(&self) -> Option<&str> {
        UpdateChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelMessageError {
    /// Creates a new `UpdateChannelMessageError`.
    pub fn new(kind: UpdateChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for UpdateChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            UpdateChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannelReadMarker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelReadMarkerError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelReadMarkerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannelReadMarker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelReadMarkerErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the
    /// resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelReadMarkerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelReadMarkerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            UpdateChannelReadMarkerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelReadMarkerError {
    fn code(&self) -> Option<&str> {
        UpdateChannelReadMarkerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelReadMarkerError {
    /// Creates a new `UpdateChannelReadMarkerError`.
    pub fn new(kind: UpdateChannelReadMarkerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelReadMarkerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelReadMarkerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelReadMarkerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelReadMarkerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelReadMarkerErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelReadMarkerErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for UpdateChannelReadMarkerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelReadMarkerErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::ThrottledClientException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            UpdateChannelReadMarkerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The client is not currently authorized to make the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedClientException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedClientException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedClientException {}
/// See [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
pub mod unauthorized_client_exception {
    /// A builder for [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
        pub fn build(self) -> crate::error::UnauthorizedClientException {
            crate::error::UnauthorizedClientException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl UnauthorizedClientException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedClientException`](crate::error::UnauthorizedClientException)
    pub fn builder() -> crate::error::unauthorized_client_exception::Builder {
        crate::error::unauthorized_client_exception::Builder::default()
    }
}

/// <p>The client exceeded its request rate limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottledClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottledClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottledClientException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottledClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottledClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottledClientException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottledClientException {}
/// See [`ThrottledClientException`](crate::error::ThrottledClientException)
pub mod throttled_client_exception {
    /// A builder for [`ThrottledClientException`](crate::error::ThrottledClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottledClientException`](crate::error::ThrottledClientException)
        pub fn build(self) -> crate::error::ThrottledClientException {
            crate::error::ThrottledClientException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ThrottledClientException {
    /// Creates a new builder-style object to manufacture [`ThrottledClientException`](crate::error::ThrottledClientException)
    pub fn builder() -> crate::error::throttled_client_exception::Builder {
        crate::error::throttled_client_exception::Builder::default()
    }
}

/// <p>The service is currently unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The service encountered an unexpected error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceFailureException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceFailureException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceFailureException {}
/// See [`ServiceFailureException`](crate::error::ServiceFailureException)
pub mod service_failure_exception {
    /// A builder for [`ServiceFailureException`](crate::error::ServiceFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceFailureException`](crate::error::ServiceFailureException)
        pub fn build(self) -> crate::error::ServiceFailureException {
            crate::error::ServiceFailureException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ServiceFailureException {
    /// Creates a new builder-style object to manufacture [`ServiceFailureException`](crate::error::ServiceFailureException)
    pub fn builder() -> crate::error::service_failure_exception::Builder {
        crate::error::service_failure_exception::Builder::default()
    }
}

/// <p>The client is permanently forbidden from making the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>The request could not be processed because of conflict in the current state of the
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The input parameters don't match the service's restrictions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The request exceeds the resource limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>One or more of the resources in the request does not exist in the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<crate::model::ErrorCode>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}
