// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchCreateAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_attendee`](crate::client::Client::batch_create_attendee).
///
/// See [`crate::client::fluent_builders::BatchCreateAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateAttendee {
    _private: (),
}
impl BatchCreateAttendee {
    /// Creates a new builder-style object to manufacture [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    pub fn builder() -> crate::input::batch_create_attendee_input::Builder {
        crate::input::batch_create_attendee_input::Builder::default()
    }
    /// Creates a new `BatchCreateAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateAttendee {
    type Output = std::result::Result<
        crate::output::BatchCreateAttendeeOutput,
        crate::error::BatchCreateAttendeeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_attendee_error(response)
        } else {
            crate::operation_deser::parse_batch_create_attendee_response(response)
        }
    }
}

/// Operation shape for `CreateAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_attendee`](crate::client::Client::create_attendee).
///
/// See [`crate::client::fluent_builders::CreateAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAttendee {
    _private: (),
}
impl CreateAttendee {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    pub fn builder() -> crate::input::create_attendee_input::Builder {
        crate::input::create_attendee_input::Builder::default()
    }
    /// Creates a new `CreateAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAttendee {
    type Output =
        std::result::Result<crate::output::CreateAttendeeOutput, crate::error::CreateAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_attendee_error(response)
        } else {
            crate::operation_deser::parse_create_attendee_response(response)
        }
    }
}

/// Operation shape for `CreateMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_meeting`](crate::client::Client::create_meeting).
///
/// See [`crate::client::fluent_builders::CreateMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMeeting {
    _private: (),
}
impl CreateMeeting {
    /// Creates a new builder-style object to manufacture [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    pub fn builder() -> crate::input::create_meeting_input::Builder {
        crate::input::create_meeting_input::Builder::default()
    }
    /// Creates a new `CreateMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMeeting {
    type Output =
        std::result::Result<crate::output::CreateMeetingOutput, crate::error::CreateMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_meeting_error(response)
        } else {
            crate::operation_deser::parse_create_meeting_response(response)
        }
    }
}

/// Operation shape for `CreateMeetingWithAttendees`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_meeting_with_attendees`](crate::client::Client::create_meeting_with_attendees).
///
/// See [`crate::client::fluent_builders::CreateMeetingWithAttendees`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMeetingWithAttendees {
    _private: (),
}
impl CreateMeetingWithAttendees {
    /// Creates a new builder-style object to manufacture [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    pub fn builder() -> crate::input::create_meeting_with_attendees_input::Builder {
        crate::input::create_meeting_with_attendees_input::Builder::default()
    }
    /// Creates a new `CreateMeetingWithAttendees` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMeetingWithAttendees {
    type Output = std::result::Result<
        crate::output::CreateMeetingWithAttendeesOutput,
        crate::error::CreateMeetingWithAttendeesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_meeting_with_attendees_error(response)
        } else {
            crate::operation_deser::parse_create_meeting_with_attendees_response(response)
        }
    }
}

/// Operation shape for `DeleteAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_attendee`](crate::client::Client::delete_attendee).
///
/// See [`crate::client::fluent_builders::DeleteAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAttendee {
    _private: (),
}
impl DeleteAttendee {
    /// Creates a new builder-style object to manufacture [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    pub fn builder() -> crate::input::delete_attendee_input::Builder {
        crate::input::delete_attendee_input::Builder::default()
    }
    /// Creates a new `DeleteAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAttendee {
    type Output =
        std::result::Result<crate::output::DeleteAttendeeOutput, crate::error::DeleteAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_attendee_error(response)
        } else {
            crate::operation_deser::parse_delete_attendee_response(response)
        }
    }
}

/// Operation shape for `DeleteMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_meeting`](crate::client::Client::delete_meeting).
///
/// See [`crate::client::fluent_builders::DeleteMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMeeting {
    _private: (),
}
impl DeleteMeeting {
    /// Creates a new builder-style object to manufacture [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    pub fn builder() -> crate::input::delete_meeting_input::Builder {
        crate::input::delete_meeting_input::Builder::default()
    }
    /// Creates a new `DeleteMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMeeting {
    type Output =
        std::result::Result<crate::output::DeleteMeetingOutput, crate::error::DeleteMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_meeting_error(response)
        } else {
            crate::operation_deser::parse_delete_meeting_response(response)
        }
    }
}

/// Operation shape for `GetAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_attendee`](crate::client::Client::get_attendee).
///
/// See [`crate::client::fluent_builders::GetAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAttendee {
    _private: (),
}
impl GetAttendee {
    /// Creates a new builder-style object to manufacture [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    pub fn builder() -> crate::input::get_attendee_input::Builder {
        crate::input::get_attendee_input::Builder::default()
    }
    /// Creates a new `GetAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAttendee {
    type Output =
        std::result::Result<crate::output::GetAttendeeOutput, crate::error::GetAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_attendee_error(response)
        } else {
            crate::operation_deser::parse_get_attendee_response(response)
        }
    }
}

/// Operation shape for `GetMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_meeting`](crate::client::Client::get_meeting).
///
/// See [`crate::client::fluent_builders::GetMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMeeting {
    _private: (),
}
impl GetMeeting {
    /// Creates a new builder-style object to manufacture [`GetMeetingInput`](crate::input::GetMeetingInput)
    pub fn builder() -> crate::input::get_meeting_input::Builder {
        crate::input::get_meeting_input::Builder::default()
    }
    /// Creates a new `GetMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMeeting {
    type Output =
        std::result::Result<crate::output::GetMeetingOutput, crate::error::GetMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_meeting_error(response)
        } else {
            crate::operation_deser::parse_get_meeting_response(response)
        }
    }
}

/// Operation shape for `ListAttendees`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attendees`](crate::client::Client::list_attendees).
///
/// See [`crate::client::fluent_builders::ListAttendees`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttendees {
    _private: (),
}
impl ListAttendees {
    /// Creates a new builder-style object to manufacture [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    pub fn builder() -> crate::input::list_attendees_input::Builder {
        crate::input::list_attendees_input::Builder::default()
    }
    /// Creates a new `ListAttendees` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttendees {
    type Output =
        std::result::Result<crate::output::ListAttendeesOutput, crate::error::ListAttendeesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attendees_error(response)
        } else {
            crate::operation_deser::parse_list_attendees_response(response)
        }
    }
}

/// Operation shape for `StartMeetingTranscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_meeting_transcription`](crate::client::Client::start_meeting_transcription).
///
/// See [`crate::client::fluent_builders::StartMeetingTranscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMeetingTranscription {
    _private: (),
}
impl StartMeetingTranscription {
    /// Creates a new builder-style object to manufacture [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
    pub fn builder() -> crate::input::start_meeting_transcription_input::Builder {
        crate::input::start_meeting_transcription_input::Builder::default()
    }
    /// Creates a new `StartMeetingTranscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMeetingTranscription {
    type Output = std::result::Result<
        crate::output::StartMeetingTranscriptionOutput,
        crate::error::StartMeetingTranscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_meeting_transcription_error(response)
        } else {
            crate::operation_deser::parse_start_meeting_transcription_response(response)
        }
    }
}

/// Operation shape for `StopMeetingTranscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_meeting_transcription`](crate::client::Client::stop_meeting_transcription).
///
/// See [`crate::client::fluent_builders::StopMeetingTranscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMeetingTranscription {
    _private: (),
}
impl StopMeetingTranscription {
    /// Creates a new builder-style object to manufacture [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
    pub fn builder() -> crate::input::stop_meeting_transcription_input::Builder {
        crate::input::stop_meeting_transcription_input::Builder::default()
    }
    /// Creates a new `StopMeetingTranscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMeetingTranscription {
    type Output = std::result::Result<
        crate::output::StopMeetingTranscriptionOutput,
        crate::error::StopMeetingTranscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_meeting_transcription_error(response)
        } else {
            crate::operation_deser::parse_stop_meeting_transcription_response(response)
        }
    }
}
