// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranscriptionConfiguration {
    /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
    pub engine_transcribe_settings: std::option::Option<crate::model::EngineTranscribeSettings>,
    /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
    pub engine_transcribe_medical_settings:
        std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
}
impl TranscriptionConfiguration {
    /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
    pub fn engine_transcribe_settings(
        &self,
    ) -> std::option::Option<&crate::model::EngineTranscribeSettings> {
        self.engine_transcribe_settings.as_ref()
    }
    /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
    pub fn engine_transcribe_medical_settings(
        &self,
    ) -> std::option::Option<&crate::model::EngineTranscribeMedicalSettings> {
        self.engine_transcribe_medical_settings.as_ref()
    }
}
impl std::fmt::Debug for TranscriptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranscriptionConfiguration");
        formatter.field(
            "engine_transcribe_settings",
            &self.engine_transcribe_settings,
        );
        formatter.field(
            "engine_transcribe_medical_settings",
            &self.engine_transcribe_medical_settings,
        );
        formatter.finish()
    }
}
/// See [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
pub mod transcription_configuration {
    /// A builder for [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_transcribe_settings:
            std::option::Option<crate::model::EngineTranscribeSettings>,
        pub(crate) engine_transcribe_medical_settings:
            std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
    }
    impl Builder {
        /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
        pub fn engine_transcribe_settings(
            mut self,
            input: crate::model::EngineTranscribeSettings,
        ) -> Self {
            self.engine_transcribe_settings = Some(input);
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
        pub fn set_engine_transcribe_settings(
            mut self,
            input: std::option::Option<crate::model::EngineTranscribeSettings>,
        ) -> Self {
            self.engine_transcribe_settings = input;
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
        pub fn engine_transcribe_medical_settings(
            mut self,
            input: crate::model::EngineTranscribeMedicalSettings,
        ) -> Self {
            self.engine_transcribe_medical_settings = Some(input);
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
        pub fn set_engine_transcribe_medical_settings(
            mut self,
            input: std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
        ) -> Self {
            self.engine_transcribe_medical_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
        pub fn build(self) -> crate::model::TranscriptionConfiguration {
            crate::model::TranscriptionConfiguration {
                engine_transcribe_settings: self.engine_transcribe_settings,
                engine_transcribe_medical_settings: self.engine_transcribe_medical_settings,
            }
        }
    }
}
impl TranscriptionConfiguration {
    /// Creates a new builder-style object to manufacture [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
    pub fn builder() -> crate::model::transcription_configuration::Builder {
        crate::model::transcription_configuration::Builder::default()
    }
}

/// <p>Settings specific to the Amazon Transcribe Medical engine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineTranscribeMedicalSettings {
    /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
    pub language_code: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
    /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
    pub specialty: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
    /// <p>The type of transcription.</p>
    pub r#type: std::option::Option<crate::model::TranscribeMedicalType>,
    /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub region: std::option::Option<crate::model::TranscribeMedicalRegion>,
    /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
    pub content_identification_type:
        std::option::Option<crate::model::TranscribeMedicalContentIdentificationType>,
}
impl EngineTranscribeMedicalSettings {
    /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
    pub fn language_code(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeMedicalLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
    pub fn specialty(&self) -> std::option::Option<&crate::model::TranscribeMedicalSpecialty> {
        self.specialty.as_ref()
    }
    /// <p>The type of transcription.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TranscribeMedicalType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub fn region(&self) -> std::option::Option<&crate::model::TranscribeMedicalRegion> {
        self.region.as_ref()
    }
    /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
    pub fn content_identification_type(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeMedicalContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
}
impl std::fmt::Debug for EngineTranscribeMedicalSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineTranscribeMedicalSettings");
        formatter.field("language_code", &self.language_code);
        formatter.field("specialty", &self.specialty);
        formatter.field("r#type", &self.r#type);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("region", &self.region);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.finish()
    }
}
/// See [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
pub mod engine_transcribe_medical_settings {
    /// A builder for [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
        pub(crate) specialty: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
        pub(crate) r#type: std::option::Option<crate::model::TranscribeMedicalType>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<crate::model::TranscribeMedicalRegion>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::TranscribeMedicalContentIdentificationType>,
    }
    impl Builder {
        /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
        pub fn language_code(mut self, input: crate::model::TranscribeMedicalLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
        pub fn specialty(mut self, input: crate::model::TranscribeMedicalSpecialty) -> Self {
            self.specialty = Some(input);
            self
        }
        /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
        pub fn set_specialty(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
        ) -> Self {
            self.specialty = input;
            self
        }
        /// <p>The type of transcription.</p>
        pub fn r#type(mut self, input: crate::model::TranscribeMedicalType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of transcription.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn region(mut self, input: crate::model::TranscribeMedicalRegion) -> Self {
            self.region = Some(input);
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn set_region(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalRegion>,
        ) -> Self {
            self.region = input;
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::TranscribeMedicalContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
        pub fn build(self) -> crate::model::EngineTranscribeMedicalSettings {
            crate::model::EngineTranscribeMedicalSettings {
                language_code: self.language_code,
                specialty: self.specialty,
                r#type: self.r#type,
                vocabulary_name: self.vocabulary_name,
                region: self.region,
                content_identification_type: self.content_identification_type,
            }
        }
    }
}
impl EngineTranscribeMedicalSettings {
    /// Creates a new builder-style object to manufacture [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
    pub fn builder() -> crate::model::engine_transcribe_medical_settings::Builder {
        crate::model::engine_transcribe_medical_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalContentIdentificationType {
    #[allow(missing_docs)] // documentation missing in model
    Phi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalContentIdentificationType {
    fn from(s: &str) -> Self {
        match s {
            "PHI" => TranscribeMedicalContentIdentificationType::Phi,
            other => TranscribeMedicalContentIdentificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalContentIdentificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalContentIdentificationType::from(s))
    }
}
impl TranscribeMedicalContentIdentificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalContentIdentificationType::Phi => "PHI",
            TranscribeMedicalContentIdentificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PHI"]
    }
}
impl AsRef<str> for TranscribeMedicalContentIdentificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalRegion {
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalRegion {
    fn from(s: &str) -> Self {
        match s {
            "ap-southeast-2" => TranscribeMedicalRegion::ApSoutheast2,
            "auto" => TranscribeMedicalRegion::Auto,
            "ca-central-1" => TranscribeMedicalRegion::CaCentral1,
            "eu-west-1" => TranscribeMedicalRegion::EuWest1,
            "us-east-1" => TranscribeMedicalRegion::UsEast1,
            "us-east-2" => TranscribeMedicalRegion::UsEast2,
            "us-west-2" => TranscribeMedicalRegion::UsWest2,
            other => TranscribeMedicalRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalRegion::from(s))
    }
}
impl TranscribeMedicalRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalRegion::ApSoutheast2 => "ap-southeast-2",
            TranscribeMedicalRegion::Auto => "auto",
            TranscribeMedicalRegion::CaCentral1 => "ca-central-1",
            TranscribeMedicalRegion::EuWest1 => "eu-west-1",
            TranscribeMedicalRegion::UsEast1 => "us-east-1",
            TranscribeMedicalRegion::UsEast2 => "us-east-2",
            TranscribeMedicalRegion::UsWest2 => "us-west-2",
            TranscribeMedicalRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ap-southeast-2",
            "auto",
            "ca-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for TranscribeMedicalRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalType {
    #[allow(missing_docs)] // documentation missing in model
    Conversation,
    #[allow(missing_docs)] // documentation missing in model
    Dictation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalType {
    fn from(s: &str) -> Self {
        match s {
            "CONVERSATION" => TranscribeMedicalType::Conversation,
            "DICTATION" => TranscribeMedicalType::Dictation,
            other => TranscribeMedicalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalType::from(s))
    }
}
impl TranscribeMedicalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalType::Conversation => "CONVERSATION",
            TranscribeMedicalType::Dictation => "DICTATION",
            TranscribeMedicalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERSATION", "DICTATION"]
    }
}
impl AsRef<str> for TranscribeMedicalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalSpecialty {
    #[allow(missing_docs)] // documentation missing in model
    Cardiology,
    #[allow(missing_docs)] // documentation missing in model
    Neurology,
    #[allow(missing_docs)] // documentation missing in model
    Oncology,
    #[allow(missing_docs)] // documentation missing in model
    Primarycare,
    #[allow(missing_docs)] // documentation missing in model
    Radiology,
    #[allow(missing_docs)] // documentation missing in model
    Urology,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalSpecialty {
    fn from(s: &str) -> Self {
        match s {
            "CARDIOLOGY" => TranscribeMedicalSpecialty::Cardiology,
            "NEUROLOGY" => TranscribeMedicalSpecialty::Neurology,
            "ONCOLOGY" => TranscribeMedicalSpecialty::Oncology,
            "PRIMARYCARE" => TranscribeMedicalSpecialty::Primarycare,
            "RADIOLOGY" => TranscribeMedicalSpecialty::Radiology,
            "UROLOGY" => TranscribeMedicalSpecialty::Urology,
            other => TranscribeMedicalSpecialty::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalSpecialty {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalSpecialty::from(s))
    }
}
impl TranscribeMedicalSpecialty {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalSpecialty::Cardiology => "CARDIOLOGY",
            TranscribeMedicalSpecialty::Neurology => "NEUROLOGY",
            TranscribeMedicalSpecialty::Oncology => "ONCOLOGY",
            TranscribeMedicalSpecialty::Primarycare => "PRIMARYCARE",
            TranscribeMedicalSpecialty::Radiology => "RADIOLOGY",
            TranscribeMedicalSpecialty::Urology => "UROLOGY",
            TranscribeMedicalSpecialty::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CARDIOLOGY",
            "NEUROLOGY",
            "ONCOLOGY",
            "PRIMARYCARE",
            "RADIOLOGY",
            "UROLOGY",
        ]
    }
}
impl AsRef<str> for TranscribeMedicalSpecialty {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalLanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalLanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "en-US" => TranscribeMedicalLanguageCode::EnUs,
            other => TranscribeMedicalLanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalLanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalLanguageCode::from(s))
    }
}
impl TranscribeMedicalLanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalLanguageCode::EnUs => "en-US",
            TranscribeMedicalLanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["en-US"]
    }
}
impl AsRef<str> for TranscribeMedicalLanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings specific to the Amazon Transcribe engine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineTranscribeSettings {
    /// <p>The language code specified for the Amazon Transcribe engine.</p>
    pub language_code: std::option::Option<crate::model::TranscribeLanguageCode>,
    /// <p>The filtering method passed to Amazon Transcribe.</p>
    pub vocabulary_filter_method:
        std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
    /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
    pub vocabulary_filter_name: std::option::Option<std::string::String>,
    /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub region: std::option::Option<crate::model::TranscribeRegion>,
    /// <p>Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.</p>
    pub enable_partial_results_stabilization: bool,
    /// <p>The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.</p>
    pub partial_results_stability:
        std::option::Option<crate::model::TranscribePartialResultsStability>,
    /// <p>Set this field to <code>PII</code> to identify personally identifiable information in the transcription output.</p>
    pub content_identification_type:
        std::option::Option<crate::model::TranscribeContentIdentificationType>,
    /// <p>Set this field to <code>PII</code> to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    pub content_redaction_type: std::option::Option<crate::model::TranscribeContentRedactionType>,
    /// <p>Lists the PII entity types you want to identify or redact. To specify entity types, you must enable <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>PIIEntityTypes must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
    /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
    pub pii_entity_types: std::option::Option<std::string::String>,
    /// <p>The name of the language model used during transcription.</p>
    pub language_model_name: std::option::Option<std::string::String>,
}
impl EngineTranscribeSettings {
    /// <p>The language code specified for the Amazon Transcribe engine.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::TranscribeLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The filtering method passed to Amazon Transcribe.</p>
    pub fn vocabulary_filter_method(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeVocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
    pub fn vocabulary_filter_name(&self) -> std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub fn region(&self) -> std::option::Option<&crate::model::TranscribeRegion> {
        self.region.as_ref()
    }
    /// <p>Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.</p>
    pub fn enable_partial_results_stabilization(&self) -> bool {
        self.enable_partial_results_stabilization
    }
    /// <p>The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.</p>
    pub fn partial_results_stability(
        &self,
    ) -> std::option::Option<&crate::model::TranscribePartialResultsStability> {
        self.partial_results_stability.as_ref()
    }
    /// <p>Set this field to <code>PII</code> to identify personally identifiable information in the transcription output.</p>
    pub fn content_identification_type(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
    /// <p>Set this field to <code>PII</code> to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    pub fn content_redaction_type(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeContentRedactionType> {
        self.content_redaction_type.as_ref()
    }
    /// <p>Lists the PII entity types you want to identify or redact. To specify entity types, you must enable <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>PIIEntityTypes must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
    /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
    pub fn pii_entity_types(&self) -> std::option::Option<&str> {
        self.pii_entity_types.as_deref()
    }
    /// <p>The name of the language model used during transcription.</p>
    pub fn language_model_name(&self) -> std::option::Option<&str> {
        self.language_model_name.as_deref()
    }
}
impl std::fmt::Debug for EngineTranscribeSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineTranscribeSettings");
        formatter.field("language_code", &self.language_code);
        formatter.field("vocabulary_filter_method", &self.vocabulary_filter_method);
        formatter.field("vocabulary_filter_name", &self.vocabulary_filter_name);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("region", &self.region);
        formatter.field(
            "enable_partial_results_stabilization",
            &self.enable_partial_results_stabilization,
        );
        formatter.field("partial_results_stability", &self.partial_results_stability);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.field("content_redaction_type", &self.content_redaction_type);
        formatter.field("pii_entity_types", &self.pii_entity_types);
        formatter.field("language_model_name", &self.language_model_name);
        formatter.finish()
    }
}
/// See [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
pub mod engine_transcribe_settings {
    /// A builder for [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::TranscribeLanguageCode>,
        pub(crate) vocabulary_filter_method:
            std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
        pub(crate) vocabulary_filter_name: std::option::Option<std::string::String>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<crate::model::TranscribeRegion>,
        pub(crate) enable_partial_results_stabilization: std::option::Option<bool>,
        pub(crate) partial_results_stability:
            std::option::Option<crate::model::TranscribePartialResultsStability>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::TranscribeContentIdentificationType>,
        pub(crate) content_redaction_type:
            std::option::Option<crate::model::TranscribeContentRedactionType>,
        pub(crate) pii_entity_types: std::option::Option<std::string::String>,
        pub(crate) language_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code specified for the Amazon Transcribe engine.</p>
        pub fn language_code(mut self, input: crate::model::TranscribeLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code specified for the Amazon Transcribe engine.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::TranscribeLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The filtering method passed to Amazon Transcribe.</p>
        pub fn vocabulary_filter_method(
            mut self,
            input: crate::model::TranscribeVocabularyFilterMethod,
        ) -> Self {
            self.vocabulary_filter_method = Some(input);
            self
        }
        /// <p>The filtering method passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_filter_method(
            mut self,
            input: std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
        ) -> Self {
            self.vocabulary_filter_method = input;
            self
        }
        /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
        pub fn vocabulary_filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_filter_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_filter_name = input;
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn region(mut self, input: crate::model::TranscribeRegion) -> Self {
            self.region = Some(input);
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn set_region(
            mut self,
            input: std::option::Option<crate::model::TranscribeRegion>,
        ) -> Self {
            self.region = input;
            self
        }
        /// <p>Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.</p>
        pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
            self.enable_partial_results_stabilization = Some(input);
            self
        }
        /// <p>Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.</p>
        pub fn set_enable_partial_results_stabilization(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_partial_results_stabilization = input;
            self
        }
        /// <p>The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.</p>
        pub fn partial_results_stability(
            mut self,
            input: crate::model::TranscribePartialResultsStability,
        ) -> Self {
            self.partial_results_stability = Some(input);
            self
        }
        /// <p>The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.</p>
        pub fn set_partial_results_stability(
            mut self,
            input: std::option::Option<crate::model::TranscribePartialResultsStability>,
        ) -> Self {
            self.partial_results_stability = input;
            self
        }
        /// <p>Set this field to <code>PII</code> to identify personally identifiable information in the transcription output.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::TranscribeContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>Set this field to <code>PII</code> to identify personally identifiable information in the transcription output.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::TranscribeContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// <p>Set this field to <code>PII</code> to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn content_redaction_type(
            mut self,
            input: crate::model::TranscribeContentRedactionType,
        ) -> Self {
            self.content_redaction_type = Some(input);
            self
        }
        /// <p>Set this field to <code>PII</code> to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_content_redaction_type(
            mut self,
            input: std::option::Option<crate::model::TranscribeContentRedactionType>,
        ) -> Self {
            self.content_redaction_type = input;
            self
        }
        /// <p>Lists the PII entity types you want to identify or redact. To specify entity types, you must enable <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
        /// <p>PIIEntityTypes must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
        /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn pii_entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.pii_entity_types = Some(input.into());
            self
        }
        /// <p>Lists the PII entity types you want to identify or redact. To specify entity types, you must enable <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
        /// <p>PIIEntityTypes must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
        /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn set_pii_entity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pii_entity_types = input;
            self
        }
        /// <p>The name of the language model used during transcription.</p>
        pub fn language_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_model_name = Some(input.into());
            self
        }
        /// <p>The name of the language model used during transcription.</p>
        pub fn set_language_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
        pub fn build(self) -> crate::model::EngineTranscribeSettings {
            crate::model::EngineTranscribeSettings {
                language_code: self.language_code,
                vocabulary_filter_method: self.vocabulary_filter_method,
                vocabulary_filter_name: self.vocabulary_filter_name,
                vocabulary_name: self.vocabulary_name,
                region: self.region,
                enable_partial_results_stabilization: self
                    .enable_partial_results_stabilization
                    .unwrap_or_default(),
                partial_results_stability: self.partial_results_stability,
                content_identification_type: self.content_identification_type,
                content_redaction_type: self.content_redaction_type,
                pii_entity_types: self.pii_entity_types,
                language_model_name: self.language_model_name,
            }
        }
    }
}
impl EngineTranscribeSettings {
    /// Creates a new builder-style object to manufacture [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
    pub fn builder() -> crate::model::engine_transcribe_settings::Builder {
        crate::model::engine_transcribe_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeContentRedactionType {
    #[allow(missing_docs)] // documentation missing in model
    Pii,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeContentRedactionType {
    fn from(s: &str) -> Self {
        match s {
            "PII" => TranscribeContentRedactionType::Pii,
            other => TranscribeContentRedactionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeContentRedactionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeContentRedactionType::from(s))
    }
}
impl TranscribeContentRedactionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeContentRedactionType::Pii => "PII",
            TranscribeContentRedactionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PII"]
    }
}
impl AsRef<str> for TranscribeContentRedactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeContentIdentificationType {
    #[allow(missing_docs)] // documentation missing in model
    Pii,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeContentIdentificationType {
    fn from(s: &str) -> Self {
        match s {
            "PII" => TranscribeContentIdentificationType::Pii,
            other => TranscribeContentIdentificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeContentIdentificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeContentIdentificationType::from(s))
    }
}
impl TranscribeContentIdentificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeContentIdentificationType::Pii => "PII",
            TranscribeContentIdentificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PII"]
    }
}
impl AsRef<str> for TranscribeContentIdentificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribePartialResultsStability {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribePartialResultsStability {
    fn from(s: &str) -> Self {
        match s {
            "high" => TranscribePartialResultsStability::High,
            "low" => TranscribePartialResultsStability::Low,
            "medium" => TranscribePartialResultsStability::Medium,
            other => TranscribePartialResultsStability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribePartialResultsStability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribePartialResultsStability::from(s))
    }
}
impl TranscribePartialResultsStability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribePartialResultsStability::High => "high",
            TranscribePartialResultsStability::Low => "low",
            TranscribePartialResultsStability::Medium => "medium",
            TranscribePartialResultsStability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["high", "low", "medium"]
    }
}
impl AsRef<str> for TranscribePartialResultsStability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeRegion {
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest2,
    #[allow(missing_docs)] // documentation missing in model
    SaEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeRegion {
    fn from(s: &str) -> Self {
        match s {
            "ap-northeast-1" => TranscribeRegion::ApNortheast1,
            "ap-northeast-2" => TranscribeRegion::ApNortheast2,
            "ap-southeast-2" => TranscribeRegion::ApSoutheast2,
            "auto" => TranscribeRegion::Auto,
            "ca-central-1" => TranscribeRegion::CaCentral1,
            "eu-central-1" => TranscribeRegion::EuCentral1,
            "eu-west-1" => TranscribeRegion::EuWest1,
            "eu-west-2" => TranscribeRegion::EuWest2,
            "sa-east-1" => TranscribeRegion::SaEast1,
            "us-east-1" => TranscribeRegion::UsEast1,
            "us-east-2" => TranscribeRegion::UsEast2,
            "us-west-2" => TranscribeRegion::UsWest2,
            other => TranscribeRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeRegion::from(s))
    }
}
impl TranscribeRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeRegion::ApNortheast1 => "ap-northeast-1",
            TranscribeRegion::ApNortheast2 => "ap-northeast-2",
            TranscribeRegion::ApSoutheast2 => "ap-southeast-2",
            TranscribeRegion::Auto => "auto",
            TranscribeRegion::CaCentral1 => "ca-central-1",
            TranscribeRegion::EuCentral1 => "eu-central-1",
            TranscribeRegion::EuWest1 => "eu-west-1",
            TranscribeRegion::EuWest2 => "eu-west-2",
            TranscribeRegion::SaEast1 => "sa-east-1",
            TranscribeRegion::UsEast1 => "us-east-1",
            TranscribeRegion::UsEast2 => "us-east-2",
            TranscribeRegion::UsWest2 => "us-west-2",
            TranscribeRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-2",
            "auto",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for TranscribeRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeVocabularyFilterMethod {
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeVocabularyFilterMethod {
    fn from(s: &str) -> Self {
        match s {
            "mask" => TranscribeVocabularyFilterMethod::Mask,
            "remove" => TranscribeVocabularyFilterMethod::Remove,
            "tag" => TranscribeVocabularyFilterMethod::Tag,
            other => TranscribeVocabularyFilterMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeVocabularyFilterMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeVocabularyFilterMethod::from(s))
    }
}
impl TranscribeVocabularyFilterMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeVocabularyFilterMethod::Mask => "mask",
            TranscribeVocabularyFilterMethod::Remove => "remove",
            TranscribeVocabularyFilterMethod::Tag => "tag",
            TranscribeVocabularyFilterMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mask", "remove", "tag"]
    }
}
impl AsRef<str> for TranscribeVocabularyFilterMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeLanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnAu,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    EsUs,
    #[allow(missing_docs)] // documentation missing in model
    FrCa,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeLanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "de-DE" => TranscribeLanguageCode::DeDe,
            "en-AU" => TranscribeLanguageCode::EnAu,
            "en-GB" => TranscribeLanguageCode::EnGb,
            "en-US" => TranscribeLanguageCode::EnUs,
            "es-US" => TranscribeLanguageCode::EsUs,
            "fr-CA" => TranscribeLanguageCode::FrCa,
            "fr-FR" => TranscribeLanguageCode::FrFr,
            "it-IT" => TranscribeLanguageCode::ItIt,
            "ja-JP" => TranscribeLanguageCode::JaJp,
            "ko-KR" => TranscribeLanguageCode::KoKr,
            "pt-BR" => TranscribeLanguageCode::PtBr,
            "zh-CN" => TranscribeLanguageCode::ZhCn,
            other => TranscribeLanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeLanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeLanguageCode::from(s))
    }
}
impl TranscribeLanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeLanguageCode::DeDe => "de-DE",
            TranscribeLanguageCode::EnAu => "en-AU",
            TranscribeLanguageCode::EnGb => "en-GB",
            TranscribeLanguageCode::EnUs => "en-US",
            TranscribeLanguageCode::EsUs => "es-US",
            TranscribeLanguageCode::FrCa => "fr-CA",
            TranscribeLanguageCode::FrFr => "fr-FR",
            TranscribeLanguageCode::ItIt => "it-IT",
            TranscribeLanguageCode::JaJp => "ja-JP",
            TranscribeLanguageCode::KoKr => "ko-KR",
            TranscribeLanguageCode::PtBr => "pt-BR",
            TranscribeLanguageCode::ZhCn => "zh-CN",
            TranscribeLanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de-DE", "en-AU", "en-GB", "en-US", "es-US", "fr-CA", "fr-FR", "it-IT", "ja-JP",
            "ko-KR", "pt-BR", "zh-CN",
        ]
    }
}
impl AsRef<str> for TranscribeLanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Amazon Chime SDK meeting attendee. Includes a unique <code>AttendeeId</code> and <code>JoinToken</code>. The <code>JoinToken</code> allows a client to authenticate and join as the specified attendee. The <code>JoinToken</code> expires when the meeting ends, or when <code>DeleteAttendee</code> is called. After that, the attendee is unable to join the meeting. </p>
/// <p>We recommend securely transferring each <code>JoinToken</code> from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attendee {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub attendee_id: std::option::Option<std::string::String>,
    /// <p>The join token used by the Amazon Chime SDK attendee.</p>
    pub join_token: std::option::Option<std::string::String>,
}
impl Attendee {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub fn attendee_id(&self) -> std::option::Option<&str> {
        self.attendee_id.as_deref()
    }
    /// <p>The join token used by the Amazon Chime SDK attendee.</p>
    pub fn join_token(&self) -> std::option::Option<&str> {
        self.join_token.as_deref()
    }
}
impl std::fmt::Debug for Attendee {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attendee");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.field("attendee_id", &self.attendee_id);
        formatter.field("join_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Attendee`](crate::model::Attendee)
pub mod attendee {
    /// A builder for [`Attendee`](crate::model::Attendee)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
        pub(crate) join_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// <p>The join token used by the Amazon Chime SDK attendee.</p>
        pub fn join_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.join_token = Some(input.into());
            self
        }
        /// <p>The join token used by the Amazon Chime SDK attendee.</p>
        pub fn set_join_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.join_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Attendee`](crate::model::Attendee)
        pub fn build(self) -> crate::model::Attendee {
            crate::model::Attendee {
                external_user_id: self.external_user_id,
                attendee_id: self.attendee_id,
                join_token: self.join_token,
            }
        }
    }
}
impl Attendee {
    /// Creates a new builder-style object to manufacture [`Attendee`](crate::model::Attendee)
    pub fn builder() -> crate::model::attendee::Builder {
        crate::model::attendee::Builder::default()
    }
}

/// <p>A meeting created using the Amazon Chime SDK.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Meeting {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>Reserved.</p>
    pub meeting_host_id: std::option::Option<std::string::String>,
    /// <p>The external meeting ID.</p>
    pub external_meeting_id: std::option::Option<std::string::String>,
    /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
    pub media_region: std::option::Option<std::string::String>,
    /// <p>The media placement for the meeting.</p>
    pub media_placement: std::option::Option<crate::model::MediaPlacement>,
    /// <p>The features available to a meeting, such as Amazon Voice Focus.</p>
    pub meeting_features: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
}
impl Meeting {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>Reserved.</p>
    pub fn meeting_host_id(&self) -> std::option::Option<&str> {
        self.meeting_host_id.as_deref()
    }
    /// <p>The external meeting ID.</p>
    pub fn external_meeting_id(&self) -> std::option::Option<&str> {
        self.external_meeting_id.as_deref()
    }
    /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
    pub fn media_region(&self) -> std::option::Option<&str> {
        self.media_region.as_deref()
    }
    /// <p>The media placement for the meeting.</p>
    pub fn media_placement(&self) -> std::option::Option<&crate::model::MediaPlacement> {
        self.media_placement.as_ref()
    }
    /// <p>The features available to a meeting, such as Amazon Voice Focus.</p>
    pub fn meeting_features(
        &self,
    ) -> std::option::Option<&crate::model::MeetingFeaturesConfiguration> {
        self.meeting_features.as_ref()
    }
}
impl std::fmt::Debug for Meeting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Meeting");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("meeting_host_id", &"*** Sensitive Data Redacted ***");
        formatter.field("external_meeting_id", &"*** Sensitive Data Redacted ***");
        formatter.field("media_region", &self.media_region);
        formatter.field("media_placement", &self.media_placement);
        formatter.field("meeting_features", &self.meeting_features);
        formatter.finish()
    }
}
/// See [`Meeting`](crate::model::Meeting)
pub mod meeting {
    /// A builder for [`Meeting`](crate::model::Meeting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) meeting_host_id: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) media_region: std::option::Option<std::string::String>,
        pub(crate) media_placement: std::option::Option<crate::model::MediaPlacement>,
        pub(crate) meeting_features:
            std::option::Option<crate::model::MeetingFeaturesConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_host_id = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.meeting_host_id = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// <p>The media placement for the meeting.</p>
        pub fn media_placement(mut self, input: crate::model::MediaPlacement) -> Self {
            self.media_placement = Some(input);
            self
        }
        /// <p>The media placement for the meeting.</p>
        pub fn set_media_placement(
            mut self,
            input: std::option::Option<crate::model::MediaPlacement>,
        ) -> Self {
            self.media_placement = input;
            self
        }
        /// <p>The features available to a meeting, such as Amazon Voice Focus.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.meeting_features = Some(input);
            self
        }
        /// <p>The features available to a meeting, such as Amazon Voice Focus.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.meeting_features = input;
            self
        }
        /// Consumes the builder and constructs a [`Meeting`](crate::model::Meeting)
        pub fn build(self) -> crate::model::Meeting {
            crate::model::Meeting {
                meeting_id: self.meeting_id,
                meeting_host_id: self.meeting_host_id,
                external_meeting_id: self.external_meeting_id,
                media_region: self.media_region,
                media_placement: self.media_placement,
                meeting_features: self.meeting_features,
            }
        }
    }
}
impl Meeting {
    /// Creates a new builder-style object to manufacture [`Meeting`](crate::model::Meeting)
    pub fn builder() -> crate::model::meeting::Builder {
        crate::model::meeting::Builder::default()
    }
}

/// <p>The configuration settings of the features available to a meeting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeetingFeaturesConfiguration {
    /// <p>The configuration settings for the audio features available to a meeting. </p>
    pub audio: std::option::Option<crate::model::AudioFeatures>,
}
impl MeetingFeaturesConfiguration {
    /// <p>The configuration settings for the audio features available to a meeting. </p>
    pub fn audio(&self) -> std::option::Option<&crate::model::AudioFeatures> {
        self.audio.as_ref()
    }
}
impl std::fmt::Debug for MeetingFeaturesConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeetingFeaturesConfiguration");
        formatter.field("audio", &self.audio);
        formatter.finish()
    }
}
/// See [`MeetingFeaturesConfiguration`](crate::model::MeetingFeaturesConfiguration)
pub mod meeting_features_configuration {
    /// A builder for [`MeetingFeaturesConfiguration`](crate::model::MeetingFeaturesConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio: std::option::Option<crate::model::AudioFeatures>,
    }
    impl Builder {
        /// <p>The configuration settings for the audio features available to a meeting. </p>
        pub fn audio(mut self, input: crate::model::AudioFeatures) -> Self {
            self.audio = Some(input);
            self
        }
        /// <p>The configuration settings for the audio features available to a meeting. </p>
        pub fn set_audio(
            mut self,
            input: std::option::Option<crate::model::AudioFeatures>,
        ) -> Self {
            self.audio = input;
            self
        }
        /// Consumes the builder and constructs a [`MeetingFeaturesConfiguration`](crate::model::MeetingFeaturesConfiguration)
        pub fn build(self) -> crate::model::MeetingFeaturesConfiguration {
            crate::model::MeetingFeaturesConfiguration { audio: self.audio }
        }
    }
}
impl MeetingFeaturesConfiguration {
    /// Creates a new builder-style object to manufacture [`MeetingFeaturesConfiguration`](crate::model::MeetingFeaturesConfiguration)
    pub fn builder() -> crate::model::meeting_features_configuration::Builder {
        crate::model::meeting_features_configuration::Builder::default()
    }
}

/// <p>An optional category of meeting features that contains audio-specific configurations, such as operating parameters for Amazon Voice Focus.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioFeatures {
    /// <p>Makes echo reduction available to clients who connect to the meeting.</p>
    pub echo_reduction: std::option::Option<crate::model::MeetingFeatureStatus>,
}
impl AudioFeatures {
    /// <p>Makes echo reduction available to clients who connect to the meeting.</p>
    pub fn echo_reduction(&self) -> std::option::Option<&crate::model::MeetingFeatureStatus> {
        self.echo_reduction.as_ref()
    }
}
impl std::fmt::Debug for AudioFeatures {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioFeatures");
        formatter.field("echo_reduction", &self.echo_reduction);
        formatter.finish()
    }
}
/// See [`AudioFeatures`](crate::model::AudioFeatures)
pub mod audio_features {
    /// A builder for [`AudioFeatures`](crate::model::AudioFeatures)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) echo_reduction: std::option::Option<crate::model::MeetingFeatureStatus>,
    }
    impl Builder {
        /// <p>Makes echo reduction available to clients who connect to the meeting.</p>
        pub fn echo_reduction(mut self, input: crate::model::MeetingFeatureStatus) -> Self {
            self.echo_reduction = Some(input);
            self
        }
        /// <p>Makes echo reduction available to clients who connect to the meeting.</p>
        pub fn set_echo_reduction(
            mut self,
            input: std::option::Option<crate::model::MeetingFeatureStatus>,
        ) -> Self {
            self.echo_reduction = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioFeatures`](crate::model::AudioFeatures)
        pub fn build(self) -> crate::model::AudioFeatures {
            crate::model::AudioFeatures {
                echo_reduction: self.echo_reduction,
            }
        }
    }
}
impl AudioFeatures {
    /// Creates a new builder-style object to manufacture [`AudioFeatures`](crate::model::AudioFeatures)
    pub fn builder() -> crate::model::audio_features::Builder {
        crate::model::audio_features::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MeetingFeatureStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MeetingFeatureStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => MeetingFeatureStatus::Available,
            "UNAVAILABLE" => MeetingFeatureStatus::Unavailable,
            other => MeetingFeatureStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MeetingFeatureStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MeetingFeatureStatus::from(s))
    }
}
impl MeetingFeatureStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MeetingFeatureStatus::Available => "AVAILABLE",
            MeetingFeatureStatus::Unavailable => "UNAVAILABLE",
            MeetingFeatureStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "UNAVAILABLE"]
    }
}
impl AsRef<str> for MeetingFeatureStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaPlacement {
    /// <p>The audio host URL.</p>
    pub audio_host_url: std::option::Option<std::string::String>,
    /// <p>The audio fallback URL.</p>
    pub audio_fallback_url: std::option::Option<std::string::String>,
    /// <p>The signaling URL.</p>
    pub signaling_url: std::option::Option<std::string::String>,
    /// <p>The turn control URL.</p>
    pub turn_control_url: std::option::Option<std::string::String>,
    /// <p>The screen data URL.</p>
    pub screen_data_url: std::option::Option<std::string::String>,
    /// <p>The screen viewing URL.</p>
    pub screen_viewing_url: std::option::Option<std::string::String>,
    /// <p>The screen sharing URL.</p>
    pub screen_sharing_url: std::option::Option<std::string::String>,
    /// <p>The event ingestion URL.</p>
    pub event_ingestion_url: std::option::Option<std::string::String>,
}
impl MediaPlacement {
    /// <p>The audio host URL.</p>
    pub fn audio_host_url(&self) -> std::option::Option<&str> {
        self.audio_host_url.as_deref()
    }
    /// <p>The audio fallback URL.</p>
    pub fn audio_fallback_url(&self) -> std::option::Option<&str> {
        self.audio_fallback_url.as_deref()
    }
    /// <p>The signaling URL.</p>
    pub fn signaling_url(&self) -> std::option::Option<&str> {
        self.signaling_url.as_deref()
    }
    /// <p>The turn control URL.</p>
    pub fn turn_control_url(&self) -> std::option::Option<&str> {
        self.turn_control_url.as_deref()
    }
    /// <p>The screen data URL.</p>
    pub fn screen_data_url(&self) -> std::option::Option<&str> {
        self.screen_data_url.as_deref()
    }
    /// <p>The screen viewing URL.</p>
    pub fn screen_viewing_url(&self) -> std::option::Option<&str> {
        self.screen_viewing_url.as_deref()
    }
    /// <p>The screen sharing URL.</p>
    pub fn screen_sharing_url(&self) -> std::option::Option<&str> {
        self.screen_sharing_url.as_deref()
    }
    /// <p>The event ingestion URL.</p>
    pub fn event_ingestion_url(&self) -> std::option::Option<&str> {
        self.event_ingestion_url.as_deref()
    }
}
impl std::fmt::Debug for MediaPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaPlacement");
        formatter.field("audio_host_url", &self.audio_host_url);
        formatter.field("audio_fallback_url", &self.audio_fallback_url);
        formatter.field("signaling_url", &self.signaling_url);
        formatter.field("turn_control_url", &self.turn_control_url);
        formatter.field("screen_data_url", &self.screen_data_url);
        formatter.field("screen_viewing_url", &self.screen_viewing_url);
        formatter.field("screen_sharing_url", &self.screen_sharing_url);
        formatter.field("event_ingestion_url", &self.event_ingestion_url);
        formatter.finish()
    }
}
/// See [`MediaPlacement`](crate::model::MediaPlacement)
pub mod media_placement {
    /// A builder for [`MediaPlacement`](crate::model::MediaPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_host_url: std::option::Option<std::string::String>,
        pub(crate) audio_fallback_url: std::option::Option<std::string::String>,
        pub(crate) signaling_url: std::option::Option<std::string::String>,
        pub(crate) turn_control_url: std::option::Option<std::string::String>,
        pub(crate) screen_data_url: std::option::Option<std::string::String>,
        pub(crate) screen_viewing_url: std::option::Option<std::string::String>,
        pub(crate) screen_sharing_url: std::option::Option<std::string::String>,
        pub(crate) event_ingestion_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The audio host URL.</p>
        pub fn audio_host_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_host_url = Some(input.into());
            self
        }
        /// <p>The audio host URL.</p>
        pub fn set_audio_host_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_host_url = input;
            self
        }
        /// <p>The audio fallback URL.</p>
        pub fn audio_fallback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_fallback_url = Some(input.into());
            self
        }
        /// <p>The audio fallback URL.</p>
        pub fn set_audio_fallback_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_fallback_url = input;
            self
        }
        /// <p>The signaling URL.</p>
        pub fn signaling_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.signaling_url = Some(input.into());
            self
        }
        /// <p>The signaling URL.</p>
        pub fn set_signaling_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signaling_url = input;
            self
        }
        /// <p>The turn control URL.</p>
        pub fn turn_control_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.turn_control_url = Some(input.into());
            self
        }
        /// <p>The turn control URL.</p>
        pub fn set_turn_control_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.turn_control_url = input;
            self
        }
        /// <p>The screen data URL.</p>
        pub fn screen_data_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_data_url = Some(input.into());
            self
        }
        /// <p>The screen data URL.</p>
        pub fn set_screen_data_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_data_url = input;
            self
        }
        /// <p>The screen viewing URL.</p>
        pub fn screen_viewing_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_viewing_url = Some(input.into());
            self
        }
        /// <p>The screen viewing URL.</p>
        pub fn set_screen_viewing_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_viewing_url = input;
            self
        }
        /// <p>The screen sharing URL.</p>
        pub fn screen_sharing_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_sharing_url = Some(input.into());
            self
        }
        /// <p>The screen sharing URL.</p>
        pub fn set_screen_sharing_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_sharing_url = input;
            self
        }
        /// <p>The event ingestion URL.</p>
        pub fn event_ingestion_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_ingestion_url = Some(input.into());
            self
        }
        /// <p>The event ingestion URL.</p>
        pub fn set_event_ingestion_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_ingestion_url = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaPlacement`](crate::model::MediaPlacement)
        pub fn build(self) -> crate::model::MediaPlacement {
            crate::model::MediaPlacement {
                audio_host_url: self.audio_host_url,
                audio_fallback_url: self.audio_fallback_url,
                signaling_url: self.signaling_url,
                turn_control_url: self.turn_control_url,
                screen_data_url: self.screen_data_url,
                screen_viewing_url: self.screen_viewing_url,
                screen_sharing_url: self.screen_sharing_url,
                event_ingestion_url: self.event_ingestion_url,
            }
        }
    }
}
impl MediaPlacement {
    /// Creates a new builder-style object to manufacture [`MediaPlacement`](crate::model::MediaPlacement)
    pub fn builder() -> crate::model::media_placement::Builder {
        crate::model::media_placement::Builder::default()
    }
}

/// <p>The list of errors returned when errors are encountered during the BatchCreateAttendee and CreateAttendee actions. This includes external user IDs, error codes, and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttendeeError {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl CreateAttendeeError {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for CreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttendeeError");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`CreateAttendeeError`](crate::model::CreateAttendeeError)
pub mod create_attendee_error {
    /// A builder for [`CreateAttendeeError`](crate::model::CreateAttendeeError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeError`](crate::model::CreateAttendeeError)
        pub fn build(self) -> crate::model::CreateAttendeeError {
            crate::model::CreateAttendeeError {
                external_user_id: self.external_user_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl CreateAttendeeError {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeError`](crate::model::CreateAttendeeError)
    pub fn builder() -> crate::model::create_attendee_error::Builder {
        crate::model::create_attendee_error::Builder::default()
    }
}

/// <p>The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttendeeRequestItem {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
}
impl CreateAttendeeRequestItem {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAttendeeRequestItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttendeeRequestItem");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
pub mod create_attendee_request_item {
    /// A builder for [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
        pub fn build(self) -> crate::model::CreateAttendeeRequestItem {
            crate::model::CreateAttendeeRequestItem {
                external_user_id: self.external_user_id,
            }
        }
    }
}
impl CreateAttendeeRequestItem {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
    pub fn builder() -> crate::model::create_attendee_request_item::Builder {
        crate::model::create_attendee_request_item::Builder::default()
    }
}

/// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationsConfiguration {
    /// <p>The ARN of the AWS Lambda function in the notifications configuration.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the SNS topic.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the SQS queue.</p>
    pub sqs_queue_arn: std::option::Option<std::string::String>,
}
impl NotificationsConfiguration {
    /// <p>The ARN of the AWS Lambda function in the notifications configuration.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
    /// <p>The ARN of the SNS topic.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The ARN of the SQS queue.</p>
    pub fn sqs_queue_arn(&self) -> std::option::Option<&str> {
        self.sqs_queue_arn.as_deref()
    }
}
impl std::fmt::Debug for NotificationsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationsConfiguration");
        formatter.field("lambda_function_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("sns_topic_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("sqs_queue_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`NotificationsConfiguration`](crate::model::NotificationsConfiguration)
pub mod notifications_configuration {
    /// A builder for [`NotificationsConfiguration`](crate::model::NotificationsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) sqs_queue_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the AWS Lambda function in the notifications configuration.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the AWS Lambda function in the notifications configuration.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// <p>The ARN of the SNS topic.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The ARN of the SQS queue.</p>
        pub fn sqs_queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sqs_queue_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SQS queue.</p>
        pub fn set_sqs_queue_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sqs_queue_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationsConfiguration`](crate::model::NotificationsConfiguration)
        pub fn build(self) -> crate::model::NotificationsConfiguration {
            crate::model::NotificationsConfiguration {
                lambda_function_arn: self.lambda_function_arn,
                sns_topic_arn: self.sns_topic_arn,
                sqs_queue_arn: self.sqs_queue_arn,
            }
        }
    }
}
impl NotificationsConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationsConfiguration`](crate::model::NotificationsConfiguration)
    pub fn builder() -> crate::model::notifications_configuration::Builder {
        crate::model::notifications_configuration::Builder::default()
    }
}
