// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
pub mod batch_create_attendee_input {
    /// A builder for [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendees:
            std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Appends an item to `attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            let mut v = self.attendees.unwrap_or_default();
            v.push(input);
            self.attendees = Some(v);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.attendees = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateAttendeeInput {
                meeting_id: self.meeting_id,
                attendees: self.attendees,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateAttendeeInputOperationOutputAlias = crate::operation::BatchCreateAttendee;
#[doc(hidden)]
pub type BatchCreateAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateAttendee`](crate::operation::BatchCreateAttendee)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchCreateAttendeeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.meeting_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_1, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/attendees",
                    MeetingId = meeting_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::BatchCreateAttendeeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("operation", "batch-create");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchCreateAttendeeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_create_attendee(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateAttendee",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    pub fn builder() -> crate::input::batch_create_attendee_input::Builder {
        crate::input::batch_create_attendee_input::Builder::default()
    }
}

/// See [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
pub mod create_attendee_input {
    /// A builder for [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) external_user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the meeting.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the meeting.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAttendeeInput {
                meeting_id: self.meeting_id,
                external_user_id: self.external_user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAttendeeInputOperationOutputAlias = crate::operation::CreateAttendee;
#[doc(hidden)]
pub type CreateAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`CreateAttendee`](crate::operation::CreateAttendee)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAttendeeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.meeting_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_2, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/attendees",
                    MeetingId = meeting_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAttendeeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_attendee(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAttendee",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    pub fn builder() -> crate::input::create_attendee_input::Builder {
        crate::input::create_attendee_input::Builder::default()
    }
}

/// See [`CreateMeetingInput`](crate::input::CreateMeetingInput)
pub mod create_meeting_input {
    /// A builder for [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) media_region: std::option::Option<std::string::String>,
        pub(crate) meeting_host_id: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) notifications_configuration:
            std::option::Option<crate::model::NotificationsConfiguration>,
        pub(crate) meeting_features:
            std::option::Option<crate::model::MeetingFeaturesConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_host_id = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.meeting_host_id = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.notifications_configuration = Some(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.notifications_configuration = input;
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.meeting_features = Some(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.meeting_features = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingInput`](crate::input::CreateMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeetingInput {
                client_request_token: self.client_request_token,
                media_region: self.media_region,
                meeting_host_id: self.meeting_host_id,
                external_meeting_id: self.external_meeting_id,
                notifications_configuration: self.notifications_configuration,
                meeting_features: self.meeting_features,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeetingInputOperationOutputAlias = crate::operation::CreateMeeting;
#[doc(hidden)]
pub type CreateMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeetingInput {
    /// Consumes the builder and constructs an Operation<[`CreateMeeting`](crate::operation::CreateMeeting)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMeetingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/meetings").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMeetingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_meeting(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMeeting",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    pub fn builder() -> crate::input::create_meeting_input::Builder {
        crate::input::create_meeting_input::Builder::default()
    }
}

/// See [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
pub mod create_meeting_with_attendees_input {
    /// A builder for [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) media_region: std::option::Option<std::string::String>,
        pub(crate) meeting_host_id: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) meeting_features:
            std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        pub(crate) notifications_configuration:
            std::option::Option<crate::model::NotificationsConfiguration>,
        pub(crate) attendees:
            std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
    }
    impl Builder {
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_host_id = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.meeting_host_id = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.meeting_features = Some(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.meeting_features = input;
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.notifications_configuration = Some(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.notifications_configuration = input;
            self
        }
        /// Appends an item to `attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            let mut v = self.attendees.unwrap_or_default();
            v.push(input);
            self.attendees = Some(v);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.attendees = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeetingWithAttendeesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeetingWithAttendeesInput {
                client_request_token: self.client_request_token,
                media_region: self.media_region,
                meeting_host_id: self.meeting_host_id,
                external_meeting_id: self.external_meeting_id,
                meeting_features: self.meeting_features,
                notifications_configuration: self.notifications_configuration,
                attendees: self.attendees,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeetingWithAttendeesInputOperationOutputAlias =
    crate::operation::CreateMeetingWithAttendees;
#[doc(hidden)]
pub type CreateMeetingWithAttendeesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeetingWithAttendeesInput {
    /// Consumes the builder and constructs an Operation<[`CreateMeetingWithAttendees`](crate::operation::CreateMeetingWithAttendees)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMeetingWithAttendees,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMeetingWithAttendeesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/meetings").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateMeetingWithAttendeesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("operation", "create-attendees");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMeetingWithAttendeesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_meeting_with_attendees(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMeetingWithAttendees::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMeetingWithAttendees",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    pub fn builder() -> crate::input::create_meeting_with_attendees_input::Builder {
        crate::input::create_meeting_with_attendees_input::Builder::default()
    }
}

/// See [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
pub mod delete_attendee_input {
    /// A builder for [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAttendeeInput {
                meeting_id: self.meeting_id,
                attendee_id: self.attendee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAttendeeInputOperationOutputAlias = crate::operation::DeleteAttendee;
#[doc(hidden)]
pub type DeleteAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAttendee`](crate::operation::DeleteAttendee)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAttendeeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.meeting_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_3, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_4 = &_input.attendee_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let attendee_id = aws_smithy_http::label::fmt_string(input_4, false);
                if attendee_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/attendees/{AttendeeId}",
                    MeetingId = meeting_id,
                    AttendeeId = attendee_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAttendeeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAttendee",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    pub fn builder() -> crate::input::delete_attendee_input::Builder {
        crate::input::delete_attendee_input::Builder::default()
    }
}

/// See [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
pub mod delete_meeting_input {
    /// A builder for [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMeetingInput {
                meeting_id: self.meeting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMeetingInputOperationOutputAlias = crate::operation::DeleteMeeting;
#[doc(hidden)]
pub type DeleteMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMeetingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMeeting`](crate::operation::DeleteMeeting)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMeetingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.meeting_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_5, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/meetings/{MeetingId}", MeetingId = meeting_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMeetingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMeeting",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    pub fn builder() -> crate::input::delete_meeting_input::Builder {
        crate::input::delete_meeting_input::Builder::default()
    }
}

/// See [`GetAttendeeInput`](crate::input::GetAttendeeInput)
pub mod get_attendee_input {
    /// A builder for [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAttendeeInput`](crate::input::GetAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAttendeeInput {
                meeting_id: self.meeting_id,
                attendee_id: self.attendee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAttendeeInputOperationOutputAlias = crate::operation::GetAttendee;
#[doc(hidden)]
pub type GetAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`GetAttendee`](crate::operation::GetAttendee)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAttendeeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.meeting_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_6, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_7 = &_input.attendee_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let attendee_id = aws_smithy_http::label::fmt_string(input_7, false);
                if attendee_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/attendees/{AttendeeId}",
                    MeetingId = meeting_id,
                    AttendeeId = attendee_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAttendeeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAttendee",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    pub fn builder() -> crate::input::get_attendee_input::Builder {
        crate::input::get_attendee_input::Builder::default()
    }
}

/// See [`GetMeetingInput`](crate::input::GetMeetingInput)
pub mod get_meeting_input {
    /// A builder for [`GetMeetingInput`](crate::input::GetMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMeetingInput`](crate::input::GetMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMeetingInput {
                meeting_id: self.meeting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMeetingInputOperationOutputAlias = crate::operation::GetMeeting;
#[doc(hidden)]
pub type GetMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMeetingInput {
    /// Consumes the builder and constructs an Operation<[`GetMeeting`](crate::operation::GetMeeting)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMeetingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.meeting_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_8, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/meetings/{MeetingId}", MeetingId = meeting_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMeetingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMeeting",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMeetingInput`](crate::input::GetMeetingInput)
    pub fn builder() -> crate::input::get_meeting_input::Builder {
        crate::input::get_meeting_input::Builder::default()
    }
}

/// See [`ListAttendeesInput`](crate::input::ListAttendeesInput)
pub mod list_attendees_input {
    /// A builder for [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttendeesInput`](crate::input::ListAttendeesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttendeesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttendeesInput {
                meeting_id: self.meeting_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttendeesInputOperationOutputAlias = crate::operation::ListAttendees;
#[doc(hidden)]
pub type ListAttendeesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAttendeesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttendees`](crate::operation::ListAttendees)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttendees,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAttendeesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.meeting_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_9, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/attendees",
                    MeetingId = meeting_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAttendeesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                if let Some(inner_11) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_11).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAttendeesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttendees::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttendees",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    pub fn builder() -> crate::input::list_attendees_input::Builder {
        crate::input::list_attendees_input::Builder::default()
    }
}

/// See [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
pub mod start_meeting_transcription_input {
    /// A builder for [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) transcription_configuration:
            std::option::Option<crate::model::TranscriptionConfiguration>,
    }
    impl Builder {
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn transcription_configuration(
            mut self,
            input: crate::model::TranscriptionConfiguration,
        ) -> Self {
            self.transcription_configuration = Some(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn set_transcription_configuration(
            mut self,
            input: std::option::Option<crate::model::TranscriptionConfiguration>,
        ) -> Self {
            self.transcription_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMeetingTranscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMeetingTranscriptionInput {
                meeting_id: self.meeting_id,
                transcription_configuration: self.transcription_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMeetingTranscriptionInputOperationOutputAlias =
    crate::operation::StartMeetingTranscription;
#[doc(hidden)]
pub type StartMeetingTranscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMeetingTranscriptionInput {
    /// Consumes the builder and constructs an Operation<[`StartMeetingTranscription`](crate::operation::StartMeetingTranscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMeetingTranscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartMeetingTranscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.meeting_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_12, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/transcription",
                    MeetingId = meeting_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::StartMeetingTranscriptionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("operation", "start");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartMeetingTranscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_meeting_transcription(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMeetingTranscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMeetingTranscription",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
    pub fn builder() -> crate::input::start_meeting_transcription_input::Builder {
        crate::input::start_meeting_transcription_input::Builder::default()
    }
}

/// See [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
pub mod stop_meeting_transcription_input {
    /// A builder for [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopMeetingTranscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopMeetingTranscriptionInput {
                meeting_id: self.meeting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopMeetingTranscriptionInputOperationOutputAlias =
    crate::operation::StopMeetingTranscription;
#[doc(hidden)]
pub type StopMeetingTranscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopMeetingTranscriptionInput {
    /// Consumes the builder and constructs an Operation<[`StopMeetingTranscription`](crate::operation::StopMeetingTranscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopMeetingTranscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopMeetingTranscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.meeting_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let meeting_id = aws_smithy_http::label::fmt_string(input_13, false);
                if meeting_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/meetings/{MeetingId}/transcription",
                    MeetingId = meeting_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::StopMeetingTranscriptionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("operation", "stop");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopMeetingTranscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopMeetingTranscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopMeetingTranscription",
            "chimesdkmeetings",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
    pub fn builder() -> crate::input::stop_meeting_transcription_input::Builder {
        crate::input::stop_meeting_transcription_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMeetingTranscriptionInput {
    /// <p>The unique ID of the meeting for which you stop transcription.</p>
    pub meeting_id: std::option::Option<std::string::String>,
}
impl StopMeetingTranscriptionInput {
    /// <p>The unique ID of the meeting for which you stop transcription.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
}
impl std::fmt::Debug for StopMeetingTranscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMeetingTranscriptionInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMeetingTranscriptionInput {
    /// <p>The unique ID of the meeting being transcribed.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
    pub transcription_configuration: std::option::Option<crate::model::TranscriptionConfiguration>,
}
impl StartMeetingTranscriptionInput {
    /// <p>The unique ID of the meeting being transcribed.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
    pub fn transcription_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TranscriptionConfiguration> {
        self.transcription_configuration.as_ref()
    }
}
impl std::fmt::Debug for StartMeetingTranscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMeetingTranscriptionInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field(
            "transcription_configuration",
            &self.transcription_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttendeesInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAttendeesInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAttendeesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttendeesInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMeetingInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
}
impl GetMeetingInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
}
impl std::fmt::Debug for GetMeetingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMeetingInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAttendeeInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub attendee_id: std::option::Option<std::string::String>,
}
impl GetAttendeeInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub fn attendee_id(&self) -> std::option::Option<&str> {
        self.attendee_id.as_deref()
    }
}
impl std::fmt::Debug for GetAttendeeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAttendeeInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("attendee_id", &self.attendee_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMeetingInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
}
impl DeleteMeetingInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMeetingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMeetingInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAttendeeInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub attendee_id: std::option::Option<std::string::String>,
}
impl DeleteAttendeeInput {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub fn attendee_id(&self) -> std::option::Option<&str> {
        self.attendee_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAttendeeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAttendeeInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("attendee_id", &self.attendee_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMeetingWithAttendeesInput {
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Region in which to create the meeting.</p>
    pub media_region: std::option::Option<std::string::String>,
    /// <p>Reserved.</p>
    pub meeting_host_id: std::option::Option<std::string::String>,
    /// <p>The external meeting ID.</p>
    pub external_meeting_id: std::option::Option<std::string::String>,
    /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    pub meeting_features: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
    /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    pub notifications_configuration: std::option::Option<crate::model::NotificationsConfiguration>,
    /// <p>The attendee information, including attendees' IDs and join tokens.</p>
    pub attendees: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
}
impl CreateMeetingWithAttendeesInput {
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Region in which to create the meeting.</p>
    pub fn media_region(&self) -> std::option::Option<&str> {
        self.media_region.as_deref()
    }
    /// <p>Reserved.</p>
    pub fn meeting_host_id(&self) -> std::option::Option<&str> {
        self.meeting_host_id.as_deref()
    }
    /// <p>The external meeting ID.</p>
    pub fn external_meeting_id(&self) -> std::option::Option<&str> {
        self.external_meeting_id.as_deref()
    }
    /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    pub fn meeting_features(
        &self,
    ) -> std::option::Option<&crate::model::MeetingFeaturesConfiguration> {
        self.meeting_features.as_ref()
    }
    /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    pub fn notifications_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationsConfiguration> {
        self.notifications_configuration.as_ref()
    }
    /// <p>The attendee information, including attendees' IDs and join tokens.</p>
    pub fn attendees(&self) -> std::option::Option<&[crate::model::CreateAttendeeRequestItem]> {
        self.attendees.as_deref()
    }
}
impl std::fmt::Debug for CreateMeetingWithAttendeesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMeetingWithAttendeesInput");
        formatter.field("client_request_token", &"*** Sensitive Data Redacted ***");
        formatter.field("media_region", &self.media_region);
        formatter.field("meeting_host_id", &"*** Sensitive Data Redacted ***");
        formatter.field("external_meeting_id", &"*** Sensitive Data Redacted ***");
        formatter.field("meeting_features", &self.meeting_features);
        formatter.field(
            "notifications_configuration",
            &self.notifications_configuration,
        );
        formatter.field("attendees", &self.attendees);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMeetingInput {
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Region in which to create the meeting.</p>
    /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    pub media_region: std::option::Option<std::string::String>,
    /// <p>Reserved.</p>
    pub meeting_host_id: std::option::Option<std::string::String>,
    /// <p>The external meeting ID.</p>
    pub external_meeting_id: std::option::Option<std::string::String>,
    /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    pub notifications_configuration: std::option::Option<crate::model::NotificationsConfiguration>,
    /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    pub meeting_features: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
}
impl CreateMeetingInput {
    /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Region in which to create the meeting.</p>
    /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    pub fn media_region(&self) -> std::option::Option<&str> {
        self.media_region.as_deref()
    }
    /// <p>Reserved.</p>
    pub fn meeting_host_id(&self) -> std::option::Option<&str> {
        self.meeting_host_id.as_deref()
    }
    /// <p>The external meeting ID.</p>
    pub fn external_meeting_id(&self) -> std::option::Option<&str> {
        self.external_meeting_id.as_deref()
    }
    /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    pub fn notifications_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationsConfiguration> {
        self.notifications_configuration.as_ref()
    }
    /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    pub fn meeting_features(
        &self,
    ) -> std::option::Option<&crate::model::MeetingFeaturesConfiguration> {
        self.meeting_features.as_ref()
    }
}
impl std::fmt::Debug for CreateMeetingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMeetingInput");
        formatter.field("client_request_token", &"*** Sensitive Data Redacted ***");
        formatter.field("media_region", &self.media_region);
        formatter.field("meeting_host_id", &"*** Sensitive Data Redacted ***");
        formatter.field("external_meeting_id", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "notifications_configuration",
            &self.notifications_configuration,
        );
        formatter.field("meeting_features", &self.meeting_features);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttendeeInput {
    /// <p>The unique ID of the meeting.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
}
impl CreateAttendeeInput {
    /// <p>The unique ID of the meeting.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAttendeeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttendeeInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateAttendeeInput {
    /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The attendee information, including attendees' IDs and join tokens.</p>
    pub attendees: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
}
impl BatchCreateAttendeeInput {
    /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The attendee information, including attendees' IDs and join tokens.</p>
    pub fn attendees(&self) -> std::option::Option<&[crate::model::CreateAttendeeRequestItem]> {
        self.attendees.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateAttendeeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateAttendeeInput");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("attendees", &self.attendees);
        formatter.finish()
    }
}
