// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Chime SDK Meetings
///
/// Client for invoking operations on Amazon Chime SDK Meetings. Each operation on Amazon Chime SDK Meetings is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_chimesdkmeetings::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_chimesdkmeetings::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_chimesdkmeetings::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchCreateAttendee`](crate::client::fluent_builders::BatchCreateAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::BatchCreateAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::BatchCreateAttendee::set_meeting_id): <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
    ///   - [`attendees(Vec<CreateAttendeeRequestItem>)`](crate::client::fluent_builders::BatchCreateAttendee::attendees) / [`set_attendees(Option<Vec<CreateAttendeeRequestItem>>)`](crate::client::fluent_builders::BatchCreateAttendee::set_attendees): <p>The attendee information, including attendees' IDs and join tokens.</p>
    /// - On success, responds with [`BatchCreateAttendeeOutput`](crate::output::BatchCreateAttendeeOutput) with field(s):
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::BatchCreateAttendeeOutput::attendees): <p>The attendee information, including attendees' IDs and join tokens.</p>
    ///   - [`errors(Option<Vec<CreateAttendeeError>>)`](crate::output::BatchCreateAttendeeOutput::errors): <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchCreateAttendeeError>`](crate::error::BatchCreateAttendeeError)
    pub fn batch_create_attendee(&self) -> fluent_builders::BatchCreateAttendee {
        fluent_builders::BatchCreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAttendee`](crate::client::fluent_builders::CreateAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateAttendee::set_meeting_id): <p>The unique ID of the meeting.</p>
    ///   - [`external_user_id(impl Into<String>)`](crate::client::fluent_builders::CreateAttendee::external_user_id) / [`set_external_user_id(Option<String>)`](crate::client::fluent_builders::CreateAttendee::set_external_user_id): <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    /// - On success, responds with [`CreateAttendeeOutput`](crate::output::CreateAttendeeOutput) with field(s):
    ///   - [`attendee(Option<Attendee>)`](crate::output::CreateAttendeeOutput::attendee): <p>The attendee information, including attendee ID and join token.</p>
    /// - On failure, responds with [`SdkError<CreateAttendeeError>`](crate::error::CreateAttendeeError)
    pub fn create_attendee(&self) -> fluent_builders::CreateAttendee {
        fluent_builders::CreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMeeting`](crate::client::fluent_builders::CreateMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_client_request_token): <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    ///   - [`media_region(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::media_region) / [`set_media_region(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_media_region): <p>The Region in which to create the meeting.</p>  <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    ///   - [`meeting_host_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::meeting_host_id) / [`set_meeting_host_id(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_meeting_host_id): <p>Reserved.</p>
    ///   - [`external_meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::external_meeting_id) / [`set_external_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_external_meeting_id): <p>The external meeting ID.</p>
    ///   - [`notifications_configuration(NotificationsConfiguration)`](crate::client::fluent_builders::CreateMeeting::notifications_configuration) / [`set_notifications_configuration(Option<NotificationsConfiguration>)`](crate::client::fluent_builders::CreateMeeting::set_notifications_configuration): <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    ///   - [`meeting_features(MeetingFeaturesConfiguration)`](crate::client::fluent_builders::CreateMeeting::meeting_features) / [`set_meeting_features(Option<MeetingFeaturesConfiguration>)`](crate::client::fluent_builders::CreateMeeting::set_meeting_features): <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    /// - On success, responds with [`CreateMeetingOutput`](crate::output::CreateMeetingOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::CreateMeetingOutput::meeting): <p>The meeting information, including the meeting ID and <code>MediaPlacement</code>.</p>
    /// - On failure, responds with [`SdkError<CreateMeetingError>`](crate::error::CreateMeetingError)
    pub fn create_meeting(&self) -> fluent_builders::CreateMeeting {
        fluent_builders::CreateMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMeetingWithAttendees`](crate::client::fluent_builders::CreateMeetingWithAttendees) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_client_request_token): <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    ///   - [`media_region(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::media_region) / [`set_media_region(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_media_region): <p>The Region in which to create the meeting.</p>
    ///   - [`meeting_host_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::meeting_host_id) / [`set_meeting_host_id(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_meeting_host_id): <p>Reserved.</p>
    ///   - [`external_meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::external_meeting_id) / [`set_external_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_external_meeting_id): <p>The external meeting ID.</p>
    ///   - [`meeting_features(MeetingFeaturesConfiguration)`](crate::client::fluent_builders::CreateMeetingWithAttendees::meeting_features) / [`set_meeting_features(Option<MeetingFeaturesConfiguration>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_meeting_features): <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
    ///   - [`notifications_configuration(NotificationsConfiguration)`](crate::client::fluent_builders::CreateMeetingWithAttendees::notifications_configuration) / [`set_notifications_configuration(Option<NotificationsConfiguration>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_notifications_configuration): <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    ///   - [`attendees(Vec<CreateAttendeeRequestItem>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::attendees) / [`set_attendees(Option<Vec<CreateAttendeeRequestItem>>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_attendees): <p>The attendee information, including attendees' IDs and join tokens.</p>
    /// - On success, responds with [`CreateMeetingWithAttendeesOutput`](crate::output::CreateMeetingWithAttendeesOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::CreateMeetingWithAttendeesOutput::meeting): <p>The meeting information, including the meeting ID and <code>MediaPlacement</code>.</p>
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::CreateMeetingWithAttendeesOutput::attendees): <p>The attendee information, including attendees' IDs and join tokens.</p>
    ///   - [`errors(Option<Vec<CreateAttendeeError>>)`](crate::output::CreateMeetingWithAttendeesOutput::errors): <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<CreateMeetingWithAttendeesError>`](crate::error::CreateMeetingWithAttendeesError)
    pub fn create_meeting_with_attendees(&self) -> fluent_builders::CreateMeetingWithAttendees {
        fluent_builders::CreateMeetingWithAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAttendee`](crate::client::fluent_builders::DeleteAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::DeleteAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::DeleteAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    /// - On success, responds with [`DeleteAttendeeOutput`](crate::output::DeleteAttendeeOutput)

    /// - On failure, responds with [`SdkError<DeleteAttendeeError>`](crate::error::DeleteAttendeeError)
    pub fn delete_attendee(&self) -> fluent_builders::DeleteAttendee {
        fluent_builders::DeleteAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMeeting`](crate::client::fluent_builders::DeleteMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::DeleteMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    /// - On success, responds with [`DeleteMeetingOutput`](crate::output::DeleteMeetingOutput)

    /// - On failure, responds with [`SdkError<DeleteMeetingError>`](crate::error::DeleteMeetingError)
    pub fn delete_meeting(&self) -> fluent_builders::DeleteMeeting {
        fluent_builders::DeleteMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAttendee`](crate::client::fluent_builders::GetAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::GetAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::GetAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::GetAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::GetAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    /// - On success, responds with [`GetAttendeeOutput`](crate::output::GetAttendeeOutput) with field(s):
    ///   - [`attendee(Option<Attendee>)`](crate::output::GetAttendeeOutput::attendee): <p>The Amazon Chime SDK attendee information.</p>
    /// - On failure, responds with [`SdkError<GetAttendeeError>`](crate::error::GetAttendeeError)
    pub fn get_attendee(&self) -> fluent_builders::GetAttendee {
        fluent_builders::GetAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMeeting`](crate::client::fluent_builders::GetMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::GetMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::GetMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    /// - On success, responds with [`GetMeetingOutput`](crate::output::GetMeetingOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::GetMeetingOutput::meeting): <p>The Amazon Chime SDK meeting information.</p>
    /// - On failure, responds with [`SdkError<GetMeetingError>`](crate::error::GetMeetingError)
    pub fn get_meeting(&self) -> fluent_builders::GetMeeting {
        fluent_builders::GetMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttendees`](crate::client::fluent_builders::ListAttendees) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttendees::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::ListAttendees::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::ListAttendees::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttendees::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttendees::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttendees::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttendees::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListAttendeesOutput`](crate::output::ListAttendeesOutput) with field(s):
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::ListAttendeesOutput::attendees): <p>The Amazon Chime SDK attendee information.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttendeesOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListAttendeesError>`](crate::error::ListAttendeesError)
    pub fn list_attendees(&self) -> fluent_builders::ListAttendees {
        fluent_builders::ListAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMeetingTranscription`](crate::client::fluent_builders::StartMeetingTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::StartMeetingTranscription::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::StartMeetingTranscription::set_meeting_id): <p>The unique ID of the meeting being transcribed.</p>
    ///   - [`transcription_configuration(TranscriptionConfiguration)`](crate::client::fluent_builders::StartMeetingTranscription::transcription_configuration) / [`set_transcription_configuration(Option<TranscriptionConfiguration>)`](crate::client::fluent_builders::StartMeetingTranscription::set_transcription_configuration): <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
    /// - On success, responds with [`StartMeetingTranscriptionOutput`](crate::output::StartMeetingTranscriptionOutput)

    /// - On failure, responds with [`SdkError<StartMeetingTranscriptionError>`](crate::error::StartMeetingTranscriptionError)
    pub fn start_meeting_transcription(&self) -> fluent_builders::StartMeetingTranscription {
        fluent_builders::StartMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopMeetingTranscription`](crate::client::fluent_builders::StopMeetingTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::StopMeetingTranscription::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::StopMeetingTranscription::set_meeting_id): <p>The unique ID of the meeting for which you stop transcription.</p>
    /// - On success, responds with [`StopMeetingTranscriptionOutput`](crate::output::StopMeetingTranscriptionOutput)

    /// - On failure, responds with [`SdkError<StopMeetingTranscriptionError>`](crate::error::StopMeetingTranscriptionError)
    pub fn stop_meeting_transcription(&self) -> fluent_builders::StopMeetingTranscription {
        fluent_builders::StopMeetingTranscription::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreateAttendee`.
    ///
    /// <p>Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateAttendee {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_create_attendee_input::Builder,
    }
    impl BatchCreateAttendee {
        /// Creates a new `BatchCreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateAttendeeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAttendee`.
    ///
    /// <p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAttendee {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_attendee_input::Builder,
    }
    impl CreateAttendee {
        /// Creates a new `CreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAttendeeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_user_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeeting`.
    ///
    /// <p>Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeeting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_meeting_input::Builder,
    }
    impl CreateMeeting {
        /// Creates a new `CreateMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_features(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_features(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingWithAttendees`.
    ///
    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeetingWithAttendees {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_meeting_with_attendees_input::Builder,
    }
    impl CreateMeetingWithAttendees {
        /// Creates a new `CreateMeetingWithAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingWithAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingWithAttendeesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_features(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_features(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttendee`.
    ///
    /// <p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttendee {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_attendee_input::Builder,
    }
    impl DeleteAttendee {
        /// Creates a new `DeleteAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttendeeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMeeting`.
    ///
    /// <p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMeeting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_meeting_input::Builder,
    }
    impl DeleteMeeting {
        /// Creates a new `DeleteMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeetingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttendee`.
    ///
    /// <p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAttendee {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_attendee_input::Builder,
    }
    impl GetAttendee {
        /// Creates a new `GetAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttendeeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMeeting`.
    ///
    /// <p>Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMeeting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_meeting_input::Builder,
    }
    impl GetMeeting {
        /// Creates a new `GetMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMeetingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendees`.
    ///
    /// <p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttendees {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_attendees_input::Builder,
    }
    impl ListAttendees {
        /// Creates a new `ListAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttendeesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttendeesPaginator {
            crate::paginator::ListAttendeesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMeetingTranscription`.
    ///
    /// <p>Starts transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMeetingTranscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_meeting_transcription_input::Builder,
    }
    impl StartMeetingTranscription {
        /// Creates a new `StartMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMeetingTranscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn transcription_configuration(
            mut self,
            input: crate::model::TranscriptionConfiguration,
        ) -> Self {
            self.inner = self.inner.transcription_configuration(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn set_transcription_configuration(
            mut self,
            input: std::option::Option<crate::model::TranscriptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_transcription_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMeetingTranscription`.
    ///
    /// <p>Stops transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopMeetingTranscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_meeting_transcription_input::Builder,
    }
    impl StopMeetingTranscription {
        /// Creates a new `StopMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMeetingTranscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
