// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchCreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateAttendeeError {
    /// Kind of error that occurred.
    pub kind: BatchCreateAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateAttendeeError {
    fn code(&self) -> Option<&str> {
        BatchCreateAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateAttendeeError {
    /// Creates a new `BatchCreateAttendeeError`.
    pub fn new(kind: BatchCreateAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for BatchCreateAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::LimitExceededException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAttendeeError {
    /// Kind of error that occurred.
    pub kind: CreateAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAttendeeError {
    fn code(&self) -> Option<&str> {
        CreateAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAttendeeError {
    /// Creates a new `CreateAttendeeError`.
    pub fn new(kind: CreateAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreateAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeetingError {
    /// Kind of error that occurred.
    pub kind: CreateMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request exceeds the resource limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeetingError {
    fn code(&self) -> Option<&str> {
        CreateMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMeetingError {
    /// Creates a new `CreateMeetingError`.
    pub fn new(kind: CreateMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateMeetingErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeetingErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateMeetingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMeetingWithAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeetingWithAttendeesError {
    /// Kind of error that occurred.
    pub kind: CreateMeetingWithAttendeesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMeetingWithAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeetingWithAttendeesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request exceeds the resource limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeetingWithAttendeesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateMeetingWithAttendeesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeetingWithAttendeesError {
    fn code(&self) -> Option<&str> {
        CreateMeetingWithAttendeesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMeetingWithAttendeesError {
    /// Creates a new `CreateMeetingWithAttendeesError`.
    pub fn new(kind: CreateMeetingWithAttendeesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeetingWithAttendeesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeetingWithAttendeesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeetingWithAttendeesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeetingWithAttendeesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateMeetingWithAttendeesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateMeetingWithAttendeesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAttendeeError {
    /// Kind of error that occurred.
    pub kind: DeleteAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAttendeeErrorKind {
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAttendeeError {
    fn code(&self) -> Option<&str> {
        DeleteAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAttendeeError {
    /// Creates a new `DeleteAttendeeError`.
    pub fn new(kind: DeleteAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttendeeErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMeetingError {
    /// Kind of error that occurred.
    pub kind: DeleteMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMeetingError {
    fn code(&self) -> Option<&str> {
        DeleteMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMeetingError {
    /// Creates a new `DeleteMeetingError`.
    pub fn new(kind: DeleteMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeetingErrorKind::ForbiddenException(_))
    }
}
impl std::error::Error for DeleteMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAttendeeError {
    /// Kind of error that occurred.
    pub kind: GetAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAttendeeError {
    fn code(&self) -> Option<&str> {
        GetAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAttendeeError {
    /// Creates a new `GetAttendeeError`.
    pub fn new(kind: GetAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMeetingError {
    /// Kind of error that occurred.
    pub kind: GetMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMeetingError {
    fn code(&self) -> Option<&str> {
        GetMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMeetingError {
    /// Creates a new `GetMeetingError`.
    pub fn new(kind: GetMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMeetingErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetMeetingErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttendeesError {
    /// Kind of error that occurred.
    pub kind: ListAttendeesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttendeesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttendeesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttendeesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttendeesError {
    fn code(&self) -> Option<&str> {
        ListAttendeesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttendeesError {
    /// Creates a new `ListAttendeesError`.
    pub fn new(kind: ListAttendeesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttendeesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttendeesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttendeesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttendeesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListAttendeesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttendeesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAttendeesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAttendeesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAttendeesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMeetingTranscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMeetingTranscriptionError {
    /// Kind of error that occurred.
    pub kind: StartMeetingTranscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMeetingTranscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMeetingTranscriptionErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMeetingTranscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMeetingTranscriptionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartMeetingTranscriptionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StartMeetingTranscriptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartMeetingTranscriptionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartMeetingTranscriptionErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartMeetingTranscriptionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartMeetingTranscriptionErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            StartMeetingTranscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMeetingTranscriptionError {
    fn code(&self) -> Option<&str> {
        StartMeetingTranscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMeetingTranscriptionError {
    /// Creates a new `StartMeetingTranscriptionError`.
    pub fn new(kind: StartMeetingTranscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMeetingTranscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMeetingTranscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMeetingTranscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMeetingTranscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMeetingTranscriptionErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMeetingTranscriptionErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for StartMeetingTranscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMeetingTranscriptionErrorKind::BadRequestException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::ForbiddenException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::NotFoundException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartMeetingTranscriptionErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            StartMeetingTranscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopMeetingTranscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopMeetingTranscriptionError {
    /// Kind of error that occurred.
    pub kind: StopMeetingTranscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopMeetingTranscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopMeetingTranscriptionErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The user isn't authorized to request a resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopMeetingTranscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopMeetingTranscriptionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopMeetingTranscriptionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StopMeetingTranscriptionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopMeetingTranscriptionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopMeetingTranscriptionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StopMeetingTranscriptionErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            StopMeetingTranscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopMeetingTranscriptionError {
    fn code(&self) -> Option<&str> {
        StopMeetingTranscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopMeetingTranscriptionError {
    /// Creates a new `StopMeetingTranscriptionError`.
    pub fn new(kind: StopMeetingTranscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopMeetingTranscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopMeetingTranscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopMeetingTranscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopMeetingTranscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMeetingTranscriptionErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMeetingTranscriptionErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for StopMeetingTranscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopMeetingTranscriptionErrorKind::BadRequestException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::ForbiddenException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::NotFoundException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            StopMeetingTranscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessableEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UnprocessableEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessableEntityException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UnprocessableEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnprocessableEntityException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnprocessableEntityException {}
/// See [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
pub mod unprocessable_entity_exception {
    /// A builder for [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
        pub fn build(self) -> crate::error::UnprocessableEntityException {
            crate::error::UnprocessableEntityException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UnprocessableEntityException {
    /// Creates a new builder-style object to manufacture [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    pub fn builder() -> crate::error::unprocessable_entity_exception::Builder {
        crate::error::unprocessable_entity_exception::Builder::default()
    }
}

/// <p>The user isn't authorized to request a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The service is currently unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The number of seconds the caller should wait before retrying.</p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
}
impl ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The number of seconds the caller should wait before retrying.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>One or more of the resources in the request does not exist in the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The client is permanently forbidden from making the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>The input parameters don't match the service's restrictions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The request exceeds the resource limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The request id associated with the call responsible for the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request id associated with the call responsible for the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                code: self.code,
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
