// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Chime SDK Meetings
///
/// Client for invoking operations on Amazon Chime SDK Meetings. Each operation on Amazon Chime SDK Meetings is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_chimesdkmeetings::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_chimesdkmeetings::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_chimesdkmeetings::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCreateAttendee` operation.
    ///
    /// See [`BatchCreateAttendee`](crate::client::fluent_builders::BatchCreateAttendee) for more information about the
    /// operation and its arguments.
    pub fn batch_create_attendee(&self) -> fluent_builders::BatchCreateAttendee<C, M, R> {
        fluent_builders::BatchCreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAttendee` operation.
    ///
    /// See [`CreateAttendee`](crate::client::fluent_builders::CreateAttendee) for more information about the
    /// operation and its arguments.
    pub fn create_attendee(&self) -> fluent_builders::CreateAttendee<C, M, R> {
        fluent_builders::CreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMeeting` operation.
    ///
    /// See [`CreateMeeting`](crate::client::fluent_builders::CreateMeeting) for more information about the
    /// operation and its arguments.
    pub fn create_meeting(&self) -> fluent_builders::CreateMeeting<C, M, R> {
        fluent_builders::CreateMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMeetingWithAttendees` operation.
    ///
    /// See [`CreateMeetingWithAttendees`](crate::client::fluent_builders::CreateMeetingWithAttendees) for more information about the
    /// operation and its arguments.
    pub fn create_meeting_with_attendees(
        &self,
    ) -> fluent_builders::CreateMeetingWithAttendees<C, M, R> {
        fluent_builders::CreateMeetingWithAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAttendee` operation.
    ///
    /// See [`DeleteAttendee`](crate::client::fluent_builders::DeleteAttendee) for more information about the
    /// operation and its arguments.
    pub fn delete_attendee(&self) -> fluent_builders::DeleteAttendee<C, M, R> {
        fluent_builders::DeleteAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMeeting` operation.
    ///
    /// See [`DeleteMeeting`](crate::client::fluent_builders::DeleteMeeting) for more information about the
    /// operation and its arguments.
    pub fn delete_meeting(&self) -> fluent_builders::DeleteMeeting<C, M, R> {
        fluent_builders::DeleteMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAttendee` operation.
    ///
    /// See [`GetAttendee`](crate::client::fluent_builders::GetAttendee) for more information about the
    /// operation and its arguments.
    pub fn get_attendee(&self) -> fluent_builders::GetAttendee<C, M, R> {
        fluent_builders::GetAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMeeting` operation.
    ///
    /// See [`GetMeeting`](crate::client::fluent_builders::GetMeeting) for more information about the
    /// operation and its arguments.
    pub fn get_meeting(&self) -> fluent_builders::GetMeeting<C, M, R> {
        fluent_builders::GetMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttendees` operation.
    ///
    /// See [`ListAttendees`](crate::client::fluent_builders::ListAttendees) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAttendees::into_paginator).
    pub fn list_attendees(&self) -> fluent_builders::ListAttendees<C, M, R> {
        fluent_builders::ListAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMeetingTranscription` operation.
    ///
    /// See [`StartMeetingTranscription`](crate::client::fluent_builders::StartMeetingTranscription) for more information about the
    /// operation and its arguments.
    pub fn start_meeting_transcription(
        &self,
    ) -> fluent_builders::StartMeetingTranscription<C, M, R> {
        fluent_builders::StartMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopMeetingTranscription` operation.
    ///
    /// See [`StopMeetingTranscription`](crate::client::fluent_builders::StopMeetingTranscription) for more information about the
    /// operation and its arguments.
    pub fn stop_meeting_transcription(&self) -> fluent_builders::StopMeetingTranscription<C, M, R> {
        fluent_builders::StopMeetingTranscription::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreateAttendee`.
    ///
    /// <p>Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_attendee_input::Builder,
    }
    impl<C, M, R> BatchCreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateAttendeeInputOperationOutputAlias,
                crate::output::BatchCreateAttendeeOutput,
                crate::error::BatchCreateAttendeeError,
                crate::input::BatchCreateAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK ID of the meeting to which you're adding attendees.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAttendee`.
    ///
    /// <p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_attendee_input::Builder,
    }
    impl<C, M, R> CreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAttendeeInputOperationOutputAlias,
                crate::output::CreateAttendeeOutput,
                crate::error::CreateAttendeeError,
                crate::input::CreateAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_user_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeeting`.
    ///
    /// <p>Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_input::Builder,
    }
    impl<C, M, R> CreateMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingInputOperationOutputAlias,
                crate::output::CreateMeetingOutput,
                crate::error::CreateMeetingError,
                crate::input::CreateMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_features(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_features(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingWithAttendees`.
    ///
    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeetingWithAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_with_attendees_input::Builder,
    }
    impl<C, M, R> CreateMeetingWithAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeetingWithAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingWithAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingWithAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingWithAttendeesInputOperationOutputAlias,
                crate::output::CreateMeetingWithAttendeesOutput,
                crate::error::CreateMeetingWithAttendeesError,
                crate::input::CreateMeetingWithAttendeesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p>The Region in which to create the meeting.</p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn meeting_features(
            mut self,
            input: crate::model::MeetingFeaturesConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_features(input);
            self
        }
        /// <p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>
        pub fn set_meeting_features(
            mut self,
            input: std::option::Option<crate::model::MeetingFeaturesConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_features(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::NotificationsConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The attendee information, including attendees' IDs and join tokens.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttendee`.
    ///
    /// <p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_attendee_input::Builder,
    }
    impl<C, M, R> DeleteAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAttendeeInputOperationOutputAlias,
                crate::output::DeleteAttendeeOutput,
                crate::error::DeleteAttendeeError,
                crate::input::DeleteAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMeeting`.
    ///
    /// <p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_meeting_input::Builder,
    }
    impl<C, M, R> DeleteMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMeetingInputOperationOutputAlias,
                crate::output::DeleteMeetingOutput,
                crate::error::DeleteMeetingError,
                crate::input::DeleteMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttendee`.
    ///
    /// <p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attendee_input::Builder,
    }
    impl<C, M, R> GetAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttendeeInputOperationOutputAlias,
                crate::output::GetAttendeeOutput,
                crate::error::GetAttendeeError,
                crate::input::GetAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMeeting`.
    ///
    /// <p>Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_meeting_input::Builder,
    }
    impl<C, M, R> GetMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMeetingInputOperationOutputAlias,
                crate::output::GetMeetingOutput,
                crate::error::GetMeetingError,
                crate::input::GetMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendees`.
    ///
    /// <p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attendees_input::Builder,
    }
    impl<C, M, R> ListAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttendeesInputOperationOutputAlias,
                crate::output::ListAttendeesOutput,
                crate::error::ListAttendeesError,
                crate::input::ListAttendeesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttendeesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttendeesPaginator<C, M, R> {
            crate::paginator::ListAttendeesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMeetingTranscription`.
    ///
    /// <p>Starts transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StartMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StartMeetingTranscriptionOutput,
                crate::error::StartMeetingTranscriptionError,
                crate::input::StartMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn transcription_configuration(
            mut self,
            input: crate::model::TranscriptionConfiguration,
        ) -> Self {
            self.inner = self.inner.transcription_configuration(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn set_transcription_configuration(
            mut self,
            input: std::option::Option<crate::model::TranscriptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_transcription_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMeetingTranscription`.
    ///
    /// <p>Stops transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StopMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StopMeetingTranscriptionOutput,
                crate::error::StopMeetingTranscriptionError,
                crate::input::StopMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
