// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    BadRequest,
    #[allow(missing_docs)] // documentation missing in model
    Conflict,
    #[allow(missing_docs)] // documentation missing in model
    Forbidden,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberAssociationsExist,
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ServiceFailure,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    #[allow(missing_docs)] // documentation missing in model
    Unauthorized,
    #[allow(missing_docs)] // documentation missing in model
    Unprocessable,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnectorGroupAssociationsExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => ErrorCode::AccessDenied,
            "BadRequest" => ErrorCode::BadRequest,
            "Conflict" => ErrorCode::Conflict,
            "Forbidden" => ErrorCode::Forbidden,
            "NotFound" => ErrorCode::NotFound,
            "PhoneNumberAssociationsExist" => ErrorCode::PhoneNumberAssociationsExist,
            "PreconditionFailed" => ErrorCode::PreconditionFailed,
            "ResourceLimitExceeded" => ErrorCode::ResourceLimitExceeded,
            "ServiceFailure" => ErrorCode::ServiceFailure,
            "ServiceUnavailable" => ErrorCode::ServiceUnavailable,
            "Throttled" => ErrorCode::Throttled,
            "Throttling" => ErrorCode::Throttling,
            "Unauthorized" => ErrorCode::Unauthorized,
            "Unprocessable" => ErrorCode::Unprocessable,
            "VoiceConnectorGroupAssociationsExist" => {
                ErrorCode::VoiceConnectorGroupAssociationsExist
            }
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "AccessDenied",
            ErrorCode::BadRequest => "BadRequest",
            ErrorCode::Conflict => "Conflict",
            ErrorCode::Forbidden => "Forbidden",
            ErrorCode::NotFound => "NotFound",
            ErrorCode::PhoneNumberAssociationsExist => "PhoneNumberAssociationsExist",
            ErrorCode::PreconditionFailed => "PreconditionFailed",
            ErrorCode::ResourceLimitExceeded => "ResourceLimitExceeded",
            ErrorCode::ServiceFailure => "ServiceFailure",
            ErrorCode::ServiceUnavailable => "ServiceUnavailable",
            ErrorCode::Throttled => "Throttled",
            ErrorCode::Throttling => "Throttling",
            ErrorCode::Unauthorized => "Unauthorized",
            ErrorCode::Unprocessable => "Unprocessable",
            ErrorCode::VoiceConnectorGroupAssociationsExist => {
                "VoiceConnectorGroupAssociationsExist"
            }
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "BadRequest",
            "Conflict",
            "Forbidden",
            "NotFound",
            "PhoneNumberAssociationsExist",
            "PreconditionFailed",
            "ResourceLimitExceeded",
            "ServiceFailure",
            "ServiceUnavailable",
            "Throttled",
            "Throttling",
            "Unauthorized",
            "Unprocessable",
            "VoiceConnectorGroupAssociationsExist",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AllowMessages {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AllowMessages {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => AllowMessages::All,
            "NONE" => AllowMessages::None,
            other => AllowMessages::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AllowMessages {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AllowMessages::from(s))
    }
}
impl AllowMessages {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AllowMessages::All => "ALL",
            AllowMessages::None => "NONE",
            AllowMessages::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "NONE"]
    }
}
impl AsRef<str> for AllowMessages {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A tag object containing a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key in a tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value in a tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key in a tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value in a tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key in a tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key in a tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value in a tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value in a tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The attributes of an <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAttributes {
    /// <p>The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.</p>
    pub device_token: std::option::Option<std::string::String>,
    /// <p>The VOIP device token for the APNS and APNS_SANDBOX endpoint types.</p>
    pub voip_device_token: std::option::Option<std::string::String>,
}
impl EndpointAttributes {
    /// <p>The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.</p>
    pub fn device_token(&self) -> std::option::Option<&str> {
        self.device_token.as_deref()
    }
    /// <p>The VOIP device token for the APNS and APNS_SANDBOX endpoint types.</p>
    pub fn voip_device_token(&self) -> std::option::Option<&str> {
        self.voip_device_token.as_deref()
    }
}
impl std::fmt::Debug for EndpointAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAttributes");
        formatter.field("device_token", &"*** Sensitive Data Redacted ***");
        formatter.field("voip_device_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EndpointAttributes`](crate::model::EndpointAttributes)
pub mod endpoint_attributes {
    /// A builder for [`EndpointAttributes`](crate::model::EndpointAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_token: std::option::Option<std::string::String>,
        pub(crate) voip_device_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.</p>
        pub fn device_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_token = Some(input.into());
            self
        }
        /// <p>The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.</p>
        pub fn set_device_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_token = input;
            self
        }
        /// <p>The VOIP device token for the APNS and APNS_SANDBOX endpoint types.</p>
        pub fn voip_device_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.voip_device_token = Some(input.into());
            self
        }
        /// <p>The VOIP device token for the APNS and APNS_SANDBOX endpoint types.</p>
        pub fn set_voip_device_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voip_device_token = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAttributes`](crate::model::EndpointAttributes)
        pub fn build(self) -> crate::model::EndpointAttributes {
            crate::model::EndpointAttributes {
                device_token: self.device_token,
                voip_device_token: self.voip_device_token,
            }
        }
    }
}
impl EndpointAttributes {
    /// Creates a new builder-style object to manufacture [`EndpointAttributes`](crate::model::EndpointAttributes)
    pub fn builder() -> crate::model::endpoint_attributes::Builder {
        crate::model::endpoint_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppInstanceUserEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Apns,
    #[allow(missing_docs)] // documentation missing in model
    ApnsSandbox,
    #[allow(missing_docs)] // documentation missing in model
    Gcm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppInstanceUserEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "APNS" => AppInstanceUserEndpointType::Apns,
            "APNS_SANDBOX" => AppInstanceUserEndpointType::ApnsSandbox,
            "GCM" => AppInstanceUserEndpointType::Gcm,
            other => AppInstanceUserEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppInstanceUserEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppInstanceUserEndpointType::from(s))
    }
}
impl AppInstanceUserEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppInstanceUserEndpointType::Apns => "APNS",
            AppInstanceUserEndpointType::ApnsSandbox => "APNS_SANDBOX",
            AppInstanceUserEndpointType::Gcm => "GCM",
            AppInstanceUserEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APNS", "APNS_SANDBOX", "GCM"]
    }
}
impl AsRef<str> for AppInstanceUserEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the data-retention settings for an <code>AppInstance</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceRetentionSettings {
    /// <p>The length of time in days to retain the messages in a channel.</p>
    pub channel_retention_settings: std::option::Option<crate::model::ChannelRetentionSettings>,
}
impl AppInstanceRetentionSettings {
    /// <p>The length of time in days to retain the messages in a channel.</p>
    pub fn channel_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::ChannelRetentionSettings> {
        self.channel_retention_settings.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceRetentionSettings");
        formatter.field(
            "channel_retention_settings",
            &self.channel_retention_settings,
        );
        formatter.finish()
    }
}
/// See [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
pub mod app_instance_retention_settings {
    /// A builder for [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_retention_settings:
            std::option::Option<crate::model::ChannelRetentionSettings>,
    }
    impl Builder {
        /// <p>The length of time in days to retain the messages in a channel.</p>
        pub fn channel_retention_settings(
            mut self,
            input: crate::model::ChannelRetentionSettings,
        ) -> Self {
            self.channel_retention_settings = Some(input);
            self
        }
        /// <p>The length of time in days to retain the messages in a channel.</p>
        pub fn set_channel_retention_settings(
            mut self,
            input: std::option::Option<crate::model::ChannelRetentionSettings>,
        ) -> Self {
            self.channel_retention_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
        pub fn build(self) -> crate::model::AppInstanceRetentionSettings {
            crate::model::AppInstanceRetentionSettings {
                channel_retention_settings: self.channel_retention_settings,
            }
        }
    }
}
impl AppInstanceRetentionSettings {
    /// Creates a new builder-style object to manufacture [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
    pub fn builder() -> crate::model::app_instance_retention_settings::Builder {
        crate::model::app_instance_retention_settings::Builder::default()
    }
}

/// <p>The details of the retention settings for a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelRetentionSettings {
    /// <p>The time in days to retain the messages in a channel.</p>
    pub retention_days: std::option::Option<i32>,
}
impl ChannelRetentionSettings {
    /// <p>The time in days to retain the messages in a channel.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for ChannelRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelRetentionSettings");
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}
/// See [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
pub mod channel_retention_settings {
    /// A builder for [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The time in days to retain the messages in a channel.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The time in days to retain the messages in a channel.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
        pub fn build(self) -> crate::model::ChannelRetentionSettings {
            crate::model::ChannelRetentionSettings {
                retention_days: self.retention_days,
            }
        }
    }
}
impl ChannelRetentionSettings {
    /// Creates a new builder-style object to manufacture [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
    pub fn builder() -> crate::model::channel_retention_settings::Builder {
        crate::model::channel_retention_settings::Builder::default()
    }
}

/// <p>Summary of the details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The name of an <code>AppInstanceUser</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl AppInstanceUserSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The name of an <code>AppInstanceUser</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for AppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserSummary");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
pub mod app_instance_user_summary {
    /// A builder for [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The name of an <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
        pub fn build(self) -> crate::model::AppInstanceUserSummary {
            crate::model::AppInstanceUserSummary {
                app_instance_user_arn: self.app_instance_user_arn,
                name: self.name,
                metadata: self.metadata,
            }
        }
    }
}
impl AppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
    pub fn builder() -> crate::model::app_instance_user_summary::Builder {
        crate::model::app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the details of an <code>AppInstanceUserEndpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserEndpointSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
    pub r#type: std::option::Option<crate::model::AppInstanceUserEndpointType>,
    /// <p>BBoolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
    pub allow_messages: std::option::Option<crate::model::AllowMessages>,
    /// <p>A read-only field that represent the state of an <code>AppInstanceUserEndpoint</code>.</p>
    pub endpoint_state: std::option::Option<crate::model::EndpointState>,
}
impl AppInstanceUserEndpointSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AppInstanceUserEndpointType> {
        self.r#type.as_ref()
    }
    /// <p>BBoolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
    pub fn allow_messages(&self) -> std::option::Option<&crate::model::AllowMessages> {
        self.allow_messages.as_ref()
    }
    /// <p>A read-only field that represent the state of an <code>AppInstanceUserEndpoint</code>.</p>
    pub fn endpoint_state(&self) -> std::option::Option<&crate::model::EndpointState> {
        self.endpoint_state.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceUserEndpointSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserEndpointSummary");
        formatter.field("app_instance_user_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_id", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("allow_messages", &self.allow_messages);
        formatter.field("endpoint_state", &self.endpoint_state);
        formatter.finish()
    }
}
/// See [`AppInstanceUserEndpointSummary`](crate::model::AppInstanceUserEndpointSummary)
pub mod app_instance_user_endpoint_summary {
    /// A builder for [`AppInstanceUserEndpointSummary`](crate::model::AppInstanceUserEndpointSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        pub(crate) allow_messages: std::option::Option<crate::model::AllowMessages>,
        pub(crate) endpoint_state: std::option::Option<crate::model::EndpointState>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn r#type(mut self, input: crate::model::AppInstanceUserEndpointType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>BBoolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn allow_messages(mut self, input: crate::model::AllowMessages) -> Self {
            self.allow_messages = Some(input);
            self
        }
        /// <p>BBoolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.allow_messages = input;
            self
        }
        /// <p>A read-only field that represent the state of an <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_state(mut self, input: crate::model::EndpointState) -> Self {
            self.endpoint_state = Some(input);
            self
        }
        /// <p>A read-only field that represent the state of an <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_state(
            mut self,
            input: std::option::Option<crate::model::EndpointState>,
        ) -> Self {
            self.endpoint_state = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserEndpointSummary`](crate::model::AppInstanceUserEndpointSummary)
        pub fn build(self) -> crate::model::AppInstanceUserEndpointSummary {
            crate::model::AppInstanceUserEndpointSummary {
                app_instance_user_arn: self.app_instance_user_arn,
                endpoint_id: self.endpoint_id,
                name: self.name,
                r#type: self.r#type,
                allow_messages: self.allow_messages,
                endpoint_state: self.endpoint_state,
            }
        }
    }
}
impl AppInstanceUserEndpointSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserEndpointSummary`](crate::model::AppInstanceUserEndpointSummary)
    pub fn builder() -> crate::model::app_instance_user_endpoint_summary::Builder {
        crate::model::app_instance_user_endpoint_summary::Builder::default()
    }
}

/// <p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p>
/// <ul>
/// <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li>
/// <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When INACTIVE, the corresponding reason will be conveyed through EndpointStatusReason.</p> </li>
/// <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li>
/// <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointState {
    /// <p>Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.</p>
    pub status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>The reason for the <code>EndpointStatus</code>.</p>
    pub status_reason: std::option::Option<crate::model::EndpointStatusReason>,
}
impl EndpointState {
    /// <p>Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EndpointStatus> {
        self.status.as_ref()
    }
    /// <p>The reason for the <code>EndpointStatus</code>.</p>
    pub fn status_reason(&self) -> std::option::Option<&crate::model::EndpointStatusReason> {
        self.status_reason.as_ref()
    }
}
impl std::fmt::Debug for EndpointState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointState");
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`EndpointState`](crate::model::EndpointState)
pub mod endpoint_state {
    /// A builder for [`EndpointState`](crate::model::EndpointState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::EndpointStatusReason>,
    }
    impl Builder {
        /// <p>Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.</p>
        pub fn status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the <code>EndpointStatus</code>.</p>
        pub fn status_reason(mut self, input: crate::model::EndpointStatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>The reason for the <code>EndpointStatus</code>.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::EndpointStatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointState`](crate::model::EndpointState)
        pub fn build(self) -> crate::model::EndpointState {
            crate::model::EndpointState {
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl EndpointState {
    /// Creates a new builder-style object to manufacture [`EndpointState`](crate::model::EndpointState)
    pub fn builder() -> crate::model::endpoint_state::Builder {
        crate::model::endpoint_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointStatusReason {
    #[allow(missing_docs)] // documentation missing in model
    InvalidDeviceToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPinpointArn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointStatusReason {
    fn from(s: &str) -> Self {
        match s {
            "INVALID_DEVICE_TOKEN" => EndpointStatusReason::InvalidDeviceToken,
            "INVALID_PINPOINT_ARN" => EndpointStatusReason::InvalidPinpointArn,
            other => EndpointStatusReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointStatusReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointStatusReason::from(s))
    }
}
impl EndpointStatusReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointStatusReason::InvalidDeviceToken => "INVALID_DEVICE_TOKEN",
            EndpointStatusReason::InvalidPinpointArn => "INVALID_PINPOINT_ARN",
            EndpointStatusReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INVALID_DEVICE_TOKEN", "INVALID_PINPOINT_ARN"]
    }
}
impl AsRef<str> for EndpointStatusReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => EndpointStatus::Active,
            "INACTIVE" => EndpointStatus::Inactive,
            other => EndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointStatus::from(s))
    }
}
impl EndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointStatus::Active => "ACTIVE",
            EndpointStatus::Inactive => "INACTIVE",
            EndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for EndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the data for an <code>AppInstance</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceSummary {
    /// <p>The <code>AppInstance</code> ARN.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstance</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of the <code>AppInstance</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl AppInstanceSummary {
    /// <p>The <code>AppInstance</code> ARN.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The name of the <code>AppInstance</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of the <code>AppInstance</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for AppInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceSummary");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstanceSummary`](crate::model::AppInstanceSummary)
pub mod app_instance_summary {
    /// A builder for [`AppInstanceSummary`](crate::model::AppInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AppInstance</code> ARN.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstance</code> ARN.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceSummary`](crate::model::AppInstanceSummary)
        pub fn build(self) -> crate::model::AppInstanceSummary {
            crate::model::AppInstanceSummary {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                metadata: self.metadata,
            }
        }
    }
}
impl AppInstanceSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceSummary`](crate::model::AppInstanceSummary)
    pub fn builder() -> crate::model::app_instance_summary::Builder {
        crate::model::app_instance_summary::Builder::default()
    }
}

/// <p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceAdminSummary {
    /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
    pub admin: std::option::Option<crate::model::Identity>,
}
impl AppInstanceAdminSummary {
    /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
    pub fn admin(&self) -> std::option::Option<&crate::model::Identity> {
        self.admin.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceAdminSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceAdminSummary");
        formatter.field("admin", &self.admin);
        formatter.finish()
    }
}
/// See [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
pub mod app_instance_admin_summary {
    /// A builder for [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
        pub fn admin(mut self, input: crate::model::Identity) -> Self {
            self.admin = Some(input);
            self
        }
        /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_admin(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.admin = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
        pub fn build(self) -> crate::model::AppInstanceAdminSummary {
            crate::model::AppInstanceAdminSummary { admin: self.admin }
        }
    }
}
impl AppInstanceAdminSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
    pub fn builder() -> crate::model::app_instance_admin_summary::Builder {
        crate::model::app_instance_admin_summary::Builder::default()
    }
}

/// <p>The details of a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Identity {
    /// <p>The ARN in an Identity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name in an Identity.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Identity {
    /// <p>The ARN in an Identity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name in an Identity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Identity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Identity");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Identity`](crate::model::Identity)
pub mod identity {
    /// A builder for [`Identity`](crate::model::Identity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN in an Identity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN in an Identity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Identity`](crate::model::Identity)
        pub fn build(self) -> crate::model::Identity {
            crate::model::Identity {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl Identity {
    /// Creates a new builder-style object to manufacture [`Identity`](crate::model::Identity)
    pub fn builder() -> crate::model::identity::Builder {
        crate::model::identity::Builder::default()
    }
}

/// <p>An endpoint under an Amazon Chime <code>AppInstanceUser</code> that receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserEndpoint {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
    pub r#type: std::option::Option<crate::model::AppInstanceUserEndpointType>,
    /// <p>The ARN of the resource to which the endpoint belongs.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The attributes of an <code>Endpoint</code>.</p>
    pub endpoint_attributes: std::option::Option<crate::model::EndpointAttributes>,
    /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
    pub allow_messages: std::option::Option<crate::model::AllowMessages>,
    /// <p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li>
    /// <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.</p> </li>
    /// <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li>
    /// <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li>
    /// </ul>
    pub endpoint_state: std::option::Option<crate::model::EndpointState>,
}
impl AppInstanceUserEndpoint {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AppInstanceUserEndpointType> {
        self.r#type.as_ref()
    }
    /// <p>The ARN of the resource to which the endpoint belongs.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The attributes of an <code>Endpoint</code>.</p>
    pub fn endpoint_attributes(&self) -> std::option::Option<&crate::model::EndpointAttributes> {
        self.endpoint_attributes.as_ref()
    }
    /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
    pub fn allow_messages(&self) -> std::option::Option<&crate::model::AllowMessages> {
        self.allow_messages.as_ref()
    }
    /// <p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li>
    /// <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.</p> </li>
    /// <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li>
    /// <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li>
    /// </ul>
    pub fn endpoint_state(&self) -> std::option::Option<&crate::model::EndpointState> {
        self.endpoint_state.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceUserEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserEndpoint");
        formatter.field("app_instance_user_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_id", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("resource_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_attributes", &self.endpoint_attributes);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("allow_messages", &self.allow_messages);
        formatter.field("endpoint_state", &self.endpoint_state);
        formatter.finish()
    }
}
/// See [`AppInstanceUserEndpoint`](crate::model::AppInstanceUserEndpoint)
pub mod app_instance_user_endpoint {
    /// A builder for [`AppInstanceUserEndpoint`](crate::model::AppInstanceUserEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_attributes: std::option::Option<crate::model::EndpointAttributes>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) allow_messages: std::option::Option<crate::model::AllowMessages>,
        pub(crate) endpoint_state: std::option::Option<crate::model::EndpointState>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn r#type(mut self, input: crate::model::AppInstanceUserEndpointType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn endpoint_attributes(mut self, input: crate::model::EndpointAttributes) -> Self {
            self.endpoint_attributes = Some(input);
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn set_endpoint_attributes(
            mut self,
            input: std::option::Option<crate::model::EndpointAttributes>,
        ) -> Self {
            self.endpoint_attributes = input;
            self
        }
        /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which an <code>AppInstanceUserEndpoint</code> was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn allow_messages(mut self, input: crate::model::AllowMessages) -> Self {
            self.allow_messages = Some(input);
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.allow_messages = input;
            self
        }
        /// <p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li>
        /// <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.</p> </li>
        /// <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li>
        /// <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li>
        /// </ul>
        pub fn endpoint_state(mut self, input: crate::model::EndpointState) -> Self {
            self.endpoint_state = Some(input);
            self
        }
        /// <p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li>
        /// <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.</p> </li>
        /// <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li>
        /// <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li>
        /// </ul>
        pub fn set_endpoint_state(
            mut self,
            input: std::option::Option<crate::model::EndpointState>,
        ) -> Self {
            self.endpoint_state = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserEndpoint`](crate::model::AppInstanceUserEndpoint)
        pub fn build(self) -> crate::model::AppInstanceUserEndpoint {
            crate::model::AppInstanceUserEndpoint {
                app_instance_user_arn: self.app_instance_user_arn,
                endpoint_id: self.endpoint_id,
                name: self.name,
                r#type: self.r#type,
                resource_arn: self.resource_arn,
                endpoint_attributes: self.endpoint_attributes,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                allow_messages: self.allow_messages,
                endpoint_state: self.endpoint_state,
            }
        }
    }
}
impl AppInstanceUserEndpoint {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserEndpoint`](crate::model::AppInstanceUserEndpoint)
    pub fn builder() -> crate::model::app_instance_user_endpoint::Builder {
        crate::model::app_instance_user_endpoint::Builder::default()
    }
}

/// <p>The details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUser {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl AppInstanceUser {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUser");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceUser`](crate::model::AppInstanceUser)
pub mod app_instance_user {
    /// A builder for [`AppInstanceUser`](crate::model::AppInstanceUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUser`](crate::model::AppInstanceUser)
        pub fn build(self) -> crate::model::AppInstanceUser {
            crate::model::AppInstanceUser {
                app_instance_user_arn: self.app_instance_user_arn,
                name: self.name,
                metadata: self.metadata,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl AppInstanceUser {
    /// Creates a new builder-style object to manufacture [`AppInstanceUser`](crate::model::AppInstanceUser)
    pub fn builder() -> crate::model::app_instance_user::Builder {
        crate::model::app_instance_user::Builder::default()
    }
}

/// <p>The details of an <code>AppInstanceAdmin</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceAdmin {
    /// <p>The <code>AppInstanceAdmin</code> data.</p>
    pub admin: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The time at which an administrator was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl AppInstanceAdmin {
    /// <p>The <code>AppInstanceAdmin</code> data.</p>
    pub fn admin(&self) -> std::option::Option<&crate::model::Identity> {
        self.admin.as_ref()
    }
    /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The time at which an administrator was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceAdmin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceAdmin");
        formatter.field("admin", &self.admin);
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
pub mod app_instance_admin {
    /// A builder for [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin: std::option::Option<crate::model::Identity>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The <code>AppInstanceAdmin</code> data.</p>
        pub fn admin(mut self, input: crate::model::Identity) -> Self {
            self.admin = Some(input);
            self
        }
        /// <p>The <code>AppInstanceAdmin</code> data.</p>
        pub fn set_admin(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.admin = input;
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The time at which an administrator was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which an administrator was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
        pub fn build(self) -> crate::model::AppInstanceAdmin {
            crate::model::AppInstanceAdmin {
                admin: self.admin,
                app_instance_arn: self.app_instance_arn,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl AppInstanceAdmin {
    /// Creates a new builder-style object to manufacture [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
    pub fn builder() -> crate::model::app_instance_admin::Builder {
        crate::model::app_instance_admin::Builder::default()
    }
}

/// <p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstance {
    /// <p>The ARN of the messaging instance.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of an <code>AppInstance</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The metadata of an <code>AppInstance</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl AppInstance {
    /// <p>The ARN of the messaging instance.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The name of an <code>AppInstance</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>The metadata of an <code>AppInstance</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for AppInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstance");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstance`](crate::model::AppInstance)
pub mod app_instance {
    /// A builder for [`AppInstance`](crate::model::AppInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the messaging instance.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the messaging instance.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of an <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The metadata of an <code>AppInstance</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of an <code>AppInstance</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstance`](crate::model::AppInstance)
        pub fn build(self) -> crate::model::AppInstance {
            crate::model::AppInstance {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                metadata: self.metadata,
            }
        }
    }
}
impl AppInstance {
    /// Creates a new builder-style object to manufacture [`AppInstance`](crate::model::AppInstance)
    pub fn builder() -> crate::model::app_instance::Builder {
        crate::model::app_instance::Builder::default()
    }
}
