// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInstanceUserEndpointOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
}
impl UpdateAppInstanceUserEndpointOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInstanceUserEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInstanceUserEndpointOutput");
        formatter.field("app_instance_user_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`UpdateAppInstanceUserEndpointOutput`](crate::output::UpdateAppInstanceUserEndpointOutput)
pub mod update_app_instance_user_endpoint_output {
    /// A builder for [`UpdateAppInstanceUserEndpointOutput`](crate::output::UpdateAppInstanceUserEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInstanceUserEndpointOutput`](crate::output::UpdateAppInstanceUserEndpointOutput)
        pub fn build(self) -> crate::output::UpdateAppInstanceUserEndpointOutput {
            crate::output::UpdateAppInstanceUserEndpointOutput {
                app_instance_user_arn: self.app_instance_user_arn,
                endpoint_id: self.endpoint_id,
            }
        }
    }
}
impl UpdateAppInstanceUserEndpointOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppInstanceUserEndpointOutput`](crate::output::UpdateAppInstanceUserEndpointOutput)
    pub fn builder() -> crate::output::update_app_instance_user_endpoint_output::Builder {
        crate::output::update_app_instance_user_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInstanceUserOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
}
impl UpdateAppInstanceUserOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInstanceUserOutput");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.finish()
    }
}
/// See [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput)
pub mod update_app_instance_user_output {
    /// A builder for [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput)
        pub fn build(self) -> crate::output::UpdateAppInstanceUserOutput {
            crate::output::UpdateAppInstanceUserOutput {
                app_instance_user_arn: self.app_instance_user_arn,
            }
        }
    }
}
impl UpdateAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput)
    pub fn builder() -> crate::output::update_app_instance_user_output::Builder {
        crate::output::update_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInstanceOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
}
impl UpdateAppInstanceOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInstanceOutput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.finish()
    }
}
/// See [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput)
pub mod update_app_instance_output {
    /// A builder for [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput)
        pub fn build(self) -> crate::output::UpdateAppInstanceOutput {
            crate::output::UpdateAppInstanceOutput {
                app_instance_arn: self.app_instance_arn,
            }
        }
    }
}
impl UpdateAppInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput)
    pub fn builder() -> crate::output::update_app_instance_output::Builder {
        crate::output::update_app_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterAppInstanceUserEndpointOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
}
impl RegisterAppInstanceUserEndpointOutput {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterAppInstanceUserEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterAppInstanceUserEndpointOutput");
        formatter.field("app_instance_user_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`RegisterAppInstanceUserEndpointOutput`](crate::output::RegisterAppInstanceUserEndpointOutput)
pub mod register_app_instance_user_endpoint_output {
    /// A builder for [`RegisterAppInstanceUserEndpointOutput`](crate::output::RegisterAppInstanceUserEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterAppInstanceUserEndpointOutput`](crate::output::RegisterAppInstanceUserEndpointOutput)
        pub fn build(self) -> crate::output::RegisterAppInstanceUserEndpointOutput {
            crate::output::RegisterAppInstanceUserEndpointOutput {
                app_instance_user_arn: self.app_instance_user_arn,
                endpoint_id: self.endpoint_id,
            }
        }
    }
}
impl RegisterAppInstanceUserEndpointOutput {
    /// Creates a new builder-style object to manufacture [`RegisterAppInstanceUserEndpointOutput`](crate::output::RegisterAppInstanceUserEndpointOutput)
    pub fn builder() -> crate::output::register_app_instance_user_endpoint_output::Builder {
        crate::output::register_app_instance_user_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppInstanceRetentionSettingsOutput {
    /// <p>The time in days to retain data. Data type: number.</p>
    pub app_instance_retention_settings:
        std::option::Option<crate::model::AppInstanceRetentionSettings>,
    /// <p>The time at which the API deletes data.</p>
    pub initiate_deletion_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl PutAppInstanceRetentionSettingsOutput {
    /// <p>The time in days to retain data. Data type: number.</p>
    pub fn app_instance_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::AppInstanceRetentionSettings> {
        self.app_instance_retention_settings.as_ref()
    }
    /// <p>The time at which the API deletes data.</p>
    pub fn initiate_deletion_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.initiate_deletion_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PutAppInstanceRetentionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppInstanceRetentionSettingsOutput");
        formatter.field(
            "app_instance_retention_settings",
            &self.app_instance_retention_settings,
        );
        formatter.field(
            "initiate_deletion_timestamp",
            &self.initiate_deletion_timestamp,
        );
        formatter.finish()
    }
}
/// See [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput)
pub mod put_app_instance_retention_settings_output {
    /// A builder for [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_retention_settings:
            std::option::Option<crate::model::AppInstanceRetentionSettings>,
        pub(crate) initiate_deletion_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn app_instance_retention_settings(
            mut self,
            input: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.app_instance_retention_settings = Some(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.app_instance_retention_settings = input;
            self
        }
        /// <p>The time at which the API deletes data.</p>
        pub fn initiate_deletion_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.initiate_deletion_timestamp = Some(input);
            self
        }
        /// <p>The time at which the API deletes data.</p>
        pub fn set_initiate_deletion_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.initiate_deletion_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput)
        pub fn build(self) -> crate::output::PutAppInstanceRetentionSettingsOutput {
            crate::output::PutAppInstanceRetentionSettingsOutput {
                app_instance_retention_settings: self.app_instance_retention_settings,
                initiate_deletion_timestamp: self.initiate_deletion_timestamp,
            }
        }
    }
}
impl PutAppInstanceRetentionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput)
    pub fn builder() -> crate::output::put_app_instance_retention_settings_output::Builder {
        crate::output::put_app_instance_retention_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tag key-value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppInstanceUsersOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The information for each requested <code>AppInstanceUser</code>.</p>
    pub app_instance_users:
        std::option::Option<std::vec::Vec<crate::model::AppInstanceUserSummary>>,
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppInstanceUsersOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The information for each requested <code>AppInstanceUser</code>.</p>
    pub fn app_instance_users(
        &self,
    ) -> std::option::Option<&[crate::model::AppInstanceUserSummary]> {
        self.app_instance_users.as_deref()
    }
    /// <p>The token passed by previous API calls until all requested users are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppInstanceUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppInstanceUsersOutput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("app_instance_users", &self.app_instance_users);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput)
pub mod list_app_instance_users_output {
    /// A builder for [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_users:
            std::option::Option<std::vec::Vec<crate::model::AppInstanceUserSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Appends an item to `app_instance_users`.
        ///
        /// To override the contents of this collection use [`set_app_instance_users`](Self::set_app_instance_users).
        ///
        /// <p>The information for each requested <code>AppInstanceUser</code>.</p>
        pub fn app_instance_users(mut self, input: crate::model::AppInstanceUserSummary) -> Self {
            let mut v = self.app_instance_users.unwrap_or_default();
            v.push(input);
            self.app_instance_users = Some(v);
            self
        }
        /// <p>The information for each requested <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppInstanceUserSummary>>,
        ) -> Self {
            self.app_instance_users = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput)
        pub fn build(self) -> crate::output::ListAppInstanceUsersOutput {
            crate::output::ListAppInstanceUsersOutput {
                app_instance_arn: self.app_instance_arn,
                app_instance_users: self.app_instance_users,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppInstanceUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput)
    pub fn builder() -> crate::output::list_app_instance_users_output::Builder {
        crate::output::list_app_instance_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppInstanceUserEndpointsOutput {
    /// <p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>
    pub app_instance_user_endpoints:
        std::option::Option<std::vec::Vec<crate::model::AppInstanceUserEndpointSummary>>,
    /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppInstanceUserEndpointsOutput {
    /// <p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>
    pub fn app_instance_user_endpoints(
        &self,
    ) -> std::option::Option<&[crate::model::AppInstanceUserEndpointSummary]> {
        self.app_instance_user_endpoints.as_deref()
    }
    /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppInstanceUserEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppInstanceUserEndpointsOutput");
        formatter.field(
            "app_instance_user_endpoints",
            &self.app_instance_user_endpoints,
        );
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListAppInstanceUserEndpointsOutput`](crate::output::ListAppInstanceUserEndpointsOutput)
pub mod list_app_instance_user_endpoints_output {
    /// A builder for [`ListAppInstanceUserEndpointsOutput`](crate::output::ListAppInstanceUserEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AppInstanceUserEndpointSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `app_instance_user_endpoints`.
        ///
        /// To override the contents of this collection use [`set_app_instance_user_endpoints`](Self::set_app_instance_user_endpoints).
        ///
        /// <p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>
        pub fn app_instance_user_endpoints(
            mut self,
            input: crate::model::AppInstanceUserEndpointSummary,
        ) -> Self {
            let mut v = self.app_instance_user_endpoints.unwrap_or_default();
            v.push(input);
            self.app_instance_user_endpoints = Some(v);
            self
        }
        /// <p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_app_instance_user_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppInstanceUserEndpointSummary>>,
        ) -> Self {
            self.app_instance_user_endpoints = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstanceUserEndpointsOutput`](crate::output::ListAppInstanceUserEndpointsOutput)
        pub fn build(self) -> crate::output::ListAppInstanceUserEndpointsOutput {
            crate::output::ListAppInstanceUserEndpointsOutput {
                app_instance_user_endpoints: self.app_instance_user_endpoints,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppInstanceUserEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppInstanceUserEndpointsOutput`](crate::output::ListAppInstanceUserEndpointsOutput)
    pub fn builder() -> crate::output::list_app_instance_user_endpoints_output::Builder {
        crate::output::list_app_instance_user_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppInstancesOutput {
    /// <p>The information for each <code>AppInstance</code>.</p>
    pub app_instances: std::option::Option<std::vec::Vec<crate::model::AppInstanceSummary>>,
    /// <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppInstancesOutput {
    /// <p>The information for each <code>AppInstance</code>.</p>
    pub fn app_instances(&self) -> std::option::Option<&[crate::model::AppInstanceSummary]> {
        self.app_instances.as_deref()
    }
    /// <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppInstancesOutput");
        formatter.field("app_instances", &self.app_instances);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput)
pub mod list_app_instances_output {
    /// A builder for [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instances:
            std::option::Option<std::vec::Vec<crate::model::AppInstanceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `app_instances`.
        ///
        /// To override the contents of this collection use [`set_app_instances`](Self::set_app_instances).
        ///
        /// <p>The information for each <code>AppInstance</code>.</p>
        pub fn app_instances(mut self, input: crate::model::AppInstanceSummary) -> Self {
            let mut v = self.app_instances.unwrap_or_default();
            v.push(input);
            self.app_instances = Some(v);
            self
        }
        /// <p>The information for each <code>AppInstance</code>.</p>
        pub fn set_app_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppInstanceSummary>>,
        ) -> Self {
            self.app_instances = input;
            self
        }
        /// <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput)
        pub fn build(self) -> crate::output::ListAppInstancesOutput {
            crate::output::ListAppInstancesOutput {
                app_instances: self.app_instances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput)
    pub fn builder() -> crate::output::list_app_instances_output::Builder {
        crate::output::list_app_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppInstanceAdminsOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The information for each administrator.</p>
    pub app_instance_admins:
        std::option::Option<std::vec::Vec<crate::model::AppInstanceAdminSummary>>,
    /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppInstanceAdminsOutput {
    /// <p>The ARN of the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The information for each administrator.</p>
    pub fn app_instance_admins(
        &self,
    ) -> std::option::Option<&[crate::model::AppInstanceAdminSummary]> {
        self.app_instance_admins.as_deref()
    }
    /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppInstanceAdminsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppInstanceAdminsOutput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("app_instance_admins", &self.app_instance_admins);
        formatter.field("next_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput)
pub mod list_app_instance_admins_output {
    /// A builder for [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_admins:
            std::option::Option<std::vec::Vec<crate::model::AppInstanceAdminSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Appends an item to `app_instance_admins`.
        ///
        /// To override the contents of this collection use [`set_app_instance_admins`](Self::set_app_instance_admins).
        ///
        /// <p>The information for each administrator.</p>
        pub fn app_instance_admins(mut self, input: crate::model::AppInstanceAdminSummary) -> Self {
            let mut v = self.app_instance_admins.unwrap_or_default();
            v.push(input);
            self.app_instance_admins = Some(v);
            self
        }
        /// <p>The information for each administrator.</p>
        pub fn set_app_instance_admins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppInstanceAdminSummary>>,
        ) -> Self {
            self.app_instance_admins = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput)
        pub fn build(self) -> crate::output::ListAppInstanceAdminsOutput {
            crate::output::ListAppInstanceAdminsOutput {
                app_instance_arn: self.app_instance_arn,
                app_instance_admins: self.app_instance_admins,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppInstanceAdminsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput)
    pub fn builder() -> crate::output::list_app_instance_admins_output::Builder {
        crate::output::list_app_instance_admins_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppInstanceRetentionSettingsOutput {
    /// <p>The retention settings for the <code>AppInstance</code>.</p>
    pub app_instance_retention_settings:
        std::option::Option<crate::model::AppInstanceRetentionSettings>,
    /// <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
    pub initiate_deletion_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetAppInstanceRetentionSettingsOutput {
    /// <p>The retention settings for the <code>AppInstance</code>.</p>
    pub fn app_instance_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::AppInstanceRetentionSettings> {
        self.app_instance_retention_settings.as_ref()
    }
    /// <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
    pub fn initiate_deletion_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.initiate_deletion_timestamp.as_ref()
    }
}
impl std::fmt::Debug for GetAppInstanceRetentionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppInstanceRetentionSettingsOutput");
        formatter.field(
            "app_instance_retention_settings",
            &self.app_instance_retention_settings,
        );
        formatter.field(
            "initiate_deletion_timestamp",
            &self.initiate_deletion_timestamp,
        );
        formatter.finish()
    }
}
/// See [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput)
pub mod get_app_instance_retention_settings_output {
    /// A builder for [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_retention_settings:
            std::option::Option<crate::model::AppInstanceRetentionSettings>,
        pub(crate) initiate_deletion_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The retention settings for the <code>AppInstance</code>.</p>
        pub fn app_instance_retention_settings(
            mut self,
            input: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.app_instance_retention_settings = Some(input);
            self
        }
        /// <p>The retention settings for the <code>AppInstance</code>.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.app_instance_retention_settings = input;
            self
        }
        /// <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
        pub fn initiate_deletion_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.initiate_deletion_timestamp = Some(input);
            self
        }
        /// <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
        pub fn set_initiate_deletion_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.initiate_deletion_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput)
        pub fn build(self) -> crate::output::GetAppInstanceRetentionSettingsOutput {
            crate::output::GetAppInstanceRetentionSettingsOutput {
                app_instance_retention_settings: self.app_instance_retention_settings,
                initiate_deletion_timestamp: self.initiate_deletion_timestamp,
            }
        }
    }
}
impl GetAppInstanceRetentionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput)
    pub fn builder() -> crate::output::get_app_instance_retention_settings_output::Builder {
        crate::output::get_app_instance_retention_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppInstanceUserEndpointOutput {
    /// <p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>
    pub app_instance_user_endpoint: std::option::Option<crate::model::AppInstanceUserEndpoint>,
}
impl DescribeAppInstanceUserEndpointOutput {
    /// <p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>
    pub fn app_instance_user_endpoint(
        &self,
    ) -> std::option::Option<&crate::model::AppInstanceUserEndpoint> {
        self.app_instance_user_endpoint.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppInstanceUserEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppInstanceUserEndpointOutput");
        formatter.field(
            "app_instance_user_endpoint",
            &self.app_instance_user_endpoint,
        );
        formatter.finish()
    }
}
/// See [`DescribeAppInstanceUserEndpointOutput`](crate::output::DescribeAppInstanceUserEndpointOutput)
pub mod describe_app_instance_user_endpoint_output {
    /// A builder for [`DescribeAppInstanceUserEndpointOutput`](crate::output::DescribeAppInstanceUserEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_endpoint:
            std::option::Option<crate::model::AppInstanceUserEndpoint>,
    }
    impl Builder {
        /// <p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>
        pub fn app_instance_user_endpoint(
            mut self,
            input: crate::model::AppInstanceUserEndpoint,
        ) -> Self {
            self.app_instance_user_endpoint = Some(input);
            self
        }
        /// <p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>
        pub fn set_app_instance_user_endpoint(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserEndpoint>,
        ) -> Self {
            self.app_instance_user_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceUserEndpointOutput`](crate::output::DescribeAppInstanceUserEndpointOutput)
        pub fn build(self) -> crate::output::DescribeAppInstanceUserEndpointOutput {
            crate::output::DescribeAppInstanceUserEndpointOutput {
                app_instance_user_endpoint: self.app_instance_user_endpoint,
            }
        }
    }
}
impl DescribeAppInstanceUserEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceUserEndpointOutput`](crate::output::DescribeAppInstanceUserEndpointOutput)
    pub fn builder() -> crate::output::describe_app_instance_user_endpoint_output::Builder {
        crate::output::describe_app_instance_user_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppInstanceUserOutput {
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user: std::option::Option<crate::model::AppInstanceUser>,
}
impl DescribeAppInstanceUserOutput {
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user(&self) -> std::option::Option<&crate::model::AppInstanceUser> {
        self.app_instance_user.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppInstanceUserOutput");
        formatter.field("app_instance_user", &self.app_instance_user);
        formatter.finish()
    }
}
/// See [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput)
pub mod describe_app_instance_user_output {
    /// A builder for [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user: std::option::Option<crate::model::AppInstanceUser>,
    }
    impl Builder {
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user(mut self, input: crate::model::AppInstanceUser) -> Self {
            self.app_instance_user = Some(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUser>,
        ) -> Self {
            self.app_instance_user = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput)
        pub fn build(self) -> crate::output::DescribeAppInstanceUserOutput {
            crate::output::DescribeAppInstanceUserOutput {
                app_instance_user: self.app_instance_user,
            }
        }
    }
}
impl DescribeAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput)
    pub fn builder() -> crate::output::describe_app_instance_user_output::Builder {
        crate::output::describe_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppInstanceAdminOutput {
    /// <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
    pub app_instance_admin: std::option::Option<crate::model::AppInstanceAdmin>,
}
impl DescribeAppInstanceAdminOutput {
    /// <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
    pub fn app_instance_admin(&self) -> std::option::Option<&crate::model::AppInstanceAdmin> {
        self.app_instance_admin.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppInstanceAdminOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppInstanceAdminOutput");
        formatter.field("app_instance_admin", &self.app_instance_admin);
        formatter.finish()
    }
}
/// See [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput)
pub mod describe_app_instance_admin_output {
    /// A builder for [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_admin: std::option::Option<crate::model::AppInstanceAdmin>,
    }
    impl Builder {
        /// <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
        pub fn app_instance_admin(mut self, input: crate::model::AppInstanceAdmin) -> Self {
            self.app_instance_admin = Some(input);
            self
        }
        /// <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
        pub fn set_app_instance_admin(
            mut self,
            input: std::option::Option<crate::model::AppInstanceAdmin>,
        ) -> Self {
            self.app_instance_admin = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput)
        pub fn build(self) -> crate::output::DescribeAppInstanceAdminOutput {
            crate::output::DescribeAppInstanceAdminOutput {
                app_instance_admin: self.app_instance_admin,
            }
        }
    }
}
impl DescribeAppInstanceAdminOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput)
    pub fn builder() -> crate::output::describe_app_instance_admin_output::Builder {
        crate::output::describe_app_instance_admin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppInstanceOutput {
    /// <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
    pub app_instance: std::option::Option<crate::model::AppInstance>,
}
impl DescribeAppInstanceOutput {
    /// <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
    pub fn app_instance(&self) -> std::option::Option<&crate::model::AppInstance> {
        self.app_instance.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppInstanceOutput");
        formatter.field("app_instance", &self.app_instance);
        formatter.finish()
    }
}
/// See [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput)
pub mod describe_app_instance_output {
    /// A builder for [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance: std::option::Option<crate::model::AppInstance>,
    }
    impl Builder {
        /// <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
        pub fn app_instance(mut self, input: crate::model::AppInstance) -> Self {
            self.app_instance = Some(input);
            self
        }
        /// <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
        pub fn set_app_instance(
            mut self,
            input: std::option::Option<crate::model::AppInstance>,
        ) -> Self {
            self.app_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput)
        pub fn build(self) -> crate::output::DescribeAppInstanceOutput {
            crate::output::DescribeAppInstanceOutput {
                app_instance: self.app_instance,
            }
        }
    }
}
impl DescribeAppInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput)
    pub fn builder() -> crate::output::describe_app_instance_output::Builder {
        crate::output::describe_app_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterAppInstanceUserEndpointOutput {}
impl std::fmt::Debug for DeregisterAppInstanceUserEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterAppInstanceUserEndpointOutput");
        formatter.finish()
    }
}
/// See [`DeregisterAppInstanceUserEndpointOutput`](crate::output::DeregisterAppInstanceUserEndpointOutput)
pub mod deregister_app_instance_user_endpoint_output {
    /// A builder for [`DeregisterAppInstanceUserEndpointOutput`](crate::output::DeregisterAppInstanceUserEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterAppInstanceUserEndpointOutput`](crate::output::DeregisterAppInstanceUserEndpointOutput)
        pub fn build(self) -> crate::output::DeregisterAppInstanceUserEndpointOutput {
            crate::output::DeregisterAppInstanceUserEndpointOutput {}
        }
    }
}
impl DeregisterAppInstanceUserEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterAppInstanceUserEndpointOutput`](crate::output::DeregisterAppInstanceUserEndpointOutput)
    pub fn builder() -> crate::output::deregister_app_instance_user_endpoint_output::Builder {
        crate::output::deregister_app_instance_user_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInstanceUserOutput {}
impl std::fmt::Debug for DeleteAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInstanceUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)
pub mod delete_app_instance_user_output {
    /// A builder for [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)
        pub fn build(self) -> crate::output::DeleteAppInstanceUserOutput {
            crate::output::DeleteAppInstanceUserOutput {}
        }
    }
}
impl DeleteAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)
    pub fn builder() -> crate::output::delete_app_instance_user_output::Builder {
        crate::output::delete_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInstanceAdminOutput {}
impl std::fmt::Debug for DeleteAppInstanceAdminOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInstanceAdminOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)
pub mod delete_app_instance_admin_output {
    /// A builder for [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)
        pub fn build(self) -> crate::output::DeleteAppInstanceAdminOutput {
            crate::output::DeleteAppInstanceAdminOutput {}
        }
    }
}
impl DeleteAppInstanceAdminOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)
    pub fn builder() -> crate::output::delete_app_instance_admin_output::Builder {
        crate::output::delete_app_instance_admin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInstanceOutput {}
impl std::fmt::Debug for DeleteAppInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)
pub mod delete_app_instance_output {
    /// A builder for [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)
        pub fn build(self) -> crate::output::DeleteAppInstanceOutput {
            crate::output::DeleteAppInstanceOutput {}
        }
    }
}
impl DeleteAppInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)
    pub fn builder() -> crate::output::delete_app_instance_output::Builder {
        crate::output::delete_app_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInstanceUserOutput {
    /// <p>The user's ARN.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
}
impl CreateAppInstanceUserOutput {
    /// <p>The user's ARN.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInstanceUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInstanceUserOutput");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.finish()
    }
}
/// See [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput)
pub mod create_app_instance_user_output {
    /// A builder for [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's ARN.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The user's ARN.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput)
        pub fn build(self) -> crate::output::CreateAppInstanceUserOutput {
            crate::output::CreateAppInstanceUserOutput {
                app_instance_user_arn: self.app_instance_user_arn,
            }
        }
    }
}
impl CreateAppInstanceUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput)
    pub fn builder() -> crate::output::create_app_instance_user_output::Builder {
        crate::output::create_app_instance_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInstanceAdminOutput {
    /// <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
    pub app_instance_admin: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
}
impl CreateAppInstanceAdminOutput {
    /// <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
    pub fn app_instance_admin(&self) -> std::option::Option<&crate::model::Identity> {
        self.app_instance_admin.as_ref()
    }
    /// <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInstanceAdminOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInstanceAdminOutput");
        formatter.field("app_instance_admin", &self.app_instance_admin);
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.finish()
    }
}
/// See [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput)
pub mod create_app_instance_admin_output {
    /// A builder for [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_admin: std::option::Option<crate::model::Identity>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
        pub fn app_instance_admin(mut self, input: crate::model::Identity) -> Self {
            self.app_instance_admin = Some(input);
            self
        }
        /// <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.app_instance_admin = input;
            self
        }
        /// <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput)
        pub fn build(self) -> crate::output::CreateAppInstanceAdminOutput {
            crate::output::CreateAppInstanceAdminOutput {
                app_instance_admin: self.app_instance_admin,
                app_instance_arn: self.app_instance_arn,
            }
        }
    }
}
impl CreateAppInstanceAdminOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput)
    pub fn builder() -> crate::output::create_app_instance_admin_output::Builder {
        crate::output::create_app_instance_admin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInstanceOutput {
    /// <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
}
impl CreateAppInstanceOutput {
    /// <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInstanceOutput");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.finish()
    }
}
/// See [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput)
pub mod create_app_instance_output {
    /// A builder for [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput)
        pub fn build(self) -> crate::output::CreateAppInstanceOutput {
            crate::output::CreateAppInstanceOutput {
                app_instance_arn: self.app_instance_arn,
            }
        }
    }
}
impl CreateAppInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput)
    pub fn builder() -> crate::output::create_app_instance_output::Builder {
        crate::output::create_app_instance_output::Builder::default()
    }
}
