// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Chime SDK Identity
///
/// Client for invoking operations on Amazon Chime SDK Identity. Each operation on Amazon Chime SDK Identity is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_chimesdkidentity::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_chimesdkidentity::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_chimesdkidentity::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAppInstance`](crate::client::fluent_builders::CreateAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_name): <p>The name of the <code>AppInstance</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_metadata): <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_client_request_token): <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAppInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAppInstance::set_tags): <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::CreateAppInstanceOutput::app_instance_arn): <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceError>`](crate::error::CreateAppInstanceError)
    pub fn create_app_instance(&self) -> fluent_builders::CreateAppInstance {
        fluent_builders::CreateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppInstanceAdmin`](crate::client::fluent_builders::CreateAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput) with field(s):
    ///   - [`app_instance_admin(Option<Identity>)`](crate::output::CreateAppInstanceAdminOutput::app_instance_admin): <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
    ///   - [`app_instance_arn(Option<String>)`](crate::output::CreateAppInstanceAdminOutput::app_instance_arn): <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceAdminError>`](crate::error::CreateAppInstanceAdminError)
    pub fn create_app_instance_admin(&self) -> fluent_builders::CreateAppInstanceAdmin {
        fluent_builders::CreateAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppInstanceUser`](crate::client::fluent_builders::CreateAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code> request.</p>
    ///   - [`app_instance_user_id(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::app_instance_user_id) / [`set_app_instance_user_id(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_app_instance_user_id): <p>The user ID of the <code>AppInstance</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_name): <p>The user's name.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_metadata): <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_client_request_token): <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAppInstanceUser::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_tags): <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::CreateAppInstanceUserOutput::app_instance_user_arn): <p>The user's ARN.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceUserError>`](crate::error::CreateAppInstanceUserError)
    pub fn create_app_instance_user(&self) -> fluent_builders::CreateAppInstanceUser {
        fluent_builders::CreateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstance`](crate::client::fluent_builders::DeleteAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceError>`](crate::error::DeleteAppInstanceError)
    pub fn delete_app_instance(&self) -> fluent_builders::DeleteAppInstance {
        fluent_builders::DeleteAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstanceAdmin`](crate::client::fluent_builders::DeleteAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceAdminError>`](crate::error::DeleteAppInstanceAdminError)
    pub fn delete_app_instance_admin(&self) -> fluent_builders::DeleteAppInstanceAdmin {
        fluent_builders::DeleteAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstanceUser`](crate::client::fluent_builders::DeleteAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user request being deleted.</p>
    /// - On success, responds with [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceUserError>`](crate::error::DeleteAppInstanceUserError)
    pub fn delete_app_instance_user(&self) -> fluent_builders::DeleteAppInstanceUser {
        fluent_builders::DeleteAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterAppInstanceUserEndpoint`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint::set_endpoint_id): <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    /// - On success, responds with [`DeregisterAppInstanceUserEndpointOutput`](crate::output::DeregisterAppInstanceUserEndpointOutput)

    /// - On failure, responds with [`SdkError<DeregisterAppInstanceUserEndpointError>`](crate::error::DeregisterAppInstanceUserEndpointError)
    pub fn deregister_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::DeregisterAppInstanceUserEndpoint {
        fluent_builders::DeregisterAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstance`](crate::client::fluent_builders::DescribeAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput) with field(s):
    ///   - [`app_instance(Option<AppInstance>)`](crate::output::DescribeAppInstanceOutput::app_instance): <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceError>`](crate::error::DescribeAppInstanceError)
    pub fn describe_app_instance(&self) -> fluent_builders::DescribeAppInstance {
        fluent_builders::DescribeAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstanceAdmin`](crate::client::fluent_builders::DescribeAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput) with field(s):
    ///   - [`app_instance_admin(Option<AppInstanceAdmin>)`](crate::output::DescribeAppInstanceAdminOutput::app_instance_admin): <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceAdminError>`](crate::error::DescribeAppInstanceAdminError)
    pub fn describe_app_instance_admin(&self) -> fluent_builders::DescribeAppInstanceAdmin {
        fluent_builders::DescribeAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstanceUser`](crate::client::fluent_builders::DescribeAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user(Option<AppInstanceUser>)`](crate::output::DescribeAppInstanceUserOutput::app_instance_user): <p>The name of the <code>AppInstanceUser</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceUserError>`](crate::error::DescribeAppInstanceUserError)
    pub fn describe_app_instance_user(&self) -> fluent_builders::DescribeAppInstanceUser {
        fluent_builders::DescribeAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstanceUserEndpoint`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint::set_endpoint_id): <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceUserEndpointOutput`](crate::output::DescribeAppInstanceUserEndpointOutput) with field(s):
    ///   - [`app_instance_user_endpoint(Option<AppInstanceUserEndpoint>)`](crate::output::DescribeAppInstanceUserEndpointOutput::app_instance_user_endpoint): <p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceUserEndpointError>`](crate::error::DescribeAppInstanceUserEndpointError)
    pub fn describe_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::DescribeAppInstanceUserEndpoint {
        fluent_builders::DescribeAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppInstanceRetentionSettings`](crate::client::fluent_builders::GetAppInstanceRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::GetAppInstanceRetentionSettings::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::GetAppInstanceRetentionSettings::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput) with field(s):
    ///   - [`app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::output::GetAppInstanceRetentionSettingsOutput::app_instance_retention_settings): <p>The retention settings for the <code>AppInstance</code>.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::GetAppInstanceRetentionSettingsOutput::initiate_deletion_timestamp): <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
    /// - On failure, responds with [`SdkError<GetAppInstanceRetentionSettingsError>`](crate::error::GetAppInstanceRetentionSettingsError)
    pub fn get_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::GetAppInstanceRetentionSettings {
        fluent_builders::GetAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstanceAdmins`](crate::client::fluent_builders::ListAppInstanceAdmins) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstanceAdmins::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstanceAdmins::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_max_results): <p>The maximum number of administrators that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_next_token): <p>The token returned from previous API requests until the number of administrators is reached.</p>
    /// - On success, responds with [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::ListAppInstanceAdminsOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_admins(Option<Vec<AppInstanceAdminSummary>>)`](crate::output::ListAppInstanceAdminsOutput::app_instance_admins): <p>The information for each administrator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstanceAdminsOutput::next_token): <p>The token returned from previous API requests until the number of administrators is reached.</p>
    /// - On failure, responds with [`SdkError<ListAppInstanceAdminsError>`](crate::error::ListAppInstanceAdminsError)
    pub fn list_app_instance_admins(&self) -> fluent_builders::ListAppInstanceAdmins {
        fluent_builders::ListAppInstanceAdmins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstances`](crate::client::fluent_builders::ListAppInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstances::set_max_results): <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstances::set_next_token): <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstances</code>.</p>
    /// - On success, responds with [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput) with field(s):
    ///   - [`app_instances(Option<Vec<AppInstanceSummary>>)`](crate::output::ListAppInstancesOutput::app_instances): <p>The information for each <code>AppInstance</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstancesOutput::next_token): <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
    /// - On failure, responds with [`SdkError<ListAppInstancesError>`](crate::error::ListAppInstancesError)
    pub fn list_app_instances(&self) -> fluent_builders::ListAppInstances {
        fluent_builders::ListAppInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstanceUserEndpoints`](crate::client::fluent_builders::ListAppInstanceUserEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::set_max_results): <p>The maximum number of endpoints that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUserEndpoints::set_next_token): <p>The token passed by previous API calls until all requested endpoints are returned.</p>
    /// - On success, responds with [`ListAppInstanceUserEndpointsOutput`](crate::output::ListAppInstanceUserEndpointsOutput) with field(s):
    ///   - [`app_instance_user_endpoints(Option<Vec<AppInstanceUserEndpointSummary>>)`](crate::output::ListAppInstanceUserEndpointsOutput::app_instance_user_endpoints): <p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstanceUserEndpointsOutput::next_token): <p>The token passed by previous API calls until all requested endpoints are returned.</p>
    /// - On failure, responds with [`SdkError<ListAppInstanceUserEndpointsError>`](crate::error::ListAppInstanceUserEndpointsError)
    pub fn list_app_instance_user_endpoints(
        &self,
    ) -> fluent_builders::ListAppInstanceUserEndpoints {
        fluent_builders::ListAppInstanceUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstanceUsers`](crate::client::fluent_builders::ListAppInstanceUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstanceUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstanceUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_max_results): <p>The maximum number of requests that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On success, responds with [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::ListAppInstanceUsersOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_users(Option<Vec<AppInstanceUserSummary>>)`](crate::output::ListAppInstanceUsersOutput::app_instance_users): <p>The information for each requested <code>AppInstanceUser</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstanceUsersOutput::next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On failure, responds with [`SdkError<ListAppInstanceUsersError>`](crate::error::ListAppInstanceUsersError)
    pub fn list_app_instance_users(&self) -> fluent_builders::ListAppInstanceUsers {
        fluent_builders::ListAppInstanceUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAppInstanceRetentionSettings`](crate::client::fluent_builders::PutAppInstanceRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_retention_settings(AppInstanceRetentionSettings)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::app_instance_retention_settings) / [`set_app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::set_app_instance_retention_settings): <p>The time in days to retain data. Data type: number.</p>
    /// - On success, responds with [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput) with field(s):
    ///   - [`app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::output::PutAppInstanceRetentionSettingsOutput::app_instance_retention_settings): <p>The time in days to retain data. Data type: number.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::PutAppInstanceRetentionSettingsOutput::initiate_deletion_timestamp): <p>The time at which the API deletes data.</p>
    /// - On failure, responds with [`SdkError<PutAppInstanceRetentionSettingsError>`](crate::error::PutAppInstanceRetentionSettingsError)
    pub fn put_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::PutAppInstanceRetentionSettings {
        fluent_builders::PutAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterAppInstanceUserEndpoint`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_name): <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    ///   - [`r#type(AppInstanceUserEndpointType)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::type) / [`set_type(Option<AppInstanceUserEndpointType>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_type): <p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>  <ul>   <li> <p> <code>APNS</code>: The mobile notification service for an Apple device.</p> </li>   <li> <p> <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p> </li>   <li> <p> <code>GCM</code>: The mobile notification service for an Android device.</p> </li>  </ul>  <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_resource_arn): <p>The ARN of the resource to which the endpoint belongs.</p>
    ///   - [`endpoint_attributes(EndpointAttributes)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::endpoint_attributes) / [`set_endpoint_attributes(Option<EndpointAttributes>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_endpoint_attributes): <p>The attributes of an <code>Endpoint</code>.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_client_request_token): <p>The idempotency token for each client request. </p>
    ///   - [`allow_messages(AllowMessages)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::allow_messages) / [`set_allow_messages(Option<AllowMessages>)`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint::set_allow_messages): <p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.</p>
    /// - On success, responds with [`RegisterAppInstanceUserEndpointOutput`](crate::output::RegisterAppInstanceUserEndpointOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::RegisterAppInstanceUserEndpointOutput::app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`endpoint_id(Option<String>)`](crate::output::RegisterAppInstanceUserEndpointOutput::endpoint_id): <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    /// - On failure, responds with [`SdkError<RegisterAppInstanceUserEndpointError>`](crate::error::RegisterAppInstanceUserEndpointError)
    pub fn register_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::RegisterAppInstanceUserEndpoint {
        fluent_builders::RegisterAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppInstance`](crate::client::fluent_builders::UpdateAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_name): <p>The name that you want to change.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_metadata): <p>The metadata that you want to change.</p>
    /// - On success, responds with [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::UpdateAppInstanceOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateAppInstanceError>`](crate::error::UpdateAppInstanceError)
    pub fn update_app_instance(&self) -> fluent_builders::UpdateAppInstance {
        fluent_builders::UpdateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppInstanceUser`](crate::client::fluent_builders::UpdateAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_name): <p>The name of the <code>AppInstanceUser</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_metadata): <p>The metadata of the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::UpdateAppInstanceUserOutput::app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateAppInstanceUserError>`](crate::error::UpdateAppInstanceUserError)
    pub fn update_app_instance_user(&self) -> fluent_builders::UpdateAppInstanceUser {
        fluent_builders::UpdateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppInstanceUserEndpoint`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::set_endpoint_id): <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::set_name): <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
    ///   - [`allow_messages(AllowMessages)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::allow_messages) / [`set_allow_messages(Option<AllowMessages>)`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint::set_allow_messages): <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
    /// - On success, responds with [`UpdateAppInstanceUserEndpointOutput`](crate::output::UpdateAppInstanceUserEndpointOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::UpdateAppInstanceUserEndpointOutput::app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`endpoint_id(Option<String>)`](crate::output::UpdateAppInstanceUserEndpointOutput::endpoint_id): <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateAppInstanceUserEndpointError>`](crate::error::UpdateAppInstanceUserEndpointError)
    pub fn update_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::UpdateAppInstanceUserEndpoint {
        fluent_builders::UpdateAppInstanceUserEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAppInstance`.
    ///
    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>
    /// <p>identity</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_instance_input::Builder,
    }
    impl CreateAppInstance {
        /// Creates a new `CreateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceAdmin`.
    ///
    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p>
    /// <ul>
    /// <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li>
    /// <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li>
    /// </ul>
    /// <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstanceAdmin {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_instance_admin_input::Builder,
    }
    impl CreateAppInstanceAdmin {
        /// Creates a new `CreateAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceAdminError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceUser`.
    ///
    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_instance_user_input::Builder,
    }
    impl CreateAppInstanceUser {
        /// Creates a new `CreateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn app_instance_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_id(input.into());
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_id(input);
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstance`.
    ///
    /// <p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_instance_input::Builder,
    }
    impl DeleteAppInstance {
        /// Creates a new `DeleteAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceAdmin`.
    ///
    /// <p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstanceAdmin {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_instance_admin_input::Builder,
    }
    impl DeleteAppInstanceAdmin {
        /// Creates a new `DeleteAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceAdminError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceUser`.
    ///
    /// <p>Deletes an <code>AppInstanceUser</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_instance_user_input::Builder,
    }
    impl DeleteAppInstanceUser {
        /// Creates a new `DeleteAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterAppInstanceUserEndpoint`.
    ///
    /// <p>Deregisters an <code>AppInstanceUserEndpoint</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterAppInstanceUserEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_app_instance_user_endpoint_input::Builder,
    }
    impl DeregisterAppInstanceUserEndpoint {
        /// Creates a new `DeregisterAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterAppInstanceUserEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstance`.
    ///
    /// <p>Returns the full details of an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_instance_input::Builder,
    }
    impl DescribeAppInstance {
        /// Creates a new `DescribeAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceAdmin`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstanceAdmin {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_instance_admin_input::Builder,
    }
    impl DescribeAppInstanceAdmin {
        /// Creates a new `DescribeAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceAdminError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUser`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUser</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_instance_user_input::Builder,
    }
    impl DescribeAppInstanceUser {
        /// Creates a new `DescribeAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUserEndpoint`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUserEndpoint</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstanceUserEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_instance_user_endpoint_input::Builder,
    }
    impl DescribeAppInstanceUserEndpoint {
        /// Creates a new `DescribeAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceRetentionSettings`.
    ///
    /// <p>Gets the retention settings for an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppInstanceRetentionSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_app_instance_retention_settings_input::Builder,
    }
    impl GetAppInstanceRetentionSettings {
        /// Creates a new `GetAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppInstanceRetentionSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceAdmins`.
    ///
    /// <p>Returns a list of the administrators in the <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstanceAdmins {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_instance_admins_input::Builder,
    }
    impl ListAppInstanceAdmins {
        /// Creates a new `ListAppInstanceAdmins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceAdminsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceAdminsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstanceAdminsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstanceAdminsPaginator {
            crate::paginator::ListAppInstanceAdminsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstances`.
    ///
    /// <p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_instances_input::Builder,
    }
    impl ListAppInstances {
        /// Creates a new `ListAppInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstancesPaginator {
            crate::paginator::ListAppInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstances</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstances</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUserEndpoints`.
    ///
    /// <p>Lists all the <code>AppInstanceUserEndpoints</code> created under a single <code>AppInstanceUser</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstanceUserEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_instance_user_endpoints_input::Builder,
    }
    impl ListAppInstanceUserEndpoints {
        /// Creates a new `ListAppInstanceUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUserEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstanceUserEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstanceUserEndpointsPaginator {
            crate::paginator::ListAppInstanceUserEndpointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of endpoints that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of endpoints that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUsers`.
    ///
    /// <p>List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstanceUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_instance_users_input::Builder,
    }
    impl ListAppInstanceUsers {
        /// Creates a new `ListAppInstanceUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstanceUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstanceUsersPaginator {
            crate::paginator::ListAppInstanceUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK identity resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceRetentionSettings`.
    ///
    /// <p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAppInstanceRetentionSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_app_instance_retention_settings_input::Builder,
    }
    impl PutAppInstanceRetentionSettings {
        /// Creates a new `PutAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppInstanceRetentionSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn app_instance_retention_settings(
            mut self,
            input: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.inner = self.inner.app_instance_retention_settings(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterAppInstanceUserEndpoint`.
    ///
    /// <p>Registers an endpoint under an Amazon Chime <code>AppInstanceUser</code>. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterAppInstanceUserEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_app_instance_user_endpoint_input::Builder,
    }
    impl RegisterAppInstanceUserEndpoint {
        /// Creates a new `RegisterAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterAppInstanceUserEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
        /// <ul>
        /// <li> <p> <code>APNS</code>: The mobile notification service for an Apple device.</p> </li>
        /// <li> <p> <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p> </li>
        /// <li> <p> <code>GCM</code>: The mobile notification service for an Android device.</p> </li>
        /// </ul>
        /// <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>
        pub fn r#type(mut self, input: crate::model::AppInstanceUserEndpointType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
        /// <ul>
        /// <li> <p> <code>APNS</code>: The mobile notification service for an Apple device.</p> </li>
        /// <li> <p> <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p> </li>
        /// <li> <p> <code>GCM</code>: The mobile notification service for an Android device.</p> </li>
        /// </ul>
        /// <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn endpoint_attributes(mut self, input: crate::model::EndpointAttributes) -> Self {
            self.inner = self.inner.endpoint_attributes(input);
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn set_endpoint_attributes(
            mut self,
            input: std::option::Option<crate::model::EndpointAttributes>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_attributes(input);
            self
        }
        /// <p>The idempotency token for each client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The idempotency token for each client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.</p>
        pub fn allow_messages(mut self, input: crate::model::AllowMessages) -> Self {
            self.inner = self.inner.allow_messages(input);
            self
        }
        /// <p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.inner = self.inner.set_allow_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK identity resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Chime SDK identity resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstance`.
    ///
    /// <p>Updates <code>AppInstance</code> metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAppInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_instance_input::Builder,
    }
    impl UpdateAppInstance {
        /// Creates a new `UpdateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstanceUser`.
    ///
    /// <p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAppInstanceUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_instance_user_input::Builder,
    }
    impl UpdateAppInstanceUser {
        /// Creates a new `UpdateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstanceUserEndpoint`.
    ///
    /// <p>Updates the details of an <code>AppInstanceUserEndpoint</code>. You can update the name and <code>AllowMessage</code> values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAppInstanceUserEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_instance_user_endpoint_input::Builder,
    }
    impl UpdateAppInstanceUserEndpoint {
        /// Creates a new `UpdateAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceUserEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn allow_messages(mut self, input: crate::model::AllowMessages) -> Self {
            self.inner = self.inner.allow_messages(input);
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.inner = self.inner.set_allow_messages(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
