// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `ChimeIdentityService`.
///
/// This client allows ergonomic access to a `ChimeIdentityService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateAppInstance` operation.
    ///
    /// See [`CreateAppInstance`](crate::client::fluent_builders::CreateAppInstance) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance(&self) -> fluent_builders::CreateAppInstance<C, M, R> {
        fluent_builders::CreateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppInstanceAdmin` operation.
    ///
    /// See [`CreateAppInstanceAdmin`](crate::client::fluent_builders::CreateAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance_admin(&self) -> fluent_builders::CreateAppInstanceAdmin<C, M, R> {
        fluent_builders::CreateAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppInstanceUser` operation.
    ///
    /// See [`CreateAppInstanceUser`](crate::client::fluent_builders::CreateAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance_user(&self) -> fluent_builders::CreateAppInstanceUser<C, M, R> {
        fluent_builders::CreateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstance` operation.
    ///
    /// See [`DeleteAppInstance`](crate::client::fluent_builders::DeleteAppInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance(&self) -> fluent_builders::DeleteAppInstance<C, M, R> {
        fluent_builders::DeleteAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstanceAdmin` operation.
    ///
    /// See [`DeleteAppInstanceAdmin`](crate::client::fluent_builders::DeleteAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance_admin(&self) -> fluent_builders::DeleteAppInstanceAdmin<C, M, R> {
        fluent_builders::DeleteAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstanceUser` operation.
    ///
    /// See [`DeleteAppInstanceUser`](crate::client::fluent_builders::DeleteAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance_user(&self) -> fluent_builders::DeleteAppInstanceUser<C, M, R> {
        fluent_builders::DeleteAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterAppInstanceUserEndpoint` operation.
    ///
    /// See [`DeregisterAppInstanceUserEndpoint`](crate::client::fluent_builders::DeregisterAppInstanceUserEndpoint) for more information about the
    /// operation and its arguments.
    pub fn deregister_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::DeregisterAppInstanceUserEndpoint<C, M, R> {
        fluent_builders::DeregisterAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstance` operation.
    ///
    /// See [`DescribeAppInstance`](crate::client::fluent_builders::DescribeAppInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance(&self) -> fluent_builders::DescribeAppInstance<C, M, R> {
        fluent_builders::DescribeAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstanceAdmin` operation.
    ///
    /// See [`DescribeAppInstanceAdmin`](crate::client::fluent_builders::DescribeAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance_admin(
        &self,
    ) -> fluent_builders::DescribeAppInstanceAdmin<C, M, R> {
        fluent_builders::DescribeAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstanceUser` operation.
    ///
    /// See [`DescribeAppInstanceUser`](crate::client::fluent_builders::DescribeAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance_user(&self) -> fluent_builders::DescribeAppInstanceUser<C, M, R> {
        fluent_builders::DescribeAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstanceUserEndpoint` operation.
    ///
    /// See [`DescribeAppInstanceUserEndpoint`](crate::client::fluent_builders::DescribeAppInstanceUserEndpoint) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::DescribeAppInstanceUserEndpoint<C, M, R> {
        fluent_builders::DescribeAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppInstanceRetentionSettings` operation.
    ///
    /// See [`GetAppInstanceRetentionSettings`](crate::client::fluent_builders::GetAppInstanceRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn get_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::GetAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::GetAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstanceAdmins` operation.
    ///
    /// See [`ListAppInstanceAdmins`](crate::client::fluent_builders::ListAppInstanceAdmins) for more information about the
    /// operation and its arguments.
    pub fn list_app_instance_admins(&self) -> fluent_builders::ListAppInstanceAdmins<C, M, R> {
        fluent_builders::ListAppInstanceAdmins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstances` operation.
    ///
    /// See [`ListAppInstances`](crate::client::fluent_builders::ListAppInstances) for more information about the
    /// operation and its arguments.
    pub fn list_app_instances(&self) -> fluent_builders::ListAppInstances<C, M, R> {
        fluent_builders::ListAppInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstanceUserEndpoints` operation.
    ///
    /// See [`ListAppInstanceUserEndpoints`](crate::client::fluent_builders::ListAppInstanceUserEndpoints) for more information about the
    /// operation and its arguments.
    pub fn list_app_instance_user_endpoints(
        &self,
    ) -> fluent_builders::ListAppInstanceUserEndpoints<C, M, R> {
        fluent_builders::ListAppInstanceUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstanceUsers` operation.
    ///
    /// See [`ListAppInstanceUsers`](crate::client::fluent_builders::ListAppInstanceUsers) for more information about the
    /// operation and its arguments.
    pub fn list_app_instance_users(&self) -> fluent_builders::ListAppInstanceUsers<C, M, R> {
        fluent_builders::ListAppInstanceUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppInstanceRetentionSettings` operation.
    ///
    /// See [`PutAppInstanceRetentionSettings`](crate::client::fluent_builders::PutAppInstanceRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn put_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::PutAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::PutAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterAppInstanceUserEndpoint` operation.
    ///
    /// See [`RegisterAppInstanceUserEndpoint`](crate::client::fluent_builders::RegisterAppInstanceUserEndpoint) for more information about the
    /// operation and its arguments.
    pub fn register_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::RegisterAppInstanceUserEndpoint<C, M, R> {
        fluent_builders::RegisterAppInstanceUserEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppInstance` operation.
    ///
    /// See [`UpdateAppInstance`](crate::client::fluent_builders::UpdateAppInstance) for more information about the
    /// operation and its arguments.
    pub fn update_app_instance(&self) -> fluent_builders::UpdateAppInstance<C, M, R> {
        fluent_builders::UpdateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppInstanceUser` operation.
    ///
    /// See [`UpdateAppInstanceUser`](crate::client::fluent_builders::UpdateAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn update_app_instance_user(&self) -> fluent_builders::UpdateAppInstanceUser<C, M, R> {
        fluent_builders::UpdateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppInstanceUserEndpoint` operation.
    ///
    /// See [`UpdateAppInstanceUserEndpoint`](crate::client::fluent_builders::UpdateAppInstanceUserEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_app_instance_user_endpoint(
        &self,
    ) -> fluent_builders::UpdateAppInstanceUserEndpoint<C, M, R> {
        fluent_builders::UpdateAppInstanceUserEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAppInstance`.
    ///
    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account.
    /// Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports
    /// idempotency behavior as described in the AWS API Standard.</p>
    /// <p>identity</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_input::Builder,
    }
    impl<C, M, R> CreateAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceInputOperationOutputAlias,
                crate::output::CreateAppInstanceOutput,
                crate::error::CreateAppInstanceError,
                crate::input::CreateAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceAdmin`.
    ///
    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The
    /// promoted user can perform the following actions. </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChannelModerator</code> actions across all channels in the
    /// <code>AppInstance</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DeleteChannelMessage</code> actions.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code>
    /// role.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_admin_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceAdminInputOperationOutputAlias,
                crate::output::CreateAppInstanceAdminOutput,
                crate::error::CreateAppInstanceAdminError,
                crate::input::CreateAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceUser`.
    ///
    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a
    /// unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_user_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceUserInputOperationOutputAlias,
                crate::output::CreateAppInstanceUserOutput,
                crate::error::CreateAppInstanceUserError,
                crate::input::CreateAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn app_instance_user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_id(inp);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_id(input);
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstance`.
    ///
    /// <p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_input::Builder,
    }
    impl<C, M, R> DeleteAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceInputOperationOutputAlias,
                crate::output::DeleteAppInstanceOutput,
                crate::error::DeleteAppInstanceError,
                crate::input::DeleteAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceAdmin`.
    ///
    /// <p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action
    /// does not delete the user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceAdminInputOperationOutputAlias,
                crate::output::DeleteAppInstanceAdminOutput,
                crate::error::DeleteAppInstanceAdminError,
                crate::input::DeleteAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceUser`.
    ///
    /// <p>Deletes an <code>AppInstanceUser</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_user_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceUserInputOperationOutputAlias,
                crate::output::DeleteAppInstanceUserOutput,
                crate::error::DeleteAppInstanceUserError,
                crate::input::DeleteAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterAppInstanceUserEndpoint`.
    ///
    /// <p>Deregisters an <code>AppInstanceUserEndpoint</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterAppInstanceUserEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_app_instance_user_endpoint_input::Builder,
    }
    impl<C, M, R> DeregisterAppInstanceUserEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterAppInstanceUserEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterAppInstanceUserEndpointInputOperationOutputAlias,
                crate::output::DeregisterAppInstanceUserEndpointOutput,
                crate::error::DeregisterAppInstanceUserEndpointError,
                crate::input::DeregisterAppInstanceUserEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstance`.
    ///
    /// <p>Returns the full details of an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_input::Builder,
    }
    impl<C, M, R> DescribeAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceInputOperationOutputAlias,
                crate::output::DescribeAppInstanceOutput,
                crate::error::DescribeAppInstanceError,
                crate::input::DescribeAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceAdmin`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceAdminInputOperationOutputAlias,
                crate::output::DescribeAppInstanceAdminOutput,
                crate::error::DescribeAppInstanceAdminError,
                crate::input::DescribeAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUser`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUser</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeAppInstanceUserOutput,
                crate::error::DescribeAppInstanceUserError,
                crate::input::DescribeAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUserEndpoint`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUserEndpoint</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstanceUserEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_user_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceUserEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceUserEndpointInputOperationOutputAlias,
                crate::output::DescribeAppInstanceUserEndpointOutput,
                crate::error::DescribeAppInstanceUserEndpointError,
                crate::input::DescribeAppInstanceUserEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceRetentionSettings`.
    ///
    /// <p>Gets the retention settings for an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> GetAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::GetAppInstanceRetentionSettingsOutput,
                crate::error::GetAppInstanceRetentionSettingsError,
                crate::input::GetAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceAdmins`.
    ///
    /// <p>Returns a list of the administrators in the <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstanceAdmins<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_admins_input::Builder,
    }
    impl<C, M, R> ListAppInstanceAdmins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceAdmins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceAdminsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceAdminsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceAdminsInputOperationOutputAlias,
                crate::output::ListAppInstanceAdminsOutput,
                crate::error::ListAppInstanceAdminsError,
                crate::input::ListAppInstanceAdminsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is
        /// reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is
        /// reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstances`.
    ///
    /// <p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instances_input::Builder,
    }
    impl<C, M, R> ListAppInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstancesInputOperationOutputAlias,
                crate::output::ListAppInstancesOutput,
                crate::error::ListAppInstancesError,
                crate::input::ListAppInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of
        /// <code>AppInstances</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of
        /// <code>AppInstances</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUserEndpoints`.
    ///
    /// <p>Lists all the <code>AppInstanceUserEndpoints</code> created under a single <code>AppInstanceUser</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstanceUserEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_user_endpoints_input::Builder,
    }
    impl<C, M, R> ListAppInstanceUserEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUserEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceUserEndpointsInputOperationOutputAlias,
                crate::output::ListAppInstanceUserEndpointsOutput,
                crate::error::ListAppInstanceUserEndpointsError,
                crate::input::ListAppInstanceUserEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of endpoints that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of endpoints that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested endpoints are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUsers`.
    ///
    /// <p>List all <code>AppInstanceUsers</code> created under a single
    /// <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstanceUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_users_input::Builder,
    }
    impl<C, M, R> ListAppInstanceUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceUsersInputOperationOutputAlias,
                crate::output::ListAppInstanceUsersOutput,
                crate::error::ListAppInstanceUsersError,
                crate::input::ListAppInstanceUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK identity resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceRetentionSettings`.
    ///
    /// <p>Sets the amount of time in days that a given <code>AppInstance</code> retains
    /// data.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> PutAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::PutAppInstanceRetentionSettingsOutput,
                crate::error::PutAppInstanceRetentionSettingsError,
                crate::input::PutAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn app_instance_retention_settings(
            mut self,
            inp: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.inner = self.inner.app_instance_retention_settings(inp);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterAppInstanceUserEndpoint`.
    ///
    /// <p>Registers an endpoint under an Amazon Chime <code>AppInstanceUser</code>. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterAppInstanceUserEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_app_instance_user_endpoint_input::Builder,
    }
    impl<C, M, R> RegisterAppInstanceUserEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterAppInstanceUserEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterAppInstanceUserEndpointInputOperationOutputAlias,
                crate::output::RegisterAppInstanceUserEndpointOutput,
                crate::error::RegisterAppInstanceUserEndpointError,
                crate::input::RegisterAppInstanceUserEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>APNS</code>: The mobile notification service for an Apple device.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GCM</code>: The mobile notification service for an Android device.</p>
        /// </li>
        /// </ul>
        /// <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>
        pub fn r#type(mut self, inp: crate::model::AppInstanceUserEndpointType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>APNS</code>: The mobile notification service for an Apple device.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GCM</code>: The mobile notification service for an Android device.</p>
        /// </li>
        /// </ul>
        /// <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserEndpointType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to which the endpoint belongs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn endpoint_attributes(mut self, inp: crate::model::EndpointAttributes) -> Self {
            self.inner = self.inner.endpoint_attributes(inp);
            self
        }
        /// <p>The attributes of an <code>Endpoint</code>.</p>
        pub fn set_endpoint_attributes(
            mut self,
            input: std::option::Option<crate::model::EndpointAttributes>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_attributes(input);
            self
        }
        /// <p>The idempotency token for each client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The idempotency token for each client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages.
        /// <code>NONE</code> indicates the endpoint receives no messages.</p>
        pub fn allow_messages(mut self, inp: crate::model::AllowMessages) -> Self {
            self.inner = self.inner.allow_messages(inp);
            self
        }
        /// <p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages.
        /// <code>NONE</code> indicates the endpoint receives no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.inner = self.inner.set_allow_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK identity resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Chime SDK identity resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstance`.
    ///
    /// <p>Updates <code>AppInstance</code> metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_instance_input::Builder,
    }
    impl<C, M, R> UpdateAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInstanceInputOperationOutputAlias,
                crate::output::UpdateAppInstanceOutput,
                crate::error::UpdateAppInstanceError,
                crate::input::UpdateAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstanceUser`.
    ///
    /// <p>Updates the details of an <code>AppInstanceUser</code>. You can update names and
    /// metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_instance_user_input::Builder,
    }
    impl<C, M, R> UpdateAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInstanceUserInputOperationOutputAlias,
                crate::output::UpdateAppInstanceUserOutput,
                crate::error::UpdateAppInstanceUserError,
                crate::input::UpdateAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstanceUserEndpoint`.
    ///
    /// <p>Updates the details of an <code>AppInstanceUserEndpoint</code>. You can update the name and <code>AllowMessage</code> values.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAppInstanceUserEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_instance_user_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateAppInstanceUserEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAppInstanceUserEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceUserEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceUserEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInstanceUserEndpointInputOperationOutputAlias,
                crate::output::UpdateAppInstanceUserEndpointOutput,
                crate::error::UpdateAppInstanceUserEndpointError,
                crate::input::UpdateAppInstanceUserEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstanceUserEndpoint</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages.
        /// <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn allow_messages(mut self, inp: crate::model::AllowMessages) -> Self {
            self.inner = self.inner.allow_messages(inp);
            self
        }
        /// <p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages.
        /// <code>NONE</code> indicates the endpoint will receive no messages.</p>
        pub fn set_allow_messages(
            mut self,
            input: std::option::Option<crate::model::AllowMessages>,
        ) -> Self {
            self.inner = self.inner.set_allow_messages(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
