// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociatePhoneNumbersWithVoiceConnectorInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorInput)
pub mod associate_phone_numbers_with_voice_connector_input {
    /// A builder for [`AssociatePhoneNumbersWithVoiceConnectorInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) force_associate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Appends an item to `e164_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.e164_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.e164_phone_numbers = Some(v);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.e164_phone_numbers = input;
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, input: bool) -> Self {
            self.force_associate = Some(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.force_associate = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePhoneNumbersWithVoiceConnectorInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePhoneNumbersWithVoiceConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePhoneNumbersWithVoiceConnectorInput {
                voice_connector_id: self.voice_connector_id,
                e164_phone_numbers: self.e164_phone_numbers,
                force_associate: self.force_associate,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePhoneNumbersWithVoiceConnectorInputOperationOutputAlias =
    crate::operation::AssociatePhoneNumbersWithVoiceConnector;
#[doc(hidden)]
pub type AssociatePhoneNumbersWithVoiceConnectorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePhoneNumbersWithVoiceConnectorInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePhoneNumbersWithVoiceConnector`](crate::operation::AssociatePhoneNumbersWithVoiceConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePhoneNumbersWithVoiceConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.voice_connector_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_1, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "associate-phone-numbers");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_phone_numbers_with_voice_connector(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePhoneNumbersWithVoiceConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePhoneNumbersWithVoiceConnector",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumbersWithVoiceConnectorInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorInput)
    pub fn builder() -> crate::input::associate_phone_numbers_with_voice_connector_input::Builder {
        crate::input::associate_phone_numbers_with_voice_connector_input::Builder::default()
    }
}

/// See [`AssociatePhoneNumbersWithVoiceConnectorGroupInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput)
pub mod associate_phone_numbers_with_voice_connector_group_input {
    /// A builder for [`AssociatePhoneNumbersWithVoiceConnectorGroupInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_group_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) force_associate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_id = input;
            self
        }
        /// Appends an item to `e164_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.e164_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.e164_phone_numbers = Some(v);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.e164_phone_numbers = input;
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, input: bool) -> Self {
            self.force_associate = Some(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.force_associate = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePhoneNumbersWithVoiceConnectorGroupInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput {
                    voice_connector_group_id: self.voice_connector_group_id,
                    e164_phone_numbers: self.e164_phone_numbers,
                    force_associate: self.force_associate,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationOutputAlias =
    crate::operation::AssociatePhoneNumbersWithVoiceConnectorGroup;
#[doc(hidden)]
pub type AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePhoneNumbersWithVoiceConnectorGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePhoneNumbersWithVoiceConnectorGroup`](crate::operation::AssociatePhoneNumbersWithVoiceConnectorGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePhoneNumbersWithVoiceConnectorGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.voice_connector_group_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_group_id = aws_smithy_http::label::fmt_string(input_2, false);
            if voice_connector_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connector-groups/{VoiceConnectorGroupId}",
                VoiceConnectorGroupId = voice_connector_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "associate-phone-numbers");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_phone_numbers_with_voice_connector_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePhoneNumbersWithVoiceConnectorGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePhoneNumbersWithVoiceConnectorGroup",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumbersWithVoiceConnectorGroupInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput)
    pub fn builder(
    ) -> crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder {
        crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder::default()
    }
}

/// See [`AssociatePhoneNumberWithUserInput`](crate::input::AssociatePhoneNumberWithUserInput)
pub mod associate_phone_number_with_user_input {
    /// A builder for [`AssociatePhoneNumberWithUserInput`](crate::input::AssociatePhoneNumberWithUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn e164_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.e164_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn set_e164_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.e164_phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePhoneNumberWithUserInput`](crate::input::AssociatePhoneNumberWithUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePhoneNumberWithUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePhoneNumberWithUserInput {
                account_id: self.account_id,
                user_id: self.user_id,
                e164_phone_number: self.e164_phone_number,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePhoneNumberWithUserInputOperationOutputAlias =
    crate::operation::AssociatePhoneNumberWithUser;
#[doc(hidden)]
pub type AssociatePhoneNumberWithUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePhoneNumberWithUserInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePhoneNumberWithUser`](crate::operation::AssociatePhoneNumberWithUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePhoneNumberWithUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociatePhoneNumberWithUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.account_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_3, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.user_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_4, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users/{UserId}",
                AccountId = account_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociatePhoneNumberWithUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "associate-phone-number");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociatePhoneNumberWithUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociatePhoneNumberWithUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_phone_number_with_user(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePhoneNumberWithUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePhoneNumberWithUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumberWithUserInput`](crate::input::AssociatePhoneNumberWithUserInput)
    pub fn builder() -> crate::input::associate_phone_number_with_user_input::Builder {
        crate::input::associate_phone_number_with_user_input::Builder::default()
    }
}

/// See [`AssociateSigninDelegateGroupsWithAccountInput`](crate::input::AssociateSigninDelegateGroupsWithAccountInput)
pub mod associate_signin_delegate_groups_with_account_input {
    /// A builder for [`AssociateSigninDelegateGroupsWithAccountInput`](crate::input::AssociateSigninDelegateGroupsWithAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) signin_delegate_groups:
            std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `signin_delegate_groups`.
        ///
        /// To override the contents of this collection use [`set_signin_delegate_groups`](Self::set_signin_delegate_groups).
        ///
        /// <p>The sign-in delegate groups.</p>
        pub fn signin_delegate_groups(mut self, input: crate::model::SigninDelegateGroup) -> Self {
            let mut v = self.signin_delegate_groups.unwrap_or_default();
            v.push(input);
            self.signin_delegate_groups = Some(v);
            self
        }
        /// <p>The sign-in delegate groups.</p>
        pub fn set_signin_delegate_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
        ) -> Self {
            self.signin_delegate_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSigninDelegateGroupsWithAccountInput`](crate::input::AssociateSigninDelegateGroupsWithAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSigninDelegateGroupsWithAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AssociateSigninDelegateGroupsWithAccountInput {
                    account_id: self.account_id,
                    signin_delegate_groups: self.signin_delegate_groups,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AssociateSigninDelegateGroupsWithAccountInputOperationOutputAlias =
    crate::operation::AssociateSigninDelegateGroupsWithAccount;
#[doc(hidden)]
pub type AssociateSigninDelegateGroupsWithAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateSigninDelegateGroupsWithAccountInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSigninDelegateGroupsWithAccount`](crate::operation::AssociateSigninDelegateGroupsWithAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSigninDelegateGroupsWithAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSigninDelegateGroupsWithAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.account_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_5, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateSigninDelegateGroupsWithAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "associate-signin-delegate-groups");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSigninDelegateGroupsWithAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSigninDelegateGroupsWithAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_signin_delegate_groups_with_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSigninDelegateGroupsWithAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSigninDelegateGroupsWithAccount",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSigninDelegateGroupsWithAccountInput`](crate::input::AssociateSigninDelegateGroupsWithAccountInput)
    pub fn builder() -> crate::input::associate_signin_delegate_groups_with_account_input::Builder {
        crate::input::associate_signin_delegate_groups_with_account_input::Builder::default()
    }
}

/// See [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
pub mod batch_create_attendee_input {
    /// A builder for [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendees:
            std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Appends an item to `attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            let mut v = self.attendees.unwrap_or_default();
            v.push(input);
            self.attendees = Some(v);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.attendees = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateAttendeeInput {
                meeting_id: self.meeting_id,
                attendees: self.attendees,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateAttendeeInputOperationOutputAlias = crate::operation::BatchCreateAttendee;
#[doc(hidden)]
pub type BatchCreateAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateAttendee`](crate::operation::BatchCreateAttendee)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateAttendeeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.meeting_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_6, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees",
                MeetingId = meeting_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchCreateAttendeeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-create");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateAttendeeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateAttendeeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_attendee(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateAttendee",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    pub fn builder() -> crate::input::batch_create_attendee_input::Builder {
        crate::input::batch_create_attendee_input::Builder::default()
    }
}

/// See [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
pub mod batch_create_channel_membership_input {
    /// A builder for [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) member_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `member_arns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.member_arns.unwrap_or_default();
            v.push(input.into());
            self.member_arns = Some(v);
            self
        }
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.member_arns = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateChannelMembershipInput {
                channel_arn: self.channel_arn,
                r#type: self.r#type,
                member_arns: self.member_arns,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateChannelMembershipInputOperationOutputAlias =
    crate::operation::BatchCreateChannelMembership;
#[doc(hidden)]
pub type BatchCreateChannelMembershipInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateChannelMembership`](crate::operation::BatchCreateChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.channel_arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_7, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_8) = &_input.chime_bearer {
                let formatted_9 = AsRef::<str>::as_ref(inner_8);
                if !formatted_9.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_9;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::BatchCreateChannelMembershipInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-create");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_channel_membership(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateChannelMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    pub fn builder() -> crate::input::batch_create_channel_membership_input::Builder {
        crate::input::batch_create_channel_membership_input::Builder::default()
    }
}

/// See [`BatchCreateRoomMembershipInput`](crate::input::BatchCreateRoomMembershipInput)
pub mod batch_create_room_membership_input {
    /// A builder for [`BatchCreateRoomMembershipInput`](crate::input::BatchCreateRoomMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) room_id: std::option::Option<std::string::String>,
        pub(crate) membership_item_list:
            std::option::Option<std::vec::Vec<crate::model::MembershipItem>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// Appends an item to `membership_item_list`.
        ///
        /// To override the contents of this collection use [`set_membership_item_list`](Self::set_membership_item_list).
        ///
        /// <p>The list of membership items.</p>
        pub fn membership_item_list(mut self, input: crate::model::MembershipItem) -> Self {
            let mut v = self.membership_item_list.unwrap_or_default();
            v.push(input);
            self.membership_item_list = Some(v);
            self
        }
        /// <p>The list of membership items.</p>
        pub fn set_membership_item_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MembershipItem>>,
        ) -> Self {
            self.membership_item_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateRoomMembershipInput`](crate::input::BatchCreateRoomMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateRoomMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateRoomMembershipInput {
                account_id: self.account_id,
                room_id: self.room_id,
                membership_item_list: self.membership_item_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateRoomMembershipInputOperationOutputAlias =
    crate::operation::BatchCreateRoomMembership;
#[doc(hidden)]
pub type BatchCreateRoomMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateRoomMembershipInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateRoomMembership`](crate::operation::BatchCreateRoomMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateRoomMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateRoomMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.account_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_10, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.room_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "room_id",
                        details: "cannot be empty or unset",
                    })?;
            let room_id = aws_smithy_http::label::fmt_string(input_11, false);
            if room_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "room_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms/{RoomId}/memberships",
                AccountId = account_id,
                RoomId = room_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchCreateRoomMembershipInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-create");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateRoomMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateRoomMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_room_membership(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateRoomMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateRoomMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateRoomMembershipInput`](crate::input::BatchCreateRoomMembershipInput)
    pub fn builder() -> crate::input::batch_create_room_membership_input::Builder {
        crate::input::batch_create_room_membership_input::Builder::default()
    }
}

/// See [`BatchDeletePhoneNumberInput`](crate::input::BatchDeletePhoneNumberInput)
pub mod batch_delete_phone_number_input {
    /// A builder for [`BatchDeletePhoneNumberInput`](crate::input::BatchDeletePhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `phone_number_ids`.
        ///
        /// To override the contents of this collection use [`set_phone_number_ids`](Self::set_phone_number_ids).
        ///
        /// <p>List of phone number IDs.</p>
        pub fn phone_number_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.phone_number_ids.unwrap_or_default();
            v.push(input.into());
            self.phone_number_ids = Some(v);
            self
        }
        /// <p>List of phone number IDs.</p>
        pub fn set_phone_number_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phone_number_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeletePhoneNumberInput`](crate::input::BatchDeletePhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeletePhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeletePhoneNumberInput {
                phone_number_ids: self.phone_number_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeletePhoneNumberInputOperationOutputAlias = crate::operation::BatchDeletePhoneNumber;
#[doc(hidden)]
pub type BatchDeletePhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeletePhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeletePhoneNumber`](crate::operation::BatchDeletePhoneNumber)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeletePhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeletePhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/phone-numbers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchDeletePhoneNumberInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-delete");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeletePhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeletePhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_phone_number(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeletePhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeletePhoneNumber",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeletePhoneNumberInput`](crate::input::BatchDeletePhoneNumberInput)
    pub fn builder() -> crate::input::batch_delete_phone_number_input::Builder {
        crate::input::batch_delete_phone_number_input::Builder::default()
    }
}

/// See [`BatchSuspendUserInput`](crate::input::BatchSuspendUserInput)
pub mod batch_suspend_user_input {
    /// A builder for [`BatchSuspendUserInput`](crate::input::BatchSuspendUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `user_id_list`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn user_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_id_list.unwrap_or_default();
            v.push(input.into());
            self.user_id_list = Some(v);
            self
        }
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSuspendUserInput`](crate::input::BatchSuspendUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchSuspendUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchSuspendUserInput {
                account_id: self.account_id,
                user_id_list: self.user_id_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchSuspendUserInputOperationOutputAlias = crate::operation::BatchSuspendUser;
#[doc(hidden)]
pub type BatchSuspendUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchSuspendUserInput {
    /// Consumes the builder and constructs an Operation<[`BatchSuspendUser`](crate::operation::BatchSuspendUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchSuspendUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchSuspendUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.account_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_12, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchSuspendUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "suspend");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchSuspendUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchSuspendUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_suspend_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchSuspendUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchSuspendUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchSuspendUserInput`](crate::input::BatchSuspendUserInput)
    pub fn builder() -> crate::input::batch_suspend_user_input::Builder {
        crate::input::batch_suspend_user_input::Builder::default()
    }
}

/// See [`BatchUnsuspendUserInput`](crate::input::BatchUnsuspendUserInput)
pub mod batch_unsuspend_user_input {
    /// A builder for [`BatchUnsuspendUserInput`](crate::input::BatchUnsuspendUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `user_id_list`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn user_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_id_list.unwrap_or_default();
            v.push(input.into());
            self.user_id_list = Some(v);
            self
        }
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUnsuspendUserInput`](crate::input::BatchUnsuspendUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUnsuspendUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUnsuspendUserInput {
                account_id: self.account_id,
                user_id_list: self.user_id_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUnsuspendUserInputOperationOutputAlias = crate::operation::BatchUnsuspendUser;
#[doc(hidden)]
pub type BatchUnsuspendUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUnsuspendUserInput {
    /// Consumes the builder and constructs an Operation<[`BatchUnsuspendUser`](crate::operation::BatchUnsuspendUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUnsuspendUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUnsuspendUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.account_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_13, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchUnsuspendUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "unsuspend");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUnsuspendUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUnsuspendUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_unsuspend_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUnsuspendUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUnsuspendUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUnsuspendUserInput`](crate::input::BatchUnsuspendUserInput)
    pub fn builder() -> crate::input::batch_unsuspend_user_input::Builder {
        crate::input::batch_unsuspend_user_input::Builder::default()
    }
}

/// See [`BatchUpdatePhoneNumberInput`](crate::input::BatchUpdatePhoneNumberInput)
pub mod batch_update_phone_number_input {
    /// A builder for [`BatchUpdatePhoneNumberInput`](crate::input::BatchUpdatePhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_phone_number_request_items:
            std::option::Option<std::vec::Vec<crate::model::UpdatePhoneNumberRequestItem>>,
    }
    impl Builder {
        /// Appends an item to `update_phone_number_request_items`.
        ///
        /// To override the contents of this collection use [`set_update_phone_number_request_items`](Self::set_update_phone_number_request_items).
        ///
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn update_phone_number_request_items(
            mut self,
            input: crate::model::UpdatePhoneNumberRequestItem,
        ) -> Self {
            let mut v = self.update_phone_number_request_items.unwrap_or_default();
            v.push(input);
            self.update_phone_number_request_items = Some(v);
            self
        }
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn set_update_phone_number_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdatePhoneNumberRequestItem>>,
        ) -> Self {
            self.update_phone_number_request_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdatePhoneNumberInput`](crate::input::BatchUpdatePhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdatePhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdatePhoneNumberInput {
                update_phone_number_request_items: self.update_phone_number_request_items,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdatePhoneNumberInputOperationOutputAlias = crate::operation::BatchUpdatePhoneNumber;
#[doc(hidden)]
pub type BatchUpdatePhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpdatePhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdatePhoneNumber`](crate::operation::BatchUpdatePhoneNumber)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdatePhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdatePhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/phone-numbers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::BatchUpdatePhoneNumberInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "batch-update");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdatePhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdatePhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_phone_number(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdatePhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdatePhoneNumber",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdatePhoneNumberInput`](crate::input::BatchUpdatePhoneNumberInput)
    pub fn builder() -> crate::input::batch_update_phone_number_input::Builder {
        crate::input::batch_update_phone_number_input::Builder::default()
    }
}

/// See [`BatchUpdateUserInput`](crate::input::BatchUpdateUserInput)
pub mod batch_update_user_input {
    /// A builder for [`BatchUpdateUserInput`](crate::input::BatchUpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) update_user_request_items:
            std::option::Option<std::vec::Vec<crate::model::UpdateUserRequestItem>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `update_user_request_items`.
        ///
        /// To override the contents of this collection use [`set_update_user_request_items`](Self::set_update_user_request_items).
        ///
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn update_user_request_items(
            mut self,
            input: crate::model::UpdateUserRequestItem,
        ) -> Self {
            let mut v = self.update_user_request_items.unwrap_or_default();
            v.push(input);
            self.update_user_request_items = Some(v);
            self
        }
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn set_update_user_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateUserRequestItem>>,
        ) -> Self {
            self.update_user_request_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateUserInput`](crate::input::BatchUpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateUserInput {
                account_id: self.account_id,
                update_user_request_items: self.update_user_request_items,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateUserInputOperationOutputAlias = crate::operation::BatchUpdateUser;
#[doc(hidden)]
pub type BatchUpdateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateUser`](crate::operation::BatchUpdateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.account_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_14, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateUserInput`](crate::input::BatchUpdateUserInput)
    pub fn builder() -> crate::input::batch_update_user_input::Builder {
        crate::input::batch_update_user_input::Builder::default()
    }
}

/// See [`CreateAccountInput`](crate::input::CreateAccountInput)
pub mod create_account_input {
    /// A builder for [`CreateAccountInput`](crate::input::CreateAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Chime account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Chime account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountInput`](crate::input::CreateAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccountInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type CreateAccountInputOperationOutputAlias = crate::operation::CreateAccount;
#[doc(hidden)]
pub type CreateAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccountInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccount`](crate::operation::CreateAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccount",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccountInput`](crate::input::CreateAccountInput)
    pub fn builder() -> crate::input::create_account_input::Builder {
        crate::input::create_account_input::Builder::default()
    }
}

/// See [`CreateAppInstanceInput`](crate::input::CreateAppInstanceInput)
pub mod create_app_instance_input {
    /// A builder for [`CreateAppInstanceInput`](crate::input::CreateAppInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceInput`](crate::input::CreateAppInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppInstanceInput {
                name: self.name,
                metadata: self.metadata,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInstanceInputOperationOutputAlias = crate::operation::CreateAppInstance;
#[doc(hidden)]
pub type CreateAppInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppInstance`](crate::operation::CreateAppInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/app-instances").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_app_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppInstance",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceInput`](crate::input::CreateAppInstanceInput)
    pub fn builder() -> crate::input::create_app_instance_input::Builder {
        crate::input::create_app_instance_input::Builder::default()
    }
}

/// See [`CreateAppInstanceAdminInput`](crate::input::CreateAppInstanceAdminInput)
pub mod create_app_instance_admin_input {
    /// A builder for [`CreateAppInstanceAdminInput`](crate::input::CreateAppInstanceAdminInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_admin_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_admin_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_admin_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceAdminInput`](crate::input::CreateAppInstanceAdminInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppInstanceAdminInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppInstanceAdminInput {
                app_instance_admin_arn: self.app_instance_admin_arn,
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInstanceAdminInputOperationOutputAlias = crate::operation::CreateAppInstanceAdmin;
#[doc(hidden)]
pub type CreateAppInstanceAdminInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInstanceAdminInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppInstanceAdmin`](crate::operation::CreateAppInstanceAdmin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppInstanceAdmin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInstanceAdminInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.app_instance_arn;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_15, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/admins",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInstanceAdminInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInstanceAdminInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_app_instance_admin(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppInstanceAdmin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppInstanceAdmin",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceAdminInput`](crate::input::CreateAppInstanceAdminInput)
    pub fn builder() -> crate::input::create_app_instance_admin_input::Builder {
        crate::input::create_app_instance_admin_input::Builder::default()
    }
}

/// See [`CreateAppInstanceUserInput`](crate::input::CreateAppInstanceUserInput)
pub mod create_app_instance_user_input {
    /// A builder for [`CreateAppInstanceUserInput`](crate::input::CreateAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_user_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn app_instance_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_id = Some(input.into());
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_id = input;
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInstanceUserInput`](crate::input::CreateAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppInstanceUserInput {
                app_instance_arn: self.app_instance_arn,
                app_instance_user_id: self.app_instance_user_id,
                name: self.name,
                metadata: self.metadata,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInstanceUserInputOperationOutputAlias = crate::operation::CreateAppInstanceUser;
#[doc(hidden)]
pub type CreateAppInstanceUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppInstanceUser`](crate::operation::CreateAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/app-instance-users").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_app_instance_user(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceUserInput`](crate::input::CreateAppInstanceUserInput)
    pub fn builder() -> crate::input::create_app_instance_user_input::Builder {
        crate::input::create_app_instance_user_input::Builder::default()
    }
}

/// See [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
pub mod create_attendee_input {
    /// A builder for [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAttendeeInput {
                meeting_id: self.meeting_id,
                external_user_id: self.external_user_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAttendeeInputOperationOutputAlias = crate::operation::CreateAttendee;
#[doc(hidden)]
pub type CreateAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`CreateAttendee`](crate::operation::CreateAttendee)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAttendeeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.meeting_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_16, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees",
                MeetingId = meeting_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAttendeeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAttendeeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_attendee(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAttendee",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    pub fn builder() -> crate::input::create_attendee_input::Builder {
        crate::input::create_attendee_input::Builder::default()
    }
}

/// See [`CreateBotInput`](crate::input::CreateBotInput)
pub mod create_bot_input {
    /// A builder for [`CreateBotInput`](crate::input::CreateBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The bot display name.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The bot display name.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotInput`](crate::input::CreateBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateBotInput {
                account_id: self.account_id,
                display_name: self.display_name,
                domain: self.domain,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotInputOperationOutputAlias = crate::operation::CreateBot;
#[doc(hidden)]
pub type CreateBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBotInput {
    /// Consumes the builder and constructs an Operation<[`CreateBot`](crate::operation::CreateBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.account_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_17, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}/bots", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_bot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateBot",
                    "chime",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotInput`](crate::input::CreateBotInput)
    pub fn builder() -> crate::input::create_bot_input::Builder {
        crate::input::create_bot_input::Builder::default()
    }
}

/// See [`CreateChannelInput`](crate::input::CreateChannelInput)
pub mod create_channel_input {
    /// A builder for [`CreateChannelInput`](crate::input::CreateChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelInput`](crate::input::CreateChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelInput {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                client_request_token: self.client_request_token,
                tags: self.tags,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelInputOperationOutputAlias = crate::operation::CreateChannel;
#[doc(hidden)]
pub type CreateChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannel`](crate::operation::CreateChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_18) = &_input.chime_bearer {
                let formatted_19 = AsRef::<str>::as_ref(inner_18);
                if !formatted_19.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_19;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_channel(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannel",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
}

/// See [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
pub mod create_channel_ban_input {
    /// A builder for [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelBanInputOperationOutputAlias = crate::operation::CreateChannelBan;
#[doc(hidden)]
pub type CreateChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelBan`](crate::operation::CreateChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.channel_arn;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_20, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_21) = &_input.chime_bearer {
                let formatted_22 = AsRef::<str>::as_ref(inner_21);
                if !formatted_22.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_22;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_ban(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelBan",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    pub fn builder() -> crate::input::create_channel_ban_input::Builder {
        crate::input::create_channel_ban_input::Builder::default()
    }
}

/// See [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
pub mod create_channel_membership_input {
    /// A builder for [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                r#type: self.r#type,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelMembershipInputOperationOutputAlias =
    crate::operation::CreateChannelMembership;
#[doc(hidden)]
pub type CreateChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelMembership`](crate::operation::CreateChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.channel_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_24) = &_input.chime_bearer {
                let formatted_25 = AsRef::<str>::as_ref(inner_24);
                if !formatted_25.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_25;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_membership(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    pub fn builder() -> crate::input::create_channel_membership_input::Builder {
        crate::input::create_channel_membership_input::Builder::default()
    }
}

/// See [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
pub mod create_channel_moderator_input {
    /// A builder for [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelModeratorInputOperationOutputAlias = crate::operation::CreateChannelModerator;
#[doc(hidden)]
pub type CreateChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannelModerator`](crate::operation::CreateChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.channel_arn;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_26, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_27) = &_input.chime_bearer {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_channel_moderator(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannelModerator",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    pub fn builder() -> crate::input::create_channel_moderator_input::Builder {
        crate::input::create_channel_moderator_input::Builder::default()
    }
}

/// See [`CreateMediaCapturePipelineInput`](crate::input::CreateMediaCapturePipelineInput)
pub mod create_media_capture_pipeline_input {
    /// A builder for [`CreateMediaCapturePipelineInput`](crate::input::CreateMediaCapturePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<crate::model::MediaPipelineSourceType>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) sink_type: std::option::Option<crate::model::MediaPipelineSinkType>,
        pub(crate) sink_arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) chime_sdk_meeting_configuration:
            std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
    }
    impl Builder {
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>
        pub fn source_type(mut self, input: crate::model::MediaPipelineSourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn sink_type(mut self, input: crate::model::MediaPipelineSinkType) -> Self {
            self.sink_type = Some(input);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn set_sink_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSinkType>,
        ) -> Self {
            self.sink_type = input;
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn sink_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sink_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn set_sink_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sink_arn = input;
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn chime_sdk_meeting_configuration(
            mut self,
            input: crate::model::ChimeSdkMeetingConfiguration,
        ) -> Self {
            self.chime_sdk_meeting_configuration = Some(input);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn set_chime_sdk_meeting_configuration(
            mut self,
            input: std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
        ) -> Self {
            self.chime_sdk_meeting_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMediaCapturePipelineInput`](crate::input::CreateMediaCapturePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMediaCapturePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMediaCapturePipelineInput {
                source_type: self.source_type,
                source_arn: self.source_arn,
                sink_type: self.sink_type,
                sink_arn: self.sink_arn,
                client_request_token: self.client_request_token,
                chime_sdk_meeting_configuration: self.chime_sdk_meeting_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMediaCapturePipelineInputOperationOutputAlias =
    crate::operation::CreateMediaCapturePipeline;
#[doc(hidden)]
pub type CreateMediaCapturePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMediaCapturePipelineInput {
    /// Consumes the builder and constructs an Operation<[`CreateMediaCapturePipeline`](crate::operation::CreateMediaCapturePipeline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMediaCapturePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMediaCapturePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/media-capture-pipelines").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMediaCapturePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMediaCapturePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_media_capture_pipeline(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMediaCapturePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMediaCapturePipeline",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMediaCapturePipelineInput`](crate::input::CreateMediaCapturePipelineInput)
    pub fn builder() -> crate::input::create_media_capture_pipeline_input::Builder {
        crate::input::create_media_capture_pipeline_input::Builder::default()
    }
}

/// See [`CreateMeetingInput`](crate::input::CreateMeetingInput)
pub mod create_meeting_input {
    /// A builder for [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) meeting_host_id: std::option::Option<std::string::String>,
        pub(crate) media_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) notifications_configuration:
            std::option::Option<crate::model::MeetingNotificationConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_host_id = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.meeting_host_id = input;
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.notifications_configuration = Some(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.notifications_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingInput`](crate::input::CreateMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeetingInput {
                client_request_token: self.client_request_token,
                external_meeting_id: self.external_meeting_id,
                meeting_host_id: self.meeting_host_id,
                media_region: self.media_region,
                tags: self.tags,
                notifications_configuration: self.notifications_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeetingInputOperationOutputAlias = crate::operation::CreateMeeting;
#[doc(hidden)]
pub type CreateMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeetingInput {
    /// Consumes the builder and constructs an Operation<[`CreateMeeting`](crate::operation::CreateMeeting)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMeetingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/meetings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMeetingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMeetingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_meeting(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMeeting",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    pub fn builder() -> crate::input::create_meeting_input::Builder {
        crate::input::create_meeting_input::Builder::default()
    }
}

/// See [`CreateMeetingDialOutInput`](crate::input::CreateMeetingDialOutInput)
pub mod create_meeting_dial_out_input {
    /// A builder for [`CreateMeetingDialOutInput`](crate::input::CreateMeetingDialOutInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) from_phone_number: std::option::Option<std::string::String>,
        pub(crate) to_phone_number: std::option::Option<std::string::String>,
        pub(crate) join_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn from_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_phone_number = Some(input.into());
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_phone_number = input;
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn to_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_phone_number = Some(input.into());
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.to_phone_number = input;
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn join_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.join_token = Some(input.into());
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn set_join_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.join_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingDialOutInput`](crate::input::CreateMeetingDialOutInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeetingDialOutInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeetingDialOutInput {
                meeting_id: self.meeting_id,
                from_phone_number: self.from_phone_number,
                to_phone_number: self.to_phone_number,
                join_token: self.join_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeetingDialOutInputOperationOutputAlias = crate::operation::CreateMeetingDialOut;
#[doc(hidden)]
pub type CreateMeetingDialOutInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeetingDialOutInput {
    /// Consumes the builder and constructs an Operation<[`CreateMeetingDialOut`](crate::operation::CreateMeetingDialOut)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMeetingDialOut,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMeetingDialOutInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.meeting_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_29, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/dial-outs",
                MeetingId = meeting_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMeetingDialOutInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMeetingDialOutInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_meeting_dial_out(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMeetingDialOut::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMeetingDialOut",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMeetingDialOutInput`](crate::input::CreateMeetingDialOutInput)
    pub fn builder() -> crate::input::create_meeting_dial_out_input::Builder {
        crate::input::create_meeting_dial_out_input::Builder::default()
    }
}

/// See [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
pub mod create_meeting_with_attendees_input {
    /// A builder for [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) meeting_host_id: std::option::Option<std::string::String>,
        pub(crate) media_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) notifications_configuration:
            std::option::Option<crate::model::MeetingNotificationConfiguration>,
        pub(crate) attendees:
            std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
    }
    impl Builder {
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_host_id = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.meeting_host_id = input;
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.notifications_configuration = Some(input);
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.notifications_configuration = input;
            self
        }
        /// Appends an item to `attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            let mut v = self.attendees.unwrap_or_default();
            v.push(input);
            self.attendees = Some(v);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.attendees = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeetingWithAttendeesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeetingWithAttendeesInput {
                client_request_token: self.client_request_token,
                external_meeting_id: self.external_meeting_id,
                meeting_host_id: self.meeting_host_id,
                media_region: self.media_region,
                tags: self.tags,
                notifications_configuration: self.notifications_configuration,
                attendees: self.attendees,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeetingWithAttendeesInputOperationOutputAlias =
    crate::operation::CreateMeetingWithAttendees;
#[doc(hidden)]
pub type CreateMeetingWithAttendeesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeetingWithAttendeesInput {
    /// Consumes the builder and constructs an Operation<[`CreateMeetingWithAttendees`](crate::operation::CreateMeetingWithAttendees)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMeetingWithAttendees,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMeetingWithAttendeesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/meetings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::CreateMeetingWithAttendeesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "create-attendees");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMeetingWithAttendeesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMeetingWithAttendeesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_meeting_with_attendees(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMeetingWithAttendees::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMeetingWithAttendees",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    pub fn builder() -> crate::input::create_meeting_with_attendees_input::Builder {
        crate::input::create_meeting_with_attendees_input::Builder::default()
    }
}

/// See [`CreatePhoneNumberOrderInput`](crate::input::CreatePhoneNumberOrderInput)
pub mod create_phone_number_order_input {
    /// A builder for [`CreatePhoneNumberOrderInput`](crate::input::CreatePhoneNumberOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_type: std::option::Option<crate::model::PhoneNumberProductType>,
        pub(crate) e164_phone_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// Appends an item to `e164_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.e164_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.e164_phone_numbers = Some(v);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.e164_phone_numbers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePhoneNumberOrderInput`](crate::input::CreatePhoneNumberOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePhoneNumberOrderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePhoneNumberOrderInput {
                product_type: self.product_type,
                e164_phone_numbers: self.e164_phone_numbers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePhoneNumberOrderInputOperationOutputAlias = crate::operation::CreatePhoneNumberOrder;
#[doc(hidden)]
pub type CreatePhoneNumberOrderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePhoneNumberOrderInput {
    /// Consumes the builder and constructs an Operation<[`CreatePhoneNumberOrder`](crate::operation::CreatePhoneNumberOrder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePhoneNumberOrder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePhoneNumberOrderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/phone-number-orders").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePhoneNumberOrderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePhoneNumberOrderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_phone_number_order(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePhoneNumberOrder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePhoneNumberOrder",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePhoneNumberOrderInput`](crate::input::CreatePhoneNumberOrderInput)
    pub fn builder() -> crate::input::create_phone_number_order_input::Builder {
        crate::input::create_phone_number_order_input::Builder::default()
    }
}

/// See [`CreateProxySessionInput`](crate::input::CreateProxySessionInput)
pub mod create_proxy_session_input {
    /// A builder for [`CreateProxySessionInput`](crate::input::CreateProxySessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) participant_phone_numbers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) expiry_minutes: std::option::Option<i32>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) number_selection_behavior:
            std::option::Option<crate::model::NumberSelectionBehavior>,
        pub(crate) geo_match_level: std::option::Option<crate::model::GeoMatchLevel>,
        pub(crate) geo_match_params: std::option::Option<crate::model::GeoMatchParams>,
    }
    impl Builder {
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Appends an item to `participant_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_participant_phone_numbers`](Self::set_participant_phone_numbers).
        ///
        /// <p>The participant phone numbers.</p>
        pub fn participant_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.participant_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.participant_phone_numbers = Some(v);
            self
        }
        /// <p>The participant phone numbers.</p>
        pub fn set_participant_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.participant_phone_numbers = input;
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn expiry_minutes(mut self, input: i32) -> Self {
            self.expiry_minutes = Some(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn set_expiry_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.expiry_minutes = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The proxy session capabilities.</p>
        pub fn capabilities(mut self, input: crate::model::Capability) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input);
            self.capabilities = Some(v);
            self
        }
        /// <p>The proxy session capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn number_selection_behavior(
            mut self,
            input: crate::model::NumberSelectionBehavior,
        ) -> Self {
            self.number_selection_behavior = Some(input);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn set_number_selection_behavior(
            mut self,
            input: std::option::Option<crate::model::NumberSelectionBehavior>,
        ) -> Self {
            self.number_selection_behavior = input;
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn geo_match_level(mut self, input: crate::model::GeoMatchLevel) -> Self {
            self.geo_match_level = Some(input);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn set_geo_match_level(
            mut self,
            input: std::option::Option<crate::model::GeoMatchLevel>,
        ) -> Self {
            self.geo_match_level = input;
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn geo_match_params(mut self, input: crate::model::GeoMatchParams) -> Self {
            self.geo_match_params = Some(input);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn set_geo_match_params(
            mut self,
            input: std::option::Option<crate::model::GeoMatchParams>,
        ) -> Self {
            self.geo_match_params = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProxySessionInput`](crate::input::CreateProxySessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProxySessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProxySessionInput {
                voice_connector_id: self.voice_connector_id,
                participant_phone_numbers: self.participant_phone_numbers,
                name: self.name,
                expiry_minutes: self.expiry_minutes,
                capabilities: self.capabilities,
                number_selection_behavior: self.number_selection_behavior,
                geo_match_level: self.geo_match_level,
                geo_match_params: self.geo_match_params,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProxySessionInputOperationOutputAlias = crate::operation::CreateProxySession;
#[doc(hidden)]
pub type CreateProxySessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProxySessionInput {
    /// Consumes the builder and constructs an Operation<[`CreateProxySession`](crate::operation::CreateProxySession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProxySession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProxySessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.voice_connector_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_30, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/proxy-sessions",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProxySessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProxySessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_proxy_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProxySession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProxySession",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProxySessionInput`](crate::input::CreateProxySessionInput)
    pub fn builder() -> crate::input::create_proxy_session_input::Builder {
        crate::input::create_proxy_session_input::Builder::default()
    }
}

/// See [`CreateRoomInput`](crate::input::CreateRoomInput)
pub mod create_room_input {
    /// A builder for [`CreateRoomInput`](crate::input::CreateRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The room name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoomInput`](crate::input::CreateRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoomInput {
                account_id: self.account_id,
                name: self.name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoomInputOperationOutputAlias = crate::operation::CreateRoom;
#[doc(hidden)]
pub type CreateRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoomInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoom`](crate::operation::CreateRoom)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.account_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_31, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_room(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoom",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
}

/// See [`CreateRoomMembershipInput`](crate::input::CreateRoomMembershipInput)
pub mod create_room_membership_input {
    /// A builder for [`CreateRoomMembershipInput`](crate::input::CreateRoomMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) room_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<crate::model::RoomMembershipRole>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The role of the member.</p>
        pub fn role(mut self, input: crate::model::RoomMembershipRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The role of the member.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoomMembershipInput`](crate::input::CreateRoomMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoomMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoomMembershipInput {
                account_id: self.account_id,
                room_id: self.room_id,
                member_id: self.member_id,
                role: self.role,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoomMembershipInputOperationOutputAlias = crate::operation::CreateRoomMembership;
#[doc(hidden)]
pub type CreateRoomMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoomMembershipInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoomMembership`](crate::operation::CreateRoomMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoomMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRoomMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.account_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_32, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.room_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "room_id",
                        details: "cannot be empty or unset",
                    })?;
            let room_id = aws_smithy_http::label::fmt_string(input_33, false);
            if room_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "room_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms/{RoomId}/memberships",
                AccountId = account_id,
                RoomId = room_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRoomMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRoomMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_room_membership(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoomMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoomMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRoomMembershipInput`](crate::input::CreateRoomMembershipInput)
    pub fn builder() -> crate::input::create_room_membership_input::Builder {
        crate::input::create_room_membership_input::Builder::default()
    }
}

/// See [`CreateSipMediaApplicationInput`](crate::input::CreateSipMediaApplicationInput)
pub mod create_sip_media_application_input {
    /// A builder for [`CreateSipMediaApplicationInput`](crate::input::CreateSipMediaApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) endpoints:
            std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
    }
    impl Builder {
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn endpoints(mut self, input: crate::model::SipMediaApplicationEndpoint) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input);
            self.endpoints = Some(v);
            self
        }
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSipMediaApplicationInput`](crate::input::CreateSipMediaApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSipMediaApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSipMediaApplicationInput {
                aws_region: self.aws_region,
                name: self.name,
                endpoints: self.endpoints,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSipMediaApplicationInputOperationOutputAlias =
    crate::operation::CreateSipMediaApplication;
#[doc(hidden)]
pub type CreateSipMediaApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSipMediaApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateSipMediaApplication`](crate::operation::CreateSipMediaApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSipMediaApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSipMediaApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/sip-media-applications").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSipMediaApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSipMediaApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sip_media_application(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSipMediaApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSipMediaApplication",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSipMediaApplicationInput`](crate::input::CreateSipMediaApplicationInput)
    pub fn builder() -> crate::input::create_sip_media_application_input::Builder {
        crate::input::create_sip_media_application_input::Builder::default()
    }
}

/// See [`CreateSipMediaApplicationCallInput`](crate::input::CreateSipMediaApplicationCallInput)
pub mod create_sip_media_application_call_input {
    /// A builder for [`CreateSipMediaApplicationCallInput`](crate::input::CreateSipMediaApplicationCallInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_phone_number: std::option::Option<std::string::String>,
        pub(crate) to_phone_number: std::option::Option<std::string::String>,
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
        pub(crate) sip_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn from_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_phone_number = input;
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn to_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.to_phone_number = input;
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// Adds a key-value pair to `sip_headers`.
        ///
        /// To override the contents of this collection use [`set_sip_headers`](Self::set_sip_headers).
        ///
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn sip_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.sip_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.sip_headers = Some(hash_map);
            self
        }
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn set_sip_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.sip_headers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSipMediaApplicationCallInput`](crate::input::CreateSipMediaApplicationCallInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSipMediaApplicationCallInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSipMediaApplicationCallInput {
                from_phone_number: self.from_phone_number,
                to_phone_number: self.to_phone_number,
                sip_media_application_id: self.sip_media_application_id,
                sip_headers: self.sip_headers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSipMediaApplicationCallInputOperationOutputAlias =
    crate::operation::CreateSipMediaApplicationCall;
#[doc(hidden)]
pub type CreateSipMediaApplicationCallInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateSipMediaApplicationCallInput {
    /// Consumes the builder and constructs an Operation<[`CreateSipMediaApplicationCall`](crate::operation::CreateSipMediaApplicationCall)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSipMediaApplicationCall,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSipMediaApplicationCallInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.sip_media_application_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_media_application_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_media_application_id = aws_smithy_http::label::fmt_string(input_34, false);
            if sip_media_application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_media_application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/sip-media-applications/{SipMediaApplicationId}/calls",
                SipMediaApplicationId = sip_media_application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSipMediaApplicationCallInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSipMediaApplicationCallInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sip_media_application_call(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSipMediaApplicationCall::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSipMediaApplicationCall",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSipMediaApplicationCallInput`](crate::input::CreateSipMediaApplicationCallInput)
    pub fn builder() -> crate::input::create_sip_media_application_call_input::Builder {
        crate::input::create_sip_media_application_call_input::Builder::default()
    }
}

/// See [`CreateSipRuleInput`](crate::input::CreateSipRuleInput)
pub mod create_sip_rule_input {
    /// A builder for [`CreateSipRuleInput`](crate::input::CreateSipRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) trigger_type: std::option::Option<crate::model::SipRuleTriggerType>,
        pub(crate) trigger_value: std::option::Option<std::string::String>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) target_applications:
            std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
    }
    impl Builder {
        /// <p>The name of the SIP rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SIP rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn trigger_type(mut self, input: crate::model::SipRuleTriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::SipRuleTriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
        pub fn trigger_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_value = Some(input.into());
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
        pub fn set_trigger_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trigger_value = input;
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// Appends an item to `target_applications`.
        ///
        /// To override the contents of this collection use [`set_target_applications`](Self::set_target_applications).
        ///
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn target_applications(
            mut self,
            input: crate::model::SipRuleTargetApplication,
        ) -> Self {
            let mut v = self.target_applications.unwrap_or_default();
            v.push(input);
            self.target_applications = Some(v);
            self
        }
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn set_target_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        ) -> Self {
            self.target_applications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSipRuleInput`](crate::input::CreateSipRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSipRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSipRuleInput {
                name: self.name,
                trigger_type: self.trigger_type,
                trigger_value: self.trigger_value,
                disabled: self.disabled,
                target_applications: self.target_applications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSipRuleInputOperationOutputAlias = crate::operation::CreateSipRule;
#[doc(hidden)]
pub type CreateSipRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSipRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateSipRule`](crate::operation::CreateSipRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSipRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSipRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/sip-rules").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSipRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSipRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sip_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSipRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSipRule",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSipRuleInput`](crate::input::CreateSipRuleInput)
    pub fn builder() -> crate::input::create_sip_rule_input::Builder {
        crate::input::create_sip_rule_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) user_type: std::option::Option<crate::model::UserType>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The user's email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The user's email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.user_type = Some(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                account_id: self.account_id,
                username: self.username,
                email: self.email,
                user_type: self.user_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.account_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_35, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::CreateUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "create");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`CreateVoiceConnectorInput`](crate::input::CreateVoiceConnectorInput)
pub mod create_voice_connector_input {
    /// A builder for [`CreateVoiceConnectorInput`](crate::input::CreateVoiceConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        pub(crate) require_encryption: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
        pub fn aws_region(mut self, input: crate::model::VoiceConnectorAwsRegion) -> Self {
            self.aws_region = Some(input);
            self
        }
        /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
        pub fn set_aws_region(
            mut self,
            input: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        ) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn require_encryption(mut self, input: bool) -> Self {
            self.require_encryption = Some(input);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn set_require_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.require_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVoiceConnectorInput`](crate::input::CreateVoiceConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVoiceConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVoiceConnectorInput {
                name: self.name,
                aws_region: self.aws_region,
                require_encryption: self.require_encryption,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVoiceConnectorInputOperationOutputAlias = crate::operation::CreateVoiceConnector;
#[doc(hidden)]
pub type CreateVoiceConnectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVoiceConnectorInput {
    /// Consumes the builder and constructs an Operation<[`CreateVoiceConnector`](crate::operation::CreateVoiceConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVoiceConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVoiceConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/voice-connectors").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVoiceConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVoiceConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_voice_connector(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVoiceConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVoiceConnector",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVoiceConnectorInput`](crate::input::CreateVoiceConnectorInput)
    pub fn builder() -> crate::input::create_voice_connector_input::Builder {
        crate::input::create_voice_connector_input::Builder::default()
    }
}

/// See [`CreateVoiceConnectorGroupInput`](crate::input::CreateVoiceConnectorGroupInput)
pub mod create_voice_connector_group_input {
    /// A builder for [`CreateVoiceConnectorGroupInput`](crate::input::CreateVoiceConnectorGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) voice_connector_items:
            std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
    }
    impl Builder {
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `voice_connector_items`.
        ///
        /// To override the contents of this collection use [`set_voice_connector_items`](Self::set_voice_connector_items).
        ///
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn voice_connector_items(mut self, input: crate::model::VoiceConnectorItem) -> Self {
            let mut v = self.voice_connector_items.unwrap_or_default();
            v.push(input);
            self.voice_connector_items = Some(v);
            self
        }
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn set_voice_connector_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        ) -> Self {
            self.voice_connector_items = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVoiceConnectorGroupInput`](crate::input::CreateVoiceConnectorGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVoiceConnectorGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVoiceConnectorGroupInput {
                name: self.name,
                voice_connector_items: self.voice_connector_items,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVoiceConnectorGroupInputOperationOutputAlias =
    crate::operation::CreateVoiceConnectorGroup;
#[doc(hidden)]
pub type CreateVoiceConnectorGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVoiceConnectorGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateVoiceConnectorGroup`](crate::operation::CreateVoiceConnectorGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVoiceConnectorGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVoiceConnectorGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/voice-connector-groups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVoiceConnectorGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVoiceConnectorGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_voice_connector_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVoiceConnectorGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVoiceConnectorGroup",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVoiceConnectorGroupInput`](crate::input::CreateVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::create_voice_connector_group_input::Builder {
        crate::input::create_voice_connector_group_input::Builder::default()
    }
}

/// See [`DeleteAccountInput`](crate::input::DeleteAccountInput)
pub mod delete_account_input {
    /// A builder for [`DeleteAccountInput`](crate::input::DeleteAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountInput`](crate::input::DeleteAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountInputOperationOutputAlias = crate::operation::DeleteAccount;
#[doc(hidden)]
pub type DeleteAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccountInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccount`](crate::operation::DeleteAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.account_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_36, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccount",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountInput`](crate::input::DeleteAccountInput)
    pub fn builder() -> crate::input::delete_account_input::Builder {
        crate::input::delete_account_input::Builder::default()
    }
}

/// See [`DeleteAppInstanceInput`](crate::input::DeleteAppInstanceInput)
pub mod delete_app_instance_input {
    /// A builder for [`DeleteAppInstanceInput`](crate::input::DeleteAppInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInstanceInput`](crate::input::DeleteAppInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppInstanceInput {
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInstanceInputOperationOutputAlias = crate::operation::DeleteAppInstance;
#[doc(hidden)]
pub type DeleteAppInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppInstance`](crate::operation::DeleteAppInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.app_instance_arn;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_37, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppInstance",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceInput`](crate::input::DeleteAppInstanceInput)
    pub fn builder() -> crate::input::delete_app_instance_input::Builder {
        crate::input::delete_app_instance_input::Builder::default()
    }
}

/// See [`DeleteAppInstanceAdminInput`](crate::input::DeleteAppInstanceAdminInput)
pub mod delete_app_instance_admin_input {
    /// A builder for [`DeleteAppInstanceAdminInput`](crate::input::DeleteAppInstanceAdminInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_admin_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_admin_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_admin_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInstanceAdminInput`](crate::input::DeleteAppInstanceAdminInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppInstanceAdminInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppInstanceAdminInput {
                app_instance_admin_arn: self.app_instance_admin_arn,
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInstanceAdminInputOperationOutputAlias = crate::operation::DeleteAppInstanceAdmin;
#[doc(hidden)]
pub type DeleteAppInstanceAdminInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInstanceAdminInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppInstanceAdmin`](crate::operation::DeleteAppInstanceAdmin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppInstanceAdmin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInstanceAdminInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.app_instance_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_38, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.app_instance_admin_arn;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_admin_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_admin_arn = aws_smithy_http::label::fmt_string(input_39, false);
            if app_instance_admin_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_admin_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}",
                AppInstanceArn = app_instance_arn,
                AppInstanceAdminArn = app_instance_admin_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInstanceAdminInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInstanceAdminInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppInstanceAdmin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppInstanceAdmin",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceAdminInput`](crate::input::DeleteAppInstanceAdminInput)
    pub fn builder() -> crate::input::delete_app_instance_admin_input::Builder {
        crate::input::delete_app_instance_admin_input::Builder::default()
    }
}

/// See [`DeleteAppInstanceStreamingConfigurationsInput`](crate::input::DeleteAppInstanceStreamingConfigurationsInput)
pub mod delete_app_instance_streaming_configurations_input {
    /// A builder for [`DeleteAppInstanceStreamingConfigurationsInput`](crate::input::DeleteAppInstanceStreamingConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInstanceStreamingConfigurationsInput`](crate::input::DeleteAppInstanceStreamingConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppInstanceStreamingConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteAppInstanceStreamingConfigurationsInput {
                    app_instance_arn: self.app_instance_arn,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInstanceStreamingConfigurationsInputOperationOutputAlias =
    crate::operation::DeleteAppInstanceStreamingConfigurations;
#[doc(hidden)]
pub type DeleteAppInstanceStreamingConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInstanceStreamingConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppInstanceStreamingConfigurations`](crate::operation::DeleteAppInstanceStreamingConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppInstanceStreamingConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInstanceStreamingConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.app_instance_arn;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_40, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/streaming-configurations",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInstanceStreamingConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInstanceStreamingConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppInstanceStreamingConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppInstanceStreamingConfigurations",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceStreamingConfigurationsInput`](crate::input::DeleteAppInstanceStreamingConfigurationsInput)
    pub fn builder() -> crate::input::delete_app_instance_streaming_configurations_input::Builder {
        crate::input::delete_app_instance_streaming_configurations_input::Builder::default()
    }
}

/// See [`DeleteAppInstanceUserInput`](crate::input::DeleteAppInstanceUserInput)
pub mod delete_app_instance_user_input {
    /// A builder for [`DeleteAppInstanceUserInput`](crate::input::DeleteAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user request being deleted.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInstanceUserInput`](crate::input::DeleteAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppInstanceUserInput {
                app_instance_user_arn: self.app_instance_user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInstanceUserInputOperationOutputAlias = crate::operation::DeleteAppInstanceUser;
#[doc(hidden)]
pub type DeleteAppInstanceUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppInstanceUser`](crate::operation::DeleteAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.app_instance_user_arn;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_user_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_user_arn = aws_smithy_http::label::fmt_string(input_41, false);
            if app_instance_user_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_user_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instance-users/{AppInstanceUserArn}",
                AppInstanceUserArn = app_instance_user_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceUserInput`](crate::input::DeleteAppInstanceUserInput)
    pub fn builder() -> crate::input::delete_app_instance_user_input::Builder {
        crate::input::delete_app_instance_user_input::Builder::default()
    }
}

/// See [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
pub mod delete_attendee_input {
    /// A builder for [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAttendeeInput {
                meeting_id: self.meeting_id,
                attendee_id: self.attendee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAttendeeInputOperationOutputAlias = crate::operation::DeleteAttendee;
#[doc(hidden)]
pub type DeleteAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAttendee`](crate::operation::DeleteAttendee)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAttendeeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.meeting_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_42, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_43 = &_input.attendee_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    })?;
            let attendee_id = aws_smithy_http::label::fmt_string(input_43, false);
            if attendee_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "attendee_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees/{AttendeeId}",
                MeetingId = meeting_id,
                AttendeeId = attendee_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAttendeeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAttendeeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAttendee",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    pub fn builder() -> crate::input::delete_attendee_input::Builder {
        crate::input::delete_attendee_input::Builder::default()
    }
}

/// See [`DeleteChannelInput`](crate::input::DeleteChannelInput)
pub mod delete_channel_input {
    /// A builder for [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelInput`](crate::input::DeleteChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelInput {
                channel_arn: self.channel_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelInputOperationOutputAlias = crate::operation::DeleteChannel;
#[doc(hidden)]
pub type DeleteChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannel`](crate::operation::DeleteChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.channel_arn;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_44, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_45) = &_input.chime_bearer {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannel",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
}

/// See [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
pub mod delete_channel_ban_input {
    /// A builder for [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelBanInputOperationOutputAlias = crate::operation::DeleteChannelBan;
#[doc(hidden)]
pub type DeleteChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelBan`](crate::operation::DeleteChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.channel_arn;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_47, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_48 = &_input.member_arn;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_48, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_49) = &_input.chime_bearer {
                let formatted_50 = AsRef::<str>::as_ref(inner_49);
                if !formatted_50.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_50;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelBan",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    pub fn builder() -> crate::input::delete_channel_ban_input::Builder {
        crate::input::delete_channel_ban_input::Builder::default()
    }
}

/// See [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
pub mod delete_channel_membership_input {
    /// A builder for [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelMembershipInputOperationOutputAlias =
    crate::operation::DeleteChannelMembership;
#[doc(hidden)]
pub type DeleteChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelMembership`](crate::operation::DeleteChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.channel_arn;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_51, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_52 = &_input.member_arn;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_52, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_53) = &_input.chime_bearer {
                let formatted_54 = AsRef::<str>::as_ref(inner_53);
                if !formatted_54.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_54;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    pub fn builder() -> crate::input::delete_channel_membership_input::Builder {
        crate::input::delete_channel_membership_input::Builder::default()
    }
}

/// See [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
pub mod delete_channel_message_input {
    /// A builder for [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelMessageInputOperationOutputAlias = crate::operation::DeleteChannelMessage;
#[doc(hidden)]
pub type DeleteChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelMessage`](crate::operation::DeleteChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.channel_arn;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_55, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_56 = &_input.message_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_56, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_57) = &_input.chime_bearer {
                let formatted_58 = AsRef::<str>::as_ref(inner_57);
                if !formatted_58.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_58;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelMessage",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    pub fn builder() -> crate::input::delete_channel_message_input::Builder {
        crate::input::delete_channel_message_input::Builder::default()
    }
}

/// See [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
pub mod delete_channel_moderator_input {
    /// A builder for [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelModeratorInputOperationOutputAlias = crate::operation::DeleteChannelModerator;
#[doc(hidden)]
pub type DeleteChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannelModerator`](crate::operation::DeleteChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_59 = &_input.channel_arn;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_59, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_60 = &_input.channel_moderator_arn;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_moderator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_moderator_arn = aws_smithy_http::label::fmt_string(input_60, false);
            if channel_moderator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_moderator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}",
                ChannelArn = channel_arn,
                ChannelModeratorArn = channel_moderator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_61) = &_input.chime_bearer {
                let formatted_62 = AsRef::<str>::as_ref(inner_61);
                if !formatted_62.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_62;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannelModerator",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    pub fn builder() -> crate::input::delete_channel_moderator_input::Builder {
        crate::input::delete_channel_moderator_input::Builder::default()
    }
}

/// See [`DeleteEventsConfigurationInput`](crate::input::DeleteEventsConfigurationInput)
pub mod delete_events_configuration_input {
    /// A builder for [`DeleteEventsConfigurationInput`](crate::input::DeleteEventsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventsConfigurationInput`](crate::input::DeleteEventsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventsConfigurationInput {
                account_id: self.account_id,
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteEventsConfiguration;
#[doc(hidden)]
pub type DeleteEventsConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventsConfiguration`](crate::operation::DeleteEventsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_63 = &_input.account_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_63, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_64 = &_input.bot_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_64, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/bots/{BotId}/events-configuration",
                AccountId = account_id,
                BotId = bot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventsConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventsConfigurationInput`](crate::input::DeleteEventsConfigurationInput)
    pub fn builder() -> crate::input::delete_events_configuration_input::Builder {
        crate::input::delete_events_configuration_input::Builder::default()
    }
}

/// See [`DeleteMediaCapturePipelineInput`](crate::input::DeleteMediaCapturePipelineInput)
pub mod delete_media_capture_pipeline_input {
    /// A builder for [`DeleteMediaCapturePipelineInput`](crate::input::DeleteMediaCapturePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) media_pipeline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn media_pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_pipeline_id = Some(input.into());
            self
        }
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_pipeline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMediaCapturePipelineInput`](crate::input::DeleteMediaCapturePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMediaCapturePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMediaCapturePipelineInput {
                media_pipeline_id: self.media_pipeline_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMediaCapturePipelineInputOperationOutputAlias =
    crate::operation::DeleteMediaCapturePipeline;
#[doc(hidden)]
pub type DeleteMediaCapturePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMediaCapturePipelineInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMediaCapturePipeline`](crate::operation::DeleteMediaCapturePipeline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMediaCapturePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMediaCapturePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.media_pipeline_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "media_pipeline_id",
                        details: "cannot be empty or unset",
                    })?;
            let media_pipeline_id = aws_smithy_http::label::fmt_string(input_65, false);
            if media_pipeline_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "media_pipeline_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/media-capture-pipelines/{MediaPipelineId}",
                MediaPipelineId = media_pipeline_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMediaCapturePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMediaCapturePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMediaCapturePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMediaCapturePipeline",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMediaCapturePipelineInput`](crate::input::DeleteMediaCapturePipelineInput)
    pub fn builder() -> crate::input::delete_media_capture_pipeline_input::Builder {
        crate::input::delete_media_capture_pipeline_input::Builder::default()
    }
}

/// See [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
pub mod delete_meeting_input {
    /// A builder for [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMeetingInput {
                meeting_id: self.meeting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMeetingInputOperationOutputAlias = crate::operation::DeleteMeeting;
#[doc(hidden)]
pub type DeleteMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMeetingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMeeting`](crate::operation::DeleteMeeting)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMeetingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_66 = &_input.meeting_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_66, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/meetings/{MeetingId}", MeetingId = meeting_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMeetingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMeetingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMeeting",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    pub fn builder() -> crate::input::delete_meeting_input::Builder {
        crate::input::delete_meeting_input::Builder::default()
    }
}

/// See [`DeletePhoneNumberInput`](crate::input::DeletePhoneNumberInput)
pub mod delete_phone_number_input {
    /// A builder for [`DeletePhoneNumberInput`](crate::input::DeletePhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePhoneNumberInput`](crate::input::DeletePhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePhoneNumberInput {
                phone_number_id: self.phone_number_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePhoneNumberInputOperationOutputAlias = crate::operation::DeletePhoneNumber;
#[doc(hidden)]
pub type DeletePhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`DeletePhoneNumber`](crate::operation::DeletePhoneNumber)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.phone_number_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "phone_number_id",
                        details: "cannot be empty or unset",
                    })?;
            let phone_number_id = aws_smithy_http::label::fmt_string(input_67, false);
            if phone_number_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "phone_number_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/phone-numbers/{PhoneNumberId}",
                PhoneNumberId = phone_number_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePhoneNumber",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePhoneNumberInput`](crate::input::DeletePhoneNumberInput)
    pub fn builder() -> crate::input::delete_phone_number_input::Builder {
        crate::input::delete_phone_number_input::Builder::default()
    }
}

/// See [`DeleteProxySessionInput`](crate::input::DeleteProxySessionInput)
pub mod delete_proxy_session_input {
    /// A builder for [`DeleteProxySessionInput`](crate::input::DeleteProxySessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) proxy_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_session_id = Some(input.into());
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proxy_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProxySessionInput`](crate::input::DeleteProxySessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProxySessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProxySessionInput {
                voice_connector_id: self.voice_connector_id,
                proxy_session_id: self.proxy_session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProxySessionInputOperationOutputAlias = crate::operation::DeleteProxySession;
#[doc(hidden)]
pub type DeleteProxySessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProxySessionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProxySession`](crate::operation::DeleteProxySession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProxySession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProxySessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_68 = &_input.voice_connector_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_68, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_69 = &_input.proxy_session_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "proxy_session_id",
                        details: "cannot be empty or unset",
                    })?;
            let proxy_session_id = aws_smithy_http::label::fmt_string(input_69, false);
            if proxy_session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "proxy_session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}",
                VoiceConnectorId = voice_connector_id,
                ProxySessionId = proxy_session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProxySessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProxySessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProxySession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProxySession",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProxySessionInput`](crate::input::DeleteProxySessionInput)
    pub fn builder() -> crate::input::delete_proxy_session_input::Builder {
        crate::input::delete_proxy_session_input::Builder::default()
    }
}

/// See [`DeleteRoomInput`](crate::input::DeleteRoomInput)
pub mod delete_room_input {
    /// A builder for [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) room_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The chat room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The chat room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoomInput`](crate::input::DeleteRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoomInput {
                account_id: self.account_id,
                room_id: self.room_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoomInputOperationOutputAlias = crate::operation::DeleteRoom;
#[doc(hidden)]
pub type DeleteRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRoomInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoom`](crate::operation::DeleteRoom)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.account_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_70, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_71 = &_input.room_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "room_id",
                        details: "cannot be empty or unset",
                    })?;
            let room_id = aws_smithy_http::label::fmt_string(input_71, false);
            if room_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "room_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms/{RoomId}",
                AccountId = account_id,
                RoomId = room_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoom",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
}

/// See [`DeleteRoomMembershipInput`](crate::input::DeleteRoomMembershipInput)
pub mod delete_room_membership_input {
    /// A builder for [`DeleteRoomMembershipInput`](crate::input::DeleteRoomMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) room_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoomMembershipInput`](crate::input::DeleteRoomMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoomMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoomMembershipInput {
                account_id: self.account_id,
                room_id: self.room_id,
                member_id: self.member_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoomMembershipInputOperationOutputAlias = crate::operation::DeleteRoomMembership;
#[doc(hidden)]
pub type DeleteRoomMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRoomMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoomMembership`](crate::operation::DeleteRoomMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoomMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRoomMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.account_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_72, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_73 = &_input.room_id;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "room_id",
                        details: "cannot be empty or unset",
                    })?;
            let room_id = aws_smithy_http::label::fmt_string(input_73, false);
            if room_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "room_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_74 = &_input.member_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    })?;
            let member_id = aws_smithy_http::label::fmt_string(input_74, false);
            if member_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms/{RoomId}/memberships/{MemberId}",
                AccountId = account_id,
                RoomId = room_id,
                MemberId = member_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRoomMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRoomMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoomMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoomMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoomMembershipInput`](crate::input::DeleteRoomMembershipInput)
    pub fn builder() -> crate::input::delete_room_membership_input::Builder {
        crate::input::delete_room_membership_input::Builder::default()
    }
}

/// See [`DeleteSipMediaApplicationInput`](crate::input::DeleteSipMediaApplicationInput)
pub mod delete_sip_media_application_input {
    /// A builder for [`DeleteSipMediaApplicationInput`](crate::input::DeleteSipMediaApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSipMediaApplicationInput`](crate::input::DeleteSipMediaApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSipMediaApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSipMediaApplicationInput {
                sip_media_application_id: self.sip_media_application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSipMediaApplicationInputOperationOutputAlias =
    crate::operation::DeleteSipMediaApplication;
#[doc(hidden)]
pub type DeleteSipMediaApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSipMediaApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSipMediaApplication`](crate::operation::DeleteSipMediaApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSipMediaApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSipMediaApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.sip_media_application_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_media_application_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_media_application_id = aws_smithy_http::label::fmt_string(input_75, false);
            if sip_media_application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_media_application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/sip-media-applications/{SipMediaApplicationId}",
                SipMediaApplicationId = sip_media_application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSipMediaApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSipMediaApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSipMediaApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSipMediaApplication",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSipMediaApplicationInput`](crate::input::DeleteSipMediaApplicationInput)
    pub fn builder() -> crate::input::delete_sip_media_application_input::Builder {
        crate::input::delete_sip_media_application_input::Builder::default()
    }
}

/// See [`DeleteSipRuleInput`](crate::input::DeleteSipRuleInput)
pub mod delete_sip_rule_input {
    /// A builder for [`DeleteSipRuleInput`](crate::input::DeleteSipRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_rule_id = Some(input.into());
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sip_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSipRuleInput`](crate::input::DeleteSipRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSipRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSipRuleInput {
                sip_rule_id: self.sip_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSipRuleInputOperationOutputAlias = crate::operation::DeleteSipRule;
#[doc(hidden)]
pub type DeleteSipRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSipRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSipRule`](crate::operation::DeleteSipRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSipRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSipRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.sip_rule_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_rule_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_rule_id = aws_smithy_http::label::fmt_string(input_76, false);
            if sip_rule_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_rule_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/sip-rules/{SipRuleId}", SipRuleId = sip_rule_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSipRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSipRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSipRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSipRule",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSipRuleInput`](crate::input::DeleteSipRuleInput)
    pub fn builder() -> crate::input::delete_sip_rule_input::Builder {
        crate::input::delete_sip_rule_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorInput`](crate::input::DeleteVoiceConnectorInput)
pub mod delete_voice_connector_input {
    /// A builder for [`DeleteVoiceConnectorInput`](crate::input::DeleteVoiceConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorInput`](crate::input::DeleteVoiceConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceConnectorInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorInputOperationOutputAlias = crate::operation::DeleteVoiceConnector;
#[doc(hidden)]
pub type DeleteVoiceConnectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnector`](crate::operation::DeleteVoiceConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.voice_connector_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_77, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnector",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorInput`](crate::input::DeleteVoiceConnectorInput)
    pub fn builder() -> crate::input::delete_voice_connector_input::Builder {
        crate::input::delete_voice_connector_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput)
pub mod delete_voice_connector_emergency_calling_configuration_input {
    /// A builder for [`DeleteVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput {
                    voice_connector_id: self.voice_connector_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorEmergencyCallingConfiguration;
#[doc(hidden)]
pub type DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorEmergencyCallingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorEmergencyCallingConfiguration`](crate::operation::DeleteVoiceConnectorEmergencyCallingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorEmergencyCallingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_78 = &_input.voice_connector_id;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_78, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorEmergencyCallingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorEmergencyCallingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput)
    pub fn builder(
    ) -> crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder {
        crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder::default(
        )
    }
}

/// See [`DeleteVoiceConnectorGroupInput`](crate::input::DeleteVoiceConnectorGroupInput)
pub mod delete_voice_connector_group_input {
    /// A builder for [`DeleteVoiceConnectorGroupInput`](crate::input::DeleteVoiceConnectorGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorGroupInput`](crate::input::DeleteVoiceConnectorGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceConnectorGroupInput {
                voice_connector_group_id: self.voice_connector_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorGroupInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorGroup;
#[doc(hidden)]
pub type DeleteVoiceConnectorGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorGroup`](crate::operation::DeleteVoiceConnectorGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.voice_connector_group_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_group_id = aws_smithy_http::label::fmt_string(input_79, false);
            if voice_connector_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connector-groups/{VoiceConnectorGroupId}",
                VoiceConnectorGroupId = voice_connector_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorGroup",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorGroupInput`](crate::input::DeleteVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::delete_voice_connector_group_input::Builder {
        crate::input::delete_voice_connector_group_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorOriginationInput`](crate::input::DeleteVoiceConnectorOriginationInput)
pub mod delete_voice_connector_origination_input {
    /// A builder for [`DeleteVoiceConnectorOriginationInput`](crate::input::DeleteVoiceConnectorOriginationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorOriginationInput`](crate::input::DeleteVoiceConnectorOriginationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorOriginationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceConnectorOriginationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorOriginationInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorOrigination;
#[doc(hidden)]
pub type DeleteVoiceConnectorOriginationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorOriginationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorOrigination`](crate::operation::DeleteVoiceConnectorOrigination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorOrigination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorOriginationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_80 = &_input.voice_connector_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_80, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/origination",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorOriginationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorOriginationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorOrigination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorOrigination",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorOriginationInput`](crate::input::DeleteVoiceConnectorOriginationInput)
    pub fn builder() -> crate::input::delete_voice_connector_origination_input::Builder {
        crate::input::delete_voice_connector_origination_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorProxyInput`](crate::input::DeleteVoiceConnectorProxyInput)
pub mod delete_voice_connector_proxy_input {
    /// A builder for [`DeleteVoiceConnectorProxyInput`](crate::input::DeleteVoiceConnectorProxyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorProxyInput`](crate::input::DeleteVoiceConnectorProxyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorProxyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceConnectorProxyInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorProxyInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorProxy;
#[doc(hidden)]
pub type DeleteVoiceConnectorProxyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorProxyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorProxy`](crate::operation::DeleteVoiceConnectorProxy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorProxy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorProxyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_81 = &_input.voice_connector_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_81, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorProxyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorProxyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorProxy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorProxy",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorProxyInput`](crate::input::DeleteVoiceConnectorProxyInput)
    pub fn builder() -> crate::input::delete_voice_connector_proxy_input::Builder {
        crate::input::delete_voice_connector_proxy_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorStreamingConfigurationInput`](crate::input::DeleteVoiceConnectorStreamingConfigurationInput)
pub mod delete_voice_connector_streaming_configuration_input {
    /// A builder for [`DeleteVoiceConnectorStreamingConfigurationInput`](crate::input::DeleteVoiceConnectorStreamingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorStreamingConfigurationInput`](crate::input::DeleteVoiceConnectorStreamingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorStreamingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteVoiceConnectorStreamingConfigurationInput {
                    voice_connector_id: self.voice_connector_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorStreamingConfigurationInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorStreamingConfiguration;
#[doc(hidden)]
pub type DeleteVoiceConnectorStreamingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorStreamingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorStreamingConfiguration`](crate::operation::DeleteVoiceConnectorStreamingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorStreamingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorStreamingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.voice_connector_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_82, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/streaming-configuration",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorStreamingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorStreamingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorStreamingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorStreamingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorStreamingConfigurationInput`](crate::input::DeleteVoiceConnectorStreamingConfigurationInput)
    pub fn builder() -> crate::input::delete_voice_connector_streaming_configuration_input::Builder
    {
        crate::input::delete_voice_connector_streaming_configuration_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorTerminationInput`](crate::input::DeleteVoiceConnectorTerminationInput)
pub mod delete_voice_connector_termination_input {
    /// A builder for [`DeleteVoiceConnectorTerminationInput`](crate::input::DeleteVoiceConnectorTerminationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorTerminationInput`](crate::input::DeleteVoiceConnectorTerminationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorTerminationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceConnectorTerminationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorTerminationInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorTermination;
#[doc(hidden)]
pub type DeleteVoiceConnectorTerminationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorTerminationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorTermination`](crate::operation::DeleteVoiceConnectorTermination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorTermination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorTerminationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.voice_connector_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_83, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/termination",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorTerminationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorTerminationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorTermination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorTermination",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorTerminationInput`](crate::input::DeleteVoiceConnectorTerminationInput)
    pub fn builder() -> crate::input::delete_voice_connector_termination_input::Builder {
        crate::input::delete_voice_connector_termination_input::Builder::default()
    }
}

/// See [`DeleteVoiceConnectorTerminationCredentialsInput`](crate::input::DeleteVoiceConnectorTerminationCredentialsInput)
pub mod delete_voice_connector_termination_credentials_input {
    /// A builder for [`DeleteVoiceConnectorTerminationCredentialsInput`](crate::input::DeleteVoiceConnectorTerminationCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) usernames: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Appends an item to `usernames`.
        ///
        /// To override the contents of this collection use [`set_usernames`](Self::set_usernames).
        ///
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn usernames(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.usernames.unwrap_or_default();
            v.push(input.into());
            self.usernames = Some(v);
            self
        }
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn set_usernames(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.usernames = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceConnectorTerminationCredentialsInput`](crate::input::DeleteVoiceConnectorTerminationCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceConnectorTerminationCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteVoiceConnectorTerminationCredentialsInput {
                    voice_connector_id: self.voice_connector_id,
                    usernames: self.usernames,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceConnectorTerminationCredentialsInputOperationOutputAlias =
    crate::operation::DeleteVoiceConnectorTerminationCredentials;
#[doc(hidden)]
pub type DeleteVoiceConnectorTerminationCredentialsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceConnectorTerminationCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceConnectorTerminationCredentials`](crate::operation::DeleteVoiceConnectorTerminationCredentials)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceConnectorTerminationCredentials,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVoiceConnectorTerminationCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_84 = &_input.voice_connector_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_84, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/termination/credentials",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteVoiceConnectorTerminationCredentialsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "delete");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVoiceConnectorTerminationCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVoiceConnectorTerminationCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_voice_connector_termination_credentials(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceConnectorTerminationCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceConnectorTerminationCredentials",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorTerminationCredentialsInput`](crate::input::DeleteVoiceConnectorTerminationCredentialsInput)
    pub fn builder() -> crate::input::delete_voice_connector_termination_credentials_input::Builder
    {
        crate::input::delete_voice_connector_termination_credentials_input::Builder::default()
    }
}

/// See [`DescribeAppInstanceInput`](crate::input::DescribeAppInstanceInput)
pub mod describe_app_instance_input {
    /// A builder for [`DescribeAppInstanceInput`](crate::input::DescribeAppInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceInput`](crate::input::DescribeAppInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppInstanceInput {
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppInstanceInputOperationOutputAlias = crate::operation::DescribeAppInstance;
#[doc(hidden)]
pub type DescribeAppInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAppInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppInstance`](crate::operation::DescribeAppInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.app_instance_arn;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_85, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppInstance",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceInput`](crate::input::DescribeAppInstanceInput)
    pub fn builder() -> crate::input::describe_app_instance_input::Builder {
        crate::input::describe_app_instance_input::Builder::default()
    }
}

/// See [`DescribeAppInstanceAdminInput`](crate::input::DescribeAppInstanceAdminInput)
pub mod describe_app_instance_admin_input {
    /// A builder for [`DescribeAppInstanceAdminInput`](crate::input::DescribeAppInstanceAdminInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_admin_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_admin_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_admin_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceAdminInput`](crate::input::DescribeAppInstanceAdminInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppInstanceAdminInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppInstanceAdminInput {
                app_instance_admin_arn: self.app_instance_admin_arn,
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppInstanceAdminInputOperationOutputAlias =
    crate::operation::DescribeAppInstanceAdmin;
#[doc(hidden)]
pub type DescribeAppInstanceAdminInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAppInstanceAdminInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppInstanceAdmin`](crate::operation::DescribeAppInstanceAdmin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppInstanceAdmin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppInstanceAdminInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.app_instance_arn;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_86, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_87 = &_input.app_instance_admin_arn;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_admin_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_admin_arn = aws_smithy_http::label::fmt_string(input_87, false);
            if app_instance_admin_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_admin_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}",
                AppInstanceArn = app_instance_arn,
                AppInstanceAdminArn = app_instance_admin_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppInstanceAdminInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppInstanceAdminInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppInstanceAdmin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppInstanceAdmin",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceAdminInput`](crate::input::DescribeAppInstanceAdminInput)
    pub fn builder() -> crate::input::describe_app_instance_admin_input::Builder {
        crate::input::describe_app_instance_admin_input::Builder::default()
    }
}

/// See [`DescribeAppInstanceUserInput`](crate::input::DescribeAppInstanceUserInput)
pub mod describe_app_instance_user_input {
    /// A builder for [`DescribeAppInstanceUserInput`](crate::input::DescribeAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInstanceUserInput`](crate::input::DescribeAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppInstanceUserInput {
                app_instance_user_arn: self.app_instance_user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppInstanceUserInputOperationOutputAlias =
    crate::operation::DescribeAppInstanceUser;
#[doc(hidden)]
pub type DescribeAppInstanceUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppInstanceUser`](crate::operation::DescribeAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.app_instance_user_arn;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_user_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_user_arn = aws_smithy_http::label::fmt_string(input_88, false);
            if app_instance_user_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_user_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instance-users/{AppInstanceUserArn}",
                AppInstanceUserArn = app_instance_user_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceUserInput`](crate::input::DescribeAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_app_instance_user_input::Builder {
        crate::input::describe_app_instance_user_input::Builder::default()
    }
}

/// See [`DescribeChannelInput`](crate::input::DescribeChannelInput)
pub mod describe_channel_input {
    /// A builder for [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelInput`](crate::input::DescribeChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelInput {
                channel_arn: self.channel_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelInputOperationOutputAlias = crate::operation::DescribeChannel;
#[doc(hidden)]
pub type DescribeChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannel`](crate::operation::DescribeChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_89 = &_input.channel_arn;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_89, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_90) = &_input.chime_bearer {
                let formatted_91 = AsRef::<str>::as_ref(inner_90);
                if !formatted_91.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_91;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannel",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
}

/// See [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
pub mod describe_channel_ban_input {
    /// A builder for [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelBanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelBanInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelBanInputOperationOutputAlias = crate::operation::DescribeChannelBan;
#[doc(hidden)]
pub type DescribeChannelBanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelBanInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelBan`](crate::operation::DescribeChannelBan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelBan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelBanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_92 = &_input.channel_arn;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_92, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_93 = &_input.member_arn;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_93, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelBanInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_94) = &_input.chime_bearer {
                let formatted_95 = AsRef::<str>::as_ref(inner_94);
                if !formatted_95.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_95;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelBanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelBanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelBan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelBan",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    pub fn builder() -> crate::input::describe_channel_ban_input::Builder {
        crate::input::describe_channel_ban_input::Builder::default()
    }
}

/// See [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
pub mod describe_channel_membership_input {
    /// A builder for [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelMembershipInput {
                channel_arn: self.channel_arn,
                member_arn: self.member_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelMembershipInputOperationOutputAlias =
    crate::operation::DescribeChannelMembership;
#[doc(hidden)]
pub type DescribeChannelMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelMembership`](crate::operation::DescribeChannelMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.channel_arn;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_96, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_97 = &_input.member_arn;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_arn",
                        details: "cannot be empty or unset",
                    })?;
            let member_arn = aws_smithy_http::label::fmt_string(input_97, false);
            if member_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships/{MemberArn}",
                ChannelArn = channel_arn,
                MemberArn = member_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelMembershipInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_98) = &_input.chime_bearer {
                let formatted_99 = AsRef::<str>::as_ref(inner_98);
                if !formatted_99.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_99;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelMembership",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    pub fn builder() -> crate::input::describe_channel_membership_input::Builder {
        crate::input::describe_channel_membership_input::Builder::default()
    }
}

/// See [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
pub mod describe_channel_membership_for_app_instance_user_input {
    /// A builder for [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeChannelMembershipForAppInstanceUserInput {
                    channel_arn: self.channel_arn,
                    app_instance_user_arn: self.app_instance_user_arn,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelMembershipForAppInstanceUserInputOperationOutputAlias =
    crate::operation::DescribeChannelMembershipForAppInstanceUser;
#[doc(hidden)]
pub type DescribeChannelMembershipForAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelMembershipForAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelMembershipForAppInstanceUser`](crate::operation::DescribeChannelMembershipForAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelMembershipForAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_100 = &_input.channel_arn;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_100, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_101) = &_input.chime_bearer {
                let formatted_102 = AsRef::<str>::as_ref(inner_101);
                if !formatted_102.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_102;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-membership");
            if let Some(inner_103) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_103),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelMembershipForAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelMembershipForAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelMembershipForAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    pub fn builder(
    ) -> crate::input::describe_channel_membership_for_app_instance_user_input::Builder {
        crate::input::describe_channel_membership_for_app_instance_user_input::Builder::default()
    }
}

/// See [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
pub mod describe_channel_moderated_by_app_instance_user_input {
    /// A builder for [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeChannelModeratedByAppInstanceUserInput {
                    channel_arn: self.channel_arn,
                    app_instance_user_arn: self.app_instance_user_arn,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelModeratedByAppInstanceUserInputOperationOutputAlias =
    crate::operation::DescribeChannelModeratedByAppInstanceUser;
#[doc(hidden)]
pub type DescribeChannelModeratedByAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelModeratedByAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelModeratedByAppInstanceUser`](crate::operation::DescribeChannelModeratedByAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelModeratedByAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_104 = &_input.channel_arn;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_104, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/channels/{ChannelArn}", ChannelArn = channel_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_105) = &_input.chime_bearer {
                let formatted_106 = AsRef::<str>::as_ref(inner_105);
                if !formatted_106.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_106;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-moderated-channel");
            if let Some(inner_107) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_107),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelModeratedByAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelModeratedByAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelModeratedByAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_channel_moderated_by_app_instance_user_input::Builder
    {
        crate::input::describe_channel_moderated_by_app_instance_user_input::Builder::default()
    }
}

/// See [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
pub mod describe_channel_moderator_input {
    /// A builder for [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_moderator_arn: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_moderator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_moderator_arn = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelModeratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelModeratorInput {
                channel_arn: self.channel_arn,
                channel_moderator_arn: self.channel_moderator_arn,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelModeratorInputOperationOutputAlias =
    crate::operation::DescribeChannelModerator;
#[doc(hidden)]
pub type DescribeChannelModeratorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelModeratorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannelModerator`](crate::operation::DescribeChannelModerator)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannelModerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelModeratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_108 = &_input.channel_arn;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_108, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_109 = &_input.channel_moderator_arn;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_moderator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_moderator_arn = aws_smithy_http::label::fmt_string(input_109, false);
            if channel_moderator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_moderator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}",
                ChannelArn = channel_arn,
                ChannelModeratorArn = channel_moderator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeChannelModeratorInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_110) = &_input.chime_bearer {
                let formatted_111 = AsRef::<str>::as_ref(inner_110);
                if !formatted_111.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_111;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelModeratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelModeratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannelModerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannelModerator",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    pub fn builder() -> crate::input::describe_channel_moderator_input::Builder {
        crate::input::describe_channel_moderator_input::Builder::default()
    }
}

/// See [`DisassociatePhoneNumberFromUserInput`](crate::input::DisassociatePhoneNumberFromUserInput)
pub mod disassociate_phone_number_from_user_input {
    /// A builder for [`DisassociatePhoneNumberFromUserInput`](crate::input::DisassociatePhoneNumberFromUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePhoneNumberFromUserInput`](crate::input::DisassociatePhoneNumberFromUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePhoneNumberFromUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociatePhoneNumberFromUserInput {
                account_id: self.account_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociatePhoneNumberFromUserInputOperationOutputAlias =
    crate::operation::DisassociatePhoneNumberFromUser;
#[doc(hidden)]
pub type DisassociatePhoneNumberFromUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePhoneNumberFromUserInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePhoneNumberFromUser`](crate::operation::DisassociatePhoneNumberFromUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePhoneNumberFromUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociatePhoneNumberFromUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_112 = &_input.account_id;
            let input_112 =
                input_112
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_112, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_113 = &_input.user_id;
            let input_113 =
                input_113
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_113, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users/{UserId}",
                AccountId = account_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociatePhoneNumberFromUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "disassociate-phone-number");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociatePhoneNumberFromUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociatePhoneNumberFromUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePhoneNumberFromUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePhoneNumberFromUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumberFromUserInput`](crate::input::DisassociatePhoneNumberFromUserInput)
    pub fn builder() -> crate::input::disassociate_phone_number_from_user_input::Builder {
        crate::input::disassociate_phone_number_from_user_input::Builder::default()
    }
}

/// See [`DisassociatePhoneNumbersFromVoiceConnectorInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput)
pub mod disassociate_phone_numbers_from_voice_connector_input {
    /// A builder for [`DisassociatePhoneNumbersFromVoiceConnectorInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Appends an item to `e164_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.e164_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.e164_phone_numbers = Some(v);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.e164_phone_numbers = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePhoneNumbersFromVoiceConnectorInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput {
                    voice_connector_id: self.voice_connector_id,
                    e164_phone_numbers: self.e164_phone_numbers,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociatePhoneNumbersFromVoiceConnectorInputOperationOutputAlias =
    crate::operation::DisassociatePhoneNumbersFromVoiceConnector;
#[doc(hidden)]
pub type DisassociatePhoneNumbersFromVoiceConnectorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePhoneNumbersFromVoiceConnectorInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePhoneNumbersFromVoiceConnector`](crate::operation::DisassociatePhoneNumbersFromVoiceConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePhoneNumbersFromVoiceConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_114 = &_input.voice_connector_id;
            let input_114 =
                input_114
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_114, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "disassociate-phone-numbers");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_phone_numbers_from_voice_connector(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePhoneNumbersFromVoiceConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePhoneNumbersFromVoiceConnector",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumbersFromVoiceConnectorInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput)
    pub fn builder() -> crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder
    {
        crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder::default()
    }
}

/// See [`DisassociatePhoneNumbersFromVoiceConnectorGroupInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput)
pub mod disassociate_phone_numbers_from_voice_connector_group_input {
    /// A builder for [`DisassociatePhoneNumbersFromVoiceConnectorGroupInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_group_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_id = input;
            self
        }
        /// Appends an item to `e164_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.e164_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.e164_phone_numbers = Some(v);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.e164_phone_numbers = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePhoneNumbersFromVoiceConnectorGroupInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
                    voice_connector_group_id: self.voice_connector_group_id,
                    e164_phone_numbers: self.e164_phone_numbers,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationOutputAlias =
    crate::operation::DisassociatePhoneNumbersFromVoiceConnectorGroup;
#[doc(hidden)]
pub type DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePhoneNumbersFromVoiceConnectorGroup`](crate::operation::DisassociatePhoneNumbersFromVoiceConnectorGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePhoneNumbersFromVoiceConnectorGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_115 = &_input.voice_connector_group_id;
            let input_115 =
                input_115
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_group_id = aws_smithy_http::label::fmt_string(input_115, false);
            if voice_connector_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connector-groups/{VoiceConnectorGroupId}",
                VoiceConnectorGroupId = voice_connector_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "disassociate-phone-numbers");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_phone_numbers_from_voice_connector_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePhoneNumbersFromVoiceConnectorGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePhoneNumbersFromVoiceConnectorGroup",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumbersFromVoiceConnectorGroupInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput)
    pub fn builder(
    ) -> crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder {
        crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder::default(
        )
    }
}

/// See [`DisassociateSigninDelegateGroupsFromAccountInput`](crate::input::DisassociateSigninDelegateGroupsFromAccountInput)
pub mod disassociate_signin_delegate_groups_from_account_input {
    /// A builder for [`DisassociateSigninDelegateGroupsFromAccountInput`](crate::input::DisassociateSigninDelegateGroupsFromAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `group_names`.
        ///
        /// To override the contents of this collection use [`set_group_names`](Self::set_group_names).
        ///
        /// <p>The sign-in delegate group names.</p>
        pub fn group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.group_names.unwrap_or_default();
            v.push(input.into());
            self.group_names = Some(v);
            self
        }
        /// <p>The sign-in delegate group names.</p>
        pub fn set_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.group_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSigninDelegateGroupsFromAccountInput`](crate::input::DisassociateSigninDelegateGroupsFromAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateSigninDelegateGroupsFromAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateSigninDelegateGroupsFromAccountInput {
                    account_id: self.account_id,
                    group_names: self.group_names,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateSigninDelegateGroupsFromAccountInputOperationOutputAlias =
    crate::operation::DisassociateSigninDelegateGroupsFromAccount;
#[doc(hidden)]
pub type DisassociateSigninDelegateGroupsFromAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateSigninDelegateGroupsFromAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateSigninDelegateGroupsFromAccount`](crate::operation::DisassociateSigninDelegateGroupsFromAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateSigninDelegateGroupsFromAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateSigninDelegateGroupsFromAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_116 = &_input.account_id;
            let input_116 =
                input_116
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_116, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateSigninDelegateGroupsFromAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "disassociate-signin-delegate-groups");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateSigninDelegateGroupsFromAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateSigninDelegateGroupsFromAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_signin_delegate_groups_from_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateSigninDelegateGroupsFromAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateSigninDelegateGroupsFromAccount",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateSigninDelegateGroupsFromAccountInput`](crate::input::DisassociateSigninDelegateGroupsFromAccountInput)
    pub fn builder() -> crate::input::disassociate_signin_delegate_groups_from_account_input::Builder
    {
        crate::input::disassociate_signin_delegate_groups_from_account_input::Builder::default()
    }
}

/// See [`GetAccountInput`](crate::input::GetAccountInput)
pub mod get_account_input {
    /// A builder for [`GetAccountInput`](crate::input::GetAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountInput`](crate::input::GetAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccountInputOperationOutputAlias = crate::operation::GetAccount;
#[doc(hidden)]
pub type GetAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetAccount`](crate::operation::GetAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_117 = &_input.account_id;
            let input_117 =
                input_117
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_117, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccount",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
}

/// See [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
pub mod get_account_settings_input {
    /// A builder for [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSettingsInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccountSettingsInputOperationOutputAlias = crate::operation::GetAccountSettings;
#[doc(hidden)]
pub type GetAccountSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSettings`](crate::operation::GetAccountSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_118 = &_input.account_id;
            let input_118 =
                input_118
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_118, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/settings",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
}

/// See [`GetAppInstanceRetentionSettingsInput`](crate::input::GetAppInstanceRetentionSettingsInput)
pub mod get_app_instance_retention_settings_input {
    /// A builder for [`GetAppInstanceRetentionSettingsInput`](crate::input::GetAppInstanceRetentionSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInstanceRetentionSettingsInput`](crate::input::GetAppInstanceRetentionSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppInstanceRetentionSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppInstanceRetentionSettingsInput {
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppInstanceRetentionSettingsInputOperationOutputAlias =
    crate::operation::GetAppInstanceRetentionSettings;
#[doc(hidden)]
pub type GetAppInstanceRetentionSettingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAppInstanceRetentionSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetAppInstanceRetentionSettings`](crate::operation::GetAppInstanceRetentionSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppInstanceRetentionSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppInstanceRetentionSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_119 = &_input.app_instance_arn;
            let input_119 =
                input_119
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_119, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/retention-settings",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppInstanceRetentionSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppInstanceRetentionSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppInstanceRetentionSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppInstanceRetentionSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppInstanceRetentionSettingsInput`](crate::input::GetAppInstanceRetentionSettingsInput)
    pub fn builder() -> crate::input::get_app_instance_retention_settings_input::Builder {
        crate::input::get_app_instance_retention_settings_input::Builder::default()
    }
}

/// See [`GetAppInstanceStreamingConfigurationsInput`](crate::input::GetAppInstanceStreamingConfigurationsInput)
pub mod get_app_instance_streaming_configurations_input {
    /// A builder for [`GetAppInstanceStreamingConfigurationsInput`](crate::input::GetAppInstanceStreamingConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInstanceStreamingConfigurationsInput`](crate::input::GetAppInstanceStreamingConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppInstanceStreamingConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppInstanceStreamingConfigurationsInput {
                app_instance_arn: self.app_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppInstanceStreamingConfigurationsInputOperationOutputAlias =
    crate::operation::GetAppInstanceStreamingConfigurations;
#[doc(hidden)]
pub type GetAppInstanceStreamingConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAppInstanceStreamingConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`GetAppInstanceStreamingConfigurations`](crate::operation::GetAppInstanceStreamingConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppInstanceStreamingConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppInstanceStreamingConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_120 = &_input.app_instance_arn;
            let input_120 =
                input_120
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_120, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/streaming-configurations",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppInstanceStreamingConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppInstanceStreamingConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppInstanceStreamingConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppInstanceStreamingConfigurations",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppInstanceStreamingConfigurationsInput`](crate::input::GetAppInstanceStreamingConfigurationsInput)
    pub fn builder() -> crate::input::get_app_instance_streaming_configurations_input::Builder {
        crate::input::get_app_instance_streaming_configurations_input::Builder::default()
    }
}

/// See [`GetAttendeeInput`](crate::input::GetAttendeeInput)
pub mod get_attendee_input {
    /// A builder for [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAttendeeInput`](crate::input::GetAttendeeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAttendeeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAttendeeInput {
                meeting_id: self.meeting_id,
                attendee_id: self.attendee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAttendeeInputOperationOutputAlias = crate::operation::GetAttendee;
#[doc(hidden)]
pub type GetAttendeeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAttendeeInput {
    /// Consumes the builder and constructs an Operation<[`GetAttendee`](crate::operation::GetAttendee)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAttendee,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAttendeeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_121 = &_input.meeting_id;
            let input_121 =
                input_121
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_121, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_122 = &_input.attendee_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    })?;
            let attendee_id = aws_smithy_http::label::fmt_string(input_122, false);
            if attendee_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "attendee_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees/{AttendeeId}",
                MeetingId = meeting_id,
                AttendeeId = attendee_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAttendeeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAttendeeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAttendee::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAttendee",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    pub fn builder() -> crate::input::get_attendee_input::Builder {
        crate::input::get_attendee_input::Builder::default()
    }
}

/// See [`GetBotInput`](crate::input::GetBotInput)
pub mod get_bot_input {
    /// A builder for [`GetBotInput`](crate::input::GetBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotInput`](crate::input::GetBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBotInput {
                account_id: self.account_id,
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotInputOperationOutputAlias = crate::operation::GetBot;
#[doc(hidden)]
pub type GetBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBotInput {
    /// Consumes the builder and constructs an Operation<[`GetBot`](crate::operation::GetBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_123 = &_input.account_id;
            let input_123 =
                input_123
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_123, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_124 = &_input.bot_id;
            let input_124 =
                input_124
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_124, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/bots/{BotId}",
                AccountId = account_id,
                BotId = bot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetBot", "chime"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotInput`](crate::input::GetBotInput)
    pub fn builder() -> crate::input::get_bot_input::Builder {
        crate::input::get_bot_input::Builder::default()
    }
}

/// See [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
pub mod get_channel_message_input {
    /// A builder for [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChannelMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChannelMessageInput {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChannelMessageInputOperationOutputAlias = crate::operation::GetChannelMessage;
#[doc(hidden)]
pub type GetChannelMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetChannelMessageInput {
    /// Consumes the builder and constructs an Operation<[`GetChannelMessage`](crate::operation::GetChannelMessage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChannelMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChannelMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_125 = &_input.channel_arn;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_125, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_126 = &_input.message_id;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_126, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages/{MessageId}",
                ChannelArn = channel_arn,
                MessageId = message_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetChannelMessageInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_127) = &_input.chime_bearer {
                let formatted_128 = AsRef::<str>::as_ref(inner_127);
                if !formatted_128.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_128;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChannelMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChannelMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChannelMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChannelMessage",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    pub fn builder() -> crate::input::get_channel_message_input::Builder {
        crate::input::get_channel_message_input::Builder::default()
    }
}

/// See [`GetEventsConfigurationInput`](crate::input::GetEventsConfigurationInput)
pub mod get_events_configuration_input {
    /// A builder for [`GetEventsConfigurationInput`](crate::input::GetEventsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventsConfigurationInput`](crate::input::GetEventsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventsConfigurationInput {
                account_id: self.account_id,
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventsConfigurationInputOperationOutputAlias = crate::operation::GetEventsConfiguration;
#[doc(hidden)]
pub type GetEventsConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetEventsConfiguration`](crate::operation::GetEventsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_129 = &_input.account_id;
            let input_129 =
                input_129
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_129, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_130 = &_input.bot_id;
            let input_130 =
                input_130
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_130, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/bots/{BotId}/events-configuration",
                AccountId = account_id,
                BotId = bot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventsConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventsConfigurationInput`](crate::input::GetEventsConfigurationInput)
    pub fn builder() -> crate::input::get_events_configuration_input::Builder {
        crate::input::get_events_configuration_input::Builder::default()
    }
}

/// See [`GetGlobalSettingsInput`](crate::input::GetGlobalSettingsInput)
pub mod get_global_settings_input {
    /// A builder for [`GetGlobalSettingsInput`](crate::input::GetGlobalSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetGlobalSettingsInput`](crate::input::GetGlobalSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGlobalSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGlobalSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetGlobalSettingsInputOperationOutputAlias = crate::operation::GetGlobalSettings;
#[doc(hidden)]
pub type GetGlobalSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGlobalSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetGlobalSettings`](crate::operation::GetGlobalSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGlobalSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGlobalSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGlobalSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGlobalSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGlobalSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGlobalSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGlobalSettingsInput`](crate::input::GetGlobalSettingsInput)
    pub fn builder() -> crate::input::get_global_settings_input::Builder {
        crate::input::get_global_settings_input::Builder::default()
    }
}

/// See [`GetMediaCapturePipelineInput`](crate::input::GetMediaCapturePipelineInput)
pub mod get_media_capture_pipeline_input {
    /// A builder for [`GetMediaCapturePipelineInput`](crate::input::GetMediaCapturePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) media_pipeline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn media_pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_pipeline_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_pipeline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMediaCapturePipelineInput`](crate::input::GetMediaCapturePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMediaCapturePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMediaCapturePipelineInput {
                media_pipeline_id: self.media_pipeline_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMediaCapturePipelineInputOperationOutputAlias =
    crate::operation::GetMediaCapturePipeline;
#[doc(hidden)]
pub type GetMediaCapturePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMediaCapturePipelineInput {
    /// Consumes the builder and constructs an Operation<[`GetMediaCapturePipeline`](crate::operation::GetMediaCapturePipeline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMediaCapturePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMediaCapturePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_131 = &_input.media_pipeline_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "media_pipeline_id",
                        details: "cannot be empty or unset",
                    })?;
            let media_pipeline_id = aws_smithy_http::label::fmt_string(input_131, false);
            if media_pipeline_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "media_pipeline_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/media-capture-pipelines/{MediaPipelineId}",
                MediaPipelineId = media_pipeline_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMediaCapturePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMediaCapturePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMediaCapturePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMediaCapturePipeline",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMediaCapturePipelineInput`](crate::input::GetMediaCapturePipelineInput)
    pub fn builder() -> crate::input::get_media_capture_pipeline_input::Builder {
        crate::input::get_media_capture_pipeline_input::Builder::default()
    }
}

/// See [`GetMeetingInput`](crate::input::GetMeetingInput)
pub mod get_meeting_input {
    /// A builder for [`GetMeetingInput`](crate::input::GetMeetingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMeetingInput`](crate::input::GetMeetingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMeetingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMeetingInput {
                meeting_id: self.meeting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMeetingInputOperationOutputAlias = crate::operation::GetMeeting;
#[doc(hidden)]
pub type GetMeetingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMeetingInput {
    /// Consumes the builder and constructs an Operation<[`GetMeeting`](crate::operation::GetMeeting)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMeeting,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMeetingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_132 = &_input.meeting_id;
            let input_132 =
                input_132
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_132, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/meetings/{MeetingId}", MeetingId = meeting_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMeetingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMeetingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMeeting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMeeting",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMeetingInput`](crate::input::GetMeetingInput)
    pub fn builder() -> crate::input::get_meeting_input::Builder {
        crate::input::get_meeting_input::Builder::default()
    }
}

/// See [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
pub mod get_messaging_session_endpoint_input {
    /// A builder for [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMessagingSessionEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMessagingSessionEndpointInput {})
        }
    }
}
#[doc(hidden)]
pub type GetMessagingSessionEndpointInputOperationOutputAlias =
    crate::operation::GetMessagingSessionEndpoint;
#[doc(hidden)]
pub type GetMessagingSessionEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMessagingSessionEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetMessagingSessionEndpoint`](crate::operation::GetMessagingSessionEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMessagingSessionEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMessagingSessionEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/endpoints/messaging-session").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMessagingSessionEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMessagingSessionEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMessagingSessionEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMessagingSessionEndpoint",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    pub fn builder() -> crate::input::get_messaging_session_endpoint_input::Builder {
        crate::input::get_messaging_session_endpoint_input::Builder::default()
    }
}

/// See [`GetPhoneNumberInput`](crate::input::GetPhoneNumberInput)
pub mod get_phone_number_input {
    /// A builder for [`GetPhoneNumberInput`](crate::input::GetPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPhoneNumberInput`](crate::input::GetPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPhoneNumberInput {
                phone_number_id: self.phone_number_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPhoneNumberInputOperationOutputAlias = crate::operation::GetPhoneNumber;
#[doc(hidden)]
pub type GetPhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`GetPhoneNumber`](crate::operation::GetPhoneNumber)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.phone_number_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "phone_number_id",
                        details: "cannot be empty or unset",
                    })?;
            let phone_number_id = aws_smithy_http::label::fmt_string(input_133, false);
            if phone_number_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "phone_number_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/phone-numbers/{PhoneNumberId}",
                PhoneNumberId = phone_number_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPhoneNumber",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberInput`](crate::input::GetPhoneNumberInput)
    pub fn builder() -> crate::input::get_phone_number_input::Builder {
        crate::input::get_phone_number_input::Builder::default()
    }
}

/// See [`GetPhoneNumberOrderInput`](crate::input::GetPhoneNumberOrderInput)
pub mod get_phone_number_order_input {
    /// A builder for [`GetPhoneNumberOrderInput`](crate::input::GetPhoneNumberOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_order_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the phone number order.</p>
        pub fn phone_number_order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_order_id = Some(input.into());
            self
        }
        /// <p>The ID for the phone number order.</p>
        pub fn set_phone_number_order_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_order_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPhoneNumberOrderInput`](crate::input::GetPhoneNumberOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPhoneNumberOrderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPhoneNumberOrderInput {
                phone_number_order_id: self.phone_number_order_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPhoneNumberOrderInputOperationOutputAlias = crate::operation::GetPhoneNumberOrder;
#[doc(hidden)]
pub type GetPhoneNumberOrderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPhoneNumberOrderInput {
    /// Consumes the builder and constructs an Operation<[`GetPhoneNumberOrder`](crate::operation::GetPhoneNumberOrder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPhoneNumberOrder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPhoneNumberOrderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_134 = &_input.phone_number_order_id;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "phone_number_order_id",
                        details: "cannot be empty or unset",
                    })?;
            let phone_number_order_id = aws_smithy_http::label::fmt_string(input_134, false);
            if phone_number_order_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "phone_number_order_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/phone-number-orders/{PhoneNumberOrderId}",
                PhoneNumberOrderId = phone_number_order_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPhoneNumberOrderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPhoneNumberOrderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPhoneNumberOrder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPhoneNumberOrder",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberOrderInput`](crate::input::GetPhoneNumberOrderInput)
    pub fn builder() -> crate::input::get_phone_number_order_input::Builder {
        crate::input::get_phone_number_order_input::Builder::default()
    }
}

/// See [`GetPhoneNumberSettingsInput`](crate::input::GetPhoneNumberSettingsInput)
pub mod get_phone_number_settings_input {
    /// A builder for [`GetPhoneNumberSettingsInput`](crate::input::GetPhoneNumberSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetPhoneNumberSettingsInput`](crate::input::GetPhoneNumberSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPhoneNumberSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPhoneNumberSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetPhoneNumberSettingsInputOperationOutputAlias = crate::operation::GetPhoneNumberSettings;
#[doc(hidden)]
pub type GetPhoneNumberSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPhoneNumberSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetPhoneNumberSettings`](crate::operation::GetPhoneNumberSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPhoneNumberSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPhoneNumberSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/settings/phone-number").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPhoneNumberSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPhoneNumberSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPhoneNumberSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPhoneNumberSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberSettingsInput`](crate::input::GetPhoneNumberSettingsInput)
    pub fn builder() -> crate::input::get_phone_number_settings_input::Builder {
        crate::input::get_phone_number_settings_input::Builder::default()
    }
}

/// See [`GetProxySessionInput`](crate::input::GetProxySessionInput)
pub mod get_proxy_session_input {
    /// A builder for [`GetProxySessionInput`](crate::input::GetProxySessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) proxy_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_session_id = Some(input.into());
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proxy_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProxySessionInput`](crate::input::GetProxySessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProxySessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProxySessionInput {
                voice_connector_id: self.voice_connector_id,
                proxy_session_id: self.proxy_session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProxySessionInputOperationOutputAlias = crate::operation::GetProxySession;
#[doc(hidden)]
pub type GetProxySessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetProxySessionInput {
    /// Consumes the builder and constructs an Operation<[`GetProxySession`](crate::operation::GetProxySession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProxySession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetProxySessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_135 = &_input.voice_connector_id;
            let input_135 =
                input_135
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_135, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_136 = &_input.proxy_session_id;
            let input_136 =
                input_136
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "proxy_session_id",
                        details: "cannot be empty or unset",
                    })?;
            let proxy_session_id = aws_smithy_http::label::fmt_string(input_136, false);
            if proxy_session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "proxy_session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}",
                VoiceConnectorId = voice_connector_id,
                ProxySessionId = proxy_session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetProxySessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetProxySessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProxySession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProxySession",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetProxySessionInput`](crate::input::GetProxySessionInput)
    pub fn builder() -> crate::input::get_proxy_session_input::Builder {
        crate::input::get_proxy_session_input::Builder::default()
    }
}

/// See [`GetRetentionSettingsInput`](crate::input::GetRetentionSettingsInput)
pub mod get_retention_settings_input {
    /// A builder for [`GetRetentionSettingsInput`](crate::input::GetRetentionSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRetentionSettingsInput`](crate::input::GetRetentionSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRetentionSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRetentionSettingsInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRetentionSettingsInputOperationOutputAlias = crate::operation::GetRetentionSettings;
#[doc(hidden)]
pub type GetRetentionSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRetentionSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetRetentionSettings`](crate::operation::GetRetentionSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRetentionSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRetentionSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_137 = &_input.account_id;
            let input_137 =
                input_137
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_137, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/retention-settings",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRetentionSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRetentionSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRetentionSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRetentionSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRetentionSettingsInput`](crate::input::GetRetentionSettingsInput)
    pub fn builder() -> crate::input::get_retention_settings_input::Builder {
        crate::input::get_retention_settings_input::Builder::default()
    }
}

/// See [`GetRoomInput`](crate::input::GetRoomInput)
pub mod get_room_input {
    /// A builder for [`GetRoomInput`](crate::input::GetRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) room_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoomInput`](crate::input::GetRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRoomInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRoomInput {
                account_id: self.account_id,
                room_id: self.room_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoomInputOperationOutputAlias = crate::operation::GetRoom;
#[doc(hidden)]
pub type GetRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRoomInput {
    /// Consumes the builder and constructs an Operation<[`GetRoom`](crate::operation::GetRoom)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_138 = &_input.account_id;
            let input_138 =
                input_138
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_138, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_139 = &_input.room_id;
            let input_139 =
                input_139
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "room_id",
                        details: "cannot be empty or unset",
                    })?;
            let room_id = aws_smithy_http::label::fmt_string(input_139, false);
            if room_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "room_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/rooms/{RoomId}",
                AccountId = account_id,
                RoomId = room_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoom::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoom", "chime",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
}

/// See [`GetSipMediaApplicationInput`](crate::input::GetSipMediaApplicationInput)
pub mod get_sip_media_application_input {
    /// A builder for [`GetSipMediaApplicationInput`](crate::input::GetSipMediaApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSipMediaApplicationInput`](crate::input::GetSipMediaApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSipMediaApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSipMediaApplicationInput {
                sip_media_application_id: self.sip_media_application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSipMediaApplicationInputOperationOutputAlias = crate::operation::GetSipMediaApplication;
#[doc(hidden)]
pub type GetSipMediaApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSipMediaApplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetSipMediaApplication`](crate::operation::GetSipMediaApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSipMediaApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSipMediaApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_140 = &_input.sip_media_application_id;
            let input_140 =
                input_140
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_media_application_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_media_application_id = aws_smithy_http::label::fmt_string(input_140, false);
            if sip_media_application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_media_application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/sip-media-applications/{SipMediaApplicationId}",
                SipMediaApplicationId = sip_media_application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSipMediaApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSipMediaApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSipMediaApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSipMediaApplication",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSipMediaApplicationInput`](crate::input::GetSipMediaApplicationInput)
    pub fn builder() -> crate::input::get_sip_media_application_input::Builder {
        crate::input::get_sip_media_application_input::Builder::default()
    }
}

/// See [`GetSipMediaApplicationLoggingConfigurationInput`](crate::input::GetSipMediaApplicationLoggingConfigurationInput)
pub mod get_sip_media_application_logging_configuration_input {
    /// A builder for [`GetSipMediaApplicationLoggingConfigurationInput`](crate::input::GetSipMediaApplicationLoggingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSipMediaApplicationLoggingConfigurationInput`](crate::input::GetSipMediaApplicationLoggingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSipMediaApplicationLoggingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetSipMediaApplicationLoggingConfigurationInput {
                    sip_media_application_id: self.sip_media_application_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetSipMediaApplicationLoggingConfigurationInputOperationOutputAlias =
    crate::operation::GetSipMediaApplicationLoggingConfiguration;
#[doc(hidden)]
pub type GetSipMediaApplicationLoggingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetSipMediaApplicationLoggingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetSipMediaApplicationLoggingConfiguration`](crate::operation::GetSipMediaApplicationLoggingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSipMediaApplicationLoggingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSipMediaApplicationLoggingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_141 = &_input.sip_media_application_id;
            let input_141 =
                input_141
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_media_application_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_media_application_id = aws_smithy_http::label::fmt_string(input_141, false);
            if sip_media_application_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_media_application_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/sip-media-applications/{SipMediaApplicationId}/logging-configuration",
                SipMediaApplicationId = sip_media_application_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSipMediaApplicationLoggingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSipMediaApplicationLoggingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSipMediaApplicationLoggingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSipMediaApplicationLoggingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSipMediaApplicationLoggingConfigurationInput`](crate::input::GetSipMediaApplicationLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_sip_media_application_logging_configuration_input::Builder
    {
        crate::input::get_sip_media_application_logging_configuration_input::Builder::default()
    }
}

/// See [`GetSipRuleInput`](crate::input::GetSipRuleInput)
pub mod get_sip_rule_input {
    /// A builder for [`GetSipRuleInput`](crate::input::GetSipRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_rule_id = Some(input.into());
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sip_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSipRuleInput`](crate::input::GetSipRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSipRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSipRuleInput {
                sip_rule_id: self.sip_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSipRuleInputOperationOutputAlias = crate::operation::GetSipRule;
#[doc(hidden)]
pub type GetSipRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSipRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetSipRule`](crate::operation::GetSipRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSipRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSipRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_142 = &_input.sip_rule_id;
            let input_142 =
                input_142
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sip_rule_id",
                        details: "cannot be empty or unset",
                    })?;
            let sip_rule_id = aws_smithy_http::label::fmt_string(input_142, false);
            if sip_rule_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sip_rule_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/sip-rules/{SipRuleId}", SipRuleId = sip_rule_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSipRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSipRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSipRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSipRule",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSipRuleInput`](crate::input::GetSipRuleInput)
    pub fn builder() -> crate::input::get_sip_rule_input::Builder {
        crate::input::get_sip_rule_input::Builder::default()
    }
}

/// See [`GetUserInput`](crate::input::GetUserInput)
pub mod get_user_input {
    /// A builder for [`GetUserInput`](crate::input::GetUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserInput`](crate::input::GetUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUserInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUserInput {
                account_id: self.account_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserInputOperationOutputAlias = crate::operation::GetUser;
#[doc(hidden)]
pub type GetUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserInput {
    /// Consumes the builder and constructs an Operation<[`GetUser`](crate::operation::GetUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_143 = &_input.account_id;
            let input_143 =
                input_143
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_143, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_144 = &_input.user_id;
            let input_144 =
                input_144
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_144, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users/{UserId}",
                AccountId = account_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUser::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetUser", "chime",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
}

/// See [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
pub mod get_user_settings_input {
    /// A builder for [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserSettingsInput {
                account_id: self.account_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserSettingsInputOperationOutputAlias = crate::operation::GetUserSettings;
#[doc(hidden)]
pub type GetUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetUserSettings`](crate::operation::GetUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_145 = &_input.account_id;
            let input_145 =
                input_145
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_145, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_146 = &_input.user_id;
            let input_146 =
                input_146
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_146, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users/{UserId}/settings",
                AccountId = account_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserSettings",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    pub fn builder() -> crate::input::get_user_settings_input::Builder {
        crate::input::get_user_settings_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorInput`](crate::input::GetVoiceConnectorInput)
pub mod get_voice_connector_input {
    /// A builder for [`GetVoiceConnectorInput`](crate::input::GetVoiceConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorInput`](crate::input::GetVoiceConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorInputOperationOutputAlias = crate::operation::GetVoiceConnector;
#[doc(hidden)]
pub type GetVoiceConnectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnector`](crate::operation::GetVoiceConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_147 = &_input.voice_connector_id;
            let input_147 =
                input_147
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_147, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnector",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorInput`](crate::input::GetVoiceConnectorInput)
    pub fn builder() -> crate::input::get_voice_connector_input::Builder {
        crate::input::get_voice_connector_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput)
pub mod get_voice_connector_emergency_calling_configuration_input {
    /// A builder for [`GetVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput {
                    voice_connector_id: self.voice_connector_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorEmergencyCallingConfiguration;
#[doc(hidden)]
pub type GetVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorEmergencyCallingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorEmergencyCallingConfiguration`](crate::operation::GetVoiceConnectorEmergencyCallingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorEmergencyCallingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_148 = &_input.voice_connector_id;
            let input_148 =
                input_148
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_148, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorEmergencyCallingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorEmergencyCallingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput)
    pub fn builder(
    ) -> crate::input::get_voice_connector_emergency_calling_configuration_input::Builder {
        crate::input::get_voice_connector_emergency_calling_configuration_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorGroupInput`](crate::input::GetVoiceConnectorGroupInput)
pub mod get_voice_connector_group_input {
    /// A builder for [`GetVoiceConnectorGroupInput`](crate::input::GetVoiceConnectorGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorGroupInput`](crate::input::GetVoiceConnectorGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorGroupInput {
                voice_connector_group_id: self.voice_connector_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorGroupInputOperationOutputAlias = crate::operation::GetVoiceConnectorGroup;
#[doc(hidden)]
pub type GetVoiceConnectorGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorGroup`](crate::operation::GetVoiceConnectorGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_149 = &_input.voice_connector_group_id;
            let input_149 =
                input_149
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_group_id = aws_smithy_http::label::fmt_string(input_149, false);
            if voice_connector_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connector-groups/{VoiceConnectorGroupId}",
                VoiceConnectorGroupId = voice_connector_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorGroup",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorGroupInput`](crate::input::GetVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::get_voice_connector_group_input::Builder {
        crate::input::get_voice_connector_group_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorLoggingConfigurationInput`](crate::input::GetVoiceConnectorLoggingConfigurationInput)
pub mod get_voice_connector_logging_configuration_input {
    /// A builder for [`GetVoiceConnectorLoggingConfigurationInput`](crate::input::GetVoiceConnectorLoggingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorLoggingConfigurationInput`](crate::input::GetVoiceConnectorLoggingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorLoggingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorLoggingConfigurationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorLoggingConfigurationInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorLoggingConfiguration;
#[doc(hidden)]
pub type GetVoiceConnectorLoggingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorLoggingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorLoggingConfiguration`](crate::operation::GetVoiceConnectorLoggingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorLoggingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorLoggingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_150 = &_input.voice_connector_id;
            let input_150 =
                input_150
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_150, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/logging-configuration",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorLoggingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorLoggingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorLoggingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorLoggingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorLoggingConfigurationInput`](crate::input::GetVoiceConnectorLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_voice_connector_logging_configuration_input::Builder {
        crate::input::get_voice_connector_logging_configuration_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorOriginationInput`](crate::input::GetVoiceConnectorOriginationInput)
pub mod get_voice_connector_origination_input {
    /// A builder for [`GetVoiceConnectorOriginationInput`](crate::input::GetVoiceConnectorOriginationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorOriginationInput`](crate::input::GetVoiceConnectorOriginationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorOriginationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorOriginationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorOriginationInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorOrigination;
#[doc(hidden)]
pub type GetVoiceConnectorOriginationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorOriginationInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorOrigination`](crate::operation::GetVoiceConnectorOrigination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorOrigination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorOriginationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_151 = &_input.voice_connector_id;
            let input_151 =
                input_151
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_151, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/origination",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorOriginationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorOriginationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorOrigination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorOrigination",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorOriginationInput`](crate::input::GetVoiceConnectorOriginationInput)
    pub fn builder() -> crate::input::get_voice_connector_origination_input::Builder {
        crate::input::get_voice_connector_origination_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorProxyInput`](crate::input::GetVoiceConnectorProxyInput)
pub mod get_voice_connector_proxy_input {
    /// A builder for [`GetVoiceConnectorProxyInput`](crate::input::GetVoiceConnectorProxyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorProxyInput`](crate::input::GetVoiceConnectorProxyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorProxyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorProxyInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorProxyInputOperationOutputAlias = crate::operation::GetVoiceConnectorProxy;
#[doc(hidden)]
pub type GetVoiceConnectorProxyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorProxyInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorProxy`](crate::operation::GetVoiceConnectorProxy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorProxy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorProxyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_152 = &_input.voice_connector_id;
            let input_152 =
                input_152
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_152, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorProxyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorProxyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorProxy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorProxy",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorProxyInput`](crate::input::GetVoiceConnectorProxyInput)
    pub fn builder() -> crate::input::get_voice_connector_proxy_input::Builder {
        crate::input::get_voice_connector_proxy_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorStreamingConfigurationInput`](crate::input::GetVoiceConnectorStreamingConfigurationInput)
pub mod get_voice_connector_streaming_configuration_input {
    /// A builder for [`GetVoiceConnectorStreamingConfigurationInput`](crate::input::GetVoiceConnectorStreamingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorStreamingConfigurationInput`](crate::input::GetVoiceConnectorStreamingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorStreamingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorStreamingConfigurationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorStreamingConfigurationInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorStreamingConfiguration;
#[doc(hidden)]
pub type GetVoiceConnectorStreamingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorStreamingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorStreamingConfiguration`](crate::operation::GetVoiceConnectorStreamingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorStreamingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorStreamingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_153 = &_input.voice_connector_id;
            let input_153 =
                input_153
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_153, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/streaming-configuration",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorStreamingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorStreamingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorStreamingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorStreamingConfiguration",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorStreamingConfigurationInput`](crate::input::GetVoiceConnectorStreamingConfigurationInput)
    pub fn builder() -> crate::input::get_voice_connector_streaming_configuration_input::Builder {
        crate::input::get_voice_connector_streaming_configuration_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorTerminationInput`](crate::input::GetVoiceConnectorTerminationInput)
pub mod get_voice_connector_termination_input {
    /// A builder for [`GetVoiceConnectorTerminationInput`](crate::input::GetVoiceConnectorTerminationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorTerminationInput`](crate::input::GetVoiceConnectorTerminationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorTerminationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorTerminationInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorTerminationInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorTermination;
#[doc(hidden)]
pub type GetVoiceConnectorTerminationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorTerminationInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorTermination`](crate::operation::GetVoiceConnectorTermination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorTermination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorTerminationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_154 = &_input.voice_connector_id;
            let input_154 =
                input_154
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_154, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/termination",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorTerminationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorTerminationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorTermination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorTermination",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorTerminationInput`](crate::input::GetVoiceConnectorTerminationInput)
    pub fn builder() -> crate::input::get_voice_connector_termination_input::Builder {
        crate::input::get_voice_connector_termination_input::Builder::default()
    }
}

/// See [`GetVoiceConnectorTerminationHealthInput`](crate::input::GetVoiceConnectorTerminationHealthInput)
pub mod get_voice_connector_termination_health_input {
    /// A builder for [`GetVoiceConnectorTerminationHealthInput`](crate::input::GetVoiceConnectorTerminationHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceConnectorTerminationHealthInput`](crate::input::GetVoiceConnectorTerminationHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceConnectorTerminationHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceConnectorTerminationHealthInput {
                voice_connector_id: self.voice_connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceConnectorTerminationHealthInputOperationOutputAlias =
    crate::operation::GetVoiceConnectorTerminationHealth;
#[doc(hidden)]
pub type GetVoiceConnectorTerminationHealthInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceConnectorTerminationHealthInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceConnectorTerminationHealth`](crate::operation::GetVoiceConnectorTerminationHealth)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceConnectorTerminationHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVoiceConnectorTerminationHealthInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_155 = &_input.voice_connector_id;
            let input_155 =
                input_155
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "voice_connector_id",
                        details: "cannot be empty or unset",
                    })?;
            let voice_connector_id = aws_smithy_http::label::fmt_string(input_155, false);
            if voice_connector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "voice_connector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/voice-connectors/{VoiceConnectorId}/termination/health",
                VoiceConnectorId = voice_connector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVoiceConnectorTerminationHealthInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVoiceConnectorTerminationHealthInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceConnectorTerminationHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceConnectorTerminationHealth",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorTerminationHealthInput`](crate::input::GetVoiceConnectorTerminationHealthInput)
    pub fn builder() -> crate::input::get_voice_connector_termination_health_input::Builder {
        crate::input::get_voice_connector_termination_health_input::Builder::default()
    }
}

/// See [`InviteUsersInput`](crate::input::InviteUsersInput)
pub mod invite_users_input {
    /// A builder for [`InviteUsersInput`](crate::input::InviteUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) user_email_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_type: std::option::Option<crate::model::UserType>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `user_email_list`.
        ///
        /// To override the contents of this collection use [`set_user_email_list`](Self::set_user_email_list).
        ///
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn user_email_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_email_list.unwrap_or_default();
            v.push(input.into());
            self.user_email_list = Some(v);
            self
        }
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn set_user_email_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_email_list = input;
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.user_type = Some(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteUsersInput`](crate::input::InviteUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InviteUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InviteUsersInput {
                account_id: self.account_id,
                user_email_list: self.user_email_list,
                user_type: self.user_type,
            })
        }
    }
}
#[doc(hidden)]
pub type InviteUsersInputOperationOutputAlias = crate::operation::InviteUsers;
#[doc(hidden)]
pub type InviteUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InviteUsersInput {
    /// Consumes the builder and constructs an Operation<[`InviteUsers`](crate::operation::InviteUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InviteUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InviteUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_156 = &_input.account_id;
            let input_156 =
                input_156
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_156, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AccountId}/users",
                AccountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::InviteUsersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "add");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InviteUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InviteUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_invite_users(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InviteUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InviteUsers",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InviteUsersInput`](crate::input::InviteUsersInput)
    pub fn builder() -> crate::input::invite_users_input::Builder {
        crate::input::invite_users_input::Builder::default()
    }
}

/// See [`ListAccountsInput`](crate::input::ListAccountsInput)
pub mod list_accounts_input {
    /// A builder for [`ListAccountsInput`](crate::input::ListAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) user_email: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn user_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_email = Some(input.into());
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn set_user_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_email = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsInput`](crate::input::ListAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountsInput {
                name: self.name,
                user_email: self.user_email,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountsInputOperationOutputAlias = crate::operation::ListAccounts;
#[doc(hidden)]
pub type ListAccountsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccounts`](crate::operation::ListAccounts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAccountsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_157) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_157));
            }
            if let Some(inner_158) = &_input.user_email {
                query.push_kv(
                    "user-email",
                    &aws_smithy_http::query::fmt_string(&inner_158),
                );
            }
            if let Some(inner_159) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_159),
                );
            }
            if let Some(inner_160) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_160).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccounts",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccountsInput`](crate::input::ListAccountsInput)
    pub fn builder() -> crate::input::list_accounts_input::Builder {
        crate::input::list_accounts_input::Builder::default()
    }
}

/// See [`ListAppInstanceAdminsInput`](crate::input::ListAppInstanceAdminsInput)
pub mod list_app_instance_admins_input {
    /// A builder for [`ListAppInstanceAdminsInput`](crate::input::ListAppInstanceAdminsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstanceAdminsInput`](crate::input::ListAppInstanceAdminsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppInstanceAdminsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppInstanceAdminsInput {
                app_instance_arn: self.app_instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppInstanceAdminsInputOperationOutputAlias = crate::operation::ListAppInstanceAdmins;
#[doc(hidden)]
pub type ListAppInstanceAdminsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppInstanceAdminsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppInstanceAdmins`](crate::operation::ListAppInstanceAdmins)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppInstanceAdmins,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppInstanceAdminsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_161 = &_input.app_instance_arn;
            let input_161 =
                input_161
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_instance_arn",
                        details: "cannot be empty or unset",
                    })?;
            let app_instance_arn = aws_smithy_http::label::fmt_string(input_161, false);
            if app_instance_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_instance_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/app-instances/{AppInstanceArn}/admins",
                AppInstanceArn = app_instance_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAppInstanceAdminsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_162) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_162).encode(),
                );
            }
            if let Some(inner_163) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_163),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppInstanceAdminsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppInstanceAdminsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppInstanceAdmins::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppInstanceAdmins",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppInstanceAdminsInput`](crate::input::ListAppInstanceAdminsInput)
    pub fn builder() -> crate::input::list_app_instance_admins_input::Builder {
        crate::input::list_app_instance_admins_input::Builder::default()
    }
}

/// See [`ListAppInstancesInput`](crate::input::ListAppInstancesInput)
pub mod list_app_instances_input {
    /// A builder for [`ListAppInstancesInput`](crate::input::ListAppInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstancesInput`](crate::input::ListAppInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppInstancesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppInstancesInputOperationOutputAlias = crate::operation::ListAppInstances;
#[doc(hidden)]
pub type ListAppInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListAppInstances`](crate::operation::ListAppInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/app-instances").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAppInstancesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_164) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_164).encode(),
                );
            }
            if let Some(inner_165) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_165),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppInstances",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppInstancesInput`](crate::input::ListAppInstancesInput)
    pub fn builder() -> crate::input::list_app_instances_input::Builder {
        crate::input::list_app_instances_input::Builder::default()
    }
}

/// See [`ListAppInstanceUsersInput`](crate::input::ListAppInstanceUsersInput)
pub mod list_app_instance_users_input {
    /// A builder for [`ListAppInstanceUsersInput`](crate::input::ListAppInstanceUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppInstanceUsersInput`](crate::input::ListAppInstanceUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppInstanceUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppInstanceUsersInput {
                app_instance_arn: self.app_instance_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppInstanceUsersInputOperationOutputAlias = crate::operation::ListAppInstanceUsers;
#[doc(hidden)]
pub type ListAppInstanceUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppInstanceUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListAppInstanceUsers`](crate::operation::ListAppInstanceUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppInstanceUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppInstanceUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/app-instance-users").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAppInstanceUsersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_166) = &_input.app_instance_arn {
                query.push_kv(
                    "app-instance-arn",
                    &aws_smithy_http::query::fmt_string(&inner_166),
                );
            }
            if let Some(inner_167) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_167).encode(),
                );
            }
            if let Some(inner_168) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_168),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppInstanceUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppInstanceUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("identity-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppInstanceUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppInstanceUsers",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppInstanceUsersInput`](crate::input::ListAppInstanceUsersInput)
    pub fn builder() -> crate::input::list_app_instance_users_input::Builder {
        crate::input::list_app_instance_users_input::Builder::default()
    }
}

/// See [`ListAttendeesInput`](crate::input::ListAttendeesInput)
pub mod list_attendees_input {
    /// A builder for [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttendeesInput`](crate::input::ListAttendeesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttendeesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttendeesInput {
                meeting_id: self.meeting_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttendeesInputOperationOutputAlias = crate::operation::ListAttendees;
#[doc(hidden)]
pub type ListAttendeesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAttendeesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttendees`](crate::operation::ListAttendees)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttendees,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttendeesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_169 = &_input.meeting_id;
            let input_169 =
                input_169
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_169, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees",
                MeetingId = meeting_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAttendeesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_170) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_170),
                );
            }
            if let Some(inner_171) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_171).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttendeesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttendeesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttendees::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttendees",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    pub fn builder() -> crate::input::list_attendees_input::Builder {
        crate::input::list_attendees_input::Builder::default()
    }
}

/// See [`ListAttendeeTagsInput`](crate::input::ListAttendeeTagsInput)
pub mod list_attendee_tags_input {
    /// A builder for [`ListAttendeeTagsInput`](crate::input::ListAttendeeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttendeeTagsInput`](crate::input::ListAttendeeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttendeeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttendeeTagsInput {
                meeting_id: self.meeting_id,
                attendee_id: self.attendee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttendeeTagsInputOperationOutputAlias = crate::operation::ListAttendeeTags;
#[doc(hidden)]
pub type ListAttendeeTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAttendeeTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListAttendeeTags`](crate::operation::ListAttendeeTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttendeeTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttendeeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_172 = &_input.meeting_id;
            let input_172 =
                input_172
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "meeting_id",
                        details: "cannot be empty or unset",
                    })?;
            let meeting_id = aws_smithy_http::label::fmt_string(input_172, false);
            if meeting_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "meeting_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_173 = &_input.attendee_id;
            let input_173 =
                input_173
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attendee_id",
                        details: "cannot be empty or unset",
                    })?;
            let attendee_id = aws_smithy_http::label::fmt_string(input_173, false);
            if attendee_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "attendee_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/meetings/{MeetingId}/attendees/{AttendeeId}/tags",
                MeetingId = meeting_id,
                AttendeeId = attendee_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttendeeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttendeeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttendeeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttendeeTags",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttendeeTagsInput`](crate::input::ListAttendeeTagsInput)
    pub fn builder() -> crate::input::list_attendee_tags_input::Builder {
        crate::input::list_attendee_tags_input::Builder::default()
    }
}

/// See [`ListBotsInput`](crate::input::ListBotsInput)
pub mod list_bots_input {
    /// A builder for [`ListBotsInput`](crate::input::ListBotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotsInput`](crate::input::ListBotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListBotsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListBotsInput {
                account_id: self.account_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotsInputOperationOutputAlias = crate::operation::ListBots;
#[doc(hidden)]
pub type ListBotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotsInput {
    /// Consumes the builder and constructs an Operation<[`ListBots`](crate::operation::ListBots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_174 = &_input.account_id;
            let input_174 =
                input_174
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_174, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AccountId}/bots", AccountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBotsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_175) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_175).encode(),
                );
            }
            if let Some(inner_176) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_176),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListBots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListBots", "chime",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
}

/// See [`ListChannelBansInput`](crate::input::ListChannelBansInput)
pub mod list_channel_bans_input {
    /// A builder for [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelBansInput`](crate::input::ListChannelBansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelBansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelBansInput {
                channel_arn: self.channel_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelBansInputOperationOutputAlias = crate::operation::ListChannelBans;
#[doc(hidden)]
pub type ListChannelBansInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelBansInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelBans`](crate::operation::ListChannelBans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelBans,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelBansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_177 = &_input.channel_arn;
            let input_177 =
                input_177
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_177, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/bans",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelBansInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_178) = &_input.chime_bearer {
                let formatted_179 = AsRef::<str>::as_ref(inner_178);
                if !formatted_179.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_179;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelBansInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_180) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_180).encode(),
                );
            }
            if let Some(inner_181) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_181),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelBansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelBansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelBans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelBans",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    pub fn builder() -> crate::input::list_channel_bans_input::Builder {
        crate::input::list_channel_bans_input::Builder::default()
    }
}

/// See [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
pub mod list_channel_memberships_input {
    /// A builder for [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMembershipsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelMembershipsInput {
                channel_arn: self.channel_arn,
                r#type: self.r#type,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelMembershipsInputOperationOutputAlias = crate::operation::ListChannelMemberships;
#[doc(hidden)]
pub type ListChannelMembershipsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMembershipsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMemberships`](crate::operation::ListChannelMemberships)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMemberships,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMembershipsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_182 = &_input.channel_arn;
            let input_182 =
                input_182
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_182, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/memberships",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMembershipsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_183) = &_input.chime_bearer {
                let formatted_184 = AsRef::<str>::as_ref(inner_183);
                if !formatted_184.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_184;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMembershipsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_185) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_185));
            }
            if let Some(inner_186) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_186).encode(),
                );
            }
            if let Some(inner_187) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_187),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMembershipsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMembershipsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelMemberships::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelMemberships",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    pub fn builder() -> crate::input::list_channel_memberships_input::Builder {
        crate::input::list_channel_memberships_input::Builder::default()
    }
}

/// See [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
pub mod list_channel_memberships_for_app_instance_user_input {
    /// A builder for [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMembershipsForAppInstanceUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListChannelMembershipsForAppInstanceUserInput {
                    app_instance_user_arn: self.app_instance_user_arn,
                    max_results: self.max_results,
                    next_token: self.next_token,
                    chime_bearer: self.chime_bearer,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListChannelMembershipsForAppInstanceUserInputOperationOutputAlias =
    crate::operation::ListChannelMembershipsForAppInstanceUser;
#[doc(hidden)]
pub type ListChannelMembershipsForAppInstanceUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMembershipsForAppInstanceUserInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMembershipsForAppInstanceUser`](crate::operation::ListChannelMembershipsForAppInstanceUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMembershipsForAppInstanceUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/channels").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_188) = &_input.chime_bearer {
                let formatted_189 = AsRef::<str>::as_ref(inner_188);
                if !formatted_189.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_189;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("scope", "app-instance-user-memberships");
            if let Some(inner_190) = &_input.app_instance_user_arn {
                query.push_kv(
                    "app-instance-user-arn",
                    &aws_smithy_http::query::fmt_string(&inner_190),
                );
            }
            if let Some(inner_191) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_191).encode(),
                );
            }
            if let Some(inner_192) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_192),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMembershipsForAppInstanceUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannelMembershipsForAppInstanceUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannelMembershipsForAppInstanceUser",
            "chime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channel_memberships_for_app_instance_user_input::Builder
    {
        crate::input::list_channel_memberships_for_app_instance_user_input::Builder::default()
    }
}

/// See [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
pub mod list_channel_messages_input {
    /// A builder for [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) chime_bearer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.chime_bearer = Some(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chime_bearer = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelMessagesInput {
                channel_arn: self.channel_arn,
                sort_order: self.sort_order,
                not_before: self.not_before,
                not_after: self.not_after,
                max_results: self.max_results,
                next_token: self.next_token,
                chime_bearer: self.chime_bearer,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelMessagesInputOperationOutputAlias = crate::operation::ListChannelMessages;
#[doc(hidden)]
pub type ListChannelMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelMessagesInput {
    /// Consumes the builder and constructs an Operation<[`ListChannelMessages`](crate::operation::ListChannelMessages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannelMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelMessagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_193 = &_input.channel_arn;
            let input_193 =
                input_193
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_arn",
                        details: "cannot be empty or unset",
                    })?;
            let channel_arn = aws_smithy_http::label::fmt_string(input_193, false);
            if channel_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/channels/{ChannelArn}/messages",
                ChannelArn = channel_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListChannelMessagesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_194) = &_input.chime_bearer {
                let formatted_195 = AsRef::<str>::as_ref(inner_194);
                if !formatted_195.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_195;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "chime_bearer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-chime-bearer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListChannelMessagesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_196) = &_input.sort_order {
                query.push_kv(
                    "sort-order",
                    &aws_smithy_http::query::fmt_string(&inner_196),
                );
            }
            if let Some(inner_197) = &_input.not_before {
                query.push_kv(
                    "not-before",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_197,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_198) = &_input.not_after {
                query.push_kv(
                    "not-after",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_198,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_199) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_199).encode(),
                );
            }
            if let Some(inner_200) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_200),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelMessagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelMessagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("messaging-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
